/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.logback;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ConfigurationSupport;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.intern.MessagePostprocessingErrorReporter;
import biz.paluch.logging.gelf.logback.LogbackLogEvent;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.Collections;

public class GelfLogbackAppender
extends AppenderBase<ILoggingEvent>
implements ErrorReporter {
    protected GelfSender gelfSender;
    protected MdcGelfMessageAssembler gelfMessageAssembler;
    private final ErrorReporter errorReporter = new MessagePostprocessingErrorReporter(this);

    public GelfLogbackAppender() {
        this.gelfMessageAssembler = new MdcGelfMessageAssembler();
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(LogMessageField.NamedLogField.Time, LogMessageField.NamedLogField.Severity, LogMessageField.NamedLogField.ThreadName, LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceLineNumber, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.LoggerName, LogMessageField.NamedLogField.Marker));
    }

    protected void append(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null);
                return;
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e);
        }
    }

    public void start() {
        if (null == this.gelfSender) {
            RuntimeContainer.initialize(this.errorReporter);
            this.gelfSender = this.createGelfSender();
        }
        super.start();
    }

    public void stop() {
        if (null != this.gelfSender) {
            Closer.close(this.gelfSender);
            this.gelfSender = null;
        }
        super.stop();
    }

    protected GelfSender createGelfSender() {
        return GelfSenderFactory.createSender(this.gelfMessageAssembler, this.errorReporter, Collections.emptyMap());
    }

    @Override
    public void reportError(String message, Exception exception) {
        this.addError(message, exception);
    }

    protected GelfMessage createGelfMessage(ILoggingEvent loggingEvent) {
        return this.gelfMessageAssembler.createGelfMessage(new LogbackLogEvent(loggingEvent));
    }

    public void setAdditionalFields(String spec) {
        ConfigurationSupport.setAdditionalFields(spec, this.gelfMessageAssembler);
    }

    public void setAdditionalFieldTypes(String spec) {
        ConfigurationSupport.setAdditionalFieldTypes(spec, this.gelfMessageAssembler);
    }

    public void setMdcFields(String spec) {
        ConfigurationSupport.setMdcFields(spec, this.gelfMessageAssembler);
    }

    public void setDynamicMdcFields(String spec) {
        ConfigurationSupport.setDynamicMdcFields(spec, this.gelfMessageAssembler);
    }

    public void setDynamicMdcFieldTypes(String spec) {
        ConfigurationSupport.setDynamicMdcFieldTypes(spec, this.gelfMessageAssembler);
    }

    public String getGraylogHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setGraylogHost(String graylogHost) {
        this.gelfMessageAssembler.setHost(graylogHost);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public int getGraylogPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setGraylogPort(int graylogPort) {
        this.gelfMessageAssembler.setPort(graylogPort);
    }

    public String getHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setHost(String host) {
        this.gelfMessageAssembler.setHost(host);
    }

    public int getPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setPort(int port) {
        this.gelfMessageAssembler.setPort(port);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public String getExtractStackTrace() {
        return this.gelfMessageAssembler.getExtractStackTrace();
    }

    public void setExtractStackTrace(String extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public boolean isIncludeLocation() {
        return this.gelfMessageAssembler.isIncludeLocation();
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.gelfMessageAssembler.setIncludeLocation(includeLocation);
    }

    public boolean isMdcProfiling() {
        return this.gelfMessageAssembler.isMdcProfiling();
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.gelfMessageAssembler.setMdcProfiling(mdcProfiling);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public int getMaximumMessageSize() {
        return this.gelfMessageAssembler.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.gelfMessageAssembler.setMaximumMessageSize(maximumMessageSize);
    }

    public boolean isIncludeFullMdc() {
        return this.gelfMessageAssembler.isIncludeFullMdc();
    }

    public void setIncludeFullMdc(boolean includeFullMdc) {
        this.gelfMessageAssembler.setIncludeFullMdc(includeFullMdc);
    }

    public String getVersion() {
        return this.gelfMessageAssembler.getVersion();
    }

    public void setVersion(String version) {
        this.gelfMessageAssembler.setVersion(version);
    }
}

