/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchQueryUtils {
    public static final Pattern queryPattern = Pattern.compile("\\s*(?:(?<name>[^\"][^: ]+|.)|\"(?<nameEsc>(?:\\\\.|[^\\\\\"])+)\"):(?:(?<value>[^\"][^ ]*)|\"(?<valueEsc>(?:\\\\.|[^\\\\\"])+)\")\\s*");
    public static final Pattern escapedCharsPattern = Pattern.compile("\\\\(.)");

    public static Map<String, String> getFields(String query) {
        Matcher matcher = queryPattern.matcher(query);
        HashMap<String, String> ret = new HashMap<String, String>();
        while (matcher.find()) {
            String value;
            String name = matcher.group("name");
            if (name == null) {
                name = SearchQueryUtils.unescape(matcher.group("nameEsc"));
            }
            if ((value = matcher.group("value")) == null) {
                value = SearchQueryUtils.unescape(matcher.group("valueEsc"));
            }
            ret.put(name, value);
        }
        return ret;
    }

    public static String unescape(String escaped) {
        return escapedCharsPattern.matcher(escaped).replaceAll("$1");
    }
}

