/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.locale.LocaleUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.storage.ReadOnlyException;

public class DefaultLocaleUpdaterProvider
implements LocaleUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LocaleSelectorProvider.class);
    private KeycloakSession session;

    public DefaultLocaleUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    public void updateUsersLocale(UserModel user, String locale) {
        if (!locale.equals(user.getFirstAttribute("locale"))) {
            try {
                user.setSingleAttribute("locale", locale);
                this.updateLocaleCookie(locale);
            }
            catch (ReadOnlyException e) {
                logger.debug((Object)"Attempt to store 'locale' attribute to read only user model. Ignoring exception", (Throwable)e);
            }
        }
        logger.debugv("Setting locale for user {0} to {1}", (Object)user.getUsername(), (Object)locale);
    }

    public void updateLocaleCookie(String locale) {
        RealmModel realm = this.session.getContext().getRealm();
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        boolean secure = realm.getSslRequired().isRequired(uriInfo.getRequestUri().getHost());
        CookieHelper.addCookie("KEYCLOAK_LOCALE", locale, AuthenticationManager.getRealmCookiePath(realm, (UriInfo)uriInfo), null, null, -1, secure, true, this.session);
        logger.debugv("Updating locale cookie to {0}", (Object)locale);
    }

    public void expireLocaleCookie() {
        RealmModel realm = this.session.getContext().getRealm();
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        boolean secure = realm.getSslRequired().isRequired(this.session.getContext().getConnection());
        CookieHelper.addCookie("KEYCLOAK_LOCALE", "", AuthenticationManager.getRealmCookiePath(realm, (UriInfo)uriInfo), null, "Expiring cookie", 0, secure, true, this.session);
    }

    public void close() {
    }
}

