/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderFactory;

public class ExportImportManager {
    private static final Logger logger = Logger.getLogger(ExportImportManager.class);
    private final KeycloakSessionFactory sessionFactory;
    private final KeycloakSession session;
    private ExportProvider exportProvider;
    private ImportProvider importProvider;

    public ExportImportManager(KeycloakSession session) {
        this.sessionFactory = session.getKeycloakSessionFactory();
        this.session = session;
        String exportImportAction = ExportImportConfig.getAction();
        if ("export".equals(exportImportAction)) {
            String providerId = System.getProperty("keycloak.migration.provider", Config.scope((String[])new String[]{"export"}).get("exporter", "dir"));
            this.exportProvider = (ExportProvider)session.getProvider(ExportProvider.class, providerId);
            if (this.exportProvider == null) {
                throw new RuntimeException("Export provider '" + providerId + "' not found");
            }
        } else if ("import".equals(exportImportAction)) {
            String providerId = System.getProperty("keycloak.migration.provider", Config.scope((String[])new String[]{"import"}).get("importer", "dir"));
            this.importProvider = (ImportProvider)session.getProvider(ImportProvider.class, providerId);
            if (this.importProvider == null) {
                throw new RuntimeException("Import provider '" + providerId + "' not found");
            }
        }
    }

    public boolean isRunImport() {
        return this.importProvider != null;
    }

    public boolean isImportMasterIncluded() {
        if (!this.isRunImport()) {
            throw new IllegalStateException("Import not enabled");
        }
        try {
            return this.importProvider.isMasterRealmExported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunExport() {
        return this.exportProvider != null;
    }

    public void runImport() {
        try {
            this.importProvider.importModel();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run import", e);
        }
    }

    public void runImportAtStartup(String dir) throws IOException {
        ExportImportConfig.setReplacePlaceholders(true);
        ExportImportConfig.setAction("import");
        Stream factories = this.sessionFactory.getProviderFactoriesStream(ImportProvider.class);
        for (ProviderFactory factory : factories.collect(Collectors.toList())) {
            final String providerId = factory.getId();
            if ("dir".equals(providerId)) {
                ExportImportConfig.setDir(dir);
                ImportProvider importProvider = (ImportProvider)this.session.getProvider(ImportProvider.class, providerId);
                importProvider.importModel();
                continue;
            }
            if (!"singleFile".equals(providerId)) continue;
            HashSet<String> filesToImport = new HashSet<String>();
            File[] files = Paths.get(dir, new String[0]).toFile().listFiles();
            Objects.requireNonNull(files, "directory not found");
            for (File file : files) {
                Path filePath = file.toPath();
                if (!(Files.exists(filePath, new LinkOption[0]) && Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().endsWith(".json"))) {
                    logger.debugf("Ignoring import file because it is not a valid file: %s", (Object)file);
                    continue;
                }
                String fileName = file.getName();
                if (fileName.contains("-realm.json") || fileName.contains("-users-")) continue;
                filesToImport.add(file.getAbsolutePath());
            }
            for (String file : filesToImport) {
                ExportImportConfig.setFile(file);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                    public void run(KeycloakSession session) {
                        ImportProvider importProvider = (ImportProvider)session.getProvider(ImportProvider.class, providerId);
                        try {
                            importProvider.importModel();
                        }
                        catch (IOException cause) {
                            throw new RuntimeException(cause);
                        }
                    }
                });
            }
        }
    }

    public void runExport() {
        try {
            this.exportProvider.exportModel();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run export", e);
        }
    }
}

