/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jitsi.srtp.crypto.SrtpCipher;

public class SrtpCipherGcm
extends SrtpCipher {
    private static final int AUTH_TAG_BITS = 128;
    private SecretKeySpec key = null;

    public SrtpCipherGcm(Cipher cipher) {
        super(cipher);
    }

    @Override
    public void init(byte[] key, byte[] saltKey) {
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("Invalid key length");
        }
        this.key = this.getSecretKey(key);
    }

    @Override
    public void setIV(byte[] iv, int opmode) throws GeneralSecurityException {
        this.cipher.init(opmode, (Key)this.key, new GCMParameterSpec(128, iv));
    }

    @Override
    public void processAAD(byte[] data2, int off, int len) {
        this.cipher.updateAAD(data2, off, len);
    }

    @Override
    public int process(byte[] data2, int off, int len) throws GeneralSecurityException {
        return this.cipher.doFinal(data2, off, len, data2, off);
    }
}

