/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.outgoing.OutgoingSsrcStats;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.rtp.rtp.RtpPacket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "()V", "numAudioPackets", "", "numVideoPackets", "ssrcStats", "", "", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "getSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getSsrcSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats$Snapshot;", "ssrc", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class OutgoingStatisticsTracker
extends ObserverNode {
    @NotNull
    private final Map<Long, OutgoingSsrcStats> ssrcStats = new ConcurrentHashMap();
    private int numAudioPackets;
    private int numVideoPackets;

    public OutgoingStatisticsTracker() {
        super("Outgoing statistics tracker");
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        RtpPacket rtpPacket;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket rtpPacket2 = rtpPacket = (RtpPacket)packetInfo.packetAs();
        if (rtpPacket2 instanceof AudioRtpPacket) {
            int n = this.numAudioPackets;
            this.numAudioPackets = n + 1;
        } else if (rtpPacket2 instanceof VideoRtpPacket) {
            int n = this.numVideoPackets;
            this.numVideoPackets = n + 1;
        }
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> OutgoingStatisticsTracker.observe$lambda-0(rtpPacket, arg_0));
        Intrinsics.checkNotNullExpressionValue(outgoingSsrcStats, "ssrcStats.computeIfAbsen\u2026rtpPacket.ssrc)\n        }");
        OutgoingSsrcStats stats = outgoingSsrcStats;
        stats.packetSent(rtpPacket.length, rtpPacket.getTimestamp());
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        OutgoingStatisticsSnapshot stats = this.getSnapshot();
        Map<Long, OutgoingSsrcStats.Snapshot> $this$forEach$iv = stats.getSsrcStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, OutgoingSsrcStats.Snapshot>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> element$iv;
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats.Snapshot streamStats = entry.getValue();
            $this$getNodeStats_u24lambda_u2d2.addJson(String.valueOf(ssrc2), streamStats.toJson());
        }
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStatsToAggregate_u24lambda_u2d3 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStatsToAggregate_u24lambda_u2d3.addNumber("num_audio_packets", this.numAudioPackets);
        $this$getNodeStatsToAggregate_u24lambda_u2d3.addNumber("num_video_packets", this.numVideoPackets);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OutgoingStatisticsSnapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        Map<Long, OutgoingSsrcStats> $this$map$iv = this.ssrcStats;
        boolean $i$f$map = false;
        Map<Long, OutgoingSsrcStats> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats stats = (OutgoingSsrcStats)entry.getValue();
            collection.add(new Pair<Long, OutgoingSsrcStats.Snapshot>(ssrc2, stats.getSnapshot()));
        }
        Map<Long, OutgoingSsrcStats.Snapshot> map2 = MapsKt.toMap((List)destination$iv$iv);
        return new OutgoingStatisticsSnapshot(map2);
    }

    @Nullable
    public final OutgoingSsrcStats.Snapshot getSsrcSnapshot(long ssrc2) {
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.get(ssrc2);
        return outgoingSsrcStats != null ? outgoingSsrcStats.getSnapshot() : null;
    }

    private static final OutgoingSsrcStats observe$lambda-0(RtpPacket $rtpPacket, Long it) {
        Intrinsics.checkNotNullParameter($rtpPacket, "$rtpPacket");
        Intrinsics.checkNotNullParameter(it, "it");
        return new OutgoingSsrcStats($rtpPacket.getSsrc());
    }
}

