/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.transform.node.incoming.BitrateCalculator;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoBitrateCalculator;", "Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "activePacketRateThreshold", "", "(Lorg/jitsi/utils/logging2/Logger;I)V", "logger", "mediaSourceDescs", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class VideoBitrateCalculator
extends BitrateCalculator {
    @NotNull
    private final Logger logger;
    @NotNull
    private MediaSourceDesc[] mediaSourceDescs;

    public VideoBitrateCalculator(@NotNull Logger parentLogger, int activePacketRateThreshold) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Video bitrate calculator", activePacketRateThreshold, null, 4, null);
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.mediaSourceDescs = new MediaSourceDesc[0];
    }

    public /* synthetic */ VideoBitrateCalculator(Logger logger, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(logger, n);
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block1: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            super.observe(packetInfo);
            VideoRtpPacket videoRtpPacket = (VideoRtpPacket)packetInfo.getPacket();
            RtpLayerDesc rtpLayerDesc = MediaSourceDescKt.findRtpLayerDesc(this.mediaSourceDescs, videoRtpPacket);
            if (rtpLayerDesc == null) break block1;
            RtpLayerDesc it = rtpLayerDesc;
            boolean bl = false;
            long now = this.getClock().millis();
            if (it.updateBitrate(DataSizeKt.getBytes(videoRtpPacket.length), now)) {
                packetInfo.setLayeringChanged(true);
            }
        }
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetMediaSourcesEvent) {
            MediaSourceDesc[] mediaSourceDescArray = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
            MediaSourceDesc[] mediaSourceDescArray2 = Arrays.copyOf(mediaSourceDescArray, mediaSourceDescArray.length);
            Intrinsics.checkNotNullExpressionValue(mediaSourceDescArray2, "copyOf(this, size)");
            this.mediaSourceDescs = mediaSourceDescArray2;
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Video bitrate calculator got media sources:\n" + ArraysKt.joinToString$default(this.mediaSourceDescs, null, null, null, 0, null, null, 63, null));
            }
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

