/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats;

import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.ParsingFormatBase;
import org.jboss.galleon.util.formatparser.formats.WildcardParsingFormat;

public class KeyValueParsingFormat
extends ParsingFormatBase {
    public static final String NAME = "KeyValue";
    public static final char SEPARATOR = '=';
    private final ParsingFormat keyFormat;
    private final char separator;
    private final ParsingFormat valueFormat;

    public static KeyValueParsingFormat getInstance() {
        WildcardParsingFormat wildcard = WildcardParsingFormat.getInstance();
        return new KeyValueParsingFormat(wildcard, '=', wildcard);
    }

    public static KeyValueParsingFormat newInstance(ParsingFormat keyFormat, ParsingFormat valueFormat) {
        return KeyValueParsingFormat.newInstance(keyFormat, '=', valueFormat);
    }

    public static KeyValueParsingFormat newInstance(ParsingFormat keyFormat, char separator, ParsingFormat valueFormat) {
        return new KeyValueParsingFormat(keyFormat, separator, valueFormat);
    }

    protected KeyValueParsingFormat(ParsingFormat keyFormat, char separator, ParsingFormat valueFormat) {
        super(NAME);
        this.keyFormat = keyFormat;
        this.separator = separator;
        this.valueFormat = valueFormat;
    }

    public ParsingFormat getKeyFormat() {
        return this.keyFormat;
    }

    public char getSeparator() {
        return this.separator;
    }

    public ParsingFormat getValueFormat() {
        return this.valueFormat;
    }

    @Override
    public boolean isOpeningChar(char ch) {
        return this.keyFormat.isOpeningChar(ch);
    }

    @Override
    public void react(ParsingContext ctx) throws FormatParsingException {
        if (ctx.charNow() == this.separator) {
            ctx.popFormats();
        }
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
        ctx.pushFormat(this.keyFormat);
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        if (Character.isWhitespace(ctx.charNow())) {
            return;
        }
        ctx.pushFormat(this.valueFormat);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.separator;
        result = 31 * result + (this.valueFormat == null ? 0 : this.valueFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValueParsingFormat other = (KeyValueParsingFormat)obj;
        if (this.separator != other.separator) {
            return false;
        }
        return !(this.valueFormat == null ? other.valueFormat != null : !this.valueFormat.equals(other.valueFormat));
    }
}

