/*	$NetBSD: conf.c,v 1.2 2012/01/18 23:12:21 nonaka Exp $	*/

/*
 * Copyright (c) 2009 NONAKA Kimihiro <nonaka@netbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "boot.h"
#include "unixdev.h"

#include <lib/libsa/ufs.h>
#include <lib/libsa/ext2fs.h>
#include "pathfs.h"

char devname_hd[] = "hd";
char devname_mmcd[] = "mmcd";
char devname_path[] = "path";

struct devsw devsw[] = {
    { devname_hd, unixstrategy, unixopen, unixclose, unixioctl },
    { devname_mmcd, unixstrategy, unixopen, unixclose, unixioctl },
    { devname_path, unixstrategy, unixpathopen, unixclose, unixioctl },
};
int ndevs = __arraycount(devsw);

struct fs_ops file_system[] = {
    FS_OPS(ffsv1),
    FS_OPS(ffsv2),
    FS_OPS(ext2fs),
    FS_OPS(pathfs),
};
int nfsys = __arraycount(file_system);
