/*	$NetBSD: sdhcreg.h,v 1.19 2017/06/23 08:43:59 ryo Exp $	*/
/*	$OpenBSD: sdhcreg.h,v 1.4 2006/07/30 17:20:40 fgsch Exp $	*/

/*
 * Copyright (c) 2006 Uwe Stuehler <uwe@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _SDHCREG_H_
#define _SDHCREG_H_

/* Host standard register set */
#define SDHC_DMA_ADDR			0x00
#define SDHC_BLOCK_SIZE			0x04
#define  SDHC_DMA_BOUNDARY_SHIFT	12
#define  SDHC_DMA_BOUNDARY_MASK		0x7
#define SDHC_BLOCK_COUNT		0x06
#define  SDHC_BLOCK_COUNT_MAX		512
#define SDHC_ARGUMENT			0x08
#define SDHC_TRANSFER_MODE		0x0c
#define  SDHC_MULTI_BLOCK_MODE		(1<<5)
#define  SDHC_READ_MODE			(1<<4)
#define  SDHC_AUTO_CMD12_ENABLE		(1<<2)
#define  SDHC_BLOCK_COUNT_ENABLE	(1<<1)
#define  SDHC_DMA_ENABLE		(1<<0)
#define SDHC_COMMAND			0x0e
/* 14-15 reserved */
#define  SDHC_COMMAND_INDEX_SHIFT	8
#define  SDHC_COMMAND_INDEX_MASK	0x3f
#define  SDHC_COMMAND_TYPE_ABORT	(3<<6)
#define  SDHC_COMMAND_TYPE_RESUME	(2<<6)
#define  SDHC_COMMAND_TYPE_SUSPEND	(1<<6)
#define  SDHC_COMMAND_TYPE_NORMAL	(0<<6)
#define  SDHC_DATA_PRESENT_SELECT	(1<<5)
#define  SDHC_INDEX_CHECK_ENABLE	(1<<4)
#define  SDHC_CRC_CHECK_ENABLE		(1<<3)
/* 2 reserved */
#define  SDHC_RESP_LEN_48_CHK_BUSY	(3<<0)
#define  SDHC_RESP_LEN_48		(2<<0)
#define  SDHC_RESP_LEN_136		(1<<0)
#define  SDHC_NO_RESPONSE		(0<<0)
#define SDHC_RESPONSE			0x10	/* - 0x1f */
#define SDHC_DATA			0x20
#define SDHC_PRESENT_STATE		0x24
/* 25-31 reserved */
#define  SDHC_CMD_LINE_SIGNAL_LEVEL	(1<<24)
#define  SDHC_DAT3_LINE_LEVEL		(1<<23)
#define  SDHC_DAT2_LINE_LEVEL		(1<<22)
#define  SDHC_DAT1_LINE_LEVEL		(1<<21)
#define  SDHC_DAT0_LINE_LEVEL		(1<<20)
#define  SDHC_WRITE_PROTECT_SWITCH	(1<<19)
#define  SDHC_CARD_DETECT_PIN_LEVEL	(1<<18)
#define  SDHC_CARD_STATE_STABLE		(1<<17)
#define  SDHC_CARD_INSERTED		(1<<16)
/* 12-15 reserved */
#define  SDHC_BUFFER_READ_ENABLE	(1<<11)
#define  SDHC_BUFFER_WRITE_ENABLE	(1<<10)
#define  SDHC_READ_TRANSFER_ACTIVE	(1<<9)
#define  SDHC_WRITE_TRANSFER_ACTIVE	(1<<8)
/* 4-7 reserved */
#define  SDHC_SDSTB			(1<<3)	/* uSDHC */
#define  SDHC_DAT_ACTIVE		(1<<2)
#define  SDHC_CMD_INHIBIT_DAT		(1<<1)
#define  SDHC_CMD_INHIBIT_CMD		(1<<0)
#define  SDHC_CMD_INHIBIT_MASK		0x0003
#define SDHC_HOST_CTL			0x28
#define  SDHC_USDHC_BURST_LEN_EN	(1<<27)	/* uSDHC */
#define  SDHC_USDHC_HOST_CTL_RESV23	(1<<23)	/* uSDHC */
#define  SDHC_USDHC_DMA_SELECT		(3<<8)	/* uSDHC */
#define  SDHC_USDHC_DMA_SELECT_ADMA1	(1<<8)	/* uSDHC */
#define  SDHC_USDHC_DMA_SELECT_ADMA2	(2<<8)	/* uSDHC */
#define  SDHC_USDHC_EMODE		(3<<4)	/* uSDHC */
#define  SDHC_USDHC_EMODE_LE		(2<<4)	/* uSDHC */
#define  SDHC_8BIT_MODE			(1<<5)
#define  SDHC_DMA_SELECT		(3<<3)
#define  SDHC_DMA_SELECT_SDMA		(0<<3)
#define  SDHC_DMA_SELECT_ADMA2		(2<<3)
#define  SDHC_HIGH_SPEED		(1<<2)
#define  SDHC_ESDHC_8BIT_MODE		(1<<2)	/* eSDHC */
#define  SDHC_4BIT_MODE			(1<<1)
#define  SDHC_LED_ON			(1<<0)
#define SDHC_POWER_CTL			0x29
#define  SDHC_VOLTAGE_SHIFT		1
#define  SDHC_VOLTAGE_MASK		0x07
#define   SDHC_VOLTAGE_3_3V		0x07
#define   SDHC_VOLTAGE_3_0V		0x06
#define   SDHC_VOLTAGE_1_8V		0x05
#define  SDHC_BUS_POWER			(1<<0)
#define SDHC_BLOCK_GAP_CTL		0x2a
#define SDHC_WAKEUP_CTL			0x2b
#define SDHC_CLOCK_CTL			0x2c
#define  SDHC_SDCLK_DIV_SHIFT		8
#define  SDHC_SDCLK_DIV_MASK		0xff
#define  SDHC_SDCLK_XDIV_SHIFT		6
#define  SDHC_SDCLK_XDIV_MASK		0x3
#define  SDHC_SDCLK_CGM			(1<<5)
#define  SDHC_SDCLK_DVS_SHIFT		4
#define  SDHC_SDCLK_DVS_MASK		0xf
#define  SDHC_SDCLK_ENABLE		(1<<2)
#define  SDHC_INTCLK_STABLE		(1<<1)
#define  SDHC_INTCLK_ENABLE		(1<<0)
#define SDHC_TIMEOUT_CTL		0x2e
#define  SDHC_TIMEOUT_MAX		0x0e
#define SDHC_SOFTWARE_RESET		0x2f
#define  SDHC_INIT_ACTIVE		(1<<3)	/* ESDHC */
#define  SDHC_RESET_MASK		0x5
#define  SDHC_RESET_DAT			(1<<2)
#define  SDHC_RESET_CMD			(1<<1)
#define  SDHC_RESET_ALL			(1<<0)
#define SDHC_NINTR_STATUS		0x30
#define  SDHC_ERROR_INTERRUPT		(1<<15)
#define  SDHC_RETUNING_EVENT		(1<<12)
#define  SDHC_CARD_INTERRUPT		(1<<8)
#define  SDHC_CARD_REMOVAL		(1<<7)
#define  SDHC_CARD_INSERTION		(1<<6)
#define  SDHC_BUFFER_READ_READY		(1<<5)
#define  SDHC_BUFFER_WRITE_READY	(1<<4)
#define  SDHC_DMA_INTERRUPT		(1<<3)
#define  SDHC_BLOCK_GAP_EVENT		(1<<2)
#define  SDHC_TRANSFER_COMPLETE		(1<<1)
#define  SDHC_COMMAND_COMPLETE		(1<<0)
#define  SDHC_NINTR_STATUS_MASK		0x91ff
#define SDHC_EINTR_STATUS		0x32
#define  SDHC_DMA_ERROR			(1<<12)
#define  SDHC_ADMA_ERROR		(1<<9)
#define  SDHC_AUTO_CMD12_ERROR		(1<<8)
#define  SDHC_CURRENT_LIMIT_ERROR	(1<<7)
#define  SDHC_DATA_END_BIT_ERROR	(1<<6)
#define  SDHC_DATA_CRC_ERROR		(1<<5)
#define  SDHC_DATA_TIMEOUT_ERROR	(1<<4)
#define  SDHC_CMD_INDEX_ERROR		(1<<3)
#define  SDHC_CMD_END_BIT_ERROR		(1<<2)
#define  SDHC_CMD_CRC_ERROR		(1<<1)
#define  SDHC_CMD_TIMEOUT_ERROR		(1<<0)
#define  SDHC_EINTR_STATUS_MASK		0x03ff	/* excluding vendor signals */
#define SDHC_NINTR_STATUS_EN		0x34
#define SDHC_EINTR_STATUS_EN		0x36
#define SDHC_NINTR_SIGNAL_EN		0x38
#define  SDHC_NINTR_SIGNAL_MASK		0x01ff
#define SDHC_EINTR_SIGNAL_EN		0x3a
#define  SDHC_EINTR_SIGNAL_MASK		0x03ff	/* excluding vendor signals */
#define SDHC_CMD12_ERROR_STATUS		0x3c
#define SDHC_HOST_CTL2			0x3e
#define  SDHC_SAMPLING_CLOCK_SEL	(1<<7)
#define  SDHC_EXECUTE_TUNING		(1<<6)
#define  SDHC_1_8V_SIGNAL_EN		(1<<3)
#define  SDHC_UHS_MODE_SELECT_SHIFT	0
#define  SDHC_UHS_MODE_SELECT_MASK	0x7
#define  SDHC_UHS_MODE_SELECT_SDR12	0
#define  SDHC_UHS_MODE_SELECT_SDR25	1
#define  SDHC_UHS_MODE_SELECT_SDR50	2
#define  SDHC_UHS_MODE_SELECT_SDR104	3
#define  SDHC_UHS_MODE_SELECT_DDR50	4
#define SDHC_CAPABILITIES		0x40
#define  SDHC_SHARED_BUS_SLOT		(1<<31)
#define  SDHC_EMBEDDED_SLOT		(1<<30)
#define  SDHC_ASYNC_INTR		(1<<29)
#define  SDHC_64BIT_SYS_BUS		(1<<28)
#define  SDHC_VOLTAGE_SUPP_1_8V		(1<<26)
#define  SDHC_VOLTAGE_SUPP_3_0V		(1<<25)
#define  SDHC_VOLTAGE_SUPP_3_3V		(1<<24)
#define  SDHC_DMA_SUPPORT		(1<<22)
#define  SDHC_HIGH_SPEED_SUPP		(1<<21)
#define  SDHC_ADMA1_SUPP		(1<<20)
#define  SDHC_ADMA2_SUPP		(1<<19)
#define  SDHC_8BIT_SUPP			(1<<18)
#define  SDHC_MAX_BLK_LEN_512		0
#define  SDHC_MAX_BLK_LEN_1024		1
#define  SDHC_MAX_BLK_LEN_2048		2
#define  SDHC_MAX_BLK_LEN_4096		3
#define  SDHC_MAX_BLK_LEN_SHIFT		16
#define  SDHC_MAX_BLK_LEN_MASK		0x3
#define  SDHC_BASE_FREQ_SHIFT		8
#define  SDHC_BASE_FREQ_MASK		0x3f
#define  SDHC_BASE_V3_FREQ_MASK		0xff
#define  SDHC_TIMEOUT_FREQ_UNIT		(1<<7)	/* 0=KHz, 1=MHz */
#define  SDHC_TIMEOUT_FREQ_SHIFT	0
#define  SDHC_TIMEOUT_FREQ_MASK		0x1f
#define SDHC_CAPABILITIES2		0x44
#define  SDHC_SDR50_SUPP		(1<<0)
#define  SDHC_SDR104_SUPP		(1<<1)
#define  SDHC_DDR50_SUPP		(1<<2)
#define  SDHC_DRIVER_TYPE_A		(1<<4)
#define  SDHC_DRIVER_TYPE_C		(1<<5)
#define  SDHC_DRIVER_TYPE_D		(1<<6)
#define  SDHC_TIMER_COUNT_SHIFT		8
#define  SDHC_TIMER_COUNT_MASK		0xf
#define  SDHC_TUNING_SDR50		(1<<13)
#define  SDHC_RETUNING_MODES_SHIFT	14
#define  SDHC_RETUNING_MODES_MASK	0x3
#define  SDHC_RETUNING_MODE_1		(0 << SDHC_RETUNING_MODES_SHIFT)
#define  SDHC_RETUNING_MODE_2		(1 << SDHC_RETUNING_MODES_SHIFT)
#define  SDHC_RETUNING_MODE_3		(2 << SDHC_RETUNING_MODES_SHIFT)
#define  SDHC_CLOCK_MULTIPLIER_SHIFT	16
#define  SDHC_CLOCK_MULTIPLIER_MASK	0xff
#define SDHC_ADMA_ERROR_STATUS		0x54
#define  SDHC_ADMA_LENGTH_MISMATCH	(1<<2)
#define  SDHC_ADMA_ERROR_STATE		(3<<0)
#define SDHC_ADMA_SYSTEM_ADDR		0x58
#define SDHC_WATERMARK_LEVEL		0x44	/* ESDHC/uSDHC */
#define  SDHC_WATERMARK_WR_BRST_SHIFT	24	/* uSDHC */
#define  SDHC_WATERMARK_WR_BRST_MASK	0x1f	/* uSDHC */
#define  SDHC_WATERMARK_WRITE_SHIFT	16
#define  SDHC_WATERMARK_WRITE_MASK	0xff
#define  SDHC_WATERMARK_RD_BRST_SHIFT	8	/* uSDHC */
#define  SDHC_WATERMARK_RD_BRST_MASK	0x1f	/* uSDHC */
#define  SDHC_WATERMARK_READ_SHIFT	0
#define  SDHC_WATERMARK_READ_MASK	0xff
#define SDHC_MAX_CAPABILITIES		0x48
#define SDHC_SLOT_INTR_STATUS		0xfc
#define SDHC_ESDHC_HOST_CTL_VERSION	0xfc	/* eSDHC */
#define SDHC_HOST_CTL_VERSION		0xfe
#define  SDHC_SPEC_VERS_SHIFT		0
#define  SDHC_SPEC_VERS_MASK		0xff
#define  SDHC_VENDOR_VERS_SHIFT		8
#define  SDHC_VENDOR_VERS_MASK		0xff
#define SDHC_DMA_CTL			0x40c	/* eSDHC */
#define  SDHC_DMA_SNOOP			0x40
#define SDHC_MIX_CTRL			0x48	/* uSDHC */
#define  SDHC_USDHC_DDR_EN			(1<<3)
#define SDHC_VEND_SPEC			0xc0	/* uSDHC */
#define  SDHC_VEND_SPEC_MBO			(1<<29)
#define  SDHC_VEND_SPEC_CARD_CLK_SOFT_EN	(1<<14)
#define  SDHC_VEND_SPEC_IPG_PERCLK_SOFT_EN	(1<<13)
#define  SDHC_VEND_SPEC_HCLK_SOFT_EN		(1<<12)
#define  SDHC_VEND_SPEC_IPG_CLK_SOFT_EN		(1<<11)
#define  SDHC_VEND_SPEC_FRC_SDCLK_ON		(1<<8)
#define  SDHC_VEND_SPEC_AC12_WR_CHKBUSY_EN	(1<<3)
#define  SDHC_VEND_SPEC_VSELECT			(1<<1)
#define SDHC_MMC_BOOT			0xc4	/* uSDHC */
#define SDHC_VEND_SPEC2			0xc8	/* uSDHC */

/* SDHC_SPEC_VERS */
#define SDHC_SPEC_VERS_100		0x00
#define SDHC_SPEC_VERS_200		0x01
#define SDHC_SPEC_VERS_300		0x02
#define SDHC_SPEC_VERS_400		0x03
#define SDHC_SPEC_NOVERS		0xff	/* dummy */

/* SDHC_CAPABILITIES decoding */
#define SDHC_BASE_V3_FREQ_KHZ(cap)					\
	((((cap) >> SDHC_BASE_FREQ_SHIFT) & SDHC_BASE_V3_FREQ_MASK) * 1000)
#define SDHC_BASE_FREQ_KHZ(cap)						\
	((((cap) >> SDHC_BASE_FREQ_SHIFT) & SDHC_BASE_FREQ_MASK) * 1000)
#define SDHC_TIMEOUT_FREQ(cap)						\
	(((cap) >> SDHC_TIMEOUT_FREQ_SHIFT) & SDHC_TIMEOUT_FREQ_MASK)
#define SDHC_TIMEOUT_FREQ_KHZ(cap)					\
	(((cap) & SDHC_TIMEOUT_FREQ_UNIT) ?				\
	    SDHC_TIMEOUT_FREQ(cap) * 1000:				\
	    SDHC_TIMEOUT_FREQ(cap))

/* SDHC_HOST_CTL_VERSION decoding */
#define SDHC_SPEC_VERSION(hcv)						\
	(((hcv) >> SDHC_SPEC_VERS_SHIFT) & SDHC_SPEC_VERS_MASK)
#define SDHC_VENDOR_VERSION(hcv)					\
	(((hcv) >> SDHC_VENDOR_VERS_SHIFT) & SDHC_VENDOR_VERS_MASK)

#define SDHC_PRESENT_STATE_BITS						\
	"\20\31CL\30D3L\27D2L\26D1L\25D0L\24WPS\23CD\22CSS\21CI"	\
	"\14BRE\13BWE\12RTA\11WTA\3DLA\2CID\1CIC"
#define SDHC_NINTR_STATUS_BITS						\
	"\20\20ERROR\11CARD\10REMOVAL\7INSERTION\6READ\5WRITE"		\
	"\4DMA\3GAP\2XFER\1CMD"
#define SDHC_EINTR_STATUS_BITS						\
	"\20\11ACMD12\10CL\7DEB\6DCRC\5DT\4CI\3CEB\2CCRC\1CT"
#define SDHC_CAPABILITIES_BITS						\
	"\20\33Vdd1.8V\32Vdd3.0V\31Vdd3.3V\30SUSPEND\27DMA\26HIGHSPEED"

#define SDHC_ADMA2_VALID	(1<<0)
#define SDHC_ADMA2_END		(1<<1)
#define SDHC_ADMA2_INT		(1<<2)
#define SDHC_ADMA2_ACT		(3<<4)
#define SDHC_ADMA2_ACT_NOP	(0<<4)
#define SDHC_ADMA2_ACT_TRANS	(2<<4)
#define SDHC_ADMA2_ACT_LINK	(3<<4)

struct sdhc_adma2_descriptor32 {
	uint16_t	attribute;
	uint16_t	length;
	uint32_t	address;
} __packed;

struct sdhc_adma2_descriptor64 {
	uint16_t	attribute;
	uint16_t	length;
	uint32_t	address;
	uint32_t	address_hi;
} __packed;

#endif /* _SDHCREG_H_ */
