/* $NetBSD: svr4_32_syscallargs.h,v 1.27 2017/05/10 06:19:49 riastradh Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.20 2013/11/07 19:37:19 njoly Exp
 */

#ifndef _SVR4_32_SYS_SYSCALLARGS_H_
#define	_SVR4_32_SYS_SYSCALLARGS_H_

/* Forward declaration */
struct lwp;

#define	SVR4_32_SYS_MAXSYSARGS	8

#undef	syscallarg
#define	syscallarg(x)							\
	union {								\
		register32_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register32_t) < sizeof (x))	\
				? 0					\
				: sizeof (register32_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

#undef check_syscall_args
#define check_syscall_args(call) /*LINTED*/ \
	typedef char call##_check_args[sizeof (struct call##_args) \
		<= SVR4_32_SYS_MAXSYSARGS * sizeof (register32_t) ? 1 : -1];

struct netbsd32_exit_args;

struct netbsd32_read_args;

struct netbsd32_write_args;

struct svr4_32_sys_open_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(int) mode;
};
check_syscall_args(svr4_32_sys_open)

struct netbsd32_close_args;

struct svr4_32_sys_wait_args {
	syscallarg(netbsd32_intp) status;
};
check_syscall_args(svr4_32_sys_wait)

struct svr4_32_sys_creat_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) mode;
};
check_syscall_args(svr4_32_sys_creat)

struct netbsd32_link_args;

struct netbsd32_unlink_args;

struct svr4_32_sys_execv_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charpp) argp;
};
check_syscall_args(svr4_32_sys_execv)

struct netbsd32_chdir_args;

struct svr4_32_sys_time_args {
	syscallarg(svr4_32_time_tp) t;
};
check_syscall_args(svr4_32_sys_time)

struct svr4_32_sys_mknod_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) mode;
	syscallarg(int) dev;
};
check_syscall_args(svr4_32_sys_mknod)

struct netbsd32_chmod_args;

struct netbsd32___posix_chown_args;

struct svr4_32_sys_break_args {
	syscallarg(netbsd32_caddr_t) nsize;
};
check_syscall_args(svr4_32_sys_break)

struct svr4_32_sys_stat_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_statp) ub;
};
check_syscall_args(svr4_32_sys_stat)

struct compat_43_netbsd32_olseek_args;

struct netbsd32_setuid_args;

struct svr4_32_sys_alarm_args {
	syscallarg(unsigned) sec;
};
check_syscall_args(svr4_32_sys_alarm)

struct svr4_32_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_statp) sb;
};
check_syscall_args(svr4_32_sys_fstat)

struct svr4_32_sys_utime_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_utimbufp) ubuf;
};
check_syscall_args(svr4_32_sys_utime)

struct svr4_32_sys_access_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
};
check_syscall_args(svr4_32_sys_access)

struct svr4_32_sys_nice_args {
	syscallarg(int) prio;
};
check_syscall_args(svr4_32_sys_nice)

struct svr4_32_sys_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};
check_syscall_args(svr4_32_sys_kill)

struct svr4_32_sys_pgrpsys_args {
	syscallarg(int) cmd;
	syscallarg(int) pid;
	syscallarg(int) pgid;
};
check_syscall_args(svr4_32_sys_pgrpsys)

struct netbsd32_dup_args;

struct svr4_32_sys_times_args {
	syscallarg(svr4_32_tms_tp) tp;
};
check_syscall_args(svr4_32_sys_times)

struct netbsd32_setgid_args;

struct svr4_32_sys_signal_args {
	syscallarg(int) signum;
	syscallarg(svr4_sig_t) handler;
};
check_syscall_args(svr4_32_sys_signal)
#ifdef SYSVMSG

struct svr4_32_sys_msgsys_args {
	syscallarg(int) what;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
check_syscall_args(svr4_32_sys_msgsys)
#else
#endif

struct svr4_32_sys_sysarch_args {
	syscallarg(int) op;
	syscallarg(netbsd32_voidp) a1;
};
check_syscall_args(svr4_32_sys_sysarch)
#ifdef SYSVSHM

struct svr4_32_sys_shmsys_args {
	syscallarg(int) what;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};
check_syscall_args(svr4_32_sys_shmsys)
#else
#endif
#ifdef SYSVSEM

struct svr4_32_sys_semsys_args {
	syscallarg(int) what;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
check_syscall_args(svr4_32_sys_semsys)
#else
#endif

struct svr4_32_sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_u_long) com;
	syscallarg(netbsd32_caddr_t) data;
};
check_syscall_args(svr4_32_sys_ioctl)

struct svr4_32_sys_utssys_args {
	syscallarg(netbsd32_voidp) a1;
	syscallarg(netbsd32_voidp) a2;
	syscallarg(int) sel;
	syscallarg(netbsd32_voidp) a3;
};
check_syscall_args(svr4_32_sys_utssys)

struct netbsd32_fsync_args;

struct netbsd32_execve_args;

struct netbsd32_umask_args;

struct netbsd32_chroot_args;

struct svr4_32_sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(netbsd32_charp) arg;
};
check_syscall_args(svr4_32_sys_fcntl)

struct svr4_32_sys_ulimit_args {
	syscallarg(int) cmd;
	syscallarg(netbsd32_long) newlimit;
};
check_syscall_args(svr4_32_sys_ulimit)

struct netbsd32_rmdir_args;

struct netbsd32_mkdir_args;

struct svr4_32_sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(int) nbytes;
};
check_syscall_args(svr4_32_sys_getdents)

struct svr4_32_sys_getmsg_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_strbuf_tp) ctl;
	syscallarg(svr4_32_strbuf_tp) dat;
	syscallarg(netbsd32_intp) flags;
};
check_syscall_args(svr4_32_sys_getmsg)

struct svr4_32_sys_putmsg_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_strbuf_tp) ctl;
	syscallarg(svr4_32_strbuf_tp) dat;
	syscallarg(int) flags;
};
check_syscall_args(svr4_32_sys_putmsg)

struct netbsd32_poll_args;

struct svr4_32_sys_lstat_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_stat_tp) ub;
};
check_syscall_args(svr4_32_sys_lstat)

struct netbsd32_symlink_args;

struct netbsd32_readlink_args;

struct netbsd32_getgroups_args;

struct netbsd32_setgroups_args;

struct netbsd32_fchmod_args;

struct netbsd32___posix_fchown_args;

struct svr4_32_sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(svr4_32_sigset_tp) set;
	syscallarg(svr4_32_sigset_tp) oset;
};
check_syscall_args(svr4_32_sys_sigprocmask)

struct svr4_32_sys_sigsuspend_args {
	syscallarg(svr4_32_sigset_tp) set;
};
check_syscall_args(svr4_32_sys_sigsuspend)

struct svr4_32_sys_sigaltstack_args {
	syscallarg(svr4_32_sigaltstack_tp) nss;
	syscallarg(svr4_32_sigaltstack_tp) oss;
};
check_syscall_args(svr4_32_sys_sigaltstack)

struct svr4_32_sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(svr4_32_sigaction_tp) nsa;
	syscallarg(svr4_32_sigaction_tp) osa;
};
check_syscall_args(svr4_32_sys_sigaction)

struct svr4_32_sys_sigpending_args {
	syscallarg(int) what;
	syscallarg(svr4_32_sigset_tp) set;
};
check_syscall_args(svr4_32_sys_sigpending)

struct svr4_32_sys_context_args {
	syscallarg(int) func;
	syscallarg(svr4_32_ucontext_tp) uc;
};
check_syscall_args(svr4_32_sys_context)

struct svr4_32_sys_statvfs_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_statvfs_tp) fs;
};
check_syscall_args(svr4_32_sys_statvfs)

struct svr4_32_sys_fstatvfs_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_statvfs_tp) fs;
};
check_syscall_args(svr4_32_sys_fstatvfs)

struct svr4_32_sys_waitsys_args {
	syscallarg(int) grp;
	syscallarg(int) id;
	syscallarg(svr4_32_siginfo_tp) info;
	syscallarg(int) options;
};
check_syscall_args(svr4_32_sys_waitsys)

struct svr4_32_sys_hrtsys_args {
	syscallarg(int) cmd;
	syscallarg(int) fun;
	syscallarg(int) sub;
	syscallarg(netbsd32_voidp) rv1;
	syscallarg(netbsd32_voidp) rv2;
};
check_syscall_args(svr4_32_sys_hrtsys)

struct svr4_32_sys_pathconf_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) name;
};
check_syscall_args(svr4_32_sys_pathconf)

struct svr4_32_sys_mmap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(svr4_32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(svr4_32_off_t) pos;
};
check_syscall_args(svr4_32_sys_mmap)

struct netbsd32_mprotect_args;

struct netbsd32_munmap_args;

struct svr4_32_sys_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};
check_syscall_args(svr4_32_sys_fpathconf)

struct netbsd32_fchdir_args;

struct netbsd32_readv_args;

struct netbsd32_writev_args;

struct svr4_32_sys_xstat_args {
	syscallarg(int) two;
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_xstat_tp) ub;
};
check_syscall_args(svr4_32_sys_xstat)

struct svr4_32_sys_lxstat_args {
	syscallarg(int) two;
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_xstat_tp) ub;
};
check_syscall_args(svr4_32_sys_lxstat)

struct svr4_32_sys_fxstat_args {
	syscallarg(int) two;
	syscallarg(int) fd;
	syscallarg(svr4_32_xstat_tp) sb;
};
check_syscall_args(svr4_32_sys_fxstat)

struct svr4_32_sys_xmknod_args {
	syscallarg(int) two;
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_mode_t) mode;
	syscallarg(svr4_dev_t) dev;
};
check_syscall_args(svr4_32_sys_xmknod)

struct svr4_32_sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(svr4_32_rlimit_tp) rlp;
};
check_syscall_args(svr4_32_sys_setrlimit)

struct svr4_32_sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(svr4_32_rlimit_tp) rlp;
};
check_syscall_args(svr4_32_sys_getrlimit)

struct netbsd32_lchown_args;

struct svr4_32_sys_memcntl_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(svr4_32_size_t) len;
	syscallarg(int) cmd;
	syscallarg(netbsd32_voidp) arg;
	syscallarg(int) attr;
	syscallarg(int) mask;
};
check_syscall_args(svr4_32_sys_memcntl)

struct netbsd32___posix_rename_args;

struct svr4_32_sys_uname_args {
	syscallarg(svr4_32_utsnamep) name;
	syscallarg(int) dummy;
};
check_syscall_args(svr4_32_sys_uname)

struct netbsd32_setegid_args;

struct svr4_32_sys_sysconfig_args {
	syscallarg(int) name;
};
check_syscall_args(svr4_32_sys_sysconfig)

struct compat_50_netbsd32_adjtime_args;

struct svr4_32_sys_systeminfo_args {
	syscallarg(int) what;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_long) len;
};
check_syscall_args(svr4_32_sys_systeminfo)

struct netbsd32_seteuid_args;

struct svr4_32_sys__lwp_info_args {
	syscallarg(svr4_32_lwpinfop) lwpinfo;
};
check_syscall_args(svr4_32_sys__lwp_info)

struct netbsd32_fchroot_args;

struct svr4_32_sys_utimes_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_timevalp_t) tptr;
};
check_syscall_args(svr4_32_sys_utimes)

struct svr4_32_sys_gettimeofday_args {
	syscallarg(netbsd32_timevalp_t) tp;
};
check_syscall_args(svr4_32_sys_gettimeofday)

struct compat_50_netbsd32_getitimer_args;

struct compat_50_netbsd32_setitimer_args;

struct svr4_32_sys__lwp_create_args {
	syscallarg(svr4_32_ucontext_tp) uc;
	syscallarg(netbsd32_u_long) flags;
	syscallarg(svr4_32_lwpid_tp) lwpid;
};
check_syscall_args(svr4_32_sys__lwp_create)

struct svr4_32_sys__lwp_suspend_args {
	syscallarg(svr4_lwpid_t) lwpid;
};
check_syscall_args(svr4_32_sys__lwp_suspend)

struct svr4_32_sys__lwp_continue_args {
	syscallarg(svr4_lwpid_t) lwpid;
};
check_syscall_args(svr4_32_sys__lwp_continue)

struct svr4_32_sys__lwp_kill_args {
	syscallarg(svr4_lwpid_t) lwpid;
	syscallarg(int) signum;
};
check_syscall_args(svr4_32_sys__lwp_kill)

struct svr4_32_sys__lwp_setprivate_args {
	syscallarg(netbsd32_voidp) buffer;
};
check_syscall_args(svr4_32_sys__lwp_setprivate)

struct svr4_32_sys__lwp_wait_args {
	syscallarg(svr4_lwpid_t) wait_for;
	syscallarg(svr4_32_lwpid_tp) departed_lwp;
};
check_syscall_args(svr4_32_sys__lwp_wait)

struct svr4_32_sys_pread_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(svr4_32_off_t) off;
};
check_syscall_args(svr4_32_sys_pread)

struct svr4_32_sys_pwrite_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(svr4_32_off_t) off;
};
check_syscall_args(svr4_32_sys_pwrite)

struct svr4_32_sys_llseek_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_long) offset1;
	syscallarg(netbsd32_long) offset2;
	syscallarg(int) whence;
};
check_syscall_args(svr4_32_sys_llseek)

struct svr4_32_sys_acl_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) cmd;
	syscallarg(int) num;
	syscallarg(svr4_32_aclent_tp) buf;
};
check_syscall_args(svr4_32_sys_acl)

struct svr4_32_sys_auditsys_args {
	syscallarg(int) code;
	syscallarg(int) a1;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
check_syscall_args(svr4_32_sys_auditsys)

struct compat_50_netbsd32_nanosleep_args;

struct svr4_32_sys_facl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(int) num;
	syscallarg(svr4_32_aclent_tp) buf;
};
check_syscall_args(svr4_32_sys_facl)

struct netbsd32_setreuid_args;

struct netbsd32_setregid_args;

struct svr4_32_sys_schedctl_args {
	syscallarg(unsigned int) x;
	syscallarg(int) y;
	syscallarg(void **) z;
};
check_syscall_args(svr4_32_sys_schedctl)

struct svr4_32_sys_resolvepath_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) bufsiz;
};
check_syscall_args(svr4_32_sys_resolvepath)

struct svr4_32_sys_getdents64_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_dirent64_tp) dp;
	syscallarg(int) nbytes;
};
check_syscall_args(svr4_32_sys_getdents64)

struct svr4_32_sys_mmap64_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(svr4_32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(svr4_32_off64_t) pos;
};
check_syscall_args(svr4_32_sys_mmap64)

struct svr4_32_sys_stat64_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_stat64_tp) sb;
};
check_syscall_args(svr4_32_sys_stat64)

struct svr4_32_sys_lstat64_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_stat64_tp) sb;
};
check_syscall_args(svr4_32_sys_lstat64)

struct svr4_32_sys_fstat64_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_stat64_tp) sb;
};
check_syscall_args(svr4_32_sys_fstat64)

struct svr4_32_sys_statvfs64_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(svr4_32_statvfs64_tp) fs;
};
check_syscall_args(svr4_32_sys_statvfs64)

struct svr4_32_sys_fstatvfs64_args {
	syscallarg(int) fd;
	syscallarg(svr4_32_statvfs64_tp) fs;
};
check_syscall_args(svr4_32_sys_fstatvfs64)

struct svr4_32_sys_setrlimit64_args {
	syscallarg(int) which;
	syscallarg(svr4_32_rlimit64_tp) rlp;
};
check_syscall_args(svr4_32_sys_setrlimit64)

struct svr4_32_sys_getrlimit64_args {
	syscallarg(int) which;
	syscallarg(svr4_32_rlimit64_tp) rlp;
};
check_syscall_args(svr4_32_sys_getrlimit64)

struct svr4_32_sys_pread64_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(svr4_32_off64_t) off;
};
check_syscall_args(svr4_32_sys_pread64)

struct svr4_32_sys_pwrite64_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(svr4_32_off64_t) off;
};
check_syscall_args(svr4_32_sys_pwrite64)
#define svr4_32_sys_creat64 svr4_32_sys_creat
#define svr4_32_sys_creat64_args svr4_32_sys_creat_args

struct svr4_32_sys_creat64_args;
#define svr4_32_sys_open64 svr4_32_sys_open
#define svr4_32_sys_open64_args svr4_32_sys_open_args

struct svr4_32_sys_open64_args;

struct svr4_32_sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};
check_syscall_args(svr4_32_sys_socket)

struct netbsd32_socketpair_args;

struct netbsd32_bind_args;

struct netbsd32_listen_args;

struct compat_43_netbsd32_oaccept_args;

struct netbsd32_connect_args;

struct netbsd32_shutdown_args;

struct compat_43_netbsd32_orecv_args;

struct compat_43_netbsd32_orecvfrom_args;

struct compat_43_netbsd32_orecvmsg_args;

struct compat_43_netbsd32_osend_args;

struct compat_43_netbsd32_osendmsg_args;

struct netbsd32_sendto_args;

struct compat_43_netbsd32_ogetpeername_args;

struct compat_43_netbsd32_ogetsockname_args;

struct netbsd32_getsockopt_args;

struct netbsd32_setsockopt_args;
#if defined(NTP) || !defined(_KERNEL)

struct netbsd32_ntp_adjtime_args;
#else
#endif

/*
 * System call prototypes.
 */

int	sys_nosys(struct lwp *, const void *, register_t *);

int	netbsd32_exit(struct lwp *, const struct netbsd32_exit_args *, register_t *);

int	sys_fork(struct lwp *, const void *, register_t *);

int	netbsd32_read(struct lwp *, const struct netbsd32_read_args *, register_t *);

int	netbsd32_write(struct lwp *, const struct netbsd32_write_args *, register_t *);

int	svr4_32_sys_open(struct lwp *, const struct svr4_32_sys_open_args *, register_t *);

int	netbsd32_close(struct lwp *, const struct netbsd32_close_args *, register_t *);

int	svr4_32_sys_wait(struct lwp *, const struct svr4_32_sys_wait_args *, register_t *);

int	svr4_32_sys_creat(struct lwp *, const struct svr4_32_sys_creat_args *, register_t *);

int	netbsd32_link(struct lwp *, const struct netbsd32_link_args *, register_t *);

int	netbsd32_unlink(struct lwp *, const struct netbsd32_unlink_args *, register_t *);

int	svr4_32_sys_execv(struct lwp *, const struct svr4_32_sys_execv_args *, register_t *);

int	netbsd32_chdir(struct lwp *, const struct netbsd32_chdir_args *, register_t *);

int	svr4_32_sys_time(struct lwp *, const struct svr4_32_sys_time_args *, register_t *);

int	svr4_32_sys_mknod(struct lwp *, const struct svr4_32_sys_mknod_args *, register_t *);

int	netbsd32_chmod(struct lwp *, const struct netbsd32_chmod_args *, register_t *);

int	netbsd32___posix_chown(struct lwp *, const struct netbsd32___posix_chown_args *, register_t *);

int	svr4_32_sys_break(struct lwp *, const struct svr4_32_sys_break_args *, register_t *);

int	svr4_32_sys_stat(struct lwp *, const struct svr4_32_sys_stat_args *, register_t *);

int	compat_43_netbsd32_olseek(struct lwp *, const struct compat_43_netbsd32_olseek_args *, register_t *);

int	sys_getpid(struct lwp *, const void *, register_t *);

int	netbsd32_setuid(struct lwp *, const struct netbsd32_setuid_args *, register_t *);

int	sys_getuid_with_euid(struct lwp *, const void *, register_t *);

int	svr4_32_sys_alarm(struct lwp *, const struct svr4_32_sys_alarm_args *, register_t *);

int	svr4_32_sys_fstat(struct lwp *, const struct svr4_32_sys_fstat_args *, register_t *);

int	svr4_32_sys_pause(struct lwp *, const void *, register_t *);

int	svr4_32_sys_utime(struct lwp *, const struct svr4_32_sys_utime_args *, register_t *);

int	svr4_32_sys_access(struct lwp *, const struct svr4_32_sys_access_args *, register_t *);

int	svr4_32_sys_nice(struct lwp *, const struct svr4_32_sys_nice_args *, register_t *);

int	sys_sync(struct lwp *, const void *, register_t *);

int	svr4_32_sys_kill(struct lwp *, const struct svr4_32_sys_kill_args *, register_t *);

int	svr4_32_sys_pgrpsys(struct lwp *, const struct svr4_32_sys_pgrpsys_args *, register_t *);

int	netbsd32_dup(struct lwp *, const struct netbsd32_dup_args *, register_t *);

int	sys_pipe(struct lwp *, const void *, register_t *);

int	svr4_32_sys_times(struct lwp *, const struct svr4_32_sys_times_args *, register_t *);

int	netbsd32_setgid(struct lwp *, const struct netbsd32_setgid_args *, register_t *);

int	sys_getgid_with_egid(struct lwp *, const void *, register_t *);

int	svr4_32_sys_signal(struct lwp *, const struct svr4_32_sys_signal_args *, register_t *);

#ifdef SYSVMSG
int	svr4_32_sys_msgsys(struct lwp *, const struct svr4_32_sys_msgsys_args *, register_t *);

#else
#endif
int	svr4_32_sys_sysarch(struct lwp *, const struct svr4_32_sys_sysarch_args *, register_t *);

#ifdef SYSVSHM
int	svr4_32_sys_shmsys(struct lwp *, const struct svr4_32_sys_shmsys_args *, register_t *);

#else
#endif
#ifdef SYSVSEM
int	svr4_32_sys_semsys(struct lwp *, const struct svr4_32_sys_semsys_args *, register_t *);

#else
#endif
int	svr4_32_sys_ioctl(struct lwp *, const struct svr4_32_sys_ioctl_args *, register_t *);

int	svr4_32_sys_utssys(struct lwp *, const struct svr4_32_sys_utssys_args *, register_t *);

int	netbsd32_fsync(struct lwp *, const struct netbsd32_fsync_args *, register_t *);

int	netbsd32_execve(struct lwp *, const struct netbsd32_execve_args *, register_t *);

int	netbsd32_umask(struct lwp *, const struct netbsd32_umask_args *, register_t *);

int	netbsd32_chroot(struct lwp *, const struct netbsd32_chroot_args *, register_t *);

int	svr4_32_sys_fcntl(struct lwp *, const struct svr4_32_sys_fcntl_args *, register_t *);

int	svr4_32_sys_ulimit(struct lwp *, const struct svr4_32_sys_ulimit_args *, register_t *);

int	netbsd32_rmdir(struct lwp *, const struct netbsd32_rmdir_args *, register_t *);

int	netbsd32_mkdir(struct lwp *, const struct netbsd32_mkdir_args *, register_t *);

int	svr4_32_sys_getdents(struct lwp *, const struct svr4_32_sys_getdents_args *, register_t *);

int	svr4_32_sys_getmsg(struct lwp *, const struct svr4_32_sys_getmsg_args *, register_t *);

int	svr4_32_sys_putmsg(struct lwp *, const struct svr4_32_sys_putmsg_args *, register_t *);

int	netbsd32_poll(struct lwp *, const struct netbsd32_poll_args *, register_t *);

int	svr4_32_sys_lstat(struct lwp *, const struct svr4_32_sys_lstat_args *, register_t *);

int	netbsd32_symlink(struct lwp *, const struct netbsd32_symlink_args *, register_t *);

int	netbsd32_readlink(struct lwp *, const struct netbsd32_readlink_args *, register_t *);

int	netbsd32_getgroups(struct lwp *, const struct netbsd32_getgroups_args *, register_t *);

int	netbsd32_setgroups(struct lwp *, const struct netbsd32_setgroups_args *, register_t *);

int	netbsd32_fchmod(struct lwp *, const struct netbsd32_fchmod_args *, register_t *);

int	netbsd32___posix_fchown(struct lwp *, const struct netbsd32___posix_fchown_args *, register_t *);

int	svr4_32_sys_sigprocmask(struct lwp *, const struct svr4_32_sys_sigprocmask_args *, register_t *);

int	svr4_32_sys_sigsuspend(struct lwp *, const struct svr4_32_sys_sigsuspend_args *, register_t *);

int	svr4_32_sys_sigaltstack(struct lwp *, const struct svr4_32_sys_sigaltstack_args *, register_t *);

int	svr4_32_sys_sigaction(struct lwp *, const struct svr4_32_sys_sigaction_args *, register_t *);

int	svr4_32_sys_sigpending(struct lwp *, const struct svr4_32_sys_sigpending_args *, register_t *);

int	svr4_32_sys_context(struct lwp *, const struct svr4_32_sys_context_args *, register_t *);

int	svr4_32_sys_statvfs(struct lwp *, const struct svr4_32_sys_statvfs_args *, register_t *);

int	svr4_32_sys_fstatvfs(struct lwp *, const struct svr4_32_sys_fstatvfs_args *, register_t *);

int	svr4_32_sys_waitsys(struct lwp *, const struct svr4_32_sys_waitsys_args *, register_t *);

int	svr4_32_sys_hrtsys(struct lwp *, const struct svr4_32_sys_hrtsys_args *, register_t *);

int	svr4_32_sys_pathconf(struct lwp *, const struct svr4_32_sys_pathconf_args *, register_t *);

int	svr4_32_sys_mmap(struct lwp *, const struct svr4_32_sys_mmap_args *, register_t *);

int	netbsd32_mprotect(struct lwp *, const struct netbsd32_mprotect_args *, register_t *);

int	netbsd32_munmap(struct lwp *, const struct netbsd32_munmap_args *, register_t *);

int	svr4_32_sys_fpathconf(struct lwp *, const struct svr4_32_sys_fpathconf_args *, register_t *);

int	sys_vfork(struct lwp *, const void *, register_t *);

int	netbsd32_fchdir(struct lwp *, const struct netbsd32_fchdir_args *, register_t *);

int	netbsd32_readv(struct lwp *, const struct netbsd32_readv_args *, register_t *);

int	netbsd32_writev(struct lwp *, const struct netbsd32_writev_args *, register_t *);

int	svr4_32_sys_xstat(struct lwp *, const struct svr4_32_sys_xstat_args *, register_t *);

int	svr4_32_sys_lxstat(struct lwp *, const struct svr4_32_sys_lxstat_args *, register_t *);

int	svr4_32_sys_fxstat(struct lwp *, const struct svr4_32_sys_fxstat_args *, register_t *);

int	svr4_32_sys_xmknod(struct lwp *, const struct svr4_32_sys_xmknod_args *, register_t *);

int	svr4_32_sys_setrlimit(struct lwp *, const struct svr4_32_sys_setrlimit_args *, register_t *);

int	svr4_32_sys_getrlimit(struct lwp *, const struct svr4_32_sys_getrlimit_args *, register_t *);

int	netbsd32_lchown(struct lwp *, const struct netbsd32_lchown_args *, register_t *);

int	svr4_32_sys_memcntl(struct lwp *, const struct svr4_32_sys_memcntl_args *, register_t *);

int	netbsd32___posix_rename(struct lwp *, const struct netbsd32___posix_rename_args *, register_t *);

int	svr4_32_sys_uname(struct lwp *, const struct svr4_32_sys_uname_args *, register_t *);

int	netbsd32_setegid(struct lwp *, const struct netbsd32_setegid_args *, register_t *);

int	svr4_32_sys_sysconfig(struct lwp *, const struct svr4_32_sys_sysconfig_args *, register_t *);

int	compat_50_netbsd32_adjtime(struct lwp *, const struct compat_50_netbsd32_adjtime_args *, register_t *);

int	svr4_32_sys_systeminfo(struct lwp *, const struct svr4_32_sys_systeminfo_args *, register_t *);

int	netbsd32_seteuid(struct lwp *, const struct netbsd32_seteuid_args *, register_t *);

int	svr4_32_sys__lwp_info(struct lwp *, const struct svr4_32_sys__lwp_info_args *, register_t *);

int	netbsd32_fchroot(struct lwp *, const struct netbsd32_fchroot_args *, register_t *);

int	svr4_32_sys_utimes(struct lwp *, const struct svr4_32_sys_utimes_args *, register_t *);

int	svr4_32_sys_vhangup(struct lwp *, const void *, register_t *);

int	svr4_32_sys_gettimeofday(struct lwp *, const struct svr4_32_sys_gettimeofday_args *, register_t *);

int	compat_50_netbsd32_getitimer(struct lwp *, const struct compat_50_netbsd32_getitimer_args *, register_t *);

int	compat_50_netbsd32_setitimer(struct lwp *, const struct compat_50_netbsd32_setitimer_args *, register_t *);

int	svr4_32_sys__lwp_create(struct lwp *, const struct svr4_32_sys__lwp_create_args *, register_t *);

int	svr4_32_sys__lwp_exit(struct lwp *, const void *, register_t *);

int	svr4_32_sys__lwp_suspend(struct lwp *, const struct svr4_32_sys__lwp_suspend_args *, register_t *);

int	svr4_32_sys__lwp_continue(struct lwp *, const struct svr4_32_sys__lwp_continue_args *, register_t *);

int	svr4_32_sys__lwp_kill(struct lwp *, const struct svr4_32_sys__lwp_kill_args *, register_t *);

int	svr4_sys__lwp_self(struct lwp *, const void *, register_t *);

int	svr4_32_sys__lwp_getprivate(struct lwp *, const void *, register_t *);

int	svr4_32_sys__lwp_setprivate(struct lwp *, const struct svr4_32_sys__lwp_setprivate_args *, register_t *);

int	svr4_32_sys__lwp_wait(struct lwp *, const struct svr4_32_sys__lwp_wait_args *, register_t *);

int	svr4_32_sys_pread(struct lwp *, const struct svr4_32_sys_pread_args *, register_t *);

int	svr4_32_sys_pwrite(struct lwp *, const struct svr4_32_sys_pwrite_args *, register_t *);

int	svr4_32_sys_llseek(struct lwp *, const struct svr4_32_sys_llseek_args *, register_t *);

int	svr4_32_sys_acl(struct lwp *, const struct svr4_32_sys_acl_args *, register_t *);

int	svr4_32_sys_auditsys(struct lwp *, const struct svr4_32_sys_auditsys_args *, register_t *);

int	compat_50_netbsd32_nanosleep(struct lwp *, const struct compat_50_netbsd32_nanosleep_args *, register_t *);

int	svr4_32_sys_facl(struct lwp *, const struct svr4_32_sys_facl_args *, register_t *);

int	netbsd32_setreuid(struct lwp *, const struct netbsd32_setreuid_args *, register_t *);

int	netbsd32_setregid(struct lwp *, const struct netbsd32_setregid_args *, register_t *);

int	svr4_32_sys_schedctl(struct lwp *, const struct svr4_32_sys_schedctl_args *, register_t *);

int	svr4_32_sys_resolvepath(struct lwp *, const struct svr4_32_sys_resolvepath_args *, register_t *);

int	svr4_32_sys_getdents64(struct lwp *, const struct svr4_32_sys_getdents64_args *, register_t *);

int	svr4_32_sys_mmap64(struct lwp *, const struct svr4_32_sys_mmap64_args *, register_t *);

int	svr4_32_sys_stat64(struct lwp *, const struct svr4_32_sys_stat64_args *, register_t *);

int	svr4_32_sys_lstat64(struct lwp *, const struct svr4_32_sys_lstat64_args *, register_t *);

int	svr4_32_sys_fstat64(struct lwp *, const struct svr4_32_sys_fstat64_args *, register_t *);

int	svr4_32_sys_statvfs64(struct lwp *, const struct svr4_32_sys_statvfs64_args *, register_t *);

int	svr4_32_sys_fstatvfs64(struct lwp *, const struct svr4_32_sys_fstatvfs64_args *, register_t *);

int	svr4_32_sys_setrlimit64(struct lwp *, const struct svr4_32_sys_setrlimit64_args *, register_t *);

int	svr4_32_sys_getrlimit64(struct lwp *, const struct svr4_32_sys_getrlimit64_args *, register_t *);

int	svr4_32_sys_pread64(struct lwp *, const struct svr4_32_sys_pread64_args *, register_t *);

int	svr4_32_sys_pwrite64(struct lwp *, const struct svr4_32_sys_pwrite64_args *, register_t *);

#define svr4_32_sys_creat64 svr4_32_sys_creat
#define svr4_32_sys_creat64_args svr4_32_sys_creat_args
int	svr4_32_sys_creat64(struct lwp *, const struct svr4_32_sys_creat64_args *, register_t *);

#define svr4_32_sys_open64 svr4_32_sys_open
#define svr4_32_sys_open64_args svr4_32_sys_open_args
int	svr4_32_sys_open64(struct lwp *, const struct svr4_32_sys_open64_args *, register_t *);

int	svr4_32_sys_socket(struct lwp *, const struct svr4_32_sys_socket_args *, register_t *);

int	netbsd32_socketpair(struct lwp *, const struct netbsd32_socketpair_args *, register_t *);

int	netbsd32_bind(struct lwp *, const struct netbsd32_bind_args *, register_t *);

int	netbsd32_listen(struct lwp *, const struct netbsd32_listen_args *, register_t *);

int	compat_43_netbsd32_oaccept(struct lwp *, const struct compat_43_netbsd32_oaccept_args *, register_t *);

int	netbsd32_connect(struct lwp *, const struct netbsd32_connect_args *, register_t *);

int	netbsd32_shutdown(struct lwp *, const struct netbsd32_shutdown_args *, register_t *);

int	compat_43_netbsd32_orecv(struct lwp *, const struct compat_43_netbsd32_orecv_args *, register_t *);

int	compat_43_netbsd32_orecvfrom(struct lwp *, const struct compat_43_netbsd32_orecvfrom_args *, register_t *);

int	compat_43_netbsd32_orecvmsg(struct lwp *, const struct compat_43_netbsd32_orecvmsg_args *, register_t *);

int	compat_43_netbsd32_osend(struct lwp *, const struct compat_43_netbsd32_osend_args *, register_t *);

int	compat_43_netbsd32_osendmsg(struct lwp *, const struct compat_43_netbsd32_osendmsg_args *, register_t *);

int	netbsd32_sendto(struct lwp *, const struct netbsd32_sendto_args *, register_t *);

int	compat_43_netbsd32_ogetpeername(struct lwp *, const struct compat_43_netbsd32_ogetpeername_args *, register_t *);

int	compat_43_netbsd32_ogetsockname(struct lwp *, const struct compat_43_netbsd32_ogetsockname_args *, register_t *);

int	netbsd32_getsockopt(struct lwp *, const struct netbsd32_getsockopt_args *, register_t *);

int	netbsd32_setsockopt(struct lwp *, const struct netbsd32_setsockopt_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL)
int	netbsd32_ntp_adjtime(struct lwp *, const struct netbsd32_ntp_adjtime_args *, register_t *);

#else
#endif
#endif /* _SVR4_32_SYS_SYSCALLARGS_H_ */
