/* $NetBSD: netbsd32_syscallargs.h,v 1.129.2.1 2019/11/04 14:44:46 martin Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.115.8.1 2019/11/04 14:39:59 martin Exp
 */

#ifndef _NETBSD32_SYS_SYSCALLARGS_H_
#define	_NETBSD32_SYS_SYSCALLARGS_H_

/* Forward declaration */
struct lwp;

#define	NETBSD32_SYS_MAXSYSARGS	8

#undef	syscallarg
#define	syscallarg(x)							\
	union {								\
		register32_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register32_t) < sizeof (x))	\
				? 0					\
				: sizeof (register32_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

#undef check_syscall_args
#define check_syscall_args(call) /*LINTED*/ \
	typedef char call##_check_args[sizeof (struct call##_args) \
		<= NETBSD32_SYS_MAXSYSARGS * sizeof (register32_t) ? 1 : -1];

struct netbsd32_syscall_args {
	syscallarg(int) code;
	syscallarg(register32_t) args[NETBSD32_SYS_MAXSYSARGS];
};

struct netbsd32_exit_args {
	syscallarg(int) rval;
};
check_syscall_args(netbsd32_exit)

struct netbsd32_read_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
};
check_syscall_args(netbsd32_read)

struct netbsd32_write_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
};
check_syscall_args(netbsd32_write)

struct netbsd32_open_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_open)

struct netbsd32_close_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_close)

struct compat_50_netbsd32_wait4_args {
	syscallarg(int) pid;
	syscallarg(netbsd32_intp) status;
	syscallarg(int) options;
	syscallarg(netbsd32_rusage50p_t) rusage;
};
check_syscall_args(compat_50_netbsd32_wait4)

struct compat_43_netbsd32_ocreat_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(compat_43_netbsd32_ocreat)

struct netbsd32_link_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) link;
};
check_syscall_args(netbsd32_link)

struct netbsd32_unlink_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_unlink)

struct netbsd32_chdir_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_chdir)

struct netbsd32_fchdir_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_fchdir)

struct compat_50_netbsd32_mknod_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
	syscallarg(uint32_t) dev;
};
check_syscall_args(compat_50_netbsd32_mknod)

struct netbsd32_chmod_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_chmod)

struct netbsd32_chown_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32_chown)

struct netbsd32_break_args {
	syscallarg(netbsd32_charp) nsize;
};
check_syscall_args(netbsd32_break)

struct compat_20_netbsd32_getfsstat_args {
	syscallarg(netbsd32_statfsp_t) buf;
	syscallarg(netbsd32_long) bufsize;
	syscallarg(int) flags;
};
check_syscall_args(compat_20_netbsd32_getfsstat)

struct compat_43_netbsd32_olseek_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_long) offset;
	syscallarg(int) whence;
};
check_syscall_args(compat_43_netbsd32_olseek)

struct netbsd32_mount_args {
	syscallarg(netbsd32_charp) type;
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(netbsd32_voidp) data;
};
check_syscall_args(netbsd32_mount)

struct netbsd32_unmount_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_unmount)

struct netbsd32_setuid_args {
	syscallarg(uid_t) uid;
};
check_syscall_args(netbsd32_setuid)

struct netbsd32_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(netbsd32_voidp) addr;
	syscallarg(int) data;
};
check_syscall_args(netbsd32_ptrace)

struct netbsd32_recvmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_msghdrp_t) msg;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_recvmsg)

struct netbsd32_sendmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_msghdrp_t) msg;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_sendmsg)

struct netbsd32_recvfrom_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(netbsd32_sockaddrp_t) from;
	syscallarg(netbsd32_intp) fromlenaddr;
};
check_syscall_args(netbsd32_recvfrom)

struct netbsd32_accept_args {
	syscallarg(int) s;
	syscallarg(netbsd32_sockaddrp_t) name;
	syscallarg(netbsd32_intp) anamelen;
};
check_syscall_args(netbsd32_accept)

struct netbsd32_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_sockaddrp_t) asa;
	syscallarg(netbsd32_intp) alen;
};
check_syscall_args(netbsd32_getpeername)

struct netbsd32_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_sockaddrp_t) asa;
	syscallarg(netbsd32_intp) alen;
};
check_syscall_args(netbsd32_getsockname)

struct netbsd32_access_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_access)

struct netbsd32_chflags_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_u_long) flags;
};
check_syscall_args(netbsd32_chflags)

struct netbsd32_fchflags_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_u_long) flags;
};
check_syscall_args(netbsd32_fchflags)

struct netbsd32_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};
check_syscall_args(netbsd32_kill)

struct compat_43_netbsd32_stat43_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat43p_t) ub;
};
check_syscall_args(compat_43_netbsd32_stat43)

struct compat_43_netbsd32_lstat43_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat43p_t) ub;
};
check_syscall_args(compat_43_netbsd32_lstat43)

struct netbsd32_dup_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_dup)

struct netbsd32_profil_args {
	syscallarg(netbsd32_voidp) samples;
	syscallarg(netbsd32_size_t) size;
	syscallarg(netbsd32_u_long) offset;
	syscallarg(u_int) scale;
};
check_syscall_args(netbsd32_profil)

struct netbsd32_ktrace_args {
	syscallarg(netbsd32_charp) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
check_syscall_args(netbsd32_ktrace)

struct netbsd32_sigaction_args {
	syscallarg(int) signum;
	syscallarg(netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
};
check_syscall_args(netbsd32_sigaction)

struct compat_13_netbsd32_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(int) mask;
};
check_syscall_args(compat_13_netbsd32_sigprocmask)

struct netbsd32___getlogin_args {
	syscallarg(netbsd32_charp) namebuf;
	syscallarg(u_int) namelen;
};
check_syscall_args(netbsd32___getlogin)

struct netbsd32_setlogin_args {
	syscallarg(netbsd32_charp) namebuf;
};
check_syscall_args(netbsd32_setlogin)

struct netbsd32_acct_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_acct)

struct compat_13_netbsd32_sigaltstack13_args {
	syscallarg(netbsd32_sigaltstack13p_t) nss;
	syscallarg(netbsd32_sigaltstack13p_t) oss;
};
check_syscall_args(compat_13_netbsd32_sigaltstack13)

struct netbsd32_ioctl_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_u_long) com;
	syscallarg(netbsd32_voidp) data;
};
check_syscall_args(netbsd32_ioctl)

struct compat_12_netbsd32_reboot_args {
	syscallarg(int) opt;
};
check_syscall_args(compat_12_netbsd32_reboot)

struct netbsd32_revoke_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_revoke)

struct netbsd32_symlink_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) link;
};
check_syscall_args(netbsd32_symlink)

struct netbsd32_readlink_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) count;
};
check_syscall_args(netbsd32_readlink)

struct netbsd32_execve_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charpp) argp;
	syscallarg(netbsd32_charpp) envp;
};
check_syscall_args(netbsd32_execve)

struct netbsd32_umask_args {
	syscallarg(mode_t) newmask;
};
check_syscall_args(netbsd32_umask)

struct netbsd32_chroot_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_chroot)

struct compat_43_netbsd32_fstat43_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat43p_t) sb;
};
check_syscall_args(compat_43_netbsd32_fstat43)

struct compat_43_netbsd32_ogetkerninfo_args {
	syscallarg(int) op;
	syscallarg(netbsd32_charp) where;
	syscallarg(netbsd32_intp) size;
	syscallarg(int) arg;
};
check_syscall_args(compat_43_netbsd32_ogetkerninfo)

struct compat_12_netbsd32_msync_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(compat_12_netbsd32_msync)

struct netbsd32_sbrk_args {
	syscallarg(netbsd32_intptr_t) incr;
};
check_syscall_args(netbsd32_sbrk)

struct netbsd32_sstk_args {
	syscallarg(int) incr;
};
check_syscall_args(netbsd32_sstk)

struct compat_43_netbsd32_ommap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(netbsd32_long) pos;
};
check_syscall_args(compat_43_netbsd32_ommap)

struct netbsd32_ovadvise_args {
	syscallarg(int) anom;
};
check_syscall_args(netbsd32_ovadvise)

struct netbsd32_munmap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(netbsd32_munmap)

struct netbsd32_mprotect_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
};
check_syscall_args(netbsd32_mprotect)

struct netbsd32_madvise_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) behav;
};
check_syscall_args(netbsd32_madvise)

struct netbsd32_mincore_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(netbsd32_charp) vec;
};
check_syscall_args(netbsd32_mincore)

struct netbsd32_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(netbsd32_gid_tp) gidset;
};
check_syscall_args(netbsd32_getgroups)

struct netbsd32_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(netbsd32_gid_tp) gidset;
};
check_syscall_args(netbsd32_setgroups)

struct netbsd32_setpgid_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};
check_syscall_args(netbsd32_setpgid)

struct compat_50_netbsd32_setitimer_args {
	syscallarg(int) which;
	syscallarg(netbsd32_itimerval50p_t) itv;
	syscallarg(netbsd32_itimerval50p_t) oitv;
};
check_syscall_args(compat_50_netbsd32_setitimer)

struct compat_12_netbsd32_oswapon_args {
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(compat_12_netbsd32_oswapon)

struct compat_50_netbsd32_getitimer_args {
	syscallarg(int) which;
	syscallarg(netbsd32_itimerval50p_t) itv;
};
check_syscall_args(compat_50_netbsd32_getitimer)

struct compat_43_netbsd32_ogethostname_args {
	syscallarg(netbsd32_charp) hostname;
	syscallarg(u_int) len;
};
check_syscall_args(compat_43_netbsd32_ogethostname)

struct compat_43_netbsd32_osethostname_args {
	syscallarg(netbsd32_charp) hostname;
	syscallarg(u_int) len;
};
check_syscall_args(compat_43_netbsd32_osethostname)

struct netbsd32_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};
check_syscall_args(netbsd32_dup2)

struct netbsd32_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(netbsd32_voidp) arg;
};
check_syscall_args(netbsd32_fcntl)

struct compat_50_netbsd32_select_args {
	syscallarg(int) nd;
	syscallarg(netbsd32_fd_setp_t) in;
	syscallarg(netbsd32_fd_setp_t) ou;
	syscallarg(netbsd32_fd_setp_t) ex;
	syscallarg(netbsd32_timeval50p_t) tv;
};
check_syscall_args(compat_50_netbsd32_select)

struct netbsd32_fsync_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_fsync)

struct netbsd32_setpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
	syscallarg(int) prio;
};
check_syscall_args(netbsd32_setpriority)

struct compat_30_netbsd32_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};
check_syscall_args(compat_30_netbsd32_socket)

struct netbsd32_connect_args {
	syscallarg(int) s;
	syscallarg(netbsd32_sockaddrp_t) name;
	syscallarg(int) namelen;
};
check_syscall_args(netbsd32_connect)

struct compat_43_netbsd32_oaccept_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) name;
	syscallarg(netbsd32_intp) anamelen;
};
check_syscall_args(compat_43_netbsd32_oaccept)

struct netbsd32_getpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
};
check_syscall_args(netbsd32_getpriority)

struct compat_43_netbsd32_osend_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_netbsd32_osend)

struct compat_43_netbsd32_orecv_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_netbsd32_orecv)

struct compat_13_netbsd32_sigreturn_args {
	syscallarg(netbsd32_sigcontextp_t) sigcntxp;
};
check_syscall_args(compat_13_netbsd32_sigreturn)

struct netbsd32_bind_args {
	syscallarg(int) s;
	syscallarg(netbsd32_sockaddrp_t) name;
	syscallarg(int) namelen;
};
check_syscall_args(netbsd32_bind)

struct netbsd32_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(netbsd32_voidp) val;
	syscallarg(int) valsize;
};
check_syscall_args(netbsd32_setsockopt)

struct netbsd32_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};
check_syscall_args(netbsd32_listen)

struct compat_43_netbsd32_osigvec_args {
	syscallarg(int) signum;
	syscallarg(netbsd32_sigvecp_t) nsv;
	syscallarg(netbsd32_sigvecp_t) osv;
};
check_syscall_args(compat_43_netbsd32_osigvec)

struct compat_43_netbsd32_sigblock_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_43_netbsd32_sigblock)

struct compat_43_netbsd32_sigsetmask_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_43_netbsd32_sigsetmask)

struct compat_13_netbsd32_sigsuspend_args {
	syscallarg(int) mask;
};
check_syscall_args(compat_13_netbsd32_sigsuspend)

struct compat_43_netbsd32_osigstack_args {
	syscallarg(netbsd32_sigstackp_t) nss;
	syscallarg(netbsd32_sigstackp_t) oss;
};
check_syscall_args(compat_43_netbsd32_osigstack)

struct compat_43_netbsd32_orecvmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_omsghdrp_t) msg;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_netbsd32_orecvmsg)

struct compat_43_netbsd32_osendmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) msg;
	syscallarg(int) flags;
};
check_syscall_args(compat_43_netbsd32_osendmsg)

struct compat_50_netbsd32_gettimeofday_args {
	syscallarg(netbsd32_timeval50p_t) tp;
	syscallarg(netbsd32_timezonep_t) tzp;
};
check_syscall_args(compat_50_netbsd32_gettimeofday)

struct compat_50_netbsd32_getrusage_args {
	syscallarg(int) who;
	syscallarg(netbsd32_rusage50p_t) rusage;
};
check_syscall_args(compat_50_netbsd32_getrusage)

struct netbsd32_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(netbsd32_voidp) val;
	syscallarg(netbsd32_intp) avalsize;
};
check_syscall_args(netbsd32_getsockopt)

struct netbsd32_readv_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
};
check_syscall_args(netbsd32_readv)

struct netbsd32_writev_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
};
check_syscall_args(netbsd32_writev)

struct compat_50_netbsd32_settimeofday_args {
	syscallarg(netbsd32_timeval50p_t) tv;
	syscallarg(netbsd32_timezonep_t) tzp;
};
check_syscall_args(compat_50_netbsd32_settimeofday)

struct netbsd32_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32_fchown)

struct netbsd32_fchmod_args {
	syscallarg(int) fd;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_fchmod)

struct compat_43_netbsd32_orecvfrom_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(netbsd32_voidp) from;
	syscallarg(netbsd32_intp) fromlenaddr;
};
check_syscall_args(compat_43_netbsd32_orecvfrom)

struct netbsd32_setreuid_args {
	syscallarg(uid_t) ruid;
	syscallarg(uid_t) euid;
};
check_syscall_args(netbsd32_setreuid)

struct netbsd32_setregid_args {
	syscallarg(gid_t) rgid;
	syscallarg(gid_t) egid;
};
check_syscall_args(netbsd32_setregid)

struct netbsd32_rename_args {
	syscallarg(netbsd32_charp) from;
	syscallarg(netbsd32_charp) to;
};
check_syscall_args(netbsd32_rename)

struct compat_43_netbsd32_otruncate_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_long) length;
};
check_syscall_args(compat_43_netbsd32_otruncate)

struct compat_43_netbsd32_oftruncate_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_long) length;
};
check_syscall_args(compat_43_netbsd32_oftruncate)

struct netbsd32_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};
check_syscall_args(netbsd32_flock)

struct netbsd32_mkfifo_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_mkfifo)

struct netbsd32_sendto_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(netbsd32_sockaddrp_t) to;
	syscallarg(int) tolen;
};
check_syscall_args(netbsd32_sendto)

struct netbsd32_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};
check_syscall_args(netbsd32_shutdown)

struct netbsd32_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(netbsd32_intp) rsv;
};
check_syscall_args(netbsd32_socketpair)

struct netbsd32_mkdir_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_mkdir)

struct netbsd32_rmdir_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_rmdir)

struct compat_50_netbsd32_utimes_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_timeval50p_t) tptr;
};
check_syscall_args(compat_50_netbsd32_utimes)

struct compat_50_netbsd32_adjtime_args {
	syscallarg(netbsd32_timeval50p_t) delta;
	syscallarg(netbsd32_timeval50p_t) olddelta;
};
check_syscall_args(compat_50_netbsd32_adjtime)

struct compat_43_netbsd32_ogetpeername_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_voidp) asa;
	syscallarg(netbsd32_intp) alen;
};
check_syscall_args(compat_43_netbsd32_ogetpeername)

struct compat_43_netbsd32_sethostid_args {
	syscallarg(int32_t) hostid;
};
check_syscall_args(compat_43_netbsd32_sethostid)

struct compat_43_netbsd32_ogetrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_orlimitp_t) rlp;
};
check_syscall_args(compat_43_netbsd32_ogetrlimit)

struct compat_43_netbsd32_osetrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_orlimitp_t) rlp;
};
check_syscall_args(compat_43_netbsd32_osetrlimit)

struct compat_43_netbsd32_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};
check_syscall_args(compat_43_netbsd32_killpg)

struct compat_50_netbsd32_quotactl_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(netbsd32_voidp) arg;
};
check_syscall_args(compat_50_netbsd32_quotactl)

struct compat_43_netbsd32_ogetsockname_args {
	syscallarg(int) fdec;
	syscallarg(netbsd32_voidp) asa;
	syscallarg(netbsd32_intp) alen;
};
check_syscall_args(compat_43_netbsd32_ogetsockname)

struct netbsd32_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(netbsd32_voidp) argp;
};
check_syscall_args(netbsd32_nfssvc)

struct compat_43_netbsd32_ogetdirentries_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(u_int) count;
	syscallarg(netbsd32_longp) basep;
};
check_syscall_args(compat_43_netbsd32_ogetdirentries)

struct compat_20_netbsd32_statfs_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_statfsp_t) buf;
};
check_syscall_args(compat_20_netbsd32_statfs)

struct compat_20_netbsd32_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_statfsp_t) buf;
};
check_syscall_args(compat_20_netbsd32_fstatfs)

struct compat_30_netbsd32_getfh_args {
	syscallarg(netbsd32_charp) fname;
	syscallarg(netbsd32_compat_30_fhandlep_t) fhp;
};
check_syscall_args(compat_30_netbsd32_getfh)

struct compat_09_netbsd32_ogetdomainname_args {
	syscallarg(netbsd32_charp) domainname;
	syscallarg(int) len;
};
check_syscall_args(compat_09_netbsd32_ogetdomainname)

struct compat_09_netbsd32_osetdomainname_args {
	syscallarg(netbsd32_charp) domainname;
	syscallarg(int) len;
};
check_syscall_args(compat_09_netbsd32_osetdomainname)

struct compat_09_netbsd32_uname_args {
	syscallarg(netbsd32_outsnamep_t) name;
};
check_syscall_args(compat_09_netbsd32_uname)

struct netbsd32_sysarch_args {
	syscallarg(int) op;
	syscallarg(netbsd32_voidp) parms;
};
check_syscall_args(netbsd32_sysarch)

struct compat_10_netbsd32_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
check_syscall_args(compat_10_netbsd32_semsys)

struct compat_10_netbsd32_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};
check_syscall_args(compat_10_netbsd32_msgsys)

struct compat_10_netbsd32_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};
check_syscall_args(compat_10_netbsd32_shmsys)

struct netbsd32_pread_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
};
check_syscall_args(netbsd32_pread)

struct netbsd32_pwrite_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
};
check_syscall_args(netbsd32_pwrite)
#if defined(NTP) || !defined(_KERNEL_OPT)

struct compat_30_netbsd32_ntp_gettime_args {
	syscallarg(netbsd32_ntptimeval50p_t) ntvp;
};
check_syscall_args(compat_30_netbsd32_ntp_gettime)

struct netbsd32_ntp_adjtime_args {
	syscallarg(netbsd32_timexp_t) tp;
};
check_syscall_args(netbsd32_ntp_adjtime)
#else
#endif

struct netbsd32_setgid_args {
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32_setgid)

struct netbsd32_setegid_args {
	syscallarg(gid_t) egid;
};
check_syscall_args(netbsd32_setegid)

struct netbsd32_seteuid_args {
	syscallarg(uid_t) euid;
};
check_syscall_args(netbsd32_seteuid)

struct compat_12_netbsd32_stat12_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat12p_t) ub;
};
check_syscall_args(compat_12_netbsd32_stat12)

struct compat_12_netbsd32_fstat12_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat12p_t) sb;
};
check_syscall_args(compat_12_netbsd32_fstat12)

struct compat_12_netbsd32_lstat12_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat12p_t) ub;
};
check_syscall_args(compat_12_netbsd32_lstat12)

struct netbsd32_pathconf_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) name;
};
check_syscall_args(netbsd32_pathconf)

struct netbsd32_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};
check_syscall_args(netbsd32_fpathconf)

struct netbsd32_getrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_rlimitp_t) rlp;
};
check_syscall_args(netbsd32_getrlimit)

struct netbsd32_setrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_rlimitp_t) rlp;
};
check_syscall_args(netbsd32_setrlimit)

struct compat_12_netbsd32_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(u_int) count;
	syscallarg(netbsd32_longp) basep;
};
check_syscall_args(compat_12_netbsd32_getdirentries)

struct netbsd32_mmap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(netbsd32_long) PAD;
	syscallarg(netbsd32_off_t) pos;
};
check_syscall_args(netbsd32_mmap)

struct netbsd32____syscall_args {
	syscallarg(quad_t) code;
	syscallarg(register32_t) args[NETBSD32_SYS_MAXSYSARGS];
};

struct netbsd32_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
	syscallarg(int) whence;
};
check_syscall_args(netbsd32_lseek)

struct netbsd32_truncate_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) length;
};
check_syscall_args(netbsd32_truncate)

struct netbsd32_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) length;
};
check_syscall_args(netbsd32_ftruncate)

struct netbsd32___sysctl_args {
	syscallarg(netbsd32_intp) name;
	syscallarg(u_int) namelen;
	syscallarg(netbsd32_voidp) oldv;
	syscallarg(netbsd32_size_tp) oldlenp;
	syscallarg(netbsd32_voidp) newv;
	syscallarg(netbsd32_size_t) newlen;
};
check_syscall_args(netbsd32___sysctl)

struct netbsd32_mlock_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(netbsd32_mlock)

struct netbsd32_munlock_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(netbsd32_munlock)

struct netbsd32_undelete_args {
	syscallarg(netbsd32_charp) path;
};
check_syscall_args(netbsd32_undelete)

struct compat_50_netbsd32_futimes_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_timeval50p_t) tptr;
};
check_syscall_args(compat_50_netbsd32_futimes)

struct netbsd32_getpgid_args {
	syscallarg(pid_t) pid;
};
check_syscall_args(netbsd32_getpgid)

struct netbsd32_reboot_args {
	syscallarg(int) opt;
	syscallarg(netbsd32_charp) bootstr;
};
check_syscall_args(netbsd32_reboot)

struct netbsd32_poll_args {
	syscallarg(netbsd32_pollfdp_t) fds;
	syscallarg(u_int) nfds;
	syscallarg(int) timeout;
};
check_syscall_args(netbsd32_poll)

struct compat_14_netbsd32___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(netbsd32_semunu_t) arg;
};
check_syscall_args(compat_14_netbsd32___semctl)

struct netbsd32_semget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};
check_syscall_args(netbsd32_semget)

struct netbsd32_semop_args {
	syscallarg(int) semid;
	syscallarg(netbsd32_sembufp_t) sops;
	syscallarg(netbsd32_size_t) nsops;
};
check_syscall_args(netbsd32_semop)

struct netbsd32_semconfig_args {
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_semconfig)

struct compat_14_netbsd32_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_msqid_ds14p_t) buf;
};
check_syscall_args(compat_14_netbsd32_msgctl)

struct netbsd32_msgget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(int) msgflg;
};
check_syscall_args(netbsd32_msgget)

struct netbsd32_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(netbsd32_voidp) msgp;
	syscallarg(netbsd32_size_t) msgsz;
	syscallarg(int) msgflg;
};
check_syscall_args(netbsd32_msgsnd)

struct netbsd32_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(netbsd32_voidp) msgp;
	syscallarg(netbsd32_size_t) msgsz;
	syscallarg(netbsd32_long) msgtyp;
	syscallarg(int) msgflg;
};
check_syscall_args(netbsd32_msgrcv)

struct netbsd32_shmat_args {
	syscallarg(int) shmid;
	syscallarg(netbsd32_voidp) shmaddr;
	syscallarg(int) shmflg;
};
check_syscall_args(netbsd32_shmat)

struct compat_14_netbsd32_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_shmid_dsp_t) buf;
};
check_syscall_args(compat_14_netbsd32_shmctl)

struct netbsd32_shmdt_args {
	syscallarg(netbsd32_voidp) shmaddr;
};
check_syscall_args(netbsd32_shmdt)

struct netbsd32_shmget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(netbsd32_size_t) size;
	syscallarg(int) shmflg;
};
check_syscall_args(netbsd32_shmget)

struct compat_50_netbsd32_clock_gettime_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_timespec50p_t) tp;
};
check_syscall_args(compat_50_netbsd32_clock_gettime)

struct compat_50_netbsd32_clock_settime_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_timespec50p_t) tp;
};
check_syscall_args(compat_50_netbsd32_clock_settime)

struct compat_50_netbsd32_clock_getres_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_timespec50p_t) tp;
};
check_syscall_args(compat_50_netbsd32_clock_getres)

struct netbsd32_timer_create_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_sigeventp_t) evp;
	syscallarg(netbsd32_timerp_t) timerid;
};
check_syscall_args(netbsd32_timer_create)

struct netbsd32_timer_delete_args {
	syscallarg(netbsd32_timer_t) timerid;
};
check_syscall_args(netbsd32_timer_delete)

struct compat_50_netbsd32_timer_settime_args {
	syscallarg(netbsd32_timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(netbsd32_itimerspec50p_t) value;
	syscallarg(netbsd32_itimerspec50p_t) ovalue;
};
check_syscall_args(compat_50_netbsd32_timer_settime)

struct compat_50_netbsd32_timer_gettime_args {
	syscallarg(netbsd32_timer_t) timerid;
	syscallarg(netbsd32_itimerspec50p_t) value;
};
check_syscall_args(compat_50_netbsd32_timer_gettime)

struct netbsd32_timer_getoverrun_args {
	syscallarg(netbsd32_timer_t) timerid;
};
check_syscall_args(netbsd32_timer_getoverrun)

struct compat_50_netbsd32_nanosleep_args {
	syscallarg(netbsd32_timespec50p_t) rqtp;
	syscallarg(netbsd32_timespec50p_t) rmtp;
};
check_syscall_args(compat_50_netbsd32_nanosleep)

struct netbsd32_fdatasync_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_fdatasync)

struct netbsd32_mlockall_args {
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_mlockall)

struct compat_50_netbsd32___sigtimedwait_args {
	syscallarg(netbsd32_sigsetp_t) set;
	syscallarg(netbsd32_siginfop_t) info;
	syscallarg(netbsd32_timespec50p_t) timeout;
};
check_syscall_args(compat_50_netbsd32___sigtimedwait)

struct netbsd32_sigqueueinfo_args {
	syscallarg(pid_t) pid;
	syscallarg(const netbsd32_siginfop_t) info;
};
check_syscall_args(netbsd32_sigqueueinfo)

struct netbsd32_modctl_args {
	syscallarg(int) cmd;
	syscallarg(netbsd32_voidp) arg;
};
check_syscall_args(netbsd32_modctl)

struct netbsd32__ksem_init_args {
	syscallarg(unsigned int) value;
	syscallarg(netbsd32_semidp_t) idp;
};
check_syscall_args(netbsd32__ksem_init)

struct netbsd32__ksem_open_args {
	syscallarg(netbsd32_charp) name;
	syscallarg(int) oflag;
	syscallarg(mode_t) mode;
	syscallarg(unsigned int) value;
	syscallarg(netbsd32_semidp_t) idp;
};
check_syscall_args(netbsd32__ksem_open)

struct netbsd32__ksem_unlink_args {
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(netbsd32__ksem_unlink)

struct netbsd32__ksem_close_args {
	syscallarg(netbsd32_intptr_t) id;
};
check_syscall_args(netbsd32__ksem_close)

struct netbsd32__ksem_post_args {
	syscallarg(netbsd32_intptr_t) id;
};
check_syscall_args(netbsd32__ksem_post)

struct netbsd32__ksem_wait_args {
	syscallarg(netbsd32_intptr_t) id;
};
check_syscall_args(netbsd32__ksem_wait)

struct netbsd32__ksem_trywait_args {
	syscallarg(netbsd32_intptr_t) id;
};
check_syscall_args(netbsd32__ksem_trywait)

struct netbsd32__ksem_getvalue_args {
	syscallarg(netbsd32_intptr_t) id;
	syscallarg(netbsd32_intp) value;
};
check_syscall_args(netbsd32__ksem_getvalue)

struct netbsd32__ksem_destroy_args {
	syscallarg(netbsd32_intptr_t) id;
};
check_syscall_args(netbsd32__ksem_destroy)

struct netbsd32__ksem_timedwait_args {
	syscallarg(intptr_t) id;
	syscallarg(const netbsd32_timespecp_t) abstime;
};
check_syscall_args(netbsd32__ksem_timedwait)

struct netbsd32_mq_open_args {
	syscallarg(const netbsd32_charp) name;
	syscallarg(int) oflag;
	syscallarg(mode_t) mode;
	syscallarg(netbsd32_mq_attrp_t) attr;
};
check_syscall_args(netbsd32_mq_open)

struct netbsd32_mq_close_args {
	syscallarg(mqd_t) mqdes;
};
check_syscall_args(netbsd32_mq_close)

struct netbsd32_mq_unlink_args {
	syscallarg(const netbsd32_charp) name;
};
check_syscall_args(netbsd32_mq_unlink)

struct netbsd32_mq_getattr_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(netbsd32_mq_attrp_t) mqstat;
};
check_syscall_args(netbsd32_mq_getattr)

struct netbsd32_mq_setattr_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const netbsd32_mq_attrp_t) mqstat;
	syscallarg(netbsd32_mq_attrp_t) omqstat;
};
check_syscall_args(netbsd32_mq_setattr)

struct netbsd32_mq_notify_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const netbsd32_sigeventp_t) notification;
};
check_syscall_args(netbsd32_mq_notify)

struct netbsd32_mq_send_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(unsigned) msg_prio;
};
check_syscall_args(netbsd32_mq_send)

struct netbsd32_mq_receive_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(netbsd32_uintp) msg_prio;
};
check_syscall_args(netbsd32_mq_receive)

struct compat_50_netbsd32_mq_timedsend_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(unsigned) msg_prio;
	syscallarg(const netbsd32_timespec50p_t) abs_timeout;
};
check_syscall_args(compat_50_netbsd32_mq_timedsend)

struct compat_50_netbsd32_mq_timedreceive_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(netbsd32_uintp) msg_prio;
	syscallarg(const netbsd32_timespec50p_t) abs_timeout;
};
check_syscall_args(compat_50_netbsd32_mq_timedreceive)

struct netbsd32___posix_rename_args {
	syscallarg(netbsd32_charp) from;
	syscallarg(netbsd32_charp) to;
};
check_syscall_args(netbsd32___posix_rename)

struct netbsd32_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(netbsd32_voidp) arg;
	syscallarg(int) misc;
};
check_syscall_args(netbsd32_swapctl)

struct compat_30_netbsd32_getdents_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) count;
};
check_syscall_args(compat_30_netbsd32_getdents)

struct netbsd32_minherit_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) inherit;
};
check_syscall_args(netbsd32_minherit)

struct netbsd32_lchmod_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_lchmod)

struct netbsd32_lchown_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32_lchown)

struct compat_50_netbsd32_lutimes_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_timeval50p_t) tptr;
};
check_syscall_args(compat_50_netbsd32_lutimes)

struct netbsd32___msync13_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32___msync13)

struct compat_30_netbsd32___stat13_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat13p_t) ub;
};
check_syscall_args(compat_30_netbsd32___stat13)

struct compat_30_netbsd32___fstat13_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat13p_t) sb;
};
check_syscall_args(compat_30_netbsd32___fstat13)

struct compat_30_netbsd32___lstat13_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat13p_t) ub;
};
check_syscall_args(compat_30_netbsd32___lstat13)

struct netbsd32___sigaltstack14_args {
	syscallarg(netbsd32_sigaltstackp_t) nss;
	syscallarg(netbsd32_sigaltstackp_t) oss;
};
check_syscall_args(netbsd32___sigaltstack14)

struct netbsd32___posix_chown_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32___posix_chown)

struct netbsd32___posix_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32___posix_fchown)

struct netbsd32___posix_lchown_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};
check_syscall_args(netbsd32___posix_lchown)

struct netbsd32_getsid_args {
	syscallarg(pid_t) pid;
};
check_syscall_args(netbsd32_getsid)

struct netbsd32___clone_args {
	syscallarg(int) flags;
	syscallarg(netbsd32_voidp) stack;
};
check_syscall_args(netbsd32___clone)

struct netbsd32_fktrace_args {
	syscallarg(int) fd;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
check_syscall_args(netbsd32_fktrace)

struct netbsd32_preadv_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
};
check_syscall_args(netbsd32_preadv)

struct netbsd32_pwritev_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
};
check_syscall_args(netbsd32_pwritev)

struct netbsd32___sigaction14_args {
	syscallarg(int) signum;
	syscallarg(netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
};
check_syscall_args(netbsd32___sigaction14)

struct netbsd32___sigpending14_args {
	syscallarg(netbsd32_sigsetp_t) set;
};
check_syscall_args(netbsd32___sigpending14)

struct netbsd32___sigprocmask14_args {
	syscallarg(int) how;
	syscallarg(netbsd32_sigsetp_t) set;
	syscallarg(netbsd32_sigsetp_t) oset;
};
check_syscall_args(netbsd32___sigprocmask14)

struct netbsd32___sigsuspend14_args {
	syscallarg(netbsd32_sigsetp_t) set;
};
check_syscall_args(netbsd32___sigsuspend14)

struct compat_16_netbsd32___sigreturn14_args {
	syscallarg(netbsd32_sigcontextp_t) sigcntxp;
};
check_syscall_args(compat_16_netbsd32___sigreturn14)

struct netbsd32___getcwd_args {
	syscallarg(netbsd32_charp) bufp;
	syscallarg(netbsd32_size_t) length;
};
check_syscall_args(netbsd32___getcwd)

struct netbsd32_fchroot_args {
	syscallarg(int) fd;
};
check_syscall_args(netbsd32_fchroot)

struct compat_30_netbsd32_fhopen_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(int) flags;
};
check_syscall_args(compat_30_netbsd32_fhopen)

struct compat_30_netbsd32_fhstat_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_stat13p_t) sb;
};
check_syscall_args(compat_30_netbsd32_fhstat)

struct compat_20_netbsd32_fhstatfs_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_stat50p_t) buf;
};
check_syscall_args(compat_20_netbsd32_fhstatfs)

struct compat_50_netbsd32___semctl14_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(netbsd32_semun50p_t) arg;
};
check_syscall_args(compat_50_netbsd32___semctl14)

struct compat_50_netbsd32___msgctl13_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_msqid_ds50p_t) buf;
};
check_syscall_args(compat_50_netbsd32___msgctl13)

struct compat_50_netbsd32___shmctl13_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_shmid_ds50p_t) buf;
};
check_syscall_args(compat_50_netbsd32___shmctl13)

struct netbsd32_lchflags_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_u_long) flags;
};
check_syscall_args(netbsd32_lchflags)

struct netbsd32_utrace_args {
	syscallarg(netbsd32_charp) label;
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(netbsd32_utrace)

struct netbsd32_getcontext_args {
	syscallarg(netbsd32_ucontextp) ucp;
};
check_syscall_args(netbsd32_getcontext)

struct netbsd32_setcontext_args {
	syscallarg(netbsd32_ucontextp) ucp;
};
check_syscall_args(netbsd32_setcontext)

struct netbsd32__lwp_create_args {
	syscallarg(netbsd32_ucontextp) ucp;
	syscallarg(netbsd32_u_long) flags;
	syscallarg(netbsd32_lwpidp) new_lwp;
};
check_syscall_args(netbsd32__lwp_create)

struct netbsd32__lwp_wait_args {
	syscallarg(lwpid_t) wait_for;
	syscallarg(netbsd32_lwpidp) departed;
};
check_syscall_args(netbsd32__lwp_wait)

struct netbsd32__lwp_suspend_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(netbsd32__lwp_suspend)

struct netbsd32__lwp_continue_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(netbsd32__lwp_continue)

struct netbsd32__lwp_wakeup_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(netbsd32__lwp_wakeup)

struct netbsd32__lwp_setprivate_args {
	syscallarg(netbsd32_voidp) ptr;
};
check_syscall_args(netbsd32__lwp_setprivate)

struct netbsd32__lwp_kill_args {
	syscallarg(lwpid_t) target;
	syscallarg(int) signo;
};
check_syscall_args(netbsd32__lwp_kill)

struct netbsd32__lwp_detach_args {
	syscallarg(lwpid_t) target;
};
check_syscall_args(netbsd32__lwp_detach)

struct compat_50_netbsd32__lwp_park_args {
	syscallarg(netbsd32_timespec50p_t) ts;
	syscallarg(lwpid_t) unpark;
	syscallarg(netbsd32_voidp) hint;
	syscallarg(netbsd32_voidp) unparkhint;
};
check_syscall_args(compat_50_netbsd32__lwp_park)

struct netbsd32__lwp_unpark_args {
	syscallarg(lwpid_t) target;
	syscallarg(netbsd32_voidp) hint;
};
check_syscall_args(netbsd32__lwp_unpark)

struct netbsd32__lwp_unpark_all_args {
	syscallarg(netbsd32_lwpidp) targets;
	syscallarg(netbsd32_size_t) ntargets;
	syscallarg(netbsd32_voidp) hint;
};
check_syscall_args(netbsd32__lwp_unpark_all)

struct netbsd32__lwp_setname_args {
	syscallarg(lwpid_t) target;
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(netbsd32__lwp_setname)

struct netbsd32__lwp_getname_args {
	syscallarg(lwpid_t) target;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_size_t) len;
};
check_syscall_args(netbsd32__lwp_getname)

struct netbsd32__lwp_ctl_args {
	syscallarg(int) features;
	syscallarg(netbsd32_pointer_t) address;
};
check_syscall_args(netbsd32__lwp_ctl)

struct netbsd32___sigaction_sigtramp_args {
	syscallarg(int) signum;
	syscallarg(netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
	syscallarg(netbsd32_voidp) tramp;
	syscallarg(int) vers;
};
check_syscall_args(netbsd32___sigaction_sigtramp)

struct netbsd32_rasctl_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) op;
};
check_syscall_args(netbsd32_rasctl)

struct compat_50_netbsd32_kevent_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_keventp_t) changelist;
	syscallarg(netbsd32_size_t) nchanges;
	syscallarg(netbsd32_keventp_t) eventlist;
	syscallarg(netbsd32_size_t) nevents;
	syscallarg(netbsd32_timespec50p_t) timeout;
};
check_syscall_args(compat_50_netbsd32_kevent)

struct netbsd32__sched_setparam_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(int) policy;
	syscallarg(const netbsd32_sched_paramp_t) params;
};
check_syscall_args(netbsd32__sched_setparam)

struct netbsd32__sched_getparam_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(netbsd32_intp) policy;
	syscallarg(netbsd32_sched_paramp_t) params;
};
check_syscall_args(netbsd32__sched_getparam)

struct netbsd32__sched_setaffinity_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(netbsd32_size_t) size;
	syscallarg(const netbsd32_cpusetp_t) cpuset;
};
check_syscall_args(netbsd32__sched_setaffinity)

struct netbsd32__sched_getaffinity_args {
	syscallarg(pid_t) pid;
	syscallarg(lwpid_t) lid;
	syscallarg(netbsd32_size_t) size;
	syscallarg(netbsd32_cpusetp_t) cpuset;
};
check_syscall_args(netbsd32__sched_getaffinity)

struct netbsd32__sched_protect_args {
	syscallarg(int) priority;
};
check_syscall_args(netbsd32__sched_protect)

struct netbsd32_fsync_range_args {
	syscallarg(int) fd;
	syscallarg(int) flags;
	syscallarg(netbsd32_off_t) start;
	syscallarg(netbsd32_off_t) length;
};
check_syscall_args(netbsd32_fsync_range)

struct netbsd32_uuidgen_args {
	syscallarg(netbsd32_uuidp_t) store;
	syscallarg(int) count;
};
check_syscall_args(netbsd32_uuidgen)

struct netbsd32_getvfsstat_args {
	syscallarg(netbsd32_statvfsp_t) buf;
	syscallarg(netbsd32_size_t) bufsize;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_getvfsstat)

struct netbsd32_statvfs1_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_statvfsp_t) buf;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_statvfs1)

struct netbsd32_fstatvfs1_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_statvfsp_t) buf;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_fstatvfs1)

struct compat_30_netbsd32_fhstatvfs1_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_statvfsp_t) buf;
	syscallarg(int) flags;
};
check_syscall_args(compat_30_netbsd32_fhstatvfs1)

struct netbsd32_extattrctl_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) cmd;
	syscallarg(netbsd32_charp) filename;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
};
check_syscall_args(netbsd32_extattrctl)

struct netbsd32_extattr_set_file_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_set_file)

struct netbsd32_extattr_get_file_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_get_file)

struct netbsd32_extattr_delete_file_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
};
check_syscall_args(netbsd32_extattr_delete_file)

struct netbsd32_extattr_set_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_set_fd)

struct netbsd32_extattr_get_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_get_fd)

struct netbsd32_extattr_delete_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
};
check_syscall_args(netbsd32_extattr_delete_fd)

struct netbsd32_extattr_set_link_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_set_link)

struct netbsd32_extattr_get_link_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_get_link)

struct netbsd32_extattr_delete_link_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_charp) attrname;
};
check_syscall_args(netbsd32_extattr_delete_link)

struct netbsd32_extattr_list_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_list_fd)

struct netbsd32_extattr_list_file_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_list_file)

struct netbsd32_extattr_list_link_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(int) attrnamespace;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) nbytes;
};
check_syscall_args(netbsd32_extattr_list_link)

struct compat_50_netbsd32_pselect_args {
	syscallarg(int) nd;
	syscallarg(netbsd32_fd_setp_t) in;
	syscallarg(netbsd32_fd_setp_t) ou;
	syscallarg(netbsd32_fd_setp_t) ex;
	syscallarg(netbsd32_timespec50p_t) ts;
	syscallarg(netbsd32_sigsetp_t) mask;
};
check_syscall_args(compat_50_netbsd32_pselect)

struct compat_50_netbsd32_pollts_args {
	syscallarg(netbsd32_pollfdp_t) fds;
	syscallarg(u_int) nfds;
	syscallarg(netbsd32_timespec50p_t) ts;
	syscallarg(netbsd32_sigsetp_t) mask;
};
check_syscall_args(compat_50_netbsd32_pollts)

struct netbsd32_setxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_setxattr)

struct netbsd32_lsetxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_lsetxattr)

struct netbsd32_fsetxattr_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_fsetxattr)

struct netbsd32_getxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_getxattr)

struct netbsd32_lgetxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_lgetxattr)

struct netbsd32_fgetxattr_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) name;
	syscallarg(netbsd32_voidp) value;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_fgetxattr)

struct netbsd32_listxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) list;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_listxattr)

struct netbsd32_llistxattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) list;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_llistxattr)

struct netbsd32_flistxattr_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) list;
	syscallarg(netbsd32_size_t) size;
};
check_syscall_args(netbsd32_flistxattr)

struct netbsd32_removexattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(netbsd32_removexattr)

struct netbsd32_lremovexattr_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(netbsd32_lremovexattr)

struct netbsd32_fremovexattr_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) name;
};
check_syscall_args(netbsd32_fremovexattr)

struct compat_50_netbsd32___stat30_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat50p_t) ub;
};
check_syscall_args(compat_50_netbsd32___stat30)

struct compat_50_netbsd32___fstat30_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat50p_t) sb;
};
check_syscall_args(compat_50_netbsd32___fstat30)

struct compat_50_netbsd32___lstat30_args {
	syscallarg(netbsd32_charp) path;
	syscallarg(netbsd32_stat50p_t) ub;
};
check_syscall_args(compat_50_netbsd32___lstat30)

struct netbsd32___getdents30_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) count;
};
check_syscall_args(netbsd32___getdents30)

struct compat_30_netbsd32___fhstat30_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_stat50p_t) sb;
};
check_syscall_args(compat_30_netbsd32___fhstat30)
#if defined(NTP) || !defined(_KERNEL_OPT)

struct compat_50_netbsd32_ntp_gettime_args {
	syscallarg(netbsd32_ntptimeval50p_t) ntvp;
};
check_syscall_args(compat_50_netbsd32_ntp_gettime)
#else
#endif

struct netbsd32___socket30_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};
check_syscall_args(netbsd32___socket30)

struct netbsd32___getfh30_args {
	syscallarg(netbsd32_charp) fname;
	syscallarg(netbsd32_pointer_t) fhp;
	syscallarg(netbsd32_size_tp) fh_size;
};
check_syscall_args(netbsd32___getfh30)

struct netbsd32___fhopen40_args {
	syscallarg(netbsd32_pointer_t) fhp;
	syscallarg(netbsd32_size_t) fh_size;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32___fhopen40)

struct netbsd32___fhstatvfs140_args {
	syscallarg(netbsd32_pointer_t) fhp;
	syscallarg(netbsd32_size_t) fh_size;
	syscallarg(netbsd32_statvfsp_t) buf;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32___fhstatvfs140)

struct compat_50_netbsd32___fhstat40_args {
	syscallarg(netbsd32_pointer_t) fhp;
	syscallarg(netbsd32_size_t) fh_size;
	syscallarg(netbsd32_stat50p_t) sb;
};
check_syscall_args(compat_50_netbsd32___fhstat40)

struct netbsd32___mount50_args {
	syscallarg(netbsd32_charp) type;
	syscallarg(netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(netbsd32_voidp) data;
	syscallarg(netbsd32_size_t) data_len;
};
check_syscall_args(netbsd32___mount50)

struct netbsd32_mremap_args {
	syscallarg(netbsd32_voidp) old_address;
	syscallarg(netbsd32_size_t) old_size;
	syscallarg(netbsd32_voidp) new_address;
	syscallarg(netbsd32_size_t) new_size;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_mremap)

struct netbsd32_pset_create_args {
	syscallarg(netbsd32_psetidp_t) psid;
};
check_syscall_args(netbsd32_pset_create)

struct netbsd32_pset_destroy_args {
	syscallarg(psetid_t) psid;
};
check_syscall_args(netbsd32_pset_destroy)

struct netbsd32_pset_assign_args {
	syscallarg(psetid_t) psid;
	syscallarg(cpuid_t) cpuid;
	syscallarg(netbsd32_psetidp_t) opsid;
};
check_syscall_args(netbsd32_pset_assign)

struct netbsd32__pset_bind_args {
	syscallarg(idtype_t) idtype;
	syscallarg(id_t) first_id;
	syscallarg(id_t) second_id;
	syscallarg(psetid_t) psid;
	syscallarg(netbsd32_psetidp_t) opsid;
};
check_syscall_args(netbsd32__pset_bind)

struct netbsd32___posix_fadvise50_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) offset;
	syscallarg(netbsd32_off_t) len;
	syscallarg(int) advice;
};
check_syscall_args(netbsd32___posix_fadvise50)

struct netbsd32___select50_args {
	syscallarg(int) nd;
	syscallarg(netbsd32_fd_setp_t) in;
	syscallarg(netbsd32_fd_setp_t) ou;
	syscallarg(netbsd32_fd_setp_t) ex;
	syscallarg(netbsd32_timevalp_t) tv;
};
check_syscall_args(netbsd32___select50)

struct netbsd32___gettimeofday50_args {
	syscallarg(netbsd32_timevalp_t) tp;
	syscallarg(netbsd32_voidp) tzp;
};
check_syscall_args(netbsd32___gettimeofday50)

struct netbsd32___settimeofday50_args {
	syscallarg(const netbsd32_timevalp_t) tv;
	syscallarg(const netbsd32_voidp) tzp;
};
check_syscall_args(netbsd32___settimeofday50)

struct netbsd32___utimes50_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_timevalp_t) tptr;
};
check_syscall_args(netbsd32___utimes50)

struct netbsd32___adjtime50_args {
	syscallarg(const netbsd32_timevalp_t) delta;
	syscallarg(netbsd32_timevalp_t) olddelta;
};
check_syscall_args(netbsd32___adjtime50)

struct netbsd32___futimes50_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_timevalp_t) tptr;
};
check_syscall_args(netbsd32___futimes50)

struct netbsd32___lutimes50_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_timevalp_t) tptr;
};
check_syscall_args(netbsd32___lutimes50)

struct netbsd32___setitimer50_args {
	syscallarg(int) which;
	syscallarg(const netbsd32_itimervalp_t) itv;
	syscallarg(netbsd32_itimervalp_t) oitv;
};
check_syscall_args(netbsd32___setitimer50)

struct netbsd32___getitimer50_args {
	syscallarg(int) which;
	syscallarg(netbsd32_itimervalp_t) itv;
};
check_syscall_args(netbsd32___getitimer50)

struct netbsd32___clock_gettime50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(netbsd32_timespecp_t) tp;
};
check_syscall_args(netbsd32___clock_gettime50)

struct netbsd32___clock_settime50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const netbsd32_timespecp_t) tp;
};
check_syscall_args(netbsd32___clock_settime50)

struct netbsd32___clock_getres50_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(netbsd32_timespecp_t) tp;
};
check_syscall_args(netbsd32___clock_getres50)

struct netbsd32___nanosleep50_args {
	syscallarg(const netbsd32_timespecp_t) rqtp;
	syscallarg(netbsd32_timespecp_t) rmtp;
};
check_syscall_args(netbsd32___nanosleep50)

struct netbsd32_____sigtimedwait50_args {
	syscallarg(const netbsd32_sigsetp_t) set;
	syscallarg(netbsd32_siginfop_t) info;
	syscallarg(netbsd32_timespecp_t) timeout;
};
check_syscall_args(netbsd32_____sigtimedwait50)

struct netbsd32___mq_timedsend50_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(const netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(unsigned) msg_prio;
	syscallarg(const netbsd32_timespecp_t) abs_timeout;
};
check_syscall_args(netbsd32___mq_timedsend50)

struct netbsd32___mq_timedreceive50_args {
	syscallarg(mqd_t) mqdes;
	syscallarg(netbsd32_charp) msg_ptr;
	syscallarg(netbsd32_size_t) msg_len;
	syscallarg(netbsd32_uintp) msg_prio;
	syscallarg(const netbsd32_timespecp_t) abs_timeout;
};
check_syscall_args(netbsd32___mq_timedreceive50)

struct compat_60_netbsd32__lwp_park_args {
	syscallarg(const netbsd32_timespecp_t) ts;
	syscallarg(lwpid_t) unpark;
	syscallarg(const netbsd32_voidp) hint;
	syscallarg(const netbsd32_voidp) unparkhint;
};
check_syscall_args(compat_60_netbsd32__lwp_park)

struct netbsd32___kevent50_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_keventp_t) changelist;
	syscallarg(netbsd32_size_t) nchanges;
	syscallarg(netbsd32_keventp_t) eventlist;
	syscallarg(netbsd32_size_t) nevents;
	syscallarg(const netbsd32_timespecp_t) timeout;
};
check_syscall_args(netbsd32___kevent50)

struct netbsd32___pselect50_args {
	syscallarg(int) nd;
	syscallarg(netbsd32_fd_setp_t) in;
	syscallarg(netbsd32_fd_setp_t) ou;
	syscallarg(netbsd32_fd_setp_t) ex;
	syscallarg(const netbsd32_timespecp_t) ts;
	syscallarg(const netbsd32_sigsetp_t) mask;
};
check_syscall_args(netbsd32___pselect50)

struct netbsd32___pollts50_args {
	syscallarg(netbsd32_pollfdp_t) fds;
	syscallarg(u_int) nfds;
	syscallarg(const netbsd32_timespecp_t) ts;
	syscallarg(const netbsd32_sigsetp_t) mask;
};
check_syscall_args(netbsd32___pollts50)

struct netbsd32___stat50_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statp_t) ub;
};
check_syscall_args(netbsd32___stat50)

struct netbsd32___fstat50_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_statp_t) sb;
};
check_syscall_args(netbsd32___fstat50)

struct netbsd32___lstat50_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statp_t) ub;
};
check_syscall_args(netbsd32___lstat50)

struct netbsd32_____semctl50_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(netbsd32_semunp_t) arg;
};
check_syscall_args(netbsd32_____semctl50)

struct netbsd32___shmctl50_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_shmid_dsp_t) buf;
};
check_syscall_args(netbsd32___shmctl50)

struct netbsd32___msgctl50_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_msqid_dsp_t) buf;
};
check_syscall_args(netbsd32___msgctl50)

struct netbsd32___getrusage50_args {
	syscallarg(int) who;
	syscallarg(netbsd32_rusagep_t) rusage;
};
check_syscall_args(netbsd32___getrusage50)

struct netbsd32___timer_settime50_args {
	syscallarg(timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(const netbsd32_itimerspecp_t) value;
	syscallarg(netbsd32_itimerspecp_t) ovalue;
};
check_syscall_args(netbsd32___timer_settime50)

struct netbsd32___timer_gettime50_args {
	syscallarg(timer_t) timerid;
	syscallarg(netbsd32_itimerspecp_t) value;
};
check_syscall_args(netbsd32___timer_gettime50)
#if defined(NTP) || !defined(_KERNEL_OPT)

struct netbsd32___ntp_gettime50_args {
	syscallarg(netbsd32_ntptimevalp_t) ntvp;
};
check_syscall_args(netbsd32___ntp_gettime50)
#else
#endif

struct netbsd32___wait450_args {
	syscallarg(int) pid;
	syscallarg(netbsd32_intp) status;
	syscallarg(int) options;
	syscallarg(netbsd32_rusagep_t) rusage;
};
check_syscall_args(netbsd32___wait450)

struct netbsd32___mknod50_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
	syscallarg(netbsd32_dev_t) dev;
};
check_syscall_args(netbsd32___mknod50)

struct netbsd32___fhstat50_args {
	syscallarg(const netbsd32_voidp) fhp;
	syscallarg(netbsd32_size_t) fh_size;
	syscallarg(netbsd32_statp_t) sb;
};
check_syscall_args(netbsd32___fhstat50)

struct netbsd32_pipe2_args {
	syscallarg(netbsd32_intp) fildes;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_pipe2)

struct netbsd32_dup3_args {
	syscallarg(int) from;
	syscallarg(int) to;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_dup3)

struct netbsd32_kqueue1_args {
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_kqueue1)

struct netbsd32_paccept_args {
	syscallarg(int) s;
	syscallarg(netbsd32_sockaddrp_t) name;
	syscallarg(netbsd32_socklenp_t) anamelen;
	syscallarg(const netbsd32_sigsetp_t) mask;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_paccept)

struct netbsd32_linkat_args {
	syscallarg(int) fd1;
	syscallarg(const netbsd32_charp) name1;
	syscallarg(int) fd2;
	syscallarg(const netbsd32_charp) name2;
	syscallarg(int) flags;
};
check_syscall_args(netbsd32_linkat)

struct netbsd32_renameat_args {
	syscallarg(int) fromfd;
	syscallarg(const netbsd32_charp) from;
	syscallarg(int) tofd;
	syscallarg(const netbsd32_charp) to;
};
check_syscall_args(netbsd32_renameat)

struct netbsd32_mkfifoat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_mkfifoat)

struct netbsd32_mknodat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
	syscallarg(int) PAD;
	syscallarg(netbsd32_dev_t) dev;
};
check_syscall_args(netbsd32_mknodat)

struct netbsd32_mkdirat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_mkdirat)

struct netbsd32_faccessat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) amode;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_faccessat)

struct netbsd32_fchmodat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_fchmodat)

struct netbsd32_fchownat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(uid_t) owner;
	syscallarg(gid_t) group;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_fchownat)

struct netbsd32_fexecve_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charpp) argp;
	syscallarg(netbsd32_charpp) envp;
};
check_syscall_args(netbsd32_fexecve)

struct netbsd32_fstatat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statp_t) buf;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_fstatat)

struct netbsd32_utimensat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_timespecp_t) tptr;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_utimensat)

struct netbsd32_openat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) oflags;
	syscallarg(mode_t) mode;
};
check_syscall_args(netbsd32_openat)

struct netbsd32_readlinkat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) bufsize;
};
check_syscall_args(netbsd32_readlinkat)

struct netbsd32_symlinkat_args {
	syscallarg(const netbsd32_charp) path1;
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path2;
};
check_syscall_args(netbsd32_symlinkat)

struct netbsd32_unlinkat_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) flag;
};
check_syscall_args(netbsd32_unlinkat)

struct netbsd32_futimens_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_timespecp_t) tptr;
};
check_syscall_args(netbsd32_futimens)

struct netbsd32___quotactl_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_voidp) args;
};
check_syscall_args(netbsd32___quotactl)

struct netbsd32_posix_spawn_args {
	syscallarg(netbsd32_pid_tp) pid;
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_posix_spawn_file_actionsp) file_actions;
	syscallarg(const netbsd32_posix_spawnattrp) attrp;
	syscallarg(netbsd32_charpp) argv;
	syscallarg(netbsd32_charpp) envp;
};
check_syscall_args(netbsd32_posix_spawn)

struct netbsd32_clock_nanosleep_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(int) flags;
	syscallarg(const netbsd32_timespecp_t) rqtp;
	syscallarg(netbsd32_timespecp_t) rmtp;
};
check_syscall_args(netbsd32_clock_nanosleep)

struct netbsd32____lwp_park60_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(int) flags;
	syscallarg(const netbsd32_timespecp_t) ts;
	syscallarg(lwpid_t) unpark;
	syscallarg(netbsd32_voidp) hint;
	syscallarg(netbsd32_voidp) unparkhint;
};
check_syscall_args(netbsd32____lwp_park60)

struct netbsd32_posix_fallocate_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) pos;
	syscallarg(netbsd32_off_t) len;
};
check_syscall_args(netbsd32_posix_fallocate)

struct netbsd32_fdiscard_args {
	syscallarg(int) fd;
	syscallarg(int) PAD;
	syscallarg(netbsd32_off_t) pos;
	syscallarg(netbsd32_off_t) len;
};
check_syscall_args(netbsd32_fdiscard)

struct netbsd32_wait6_args {
	syscallarg(idtype_t) idtype;
	syscallarg(id_t) id;
	syscallarg(netbsd32_intp) status;
	syscallarg(int) options;
	syscallarg(netbsd32_wrusagep_t) wru;
	syscallarg(netbsd32_siginfop_t) info;
};
check_syscall_args(netbsd32_wait6)

struct netbsd32_clock_getcpuclockid2_args {
	syscallarg(idtype_t) idtype;
	syscallarg(id_t) id;
	syscallarg(netbsd32_clockidp_t) clock_id;
};
check_syscall_args(netbsd32_clock_getcpuclockid2)

/*
 * System call prototypes.
 */

int	netbsd32_syscall(struct lwp *, const struct netbsd32_syscall_args *, register_t *);

int	netbsd32_exit(struct lwp *, const struct netbsd32_exit_args *, register_t *);

int	sys_fork(struct lwp *, const void *, register_t *);

int	netbsd32_read(struct lwp *, const struct netbsd32_read_args *, register_t *);

int	netbsd32_write(struct lwp *, const struct netbsd32_write_args *, register_t *);

int	netbsd32_open(struct lwp *, const struct netbsd32_open_args *, register_t *);

int	netbsd32_close(struct lwp *, const struct netbsd32_close_args *, register_t *);

int	compat_50_netbsd32_wait4(struct lwp *, const struct compat_50_netbsd32_wait4_args *, register_t *);

int	compat_43_netbsd32_ocreat(struct lwp *, const struct compat_43_netbsd32_ocreat_args *, register_t *);

int	netbsd32_link(struct lwp *, const struct netbsd32_link_args *, register_t *);

int	netbsd32_unlink(struct lwp *, const struct netbsd32_unlink_args *, register_t *);

int	netbsd32_chdir(struct lwp *, const struct netbsd32_chdir_args *, register_t *);

int	netbsd32_fchdir(struct lwp *, const struct netbsd32_fchdir_args *, register_t *);

int	compat_50_netbsd32_mknod(struct lwp *, const struct compat_50_netbsd32_mknod_args *, register_t *);

int	netbsd32_chmod(struct lwp *, const struct netbsd32_chmod_args *, register_t *);

int	netbsd32_chown(struct lwp *, const struct netbsd32_chown_args *, register_t *);

int	netbsd32_break(struct lwp *, const struct netbsd32_break_args *, register_t *);

int	compat_20_netbsd32_getfsstat(struct lwp *, const struct compat_20_netbsd32_getfsstat_args *, register_t *);

int	compat_43_netbsd32_olseek(struct lwp *, const struct compat_43_netbsd32_olseek_args *, register_t *);

int	sys_getpid(struct lwp *, const void *, register_t *);

int	netbsd32_mount(struct lwp *, const struct netbsd32_mount_args *, register_t *);

int	netbsd32_unmount(struct lwp *, const struct netbsd32_unmount_args *, register_t *);

int	netbsd32_setuid(struct lwp *, const struct netbsd32_setuid_args *, register_t *);

int	sys_getuid(struct lwp *, const void *, register_t *);

int	sys_geteuid(struct lwp *, const void *, register_t *);

int	netbsd32_ptrace(struct lwp *, const struct netbsd32_ptrace_args *, register_t *);

int	netbsd32_recvmsg(struct lwp *, const struct netbsd32_recvmsg_args *, register_t *);

int	netbsd32_sendmsg(struct lwp *, const struct netbsd32_sendmsg_args *, register_t *);

int	netbsd32_recvfrom(struct lwp *, const struct netbsd32_recvfrom_args *, register_t *);

int	netbsd32_accept(struct lwp *, const struct netbsd32_accept_args *, register_t *);

int	netbsd32_getpeername(struct lwp *, const struct netbsd32_getpeername_args *, register_t *);

int	netbsd32_getsockname(struct lwp *, const struct netbsd32_getsockname_args *, register_t *);

int	netbsd32_access(struct lwp *, const struct netbsd32_access_args *, register_t *);

int	netbsd32_chflags(struct lwp *, const struct netbsd32_chflags_args *, register_t *);

int	netbsd32_fchflags(struct lwp *, const struct netbsd32_fchflags_args *, register_t *);

int	sys_sync(struct lwp *, const void *, register_t *);

int	netbsd32_kill(struct lwp *, const struct netbsd32_kill_args *, register_t *);

int	compat_43_netbsd32_stat43(struct lwp *, const struct compat_43_netbsd32_stat43_args *, register_t *);

int	sys_getppid(struct lwp *, const void *, register_t *);

int	compat_43_netbsd32_lstat43(struct lwp *, const struct compat_43_netbsd32_lstat43_args *, register_t *);

int	netbsd32_dup(struct lwp *, const struct netbsd32_dup_args *, register_t *);

int	sys_pipe(struct lwp *, const void *, register_t *);

int	sys_getegid(struct lwp *, const void *, register_t *);

int	netbsd32_profil(struct lwp *, const struct netbsd32_profil_args *, register_t *);

int	netbsd32_ktrace(struct lwp *, const struct netbsd32_ktrace_args *, register_t *);

int	netbsd32_sigaction(struct lwp *, const struct netbsd32_sigaction_args *, register_t *);

int	sys_getgid(struct lwp *, const void *, register_t *);

int	compat_13_netbsd32_sigprocmask(struct lwp *, const struct compat_13_netbsd32_sigprocmask_args *, register_t *);

int	netbsd32___getlogin(struct lwp *, const struct netbsd32___getlogin_args *, register_t *);

int	netbsd32_setlogin(struct lwp *, const struct netbsd32_setlogin_args *, register_t *);

int	netbsd32_acct(struct lwp *, const struct netbsd32_acct_args *, register_t *);

int	compat_13_sys_sigpending(struct lwp *, const void *, register_t *);

int	compat_13_netbsd32_sigaltstack13(struct lwp *, const struct compat_13_netbsd32_sigaltstack13_args *, register_t *);

int	netbsd32_ioctl(struct lwp *, const struct netbsd32_ioctl_args *, register_t *);

int	compat_12_netbsd32_reboot(struct lwp *, const struct compat_12_netbsd32_reboot_args *, register_t *);

int	netbsd32_revoke(struct lwp *, const struct netbsd32_revoke_args *, register_t *);

int	netbsd32_symlink(struct lwp *, const struct netbsd32_symlink_args *, register_t *);

int	netbsd32_readlink(struct lwp *, const struct netbsd32_readlink_args *, register_t *);

int	netbsd32_execve(struct lwp *, const struct netbsd32_execve_args *, register_t *);

int	netbsd32_umask(struct lwp *, const struct netbsd32_umask_args *, register_t *);

int	netbsd32_chroot(struct lwp *, const struct netbsd32_chroot_args *, register_t *);

int	compat_43_netbsd32_fstat43(struct lwp *, const struct compat_43_netbsd32_fstat43_args *, register_t *);

int	compat_43_netbsd32_ogetkerninfo(struct lwp *, const struct compat_43_netbsd32_ogetkerninfo_args *, register_t *);

int	compat_43_sys_getpagesize(struct lwp *, const void *, register_t *);

int	compat_12_netbsd32_msync(struct lwp *, const struct compat_12_netbsd32_msync_args *, register_t *);

int	sys_vfork(struct lwp *, const void *, register_t *);

int	netbsd32_sbrk(struct lwp *, const struct netbsd32_sbrk_args *, register_t *);

int	netbsd32_sstk(struct lwp *, const struct netbsd32_sstk_args *, register_t *);

int	compat_43_netbsd32_ommap(struct lwp *, const struct compat_43_netbsd32_ommap_args *, register_t *);

int	netbsd32_ovadvise(struct lwp *, const struct netbsd32_ovadvise_args *, register_t *);

int	netbsd32_munmap(struct lwp *, const struct netbsd32_munmap_args *, register_t *);

int	netbsd32_mprotect(struct lwp *, const struct netbsd32_mprotect_args *, register_t *);

int	netbsd32_madvise(struct lwp *, const struct netbsd32_madvise_args *, register_t *);

int	netbsd32_mincore(struct lwp *, const struct netbsd32_mincore_args *, register_t *);

int	netbsd32_getgroups(struct lwp *, const struct netbsd32_getgroups_args *, register_t *);

int	netbsd32_setgroups(struct lwp *, const struct netbsd32_setgroups_args *, register_t *);

int	sys_getpgrp(struct lwp *, const void *, register_t *);

int	netbsd32_setpgid(struct lwp *, const struct netbsd32_setpgid_args *, register_t *);

int	compat_50_netbsd32_setitimer(struct lwp *, const struct compat_50_netbsd32_setitimer_args *, register_t *);

int	compat_43_sys_wait(struct lwp *, const void *, register_t *);

int	compat_12_netbsd32_oswapon(struct lwp *, const struct compat_12_netbsd32_oswapon_args *, register_t *);

int	compat_50_netbsd32_getitimer(struct lwp *, const struct compat_50_netbsd32_getitimer_args *, register_t *);

int	compat_43_netbsd32_ogethostname(struct lwp *, const struct compat_43_netbsd32_ogethostname_args *, register_t *);

int	compat_43_netbsd32_osethostname(struct lwp *, const struct compat_43_netbsd32_osethostname_args *, register_t *);

int	compat_43_sys_getdtablesize(struct lwp *, const void *, register_t *);

int	netbsd32_dup2(struct lwp *, const struct netbsd32_dup2_args *, register_t *);

int	netbsd32_fcntl(struct lwp *, const struct netbsd32_fcntl_args *, register_t *);

int	compat_50_netbsd32_select(struct lwp *, const struct compat_50_netbsd32_select_args *, register_t *);

int	netbsd32_fsync(struct lwp *, const struct netbsd32_fsync_args *, register_t *);

int	netbsd32_setpriority(struct lwp *, const struct netbsd32_setpriority_args *, register_t *);

int	compat_30_netbsd32_socket(struct lwp *, const struct compat_30_netbsd32_socket_args *, register_t *);

int	netbsd32_connect(struct lwp *, const struct netbsd32_connect_args *, register_t *);

int	compat_43_netbsd32_oaccept(struct lwp *, const struct compat_43_netbsd32_oaccept_args *, register_t *);

int	netbsd32_getpriority(struct lwp *, const struct netbsd32_getpriority_args *, register_t *);

int	compat_43_netbsd32_osend(struct lwp *, const struct compat_43_netbsd32_osend_args *, register_t *);

int	compat_43_netbsd32_orecv(struct lwp *, const struct compat_43_netbsd32_orecv_args *, register_t *);

int	compat_13_netbsd32_sigreturn(struct lwp *, const struct compat_13_netbsd32_sigreturn_args *, register_t *);

int	netbsd32_bind(struct lwp *, const struct netbsd32_bind_args *, register_t *);

int	netbsd32_setsockopt(struct lwp *, const struct netbsd32_setsockopt_args *, register_t *);

int	netbsd32_listen(struct lwp *, const struct netbsd32_listen_args *, register_t *);

int	compat_43_netbsd32_osigvec(struct lwp *, const struct compat_43_netbsd32_osigvec_args *, register_t *);

int	compat_43_netbsd32_sigblock(struct lwp *, const struct compat_43_netbsd32_sigblock_args *, register_t *);

int	compat_43_netbsd32_sigsetmask(struct lwp *, const struct compat_43_netbsd32_sigsetmask_args *, register_t *);

int	compat_13_netbsd32_sigsuspend(struct lwp *, const struct compat_13_netbsd32_sigsuspend_args *, register_t *);

int	compat_43_netbsd32_osigstack(struct lwp *, const struct compat_43_netbsd32_osigstack_args *, register_t *);

int	compat_43_netbsd32_orecvmsg(struct lwp *, const struct compat_43_netbsd32_orecvmsg_args *, register_t *);

int	compat_43_netbsd32_osendmsg(struct lwp *, const struct compat_43_netbsd32_osendmsg_args *, register_t *);

int	compat_50_netbsd32_gettimeofday(struct lwp *, const struct compat_50_netbsd32_gettimeofday_args *, register_t *);

int	compat_50_netbsd32_getrusage(struct lwp *, const struct compat_50_netbsd32_getrusage_args *, register_t *);

int	netbsd32_getsockopt(struct lwp *, const struct netbsd32_getsockopt_args *, register_t *);

int	netbsd32_readv(struct lwp *, const struct netbsd32_readv_args *, register_t *);

int	netbsd32_writev(struct lwp *, const struct netbsd32_writev_args *, register_t *);

int	compat_50_netbsd32_settimeofday(struct lwp *, const struct compat_50_netbsd32_settimeofday_args *, register_t *);

int	netbsd32_fchown(struct lwp *, const struct netbsd32_fchown_args *, register_t *);

int	netbsd32_fchmod(struct lwp *, const struct netbsd32_fchmod_args *, register_t *);

int	compat_43_netbsd32_orecvfrom(struct lwp *, const struct compat_43_netbsd32_orecvfrom_args *, register_t *);

int	netbsd32_setreuid(struct lwp *, const struct netbsd32_setreuid_args *, register_t *);

int	netbsd32_setregid(struct lwp *, const struct netbsd32_setregid_args *, register_t *);

int	netbsd32_rename(struct lwp *, const struct netbsd32_rename_args *, register_t *);

int	compat_43_netbsd32_otruncate(struct lwp *, const struct compat_43_netbsd32_otruncate_args *, register_t *);

int	compat_43_netbsd32_oftruncate(struct lwp *, const struct compat_43_netbsd32_oftruncate_args *, register_t *);

int	netbsd32_flock(struct lwp *, const struct netbsd32_flock_args *, register_t *);

int	netbsd32_mkfifo(struct lwp *, const struct netbsd32_mkfifo_args *, register_t *);

int	netbsd32_sendto(struct lwp *, const struct netbsd32_sendto_args *, register_t *);

int	netbsd32_shutdown(struct lwp *, const struct netbsd32_shutdown_args *, register_t *);

int	netbsd32_socketpair(struct lwp *, const struct netbsd32_socketpair_args *, register_t *);

int	netbsd32_mkdir(struct lwp *, const struct netbsd32_mkdir_args *, register_t *);

int	netbsd32_rmdir(struct lwp *, const struct netbsd32_rmdir_args *, register_t *);

int	compat_50_netbsd32_utimes(struct lwp *, const struct compat_50_netbsd32_utimes_args *, register_t *);

int	compat_50_netbsd32_adjtime(struct lwp *, const struct compat_50_netbsd32_adjtime_args *, register_t *);

int	compat_43_netbsd32_ogetpeername(struct lwp *, const struct compat_43_netbsd32_ogetpeername_args *, register_t *);

int	compat_43_sys_gethostid(struct lwp *, const void *, register_t *);

int	compat_43_netbsd32_sethostid(struct lwp *, const struct compat_43_netbsd32_sethostid_args *, register_t *);

int	compat_43_netbsd32_ogetrlimit(struct lwp *, const struct compat_43_netbsd32_ogetrlimit_args *, register_t *);

int	compat_43_netbsd32_osetrlimit(struct lwp *, const struct compat_43_netbsd32_osetrlimit_args *, register_t *);

int	compat_43_netbsd32_killpg(struct lwp *, const struct compat_43_netbsd32_killpg_args *, register_t *);

int	sys_setsid(struct lwp *, const void *, register_t *);

int	compat_50_netbsd32_quotactl(struct lwp *, const struct compat_50_netbsd32_quotactl_args *, register_t *);

int	compat_43_sys_quota(struct lwp *, const void *, register_t *);

int	compat_43_netbsd32_ogetsockname(struct lwp *, const struct compat_43_netbsd32_ogetsockname_args *, register_t *);

int	netbsd32_nfssvc(struct lwp *, const struct netbsd32_nfssvc_args *, register_t *);

int	compat_43_netbsd32_ogetdirentries(struct lwp *, const struct compat_43_netbsd32_ogetdirentries_args *, register_t *);

int	compat_20_netbsd32_statfs(struct lwp *, const struct compat_20_netbsd32_statfs_args *, register_t *);

int	compat_20_netbsd32_fstatfs(struct lwp *, const struct compat_20_netbsd32_fstatfs_args *, register_t *);

int	compat_30_netbsd32_getfh(struct lwp *, const struct compat_30_netbsd32_getfh_args *, register_t *);

int	compat_09_netbsd32_ogetdomainname(struct lwp *, const struct compat_09_netbsd32_ogetdomainname_args *, register_t *);

int	compat_09_netbsd32_osetdomainname(struct lwp *, const struct compat_09_netbsd32_osetdomainname_args *, register_t *);

int	compat_09_netbsd32_uname(struct lwp *, const struct compat_09_netbsd32_uname_args *, register_t *);

int	netbsd32_sysarch(struct lwp *, const struct netbsd32_sysarch_args *, register_t *);

int	compat_10_netbsd32_semsys(struct lwp *, const struct compat_10_netbsd32_semsys_args *, register_t *);

int	compat_10_netbsd32_msgsys(struct lwp *, const struct compat_10_netbsd32_msgsys_args *, register_t *);

int	compat_10_netbsd32_shmsys(struct lwp *, const struct compat_10_netbsd32_shmsys_args *, register_t *);

int	netbsd32_pread(struct lwp *, const struct netbsd32_pread_args *, register_t *);

int	netbsd32_pwrite(struct lwp *, const struct netbsd32_pwrite_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL_OPT)
int	compat_30_netbsd32_ntp_gettime(struct lwp *, const struct compat_30_netbsd32_ntp_gettime_args *, register_t *);

int	netbsd32_ntp_adjtime(struct lwp *, const struct netbsd32_ntp_adjtime_args *, register_t *);

#else
#endif
int	netbsd32_setgid(struct lwp *, const struct netbsd32_setgid_args *, register_t *);

int	netbsd32_setegid(struct lwp *, const struct netbsd32_setegid_args *, register_t *);

int	netbsd32_seteuid(struct lwp *, const struct netbsd32_seteuid_args *, register_t *);

int	compat_12_netbsd32_stat12(struct lwp *, const struct compat_12_netbsd32_stat12_args *, register_t *);

int	compat_12_netbsd32_fstat12(struct lwp *, const struct compat_12_netbsd32_fstat12_args *, register_t *);

int	compat_12_netbsd32_lstat12(struct lwp *, const struct compat_12_netbsd32_lstat12_args *, register_t *);

int	netbsd32_pathconf(struct lwp *, const struct netbsd32_pathconf_args *, register_t *);

int	netbsd32_fpathconf(struct lwp *, const struct netbsd32_fpathconf_args *, register_t *);

int	netbsd32_getrlimit(struct lwp *, const struct netbsd32_getrlimit_args *, register_t *);

int	netbsd32_setrlimit(struct lwp *, const struct netbsd32_setrlimit_args *, register_t *);

int	compat_12_netbsd32_getdirentries(struct lwp *, const struct compat_12_netbsd32_getdirentries_args *, register_t *);

int	netbsd32_mmap(struct lwp *, const struct netbsd32_mmap_args *, register_t *);

int	netbsd32____syscall(struct lwp *, const struct netbsd32____syscall_args *, register_t *);

int	netbsd32_lseek(struct lwp *, const struct netbsd32_lseek_args *, register_t *);

int	netbsd32_truncate(struct lwp *, const struct netbsd32_truncate_args *, register_t *);

int	netbsd32_ftruncate(struct lwp *, const struct netbsd32_ftruncate_args *, register_t *);

int	netbsd32___sysctl(struct lwp *, const struct netbsd32___sysctl_args *, register_t *);

int	netbsd32_mlock(struct lwp *, const struct netbsd32_mlock_args *, register_t *);

int	netbsd32_munlock(struct lwp *, const struct netbsd32_munlock_args *, register_t *);

int	netbsd32_undelete(struct lwp *, const struct netbsd32_undelete_args *, register_t *);

int	compat_50_netbsd32_futimes(struct lwp *, const struct compat_50_netbsd32_futimes_args *, register_t *);

int	netbsd32_getpgid(struct lwp *, const struct netbsd32_getpgid_args *, register_t *);

int	netbsd32_reboot(struct lwp *, const struct netbsd32_reboot_args *, register_t *);

int	netbsd32_poll(struct lwp *, const struct netbsd32_poll_args *, register_t *);

int	compat_14_netbsd32___semctl(struct lwp *, const struct compat_14_netbsd32___semctl_args *, register_t *);

int	netbsd32_semget(struct lwp *, const struct netbsd32_semget_args *, register_t *);

int	netbsd32_semop(struct lwp *, const struct netbsd32_semop_args *, register_t *);

int	netbsd32_semconfig(struct lwp *, const struct netbsd32_semconfig_args *, register_t *);

int	compat_14_netbsd32_msgctl(struct lwp *, const struct compat_14_netbsd32_msgctl_args *, register_t *);

int	netbsd32_msgget(struct lwp *, const struct netbsd32_msgget_args *, register_t *);

int	netbsd32_msgsnd(struct lwp *, const struct netbsd32_msgsnd_args *, register_t *);

int	netbsd32_msgrcv(struct lwp *, const struct netbsd32_msgrcv_args *, register_t *);

int	netbsd32_shmat(struct lwp *, const struct netbsd32_shmat_args *, register_t *);

int	compat_14_netbsd32_shmctl(struct lwp *, const struct compat_14_netbsd32_shmctl_args *, register_t *);

int	netbsd32_shmdt(struct lwp *, const struct netbsd32_shmdt_args *, register_t *);

int	netbsd32_shmget(struct lwp *, const struct netbsd32_shmget_args *, register_t *);

int	compat_50_netbsd32_clock_gettime(struct lwp *, const struct compat_50_netbsd32_clock_gettime_args *, register_t *);

int	compat_50_netbsd32_clock_settime(struct lwp *, const struct compat_50_netbsd32_clock_settime_args *, register_t *);

int	compat_50_netbsd32_clock_getres(struct lwp *, const struct compat_50_netbsd32_clock_getres_args *, register_t *);

int	netbsd32_timer_create(struct lwp *, const struct netbsd32_timer_create_args *, register_t *);

int	netbsd32_timer_delete(struct lwp *, const struct netbsd32_timer_delete_args *, register_t *);

int	compat_50_netbsd32_timer_settime(struct lwp *, const struct compat_50_netbsd32_timer_settime_args *, register_t *);

int	compat_50_netbsd32_timer_gettime(struct lwp *, const struct compat_50_netbsd32_timer_gettime_args *, register_t *);

int	netbsd32_timer_getoverrun(struct lwp *, const struct netbsd32_timer_getoverrun_args *, register_t *);

int	compat_50_netbsd32_nanosleep(struct lwp *, const struct compat_50_netbsd32_nanosleep_args *, register_t *);

int	netbsd32_fdatasync(struct lwp *, const struct netbsd32_fdatasync_args *, register_t *);

int	netbsd32_mlockall(struct lwp *, const struct netbsd32_mlockall_args *, register_t *);

int	sys_munlockall(struct lwp *, const void *, register_t *);

int	compat_50_netbsd32___sigtimedwait(struct lwp *, const struct compat_50_netbsd32___sigtimedwait_args *, register_t *);

int	netbsd32_sigqueueinfo(struct lwp *, const struct netbsd32_sigqueueinfo_args *, register_t *);

int	netbsd32_modctl(struct lwp *, const struct netbsd32_modctl_args *, register_t *);

int	netbsd32__ksem_init(struct lwp *, const struct netbsd32__ksem_init_args *, register_t *);

int	netbsd32__ksem_open(struct lwp *, const struct netbsd32__ksem_open_args *, register_t *);

int	netbsd32__ksem_unlink(struct lwp *, const struct netbsd32__ksem_unlink_args *, register_t *);

int	netbsd32__ksem_close(struct lwp *, const struct netbsd32__ksem_close_args *, register_t *);

int	netbsd32__ksem_post(struct lwp *, const struct netbsd32__ksem_post_args *, register_t *);

int	netbsd32__ksem_wait(struct lwp *, const struct netbsd32__ksem_wait_args *, register_t *);

int	netbsd32__ksem_trywait(struct lwp *, const struct netbsd32__ksem_trywait_args *, register_t *);

int	netbsd32__ksem_getvalue(struct lwp *, const struct netbsd32__ksem_getvalue_args *, register_t *);

int	netbsd32__ksem_destroy(struct lwp *, const struct netbsd32__ksem_destroy_args *, register_t *);

int	netbsd32__ksem_timedwait(struct lwp *, const struct netbsd32__ksem_timedwait_args *, register_t *);

int	netbsd32_mq_open(struct lwp *, const struct netbsd32_mq_open_args *, register_t *);

int	netbsd32_mq_close(struct lwp *, const struct netbsd32_mq_close_args *, register_t *);

int	netbsd32_mq_unlink(struct lwp *, const struct netbsd32_mq_unlink_args *, register_t *);

int	netbsd32_mq_getattr(struct lwp *, const struct netbsd32_mq_getattr_args *, register_t *);

int	netbsd32_mq_setattr(struct lwp *, const struct netbsd32_mq_setattr_args *, register_t *);

int	netbsd32_mq_notify(struct lwp *, const struct netbsd32_mq_notify_args *, register_t *);

int	netbsd32_mq_send(struct lwp *, const struct netbsd32_mq_send_args *, register_t *);

int	netbsd32_mq_receive(struct lwp *, const struct netbsd32_mq_receive_args *, register_t *);

int	compat_50_netbsd32_mq_timedsend(struct lwp *, const struct compat_50_netbsd32_mq_timedsend_args *, register_t *);

int	compat_50_netbsd32_mq_timedreceive(struct lwp *, const struct compat_50_netbsd32_mq_timedreceive_args *, register_t *);

int	netbsd32___posix_rename(struct lwp *, const struct netbsd32___posix_rename_args *, register_t *);

int	netbsd32_swapctl(struct lwp *, const struct netbsd32_swapctl_args *, register_t *);

int	compat_30_netbsd32_getdents(struct lwp *, const struct compat_30_netbsd32_getdents_args *, register_t *);

int	netbsd32_minherit(struct lwp *, const struct netbsd32_minherit_args *, register_t *);

int	netbsd32_lchmod(struct lwp *, const struct netbsd32_lchmod_args *, register_t *);

int	netbsd32_lchown(struct lwp *, const struct netbsd32_lchown_args *, register_t *);

int	compat_50_netbsd32_lutimes(struct lwp *, const struct compat_50_netbsd32_lutimes_args *, register_t *);

int	netbsd32___msync13(struct lwp *, const struct netbsd32___msync13_args *, register_t *);

int	compat_30_netbsd32___stat13(struct lwp *, const struct compat_30_netbsd32___stat13_args *, register_t *);

int	compat_30_netbsd32___fstat13(struct lwp *, const struct compat_30_netbsd32___fstat13_args *, register_t *);

int	compat_30_netbsd32___lstat13(struct lwp *, const struct compat_30_netbsd32___lstat13_args *, register_t *);

int	netbsd32___sigaltstack14(struct lwp *, const struct netbsd32___sigaltstack14_args *, register_t *);

int	sys___vfork14(struct lwp *, const void *, register_t *);

int	netbsd32___posix_chown(struct lwp *, const struct netbsd32___posix_chown_args *, register_t *);

int	netbsd32___posix_fchown(struct lwp *, const struct netbsd32___posix_fchown_args *, register_t *);

int	netbsd32___posix_lchown(struct lwp *, const struct netbsd32___posix_lchown_args *, register_t *);

int	netbsd32_getsid(struct lwp *, const struct netbsd32_getsid_args *, register_t *);

int	netbsd32___clone(struct lwp *, const struct netbsd32___clone_args *, register_t *);

int	netbsd32_fktrace(struct lwp *, const struct netbsd32_fktrace_args *, register_t *);

int	netbsd32_preadv(struct lwp *, const struct netbsd32_preadv_args *, register_t *);

int	netbsd32_pwritev(struct lwp *, const struct netbsd32_pwritev_args *, register_t *);

int	netbsd32___sigaction14(struct lwp *, const struct netbsd32___sigaction14_args *, register_t *);

int	netbsd32___sigpending14(struct lwp *, const struct netbsd32___sigpending14_args *, register_t *);

int	netbsd32___sigprocmask14(struct lwp *, const struct netbsd32___sigprocmask14_args *, register_t *);

int	netbsd32___sigsuspend14(struct lwp *, const struct netbsd32___sigsuspend14_args *, register_t *);

int	compat_16_netbsd32___sigreturn14(struct lwp *, const struct compat_16_netbsd32___sigreturn14_args *, register_t *);

int	netbsd32___getcwd(struct lwp *, const struct netbsd32___getcwd_args *, register_t *);

int	netbsd32_fchroot(struct lwp *, const struct netbsd32_fchroot_args *, register_t *);

int	compat_30_netbsd32_fhopen(struct lwp *, const struct compat_30_netbsd32_fhopen_args *, register_t *);

int	compat_30_netbsd32_fhstat(struct lwp *, const struct compat_30_netbsd32_fhstat_args *, register_t *);

int	compat_20_netbsd32_fhstatfs(struct lwp *, const struct compat_20_netbsd32_fhstatfs_args *, register_t *);

int	compat_50_netbsd32___semctl14(struct lwp *, const struct compat_50_netbsd32___semctl14_args *, register_t *);

int	compat_50_netbsd32___msgctl13(struct lwp *, const struct compat_50_netbsd32___msgctl13_args *, register_t *);

int	compat_50_netbsd32___shmctl13(struct lwp *, const struct compat_50_netbsd32___shmctl13_args *, register_t *);

int	netbsd32_lchflags(struct lwp *, const struct netbsd32_lchflags_args *, register_t *);

int	sys_issetugid(struct lwp *, const void *, register_t *);

int	netbsd32_utrace(struct lwp *, const struct netbsd32_utrace_args *, register_t *);

int	netbsd32_getcontext(struct lwp *, const struct netbsd32_getcontext_args *, register_t *);

int	netbsd32_setcontext(struct lwp *, const struct netbsd32_setcontext_args *, register_t *);

int	netbsd32__lwp_create(struct lwp *, const struct netbsd32__lwp_create_args *, register_t *);

int	sys__lwp_exit(struct lwp *, const void *, register_t *);

int	sys__lwp_self(struct lwp *, const void *, register_t *);

int	netbsd32__lwp_wait(struct lwp *, const struct netbsd32__lwp_wait_args *, register_t *);

int	netbsd32__lwp_suspend(struct lwp *, const struct netbsd32__lwp_suspend_args *, register_t *);

int	netbsd32__lwp_continue(struct lwp *, const struct netbsd32__lwp_continue_args *, register_t *);

int	netbsd32__lwp_wakeup(struct lwp *, const struct netbsd32__lwp_wakeup_args *, register_t *);

int	sys__lwp_getprivate(struct lwp *, const void *, register_t *);

int	netbsd32__lwp_setprivate(struct lwp *, const struct netbsd32__lwp_setprivate_args *, register_t *);

int	netbsd32__lwp_kill(struct lwp *, const struct netbsd32__lwp_kill_args *, register_t *);

int	netbsd32__lwp_detach(struct lwp *, const struct netbsd32__lwp_detach_args *, register_t *);

int	compat_50_netbsd32__lwp_park(struct lwp *, const struct compat_50_netbsd32__lwp_park_args *, register_t *);

int	netbsd32__lwp_unpark(struct lwp *, const struct netbsd32__lwp_unpark_args *, register_t *);

int	netbsd32__lwp_unpark_all(struct lwp *, const struct netbsd32__lwp_unpark_all_args *, register_t *);

int	netbsd32__lwp_setname(struct lwp *, const struct netbsd32__lwp_setname_args *, register_t *);

int	netbsd32__lwp_getname(struct lwp *, const struct netbsd32__lwp_getname_args *, register_t *);

int	netbsd32__lwp_ctl(struct lwp *, const struct netbsd32__lwp_ctl_args *, register_t *);

int	netbsd32___sigaction_sigtramp(struct lwp *, const struct netbsd32___sigaction_sigtramp_args *, register_t *);

int	netbsd32_rasctl(struct lwp *, const struct netbsd32_rasctl_args *, register_t *);

int	sys_kqueue(struct lwp *, const void *, register_t *);

int	compat_50_netbsd32_kevent(struct lwp *, const struct compat_50_netbsd32_kevent_args *, register_t *);

int	netbsd32__sched_setparam(struct lwp *, const struct netbsd32__sched_setparam_args *, register_t *);

int	netbsd32__sched_getparam(struct lwp *, const struct netbsd32__sched_getparam_args *, register_t *);

int	netbsd32__sched_setaffinity(struct lwp *, const struct netbsd32__sched_setaffinity_args *, register_t *);

int	netbsd32__sched_getaffinity(struct lwp *, const struct netbsd32__sched_getaffinity_args *, register_t *);

int	sys_sched_yield(struct lwp *, const void *, register_t *);

int	netbsd32__sched_protect(struct lwp *, const struct netbsd32__sched_protect_args *, register_t *);

int	netbsd32_fsync_range(struct lwp *, const struct netbsd32_fsync_range_args *, register_t *);

int	netbsd32_uuidgen(struct lwp *, const struct netbsd32_uuidgen_args *, register_t *);

int	netbsd32_getvfsstat(struct lwp *, const struct netbsd32_getvfsstat_args *, register_t *);

int	netbsd32_statvfs1(struct lwp *, const struct netbsd32_statvfs1_args *, register_t *);

int	netbsd32_fstatvfs1(struct lwp *, const struct netbsd32_fstatvfs1_args *, register_t *);

int	compat_30_netbsd32_fhstatvfs1(struct lwp *, const struct compat_30_netbsd32_fhstatvfs1_args *, register_t *);

int	netbsd32_extattrctl(struct lwp *, const struct netbsd32_extattrctl_args *, register_t *);

int	netbsd32_extattr_set_file(struct lwp *, const struct netbsd32_extattr_set_file_args *, register_t *);

int	netbsd32_extattr_get_file(struct lwp *, const struct netbsd32_extattr_get_file_args *, register_t *);

int	netbsd32_extattr_delete_file(struct lwp *, const struct netbsd32_extattr_delete_file_args *, register_t *);

int	netbsd32_extattr_set_fd(struct lwp *, const struct netbsd32_extattr_set_fd_args *, register_t *);

int	netbsd32_extattr_get_fd(struct lwp *, const struct netbsd32_extattr_get_fd_args *, register_t *);

int	netbsd32_extattr_delete_fd(struct lwp *, const struct netbsd32_extattr_delete_fd_args *, register_t *);

int	netbsd32_extattr_set_link(struct lwp *, const struct netbsd32_extattr_set_link_args *, register_t *);

int	netbsd32_extattr_get_link(struct lwp *, const struct netbsd32_extattr_get_link_args *, register_t *);

int	netbsd32_extattr_delete_link(struct lwp *, const struct netbsd32_extattr_delete_link_args *, register_t *);

int	netbsd32_extattr_list_fd(struct lwp *, const struct netbsd32_extattr_list_fd_args *, register_t *);

int	netbsd32_extattr_list_file(struct lwp *, const struct netbsd32_extattr_list_file_args *, register_t *);

int	netbsd32_extattr_list_link(struct lwp *, const struct netbsd32_extattr_list_link_args *, register_t *);

int	compat_50_netbsd32_pselect(struct lwp *, const struct compat_50_netbsd32_pselect_args *, register_t *);

int	compat_50_netbsd32_pollts(struct lwp *, const struct compat_50_netbsd32_pollts_args *, register_t *);

int	netbsd32_setxattr(struct lwp *, const struct netbsd32_setxattr_args *, register_t *);

int	netbsd32_lsetxattr(struct lwp *, const struct netbsd32_lsetxattr_args *, register_t *);

int	netbsd32_fsetxattr(struct lwp *, const struct netbsd32_fsetxattr_args *, register_t *);

int	netbsd32_getxattr(struct lwp *, const struct netbsd32_getxattr_args *, register_t *);

int	netbsd32_lgetxattr(struct lwp *, const struct netbsd32_lgetxattr_args *, register_t *);

int	netbsd32_fgetxattr(struct lwp *, const struct netbsd32_fgetxattr_args *, register_t *);

int	netbsd32_listxattr(struct lwp *, const struct netbsd32_listxattr_args *, register_t *);

int	netbsd32_llistxattr(struct lwp *, const struct netbsd32_llistxattr_args *, register_t *);

int	netbsd32_flistxattr(struct lwp *, const struct netbsd32_flistxattr_args *, register_t *);

int	netbsd32_removexattr(struct lwp *, const struct netbsd32_removexattr_args *, register_t *);

int	netbsd32_lremovexattr(struct lwp *, const struct netbsd32_lremovexattr_args *, register_t *);

int	netbsd32_fremovexattr(struct lwp *, const struct netbsd32_fremovexattr_args *, register_t *);

int	compat_50_netbsd32___stat30(struct lwp *, const struct compat_50_netbsd32___stat30_args *, register_t *);

int	compat_50_netbsd32___fstat30(struct lwp *, const struct compat_50_netbsd32___fstat30_args *, register_t *);

int	compat_50_netbsd32___lstat30(struct lwp *, const struct compat_50_netbsd32___lstat30_args *, register_t *);

int	netbsd32___getdents30(struct lwp *, const struct netbsd32___getdents30_args *, register_t *);

int	compat_30_netbsd32___fhstat30(struct lwp *, const struct compat_30_netbsd32___fhstat30_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL_OPT)
int	compat_50_netbsd32_ntp_gettime(struct lwp *, const struct compat_50_netbsd32_ntp_gettime_args *, register_t *);

#else
#endif
int	netbsd32___socket30(struct lwp *, const struct netbsd32___socket30_args *, register_t *);

int	netbsd32___getfh30(struct lwp *, const struct netbsd32___getfh30_args *, register_t *);

int	netbsd32___fhopen40(struct lwp *, const struct netbsd32___fhopen40_args *, register_t *);

int	netbsd32___fhstatvfs140(struct lwp *, const struct netbsd32___fhstatvfs140_args *, register_t *);

int	compat_50_netbsd32___fhstat40(struct lwp *, const struct compat_50_netbsd32___fhstat40_args *, register_t *);

int	netbsd32___mount50(struct lwp *, const struct netbsd32___mount50_args *, register_t *);

int	netbsd32_mremap(struct lwp *, const struct netbsd32_mremap_args *, register_t *);

int	netbsd32_pset_create(struct lwp *, const struct netbsd32_pset_create_args *, register_t *);

int	netbsd32_pset_destroy(struct lwp *, const struct netbsd32_pset_destroy_args *, register_t *);

int	netbsd32_pset_assign(struct lwp *, const struct netbsd32_pset_assign_args *, register_t *);

int	netbsd32__pset_bind(struct lwp *, const struct netbsd32__pset_bind_args *, register_t *);

int	netbsd32___posix_fadvise50(struct lwp *, const struct netbsd32___posix_fadvise50_args *, register_t *);

int	netbsd32___select50(struct lwp *, const struct netbsd32___select50_args *, register_t *);

int	netbsd32___gettimeofday50(struct lwp *, const struct netbsd32___gettimeofday50_args *, register_t *);

int	netbsd32___settimeofday50(struct lwp *, const struct netbsd32___settimeofday50_args *, register_t *);

int	netbsd32___utimes50(struct lwp *, const struct netbsd32___utimes50_args *, register_t *);

int	netbsd32___adjtime50(struct lwp *, const struct netbsd32___adjtime50_args *, register_t *);

int	netbsd32___futimes50(struct lwp *, const struct netbsd32___futimes50_args *, register_t *);

int	netbsd32___lutimes50(struct lwp *, const struct netbsd32___lutimes50_args *, register_t *);

int	netbsd32___setitimer50(struct lwp *, const struct netbsd32___setitimer50_args *, register_t *);

int	netbsd32___getitimer50(struct lwp *, const struct netbsd32___getitimer50_args *, register_t *);

int	netbsd32___clock_gettime50(struct lwp *, const struct netbsd32___clock_gettime50_args *, register_t *);

int	netbsd32___clock_settime50(struct lwp *, const struct netbsd32___clock_settime50_args *, register_t *);

int	netbsd32___clock_getres50(struct lwp *, const struct netbsd32___clock_getres50_args *, register_t *);

int	netbsd32___nanosleep50(struct lwp *, const struct netbsd32___nanosleep50_args *, register_t *);

int	netbsd32_____sigtimedwait50(struct lwp *, const struct netbsd32_____sigtimedwait50_args *, register_t *);

int	netbsd32___mq_timedsend50(struct lwp *, const struct netbsd32___mq_timedsend50_args *, register_t *);

int	netbsd32___mq_timedreceive50(struct lwp *, const struct netbsd32___mq_timedreceive50_args *, register_t *);

int	compat_60_netbsd32__lwp_park(struct lwp *, const struct compat_60_netbsd32__lwp_park_args *, register_t *);

int	netbsd32___kevent50(struct lwp *, const struct netbsd32___kevent50_args *, register_t *);

int	netbsd32___pselect50(struct lwp *, const struct netbsd32___pselect50_args *, register_t *);

int	netbsd32___pollts50(struct lwp *, const struct netbsd32___pollts50_args *, register_t *);

int	netbsd32___stat50(struct lwp *, const struct netbsd32___stat50_args *, register_t *);

int	netbsd32___fstat50(struct lwp *, const struct netbsd32___fstat50_args *, register_t *);

int	netbsd32___lstat50(struct lwp *, const struct netbsd32___lstat50_args *, register_t *);

int	netbsd32_____semctl50(struct lwp *, const struct netbsd32_____semctl50_args *, register_t *);

int	netbsd32___shmctl50(struct lwp *, const struct netbsd32___shmctl50_args *, register_t *);

int	netbsd32___msgctl50(struct lwp *, const struct netbsd32___msgctl50_args *, register_t *);

int	netbsd32___getrusage50(struct lwp *, const struct netbsd32___getrusage50_args *, register_t *);

int	netbsd32___timer_settime50(struct lwp *, const struct netbsd32___timer_settime50_args *, register_t *);

int	netbsd32___timer_gettime50(struct lwp *, const struct netbsd32___timer_gettime50_args *, register_t *);

#if defined(NTP) || !defined(_KERNEL_OPT)
int	netbsd32___ntp_gettime50(struct lwp *, const struct netbsd32___ntp_gettime50_args *, register_t *);

#else
#endif
int	netbsd32___wait450(struct lwp *, const struct netbsd32___wait450_args *, register_t *);

int	netbsd32___mknod50(struct lwp *, const struct netbsd32___mknod50_args *, register_t *);

int	netbsd32___fhstat50(struct lwp *, const struct netbsd32___fhstat50_args *, register_t *);

int	netbsd32_pipe2(struct lwp *, const struct netbsd32_pipe2_args *, register_t *);

int	netbsd32_dup3(struct lwp *, const struct netbsd32_dup3_args *, register_t *);

int	netbsd32_kqueue1(struct lwp *, const struct netbsd32_kqueue1_args *, register_t *);

int	netbsd32_paccept(struct lwp *, const struct netbsd32_paccept_args *, register_t *);

int	netbsd32_linkat(struct lwp *, const struct netbsd32_linkat_args *, register_t *);

int	netbsd32_renameat(struct lwp *, const struct netbsd32_renameat_args *, register_t *);

int	netbsd32_mkfifoat(struct lwp *, const struct netbsd32_mkfifoat_args *, register_t *);

int	netbsd32_mknodat(struct lwp *, const struct netbsd32_mknodat_args *, register_t *);

int	netbsd32_mkdirat(struct lwp *, const struct netbsd32_mkdirat_args *, register_t *);

int	netbsd32_faccessat(struct lwp *, const struct netbsd32_faccessat_args *, register_t *);

int	netbsd32_fchmodat(struct lwp *, const struct netbsd32_fchmodat_args *, register_t *);

int	netbsd32_fchownat(struct lwp *, const struct netbsd32_fchownat_args *, register_t *);

int	netbsd32_fexecve(struct lwp *, const struct netbsd32_fexecve_args *, register_t *);

int	netbsd32_fstatat(struct lwp *, const struct netbsd32_fstatat_args *, register_t *);

int	netbsd32_utimensat(struct lwp *, const struct netbsd32_utimensat_args *, register_t *);

int	netbsd32_openat(struct lwp *, const struct netbsd32_openat_args *, register_t *);

int	netbsd32_readlinkat(struct lwp *, const struct netbsd32_readlinkat_args *, register_t *);

int	netbsd32_symlinkat(struct lwp *, const struct netbsd32_symlinkat_args *, register_t *);

int	netbsd32_unlinkat(struct lwp *, const struct netbsd32_unlinkat_args *, register_t *);

int	netbsd32_futimens(struct lwp *, const struct netbsd32_futimens_args *, register_t *);

int	netbsd32___quotactl(struct lwp *, const struct netbsd32___quotactl_args *, register_t *);

int	netbsd32_posix_spawn(struct lwp *, const struct netbsd32_posix_spawn_args *, register_t *);

int	netbsd32_clock_nanosleep(struct lwp *, const struct netbsd32_clock_nanosleep_args *, register_t *);

int	netbsd32____lwp_park60(struct lwp *, const struct netbsd32____lwp_park60_args *, register_t *);

int	netbsd32_posix_fallocate(struct lwp *, const struct netbsd32_posix_fallocate_args *, register_t *);

int	netbsd32_fdiscard(struct lwp *, const struct netbsd32_fdiscard_args *, register_t *);

int	netbsd32_wait6(struct lwp *, const struct netbsd32_wait6_args *, register_t *);

int	netbsd32_clock_getcpuclockid2(struct lwp *, const struct netbsd32_clock_getcpuclockid2_args *, register_t *);

#endif /* _NETBSD32_SYS_SYSCALLARGS_H_ */
