/* $NetBSD: linux32_systrace_args.c,v 1.5 2017/05/10 06:19:49 riastradh Exp $ */

/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(register_t sysnum, const void *params, uintptr_t *uarg, size_t *n_args)
{
	intptr_t *iarg  = (intptr_t *)uarg;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_exit */
	case 1: {
		const struct linux32_sys_exit_args *p = params;
		iarg[0] = SCARG(p, rval); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* netbsd32_read */
	case 3: {
		const struct netbsd32_read_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_write */
	case 4: {
		const struct netbsd32_write_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_open */
	case 5: {
		const struct linux32_sys_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_close */
	case 6: {
		const struct netbsd32_close_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_waitpid */
	case 7: {
		const struct linux32_sys_waitpid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status).i32; /* netbsd32_intp */
		iarg[2] = SCARG(p, options); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_creat */
	case 8: {
		const struct linux32_sys_creat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_link */
	case 9: {
		const struct netbsd32_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, link).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_unlink */
	case 10: {
		const struct linux32_sys_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_execve */
	case 11: {
		const struct netbsd32_execve_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, argp).i32; /* netbsd32_charpp */
		uarg[2] = (intptr_t) SCARG(p, envp).i32; /* netbsd32_charpp */
		*n_args = 3;
		break;
	}
	/* netbsd32_chdir */
	case 12: {
		const struct netbsd32_chdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* linux32_sys_time */
	case 13: {
		const struct linux32_sys_time_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, t).i32; /* linux32_timep_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_mknod */
	case 14: {
		const struct linux32_sys_mknod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		uarg[2] = SCARG(p, dev); /* unsigned */
		*n_args = 3;
		break;
	}
	/* netbsd32_chmod */
	case 15: {
		const struct netbsd32_chmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_lchown16 */
	case 16: {
		const struct linux32_sys_lchown16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, uid); /* linux32_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux32_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_break */
	case 17: {
		const struct linux32_sys_break_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* compat_43_netbsd32_olseek */
	case 19: {
		const struct compat_43_netbsd32_olseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* netbsd32_long */
		iarg[2] = SCARG(p, whence); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* netbsd32_setuid */
	case 23: {
		const struct netbsd32_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_getuid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_stime */
	case 25: {
		const struct linux32_sys_stime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, t).i32; /* linux32_timep_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_ptrace */
	case 26: {
		const struct linux32_sys_ptrace_args *p = params;
		iarg[0] = SCARG(p, request); /* int */
		iarg[1] = SCARG(p, pid); /* int */
		iarg[2] = SCARG(p, addr); /* int */
		iarg[3] = SCARG(p, data); /* int */
		*n_args = 4;
		break;
	}
	/* linux32_sys_alarm */
	case 27: {
		const struct linux32_sys_alarm_args *p = params;
		uarg[0] = SCARG(p, secs); /* unsigned int */
		*n_args = 1;
		break;
	}
	/* linux_sys_pause */
	case 29: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_utime */
	case 30: {
		const struct linux32_sys_utime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, times).i32; /* linux32_utimbufp_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_access */
	case 33: {
		const struct netbsd32_access_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux32_sys_nice */
	case 34: {
		const struct linux32_sys_nice_args *p = params;
		iarg[0] = SCARG(p, incr); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_kill */
	case 37: {
		const struct linux32_sys_kill_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32___posix_rename */
	case 38: {
		const struct netbsd32___posix_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, to).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_mkdir */
	case 39: {
		const struct netbsd32_mkdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_rmdir */
	case 40: {
		const struct netbsd32_rmdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_dup */
	case 41: {
		const struct netbsd32_dup_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_pipe */
	case 42: {
		const struct linux32_sys_pipe_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fd).i32; /* netbsd32_intp */
		*n_args = 1;
		break;
	}
	/* linux32_sys_times */
	case 43: {
		const struct linux32_sys_times_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tms).i32; /* linux32_tmsp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_brk */
	case 45: {
		const struct linux32_sys_brk_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_setgid */
	case 46: {
		const struct netbsd32_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_getgid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_signal */
	case 48: {
		const struct linux32_sys_signal_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, handler).i32; /* linux32_handlerp_t */
		*n_args = 2;
		break;
	}
	/* sys_geteuid */
	case 49: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 50: {
		*n_args = 0;
		break;
	}
	/* netbsd32_acct */
	case 51: {
		const struct netbsd32_acct_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* linux32_sys_ioctl */
	case 54: {
		const struct linux32_sys_ioctl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, com); /* netbsd32_u_long */
		uarg[2] = (intptr_t) SCARG(p, data).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* linux32_sys_fcntl */
	case 55: {
		const struct linux32_sys_fcntl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 3;
		break;
	}
	/* netbsd32_setpgid */
	case 57: {
		const struct netbsd32_setpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, pgid); /* int */
		*n_args = 2;
		break;
	}
	/* linux32_sys_oldolduname */
	case 59: {
		const struct linux32_sys_oldolduname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up).i32; /* linux32_oldold_utsnamep_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_umask */
	case 60: {
		const struct netbsd32_umask_args *p = params;
		iarg[0] = SCARG(p, newmask); /* int */
		*n_args = 1;
		break;
	}
	/* netbsd32_chroot */
	case 61: {
		const struct netbsd32_chroot_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* netbsd32_dup2 */
	case 63: {
		const struct netbsd32_dup2_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		*n_args = 2;
		break;
	}
	/* sys_getppid */
	case 64: {
		*n_args = 0;
		break;
	}
	/* sys_getpgrp */
	case 65: {
		*n_args = 0;
		break;
	}
	/* sys_setsid */
	case 66: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_siggetmask */
	case 68: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_sigsetmask */
	case 69: {
		const struct linux32_sys_sigsetmask_args *p = params;
		iarg[0] = SCARG(p, mask); /* linux32_old_sigset_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_setreuid16 */
	case 70: {
		const struct linux32_sys_setreuid16_args *p = params;
		iarg[0] = SCARG(p, ruid); /* linux32_uid16_t */
		iarg[1] = SCARG(p, euid); /* linux32_uid16_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_setregid16 */
	case 71: {
		const struct linux32_sys_setregid16_args *p = params;
		iarg[0] = SCARG(p, rgid); /* linux32_gid16_t */
		iarg[1] = SCARG(p, egid); /* linux32_gid16_t */
		*n_args = 2;
		break;
	}
	/* compat_43_netbsd32_osethostname */
	case 74: {
		const struct compat_43_netbsd32_osethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* linux32_sys_setrlimit */
	case 75: {
		const struct linux32_sys_setrlimit_args *p = params;
		uarg[0] = SCARG(p, which); /* u_int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_orlimitp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_getrlimit */
	case 76: {
		const struct linux32_sys_getrlimit_args *p = params;
		uarg[0] = SCARG(p, which); /* u_int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_orlimitp_t */
		*n_args = 2;
		break;
	}
	/* compat_50_netbsd32_getrusage */
	case 77: {
		const struct compat_50_netbsd32_getrusage_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusage50p_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_gettimeofday */
	case 78: {
		const struct linux32_sys_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timeval50p_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* netbsd32_timezonep_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_settimeofday */
	case 79: {
		const struct linux32_sys_settimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp).i32; /* netbsd32_timeval50p_t */
		uarg[1] = (intptr_t) SCARG(p, tzp).i32; /* netbsd32_timezonep_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_getgroups16 */
	case 80: {
		const struct linux32_sys_getgroups16_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* linux32_gid16p_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_setgroups16 */
	case 81: {
		const struct linux32_sys_setgroups16_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* linux32_gid16p_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_oldselect */
	case 82: {
		const struct linux32_sys_oldselect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lsp).i32; /* linux32_oldselectp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_symlink */
	case 83: {
		const struct netbsd32_symlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, link).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* compat_43_netbsd32_lstat43 */
	case 84: {
		const struct compat_43_netbsd32_lstat43_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, ub).i32; /* netbsd32_stat43p_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_readlink */
	case 85: {
		const struct netbsd32_readlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, count); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_swapon */
	case 87: {
		const struct linux32_sys_swapon_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* linux32_sys_reboot */
	case 88: {
		const struct linux32_sys_reboot_args *p = params;
		iarg[0] = SCARG(p, magic1); /* int */
		iarg[1] = SCARG(p, magic2); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 4;
		break;
	}
	/* linux32_sys_readdir */
	case 89: {
		const struct linux32_sys_readdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent).i32; /* netbsd32_voidp */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_old_mmap */
	case 90: {
		const struct linux32_sys_old_mmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lmp).i32; /* linux32_oldmmapp */
		*n_args = 1;
		break;
	}
	/* netbsd32_munmap */
	case 91: {
		const struct netbsd32_munmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* compat_43_netbsd32_otruncate */
	case 92: {
		const struct compat_43_netbsd32_otruncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, length); /* netbsd32_long */
		*n_args = 2;
		break;
	}
	/* compat_43_netbsd32_oftruncate */
	case 93: {
		const struct compat_43_netbsd32_oftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, length); /* netbsd32_long */
		*n_args = 2;
		break;
	}
	/* netbsd32_fchmod */
	case 94: {
		const struct netbsd32_fchmod_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_fchown16 */
	case 95: {
		const struct linux32_sys_fchown16_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, uid); /* linux32_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux32_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getpriority */
	case 96: {
		const struct linux32_sys_getpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32_setpriority */
	case 97: {
		const struct netbsd32_setpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		iarg[2] = SCARG(p, prio); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_profil */
	case 98: {
		const struct netbsd32_profil_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, samples).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, size); /* netbsd32_size_t */
		iarg[2] = SCARG(p, offset); /* netbsd32_u_long */
		uarg[3] = SCARG(p, scale); /* u_int */
		*n_args = 4;
		break;
	}
	/* linux32_sys_statfs */
	case 99: {
		const struct linux32_sys_statfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_statfsp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_fstatfs */
	case 100: {
		const struct linux32_sys_fstatfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_statfsp */
		*n_args = 2;
		break;
	}
	/* linux_sys_ioperm */
	case 101: {
		const struct linux_sys_ioperm_args *p = params;
		uarg[0] = SCARG(p, lo); /* unsigned int */
		uarg[1] = SCARG(p, hi); /* unsigned int */
		iarg[2] = SCARG(p, val); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_socketcall */
	case 102: {
		const struct linux32_sys_socketcall_args *p = params;
		iarg[0] = SCARG(p, what); /* int */
		uarg[1] = (intptr_t) SCARG(p, args).i32; /* netbsd32_voidp */
		*n_args = 2;
		break;
	}
	/* compat_50_netbsd32_setitimer */
	case 104: {
		const struct compat_50_netbsd32_setitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* netbsd32_itimerval50p_t */
		uarg[2] = (intptr_t) SCARG(p, oitv).i32; /* netbsd32_itimerval50p_t */
		*n_args = 3;
		break;
	}
	/* compat_50_netbsd32_getitimer */
	case 105: {
		const struct compat_50_netbsd32_getitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv).i32; /* netbsd32_itimerval50p_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_stat */
	case 106: {
		const struct linux32_sys_stat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_statp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_lstat */
	case 107: {
		const struct linux32_sys_lstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_statp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_fstat */
	case 108: {
		const struct linux32_sys_fstat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_statp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_olduname */
	case 109: {
		const struct linux32_sys_olduname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up).i32; /* linux32_oldutsnamep_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_iopl */
	case 110: {
		const struct linux_sys_iopl_args *p = params;
		iarg[0] = SCARG(p, level); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_wait4 */
	case 114: {
		const struct linux32_sys_wait4_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status).i32; /* netbsd32_intp */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage).i32; /* netbsd32_rusage50p_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_swapoff */
	case 115: {
		const struct linux32_sys_swapoff_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		*n_args = 1;
		break;
	}
	/* linux32_sys_sysinfo */
	case 116: {
		const struct linux32_sys_sysinfo_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, arg).i32; /* linux32_sysinfop_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_ipc */
	case 117: {
		const struct linux32_sys_ipc_args *p = params;
		iarg[0] = SCARG(p, what); /* int */
		iarg[1] = SCARG(p, a1); /* int */
		iarg[2] = SCARG(p, a2); /* int */
		iarg[3] = SCARG(p, a3); /* int */
		uarg[4] = (intptr_t) SCARG(p, ptr).i32; /* netbsd32_voidp */
		*n_args = 5;
		break;
	}
	/* netbsd32_fsync */
	case 118: {
		const struct netbsd32_fsync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_sigreturn */
	case 119: {
		const struct linux32_sys_sigreturn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, scp).i32; /* linux32_sigcontextp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_clone */
	case 120: {
		const struct linux32_sys_clone_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		uarg[1] = (intptr_t) SCARG(p, stack).i32; /* netbsd32_voidp */
		uarg[2] = (intptr_t) SCARG(p, parent_tidptr).i32; /* netbsd32_voidp */
		uarg[3] = (intptr_t) SCARG(p, tls).i32; /* netbsd32_voidp */
		uarg[4] = (intptr_t) SCARG(p, child_tidptr).i32; /* netbsd32_voidp */
		*n_args = 5;
		break;
	}
	/* linux32_sys_setdomainname */
	case 121: {
		const struct linux32_sys_setdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* linux32_sys_uname */
	case 122: {
		const struct linux32_sys_uname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up).i32; /* linux32_utsnamep */
		*n_args = 1;
		break;
	}
	/* linux32_sys_modify_ldt */
	case 123: {
		const struct linux32_sys_modify_ldt_args *p = params;
		iarg[0] = SCARG(p, func); /* int */
		uarg[1] = (intptr_t) SCARG(p, ptr).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, bytecount); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_mprotect */
	case 125: {
		const struct linux32_sys_mprotect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, start).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, prot); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_getpgid */
	case 132: {
		const struct netbsd32_getpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_fchdir */
	case 133: {
		const struct netbsd32_fchdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_personality */
	case 136: {
		const struct linux32_sys_personality_args *p = params;
		iarg[0] = SCARG(p, per); /* netbsd32_u_long */
		*n_args = 1;
		break;
	}
	/* linux32_sys_setfsuid */
	case 138: {
		const struct linux32_sys_setfsuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_setfsgid */
	case 139: {
		const struct linux32_sys_setfsgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_llseek */
	case 140: {
		const struct linux32_sys_llseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, ohigh); /* u_int32_t */
		uarg[2] = SCARG(p, olow); /* u_int32_t */
		uarg[3] = (intptr_t) SCARG(p, res).i32; /* netbsd32_voidp */
		iarg[4] = SCARG(p, whence); /* int */
		*n_args = 5;
		break;
	}
	/* linux32_sys_getdents */
	case 141: {
		const struct linux32_sys_getdents_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent).i32; /* linux32_direntp_t */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_select */
	case 142: {
		const struct linux32_sys_select_args *p = params;
		iarg[0] = SCARG(p, nfds); /* int */
		uarg[1] = (intptr_t) SCARG(p, readfds).i32; /* netbsd32_fd_setp_t */
		uarg[2] = (intptr_t) SCARG(p, writefds).i32; /* netbsd32_fd_setp_t */
		uarg[3] = (intptr_t) SCARG(p, exceptfds).i32; /* netbsd32_fd_setp_t */
		uarg[4] = (intptr_t) SCARG(p, timeout).i32; /* netbsd32_timeval50p_t */
		*n_args = 5;
		break;
	}
	/* netbsd32_flock */
	case 143: {
		const struct netbsd32_flock_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* netbsd32___msync13 */
	case 144: {
		const struct netbsd32___msync13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_readv */
	case 145: {
		const struct netbsd32_readv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_writev */
	case 146: {
		const struct netbsd32_writev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp).i32; /* netbsd32_iovecp_t */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_getsid */
	case 147: {
		const struct netbsd32_getsid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_fdatasync */
	case 148: {
		const struct linux32_sys_fdatasync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys___sysctl */
	case 149: {
		const struct linux32_sys___sysctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lsp).i32; /* linux32___sysctlp_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_mlock */
	case 150: {
		const struct netbsd32_mlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_munlock */
	case 151: {
		const struct netbsd32_munlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_mlockall */
	case 152: {
		const struct netbsd32_mlockall_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munlockall */
	case 153: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_sched_setparam */
	case 154: {
		const struct linux32_sys_sched_setparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* const linux32_sched_paramp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_sched_getparam */
	case 155: {
		const struct linux32_sys_sched_getparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_sched_paramp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_sched_setscheduler */
	case 156: {
		const struct linux32_sys_sched_setscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, policy); /* int */
		uarg[2] = (intptr_t) SCARG(p, sp).i32; /* linux32_sched_paramp_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_sched_getscheduler */
	case 157: {
		const struct linux32_sys_sched_getscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_sched_yield */
	case 158: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_sched_get_priority_max */
	case 159: {
		const struct linux32_sys_sched_get_priority_max_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_sched_get_priority_min */
	case 160: {
		const struct linux32_sys_sched_get_priority_min_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_nanosleep */
	case 162: {
		const struct linux32_sys_nanosleep_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp).i32; /* linux32_timespecp_t */
		uarg[1] = (intptr_t) SCARG(p, rmtp).i32; /* linux32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_mremap */
	case 163: {
		const struct linux32_sys_mremap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, old_address).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, old_size); /* netbsd32_size_t */
		iarg[2] = SCARG(p, new_size); /* netbsd32_size_t */
		iarg[3] = SCARG(p, flags); /* netbsd32_u_long */
		*n_args = 4;
		break;
	}
	/* linux32_sys_setresuid16 */
	case 164: {
		const struct linux32_sys_setresuid16_args *p = params;
		iarg[0] = SCARG(p, ruid); /* linux32_uid16_t */
		iarg[1] = SCARG(p, euid); /* linux32_uid16_t */
		iarg[2] = SCARG(p, suid); /* linux32_uid16_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getresuid16 */
	case 165: {
		const struct linux32_sys_getresuid16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ruid).i32; /* linux32_uid16p_t */
		uarg[1] = (intptr_t) SCARG(p, euid).i32; /* linux32_uid16p_t */
		uarg[2] = (intptr_t) SCARG(p, suid).i32; /* linux32_uid16p_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_poll */
	case 168: {
		const struct netbsd32_poll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds).i32; /* netbsd32_pollfdp_t */
		uarg[1] = SCARG(p, nfds); /* u_int */
		iarg[2] = SCARG(p, timeout); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_setresgid16 */
	case 170: {
		const struct linux32_sys_setresgid16_args *p = params;
		iarg[0] = SCARG(p, rgid); /* linux32_gid16_t */
		iarg[1] = SCARG(p, egid); /* linux32_gid16_t */
		iarg[2] = SCARG(p, sgid); /* linux32_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getresgid16 */
	case 171: {
		const struct linux32_sys_getresgid16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rgid).i32; /* linux32_gid16p_t */
		uarg[1] = (intptr_t) SCARG(p, egid).i32; /* linux32_gid16p_t */
		uarg[2] = (intptr_t) SCARG(p, sgid).i32; /* linux32_gid16p_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_rt_sigreturn */
	case 173: {
		const struct linux32_sys_rt_sigreturn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp).i32; /* linux32_ucontextp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_rt_sigaction */
	case 174: {
		const struct linux32_sys_rt_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa).i32; /* linux32_sigactionp_t */
		uarg[2] = (intptr_t) SCARG(p, osa).i32; /* linux32_sigactionp_t */
		iarg[3] = SCARG(p, sigsetsize); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_rt_sigprocmask */
	case 175: {
		const struct linux32_sys_rt_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set).i32; /* linux32_sigsetp_t */
		uarg[2] = (intptr_t) SCARG(p, oset).i32; /* linux32_sigsetp_t */
		iarg[3] = SCARG(p, sigsetsize); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_rt_sigpending */
	case 176: {
		const struct linux32_sys_rt_sigpending_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* linux32_sigsetp_t */
		iarg[1] = SCARG(p, sigsetsize); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_rt_sigtimedwait */
	case 177: {
		const struct linux32_sys_rt_sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set).i32; /* const linux32_sigsetp_t */
		uarg[1] = (intptr_t) SCARG(p, info).i32; /* linux32_siginfop_t */
		uarg[2] = (intptr_t) SCARG(p, timeout).i32; /* const linux32_timespecp_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_rt_queueinfo */
	case 178: {
		const struct linux32_sys_rt_queueinfo_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, sig); /* int */
		uarg[2] = (intptr_t) SCARG(p, uinfo).i32; /* linux32_siginfop_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_rt_sigsuspend */
	case 179: {
		const struct linux32_sys_rt_sigsuspend_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, unewset).i32; /* linux32_sigsetp_t */
		iarg[1] = SCARG(p, sigsetsize); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_pread */
	case 180: {
		const struct linux32_sys_pread_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		iarg[3] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_pwrite */
	case 181: {
		const struct linux32_sys_pwrite_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_voidp */
		iarg[2] = SCARG(p, nbyte); /* netbsd32_size_t */
		iarg[3] = SCARG(p, offset); /* netbsd32_off_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_chown16 */
	case 182: {
		const struct linux32_sys_chown16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, uid); /* linux32_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux32_gid16_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___getcwd */
	case 183: {
		const struct netbsd32___getcwd_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, bufp).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, length); /* netbsd32_size_t */
		*n_args = 2;
		break;
	}
	/* sys___vfork14 */
	case 190: {
		*n_args = 0;
		break;
	}
	/* linux32_sys_ugetrlimit */
	case 191: {
		const struct linux32_sys_ugetrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp).i32; /* netbsd32_orlimitp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_mmap2 */
	case 192: {
		const struct linux32_sys_mmap2_args *p = params;
		iarg[0] = SCARG(p, addr); /* netbsd32_u_long */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, offset); /* linux32_off_t */
		*n_args = 6;
		break;
	}
	/* linux32_sys_truncate64 */
	case 193: {
		const struct linux32_sys_truncate64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, lenlo); /* uint32_t */
		uarg[2] = SCARG(p, lenhi); /* uint32_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_ftruncate64 */
	case 194: {
		const struct linux32_sys_ftruncate64_args *p = params;
		uarg[0] = SCARG(p, fd); /* unsigned int */
		uarg[1] = SCARG(p, lenlo); /* uint32_t */
		uarg[2] = SCARG(p, lenhi); /* uint32_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_stat64 */
	case 195: {
		const struct linux32_sys_stat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_stat64p */
		*n_args = 2;
		break;
	}
	/* linux32_sys_lstat64 */
	case 196: {
		const struct linux32_sys_lstat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_stat64p */
		*n_args = 2;
		break;
	}
	/* linux32_sys_fstat64 */
	case 197: {
		const struct linux32_sys_fstat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp).i32; /* linux32_stat64p */
		*n_args = 2;
		break;
	}
	/* netbsd32___posix_lchown */
	case 198: {
		const struct netbsd32___posix_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_getuid */
	case 199: {
		*n_args = 0;
		break;
	}
	/* sys_getgid */
	case 200: {
		*n_args = 0;
		break;
	}
	/* sys_geteuid */
	case 201: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 202: {
		*n_args = 0;
		break;
	}
	/* netbsd32_setreuid */
	case 203: {
		const struct netbsd32_setreuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_setregid */
	case 204: {
		const struct netbsd32_setregid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		*n_args = 2;
		break;
	}
	/* netbsd32_getgroups */
	case 205: {
		const struct netbsd32_getgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* netbsd32_gid_tp */
		*n_args = 2;
		break;
	}
	/* netbsd32_setgroups */
	case 206: {
		const struct netbsd32_setgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset).i32; /* netbsd32_gid_tp */
		*n_args = 2;
		break;
	}
	/* netbsd32___posix_fchown */
	case 207: {
		const struct netbsd32___posix_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_setresuid */
	case 208: {
		const struct linux32_sys_setresuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		uarg[2] = SCARG(p, suid); /* uid_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getresuid */
	case 209: {
		const struct linux32_sys_getresuid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ruid).i32; /* linux32_uidp_t */
		uarg[1] = (intptr_t) SCARG(p, euid).i32; /* linux32_uidp_t */
		uarg[2] = (intptr_t) SCARG(p, suid).i32; /* linux32_uidp_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_setresgid */
	case 210: {
		const struct linux32_sys_setresgid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		iarg[2] = SCARG(p, sgid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getresgid */
	case 211: {
		const struct linux32_sys_getresgid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rgid).i32; /* linux32_gidp_t */
		uarg[1] = (intptr_t) SCARG(p, egid).i32; /* linux32_gidp_t */
		uarg[2] = (intptr_t) SCARG(p, sgid).i32; /* linux32_gidp_t */
		*n_args = 3;
		break;
	}
	/* netbsd32___posix_chown */
	case 212: {
		const struct netbsd32___posix_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_setuid */
	case 213: {
		const struct netbsd32_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_setgid */
	case 214: {
		const struct netbsd32_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_setfsuid */
	case 215: {
		const struct linux32_sys_setfsuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_setfsgid */
	case 216: {
		const struct linux32_sys_setfsgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* netbsd32_mincore */
	case 218: {
		const struct netbsd32_mincore_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, vec).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_madvise */
	case 219: {
		const struct netbsd32_madvise_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr).i32; /* netbsd32_voidp */
		iarg[1] = SCARG(p, len); /* netbsd32_size_t */
		iarg[2] = SCARG(p, behav); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_getdents64 */
	case 220: {
		const struct linux32_sys_getdents64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent).i32; /* linux32_dirent64p_t */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	/* linux32_sys_fcntl64 */
	case 221: {
		const struct linux32_sys_fcntl64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg).i32; /* netbsd32_voidp */
		*n_args = 3;
		break;
	}
	/* linux_sys_gettid */
	case 224: {
		*n_args = 0;
		break;
	}
	/* netbsd32_setxattr */
	case 226: {
		const struct netbsd32_setxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_lsetxattr */
	case 227: {
		const struct netbsd32_lsetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_fsetxattr */
	case 228: {
		const struct netbsd32_fsetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_getxattr */
	case 229: {
		const struct netbsd32_getxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_lgetxattr */
	case 230: {
		const struct netbsd32_lgetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_fgetxattr */
	case 231: {
		const struct netbsd32_fgetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, value).i32; /* netbsd32_voidp */
		iarg[3] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_listxattr */
	case 232: {
		const struct netbsd32_listxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_llistxattr */
	case 233: {
		const struct netbsd32_llistxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_flistxattr */
	case 234: {
		const struct netbsd32_flistxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, list).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, size); /* netbsd32_size_t */
		*n_args = 3;
		break;
	}
	/* netbsd32_removexattr */
	case 235: {
		const struct netbsd32_removexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_lremovexattr */
	case 236: {
		const struct netbsd32_lremovexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* netbsd32_fremovexattr */
	case 237: {
		const struct netbsd32_fremovexattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name).i32; /* netbsd32_charp */
		*n_args = 2;
		break;
	}
	/* linux32_sys_tkill */
	case 238: {
		const struct linux32_sys_tkill_args *p = params;
		iarg[0] = SCARG(p, tid); /* int */
		iarg[1] = SCARG(p, sig); /* int */
		*n_args = 2;
		break;
	}
	/* linux32_sys_futex */
	case 240: {
		const struct linux32_sys_futex_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, uaddr).i32; /* linux32_intp_t */
		iarg[1] = SCARG(p, op); /* int */
		iarg[2] = SCARG(p, val); /* int */
		uarg[3] = (intptr_t) SCARG(p, timeout).i32; /* linux32_timespecp_t */
		uarg[4] = (intptr_t) SCARG(p, uaddr2).i32; /* linux32_intp_t */
		iarg[5] = SCARG(p, val3); /* int */
		*n_args = 6;
		break;
	}
	/* linux32_sys_sched_setaffinity */
	case 241: {
		const struct linux32_sys_sched_setaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask).i32; /* linux32_ulongp_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_sched_getaffinity */
	case 242: {
		const struct linux32_sys_sched_getaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask).i32; /* linux32_ulongp_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_set_thread_area */
	case 243: {
		const struct linux32_sys_set_thread_area_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, desc).i32; /* linux32_user_descp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_get_thread_area */
	case 244: {
		const struct linux32_sys_get_thread_area_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, desc).i32; /* linux32_user_descp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_fadvise64 */
	case 250: {
		const struct linux32_sys_fadvise64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, offlo); /* uint32_t */
		uarg[2] = SCARG(p, offhi); /* uint32_t */
		iarg[3] = SCARG(p, len); /* linux32_size_t */
		iarg[4] = SCARG(p, advice); /* int */
		*n_args = 5;
		break;
	}
	/* linux32_sys_exit_group */
	case 252: {
		const struct linux32_sys_exit_group_args *p = params;
		iarg[0] = SCARG(p, error_code); /* int */
		*n_args = 1;
		break;
	}
	/* linux32_sys_set_tid_address */
	case 258: {
		const struct linux32_sys_set_tid_address_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tid).i32; /* linux32_intp_t */
		*n_args = 1;
		break;
	}
	/* linux32_sys_clock_settime */
	case 264: {
		const struct linux32_sys_clock_settime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* linux32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_clock_gettime */
	case 265: {
		const struct linux32_sys_clock_gettime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* linux32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_clock_getres */
	case 266: {
		const struct linux32_sys_clock_getres_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp).i32; /* linux32_timespecp_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_clock_nanosleep */
	case 267: {
		const struct linux32_sys_clock_nanosleep_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, rqtp).i32; /* linux32_timespecp_t */
		uarg[3] = (intptr_t) SCARG(p, rmtp).i32; /* linux32_timespecp_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_statfs64 */
	case 268: {
		const struct linux32_sys_statfs64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, sz); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, sp).i32; /* linux32_statfs64p */
		*n_args = 3;
		break;
	}
	/* linux32_sys_fstatfs64 */
	case 269: {
		const struct linux32_sys_fstatfs64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, sz); /* netbsd32_size_t */
		uarg[2] = (intptr_t) SCARG(p, sp).i32; /* linux32_statfs64p */
		*n_args = 3;
		break;
	}
	/* linux32_sys_tgkill */
	case 270: {
		const struct linux32_sys_tgkill_args *p = params;
		iarg[0] = SCARG(p, tgid); /* int */
		iarg[1] = SCARG(p, tid); /* int */
		iarg[2] = SCARG(p, sig); /* int */
		*n_args = 3;
		break;
	}
	/* compat_50_netbsd32_utimes */
	case 271: {
		const struct compat_50_netbsd32_utimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[1] = (intptr_t) SCARG(p, tptr).i32; /* netbsd32_timeval50p_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_fadvise64_64 */
	case 272: {
		const struct linux32_sys_fadvise64_64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, offlo); /* uint32_t */
		uarg[2] = SCARG(p, offhi); /* uint32_t */
		uarg[3] = SCARG(p, lenlo); /* uint32_t */
		uarg[4] = SCARG(p, lenhi); /* uint32_t */
		iarg[5] = SCARG(p, advice); /* int */
		*n_args = 6;
		break;
	}
	/* linux32_sys_openat */
	case 295: {
		const struct linux32_sys_openat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, flags); /* int */
		iarg[3] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 4;
		break;
	}
	/* netbsd32_mkdirat */
	case 296: {
		const struct netbsd32_mkdirat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_mknodat */
	case 297: {
		const struct linux32_sys_mknodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		uarg[3] = SCARG(p, dev); /* unsigned */
		*n_args = 4;
		break;
	}
	/* linux32_sys_fchownat */
	case 298: {
		const struct linux32_sys_fchownat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[2] = SCARG(p, owner); /* uid_t */
		iarg[3] = SCARG(p, group); /* gid_t */
		iarg[4] = SCARG(p, flag); /* int */
		*n_args = 5;
		break;
	}
	/* linux32_sys_fstatat64 */
	case 300: {
		const struct linux32_sys_fstatat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, sp).i32; /* linux32_stat64p */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux32_sys_unlinkat */
	case 301: {
		const struct linux32_sys_unlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, flag); /* int */
		*n_args = 3;
		break;
	}
	/* netbsd32_renameat */
	case 302: {
		const struct netbsd32_renameat_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to).i32; /* netbsd32_charp */
		*n_args = 4;
		break;
	}
	/* linux32_sys_linkat */
	case 303: {
		const struct linux32_sys_linkat_args *p = params;
		iarg[0] = SCARG(p, fd1); /* int */
		uarg[1] = (intptr_t) SCARG(p, name1).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, fd2); /* int */
		uarg[3] = (intptr_t) SCARG(p, name2).i32; /* netbsd32_charp */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* netbsd32_symlinkat */
	case 304: {
		const struct netbsd32_symlinkat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path1).i32; /* netbsd32_charp */
		iarg[1] = SCARG(p, fd); /* int */
		uarg[2] = (intptr_t) SCARG(p, path2).i32; /* netbsd32_charp */
		*n_args = 3;
		break;
	}
	/* netbsd32_readlinkat */
	case 305: {
		const struct netbsd32_readlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, buf).i32; /* netbsd32_charp */
		iarg[3] = SCARG(p, bufsize); /* linux32_size_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_fchmodat */
	case 306: {
		const struct linux32_sys_fchmodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_faccessat */
	case 307: {
		const struct linux32_sys_faccessat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		iarg[2] = SCARG(p, amode); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_ppoll */
	case 309: {
		const struct linux32_sys_ppoll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds).i32; /* netbsd32_pollfdp_t */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, timeout).i32; /* linux32_timespecp_t */
		uarg[3] = (intptr_t) SCARG(p, sigset).i32; /* linux32_sigsetp_t */
		*n_args = 4;
		break;
	}
	/* linux32_sys_set_robust_list */
	case 311: {
		const struct linux32_sys_set_robust_list_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, head).i32; /* linux32_robust_list_headp_t */
		iarg[1] = SCARG(p, len); /* linux32_size_t */
		*n_args = 2;
		break;
	}
	/* linux32_sys_get_robust_list */
	case 312: {
		const struct linux32_sys_get_robust_list_args *p = params;
		iarg[0] = SCARG(p, pid); /* linux32_pid_t */
		uarg[1] = (intptr_t) SCARG(p, head).i32; /* linux32_robust_list_headpp_t */
		uarg[2] = (intptr_t) SCARG(p, len).i32; /* linux32_sizep_t */
		*n_args = 3;
		break;
	}
	/* linux32_sys_utimensat */
	case 320: {
		const struct linux32_sys_utimensat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path).i32; /* netbsd32_charp */
		uarg[2] = (intptr_t) SCARG(p, times).i32; /* linux32_timespecp_t */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux32_sys_dup3 */
	case 330: {
		const struct linux32_sys_dup3_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* linux32_sys_pipe2 */
	case 331: {
		const struct linux32_sys_pipe2_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fd).i32; /* netbsd32_intp */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0:
		break;
	/* linux32_sys_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fork */
	case 2:
		break;
	/* netbsd32_read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_open */
	case 5:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_waitpid */
	case 7:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_intp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_creat */
	case 8:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_link */
	case 9:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_execve */
	case 11:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charpp";
			break;
		case 2:
			p = "netbsd32_charpp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_time */
	case 13:
		switch(ndx) {
		case 0:
			p = "linux32_timep_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		case 2:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_lchown16 */
	case 16:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_uid16_t";
			break;
		case 2:
			p = "linux32_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_break */
	case 17:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* compat_43_netbsd32_olseek */
	case 19:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpid */
	case 20:
		break;
	/* netbsd32_setuid */
	case 23:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 24:
		break;
	/* linux32_sys_stime */
	case 25:
		switch(ndx) {
		case 0:
			p = "linux32_timep_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_alarm */
	case 27:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pause */
	case 29:
		break;
	/* linux32_sys_utime */
	case 30:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_utimbufp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_access */
	case 33:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_nice */
	case 34:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sync */
	case 36:
		break;
	/* linux32_sys_kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_rename */
	case 38:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkdir */
	case 39:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_rmdir */
	case 40:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_pipe */
	case 42:
		switch(ndx) {
		case 0:
			p = "netbsd32_intp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_times */
	case 43:
		switch(ndx) {
		case 0:
			p = "linux32_tmsp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_brk */
	case 45:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setgid */
	case 46:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getgid */
	case 47:
		break;
	/* linux32_sys_signal */
	case 48:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_handlerp_t";
			break;
		default:
			break;
		};
		break;
	/* sys_geteuid */
	case 49:
		break;
	/* sys_getegid */
	case 50:
		break;
	/* netbsd32_acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_u_long";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fcntl */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setpgid */
	case 57:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_oldolduname */
	case 59:
		switch(ndx) {
		case 0:
			p = "linux32_oldold_utsnamep_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_dup2 */
	case 63:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getppid */
	case 64:
		break;
	/* sys_getpgrp */
	case 65:
		break;
	/* sys_setsid */
	case 66:
		break;
	/* linux32_sys_siggetmask */
	case 68:
		break;
	/* linux32_sys_sigsetmask */
	case 69:
		switch(ndx) {
		case 0:
			p = "linux32_old_sigset_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setreuid16 */
	case 70:
		switch(ndx) {
		case 0:
			p = "linux32_uid16_t";
			break;
		case 1:
			p = "linux32_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setregid16 */
	case 71:
		switch(ndx) {
		case 0:
			p = "linux32_gid16_t";
			break;
		case 1:
			p = "linux32_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* compat_43_netbsd32_osethostname */
	case 74:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setrlimit */
	case 75:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "netbsd32_orlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getrlimit */
	case 76:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "netbsd32_orlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* compat_50_netbsd32_getrusage */
	case 77:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_rusage50p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_gettimeofday */
	case 78:
		switch(ndx) {
		case 0:
			p = "netbsd32_timeval50p_t";
			break;
		case 1:
			p = "netbsd32_timezonep_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_settimeofday */
	case 79:
		switch(ndx) {
		case 0:
			p = "netbsd32_timeval50p_t";
			break;
		case 1:
			p = "netbsd32_timezonep_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getgroups16 */
	case 80:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_gid16p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setgroups16 */
	case 81:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_gid16p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_oldselect */
	case 82:
		switch(ndx) {
		case 0:
			p = "linux32_oldselectp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_symlink */
	case 83:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* compat_43_netbsd32_lstat43 */
	case 84:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_stat43p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readlink */
	case 85:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_swapon */
	case 87:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_reboot */
	case 88:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_readdir */
	case 89:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_old_mmap */
	case 90:
		switch(ndx) {
		case 0:
			p = "linux32_oldmmapp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_munmap */
	case 91:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* compat_43_netbsd32_otruncate */
	case 92:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		default:
			break;
		};
		break;
	/* compat_43_netbsd32_oftruncate */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_long";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchmod */
	case 94:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fchown16 */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_uid16_t";
			break;
		case 2:
			p = "linux32_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setpriority */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_profil */
	case 98:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_u_long";
			break;
		case 3:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_statfs */
	case 99:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_statfsp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fstatfs */
	case 100:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_statfsp";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ioperm */
	case 101:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_socketcall */
	case 102:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* compat_50_netbsd32_setitimer */
	case 104:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_itimerval50p_t";
			break;
		case 2:
			p = "netbsd32_itimerval50p_t";
			break;
		default:
			break;
		};
		break;
	/* compat_50_netbsd32_getitimer */
	case 105:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_itimerval50p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_stat */
	case 106:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_statp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_lstat */
	case 107:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_statp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fstat */
	case 108:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_statp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_olduname */
	case 109:
		switch(ndx) {
		case 0:
			p = "linux32_oldutsnamep_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_iopl */
	case 110:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_wait4 */
	case 114:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_intp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_rusage50p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_swapoff */
	case 115:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sysinfo */
	case 116:
		switch(ndx) {
		case 0:
			p = "linux32_sysinfop_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_ipc */
	case 117:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fsync */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sigreturn */
	case 119:
		switch(ndx) {
		case 0:
			p = "linux32_sigcontextp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_clone */
	case 120:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setdomainname */
	case 121:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_uname */
	case 122:
		switch(ndx) {
		case 0:
			p = "linux32_utsnamep";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_modify_ldt */
	case 123:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_mprotect */
	case 125:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getpgid */
	case 132:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fchdir */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_personality */
	case 136:
		switch(ndx) {
		case 0:
			p = "netbsd32_u_long";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setfsuid */
	case 138:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setfsgid */
	case 139:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_llseek */
	case 140:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "netbsd32_voidp";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getdents */
	case 141:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_direntp_t";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_select */
	case 142:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_fd_setp_t";
			break;
		case 2:
			p = "netbsd32_fd_setp_t";
			break;
		case 3:
			p = "netbsd32_fd_setp_t";
			break;
		case 4:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_flock */
	case 143:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___msync13 */
	case 144:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readv */
	case 145:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_writev */
	case 146:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_iovecp_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getsid */
	case 147:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fdatasync */
	case 148:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys___sysctl */
	case 149:
		switch(ndx) {
		case 0:
			p = "linux32___sysctlp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mlock */
	case 150:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_munlock */
	case 151:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mlockall */
	case 152:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munlockall */
	case 153:
		break;
	/* linux32_sys_sched_setparam */
	case 154:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const linux32_sched_paramp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_getparam */
	case 155:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "linux32_sched_paramp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_setscheduler */
	case 156:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux32_sched_paramp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_getscheduler */
	case 157:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_yield */
	case 158:
		break;
	/* linux32_sys_sched_get_priority_max */
	case 159:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_get_priority_min */
	case 160:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_nanosleep */
	case 162:
		switch(ndx) {
		case 0:
			p = "linux32_timespecp_t";
			break;
		case 1:
			p = "linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_mremap */
	case 163:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_u_long";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setresuid16 */
	case 164:
		switch(ndx) {
		case 0:
			p = "linux32_uid16_t";
			break;
		case 1:
			p = "linux32_uid16_t";
			break;
		case 2:
			p = "linux32_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getresuid16 */
	case 165:
		switch(ndx) {
		case 0:
			p = "linux32_uid16p_t";
			break;
		case 1:
			p = "linux32_uid16p_t";
			break;
		case 2:
			p = "linux32_uid16p_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_poll */
	case 168:
		switch(ndx) {
		case 0:
			p = "netbsd32_pollfdp_t";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setresgid16 */
	case 170:
		switch(ndx) {
		case 0:
			p = "linux32_gid16_t";
			break;
		case 1:
			p = "linux32_gid16_t";
			break;
		case 2:
			p = "linux32_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getresgid16 */
	case 171:
		switch(ndx) {
		case 0:
			p = "linux32_gid16p_t";
			break;
		case 1:
			p = "linux32_gid16p_t";
			break;
		case 2:
			p = "linux32_gid16p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigreturn */
	case 173:
		switch(ndx) {
		case 0:
			p = "linux32_ucontextp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigaction */
	case 174:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_sigactionp_t";
			break;
		case 2:
			p = "linux32_sigactionp_t";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigprocmask */
	case 175:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_sigsetp_t";
			break;
		case 2:
			p = "linux32_sigsetp_t";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigpending */
	case 176:
		switch(ndx) {
		case 0:
			p = "linux32_sigsetp_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigtimedwait */
	case 177:
		switch(ndx) {
		case 0:
			p = "const linux32_sigsetp_t";
			break;
		case 1:
			p = "linux32_siginfop_t";
			break;
		case 2:
			p = "const linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_queueinfo */
	case 178:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux32_siginfop_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_rt_sigsuspend */
	case 179:
		switch(ndx) {
		case 0:
			p = "linux32_sigsetp_t";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_pread */
	case 180:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_pwrite */
	case 181:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_voidp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		case 3:
			p = "netbsd32_off_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_chown16 */
	case 182:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_uid16_t";
			break;
		case 2:
			p = "linux32_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___getcwd */
	case 183:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* sys___vfork14 */
	case 190:
		break;
	/* linux32_sys_ugetrlimit */
	case 191:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_orlimitp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_mmap2 */
	case 192:
		switch(ndx) {
		case 0:
			p = "netbsd32_u_long";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "linux32_off_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_truncate64 */
	case 193:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_ftruncate64 */
	case 194:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_stat64 */
	case 195:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_stat64p";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_lstat64 */
	case 196:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "linux32_stat64p";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fstat64 */
	case 197:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_stat64p";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_lchown */
	case 198:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 199:
		break;
	/* sys_getgid */
	case 200:
		break;
	/* sys_geteuid */
	case 201:
		break;
	/* sys_getegid */
	case 202:
		break;
	/* netbsd32_setreuid */
	case 203:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setregid */
	case 204:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getgroups */
	case 205:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_gid_tp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setgroups */
	case 206:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_gid_tp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_fchown */
	case 207:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setresuid */
	case 208:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getresuid */
	case 209:
		switch(ndx) {
		case 0:
			p = "linux32_uidp_t";
			break;
		case 1:
			p = "linux32_uidp_t";
			break;
		case 2:
			p = "linux32_uidp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setresgid */
	case 210:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getresgid */
	case 211:
		switch(ndx) {
		case 0:
			p = "linux32_gidp_t";
			break;
		case 1:
			p = "linux32_gidp_t";
			break;
		case 2:
			p = "linux32_gidp_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32___posix_chown */
	case 212:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setuid */
	case 213:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_setgid */
	case 214:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setfsuid */
	case 215:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_setfsgid */
	case 216:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mincore */
	case 218:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_madvise */
	case 219:
		switch(ndx) {
		case 0:
			p = "netbsd32_voidp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_getdents64 */
	case 220:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux32_dirent64p_t";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	/* linux32_sys_fcntl64 */
	case 221:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_gettid */
	case 224:
		break;
	/* netbsd32_setxattr */
	case 226:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lsetxattr */
	case 227:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fsetxattr */
	case 228:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_getxattr */
	case 229:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lgetxattr */
	case 230:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fgetxattr */
	case 231:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_voidp";
			break;
		case 3:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_listxattr */
	case 232:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_llistxattr */
	case 233:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_flistxattr */
	case 234:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_size_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_removexattr */
	case 235:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_lremovexattr */
	case 236:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_fremovexattr */
	case 237:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_tkill */
	case 238:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_futex */
	case 240:
		switch(ndx) {
		case 0:
			p = "linux32_intp_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "linux32_timespecp_t";
			break;
		case 4:
			p = "linux32_intp_t";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_setaffinity */
	case 241:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "linux32_ulongp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_sched_getaffinity */
	case 242:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "linux32_ulongp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_set_thread_area */
	case 243:
		switch(ndx) {
		case 0:
			p = "linux32_user_descp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_get_thread_area */
	case 244:
		switch(ndx) {
		case 0:
			p = "linux32_user_descp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fadvise64 */
	case 250:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "linux32_size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_exit_group */
	case 252:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_set_tid_address */
	case 258:
		switch(ndx) {
		case 0:
			p = "linux32_intp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_clock_settime */
	case 264:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_clock_gettime */
	case 265:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_clock_getres */
	case 266:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_clock_nanosleep */
	case 267:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux32_timespecp_t";
			break;
		case 3:
			p = "linux32_timespecp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_statfs64 */
	case 268:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "linux32_statfs64p";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fstatfs64 */
	case 269:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_size_t";
			break;
		case 2:
			p = "linux32_statfs64p";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_tgkill */
	case 270:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* compat_50_netbsd32_utimes */
	case 271:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "netbsd32_timeval50p_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fadvise64_64 */
	case 272:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uint32_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "uint32_t";
			break;
		case 4:
			p = "uint32_t";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_openat */
	case 295:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_mkdirat */
	case 296:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_mknodat */
	case 297:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		case 3:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fchownat */
	case 298:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fstatat64 */
	case 300:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "linux32_stat64p";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_unlinkat */
	case 301:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_renameat */
	case 302:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_linkat */
	case 303:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "netbsd32_charp";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_symlinkat */
	case 304:
		switch(ndx) {
		case 0:
			p = "netbsd32_charp";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		default:
			break;
		};
		break;
	/* netbsd32_readlinkat */
	case 305:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "netbsd32_charp";
			break;
		case 3:
			p = "linux32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_fchmodat */
	case 306:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_faccessat */
	case 307:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_ppoll */
	case 309:
		switch(ndx) {
		case 0:
			p = "netbsd32_pollfdp_t";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "linux32_timespecp_t";
			break;
		case 3:
			p = "linux32_sigsetp_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_set_robust_list */
	case 311:
		switch(ndx) {
		case 0:
			p = "linux32_robust_list_headp_t";
			break;
		case 1:
			p = "linux32_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_get_robust_list */
	case 312:
		switch(ndx) {
		case 0:
			p = "linux32_pid_t";
			break;
		case 1:
			p = "linux32_robust_list_headpp_t";
			break;
		case 2:
			p = "linux32_sizep_t";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_utimensat */
	case 320:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "netbsd32_charp";
			break;
		case 2:
			p = "linux32_timespecp_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_dup3 */
	case 330:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux32_sys_pipe2 */
	case 331:
		switch(ndx) {
		case 0:
			p = "netbsd32_intp";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0:
	/* linux32_sys_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fork */
	case 2:
	/* netbsd32_read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* linux32_sys_open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_waitpid */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_creat */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_execve */
	case 11:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_time */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_lchown16 */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_break */
	case 17:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_netbsd32_olseek */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_long";
		break;
	/* sys_getpid */
	case 20:
	/* netbsd32_setuid */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 24:
	/* linux32_sys_stime */
	case 25:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_alarm */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pause */
	case 29:
	/* linux32_sys_utime */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_nice */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sync */
	case 36:
	/* linux32_sys_kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_rename */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkdir */
	case 39:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_rmdir */
	case 40:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_pipe */
	case 42:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_times */
	case 43:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_brk */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setgid */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgid */
	case 47:
	/* linux32_sys_signal */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_geteuid */
	case 49:
	/* sys_getegid */
	case 50:
	/* netbsd32_acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fcntl */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setpgid */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_oldolduname */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_dup2 */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getppid */
	case 64:
	/* sys_getpgrp */
	case 65:
	/* sys_setsid */
	case 66:
	/* linux32_sys_siggetmask */
	case 68:
	/* linux32_sys_sigsetmask */
	case 69:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setreuid16 */
	case 70:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setregid16 */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_netbsd32_osethostname */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setrlimit */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getrlimit */
	case 76:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_netbsd32_getrusage */
	case 77:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_gettimeofday */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_settimeofday */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getgroups16 */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setgroups16 */
	case 81:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_oldselect */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_symlink */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_netbsd32_lstat43 */
	case 84:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readlink */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_swapon */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_reboot */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_readdir */
	case 89:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_old_mmap */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_munmap */
	case 91:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_netbsd32_otruncate */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_netbsd32_oftruncate */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchmod */
	case 94:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fchown16 */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setpriority */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_profil */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_statfs */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fstatfs */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ioperm */
	case 101:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_socketcall */
	case 102:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_netbsd32_setitimer */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_netbsd32_getitimer */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_stat */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_lstat */
	case 107:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fstat */
	case 108:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_olduname */
	case 109:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_iopl */
	case 110:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_wait4 */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_swapoff */
	case 115:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sysinfo */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_ipc */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fsync */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sigreturn */
	case 119:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_clone */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setdomainname */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_uname */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_modify_ldt */
	case 123:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_mprotect */
	case 125:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getpgid */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fchdir */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_personality */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setfsuid */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setfsgid */
	case 139:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_llseek */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getdents */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_select */
	case 142:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_flock */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___msync13 */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readv */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_writev */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* netbsd32_getsid */
	case 147:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* linux32_sys_fdatasync */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys___sysctl */
	case 149:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mlock */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_munlock */
	case 151:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mlockall */
	case 152:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlockall */
	case 153:
	/* linux32_sys_sched_setparam */
	case 154:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_getparam */
	case 155:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_setscheduler */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_getscheduler */
	case 157:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_yield */
	case 158:
	/* linux32_sys_sched_get_priority_max */
	case 159:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_get_priority_min */
	case 160:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_nanosleep */
	case 162:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_mremap */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setresuid16 */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getresuid16 */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_poll */
	case 168:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setresgid16 */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getresgid16 */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigreturn */
	case 173:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigaction */
	case 174:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigprocmask */
	case 175:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigpending */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigtimedwait */
	case 177:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_queueinfo */
	case 178:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_rt_sigsuspend */
	case 179:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_pread */
	case 180:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* linux32_sys_pwrite */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "netbsd32_ssize_t";
		break;
	/* linux32_sys_chown16 */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___getcwd */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___vfork14 */
	case 190:
	/* linux32_sys_ugetrlimit */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_mmap2 */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "linux32_off_t";
		break;
	/* linux32_sys_truncate64 */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_ftruncate64 */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_stat64 */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_lstat64 */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fstat64 */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_lchown */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 199:
	/* sys_getgid */
	case 200:
	/* sys_geteuid */
	case 201:
	/* sys_getegid */
	case 202:
	/* netbsd32_setreuid */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setregid */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getgroups */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setgroups */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_fchown */
	case 207:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setresuid */
	case 208:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getresuid */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setresgid */
	case 210:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getresgid */
	case 211:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32___posix_chown */
	case 212:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setuid */
	case 213:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_setgid */
	case 214:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setfsuid */
	case 215:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_setfsgid */
	case 216:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mincore */
	case 218:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_madvise */
	case 219:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_getdents64 */
	case 220:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	/* linux32_sys_fcntl64 */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_gettid */
	case 224:
	/* netbsd32_setxattr */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lsetxattr */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fsetxattr */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_getxattr */
	case 229:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_lgetxattr */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_fgetxattr */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_listxattr */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_llistxattr */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_flistxattr */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* netbsd32_removexattr */
	case 235:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_lremovexattr */
	case 236:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_fremovexattr */
	case 237:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_tkill */
	case 238:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_futex */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_setaffinity */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_sched_getaffinity */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_set_thread_area */
	case 243:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_get_thread_area */
	case 244:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fadvise64 */
	case 250:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_exit_group */
	case 252:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_set_tid_address */
	case 258:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_clock_settime */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_clock_gettime */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_clock_getres */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_clock_nanosleep */
	case 267:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_statfs64 */
	case 268:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fstatfs64 */
	case 269:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_tgkill */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_netbsd32_utimes */
	case 271:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fadvise64_64 */
	case 272:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_openat */
	case 295:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_mkdirat */
	case 296:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_mknodat */
	case 297:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fchownat */
	case 298:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fstatat64 */
	case 300:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_unlinkat */
	case 301:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_renameat */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_linkat */
	case 303:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_symlinkat */
	case 304:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* netbsd32_readlinkat */
	case 305:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_fchmodat */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_faccessat */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_ppoll */
	case 309:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_set_robust_list */
	case 311:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_get_robust_list */
	case 312:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_utimensat */
	case 320:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_dup3 */
	case 330:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux32_sys_pipe2 */
	case 331:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
