/* $NetBSD: linux32_sysent.c,v 1.78 2017/05/10 06:19:49 riastradh Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.69 2015/03/08 17:10:44 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux32_sysent.c,v 1.78 2017/05/10 06:19:49 riastradh Exp $");

#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <machine/netbsd32_machdep.h>
#include <compat/netbsd32/netbsd32.h>
#include <compat/netbsd32/netbsd32_syscallargs.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux32/common/linux32_types.h>
#include <compat/linux32/common/linux32_signal.h>
#include <compat/linux32/arch/amd64/linux32_missing.h>
#include <compat/linux32/linux32_syscallargs.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register32_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent linux32_sysent[] = {
	{
		.sy_call = (sy_call_t *)linux_sys_nosys
	},		/* 0 = syscall */
	{
		ns(struct linux32_sys_exit_args),
		.sy_call = (sy_call_t *)linux32_sys_exit
	},		/* 1 = exit */
	{
		.sy_call = (sy_call_t *)sys_fork
	},		/* 2 = fork */
	{
		ns(struct netbsd32_read_args),
		.sy_call = (sy_call_t *)netbsd32_read
	},		/* 3 = netbsd32_read */
	{
		ns(struct netbsd32_write_args),
		.sy_call = (sy_call_t *)netbsd32_write
	},		/* 4 = netbsd32_write */
	{
		ns(struct linux32_sys_open_args),
		.sy_call = (sy_call_t *)linux32_sys_open
	},		/* 5 = open */
	{
		ns(struct netbsd32_close_args),
		.sy_call = (sy_call_t *)netbsd32_close
	},		/* 6 = netbsd32_close */
	{
		ns(struct linux32_sys_waitpid_args),
		.sy_call = (sy_call_t *)linux32_sys_waitpid
	},		/* 7 = waitpid */
	{
		ns(struct linux32_sys_creat_args),
		.sy_call = (sy_call_t *)linux32_sys_creat
	},		/* 8 = creat */
	{
		ns(struct netbsd32_link_args),
		.sy_call = (sy_call_t *)netbsd32_link
	},		/* 9 = netbsd32_link */
	{
		ns(struct linux32_sys_unlink_args),
		.sy_call = (sy_call_t *)linux32_sys_unlink
	},		/* 10 = unlink */
	{
		ns(struct netbsd32_execve_args),
		.sy_call = (sy_call_t *)netbsd32_execve
	},		/* 11 = netbsd32_execve */
	{
		ns(struct netbsd32_chdir_args),
		.sy_call = (sy_call_t *)netbsd32_chdir
	},		/* 12 = netbsd32_chdir */
	{
		ns(struct linux32_sys_time_args),
		.sy_call = (sy_call_t *)linux32_sys_time
	},		/* 13 = time */
	{
		ns(struct linux32_sys_mknod_args),
		.sy_call = (sy_call_t *)linux32_sys_mknod
	},		/* 14 = mknod */
	{
		ns(struct netbsd32_chmod_args),
		.sy_call = (sy_call_t *)netbsd32_chmod
	},		/* 15 = netbsd32_chmod */
	{
		ns(struct linux32_sys_lchown16_args),
		.sy_call = (sy_call_t *)linux32_sys_lchown16
	},		/* 16 = lchown16 */
	{
		ns(struct linux32_sys_break_args),
		.sy_call = (sy_call_t *)linux32_sys_break
	},		/* 17 = break */
	{
		.sy_call = linux_sys_nosys,
	},		/* 18 = filler */
	{
		ns(struct compat_43_netbsd32_olseek_args),
		.sy_call = (sy_call_t *)compat_43_netbsd32_olseek
	},		/* 19 = compat_43_netbsd32_olseek */
	{
		.sy_call = (sy_call_t *)sys_getpid
	},		/* 20 = getpid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 21 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 22 = filler */
	{
		ns(struct netbsd32_setuid_args),
		.sy_call = (sy_call_t *)netbsd32_setuid
	},		/* 23 = linux_setuid16 */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 24 = linux_getuid16 */
	{
		ns(struct linux32_sys_stime_args),
		.sy_call = (sy_call_t *)linux32_sys_stime
	},		/* 25 = stime */
	{
		ns(struct linux32_sys_ptrace_args),
		.sy_call = (sy_call_t *)linux32_sys_ptrace
	},		/* 26 = ptrace */
	{
		ns(struct linux32_sys_alarm_args),
		.sy_call = (sy_call_t *)linux32_sys_alarm
	},		/* 27 = alarm */
	{
		.sy_call = linux_sys_nosys,
	},		/* 28 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_pause
	},		/* 29 = pause */
	{
		ns(struct linux32_sys_utime_args),
		.sy_call = (sy_call_t *)linux32_sys_utime
	},		/* 30 = utime */
	{
		.sy_call = linux_sys_nosys,
	},		/* 31 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 32 = filler */
	{
		ns(struct netbsd32_access_args),
		.sy_call = (sy_call_t *)netbsd32_access
	},		/* 33 = netbsd32_access */
	{
		ns(struct linux32_sys_nice_args),
		.sy_call = (sy_call_t *)linux32_sys_nice
	},		/* 34 = nice */
	{
		.sy_call = linux_sys_nosys,
	},		/* 35 = filler */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 36 = sync */
	{
		ns(struct linux32_sys_kill_args),
		.sy_call = (sy_call_t *)linux32_sys_kill
	},		/* 37 = kill */
	{
		ns(struct netbsd32___posix_rename_args),
		.sy_call = (sy_call_t *)netbsd32___posix_rename
	},		/* 38 = netbsd32___posix_rename */
	{
		ns(struct netbsd32_mkdir_args),
		.sy_call = (sy_call_t *)netbsd32_mkdir
	},		/* 39 = netbsd32_mkdir */
	{
		ns(struct netbsd32_rmdir_args),
		.sy_call = (sy_call_t *)netbsd32_rmdir
	},		/* 40 = netbsd32_rmdir */
	{
		ns(struct netbsd32_dup_args),
		.sy_call = (sy_call_t *)netbsd32_dup
	},		/* 41 = netbsd32_dup */
	{
		ns(struct linux32_sys_pipe_args),
		.sy_call = (sy_call_t *)linux32_sys_pipe
	},		/* 42 = pipe */
	{
		ns(struct linux32_sys_times_args),
		.sy_call = (sy_call_t *)linux32_sys_times
	},		/* 43 = times */
	{
		.sy_call = linux_sys_nosys,
	},		/* 44 = filler */
	{
		ns(struct linux32_sys_brk_args),
		.sy_call = (sy_call_t *)linux32_sys_brk
	},		/* 45 = brk */
	{
		ns(struct netbsd32_setgid_args),
		.sy_call = (sy_call_t *)netbsd32_setgid
	},		/* 46 = linux_setgid16 */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 47 = linux_getgid16 */
	{
		ns(struct linux32_sys_signal_args),
		.sy_call = (sy_call_t *)linux32_sys_signal
	},		/* 48 = signal */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 49 = linux_geteuid16 */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 50 = linux_getegid16 */
	{
		ns(struct netbsd32_acct_args),
		.sy_call = (sy_call_t *)netbsd32_acct
	},		/* 51 = netbsd32_acct */
	{
		.sy_call = linux_sys_nosys,
	},		/* 52 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 53 = filler */
	{
		ns(struct linux32_sys_ioctl_args),
		.sy_call = (sy_call_t *)linux32_sys_ioctl
	},		/* 54 = ioctl */
	{
		ns(struct linux32_sys_fcntl_args),
		.sy_call = (sy_call_t *)linux32_sys_fcntl
	},		/* 55 = fcntl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 56 = filler */
	{
		ns(struct netbsd32_setpgid_args),
		.sy_call = (sy_call_t *)netbsd32_setpgid
	},		/* 57 = netbsd32_setpgid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 58 = filler */
	{
		ns(struct linux32_sys_oldolduname_args),
		.sy_call = (sy_call_t *)linux32_sys_oldolduname
	},		/* 59 = oldolduname */
	{
		ns(struct netbsd32_umask_args),
		.sy_call = (sy_call_t *)netbsd32_umask
	},		/* 60 = netbsd32_umask */
	{
		ns(struct netbsd32_chroot_args),
		.sy_call = (sy_call_t *)netbsd32_chroot
	},		/* 61 = netbsd32_chroot */
	{
		.sy_call = linux_sys_nosys,
	},		/* 62 = filler */
	{
		ns(struct netbsd32_dup2_args),
		.sy_call = (sy_call_t *)netbsd32_dup2
	},		/* 63 = netbsd32_dup2 */
	{
		.sy_call = (sy_call_t *)sys_getppid
	},		/* 64 = getppid */
	{
		.sy_call = (sy_call_t *)sys_getpgrp
	},		/* 65 = getpgrp */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 66 = setsid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 67 = filler */
	{
		.sy_call = (sy_call_t *)linux32_sys_siggetmask
	},		/* 68 = siggetmask */
	{
		ns(struct linux32_sys_sigsetmask_args),
		.sy_call = (sy_call_t *)linux32_sys_sigsetmask
	},		/* 69 = sigsetmask */
	{
		ns(struct linux32_sys_setreuid16_args),
		.sy_call = (sy_call_t *)linux32_sys_setreuid16
	},		/* 70 = setreuid16 */
	{
		ns(struct linux32_sys_setregid16_args),
		.sy_call = (sy_call_t *)linux32_sys_setregid16
	},		/* 71 = setregid16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 72 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 73 = filler */
	{
		ns(struct compat_43_netbsd32_osethostname_args),
		.sy_call = (sy_call_t *)compat_43_netbsd32_osethostname
	},		/* 74 = compat_43_netbsd32_osethostname */
	{
		ns(struct linux32_sys_setrlimit_args),
		.sy_call = (sy_call_t *)linux32_sys_setrlimit
	},		/* 75 = setrlimit */
	{
		ns(struct linux32_sys_getrlimit_args),
		.sy_call = (sy_call_t *)linux32_sys_getrlimit
	},		/* 76 = getrlimit */
	{
		ns(struct compat_50_netbsd32_getrusage_args),
		.sy_call = (sy_call_t *)compat_50_netbsd32_getrusage
	},		/* 77 = compat_50_netbsd32_getrusage */
	{
		ns(struct linux32_sys_gettimeofday_args),
		.sy_call = (sy_call_t *)linux32_sys_gettimeofday
	},		/* 78 = gettimeofday */
	{
		ns(struct linux32_sys_settimeofday_args),
		.sy_call = (sy_call_t *)linux32_sys_settimeofday
	},		/* 79 = settimeofday */
	{
		ns(struct linux32_sys_getgroups16_args),
		.sy_call = (sy_call_t *)linux32_sys_getgroups16
	},		/* 80 = getgroups16 */
	{
		ns(struct linux32_sys_setgroups16_args),
		.sy_call = (sy_call_t *)linux32_sys_setgroups16
	},		/* 81 = setgroups16 */
	{
		ns(struct linux32_sys_oldselect_args),
		.sy_call = (sy_call_t *)linux32_sys_oldselect
	},		/* 82 = oldselect */
	{
		ns(struct netbsd32_symlink_args),
		.sy_call = (sy_call_t *)netbsd32_symlink
	},		/* 83 = netbsd32_symlink */
	{
		ns(struct compat_43_netbsd32_lstat43_args),
		.sy_call = (sy_call_t *)compat_43_netbsd32_lstat43
	},		/* 84 = compat_43_netbsd32_lstat43 */
	{
		ns(struct netbsd32_readlink_args),
		.sy_call = (sy_call_t *)netbsd32_readlink
	},		/* 85 = netbsd32_readlink */
	{
		.sy_call = linux_sys_nosys,
	},		/* 86 = filler */
	{
		ns(struct linux32_sys_swapon_args),
		.sy_call = (sy_call_t *)linux32_sys_swapon
	},		/* 87 = swapon */
	{
		ns(struct linux32_sys_reboot_args),
		.sy_call = (sy_call_t *)linux32_sys_reboot
	},		/* 88 = reboot */
	{
		ns(struct linux32_sys_readdir_args),
		.sy_call = (sy_call_t *)linux32_sys_readdir
	},		/* 89 = readdir */
	{
		ns(struct linux32_sys_old_mmap_args),
		.sy_call = (sy_call_t *)linux32_sys_old_mmap
	},		/* 90 = old_mmap */
	{
		ns(struct netbsd32_munmap_args),
		.sy_call = (sy_call_t *)netbsd32_munmap
	},		/* 91 = netbsd32_munmap */
	{
		ns(struct compat_43_netbsd32_otruncate_args),
		.sy_call = (sy_call_t *)compat_43_netbsd32_otruncate
	},		/* 92 = compat_43_netbsd32_otruncate */
	{
		ns(struct compat_43_netbsd32_oftruncate_args),
		.sy_call = (sy_call_t *)compat_43_netbsd32_oftruncate
	},		/* 93 = compat_43_netbsd32_oftruncate */
	{
		ns(struct netbsd32_fchmod_args),
		.sy_call = (sy_call_t *)netbsd32_fchmod
	},		/* 94 = netbsd32_fchmod */
	{
		ns(struct linux32_sys_fchown16_args),
		.sy_call = (sy_call_t *)linux32_sys_fchown16
	},		/* 95 = fchown16 */
	{
		ns(struct linux32_sys_getpriority_args),
		.sy_call = (sy_call_t *)linux32_sys_getpriority
	},		/* 96 = getpriority */
	{
		ns(struct netbsd32_setpriority_args),
		.sy_call = (sy_call_t *)netbsd32_setpriority
	},		/* 97 = netbsd32_setpriority */
	{
		ns(struct netbsd32_profil_args),
		.sy_call = (sy_call_t *)netbsd32_profil
	},		/* 98 = netbsd32_profil */
	{
		ns(struct linux32_sys_statfs_args),
		.sy_call = (sy_call_t *)linux32_sys_statfs
	},		/* 99 = statfs */
	{
		ns(struct linux32_sys_fstatfs_args),
		.sy_call = (sy_call_t *)linux32_sys_fstatfs
	},		/* 100 = fstatfs */
	{
		ns(struct linux_sys_ioperm_args),
		.sy_call = (sy_call_t *)linux_sys_ioperm
	},		/* 101 = ioperm */
	{
		ns(struct linux32_sys_socketcall_args),
		.sy_call = (sy_call_t *)linux32_sys_socketcall
	},		/* 102 = socketcall */
	{
		.sy_call = linux_sys_nosys,
	},		/* 103 = filler */
	{
		ns(struct compat_50_netbsd32_setitimer_args),
		.sy_call = (sy_call_t *)compat_50_netbsd32_setitimer
	},		/* 104 = compat_50_netbsd32_setitimer */
	{
		ns(struct compat_50_netbsd32_getitimer_args),
		.sy_call = (sy_call_t *)compat_50_netbsd32_getitimer
	},		/* 105 = compat_50_netbsd32_getitimer */
	{
		ns(struct linux32_sys_stat_args),
		.sy_call = (sy_call_t *)linux32_sys_stat
	},		/* 106 = stat */
	{
		ns(struct linux32_sys_lstat_args),
		.sy_call = (sy_call_t *)linux32_sys_lstat
	},		/* 107 = lstat */
	{
		ns(struct linux32_sys_fstat_args),
		.sy_call = (sy_call_t *)linux32_sys_fstat
	},		/* 108 = fstat */
	{
		ns(struct linux32_sys_olduname_args),
		.sy_call = (sy_call_t *)linux32_sys_olduname
	},		/* 109 = olduname */
	{
		ns(struct linux_sys_iopl_args),
		.sy_call = (sy_call_t *)linux_sys_iopl
	},		/* 110 = iopl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 111 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 112 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 113 = filler */
	{
		ns(struct linux32_sys_wait4_args),
		.sy_call = (sy_call_t *)linux32_sys_wait4
	},		/* 114 = wait4 */
	{
		ns(struct linux32_sys_swapoff_args),
		.sy_call = (sy_call_t *)linux32_sys_swapoff
	},		/* 115 = swapoff */
	{
		ns(struct linux32_sys_sysinfo_args),
		.sy_call = (sy_call_t *)linux32_sys_sysinfo
	},		/* 116 = sysinfo */
	{
		ns(struct linux32_sys_ipc_args),
		.sy_call = (sy_call_t *)linux32_sys_ipc
	},		/* 117 = ipc */
	{
		ns(struct netbsd32_fsync_args),
		.sy_call = (sy_call_t *)netbsd32_fsync
	},		/* 118 = netbsd32_fsync */
	{
		ns(struct linux32_sys_sigreturn_args),
		.sy_call = (sy_call_t *)linux32_sys_sigreturn
	},		/* 119 = sigreturn */
	{
		ns(struct linux32_sys_clone_args),
		.sy_call = (sy_call_t *)linux32_sys_clone
	},		/* 120 = clone */
	{
		ns(struct linux32_sys_setdomainname_args),
		.sy_call = (sy_call_t *)linux32_sys_setdomainname
	},		/* 121 = setdomainname */
	{
		ns(struct linux32_sys_uname_args),
		.sy_call = (sy_call_t *)linux32_sys_uname
	},		/* 122 = uname */
	{
		ns(struct linux32_sys_modify_ldt_args),
		.sy_call = (sy_call_t *)linux32_sys_modify_ldt
	},		/* 123 = modify_ldt */
	{
		.sy_call = linux_sys_nosys,
	},		/* 124 = filler */
	{
		ns(struct linux32_sys_mprotect_args),
		.sy_call = (sy_call_t *)linux32_sys_mprotect
	},		/* 125 = mprotect */
	{
		.sy_call = linux_sys_nosys,
	},		/* 126 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 127 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 128 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 129 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 130 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 131 = filler */
	{
		ns(struct netbsd32_getpgid_args),
		.sy_call = (sy_call_t *)netbsd32_getpgid
	},		/* 132 = netbsd32_getpgid */
	{
		ns(struct netbsd32_fchdir_args),
		.sy_call = (sy_call_t *)netbsd32_fchdir
	},		/* 133 = netbsd32_fchdir */
	{
		.sy_call = linux_sys_nosys,
	},		/* 134 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 135 = filler */
	{
		ns(struct linux32_sys_personality_args),
		.sy_call = (sy_call_t *)linux32_sys_personality
	},		/* 136 = personality */
	{
		.sy_call = linux_sys_nosys,
	},		/* 137 = filler */
	{
		ns(struct linux32_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux32_sys_setfsuid
	},		/* 138 = setfsuid16 */
	{
		ns(struct linux32_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux32_sys_setfsgid
	},		/* 139 = setfsgid16 */
	{
		ns(struct linux32_sys_llseek_args),
		.sy_call = (sy_call_t *)linux32_sys_llseek
	},		/* 140 = llseek */
	{
		ns(struct linux32_sys_getdents_args),
		.sy_call = (sy_call_t *)linux32_sys_getdents
	},		/* 141 = getdents */
	{
		ns(struct linux32_sys_select_args),
		.sy_call = (sy_call_t *)linux32_sys_select
	},		/* 142 = select */
	{
		ns(struct netbsd32_flock_args),
		.sy_call = (sy_call_t *)netbsd32_flock
	},		/* 143 = netbsd32_flock */
	{
		ns(struct netbsd32___msync13_args),
		.sy_call = (sy_call_t *)netbsd32___msync13
	},		/* 144 = netbsd32___msync13 */
	{
		ns(struct netbsd32_readv_args),
		.sy_call = (sy_call_t *)netbsd32_readv
	},		/* 145 = netbsd32_readv */
	{
		ns(struct netbsd32_writev_args),
		.sy_call = (sy_call_t *)netbsd32_writev
	},		/* 146 = netbsd32_writev */
	{
		ns(struct netbsd32_getsid_args),
		.sy_call = (sy_call_t *)netbsd32_getsid
	},		/* 147 = netbsd32_getsid */
	{
		ns(struct linux32_sys_fdatasync_args),
		.sy_call = (sy_call_t *)linux32_sys_fdatasync
	},		/* 148 = fdatasync */
	{
		ns(struct linux32_sys___sysctl_args),
		.sy_call = (sy_call_t *)linux32_sys___sysctl
	},		/* 149 = __sysctl */
	{
		ns(struct netbsd32_mlock_args),
		.sy_call = (sy_call_t *)netbsd32_mlock
	},		/* 150 = netbsd32_mlock */
	{
		ns(struct netbsd32_munlock_args),
		.sy_call = (sy_call_t *)netbsd32_munlock
	},		/* 151 = netbsd32_munlock */
	{
		ns(struct netbsd32_mlockall_args),
		.sy_call = (sy_call_t *)netbsd32_mlockall
	},		/* 152 = netbsd32_mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 153 = munlockall */
	{
		ns(struct linux32_sys_sched_setparam_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_setparam
	},		/* 154 = sched_setparam */
	{
		ns(struct linux32_sys_sched_getparam_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_getparam
	},		/* 155 = sched_getparam */
	{
		ns(struct linux32_sys_sched_setscheduler_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_setscheduler
	},		/* 156 = sched_setscheduler */
	{
		ns(struct linux32_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_getscheduler
	},		/* 157 = sched_getscheduler */
	{
		.sy_call = (sy_call_t *)linux_sys_sched_yield
	},		/* 158 = sched_yield */
	{
		ns(struct linux32_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_get_priority_max
	},		/* 159 = sched_get_priority_max */
	{
		ns(struct linux32_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_get_priority_min
	},		/* 160 = sched_get_priority_min */
	{
		.sy_call = linux_sys_nosys,
	},		/* 161 = filler */
	{
		ns(struct linux32_sys_nanosleep_args),
		.sy_call = (sy_call_t *)linux32_sys_nanosleep
	},		/* 162 = nanosleep */
	{
		ns(struct linux32_sys_mremap_args),
		.sy_call = (sy_call_t *)linux32_sys_mremap
	},		/* 163 = mremap */
	{
		ns(struct linux32_sys_setresuid16_args),
		.sy_call = (sy_call_t *)linux32_sys_setresuid16
	},		/* 164 = setresuid16 */
	{
		ns(struct linux32_sys_getresuid16_args),
		.sy_call = (sy_call_t *)linux32_sys_getresuid16
	},		/* 165 = getresuid16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 166 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 167 = filler */
	{
		ns(struct netbsd32_poll_args),
		.sy_call = (sy_call_t *)netbsd32_poll
	},		/* 168 = netbsd32_poll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 169 = filler */
	{
		ns(struct linux32_sys_setresgid16_args),
		.sy_call = (sy_call_t *)linux32_sys_setresgid16
	},		/* 170 = setresgid16 */
	{
		ns(struct linux32_sys_getresgid16_args),
		.sy_call = (sy_call_t *)linux32_sys_getresgid16
	},		/* 171 = getresgid16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 172 = filler */
	{
		ns(struct linux32_sys_rt_sigreturn_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigreturn
	},		/* 173 = rt_sigreturn */
	{
		ns(struct linux32_sys_rt_sigaction_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigaction
	},		/* 174 = rt_sigaction */
	{
		ns(struct linux32_sys_rt_sigprocmask_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigprocmask
	},		/* 175 = rt_sigprocmask */
	{
		ns(struct linux32_sys_rt_sigpending_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigpending
	},		/* 176 = rt_sigpending */
	{
		ns(struct linux32_sys_rt_sigtimedwait_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigtimedwait
	},		/* 177 = rt_sigtimedwait */
	{
		ns(struct linux32_sys_rt_queueinfo_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_queueinfo
	},		/* 178 = rt_queueinfo */
	{
		ns(struct linux32_sys_rt_sigsuspend_args),
		.sy_call = (sy_call_t *)linux32_sys_rt_sigsuspend
	},		/* 179 = rt_sigsuspend */
	{
		ns(struct linux32_sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64,
		.sy_call = (sy_call_t *)linux32_sys_pread
	},		/* 180 = pread */
	{
		ns(struct linux32_sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64,
		.sy_call = (sy_call_t *)linux32_sys_pwrite
	},		/* 181 = pwrite */
	{
		ns(struct linux32_sys_chown16_args),
		.sy_call = (sy_call_t *)linux32_sys_chown16
	},		/* 182 = chown16 */
	{
		ns(struct netbsd32___getcwd_args),
		.sy_call = (sy_call_t *)netbsd32___getcwd
	},		/* 183 = netbsd32___getcwd */
	{
		.sy_call = linux_sys_nosys,
	},		/* 184 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 185 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 186 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 187 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 188 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 189 = filler */
	{
		.sy_call = (sy_call_t *)sys___vfork14
	},		/* 190 = __vfork14 */
	{
		ns(struct linux32_sys_ugetrlimit_args),
		.sy_call = (sy_call_t *)linux32_sys_ugetrlimit
	},		/* 191 = ugetrlimit */
	{
		ns(struct linux32_sys_mmap2_args),
		.sy_call = (sy_call_t *)linux32_sys_mmap2
	},		/* 192 = mmap2 */
	{
		ns(struct linux32_sys_truncate64_args),
		.sy_call = (sy_call_t *)linux32_sys_truncate64
	},		/* 193 = truncate64 */
	{
		ns(struct linux32_sys_ftruncate64_args),
		.sy_call = (sy_call_t *)linux32_sys_ftruncate64
	},		/* 194 = ftruncate64 */
	{
		ns(struct linux32_sys_stat64_args),
		.sy_call = (sy_call_t *)linux32_sys_stat64
	},		/* 195 = stat64 */
	{
		ns(struct linux32_sys_lstat64_args),
		.sy_call = (sy_call_t *)linux32_sys_lstat64
	},		/* 196 = lstat64 */
	{
		ns(struct linux32_sys_fstat64_args),
		.sy_call = (sy_call_t *)linux32_sys_fstat64
	},		/* 197 = fstat64 */
	{
		ns(struct netbsd32___posix_lchown_args),
		.sy_call = (sy_call_t *)netbsd32___posix_lchown
	},		/* 198 = netbsd32___posix_lchown */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 199 = getuid */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 200 = getgid */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 201 = geteuid */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 202 = getegid */
	{
		ns(struct netbsd32_setreuid_args),
		.sy_call = (sy_call_t *)netbsd32_setreuid
	},		/* 203 = netbsd32_setreuid */
	{
		ns(struct netbsd32_setregid_args),
		.sy_call = (sy_call_t *)netbsd32_setregid
	},		/* 204 = netbsd32_setregid */
	{
		ns(struct netbsd32_getgroups_args),
		.sy_call = (sy_call_t *)netbsd32_getgroups
	},		/* 205 = netbsd32_getgroups */
	{
		ns(struct netbsd32_setgroups_args),
		.sy_call = (sy_call_t *)netbsd32_setgroups
	},		/* 206 = netbsd32_setgroups */
	{
		ns(struct netbsd32___posix_fchown_args),
		.sy_call = (sy_call_t *)netbsd32___posix_fchown
	},		/* 207 = netbsd32___posix_fchown */
	{
		ns(struct linux32_sys_setresuid_args),
		.sy_call = (sy_call_t *)linux32_sys_setresuid
	},		/* 208 = setresuid */
	{
		ns(struct linux32_sys_getresuid_args),
		.sy_call = (sy_call_t *)linux32_sys_getresuid
	},		/* 209 = getresuid */
	{
		ns(struct linux32_sys_setresgid_args),
		.sy_call = (sy_call_t *)linux32_sys_setresgid
	},		/* 210 = setresgid */
	{
		ns(struct linux32_sys_getresgid_args),
		.sy_call = (sy_call_t *)linux32_sys_getresgid
	},		/* 211 = getresgid */
	{
		ns(struct netbsd32___posix_chown_args),
		.sy_call = (sy_call_t *)netbsd32___posix_chown
	},		/* 212 = netbsd32___posix_chown */
	{
		ns(struct netbsd32_setuid_args),
		.sy_call = (sy_call_t *)netbsd32_setuid
	},		/* 213 = netbsd32_setuid */
	{
		ns(struct netbsd32_setgid_args),
		.sy_call = (sy_call_t *)netbsd32_setgid
	},		/* 214 = netbsd32_setgid */
	{
		ns(struct linux32_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux32_sys_setfsuid
	},		/* 215 = setfsuid */
	{
		ns(struct linux32_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux32_sys_setfsgid
	},		/* 216 = setfsgid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 217 = filler */
	{
		ns(struct netbsd32_mincore_args),
		.sy_call = (sy_call_t *)netbsd32_mincore
	},		/* 218 = netbsd32_mincore */
	{
		ns(struct netbsd32_madvise_args),
		.sy_call = (sy_call_t *)netbsd32_madvise
	},		/* 219 = netbsd32_madvise */
	{
		ns(struct linux32_sys_getdents64_args),
		.sy_call = (sy_call_t *)linux32_sys_getdents64
	},		/* 220 = getdents64 */
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	{
		ns(struct linux32_sys_fcntl64_args),
		.sy_call = (sy_call_t *)linux32_sys_fcntl64
	},		/* 221 = fcntl64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 222 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 223 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_gettid
	},		/* 224 = gettid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 225 = filler */
	{
		ns(struct netbsd32_setxattr_args),
		.sy_call = (sy_call_t *)netbsd32_setxattr
	},		/* 226 = netbsd32_setxattr */
	{
		ns(struct netbsd32_lsetxattr_args),
		.sy_call = (sy_call_t *)netbsd32_lsetxattr
	},		/* 227 = netbsd32_lsetxattr */
	{
		ns(struct netbsd32_fsetxattr_args),
		.sy_call = (sy_call_t *)netbsd32_fsetxattr
	},		/* 228 = netbsd32_fsetxattr */
	{
		ns(struct netbsd32_getxattr_args),
		.sy_call = (sy_call_t *)netbsd32_getxattr
	},		/* 229 = netbsd32_getxattr */
	{
		ns(struct netbsd32_lgetxattr_args),
		.sy_call = (sy_call_t *)netbsd32_lgetxattr
	},		/* 230 = netbsd32_lgetxattr */
	{
		ns(struct netbsd32_fgetxattr_args),
		.sy_call = (sy_call_t *)netbsd32_fgetxattr
	},		/* 231 = netbsd32_fgetxattr */
	{
		ns(struct netbsd32_listxattr_args),
		.sy_call = (sy_call_t *)netbsd32_listxattr
	},		/* 232 = netbsd32_listxattr */
	{
		ns(struct netbsd32_llistxattr_args),
		.sy_call = (sy_call_t *)netbsd32_llistxattr
	},		/* 233 = netbsd32_llistxattr */
	{
		ns(struct netbsd32_flistxattr_args),
		.sy_call = (sy_call_t *)netbsd32_flistxattr
	},		/* 234 = netbsd32_flistxattr */
	{
		ns(struct netbsd32_removexattr_args),
		.sy_call = (sy_call_t *)netbsd32_removexattr
	},		/* 235 = netbsd32_removexattr */
	{
		ns(struct netbsd32_lremovexattr_args),
		.sy_call = (sy_call_t *)netbsd32_lremovexattr
	},		/* 236 = netbsd32_lremovexattr */
	{
		ns(struct netbsd32_fremovexattr_args),
		.sy_call = (sy_call_t *)netbsd32_fremovexattr
	},		/* 237 = netbsd32_fremovexattr */
	{
		ns(struct linux32_sys_tkill_args),
		.sy_call = (sy_call_t *)linux32_sys_tkill
	},		/* 238 = tkill */
	{
		.sy_call = linux_sys_nosys,
	},		/* 239 = filler */
	{
		ns(struct linux32_sys_futex_args),
		.sy_call = (sy_call_t *)linux32_sys_futex
	},		/* 240 = futex */
	{
		ns(struct linux32_sys_sched_setaffinity_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_setaffinity
	},		/* 241 = sched_setaffinity */
	{
		ns(struct linux32_sys_sched_getaffinity_args),
		.sy_call = (sy_call_t *)linux32_sys_sched_getaffinity
	},		/* 242 = sched_getaffinity */
	{
		ns(struct linux32_sys_set_thread_area_args),
		.sy_call = (sy_call_t *)linux32_sys_set_thread_area
	},		/* 243 = set_thread_area */
	{
		ns(struct linux32_sys_get_thread_area_args),
		.sy_call = (sy_call_t *)linux32_sys_get_thread_area
	},		/* 244 = get_thread_area */
	{
		.sy_call = linux_sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 247 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 248 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 249 = filler */
	{
		ns(struct linux32_sys_fadvise64_args),
		.sy_call = (sy_call_t *)linux32_sys_fadvise64
	},		/* 250 = fadvise64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 251 = filler */
	{
		ns(struct linux32_sys_exit_group_args),
		.sy_call = (sy_call_t *)linux32_sys_exit_group
	},		/* 252 = exit_group */
	{
		.sy_call = linux_sys_nosys,
	},		/* 253 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 254 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 255 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 256 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 257 = filler */
	{
		ns(struct linux32_sys_set_tid_address_args),
		.sy_call = (sy_call_t *)linux32_sys_set_tid_address
	},		/* 258 = set_tid_address */
	{
		.sy_call = linux_sys_nosys,
	},		/* 259 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 260 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 261 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 262 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 263 = filler */
	{
		ns(struct linux32_sys_clock_settime_args),
		.sy_call = (sy_call_t *)linux32_sys_clock_settime
	},		/* 264 = clock_settime */
	{
		ns(struct linux32_sys_clock_gettime_args),
		.sy_call = (sy_call_t *)linux32_sys_clock_gettime
	},		/* 265 = clock_gettime */
	{
		ns(struct linux32_sys_clock_getres_args),
		.sy_call = (sy_call_t *)linux32_sys_clock_getres
	},		/* 266 = clock_getres */
	{
		ns(struct linux32_sys_clock_nanosleep_args),
		.sy_call = (sy_call_t *)linux32_sys_clock_nanosleep
	},		/* 267 = clock_nanosleep */
	{
		ns(struct linux32_sys_statfs64_args),
		.sy_call = (sy_call_t *)linux32_sys_statfs64
	},		/* 268 = statfs64 */
	{
		ns(struct linux32_sys_fstatfs64_args),
		.sy_call = (sy_call_t *)linux32_sys_fstatfs64
	},		/* 269 = fstatfs64 */
	{
		ns(struct linux32_sys_tgkill_args),
		.sy_call = (sy_call_t *)linux32_sys_tgkill
	},		/* 270 = tgkill */
	{
		ns(struct compat_50_netbsd32_utimes_args),
		.sy_call = (sy_call_t *)compat_50_netbsd32_utimes
	},		/* 271 = compat_50_netbsd32_utimes */
	{
		ns(struct linux32_sys_fadvise64_64_args),
		.sy_call = (sy_call_t *)linux32_sys_fadvise64_64
	},		/* 272 = fadvise64_64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 273 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 274 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 275 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 276 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 277 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 278 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 279 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 280 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 284 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 285 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 287 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 288 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 290 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 291 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 292 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 293 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 294 = filler */
	{
		ns(struct linux32_sys_openat_args),
		.sy_call = (sy_call_t *)linux32_sys_openat
	},		/* 295 = openat */
	{
		ns(struct netbsd32_mkdirat_args),
		.sy_call = (sy_call_t *)netbsd32_mkdirat
	},		/* 296 = netbsd32_mkdirat */
	{
		ns(struct linux32_sys_mknodat_args),
		.sy_call = (sy_call_t *)linux32_sys_mknodat
	},		/* 297 = mknodat */
	{
		ns(struct linux32_sys_fchownat_args),
		.sy_call = (sy_call_t *)linux32_sys_fchownat
	},		/* 298 = fchownat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 299 = filler */
	{
		ns(struct linux32_sys_fstatat64_args),
		.sy_call = (sy_call_t *)linux32_sys_fstatat64
	},		/* 300 = fstatat64 */
	{
		ns(struct linux32_sys_unlinkat_args),
		.sy_call = (sy_call_t *)linux32_sys_unlinkat
	},		/* 301 = unlinkat */
	{
		ns(struct netbsd32_renameat_args),
		.sy_call = (sy_call_t *)netbsd32_renameat
	},		/* 302 = netbsd32_renameat */
	{
		ns(struct linux32_sys_linkat_args),
		.sy_call = (sy_call_t *)linux32_sys_linkat
	},		/* 303 = linkat */
	{
		ns(struct netbsd32_symlinkat_args),
		.sy_call = (sy_call_t *)netbsd32_symlinkat
	},		/* 304 = netbsd32_symlinkat */
	{
		ns(struct netbsd32_readlinkat_args),
		.sy_call = (sy_call_t *)netbsd32_readlinkat
	},		/* 305 = netbsd32_readlinkat */
	{
		ns(struct linux32_sys_fchmodat_args),
		.sy_call = (sy_call_t *)linux32_sys_fchmodat
	},		/* 306 = fchmodat */
	{
		ns(struct linux32_sys_faccessat_args),
		.sy_call = (sy_call_t *)linux32_sys_faccessat
	},		/* 307 = faccessat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 308 = filler */
	{
		ns(struct linux32_sys_ppoll_args),
		.sy_call = (sy_call_t *)linux32_sys_ppoll
	},		/* 309 = ppoll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 310 = filler */
	{
		ns(struct linux32_sys_set_robust_list_args),
		.sy_call = (sy_call_t *)linux32_sys_set_robust_list
	},		/* 311 = set_robust_list */
	{
		ns(struct linux32_sys_get_robust_list_args),
		.sy_call = (sy_call_t *)linux32_sys_get_robust_list
	},		/* 312 = get_robust_list */
	{
		.sy_call = linux_sys_nosys,
	},		/* 313 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 314 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 315 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 316 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 317 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 318 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 319 = filler */
	{
		ns(struct linux32_sys_utimensat_args),
		.sy_call = (sy_call_t *)linux32_sys_utimensat
	},		/* 320 = utimensat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 321 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 322 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 323 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 324 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 325 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 326 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 327 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 328 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 329 = filler */
	{
		ns(struct linux32_sys_dup3_args),
		.sy_call = (sy_call_t *)linux32_sys_dup3
	},		/* 330 = dup3 */
	{
		ns(struct linux32_sys_pipe2_args),
		.sy_call = (sy_call_t *)linux32_sys_pipe2
	},		/* 331 = pipe2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 332 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 333 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 334 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 335 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 336 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 337 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 338 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 339 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 340 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 341 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 342 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 343 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 344 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 347 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 348 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 349 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 350 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 351 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 352 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 353 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 354 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 355 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 356 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 357 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 358 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 359 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 360 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 361 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 362 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 363 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 364 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 365 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 366 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 367 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 368 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 369 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 373 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 374 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 375 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 376 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 377 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 378 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 380 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 381 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 382 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 383 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 384 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 385 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 386 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 387 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 388 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 389 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 390 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 391 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 392 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 393 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 394 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 395 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 396 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 399 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 400 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 401 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 402 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 403 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 404 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 405 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 406 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 407 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 408 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 410 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 411 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 412 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 413 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 418 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 419 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 420 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 421 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 422 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 423 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 424 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 425 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 426 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 427 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 434 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 435 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 436 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 438 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 439 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 440 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 441 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 449 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 450 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 451 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 452 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 453 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 454 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 455 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 456 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 457 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 458 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 459 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 460 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 461 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 462 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 463 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 464 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 465 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 466 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 467 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 474 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 475 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 478 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 479 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 486 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 487 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 488 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 501 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 502 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 503 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 511 = filler */
};
