/* $NetBSD: linux_systrace_args.c,v 1.12 2017/05/10 06:19:48 riastradh Exp $ */

/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(register_t sysnum, const void *params, uintptr_t *uarg, size_t *n_args)
{
	intptr_t *iarg  = (intptr_t *)uarg;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0: {
		*n_args = 0;
		break;
	}
	/* linux_sys_exit */
	case 1: {
		const struct linux_sys_exit_args *p = params;
		iarg[0] = SCARG(p, rval); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* sys_read */
	case 3: {
		const struct sys_read_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_write */
	case 4: {
		const struct sys_write_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* const void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_open */
	case 5: {
		const struct linux_sys_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* sys_close */
	case 6: {
		const struct sys_close_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_waitpid */
	case 7: {
		const struct linux_sys_waitpid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status); /* int * */
		iarg[2] = SCARG(p, options); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_creat */
	case 8: {
		const struct linux_sys_creat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys_link */
	case 9: {
		const struct sys_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_unlink */
	case 10: {
		const struct linux_sys_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_execve */
	case 11: {
		const struct sys_execve_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, argp); /* char ** */
		uarg[2] = (intptr_t) SCARG(p, envp); /* char ** */
		*n_args = 3;
		break;
	}
	/* sys_chdir */
	case 12: {
		const struct sys_chdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_time */
	case 13: {
		const struct linux_sys_time_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, t); /* linux_time_t * */
		*n_args = 1;
		break;
	}
	/* linux_sys_mknod */
	case 14: {
		const struct linux_sys_mknod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		uarg[2] = SCARG(p, dev); /* unsigned */
		*n_args = 3;
		break;
	}
	/* sys_chmod */
	case 15: {
		const struct sys_chmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_lchown16 */
	case 16: {
		const struct linux_sys_lchown16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, uid); /* linux_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux_gid16_t */
		*n_args = 3;
		break;
	}
	/* compat_43_sys_lseek */
	case 19: {
		const struct compat_43_sys_lseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* long */
		iarg[2] = SCARG(p, whence); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* sys_setuid */
	case 23: {
		const struct sys_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_getuid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* linux_sys_stime */
	case 25: {
		const struct linux_sys_stime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, t); /* linux_time_t * */
		*n_args = 1;
		break;
	}
	/* linux_sys_ptrace */
	case 26: {
		const struct linux_sys_ptrace_args *p = params;
		iarg[0] = SCARG(p, request); /* int */
		iarg[1] = SCARG(p, pid); /* int */
		iarg[2] = SCARG(p, addr); /* int */
		iarg[3] = SCARG(p, data); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_alarm */
	case 27: {
		const struct linux_sys_alarm_args *p = params;
		uarg[0] = SCARG(p, secs); /* unsigned int */
		*n_args = 1;
		break;
	}
	/* linux_sys_pause */
	case 29: {
		*n_args = 0;
		break;
	}
	/* linux_sys_utime */
	case 30: {
		const struct linux_sys_utime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, times); /* struct linux_utimbuf * */
		*n_args = 2;
		break;
	}
	/* sys_access */
	case 33: {
		const struct sys_access_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_nice */
	case 34: {
		const struct linux_sys_nice_args *p = params;
		iarg[0] = SCARG(p, incr); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* linux_sys_kill */
	case 37: {
		const struct linux_sys_kill_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* sys___posix_rename */
	case 38: {
		const struct sys___posix_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_mkdir */
	case 39: {
		const struct sys_mkdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys_rmdir */
	case 40: {
		const struct sys_rmdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_dup */
	case 41: {
		const struct sys_dup_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_pipe */
	case 42: {
		const struct linux_sys_pipe_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pfds); /* int * */
		*n_args = 1;
		break;
	}
	/* linux_sys_times */
	case 43: {
		const struct linux_sys_times_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tms); /* struct times * */
		*n_args = 1;
		break;
	}
	/* linux_sys_brk */
	case 45: {
		const struct linux_sys_brk_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize); /* char * */
		*n_args = 1;
		break;
	}
	/* sys_setgid */
	case 46: {
		const struct sys_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_getgid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* linux_sys_signal */
	case 48: {
		const struct linux_sys_signal_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, handler); /* linux_handler_t */
		*n_args = 2;
		break;
	}
	/* sys_geteuid */
	case 49: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 50: {
		*n_args = 0;
		break;
	}
	/* sys_acct */
	case 51: {
		const struct sys_acct_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_ioctl */
	case 54: {
		const struct linux_sys_ioctl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, com); /* u_long */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		*n_args = 3;
		break;
	}
	/* linux_sys_fcntl */
	case 55: {
		const struct linux_sys_fcntl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 3;
		break;
	}
	/* sys_setpgid */
	case 57: {
		const struct sys_setpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, pgid); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_oldolduname */
	case 59: {
		const struct linux_sys_oldolduname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up); /* struct linux_oldold_utsname * */
		*n_args = 1;
		break;
	}
	/* sys_umask */
	case 60: {
		const struct sys_umask_args *p = params;
		iarg[0] = SCARG(p, newmask); /* int */
		*n_args = 1;
		break;
	}
	/* sys_chroot */
	case 61: {
		const struct sys_chroot_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		*n_args = 1;
		break;
	}
	/* sys_dup2 */
	case 63: {
		const struct sys_dup2_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		*n_args = 2;
		break;
	}
	/* sys_getppid */
	case 64: {
		*n_args = 0;
		break;
	}
	/* sys_getpgrp */
	case 65: {
		*n_args = 0;
		break;
	}
	/* sys_setsid */
	case 66: {
		*n_args = 0;
		break;
	}
	/* linux_sys_sigaction */
	case 67: {
		const struct linux_sys_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct linux_old_sigaction * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct linux_old_sigaction * */
		*n_args = 3;
		break;
	}
	/* linux_sys_siggetmask */
	case 68: {
		*n_args = 0;
		break;
	}
	/* linux_sys_sigsetmask */
	case 69: {
		const struct linux_sys_sigsetmask_args *p = params;
		iarg[0] = SCARG(p, mask); /* linux_old_sigset_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setreuid16 */
	case 70: {
		const struct linux_sys_setreuid16_args *p = params;
		iarg[0] = SCARG(p, ruid); /* linux_uid16_t */
		iarg[1] = SCARG(p, euid); /* linux_uid16_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_setregid16 */
	case 71: {
		const struct linux_sys_setregid16_args *p = params;
		iarg[0] = SCARG(p, rgid); /* linux_gid16_t */
		iarg[1] = SCARG(p, egid); /* linux_gid16_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_sigsuspend */
	case 72: {
		const struct linux_sys_sigsuspend_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, restart); /* void * */
		iarg[1] = SCARG(p, oldmask); /* int */
		iarg[2] = SCARG(p, mask); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_sigpending */
	case 73: {
		const struct linux_sys_sigpending_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* linux_old_sigset_t * */
		*n_args = 1;
		break;
	}
	/* compat_43_sys_sethostname */
	case 74: {
		const struct compat_43_sys_sethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname); /* char * */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* linux_sys_setrlimit */
	case 75: {
		const struct linux_sys_setrlimit_args *p = params;
		uarg[0] = SCARG(p, which); /* u_int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct orlimit * */
		*n_args = 2;
		break;
	}
	/* linux_sys_getrlimit */
	case 76: {
		const struct linux_sys_getrlimit_args *p = params;
		uarg[0] = SCARG(p, which); /* u_int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct orlimit * */
		*n_args = 2;
		break;
	}
	/* compat_50_sys_getrusage */
	case 77: {
		const struct compat_50_sys_getrusage_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_gettimeofday */
	case 78: {
		const struct linux_sys_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_sys_settimeofday */
	case 79: {
		const struct linux_sys_settimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_sys_getgroups16 */
	case 80: {
		const struct linux_sys_getgroups16_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* linux_gid16_t * */
		*n_args = 2;
		break;
	}
	/* linux_sys_setgroups16 */
	case 81: {
		const struct linux_sys_setgroups16_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* linux_gid16_t * */
		*n_args = 2;
		break;
	}
	/* linux_sys_oldselect */
	case 82: {
		const struct linux_sys_oldselect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lsp); /* struct linux_oldselect * */
		*n_args = 1;
		break;
	}
	/* sys_symlink */
	case 83: {
		const struct sys_symlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* compat_43_sys_lstat */
	case 84: {
		const struct compat_43_sys_lstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat43 * */
		*n_args = 2;
		break;
	}
	/* sys_readlink */
	case 85: {
		const struct sys_readlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		iarg[2] = SCARG(p, count); /* int */
		*n_args = 3;
		break;
	}
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 86: {
		const struct linux_sys_uselib_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
#else
#endif
	/* linux_sys_swapon */
	case 87: {
		const struct linux_sys_swapon_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_reboot */
	case 88: {
		const struct linux_sys_reboot_args *p = params;
		iarg[0] = SCARG(p, magic1); /* int */
		iarg[1] = SCARG(p, magic2); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 4;
		break;
	}
	/* linux_sys_readdir */
	case 89: {
		const struct linux_sys_readdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent); /* void * */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_old_mmap */
	case 90: {
		const struct linux_sys_old_mmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lmp); /* struct linux_oldmmap * */
		*n_args = 1;
		break;
	}
	/* sys_munmap */
	case 91: {
		const struct sys_munmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* compat_43_sys_truncate */
	case 92: {
		const struct compat_43_sys_truncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, length); /* long */
		*n_args = 2;
		break;
	}
	/* compat_43_sys_ftruncate */
	case 93: {
		const struct compat_43_sys_ftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, length); /* long */
		*n_args = 2;
		break;
	}
	/* sys_fchmod */
	case 94: {
		const struct sys_fchmod_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_fchown16 */
	case 95: {
		const struct linux_sys_fchown16_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, uid); /* linux_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getpriority */
	case 96: {
		const struct linux_sys_getpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setpriority */
	case 97: {
		const struct sys_setpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		iarg[2] = SCARG(p, prio); /* int */
		*n_args = 3;
		break;
	}
	/* sys_profil */
	case 98: {
		const struct sys_profil_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, samples); /* void * */
		uarg[1] = SCARG(p, size); /* u_int */
		uarg[2] = SCARG(p, offset); /* u_int */
		uarg[3] = SCARG(p, scale); /* u_int */
		*n_args = 4;
		break;
	}
	/* linux_sys_statfs */
	case 99: {
		const struct linux_sys_statfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_statfs * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fstatfs */
	case 100: {
		const struct linux_sys_fstatfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_statfs * */
		*n_args = 2;
		break;
	}
	/* linux_sys_socketcall */
	case 102: {
		const struct linux_sys_socketcall_args *p = params;
		iarg[0] = SCARG(p, what); /* int */
		uarg[1] = (intptr_t) SCARG(p, args); /* void * */
		*n_args = 2;
		break;
	}
	/* compat_50_sys_setitimer */
	case 104: {
		const struct compat_50_sys_setitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval50 * */
		uarg[2] = (intptr_t) SCARG(p, oitv); /* struct itimerval50 * */
		*n_args = 3;
		break;
	}
	/* compat_50_sys_getitimer */
	case 105: {
		const struct compat_50_sys_getitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_stat */
	case 106: {
		const struct linux_sys_stat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat * */
		*n_args = 2;
		break;
	}
	/* linux_sys_lstat */
	case 107: {
		const struct linux_sys_lstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fstat */
	case 108: {
		const struct linux_sys_fstat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat * */
		*n_args = 2;
		break;
	}
	/* linux_sys_olduname */
	case 109: {
		const struct linux_sys_olduname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up); /* struct linux_oldutsname * */
		*n_args = 1;
		break;
	}
	/* linux_sys_wait4 */
	case 114: {
		const struct linux_sys_wait4_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status); /* int * */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 4;
		break;
	}
	/* linux_sys_swapoff */
	case 115: {
		const struct linux_sys_swapoff_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_sysinfo */
	case 116: {
		const struct linux_sys_sysinfo_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, arg); /* struct linux_sysinfo * */
		*n_args = 1;
		break;
	}
	/* linux_sys_ipc */
	case 117: {
		const struct linux_sys_ipc_args *p = params;
		iarg[0] = SCARG(p, what); /* int */
		iarg[1] = SCARG(p, a1); /* int */
		iarg[2] = SCARG(p, a2); /* int */
		iarg[3] = SCARG(p, a3); /* int */
		uarg[4] = (intptr_t) SCARG(p, ptr); /* void * */
		*n_args = 5;
		break;
	}
	/* sys_fsync */
	case 118: {
		const struct sys_fsync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_sigreturn */
	case 119: {
		const struct linux_sys_sigreturn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, scp); /* struct linux_sigcontext * */
		*n_args = 1;
		break;
	}
	/* linux_sys_clone */
	case 120: {
		const struct linux_sys_clone_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		uarg[1] = (intptr_t) SCARG(p, stack); /* void * */
		uarg[2] = (intptr_t) SCARG(p, parent_tidptr); /* void * */
		uarg[3] = (intptr_t) SCARG(p, tls); /* void * */
		uarg[4] = (intptr_t) SCARG(p, child_tidptr); /* void * */
		*n_args = 5;
		break;
	}
	/* linux_sys_setdomainname */
	case 121: {
		const struct linux_sys_setdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname); /* char * */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_uname */
	case 122: {
		const struct linux_sys_uname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up); /* struct linux_utsname * */
		*n_args = 1;
		break;
	}
	/* linux_sys_mprotect */
	case 125: {
		const struct linux_sys_mprotect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, start); /* const void * */
		uarg[1] = SCARG(p, len); /* unsigned long */
		iarg[2] = SCARG(p, prot); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_sigprocmask */
	case 126: {
		const struct linux_sys_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set); /* const linux_old_sigset_t * */
		uarg[2] = (intptr_t) SCARG(p, oset); /* linux_old_sigset_t * */
		*n_args = 3;
		break;
	}
	/* sys_getpgid */
	case 132: {
		const struct sys_getpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* sys_fchdir */
	case 133: {
		const struct sys_fchdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_personality */
	case 136: {
		const struct linux_sys_personality_args *p = params;
		uarg[0] = SCARG(p, per); /* unsigned long */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsuid */
	case 138: {
		const struct linux_sys_setfsuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsgid */
	case 139: {
		const struct linux_sys_setfsgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_llseek */
	case 140: {
		const struct linux_sys_llseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, ohigh); /* u_int32_t */
		uarg[2] = SCARG(p, olow); /* u_int32_t */
		uarg[3] = (intptr_t) SCARG(p, res); /* void * */
		iarg[4] = SCARG(p, whence); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_getdents */
	case 141: {
		const struct linux_sys_getdents_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent); /* struct linux_dirent * */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_select */
	case 142: {
		const struct linux_sys_select_args *p = params;
		iarg[0] = SCARG(p, nfds); /* int */
		uarg[1] = (intptr_t) SCARG(p, readfds); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, writefds); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, exceptfds); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct timeval50 * */
		*n_args = 5;
		break;
	}
	/* sys_flock */
	case 143: {
		const struct sys_flock_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* sys___msync13 */
	case 144: {
		const struct sys___msync13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_readv */
	case 145: {
		const struct sys_readv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_writev */
	case 146: {
		const struct sys_writev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getsid */
	case 147: {
		const struct sys_getsid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_fdatasync */
	case 148: {
		const struct linux_sys_fdatasync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys___sysctl */
	case 149: {
		const struct linux_sys___sysctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lsp); /* struct linux___sysctl * */
		*n_args = 1;
		break;
	}
	/* sys_mlock */
	case 150: {
		const struct sys_mlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_munlock */
	case 151: {
		const struct sys_munlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_mlockall */
	case 152: {
		const struct sys_mlockall_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munlockall */
	case 153: {
		*n_args = 0;
		break;
	}
	/* linux_sys_sched_setparam */
	case 154: {
		const struct linux_sys_sched_setparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp); /* const struct linux_sched_param * */
		*n_args = 2;
		break;
	}
	/* linux_sys_sched_getparam */
	case 155: {
		const struct linux_sys_sched_getparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_sched_param * */
		*n_args = 2;
		break;
	}
	/* linux_sys_sched_setscheduler */
	case 156: {
		const struct linux_sys_sched_setscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, policy); /* int */
		uarg[2] = (intptr_t) SCARG(p, sp); /* const struct linux_sched_param * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sched_getscheduler */
	case 157: {
		const struct linux_sys_sched_getscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_sched_yield */
	case 158: {
		*n_args = 0;
		break;
	}
	/* linux_sys_sched_get_priority_max */
	case 159: {
		const struct linux_sys_sched_get_priority_max_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_sched_get_priority_min */
	case 160: {
		const struct linux_sys_sched_get_priority_min_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_nanosleep */
	case 162: {
		const struct linux_sys_nanosleep_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp); /* const struct linux_timespec * */
		uarg[1] = (intptr_t) SCARG(p, rmtp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_mremap */
	case 163: {
		const struct linux_sys_mremap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, old_address); /* void * */
		uarg[1] = SCARG(p, old_size); /* size_t */
		uarg[2] = SCARG(p, new_size); /* size_t */
		uarg[3] = SCARG(p, flags); /* u_long */
		*n_args = 4;
		break;
	}
	/* linux_sys_setresuid16 */
	case 164: {
		const struct linux_sys_setresuid16_args *p = params;
		iarg[0] = SCARG(p, ruid); /* linux_uid16_t */
		iarg[1] = SCARG(p, euid); /* linux_uid16_t */
		iarg[2] = SCARG(p, suid); /* linux_uid16_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresuid16 */
	case 165: {
		const struct linux_sys_getresuid16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ruid); /* linux_uid16_t * */
		uarg[1] = (intptr_t) SCARG(p, euid); /* linux_uid16_t * */
		uarg[2] = (intptr_t) SCARG(p, suid); /* linux_uid16_t * */
		*n_args = 3;
		break;
	}
	/* sys_poll */
	case 168: {
		const struct sys_poll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		iarg[2] = SCARG(p, timeout); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_setresgid16 */
	case 170: {
		const struct linux_sys_setresgid16_args *p = params;
		iarg[0] = SCARG(p, rgid); /* linux_gid16_t */
		iarg[1] = SCARG(p, egid); /* linux_gid16_t */
		iarg[2] = SCARG(p, sgid); /* linux_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresgid16 */
	case 171: {
		const struct linux_sys_getresgid16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rgid); /* linux_gid16_t * */
		uarg[1] = (intptr_t) SCARG(p, egid); /* linux_gid16_t * */
		uarg[2] = (intptr_t) SCARG(p, sgid); /* linux_gid16_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_rt_sigaction */
	case 174: {
		const struct linux_sys_rt_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct linux_sigaction * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct linux_sigaction * */
		uarg[3] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_rt_sigprocmask */
	case 175: {
		const struct linux_sys_rt_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set); /* const linux_sigset_t * */
		uarg[2] = (intptr_t) SCARG(p, oset); /* linux_sigset_t * */
		uarg[3] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_rt_sigpending */
	case 176: {
		const struct linux_sys_rt_sigpending_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* linux_sigset_t * */
		uarg[1] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_rt_sigtimedwait */
	case 177: {
		const struct linux_sys_rt_sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* const linux_sigset_t * */
		uarg[1] = (intptr_t) SCARG(p, info); /* linux_siginfo_t * */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* const struct linux_timespec * */
		*n_args = 3;
		break;
	}
	/* linux_sys_rt_queueinfo */
	case 178: {
		const struct linux_sys_rt_queueinfo_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		uarg[2] = (intptr_t) SCARG(p, uinfo); /* linux_siginfo_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_rt_sigsuspend */
	case 179: {
		const struct linux_sys_rt_sigsuspend_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, unewset); /* linux_sigset_t * */
		uarg[1] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_pread */
	case 180: {
		const struct linux_sys_pread_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, offset); /* off_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_pwrite */
	case 181: {
		const struct linux_sys_pwrite_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, offset); /* off_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_chown16 */
	case 182: {
		const struct linux_sys_chown16_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, uid); /* linux_uid16_t */
		iarg[2] = SCARG(p, gid); /* linux_gid16_t */
		*n_args = 3;
		break;
	}
	/* sys___getcwd */
	case 183: {
		const struct sys___getcwd_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, bufp); /* char * */
		uarg[1] = SCARG(p, length); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_sigaltstack */
	case 186: {
		const struct linux_sys_sigaltstack_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ss); /* const struct linux_sigaltstack * */
		uarg[1] = (intptr_t) SCARG(p, oss); /* struct linux_sigaltstack * */
		*n_args = 2;
		break;
	}
	/* sys___vfork14 */
	case 190: {
		*n_args = 0;
		break;
	}
	/* linux_sys_ugetrlimit */
	case 191: {
		const struct linux_sys_ugetrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct rlimit * */
		*n_args = 2;
		break;
	}
#define linux_sys_mmap2_args linux_sys_mmap_args
	/* linux_sys_mmap2 */
	case 192: {
		const struct linux_sys_mmap2_args *p = params;
		uarg[0] = SCARG(p, addr); /* unsigned long */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, offset); /* linux_off_t */
		*n_args = 6;
		break;
	}
	/* linux_sys_truncate64 */
	case 193: {
		const struct linux_sys_truncate64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, length); /* off_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_ftruncate64 */
	case 194: {
		const struct linux_sys_ftruncate64_args *p = params;
		uarg[0] = SCARG(p, fd); /* unsigned int */
		iarg[1] = SCARG(p, length); /* off_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_stat64 */
	case 195: {
		const struct linux_sys_stat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_lstat64 */
	case 196: {
		const struct linux_sys_lstat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fstat64 */
	case 197: {
		const struct linux_sys_fstat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* sys___posix_lchown */
	case 198: {
		const struct sys___posix_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_getuid */
	case 199: {
		*n_args = 0;
		break;
	}
	/* sys_getgid */
	case 200: {
		*n_args = 0;
		break;
	}
	/* sys_geteuid */
	case 201: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 202: {
		*n_args = 0;
		break;
	}
	/* sys_setreuid */
	case 203: {
		const struct sys_setreuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		*n_args = 2;
		break;
	}
	/* sys_setregid */
	case 204: {
		const struct sys_setregid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		*n_args = 2;
		break;
	}
	/* sys_getgroups */
	case 205: {
		const struct sys_getgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* gid_t * */
		*n_args = 2;
		break;
	}
	/* sys_setgroups */
	case 206: {
		const struct sys_setgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* gid_t * */
		*n_args = 2;
		break;
	}
	/* sys___posix_fchown */
	case 207: {
		const struct sys___posix_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_setresuid */
	case 208: {
		const struct linux_sys_setresuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		uarg[2] = SCARG(p, suid); /* uid_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresuid */
	case 209: {
		const struct linux_sys_getresuid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ruid); /* uid_t * */
		uarg[1] = (intptr_t) SCARG(p, euid); /* uid_t * */
		uarg[2] = (intptr_t) SCARG(p, suid); /* uid_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_setresgid */
	case 210: {
		const struct linux_sys_setresgid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		iarg[2] = SCARG(p, sgid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresgid */
	case 211: {
		const struct linux_sys_getresgid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rgid); /* gid_t * */
		uarg[1] = (intptr_t) SCARG(p, egid); /* gid_t * */
		uarg[2] = (intptr_t) SCARG(p, sgid); /* gid_t * */
		*n_args = 3;
		break;
	}
	/* sys___posix_chown */
	case 212: {
		const struct sys___posix_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_setuid */
	case 213: {
		const struct sys_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_setgid */
	case 214: {
		const struct sys_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsuid */
	case 215: {
		const struct linux_sys_setfsuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsgid */
	case 216: {
		const struct linux_sys_setfsgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_getdents64 */
	case 217: {
		const struct linux_sys_getdents64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent); /* struct linux_dirent64 * */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* sys_mincore */
	case 219: {
		const struct sys_mincore_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, vec); /* char * */
		*n_args = 3;
		break;
	}
	/* sys_madvise */
	case 220: {
		const struct sys_madvise_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, behav); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_fcntl64 */
	case 221: {
		const struct linux_sys_fcntl64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 3;
		break;
	}
	/* linux_sys_gettid */
	case 224: {
		*n_args = 0;
		break;
	}
	/* linux_sys_setxattr */
	case 226: {
		const struct linux_sys_setxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_lsetxattr */
	case 227: {
		const struct linux_sys_lsetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_fsetxattr */
	case 228: {
		const struct linux_sys_fsetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_getxattr */
	case 229: {
		const struct linux_sys_getxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_lgetxattr */
	case 230: {
		const struct linux_sys_lgetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_fgetxattr */
	case 231: {
		const struct linux_sys_fgetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_listxattr */
	case 232: {
		const struct linux_sys_listxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_llistxattr */
	case 233: {
		const struct linux_sys_llistxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_flistxattr */
	case 234: {
		const struct linux_sys_flistxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_removexattr */
	case 235: {
		const struct linux_sys_removexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_lremovexattr */
	case 236: {
		const struct linux_sys_lremovexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fremovexattr */
	case 237: {
		const struct linux_sys_fremovexattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_tkill */
	case 238: {
		const struct linux_sys_tkill_args *p = params;
		iarg[0] = SCARG(p, tid); /* int */
		iarg[1] = SCARG(p, sig); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_futex */
	case 240: {
		const struct linux_sys_futex_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, uaddr); /* int * */
		iarg[1] = SCARG(p, op); /* int */
		iarg[2] = SCARG(p, val); /* int */
		uarg[3] = (intptr_t) SCARG(p, timeout); /* const struct linux_timespec * */
		uarg[4] = (intptr_t) SCARG(p, uaddr2); /* int * */
		iarg[5] = SCARG(p, val3); /* int */
		*n_args = 6;
		break;
	}
	/* linux_sys_sched_setaffinity */
	case 241: {
		const struct linux_sys_sched_setaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask); /* unsigned long * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sched_getaffinity */
	case 242: {
		const struct linux_sys_sched_getaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask); /* unsigned long * */
		*n_args = 3;
		break;
	}
	/* linux_sys_exit_group */
	case 248: {
		const struct linux_sys_exit_group_args *p = params;
		iarg[0] = SCARG(p, error_code); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_set_tid_address */
	case 256: {
		const struct linux_sys_set_tid_address_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tid); /* int * */
		*n_args = 1;
		break;
	}
	/* linux_sys_clock_settime */
	case 262: {
		const struct linux_sys_clock_settime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_gettime */
	case 263: {
		const struct linux_sys_clock_gettime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_getres */
	case 264: {
		const struct linux_sys_clock_getres_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_nanosleep */
	case 265: {
		const struct linux_sys_clock_nanosleep_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, rqtp); /* struct linux_timespec * */
		uarg[3] = (intptr_t) SCARG(p, rmtp); /* struct linux_timespec * */
		*n_args = 4;
		break;
	}
	/* linux_sys_statfs64 */
	case 266: {
		const struct linux_sys_statfs64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, sz); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, sp); /* struct linux_statfs64 * */
		*n_args = 3;
		break;
	}
	/* linux_sys_fstatfs64 */
	case 267: {
		const struct linux_sys_fstatfs64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, sz); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, sp); /* struct linux_statfs64 * */
		*n_args = 3;
		break;
	}
	/* linux_sys_tgkill */
	case 268: {
		const struct linux_sys_tgkill_args *p = params;
		iarg[0] = SCARG(p, tgid); /* int */
		iarg[1] = SCARG(p, tid); /* int */
		iarg[2] = SCARG(p, sig); /* int */
		*n_args = 3;
		break;
	}
	/* compat_50_sys_utimes */
	case 269: {
		const struct compat_50_sys_utimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fadvise64_64 */
	case 270: {
		const struct linux_sys_fadvise64_64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* off_t */
		iarg[2] = SCARG(p, len); /* off_t */
		iarg[3] = SCARG(p, advice); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_openat */
	case 322: {
		const struct linux_sys_openat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flags); /* int */
		iarg[3] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 4;
		break;
	}
	/* sys_mkdirat */
	case 323: {
		const struct sys_mkdirat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_mknodat */
	case 324: {
		const struct linux_sys_mknodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		uarg[3] = SCARG(p, dev); /* unsigned */
		*n_args = 4;
		break;
	}
	/* linux_sys_fchownat */
	case 325: {
		const struct linux_sys_fchownat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = SCARG(p, owner); /* uid_t */
		iarg[3] = SCARG(p, group); /* gid_t */
		iarg[4] = SCARG(p, flag); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_fstatat64 */
	case 327: {
		const struct linux_sys_fstatat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_unlinkat */
	case 328: {
		const struct linux_sys_unlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flag); /* int */
		*n_args = 3;
		break;
	}
	/* sys_renameat */
	case 329: {
		const struct sys_renameat_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from); /* const char * */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 4;
		break;
	}
	/* linux_sys_linkat */
	case 330: {
		const struct linux_sys_linkat_args *p = params;
		iarg[0] = SCARG(p, fd1); /* int */
		uarg[1] = (intptr_t) SCARG(p, name1); /* const char * */
		iarg[2] = SCARG(p, fd2); /* int */
		uarg[3] = (intptr_t) SCARG(p, name2); /* const char * */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_symlinkat */
	case 331: {
		const struct sys_symlinkat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path1); /* const char * */
		iarg[1] = SCARG(p, fd); /* int */
		uarg[2] = (intptr_t) SCARG(p, path2); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_readlinkat */
	case 332: {
		const struct sys_readlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[3] = SCARG(p, bufsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_fchmodat */
	case 333: {
		const struct linux_sys_fchmodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_faccessat */
	case 334: {
		const struct linux_sys_faccessat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, amode); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_pselect6 */
	case 335: {
		const struct linux_sys_pselect6_args *p = params;
		iarg[0] = SCARG(p, nfds); /* int */
		uarg[1] = (intptr_t) SCARG(p, readfds); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, writefds); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, exceptfds); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct linux_timespec * */
		uarg[5] = (intptr_t) SCARG(p, ss); /* linux_sized_sigset_t * */
		*n_args = 6;
		break;
	}
	/* linux_sys_ppoll */
	case 336: {
		const struct linux_sys_ppoll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* struct linux_timespec * */
		uarg[3] = (intptr_t) SCARG(p, sigset); /* linux_sigset_t * */
		*n_args = 4;
		break;
	}
	/* linux_sys_set_robust_list */
	case 338: {
		const struct linux_sys_set_robust_list_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, head); /* struct linux_robust_list_head * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_get_robust_list */
	case 339: {
		const struct linux_sys_get_robust_list_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, head); /* struct linux_robust_list_head ** */
		uarg[2] = (intptr_t) SCARG(p, len); /* size_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_utimensat */
	case 348: {
		const struct linux_sys_utimensat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, times); /* struct linux_timespec * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_dup3 */
	case 358: {
		const struct linux_sys_dup3_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_pipe2 */
	case 359: {
		const struct linux_sys_pipe2_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pfds); /* int * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_recvmmsg */
	case 365: {
		const struct linux_sys_recvmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgvec); /* struct linux_mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct timespec * */
		*n_args = 5;
		break;
	}
	/* linux_sys_accept4 */
	case 366: {
		const struct linux_sys_accept4_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* struct osockaddr * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* int * */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_sendmmsg */
	case 374: {
		const struct linux_sys_sendmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgvec); /* struct linux_mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		*n_args = 4;
		break;
	}
	/* linux_sys_breakpoint */
	case 385: {
		*n_args = 0;
		break;
	}
	/* linux_sys_cacheflush */
	case 386: {
		const struct linux_sys_cacheflush_args *p = params;
		uarg[0] = SCARG(p, from); /* uintptr_t */
		iarg[1] = SCARG(p, to); /* intptr_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_set_tls */
	case 389: {
		const struct linux_sys_set_tls_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tls); /* void * */
		*n_args = 1;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0:
		break;
	/* linux_sys_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fork */
	case 2:
		break;
	/* sys_read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_open */
	case 5:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_waitpid */
	case 7:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_creat */
	case 8:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_link */
	case 9:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_execve */
	case 11:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char **";
			break;
		case 2:
			p = "char **";
			break;
		default:
			break;
		};
		break;
	/* sys_chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_time */
	case 13:
		switch(ndx) {
		case 0:
			p = "linux_time_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		case 2:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* sys_chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lchown16 */
	case 16:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_uid16_t";
			break;
		case 2:
			p = "linux_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_lseek */
	case 19:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpid */
	case 20:
		break;
	/* sys_setuid */
	case 23:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 24:
		break;
	/* linux_sys_stime */
	case 25:
		switch(ndx) {
		case 0:
			p = "linux_time_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_alarm */
	case 27:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pause */
	case 29:
		break;
	/* linux_sys_utime */
	case 30:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_utimbuf *";
			break;
		default:
			break;
		};
		break;
	/* sys_access */
	case 33:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_nice */
	case 34:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sync */
	case 36:
		break;
	/* linux_sys_kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_rename */
	case 38:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdir */
	case 39:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_rmdir */
	case 40:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pipe */
	case 42:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_times */
	case 43:
		switch(ndx) {
		case 0:
			p = "struct times *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_brk */
	case 45:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_setgid */
	case 46:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getgid */
	case 47:
		break;
	/* linux_sys_signal */
	case 48:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_handler_t";
			break;
		default:
			break;
		};
		break;
	/* sys_geteuid */
	case 49:
		break;
	/* sys_getegid */
	case 50:
		break;
	/* sys_acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_long";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fcntl */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_setpgid */
	case 57:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_oldolduname */
	case 59:
		switch(ndx) {
		case 0:
			p = "struct linux_oldold_utsname *";
			break;
		default:
			break;
		};
		break;
	/* sys_umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_dup2 */
	case 63:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getppid */
	case 64:
		break;
	/* sys_getpgrp */
	case 65:
		break;
	/* sys_setsid */
	case 66:
		break;
	/* linux_sys_sigaction */
	case 67:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct linux_old_sigaction *";
			break;
		case 2:
			p = "struct linux_old_sigaction *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_siggetmask */
	case 68:
		break;
	/* linux_sys_sigsetmask */
	case 69:
		switch(ndx) {
		case 0:
			p = "linux_old_sigset_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setreuid16 */
	case 70:
		switch(ndx) {
		case 0:
			p = "linux_uid16_t";
			break;
		case 1:
			p = "linux_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setregid16 */
	case 71:
		switch(ndx) {
		case 0:
			p = "linux_gid16_t";
			break;
		case 1:
			p = "linux_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigsuspend */
	case 72:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigpending */
	case 73:
		switch(ndx) {
		case 0:
			p = "linux_old_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_sethostname */
	case 74:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setrlimit */
	case 75:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct orlimit *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getrlimit */
	case 76:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct orlimit *";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_getrusage */
	case 77:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_gettimeofday */
	case 78:
		switch(ndx) {
		case 0:
			p = "struct timeval50 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_settimeofday */
	case 79:
		switch(ndx) {
		case 0:
			p = "struct timeval50 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getgroups16 */
	case 80:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setgroups16 */
	case 81:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_oldselect */
	case 82:
		switch(ndx) {
		case 0:
			p = "struct linux_oldselect *";
			break;
		default:
			break;
		};
		break;
	/* sys_symlink */
	case 83:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_lstat */
	case 84:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat43 *";
			break;
		default:
			break;
		};
		break;
	/* sys_readlink */
	case 85:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 86:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* linux_sys_swapon */
	case 87:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_reboot */
	case 88:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_readdir */
	case 89:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_old_mmap */
	case 90:
		switch(ndx) {
		case 0:
			p = "struct linux_oldmmap *";
			break;
		default:
			break;
		};
		break;
	/* sys_munmap */
	case 91:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_truncate */
	case 92:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_ftruncate */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys_fchmod */
	case 94:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fchown16 */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_uid16_t";
			break;
		case 2:
			p = "linux_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setpriority */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_profil */
	case 98:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_statfs */
	case 99:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_statfs *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstatfs */
	case 100:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_statfs *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_socketcall */
	case 102:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_setitimer */
	case 104:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval50 *";
			break;
		case 2:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_getitimer */
	case 105:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_stat */
	case 106:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lstat */
	case 107:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstat */
	case 108:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_stat *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_olduname */
	case 109:
		switch(ndx) {
		case 0:
			p = "struct linux_oldutsname *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_wait4 */
	case 114:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_swapoff */
	case 115:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sysinfo */
	case 116:
		switch(ndx) {
		case 0:
			p = "struct linux_sysinfo *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ipc */
	case 117:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_fsync */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigreturn */
	case 119:
		switch(ndx) {
		case 0:
			p = "struct linux_sigcontext *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clone */
	case 120:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setdomainname */
	case 121:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_uname */
	case 122:
		switch(ndx) {
		case 0:
			p = "struct linux_utsname *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mprotect */
	case 125:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "unsigned long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigprocmask */
	case 126:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const linux_old_sigset_t *";
			break;
		case 2:
			p = "linux_old_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpgid */
	case 132:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fchdir */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_personality */
	case 136:
		switch(ndx) {
		case 0:
			p = "unsigned long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsuid */
	case 138:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsgid */
	case 139:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_llseek */
	case 140:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_int32_t";
			break;
		case 2:
			p = "u_int32_t";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getdents */
	case 141:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_dirent *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_select */
	case 142:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_flock */
	case 143:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___msync13 */
	case 144:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_readv */
	case 145:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_writev */
	case 146:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getsid */
	case 147:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fdatasync */
	case 148:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys___sysctl */
	case 149:
		switch(ndx) {
		case 0:
			p = "struct linux___sysctl *";
			break;
		default:
			break;
		};
		break;
	/* sys_mlock */
	case 150:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_munlock */
	case 151:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mlockall */
	case 152:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munlockall */
	case 153:
		break;
	/* linux_sys_sched_setparam */
	case 154:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getparam */
	case 155:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_setscheduler */
	case 156:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getscheduler */
	case 157:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_yield */
	case 158:
		break;
	/* linux_sys_sched_get_priority_max */
	case 159:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_get_priority_min */
	case 160:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_nanosleep */
	case 162:
		switch(ndx) {
		case 0:
			p = "const struct linux_timespec *";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mremap */
	case 163:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresuid16 */
	case 164:
		switch(ndx) {
		case 0:
			p = "linux_uid16_t";
			break;
		case 1:
			p = "linux_uid16_t";
			break;
		case 2:
			p = "linux_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresuid16 */
	case 165:
		switch(ndx) {
		case 0:
			p = "linux_uid16_t *";
			break;
		case 1:
			p = "linux_uid16_t *";
			break;
		case 2:
			p = "linux_uid16_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_poll */
	case 168:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresgid16 */
	case 170:
		switch(ndx) {
		case 0:
			p = "linux_gid16_t";
			break;
		case 1:
			p = "linux_gid16_t";
			break;
		case 2:
			p = "linux_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresgid16 */
	case 171:
		switch(ndx) {
		case 0:
			p = "linux_gid16_t *";
			break;
		case 1:
			p = "linux_gid16_t *";
			break;
		case 2:
			p = "linux_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigaction */
	case 174:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct linux_sigaction *";
			break;
		case 2:
			p = "struct linux_sigaction *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigprocmask */
	case 175:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const linux_sigset_t *";
			break;
		case 2:
			p = "linux_sigset_t *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigpending */
	case 176:
		switch(ndx) {
		case 0:
			p = "linux_sigset_t *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigtimedwait */
	case 177:
		switch(ndx) {
		case 0:
			p = "const linux_sigset_t *";
			break;
		case 1:
			p = "linux_siginfo_t *";
			break;
		case 2:
			p = "const struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_queueinfo */
	case 178:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_siginfo_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigsuspend */
	case 179:
		switch(ndx) {
		case 0:
			p = "linux_sigset_t *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pread */
	case 180:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pwrite */
	case 181:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_chown16 */
	case 182:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_uid16_t";
			break;
		case 2:
			p = "linux_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* sys___getcwd */
	case 183:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigaltstack */
	case 186:
		switch(ndx) {
		case 0:
			p = "const struct linux_sigaltstack *";
			break;
		case 1:
			p = "struct linux_sigaltstack *";
			break;
		default:
			break;
		};
		break;
	/* sys___vfork14 */
	case 190:
		break;
	/* linux_sys_ugetrlimit */
	case 191:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
#define linux_sys_mmap2_args linux_sys_mmap_args
	/* linux_sys_mmap2 */
	case 192:
		switch(ndx) {
		case 0:
			p = "unsigned long";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "linux_off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_truncate64 */
	case 193:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ftruncate64 */
	case 194:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_stat64 */
	case 195:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lstat64 */
	case 196:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstat64 */
	case 197:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_lchown */
	case 198:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 199:
		break;
	/* sys_getgid */
	case 200:
		break;
	/* sys_geteuid */
	case 201:
		break;
	/* sys_getegid */
	case 202:
		break;
	/* sys_setreuid */
	case 203:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setregid */
	case 204:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getgroups */
	case 205:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_setgroups */
	case 206:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_fchown */
	case 207:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresuid */
	case 208:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresuid */
	case 209:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		case 1:
			p = "uid_t *";
			break;
		case 2:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresgid */
	case 210:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresgid */
	case 211:
		switch(ndx) {
		case 0:
			p = "gid_t *";
			break;
		case 1:
			p = "gid_t *";
			break;
		case 2:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_chown */
	case 212:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setuid */
	case 213:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setgid */
	case 214:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsuid */
	case 215:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsgid */
	case 216:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getdents64 */
	case 217:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_dirent64 *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* sys_mincore */
	case 219:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_madvise */
	case 220:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fcntl64 */
	case 221:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_gettid */
	case 224:
		break;
	/* linux_sys_setxattr */
	case 226:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lsetxattr */
	case 227:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fsetxattr */
	case 228:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getxattr */
	case 229:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lgetxattr */
	case 230:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fgetxattr */
	case 231:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_listxattr */
	case 232:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_llistxattr */
	case 233:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_flistxattr */
	case 234:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_removexattr */
	case 235:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lremovexattr */
	case 236:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fremovexattr */
	case 237:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_tkill */
	case 238:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_futex */
	case 240:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const struct linux_timespec *";
			break;
		case 4:
			p = "int *";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_setaffinity */
	case 241:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "unsigned long *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getaffinity */
	case 242:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "unsigned long *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_exit_group */
	case 248:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_set_tid_address */
	case 256:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_settime */
	case 262:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_gettime */
	case 263:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_getres */
	case 264:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_nanosleep */
	case 265:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_statfs64 */
	case 266:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct linux_statfs64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstatfs64 */
	case 267:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct linux_statfs64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_tgkill */
	case 268:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_utimes */
	case 269:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fadvise64_64 */
	case 270:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "off_t";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_openat */
	case 322:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdirat */
	case 323:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mknodat */
	case 324:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		case 3:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fchownat */
	case 325:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstatat64 */
	case 327:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "struct linux_stat64 *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_unlinkat */
	case 328:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_renameat */
	case 329:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_linkat */
	case 330:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_symlinkat */
	case 331:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_readlinkat */
	case 332:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fchmodat */
	case 333:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_faccessat */
	case 334:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pselect6 */
	case 335:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct linux_timespec *";
			break;
		case 5:
			p = "linux_sized_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ppoll */
	case 336:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "linux_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_set_robust_list */
	case 338:
		switch(ndx) {
		case 0:
			p = "struct linux_robust_list_head *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_get_robust_list */
	case 339:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_robust_list_head **";
			break;
		case 2:
			p = "size_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_utimensat */
	case 348:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_dup3 */
	case 358:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pipe2 */
	case 359:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_recvmmsg */
	case 365:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_accept4 */
	case 366:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct osockaddr *";
			break;
		case 2:
			p = "int *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sendmmsg */
	case 374:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_breakpoint */
	case 385:
		break;
	/* linux_sys_cacheflush */
	case 386:
		switch(ndx) {
		case 0:
			p = "uintptr_t";
			break;
		case 1:
			p = "intptr_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_set_tls */
	case 389:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* linux_sys_nosys */
	case 0:
	/* linux_sys_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fork */
	case 2:
	/* sys_read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_waitpid */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_creat */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_execve */
	case 11:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_time */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lchown16 */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_lseek */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "long";
		break;
	/* sys_getpid */
	case 20:
	/* sys_setuid */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 24:
	/* linux_sys_stime */
	case 25:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_alarm */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pause */
	case 29:
	/* linux_sys_utime */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_nice */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sync */
	case 36:
	/* linux_sys_kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_rename */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdir */
	case 39:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_rmdir */
	case 40:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pipe */
	case 42:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_times */
	case 43:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_brk */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgid */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgid */
	case 47:
	/* linux_sys_signal */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_geteuid */
	case 49:
	/* sys_getegid */
	case 50:
	/* sys_acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fcntl */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setpgid */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_oldolduname */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_dup2 */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getppid */
	case 64:
	/* sys_getpgrp */
	case 65:
	/* sys_setsid */
	case 66:
	/* linux_sys_sigaction */
	case 67:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_siggetmask */
	case 68:
	/* linux_sys_sigsetmask */
	case 69:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setreuid16 */
	case 70:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setregid16 */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigsuspend */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigpending */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_sethostname */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setrlimit */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getrlimit */
	case 76:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_getrusage */
	case 77:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_gettimeofday */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_settimeofday */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getgroups16 */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setgroups16 */
	case 81:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_oldselect */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_symlink */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_lstat */
	case 84:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlink */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 86:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* linux_sys_swapon */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_reboot */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_readdir */
	case 89:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_old_mmap */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munmap */
	case 91:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_truncate */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_ftruncate */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchmod */
	case 94:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fchown16 */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setpriority */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_profil */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_statfs */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstatfs */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_socketcall */
	case 102:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_setitimer */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_getitimer */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_stat */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lstat */
	case 107:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstat */
	case 108:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_olduname */
	case 109:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_wait4 */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_swapoff */
	case 115:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sysinfo */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ipc */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fsync */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigreturn */
	case 119:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clone */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setdomainname */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_uname */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mprotect */
	case 125:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigprocmask */
	case 126:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpgid */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* sys_fchdir */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_personality */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setfsuid */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setfsgid */
	case 139:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_llseek */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getdents */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_select */
	case 142:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_flock */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___msync13 */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readv */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_writev */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_getsid */
	case 147:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* linux_sys_fdatasync */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys___sysctl */
	case 149:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlock */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlock */
	case 151:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlockall */
	case 152:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlockall */
	case 153:
	/* linux_sys_sched_setparam */
	case 154:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getparam */
	case 155:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_setscheduler */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getscheduler */
	case 157:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_yield */
	case 158:
	/* linux_sys_sched_get_priority_max */
	case 159:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_get_priority_min */
	case 160:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_nanosleep */
	case 162:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mremap */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "void *";
		break;
	/* linux_sys_setresuid16 */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresuid16 */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_poll */
	case 168:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setresgid16 */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresgid16 */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigaction */
	case 174:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigprocmask */
	case 175:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigpending */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigtimedwait */
	case 177:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_queueinfo */
	case 178:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigsuspend */
	case 179:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pread */
	case 180:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pwrite */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_chown16 */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getcwd */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigaltstack */
	case 186:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___vfork14 */
	case 190:
	/* linux_sys_ugetrlimit */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#define linux_sys_mmap2_args linux_sys_mmap_args
	/* linux_sys_mmap2 */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "linux_off_t";
		break;
	/* linux_sys_truncate64 */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ftruncate64 */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_stat64 */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lstat64 */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstat64 */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_lchown */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 199:
	/* sys_getgid */
	case 200:
	/* sys_geteuid */
	case 201:
	/* sys_getegid */
	case 202:
	/* sys_setreuid */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setregid */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgroups */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgroups */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_fchown */
	case 207:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setresuid */
	case 208:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresuid */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setresgid */
	case 210:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresgid */
	case 211:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_chown */
	case 212:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setuid */
	case 213:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgid */
	case 214:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setfsuid */
	case 215:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setfsgid */
	case 216:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getdents64 */
	case 217:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mincore */
	case 219:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_madvise */
	case 220:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fcntl64 */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_gettid */
	case 224:
	/* linux_sys_setxattr */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lsetxattr */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fsetxattr */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getxattr */
	case 229:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_lgetxattr */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_fgetxattr */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_listxattr */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_llistxattr */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_flistxattr */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_removexattr */
	case 235:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lremovexattr */
	case 236:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fremovexattr */
	case 237:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_tkill */
	case 238:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_futex */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_setaffinity */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getaffinity */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_exit_group */
	case 248:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_set_tid_address */
	case 256:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_settime */
	case 262:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_gettime */
	case 263:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_getres */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_nanosleep */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_statfs64 */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstatfs64 */
	case 267:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_tgkill */
	case 268:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_utimes */
	case 269:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fadvise64_64 */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_openat */
	case 322:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdirat */
	case 323:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mknodat */
	case 324:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fchownat */
	case 325:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstatat64 */
	case 327:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_unlinkat */
	case 328:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_renameat */
	case 329:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_linkat */
	case 330:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_symlinkat */
	case 331:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlinkat */
	case 332:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_fchmodat */
	case 333:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_faccessat */
	case 334:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pselect6 */
	case 335:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ppoll */
	case 336:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_set_robust_list */
	case 338:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_get_robust_list */
	case 339:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_utimensat */
	case 348:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_dup3 */
	case 358:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pipe2 */
	case 359:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_recvmmsg */
	case 365:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_accept4 */
	case 366:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sendmmsg */
	case 374:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_breakpoint */
	case 385:
	/* linux_sys_cacheflush */
	case 386:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_set_tls */
	case 389:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
