/* $NetBSD: linux_sysent.c,v 1.106 2017/05/10 06:19:48 riastradh Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.94 2017/02/03 16:17:08 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_sysent.c,v 1.106 2017/05/10 06:19:48 riastradh Exp $");

#if defined(_KERNEL_OPT)
#include "opt_sysv.h"
#endif
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_msg.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/common/linux_shm.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent linux_sysent[] = {
	{
		.sy_call = (sy_call_t *)linux_sys_nosys
	},		/* 0 = syscall */
	{
		ns(struct linux_sys_exit_args),
		.sy_call = (sy_call_t *)linux_sys_exit
	},		/* 1 = exit */
	{
		.sy_call = (sy_call_t *)sys_fork
	},		/* 2 = fork */
	{
		ns(struct sys_read_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_read
	},		/* 3 = read */
	{
		ns(struct sys_write_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_write
	},		/* 4 = write */
	{
		.sy_call = linux_sys_nosys,
	},		/* 5 = filler */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)sys_close
	},		/* 6 = close */
	{
		ns(struct osf1_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_wait4
	},		/* 7 = wait4 */
	{
		ns(struct linux_sys_creat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_creat
	},		/* 8 = creat */
	{
		ns(struct sys_link_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_link
	},		/* 9 = link */
	{
		ns(struct linux_sys_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlink
	},		/* 10 = unlink */
	{
		.sy_call = linux_sys_nosys,
	},		/* 11 = filler */
	{
		ns(struct sys_chdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chdir
	},		/* 12 = chdir */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)sys_fchdir
	},		/* 13 = fchdir */
	{
		ns(struct linux_sys_mknod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknod
	},		/* 14 = mknod */
	{
		ns(struct sys_chmod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chmod
	},		/* 15 = chmod */
	{
		ns(struct sys___posix_chown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_chown
	},		/* 16 = __posix_chown */
	{
		ns(struct linux_sys_brk_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_brk
	},		/* 17 = brk */
	{
		.sy_call = linux_sys_nosys,
	},		/* 18 = filler */
	{
		ns(struct compat_43_sys_lseek_args),
		.sy_call = (sy_call_t *)compat_43_sys_lseek
	},		/* 19 = lseek */
	{
		.sy_call = (sy_call_t *)sys_getpid_with_ppid
	},		/* 20 = getpid_with_ppid */
	{
		ns(struct osf1_sys_mount_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_mount
	},		/* 21 = mount */
	{
		.sy_call = linux_sys_nosys,
	},		/* 22 = filler */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 23 = setuid */
	{
		.sy_call = (sy_call_t *)sys_getuid_with_euid
	},		/* 24 = getuid_with_euid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 25 = filler */
	{
		ns(struct linux_sys_ptrace_args),
		.sy_call = (sy_call_t *)linux_sys_ptrace
	},		/* 26 = ptrace */
	{
		.sy_call = linux_sys_nosys,
	},		/* 27 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 28 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 29 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 30 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 31 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 32 = filler */
	{
		ns(struct sys_access_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_access
	},		/* 33 = access */
	{
		.sy_call = linux_sys_nosys,
	},		/* 34 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 35 = filler */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 36 = sync */
	{
		ns(struct linux_sys_kill_args),
		.sy_call = (sy_call_t *)linux_sys_kill
	},		/* 37 = kill */
	{
		.sy_call = linux_sys_nosys,
	},		/* 38 = filler */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)sys_setpgid
	},		/* 39 = setpgid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 40 = filler */
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)sys_dup
	},		/* 41 = dup */
	{
		.sy_call = (sy_call_t *)linux_sys_pipe
	},		/* 42 = pipe */
	{
		ns(struct osf1_sys_set_program_attributes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_set_program_attributes
	},		/* 43 = set_program_attributes */
	{
		.sy_call = linux_sys_nosys,
	},		/* 44 = filler */
	{
		ns(struct linux_sys_open_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_open
	},		/* 45 = open */
	{
		.sy_call = linux_sys_nosys,
	},		/* 46 = filler */
	{
		.sy_call = (sy_call_t *)sys_getgid_with_egid
	},		/* 47 = getgid_with_egid */
	{
		ns(struct compat_13_sys_sigprocmask_args),
		.sy_call = (sy_call_t *)compat_13_sys_sigprocmask
	},		/* 48 = sigprocmask */
	{
		.sy_call = linux_sys_nosys,
	},		/* 49 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 50 = filler */
	{
		ns(struct sys_acct_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_acct
	},		/* 51 = acct */
	{
		ns(struct linux_sys_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigpending
	},		/* 52 = sigpending */
	{
		.sy_call = linux_sys_nosys,
	},		/* 53 = filler */
	{
		ns(struct linux_sys_ioctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ioctl
	},		/* 54 = ioctl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 55 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 56 = filler */
	{
		ns(struct sys_symlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlink
	},		/* 57 = symlink */
	{
		ns(struct sys_readlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlink
	},		/* 58 = readlink */
	{
		ns(struct sys_execve_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_execve
	},		/* 59 = execve */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)sys_umask
	},		/* 60 = umask */
	{
		ns(struct sys_chroot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chroot
	},		/* 61 = chroot */
	{
		.sy_call = linux_sys_nosys,
	},		/* 62 = filler */
	{
		.sy_call = (sy_call_t *)sys_getpgrp
	},		/* 63 = getpgrp */
	{
		.sy_call = (sy_call_t *)compat_43_sys_getpagesize
	},		/* 64 = getpagesize */
	{
		.sy_call = linux_sys_nosys,
	},		/* 65 = filler */
	{
		.sy_call = (sy_call_t *)sys___vfork14
	},		/* 66 = __vfork14 */
	{
		ns(struct linux_sys_stat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stat
	},		/* 67 = stat */
	{
		ns(struct linux_sys_lstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lstat
	},		/* 68 = lstat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 69 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 70 = filler */
	{
		ns(struct linux_sys_mmap_args),
		.sy_call = (sy_call_t *)linux_sys_mmap
	},		/* 71 = mmap */
	{
		.sy_call = linux_sys_nosys,
	},		/* 72 = filler */
	{
		ns(struct sys_munmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munmap
	},		/* 73 = munmap */
	{
		ns(struct linux_sys_mprotect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mprotect
	},		/* 74 = mprotect */
	{
		ns(struct sys_madvise_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_madvise
	},		/* 75 = madvise */
	{
		.sy_call = linux_sys_nosys,
	},		/* 76 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 77 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 78 = filler */
	{
		ns(struct sys_getgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getgroups
	},		/* 79 = getgroups */
	{
		ns(struct sys_setgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setgroups
	},		/* 80 = setgroups */
	{
		.sy_call = linux_sys_nosys,
	},		/* 81 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 82 = filler */
	{
		ns(struct osf1_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_setitimer
	},		/* 83 = setitimer */
	{
		.sy_call = linux_sys_nosys,
	},		/* 84 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 85 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 86 = filler */
	{
		ns(struct compat_43_sys_gethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_gethostname
	},		/* 87 = gethostname */
	{
		ns(struct compat_43_sys_sethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sethostname
	},		/* 88 = sethostname */
	{
		.sy_call = linux_sys_nosys,
	},		/* 89 = filler */
	{
		ns(struct sys_dup2_args),
		.sy_call = (sy_call_t *)sys_dup2
	},		/* 90 = dup2 */
	{
		ns(struct linux_sys_fstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat
	},		/* 91 = fstat */
	{
		ns(struct linux_sys_fcntl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fcntl
	},		/* 92 = fcntl */
	{
		ns(struct osf1_sys_select_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_select
	},		/* 93 = select */
	{
		ns(struct sys_poll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_poll
	},		/* 94 = poll */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)sys_fsync
	},		/* 95 = fsync */
	{
		ns(struct sys_setpriority_args),
		.sy_call = (sy_call_t *)sys_setpriority
	},		/* 96 = setpriority */
	{
		ns(struct linux_sys_socket_args),
		.sy_call = (sy_call_t *)linux_sys_socket
	},		/* 97 = socket */
	{
		ns(struct linux_sys_connect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_connect
	},		/* 98 = connect */
	{
		ns(struct linux_sys_accept_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept
	},		/* 99 = accept */
	{
		ns(struct linux_sys_getpriority_args),
		.sy_call = (sy_call_t *)linux_sys_getpriority
	},		/* 100 = getpriority */
	{
		ns(struct linux_sys_send_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_send
	},		/* 101 = send */
	{
		ns(struct linux_sys_recv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recv
	},		/* 102 = recv */
	{
		ns(struct linux_sys_sigreturn_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigreturn
	},		/* 103 = sigreturn */
	{
		ns(struct linux_sys_bind_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_bind
	},		/* 104 = bind */
	{
		ns(struct linux_sys_setsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setsockopt
	},		/* 105 = setsockopt */
	{
		ns(struct sys_listen_args),
		.sy_call = (sy_call_t *)sys_listen
	},		/* 106 = listen */
	{
		.sy_call = linux_sys_nosys,
	},		/* 107 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 108 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 109 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 110 = filler */
	{
		ns(struct linux_sys_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigsuspend
	},		/* 111 = sigsuspend */
	{
		ns(struct compat_43_sys_sigstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sigstack
	},		/* 112 = sigstack */
	{
		ns(struct linux_sys_recvmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmsg
	},		/* 113 = recvmsg */
	{
		ns(struct linux_sys_sendmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmsg
	},		/* 114 = sendmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 115 = filler */
	{
		ns(struct osf1_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_gettimeofday
	},		/* 116 = gettimeofday */
	{
		ns(struct osf1_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_getrusage
	},		/* 117 = getrusage */
	{
		ns(struct linux_sys_getsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockopt
	},		/* 118 = getsockopt */
	{
		.sy_call = linux_sys_nosys,
	},		/* 119 = filler */
	{
		ns(struct sys_readv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readv
	},		/* 120 = readv */
	{
		ns(struct sys_writev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_writev
	},		/* 121 = writev */
	{
		ns(struct osf1_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_settimeofday
	},		/* 122 = settimeofday */
	{
		ns(struct sys___posix_fchown_args),
		.sy_call = (sy_call_t *)sys___posix_fchown
	},		/* 123 = __posix_fchown */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)sys_fchmod
	},		/* 124 = fchmod */
	{
		ns(struct linux_sys_recvfrom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvfrom
	},		/* 125 = recvfrom */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)sys_setreuid
	},		/* 126 = setreuid */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)sys_setregid
	},		/* 127 = setregid */
	{
		ns(struct sys___posix_rename_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_rename
	},		/* 128 = __posix_rename */
	{
		ns(struct compat_43_sys_truncate_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_truncate
	},		/* 129 = truncate */
	{
		ns(struct compat_43_sys_ftruncate_args),
		.sy_call = (sy_call_t *)compat_43_sys_ftruncate
	},		/* 130 = ftruncate */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)sys_flock
	},		/* 131 = flock */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 132 = setgid */
	{
		ns(struct linux_sys_sendto_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendto
	},		/* 133 = sendto */
	{
		ns(struct sys_shutdown_args),
		.sy_call = (sy_call_t *)sys_shutdown
	},		/* 134 = shutdown */
	{
		ns(struct linux_sys_socketpair_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_socketpair
	},		/* 135 = socketpair */
	{
		ns(struct sys_mkdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdir
	},		/* 136 = mkdir */
	{
		ns(struct sys_rmdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_rmdir
	},		/* 137 = rmdir */
	{
		ns(struct osf1_sys_utimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_utimes
	},		/* 138 = utimes */
	{
		.sy_call = linux_sys_nosys,
	},		/* 139 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 140 = filler */
	{
		ns(struct linux_sys_getpeername_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getpeername
	},		/* 141 = getpeername */
	{
		.sy_call = linux_sys_nosys,
	},		/* 142 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 143 = filler */
	{
		ns(struct linux_sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getrlimit
	},		/* 144 = getrlimit */
	{
		ns(struct linux_sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setrlimit
	},		/* 145 = setrlimit */
	{
		.sy_call = linux_sys_nosys,
	},		/* 146 = filler */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 147 = setsid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 148 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 149 = filler */
	{
		ns(struct linux_sys_getsockname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockname
	},		/* 150 = getsockname */
	{
		.sy_call = linux_sys_nosys,
	},		/* 151 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 152 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 153 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 154 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 155 = filler */
	{
		ns(struct linux_sys_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigaction
	},		/* 156 = sigaction */
	{
		.sy_call = linux_sys_nosys,
	},		/* 157 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 158 = filler */
	{
		ns(struct compat_43_sys_getdirentries_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getdirentries
	},		/* 159 = getdirentries */
	{
		ns(struct osf1_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_statfs
	},		/* 160 = statfs */
	{
		ns(struct osf1_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_fstatfs
	},		/* 161 = fstatfs */
	{
		.sy_call = linux_sys_nosys,
	},		/* 162 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 163 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 164 = filler */
	{
		ns(struct compat_09_sys_getdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_09_sys_getdomainname
	},		/* 165 = getdomainname */
	{
		ns(struct linux_sys_setdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setdomainname
	},		/* 166 = setdomainname */
	{
		.sy_call = linux_sys_nosys,
	},		/* 167 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 168 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 169 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 170 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 171 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 172 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 173 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 174 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 175 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 176 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 177 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 178 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 179 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 180 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 181 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 182 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 183 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 184 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 185 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 186 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 187 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 188 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 189 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 190 = filler */
	{
		ns(struct linux_sys_ugetrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ugetrlimit
	},		/* 191 = ugetrlimit */
	{
		.sy_call = linux_sys_nosys,
	},		/* 192 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 193 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 194 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 195 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 196 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 197 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 198 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 199 = filler */
#ifdef SYSVMSG
	{
		ns(struct linux_sys_msgctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_msgctl
	},		/* 200 = msgctl */
	{
		ns(struct sys_msgget_args),
		.sy_call = (sy_call_t *)sys_msgget
	},		/* 201 = msgget */
	{
		ns(struct sys_msgrcv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgrcv
	},		/* 202 = msgrcv */
	{
		ns(struct sys_msgsnd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgsnd
	},		/* 203 = msgsnd */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 200 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 201 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 202 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 203 = filler */
#endif
#ifdef SYSVSEM
	{
		ns(struct linux_sys_semctl_args),
		.sy_call = (sy_call_t *)linux_sys_semctl
	},		/* 204 = semctl */
	{
		ns(struct sys_semget_args),
		.sy_call = (sy_call_t *)sys_semget
	},		/* 205 = semget */
	{
		ns(struct sys_semop_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_semop
	},		/* 206 = semop */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 204 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 205 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 206 = filler */
#endif
	{
		ns(struct linux_sys_olduname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_olduname
	},		/* 207 = olduname */
	{
		ns(struct sys___posix_lchown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_lchown
	},		/* 208 = __posix_lchown */
#ifdef SYSVSHM
	{
		ns(struct linux_sys_shmat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_shmat
	},		/* 209 = shmat */
	{
		ns(struct linux_sys_shmctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_shmctl
	},		/* 210 = shmctl */
	{
		ns(struct sys_shmdt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmdt
	},		/* 211 = shmdt */
	{
		ns(struct linux_sys_shmget_args),
		.sy_call = (sy_call_t *)linux_sys_shmget
	},		/* 212 = shmget */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 209 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 210 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 211 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 212 = filler */
#endif
	{
		.sy_call = linux_sys_nosys,
	},		/* 213 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 214 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 215 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 216 = filler */
	{
		ns(struct sys___msync13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___msync13
	},		/* 217 = __msync13 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 218 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 219 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 220 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 221 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 222 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 223 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 224 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 225 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 226 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 227 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 228 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 229 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 230 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 231 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 232 = filler */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)sys_getpgid
	},		/* 233 = getpgid */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)sys_getsid
	},		/* 234 = getsid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 235 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 236 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 237 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 238 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 239 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 240 = filler */
	{
		ns(struct osf1_sys_sysinfo_args),
		.sy_call = (sy_call_t *)osf1_sys_sysinfo
	},		/* 241 = sysinfo */
	{
		.sy_call = linux_sys_nosys,
	},		/* 242 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 243 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 244 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 247 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 248 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 249 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 250 = filler */
	{
		ns(struct osf1_sys_usleep_thread_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_usleep_thread
	},		/* 251 = usleep_thread */
	{
		.sy_call = linux_sys_nosys,
	},		/* 252 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 253 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 254 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 255 = filler */
	{
		ns(struct osf1_sys_getsysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_getsysinfo
	},		/* 256 = getsysinfo */
	{
		ns(struct osf1_sys_setsysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)osf1_sys_setsysinfo
	},		/* 257 = setsysinfo */
	{
		.sy_call = linux_sys_nosys,
	},		/* 258 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 259 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 260 = filler */
	{
		ns(struct linux_sys_fdatasync_args),
		.sy_call = (sy_call_t *)linux_sys_fdatasync
	},		/* 261 = fdatasync */
	{
		.sy_call = linux_sys_nosys,
	},		/* 262 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 263 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 264 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 265 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 266 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 267 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 268 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 269 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 270 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 271 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 272 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 273 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 274 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 275 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 276 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 277 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 278 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 279 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 280 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 284 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 285 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 287 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 288 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 290 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 291 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 292 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 293 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 294 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 295 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 296 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 297 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 298 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 299 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 300 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 301 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 302 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 303 = filler */
	{
		ns(struct linux_sys_swapoff_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapoff
	},		/* 304 = swapoff */
	{
		ns(struct linux_sys_getdents_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents
	},		/* 305 = getdents */
	{
		.sy_call = linux_sys_nosys,
	},		/* 306 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 307 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 308 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 309 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 310 = filler */
	{
		ns(struct linux_sys_reboot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_reboot
	},		/* 311 = reboot */
	{
		ns(struct linux_sys_clone_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clone
	},		/* 312 = clone */
#ifdef EXEC_AOUT
	{
		ns(struct linux_sys_uselib_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uselib
	},		/* 313 = uselib */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 313 = filler */
#endif
	{
		ns(struct sys_mlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mlock
	},		/* 314 = mlock */
	{
		ns(struct sys_munlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munlock
	},		/* 315 = munlock */
	{
		ns(struct sys_mlockall_args),
		.sy_call = (sy_call_t *)sys_mlockall
	},		/* 316 = mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 317 = munlockall */
	{
		ns(struct linux_sys_sysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sysinfo
	},		/* 318 = sysinfo */
	{
		ns(struct linux_sys___sysctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys___sysctl
	},		/* 319 = __sysctl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 320 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 321 = filler */
	{
		ns(struct linux_sys_swapon_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapon
	},		/* 322 = swapon */
	{
		ns(struct linux_sys_times_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_times
	},		/* 323 = times */
	{
		ns(struct linux_sys_personality_args),
		.sy_call = (sy_call_t *)linux_sys_personality
	},		/* 324 = personality */
	{
		ns(struct linux_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsuid
	},		/* 325 = setfsuid */
	{
		ns(struct linux_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsgid
	},		/* 326 = setfsgid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 327 = filler */
	{
		ns(struct linux_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statfs
	},		/* 328 = statfs */
	{
		ns(struct linux_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatfs
	},		/* 329 = fstatfs */
	{
		ns(struct linux_sys_sched_setparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setparam
	},		/* 330 = sched_setparam */
	{
		ns(struct linux_sys_sched_getparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getparam
	},		/* 331 = sched_getparam */
	{
		ns(struct linux_sys_sched_setscheduler_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setscheduler
	},		/* 332 = sched_setscheduler */
	{
		ns(struct linux_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)linux_sys_sched_getscheduler
	},		/* 333 = sched_getscheduler */
	{
		.sy_call = (sy_call_t *)linux_sys_sched_yield
	},		/* 334 = sched_yield */
	{
		ns(struct linux_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_max
	},		/* 335 = sched_get_priority_max */
	{
		ns(struct linux_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_min
	},		/* 336 = sched_get_priority_min */
	{
		.sy_call = linux_sys_nosys,
	},		/* 337 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 338 = filler */
	{
		ns(struct linux_sys_uname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uname
	},		/* 339 = uname */
	{
		ns(struct linux_sys_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_nanosleep
	},		/* 340 = nanosleep */
	{
		ns(struct linux_sys_mremap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mremap
	},		/* 341 = mremap */
	{
		.sy_call = linux_sys_nosys,
	},		/* 342 = filler */
	{
		ns(struct linux_sys_setresuid_args),
		.sy_call = (sy_call_t *)linux_sys_setresuid
	},		/* 343 = setresuid */
	{
		ns(struct linux_sys_getresuid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresuid
	},		/* 344 = getresuid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 347 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 348 = filler */
	{
		ns(struct linux_sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pread
	},		/* 349 = pread */
	{
		ns(struct linux_sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwrite
	},		/* 350 = pwrite */
	{
		ns(struct linux_sys_rt_sigreturn_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigreturn
	},		/* 351 = rt_sigreturn */
	{
		ns(struct linux_sys_rt_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigaction
	},		/* 352 = rt_sigaction */
	{
		ns(struct linux_sys_rt_sigprocmask_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigprocmask
	},		/* 353 = rt_sigprocmask */
	{
		ns(struct linux_sys_rt_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigpending
	},		/* 354 = rt_sigpending */
	{
		ns(struct linux_sys_rt_sigtimedwait_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigtimedwait
	},		/* 355 = rt_sigtimedwait */
	{
		ns(struct linux_sys_rt_queueinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_queueinfo
	},		/* 356 = rt_queueinfo */
	{
		ns(struct linux_sys_rt_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigsuspend
	},		/* 357 = rt_sigsuspend */
	{
		ns(struct linux_sys_select_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_select
	},		/* 358 = select */
	{
		ns(struct linux_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_gettimeofday
	},		/* 359 = gettimeofday */
	{
		ns(struct linux_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_settimeofday
	},		/* 360 = settimeofday */
	{
		ns(struct compat_50_sys_getitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getitimer
	},		/* 361 = getitimer */
	{
		ns(struct compat_50_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_setitimer
	},		/* 362 = setitimer */
	{
		ns(struct compat_50_sys_utimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_utimes
	},		/* 363 = utimes */
	{
		ns(struct compat_50_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getrusage
	},		/* 364 = getrusage */
	{
		ns(struct linux_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_wait4
	},		/* 365 = wait4 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 366 = filler */
	{
		ns(struct sys___getcwd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getcwd
	},		/* 367 = __getcwd */
	{
		.sy_call = linux_sys_nosys,
	},		/* 368 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 369 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 373 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 374 = filler */
	{
		ns(struct sys_mincore_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mincore
	},		/* 375 = mincore */
	{
		.sy_call = linux_sys_nosys,
	},		/* 376 = filler */
	{
		ns(struct linux_sys_getdents64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents64
	},		/* 377 = getdents64 */
	{
		.sy_call = (sy_call_t *)linux_sys_gettid
	},		/* 378 = gettid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 380 = filler */
	{
		ns(struct linux_sys_tkill_args),
		.sy_call = (sy_call_t *)linux_sys_tkill
	},		/* 381 = tkill */
	{
		ns(struct linux_sys_setxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setxattr
	},		/* 382 = setxattr */
	{
		ns(struct linux_sys_lsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lsetxattr
	},		/* 383 = lsetxattr */
	{
		ns(struct linux_sys_fsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fsetxattr
	},		/* 384 = fsetxattr */
	{
		ns(struct linux_sys_getxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getxattr
	},		/* 385 = getxattr */
	{
		ns(struct linux_sys_lgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lgetxattr
	},		/* 386 = lgetxattr */
	{
		ns(struct linux_sys_fgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fgetxattr
	},		/* 387 = fgetxattr */
	{
		ns(struct linux_sys_listxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_listxattr
	},		/* 388 = listxattr */
	{
		ns(struct linux_sys_llistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_llistxattr
	},		/* 389 = llistxattr */
	{
		ns(struct linux_sys_flistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_flistxattr
	},		/* 390 = flistxattr */
	{
		ns(struct linux_sys_removexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_removexattr
	},		/* 391 = removexattr */
	{
		ns(struct linux_sys_lremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lremovexattr
	},		/* 392 = lremovexattr */
	{
		ns(struct linux_sys_fremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fremovexattr
	},		/* 393 = fremovexattr */
	{
		ns(struct linux_sys_futex_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_futex
	},		/* 394 = futex */
	{
		ns(struct linux_sys_sched_setaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setaffinity
	},		/* 395 = sched_setaffinity */
	{
		ns(struct linux_sys_sched_getaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getaffinity
	},		/* 396 = sched_getaffinity */
	{
		.sy_call = linux_sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 399 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 400 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 401 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 402 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 403 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 404 = filler */
	{
		ns(struct linux_sys_exit_group_args),
		.sy_call = (sy_call_t *)linux_sys_exit_group
	},		/* 405 = exit_group */
	{
		.sy_call = linux_sys_nosys,
	},		/* 406 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 407 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 408 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 410 = filler */
	{
		ns(struct linux_sys_set_tid_address_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_tid_address
	},		/* 411 = set_tid_address */
	{
		.sy_call = linux_sys_nosys,
	},		/* 412 = filler */
	{
		ns(struct linux_sys_fadvise64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_fadvise64
	},		/* 413 = fadvise64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 418 = filler */
	{
		ns(struct linux_sys_clock_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_settime
	},		/* 419 = clock_settime */
	{
		ns(struct linux_sys_clock_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_gettime
	},		/* 420 = clock_gettime */
	{
		ns(struct linux_sys_clock_getres_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_getres
	},		/* 421 = clock_getres */
	{
		ns(struct linux_sys_clock_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_nanosleep
	},		/* 422 = clock_nanosleep */
	{
		.sy_call = linux_sys_nosys,
	},		/* 423 = filler */
	{
		ns(struct linux_sys_tgkill_args),
		.sy_call = (sy_call_t *)linux_sys_tgkill
	},		/* 424 = tgkill */
	{
		ns(struct linux_sys_stat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stat64
	},		/* 425 = stat64 */
	{
		ns(struct linux_sys_lstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lstat64
	},		/* 426 = lstat64 */
	{
		ns(struct linux_sys_fstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat64
	},		/* 427 = fstat64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 434 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 435 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 436 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 438 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 439 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 440 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 441 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 449 = filler */
	{
		ns(struct linux_sys_openat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_openat
	},		/* 450 = openat */
	{
		ns(struct sys_mkdirat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdirat
	},		/* 451 = mkdirat */
	{
		ns(struct linux_sys_mknodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknodat
	},		/* 452 = mknodat */
	{
		ns(struct linux_sys_fchownat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchownat
	},		/* 453 = fchownat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 454 = filler */
	{
		ns(struct linux_sys_fstatat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatat64
	},		/* 455 = fstatat64 */
	{
		ns(struct linux_sys_unlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlinkat
	},		/* 456 = unlinkat */
	{
		ns(struct sys_renameat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_renameat
	},		/* 457 = renameat */
	{
		ns(struct linux_sys_linkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_linkat
	},		/* 458 = linkat */
	{
		ns(struct sys_symlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlinkat
	},		/* 459 = symlinkat */
	{
		ns(struct sys_readlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlinkat
	},		/* 460 = readlinkat */
	{
		ns(struct linux_sys_fchmodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchmodat
	},		/* 461 = fchmodat */
	{
		ns(struct linux_sys_faccessat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_faccessat
	},		/* 462 = faccessat */
	{
		ns(struct linux_sys_pselect6_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pselect6
	},		/* 463 = pselect6 */
	{
		ns(struct linux_sys_ppoll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ppoll
	},		/* 464 = ppoll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 465 = filler */
	{
		ns(struct linux_sys_set_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_robust_list
	},		/* 466 = set_robust_list */
	{
		ns(struct linux_sys_get_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_get_robust_list
	},		/* 467 = get_robust_list */
	{
		.sy_call = linux_sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 474 = filler */
	{
		ns(struct linux_sys_utimensat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utimensat
	},		/* 475 = utimensat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 478 = filler */
	{
		ns(struct linux_sys_recvmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmmsg
	},		/* 479 = recvmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 486 = filler */
	{
		ns(struct linux_sys_dup3_args),
		.sy_call = (sy_call_t *)linux_sys_dup3
	},		/* 487 = dup3 */
	{
		ns(struct linux_sys_pipe2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe2
	},		/* 488 = pipe2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 501 = filler */
	{
		ns(struct linux_sys_accept4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept4
	},		/* 502 = accept4 */
	{
		ns(struct linux_sys_sendmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmmsg
	},		/* 503 = sendmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 511 = filler */
};
