/*	$NetbSD$	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * UART Registers
 */

#ifndef _OCTEON_UARTREG_H_
#define _OCTEON_UARTREG_H_

/* ---- register addresses */

#define	MIO_UART0_RBR				0x0001180000000800ULL
#define	MIO_UART0_IER				0x0001180000000808ULL
#define	MIO_UART0_IIR				0x0001180000000810ULL
#define	MIO_UART0_LCR				0x0001180000000818ULL
#define	MIO_UART0_MCR				0x0001180000000820ULL
#define	MIO_UART0_LSR				0x0001180000000828ULL
#define	MIO_UART0_MSR				0x0001180000000830ULL
#define	MIO_UART0_SCR				0x0001180000000838ULL
#define	MIO_UART0_THR				0x0001180000000840ULL
#define	MIO_UART0_FCR				0x0001180000000850ULL
#define	MIO_UART0_DLL				0x0001180000000880ULL
#define	MIO_UART0_DLH				0x0001180000000888ULL
#define	MIO_UART0_FAR				0x0001180000000920ULL
#define	MIO_UART0_TFR				0x0001180000000928ULL
#define	MIO_UART0_RFW				0x0001180000000930ULL
#define	MIO_UART0_USR				0x0001180000000938ULL
#define	MIO_UART0_TFL				0x0001180000000a00ULL
#define	MIO_UART0_RFL				0x0001180000000a08ULL
#define	MIO_UART0_SRR				0x0001180000000a10ULL
#define	MIO_UART0_SRTS				0x0001180000000a18ULL
#define	MIO_UART0_SBCR				0x0001180000000a20ULL
#define	MIO_UART0_SFE				0x0001180000000a30ULL
#define	MIO_UART0_SRT				0x0001180000000a38ULL
#define	MIO_UART0_STT				0x0001180000000b00ULL
#define	MIO_UART0_HTX				0x0001180000000b08ULL
#define	MIO_UART1_RBR				0x0001180000000c00ULL
#define	MIO_UART1_IER				0x0001180000000c08ULL
#define	MIO_UART1_IIR				0x0001180000000c10ULL
#define	MIO_UART1_LCR				0x0001180000000c18ULL
#define	MIO_UART1_MCR				0x0001180000000c20ULL
#define	MIO_UART1_LSR				0x0001180000000c28ULL
#define	MIO_UART1_MSR				0x0001180000000c30ULL
#define	MIO_UART1_SCR				0x0001180000000c38ULL
#define	MIO_UART1_THR				0x0001180000000c40ULL
#define	MIO_UART1_FCR				0x0001180000000c50ULL
#define	MIO_UART1_DLL				0x0001180000000c80ULL
#define	MIO_UART1_DLH				0x0001180000000c88ULL
#define	MIO_UART1_FAR				0x0001180000000d20ULL
#define	MIO_UART1_TFR				0x0001180000000d28ULL
#define	MIO_UART1_RFW				0x0001180000000d30ULL
#define	MIO_UART1_USR				0x0001180000000d38ULL
#define	MIO_UART1_TFL				0x0001180000000e00ULL
#define	MIO_UART1_RFL				0x0001180000000e08ULL
#define	MIO_UART1_SRR				0x0001180000000e10ULL
#define	MIO_UART1_SRTS				0x0001180000000e18ULL
#define	MIO_UART1_SBCR				0x0001180000000e20ULL
#define	MIO_UART1_SFE				0x0001180000000e30ULL
#define	MIO_UART1_SRT				0x0001180000000e38ULL
#define	MIO_UART1_STT				0x0001180000000f00ULL
#define	MIO_UART1_HTX				0x0001180000000f08ULL

/* ---- snprintb */

/* XXX */

/* ---- bus_space */

#define	MIO_UART0_BASE				0x0001180000000800ULL
#define	MIO_UART1_BASE				0x0001180000000c00ULL

#define	MIO_UART_RBR_OFFSET			0x0000
#define	MIO_UART_IER_OFFSET			0x0008
#define	MIO_UART_IIR_OFFSET			0x0010
#define	MIO_UART_LCR_OFFSET			0x0018
#define	MIO_UART_MCR_OFFSET			0x0020
#define	MIO_UART_LSR_OFFSET			0x0028
#define	MIO_UART_MSR_OFFSET			0x0030
#define	MIO_UART_SCR_OFFSET			0x0038
#define	MIO_UART_THR_OFFSET			0x0040
#define	MIO_UART_FCR_OFFSET			0x0050
#define	MIO_UART_DLL_OFFSET			0x0080
#define	MIO_UART_DLH_OFFSET			0x0088
#define	MIO_UART_FAR_OFFSET			0x0120
#define	MIO_UART_TFR_OFFSET			0x0128
#define	MIO_UART_RFW_OFFSET			0x0130
#define	MIO_UART_USR_OFFSET			0x0138
#define	MIO_UART_TFL_OFFSET			0x0200
#define	MIO_UART_RFL_OFFSET			0x0208
#define	MIO_UART_SRR_OFFSET			0x0210
#define	MIO_UART_SRTS_OFFSET			0x0218
#define	MIO_UART_SBCR_OFFSET			0x0220
#define	MIO_UART_SFE_OFFSET			0x0230
#define	MIO_UART_SRT_OFFSET			0x0238
#define	MIO_UART_STT_OFFSET			0x0300
#define	MIO_UART_HTX_OFFSET			0x0308

#endif /* _OCTEON_UARTREG_H_ */
