/* $NetBSD: sun6i_a31_ccu.h,v 1.1.4.2 2017/07/18 19:13:08 snj Exp $ */

/*-
 * Copyright (c) 2017 Emmanuel Vadot <manu@freebsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef __CCU_A31_H__
#define __CCU_A31_H__

#define	A31_RST_USB_PHY0		0
#define	A31_RST_USB_PHY1		1
#define	A31_RST_USB_PHY2		2
#define	A31_RST_AHB1_MIPI_DSI		3
#define	A31_RST_AHB1_SS			4
#define	A31_RST_AHB1_DMA		5
#define	A31_RST_AHB1_MMC0		6
#define	A31_RST_AHB1_MMC1		7
#define	A31_RST_AHB1_MMC2		8
#define	A31_RST_AHB1_MMC3		9
#define	A31_RST_AHB1_NAND1		10
#define	A31_RST_AHB1_NAND0		11
#define	A31_RST_AHB1_SDRAM		12
#define	A31_RST_AHB1_EMAC		13
#define	A31_RST_AHB1_TS			14
#define	A31_RST_AHB1_HSTIMER		15
#define	A31_RST_AHB1_SPI0		16
#define	A31_RST_AHB1_SPI1		17
#define	A31_RST_AHB1_SPI2		18
#define	A31_RST_AHB1_SPI3		19
#define	A31_RST_AHB1_OTG		20
#define	A31_RST_AHB1_EHCI0		21
#define	A31_RST_AHB1_EHCI1		22
#define	A31_RST_AHB1_OHCI0		23
#define	A31_RST_AHB1_OHCI1		24
#define	A31_RST_AHB1_OHCI2		25
#define	A31_RST_AHB1_VE			26
#define	A31_RST_AHB1_LCD0		27
#define	A31_RST_AHB1_LCD1		28
#define	A31_RST_AHB1_CSI		29
#define	A31_RST_AHB1_HDMI		30
#define	A31_RST_AHB1_BE0		31
#define	A31_RST_AHB1_BE1		32
#define	A31_RST_AHB1_FE0		33
#define	A31_RST_AHB1_FE1		34
#define	A31_RST_AHB1_MP			35
#define	A31_RST_AHB1_GPU		36
#define	A31_RST_AHB1_DEU0		37
#define	A31_RST_AHB1_DEU1		38
#define	A31_RST_AHB1_DRC0		39
#define	A31_RST_AHB1_DRC1		40
#define	A31_RST_AHB1_LVDS		41
#define	A31_RST_APB1_CODEC		42
#define	A31_RST_APB1_SPDIF		43
#define	A31_RST_APB1_DIGITAL_MIC	44
#define	A31_RST_APB1_DAUDIO0		45
#define	A31_RST_APB1_DAUDIO1		46
#define	A31_RST_APB2_I2C0		47
#define	A31_RST_APB2_I2C1		48
#define	A31_RST_APB2_I2C2		49
#define	A31_RST_APB2_I2C3		50
#define	A31_RST_APB2_UART0		51
#define	A31_RST_APB2_UART1		52
#define	A31_RST_APB2_UART2		53
#define	A31_RST_APB2_UART3		54
#define	A31_RST_APB2_UART4		55
#define	A31_RST_APB2_UART5		56

#define	A31_CLK_PLL_CPU			0
#define	A31_CLK_PLL_AUDIO_BASE		1
#define	A31_CLK_PLL_AUDIO		2
#define	A31_CLK_PLL_AUDIO_2X		3
#define	A31_CLK_PLL_AUDIO_4X		4
#define	A31_CLK_PLL_AUDIO_8X		5
#define	A31_CLK_PLL_VIDEO0		6
#define	A31_CLK_PLL_VIDEO0_2X		7
#define	A31_CLK_PLL_VE			8
#define	A31_CLK_PLL_DDR			9
#define	A31_CLK_PLL_PERIPH		10
#define	A31_CLK_PLL_PERIPH_2X		11
#define	A31_CLK_PLL_VIDEO1		12
#define	A31_CLK_PLL_VIDEO1_2X		13
#define	A31_CLK_PLL_GPU			14
#define	A31_CLK_PLL_MIPI		15
#define	A31_CLK_PLL9			16
#define	A31_CLK_PLL10			17
#define	A31_CLK_CPU			18
#define	A31_CLK_AXI			19
#define	A31_CLK_AHB1			20
#define	A31_CLK_APB1			21
#define	A31_CLK_APB2			22
#define	A31_CLK_AHB1_MIPIDSI		23
#define	A31_CLK_AHB1_SS			24
#define	A31_CLK_AHB1_DMA		25
#define	A31_CLK_AHB1_MMC0		26
#define	A31_CLK_AHB1_MMC1		27
#define	A31_CLK_AHB1_MMC2		28
#define	A31_CLK_AHB1_MMC3		29
#define	A31_CLK_AHB1_NAND1		30
#define	A31_CLK_AHB1_NAND0		31
#define	A31_CLK_AHB1_SDRAM		32
#define	A31_CLK_AHB1_EMAC		33
#define	A31_CLK_AHB1_TS			34
#define	A31_CLK_AHB1_HSTIMER		35
#define	A31_CLK_AHB1_SPI0		36
#define	A31_CLK_AHB1_SPI1		37
#define	A31_CLK_AHB1_SPI2		38
#define	A31_CLK_AHB1_SPI3		39
#define	A31_CLK_AHB1_OTG		40
#define	A31_CLK_AHB1_EHCI0		41
#define	A31_CLK_AHB1_EHCI1		42
#define	A31_CLK_AHB1_OHCI0		43
#define	A31_CLK_AHB1_OHCI1		44
#define	A31_CLK_AHB1_OHCI2		45
#define	A31_CLK_AHB1_VE			46
#define	A31_CLK_AHB1_LCD0		47
#define	A31_CLK_AHB1_LCD1		48
#define	A31_CLK_AHB1_CSI		49
#define	A31_CLK_AHB1_HDMI		50
#define	A31_CLK_AHB1_BE0		51
#define	A31_CLK_AHB1_BE1		52
#define	A31_CLK_AHB1_FE0		53
#define	A31_CLK_AHB1_FE1		54
#define	A31_CLK_AHB1_MP			55
#define	A31_CLK_AHB1_GPU		56
#define	A31_CLK_AHB1_DEU0		57
#define	A31_CLK_AHB1_DEU1		58
#define	A31_CLK_AHB1_DRC0		59
#define	A31_CLK_AHB1_DRC1		60
#define	A31_CLK_APB1_CODEC		61
#define	A31_CLK_APB1_SPDIF		62
#define	A31_CLK_APB1_DIGITAL_MIC	63
#define	A31_CLK_APB1_PIO		64
#define	A31_CLK_APB1_DAUDIO0		65
#define	A31_CLK_APB1_DAUDIO1		66
#define	A31_CLK_APB2_I2C0		67
#define	A31_CLK_APB2_I2C1		68
#define	A31_CLK_APB2_I2C2		69
#define	A31_CLK_APB2_I2C3		70
#define	A31_CLK_APB2_UART0		71
#define	A31_CLK_APB2_UART1		72
#define	A31_CLK_APB2_UART2		73
#define	A31_CLK_APB2_UART3		74
#define	A31_CLK_APB2_UART4		75
#define	A31_CLK_APB2_UART5		76
#define	A31_CLK_NAND0			77
#define	A31_CLK_NAND1			78
#define	A31_CLK_MMC0			79
#define	A31_CLK_MMC0_SAMPLE		80
#define	A31_CLK_MMC0_OUTPUT		81
#define	A31_CLK_MMC1			82
#define	A31_CLK_MMC1_SAMPLE		83
#define	A31_CLK_MMC1_OUTPUT		84
#define	A31_CLK_MMC2			85
#define	A31_CLK_MMC2_SAMPLE		86
#define	A31_CLK_MMC2_OUTPUT		87
#define	A31_CLK_MMC3			88
#define	A31_CLK_MMC3_SAMPLE		89
#define	A31_CLK_MMC3_OUTPUT		90
#define	A31_CLK_TS			91
#define	A31_CLK_SS			92
#define	A31_CLK_SPI0			93
#define	A31_CLK_SPI1			94
#define	A31_CLK_SPI2			95
#define	A31_CLK_SPI3			96
#define	A31_CLK_DAUDIO0			97
#define	A31_CLK_DAUDIO1			98
#define	A31_CLK_SPDIF			99
#define	A31_CLK_USB_PHY0		100
#define	A31_CLK_USB_PHY1		101
#define	A31_CLK_USB_PHY2		102
#define	A31_CLK_USB_OHCI0		103
#define	A31_CLK_USB_OHCI1		104
#define	A31_CLK_USB_OHCI2		105
#define	A31_CLK_MDFS			107
#define	A31_CLK_SDRAM0			108
#define	A31_CLK_SDRAM1			109
#define	A31_CLK_DRAM_VE			110
#define	A31_CLK_DRAM_CSI_ISP		111
#define	A31_CLK_DRAM_TS			112
#define	A31_CLK_DRAM_DRC0		113
#define	A31_CLK_DRAM_DRC1		114
#define	A31_CLK_DRAM_DEU0		115
#define	A31_CLK_DRAM_DEU1		116
#define	A31_CLK_DRAM_FE0		117
#define	A31_CLK_DRAM_FE1		118
#define	A31_CLK_DRAM_BE0		119
#define	A31_CLK_DRAM_BE1		120
#define	A31_CLK_DRAM_MP			121
#define	A31_CLK_BE0			122
#define	A31_CLK_BE1			123
#define	A31_CLK_FE0			124
#define	A31_CLK_FE1			125
#define	A31_CLK_MP			126
#define	A31_CLK_LCD0_CH0		127
#define	A31_CLK_LCD1_CH0		128
#define	A31_CLK_LCD0_CH1		129
#define	A31_CLK_LCD1_CH1		130
#define	A31_CLK_CSI0_SCLK		131
#define	A31_CLK_CSI0_MCLK		132
#define	A31_CLK_CSI1_MCLK		133
#define	A31_CLK_VE			134
#define	A31_CLK_CODEC			135
#define	A31_CLK_AVS			136
#define	A31_CLK_DIGITAL_MIC		137
#define	A31_CLK_HDMI			138
#define	A31_CLK_HDMI_DDC		139
#define	A31_CLK_PS			140
#define	A31_CLK_MBUS0			141
#define	A31_CLK_MBUS1			142
#define	A31_CLK_MIPI_DSI		143
#define	A31_CLK_MIPI_DSI_DPHY		144
#define	A31_CLK_MIPI_CSI_DPHY		145
#define	A31_CLK_IEP_DRC0		146
#define	A31_CLK_IEP_DRC1		147
#define	A31_CLK_IEP_DEU0		148
#define	A31_CLK_IEP_DEU1		149
#define	A31_CLK_GPU_CORE		150
#define	A31_CLK_GPU_MEMORY		151
#define	A31_CLK_GPU_HYD			152
#define	A31_CLK_ATS			153
#define	A31_CLK_TRACE			154
#define	A31_CLK_OUT_A			155
#define	A31_CLK_OUT_B			156
#define	A31_CLK_OUT_C			157

#endif	/* __CCU_A31		H__ */
