/* $NetBSD: g2_intr.h,v 1.1 2013/02/19 16:07:23 matt Exp $ */
/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Matt Thomas of 3am Software Foundry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_CORTINA_G2_INTR_H_
#define _ARM_CORTINA_G2_INTR_H_

#define	PIC_G2_GIC_MAXSOURCES		80
#define	PIC_G2_REGBUS_MAXSOURCES	16
#define	PIC_G2_PCIE_MAXSOURCES		8	/* times 3 */
#define	PIC_G2_DMAENG_MAXSOURCES	20
#define	PIC_G2_DMASSP_MAXSOURCES	16
#define	PIC_G2_GPIO_MAXSOURCES		32	/* times 5 */

#define	PIC_MAXSOURCES		PIC_G2_GIC_MAXSOURCES
#define	PIC_MAXMAXSOURCES	\
	(PIC_G2_GIC_MAXSOURCES + PIC_G2_REGBUS_MAXSOURCES \
	 + 3*PIC_G2_PCIE_MAXSOURCES + PIC_G2_DMAENG_MAXSOURCES \
	 + PIC_G2_DMASSP_MAXSOURCES + 5 * PIC_G2_GPIO_MAXSOURCES)

#define	PIC_G2_GIC_BASE		0
#define	PIC_G2_REGBUS_BASE	PIC_G2_GIC_MAXSOURCES
#define	PIC_G2_PCIE0_BASE	(PIC_G2_REGBUS_BASE + PIC_G2_REGBUS_MAXSOURCES)
#define	PIC_G2_PCIE1_BASE	(PIC_G2_PCIE0_BASE + PIC_G2_PCIE_MAXSOURCES)
#define	PIC_G2_PCIE2_BASE	(PIC_G2_PCIE1_BASE + PIC_G2_PCIE_MAXSOURCES)
#define	PIC_G2_DMAENG_BASE	(PIC_G2_PCIE2_BASE + PIC_G2_PCIE_MAXSOURCES)
#define	PIC_G2_DMASSP_BASE	(PIC_G2_DMAENG_BASE + PIC_G2_DMAENG_MAXSOURCES)
#define	PIC_G2_GPIO0_BASE	(PIC_G2_DMASSP_BASE + PIC_G2_DMASSP_MAXSOURCES)
#define	PIC_G2_GPIO1_BASE	(PIC_G2_GPIO0_BASE + PIC_G2_GPIO_MAXSOURCES)
#define	PIC_G2_GPIO2_BASE	(PIC_G2_GPIO1_BASE + PIC_G2_GPIO_MAXSOURCES)
#define	PIC_G2_GPIO3_BASE	(PIC_G2_GPIO2_BASE + PIC_G2_GPIO_MAXSOURCES)
#define	PIC_G2_GPIO4_BASE	(PIC_G2_GPIO3_BASE + PIC_G2_GPIO_MAXSOURCES)

/*
 * The BCM53xx uses a generic interrupt controller so pull that stuff.
 */
#include <arm/cortex/gic_intr.h>
#include <arm/cortex/a9tmr_intr.h>	/* A9 Timer PPIs */

#define	IRQ_GLOBAL_SYS		(PIC_G2_GIC_BASE + 32)
#define	IRQ_NETENG		(PIC_G2_GIC_BASE + 33)
#define	IRQ_ARM_PARITY		(PIC_G2_GIC_BASE + 34)
#define	IRQ_PERIPH_REGBUS	(PIC_G2_GIC_BASE + 35)
#define	IRQ_L2_CTRL		(PIC_G2_GIC_BASE + 36)
#define	IRQ_SDRAM_CTRL		(PIC_G2_GIC_BASE + 37)
#define	IRQ_UART0		(PIC_G2_GIC_BASE + 38)
#define	IRQ_UART1		(PIC_G2_GIC_BASE + 39)
#define	IRQ_UART2		(PIC_G2_GIC_BASE + 40)
#define	IRQ_UART3		(PIC_G2_GIC_BASE + 41)
#define	IRQ_RTC_ALARM		(PIC_G2_GIC_BASE + 42)
#define	IRQ_RTC_PERIODIC	(PIC_G2_GIC_BASE + 43)
#define	IRQ_WAKEONLAN0		(PIC_G2_GIC_BASE + 44)
#define	IRQ_WAKEONLAN1		(PIC_G2_GIC_BASE + 45)
#define	IRQ_WAKEONLAN2		(PIC_G2_GIC_BASE + 46)
#define	IRQ_DMA			(PIC_G2_GIC_BASE + 47)
#define	IRQ_SW0			(PIC_G2_GIC_BASE + 48)
#define	IRQ_SW1			(PIC_G2_GIC_BASE + 49)
#define	IRQ_FLASH_CTRL		(PIC_G2_GIC_BASE + 50)
#define	IRQ_TS_CTRL		(PIC_G2_GIC_BASE + 51)
#define	IRQ_CIR_CTRL		(PIC_G2_GIC_BASE + 52)
#define	IRQ_PWR_CTRL		(PIC_G2_GIC_BASE + 53)
#define	IRQ_RECIRC_MB0		(PIC_G2_GIC_BASE + 54)
#define	IRQ_RECIRC_MB1		(PIC_G2_GIC_BASE + 55)
#define	IRQ_CRYPTO_ENG0		(PIC_G2_GIC_BASE + 56)
#define	IRQ_CRYPTO_ENG1		(PIC_G2_GIC_BASE + 57)
#define	IRQ_SDMMC		(PIC_G2_GIC_BASE + 58)
#define	IRQ_ARM_CTIRQ0		(PIC_G2_GIC_BASE + 59)
#define	IRQ_ARM_CTIRQ1		(PIC_G2_GIC_BASE + 60)
#define	IRQ_USB_DEV		(PIC_G2_GIC_BASE + 61)
#define	IRQ_USB_EHCI		(PIC_G2_GIC_BASE + 62)
#define	IRQ_USB_OHCI		(PIC_G2_GIC_BASE + 63)
#define	IRQ_AHCI_CTRL		(PIC_G2_GIC_BASE + 64)
#define	IRQ_PCIE0		(PIC_G2_GIC_BASE + 65)
#define	IRQ_PCIE1		(PIC_G2_GIC_BASE + 66)
#define	IRQ_PCIE2		(PIC_G2_GIC_BASE + 67)
#define	IRQ_LCD			(PIC_G2_GIC_BASE + 68)
#define	IRQ_NI_RX_XRAM0		(PIC_G2_GIC_BASE + 69)
#define	IRQ_NI_RX_XRAM1		(PIC_G2_GIC_BASE + 70)
#define	IRQ_NI_RX_XRAM2		(PIC_G2_GIC_BASE + 71)
#define	IRQ_NI_RX_XRAM3		(PIC_G2_GIC_BASE + 72)
#define	IRQ_NI_RX_XRAM4		(PIC_G2_GIC_BASE + 73)
#define	IRQ_NI_RX_XRAM5		(PIC_G2_GIC_BASE + 74)
#define	IRQ_NI_RX_XRAM6		(PIC_G2_GIC_BASE + 75)
#define	IRQ_NI_RX_XRAM7		(PIC_G2_GIC_BASE + 76)
#define	IRQ_NI_RX_XRAM8		(PIC_G2_GIC_BASE + 77)
#define	IRQ_SPDIF		(PIC_G2_GIC_BASE + 78)

#define	IRQ_REGBUS_SOFT0	(PIC_G2_REGBUS_BASE + 0)
#define	IRQ_REGBUS_SOFT1	(PIC_G2_REGBUS_BASE + 1)
#define	IRQ_REGBUS_TIMER0	(PIC_G2_REGBUS_BASE + 2)
#define	IRQ_REGBUS_TIMER1	(PIC_G2_REGBUS_BASE + 3)
#define	IRQ_REGBUS_AXII		(PIC_G2_REGBUS_BASE + 4)
#define	IRQ_REGBUS_SPI		(PIC_G2_REGBUS_BASE + 5)
#define	IRQ_REGBUS_GPIO0	(PIC_G2_REGBUS_BASE + 6)
#define	IRQ_REGBUS_GPIO1	(PIC_G2_REGBUS_BASE + 7)
#define	IRQ_REGBUS_GPIO2	(PIC_G2_REGBUS_BASE + 8)
#define	IRQ_REGBUS_GPIO3	(PIC_G2_REGBUS_BASE + 9)
#define	IRQ_REGBUS_GPIO4	(PIC_G2_REGBUS_BASE + 10)
#define	IRQ_REGBUS_BIWI		(PIC_G2_REGBUS_BASE + 11)
#define	IRQ_REGBUS_MDIO		(PIC_G2_REGBUS_BASE + 12)
#define	IRQ_REGBUS_DMASSP	(PIC_G2_REGBUS_BASE + 13)
#define	IRQ_REGBUS_TRNG		(PIC_G2_REGBUS_BASE + 14)

#define	IRQ_DMAENG_DESC		(PIC_G2_DMAENG_BASE + 0)
#define	IRQ_DMAENG_RX_0		(PIC_G2_DMAENG_BASE + 1)
#define	IRQ_DMAENG_RX_1		(PIC_G2_DMAENG_BASE + 2)
#define	IRQ_DMAENG_RX_2		(PIC_G2_DMAENG_BASE + 3)
#define	IRQ_DMAENG_RX_3		(PIC_G2_DMAENG_BASE + 4)
#define	IRQ_DMAENG_RX_4		(PIC_G2_DMAENG_BASE + 5)
#define	IRQ_DMAENG_RX_5		(PIC_G2_DMAENG_BASE + 6)
#define	IRQ_DMAENG_RX_6		(PIC_G2_DMAENG_BASE + 7)
#define	IRQ_DMAENG_RX_7		(PIC_G2_DMAENG_BASE + 8)
#define	IRQ_DMAENG_TX_0		(PIC_G2_DMAENG_BASE + 9)
#define	IRQ_DMAENG_TX_1		(PIC_G2_DMAENG_BASE + 10)
#define	IRQ_DMAENG_TX_2		(PIC_G2_DMAENG_BASE + 11)
#define	IRQ_DMAENG_TX_3		(PIC_G2_DMAENG_BASE + 12)
#define	IRQ_DMAENG_TX_4		(PIC_G2_DMAENG_BASE + 13)
#define	IRQ_DMAENG_TX_5		(PIC_G2_DMAENG_BASE + 14)
#define	IRQ_DMAENG_TX_6		(PIC_G2_DMAENG_BASE + 15)
#define	IRQ_DMAENG_TX_7		(PIC_G2_DMAENG_BASE + 16)
#define	IRQ_DMAENG_BMC_0	(PIC_G2_DMAENG_BASE + 17)
#define	IRQ_DMAENG_BMC_1	(PIC_G2_DMAENG_BASE + 18)

#define	IRQ_DMASSP_DESC		(PIC_G2_DMASSP_BASE + 0)
#define	IRQ_DMASSP_RX_5		(PIC_G2_DMASSP_BASE + 1)
#define	IRQ_DMASSP_RX_6		(PIC_G2_DMASSP_BASE + 2)
#define	IRQ_DMASSP_RX_7		(PIC_G2_DMASSP_BASE + 3)
#define	IRQ_DMASSP_TX_5		(PIC_G2_DMASSP_BASE + 4)
#define	IRQ_DMASSP_TX_6		(PIC_G2_DMASSP_BASE + 5)
#define	IRQ_DMASSP_TX_7		(PIC_G2_DMASSP_BASE + 6)
#define	IRQ_DMASSP_AXI_RX_RD_DESC (PIC_G2_DMASSP_BASE + 7)
#define	IRQ_DMASSP_AXI_TX_RD_DESC (PIC_G2_DMASSP_BASE + 8)
#define	IRQ_DMASSP_AXI_TX_RD_DATA (PIC_G2_DMASSP_BASE + 9)
#define	IRQ_DMASSP_AXI_RX_WR_DESC (PIC_G2_DMASSP_BASE + 10)
#define	IRQ_DMASSP_AXI_RX_WR_DATA (PIC_G2_DMASSP_BASE + 11)
#define	IRQ_DMASSP_AXI_TX_WR_DESC (PIC_G2_DMASSP_BASE + 12)
#define	IRQ_DMASSP_SSP_0	(PIC_G2_DMASSP_BASE + 13)
#define	IRQ_DMASSP_SSP_1	(PIC_G2_DMASSP_BASE + 14)

#endif /* _ARM_CORTINA_G2_INTR_H_ */
