/* $NetBSD: amlogic_intr.h,v 1.6 2015/03/22 17:28:22 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_AMLOGIC_INTR_H
#define _ARM_AMLOGIC_INTR_H

#define PIC_MAXSOURCES		256
#define PIC_MAXMAXSOURCES	282

#include <arm/cortex/gic_intr.h>
#include <arm/cortex/a9tmr_intr.h>

#define AMLOGIC_INTR_GMAC	40
#define AMLOGIC_INTR_SDIO	60
#define AMLOGIC_INTR_USB0	62
#define AMLOGIC_INTR_USB1	63
#define AMLOGIC_INTR_UART2AO	70
#define AMLOGIC_INTR_RTC	104
#define AMLOGIC_INTR_SDHC	110
#define AMLOGIC_INTR_UART0AO	122

#endif /* _ARM_AMLOGIC_INTR_H */
