/* $NetBSD: awin_reg.h,v 1.91 2017/05/27 21:02:55 bouyer Exp $ */

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Matt Thomas of 3am Software Foundry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_ALLWINNER_AWIN_REG_H
#define _ARM_ALLWINNER_AWIN_REG_H

#define AWIN_LOSC_FREQ			(32*1024)	/* 32KHz */
#define AWIN_REF_FREQ			(24*1000*1000)	/* 24MHz */

#define AWIN_CPUBIST_PBASE		0x3F501000
#define AWIN_CPUBIST_SIZE		0x00001000
#define AWIN_SRAM_PBASE			0x00000000
#define AWIN_SRAM_SIZE			0x00100000	/* round to 1MB */
#define AWIN_SRAMA1_PBASE		0x00000000
#define AWIN_SRAMA1_SIZE		0x00004000
#define AWIN_SRAMA2_PBASE		0x00004000
#define AWIN_SRAMA2_SIZE		0x00004000
#define AWIN_SRAMA3_PBASE		0x00008000
#define AWIN_SRAMA3_SIZE		0x00003400
#define AWIN_SRAMA4_PBASE		0x0000B400
#define AWIN_SRAMA4_SIZE		0x00000C00
#define AWIN_SRAMD_PBASE		0x00010000
#define AWIN_SRAMD_SIZE			0x00001000
#define AWIN_SRAMB_PBASE		0x00020000	/* Secure */
#define AWIN_SRAMB_SIZE			0x00010000	/* Secure */

#define AWIN_CORE_PBASE			0x01C00000
#if defined(ALLWINNER_A80)
#define AWIN_CORE_SIZE			0x06400000	/* XXX */
#define AWIN_A80_RCPUCFG_PBASE		0x01700000
#define AWIN_A80_RCPUCFG_SIZE		0x00100000
#define AWIN_A80_CORE2_PBASE		0x00800000
#define AWIN_A80_CORE2_SIZE		0x00100000
#define AWIN_A80_USB_PBASE		0x00a00000
#define AWIN_A80_USB_SIZE		0x00100000
#define AWIN_A80_RCPUS_PBASE		0x08000000
#define AWIN_A80_RCPUS_SIZE		0x00100000
#else
#define AWIN_CORE_SIZE			0x00400000
#endif
#define AWIN_SRAM_OFFSET		0x00000000
#define AWIN_DRAM_OFFSET		0x00001000
#define AWIN_DMA_OFFSET			0x00002000
#define AWIN_NFC_OFFSET			0x00003000
#define AWIN_TS_OFFSET			0x00004000
#define AWIN_SPI0_OFFSET		0x00005000
#define AWIN_SPI1_OFFSET		0x00006000
#define AWIN_MS_OFFSET			0x00007000
#define AWIN_TVD_OFFSET			0x00008000
#define AWIN_CSI0_OFFSET		0x00009000
#define AWIN_TVE0_OFFSET		0x0000A000
#define AWIN_EMAC_OFFSET		0x0000B000
#define AWIN_LCD0_OFFSET		0x0000C000
#define AWIN_LCD1_OFFSET		0x0000D000
#define AWIN_VE_OFFSET			0x0000E000
#define AWIN_SDMMC0_OFFSET		0x0000F000
#define AWIN_SDMMC1_OFFSET		0x00010000
#define AWIN_SDMMC2_OFFSET		0x00011000
#define AWIN_SDMMC3_OFFSET		0x00012000
#define AWIN_USB0_OFFSET		0x00013000
#define AWIN_USB1_OFFSET		0x00014000
#define AWIN_SS_OFFSET			0x00015000
#define AWIN_HDMI_OFFSET		0x00016000
#define AWIN_SPI2_OFFSET		0x00017000
#define AWIN_SATA_OFFSET		0x00018000	/* A20 */
#define AWIN_PATA_OFFSET		0x00019000	/* A10 */
#define AWIN_ACE_OFFSET			0x0001A000
#define AWIN_TVE1_OFFSET		0x0001B000
#define AWIN_USB2_OFFSET		0x0001C000
#define AWIN_CSI1_OFFSET		0x0001D000
#define AWIN_TZASC_OFFSET		0x0001E000	/* A10 */
#define AWIN_SPI3_OFFSET		0x0001F000
#define AWIN_CCM_OFFSET			0x00020000
#define AWIN_INTC_OFFSET		0x00020400
#define AWIN_PIO_OFFSET			0x00020800
#define AWIN_TMR_OFFSET			0x00020C00
#define AWIN_SPDIF_OFFSET		0x00021000	/* A20 */
#define AWIN_AC97_OFFSET		0x00021400
#define AWIN_IR0_OFFSET			0x00021800
#define AWIN_IR1_OFFSET			0x00021C00
#define AWIN_IIS0_OFFSET		0x00022000
#define AWIN_IIS1_OFFSET		0x00022400
#define AWIN_LRADC_OFFSET		0x00022800
#define AWIN_AC_OFFSET			0x00022C00
#define AWIN_KEYPAD_OFFSET		0x00023000
#define AWIN_TZPC_OFFSET		0x00023400	/* A10 */
#define AWIN_SID_OFFSET			0x00023800
#define AWIN_SJTAG_OFFSET		0x00023C00
#define AWIN__RSVD3_OFFSET		0x00024000
#define AWIN_IIS2_OFFSET		0x00024400
#define AWIN__RSVD4_OFFSET		0x00024800
#define AWIN__RSVD5_OFFSET		0x00024C00
#define AWIN_TP_OFFSET			0x00025000
#define AWIN_PMU_OFFSET			0x00025400
#define AWIN__RSVD6_OFFSET		0x00025800
#define AWIN_CPUCFG_OFFSET		0x00025C00
#define AWIN__RSVD7_OFFSET		0x00026000
#define AWIN__RSVD8_OFFSET		0x00026400
#define AWIN__RSVD9_OFFSET		0x00026800
#define AWIN__RSVD10_OFFSET		0x00026C00
#define AWIN__RSVD11_OFFSET		0x00027000
#define AWIN__RSVD12_OFFSET		0x00027400
#define AWIN__RSVD13_OFFSET		0x00027800
#define AWIN__RSVD14_OFFSET		0x00027C00
#define AWIN_UART_FREQ			AWIN_REF_FREQ	/* 24MHz */
#define AWIN_UART_SIZE			0x00000100
#define AWIN_UART0_OFFSET		0x00028000
#define AWIN_UART1_OFFSET		0x00028400
#define AWIN_UART2_OFFSET		0x00028800
#define AWIN_UART3_OFFSET		0x00028C00
#define AWIN_UART4_OFFSET		0x00029000
#define AWIN_UART5_OFFSET		0x00029400
#define AWIN_UART6_OFFSET		0x00029800
#define AWIN_UART7_OFFSET		0x00029C00
#define AWIN_PS20_OFFSET		0x0002A000
#define AWIN_PS21_OFFSET		0x0002A400
#define AWIN__RSVD15_OFFSET		0x0002A800
#define AWIN_TWI0_OFFSET		0x0002AC00	/* Marvell I2C */
#define AWIN_TWI1_OFFSET		0x0002B000	/* Marvell I2C */
#define AWIN_TWI2_OFFSET		0x0002B400	/* Marvell I2C */
#define AWIN_TWI3_OFFSET		0x0002B800	/* Marvell I2C */
#define AWIN_CAN_OFFSET			0x0002BC00
#define AWIN_TWI4_OFFSET		0x0002C000	/* A20 */
#define AWIN_SCR_OFFSET			0x0002C400
#define AWIN_GPS_OFFSET			0x00030000
#define AWIN_MALI400_OFFSET		0x00040000
#define AWIN_GMAC_OFFSET		0x00050000
#define AWIN_GMAC_SIZE			0x00010000	/* A20 */
#define AWIN_HSTMR_OFFSET		0x00060000	/* A20 */
#define AWIN_GIC_OFFSET			0x00080000	/* A20 */
#define AWIN_HDMI1_OFFSET		0x000E0000	/* A20 */
#define AWIN_SRAMC_OFFSET		0x00100000
#define AWIN_DE_FE0_OFFSET		0x00200000
#define AWIN_DE_FE1_OFFSET		0x00220000
#define AWIN_DE_BE1_OFFSET		0x00240000
#define AWIN_DE_BE0_OFFSET		0x00260000
#define AWIN_MP_OFFSET			0x00280000
#define AWIN_AVG_OFFSET			0x002A0000
#if defined(ALLWINNER_A80)
#define AWIN_SDRAM_PBASE		0x20000000
#else
#define AWIN_SDRAM_PBASE		0x40000000
#endif

/* A10/A20 SRAM Controller */
#define AWIN_SRAM_CTL0_REG		0x0000
#define AWIN_SRAM_CTL1_REG		0x0004
#define AWIN_SRAM_VER_REG		0x0024

#define AWIN_SRAM_CTL1_A3_A4		__BITS(5,4)
#define AWIN_SRAM_CTL1_A3_A4_EMAC	1
#define AWIN_SRAM_CTL1_SRAMD_MAP	__BIT(0)
#define AWIN_SRAM_CTL1_SRAMD_MAP_CPUDMA	0
#define AWIN_SRAM_CTL1_SRAMD_MAP_USB0	1

#define AWIN_SRAM_VER_KEY_FIELD		__BITS(31,16)
#define AWIN_SRAM_VER_R_EN		__BIT(15)
#define AWIN_SRAM_VER_BOOT_SEL_PAD_STA	__BIT(8)
#define AWIN_SRAM_VER_BITS		__BITS(7,0)

#define AWIN_SRAM_VER_KEY_A10		0x1623
#define AWIN_SRAM_VER_KEY_A13		0x1625
#define AWIN_SRAM_VER_KEY_A31		0x1633
#define AWIN_SRAM_VER_KEY_A80		0x1639
#define AWIN_SRAM_VER_KEY_A23		0x1650
#define AWIN_SRAM_VER_KEY_A20		0x1651

/* A10/A20 DRAM Controller */
#define AWIN_DRAM_CCR_REG		0x0000
#define AWIN_DRAM_DCR_REG		0x0004
#define AWIN_DRAM_IOCR_REG		0x0008
#define AWIN_DRAM_CSR_REG		0x000C
#define AWIN_DRAM_DRR_REG		0x0010
#define AWIN_DRAM_TPR0_REG		0x0014
#define AWIN_DRAM_TPR1_REG		0x0018
#define AWIN_DRAM_TPR2_REG		0x001C
#define AWIN_DRAM_GDLLCR_REG		0x0020
#define AWIN_DRAM_RSLR0_REG		0x004C
#define AWIN_DRAM_RSLR1_REG		0x0050
#define AWIN_DRAM_RDGR0_REG		0x005C
#define AWIN_DRAM_RDGR1_REG		0x0060
#define AWIN_DRAM_ODTCR_REG		0x0098
#define AWIN_DRAM_DTR0_REG		0x009C
#define AWIN_DRAM_DTR1_REG		0x00A0
#define AWIN_DRAM_DTAR_REG		0x00A4
#define AWIN_DRAM_ZQCR0_REG		0x00A8
#define AWIN_DRAM_ZQCR1_REG		0x00AC
#define AWIN_DRAM_ZQSR_REG		0x00B0
#define AWIN_DRAM_IDCR_REG		0x00B4
#define AWIN_DRAM_MR_REG		0x01F0
#define AWIN_DRAM_EMR1_REG		0x01F4
#define AWIN_DRAM_EMR2_REG		0x01F8
#define AWIN_DRAM_EMR3_REG		0x01FC
#define AWIN_DRAM_DLLCTR_REG		0x0200
#define AWIN_DRAM_DLLCR0_REG		0x0204
#define AWIN_DRAM_DLLCR1_REG		0x0208
#define AWIN_DRAM_DLLCR2_REG		0x020C
#define AWIN_DRAM_DLLCR3_REG		0x0210
#define AWIN_DRAM_DLLCR4_REG		0x0214
#define AWIN_DRAM_DQTR0_REG		0x0218
#define AWIN_DRAM_DQTR1_REG		0x021C
#define AWIN_DRAM_DQTR2_REG		0x0220
#define AWIN_DRAM_DQTR3_REG		0x0224
#define AWIN_DRAM_DQSTR_REG		0x0228
#define AWIN_DRAM_DQSBTR_REG		0x022C
#define AWIN_DRAM_MCR_REG		0x0230
#define AWIN_DRAM_PPWRSCTRL_REG		0x0240
#define AWIN_DRAM_APR_REG		0x0244
#define AWIN_DRAM_PLDTR_REG		0x023C
#define AWIN_DRAM_HPCR0_REG		0x0240
#define AWIN_DRAM_HPCRn_REG(n)		(0x0240+4*(n))
#define AWIN_DRAM_HPCR_USB1_REG		AWIN_DRAM_HPCRn_REG(4)
#define AWIN_DRAM_HPCR_USB2_REG		AWIN_DRAM_HPCRn_REG(5)
#define AWIN_DRAM_CSEL_REG		0x02E0

#define AWIN_DRAM_DCR_IO_WIDTH		__BITS(2,1)
#define AWIN_DRAM_DCR_IO_WIDTH_16BIT	2
#define AWIN_DRAM_DCR_IO_WIDTH_8BIT	1
#define AWIN_DRAM_DCR_CHIP_DENSITY	__BITS(5,3)
#define AWIN_DRAM_DCR_CHIP_DENSITY_256M	0
#define AWIN_DRAM_DCR_CHIP_DENSITY_512M	1
#define AWIN_DRAM_DCR_CHIP_DENSITY_1G	2
#define AWIN_DRAM_DCR_CHIP_DENSITY_2G	3
#define AWIN_DRAM_DCR_CHIP_DENSITY_4G	4
#define AWIN_DRAM_DCR_CHIP_DENSITY_8G	5
#define AWIN_DRAM_DCR_BUS_WIDTH		__BITS(8,6)
#define AWIN_DRAM_DCR_BUS_WIDTH_32BIT	3
#define AWIN_DRAM_DCR_BUS_WIDTH_16BIT	1
#define AWIN_DRAM_DCR_BUS_WIDTH_8BIT	0
#define AWIN_DRAM_DCR_RANK_SEL		__BITS(11,10)

#define AWIN_DRAM_HPCR_READ_CNT_EN	__BIT(31)
#define AWIN_DRAM_HPCR_RWRITE_CNT_EN	__BIT(30)
#define AWIN_DRAM_HPCR_COMMAND_NUM	__BIT(8)
#define AWIN_DRAM_HPCR_WAIT_STATE	__BIT(4)
#define AWIN_DRAM_HPCR_PRIORITY_LEVEL	__BIT(2)
#define AWIN_DRAM_HPCR_ACCESS_EN	__BIT(0)

/* DMA controller definitions */
#define AWIN_DMA_IRQ_EN_REG		0x0000
#define AWIN_DMA_IRQ_PEND_STA_REG	0x0004
#define AWIN_NDMA_AUTO_GATE_REG		0x0008
#define AWIN_NDMA_REG(n)		(0x100+0x20*(n))
#define AWIN_NDMA_CTL_REG		0x0000
#define AWIN_NDMA_SRC_ADDR_REG		0x0004
#define AWIN_NDMA_DEST_ADDR_REG		0x0008
#define AWIN_NDMA_BC_REG		0x000c

#define AWIN_DDMA_REG(n)		(0x300+0x20*(n))
#define AWIN_DDMA_CTL_REG		0x0000
#define AWIN_DDMA_SRC_START_ADDR_REG	0x0004
#define AWIN_DDMA_DEST_START_ADDR_REG	0x0008
#define AWIN_DDMA_BC_REG		0x000c
#define AWIN_DDMA_PARA_REG		0x0018

#define AWIN_DMA_IRQ_END_MASK		0xaaaaaaaa
#define AWIN_DMA_IRQ_HF_MASK		0x55555555
#define AWIN_DMA_IRQ_DDMA		__BITS(31,16)
#define AWIN_DMA_IRQ_DDMA_END(n)	__BIT(17+2*(n))
#define AWIN_DMA_IRQ_DDMA_HF(n)		__BIT(16+2*(n))
#define AWIN_DMA_IRQ_NDMA		__BITS(15,0)
#define AWIN_DMA_IRQ_NDMA_END(n)	__BIT(1+2*(n))
#define AWIN_DMA_IRQ_NDMA_HF(n)		__BIT(0+2*(n))

#define AWIN_NDMA_AUTO_GATING_DIS	__BIT(16)

#define AWIN_DMA_CTL_DST_DATA_WIDTH	__BITS(26,25)
#define AWIN_DMA_CTL_DATA_WIDTH_8	0
#define AWIN_DMA_CTL_DATA_WIDTH_16	1
#define AWIN_DMA_CTL_DATA_WIDTH_32	2
#define AWIN_DMA_CTL_DST_BURST_LEN	__BITS(24,23)
#define AWIN_DMA_CTL_BURST_LEN_1	0
#define AWIN_DMA_CTL_BURST_LEN_4	1
#define AWIN_DMA_CTL_BURST_LEN_8	2
#define AWIN_DMA_CTL_DST_DRQ_TYPE	__BITS(20,16)
#define AWIN_DMA_CTL_BC_REMAINING	__BIT(15)
#define AWIN_DMA_CTL_SRC_DATA_WIDTH	__BITS(10,9)
#define AWIN_DMA_CTL_SRC_BURST_LEN	__BITS(8,7)
#define AWIN_DMA_CTL_SRC_DRQ_TYPE	__BITS(4,0)

#define AWIN_NDMA_CTL_DMA_LOADING	__BIT(31)
#define AWIN_NDMA_CTL_DMA_CONTIN_MODE	__BIT(30)
#define AWIN_NDMA_CTL_WAIT_STATE_LOG2	__BITS(29,27)
#define AWIN_NDMA_CTL_DST_NON_SECURE	__BIT(22)
#define AWIN_NDMA_CTL_DST_ADDR_NOINCR	__BIT(21)
#define AWIN_NDMA_CTL_DRQ_IRO		0
#define AWIN_NDMA_CTL_DRQ_IR1		1
#define AWIN_NDMA_CTL_DRQ_SPDIF		2
#define AWIN_NDMA_CTL_DRQ_IISO		3
#define AWIN_NDMA_CTL_DRQ_IIS1		4
#define AWIN_NDMA_CTL_DRQ_AC97		5
#define AWIN_NDMA_CTL_DRQ_IIS2		6
#define AWIN_NDMA_CTL_DRQ_UARTO		8
#define AWIN_NDMA_CTL_DRQ_UART1		9
#define AWIN_NDMA_CTL_DRQ_UART2		10
#define AWIN_NDMA_CTL_DRQ_UART3		11
#define AWIN_NDMA_CTL_DRQ_UART4		12
#define AWIN_NDMA_CTL_DRQ_UART5		13
#define AWIN_NDMA_CTL_DRQ_UART6		14
#define AWIN_NDMA_CTL_DRQ_UART7		15
#define AWIN_NDMA_CTL_DRQ_DDC		16
#define AWIN_NDMA_CTL_DRQ_USB_EP1	17
#define AWIN_NDMA_CTL_DRQ_CODEC		19
#define AWIN_NDMA_CTL_DRQ_SRAM		21
#define AWIN_NDMA_CTL_DRQ_SDRAM		22
#define AWIN_NDMA_CTL_DRQ_TP_AD		23
#define AWIN_NDMA_CTL_DRQ_SPI0		24
#define AWIN_NDMA_CTL_DRQ_SPI1		25
#define AWIN_NDMA_CTL_DRQ_SPI2		26
#define AWIN_NDMA_CTL_DRQ_SPI3		27
#define AWIN_NDMA_CTL_DRQ_USB_EP2	28
#define AWIN_NDMA_CTL_DRQ_USB_EP3	29
#define AWIN_NDMA_CTL_DRQ_USB_EP4	30
#define AWIN_NDMA_CTL_DRQ_USB_EP5	31
#define AWIN_NDMA_CTL_SRC_NON_SECURE	__BIT(6)
#define AWIN_NDMA_CTL_SRC_ADDR_NOINCR	__BIT(5)

#define AWIN_NDMA_BC_COUNT		__BITS(17,0)

#define AWIN_DDMA_CTL_DMA_LOADING	__BIT(31)
#define AWIN_DDMA_CTL_BUSY		__BIT(30)
#define AWIN_DDMA_CTL_DMA_CONTIN_MODE	__BIT(29)
#define AWIN_DDMA_CTL_DST_NON_SECURE	__BIT(28)
#define AWIN_DDMA_CTL_DST_ADDR_MODE	__BITS(22,21)
#define AWIN_DDMA_CTL_DMA_ADDR_LINEAR	0
#define AWIN_DDMA_CTL_DMA_ADDR_IO	1
#define AWIN_DDMA_CTL_DMA_ADDR_HPAGE	2
#define AWIN_DDMA_CTL_DMA_ADDR_VPAGE	3
#define AWIN_DDMA_CTL_DST_DRQ_TYPE	__BITS(20,16)
#define AWIN_DDMA_CTL_DRQ_SRAM		0
#define AWIN_DDMA_CTL_DRQ_SDRAM		1
#define AWIN_DDMA_CTL_DRQ_NFC		3
#define AWIN_DDMA_CTL_DRQ_USB0		4
#define AWIN_DDMA_CTL_DRQ_EMAC_TX	6
#define AWIN_DDMA_CTL_DRQ_EMAC_RX	7
#define AWIN_DDMA_CTL_DRQ_SPI1_TX	8
#define AWIN_DDMA_CTL_DRQ_SPI1_RX	9
#define AWIN_DDMA_CTL_DRQ_SS_TX		10
#define AWIN_DDMA_CTL_DRQ_SS_RX		11
#define AWIN_DDMA_CTL_DRQ_TCON0		14
#define AWIN_DDMA_CTL_DRQ_TCON1		15
#define AWIN_DDMA_CTL_DRQ_MS_TX		23
#define AWIN_DDMA_CTL_DRQ_MS_RX		23
#define AWIN_DDMA_CTL_DRQ_HDMI_AUDIO	24
#define AWIN_DDMA_CTL_DRQ_SPI0_TX	26
#define AWIN_DDMA_CTL_DRQ_SPI0_RX	27
#define AWIN_DDMA_CTL_DRQ_SPI2_TX	28
#define AWIN_DDMA_CTL_DRQ_SPI2_RX	29
#define AWIN_DDMA_CTL_DRQ_SPI3_TX	30
#define AWIN_DDMA_CTL_DRQ_SPI3_RX	31
#define AWIN_DDMA_CTL_SRC_NON_SECURE	__BIT(12)
#define AWIN_DDMA_CTL_SRC_ADDR_MODE	__BITS(6,5)

#define AWIN_DDMA_BC_COUNT		__BITS(13,0)

#define AWIN_DDMA_PARA_DST_DATA_BLK_SIZ	__BITS(31,24)
#define AWIN_DDMA_PARA_DST_WAIT_CYC	__BITS(23,16)
#define AWIN_DDMA_PARA_SRC_DATA_BLK_SIZ	__BITS(15,8)
#define AWIN_DDMA_PARA_SRC_WAIT_CYC	__BITS(7,0)

#define AWIN_NFC_CTL_REG		0x0000
#define AWIN_NFC_ST_REG			0x0004
#define AWIN_NFC_INT_REG		0x0008
#define AWIN_NFC_TIMING_CTL_REG		0x000C
#define AWIN_NFC_TIMING_CFG_REG		0x0010
#define AWIN_NFC_ADDR_LOW_REG		0x0014
#define AWIN_NFC_ADDR_HIGH_REG		0x0018
#define AWIN_NFC_SECTOR_NUM_REG		0x001C
#define AWIN_NFC_CNT_REG		0x0020
#define AWIN_NFC_CMD_REG		0x0024
#define AWIN_NFC_READ_CMD_SET_REG	0x0028
#define AWIN_NFC_WRITE_CMD_SET_REG	0x002C
#define AWIN_NFC_IO_DATA_REG		0x0030
#define AWIN_NFC_ECC_CTL_REG		0x0034
#define AWIN_NFC_ECC_ST_REG		0x0038
#define AWIN_NFC_DEBUG_REG		0x003C
#define AWIN_NFC_ECC_CNT0_REG		0x0040
#define AWIN_NFC_ECC_CNT1_REG		0x0044
#define AWIN_NFC_ECC_CNT2_REG		0x0048
#define AWIN_NFC_ECC_CNT3_REG		0x004C
#define AWIN_NFC_USER_DB_REG		0x0050
#define AWIN_NFC_RAM0_REG		0x0400
#define AWIN_NFC_RAM1_REG		0x0800

#define AWIN_NFC_CTL_DEBUG		__BIT(31)
#define AWIN_NFC_CTL_CE_SEL		__BITS(26,24)
#define AWIN_NFC_CTL_RAM_METHOD		__BIT(14)
#define AWIN_NFC_CTL_SAM		__BIT(12)
#define AWIN_NFC_CTL_PAGE_SIZE		__BITS(11,8)
#define AWIN_NFC_CTL_PAGE_SIZE_1K	0
#define AWIN_NFC_CTL_PAGE_SIZE_2K	1
#define AWIN_NFC_CTL_PAGE_SIZE_4K	2
#define AWIN_NFC_CTL_PAGE_SIZE_8K	3
#define AWIN_NFC_CTL_PAGE_SIZE_16K	4
#define AWIN_NFC_CTL_CE_CTL1		__BIT(7)
#define AWIN_NFC_CTL_CE_CTL0		__BIT(6)
#define AWIN_NFC_CTL_RB_SEL1		__BIT(3)
#define AWIN_NFC_CTL_BUS_WIDTH16	__BIT(2)
#define AWIN_NFC_CTL_RESET		__BIT(1)
#define AWIN_NFC_CTL_EN			__BIT(0)

#define AWIN_NFC_ST_STATE3		__BIT(11)
#define AWIN_NFC_ST_STATE2		__BIT(10)
#define AWIN_NFC_ST_STATE1		__BIT(9)
#define AWIN_NFC_ST_STATE0		__BIT(8)
#define AWIN_NFC_ST_MATCH_INT		__BIT(5)
#define AWIN_NFC_ST_STAT		__BIT(4)
#define AWIN_MFC_ST_CMD_FIFO		__BIT(3)
#define AWIN_MFC_ST_DMA_INT		__BIT(2)
#define AWIN_MFC_ST_CMD_INT		__BIT(1)
#define AWIN_MFC_ST_RB_B2R		__BIT(0)

#define AWIN_NFC_INT_DMA_EN		__BIT(2)
#define AWIN_NFC_INT_CMD_EN		__BIT(1)
#define AWIN_NFC_INT_B2R_EN		__BIT(0)

#define AWIN_NFC_CMD_CMD_TYPE		__BITS(31,30)
#define AWIN_NFC_CMD_SEND_CMD3		__BIT(29)
#define AWIN_NFC_CMD_SEND_CMD2		__BIT(28)
#define AWIN_NFC_CMD_ROW_AUTO_INC	__BIT(27)
#define AWIN_NFC_CMD_DATA_SWAP		__BIT(26)
#define AWIN_NFC_CMD_SEQ		__BIT(25)
#define AWIN_NFC_CMD_SEND_CMD1		__BIT(24)
#define AWIN_NFC_CMD_WAIT_FLAG		__BIT(23)
#define AWIN_NFC_CMD_SEND_CMD0		__BIT(22)
#define AWIN_NFC_CMD_DATA_TRANS		__BIT(21)
#define AWIN_NFC_CMD_XS_DIR		__BIT(20)
#define AWIN_NFC_CMD_SEND_ADDR		__BIT(19)
#define AWIN_NFC_CMD_ADDR_NUM		__BITS(18,16)
#define AWIN_NFC_CMD_HIGH		__BITS(15,8)
#define AWIN_NFC_CMD_LOW		__BITS(7,0)

#define AWIN_NFC_READ_CMD_SET_RAMDOM_CMD1	__BITS(23,16)
#define AWIN_NFC_READ_CMD_SET_RANDOM_CMD0	__BITS(15,8)
#define AWIN_NFC_READ_CMD_SET_CMD	__BITS(7,0)

#define AWIN_NFC_WRITE_CMD_SET_RANDOM_CMD0	__BITS(15,8)
#define AWIN_NFC_WRITE_CMD_SET_CMD	__BITS(7,0)

#define AWIN_ECC_CTL_RANDOM_SEED	__BITS(31,16)
#define AWIN_ECC_CTL_MODE		__BITS(15,12)
#define AWIN_ECC_CTL_MODE_16BITS	0
#define AWIN_ECC_CTL_MODE_24BITS	1
#define AWIN_ECC_CTL_MODE_28BITS	2
#define AWIN_ECC_CTL_MODE_32BITS	3
#define AWIN_ECC_CTL_MODE_40BITS	4
#define AWIN_ECC_CTL_MODE_48BITS	5
#define AWIN_ECC_CTL_MODE_56BITS	6
#define AWIN_ECC_CTL_MODE_60BITS	7
#define AWIN_ECC_CTL_MODE_64BITS	8
#define AWIN_ECC_CTL_RANDOM_DIR		__BIT(10)
#define AWIN_ECC_CTL_RANDOM		__BIT(9)
#define AWIN_ECC_CTL_BLOCK_SIZE		__BIT(5)
#define AWIN_ECC_CTL_EXCEPTION		__BIT(4)
#define AWIN_ECC_CTL_PIPELINE  		__BIT(3)
#define AWIN_ECC_CTL_EN			__BIT(0)

#define AWIN_EMAC_CTL_REG		0x0000
#define AWIN_EMAC_TX_MODE_REG		0x0004
#define AWIN_EMAC_TX_FLOW_REG		0x0008
#define AWIN_EMAC_TX_CTL0_REG		0x000C
#define AWIN_EMAC_TX_CTL1_REG		0x0010
#define AWIN_EMAC_TX_CTL_REG(n)		(0x000C+4*(n))
#define AWIN_EMAC_TX_INS_REG		0x0014
#define AWIN_EMAC_TX_PL0_REG		0x0018
#define AWIN_EMAC_TX_PL1_REG		0x001C
#define AWIN_EMAC_TX_PL_REG(n)		(0x0018+4*(n))
#define AWIN_EMAC_TX_STA_REG		0x0020
#define AWIN_EMAC_TX_IO_DATA0_REG	0x0024
#define AWIN_EMAC_TX_IO_DATA1_REG	0x0028
#define AWIN_EMAC_TX_IO_DATA_REG(n)	(0x0024+4*(n))
#define AWIN_EMAC_TX_TSVL0_REG		0x002C
#define AWIN_EMAC_TX_TSVH0_REG		0x0030
#define AWIN_EMAC_TX_TSVL1_REG		0x0034
#define AWIN_EMAC_TX_TSVH1_REG		0x0038
#define AWIN_EMAC_RX_CTL_REG		0x003C
#define AWIN_EMAC_RX_HASH0_REG		0x0040
#define AWIN_EMAC_RX_HASH1_REG		0x0044
#define AWIN_EMAC_RX_STA_REG		0x0048
#define AWIN_EMAC_RX_IO_DATA_REG	0x004C
#define AWIN_EMAC_RX_FBC_REG		0x0050
#define AWIN_EMAC_INT_CTL_REG		0x0054
#define AWIN_EMAC_INT_STA_REG		0x0058
#define AWIN_EMAC_MAC_CTL0_REG		0x005C
#define AWIN_EMAC_MAC_CTL1_REG		0x0060
#define AWIN_EMAC_MAC_IPGT_REG		0x0064
#define AWIN_EMAC_MAC_IPGR_REG		0x0068
#define AWIN_EMAC_MAC_CLRT_REG		0x006C
#define AWIN_EMAC_MAC_MAXF_REG		0x0070
#define AWIN_EMAC_MAC_SUPP_REG		0x0074
#define AWIN_EMAC_MAC_TEST_REG		0x0078
#define AWIN_EMAC_MAC_MCFG_REG		0x007C		// MDIO
#define AWIN_EMAC_MAC_MCMD_REG		0x0080		// MDIO
#define AWIN_EMAC_MAC_MADR_REG		0x0084		// MDIO
#define AWIN_EMAC_MAC_MWTD_REG		0x0088		// MDIO
#define AWIN_EMAC_MAC_MRDD_REG		0x008C		// MDIO
#define AWIN_EMAC_MAC_MIND_REG		0x0090		// MDIO
#define AWIN_EMAC_MAC_SSRR_REG		0x0094
#define AWIN_EMAC_MAC_A0_REG		0x0098
#define AWIN_EMAC_MAC_A1_REG		0x009C
#define AWIN_EMAC_MAC_A2_REG		0x00A0
#define AWIN_EMAC_SAFX0_L_REG		0x00A4
#define AWIN_EMAC_SAFX0_H_REG		0x00A8
#define AWIN_EMAC_SAFX1_L_REG		0x00AC
#define AWIN_EMAC_SAFX1_H_REG		0x00B0
#define AWIN_EMAC_SAFX2_L_REG		0x00B4
#define AWIN_EMAC_SAFX2_H_REG		0x00B8
#define AWIN_EMAC_SAFX3_L_REG		0x00BC
#define AWIN_EMAC_SAFX3_H_REG		0x00C0

#define AWIN_EMAC_RXHDR_STS		__BITS(31,16)
#define AWIN_EMAC_RXHDR_LEN		__BITS(15,0)

#define AWIN_EMAC_TX_MODE_ABF_ENA	__BIT(0)
#define AWIN_EMAC_TX_MODE_DMA		__BIT(1)

#define AWIN_EMAC_TX_CTL_START		__BIT(0)

#define AWIN_EMAC_RX_CTL_SA_IF		__BIT(25)	// SA filter invert
#define AWIN_EMAC_RX_CTL_SA		__BIT(24)	// SA filter
#define AWIN_EMAC_RX_CTL_BC0		__BIT(22)	// broadcast ena
#define AWIN_EMAC_RX_CTL_MHF		__BIT(21)	// multicast hash ena
#define AWIN_EMAC_RX_CTL_MC0		__BIT(20)	// multicast accept
#define AWIN_EMAC_RX_CTL_DAF		__BIT(17)	// DA filter
#define AWIN_EMAC_RX_CTL_UCAD		__BIT(16)	// unicast accept
#define AWIN_EMAC_RX_CTL_POR		__BIT(8)	// pass too long
#define AWIN_EMAC_RX_CTL_PLE		__BIT(7)	// pass length err
#define AWIN_EMAC_RX_CTL_PCRCE		__BIT(6)	// pass crc errors
#define AWIN_EMAC_RX_CTL_PCF		__BIT(5)	// pass control frames
#define AWIN_EMAC_RX_CTL_PROMISC	__BIT(4)	// pass all frames
#define AWIN_EMAC_RX_CTL_FIFO_RESET	__BIT(3)
#define AWIN_EMAC_RX_CTL_DMA		__BIT(2)
#define AWIN_EMAC_RX_CTL_DRQ_MODE	__BIT(1)
#define AWIN_EMAC_RX_CTL_START		__BIT(0)

#define AWIN_EMAC_RX_MAGIC		0x0143414d	// M A C \001

#define AWIN_EMAC_MAC_CTL0_SOFT_RESET	__BIT(15)
#define AWIN_EMAC_MAC_CTL0_TFC		__BIT(3)
#define AWIN_EMAC_MAC_CTL0_RFC		__BIT(2)

#define AWIN_EMAC_MAC_CTL1_ED		__BIT(15)
#define AWIN_EMAC_MAC_CTL1_NB		__BIT(13)
#define AWIN_EMAC_MAC_CTL1_BNB		__BIT(12)
#define AWIN_EMAC_MAC_CTL1_LPE		__BIT(9)
#define AWIN_EMAC_MAC_CTL1_PRE		__BIT(8)
#define AWIN_EMAC_MAC_CTL1_ADP		__BIT(7)	// auto detect short
#define AWIN_EMAC_MAC_CTL1_VC		__BIT(6)	// pad short and append
#define AWIN_EMAC_MAC_CTL1_PC		__BIT(5)	// enable pad short
#define AWIN_EMAC_MAC_CTL1_CRC		__BIT(4)	// append crc
#define AWIN_EMAC_MAC_CTL1_DCRC		__BIT(3)	// delayed CRC
#define AWIN_EMAC_MAC_CTL1_HF		__BIT(2)	// huge frame
#define AWIN_EMAC_MAC_CTL1_FLC		__BIT(1)	// frame length check
#define AWIN_EMAC_MAC_CTL1_FD		__BIT(0)	// full duplex

#define AWIN_EMAC_MAC_IPGR_IPG1		__BITS(7,0)
#define AWIN_EMAC_MAC_IPGR_IPG2		__BITS(15,8)

#define AWIN_EMAC_MAC_CLRT_RM		__BITS(7,0)
#define AWIN_EMAC_MAC_CLRT_CW		__BITS(15,8)

#define AWIN_EMAC_MAC_SUPP_100M		__BIT(8)

#define AWIN_EMAC_RX_STA_CRCERR		__BIT(4)
#define AWIN_EMAC_RX_STA_LENERR		__BIT(5)
#define AWIN_EMAC_RX_STA_ALNERR		__BIT(6)

#define AWIN_MAC_MCFG_CLK		__BITS(5,2)

#define AWIN_EMAC_INT_RX		__BIT(8)
#define AWIN_EMAC_INT_TX1		__BIT(1)
#define AWIN_EMAC_INT_TX0		__BIT(0)

#define AHCI_P_AWIN_DMA(p)		(0x170 + AHCI_P_OFFSET(p))
#define AWIN_AHCI_BISTAFR_REG		0x00A0
#define AWIN_AHCI_BISTCR_REG		0x00A4
#define AWIN_AHCI_BISTFCTR_REG		0x00A8
#define AWIN_AHCI_BISTSR_REG		0x00AC
#define AWIN_AHCI_BISTDECR_REG		0x00B0
#define AWIN_AHCI_DIAGNR_REG		0x00B4
#define AWIN_AHCI_DIAGNR1_REG		0x00B8
#define AWIN_AHCI_OOBR_REG		0x00BC
#define AWIN_AHCI_PHYCS0R_REG		0x00C0
#define AWIN_AHCI_PHYCS1R_REG		0x00C4
#define AWIN_AHCI_PHYCS2R_REG		0x00C8
#define AWIN_AHCI_TIMER1MS_REG		0x00E0
#define AWIN_AHCI_GPARAM1R_REG		0x00E8
#define AWIN_AHCI_GPARAM2R_REG		0x00EC
#define AWIN_AHCI_PPARAMR_REG		0x00F0
#define AWIN_AHCI_TESTR_REG		0x00F4
#define AWIN_AHCI_VERSIONR_REG		0x00F8
#define AWIN_AHCI_IDR_REG		0x00FC
#define AWIN_AHCI_RWCR_REG		0x00FC

#define AWIN_AHCI_P0DMACR_REG		0x0170
#define AWIN_AHCI_P0PHYCR_REG		0x0178
#define AWIN_AHCI_P0PHYSR_REG		0x017C

#define AWIN_MMC_GCTRL			0x0000
#define AWIN_MMC_CLKCR			0x0004
#define AWIN_MMC_TIMEOUT		0x0008
#define AWIN_MMC_WIDTH			0x000C
#define AWIN_MMC_BLKSZ			0x0010
#define AWIN_MMC_BYTECNT		0x0014
#define AWIN_MMC_CMD			0x0018
#define AWIN_MMC_ARG			0x001C
#define AWIN_MMC_RESP0			0x0020
#define AWIN_MMC_RESP1			0x0024
#define AWIN_MMC_RESP2			0x0028
#define AWIN_MMC_RESP3			0x002C
#define AWIN_MMC_IMASK			0x0030
#define AWIN_MMC_MINT			0x0034
#define AWIN_MMC_RINT			0x0038
#define AWIN_MMC_STATUS			0x003C
#define AWIN_MMC_FTRGLEVEL		0x0040
#define AWIN_MMC_FUNCSEL		0x0044
#define AWIN_MMC_CBCR			0x0048
#define AWIN_MMC_BBCR			0x004C
#define AWIN_MMC_DBGC			0x0050
#define AWIN_MMC_A12A			0x0058		/* A80 */
#define AWIN_MMC_HWRST			0x0078		/* A80 */
#define AWIN_MMC_DMAC			0x0080
#define AWIN_MMC_DLBA			0x0084
#define AWIN_MMC_IDST			0x0088
#define AWIN_MMC_IDIE			0x008C
#define AWIN_MMC_CHDA			0x0090
#define AWIN_MMC_CBDA			0x0094
#define AWIN_MMC_FIFO			0x0100

#define AWIN_MMC_GCTRL_ACCESS_BY_AHB	__BIT(31)
#define AWIN_MMC_GCTRL_WAIT_MEM_ACCESS_DONE __BIT(30)
#define AWIN_MMC_GCTRL_DDR_MODE		__BIT(10)
#define AWIN_MMC_GCTRL_DEBOUNCEEN	__BIT(8)
#define AWIN_MMC_GCTRL_DMAEN		__BIT(5)
#define AWIN_MMC_GCTRL_INTEN		__BIT(4)
#define AWIN_MMC_GCTRL_DMARESET		__BIT(2)
#define AWIN_MMC_GCTRL_FIFORESET	__BIT(1)
#define AWIN_MMC_GCTRL_SOFTRESET	__BIT(0)
#define AWIN_MMC_GCTRL_RESET \
	(AWIN_MMC_GCTRL_SOFTRESET | AWIN_MMC_GCTRL_FIFORESET | \
	 AWIN_MMC_GCTRL_DMARESET)

#define AWIN_MMC_CLKCR_LOWPOWERON	__BIT(17)
#define AWIN_MMC_CLKCR_CARDCLKON	__BIT(16)
#define AWIN_MMC_CLKCR_DIV		__BITS(15,0)

#define AWIN_MMC_WIDTH_1		0
#define AWIN_MMC_WIDTH_4		1
#define AWIN_MMC_WIDTH_8		2

#define AWIN_MMC_CMD_START		__BIT(31)
#define AWIN_MMC_CMD_USE_HOLD_REG	__BIT(29)
#define AWIN_MMC_CMD_VOL_SWITCH		__BIT(28)
#define AWIN_MMC_CMD_BOOT_ABORT		__BIT(27)
#define AWIN_MMC_CMD_BOOT_ACK_EXP	__BIT(26)
#define AWIN_MMC_CMD_ALT_BOOT_OPT	__BIT(25)
#define AWIN_MMC_CMD_ENBOOT		__BIT(24)
#define AWIN_MMC_CMD_CCS_EXP		__BIT(23)
#define AWIN_MMC_CMD_RD_CEATA_DEV	__BIT(22)
#define AWIN_MMC_CMD_UPCLK_ONLY		__BIT(21)
#define AWIN_MMC_CMD_SEND_INIT_SEQ	__BIT(15)
#define AWIN_MMC_CMD_STOP_ABORT_CMD	__BIT(14)
#define AWIN_MMC_CMD_WAIT_PRE_OVER	__BIT(13)
#define AWIN_MMC_CMD_SEND_AUTO_STOP	__BIT(12)
#define AWIN_MMC_CMD_SEQMOD		__BIT(11)
#define AWIN_MMC_CMD_WRITE		__BIT(10)
#define AWIN_MMC_CMD_DATA_EXP		__BIT(9)
#define AWIN_MMC_CMD_CHECK_RSP_CRC	__BIT(8)
#define AWIN_MMC_CMD_LONG_RSP		__BIT(7)
#define AWIN_MMC_CMD_RSP_EXP		__BIT(6)

#define AWIN_MMC_INT_CARD_REMOVE	__BIT(31)
#define AWIN_MMC_INT_CARD_INSERT	__BIT(30)
#define AWIN_MMC_INT_SDIO_INT		__BIT(16)
#define AWIN_MMC_INT_END_BIT_ERR	__BIT(15)
#define AWIN_MMC_INT_AUTO_CMD_DONE	__BIT(14)
#define AWIN_MMC_INT_START_BIT_ERR	__BIT(13)
#define AWIN_MMC_INT_HW_LOCKED		__BIT(12)
#define AWIN_MMC_INT_FIFO_RUN_ERR	__BIT(11)
#define AWIN_MMC_INT_VOL_CHG_DONE	__BIT(10)
#define AWIN_MMC_INT_DATA_STARVE	__BIT(10)
#define AWIN_MMC_INT_BOOT_START		__BIT(9)
#define AWIN_MMC_INT_DATA_TIMEOUT	__BIT(9)
#define AWIN_MMC_INT_ACK_RCV		__BIT(8)
#define AWIN_MMC_INT_RESP_TIMEOUT	__BIT(8)
#define AWIN_MMC_INT_DATA_CRC_ERR	__BIT(7)
#define AWIN_MMC_INT_RESP_CRC_ERR	__BIT(6)
#define AWIN_MMC_INT_RX_DATA_REQ	__BIT(5)
#define AWIN_MMC_INT_TX_DATA_REQ	__BIT(4)
#define AWIN_MMC_INT_DATA_OVER		__BIT(3)
#define AWIN_MMC_INT_CMD_DONE		__BIT(2)
#define AWIN_MMC_INT_RESP_ERR		__BIT(1)
#define AWIN_MMC_INT_ERROR \
	(AWIN_MMC_INT_RESP_ERR | AWIN_MMC_INT_RESP_CRC_ERR | \
	 AWIN_MMC_INT_DATA_CRC_ERR | AWIN_MMC_INT_RESP_TIMEOUT | \
	 AWIN_MMC_INT_FIFO_RUN_ERR | AWIN_MMC_INT_HW_LOCKED | \
	 AWIN_MMC_INT_START_BIT_ERR  | AWIN_MMC_INT_END_BIT_ERR)

#define AWIN_MMC_STATUS_DMAREQ		__BIT(31)
#define AWIN_MMC_STATUS_DATA_FSM_BUSY	__BIT(10)
#define AWIN_MMC_STATUS_CARD_DATA_BUSY	__BIT(9)
#define AWIN_MMC_STATUS_CARD_PRESENT	__BIT(8)
#define AWIN_MMC_STATUS_FIFO_FULL	__BIT(3)
#define AWIN_MMC_STATUS_FIFO_EMPTY	__BIT(2)
#define AWIN_MMC_STATUS_TXWL_FLAG	__BIT(1)
#define AWIN_MMC_STATUS_RXWL_FLAG	__BIT(0)

#define AWIN_MMC_FUNCSEL_CEATA_DEV_INTEN __BIT(10)
#define AWIN_MMC_FUNCSEL_SEND_AUTO_STOP_CCSD __BIT(9)
#define AWIN_MMC_FUNCSEL_SEND_CCSD	__BIT(8)
#define AWIN_MMC_FUNCSEL_ABT_RD_DATA	__BIT(2)
#define AWIN_MMC_FUNCSEL_SDIO_RD_WAIT	__BIT(1)
#define AWIN_MMC_FUNCSEL_SEND_IRQ_RSP	__BIT(0)

#define AWIN_MMC_DMAC_REFETCH_DES	__BIT(31)
#define AWIN_MMC_DMAC_IDMA_ON		__BIT(7)
#define AWIN_MMC_DMAC_FIX_BURST		__BIT(1)
#define AWIN_MMC_DMAC_SOFTRESET		__BIT(0)

#define AWIN_MMC_IDST_HOST_ABT		__BIT(10)
#define AWIN_MMC_IDST_ABNORMAL_INT_SUM	__BIT(9)
#define AWIN_MMC_IDST_NORMAL_INT_SUM	__BIT(8)
#define AWIN_MMC_IDST_CARD_ERR_SUM	__BIT(5)
#define AWIN_MMC_IDST_DES_INVALID	__BIT(4)
#define AWIN_MMC_IDST_FATAL_BUS_ERR	__BIT(2)
#define AWIN_MMC_IDST_RECEIVE_INT	__BIT(1)
#define AWIN_MMC_IDST_TRANSMIT_INT	__BIT(0)
#define AWIN_MMC_IDST_ERROR \
	(AWIN_MMC_IDST_ABNORMAL_INT_SUM | AWIN_MMC_IDST_CARD_ERR_SUM | \
	 AWIN_MMC_IDST_DES_INVALID | AWIN_MMC_IDST_FATAL_BUS_ERR)
#define AWIN_MMC_IDST_COMPLETE \
	(AWIN_MMC_IDST_RECEIVE_INT | AWIN_MMC_IDST_TRANSMIT_INT)

#if !defined(_LOCORE)
struct awin_mmc_idma_descriptor {
	uint32_t	dma_config;
#define AWIN_MMC_IDMA_CONFIG_DIC	__BIT(1)
#define AWIN_MMC_IDMA_CONFIG_LD		__BIT(2)
#define AWIN_MMC_IDMA_CONFIG_FD		__BIT(3)
#define AWIN_MMC_IDMA_CONFIG_CH		__BIT(4)
#define AWIN_MMC_IDMA_CONFIG_ER		__BIT(5)
#define AWIN_MMC_IDMA_CONFIG_CES	__BIT(30)
#define AWIN_MMC_IDMA_CONFIG_OWN	__BIT(31)
	uint32_t	dma_buf_size;
	uint32_t	dma_buf_addr;
	uint32_t	dma_next;
} __packed;
#endif

#define AWIN_IR_CTL_REG			0x0000
#define AWIN_IR_TXCTL_REG		0x0004
#define AWIN_IR_TXADR_REG		0x0008
#define AWIN_IR_TXCNT_REG		0x000C
#define AWIN_IR_RXCTL_REG		0x0010
#define AWIN_IR_RXADR_REG		0x0014
#define AWIN_IR_RXCNT_REG		0x0018
#define AWIN_IR_TXFIFO_REG		0x001C
#define AWIN_IR_RXFIFO_REG		0x0020
#define AWIN_IR_TXINT_REG		0x0024
#define AWIN_IR_TXSTA_REG		0x0028
#define AWIN_IR_RXINT_REG		0x002C
#define AWIN_IR_RXSTA_REG		0x0030
#define AWIN_IR_CIR_REG			0x0034

#define AWIN_IR_CTL_CGPO		__BIT(8)
#define AWIN_IR_CTL_MD			__BITS(5,4)
#define AWIN_IR_CTL_MD_0_576_MIR	0
#define AWIN_IR_CTL_MD_1_152_MIR	1
#define AWIN_IR_CTL_MD_4_0_FIR		2
#define AWIN_IR_CTL_MD_CIR		3
#define AWIN_IR_CTL_TXEN		__BIT(2)
#define AWIN_IR_CTL_RXEN		__BIT(1)
#define AWIN_IR_CTL_GEN			__BIT(0)

#define AWIN_IR_TXCTL_PCF		__BIT(5)
#define AWIN_IR_TXCTL_SIP		__BIT(3)
#define AWIN_IR_TXCTL_TPPI		__BIT(2)

#define AWIN_IR_TXADR_HAG		__BIT(8)
#define AWIN_IR_TXADR_TPA		__BITS(7,0)

#define AWIN_IR_TXCNT_TPL		__BITS(10,0)

#define AWIN_IR_RXCTL_RPA		__BIT(3)
#define AWIN_IR_RXCTL_RPPI		__BIT(2)

#define AWIN_IR_RXADR_RAM		__BIT(8)
#define AWIN_IR_RXADR_RA		__BITS(7,0)

#define AWIN_IR_RXCNT_RPL		__BITS(11,0)

#define AWIN_IR_TXFIFO_DATA		__BITS(7,0)

#define AWIN_IR_RXFIFO_DATA		__BITS(7,0)

#define AWIN_IR_TXINT_TEL		__BITS(11,8)
#define AWIN_IR_TXINT_DRQ_EN		__BIT(5)
#define AWIN_IR_TXINT_TEI_EN		__BIT(4)
#define AWIN_IR_TXINT_TCI_EN		__BIT(3)
#define AWIN_IR_TXINT_SIPEI_EN		__BIT(2)
#define AWIN_IR_TXINT_TPEI_EN		__BIT(1)
#define AWIN_IR_TUI_EN			__BIT(0)

#define AWIN_IR_TXSTA_TA		__BITS(12,8)
#define AWIN_IR_TXSTA_TE		__BIT(4)
#define AWIN_IR_TXSTA_TC		__BIT(3)
#define AWIN_IR_TXSTA_SIPE		__BIT(2)
#define AWIN_IR_TXSTA_TPE		__BIT(1)
#define AWIN_IR_TXSTA_TU		__BIT(0)

#define AWIN_IR_RXINT_RAL		__BITS(13,8)
#define AWIN_IR_RXINT_DRQ_EN		__BIT(5)
#define AWIN_IR_RXINT_RAI_EN		__BIT(4)
#define AWIN_IR_RXINT_CRCI_EN		__BIT(3)
#define AWIN_IR_RXINT_RISI_EN		__BIT(2)
#define AWIN_IR_RXINT_RPEI_EN		__BIT(1)
#define AWIN_IR_RXINT_ROI_EN		__BIT(0)

#define AWIN_IR_RXSTA_RAC		__BITS(12,8)
#define AWIN_IR_RXSTA_STAT		__BIT(7)	/* A31 */
#define AWIN_IR_RXSTA_RA		__BIT(4)
#define AWIN_IR_RXSTA_CRC		__BIT(3)
#define AWIN_IR_RXSTA_RIS		__BIT(2)
#define AWIN_IR_RXSTA_RPE		__BIT(1)
#define AWIN_IR_RXSTA_ROI		__BIT(0)

#define AWIN_IR_CIR_SCS2		__BIT(24)
#define AWIN_IR_CIR_ATHC		__BIT(23)
#define AWIN_IR_CIR_ATHR		__BITS(22,16)
#define AWIN_IR_CIR_ITHR		__BITS(15,8)
#define AWIN_IR_CIR_NTHR		__BITS(7,2)
#define AWIN_IR_CIR_SCS			__BITS(1,0)

#define AWIN_CPUCFG_CPU0_RST_CTRL_REG	0x0040
#define AWIN_CPUCFG_CPU0_CTRL_REG	0x0044
#define AWIN_CPUCFG_CPU0_STATUS_REG	0x0048
#define AWIN_CPUCFG_CPU1_RST_CTRL_REG	0x0080
#define AWIN_CPUCFG_CPU1_CTRL_REG	0x0084
#define AWIN_CPUCFG_CPU1_STATUS_REG	0x0088
#define AWIN_CPUCFG_GENCTRL_REG		0x0184
#define AWIN_CPUCFG_PRIVATE_REG		0x01A4
#define AWIN_CPUCFG_CPU1_PWRCLAMP_REG	0x01B0
#define AWIN_CPUCFG_CPU1_PWROFF_REG	0x01B4
#define AWIN_CPUCFG_DBGCTRL0_REG	0x01E0
#define AWIN_CPUCFG_DBGCTRL1_REG	0x01E4
#define AWIN_CPUCFG_CNT64_CTRL_REG	0x0280
#define AWIN_CPUCFG_CNT64_LOW_REG	0x0284
#define AWIN_CPUCFG_CNT64_HIGH_REG	0x0288

#define AWIN_CPUCFG_CPU_RST_CTRL_CORE_RESET __BIT(1)
#define AWIN_CPUCFG_CPU_RST_CTRL_RESET	__BIT(0)

#define AWIN_CPUCFG_CPU_CTRL_CP15_WRITE_DISABLE	__BIT(0)

#define AWIN_CPUCFG_CPU_STATUS_STANDBYWFI	__BIT(2)
#define AWIN_CPUCFG_CPU_STATUS_STANDBYWFE	__BIT(1)
#define AWIN_CPUCFG_CPU_STATUS_SMP_AMP		__BIT(0)

#define AWIN_CPUCFG_GENCTRL_CPU1_L1INV		__BIT(1)
#define AWIN_CPUCFG_GENCTRL_CPU0_L1INV		__BIT(0)

#define AWIN_CPUCFG_DBGCTL0_CPU1_DBGPWRDUP	__BIT(1)
#define AWIN_CPUCFG_DBGCTL0_CPU0_DBGPWRDUP	__BIT(1)

#define AWIN_CPUCFG_CNT64_CLK_SRC_SEL		__BIT(2)
#define AWIN_CPUCFG_CNT64_RL_EN			__BIT(1)
#define AWIN_CPUCFG_CNT64_CLR_EN		__BIT(0)

#define AWIN_PLL1_CFG_REG		0x0000
#define AWIN_PLL1_TUN_REG		0x0004
#define AWIN_PLL2_CFG_REG		0x0008
#define AWIN_PLL2_TUN_REG		0x000C
#define AWIN_PLL3_CFG_REG		0x0010
#define AWIN_PLL4_CFG_REG		0x0018
#define AWIN_PLL5_CFG_REG		0x0020
#define AWIN_PLL5_TUN_REG		0x0024
#define AWIN_PLL6_CFG_REG		0x0028
#define AWIN_PLL6_TUN_REG		0x002C
#define AWIN_PLL7_CFG_REG		0x0030
#define AWIN_PLL1_TUN2_REG		0x0038
#define AWIN_PLL6_TUN2_REG		0x003C
#define AWIN_PLL8_CFG_REG		0x0040
#define AWIN_OSC24M_CFG_REG		0x0050
#define AWIN_CPU_AHB_APB0_CFG_REG	0x0054
#define AWIN_APB1_CLK_DIV_REG		0x0058
#define AWIN_AXI_GATING_REG		0x005C
#define AWIN_AHB_GATING0_REG		0x0060
#define AWIN_AHB_GATING1_REG		0x0064
#define AWIN_APB0_GATING_REG		0x0068
#define AWIN_APB1_GATING_REG		0x006C
#define AWIN_NAND_SCLK_CFG_REG		0x0080
#define AWIN_MS_SCLK_CFG_REG		0x0084
#define AWIN_SD0_CLK_REG		0x0088
#define AWIN_SD1_CLK_REG		0x008C
#define AWIN_SD2_CLK_REG		0x0090
#define AWIN_SD3_CLK_REG		0x0094
#define AWIN_TS_CLK_REG			0x0098
#define AWIN_SS_CLK_REG			0x009C
#define AWIN_SPI0_CLK_REG		0x00A0
#define AWIN_SPI1_CLK_REG		0x00A4
#define AWIN_SPI2_CLK_REG		0x00A8
#define AWIN_IR0_CLK_REG		0x00B0
#define AWIN_IR1_CLK_REG		0x00B4
#define AWIN_IIS_CLK_REG		0x00B8
#define AWIN_AC97_CLK_REG		0x00BC
#define AWIN_SPDIF_CLK_REG		0x00C0
#define AWIN_KEYPAD_CLK_REG		0x00C4
#define AWIN_SATA_CLK_REG		0x00C8
#define AWIN_USB_CLK_REG		0x00CC
#define AWIN_SPI3_CLK_REG		0x00D4
#define AWIN_DRAM_CLK_REG		0x0100
#define AWIN_BE0_SCLK_CFG_REG		0x0104
#define AWIN_BE1_SCLK_CFG_REG		0x0108
#define AWIN_FE0_CLK_REG		0x010C
#define AWIN_FE1_CLK_REG		0x0110
#define AWIN_MP_CLK_REG			0x0114
#define AWIN_LCD0_CH0_CLK_REG		0x0118
#define AWIN_LCD1_CH0_CLK_REG		0x011C
#define AWIN_CSI_ISP_CLK_REG		0x0120
#define AWIN_TVD_CLK_REG		0x0128
#define AWIN_LCD0_CH1_CLK_REG		0x012C
#define AWIN_LCD1_CH1_CLK_REG		0x0130
#define AWIN_CSI0_CLK_REG		0x0134
#define AWIN_CSI1_CLK_REG		0x0138
#define AWIN_VE_CLK_REG			0x013C
#define AWIN_AUDIO_CODEC_CLK_REG	0x0140
#define AWIN_AVS_CLK_REG		0x0144
#define AWIN_ACE_CLK_REG		0x0148
#define AWIN_LVDS_CLK_REG		0x014C
#define AWIN_HDMI_CLK_REG		0x0150
#define AWIN_MALI400_CLK_REG		0x0154
#define AWIN_MBUF_SCLK_CFG_REG		0x015C
#define AWIN_GMAC_CLK_REG		0x0164
#define AWIN_HDM1_RST_REG		0x0170
#define AWIN_HDM1_CTLR_REG		0x0174
#define AWIN_HDM1_SLOW_CLK_REG		0x0178
#define AWIN_HDM1_REPPEAT_CLK_REG	0x017C
#define AWIN_CLK_OUTA_REG		0x01F0
#define AWIN_CLK_OUTB_REG		0x01F4

#define AWIN_OSC24M_CFG_ENABLE		__BIT(0)

#define AWIN_PLL_CFG_ENABLE		__BIT(31)
#define AWIN_PLL_CFG_BYPASS		__BIT(30)
#define AWIN_PLL_CFG_PLL5		__BIT(25)
#define AWIN_PLL_CFG_PLL6		__BIT(24)
#define AWIN_PLL_CFG_OUT_EXP_DIVP	__BITS(17,16)
#define AWIN_PLL_CFG_FACTOR_N		__BITS(12,8)
#define AWIN_PLL_CFG_FACTOR_K		__BITS(5,4)
#define AWIN_PLL_CFG_FACTOR_M		__BITS(1,0)

#define AWIN_PLL1_SIG_DELT_PAT_IN	__BIT(3)
#define AWIN_PLL1_SIG_DELT_PAT_EN	__BIT(2)

#define AWIN_PLL2_CFG_POSTDIV		__BITS(29,26)
#define AWIN_PLL2_CFG_FACTOR_N		__BITS(14,8)
#define AWIN_PLL2_CFG_PREVDIV		__BITS(4,0)

#define AWIN_PLL3_MODE_SEL		__BIT(15)
#define AWIN_PLL3_FRAC_SET		__BIT(14)
#define AWIN_PLL3_FACTOR_M		__BITS(6,0)

#define AWIN_PLL5_CFG_DDR_CLK_EN	__BIT(29)
#define AWIN_PLL5_OUT_EXT_DIV_P		__BITS(17,16)
#define AWIN_PLL5_CFG_LDO_EN		__BIT(7)
#define AWIN_PLL5_CFG_FACTOR_M1		__BITS(3,2)

#define AWIN_PLL6_VCO_BIAS		__BITS(29,25)
#define AWIN_PLL6_PLL_BIAS		__BITS(24,20)
#define AWIN_PLL6_CFG_SATA_CLK_EN	__BIT(14)

#define AWIN_PLL7_MODE_SEL		__BIT(15)
#define AWIN_PLL7_FRAC_SET		__BIT(14)
#define AWIN_PLL7_FACTOR_M		__BITS(6,0)

#define AWIN_DVFS_START			__BIT(31)
#define AWIN_CPU_CLK_SRC_SEL		__BITS(17,16)
#define AWIN_CPU_CLK_SRC_SEL_LOSC	0
#define AWIN_CPU_CLK_SRC_SEL_OSC24M	1
#define AWIN_CPU_CLK_SRC_SEL_PLL1	2
#define AWIN_CPU_CLK_SRC_SEL_200MHZ	3
#define AWIN_APB0_CLK_RATIO		__BITS(9,8)
#define AWIN_AHB_CLK_SRC_SEL		__BITS(7,6)
#define AWIN_AHB_CLK_SRC_SEL_AXI	0
#define AWIN_AHB_CLK_SRC_SEL_PLL6_2	1
#define AWIN_AHB_CLK_SRC_SEL_PLL6	2
#define AWIN_AHB_CLK_RATIO		__BITS(5,4)
#define AWIN_ATB_APB_CLK_DIV		__BITS(3,2)
#define AWIN_AXI_CLK_DIV_RATIO		__BITS(1,0)

#define AWIN_AHB_GATING0_STIMER		__BIT(28)
#define AWIN_AHB_GATING0_SATA		__BIT(25)
#define AWIN_AHB_GATING0_PATA		__BIT(24)
#define AWIN_AHB_GATING0_SPI3		__BIT(23)
#define AWIN_AHB_GATING0_SPI2		__BIT(22)
#define AWIN_AHB_GATING0_SPI1		__BIT(21)
#define AWIN_AHB_GATING0_SPI0		__BIT(20)
#define AWIN_AHB_GATING0_TS		__BIT(18)
#define AWIN_AHB_GATING0_EMAC		__BIT(17)
#define AWIN_AHB_GATING0_ACE		__BIT(16)
#define AWIN_AHB_GATING0_SDRAM		__BIT(14)
#define AWIN_AHB_GATING0_NAND		__BIT(13)
#define AWIN_AHB_GATING0_NC12		__BIT(12)
#define AWIN_AHB_GATING0_SDMMC3		__BIT(11)
#define AWIN_AHB_GATING0_SDMMC2		__BIT(10)
#define AWIN_AHB_GATING0_SDMMC1		__BIT(9)
#define AWIN_AHB_GATING0_SDMMC0		__BIT(8)
#define AWIN_AHB_GATING0_BIST		__BIT(7)
#define AWIN_AHB_GATING0_DMA		__BIT(6)
#define AWIN_AHB_GATING0_SS		__BIT(5)
#define AWIN_AHB_GATING0_USB_OHCI1	__BIT(4)
#define AWIN_AHB_GATING0_USB_EHCI1	__BIT(3)
#define AWIN_AHB_GATING0_USB_OHCI0	__BIT(2)
#define AWIN_AHB_GATING0_USB_EHCI0	__BIT(1)
#define AWIN_AHB_GATING0_USB0		__BIT(0)

#define AWIN_AHB_GATING1_MALI400	__BIT(20)
#define AWIN_AHB_GATING1_MP		__BIT(18)
#define AWIN_AHB_GATING1_GMAC		__BIT(17)
#define AWIN_AHB_GATING1_DE_FE1		__BIT(15)
#define AWIN_AHB_GATING1_DE_FE0		__BIT(14)
#define AWIN_AHB_GATING1_DE_BE1		__BIT(13)
#define AWIN_AHB_GATING1_DE_BE0		__BIT(12)
#define AWIN_AHB_GATING1_HDMI		__BIT(11)
#define AWIN_AHB_GATING1_CSI1		__BIT(9)
#define AWIN_AHB_GATING1_CSI0		__BIT(8)
#define AWIN_AHB_GATING1_LCD1		__BIT(5)
#define AWIN_AHB_GATING1_LCD0		__BIT(4)
#define AWIN_AHB_GATING1_TVE1		__BIT(3)
#define AWIN_AHB_GATING1_TVE0		__BIT(2)
#define AWIN_AHB_GATING1_TVD		__BIT(1)
#define AWIN_AHB_GATING1_VE		__BIT(0)

#define AWIN_APB_GATING0_KEYPAD		__BIT(10)
#define AWIN_APB_GATING0_IIS2		__BIT(8)
#define AWIN_APB_GATING0_IR1		__BIT(7)
#define AWIN_APB_GATING0_IR0		__BIT(6)
#define AWIN_APB_GATING0_PIO		__BIT(5)
#define AWIN_APB_GATING0_IIS1		__BIT(4)
#define AWIN_APB_GATING0_IIS0		__BIT(3)
#define AWIN_APB_GATING0_AC97		__BIT(2)
#define AWIN_APB_GATING0_SPDIF		__BIT(1)
#define AWIN_APB_GATING0_CODEC		__BIT(0)

#define AWIN_APB_GATING1_UART7		__BIT(23)
#define AWIN_APB_GATING1_UART6		__BIT(22)
#define AWIN_APB_GATING1_UART5		__BIT(21)
#define AWIN_APB_GATING1_UART4		__BIT(20)
#define AWIN_APB_GATING1_UART3		__BIT(19)
#define AWIN_APB_GATING1_UART2		__BIT(18)
#define AWIN_APB_GATING1_UART1		__BIT(17)
#define AWIN_APB_GATING1_UART0		__BIT(16)
#define AWIN_APB_GATING1_TWI4		__BIT(15)
#define AWIN_APB_GATING1_PS21		__BIT(7)
#define AWIN_APB_GATING1_PS20		__BIT(6)
#define AWIN_APB_GATING1_SCR		__BIT(5)
#define AWIN_APB_GATING1_CAN		__BIT(4)
#define AWIN_APB_GATING1_TWI3		__BIT(3)
#define AWIN_APB_GATING1_TWI2		__BIT(2)
#define AWIN_APB_GATING1_TWI1		__BIT(1)
#define AWIN_APB_GATING1_TWI0		__BIT(0)

#define AWIN_APB0_GATING_ADDA		__BIT(0)

#define AWIN_CLK_ENABLE			__BIT(31)
#define AWIN_CLK_SRC_SEL		__BITS(25,24)
#define AWIN_CLK_SRC_SEL_OSC24M		0
#define AWIN_CLK_SRC_SEL_PLL6		1
#define AWIN_CLK_SRC_SEL_PLL5		2
#define AWIN_CLK_SRC_SEL_LOSC		3
#define AWIN_CLK_SRC_SEL_KEYPAD_LOSC	2
#define AWIN_CLK_SRC_SEL_SATA_PLL6	0	/* 100 MHz */
#define AWIN_CLK_SRC_SEL_SATA_EXT	1
#define AWIN_CLK_SRC_SEL_DE_PLL3	0
#define AWIN_CLK_SRC_SEL_DE_PLL7	1
#define AWIN_CLK_SRC_SEL_DE_PLL5	2
#define AWIN_CLK_SRC_SEL_CIR_LOSC	0
#define AWIN_CLK_SRC_SEL_CIR_HOSC	1
#define AWIN_CLK_SRC_SEL_MP_PLL3	0
#define AWIN_CLK_SRC_SEL_MP_PLL7	1
#define AWIN_CLK_SRC_SEL_MP_PLL9	2
#define AWIN_CLK_SRC_SEL_MP_PLL10	3
#define AWIN_CLK_DIV_RATIO_N		__BITS(17,16)
#define AWIN_CLK_DIV_RATIO_M		__BITS(3,0)

#define AWIN_LVDS_CLK_ENABLE		__BIT(0)

#define AWIN_ISS_CLK_SRC_SEL		__BITS(17,16)

#define AWIN_USB_CLK_USBPHY_ENABLE	__BIT(8)
#define AWIN_USB_CLK_OHCI1_ENABLE	__BIT(7)
#define AWIN_USB_CLK_OHCI0_ENABLE	__BIT(6)
#define AWIN_USB_CLK_PHY2_ENABLE	__BIT(2)
#define AWIN_USB_CLK_PHY1_ENABLE	__BIT(1)
#define AWIN_USB_CLK_PHY0_ENABLE	__BIT(0)

#define AWIN_DRAM_CLK_ACE_DCLK_ENABLE	__BIT(29)
#define AWIN_DRAM_CLK_DE_MP_DCLK_ENABLE	__BIT(28)
#define AWIN_DRAM_CLK_BE1_DCLK_ENABLE	__BIT(27)
#define AWIN_DRAM_CLK_BE0_DCLK_ENABLE	__BIT(26)
#define AWIN_DRAM_CLK_FE1_DCLK_ENABLE	__BIT(25)
#define AWIN_DRAM_CLK_FE0_DCLK_ENABLE	__BIT(24)
#define AWIN_DRAM_CLK_DCLK_OUT_ENABLE	__BIT(16)
#define AWIN_DRAM_CLK_TVE1_DCLK_ENABLE	__BIT(6)
#define AWIN_DRAM_CLK_TVE0_DCLK_ENABLE	__BIT(5)
#define AWIN_DRAM_CLK_TVD_DCLK_ENABLE	__BIT(4)
#define AWIN_DRAM_CLK_TS_DCLK_ENABLE	__BIT(3)
#define AWIN_DRAM_CLK_CSI1_DCLK_ENABLE	__BIT(2)
#define AWIN_DRAM_CLK_CSI0_DCLK_ENABLE	__BIT(1)
#define AWIN_DRAM_CLK_VE_DCLK_ENABLE	__BIT(0)

#define AWIN_GMAC_CLK_TXC_DIV		__BITS(9,8)
#define AWIN_GMAC_CLK_TXC_DIV_1000	0
#define AWIN_GMAC_CLK_TXC_DIV_100	1
#define AWIN_GMAC_CLK_TXC_DIV_10	2
#define AWIN_GMAC_CLK_RXDC		__BITS(7,5)
#define AWIN_GMAC_CLK_RXIE		__BIT(4)
#define AWIN_GMAC_CLK_TXIE		__BIT(3)
#define AWIN_GMAC_CLK_PIT		__BIT(2)
#define AWIN_GMAC_CLK_TCS		__BITS(1,0)
#define AWIN_GMAC_CLK_TCS_MII		0
#define AWIN_GMAC_CLK_TCS_EXT_125	1
#define AWIN_GMAC_CLK_TCS_INT_RGMII	2

#define AWIN_BEx_CLK_SCLK_GATING	__BIT(31)
#define AWIN_BEx_CLK_RST		__BIT(30)
#define AWIN_BEx_CLK_SRC_SEL		__BITS(25,24)
#define AWIN_BEx_CLK_SRC_SEL_PLL3	0
#define AWIN_BEx_CLK_SRC_SEL_PLL7	1
#define AWIN_BEx_CLK_SRC_SEL_PLL5	2
#define AWIN_BEx_CLK_DIV_RATIO_M	__BITS(3,0)

#define AWIN_LCDx_CH0_CLK_LCDx_RST	__BIT(30)
#define AWIN_LCDx_CHx_CLK_SRC_SEL	__BITS(25,24)
#define AWIN_LCDx_CHx_CLK_SRC_SEL_PLL3	0
#define AWIN_LCDx_CHx_CLK_SRC_SEL_PLL7	1
#define AWIN_LCDx_CHx_CLK_SRC_SEL_PLL3_2X 2
#define AWIN_LCDx_CHx_CLK_SRC_SEL_PLL7_2X 3 /* for lcd0ch0 this is pll6x2 */
#define AWIN_LCDx_CH1_SCLK1_GATING	__BIT(15)
#define AWIN_LCDx_CH1_SCLK1_SRC_SEL	__BIT(11)
#define AWIN_LCDx_CH1_CLK_DIV_RATIO_M	__BITS(3,0)

#define AWIN_HDMI_CLK_SRC_SEL		__BITS(25,24)
#define AWIN_HDMI_CLK_SRC_SEL_PLL3	0
#define AWIN_HDMI_CLK_SRC_SEL_PLL7	1
#define AWIN_HDMI_CLK_SRC_SEL_PLL3_2X	2
#define AWIN_HDMI_CLK_SRC_SEL_PLL7_2X	3
#define AWIN_HDMI_CLK_DIV_RATIO_M	__BITS(3,0)

#define AWIN_SD_CLK_SRC_SEL		__BITS(25,24)
#define AWIN_SD_CLK_SRC_SEL_OSC24M	0
#define AWIN_SD_CLK_SRC_SEL_PLL6	1
#define AWIN_SD_CLK_PHASE_CTR		__BITS(22,20)
#define AWIN_SD_CLK_DIV_RATIO_N		__BITS(17,16)
#define AWIN_SD_CLK_OUTPUT_PHASE_CTR	__BITS(10,8)
#define AWIN_SD_CLK_DIV_RATIO_M		__BITS(3,0)

#define AWIN_CLK_OUT_ENABLE		__BIT(31)
#define AWIN_CLK_OUT_SRC_SEL		__BITS(25,24)
#define AWIN_CLK_OUT_SRC_SEL_32K	0
#define AWIN_CLK_OUT_SRC_SEL_LOSC	1
#define AWIN_CLK_OUT_SRC_SEL_OSC24M	2
#define AWIN_CLK_OUT_SRC_FACTOR_N	__BITS(21,20)
#define AWIN_CLK_OUT_SRC_FACTOR_M	__BITS(12,8)

/* USB device offsets */
#define AWIN_USB0_PHY_CSR_REG		0x0400
#define AWIN_USB0_PHY_CTL_REG		0x0404
#define AWIN_EHCI_OFFSET		0x0000
#define AWIN_EHCI_SIZE			0x0400
#define AWIN_OHCI_OFFSET		0x0400
#define AWIN_OHCI_SIZE			0x0400
#define AWIN_USB_PMU_IRQ_REG		0x0800

#define AWIN_USB0_PHY_CSR_VBUS_VALID_DATA	__BIT(30)
#define AWIN_USB0_PHY_CSR_VBUS_VALID_VBUS	__BIT(29)
#define AWIN_USB0_PHY_CSR_EXT_ID_STATUS		__BIT(28)
#define AWIN_USB0_PHY_CSR_EXT_DM_STATUS		__BIT(27)
#define AWIN_USB0_PHY_CSR_EXT_DP_STATUS		__BIT(26)
#define AWIN_USB0_PHY_CSR_MERGED_VBUS_STATUS	__BIT(25)
#define AWIN_USB0_PHY_CSR_MERGED_ID_STATUS	__BIT(24)
#define AWIN_USB0_PHY_CSR_ID_PULLUP_EN		__BIT(17)
#define AWIN_USB0_PHY_CSR_DPDM_PULLUP_EN	__BIT(16)
#define AWIN_USB0_PHY_CSR_FORCE_ID		__BITS(15,14)
#define AWIN_USB0_PHY_CSR_FORCE_ID_LOW		2
#define AWIN_USB0_PHY_CSR_FORCE_ID_HIGH		3
#define AWIN_USB0_PHY_CSR_FORCE_VBUS_VALID	__BITS(13,12)
#define AWIN_USB0_PHY_CSR_FORCE_VBUS_VALID_LOW	2
#define AWIN_USB0_PHY_CSR_FORCE_VBUS_VALID_HIGH	3
#define AWIN_USB0_PHY_CSR_VBUS_VALID_SRC	__BITS(11,10)
#define AWIN_USB0_PHY_CSR_HOSC_EN		__BIT(7)
#define AWIN_USB0_PHY_CSR_VBUS_CHANGE_DET	__BIT(6)
#define AWIN_USB0_PHY_CSR_ID_CHANGE_DET		__BIT(5)
#define AWIN_USB0_PHY_CSR_DPDM_CHANGE_DET	__BIT(4)
#define AWIN_USB0_PHY_CSR_IRQ_EN		__BIT(3)
#define AWIN_USB0_PHY_CSR_VBUS_CHANGE_DET_EN	__BIT(2)
#define AWIN_USB0_PHY_CSR_ID_CHANGE_DET_EN	__BIT(1)
#define AWIN_USB0_PHY_CSR_DPDM_CHANGE_DET_EN	__BIT(0)

#define AWIN_USB0_PHY_CTL_ADDR		__BITS(15,8)
#define AWIN_USB0_PHY_CTL_DAT		__BIT(7)
#define AWIN_USB0_PHY_CTL_CLK2		__BIT(2)
#define AWIN_USB0_PHY_CTL_CLK1		__BIT(1)
#define AWIN_USB0_PHY_CTL_CLK0		__BIT(0)

#define AWIN_USB_PMU_IRQ_EHCI_HS_FORCE	__BIT(20)	/* A80 */
#define AWIN_USB_PMU_IRQ_HSIC_CONNECT_DET __BIT(17)	/* A80 */
#define AWIN_USB_PMU_IRQ_AHB_INCR8	__BIT(10)
#define AWIN_USB_PMU_IRQ_AHB_INCR4	__BIT(9)
#define AWIN_USB_PMU_IRQ_AHB_INCRX	__BIT(8)
#define AWIN_USB_PMU_IRQ_HSIC		__BIT(1)	/* A80 */
#define AWIN_USB_PMU_IRQ_ULPI_BYPASS	__BIT(0)

/* PATA Definitions */
#define AWIN_PATA_CTL_REG		0x0100	/* XXX Bogus */

/* A10 Interrupt Register Definitions */
#define AWIN_INTC_VECTOR_REG		0x0000
#define AWIN_INTC_BASE_ADDR_REG		0x0004
#define AWIN_NMI_INT_CTRL_REG		0x000C
#define AWIN_INTC_IRQ_PEND0_REG		0x0010
#define AWIN_INTC_IRQ_PEND1_REG		0x0014
#define AWIN_INTC_IRQ_PEND2_REG		0x0018
#define AWIN_INTC_FIQ_PEND0_REG		0x0020
#define AWIN_INTC_FIQ_PEND1_REG		0x0024
#define AWIN_INTC_FIQ_PEND2_REG		0x0028
#define AWIN_INTC_IRQ_TYPE_SEL0_REG	0x0030
#define AWIN_INTC_IRQ_TYPE_SEL1_REG	0x0034
#define AWIN_INTC_IRQ_TYPE_SEL2_REG	0x0038
#define AWIN_INTC_EN0_REG		0x0040
#define AWIN_INTC_EN1_REG		0x0044
#define AWIN_INTC_EN2_REG		0x0048
#define AWIN_INTC_MASK0_REG		0x0050
#define AWIN_INTC_MASK1_REG		0x0054
#define AWIN_INTC_MASK2_REG		0x0058
#define AWIN_INTC_RESP0_REG		0x0060
#define AWIN_INTC_RESP1_REG		0x0064
#define AWIN_INTC_RESP2_REG		0x0068
#define AWIN_INTC_FF0_REG		0x0070
#define AWIN_INTC_FF1_REG		0x0074
#define AWIN_INTC_FF2_REG		0x0078
#define AWIN_INTC_PRIO0_REG		0x0080
#define AWIN_INTC_PRIO1_REG		0x0084
#define AWIN_INTC_PRIO2_REG		0x0088
#define AWIN_INTC_PRIO3_REG		0x008C
#define AWIN_INTC_PRIO4_REG		0x0090

/* [G]PIO Definitions */
#define AWIN_PIO_CFG0_REG		0x0000
#define AWIN_PIO_CFG1_REG		0x0004
#define AWIN_PIO_CFG2_REG		0x0008
#define AWIN_PIO_CFG3_REG		0x000c
#define AWIN_PIO_DAT_REG		0x0010
#define AWIN_PIO_DRV0_REG		0x0014
#define AWIN_PIO_DRV1_REG		0x0018
#define AWIN_PIO_PUL0_REG		0x001c
#define AWIN_PIO_PUL1_REG		0x0020
#define AWIN_PIO_GRP_SIZE		0x0024
#define AWIN_PIO_INT_CFG0_REG		0x0200
#define AWIN_PIO_INT_CFG1_REG		0x0204
#define AWIN_PIO_INT_CFG2_REG		0x0208
#define AWIN_PIO_INT_CFG3_REG		0x020c
#define AWIN_PIO_INT_CTL_REG		0x0210
#define AWIN_PIO_INT_STA_REG		0x0214
#define AWIN_PIO_INT_DEB_REG		0x0218
#define AWIN_PIO_SDR_PAD_DEV_REG	0x0220
#define AWIN_PIO_SDR_PAD_PUL_REG	0x0224
#define AWIN_PIO_INT_SIZE		0x0028

#define AWIN_PIO_CFG_PINMASK(pin)	(7 << (4*((pin) & 7)))
#define AWIN_PIO_DRV_MASK(pin)		((x) << (2*((pin) & 15)))
#define AWIN_PIO_PULn(v, pin)		((v) << (2*((pin) & 15)))

#define AWIN_PIO_FUNC_INPUT		0x0
#define AWIN_PIO_FUNC_OUTPUT		0x1

#define AWIN_PIO_PULL_NONE		0x0
#define AWIN_PIO_PULL_UP		0x1
#define AWIN_PIO_PULL_DOWN		0x2

#define AWIN_PIO_EINT_POSITIVE_EDGE	0x0
#define AWIN_PIO_EINT_NEGATIVE_EDGE	0x1
#define AWIN_PIO_EINT_HIGH_LEVEL	0x2
#define AWIN_PIO_EINT_LOW_LEVEL		0x3
#define AWIN_PIO_EINT_DOUBLE_EDGE	0x4

#define AWIN_PIO_PA_PINS		18
#define AWIN_PIO_PA_EMAC_PINS		0x0003ffff /* PA pins 17-0 */
#define AWIN_PIO_PA_EMAC_FUNC		2
#define AWIN_PIO_PA_CAN_PINS		0x00030000 /* PA pins 17-16 */
#define AWIN_PIO_PA_CAN_FUNC		3
#define AWIN_PIO_PA_UART7_PINS		0x0000c000 /* PA pins 15-14 */
#define AWIN_PIO_PA_UART7_FUNC		3
#define AWIN_PIO_PA_UART6_PINS		0x00003000 /* PA pins 13-12 */
#define AWIN_PIO_PA_UART6_FUNC		3
#define AWIN_PIO_PA_SPI3_PINS		0x000003e0 /* PA pins 9-5 */
#define AWIN_PIO_PA_SPI3_FUNC		3
#define AWIN_PIO_PA_SPI1_PINS		0x0000001f /* PA pins 0-4 */
#define AWIN_PIO_PA_SPI1_FUNC		3
#define AWIN_PIO_PA_UART1_PINS		0x0003fc00 /* PA pins 17-10 */
#define AWIN_PIO_PA_UART1_FUNC		4
#define AWIN_PIO_PA_UART2_PINS		0x0000000f /* PA pins 3-0 */
#define AWIN_PIO_PA_UART2_FUNC		4
#define AWIN_PIO_PA_GMAC_PINS		0x0003ffff /* PA pins 17-0 */
#define AWIN_PIO_PA_GMAC_FUNC		5
#define AWIN_PIO_PA_I2S1_PINS		0x0003c200 /* PA pins 17-14,9 */
#define AWIN_PIO_PA_I2S1_FUNC		5

#define AWIN_PIO_PB_PINS		24
#define AWIN_PIO_PB_UART0_PINS		0x00c00000 /* PB pins 23-22 */
#define AWIN_PIO_PB_UART0_FUNC		2
#define AWIN_PIO_PB_TWI2_PINS		0x00300000 /* PB pins 21-20 */
#define AWIN_PIO_PB_TWI2_FUNC		2
#define AWIN_PIO_PB_TWI1_PINS		0x000c0000 /* PB pins 19-18 */
#define AWIN_PIO_PB_TWI1_FUNC		2
#define AWIN_PIO_PB_SPI2_PINS		0x0003e000 /* PB pins 17-13 */
#define AWIN_PIO_PB_SPI2_FUNC		2
#define AWIN_PIO_PB_I2S_PINS		0x00001fe0 /* PB pins 12-5 */
#define AWIN_PIO_PB_I2S_FUNC		2
#define AWIN_PIO_PB_IR0_PINS		0x00000018 /* PB pins 4-3 */
#define AWIN_PIO_PB_IR0_FUNC		2
#define AWIN_PIO_PB_PWN_PINS		0x00000004 /* PB pins 2-2 */
#define AWIN_PIO_PB_PWN_FUNC		2
#define AWIN_PIO_PB_TWI0_PINS		0x00000003 /* PB pins 1-0 */
#define AWIN_PIO_PB_TWI0_FUNC		2
#define AWIN_PIO_PB_IR1_PINS		0x00c00000 /* PB pins 23-22 */
#define AWIN_PIO_PB_IR1_FUNC		3
#define AWIN_PIO_PB_JTAG_PINS		0x0003c000 /* PB pins 17-14 */
#define AWIN_PIO_PB_JTAG_FUNC		3
#define AWIN_PIO_PB_AC97_PINS		0x000011e0 /* PB pins 12,8-5 */
#define AWIN_PIO_PB_AC97_FUNC		3
#define AWIN_PIO_PB_SPDIF_PINS		0x00003008 /* PB pins 13-12,3-3 */
#define AWIN_PIO_PB_SPDIF_FUNC		4
#define AWIN_PIO_PB_STANBYWFI_PINS	0x00000008 /* PB pins 3-3 */
#define AWIN_PIO_PB_STANBYWFI_FUNC	6

#define AWIN_PIO_PC_PINS		25
#define AWIN_PIO_PC_NAND_PINS		0x0107ffff /* PC pins 24,18-0 */
#define AWIN_PIO_PC_NAND_FUNC		2
#define AWIN_PIO_PC_NAND_PINS2		0x00800000 /* PC pin 23 */
#define AWIN_PIO_PC_NAND_FUNC2		3
#define AWIN_PIO_PC_SPI0_PINS		0x00800007 /* PC pins 23-23,3-0 */
#define AWIN_PIO_PC_SPI0_FUNC		3
#define AWIN_PIO_PC_SPI2_PINS		0x00f80000 /* PC pins 23-19 */
#define AWIN_PIO_PC_SPI2_FUNC		3
#define AWIN_PIO_PC_SDC2_PINS		0x00000fc0 /* PC pins 11-6 */
#define AWIN_PIO_PC_SDC2_FUNC		3
#define AWIN_PIO_PC_EINT_PINS		0x00780000 /* PC pins 22-19 */
#define AWIN_PIO_PC_EINT_FUNC		3

#define AWIN_PIO_PD_PINS		28
#define AWIN_PIO_PD_LCD0_PINS		0x0fffffff /* PD pins 27-0 */
#define AWIN_PIO_PD_LCD0_FUNC		2
#define AWIN_PIO_PD_SMC_PINS		0x0fe00000 /* PD pins 27-21 */
#define AWIN_PIO_PD_SMC_FUNC		3
#define AWIN_PIO_PD_CSI1_PINS		0x00100000 /* PD pins 20-20 */
#define AWIN_PIO_PD_CSI1_FUNC		3
#define AWIN_PIO_PD_LVDS1_PINS		0x000ffc00 /* PD pins 19-10 */
#define AWIN_PIO_PD_LVDS1_FUNC		3
#define AWIN_PIO_PD_LVDS0_PINS		0x000003ff /* PD pins 9-0 */
#define AWIN_PIO_PD_LVDS0_FUNC		3

#define AWIN_PIO_PE_PINS		12
#define AWIN_PIO_PE_TS_PINS		0x00000fff /* PE pins 11-0 */
#define AWIN_PIO_PE_TS_FUNC		2
#define AWIN_PIO_PE_CSI0_PINS		0x00000fff /* PE pins 11-0 */
#define AWIN_PIO_PE_CSI0_FUNC		3
#define AWIN_PIO_PE_SMC_PINS		0x00000020 /* PE pins 5-5 */
#define AWIN_PIO_PE_SMC_FUNC		4

#define AWIN_PIO_PF_PINS		6
#define AWIN_PIO_PF_SDC0_PINS		0x0000003f /* PF pins 5-0 */
#define AWIN_PIO_PF_SDC0_FUNC		2
#define AWIN_PIO_PF_UART0_PINS		0x00000014 /* PF pins 4,2 */
#define AWIN_PIO_PF_UART0_FUNC		3
#define AWIN_PIO_PF_JTAG_PINS		0x0000002b /* PF pins 5,3,1-0 */
#define AWIN_PIO_PF_JTAG_FUNC		4

#define AWIN_PIO_PG_PINS		12
#define AWIN_PIO_PG_TS1_PINS		0x00000fff /* PG pins 11-0 */
#define AWIN_PIO_PG_TS1_FUNC		2
#define AWIN_PIO_PG_CSI1_PINS		0x00000fff /* PG pins 11-0 */
#define AWIN_PIO_PG_CSI1_FUNC		3
#define AWIN_PIO_PG_UART4_PINS		0x00000c00 /* PG pins 11-10 */
#define AWIN_PIO_PG_UART4_FUNC		4
#define AWIN_PIO_PG_UART3_PINS		0x000000c0 /* PG pins 6-7 */
#define AWIN_PIO_PG_UART3_FUNC		4
#define AWIN_PIO_PG_SDC1_PINS		0x0000003f /* PG pins 5-0 */
#define AWIN_PIO_PG_SDC1_FUNC		4
#define AWIN_PIO_PG_CSI0_PINS		0x00000ff0 /* PG pins 11-4 */
#define AWIN_PIO_PG_CSI0_FUNC		5

#define AWIN_PIO_PH_PINS		28
#define AWIN_PIO_PH_LCD1_PINS		0x0fffffff /* PH pins 27-0 */
#define AWIN_PIO_PH_LCD1_FUNC		2
#define AWIN_PIO_PH_PATA_PINS		0x0fffffff /* PH pins 27-0 */
#define AWIN_PIO_PH_PATA_FUNC		3
#define AWIN_PIO_PH_EMAC_PINS		0x0fffcf00 /* PH pins 27-14,11-8 */
#define AWIN_PIO_PH_EMAC_FUNC		3
#define AWIN_PIO_PH_KP_PINS		0x0fcfcf00 /* PH pins 27-22,19-14,11-8 */
#define AWIN_PIO_PH_KP_FUNC		4
#define AWIN_PIO_PH_CAN_PINS		0x00300000 /* PH pins 21-20 */
#define AWIN_PIO_PH_CAN_FUNC		4
#define AWIN_PIO_PH_PS21_PINS		0x00003000 /* PH pins 13-12 */
#define AWIN_PIO_PH_PS21_FUNC		4
#define AWIN_PIO_PH_UART5_PINS		0x000000c0 /* PH pins 7-6 */
#define AWIN_PIO_PH_UART5_FUNC		4
#define AWIN_PIO_PH_UART4_PINS		0x00000030 /* PH pins 5-4 */
#define AWIN_PIO_PH_UART4_FUNC		4
#define AWIN_PIO_PH_UART3_PINS		0x0000000f /* PH pins 3-0 */
#define AWIN_PIO_PH_UART3_FUNC		4
#define AWIN_PIO_PH_SDC1_PINS		0x0fc00000 /* PH pins 27-23 */
#define AWIN_PIO_PH_SDC1_FUNC		5
#define AWIN_PIO_PH_SMC_PINS		0x000fe000 /* PH pins 19-13 */
#define AWIN_PIO_PH_SMC_FUNC		5
#define AWIN_PIO_PH_MS_PINS		0x00000fc0 /* PH pins 11-6 */
#define AWIN_PIO_PH_MS_FUNC		5
#define AWIN_PIO_PH_EINT_PINS		0x003fffff /* PH pins 21-0 */
#define AWIN_PIO_PH_EINT_FUNC		6
#define AWIN_PIO_PH_CSI1_PINS		0x0fffffff /* PH pins 27-0 */
#define AWIN_PIO_PH_CSI1_FUNC		7

#define AWIN_PIO_PI_PINS		22
#define AWIN_PIO_PI_PS20_PINS		0x00300000 /* PI pins 21-20 */
#define AWIN_PIO_PI_PS20_FUNC		2
#define AWIN_PIO_PI_SPI1_PINS		0x000f0000 /* PI pins 7-4 */
#define AWIN_PIO_PI_SPI1_FUNC		2
#define AWIN_PIO_PI_SDC3_PINS		0x000003f0 /* PI pins 9-4 */
#define AWIN_PIO_PI_SDC3_FUNC		2
#define AWIN_PIO_PI_PWM1_PINS		0x00000008 /* PI pins 3-3 */
#define AWIN_PIO_PI_PWM1_FUNC		2
#define AWIN_PIO_PI_UART7_PINS		0x00300000 /* PI pins 21-20 */
#define AWIN_PIO_PI_UART7_FUNC		3
#define AWIN_PIO_PI_UART2_PINS		0x000f0000 /* PI pins 19-16 */
#define AWIN_PIO_PI_UART2_FUNC		3
#define AWIN_PIO_PI_PS21_PINS		0x0000c000 /* PI pins 15-14 */
#define AWIN_PIO_PI_PS21_FUNC		3
#define AWIN_PIO_PI_UART6_PINS		0x00003000 /* PI pins 13-12 */
#define AWIN_PIO_PI_UART6_FUNC		3
#define AWIN_PIO_PI_UART5_PINS		0x00000c00 /* PI pins 11-10 */
#define AWIN_PIO_PI_UART5_FUNC		3
#define AWIN_PIO_PI_TWI4_PINS		0x0000000c /* PI pins 3-2 */
#define AWIN_PIO_PI_TWI4_FUNC		3
#define AWIN_PIO_PI_TWI3_PINS		0x00000003 /* PI pins 1-0 */
#define AWIN_PIO_PI_TWI3_FUNC		3
#define AWIN_PIO_PI_HSXX_PINS		0x00300000 /* PI pins 21-20 */
#define AWIN_PIO_PI_HSXX_FUNC		4
#define AWIN_PIO_PI_TCLKIN_PINS		0x0000c000 /* PI pins 15-14 */
#define AWIN_PIO_PI_TCLKIN_FUNC		4
#define AWIN_PIO_PI_CLKOUTB_PINS	0x00002000 /* PI pins 13-13 */
#define AWIN_PIO_PI_CLKOUTB_FUNC	4
#define AWIN_PIO_PI_CLKOUTA_PINS	0x00002000 /* PI pins 12-12 */
#define AWIN_PIO_PI_CLKOUTA_FUNC	4
#define AWIN_PIO_PI_EINT_PINS		0x000ffc00 /* PI pins 19-10 */
#define AWIN_PIO_PI_EINT_FUNC		6

/* Standard Timer (A10) */
#define AWIN_TMR_IRQ_EN_REG		0x0000
#define AWIN_TMR_IRQ_STA_REG		0x0004
#define AWIN_TMR0_CTRL_REG		0x0010
#define AWIN_TMR0_INTV_VALUE_REG	0x0014
#define AWIN_TMR0_CUR_VALUE_REG		0x0018
#define AWIN_TMR1_CTRL_REG		0x0020
#define AWIN_TMR1_INTV_VALUE_REG	0x0024
#define AWIN_TMR1_CUR_VALUE_REG		0x0028
#define AWIN_TMR2_CTRL_REG		0x0030
#define AWIN_TMR2_INTV_VALUE_REG	0x0034
#define AWIN_TMR2_CUR_VALUE_REG		0x0038
#define AWIN_TMR3_CTRL_REG		0x0040
#define AWIN_TMR3_INTV_VALUE_REG	0x0044
#define AWIN_TMR4_CTRL_REG		0x0050
#define AWIN_TMR4_INTV_VALUE_REG	0x0054
#define AWIN_TMR4_CUR_VALUE_REG		0x0058
#define AWIN_TMR5_CTRL_REG		0x0060
#define AWIN_TMR5_INTV_VALUE_REG	0x0064
#define AWIN_TMR5_CUR_VALUE_REG		0x0068
#define AWIN_AVS_CNT_CTL_REG		0x0080
#define AWIN_AVS_CNT0_REG		0x0084
#define AWIN_AVS_CNT1_REG		0x0088
#define AWIN_AVS_CNT_DIV_REG		0x008C
#define AWIN_WDOG_CTRL_REG		0x0090
#define AWIN_WDOG_MODE_REG		0x0094
#define AWIN_CNT64_CTRL_REG		0x00A0	/* A10 */
#define AWIN_CNT64_LO_REG		0x00A4	/* A10 */
#define AWIN_CNT64_HI_REG		0x00A8	/* A10 */
#define AWIN_LOSC_CTRL_REG		0x0100
#define AWIN_RTC_YY_MM_DD_REG		0x0104
#define AWIN_RTC_HH_MM_SS_REG		0x0108
#define AWIN_DD_HH_MM_SS_REG		0x010C
#define AWIN_ALARM_WK_HH_MM_SS_REG	0x0110
#define AWIN_ALARM_EN_REG		0x0114
#define AWIN_ALARM_IRQ_EN_REG		0x0118
#define AWIN_ALARM_IRQ_STA_REG		0x011C
#define AWIN_TMR_GP_DATA0_REG		0x0120
#define AWIN_TMR_GP_DATA1_REG		0x0124
#define AWIN_TMR_GP_DATA2_REG		0x0128
#define AWIN_TMR_GP_DATA3_REG		0x012C
#define AWIN_CPU_CFG_REG		0x0140

#define AWIN_TMR_IRQ_WDOG		__BIT(8)
#define AWIN_TMR_IRQ_TIMER5		__BIT(5)
#define AWIN_TMR_IRQ_TIMER4		__BIT(4)
#define AWIN_TMR_IRQ_TIMER3		__BIT(3)
#define AWIN_TMR_IRQ_TIMER2		__BIT(2)
#define AWIN_TMR_IRQ_TIMER1		__BIT(1)
#define AWIN_TMR_IRQ_TIMER0		__BIT(0)

#define AWIN_TMR_CTRL_SINGLE_SHOT	__BIT(7)
#define AWIN_TMR_CTRL_PRESCALE		__BITS(6,4)
#define AWIN_TMR_CTRL_CLK_SRC		__BITS(3,2)
#define AWIN_TMR_CTRL_CLK_SRC_LOSC	0
#define AWIN_TMR_CTRL_CLK_SRC_OSC24M	1
#define AWIN_TMR_CTRL_CLK_SRC_PLL6_DIV6	2
#define AWIN_TMR_CTRL_RELOAD		__BIT(1)
#define AWIN_TMR_CTRL_ENABLE		__BIT(0)

#define AWIN_CNT64_CTRL_PLL6_DIV6	__BIT(2)
#define AWIN_CNT64_CTRL_RL_ENABLE	__BIT(1)
#define AWIN_CNT64_CTRL_CLR_ENABLE	__BIT(0)

#define AWIN_WDOG_CTRL_KEY		__BITS(12,1)
#define AWIN_WDOG_CTRL_KEY_MAGIC	0xa57
#define AWIN_WDOG_CTRL_RSTART		__BIT(0)
#define AWIN_WDOG_MODE_INTV		__BITS(6,3)
#define AWIN_WDOG_MODE_INTV_HALFSEC	0
#define AWIN_WDOG_MODE_INTV_1SEC	1
#define AWIN_WDOG_MODE_INTV_2SEC	2
#define AWIN_WDOG_MODE_INTV_3SEC	3
#define AWIN_WDOG_MODE_INTV_4SEC	4
#define AWIN_WDOG_MODE_INTV_5SEC	5
#define AWIN_WDOG_MODE_INTV_6SEC	6
#define AWIN_WDOG_MODE_INTV_8SEC	7
#define AWIN_WDOG_MODE_INTV_10SEC	8
#define AWIN_WDOG_MODE_INTV_12SEC	9
#define AWIN_WDOG_MODE_INTV_14SEC	10
#define AWIN_WDOG_MODE_INTV_16SEC	11
#define AWIN_WDOG_MODE_RST_EN		__BIT(1)
#define AWIN_WDOG_MODE_EN		__BIT(0)

#define AWIN_LOSC_CTRL_KEY_FIELD	__BITS(31,16)
#define AWIN_LOSC_CTRL_CLK32K_AUTO_SWT_PEND __BIT(15)
#define AWIN_LOSC_CTRL_CLK32K_AUTO_SWT_EN __BIT(14)
#define AWIN_LOSC_CTRL_ALM_DDHHMMSS_ACCE __BIT(9)
#define AWIN_LOSC_CTRL_RTC_HHMMSS_ACCE	__BIT(8)
#define AWIN_LOSC_CTRL_RTC_YYMMDD_ACCE	__BIT(7)
#define AWIN_LOSC_CTRL_EXT_LOSC_GSM	__BITS(3,2)
#define AWIN_LOSC_CTRL_OSC32K_SRC_SEL	__BIT(0)
#define AWIN_LOSC_CTRL_BUSY \
	(AWIN_LOSC_CTRL_ALM_DDHHMMSS_ACCE | \
	 AWIN_LOSC_CTRL_RTC_HHMMSS_ACCE | \
	 AWIN_LOSC_CTRL_RTC_YYMMDD_ACCE)

#define AWIN_RTC_YY_MM_DD_RTC_SIM_CTRL	__BIT(30)
#define AWIN_RTC_YY_MM_DD_LEAP		__BIT(22)
#define AWIN_A20_RTC_YY_MM_DD_LEAP	__BIT(24)
#define AWIN_RTC_YY_MM_DD_YEAR		__BITS(21,16)
#define AWIN_A20_RTC_YY_MM_DD_YEAR	__BITS(23,16)
#define AWIN_RTC_YY_MM_DD_MONTH		__BITS(11,8)
#define AWIN_RTC_YY_MM_DD_DAY		__BITS(4,0)
#define AWIN_RTC_HH_MM_SS_WK_NO		__BITS(31,29)
#define AWIN_RTC_HH_MM_SS_HOUR		__BITS(20,16)
#define AWIN_RTC_HH_MM_SS_MINUTE	__BITS(13,8)
#define AWIN_RTC_HH_MM_SS_SECOND	__BITS(5,0)

#define AWIN_TWI_ADDR_REG		0x0000
#define AWIN_TWI_XADDR_REG		0x0004
#define AWIN_TWI_DATA_REG		0x0008
#define AWIN_TWI_CNTR_REG		0x000C
#define AWIN_TWI_STAT_REG		0x0010
#define AWIN_TWI_CCR_REG		0x0014
#define AWIN_TWI_SRST_REG		0x0018
#define AWIN_TWI_EFR_REG		0x001C
#define AWIN_TWI_LCR_REG		0x0020

#define AWIN_SPI_RXDATA_REG		0x0000
#define AWIN_SPI_TXDATA_REG		0x0004
#define AWIN_SPI_CTL_REG		0x0008
#define AWIN_SPI_INTCTL_REG		0x000C
#define AWIN_SPI_ST_REG			0x0010
#define AWIN_SPI_DMACTL_REG		0x0014
#define AWIN_SPI_WAIT_REG		0x0018
#define AWIN_SPI_CCTL_REG		0x001C
#define AWIN_SPI_BC_REG			0x0020
#define AWIN_SPI_TC_REG			0x0024
#define AWIN_SPI_FIFO_STA_REG		0x0028

/* A20 CPU Configuration definitions */
#define AWIN_CPU0_RST_CTRL_REG		0x0040
#define AWIN_CPU0_CTRL_REG		0x0044
#define AWIN_CPU0_STATUS_REG		0x0048
#define AWIN_CPU1_RST_CTRL_REG		0x0080
#define AWIN_CPU1_CTRL_REG		0x0084
#define AWIN_CPU1_STATUS_REG		0x0088
#define AWIN_GENER_CTRL_REG		0x0184
#define AWIN_EVENT_IN_REG		0x0190
#define AWIN_PRIVATE_REG		0x01A4
#define AWIN_IDLE_CNT0_LOW_REG		0x0200
#define AWIN_IDLE_CNT0_HIGH_REG		0x0204
#define AWIN_IDLE_CNT0_CTRL_REG		0x0208
#define AWIN_IDLE_CNT1_LOW_REG		0x0210
#define AWIN_IDLE_CNT1_HIGH_REG		0x0214
#define AWIN_IDLE_CNT1_CTRL_REG		0x0218
#define AWIN_OSC24M_CNT64_CTRL_REG	0x0280
#define AWIN_OSC24M_CNT64_LOW_REG	0x0284
#define AWIN_OSC24M_CNT64_HIGH_REG	0x0288
#define AWIN_LOSC_CNT64_CTRL_REG	0x0290
#define AWIN_LOSC_CNT64_LOW_REG		0x0294
#define AWIN_LOSC_CNT64_HIGH_REG	0x0298

#define AWIN_CPU_CORE_RESET		__BIT(1)
#define AWIN_CPU_RESET			__BIT(0)

/* High Speed Timer (A20) */
#define AWIN_HSTMR_IRQ_EN_REG		0x0000
#define AWIN_HSTMR_IRQ_STAT_REG		0x0004
#define AWIN_HSTMR_TMR0_CTRL_REG	0x0010
#define AWIN_HSTMR_TMR0_INTV_LO_REG	0x0014
#define AWIN_HSTMR_TMR0_INTV_HI_REG	0x0018
#define AWIN_HSTMR_TMR0_CURNT_LO_REG	0x001c
#define AWIN_HSTMR_TMR0_CURNT_HI_REG	0x0020
#define AWIN_HSTMR_TMR1_CTRL_REG	0x0030
#define AWIN_HSTMR_TMR1_INTV_LO_REG	0x0034
#define AWIN_HSTMR_TMR1_INTV_HI_REG	0x0038
#define AWIN_HSTMR_TMR1_CURNT_LO_REG	0x003c
#define AWIN_HSTMR_TMR1_CURNT_HI_REG	0x0040
#define AWIN_HSTMR_TMR2_CTRL_REG	0x0050
#define AWIN_HSTMR_TMR2_INTV_LO_REG	0x0054
#define AWIN_HSTMR_TMR2_INTV_HI_REG	0x0058
#define AWIN_HSTMR_TMR2_CURNT_LO_REG	0x005c
#define AWIN_HSTMR_TMR2_CURNT_HI_REG	0x0060
#define AWIN_HSTMR_TMR3_CTRL_REG	0x0070
#define AWIN_HSTMR_TMR3_INTV_LO_REG	0x0074
#define AWIN_HSTMR_TMR3_INTV_HI_REG	0x0078
#define AWIN_HSTMR_TMR3_CURNT_LO_REG	0x007c
#define AWIN_HSTMR_TMR3_CURNT_HI_REG	0x0080

/* DEBE */
#define AWIN_DEBE_MODCTL_REG		0x0800
#define AWIN_DEBE_BACKCOLOR_REG		0x0804
#define AWIN_DEBE_DISSIZE_REG		0x0808
#define AWIN_DEBE_LAYSIZE_REG		0x0810
#define AWIN_DEBE_LAYCOOR_REG		0x0820
#define AWIN_DEBE_LAYLINEWIDTH_REG	0x0840
#define AWIN_DEBE_LAYFB_L32ADD_REG	0x0850
#define AWIN_DEBE_LAYFB_H4ADD_REG	0x0860
#define AWIN_DEBE_REGBUFFCTL_REG	0x0870
#define AWIN_DEBE_CKMAX_REG		0x0880
#define AWIN_DEBE_CKMIN_REG		0x0884
#define AWIN_DEBE_CKCFG_REG		0x0888
#define AWIN_DEBE_ATTCTL0_REG		0x0890
#define AWIN_DEBE_ATTCTL1_REG		0x08A0
#define AWIN_DEBE_HWCCTL_REG		0x08D8
#define AWIN_DEBE_HWCFBCTL_REG		0x08E0
#define AWIN_DEBE_WBCTL_REG		0x08F0
#define AWIN_DEBE_WBADD_REG		0x08F4
#define AWIN_DEBE_WBLINEWIDTH_REG	0x08F8
#define AWIN_DEBE_IYUVCTL_REG		0x0920
#define AWIN_DEBE_IYUVADD_REG		0x0930
#define AWIN_DEBE_IYUVLINEWIDTH_REG	0x0940
#define AWIN_DEBE_YGCOEF_REG		0x0950
#define AWIN_DEBE_YGCONS_REG		0x095C
#define AWIN_DEBE_URCOEF_REG		0x0960
#define AWIN_DEBE_URCONS_REG		0x096C
#define AWIN_DEBE_VBCOEF_REG		0x0970
#define AWIN_DEBE_VBCONS_REG		0x097C
#define AWIN_DEBE_OCCTL_REG		0x09C0
#define AWIN_DEBE_OCRCOEF_REG		0x09D0
#define AWIN_DEBE_OCRCONS_REG		0x09DC
#define AWIN_DEBE_OCGCOEF_REG		0x09E0
#define AWIN_DEBE_OCGCONS_REG		0x09EC
#define AWIN_DEBE_OCBCOEF_REG		0x09F0
#define AWIN_DEBE_OCBCONS_REG		0x09FC
#define AWIN_DEBE_HWC_PATTERN_BLOCK	0x4800
#define AWIN_DEBE_HWC_PALETTE_TABLE	0x4C00

#define AWIN_DEBE_MODCTL_LINE_SEL	__BIT(29)
#define AWIN_DEBE_MODCTL_ITLMOD_EN	__BIT(28)
#define AWIN_DEBE_MODCTL_OUT_SEL	__BITS(22,20)
#define AWIN_DEBE_MODCTL_OUT_SEL_LCD0	0
#define AWIN_DEBE_MODCTL_OUT_SEL_LCD1	1
#define AWIN_DEBE_MODCTL_OUT_SEL_FE0	6
#define AWIN_DEBE_MODCTL_OUT_SEL_FE1	7
#define AWIN_DEBE_MODCTL_OSCA_EN	__BIT(17)
#define AWIN_DEBE_MODCTL_HWC_EN		__BIT(16)
#define AWIN_DEBE_MODCTL_LAY3_EN	__BIT(11)
#define AWIN_DEBE_MODCTL_LAY2_EN	__BIT(10)
#define AWIN_DEBE_MODCTL_LAY1_EN	__BIT(9)
#define AWIN_DEBE_MODCTL_LAY0_EN	__BIT(8)
#define AWIN_DEBE_MODCTL_START_CTL	__BIT(1)
#define AWIN_DEBE_MODCTL_EN		__BIT(0)

#define AWIN_DEBE_ATTCTL0_LAY_GLBALPHA	__BITS(31,24)
#define AWIN_DEBE_ATTCTL0_LAY_WORKMOD	__BITS(23,22)
#define AWIN_DEBE_ATTCTL0_PREMUL	__BIT(21,20)
#define AWIN_DEBE_ATTCTL0_CKEN		__BITS(19,18)
#define AWIN_DEBE_ATTCTL0_LAY_PIPESEL	__BIT(15)
#define AWIN_DEBE_ATTCTL0_LAY_PRISEL	__BITS(11,10)
#define AWIN_DEBE_ATTCTL0_LAY_VDOSEL	__BIT(4)
#define AWIN_DEBE_ATTCTL0_LAY_YUVEN	__BIT(2)
#define AWIN_DEBE_ATTCTL0_LAY_VDOEN	__BIT(1)
#define AWIN_DEBE_ATTCTL0_LAY_GLBALPHAEN __BIT(0)

#define AWIN_DEBE_ATTCTL1_LAY_HSCAFCT	__BITS(15,14)
#define AWIN_DEBE_ATTCTL1_LAY_WSCAFCT	__BITS(13,12)
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT	__BITS(11,8)
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_MONO_1BPP	0
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_MONO_2BPP	1
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_MONO_4BPP	2
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_MONO_8BPP	3
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGB655	4
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGB565	5
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGB556	6
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_ARGB1555	7
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGBA5551	8
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_XRGB8888	9
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_ARGB8888	10
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGB888	11
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_ARGB4444	12
#define AWIN_DEBE_ATTCTL1_LAY_FBFMT_RGBA4444	13
#define AWIN_DEBE_ATTCTL1_LAY_BRSWAPEN	__BIT(2)
#define AWIN_DEBE_ATTCTL1_LAY_FBPS	__BITS(1,0)
#define AWIN_DEBE_ATTCTL1_LAY_FBPS_32BPP_ARGB	0
#define AWIN_DEBE_ATTCTL1_LAY_FBPS_32BPP_BGRA	2

#define AWIN_DEBE_REGBUFFCTL_REGAUTOLOAD_DIS __BIT(1)
#define AWIN_DEBE_REGBUFFCTL_REGLOADCTL	__BIT(0)

#define AWIN_DEBE_HWCCTL_YCOOR		__BITS(31,16)
#define AWIN_DEBE_HWCCTL_XCOOR		__BITS(15,0)

#define AWIN_DEBE_HWCFBCTL_YCOOROFF	__BITS(31,24)
#define AWIN_DEBE_HWCFBCTL_XCOOROFF	__BITS(23,16)
#define AWIN_DEBE_HWCFBCTL_YSIZE	__BITS(5,4)
#define AWIN_DEBE_HWCFBCTL_YSIZE_32	0
#define AWIN_DEBE_HWCFBCTL_YSIZE_64	1
#define AWIN_DEBE_HWCFBCTL_XSIZE	__BITS(3,2)
#define AWIN_DEBE_HWCFBCTL_XSIZE_32	0
#define AWIN_DEBE_HWCFBCTL_XSIZE_64	1
#define AWIN_DEBE_HWCFBCTL_FBFMT	__BITS(1,0)
#define AWIN_DEBE_HWCFBCTL_FBFMT_1BPP	0
#define AWIN_DEBE_HWCFBCTL_FBFMT_2BPP	1
#define AWIN_DEBE_HWCFBCTL_FBFMT_4BPP	2
#define AWIN_DEBE_HWCFBCTL_FBFMT_8BPP	3

/* TCON */
#define AWIN_TCON_GCTL_REG		0x0000
#define AWIN_TCON_GINT0_REG		0x0004
#define AWIN_TCON_GINT1_REG		0x0008
#define AWIN_TCON0_FRM_CTL_REG		0x0010
#define AWIN_TCON0_FRM1_CTL_REG		0x0014
#define AWIN_TCON0_FRM2_CTL_REG		0x002c
#define AWIN_TCON0_CTL_REG		0x0040
#define AWIN_TCON0_DCLK_REG		0x0044
#define AWIN_TCON0_BASIC0_REG		0x0048
#define AWIN_TCON0_BASIC1_REG		0x004C
#define AWIN_TCON0_BASIC2_REG		0x0050
#define AWIN_TCON0_BASIC3_REG		0x0054
#define AWIN_TCON0_HV_IF_REG		0x0058
#define AWIN_TCON0_CPU_IF_REG		0x0060
#define AWIN_TCON0_CPU_WR_REG		0x0064
#define AWIN_TCON0_CPU_RD0_REG		0x0068
#define AWIN_TCON0_CPU_RD1_REG		0x006C
#define AWIN_TCON0_LVDS_IF_REG		0x0084
#define AWIN_TCON0_IO_POL_REG		0x0088
#define AWIN_TCON0_IO_TRI_REG		0x008C
#define AWIN_TCON1_CTL_REG		0x0090
#define AWIN_TCON1_BASIC0_REG		0x0094
#define AWIN_TCON1_BASIC1_REG		0x0098
#define AWIN_TCON1_BASIC2_REG		0x009C
#define AWIN_TCON1_BASIC3_REG		0x00A0
#define AWIN_TCON1_BASIC4_REG		0x00A4
#define AWIN_TCON1_BASIC5_REG		0x00A8
#define AWIN_TCON1_IO_POL_REG		0x00F0
#define AWIN_TCON1_IO_TRI_REG		0x00F4
#define AWIN_TCON_CEU_CTL_REG		0x0100
#define AWIN_TCON0_CPU_TRI0_REG		0x0160
#define AWIN_TCON0_CPU_TRI1_REG		0x0164
#define AWIN_TCON0_CPU_TRI2_REG		0x0168
#define AWIN_TCON0_CPU_TRI3_REG		0x016C
#define AWIN_TCON_CMAP_CTL_REG		0x0180
#define AWIN_TCON_CMAP_ODD0_REG		0x0190
#define AWIN_TCON_CMAP_ODD1_REG		0x0194
#define AWIN_TCON_CMAP_EVEN0_REG	0x0198
#define AWIN_TCON_CMAP_EVEN1_REG	0x019C
#define AWIN_TCON_MUX_CTL_REG		0x0200 /* only in TCON0 */
#define AWIN_TCON_LVDS_ANA0		0x220
#define AWIN_TCON_LVDS_ANA1		0x224

#define AWIN_TCON_GCTL_EN		__BIT(31)
#define AWIN_TCON_GCTL_GAMMA_EN		__BIT(30)
#define AWIN_TCON_GCTL_IO_MAP_SEL	__BIT(0)
#define AWIN_TCON_GCTL_IO_MAP_SEL_TCON0	0
#define AWIN_TCON_GCTL_IO_MAP_SEL_TCON1	1

#define AWIN_TCON_GINT1_TCON0_LINENO	__BITS(27,16)
#define AWIN_TCON_GINT1_TCON1_LINENO	__BITS(11,0)

#define AWIN_TCON0_FRM_ENABLE		__BIT(31)
#define AWIN_TCON0_FRM_R5BITS		__BIT(6)
#define AWIN_TCON0_FRM_G5BITS		__BIT(5)
#define AWIN_TCON0_FRM_B5BITS		__BIT(4)

#define AWIN_TCONx_CTL_EN		__BIT(31)
#define AWIN_TCON0_CTL0_IF		__BITS(25,24)
#define AWIN_TCON0_CTL0_IF_HV		0
#define AWIN_TCON0_CTL0_IF_8080		1
#define AWIN_TCON0_CTL0_IF_TTL		2
#define AWIN_TCON0_CTL_RG_SWAP		__BIT(23)
#define AWIN_TCON0_CTL_TSTV		__BIT(22)
#define AWIN_TCONx_CTL_INTERLACE_EN	__BIT(20)
#define AWIN_TCONx_CTL_START_DELAY	__BITS(8,4)
#define AWIN_TCONx_CTL_SRC_SEL		__BITS(1,0)
#define AWIN_TCONx_CTL_SRC_SEL_DE0	0
#define AWIN_TCONx_CTL_SRC_SEL_DE1	1
#define AWIN_TCONx_CTL_SRC_SEL_BLUEDATA	2

#define AWIN_TCON0_DCLK_DIV		__BITS(6,0)

#define AWIN_TCON0_LVDS_IF_EN		__BIT(31)
#define AWIN_TCON0_LVDS_IF_DUALCHAN	__BIT(30)
#define AWIN_TCON0_LVDS_IF_DIR_REV	__BIT(28)
#define AWIN_TCON0_LVDS_IF_MODE_JEIDA	__BIT(27)
#define AWIN_TCON0_LVDS_IF_18BITS	__BIT(26)
#define AWIN_TCON0_LVDS_IF_CORR_MODE1	__BIT(23)

#define AWIN_TCON_IO_POL_IO2_INV	__BIT(26)
#define AWIN_TCON_IO_POL_PVSYNC		__BIT(25)
#define AWIN_TCON_IO_POL_PHSYNC		__BIT(24)

#define AWIN_TCON_IO_TRI_IO3		__BIT(27)
#define AWIN_TCON_IO_TRI_IO2		__BIT(26)
#define AWIN_TCON_IO_TRI_IO1		__BIT(25)
#define AWIN_TCON_IO_TRI_IO0		__BIT(24)
#define AWIN_TCON_IO_TRI_DATA		__BITS(23,0)

#define AWIN_TCON_MUX_CTL_HDMI_OUTPUT_SRC __BITS(9,8)
#define AWIN_TCON_MUX_CTL_HDMI_OUTPUT_SRC_LCDC0_TCON1	0
#define AWIN_TCON_MUX_CTL_HDMI_OUTPUT_SRC_LCDC1_TCON1	1
#define AWIN_TCON_MUX_CTL_HDMI_OUTPUT_SRC_CLOSE		2

/* HDMI */
#define AWIN_HDMI_VERSION_ID_REG	0x0000
#define AWIN_HDMI_CTRL_REG		0x0004
#define AWIN_HDMI_INT_STATUS_REG	0x0008
#define AWIN_HDMI_HPD_REG		0x000c
#define AWIN_HDMI_VID_CTRL_REG		0x0010
#define AWIN_HDMI_VID_TIMING_0_REG	0x0014
#define AWIN_HDMI_VID_TIMING_1_REG	0x0018
#define AWIN_HDMI_VID_TIMING_2_REG	0x001c
#define AWIN_HDMI_VID_TIMING_3_REG	0x0020
#define AWIN_HDMI_VID_TIMING_4_REG	0x0024
#define AWIN_HDMI_AUD_CTRL_REG		0x0040
#define AWIN_HDMI_ADMA_CTRL_REG		0x0044
#define AWIN_HDMI_AUD_FMT_REG		0x0048
#define AWIN_HDMI_AUD_PCM_CTRL_REG	0x004c
#define AWIN_HDMI_AUD_CTS_REG		0x0050
#define AWIN_HDMI_AUD_N_REG		0x0054
#define AWIN_HDMI_AUD_CH_STATUS0_REG	0x0058
#define AWIN_HDMI_AUD_CH_STATUS1_REG	0x005c
#define AWIN_HDMI_AVI_INFO_PKT_REG	0x0080
#define AWIN_HDMI_AUD_INFO_PKT_REG	0x00a0
#define AWIN_HDMI_ACP_PKT_REG		0x00c0
#define AWIN_HDMI_GP_PKT_REG		0x00e0
#define AWIN_HDMI_PAD_CTRL0_REG		0x0200
#define AWIN_HDMI_PAD_CTRL1_REG		0x0204
#define AWIN_HDMI_PLL_CTRL_REG		0x0208
#define AWIN_HDMI_PLL_DBG0_REG		0x020c
#define AWIN_HDMI_PLL_DBG1_REG		0x0210
#define AWIN_HDMI_HPD_CEC_REG		0x0214
#define AWIN_HDMI_SPD_PKT_REG		0x0240
#define AWIN_HDMI_PKT_CTRL0_REG		0x02f0
#define AWIN_HDMI_PKT_CTRL1_REG		0x02f4
#define AWIN_HDMI_DBG4_REG		0x0310
#define AWIN_HDMI_AUX_TX_FIFO_REG	0x0400
#define AWIN_HDMI_DDC_CTRL_REG		0x0500
#define AWIN_HDMI_DDC_SLAVE_ADDR_REG	0x0504
#define AWIN_HDMI_DDC_INT_MASK_REG	0x0508
#define AWIN_HDMI_DDC_INT_STATUS_REG	0x050c
#define AWIN_HDMI_DDC_FIFO_CTRL_REG	0x0510
#define AWIN_HDMI_DDC_FIFO_STATUS_REG	0x0514
#define AWIN_HDMI_DDC_FIFO_ACCESS_REG	0x0518
#define AWIN_HDMI_DDC_BYTE_COUNTER_REG	0x051c
#define AWIN_HDMI_DDC_COMMAND_REG	0x0520
#define AWIN_HDMI_DDC_EX_REG		0x0524
#define AWIN_HDMI_DDC_CLOCK_REG		0x0528
#define AWIN_HDMI_DDC_DBG_REG		0x0540

#define AWIN_HDMI_VERSION_ID_H		__BITS(31,16)
#define AWIN_HDMI_VERSION_ID_L		__BITS(15,0)

#define AWIN_HDMI_CTRL_MODULE_EN	__BIT(31)
#define AWIN_HDMI_CTRL_HDCP_EN		__BIT(30)
#define AWIN_HDMI_CTRL_CLR_AVMUTE	__BIT(1)
#define AWIN_HDMI_CTRL_SET_AVMUTE	__BIT(0)

#define AWIN_HDMI_HPD_HOTPLUG_DET	__BIT(0)

#define AWIN_HDMI_VID_CTRL_VIDEO_EN	__BIT(31)
#define AWIN_HDMI_VID_CTRL_HDMI_MODE	__BIT(30)
#define AWIN_HDMI_VID_CTRL_HDMI_MODE_DVI	0
#define AWIN_HDMI_VID_CTRL_HDMI_MODE_HDMI	1
#define AWIN_HDMI_VID_CTRL_SRC_SEL	__BIT(5)
#define AWIN_HDMI_VID_CTRL_SRC_SEL_RGB		0
#define AWIN_HDMI_VID_CTRL_SRC_SEL_CBGEN	1
#define AWIN_HDMI_VID_CTRL_OUTPUT_FMT	__BIT(4)
#define AWIN_HDMI_VID_CTRL_OUTPUT_FMT_PROGRESS	0
#define AWIN_HDMI_VID_CTRL_OUTPUT_FMT_INTERLACE	1
#define AWIN_HDMI_VID_CTRL_COLOR_MODE	__BITS(3,2)
#define AWIN_HDMI_VID_CTRL_COLOR_MODE_24	0
#define AWIN_HDMI_VID_CTRL_COLOR_MODE_30	1
#define AWIN_HDMI_VID_CTRL_COLOR_MODE_36	2
#define AWIN_HDMI_VID_CTRL_COLOR_MODE_48	3
#define AWIN_HDMI_VID_CTRL_REPEATER_SEL	__BITS(1,0)
#define AWIN_HDMI_VID_CTRL_REPEATER_SEL_NORMAL	0
#define AWIN_HDMI_VID_CTRL_REPEATER_SEL_2X	1
#define AWIN_HDMI_VID_CTRL_REPEATER_SEL_4X	2

#define AWIN_HDMI_VID_TIMING_0_ACT_V	__BITS(27,16)
#define AWIN_HDMI_VID_TIMING_0_ACT_H	__BITS(11,0)

#define AWIN_HDMI_VID_TIMING_1_VBP	__BITS(27,16)
#define AWIN_HDMI_VID_TIMING_1_HBP	__BITS(11,0)

#define AWIN_HDMI_VID_TIMING_2_VFP	__BITS(27,16)
#define AWIN_HDMI_VID_TIMING_2_HFP	__BITS(11,0)

#define AWIN_HDMI_VID_TIMING_3_VSPW	__BITS(27,16)
#define AWIN_HDMI_VID_TIMING_3_HSPW	__BITS(11,0)

#define AWIN_HDMI_VID_TIMING_4_TX_CLOCK	__BITS(25,16)
#define AWIN_HDMI_VID_TIMING_4_TX_CLOCK_NORMAL	0x3e0
#define AWIN_HDMI_VID_TIMING_4_VSYNC_ACTIVE_SEL __BIT(1)
#define AWIN_HDMI_VID_TIMING_4_HSYNC_ACTIVE_SEL __BIT(0)

#define AWIN_HDMI_PAD_CTRL0_BIAS	__BIT(31)
#define AWIN_HDMI_PAD_CTRL0_LDOCEN	__BIT(30)
#define AWIN_HDMI_PAD_CTRL0_LD0DEN	__BIT(29)
#define AWIN_HDMI_PAD_CTRL0_PWENC	__BIT(28)
#define AWIN_HDMI_PAD_CTRL0_PWEND	__BIT(27)
#define AWIN_HDMI_PAD_CTRL0_PWENG	__BIT(26)
#define AWIN_HDMI_PAD_CTRL0_CKEN	__BIT(25)
#define AWIN_HDMI_PAD_CTRL0_SEN		__BIT(24)
#define AWIN_HDMI_PAD_CTRL0_TXEN	__BIT(23)
#define AWIN_HDMI_PAD_CTRL0_AUTOSYNC_DIS __BIT(22)
#define AWIN_HDMI_PAD_CTRL0_LSB_MSB	__BIT(21)

#define AWIN_HDMI_PAD_CTRL1_AMP_OPT	__BIT(23)
#define AWIN_HDMI_PAD_CTRL1_AMPCK_OPT	__BIT(22)
#define AWIN_HDMI_PAD_CTRL1_DMP_OPT	__BIT(21)
#define AWIN_HDMI_PAD_CTRL1_EMP_OPT	__BIT(20)
#define AWIN_HDMI_PAD_CTRL1_EMPCK_OPT	__BIT(19)
#define AWIN_HDMI_PAD_CTRL1_PWSCK	__BIT(18)
#define AWIN_HDMI_PAD_CTRL1_PWSDT	__BIT(17)
#define AWIN_HDMI_PAD_CTRL1_REG_CSMPS	__BIT(16)
#define AWIN_HDMI_PAD_CTRL1_REG_DEN	__BIT(15)
#define AWIN_HDMI_PAD_CTRL1_REG_DENCK	__BIT(14)
#define AWIN_HDMI_PAD_CTRL1_REG_PLRCK	__BIT(13)
#define AWIN_HDMI_PAD_CTRL1_REG_EMP	__BITS(12,10)
#define AWIN_HDMI_PAD_CTRL1_REG_CD	__BITS(9,8)
#define AWIN_HDMI_PAD_CTRL1_REG_CKSS	__BITS(7,6)
#define AWIN_HDMI_PAD_CTRL1_REG_AMP	__BITS(5,3)
#define AWIN_HDMI_PAD_CTRL1_REG_PLR	__BITS(2,0)

#define AWIN_HDMI_PLL_CTRL_PLL_EN	__BIT(31)
#define AWIN_HDMI_PLL_CTRL_BWS		__BIT(30)
#define AWIN_HDMI_PLL_CTRL_HV_IS_33	__BIT(29)
#define AWIN_HDMI_PLL_CTRL_LDO1_EN	__BIT(28)
#define AWIN_HDMI_PLL_CTRL_LDO2_EN	__BIT(27)
#define AWIN_HDMI_PLL_CTRL_S6P25_7P5	__BIT(26)
#define AWIN_HDMI_PLL_CTRL_SDIV2	__BIT(25)
#define AWIN_HDMI_PLL_CTRL_SINT_FRAC	__BIT(24)
#define AWIN_HDMI_PLL_CTRL_VCO_GAIN_EN	__BIT(23)
#define AWIN_HDMI_PLL_CTRL_VCO_GAIN	__BITS(22,20)
#define AWIN_HDMI_PLL_CTRL_S		__BITS(19,17)
#define AWIN_HDMI_PLL_CTRL_CP_S		__BITS(16,12)
#define AWIN_HDMI_PLL_CTRL_CS		__BITS(11,8)
#define AWIN_HDMI_PLL_CTRL_PREDIV	__BITS(7,4)
#define AWIN_HDMI_PLL_CTRL_VCO_S	__BITS(3,0)

#define AWIN_HDMI_AUD_CTRL_EN		__BIT(31)
#define AWIN_HDMI_AUD_CTRL_RST		__BIT(30)

#define AWIN_HDMI_ADMA_CTRL_SRC_DMA_MODE __BIT(31)
#define AWIN_HDMI_ADMA_CTRL_DMA_REQ_CTRL __BITS(25,24)
#define AWIN_HDMI_ADMA_CTRL_SRC_DMA_SAMPLE_RATE __BIT(19)
#define AWIN_HDMI_ADMA_CTRL_SRC_SAMPLE_LAYOUT __BIT(18)
#define AWIN_HDMI_ADMA_CTRL_SRC_WORD_LEN __BITS(17,16)
#define AWIN_HDMI_ADMA_CTRL_FIFO_CLEAR	__BIT(15)
#define AWIN_HDMI_ADMA_CTRL_DATA_SEL	__BIT(0)

#define AWIN_HDMI_AUD_FMT_SRC_SEL	__BIT(31)
#define AWIN_HDMI_AUD_FMT_SEL		__BITS(26,24)
#define AWIN_HDMI_AUD_FMT_DSD_FMT	__BIT(4)
#define AWIN_HDMI_AUD_FMT_LAYOUT	__BIT(3)
#define AWIN_HDMI_AUD_FMT_SRC_CH_CFG	__BITS(2,0)

#define AWIN_HDMI_AUD_CH_STATUS0_CHNL_BIT1	__BITS(31,30)
#define AWIN_HDMI_AUD_CH_STATUS0_CLK_ACCUR	__BITS(29,28)
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ	__BITS(27,24)
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_44_1	0
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_48	2
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_32	3
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_88_2	8
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_96	10
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_176_4	12
#define AWIN_HDMI_AUD_CH_STATUS0_FS_FREQ_192	14
#define AWIN_HDMI_AUD_CH_STATUS0_CH_NUM		__BITS(23,20)
#define AWIN_HDMI_AUD_CH_STATUS0_SOURCE_NUM	__BITS(19,16)
#define AWIN_HDMI_AUD_CH_STATUS0_CATEGORY_CODE	__BITS(15,8)
#define AWIN_HDMI_AUD_CH_STATUS0_MODE		__BITS(7,6)
#define AWIN_HDMI_AUD_CH_STATUS0_EMPHASIS	__BITS(5,3)
#define AWIN_HDMI_AUD_CH_STATUS0_CP		__BIT(2)
#define AWIN_HDMI_AUD_CH_STATUS0_DATA_TYPE	__BIT(1)
#define AWIN_HDMI_AUD_CH_STATUS0_APP_TYPE	__BIT(0)

#define AWIN_HDMI_AUD_CH_STATUS1_CGMS_A		__BITS(9,8)
#define AWIN_HDMI_AUD_CH_STATUS1_ORIGINAL_FS	__BITS(7,4)
#define AWIN_HDMI_AUD_CH_STATUS1_WORD_LEN	__BITS(3,1)
#define AWIN_HDMI_AUD_CH_STATUS1_WORD_LEN_MAX	__BIT(0)

#define AWIN_HDMI_DDC_CTRL_EN		__BIT(31)
#define AWIN_HDMI_DDC_CTRL_ACCESS_CMD_START __BIT(30)
#define AWIN_HDMI_DDC_CTRL_FIFO_DIR	__BIT(8)
#define AWIN_HDMI_DDC_CTRL_FIFO_DIR_READ	0
#define AWIN_HDMI_DDC_CTRL_FIFO_DIR_WRITE	1
#define AWIN_HDMI_DDC_CTRL_SW_RST	__BIT(0)

#define AWIN_HDMI_DDC_SLAVE_ADDR_0	__BITS(31,24)
#define AWIN_HDMI_DDC_SLAVE_ADDR_1	__BITS(23,16)
#define AWIN_HDMI_DDC_SLAVE_ADDR_2	__BITS(15,8)
#define AWIN_HDMI_DDC_SLAVE_ADDR_3	__BITS(6,0)

#define AWIN_HDMI_DDC_INT_STATUS_CLEAR	__BIT(8)
#define AWIN_HDMI_DDC_INT_STATUS_ILLEGAL_FIFO_OP __BIT(7)
#define AWIN_HDMI_DDC_INT_STATUS_RX_UNDERFLOW __BIT(6)
#define AWIN_HDMI_DDC_INT_STATUS_TX_OVERFLOW __BIT(5)
#define AWIN_HDMI_DDC_INT_STATUS_FIFO_REQ __BIT(4)
#define AWIN_HDMI_DDC_INT_STATUS_ARB_ERR __BIT(3)
#define AWIN_HDMI_DDC_INT_STATUS_ACK_ERR __BIT(2)
#define AWIN_HDMI_DDC_INT_STATUS_BUS_ERR __BIT(1)
#define AWIN_HDMI_DDC_INT_STATUS_TRANSFER_COMPLETE __BIT(0)

#define AWIN_HDMI_DDC_FIFO_CTRL_ADDR_CLEAR __BIT(31)
#define AWIN_HDMI_DDC_FIFO_CTRL_REQUEST_EN __BIT(8)
#define AWIN_HDMI_DDC_FIFO_CTRL_RX_TRIGGER_THRESH __BITS(7,4)
#define AWIN_HDMI_DDC_FIFO_CTRL_TX_TRIGGER_THRESH __BITS(3,0)

#define AWIN_HDMI_DDC_FIFO_STATUS_REQ_READY __BIT(7)
#define AWIN_HDMI_DDC_FIFO_STATUS_FULL	__BIT(6)
#define AWIN_HDMI_DDC_FIFO_STATUS_EMPTY	__BIT(5)
#define AWIN_HDMI_DDC_FIFO_STATUS_LEVEL	__BITS(4,0)

#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD __BITS(2,0)
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_ABORT	0
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_SOREAD	1
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_EOWRITE 2
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_IOWRITE 3
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_EOREAD	4
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_IOREAD	5
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_EOEDDCREAD 6
#define AWIN_HDMI_DDC_COMMAND_ACCESS_CMD_IOEDDCREAD 7

#define AWIN_HDMI_DDC_CLOCK_M		__BITS(6,3)
#define AWIN_HDMI_DDC_CLOCK_N		__BITS(2,0)

/* Mixer processor */
#define AWIN_MP_CTL_REG				0x0000
#define AWIN_MP_STS_REG				0x0004
#define AWIN_MP_IDMAGLBCTL_REG			0x0008
#define AWIN_MP_IDMA_H4ADD_REG			0x000C
#define AWIN_MP_IDMA_L32ADD_REG(n)		(0x0010 + ((n) * 4))
#define AWIN_MP_IDMALINEWIDTH_REG(n)		(0x0020 + ((n) * 4))
#define AWIN_MP_IDMASIZE_REG(n)			(0x0030 + ((n) * 4))
#define AWIN_MP_IDMACOOR_REG(n)			(0x0040 + ((n) * 4))
#define AWIN_MP_IDMASET_REG(n)			(0x0050 + ((n) * 4))
#define AWIN_MP_IDMAFILLCOLOR_REG(n)		(0x0060 + ((n) * 4))
#define AWIN_MP_CSC0CTL_REG			0x0074
#define AWIN_MP_CSC1CTL_REG			0x0078
#define AWIN_MP_SCACTL_REG			0x0080
#define AWIN_MP_SCAOUTSIZE_REG			0x0084
#define AWIN_MP_SCAHORFCT_REG			0x0088
#define AWIN_MP_SCAVERFCT_REG			0x008c
#define AWIN_MP_SCAHORPHASE_REG			0x0090
#define AWIN_MP_SCAVERPHASE_REG			0x0094
#define AWIN_MP_ROPCTL_REG			0x00b0
#define AWIN_MP_ROPIDX0CTL_REG			0x00b8
#define AWIN_MP_ROPIDX1CTL_REG			0x00bc
#define AWIN_MP_ALPHACKCTL_REG			0x00c0
#define AWIN_MP_CKMIN_REG			0x00c4
#define AWIN_MP_CKMAX_REG			0x00c8
#define AWIN_MP_ROPOUTFILLCOLOR_REG		0x00cc
#define AWIN_MP_CSC2CTL_REG			0x00d0
#define AWIN_MP_OUTCTL_REG			0x00e0
#define AWIN_MP_OUTSIZE_REG			0x00e8
#define AWIN_MP_OUTH4ADD_REG			0x00ec
#define AWIN_MP_OUTL32ADD_REG(n)		(0x00f0 + ((n) * 4))
#define AWIN_MP_OUTLINEWIDTH_REG(n)		(0x0100 + ((n) * 4))
#define AWIN_MP_OUTALPHACTL_REG			0x0120
#define AWIN_MP_MBCTL_REG(n)			(0x0130 + ((n) * 4))
#define AWIN_MP_CMDQUECTL_REG			0x0140
#define AWIN_MP_CMDQUESTS_REG			0x0144
#define AWIN_MP_CMDQUEADD_REG			0x0148
#define AWIN_MP_ICSCYGCOEF_REG(n)		(0x0180 + ((n) * 4))
#define AWIN_MP_ICSCYGCONS_REG			0x018c
#define AWIN_MP_ICSCCURCOEF_REG(n)		(0x0190 + ((n) * 4))
#define AWIN_MP_ICSCCURCONS_REG			0x019c
#define AWIN_MP_ICSCVBCOEF_REG(n)		(0x01a0 + ((n) * 4))
#define AWIN_MP_ICSCVBCONS_REG			0x01ac
#define AWIN_MP_OCSCYGCOEF_REG(n)		(0x01c0 + ((n) * 4))
#define AWIN_MP_OCSCYGCONS_REG			0x01cc
#define AWIN_MP_OCSCCURCOEF_REG(n)		(0x01d0 + ((n) * 4))
#define AWIN_MP_OCSCCURCONS_REG			0x01dc
#define AWIN_MP_OCSCVBCOEF_REG(n)		(0x01e0 + ((n) * 4))
#define AWIN_MP_OCSCVBCONS_REG			0x01ec
#define AWIN_MP_SCAL_HORIZ_FILT_BLOCK		0x0200
#define AWIN_MP_SCAL_VERT_FILT_BLOCK		0x0280
#define AWIN_MP_PALETTE_TABLE			0x0400

#define AWIN_MP_CTL_HWERRIRQ_EN			__BIT(9)
#define AWIN_MP_CTL_FINISHIRQ_EN		__BIT(8)
#define AWIN_MP_CTL_START_CTL			__BIT(1)
#define AWIN_MP_CTL_MP_EN			__BIT(0)

#define AWIN_MP_STS_HWERR_FLAG			__BIT(13)
#define AWIN_MP_STS_BUSY_FLAG			__BIT(12)
#define AWIN_MP_STS_HWERRIRQ_FLAG		__BIT(9)
#define AWIN_MP_STS_FINISHIRQ_FLAG		__BIT(8)

#define AWIN_MP_IDMAGLBCTL_MEMSCANORDER		__BITS(9,8)
#define AWIN_MP_IDMAGLBCTL_MEMSCANORDER_TD_LR	0
#define AWIN_MP_IDMAGLBCTL_MEMSCANORDER_TD_RL	1
#define AWIN_MP_IDMAGLBCTL_MEMSCANORDER_DT_LR	2
#define AWIN_MP_IDMAGLBCTL_MEMSCANORDER_DT_RL	3

#define AWIN_MP_IDMA_H4ADD_IDMA3_H4ADD		__BITS(27,24)
#define AWIN_MP_IDMA_H4ADD_IDMA2_H4ADD		__BITS(19,16)
#define AWIN_MP_IDMA_H4ADD_IDMA1_H4ADD		__BITS(11,8)
#define AWIN_MP_IDMA_H4ADD_IDMA0_H4ADD		__BITS(3,0)

#define AWIN_MP_IDMASIZE_HEIGHT			__BITS(28,16)
#define AWIN_MP_IDMASIZE_WIDTH			__BITS(12,0)

#define AWIN_MP_IDMACOOR_YCOOR			__BITS(31,16)
#define AWIN_MP_IDMACOOR_XCOOR			__BITS(15,0)

#define AWIN_MP_IDMASET_IDMA_GLBALPHA		__BITS(31,24)
#define AWIN_MP_IDMASET_MBFMT			__BIT(22)
#define AWIN_MP_IDMASET_MBSIZE			__BITS(21,20)
#define AWIN_MP_IDMASET_MBSIZE_16X16		0
#define AWIN_MP_IDMASET_MBSIZE_32X32		1
#define AWIN_MP_IDMASET_MBSIZE_64X64		2
#define AWIN_MP_IDMASET_MBSIZE_128X128		3
#define AWIN_MP_IDMASET_IDMA_FCMODEN		__BIT(16)
#define AWIN_MP_IDMASET_IDMA_PS			__BITS(15,12)
#define AWIN_MP_IDMASET_IDMA_FMT		__BITS(11,8)
#define AWIN_MP_IDMASET_IDMA_FMT_ARGB8888	0
#define AWIN_MP_IDMASET_IDMA_FMT_ARGB4444	1
#define AWIN_MP_IDMASET_IDMA_FMT_ARGB1555	2
#define AWIN_MP_IDMASET_IDMA_FMT_RGB565		3
#define AWIN_MP_IDMASET_IDMA_FMT_IYUV422	4
#define AWIN_MP_IDMASET_IDMA_FMT_UV88		5
#define AWIN_MP_IDMASET_IDMA_FMT_Y8		6
#define AWIN_MP_IDMASET_IDMA_FMT_8BPP_MP	7
#define AWIN_MP_IDMASET_IDMA_FMT_4BPP_MP	8
#define AWIN_MP_IDMASET_IDMA_FMT_2BPP_MP	9
#define AWIN_MP_IDMASET_IDMA_FMT_1BPP_MP	10
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL		__BITS(7,4)
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_NORMAL	0
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_X	1
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_Y	2
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_XY	3
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_A	4
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_AX	5
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_AY	6
#define AWIN_MP_IDMASET_IDMA_ROPMIRCTL_AXY	7
#define AWIN_MP_IDMASET_IDMA_ALPHACTL		__BITS(3,2)
#define AWIN_MP_IDMASET_IDMA_WORKMOD		__BIT(1)
#define AWIN_MP_IDMASET_IDMA_EN			__BIT(0)

#define AWIN_MP_CSCxCTL_DATAMOD			__BITS(7,4)
#define AWIN_MP_CSCxCTL_EN			__BIT(0)

#define AWIN_MP_SCACTL_SCA_ALGSEL		__BITS(5,4)
#define AWIN_MP_SCACTL_SCA_EN			__BIT(0)

#define AWIN_MP_SCAOUTSIZE_OUTHEIGHT		__BITS(28,16)
#define AWIN_MP_SCAOUTSIZE_OUTWIDTH		__BITS(12,0)

#define AWIN_MP_SCAHORFCT_HORINTFCT		__BITS(23,16)
#define AWIN_MP_SCAHORFCT_HORFRAFCT		__BITS(15,0)

#define AWIN_MP_SCAVERFCT_VERINTFCT		__BITS(23,16)
#define AWIN_MP_SCAVERFCT_VERFRAFCT		__BITS(15,0)

#define AWIN_MP_SCAHORPHASE_HORPHASE		__BITS(19,0)

#define AWIN_MP_SCAVERPHASE_VERPHASE		__BITS(19,0)

#define AWIN_MP_ROPCTL_ROP_ALPHABYPASSSEL	__BITS(15,14)
#define AWIN_MP_ROPCTL_ROP_REDBYPASSSEL		__BITS(13,12)
#define AWIN_MP_ROPCTL_ROP_GREENBYPASSSEL	__BITS(11,10)
#define AWIN_MP_ROPCTL_ROP_BLUEBYPASSSEL	__BITS(9,8)
#define AWIN_MP_ROPCTL_ROP_ALPHABYPASSEN	__BIT(7)
#define AWIN_MP_ROPCTL_ROP_REDBYPASSEN		__BIT(6)
#define AWIN_MP_ROPCTL_ROP_GREENBYPASSEN	__BIT(5)
#define AWIN_MP_ROPCTL_ROP_BLUEBYPSASEN		__BIT(4)
#define AWIN_MP_ROPCTL_ROP_MOD			__BIT(0)

#define AWIN_MP_ROPIDXxCTL_CH2IGN_EN		__BIT(18)
#define AWIN_MP_ROPIDXxCTL_CH1IGN_EN		__BIT(17)
#define AWIN_MP_ROPIDXxCTL_CH0IGN_EN		__BIT(16)
#define AWIN_MP_ROPIDXxCTL_NOD7_CTL		__BIT(15)
#define AWIN_MP_ROPIDXxCTL_NOD6_CTL		__BITS(14,11)
#define AWIN_MP_ROPIDXxCTL_NOD5_CTL		__BIT(10)
#define AWIN_MP_ROPIDXxCTL_NOD4_CTL		__BITS(9,6)
#define AWIN_MP_ROPIDXxCTL_NOD3_CTL		__BIT(5)
#define AWIN_MP_ROPIDXxCTL_NOD2_CTL		__BIT(4)
#define AWIN_MP_ROPIDXxCTL_NOD1_CTL		__BIT(3)
#define AWIN_MP_ROPIDXxCTL_NOD0_CTL		__BITS(2,0)

#define AWIN_MP_ALPHACKCTL_CH3GALPHA		__BITS(31,24)
#define AWIN_MP_ALPHACKCTL_ROPGALPHA		__BITS(23,16)
#define AWIN_MP_ALPHACKCTL_CH3ALPHACTL		__BITS(15,14)
#define AWIN_MP_ALPHACKCTL_ROPALPHACTL		__BITS(13,12)
#define AWIN_MP_ALPHACKCTL_CK_REDCON		__BIT(10)
#define AWIN_MP_ALPHACKCTL_CK_GREENCON		__BIT(9)
#define AWIN_MP_ALPHACKCTL_CK_BLUECON		__BIT(8)
#define AWIN_MP_ALPHACKCTL_ICH3_PREMUL		__BIT(7)
#define AWIN_MP_ALPHACKCTL_IROP_PREMUL		__BIT(6)
#define AWIN_MP_ALPHACKCTL_O_PREMUL		__BIT(5)
#define AWIN_MP_ALPHACKCTL_PRI			__BIT(4)
#define AWIN_MP_ALPHACKCTL_ALPHACK_MOD		__BITS(2,1)
#define AWIN_MP_ALPHACKCTL_ALPHACK_EN		__BIT(0)

#define AWIN_MP_CSC2CTL_CSC2_EN			__BIT(0)

#define AWIN_MP_OUTCTL_OUT_PS			__BITS(11,8)
#define AWIN_MP_OUTCTL_RND_EN			__BIT(7)
#define AWIN_MP_OUTCTL_OUT_FMT			__BITS(3,0)
#define AWIN_MP_OUTCTL_OUT_FMT_ARGB8888		0
#define AWIN_MP_OUTCTL_OUT_FMT_ARGB4444		1
#define AWIN_MP_OUTCTL_OUT_FMT_ARGB1555		2
#define AWIN_MP_OUTCTL_OUT_FMT_RGB565		3
#define AWIN_MP_OUTCTL_OUT_FMT_IYUV422		4
#define AWIN_MP_OUTCTL_OUT_FMT_YUV422_UVC	5
#define AWIN_MP_OUTCTL_OUT_FMT_YUV422		6
#define AWIN_MP_OUTCTL_OUT_FMT_8BPP_M		7
#define AWIN_MP_OUTCTL_OUT_FMT_4BPP_M		8
#define AWIN_MP_OUTCTL_OUT_FMT_2BPP_M		9
#define AWIN_MP_OUTCTL_OUT_FMT_1BPP_M		10
#define AWIN_MP_OUTCTL_OUT_FMT_YUV420_UVC	11
#define AWIN_MP_OUTCTL_OUT_FMT_YUV420		12
#define AWIN_MP_OUTCTL_OUT_FMT_YUV411_UVC	13
#define AWIN_MP_OUTCTL_OUT_FMT_YUV411		14

#define AWIN_MP_OUTSIZE_OUT_HEIGHT		__BITS(28,16)
#define AWIN_MP_OUTSIZE_OUT_WIDTH		__BITS(12,0)

#define AWIN_MP_OUTH4ADD_OUTCH2_H4ADD		__BITS(19,16)
#define AWIN_MP_OUTH4ADD_OUTCH1_H4ADD		__BITS(11,8)
#define AWIN_MP_OUTH4ADD_OUTCH0_H4ADD		__BITS(3,0)

#define AWIN_MP_OUTALPHACTL_IMG_ALPHA		__BITS(31,24)
#define AWIN_MP_OUTALPHACTL_NONIMG_ALPHA	__BITS(23,16)
#define AWIN_MP_OUTALPHACTL_A2ALPHACTL		__BITS(7,6)
#define AWIN_MP_OUTALPHACTL_A3ALPHACTL		__BITS(5,4)
#define AWIN_MP_OUTALPHACTL_A1ALPHACTL		__BITS(3,2)
#define AWIN_MP_OUTALPHACTL_A0ALPHACTL		__BITS(1,0)

#define AWIN_MP_MBCTL_Y_OFFSET			__BITS(31,16)
#define AWIN_MP_MBCTL_X_OFFSET			__BITS(15,0)

#define AWIN_MP_CMDQUECTL_FINISHIRQ_EN		__BIT(8)
#define AWIN_MP_CMDQUECTL_START_CTL		__BIT(1)
#define AWIN_MP_CMDQUECTL_EN			__BIT(0)

#define AWIN_MP_CMDQUESTS_BUSY_FLAG		__BIT(12)
#define AWIN_MP_CMDQUESTS_FINISHIRQ_FLAG	__BIT(8)

/*
 * TVE registers
 */

#define AWIN_TVE_ENABLE			0x00000000
#define AWIN_TVE_CONFIG			0x00000004
#define AWIN_TVE_DAC_1			0x00000008
#define AWIN_TVE_NOTCH			0x0000000c
#define AWIN_TVE_CHROMA			0x00000010
#define AWIN_TVE_PORCH			0x00000014
#define AWIN_TVE_VSYNC			0x00000018
#define AWIN_TVE_LINENUMBER		0x0000001C
#define AWIN_TVE_LEVEL			0x00000020
#define AWIN_TVE_DAC_2			0x00000024
#define AWIN_TVE_AUTODETECT_E		0x00000030
#define AWIN_TVE_AUTODETECT_INTR	0x00000034
#define AWIN_TVE_AUTODETECT_STATUS	0x00000038
#define AWIN_TVE_AUTODETECT_DEBOUNCE	0x0000003C
#define AWIN_TVE_CSC_1			0x00000040
#define AWIN_TVE_CSC_2			0x00000044
#define AWIN_TVE_CSC_3			0x00000048
#define AWIN_TVE_CSC_4			0x0000004C
#define AWIN_TVE_COLOR_BURST		0x00000100
#define AWIN_TVE_VSYNC_NUMBER		0x00000104
#define AWIN_TVE_NOTCH_FREQ		0x00000108
#define AWIN_TVE_CBCR			0x0000010C
#define AWIN_TVE_TINT			0x00000110
#define AWIN_TVE_BURST_WIDTH		0x00000114
#define AWIN_TVE_CBCR_GAIN		0x00000118
#define AWIN_TVE_SYNC_VBI		0x0000011C
#define AWIN_TVE_WHITE_LEVEL		0x00000120
#define AWIN_TVE_ACTIVE_LINE		0x00000124
#define AWIN_TVE_CHROMA_COMPGAIN	0x00000128
#define AWIN_TVE_TVENC			0x0000012C
#define AWIN_TVE_RESYNC			0x00000130
#define AWIN_TVE_SLAVE_PARAM		0x00000134
#define AWIN_TVE_CONFIG_2		0x00000138
#define AWIN_TVE_CONFIG_3		0x0000013C

/* AWIN_TVE_ENABLE */
#define AWIN_TVE_CLOCK_GATE_DISABLE	__BIT(31)
#define AWIN_TVE_EN			__BIT(0)

/*
 * A31 registers
 */
#define AWIN_A31_USB0_OFFSET		0x00019000	/* OTG */
#define AWIN_A31_USB1_OFFSET		0x0001a000	/* EHCI0/OHCI0 */
#define AWIN_A31_USB2_OFFSET		0x0001b000	/* EHCI1/OHCI1 */
#define AWIN_A31_USB3_OFFSET		0x0001c000	/* OHCI2 */
#define AWIN_A31_GMAC_OFFSET		0x00030000	/* GMAC */
#define AWIN_A31_RTC_OFFSET		0x00300000	/* RTC */
#define AWIN_A31_PRCM_OFFSET		0x00301400	/* PRCM */
#define AWIN_A31_CPUCFG_OFFSET		0x00301C00
#define AWIN_A31_CIR_OFFSET		0x00302000	/* CIR */
#define AWIN_A31_CPUPIO_OFFSET		0x00302c00	/* CPUs-PORT */
#define AWIN_A31_P2WI_OFFSET		0x00303400	/* P2WI */

#define AWIN_A31_PRCM_APB0_GATING_REG		0x0028
#define AWIN_A31_PRCM_CIR_CLK_REG		0x0054
#define AWIN_A31_PRCM_APB0_RESET_REG		0x00B0
#define AWIN_A31_PRCM_PWROFF_GATING_REG		0x0100
#define AWIN_A31_PRCM_CPUX_PWR_CLAMP_REG	0x0140
#define AWIN_A31_PRCM_CPU1_PWR_CLAMP_REG	0x0144
#define AWIN_A31_PRCM_CPU2_PWR_CLAMP_REG	0x0148
#define AWIN_A31_PRCM_CPU3_PWR_CLAMP_REG	0x014C

#define AWIN_A31_CPUCFG_CPU0_RST_CTRL_REG	0x0040
#define AWIN_A31_CPUCFG_CPU0_PWR_CLAMP_STATUS_REG 0x0064
#define AWIN_A31_CPUCFG_RST_CTRL_REG(n)		(0x0040 + (n * 0x40))
#define AWIN_A31_CPUCFG_CTRL_REG(n)		(0x0044 + (n * 0x40))
#define AWIN_A31_CPUCFG_STATUS_REG(n)		(0x0048 + (n * 0x40))
#define AWIN_A31_CPUCFG_PWR_CLAMP_STATUS_REG(n)	(0x0064 + (n * 0x40))

#define AWIN_A31_CPU_AXI_CFG_REG		0x0050

#define AWIN_A31_PLL10_CFG_REG		0x0048
#define AWIN_A31_GMAC_CLK_REG		0x00D0
#define AWIN_A31_AHB_RESET0_REG		0x02C0
#define AWIN_A31_AHB_RESET1_REG		0x02C4
#define AWIN_A31_AHB_RESET2_REG		0x02C8
#define AWIN_A31_APB1_RESET_REG		0x02D0
#define AWIN_A31_APB2_RESET_REG		0x02D8

#define AWIN_A31_PRCM_APB0_GATING_CIR	__BIT(1)

#define AWIN_A31_PRCM_APB0_RESET_CIR	__BIT(1)

#define AWIN_A31_CPUCFG_RST_CTRL_CORE_RESET __BIT(1)
#define AWIN_A31_CPUCFG_RST_CTRL_CPU_RESET __BIT(0)

#define AWIN_A31_PLL2_CFG_LOCK		__BIT(28)
#define AWIN_A31_PLL2_CFG_PLL_SDM_EN	__BIT(24)
#define AWIN_A31_PLL2_CFG_POSTDIV_P	__BITS(19,16)
#define AWIN_A31_PLL2_CFG_FACTOR_N	__BITS(14,8)
#define AWIN_A31_PLL2_CFG_PREVDIV_M	__BITS(4,0)

#define AWIN_A31_PLL3_CFG_MODE		__BIT(30)
#define AWIN_A31_PLL3_CFG_LOCK		__BIT(28)
#define AWIN_A31_PLL3_CFG_FRAC_CLK_OUT	__BIT(25)
#define AWIN_A31_PLL3_CFG_MODE_SEL	__BIT(24)
#define AWIN_A31_PLL3_CFG_SDM_EN	__BIT(20)
#define AWIN_A31_PLL3_CFG_FACTOR_N	__BITS(14,8)
#define AWIN_A31_PLL3_CFG_PREDIV_M	__BITS(3,0)

#define AWIN_A31_PLL6_CFG_LOCK		__BIT(28)

#define AWIN_A31_PLL7_CFG_MODE		__BIT(30)
#define AWIN_A31_PLL7_CFG_LOCK		__BIT(28)
#define AWIN_A31_PLL7_CFG_FRAC_CLK_OUT	__BIT(25)
#define AWIN_A31_PLL7_CFG_MODE_SEL	__BIT(24)
#define AWIN_A31_PLL7_CFG_SDM_EN	__BIT(20)
#define AWIN_A31_PLL7_CFG_FACTOR_N	__BITS(14,8)
#define AWIN_A31_PLL7_CFG_PREDIV_M	__BITS(3,0)

#define AWIN_A31_PLL10_CFG_MODE		__BIT(30)
#define AWIN_A31_PLL10_CFG_LOCK		__BIT(28)
#define AWIN_A31_PLL10_CFG_FRAC_CLK_OUT	__BIT(25)
#define AWIN_A31_PLL10_CFG_MODE_SEL	__BIT(24)
#define AWIN_A31_PLL10_CFG_SDM_EN	__BIT(20)
#define AWIN_A31_PLL10_CFG_FACTOR_N	__BITS(14,8)
#define AWIN_A31_PLL10_CFG_PREDIV_M	__BITS(3,0)

#define AWIN_A31_AHB_GATING0_USB_OHCI2	__BIT(31)
#define AWIN_A31_AHB_GATING0_USB_OHCI1	__BIT(30)
#define AWIN_A31_AHB_GATING0_USB_OHCI2	__BIT(31)
#define AWIN_A31_AHB_GATING0_USB_OHCI1	__BIT(30)
#define AWIN_A31_AHB_GATING0_USB_OHCI0	__BIT(29)
#define AWIN_A31_AHB_GATING0_USB_EHCI1	__BIT(27)
#define AWIN_A31_AHB_GATING0_USB_EHCI0	__BIT(26)
#define AWIN_A31_AHB_GATING0_USB0	__BIT(24)
#define AWIN_A31_AHB_GATING0_GMAC	__BIT(17)

#define AWIN_A31_USB_CLK_OHCI2_ENABLE	__BIT(18)
#define AWIN_A31_USB_CLK_OHCI1_ENABLE	__BIT(17)
#define AWIN_A31_USB_CLK_OHCI0_ENABLE	__BIT(16)
#define AWIN_A31_USB_CLK_USBPHY2_ENABLE	__BIT(10)
#define AWIN_A31_USB_CLK_USBPHY1_ENABLE	__BIT(9)
#define AWIN_A31_USB_CLK_USBPHY0_ENABLE	__BIT(8)
#define AWIN_A31_USB_CLK_PHY2_ENABLE	__BIT(2)
#define AWIN_A31_USB_CLK_PHY1_ENABLE	__BIT(1)
#define AWIN_A31_USB_CLK_PHY0_ENABLE	__BIT(0)

#define AWIN_A31_HDMI_CLK_DDC_GATING	__BIT(30)

#define AWIN_A31_AHB_RESET0_USBOHCI2_RST	__BIT(31)
#define AWIN_A31_AHB_RESET0_USBOHCI1_RST	__BIT(30)
#define AWIN_A31_AHB_RESET0_USBOHCI0_RST	__BIT(29)
#define AWIN_A31_AHB_RESET0_USBEHCI1_RST	__BIT(27)
#define AWIN_A31_AHB_RESET0_USBEHCI0_RST	__BIT(26)
#define AWIN_A31_AHB_RESET0_USBOTG_RST		__BIT(24)
#define AWIN_A31_AHB_RESET0_SPI3_RST		__BIT(23)
#define AWIN_A31_AHB_RESET0_SPI2_RST		__BIT(22)
#define AWIN_A31_AHB_RESET0_SPI1_RST		__BIT(21)
#define AWIN_A31_AHB_RESET0_SPI0_RST		__BIT(20)
#define AWIN_A31_AHB_RESET0_HSTMR_RST		__BIT(19)
#define AWIN_A31_AHB_RESET0_TS_RST		__BIT(18)
#define AWIN_A31_AHB_RESET0_GMAC_RST		__BIT(17)
#define AWIN_A31_AHB_RESET0_SDRAM_RST		__BIT(14)
#define AWIN_A31_AHB_RESET0_NAND0_RST		__BIT(13)
#define AWIN_A31_AHB_RESET0_NAND1_RST		__BIT(12)
#define AWIN_A31_AHB_RESET0_SD3_RST		__BIT(11)
#define AWIN_A31_AHB_RESET0_SD2_RST		__BIT(10)
#define AWIN_A31_AHB_RESET0_SD1_RST		__BIT(9)
#define AWIN_A31_AHB_RESET0_SD0_RST		__BIT(8)
#define AWIN_A31_AHB_RESET0_DMA_RST		__BIT(6)
#define AWIN_A31_AHB_RESET0_SS_RST		__BIT(5)
#define AWIN_A31_AHB_RESET0_MIPIDSI_RST		__BIT(1)

#define AWIN_A31_AHB_RESET1_DRC1_RST		__BIT(26)
#define AWIN_A31_AHB_RESET1_DRC0_RST		__BIT(25)
#define AWIN_A31_AHB_RESET1_DEU1_RST		__BIT(24)
#define AWIN_A31_AHB_RESET1_DEU0_RST		__BIT(23)
#define AWIN_A31_AHB_RESET1_GPU_RST		__BIT(20)
#define AWIN_A31_AHB_RESET1_MP_RST		__BIT(18)
#define AWIN_A31_AHB_RESET1_FE1_RST		__BIT(15)
#define AWIN_A31_AHB_RESET1_FE0_RST		__BIT(14)
#define AWIN_A31_AHB_RESET1_BE1_RST		__BIT(13)
#define AWIN_A31_AHB_RESET1_BE0_RST		__BIT(12)
#define AWIN_A31_AHB_RESET1_HDMI_RST		__BIT(11)
#define AWIN_A31_AHB_RESET1_CSI_RST		__BIT(8)
#define AWIN_A31_AHB_RESET1_LCD1_RST		__BIT(5)
#define AWIN_A31_AHB_RESET1_LCD0_RST		__BIT(4)
#define AWIN_A31_AHB_RESET1_VE_RST		__BIT(0)

#define AWIN_A31_APB1_RESET_DAUDIO1_RST		__BIT(13)
#define AWIN_A31_APB1_RESET_DAUDIO0_RST		__BIT(12)
#define AWIN_A31_APB1_RESET_DIGITAL_MIC_RST	__BIT(4)
#define AWIN_A31_APB1_RESET_CODEC_RST		__BIT(0)

#define AWIN_A31_APB2_RESET_UART5_RST		__BIT(21)
#define AWIN_A31_APB2_RESET_UART4_RST		__BIT(20)
#define AWIN_A31_APB2_RESET_UART3_RST		__BIT(19)
#define AWIN_A31_APB2_RESET_UART2_RST		__BIT(18)
#define AWIN_A31_APB2_RESET_UART1_RST		__BIT(17)
#define AWIN_A31_APB2_RESET_UART0_RST		__BIT(16)

#define AWIN_A31_APB2_RESET_TWI3_RST		__BIT(3)
#define AWIN_A31_APB2_RESET_TWI2_RST		__BIT(2)
#define AWIN_A31_APB2_RESET_TWI1_RST		__BIT(1)
#define AWIN_A31_APB2_RESET_TWI0_RST		__BIT(0)

#define AWIN_A31_WDOG1_IRQ_EN_REG		0x00A0
#define AWIN_A31_WDOG1_IRQ_STA_REG		0x00A4
#define AWIN_A31_WDOG1_CTRL_REG			0x00B0
#define AWIN_A31_WDOG1_CFG_REG			0x00B4
#define AWIN_A31_WDOG1_MODE_REG			0x00B8

#define AWIN_A31_WDOG_CFG_CONFIG		__BITS(1,0)
#define AWIN_A31_WDOG_CFG_CONFIG_SYS		1
#define AWIN_A31_WDOG_CFG_CONFIG_INT		2

#define AWIN_A31_WDOG_MODE_EN			__BIT(0)
#define AWIN_A31_WDOG_MODE_INTV			__BITS(7,4)

#define AWIN_A31_MMC_FIFO			0x0200

#define AWIN_A31_LOSC_CTRL_REG			0x0000
#define AWIN_A31_RTC_YY_MM_DD_REG		0x0010
#define AWIN_A31_RTC_HH_MM_SS_REG		0x0014

#define AWIN_A31_P2WI_CTRL_REG			0x0000
#define AWIN_A31_P2WI_CCR_REG			0x0004
#define AWIN_A31_P2WI_INTE_REG			0x0008
#define AWIN_A31_P2WI_STAT_REG			0x000c
#define AWIN_A31_P2WI_DADDR0_REG		0x0010
#define AWIN_A31_P2WI_DADDR1_REG		0x0014
#define AWIN_A31_P2WI_DLEN_REG			0x0018
#define AWIN_A31_P2WI_DATA0_REG			0x001c
#define AWIN_A31_P2WI_DATA1_REG			0x0020
#define AWIN_A31_P2WI_LCR_REG			0x0024
#define AWIN_A31_P2WI_PMCR_REG			0x0028

#define AWIN_A31_P2WI_CTRL_START_TRANS		__BIT(7)
#define AWIN_A31_P2WI_CTRL_ABORT_TRANS		__BIT(6)
#define AWIN_A31_P2WI_CTRL_GLOBAL_INT_ENB	__BIT(1)
#define AWIN_A31_P2WI_CTRL_SOFT_RESET		__BIT(0)

#define AWIN_A31_P2WI_CCR_SDA_ODLY		__BITS(10,8)
#define AWIN_A31_P2WI_CCR_CLK_DIV		__BITS(7,0)

#define AWIN_A31_P2WI_INTE_LOAD_BSY_ENB		__BIT(2)
#define AWIN_A31_P2WI_INTE_TRANS_ERR_ENB	__BIT(1)
#define AWIN_A31_P2WI_INTE_TRANS_OVER_ENB	__BIT(0)

#define AWIN_A31_P2WI_STAT_TRANS_ERR_ID		__BITS(15,8)
#define AWIN_A31_P2WI_STAT_LOAD_BSY		__BIT(2)
#define AWIN_A31_P2WI_STAT_TRANS_ERR		__BIT(1)
#define AWIN_A31_P2WI_STAT_TRANS_OVER		__BIT(0)
#define AWIN_A31_P2WI_STAT_MASK		\
	(AWIN_A31_P2WI_STAT_LOAD_BSY |	\
	 AWIN_A31_P2WI_STAT_TRANS_ERR |	\
	 AWIN_A31_P2WI_STAT_TRANS_OVER)

#define AWIN_A31_P2WI_DLEN_READ_WRITE_FLAG	__BIT(4)
#define AWIN_A31_P2WI_DLEN_ACCESS_LENGTH	__BITS(2,0)

#define AWIN_A31_P2WI_LCR_SCL_STATE		__BIT(5)
#define AWIN_A31_P2WI_LCR_SDA_STATE		__BIT(4)
#define AWIN_A31_P2WI_LCR_SCL_CTL		__BIT(3)
#define AWIN_A31_P2WI_LCR_SCL_CTL_EN		__BIT(2)
#define AWIN_A31_P2WI_LCR_SDA_CTL		__BIT(1)
#define AWIN_A31_P2WI_LCR_SDA_CTL_EN		__BIT(0)

#define AWIN_A31_P2WI_PMCR_PMU_INIT_SEND	__BIT(31)
#define AWIN_A31_P2WI_PMCR_PMU_INIT_DATA	__BITS(23,16)
#define AWIN_A31_P2WI_PMCR_PMU_MODE_CTRL_REG_ADDR __BITS(15,8)
#define AWIN_A31_P2WI_PMCR_PMU_DEVICE_ADDR	__BITS(7,0)

#define AWIN_A31_DMA_IRQ_EN_REG0_REG		0x0000
#define AWIN_A31_DMA_IRQ_EN_REG1_REG		0x0004
#define AWIN_A31_DMA_IRQ_PEND_REG0_REG		0x0010
#define AWIN_A31_DMA_IRQ_PEND_REG1_REG		0x0014
#define AWIN_A31_DMA_STA_REG			0x0030
#define AWIN_A31_DMA_EN_REG(n)			(0x0100 + (n) * 0x40 + 0x00)
#define AWIN_A31_DMA_PAU_REG(n)			(0x0100 + (n) * 0x40 + 0x04)
#define AWIN_A31_DMA_START_ADDR_REG(n)		(0x0100 + (n) * 0x40 + 0x08)
#define AWIN_A31_DMA_CFG_REG(n)			(0x0100 + (n) * 0x40 + 0x0C)
#define AWIN_A31_DMA_CUR_SRC_REG(n)		(0x0100 + (n) * 0x40 + 0x10)
#define AWIN_A31_DMA_CUR_DEST_REG(n)		(0x0100 + (n) * 0x40 + 0x14)
#define AWIN_A31_DMA_BCNT_LEFT_REG(n)		(0x0100 + (n) * 0x40 + 0x18)
#define AWIN_A31_DMA_PARA_REG(n)		(0x0100 + (n) * 0x40 + 0x1C)

#define AWIN_A31_DMA_IRQ_EN_REG0_QUEUE_IRQ_EN(n) __BIT(n * 4 + 2)
#define AWIN_A31_DMA_IRQ_EN_REG0_PKG_IRQ_EN(n)	__BIT(n * 4 + 1)
#define AWIN_A31_DMA_IRQ_EN_REG0_HLAF_IRQ_EN(n)	__BIT(n * 4 + 0)

#define AWIN_A31_DMA_IRQ_EN_REG1_QUEUE_IRQ_EN(n) __BIT((n - 8) * 4 + 2)
#define AWIN_A31_DMA_IRQ_EN_REG1_PKG_IRQ_EN(n)	__BIT((n - 8) * 4 + 1)
#define AWIN_A31_DMA_IRQ_EN_REG1_HLAF_IRQ_EN(n)	__BIT((n - 8) * 4 + 0)

#define AWIN_A31_DMA_IRQ_QUEUE_MASK		0x4444444444444444ULL
#define AWIN_A31_DMA_IRQ_PKG_MASK		0x2222222222222222ULL
#define AWIN_A31_DMA_IRQ_HF_MASK		0x1111111111111111ULL

#define AWIN_A31_DMA_EN_EN			__BIT(0)

#define AWIN_A31_DMA_PAU_PAUSE			__BIT(0)

#define AWIN_A31_DMA_CFG_DEST_DATA_WIDTH	__BITS(26,25)
#define AWIN_A31_DMA_CFG_DEST_BST_LEN		__BITS(24,23)
#define AWIN_A31_DMA_CFG_DEST_ADDR_MODE		__BITS(22,21)
#define AWIN_A31_DMA_CFG_DEST_DRQ_TYPE		__BITS(20,16)
#define AWIN_A31_DMA_CFG_SRC_DATA_WIDTH		__BITS(10,9)
#define AWIN_A31_DMA_CFG_SRC_BST_LEN		__BITS(8,7)
#define AWIN_A31_DMA_CFG_SRC_ADDR_MODE		__BITS(6,5)
#define AWIN_A31_DMA_CFG_SRC_DRQ_TYPE		__BITS(4,0)

#define AWIN_A31_DMA_PARA_DATA_BLK_SIZE		__BITS(15,8)
#define AWIN_A31_DMA_PARA_WAIT_CYC		__BITS(7,0)

#define AWIN_A31_DMA_CFG_DATA_WIDTH_8		0
#define AWIN_A31_DMA_CFG_DATA_WIDTH_16		1
#define AWIN_A31_DMA_CFG_DATA_WIDTH_32		2

#define AWIN_A31_DMA_CFG_BST_LEN_1		0
#define AWIN_A31_DMA_CFG_BST_LEN_8		1

#define AWIN_A31_DMA_CFG_ADDR_MODE_LINEAR	0
#define AWIN_A31_DMA_CFG_ADDR_MODE_IO		1

#define AWIN_A31_DMA_DRQ_TYPE_SRAM		0
#define AWIN_A31_DMA_DRQ_TYPE_SDRAM		1
#define AWIN_A31_DMA_DRQ_TYPE_DAUDIO0		3
#define AWIN_A31_DMA_DRQ_TYPE_DAUDIO1		4
#define AWIN_A31_DMA_DRQ_TYPE_NAND0		5
#define AWIN_A31_DMA_DRQ_TYPE_UART0		6
#define AWIN_A31_DMA_DRQ_TYPE_UART1		7
#define AWIN_A31_DMA_DRQ_TYPE_UART2		8
#define AWIN_A31_DMA_DRQ_TYPE_UART3		9
#define AWIN_A31_DMA_DRQ_TYPE_UART4		10
#define AWIN_A31_DMA_DRQ_TYPE_TCON0		11
#define AWIN_A31_DMA_DRQ_TYPE_TCON1		12
#define AWIN_A31_DMA_DRQ_TYPE_HDMIDDC		13
#define AWIN_A31_DMA_DRQ_TYPE_HDMIAUDIO		14
#define AWIN_A31_DMA_DRQ_TYPE_AUDIOCODEC	15
#define AWIN_A31_DMA_DRQ_TYPE_SS		16
#define AWIN_A31_DMA_DRQ_TYPE_OTG_EP1		17
#define AWIN_A31_DMA_DRQ_TYPE_OTG_EP2		18
#define AWIN_A31_DMA_DRQ_TYPE_OTG_EP3		19
#define AWIN_A31_DMA_DRQ_TYPE_OTG_EP4		20
#define AWIN_A31_DMA_DRQ_TYPE_OTG_EP5		21
#define AWIN_A31_DMA_DRQ_TYPE_UART5		22
#define AWIN_A31_DMA_DRQ_TYPE_SPI0		23
#define AWIN_A31_DMA_DRQ_TYPE_SPI1		24
#define AWIN_A31_DMA_DRQ_TYPE_SPI2		25
#define AWIN_A31_DMA_DRQ_TYPE_SPI3		26
#define AWIN_A31_DMA_DRQ_TYPE_TP		27
#define AWIN_A31_DMA_DRQ_TYPE_NAND1		28
#define AWIN_A31_DMA_DRQ_TYPE_DIGITALMIC	30

#if !defined(_LOCORE)
struct awin_a31_dma_desc {
	uint32_t	dma_config;
	uint32_t	dma_srcaddr;
	uint32_t	dma_dstaddr;
	uint32_t	dma_bcnt;
	uint32_t	dma_para;
	uint32_t	dma_next;
#define AWIN_A31_DMA_NULL	0xfffff800
};
#endif

#define AWIN_A31_BEx_CLK_SRC_SEL	__BITS(26,24)
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL3		0
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL7		1
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL6_2X	2
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL8		3
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL9		4
#define AWIN_A31_BEx_CLK_SRC_SEL_PLL10		5

#define AWIN_A31_HDMI_DDC_CTRL_REG		0x0500
#define AWIN_A31_HDMI_DDC_EXCTRL_REG		0x0504
#define AWIN_A31_HDMI_DDC_COMMAND_REG		0x0508
#define AWIN_A31_HDMI_DDC_SLAVE_ADDR_REG	0x050c
#define AWIN_A31_HDMI_DDC_INT_MASK_REG		0x0510
#define AWIN_A31_HDMI_DDC_INT_STATUS_REG	0x0514
#define AWIN_A31_HDMI_DDC_FIFO_CTRL_REG		0x0518
#define AWIN_A31_HDMI_DDC_FIFO_STATUS_REG	0x051c
#define AWIN_A31_HDMI_DDC_CLOCK_REG		0x0520
#define AWIN_A31_HDMI_DDC_TIMEOUT_REG		0x0524
#define AWIN_A31_HDMI_DDC_FIFO_ACCESS_REG	0x0580

#define AWIN_A31_HDMI_DDC_CTRL_SW_RST		__BIT(31)
#define AWIN_A31_HDMI_DDC_CTRL_ACCESS_CMD_START __BIT(27)
#define AWIN_A31_HDMI_DDC_CTRL_SDA_PAD_PULLDOWN	__BIT(7)
#define AWIN_A31_HDMI_DDC_CTRL_SDA_PAD_EN	__BIT(6)
#define AWIN_A31_HDMI_DDC_CTRL_SCL_PAD_PULLDOWN	__BIT(5)
#define AWIN_A31_HDMI_DDC_CTRL_SCL_PAD_EN	__BIT(4)
#define AWIN_A31_HDMI_DDC_CTRL_EN		__BIT(0)

#define AWIN_A31_HDMI_DDC_EXCTRL_BUS_BUSY	__BIT(10)
#define AWIN_A31_HDMI_DDC_EXCTRL_SCL_STATUS	__BIT(9)
#define AWIN_A31_HDMI_DDC_EXCTRL_SDA_STATUS	__BIT(8)
#define AWIN_A31_HDMI_DDC_EXCTRL_SEGMENT_SEL	__BIT(7)
#define AWIN_A31_HDMI_DDC_EXCTRL_SEGMENT0_DET	__BIT(6)
#define AWIN_A31_HDMI_DDC_EXCTRL_INIT_SEQ_MODE	__BIT(5)
#define AWIN_A31_HDMI_DDC_EXCTRL_INIT_SEQ_EN	__BIT(4)
#define AWIN_A31_HDMI_DDC_EXCTRL_SW_SCL		__BIT(3)
#define AWIN_A31_HDMI_DDC_EXCTRL_SW_SCL_EN	__BIT(2)
#define AWIN_A31_HDMI_DDC_EXCTRL_SW_SDA		__BIT(1)
#define AWIN_A31_HDMI_DDC_EXCTRL_SW_SDA_EN	__BIT(0)

#define AWIN_A31_HDMI_DDC_COMMAND_DTC		__BITS(25,16)
#define AWIN_A31_HDMI_DDC_COMMAND_CMD		__BITS(2,0)

#define AWIN_A31_HDMI_DDC_FIFO_CTRL_RST		__BIT(15)

#define AWIN_A31_HDMI_DDC_SLAVE_ADDR_SEG_PTR	__BITS(31,24)
#define AWIN_A31_HDMI_DDC_SLAVE_ADDR_DDC_CMD	__BITS(23,16)
#define AWIN_A31_HDMI_DDC_SLAVE_ADDR_OFF_ADR	__BITS(15,8)
#define AWIN_A31_HDMI_DDC_SLAVE_ADDR_DEV_ADR	__BITS(7,1)

#define AWIN_A31_PIO_PA_PINS		28
#define AWIN_A31_PIO_PA_GMAC_FUNC	2
#define AWIN_A31_PIO_PA_GMAC_PINS	0x0e187e0f /* PA pins 27-25,20-19,14-9,3-0 */

#define AWIN_A31_PIO_PB_PINS		8
#define AWIN_A31_PIO_PB_TWI3_FUNC	2
#define AWIN_A31_PIO_PB_TWI3_PINS	0x00000060 /* PB pins 6-5 */

#define AWIN_A31_PIO_PC_PINS		28

#define AWIN_A31_PIO_PD_PINS		28

#define AWIN_A31_PIO_PE_PINS		17

#define AWIN_A31_PIO_PF_PINS		6
#define AWIN_A31_PIO_PF_SDMMC0_FUNC	2
#define AWIN_A31_PIO_PF_SDMMC0_PINS	0x0000003f /* PF pins 5-0 */

#define AWIN_A31_PIO_PG_PINS		19
#define AWIN_A31_PIO_PG_SDMMC1_FUNC	2
#define AWIN_A31_PIO_PG_SDMMC1_PINS	0x0000003f /* PG pins 5-0 */

#define AWIN_A31_PIO_PH_PINS		31
#define AWIN_A31_PIO_PH_UART0_FUNC	2
#define AWIN_A31_PIO_PH_UART0_PINS	0x00300000 /* PH pins 21-20 */
#define AWIN_A31_PIO_PH_TWI0_FUNC	2
#define AWIN_A31_PIO_PH_TWI0_PINS	0x0000c000 /* PH pins 15-14 */
#define AWIN_A31_PIO_PH_TWI1_FUNC	2
#define AWIN_A31_PIO_PH_TWI1_PINS	0x00030000 /* PH pins 17-16 */
#define AWIN_A31_PIO_PH_TWI2_FUNC	2
#define AWIN_A31_PIO_PH_TWI2_PINS	0x000c0000 /* PH pins 19-18 */

#define AWIN_A31_PIO_PL_PINS		9
#define AWIN_A31_PIO_PL_IR_FUNC		2
#define AWIN_A31_PIO_PL_IR_PINS		0x00000010 /* PL pin 4 */

#define AWIN_A31_PIO_PM_PINS		8

/*
 * A80 registers
 */
#define AWIN_A80_GIC_BASE		0x01c40000

/*
 * These offsets are relative to AWIN_CORE_PBASE
 */
#define AWIN_A80_SDMMC_COMM_OFFSET	0x00013000
#define AWIN_A80_DE_BE0_OFFSET		0x01600000
#define AWIN_A80_DE_BE1_OFFSET		0x01640000
#define AWIN_A80_DE_BE2_OFFSET		0x01680000
#define AWIN_A80_LCD0_OFFSET		0x02000000
#define AWIN_A80_HDMI_OFFSET		0x02100000
#define AWIN_A80_CCU_OFFSET		0x04400000
#define AWIN_A80_CCU_SCLK_OFFSET	0x04400400
#define AWIN_A80_PIO_OFFSET		0x04400800
#define AWIN_A80_TIMER_OFFSET		0x04400c00
#define AWIN_A80_PWM_OFFSET		0x04401400
#define AWIN_A80_KEYADC_OFFSET		0x04401800
#define AWIN_A80_SMTA_OFFSET		0x04403400
#define AWIN_A80_GPADC_OFFSET		0x04404c00
#define AWIN_A80_UART0_OFFSET		0x05400000
#define AWIN_A80_UART1_OFFSET		0x05400400
#define AWIN_A80_UART2_OFFSET		0x05400800
#define AWIN_A80_UART3_OFFSET		0x05400c00
#define AWIN_A80_UART4_OFFSET		0x05401000
#define AWIN_A80_UART5_OFFSET		0x05401400
#define AWIN_A80_TWI0_OFFSET		0x05402800
#define AWIN_A80_TWI1_OFFSET		0x05402c00
#define AWIN_A80_TWI2_OFFSET		0x05403000
#define AWIN_A80_TWI3_OFFSET		0x05403400
#define AWIN_A80_TWI4_OFFSET		0x05403800

/*
 * These offsets are relative to AWIN_A80_USB_PBASE
 */
#define AWIN_A80_USB0_OFFSET		0x00000000
#define AWIN_A80_USB1_OFFSET		0x00001000
#define AWIN_A80_USB2_OFFSET		0x00002000
#define AWIN_A80_USBPHY_OFFSET		0x00008000

/*
 * These offsets are relative to AWIN_A80_CORE2_PBASE
 */
#define AWIN_A80_SYS_CTRL_OFFSET	0x00000000
#define AWIN_A80_DMA_OFFSET		0x00002000
#define AWIN_A80_GMAC_OFFSET		0x00030000

/*
 * These offsets are relative to AWIN_A80_RCPUS_PBASE
 */
#define AWIN_A80_RPRCM_OFFSET		0x00001400
#define AWIN_A80_CIR_OFFSET		0x00002000
#define AWIN_A80_RPIO_OFFSET		0x00002c00
#define AWIN_A80_RSB_OFFSET		0x00003400
#define AWIN_A80_DAUDIO1_OFFSET		0x00006000

#define AWIN_A80_SDMMC_COMM_SDC_RESET_SW	__BIT(18)
#define AWIN_A80_SDMMC_COMM_SDC_CLOCK_SW	__BIT(16)

#define AWIN_A80_CCU_PLL_C0CPUX_CTRL_REG	0x0000
#define AWIN_A80_CCU_PLL_C1CPUX_CTRL_REG	0x0004
#define AWIN_A80_CCU_PLL_AUDIO_CTRL_REG		0x0008
#define AWIN_A80_CCU_PLL_PERIPH0_CTRL_REG	0x000c
#define AWIN_A80_CCU_PLL_VE_CTRL_REG		0x0010
#define AWIN_A80_CCU_PLL_DDR_CTRL_REG		0x0014
#define AWIN_A80_CCU_PLL_VIDEO0_CTRL_REG	0x0018
#define AWIN_A80_CCU_PLL_VIDEO1_CTRL_REG	0x001c
#define AWIN_A80_CCU_PLL_GPU_CTRL_REG		0x0020
#define AWIN_A80_CCU_PLL_DE_CTRL_REG		0x0024
#define AWIN_A80_CCU_PLL_ISP_CTRL_REG		0x0028
#define AWIN_A80_CCU_PLL_PERIPH1_CTRL_REG	0x002c

#define AWIN_A80_CCU_PLL_CxCPUX_ENABLE		__BIT(31)
#define AWIN_A80_CCU_PLL_CxCPUX_LOCK_TIME	__BITS(26,24)
#define AWIN_A80_CCU_PLL_CxCPUX_OUT_EXT_DIVP	__BIT(16)
#define AWIN_A80_CCU_PLL_CxCPUX_FACTOR_N	__BITS(15,8)
#define AWIN_A80_CCU_PLL_CxCPUX_POSTDIV_M	__BITS(1,0)

#define AWIN_A80_CCU_PLL_AUDIO_ENABLE		__BIT(31)
#define AWIN_A80_CCU_PLL_AUDIO_SDM_ENABLE	__BIT(24)
#define AWIN_A80_CCU_PLL_AUDIO_OUTPUT_DIV	__BIT(18)
#define AWIN_A80_CCU_PLL_AUDIO_INPUT_DIV	__BIT(16)
#define AWIN_A80_CCU_PLL_AUDIO_FACTOR_N		__BITS(15,8)
#define AWIN_A80_CCU_PLL_AUDIO_POSTDIV_P	__BITS(5,0)

#define AWIN_A80_CCU_PLL_PERIPH0_ENABLE		__BIT(31)
#define AWIN_A80_CCU_PLL_PERIPH0_SDM_ENABLE	__BIT(24)
#define AWIN_A80_CCU_PLL_PERIPH0_OUTPUT_DIV	__BIT(18)
#define AWIN_A80_CCU_PLL_PERIPH0_INPUT_DIV	__BIT(16)
#define AWIN_A80_CCU_PLL_PERIPH0_FACTOR_N	__BITS(15,8)

#define AWIN_A80_CCU_SCLK_SDMMC0_CLK_REG	0x0010
#define AWIN_A80_CCU_SCLK_SDMMC1_CLK_REG	0x0014
#define AWIN_A80_CCU_SCLK_SDMMC2_CLK_REG	0x0018
#define AWIN_A80_CCU_SCLK_SDMMC3_CLK_REG	0x001c

#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING0_REG	0x0180
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING1_REG	0x0184
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING2_REG	0x0188
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING3_REG	0x0190
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_REG	0x0194

#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST0_REG	0x01a0
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST1_REG	0x01a4
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST2_REG	0x01a8
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST3_REG	0x01b0
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_REG	0x01b4

#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING0_SD	__BIT(8)

#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING1_DMA	__BIT(24)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING1_GMAC	__BIT(17)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING1_USB_HOST __BIT(1)

#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART5	__BIT(21)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART4	__BIT(20)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART3	__BIT(19)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART2	__BIT(18)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART1	__BIT(17)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_UART0	__BIT(16)

#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_TWI4	__BIT(4)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_TWI2	__BIT(3)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_TWI3	__BIT(2)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_TWI1	__BIT(1)
#define AWIN_A80_CCU_SCLK_BUS_CLK_GATING4_TWI0	__BIT(0)

#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST0_SD	__BIT(8)

#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST1_DMA	__BIT(24)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST1_GMAC	__BIT(17)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST1_USB_DRD	__BIT(1)

#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART5	__BIT(21)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART4	__BIT(20)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART3	__BIT(19)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART2	__BIT(18)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART1	__BIT(17)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_UART0	__BIT(16)

#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_TWI4	__BIT(4)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_TWI3	__BIT(3)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_TWI2	__BIT(2)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_TWI1	__BIT(1)
#define AWIN_A80_CCU_SCLK_BUS_SOFT_RST4_TWI0	__BIT(0)

#define AWIN_A80_CCU_SCLK_SDMMC_SCLK_GATING	__BIT(31)
#define AWIN_A80_CCU_SCLK_SDMMC_CLK_SRC_SEL	__BITS(27,24)
#define AWIN_A80_CCU_SCLK_SDMMC_CLK_SRC_SEL_OSC24M	0
#define AWIN_A80_CCU_SCLK_SDMMC_CLK_SRC_SEL_PERIPH0	1
#define AWIN_A80_CCU_SCLK_SDMMC_SAMPLE_CLK_PHASE_CTR __BITS(22,20)
#define AWIN_A80_CCU_SCLK_SDMMC_CLK_DIV_RATIO_N	__BITS(17,16)
#define AWIN_A80_CCU_SCLK_SDMMC_OUTPUT_CLK_PHASE_CTR __BITS(10,8)
#define AWIN_A80_CCU_SCLK_SDMMC_CLK_DIV_RATIO_M	__BITS(3,0)

#define AWIN_A80_CCU_SCLK_DAUDIO_SCLK_GATING	__BIT(31)

#define AWIN_A80_USBPHY_HCI_SCR_REG		0x0000
#define AWIN_A80_USBPHY_HCI_PCR_REG		0x0004

#define AWIN_A80_USBPHY_HCI_SCR_HCI2_RST	__BIT(19)
#define AWIN_A80_USBPHY_HCI_SCR_HCI1_RST	__BIT(18)
#define AWIN_A80_USBPHY_HCI_SCR_HCI0_RST	__BIT(17)
#define AWIN_A80_USBPHY_HCI_SCR_OHCI2_SCLK_GATING __BIT(6)
#define AWIN_A80_USBPHY_HCI_SCR_HCI2_AHB_GATING	__BIT(5)
#define AWIN_A80_USBPHY_HCI_SCR_HCI1_AHB_GATING __BIT(3)
#define AWIN_A80_USBPHY_HCI_SCR_OHCI0_SCLK_GATING __BIT(2)
#define AWIN_A80_USBPHY_HCI_SCR_HCI0_AHB_GATING	__BIT(1)

#define AWIN_A80_USBPHY_HCI_PCR_HCI2_UTMIPHY_RST __BIT(21)
#define AWIN_A80_USBPHY_HCI_PCR_HCI1_HSIC_RST	__BIT(18)
#define AWIN_A80_USBPHY_HCI_PCR_HCI0_PHY_RST	__BIT(17)
#define AWIN_A80_USBPHY_HCI_PCR_12M_GATING_HCI1_HSIC __BIT(10)
#define AWIN_A80_USBPHY_HCI_PCR_SCLK_GATING_HCI2_UTMIPHY __BIT(5)
#define AWIN_A80_USBPHY_HCI_PCR_480M_GATING_HCI2_HSIC __BIT(4)
#define AWIN_A80_USBPHY_HCI_PCR_480M_GATING_HCI1_HSIC __BIT(2)
#define AWIN_A80_USBPHY_HCI_PCR_SCLK_GATING_HCI0_PHY __BIT(1)

#define AWIN_A80_SYS_CTRL_VER_REG		0x0024
#define AWIN_A80_SYS_CTRL_EMAC_CLK_REG		0x0030
#define AWIN_A80_SYS_CTRL_DISP_MUX_CTRL_REG	0x0038

#define AWIN_A80_RPRCM_APB0_GATING_REG		0x0028
#define AWIN_A80_RPRCM_CIR_CLK_REG		0x0054
#define AWIN_A80_RPRCM_DAUDIO0_CLK_REG		0x0058
#define AWIN_A80_RPRCM_DAUDIO1_CLK_REG		0x005c
#define AWIN_A80_RPRCM_APB0_RST_REG		0x00b0

#define AWIN_A80_RPRCM_CLUSTER0_RST_REG		0x0004

#define AWIN_A80_RPRCM_CLUSTER0_RST_REG		0x0004
#define AWIN_A80_RPRCM_CLUSTER1_RST_REG		0x0008

#define AWIN_A80_RPRCM_CLUSTER0_PWR_GATING_REG	0x0100
#define AWIN_A80_RPRCM_CLUSTER1_PWR_GATING_REG	0x0104

#define AWIN_A80_RPRCM_CLUSTER0_PRW_CLAMP_REG	0x0140

#define AWIN_A80_RPRCM_CLUSTER0_PRW_CLAMP_STATUS_REG	0x0064

#define AWIN_A80_RPRCM_PRIVATE_REG		0x0164

#define AWIN_A80_RPRCM_APB0_GATING_CIR		__BIT(1)
#define AWIN_A80_RPRCM_APB0_GATING_DAUDIO1	__BIT(18)
#define AWIN_A80_RPRCM_APB0_GATING_DAUDIO0	__BIT(17)
#define AWIN_A80_RPRCM_APB0_RST_CIR		__BIT(1)
#define AWIN_A80_RPRCM_APB0_RST_DAUDIO1		__BIT(18)
#define AWIN_A80_RPRCM_APB0_RST_DAUDIO0		__BIT(17)

#define AWIN_A80_RCPUCFG_CLUSTER0_RST_REG	0x0080
#define AWIN_A80_RCPUCFG_CLUSTER1_RST_REG	0x0084

#define AWIN_A80_RSB_CMD_REG			0x002c
#define AWIN_A80_RSB_DAR_REG			0x0030

#define AWIN_A80_RSB_CMD_IDX			__BITS(7,0)
#define AWIN_A80_RSB_CMD_IDX_SRTA		0xe8
#define AWIN_A80_RSB_CMD_IDX_RD8		0x8b
#define AWIN_A80_RSB_CMD_IDX_RD16		0x9c
#define AWIN_A80_RSB_CMD_IDX_RD32		0xa6
#define AWIN_A80_RSB_CMD_IDX_WR8		0x4e
#define AWIN_A80_RSB_CMD_IDX_WR16		0x59
#define AWIN_A80_RSB_CMD_IDX_WR32		0x63

#define AWIN_A80_RSB_DAR_RTA			__BITS(23,16)
#define AWIN_A80_RSB_DAR_DA			__BITS(15,0)

#define AWIN_A80_PIO_PA_PINS		18
#define AWIN_A80_PIO_PA_GMAC_FUNC	2
#define AWIN_A80_PIO_PA_GMAC_PINS	0x0003f7bf /* PA pins 17-12,10-7,5-0 */

#define AWIN_A80_PIO_PB_PINS		20
#define AWIN_A80_PIO_PB_TWI4_FUNC	4
#define AWIN_A80_PIO_PB_TWI4_PINS	0x00018000 /* PB pins 16-15 */

#define AWIN_A80_PIO_PC_PINS		20
#define AWIN_A80_PIO_PC_SDMMC2_FUNC	3
#define AWIN_A80_PIO_PC_SDMMC2_PINS	0x0001ffc0 /* PC pins 16-6 */

#define AWIN_A80_PIO_PD_PINS		28

#define AWIN_A80_PIO_PE_PINS		21

#define AWIN_A80_PIO_PF_PINS		6
#define AWIN_A80_PIO_PF_SDMMC0_FUNC	2
#define AWIN_A80_PIO_PF_SDMMC0_PINS	0x0000003f /* PF pins 5-0 */

#define AWIN_A80_PIO_PG_PINS		16
#define AWIN_A80_PIO_PG_SDMMC1_FUNC	2
#define AWIN_A80_PIO_PG_SDMMC1_PINS	0x0000003f /* PG pins 5-0 */
#define AWIN_A80_PIO_PG_TWI3_FUNC	2
#define AWIN_A80_PIO_PG_TWI3_PINS	0x00000c00 /* PG pins 11-10 */

#define AWIN_A80_PIO_PH_PINS		22
#define AWIN_A80_PIO_PH_TWI0_FUNC	2
#define AWIN_A80_PIO_PH_TWI0_PINS	0x00000003 /* PH pins 1-0 */
#define AWIN_A80_PIO_PH_TWI1_FUNC	2
#define AWIN_A80_PIO_PH_TWI1_PINS	0x0000000c /* PH pins 3-2 */
#define AWIN_A80_PIO_PH_TWI2_FUNC	2
#define AWIN_A80_PIO_PH_TWI2_PINS	0x00000030 /* PH pins 5-4 */
#define AWIN_A80_PIO_PH_UART0_FUNC	2
#define AWIN_A80_PIO_PH_UART0_PINS	0x00003000 /* PH pins 13-12 */

#define AWIN_A80_PIO_PL_PINS		14
#define AWIN_A80_PIO_PL_CIR_FUNC	3
#define AWIN_A80_PIO_PL_CIR_PINS	0x00000040 /* PL pin 6 */

#define AWIN_A80_PIO_PM_PINS		16
#define AWIN_A80_PIO_PM_DAUDIO1_FUNC	3
#define AWIN_A80_PIO_PM_DAUDIO1_PINS	0x00007cf0 /* PM pins 14-10,7-4 */

#define AWIN_A80_PIO_PN_PINS		2

#define AWIN_LRADC_CTRL_REG		0x00
#define AWIN_LRADC_CTRL_FIRSTCONV_MASK		__BITS(31,24)
#define AWIN_LRADC_CTRL_FIRSTCONV_SHIFT		24
#define AWIN_LRADC_CTRL_CHAN_MASK		__BITS(23,22)
#define AWIN_LRADC_CTRL_CHAN_SHIFT		22
#define AWIN_LRADC_CTRL_CONT_MASK		__BITS(19,16)
#define AWIN_LRADC_CTRL_CONT_SHIFT		16
#define AWIN_LRADC_CTRL_KMODE_MASK		__BITS(13,12)
#define AWIN_LRADC_CTRL_KMODE_NORMAL		(0 << 12)
#define AWIN_LRADC_CTRL_KMODE_SINGLE		(1 << 12)
#define AWIN_LRADC_CTRL_KMODE_CONTINUE		(2 << 12)
#define AWIN_LRADC_CTRL_LV_A_B_CNT_MASK		__BITS(11,8)
#define AWIN_LRADC_CTRL_LV_A_B_CNT_SHIFT	8
#define AWIN_LRADC_CTRL_HOLD_EN			__BIT(6)
#define AWIN_LRADC_CTRL_LEVEL_B_MASK		__BITS(5,4)
#define AWIN_LRADC_CTRL_LEVEL_B_3C		(0 << 4)
#define AWIN_LRADC_CTRL_LEVEL_B_39		(1 << 4)
#define AWIN_LRADC_CTRL_LEVEL_B_36		(2 << 4)
#define AWIN_LRADC_CTRL_LEVEL_B_33		(3 << 4)
#define AWIN_LRADC_CTRL_RATE_MASK		__BITS(3,2)
#define AWIN_LRADC_CTRL_RATE_250		(0 << 2)
#define AWIN_LRADC_CTRL_RATE_125		(1 << 2)
#define AWIN_LRADC_CTRL_RATE_62			(2 << 2)
#define AWIN_LRADC_CTRL_RATE_31			(3 << 2)
#define AWIN_LRADC_CTRL_EN			__BIT(0)
#define AWIN_LRADC_INTC_REG		0x04
#define AWIN_LRADC_INTS_REG		0x08
#define AWIN_LRADC_INT_KEYUP1		__BIT(12)
#define AWIN_LRADC_INT_ALREADYHOLD1	__BIT(11)
#define AWIN_LRADC_INT_HOLD1		__BIT(10)
#define AWIN_LRADC_INT_KEY1		__BIT(9)
#define AWIN_LRADC_INT_DATA1		__BIT(8)
#define AWIN_LRADC_INT_KEYUP0		__BIT(4)
#define AWIN_LRADC_INT_ALREADYHOLD0	__BIT(3)
#define AWIN_LRADC_INT_HOLD0		__BIT(2)
#define AWIN_LRADC_INT_KEY0		__BIT(1)
#define AWIN_LRADC_INT_DATA0		__BIT(0)
#define AWIN_LRADC_DATA0_REG		0x0c
#define AWIN_LRADC_DATA1_REG		0x10

/* CAN mode select register */
#define AWIN_CAN_MODSEL_REG		0x00
#define AWIN_CAN_MODSEL_SLEEP		__BIT(4)
#define AWIN_CAN_MODSEL_ACP_FLT_MOD	__BIT(3)
#define AWIN_CAN_MODSEL_LB_MOD		__BIT(2)
#define AWIN_CAN_MODSEL_LST_ONLY	__BIT(1)
#define AWIN_CAN_MODSEL_RST		__BIT(0)

/* CAN command register */
#define AWIN_CAN_CMD_REG	0x04
#define AWIN_CAN_CMD_BUS_OFF		__BIT(5)
#define AWIN_CAN_CMD_SELF_REQ		__BIT(4)
#define AWIN_CAN_CMD_CLR_OR		__BIT(3)
#define AWIN_CAN_CMD_REL_RX_BUF		__BIT(2)
#define AWIN_CAN_CMD_ABT_REQ		__BIT(1)
#define AWIN_CAN_CMD_TANS_REQ		__BIT(0)

/* CAN status register */
#define AWIN_CAN_STA_REG	0x08
#define AWIN_CAN_STA_ERR_CODE		__BITS(23,22)
#define AWIN_CAN_STA_ERR_CODE_BIT		0
#define AWIN_CAN_STA_ERR_CODE_FORM		1
#define AWIN_CAN_STA_ERR_CODE_STUFF		2
#define AWIN_CAN_STA_ERR_CODE_OTHER		3
#define AWIN_CAN_STA_ERR_DIR		_BIT(21)
#define AWIN_CAN_STA_ERR_SEG_CODE	__BITS(20,16)
#define AWIN_CAN_STA_ARB_LOST		__BITS(12,8)
#define AWIN_CAN_STA_BUS		__BIT(7)
#define AWIN_CAN_STA_ERR		__BIT(6)
#define AWIN_CAN_STA_TX 		__BIT(5)
#define AWIN_CAN_STA_RX 		__BIT(4)
#define AWIN_CAN_STA_TX_OVER		__BIT(3)
#define AWIN_CAN_STA_TX_RDY		__BIT(2)
#define AWIN_CAN_STA_DATA_OR		__BIT(1)
#define AWIN_CAN_STA_RX_RDY		__BIT(0)

/* CAN interrupt register */
#define AWIN_CAN_INT_REG	0x0c
#define AWIN_CAN_INT_BERR		__BIT(7)
#define AWIN_CAN_INT_ARB_LOST		__BIT(6)
#define AWIN_CAN_INT_ERR_PASSIVE	__BIT(5)
#define AWIN_CAN_INT_WAKEUP		__BIT(4)
#define AWIN_CAN_INT_DATA_OR		__BIT(3)
#define AWIN_CAN_INT_ERR		__BIT(2)
#define AWIN_CAN_INT_TX_FLAG		__BIT(1)
#define AWIN_CAN_INT_RX_FLAG		__BIT(0)

/* CAN interrupt enable register */
#define AWIN_CAN_INTE_REG	0x10

/* CAN bus timing register */
#define AWIN_CAN_BUS_TIME_REG	0x14
#define AWIN_CAN_BUS_TIME_SAM		__BIT(23)
#define AWIN_CAN_BUS_TIME_PHSEG2	__BITS(22,20)
#define AWIN_CAN_BUS_TIME_PHSEG1	__BITS(19,16)
#define AWIN_CAN_BUS_TIME_SJW		__BITS(15,14)
#define AWIN_CAN_BUS_TIME_TQ_BRP	__BITS(9,0)

/* CAN tx error warning limit register */
#define AWIN_CAN_EWL_REG	0x18
#define AWIN_CAN_EWL_ERR_WRN_LMT	__BITS(7,0)

/* CAN error counter register */
#define AWIN_CAN_REC_REG	0x1c
#define AWIN_CAN_REC_RX_ERR_CNT		__BITS(23,16)
#define AWIN_CAN_REC_TX_ERR_CNT		__BITS(7,0)

/* CAN receive message register */
#define AWIN_CAN_RMSGC_REG	0x20
#define AWIN_CAN_RMSGC_RX_MSG_CNT	__BITS(7,0)

/* CAN receive buffer start address register */
#define AWIN_CAN_RSADDR_REG	0x24
#define AWIN_CAN_RSADDR_RX_BUF_SADDR	__BITS(5,0)

/* CAN rx/tx message buffer 0 register */
#define AWIN_CAN_TXBUF0_REG	0x40
#define AWIN_CAN_TXBUF0_EFF		__BIT(7)
#define AWIN_CAN_TXBUF0_RTR		__BIT(6)
#define AWIN_CAN_TXBUF0_DL		__BITS(3,0)

/* CAN rx/tx message buffer registers */
#define AWIN_CAN_TXBUF1_REG	0x44
#define AWIN_CAN_TXBUF2_REG	0x48
#define AWIN_CAN_TXBUF3_REG	0x4c
#define AWIN_CAN_TXBUF4_REG	0x50
#define AWIN_CAN_TXBUF5_REG	0x54
#define AWIN_CAN_TXBUF6_REG	0x58
#define AWIN_CAN_TXBUF7_REG	0x5c
#define AWIN_CAN_TXBUF8_REG	0x60
#define AWIN_CAN_TXBUF9_REG	0x64
#define AWIN_CAN_TXBUF10_REG	0x68
#define AWIN_CAN_TXBUF11_REG	0x6c
#define AWIN_CAN_TXBUF12_REG	0x70

/* CAN acceptance code 0 register */
#define AWIN_CAN_ACPC		0x40

/* CAN acceptance mask 0 register */
#define AWIN_CAN_ACPM		0x44

/* CAN transmit buffer for read back registers */
#define AWIN_CAN_RBUF_RBACK0	0x180
#define AWIN_CAN_RBUF_RBACK1	0x184
#define AWIN_CAN_RBUF_RBACK2	0x188
#define AWIN_CAN_RBUF_RBACK3	0x18c
#define AWIN_CAN_RBUF_RBACK4	0x190
#define AWIN_CAN_RBUF_RBACK5	0x194
#define AWIN_CAN_RBUF_RBACK6	0x198
#define AWIN_CAN_RBUF_RBACK7	0x19c
#define AWIN_CAN_RBUF_RBACK8	0x1a0
#define AWIN_CAN_RBUF_RBACK9	0x1a4
#define AWIN_CAN_RBUF_RBACK10	0x1a8
#define AWIN_CAN_RBUF_RBACK11	0x1ac
#define AWIN_CAN_RBUF_RBACK12	0x1b0

#endif /* _ARM_ALLWINNER_AWIN_REG_H_ */
