/*	$OpenBSD: glxreg.h,v 1.1 2010/10/14 21:23:05 pirofti Exp $	*/

/*
 * Copyright (c) 2009 Miodrag Vallat.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * AMD 5536 Geode companion chip MSR registers
 */

/*
 * Base addresses of the MSR groups.
 */

#define	GCSC_SB_MSR_BASE		0x51000000
#define	GCSC_GLIU_MSR_BASE		0x51010000
#define	GCSC_USB_MSR_BASE		0x51200000
#define	GCSC_IDE_MSR_BASE		0x51300000
#define	GCSC_DIVIL_MSR_BASE		0x51400000
#define	GCSC_ACC_MSR_BASE		0x51500000
#define	GCSC_GLCP_MSR_BASE		0x51700000

/*
 * GeodeLink Interface Unit (GLIU)
 */

#define	GCSC_GLIU_GLD_MSR_CAP		(GCSC_GLIU_MSR_BASE + 0x00)
#define	GCSC_GLIU_GLD_MSR_CONFIG	(GCSC_GLIU_MSR_BASE + 0x01)
#define	GCSC_GLIU_GLD_MSR_SMI		(GCSC_GLIU_MSR_BASE + 0x02)
#define	GCSC_GLIU_GLD_MSR_ERROR		(GCSC_GLIU_MSR_BASE + 0x03)
#define	GCSC_GLIU_GLD_MSR_PM		(GCSC_GLIU_MSR_BASE + 0x04)
#define	GCSC_GLIU_GLD_MSR_DIAG		(GCSC_GLIU_MSR_BASE + 0x05)

#define	GCSC_GLIU_P2D_BM0		(GCSC_GLIU_MSR_BASE + 0x20)
#define	GCSC_GLIU_P2D_BM1		(GCSC_GLIU_MSR_BASE + 0x21)
#define	GCSC_GLIU_P2D_BM2		(GCSC_GLIU_MSR_BASE + 0x22)
#define	GCSC_GLIU_P2D_BMK0		(GCSC_GLIU_MSR_BASE + 0x23)
#define	GCSC_GLIU_P2D_BMK1		(GCSC_GLIU_MSR_BASE + 0x24)
#define	GCSC_GLIU_P2D_BM3		(GCSC_GLIU_MSR_BASE + 0x25)
#define	GCSC_GLIU_P2D_BM4		(GCSC_GLIU_MSR_BASE + 0x26)

#define	GCSC_GLIU_COH			(GCSC_GLIU_MSR_BASE + 0x80)
#define	GCSC_GLIU_PAE			(GCSC_GLIU_MSR_BASE + 0x81)
#define	GCSC_GLIU_ARB			(GCSC_GLIU_MSR_BASE + 0x82)
#define	GCSC_GLIU_ASMI			(GCSC_GLIU_MSR_BASE + 0x83)
#define	GCSC_GLIU_AERR			(GCSC_GLIU_MSR_BASE + 0x84)
#define	GCSC_GLIU_DEBUG			(GCSC_GLIU_MSR_BASE + 0x85)
#define	GCSC_GLIU_PHY_CAP		(GCSC_GLIU_MSR_BASE + 0x86)
#define	GCSC_GLIU_NOUT_RESP		(GCSC_GLIU_MSR_BASE + 0x87)
#define	GCSC_GLIU_NOUT_WDATA		(GCSC_GLIU_MSR_BASE + 0x88)
#define	GCSC_GLIU_WHOAMI		(GCSC_GLIU_MSR_BASE + 0x8b)
#define	GCSC_GLIU_SLV_DIS		(GCSC_GLIU_MSR_BASE + 0x8c)
#define	GCSC_GLIU_STATISTIC_CNT0	(GCSC_GLIU_MSR_BASE + 0xa0)
#define	GCSC_GLIU_STATISTIC_MASK0	(GCSC_GLIU_MSR_BASE + 0xa1)
#define	GCSC_GLIU_STATISTIC_ACTION0	(GCSC_GLIU_MSR_BASE + 0xa2)
#define	GCSC_GLIU_STATISTIC_CNT1	(GCSC_GLIU_MSR_BASE + 0xa4)
#define	GCSC_GLIU_STATISTIC_MASK1	(GCSC_GLIU_MSR_BASE + 0xa5)
#define	GCSC_GLIU_STATISTIC_ACTION1	(GCSC_GLIU_MSR_BASE + 0xa6)
#define	GCSC_GLIU_STATISTIC_CNT2	(GCSC_GLIU_MSR_BASE + 0xa8)
#define	GCSC_GLIU_STATISTIC_MASK2	(GCSC_GLIU_MSR_BASE + 0xa9)
#define	GCSC_GLIU_STATISTIC_ACTION2	(GCSC_GLIU_MSR_BASE + 0xaa)
#define	GCSC_GLIU_RQ_COMP_VAL		(GCSC_GLIU_MSR_BASE + 0xc0)
#define	GCSC_GLIU_RQ_COMP_MASK		(GCSC_GLIU_MSR_BASE + 0xc1)
#define	GCSC_GLIU_DA_COMP_VAL_LO	(GCSC_GLIU_MSR_BASE + 0xd0)
#define	GCSC_GLIU_DA_COMP_VAL_HI	(GCSC_GLIU_MSR_BASE + 0xd1)
#define	GCSC_GLIU_DA_COMP_MASK_LO	(GCSC_GLIU_MSR_BASE + 0xd2)
#define	GCSC_GLIU_DA_COMP_MASK_HI	(GCSC_GLIU_MSR_BASE + 0xd3)

#define	GCSC_GLIU_IOD_BM0		(GCSC_GLIU_MSR_BASE + 0xe0)
#define	GCSC_GLIU_IOD_BM1		(GCSC_GLIU_MSR_BASE + 0xe1)
#define	GCSC_GLIU_IOD_BM2		(GCSC_GLIU_MSR_BASE + 0xe2)
#define	GCSC_GLIU_IOD_BM3		(GCSC_GLIU_MSR_BASE + 0xe3)
#define	GCSC_GLIU_IOD_BM4		(GCSC_GLIU_MSR_BASE + 0xe4)
#define	GCSC_GLIU_IOD_BM5		(GCSC_GLIU_MSR_BASE + 0xe5)
#define	GCSC_GLIU_IOD_BM6		(GCSC_GLIU_MSR_BASE + 0xe6)
#define	GCSC_GLIU_IOD_BM7		(GCSC_GLIU_MSR_BASE + 0xe7)
#define	GCSC_GLIU_IOD_BM8		(GCSC_GLIU_MSR_BASE + 0xe8)
#define	GCSC_GLIU_IOD_BM9		(GCSC_GLIU_MSR_BASE + 0xe9)
#define	GCSC_GLIU_IOD_SC0		(GCSC_GLIU_MSR_BASE + 0xea)
#define	GCSC_GLIU_IOD_SC1		(GCSC_GLIU_MSR_BASE + 0xeb)
#define	GCSC_GLIU_IOD_SC2		(GCSC_GLIU_MSR_BASE + 0xec)
#define	GCSC_GLIU_IOD_SC3		(GCSC_GLIU_MSR_BASE + 0xed)
#define	GCSC_GLIU_IOD_SC4		(GCSC_GLIU_MSR_BASE + 0xee)
#define	GCSC_GLIU_IOD_SC5		(GCSC_GLIU_MSR_BASE + 0xef)
#define	GCSC_GLIU_IOD_SC6		(GCSC_GLIU_MSR_BASE + 0xf0)
#define	GCSC_GLIU_IOD_SC7		(GCSC_GLIU_MSR_BASE + 0xf1)

/*
 * GeodeLink PCI South Bridge (SB)
 */

#define	GCSC_GLPCI_GLD_MSR_CAP		(GCSC_SB_MSR_BASE + 0x00)
#define	GCSC_GLPCI_GLD_MSR_CONFIG	(GCSC_SB_MSR_BASE + 0x01)
#define	GCSC_GLPCI_GLD_MSR_SMI		(GCSC_SB_MSR_BASE + 0x02)
#define	GCSC_GLPCI_GLD_MSR_ERROR	(GCSC_SB_MSR_BASE + 0x03)
#define	GCSC_GLPCI_GLD_MSR_PM		(GCSC_SB_MSR_BASE + 0x04)
#define	GCSC_GLPCI_GLD_MSR_DIAG		(GCSC_SB_MSR_BASE + 0x05)

#define	GCSC_GLPCI_CTRL			(GCSC_SB_MSR_BASE + 0x10)
#define	GCSC_GLPCI_R0			(GCSC_SB_MSR_BASE + 0x20)
#define	GCSC_GLPCI_R1			(GCSC_SB_MSR_BASE + 0x21)
#define	GCSC_GLPCI_R2			(GCSC_SB_MSR_BASE + 0x22)
#define	GCSC_GLPCI_R3			(GCSC_SB_MSR_BASE + 0x23)
#define	GCSC_GLPCI_R4			(GCSC_SB_MSR_BASE + 0x24)
#define	GCSC_GLPCI_R5			(GCSC_SB_MSR_BASE + 0x25)
#define	GCSC_GLPCI_R6			(GCSC_SB_MSR_BASE + 0x26)
#define	GCSC_GLPCI_R7			(GCSC_SB_MSR_BASE + 0x27)
#define	GCSC_GLPCI_R8			(GCSC_SB_MSR_BASE + 0x28)
#define	GCSC_GLPCI_R9			(GCSC_SB_MSR_BASE + 0x29)
#define	GCSC_GLPCI_R10			(GCSC_SB_MSR_BASE + 0x2a)
#define	GCSC_GLPCI_R11			(GCSC_SB_MSR_BASE + 0x2b)
#define	GCSC_GLPCI_R12			(GCSC_SB_MSR_BASE + 0x2c)
#define	GCSC_GLPCI_R13			(GCSC_SB_MSR_BASE + 0x2d)
#define	GCSC_GLPCI_R14			(GCSC_SB_MSR_BASE + 0x2e)
#define	GCSC_GLPCI_R15			(GCSC_SB_MSR_BASE + 0x2f)
#define	GCSC_GLPCI_PCIHEAD_BYTE0_3	(GCSC_SB_MSR_BASE + 0x30)
#define	GCSC_GLPCI_PCIHEAD_BYTE4_7	(GCSC_SB_MSR_BASE + 0x31)
#define	GCSC_GLPCI_PCIHEAD_BYTE8_B	(GCSC_SB_MSR_BASE + 0x32)
#define	GCSC_GLPCI_PCIHEAD_BYTEC_F	(GCSC_SB_MSR_BASE + 0x33)

/*
 * AC97 Audio Codec Controller (ACC)
 */

#define	GCSC_ACC_GLD_MSR_CAP		(GCSC_ACC_MSR_BASE + 0x00)
#define	GCSC_ACC_GLD_MSR_CONFIG		(GCSC_ACC_MSR_BASE + 0x01)
#define	GCSC_ACC_GLD_MSR_SMI		(GCSC_ACC_MSR_BASE + 0x02)
#define	GCSC_ACC_GLD_MSR_ERROR		(GCSC_ACC_MSR_BASE + 0x03)
#define	GCSC_ACC_GLD_MSR_PM		(GCSC_ACC_MSR_BASE + 0x04)
#define	GCSC_ACC_GLD_MSR_DIAG		(GCSC_ACC_MSR_BASE + 0x05)

/*
 * USB Controller Registers (USB)
 */

#define	GCSC_USB_GLD_MSR_CAP		(GCSC_USB_MSR_BASE + 0x00)
#define	GCSC_USB_GLD_MSR_CONFIG		(GCSC_USB_MSR_BASE + 0x01)
#define	GCSC_USB_GLD_MSR_SMI		(GCSC_USB_MSR_BASE + 0x02)
#define	GCSC_USB_GLD_MSR_ERROR		(GCSC_USB_MSR_BASE + 0x03)
#define	GCSC_USB_GLD_MSR_PM		(GCSC_USB_MSR_BASE + 0x04)
#define	GCSC_USB_GLD_MSR_DIAG		(GCSC_USB_MSR_BASE + 0x05)

#define	GCSC_USB_MSR_OHCB		(GCSC_USB_MSR_BASE + 0x08)
#define	GCSC_USB_MSR_EHCB		(GCSC_USB_MSR_BASE + 0x09)
#define	GCSC_USB_MSR_UDCB		(GCSC_USB_MSR_BASE + 0x0a)
#define	GCSC_USB_MSR_UOCB		(GCSC_USB_MSR_BASE + 0x0b)

/*
 * IDE Controller Registers (IDE)
 */

#define	GCSC_IDE_GLD_MSR_CAP		(GCSC_IDE_MSR_BASE + 0x00)
#define	GCSC_IDE_GLD_MSR_CONFIG		(GCSC_IDE_MSR_BASE + 0x01)
#define	GCSC_IDE_GLD_MSR_SMI		(GCSC_IDE_MSR_BASE + 0x02)
#define	GCSC_IDE_GLD_MSR_ERROR		(GCSC_IDE_MSR_BASE + 0x03)
#define	GCSC_IDE_GLD_MSR_PM		(GCSC_IDE_MSR_BASE + 0x04)
#define	GCSC_IDE_GLD_MSR_DIAG		(GCSC_IDE_MSR_BASE + 0x05)

#define	GCSC_IDE_IO_BAR			(GCSC_IDE_MSR_BASE + 0x08)
#define	GCSC_IDE_CFG			(GCSC_IDE_MSR_BASE + 0x10)
#define	GCSC_IDE_DTC			(GCSC_IDE_MSR_BASE + 0x12)
#define	GCSC_IDE_CAST			(GCSC_IDE_MSR_BASE + 0x13)
#define	GCSC_IDE_ETC			(GCSC_IDE_MSR_BASE + 0x14)
#define	GCSC_IDE_PM			(GCSC_IDE_MSR_BASE + 0x15)

/*
 * Diverse Integration Logic (DIVIL)
 */

#define	GCSC_DIVIL_GLD_MSR_CAP		(GCSC_DIVIL_MSR_BASE + 0x00)
#define	GCSC_DIVIL_GLD_MSR_CONFIG	(GCSC_DIVIL_MSR_BASE + 0x01)
#define	GCSC_DIVIL_GLD_MSR_SMI		(GCSC_DIVIL_MSR_BASE + 0x02)
#define	GCSC_DIVIL_GLD_MSR_ERROR	(GCSC_DIVIL_MSR_BASE + 0x03)
#define	GCSC_DIVIL_GLD_MSR_PM		(GCSC_DIVIL_MSR_BASE + 0x04)
#define	GCSC_DIVIL_GLD_MSR_DIAG		(GCSC_DIVIL_MSR_BASE + 0x05)

#define	GCSC_DIVIL_LBAR_IRQ		(GCSC_DIVIL_MSR_BASE + 0x08)
#define	GCSC_DIVIL_LBAR_KEL		(GCSC_DIVIL_MSR_BASE + 0x09)
#define	GCSC_DIVIL_LBAR_SMB		(GCSC_DIVIL_MSR_BASE + 0x0b)
#define	GCSC_DIVIL_LBAR_GPIO		(GCSC_DIVIL_MSR_BASE + 0x0c)
#define	GCSC_DIVIL_LBAR_MFGPT		(GCSC_DIVIL_MSR_BASE + 0x0d)
#define	GCSC_DIVIL_LBAR_ACPI		(GCSC_DIVIL_MSR_BASE + 0x0e)
#define	GCSC_DIVIL_LBAR_PMS		(GCSC_DIVIL_MSR_BASE + 0x0f)
#define	GCSC_DIVIL_LBAR_FLSH0		(GCSC_DIVIL_MSR_BASE + 0x10)
#define	GCSC_DIVIL_LBAR_FLSH1		(GCSC_DIVIL_MSR_BASE + 0x11)
#define	GCSC_DIVIL_LBAR_FLSH2		(GCSC_DIVIL_MSR_BASE + 0x12)
#define	GCSC_DIVIL_LBAR_FLSH3		(GCSC_DIVIL_MSR_BASE + 0x13)
#define	GCSC_DIVIL_LEG_IO		(GCSC_DIVIL_MSR_BASE + 0x14)
#define	GCSC_DIVIL_BALL_OPTS		(GCSC_DIVIL_MSR_BASE + 0x15)
#define	GCSC_DIVIL_SOFT_IRQ		(GCSC_DIVIL_MSR_BASE + 0x16)
#define	GCSC_DIVIL_SOFT_RESET		(GCSC_DIVIL_MSR_BASE + 0x17)
#define	GCSC_NORF_CTL			(GCSC_DIVIL_MSR_BASE + 0x18)
#define	GCSC_NORF_T01			(GCSC_DIVIL_MSR_BASE + 0x19)
#define	GCSC_NORF_T23			(GCSC_DIVIL_MSR_BASE + 0x1a)
#define	GCSC_NANDF_DATA			(GCSC_DIVIL_MSR_BASE + 0x1b)
#define	GCSC_NANDF_CTL			(GCSC_DIVIL_MSR_BASE + 0x1c)
#define	GCSC_NANDF_RSVD			(GCSC_DIVIL_MSR_BASE + 0x1d)
#define	GCSC_DIVIL_AC_DMA		(GCSC_DIVIL_MSR_BASE + 0x1e)
#define	GCSC_KELX_CTL			(GCSC_DIVIL_MSR_BASE + 0x1f)
#define	GCSC_PIC_YSEL_LOW		(GCSC_DIVIL_MSR_BASE + 0x20)
#define	GCSC_PIC_YSEL_HIGH		(GCSC_DIVIL_MSR_BASE + 0x21)
#define	GCSC_PIC_ZSEL_LOW		(GCSC_DIVIL_MSR_BASE + 0x22)
#define	GCSC_PIC_ZSEL_HIGH		(GCSC_DIVIL_MSR_BASE + 0x23)
#define	GCSC_PIC_IRQM_PRIM		(GCSC_DIVIL_MSR_BASE + 0x24)
#define	GCSC_PIC_IRQM_LPC		(GCSC_DIVIL_MSR_BASE + 0x25)
#define	GCSC_PIC_XIRR_STS_LOW		(GCSC_DIVIL_MSR_BASE + 0x26)
#define	GCSC_PIC_XIRR_STS_HIGH		(GCSC_DIVIL_MSR_BASE + 0x27)
#define	GCSC_MFGPT_IRQ			(GCSC_DIVIL_MSR_BASE + 0x28)
#define	GCSC_MFGPT_NR			(GCSC_DIVIL_MSR_BASE + 0x29)
#define	GCSC_MFGPT_RSVD			(GCSC_DIVIL_MSR_BASE + 0x2a)
#define	GCSC_MFGPT_SETUP		(GCSC_DIVIL_MSR_BASE + 0x2b)
#define	GCSC_FLPY_3F2_SHDW		(GCSC_DIVIL_MSR_BASE + 0x30)
#define	GCSC_FLPY_3F7_SHDW		(GCSC_DIVIL_MSR_BASE + 0x31)
#define	GCSC_FLPY_372_SHDW		(GCSC_DIVIL_MSR_BASE + 0x32)
#define	GCSC_FLPY_377_SHDW		(GCSC_DIVIL_MSR_BASE + 0x33)
#define	GCSC_PIC_SHDW			(GCSC_DIVIL_MSR_BASE + 0x34)
#define	GCSC_PIT_SHDW			(GCSC_DIVIL_MSR_BASE + 0x36)
#define	GCSC_PIT_CNTRL			(GCSC_DIVIL_MSR_BASE + 0x37)
#define	GCSC_UART1_MOD			(GCSC_DIVIL_MSR_BASE + 0x38)
#define	GCSC_UART1_DONG			(GCSC_DIVIL_MSR_BASE + 0x39)
#define	GCSC_UART1_CONF			(GCSC_DIVIL_MSR_BASE + 0x3a)
#define	GCSC_UART1_RSVD_MSR		(GCSC_DIVIL_MSR_BASE + 0x3b)
#define	GCSC_UART2_MOD			(GCSC_DIVIL_MSR_BASE + 0x3c)
#define	GCSC_UART2_DONG			(GCSC_DIVIL_MSR_BASE + 0x3d)
#define	GCSC_UART2_CONF			(GCSC_DIVIL_MSR_BASE + 0x3e)
#define	GCSC_UART2_RSVD_MSR		(GCSC_DIVIL_MSR_BASE + 0x3f)
#define	GCSC_DMA_MAP			(GCSC_DIVIL_MSR_BASE + 0x40)
#define	GCSC_DMA_SHDW_CH0		(GCSC_DIVIL_MSR_BASE + 0x41)
#define	GCSC_DMA_SHDW_CH1		(GCSC_DIVIL_MSR_BASE + 0x42)
#define	GCSC_DMA_SHDW_CH2		(GCSC_DIVIL_MSR_BASE + 0x43)
#define	GCSC_DMA_SHDW_CH3		(GCSC_DIVIL_MSR_BASE + 0x44)
#define	GCSC_DMA_SHDW_CH4		(GCSC_DIVIL_MSR_BASE + 0x45)
#define	GCSC_DMA_SHDW_CH5		(GCSC_DIVIL_MSR_BASE + 0x46)
#define	GCSC_DMA_SHDW_CH6		(GCSC_DIVIL_MSR_BASE + 0x47)
#define	GCSC_DMA_SHDW_CH7		(GCSC_DIVIL_MSR_BASE + 0x48)
#define	GCSC_DMA_MSK_SHDW		(GCSC_DIVIL_MSR_BASE + 0x49)
#define	GCSC_LPC_EADDR			(GCSC_DIVIL_MSR_BASE + 0x4c)
#define	GCSC_LPC_ESTAT			(GCSC_DIVIL_MSR_BASE + 0x4d)
#define	GCSC_LPC_SIRQ			(GCSC_DIVIL_MSR_BASE + 0x4e)
#define	GCSC_LPC_RSVD			(GCSC_DIVIL_MSR_BASE + 0x4f)
#define	GCSC_PMC_LTMR			(GCSC_DIVIL_MSR_BASE + 0x50)
#define	GCSC_PMC_RSVD			(GCSC_DIVIL_MSR_BASE + 0x51)
#define	GCSC_RTC_RAM_LOCK		(GCSC_DIVIL_MSR_BASE + 0x54)
#define	GCSC_RTC_DOMA_OFFSET		(GCSC_DIVIL_MSR_BASE + 0x55)
#define	GCSC_RTC_MONA_OFFSET		(GCSC_DIVIL_MSR_BASE + 0x56)
#define	GCSC_RTC_CEN_OFFSET		(GCSC_DIVIL_MSR_BASE + 0x57)

/*
 * GeodeLink Control Processor (GLCP)
 */

#define	GCSC_GLCP_GLD_MSR_CAP		(GCSC_GLCP_MSR_BASE + 0x00)
#define	GCSC_GLCP_GLD_MSR_CONFIG	(GCSC_GLCP_MSR_BASE + 0x01)
#define	GCSC_GLCP_GLD_MSR_SMI		(GCSC_GLCP_MSR_BASE + 0x02)
#define	GCSC_GLCP_GLD_MSR_ERROR		(GCSC_GLCP_MSR_BASE + 0x03)
#define	GCSC_GLCP_GLD_MSR_PM		(GCSC_GLCP_MSR_BASE + 0x04)
#define	GCSC_GLCP_GLD_MSR_DIAG		(GCSC_GLCP_MSR_BASE + 0x05)

#define	GCSC_GLCP_CLK_DIS_DELAY		(GCSC_GLCP_MSR_BASE + 0x08)
#define	GCSC_GLCP_PMCLKDISABLE		(GCSC_GLCP_MSR_BASE + 0x09)
#define	GCSC_GLCP_GLB_PM		(GCSC_GLCP_MSR_BASE + 0x0b)
#define	GCSC_GLCP_DBGOUT		(GCSC_GLCP_MSR_BASE + 0x0c)
#define	GCSC_GLCP_DOWSER		(GCSC_GLCP_MSR_BASE + 0x0e)
#define	GCSC_GLCP_CLKOFF		(GCSC_GLCP_MSR_BASE + 0x10)
#define	GCSC_GLCP_CLKACTIVE		(GCSC_GLCP_MSR_BASE + 0x11)
#define	GCSC_GLCP_CLKDISABLE		(GCSC_GLCP_MSR_BASE + 0x12)
#define	GCSC_GLCP_CLK4ACK		(GCSC_GLCP_MSR_BASE + 0x13)
#define	GCSC_GLCP_SYS_RST		(GCSC_GLCP_MSR_BASE + 0x14)
#define	GCSC_GLCP_DBGCLKCTRL		(GCSC_GLCP_MSR_BASE + 0x16)
#define	GCSC_GLCP_CHIP_REV_ID		(GCSC_GLCP_MSR_BASE + 0x17)

/*
 * GPIO registers
 */

#define	GCSC_GPIOL_OUT_VAL		0x0000
#define	GCSC_GPIOL_OUT_EN		0x0004
#define	GCSC_GPIOL_OUT_OD_EN		0x0008
#define	GCSC_GPIOL_OUT_INVRT_EN		0x000c
#define	GCSC_GPIOL_OUT_AUX1_SEL		0x0010
#define	GCSC_GPIOL_OUT_AUX2_SEL		0x0014
#define	GCSC_GPIOL_PU_EN		0x0018
#define	GCSC_GPIOL_PD_EN		0x001c
#define	GCSC_GPIOL_IN_EN		0x0020
#define	GCSC_GPIOL_IN_INV_EN		0x0024
#define	GCSC_GPIOL_IN_FLTR_EN		0x0028
#define	GCSC_GPIOL_IN_EVNTCNT_EN	0x002c
#define	GCSC_GPIOL_READ_BACK		0x0030
#define	GCSC_GPIOL_IN_AUX1_SEL		0x0034
#define	GCSC_GPIOL_EVNT_EN		0x0038
#define	GCSC_GPIOL_LOCK_EN		0x003c
#define	GCSC_GPIOL_POSEDGE_EN		0x0040
#define	GCSC_GPIOL_NEGEDGE_EN		0x0044
#define	GCSC_GPIOL_POSEDGE_STS		0x0048
#define	GCSC_GPIOL_NEGEDGE_STS		0x004c
#define	GCSC_GPIO_FLTR0_AMNT		0x0050
#define	GCSC_GPIO_FLTR0_CNT		0x0052
#define	GCSC_GPIO_EVNTCNT0		0x0054
#define	GCSC_GPIO_EVNTCNT0_COMP		0x0056
#define	GCSC_GPIO_FLTR1_AMNT		0x0058
#define	GCSC_GPIO_FLTR1_CNT		0x005a
#define	GCSC_GPIO_EVNTCNT1		0x005c
#define	GCSC_GPIO_EVNTCNT1_COMP		0x005e
#define	GCSC_GPIO_FLTR2_AMNT		0x0060
#define	GCSC_GPIO_FLTR2_CNT		0x0062
#define	GCSC_GPIO_EVNTCNT2		0x0064
#define	GCSC_GPIO_EVNTCNT2_COMP		0x0066
#define	GCSC_GPIO_FLTR3_AMNT		0x0068
#define	GCSC_GPIO_FLTR3_CNT		0x006a
#define	GCSC_GPIO_EVNTCNT3		0x006c
#define	GCSC_GPIO_EVNTCNT3_COMP		0x006e
#define	GCSC_GPIO_FLTR4_AMNT		0x0070
#define	GCSC_GPIO_FLTR4_CNT		0x0072
#define	GCSC_GPIO_EVNTCNT4		0x0074
#define	GCSC_GCSC_GPIO_EVNTCNT4_COMP	0x0076
#define	GCSC_GPIO_FLTR5_AMNT		0x0078
#define	GCSC_GPIO_FLTR5_CNT		0x007a
#define	GCSC_GPIO_EVNTCNT5		0x007c
#define	GCSC_GPIO_EVNTCNT5_COMP		0x007e
#define	GCSC_GPIOH_OUT_VAL		0x0080
#define	GCSC_GPIOH_OUT_EN		0x0084
#define	GCSC_GPIOH_OUT_OD_EN		0x0088
#define	GCSC_GPIOH_OUT_INVRT_EN		0x008c
#define	GCSC_GPIOH_OUT_AUX1_SEL		0x0090
#define	GCSC_GPIOH_OUT_AUX2_SEL		0x0094
#define	GCSC_GPIOH_PU_EN		0x0098
#define	GCSC_GPIOH_PD_EN		0x009c
#define	GCSC_GPIOH_IN_EN		0x00a0
#define	GCSC_GPIOH_IN_INV_EN		0x00a4
#define	GCSC_GPIOH_IN_FLTR_EN		0x00a8
#define	GCSC_GPIOH_IN_EVNTCNT_E		0x00ac
#define	GCSC_GPIOH_READ_BACK		0x00b0
#define	GCSC_GPIOH_IN_AUX1_SEL		0x00b4
#define	GCSC_GPIOH_EVNT_EN		0x00b8
#define	GCSC_GPIOH_LOCK_EN		0x00bc
#define	GCSC_GPIOH_POSEDGE_EN		0x00c0
#define	GCSC_GPIOH_NEGEDGE_EN		0x00c4
#define	GCSC_GPIOH_POSEDGE_STS		0x00c8
#define	GCSC_GPIOH_NEGEDGE_STS		0x00cc
#define	GCSC_GPIO_FLTR6_AMNT		0x00d0
#define	GCSC_GPIO_FLTR6_CNT		0x00d2
#define	GCSC_GPIO_EVNTCNT6		0x00d4
#define	GCSC_GPIO_EVNTCNT6_COMP		0x00d6
#define	GCSC_GPIO_FLTR7_AMNT		0x00d8
#define	GCSC_GPIO_FLTR7_CNT		0x00da
#define	GCSC_GPIO_EVNTCNT7		0x00dc
#define	GCSC_GPIO_EVNTCNT7_COMP		0x00de
#define	GCSC_GPIO_MAP_X			0x00e0
#define	GCSC_GPIO_MAP_Y			0x00e4
#define	GCSC_GPIO_MAP_Z			0x00e8
#define	GCSC_GPIO_MAP_W			0x00ec
#define	GCSC_GPIO_FE0_SEL		0x00f0
#define	GCSC_GPIO_FE1_SEL		0x00f1
#define	GCSC_GPIO_FE2_SEL		0x00f2
#define	GCSC_GPIO_FE3_SEL		0x00f3
#define	GCSC_GPIO_FE4_SEL		0x00f4
#define	GCSC_GPIO_FE5_SEL		0x00f5
#define	GCSC_GPIO_FE6_SEL		0x00f6
#define	GCSC_GPIO_FE7_SEL		0x00f7
#define	GCSC_GPIOL_EVNTCNT_DEC		0x00f8
#define	GCSC_GPIOH_EVNTCNT_DEC		0x00fc

#define	GCSC_GPIO_ATOMIC_VALUE(pin,feature) \
	((feature) ? \
	    ((0 << (16 + (pin))) | (1 << (pin))) : \
	    ((1 << (16 + (pin))) | (0 << (pin))))
