/*	$NetBSD: imx51_ccmreg.h,v 1.6 2021/07/24 21:31:32 andvar Exp $	*/
/*
 * Copyright (c) 2011, 2012  Genetec Corporation.  All rights reserved.
 * Written by Hashimoto Kenichi for Genetec Corporation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GENETEC CORPORATION ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL GENETEC CORPORATION
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef	_IMX51_CCMREG_H
#define	_IMX51_CCMREG_H

#include <sys/cdefs.h>

/* register offset address */

#define	CCMC_IMX6_BASE	0x020c4040

#define	CCMC_CCR	0x0000
#define	 CCR_FPM_MULT	__BIT(12)
#define	 CCR_COSC_EN	__BIT(12)
#define	CCMC_CCDR	0x0004
#define	CCMC_CSR	0x0008
#define	CCMC_CCSR	0x000c
#define	 CCSR_LP_APM	__BIT(9)
#define	 CCSR_STEP_SEL		__BITS(8, 7)
#define	 CCSR_PLL2_DIV_PODF	__BITS(6, 5)
#define	 CCSR_PLL3_DIV_PODF	__BITS(4, 3)
#define	 CCSR_PLL1_SW_CLK_SEL	__BIT(2)
#define	 CCSR_PLL2_SW_CLK_SEL	__BIT(1)
#define	 CCSR_PLL3_SW_CLK_SEL	__BIT(0)
#define	CCMC_CACRR	0x0010
#define	CCMC_CBCDR	0x0014
#define	 CBCDR_DDR_HIGH_FREQ_CLK_SEL	__BIT(30)
#define	 CBCDR_DDR_CLK_PODF		__BITS(29, 27)
#ifdef IMX50
#define	 CBCDR_PERIPH_CLK_SEL		__BITS(26, 25)
#else
#define	 CBCDR_EMI_CLK_SEL		__BIT(26)
#define	 CBCDR_PERIPH_CLK_SEL		__BIT(25)
#endif
#define	 CBCDR_EMI_SLOW_PODF		__BITS(24, 22)
#define	 CBCDR_AXI_B_PODF		__BITS(21, 19)
#define	 CBCDR_AXI_A_PODF		__BITS(18, 16)
#define	 CBCDR_NFC_PODF			__BITS(15, 13)
#define	 CBCDR_AHB_PODF			__BITS(12, 10)
#define	 CBCDR_IPG_PODF			__BITS(9, 8)
#define	 CBCDR_PERCLK_PRED1		__BITS(7, 6)
#define	 CBCDR_PERCLK_PRED2		__BITS(5, 3)
#define	 CBCDR_PERCLK_PODF		__BITS(2, 0)
#define	CCMC_CBCMR			0x0018
#define	 CBCMR_PERIPH_APM_SEL		__BITS(13, 12)
#define	 CBCMR_IPU_HSP_CLK_SEL		__BITS(7, 6)
#define	 CBCMR_PERCLK_LP_APM_SEL	__BIT(1)
#define	 CBCMR_PERCLK_IPG_SEL		__BIT(0)
#define	CCMC_CSCMR1			0x001c
#define	 CSCMR1_UART_CLK_SEL		__BITS(25, 24)
#ifdef IMX50
#define	 CSCMR1_ESDHC1_CLK_SEL		__BITS(22, 21)
#define	 CSCMR1_ESDHC2_CLK_SEL		__BIT(20)
#define	 CSCMR1_ESDHC4_CLK_SEL		__BIT(19)
#define	 CSCMR1_ESDHC3_CLK_SEL		__BITS(18, 16)
#else
#define	 CSCMR1_ESDHC1_CLK_SEL		__BITS(21, 20)
#define	 CSCMR1_ESDHC3_CLK_SEL		__BIT(19)
#define	 CSCMR1_ESDHC4_CLK_SEL		__BIT(18)
#define	 CSCMR1_ESDHC2_CLK_SEL		__BITS(17, 16)
#endif
#define	 CSCMR1_CSPI_CLK_SEL		__BITS(5, 4)
#define	CCMC_CSCMR2			0x0020
#define	CCMC_CSCDR1			0x0024
#ifdef IMX50
#define	 CSCDR1_ESDHC3_CLK_PRED		__BITS(24, 22)
#define	 CSCDR1_ESDHC3_CLK_PODF		__BITS(21, 19)
#else
#define	 CSCDR1_ESDHC2_CLK_PRED		__BITS(24, 22)
#define	 CSCDR1_ESDHC2_CLK_PODF		__BITS(21, 19)
#endif
#define	 CSCDR1_ESDHC1_CLK_PRED		__BITS(18, 16)
#define	 CSCDR1_ESDHC1_CLK_PODF		__BITS(13, 11)
#define	 CSCDR1_UART_CLK_PRED		__BITS(5, 3)
#define	 CSCDR1_UART_CLK_PODF		__BITS(2, 0)
#define	CCMC_CS1CDR			0x0028
#define	CCMC_CS2CDR			0x002c
#define	CCMC_CDCDR			0x0030
#define	 CDCDR_PERIPH_CLK2		__BITS(29, 27)
#define	CCMC_CHSCCDR			0x0034	// i.MX6
#define	CCMC_CSCDR2			0x0038
#define	 CSCDR2_ECSPI_CLK_PRED		__BITS(27, 25)
#define	 CSCDR2_ECSPI_CLK_PODF		__BITS(24, 19)
#define	CCMC_CSCDR3			0x003c
#define	CCMC_CSCDR4			0x0040
#define	CCMC_CWDR			0x0044
#define	CCMC_CDHIPR			0x0048
#define	CCMC_CDCR			0x004c
#define	 CDCR_SW_PERIPH_CLK_DIV_REQ	__BIT(6)
#define	 CDCR_PERIPH_CLK_DVFS_PODF	__BITS(1, 0)
#define	CCMC_CTOR			0x0050
#define	CCMC_CLPCR			0x0054
#define	CCMC_CISR			0x0058
#define	CCMC_CIMR			0x005c
#define	CCMC_CCOSR			0x0060
#define	CCMC_CGPR			0x0064
#define	CCMC_CCGR(n)			(0x0068 + (n) * 4)
#define	CCMC_CMEOR			0x0084
#ifdef IMX50
#define	CCMC_CSR2			0x008C
#define	 CSR2_EPDC_ASM_ACTIVE		__BIT(13)
#define	 CSR2_EPXP_ASM_ACTIVE		__BIT(12)
#define	 CSR2_ELCDIF_ASM_ACTIVE		__BIT(11)
#define	 CSR2_SYS_CLK_XTAL_ACTIVE	__BIT(10)
#define	 CSR2_ELCDIF_PIX_BUSY		__BIT(9)
#define	 CSR2_EPDC_PIX_BUSY		__BIT(8)
#define	 CSR2_MSHC_XMSCKI_BUSY		__BIT(7)
#define	 CSR2_BCH_BUSY			__BIT(6)
#define	 CSR2_GPMI_BUSY			__BIT(5)
#define	 CSR2_EPDC_AXI_BUSY		__BIT(4)
#define	 CSR2_DISPLAY_AXI_BUSY		__BIT(3)
#define	 CSR2_DDR_CLK_REF_PLL_BUSY	__BIT(2)
#define	 CSR2_SYS_CLK_REF_PLL_BUSY	__BIT(1)
#define	 CSR2_SYS_CLK_REF_XTAL_BUSY	__BIT(0)
#define	CCMC_CLKSEQ_BYPASS		0x0090
#define	 CLKSEQ_ELCDIF_PIX_CLK		__BITS(15, 14)
#define	 CLKSEQ_EPDC_PIX_CLK		__BITS(13, 12)
#define	 CLKSEQ_MSHC_XMSCKI_CLK		__BITS(11, 10)
#define	 CLKSEQ_BCH_CLK			__BITS(9, 8)
#define	 CLKSEQ_GPMI_CLK		__BITS(7, 6)
#define	 CLKSEQ_EPDC_AXI_CLK		__BITS(5, 4)
#define	 CLKSEQ_DISPLAY_AXI_CLK		__BITS(3, 2)
#define	 CLKSEQ_SYS_CLK			__BITS(1, 0)
#define	  CLKSEQ_XTAL			0
#define	  CLKSEQ_PFDx			1
#define	  CLKSEQ_PLL1			2
#define	  CLKSEQ_CAMP1			3
#define	CCMC_EPDC_PIX			0x00A0
#define	 EPDC_PIX_CLKGATE		__BITS(31, 30)
#define	 EPDC_PIX_CLKGATE_OFF		__SHIFTIN(0, EPDC_AXI_CLKGATE)
#define	 EPDC_PIX_CLKGATE_RUNMODE	__SHIFTIN(1, EPDC_AXI_CLKGATE)
#define	 EPDC_PIX_CLKGATE_ALWAYS	__SHIFTIN(2, EPDC_AXI_CLKGATE)
#define	 EPDC_PIX_CLKGATE_EXCEPTSTOP	__SHIFTIN(3, EPDC_AXI_CLKGATE)
#define	 EPDC_PIX_CLK_PRED		__BITS(13, 12)
#define	 EPDC_PIX_CLK_PODF		__BITS(11, 0)
#define	CCMC_EPDC_AXI			0x00A8
#define	 EPDC_AXI_CLKGATE		__BITS(31, 30)
#define	 EPDC_AXI_CLKGATE_OFF		__SHIFTIN(0, EPDC_AXI_CLKGATE)
#define	 EPDC_AXI_CLKGATE_RUNMODE	__SHIFTIN(1, EPDC_AXI_CLKGATE)
#define	 EPDC_AXI_CLKGATE_ALWAYS	__SHIFTIN(2, EPDC_AXI_CLKGATE)
#define	 EPDC_AXI_CLKGATE_EXCEPTSTOP	__SHIFTIN(3, EPDC_AXI_CLKGATE)
#define	 EPDC_ASM_EN			__BIT(9)
#define	 EPDC_ASM_SLOW_DIV		__BITS(8, 6)
#define	 EPDC_AXI_DIV			__BITS(5, 0)
#endif

#define	CCMC_SIZE	0x0100

/* CCGR Clock Gate Register */

#define	CCMR_CCGR_NSOURCE	16
#define	CCMR_CCGR_NGROUPS	7
#define	CCMR_CCGR_MODULE(clk)	((clk) / CCMR_CCGR_NSOURCE)
#define	__CCGR_NUM(a, b)	((a) * 16 + (b))
#define	CCGR_MODE_CLKOFF	0x0
#define	CCGR_MODE_CLKON		0x2

#ifdef IMX50
#define	CCGR_USBOH1_CLK			__CCGR_NUM(2, 13)
#define	CCGR_USBPHY1_CLK		__CCGR_NUM(4, 5)
#define	CCGR_EPDC_PIX_CLK		__CCGR_NUM(6, 5)
#define	CCGR_EPDC_AXI_CLK		__CCGR_NUM(6, 8)
#else
#define	CCGR_ARM_BUS_CLK		__CCGR_NUM(0, 0)
#define	CCGR_ARM_AXI_CLK		__CCGR_NUM(0, 1)
#define	CCGR_ARM_DEBUG_CLK		__CCGR_NUM(0, 2)
#define	CCGR_TZIC_CLK			__CCGR_NUM(0, 3)
#define	CCGR_DAP_CLK			__CCGR_NUM(0, 4)
#define	CCGR_TPIU_CLK			__CCGR_NUM(0, 5)
#define	CCGR_CTI2_CLK			__CCGR_NUM(0, 6)
#define	CCGR_CTI3_CLK			__CCGR_NUM(0, 7)
#define	CCGR_AHBMUX1_CLK		__CCGR_NUM(0, 8)
#define	CCGR_AHBMUX2_CLK		__CCGR_NUM(0, 9)
#define	CCGR_ROMCP_CLK			__CCGR_NUM(0, 10)
#define	CCGR_ROM_CLK			__CCGR_NUM(0, 11)
#define	CCGR_AIPS_TZ1_CLK		__CCGR_NUM(0, 12)
#define	CCGR_AIPS_TZ2_CLK		__CCGR_NUM(0, 13)
#define	CCGR_AHB_MAX_CLK		__CCGR_NUM(0, 14)
#define	CCGR_IIM_CLK			__CCGR_NUM(0, 15)
#define	CCGR_TMAX1_CLK			__CCGR_NUM(1, 0)
#define	CCGR_TMAX2_CLK			__CCGR_NUM(1, 1)
#define	CCGR_TMAX3_CLK			__CCGR_NUM(1, 2)
#define	CCGR_UART1_CLK			__CCGR_NUM(1, 3)
#define	CCGR_UART1_SERIAL_CLK		__CCGR_NUM(1, 4)
#define	CCGR_UART2_CLK			__CCGR_NUM(1, 5)
#define	CCGR_UART2_SERIAL_CLK		__CCGR_NUM(1, 6)
#define	CCGR_UART3_CLK			__CCGR_NUM(1, 7)
#define	CCGR_UART3_SERIAL_CLK		__CCGR_NUM(1, 8)
#define	CCGR_I2C1_SERIAL_CLK		__CCGR_NUM(1, 9)
#define	CCGR_I2C2_SERIAL_CLK		__CCGR_NUM(1, 10)
#define	CCGR_HSI2C_CLK			__CCGR_NUM(1, 11)
#define	CCGR_HSI2C_SERIAL_CLK		__CCGR_NUM(1, 12)
#define	CCGR_FIRI_CLK			__CCGR_NUM(1, 13)
#define	CCGR_FIRI_SERIAL_CLK		__CCGR_NUM(1, 14)
#define	CCGR_SCC_CLK			__CCGR_NUM(1, 15)
#define	CCGR_USB_PHY_CLK		__CCGR_NUM(2, 0)
#define	CCGR_EPIT1_CLK			__CCGR_NUM(2, 1)
#define	CCGR_EPIT1_SERIAL_CLK		__CCGR_NUM(2, 2)
#define	CCGR_EPIT2_CLK			__CCGR_NUM(2, 3)
#define	CCGR_ESDHC1_CLK			__CCGR_NUM(3, 0)
#define	CCGR_ESDHC1_SERIAL_CLK		__CCGR_NUM(3, 1)
#define	CCGR_ESDHC2_CLK			__CCGR_NUM(3, 2)
#define	CCGR_ESDHC2_SERIAL_CLK		__CCGR_NUM(3, 3)
#define	CCGR_ESDHC3_CLK			__CCGR_NUM(3, 4)
#define	CCGR_ESDHC3_SERIAL_CLK		__CCGR_NUM(3, 5)
#define	CCGR_ESDHC4_CLK			__CCGR_NUM(3, 6)
#define	CCGR_ESDHC4_SERIAL_CLK		__CCGR_NUM(3, 7)
#define	CCGR_SSI1_CLK			__CCGR_NUM(3, 8)
#define	CCGR_SSI1_SERIAL_CLK		__CCGR_NUM(3, 9)
#define	CCGR_SSI2_CLK			__CCGR_NUM(3, 10)
#define	CCGR_SSI2_SERIAL_CLK		__CCGR_NUM(3, 11)
#define	CCGR_SSI3_CLK			__CCGR_NUM(3, 12)
#define	CCGR_SSI3_SERIAL_CLK		__CCGR_NUM(3, 13)
#define	CCGR_SSI_EXT1_CLK		__CCGR_NUM(3, 14)
#define	CCGR_SSI_EXT2_CLK		__CCGR_NUM(3, 15)
#define	CCGR_PATA_CLK			__CCGR_NUM(4, 0)
#define	CCGR_SIM_CLK			__CCGR_NUM(4, 1)
#define	CCGR_SIM_SERIAL_CLK		__CCGR_NUM(4, 2)
#define	CCGR_SAHARA_CLK			__CCGR_NUM(4, 3)
#define	CCGR_RTIC_CLK			__CCGR_NUM(4, 4)
#define	CCGR_ECSPI1_CLK			__CCGR_NUM(4, 5)
#define	CCGR_ECSPI1_SERIAL_CLK		__CCGR_NUM(4, 6)
#define	CCGR_ECSPI2_CLK			__CCGR_NUM(4, 7)
#define	CCGR_ECSPI2_SERIAL_CLK		__CCGR_NUM(4, 8)
#define	CCGR_CSPI_CLK			__CCGR_NUM(4, 9)
#define	CCGR_SRTC_CLK			__CCGR_NUM(4, 10)
#define	CCGR_SDMA_CLK			__CCGR_NUM(4, 11)
#define	CCGR_SPBA_CLK			__CCGR_NUM(5, 0)
#define	CCGR_GPU_CLK			__CCGR_NUM(5, 1)
#define	CCGR_GARB_CLK			__CCGR_NUM(5, 2)
#define	CCGR_VPU_CLK			__CCGR_NUM(5, 3)
#define	CCGR_VPU_SERIAL_CLK		__CCGR_NUM(5, 4)
#define	CCGR_IPU_CLK			__CCGR_NUM(5, 5)
#define	CCGR_EMI_GARB_CLK		__CCGR_NUM(6, 0)
#define	CCGR_IPU_DI0_CLK		__CCGR_NUM(6, 1)
#define	CCGR_IPU_DI1_CLK		__CCGR_NUM(6, 2)
#define	CCGR_GPU2D_CLK			__CCGR_NUM(6, 3)
#define	CCGR_SLIMBUS_CLK		__CCGR_NUM(6, 4)
#define	CCGR_SLIMBUS_SERIAL_CLK		__CCGR_NUM(6, 5)
#endif

#endif /* _IMX51_CCMREG_H */

