/*	$NetBSD: timervar.h,v 1.13 2021/01/24 07:36:54 mrg Exp $	*/

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "opt_sparc_arch.h"

#if defined(SUN4) || defined(SUN4C)
int	clockintr_4(void *);
int	statintr_4(void *);
void	timer_init_4(void);

void	timerattach_obio_4(device_t, device_t, void *);
void	timerattach_mainbus_4c(device_t, device_t, void *);
#endif /* SUN4 || SUN4C */

#if defined(SUN4M)
int	clockintr_4m(void *);
int	statintr_4m(void *);
void	timer_init_4m(void);

void	timerattach_obio_4m(device_t, device_t, void *);
#endif /* SUN4M */

/* Imported from clock.c: */
extern int statvar, statmin, statint;
extern int timerblurb;
extern void (*timer_init)(void);
extern int (*eeprom_nvram_wenable)(int);
extern int oldclk;
extern int timerblurb;
void tickle_tc(void);

/* Common timer attach routine in timer.c: */
void	timerattach(volatile int *, volatile int *);
extern void	*sched_cookie;		/* for schedclock() interrupts */

static inline u_long __attribute__((__unused__))
new_interval(void)
{
	u_long newint, r, var;

	/*
	 * Compute new randomized interval.  The intervals are uniformly
	 * distributed on [statint - statvar / 2, statint + statvar / 2],
	 * and therefore have mean statint, giving a stathz frequency clock.
	 */
	var = statvar;
	do {
		r = random() & (var - 1);
	} while (r == 0);
	newint = statmin + r;
	return (newint);
}
