/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import org.openjsse.sun.security.ssl.Alert;
import org.openjsse.sun.security.ssl.ClientHandshakeContext;
import org.openjsse.sun.security.ssl.ConnectionContext;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.HandshakeOutStream;
import org.openjsse.sun.security.ssl.HandshakeProducer;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.RSAKeyExchange;
import org.openjsse.sun.security.ssl.Record;
import org.openjsse.sun.security.ssl.SSLConsumer;
import org.openjsse.sun.security.ssl.SSLCredentials;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLKeyDerivation;
import org.openjsse.sun.security.ssl.SSLKeyExchange;
import org.openjsse.sun.security.ssl.SSLLogger;
import org.openjsse.sun.security.ssl.SSLPossession;
import org.openjsse.sun.security.ssl.SSLTrafficKeyDerivation;
import org.openjsse.sun.security.ssl.ServerHandshakeContext;
import org.openjsse.sun.security.ssl.Utilities;
import org.openjsse.sun.security.ssl.X509Authentication;
import org.openjsse.sun.security.util.HexDumpEncoder;

final class RSAClientKeyExchange {
    static final SSLConsumer rsaHandshakeConsumer = new RSAClientKeyExchangeConsumer();
    static final HandshakeProducer rsaHandshakeProducer = new RSAClientKeyExchangeProducer();

    RSAClientKeyExchange() {
    }

    private static final class RSAClientKeyExchangeConsumer
    implements SSLConsumer {
        private RSAClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            PrivateKey privateKey;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            RSAKeyExchange.EphemeralRSAPossession rsaPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof RSAKeyExchange.EphemeralRSAPossession) {
                    rsaPossession = (RSAKeyExchange.EphemeralRSAPossession)possession;
                    break;
                }
                if (!(possession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)possession;
                if (rsaPossession == null) continue;
                break;
            }
            if (rsaPossession == null && x509Possession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA possessions negotiated for client key exchange");
            }
            PrivateKey privateKey2 = privateKey = rsaPossession != null ? rsaPossession.popPrivateKey : x509Possession.popPrivateKey;
            if (!privateKey.getAlgorithm().equals("RSA")) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not RSA private key for client key exchange");
            }
            RSAClientKeyExchangeMessage ckem = new RSAClientKeyExchangeMessage(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming RSA ClientKeyExchange handshake message", ckem);
            }
            try {
                RSAKeyExchange.RSAPremasterSecret premaster = RSAKeyExchange.RSAPremasterSecret.decode(shc, privateKey, ckem.encrypted);
                shc.handshakeCredentials.add(premaster);
            }
            catch (GeneralSecurityException gse) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot decode RSA premaster secret", gse);
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class RSAClientKeyExchangeProducer
    implements HandshakeProducer {
        private RSAClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            RSAClientKeyExchangeMessage ckem;
            PublicKey publicKey;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            RSAKeyExchange.EphemeralRSACredentials rsaCredentials = null;
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials credential : chc.handshakeCredentials) {
                if (credential instanceof RSAKeyExchange.EphemeralRSACredentials) {
                    rsaCredentials = (RSAKeyExchange.EphemeralRSACredentials)credential;
                    if (x509Credentials == null) continue;
                    break;
                }
                if (!(credential instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)credential;
                if (rsaCredentials == null) continue;
                break;
            }
            if (rsaCredentials == null && x509Credentials == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA credentials negotiated for client key exchange");
            }
            PublicKey publicKey2 = publicKey = rsaCredentials != null ? rsaCredentials.popPublicKey : x509Credentials.popPublicKey;
            if (!publicKey.getAlgorithm().equals("RSA")) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not RSA public key for client key exchange");
            }
            try {
                RSAKeyExchange.RSAPremasterSecret premaster = RSAKeyExchange.RSAPremasterSecret.createPremasterSecret(chc);
                chc.handshakePossessions.add(premaster);
                ckem = new RSAClientKeyExchangeMessage(chc, premaster, publicKey);
            }
            catch (GeneralSecurityException gse) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate RSA premaster secret", gse);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced RSA ClientKeyExchange handshake message", ckem);
            }
            ckem.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class RSAClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        final int protocolVersion;
        final boolean useTLS10PlusSpec;
        final byte[] encrypted;

        RSAClientKeyExchangeMessage(HandshakeContext context, RSAKeyExchange.RSAPremasterSecret premaster, PublicKey publicKey) throws GeneralSecurityException {
            super(context);
            this.protocolVersion = context.clientHelloVersion;
            this.encrypted = premaster.getEncoded(publicKey, context.sslContext.getSecureRandom());
            this.useTLS10PlusSpec = ProtocolVersion.useTLS10PlusSpec(this.protocolVersion, context.sslContext.isDTLS());
        }

        RSAClientKeyExchangeMessage(HandshakeContext context, ByteBuffer m) throws IOException {
            super(context);
            if (m.remaining() < 2) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid RSA ClientKeyExchange message: insufficient data");
            }
            this.protocolVersion = context.clientHelloVersion;
            this.useTLS10PlusSpec = ProtocolVersion.useTLS10PlusSpec(this.protocolVersion, context.sslContext.isDTLS());
            if (this.useTLS10PlusSpec) {
                this.encrypted = Record.getBytes16(m);
            } else {
                this.encrypted = new byte[m.remaining()];
                m.get(this.encrypted);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.useTLS10PlusSpec) {
                return this.encrypted.length + 2;
            }
            return this.encrypted.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            if (this.useTLS10PlusSpec) {
                hos.putBytes16(this.encrypted);
            } else {
                hos.write(this.encrypted);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"RSA ClientKeyExchange\": '{'\n  \"client_version\":  {0}\n  \"encncrypted\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{ProtocolVersion.nameOf(this.protocolVersion), Utilities.indent(hexEncoder.encodeBuffer(this.encrypted), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

