/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import sun.misc.JavaUtilZipFileAccess;
import sun.misc.PerfCounter;
import sun.misc.SharedSecrets;
import sun.misc.VM;

public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private final String name;
    private final int total;
    private final boolean locsig;
    private volatile boolean closeRequested = false;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private static final boolean ensuretrailingslash;
    private static final boolean disableInflaterCache;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams = new WeakHashMap<InputStream, Inflater>();
    private Deque<Inflater> inflaterCache = new ArrayDeque<Inflater>();
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        this(file, n, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n, Charset charset) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        long l = System.nanoTime();
        this.jzfile = ZipFile.open(string, n, file.lastModified(), usemmap);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(l);
        PerfCounter.getZipFileCount().increment();
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
        this.locsig = ZipFile.startsWithLOC(this.jzfile);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        this(new File(string), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            byte[] byArray = ZipFile.getCommentBytes(this.jzfile);
            if (byArray == null) {
                return null;
            }
            return this.zc.toString(byArray, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = ZipFile.getEntry(this.jzfile, this.zc.getBytes(string), true);
            if (l != 0L) {
                ZipEntry zipEntry = ensuretrailingslash ? this.getZipEntry(null, l) : this.getZipEntry(string, l);
                ZipFile.freeEntry(this.jzfile, l);
                return zipEntry;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw new NullPointerException("entry");
        }
        long l = 0L;
        ZipFileInputStream zipFileInputStream = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = !this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? ZipFile.getEntry(this.jzfile, this.zc.getBytesUTF8(zipEntry.name), false) : ZipFile.getEntry(this.jzfile, this.zc.getBytes(zipEntry.name), false);
            if (l == 0L) {
                return null;
            }
            zipFileInputStream = new ZipFileInputStream(l);
            switch (ZipFile.getEntryMethod(l)) {
                case 0: {
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(zipFileInputStream, null);
                    }
                    return zipFileInputStream;
                }
                case 8: {
                    long l2 = ZipFile.getEntrySize(l) + 2L;
                    if (l2 > 65536L) {
                        l2 = 8192L;
                    }
                    if (l2 <= 0L) {
                        l2 = 4096L;
                    }
                    Inflater inflater = this.getInflater();
                    ZipFileInflaterInputStream zipFileInflaterInputStream = new ZipFileInflaterInputStream(zipFileInputStream, inflater, (int)l2);
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(zipFileInflaterInputStream, inflater);
                    }
                    return zipFileInflaterInputStream;
                }
            }
            throw new ZipException("invalid compression method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        if (!disableInflaterCache) {
            Deque<Inflater> deque = this.inflaterCache;
            synchronized (deque) {
                Inflater inflater;
                while (null != (inflater = this.inflaterCache.poll())) {
                    if (inflater.ended()) continue;
                    return inflater;
                }
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        if (!inflater.ended()) {
            if (!disableInflaterCache) {
                inflater.reset();
                Deque<Inflater> deque = this.inflaterCache;
                synchronized (deque) {
                    this.inflaterCache.add(inflater);
                }
            } else {
                inflater.end();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        return new ZipEntryIterator();
    }

    public Stream<? extends ZipEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new ZipEntryIterator(), (long)this.size(), 1297), false);
    }

    private ZipEntry getZipEntry(String string, long l) {
        byte[] byArray;
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.flag = ZipFile.getEntryFlag(l);
        zipEntry.name = string != null ? string : ((byArray = ZipFile.getEntryBytes(l, 0)) == null ? "" : (!this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length)));
        zipEntry.xdostime = ZipFile.getEntryTime(l);
        zipEntry.crc = ZipFile.getEntryCrc(l);
        zipEntry.size = ZipFile.getEntrySize(l);
        zipEntry.csize = ZipFile.getEntryCSize(l);
        zipEntry.method = ZipFile.getEntryMethod(l);
        zipEntry.setExtra0(ZipFile.getEntryBytes(l, 1), false);
        byArray = ZipFile.getEntryBytes(l, 2);
        zipEntry.comment = byArray == null ? null : (!this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length));
        return zipEntry;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            Object object;
            Object object2 = this.streams;
            synchronized (object2) {
                if (!this.streams.isEmpty()) {
                    object = new HashMap<InputStream, Inflater>(this.streams);
                    this.streams.clear();
                    for (Map.Entry entry : object.entrySet()) {
                        ((InputStream)entry.getKey()).close();
                        Inflater inflater = (Inflater)entry.getValue();
                        if (inflater == null) continue;
                        inflater.end();
                    }
                }
            }
            object = this.inflaterCache;
            synchronized (object) {
                while (null != (object2 = this.inflaterCache.poll())) {
                    ((Inflater)object2).end();
                }
            }
            if (this.jzfile != 0L) {
                long l = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(l);
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private boolean startsWithLocHeader() {
        return this.locsig;
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native boolean startsWithLOC(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
        String string = VM.getSavedProperty("sun.zip.disableMemoryMapping");
        usemmap = string == null || string.length() != 0 && !string.equalsIgnoreCase("true");
        string = VM.getSavedProperty("jdk.util.zip.ensureTrailingSlash");
        ensuretrailingslash = string == null || !string.equalsIgnoreCase("false");
        string = VM.getSavedProperty("sun.zip.disableInflaterCache");
        disableInflaterCache = string != null && string.equalsIgnoreCase("true");
        SharedSecrets.setJavaUtilZipFileAccess(new JavaUtilZipFileAccess(){

            @Override
            public boolean startsWithLocHeader(ZipFile zipFile) {
                return zipFile.startsWithLocHeader();
            }
        });
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean zfisCloseRequested = false;
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l) {
            this.rem = ZipFile.getEntryCSize(l);
            this.size = ZipFile.getEntrySize(l);
            this.jzentry = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                long l = this.rem;
                long l2 = this.pos;
                if (l == 0L) {
                    return -1;
                }
                if (n2 <= 0) {
                    return 0;
                }
                if ((long)n2 > l) {
                    n2 = (int)l;
                }
                ZipFile.this.ensureOpenOrZipException();
                n2 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, l2, byArray, n, n2);
                if (n2 > 0) {
                    this.pos = l2 + (long)n2;
                    this.rem = l - (long)n2;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long l) {
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            if (this.rem == 0L) {
                this.close();
            }
            return l;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.zfisCloseRequested) {
                return;
            }
            this.zfisCloseRequested = true;
            this.rem = 0L;
            Object object = ZipFile.this;
            synchronized (object) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
            object = ZipFile.this.streams;
            synchronized (object) {
                ZipFile.this.streams.remove(this);
            }
        }

        protected void finalize() {
            this.close();
        }
    }

    private class ZipEntryIterator
    implements Enumeration<ZipEntry>,
    Iterator<ZipEntry> {
        private int i = 0;

        public ZipEntryIterator() {
            ZipFile.this.ensureOpen();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                return this.i < ZipFile.this.total;
            }
        }

        @Override
        public ZipEntry nextElement() {
            return this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZipEntry next() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                if (this.i >= ZipFile.this.total) {
                    throw new NoSuchElementException();
                }
                long l = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                if (l == 0L) {
                    String string = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                    throw new ZipError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                }
                ZipEntry zipEntry = ZipFile.this.getZipEntry(null, l);
                ZipFile.freeEntry(ZipFile.this.jzfile, l);
                return zipEntry;
            }
        }
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final ZipFileInputStream zfin;

        ZipFileInflaterInputStream(ZipFileInputStream zipFileInputStream, Inflater inflater, int n) {
            super(zipFileInputStream, inflater, n);
            this.closeRequested = false;
            this.eof = false;
            this.zfin = zipFileInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Inflater inflater;
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Map map = ZipFile.this.streams;
            synchronized (map) {
                inflater = (Inflater)ZipFile.this.streams.remove(this);
            }
            if (inflater != null) {
                ZipFile.this.releaseInflater(inflater);
            }
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long l = this.zfin.size() - this.inf.getBytesWritten();
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

