#!/usr/bin/python
###############################################################################
#                                                                             #
# Fireinfo                                                                    #
# Copyright (C) 2010, 2011 IPFire Team (www.ipfire.org)                       #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
###############################################################################

import os

SYS_CLASS_NET = "/sys/class/net"

class Network(object):
	def __init__(self):
		self._devices = os.listdir(SYS_CLASS_NET)

	def has_green(self):
		return "green0" in self._devices

	def has_red(self):
		for i in ("red0", "ppp0"):
			if i in self._devices:
				return True

		return False

	def has_blue(self):
		return "blue0" in self._devices

	def has_orange(self):
		return "orange0" in self._devices


if __name__ == "__main__":
	n = Network()

	print "has_green", n.has_green()
	print "has_red", n.has_red()
	print "has_blue", n.has_blue()
	print "has_orange", n.has_orange()
