import os
import string


class Device(object):
	def __init__(self, path):
		self.path=path
		self._uevent={}	
		with open(os.path.join(path, "uevent")) as f:
			for line in f.readlines():
				key, val = line.split("=")
				self._uevent[key]=val.rstrip().lower()
		
	@property
	def driver(self):
		return self._uevent.get("DRIVER", None)

			
class PCIDevice(Device):
	subsystem = "pci"
	
	@property
	def model(self):
		return self._uevent['PCI_ID'].split(":")[1]
		
	@property
	def vendor(self):
		return self._uevent['PCI_ID'].split(":")[0]

	@property
	def deviceclass(self):
		return self._uevent['PCI_CLASS']
	
	
class USBDevice(Device):
	subsystem = "usb"
	
	def pad(self, s):
		while len(s) < 4:
			s = "0"+s
		return s
		
	
	@property
	def vendor(self):
		return self.pad(self._uevent['PRODUCT'].split("/")[0])

	@property
	def model(self):
		return self.pad(self._uevent['PRODUCT'].split("/")[1])

	@property
	def deviceclass(self):
		return self._uevent.get("INTERFACE", None)


	
