
/*  A Bison parser, made from /home/gray/mailutils/sieve/./sieve-gram.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUMBER	257
#define	STRING	258
#define	IF	259
#define	ELSIF	260
#define	ELSE	261
#define	REJCT	262
#define	FILEINTO	263
#define	FORWARD	264
#define	KEEP	265
#define	STOP	266
#define	DISCARD	267
#define	VACATION	268
#define	REQUIRE	269
#define	SETFLAG	270
#define	ADDFLAG	271
#define	REMOVEFLAG	272
#define	MARK	273
#define	UNMARK	274
#define	NOTIFY	275
#define	DENOTIFY	276
#define	ANYOF	277
#define	ALLOF	278
#define	EXISTS	279
#define	SFALSE	280
#define	STRUE	281
#define	HEADER	282
#define	NOT	283
#define	SIZE	284
#define	ADDRESS	285
#define	ENVELOPE	286
#define	COMPARATOR	287
#define	IS	288
#define	CONTAINS	289
#define	MATCHES	290
#define	REGEX	291
#define	OVER	292
#define	UNDER	293
#define	ALL	294
#define	LOCALPART	295
#define	DOMAIN	296
#define	USER	297
#define	DETAIL	298
#define	DAYS	299
#define	ADDRESSES	300
#define	SUBJECT	301
#define	MIME	302
#define	LOW	303
#define	MEDIUM	304
#define	HIGH	305

#line 1 "sieve-gram.y"

/* sieve.y -- sieve parser
 * Larry Greenfield
 * $Id: sieve-gram.y,v 1.4 2002/08/28 11:52:47 gray Exp $
 */
/***********************************************************
        Copyright 1999 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Carnegie Mellon
University not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE FOR
ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
******************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "xalloc.h"
#include "comparator.h"
#include "interp.h"
#include "script.h"
#include "tree.h"
#include "sieve.h"
  
#include "util.h"
#include "imparse.h"

    /* definitions */
extern int addrparse(void);

struct vtags {
    int days;
    stringlist_t *addresses;
    char *subject;
    int mime;
};

struct htags {
    char *comparator;
    int comptag;
};

struct aetags {
    int addrtag;
    char *comparator;
    int comptag;
};

static commandlist_t *ret;
static sieve_script_t *parse_script;
static int check_reqs(stringlist_t *sl);
static test_t *build_address(int t, struct aetags *ae,
			     stringlist_t *sl, patternlist_t *pl);
static test_t *build_header(int t, struct htags *h,
			    stringlist_t *sl, patternlist_t *pl);
static commandlist_t *build_vacation(int t, struct vtags *h, char *s);
static struct aetags *new_aetags(void);
static struct aetags *canon_aetags(struct aetags *ae);
static void free_aetags(struct aetags *ae);
static struct htags *new_htags(void);
static struct htags *canon_htags(struct htags *h);
static void free_htags(struct htags *h);
static struct vtags *new_vtags(void);
static struct vtags *canon_vtags(struct vtags *v);
static void free_vtags(struct vtags *v);

static int verify_mailboxes(stringlist_t *sl);
static int verify_addresses(stringlist_t *sl);
static int verify_flags(stringlist_t *sl);
#ifdef ENABLE_REGEX
static patternlist_t *verify_regexs(stringlist_t *sl, char *comp);
#endif
static int ok_header(char *s);

int yyerror(char *msg);
extern int yylex(void);

#define YYERROR_VERBOSE /* i want better error messages! */

#line 99 "sieve-gram.y"
typedef union {
    int nval;
    char *sval;
    stringlist_t *sl;
    test_t *test;
    testlist_t *testl;
    commandlist_t *cl;
    struct vtags *vtag;
    struct aetags *aetag;
    struct htags *htag;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		121
#define	YYFLAG		-32768
#define	YYNTBASE	60

#define YYTRANSLATE(x) ((unsigned)(x) <= 305 ? yytranslate[x] : 82)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    58,
    59,     2,     2,    55,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    52,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    53,     2,    54,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    56,     2,    57,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     3,     6,     7,    10,    14,    16,    19,    22,
    27,    30,    31,    36,    39,    42,    45,    48,    50,    52,
    54,    58,    61,    64,    67,    69,    71,    76,    78,    79,
    81,    83,    85,    86,    88,    89,    93,    97,   101,   104,
   108,   110,   112,   116,   120,   123,   126,   129,   132,   134,
   136,   141,   146,   149,   153,   155,   157,   159,   160,   163,
   166,   170,   171,   174,   178,   180,   182,   184,   186,   188,
   190,   192,   194,   196,   198,   200,   204,   206
};

static const short yyrhs[] = {    -1,
    61,     0,    61,    63,     0,     0,    62,    61,     0,    15,
    70,    52,     0,    64,     0,    64,    63,     0,    66,    52,
     0,     5,    73,    72,    65,     0,     1,    52,     0,     0,
     6,    73,    72,    65,     0,     7,    72,     0,     8,     4,
     0,     9,    70,     0,    10,    70,     0,    11,     0,    12,
     0,    13,     0,    14,    69,     4,     0,    16,    70,     0,
    17,    70,     0,    18,    70,     0,    19,     0,    20,     0,
    21,    67,     4,    68,     0,    22,     0,     0,    49,     0,
    50,     0,    51,     0,     0,    70,     0,     0,    69,    45,
     3,     0,    69,    46,    70,     0,    69,    47,     4,     0,
    69,    48,     0,    53,    71,    54,     0,     4,     0,     4,
     0,     4,    55,    71,     0,    56,    63,    57,     0,    56,
    57,     0,    23,    80,     0,    24,    80,     0,    25,    70,
     0,    26,     0,    27,     0,    28,    76,    70,    70,     0,
    74,    75,    70,    70,     0,    29,    73,     0,    30,    79,
     3,     0,     1,     0,    31,     0,    32,     0,     0,    75,
    77,     0,    75,    78,     0,    75,    33,     4,     0,     0,
    76,    78,     0,    76,    33,     4,     0,    40,     0,    41,
     0,    42,     0,    43,     0,    44,     0,    34,     0,    35,
     0,    36,     0,    37,     0,    38,     0,    39,     0,    58,
    81,    59,     0,    73,     0,    73,    55,    81,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   136,   137,   138,   141,   142,   145,   151,   152,   155,   156,
   157,   160,   161,   162,   165,   170,   179,   184,   185,   186,
   187,   195,   204,   213,   222,   227,   233,   245,   253,   254,
   255,   256,   259,   262,   265,   266,   269,   276,   282,   288,
   289,   292,   293,   296,   297,   300,   301,   302,   303,   304,
   305,   319,   333,   334,   336,   339,   340,   343,   344,   349,
   353,   359,   360,   364,   371,   372,   373,   374,   379,   386,
   387,   388,   389,   396,   397,   399,   402,   403
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMBER",
"STRING","IF","ELSIF","ELSE","REJCT","FILEINTO","FORWARD","KEEP","STOP","DISCARD",
"VACATION","REQUIRE","SETFLAG","ADDFLAG","REMOVEFLAG","MARK","UNMARK","NOTIFY",
"DENOTIFY","ANYOF","ALLOF","EXISTS","SFALSE","STRUE","HEADER","NOT","SIZE","ADDRESS",
"ENVELOPE","COMPARATOR","IS","CONTAINS","MATCHES","REGEX","OVER","UNDER","ALL",
"LOCALPART","DOMAIN","USER","DETAIL","DAYS","ADDRESSES","SUBJECT","MIME","LOW",
"MEDIUM","HIGH","';'","'['","']'","','","'{'","'}'","'('","')'","start","reqs",
"require","commands","command","elsif","action","priority","optional_headers",
"vtags","stringlist","strings","block","test","addrorenv","aetags","htags","addrparttag",
"comptag","sizetag","testlist","tests", NULL
};
#endif

static const short yyr1[] = {     0,
    60,    60,    60,    61,    61,    62,    63,    63,    64,    64,
    64,    65,    65,    65,    66,    66,    66,    66,    66,    66,
    66,    66,    66,    66,    66,    66,    66,    66,    67,    67,
    67,    67,    68,    68,    69,    69,    69,    69,    69,    70,
    70,    71,    71,    72,    72,    73,    73,    73,    73,    73,
    73,    73,    73,    73,    73,    74,    74,    75,    75,    75,
    75,    76,    76,    76,    77,    77,    77,    77,    77,    78,
    78,    78,    78,    79,    79,    80,    81,    81
};

static const short yyr2[] = {     0,
     0,     1,     2,     0,     2,     3,     1,     2,     2,     4,
     2,     0,     4,     2,     2,     2,     2,     1,     1,     1,
     3,     2,     2,     2,     1,     1,     4,     1,     0,     1,
     1,     1,     0,     1,     0,     3,     3,     3,     2,     3,
     1,     1,     3,     3,     2,     2,     2,     2,     1,     1,
     4,     4,     2,     3,     1,     1,     1,     0,     2,     2,
     3,     0,     2,     3,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     3,     1,     3
};

static const short yydefact[] = {     4,
     0,     0,     4,    41,     0,     0,     0,     0,     0,     0,
     0,    18,    19,    20,    35,     0,     0,     0,    25,    26,
    29,    28,     3,     0,     0,     5,    42,     0,     6,    11,
    55,     0,     0,     0,    49,    50,    62,     0,     0,    56,
    57,     0,    58,    15,    16,    17,     0,    22,    23,    24,
    30,    31,    32,     0,     8,     9,     0,    40,     0,    46,
    47,    48,     0,    53,    74,    75,     0,     0,    12,     0,
    21,     0,     0,     0,    39,    33,    43,    77,     0,     0,
    70,    71,    72,    73,     0,    63,    54,    45,     0,     0,
     0,    10,     0,    65,    66,    67,    68,    69,     0,    59,
    60,    36,    37,    38,    27,    34,     0,    76,    64,    51,
    44,     0,    14,    61,    52,    78,    12,    13,     0,     0,
     0
};

static const short yydefgoto[] = {   119,
     2,     3,    23,    24,    92,    25,    54,   105,    47,     6,
    28,    69,    78,    43,    70,    63,   100,    86,    67,    60,
    79
};

static const short yypact[] = {    62,
     1,   132,   -11,-32768,     9,   -29,     7,    87,    42,     1,
     1,-32768,-32768,-32768,-32768,     1,     1,     1,-32768,-32768,
   -40,-32768,-32768,    17,    12,-32768,    13,    11,-32768,-32768,
-32768,    15,    15,     1,-32768,-32768,-32768,    87,   -23,-32768,
-32768,    16,-32768,-32768,-32768,-32768,    10,-32768,-32768,-32768,
-32768,-32768,-32768,    63,-32768,-32768,     9,-32768,    87,-32768,
-32768,-32768,    72,-32768,-32768,-32768,    66,    82,    14,     8,
-32768,    67,     1,    74,-32768,     1,-32768,    24,    21,    77,
-32768,-32768,-32768,-32768,     1,-32768,-32768,-32768,    25,    87,
    16,-32768,    81,-32768,-32768,-32768,-32768,-32768,     1,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    87,-32768,-32768,-32768,
-32768,    16,-32768,-32768,-32768,-32768,    14,-32768,    71,    86,
-32768
};

static const short yypgoto[] = {-32768,
    94,-32768,   -21,-32768,     3,-32768,-32768,-32768,-32768,   -10,
    64,   -72,    -6,-32768,-32768,-32768,-32768,    52,-32768,    90,
    19
};


#define	YYLAST		154


static const short yytable[] = {    45,
    46,    42,    55,     1,     4,    48,    49,    50,    51,    52,
    53,     4,    27,    71,    65,    66,    -7,     7,   113,    90,
    91,     8,    29,    62,     9,    10,    11,    12,    13,    14,
    15,    64,    16,    17,    18,    19,    20,    21,    22,   117,
    93,    81,    82,    83,    84,    44,    89,    94,    95,    96,
    97,    98,    85,     5,    72,    73,    74,    75,    30,    99,
     5,    -1,   103,    56,    58,   106,    76,    57,    87,   102,
   120,    68,    59,    -7,   110,     4,     1,   104,   107,   108,
   109,   111,     7,   112,   114,   121,     8,    31,   115,     9,
    10,    11,    12,    13,    14,    15,    26,    16,    17,    18,
    19,    20,    21,    22,    80,    81,    82,    83,    84,    32,
    33,    34,    35,    36,    37,    38,    39,    40,    41,   118,
    77,   101,    61,     0,     5,   116,     0,     0,     0,     0,
     0,    -2,     7,     0,     0,     0,     8,     0,    88,     9,
    10,    11,    12,    13,    14,    15,     0,    16,    17,    18,
    19,    20,    21,    22
};

static const short yycheck[] = {    10,
    11,     8,    24,    15,     4,    16,    17,    18,    49,    50,
    51,     4,     4,     4,    38,    39,     0,     1,    91,     6,
     7,     5,    52,    34,     8,     9,    10,    11,    12,    13,
    14,    38,    16,    17,    18,    19,    20,    21,    22,   112,
    33,    34,    35,    36,    37,     4,    68,    40,    41,    42,
    43,    44,    63,    53,    45,    46,    47,    48,    52,    70,
    53,     0,    73,    52,    54,    76,     4,    55,     3,     3,
     0,    56,    58,    57,    85,     4,    15,     4,    55,    59,
     4,    57,     1,    90,     4,     0,     5,     1,    99,     8,
     9,    10,    11,    12,    13,    14,     3,    16,    17,    18,
    19,    20,    21,    22,    33,    34,    35,    36,    37,    23,
    24,    25,    26,    27,    28,    29,    30,    31,    32,   117,
    57,    70,    33,    -1,    53,   107,    -1,    -1,    -1,    -1,
    -1,     0,     1,    -1,    -1,    -1,     5,    -1,    57,     8,
     9,    10,    11,    12,    13,    14,    -1,    16,    17,    18,
    19,    20,    21,    22
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 136 "sieve-gram.y"
{ ret = NULL; ;
    break;}
case 2:
#line 137 "sieve-gram.y"
{ ret = NULL; ;
    break;}
case 3:
#line 138 "sieve-gram.y"
{ ret = yyvsp[0].cl; ;
    break;}
case 6:
#line 145 "sieve-gram.y"
{ if (!check_reqs(yyvsp[-1].sl)) {
                                    yyerror("unsupported feature");
				    YYERROR;
                                  } ;
    break;}
case 7:
#line 151 "sieve-gram.y"
{ yyval.cl = yyvsp[0].cl; ;
    break;}
case 8:
#line 152 "sieve-gram.y"
{ yyvsp[-1].cl->next = yyvsp[0].cl; yyval.cl = yyvsp[-1].cl; ;
    break;}
case 9:
#line 155 "sieve-gram.y"
{ yyval.cl = yyvsp[-1].cl; ;
    break;}
case 10:
#line 156 "sieve-gram.y"
{ yyval.cl = new_if(yyvsp[-2].test, yyvsp[-1].cl, yyvsp[0].cl); ;
    break;}
case 11:
#line 157 "sieve-gram.y"
{ yyval.cl = new_command(STOP); ;
    break;}
case 12:
#line 160 "sieve-gram.y"
{ yyval.cl = NULL; ;
    break;}
case 13:
#line 161 "sieve-gram.y"
{ yyval.cl = new_if(yyvsp[-2].test, yyvsp[-1].cl, yyvsp[0].cl); ;
    break;}
case 14:
#line 162 "sieve-gram.y"
{ yyval.cl = yyvsp[0].cl; ;
    break;}
case 15:
#line 165 "sieve-gram.y"
{ if (!parse_script->support.reject) {
				     yyerror("reject not required");
				     YYERROR;
				   }
				   yyval.cl = new_command(REJCT); yyval.cl->u.str = yyvsp[0].sval; ;
    break;}
case 16:
#line 170 "sieve-gram.y"
{ if (!parse_script->support.fileinto) {
				     yyerror("fileinto not required");
	                             YYERROR;
                                   }
				   if (!verify_mailboxes(yyvsp[0].sl)) {
				     YYERROR; /* vm should call yyerror() */
				   }
	                           yyval.cl = new_command(FILEINTO);
				   yyval.cl->u.sl = yyvsp[0].sl; ;
    break;}
case 17:
#line 179 "sieve-gram.y"
{ yyval.cl = new_command(FORWARD);
				   if (!verify_addresses(yyvsp[0].sl)) {
				     YYERROR; /* va should call yyerror() */
				   }
				   yyval.cl->u.sl = yyvsp[0].sl; ;
    break;}
case 18:
#line 184 "sieve-gram.y"
{ yyval.cl = new_command(KEEP); ;
    break;}
case 19:
#line 185 "sieve-gram.y"
{ yyval.cl = new_command(STOP); ;
    break;}
case 20:
#line 186 "sieve-gram.y"
{ yyval.cl = new_command(DISCARD); ;
    break;}
case 21:
#line 187 "sieve-gram.y"
{ if (!parse_script->support.vacation) {
				     yyerror("vacation not required");
				     yyval.cl = new_command(VACATION);
				     YYERROR;
				   } else {
  				     yyval.cl = build_vacation(VACATION,
					    canon_vtags(yyvsp[-1].vtag), yyvsp[0].sval);
				   } ;
    break;}
case 22:
#line 195 "sieve-gram.y"
{ if (!parse_script->support.imapflags) {
                                    yyerror("imapflags not required");
                                    YYERROR;
                                   }
                                  if (!verify_flags(yyvsp[0].sl)) {
                                    YYERROR; /* vf should call yyerror() */
                                  }
                                  yyval.cl = new_command(SETFLAG);
                                  yyval.cl->u.sl = yyvsp[0].sl; ;
    break;}
case 23:
#line 204 "sieve-gram.y"
{ if (!parse_script->support.imapflags) {
                                    yyerror("imapflags not required");
                                    YYERROR;
                                    }
                                  if (!verify_flags(yyvsp[0].sl)) {
                                    YYERROR; /* vf should call yyerror() */
                                  }
                                  yyval.cl = new_command(ADDFLAG);
                                  yyval.cl->u.sl = yyvsp[0].sl; ;
    break;}
case 24:
#line 213 "sieve-gram.y"
{ if (!parse_script->support.imapflags) {
                                    yyerror("imapflags not required");
                                    YYERROR;
                                    }
                                  if (!verify_flags(yyvsp[0].sl)) {
                                    YYERROR; /* vf should call yyerror() */
                                  }
                                  yyval.cl = new_command(REMOVEFLAG);
                                  yyval.cl->u.sl = yyvsp[0].sl; ;
    break;}
case 25:
#line 222 "sieve-gram.y"
{ if (!parse_script->support.imapflags) {
                                    yyerror("imapflags not required");
                                    YYERROR;
                                    }
                                  yyval.cl = new_command(MARK); ;
    break;}
case 26:
#line 227 "sieve-gram.y"
{ if (!parse_script->support.imapflags) {
                                    yyerror("imapflags not required");
                                    YYERROR;
                                    }
                                  yyval.cl = new_command(UNMARK); ;
    break;}
case 27:
#line 234 "sieve-gram.y"
{
					if (!parse_script->support.notify) {
					    yyerror("notify not required");
					    YYERROR;
					}

					yyval.cl = new_command(NOTIFY);
					yyval.cl->u.n.priority = yyvsp[-2].sval;
					yyval.cl->u.n.message = yyvsp[-1].sval;
					yyval.cl->u.n.headers_list = yyvsp[0].sl;
				    ;
    break;}
case 28:
#line 245 "sieve-gram.y"
{ if (!parse_script->support.notify) {
                                    yyerror("notify not required");
                                    YYERROR;
                                    }
	                            yyval.cl = new_command(DENOTIFY); ;
    break;}
case 29:
#line 253 "sieve-gram.y"
{ yyval.sval = "medium"; ;
    break;}
case 30:
#line 254 "sieve-gram.y"
{ yyval.sval = "low"; ;
    break;}
case 31:
#line 255 "sieve-gram.y"
{ yyval.sval = "medium"; ;
    break;}
case 32:
#line 256 "sieve-gram.y"
{ yyval.sval = "high"; ;
    break;}
case 33:
#line 259 "sieve-gram.y"
{
				yyval.sl = NULL;
	                      ;
    break;}
case 34:
#line 262 "sieve-gram.y"
{ yyval.sl = yyvsp[0].sl; ;
    break;}
case 35:
#line 265 "sieve-gram.y"
{ yyval.vtag = new_vtags(); ;
    break;}
case 36:
#line 266 "sieve-gram.y"
{ if (yyval.vtag->days != -1) {
					yyerror("duplicate :days"); YYERROR; }
				   else { yyval.vtag->days = yyvsp[0].nval; } ;
    break;}
case 37:
#line 269 "sieve-gram.y"
{ if (yyval.vtag->addresses != NULL) {
					yyerror("duplicate :addresses");
					YYERROR;
				       } else if (!verify_addresses(yyvsp[0].sl)) {
					  YYERROR;
				       } else {
					 yyval.vtag->addresses = yyvsp[0].sl; } ;
    break;}
case 38:
#line 276 "sieve-gram.y"
{ if (yyval.vtag->subject != NULL) {
					yyerror("duplicate :subject");
					YYERROR;
				   } else if (!ok_header(yyvsp[0].sval)) {
					YYERROR;
				   } else { yyval.vtag->subject = yyvsp[0].sval; } ;
    break;}
case 39:
#line 282 "sieve-gram.y"
{ if (yyval.vtag->mime != -1) {
					yyerror("duplicate :mime");
					YYERROR; }
				   else { yyval.vtag->mime = MIME; } ;
    break;}
case 40:
#line 288 "sieve-gram.y"
{ yyval.sl = yyvsp[-1].sl; ;
    break;}
case 41:
#line 289 "sieve-gram.y"
{ yyval.sl = new_sl(yyvsp[0].sval, NULL); ;
    break;}
case 42:
#line 292 "sieve-gram.y"
{ yyval.sl = new_sl(yyvsp[0].sval, NULL); ;
    break;}
case 43:
#line 293 "sieve-gram.y"
{ yyval.sl = new_sl(yyvsp[-2].sval, yyvsp[0].sl); ;
    break;}
case 44:
#line 296 "sieve-gram.y"
{ yyval.cl = yyvsp[-1].cl; ;
    break;}
case 45:
#line 297 "sieve-gram.y"
{ yyval.cl = NULL; ;
    break;}
case 46:
#line 300 "sieve-gram.y"
{ yyval.test = new_test(ANYOF); yyval.test->u.tl = yyvsp[0].testl; ;
    break;}
case 47:
#line 301 "sieve-gram.y"
{ yyval.test = new_test(ALLOF); yyval.test->u.tl = yyvsp[0].testl; ;
    break;}
case 48:
#line 302 "sieve-gram.y"
{ yyval.test = new_test(EXISTS); yyval.test->u.sl = yyvsp[0].sl; ;
    break;}
case 49:
#line 303 "sieve-gram.y"
{ yyval.test = new_test(SFALSE); ;
    break;}
case 50:
#line 304 "sieve-gram.y"
{ yyval.test = new_test(STRUE); ;
    break;}
case 51:
#line 306 "sieve-gram.y"
{ patternlist_t *pl;
				   yyvsp[-2].htag = canon_htags(yyvsp[-2].htag);
#ifdef ENABLE_REGEX
				   if (yyvsp[-2].htag->comptag == REGEX) {
				     pl = verify_regexs(yyvsp[0].sl, yyvsp[-2].htag->comparator);
				     if (!pl) { YYERROR; }
				   }
				   else
#endif
				     pl = (patternlist_t *) yyvsp[0].sl;

				   yyval.test = build_header(HEADER, yyvsp[-2].htag, yyvsp[-1].sl, pl);
				   if (yyval.test == NULL) { YYERROR; } ;
    break;}
case 52:
#line 320 "sieve-gram.y"
{ patternlist_t *pl;
				   yyvsp[-2].aetag = canon_aetags(yyvsp[-2].aetag);
#ifdef ENABLE_REGEX
				   if (yyvsp[-2].aetag->comptag == REGEX) {
				     pl = verify_regexs(yyvsp[0].sl, yyvsp[-2].aetag->comparator);
				     if (!pl) { YYERROR; }
				   }
				   else
#endif
				     pl = (patternlist_t *) yyvsp[0].sl;

				   yyval.test = build_address(yyvsp[-3].nval, yyvsp[-2].aetag, yyvsp[-1].sl, pl);
				   if (yyval.test == NULL) { YYERROR; } ;
    break;}
case 53:
#line 333 "sieve-gram.y"
{ yyval.test = new_test(NOT); yyval.test->u.t = yyvsp[0].test; ;
    break;}
case 54:
#line 334 "sieve-gram.y"
{ yyval.test = new_test(SIZE); yyval.test->u.sz.t = yyvsp[-1].nval;
		                   yyval.test->u.sz.n = yyvsp[0].nval; ;
    break;}
case 55:
#line 336 "sieve-gram.y"
{ yyval.test = NULL; ;
    break;}
case 56:
#line 339 "sieve-gram.y"
{ yyval.nval = ADDRESS; ;
    break;}
case 57:
#line 340 "sieve-gram.y"
{ yyval.nval = ENVELOPE; ;
    break;}
case 58:
#line 343 "sieve-gram.y"
{ yyval.aetag = new_aetags(); ;
    break;}
case 59:
#line 344 "sieve-gram.y"
{ yyval.aetag = yyvsp[-1].aetag;
				   if (yyval.aetag->addrtag != -1) {
			yyerror("duplicate or conflicting address part tag");
			YYERROR; }
				   else { yyval.aetag->addrtag = yyvsp[0].nval; } ;
    break;}
case 60:
#line 349 "sieve-gram.y"
{ yyval.aetag = yyvsp[-1].aetag;
				   if (yyval.aetag->comptag != -1) {
			yyerror("duplicate comparator type tag"); YYERROR; }
				   else { yyval.aetag->comptag = yyvsp[0].nval; } ;
    break;}
case 61:
#line 353 "sieve-gram.y"
{ yyval.aetag = yyvsp[-2].aetag;
				   if (yyval.aetag->comparator != NULL) {
			yyerror("duplicate comparator tag"); YYERROR; }
				   else { yyval.aetag->comparator = yyvsp[0].sval; } ;
    break;}
case 62:
#line 359 "sieve-gram.y"
{ yyval.htag = new_htags(); ;
    break;}
case 63:
#line 360 "sieve-gram.y"
{ yyval.htag = yyvsp[-1].htag;
				   if (yyval.htag->comptag != -1) {
			yyerror("duplicate comparator type tag"); YYERROR; }
				   else { yyval.htag->comptag = yyvsp[0].nval; } ;
    break;}
case 64:
#line 364 "sieve-gram.y"
{ yyval.htag = yyvsp[-2].htag;
				   if (yyval.htag->comparator != NULL) {
			yyerror("duplicate comparator tag");
					YYERROR; }
				   else { yyval.htag->comparator = yyvsp[0].sval; } ;
    break;}
case 65:
#line 371 "sieve-gram.y"
{ yyval.nval = ALL; ;
    break;}
case 66:
#line 372 "sieve-gram.y"
{ yyval.nval = LOCALPART; ;
    break;}
case 67:
#line 373 "sieve-gram.y"
{ yyval.nval = DOMAIN; ;
    break;}
case 68:
#line 374 "sieve-gram.y"
{ if (!parse_script->support.subaddress) {
				     yyerror("subaddress not required");
				     YYERROR;
				   }
				   yyval.nval = USER; ;
    break;}
case 69:
#line 379 "sieve-gram.y"
{ if (!parse_script->support.subaddress) {
				     yyerror("subaddress not required");
				     YYERROR;
				   }
				   yyval.nval = DETAIL; ;
    break;}
case 70:
#line 386 "sieve-gram.y"
{ yyval.nval = IS; ;
    break;}
case 71:
#line 387 "sieve-gram.y"
{ yyval.nval = CONTAINS; ;
    break;}
case 72:
#line 388 "sieve-gram.y"
{ yyval.nval = MATCHES; ;
    break;}
case 73:
#line 389 "sieve-gram.y"
{ if (!parse_script->support.regex) {
				     yyerror("regex not required");
				     YYERROR;
				   }
				   yyval.nval = REGEX; ;
    break;}
case 74:
#line 396 "sieve-gram.y"
{ yyval.nval = OVER; ;
    break;}
case 75:
#line 397 "sieve-gram.y"
{ yyval.nval = UNDER; ;
    break;}
case 76:
#line 399 "sieve-gram.y"
{ yyval.testl = yyvsp[-1].testl; ;
    break;}
case 77:
#line 402 "sieve-gram.y"
{ yyval.testl = new_testlist(yyvsp[0].test, NULL); ;
    break;}
case 78:
#line 403 "sieve-gram.y"
{ yyval.testl = new_testlist(yyvsp[-2].test, yyvsp[0].testl); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 406 "sieve-gram.y"


commandlist_t *sieve_parse(sieve_script_t *script, FILE *f)
{
    commandlist_t *t;
    extern FILE *yyin;

    yyin = f;
    parse_script = script;
    if (yyparse()) {
	t = NULL;
    } else {
	t = ret;
    }
    ret = NULL;
    return t;
}

int yyerror(char *msg)
{
    extern int yylineno;
    int ret;

    parse_script->err++;
    if (parse_script->interp.err) {
	ret = parse_script->interp.err(yylineno, msg,
				       parse_script->interp.interp_context,
				       parse_script->script_context);
    }

    return 0;
}

static int check_reqs(stringlist_t *sl)
{
    int i = 1;
    stringlist_t *s;

    while (sl != NULL) {
	s = sl;
	sl = sl->next;

	i &= script_require(parse_script, s->s);

	if (s->s) free(s->s);
	free(s);
    }
    return i;
}

static test_t *build_address(int t, struct aetags *ae,
			     stringlist_t *sl, patternlist_t *pl)
{
    test_t *ret = new_test(t);	/* can be either ADDRESS or ENVELOPE */

    assert((t == ADDRESS) || (t == ENVELOPE));

    if (ret) {
	ret->u.ae.comptag = ae->comptag;
	ret->u.ae.comp = lookup_comp(ae->comparator, ae->comptag);
	ret->u.ae.sl = sl;
	ret->u.ae.pl = pl;
	ret->u.ae.addrpart = ae->addrtag;
	free_aetags(ae);
	if (ret->u.ae.comp == NULL) {
	    free_test(ret);
	    ret = NULL;
	}
    }
    return ret;
}

static test_t *build_header(int t, struct htags *h,
			    stringlist_t *sl, patternlist_t *pl)
{
    test_t *ret = new_test(t);	/* can be HEADER */

    assert(t == HEADER);

    if (ret) {
	ret->u.h.comptag = h->comptag;
	ret->u.h.comp = lookup_comp(h->comparator, h->comptag);
	ret->u.h.sl = sl;
	ret->u.h.pl = pl;
	free_htags(h);
	if (ret->u.h.comp == NULL) {
	    free_test(ret);
	    ret = NULL;
	}
    }
    return ret;
}

static commandlist_t *build_vacation(int t, struct vtags *v, char *reason)
{
    commandlist_t *ret = new_command(t);

    assert(t == VACATION);

    if (ret) {
	ret->u.v.subject = v->subject; v->subject = NULL;
	ret->u.v.days = v->days;
	ret->u.v.mime = v->mime;
	ret->u.v.addresses = v->addresses; v->addresses = NULL;
	free_vtags(v);
	ret->u.v.message = reason;
    }
    return ret;
}

static struct aetags *new_aetags(void)
{
    struct aetags *r = (struct aetags *) xmalloc(sizeof(struct aetags));

    r->addrtag = r->comptag = -1;
    r->comparator = NULL;

    return r;
}

static struct aetags *canon_aetags(struct aetags *ae)
{
    if (ae->addrtag == -1) { ae->addrtag = ALL; }
    if (ae->comparator == NULL) { ae->comparator = strdup("i;ascii-casemap"); }
    if (ae->comptag == -1) { ae->comptag = IS; }
    return ae;
}

static void free_aetags(struct aetags *ae)
{
    free(ae->comparator);
    free(ae);
}

static struct htags *new_htags(void)
{
    struct htags *r = (struct htags *) xmalloc(sizeof(struct htags));

    r->comptag = -1;
    r->comparator = NULL;

    return r;
}

static struct htags *canon_htags(struct htags *h)
{
    if (h->comparator == NULL) { h->comparator = strdup("i;ascii-casemap"); }
    if (h->comptag == -1) { h->comptag = IS; }
    return h;
}

static void free_htags(struct htags *h)
{
    free(h->comparator);
    free(h);
}

static struct vtags *new_vtags(void)
{
    struct vtags *r = (struct vtags *) xmalloc(sizeof(struct vtags));

    r->days = -1;
    r->addresses = NULL;
    r->subject = NULL;
    r->mime = -1;

    return r;
}

static struct vtags *canon_vtags(struct vtags *v)
{
    assert(parse_script->interp.vacation != NULL);

    if (v->days == -1) { v->days = 7; }
    if (v->days < parse_script->interp.vacation->min_response)
       { v->days = parse_script->interp.vacation->min_response; }
    if (v->days > parse_script->interp.vacation->max_response)
       { v->days = parse_script->interp.vacation->max_response; }
    if (v->mime == -1) { v->mime = 0; }

    return v;
}

static void free_vtags(struct vtags *v)
{
    if (v->addresses) { free_sl(v->addresses); }
    if (v->subject) { free(v->subject); }
    free(v);
}

char *addrptr;		/* pointer to address string for address lexer */
char addrerr[500];	/* buffer for address parser error messages */

static int verify_address(char *s)
{
    char errbuf[500];

    addrptr = s;
    if (addrparse()) {
	sprintf(errbuf, "address '%s': %s", s, addrerr);
	yyerror(errbuf);
	return 0;
    }
    return 1;
}

static int verify_addresses(stringlist_t *sl)
{
    for (; sl != NULL && verify_address(sl->s); sl = sl->next) ;
    return (sl == NULL);
}

static int verify_mailbox(char *s)
{
    /* if not a mailbox, call yyerror */
    return 1;
}

static int verify_mailboxes(stringlist_t *sl)
{
    for (; sl != NULL && verify_mailbox(sl->s); sl = sl->next) ;
    return (sl == NULL);
}

static int verify_flag(char *f)
{
    char errbuf[100];

    if (f[0] == '\\') {
	strlower(f);
	if (strcmp(f, "\\seen") && strcmp(f, "\\answered") &&
	    strcmp(f, "\\flagged") && strcmp(f, "\\draft") &&
	    strcmp(f, "\\deleted")) {
	    sprintf(errbuf, "flag '%s': not a system flag", f);
	    yyerror(errbuf);
	    return 0;
	}
	return 1;
    }
    if (!imparse_isatom(f)) {
	sprintf(errbuf, "flag '%s': not a valid keyword", f);
	yyerror(errbuf);
	return 0;
    }
    return 1;
}

static int verify_flags(stringlist_t *sl)
{
    for (; sl != NULL && verify_flag(sl->s); sl = sl->next) ;
    return (sl == NULL);
}


#ifdef ENABLE_REGEX
static regex_t *verify_regex(char *s, int cflags)
{
    int ret;
    char errbuf[100];
    regex_t *reg = (regex_t *) xmalloc(sizeof(regex_t));

    if ((ret = regcomp(reg, s, cflags)) != 0) {
	(void) regerror(ret, reg, errbuf, sizeof(errbuf));
	yyerror(errbuf);
	free(reg);
	return NULL;
    }
    return reg;
}

static patternlist_t *verify_regexs(stringlist_t *sl, char *comp)
{
    stringlist_t *sl2;
    patternlist_t *pl = NULL;
    int cflags = REG_EXTENDED | REG_NOSUB;
    regex_t *reg;

    if (!strcmp(comp, "i;ascii-casemap")) {
	cflags |= REG_ICASE;
    }

    for (sl2 = sl; sl2 != NULL; sl2 = sl2->next) {
	if ((reg = verify_regex(sl2->s, cflags)) == NULL) {
	    free_pl(pl, REGEX);
	    break;
	}
	pl = (patternlist_t *) new_pl(reg, pl);
    }
    if (sl2 == NULL) {
	free_sl(sl);
	return pl;
    }
    return NULL;
}
#endif

/* is it ok to put this in an RFC822 header body? */
static int ok_header(char *s)
{
    return 1;
}
