/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

const nonTrivialCheckModule = require("js_checker/nontrivial_checker");
const check = nonTrivialCheckModule.nonTrivialChecker(false, false);
const mn = require("./mock/mock_nodes");
var testRunner;
const remainingTests;

const constants = require("js_checker/constant_types");
var checkTypes = constants.checkTypes;

var testCheckNontrivial = function (test, n) {
    test.assertEqual(checkTypes.NONTRIVIAL_GLOBAL, check.checkNontrivial(n));
};


exports.testInvokesEvalIdentifier = function (test) {    
    // a node that could be found during 
    // jsChecker walkTree execution.
    // n corresponds to "eval".
    var n = mn.mockNodes['eval'];
    // making sure we have a correct (as expected) tree
    test.assertEqual(true, check.invokesEval(n));
    //testCheckNontrivial(test, n1);
    test.done();
};

exports.testInvokesEvalIdentifier_2 = function (test) {
    // a node that could be found during 
    // jsChecker walkTree execution.
    // n corresponds to "evaluate"
    var n = mn.mockNodes['evaluate'];
    // making sure we have a correct (as expected) tree
    test.assertNotEqual(true, check.invokesEval(n));
    test.done();
};

exports.testInvokesMethodBracketSuffix = function (test) {
    // n corresponds to window['eval']('var i;');
    var n = mn.mockNodes["window['eval']('var i;');"];
    test.assertEqual(true, check.invokesMethodBracketSuffix(n));
    testCheckNontrivial(test, n);
    test.done();

}

exports.testInvokesMethodBracketSuffixArray = function (test) {
    // n1 corresponds to array[num] = 'some text';
    var n = mn.mockNodes["array[num] = 'some text';"];
    test.assertNotEqual(true, check.invokesMethodBracketSuffix(n));
    test.done();
}

exports.testCreatesXhrObject = function (test) {
    // n1 corresponds to identifier "XMLHttpRequest"
    var n = mn.mockNodes['XMLHttpRequest'];
    test.assertEqual(true, check.createsXhrObject(n));
    testCheckNontrivial(test, n);
    test.done();
};

exports.testCreatesXhrObject_MS = function (test) {
    // n1 corresponds to identifier "ActiveXObject"
    var n = mn.mockNodes['ActiveXObject'];
    test.assertEqual(true, check.createsXhrObject(n));
    test.done();
};

exports.testInvokesXhrOpen = function (test) {
    // n1 corresponds to: 
    // "oReq.open("GET", "http://localhost/test.xml", true);"
    var n = mn.mockNodes["oReq.open\('GET', 'http://localhost/test.xml', true;\)"];
    test.assertEqual(true, check.invokesXhrOpen(n));
    testCheckNontrivial(test, n);
    test.done();
}

exports.testInvokesMethodOpenNotXhr = function (test) {
    // n1 corresponds to: 
    // "oReq.open("a random string");"
    var n = mn.mockNodes["oReq.open\('a random string'\);"];
    test.assertNotEqual('global', check.invokesXhrOpen(n));
    test.done();
};

exports.testCreatesScriptElement = function (test) {
    // n1 corresponds to:
    // "document.createElement('script');"
    var n = mn.mockNodes["document.createElement('script');"];
    test.assertEqual(true, check.createsScriptElement(n));
    testCheckNontrivial(test, n);
    test.done();
};

exports.testScriptWrittenAsHtmlString = function (test) {
    // string written corresponds to: 
    //<script src=\"evil-js.js\"type=\"text/javascript\></script>
    // and written with document.write();
    var n = mn.mockNodes['document.write\("script src=\"evil-js.js\"type=\"text/javascript\></script>"\)'];
    test.assertEqual(true, check.writesScriptAsHtmlString(n));
    testCheckNontrivial(test, n);
    test.done();
};

exports.testScriptWrittenAsStringConcat = function (test) {
    // string written corresponds to: 
    // document.write('a ' + ' text');
    // since we are not currently analyzing such construct
    // we are flagging it as nontrivial.
    var n = mn.mockNodes["document.write\('a ' + ' text'\);"];
    test.assertEqual(true, check.writesScriptAsHtmlString(n));
    testCheckNontrivial(test, n);
    test.done();
};

exports.testWriteNonscriptHtmlString = function (test) {
// corresponds to: document.write('<h1>some text</h1>');
    var n = mn.mockNodes["document.write\('<h1>some text</h1>'\)"];
    test.assertEqual(false, check.writesScriptAsHtmlString(n));
    test.done();  
};

/*exports.testSetsInnerHTMLProperty = function (test) {
    var n = mn.mockNodes['element.innerHTML = "<script src=\'externalscript.js\'></script>";'];
    test.assertEqual(true, check.setsInnerHTMLProperty(n));
    testCheckNontrivial(test, n);
    test.done();  
};*/

/*exports.testSetsInnerHTMLPropertyNonscript = function (test) {
    var n = mn.mockNodes['element.innerHTML = "<h1>A headline!</h1>";'];
    test.assertNotEqual(true, check.setsInnerHTMLProperty(n));
    test.done();
};*/

/*
exports.testSetsInnerHTMLPropertyConcat = function (test) {
    var n = mn.mockNodes['element.innerHTML = "script src" + "=\'eviljs.js\'";'];
    test.assertEqual(true, check.setsInnerHTMLProperty(n));
    testCheckNontrivial(test, n);
    test.done();
};
*/
/*exports.testCheckNonTrivialWithFuncDefAndIsLoadedExternally = function (test) {
    var subcheck = nonTrivialCheckModule.nonTrivialChecker(true, false);
    // a node that could be found during 
    // jsChecker walkTree execution.
    // n corresponds to "function example(param1) {}"
    var n = mn.mockNodes['function example(param1) {}'];
    // making sure we have a correct (as expected) tree
    test.assertEqual('local', subcheck.checkNontrivial(n));
    test.done();
};

exports.testCheckNonTrivialWithFuncDefAndHtmlLoadsExternalScripts = function (test) {
    var subcheck = nonTrivialCheckModule.nonTrivialChecker(false, true);
    // a node that could be found during 
    // jsChecker walkTree execution.
    // n corresponds to "function example(param1) {}"
    var n = mn.mockNodes['function example(param1) {}'];
    // making sure we have a correct (as expected) tree
    test.assertEqual('local', subcheck.checkNontrivial(n));
    test.done();
};

exports.testCheckNonTrivialWithFuncDefAndHtmlLoadsExternalScriptsAndIsLoadedExternally = function (test) {
    // that's not really possible, but avoiding silent bugs.
    var subcheck = nonTrivialCheckModule.nonTrivialChecker(true, true);
    var n = mn.mockNodes['function example(param1) {}'];
    // making sure we have a correct (as expected) tree
    test.assertEqual('local', subcheck.checkNontrivial(n));
    test.done();
};*/