
;;; d-make-tags.el --- Makes tags for Lisp++ mode code

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-make-tags.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: make tags for Lisp++ mode code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun d-make-tags ()
  (interactive)
  (progn
    (setq *buf* (find-file (concat *directory* "TAGS")))
    (erase-buffer)
    (let* ((list (directory-files *directory* t "\\.lisp[+][+]$"))
           ptr name str p class-name)
      (setq ptr list)
      (while ptr
        (save-excursion
          (set-buffer *buf*)
          (insert "\f\n")
          (insert (file-name-nondirectory (car ptr)) ",0\n"))
        (find-file (car ptr))
        (goto-char (point-min))
        (while (re-search-forward
                (concat
                 "^ ?(\\(cfunction\\|cmethod\\|cproperty\\|"
                 "c-static-method\\|c-static-property"
                 "c-property-callback\\|cglobal\\|"
                 "c-constructor-method\\|c-destructor-method\\)"
                 " *\\((\\(cret\\|ctype\\|cfptr\\)[^()]*)\\)? *(cname \\([^()]*\\))") nil t)
          (save-excursion
            (setq name (buffer-substring-no-properties
                        (match-beginning 4)
                        (match-end 4)))
            (setq str  (buffer-substring-no-properties
                        (match-beginning 0)
                        (match-end 0)))
            (setq line (d-what-line))
            (setq p    (point))
            (setq class-name (d-inside-class))
            ;;(debug "Foomatic")
            (set-buffer *buf*)
            (goto-char (point-max))
            (insert str)
            (insert "")
            (when class-name
              ;;(debug "Apple Pie")
              (insert class-name "::" name ""))
            (insert (format "%s" line))
            (insert ",")
            (insert (format "%s" p))
            (insert "\n")
            ;;(debug "Cabbage")
            ))
        ;;(setq ptr nil)
        (setq ptr (cdr ptr)))
    )))

(defun d-inside-class ()
  (let (p class-name)
    (save-excursion
      (setq p (point))
      (when (re-search-backward "^(cclass \\([a-zA-Z0-9_]*\\)" nil t)
        (setq class-name (buffer-substring-no-properties
                          (match-beginning 1)
                          (match-end 1)))
        (beginning-of-line)
        (forward-sexp 1)
        (when (> (point) p)
          ;;(debug "Apple Pie")
          class-name)))))

(provide 'd-make-tags)
;;; d-make-tags.el ends here
