/* -*-C++-*-
*******************************************************************************
*
* File:         chirp_file.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <VrFileSink.h>
#include <VrChirpSource.h>
#include <VrConnect.h>
#include <VrMultiTask.h>


#define SAMPLING_FREQUENCY                         500

int 
main (int argc, char **argv)
{
  // create the modules
  
  VrChirpSource<short> source (SAMPLING_FREQUENCY, 32767, 4);
  VrFileSink<char> sink("chirp_file.dat");
  VrMultiTask m;

  m.add (&sink);

  // connect them together

  NWO_CONNECT (&source, &sink);

  m.start ();
  while (1){
    m.process ();
  }
  m.stop ();

  return 0;
}
