/* $NoKeywords:$ */
/**
 * @file
 *
 *  Register definitions
 *
 *
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:     AGESA
 * @e sub-project: GNB
 * @e \$Revision: 64732 $   @e \$Date: 2012-01-30 02:16:26 -0600 (Mon, 30 Jan 2012) $
 *
 */
/*
*****************************************************************************
*
 * Copyright (c) 2008 - 2012, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* ***************************************************************************
*
*/

#ifndef _GNBREGISTERSTN_H_
#define _GNBREGISTERSTN_H_
#define  TYPE_D0F0                  0x1
#define  TYPE_D0F0x64               0x2
#define  TYPE_D0F0x98               0x3
#define  TYPE_D0F0xBC               0x4
#define  TYPE_D0F0xE4               0x5
#define  TYPE_DxF0                  0x6
#define  TYPE_DxF0xE4               0x7
#define  TYPE_D0F2                  0x8
#define  TYPE_D0F2xF4               0x9
#define  TYPE_D0F2xFC               0xa
#define  TYPE_D18F1                 0xb
#define  TYPE_D18F2                 0xc
#define  TYPE_D18F3                 0xd
#define  TYPE_D18F4                 0xe
#define  TYPE_D18F5                 0xf
#define  TYPE_MSR                   0x10
#define  TYPE_D1F0                  0x11
#define  TYPE_GMM                   0x12
#define  TYPE_D18F2x9C_dct0         0x13
#define  TYPE_D18F2x9C_dct0_mp0     0x14
#define  TYPE_D18F2x9C_dct0_mp1     0x15
#define  TYPE_D18F2x9C_dct1         0x16
#define  TYPE_D18F2x9C_dct1_mp0     0x17
#define  TYPE_D18F2x9C_dct1_mp1     0x18
#define  TYPE_D18F2_dct0            0x19
#define  TYPE_D18F2_dct1            0x1a
#define  TYPE_D18F2_dct0_mp0        0x1b
#define  TYPE_D18F2_dct0_mp1        0x1c
#define  TYPE_D1F1                  0x1d
#define  TYPE_D18F2_dct1_mp0        0x1e
#define  TYPE_D18F2_dct1_mp1        0x1f
#define  TYPE_CGIND                 0x20
#define  TYPE_SMU_MSG               0x21

#ifndef WRAP_SPACE
  #define  WRAP_SPACE(w, x)   (0x01300000 | (w << 16) | (x))
#endif
#ifndef CORE_SPACE
  #define  CORE_SPACE(c, x)   (0x00010000 | (c << 24) | (x))
#endif
#ifndef PHY_SPACE
  #define  PHY_SPACE(w, p, x) (0x00200000 | ((p + 1) << 24) | (w << 16) | (x))
#endif
#ifndef PIF_SPACE
  #define  PIF_SPACE(w, p, x) (0x00100000 | ((p + 1) << 24) | (w << 16) | (x))
#endif

#define  L1_SEL_GFX                         0
#define  L1_SEL_GPPSB                       1
#define  L1_SEL_GBIF                        2
#define  L1_SEL_INTGEN                      3

#define  SMU_MSG_TYPE                       TYPE_SMU_MSG
#define  SMC_MSG_FIRMWARE_AUTH              0
#define  SMC_MSG_HALT                       1
#define  SMC_MSG_PHY_LN_OFF                 2
#define  SMC_MSG_PHY_LN_ON                  3
#define  SMC_MSG_DDI_PHY_OFF                4
#define  SMC_MSG_DDI_PHY_ON                 5
#define  SMC_MSG_CASCADE_PLL_OFF            6
#define  SMC_MSG_CASCADE_PLL_ON             7
#define  SMC_MSG_PWR_OFF_x16                8
#define  SMC_MSG_CONFIG_LCLK_DPM            9
#define  SMC_MSG_FLUSH_DATA_CACHE           10
#define  SMC_MSG_FLUSH_INSTRUCTION_CACHE    11
#define  SMC_MSG_CONFIG_VPC_ACCUMULATOR     12
#define  SMC_MSG_CONFIG_BAPM                13
#define  SMC_MSG_CONFIG_TDC_LIMIT           14
#define  SMC_MSG_CONFIG_LPMx                15
#define  SMC_MSG_CONFIG_HTC_LIMIT           16
#define  SMC_MSG_CONFIG_THERMAL_CNTL        17
#define  SMC_MSG_CONFIG_VOLTAGE_CNTL        18
#define  SMC_MSG_CONFIG_TDP_CNTL            19
#define  SMC_MSG_EN_PM_CNTL                 20
#define  SMC_MSG_DIS_PM_CNTL                21
#define  SMC_MSG_CONFIG_NBDPM               22
#define  SMC_MSG_CONFIG_LOADLINE            23
#define  SMC_MSG_ADJUST_LOADLINE            24
#define  SMC_MSG_RECONFIGURE                25
#define  SMC_MSG_PCIE_PLLSWITCH             27
#define  SMC_MSG_ENABLE_BAPM                32
#define  SMC_MSG_DISABLE_BAPM               33

// **** D0F0x00 Register Definition ****
// Address
#define D0F0x00_ADDRESS                                         0x0

// Type
#define D0F0x00_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x00_VendorID_OFFSET                                 0
#define D0F0x00_VendorID_WIDTH                                  16
#define D0F0x00_VendorID_MASK                                   0xffff
#define D0F0x00_DeviceID_OFFSET                                 16
#define D0F0x00_DeviceID_WIDTH                                  16
#define D0F0x00_DeviceID_MASK                                   0xffff0000

/// D0F0x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x00_STRUCT;

// **** D0F0x04 Register Definition ****
// Address
#define D0F0x04_ADDRESS                                         0x4

// Type
#define D0F0x04_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x04_IoAccessEn_OFFSET                               0
#define D0F0x04_IoAccessEn_WIDTH                                1
#define D0F0x04_IoAccessEn_MASK                                 0x1
#define D0F0x04_MemAccessEn_OFFSET                              1
#define D0F0x04_MemAccessEn_WIDTH                               1
#define D0F0x04_MemAccessEn_MASK                                0x2
#define D0F0x04_BusMasterEn_OFFSET                              2
#define D0F0x04_BusMasterEn_WIDTH                               1
#define D0F0x04_BusMasterEn_MASK                                0x4
#define D0F0x04_SpecialCycleEn_OFFSET                           3
#define D0F0x04_SpecialCycleEn_WIDTH                            1
#define D0F0x04_SpecialCycleEn_MASK                             0x8
#define D0F0x04_MemWriteInvalidateEn_OFFSET                     4
#define D0F0x04_MemWriteInvalidateEn_WIDTH                      1
#define D0F0x04_MemWriteInvalidateEn_MASK                       0x10
#define D0F0x04_PalSnoopEn_OFFSET                               5
#define D0F0x04_PalSnoopEn_WIDTH                                1
#define D0F0x04_PalSnoopEn_MASK                                 0x20
#define D0F0x04_ParityErrorEn_OFFSET                            6
#define D0F0x04_ParityErrorEn_WIDTH                             1
#define D0F0x04_ParityErrorEn_MASK                              0x40
#define D0F0x04_Reserved_7_7_OFFSET                             7
#define D0F0x04_Reserved_7_7_WIDTH                              1
#define D0F0x04_Reserved_7_7_MASK                               0x80
#define D0F0x04_SerrEn_OFFSET                                   8
#define D0F0x04_SerrEn_WIDTH                                    1
#define D0F0x04_SerrEn_MASK                                     0x100
#define D0F0x04_FastB2BEn_OFFSET                                9
#define D0F0x04_FastB2BEn_WIDTH                                 1
#define D0F0x04_FastB2BEn_MASK                                  0x200
#define D0F0x04_Reserved_19_10_OFFSET                           10
#define D0F0x04_Reserved_19_10_WIDTH                            10
#define D0F0x04_Reserved_19_10_MASK                             0xffc00
#define D0F0x04_CapList_OFFSET                                  20
#define D0F0x04_CapList_WIDTH                                   1
#define D0F0x04_CapList_MASK                                    0x100000
#define D0F0x04_PCI66En_OFFSET                                  21
#define D0F0x04_PCI66En_WIDTH                                   1
#define D0F0x04_PCI66En_MASK                                    0x200000
#define D0F0x04_Reserved_22_22_OFFSET                           22
#define D0F0x04_Reserved_22_22_WIDTH                            1
#define D0F0x04_Reserved_22_22_MASK                             0x400000
#define D0F0x04_FastBackCapable_OFFSET                          23
#define D0F0x04_FastBackCapable_WIDTH                           1
#define D0F0x04_FastBackCapable_MASK                            0x800000
#define D0F0x04_Reserved_24_24_OFFSET                           24
#define D0F0x04_Reserved_24_24_WIDTH                            1
#define D0F0x04_Reserved_24_24_MASK                             0x1000000
#define D0F0x04_DevselTiming_OFFSET                             25
#define D0F0x04_DevselTiming_WIDTH                              2
#define D0F0x04_DevselTiming_MASK                               0x6000000
#define D0F0x04_SignalTargetAbort_OFFSET                        27
#define D0F0x04_SignalTargetAbort_WIDTH                         1
#define D0F0x04_SignalTargetAbort_MASK                          0x8000000
#define D0F0x04_ReceivedTargetAbort_OFFSET                      28
#define D0F0x04_ReceivedTargetAbort_WIDTH                       1
#define D0F0x04_ReceivedTargetAbort_MASK                        0x10000000
#define D0F0x04_ReceivedMasterAbort_OFFSET                      29
#define D0F0x04_ReceivedMasterAbort_WIDTH                       1
#define D0F0x04_ReceivedMasterAbort_MASK                        0x20000000
#define D0F0x04_SignaledSystemError_OFFSET                      30
#define D0F0x04_SignaledSystemError_WIDTH                       1
#define D0F0x04_SignaledSystemError_MASK                        0x40000000
#define D0F0x04_ParityErrorDetected_OFFSET                      31
#define D0F0x04_ParityErrorDetected_WIDTH                       1
#define D0F0x04_ParityErrorDetected_MASK                        0x80000000

/// D0F0x04
typedef union {
  struct {                                                              ///<
    UINT32                                               IoAccessEn:1 ; ///<
    UINT32                                              MemAccessEn:1 ; ///<
    UINT32                                              BusMasterEn:1 ; ///<
    UINT32                                           SpecialCycleEn:1 ; ///<
    UINT32                                     MemWriteInvalidateEn:1 ; ///<
    UINT32                                               PalSnoopEn:1 ; ///<
    UINT32                                            ParityErrorEn:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                FastB2BEn:1 ; ///<
    UINT32                                           Reserved_19_10:10; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      SignaledSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x04_STRUCT;

// **** D0F0x08 Register Definition ****
// Address
#define D0F0x08_ADDRESS                                         0x8

// Type
#define D0F0x08_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x08_RevID_OFFSET                                    0
#define D0F0x08_RevID_WIDTH                                     8
#define D0F0x08_RevID_MASK                                      0xff
#define D0F0x08_ClassCode_OFFSET                                8
#define D0F0x08_ClassCode_WIDTH                                 24
#define D0F0x08_ClassCode_MASK                                  0xffffff00

/// D0F0x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x08_STRUCT;

// **** D0F0x0C Register Definition ****
// Address
#define D0F0x0C_ADDRESS                                         0xc

// Type
#define D0F0x0C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x0C_CacheLineSize_OFFSET                            0
#define D0F0x0C_CacheLineSize_WIDTH                             8
#define D0F0x0C_CacheLineSize_MASK                              0xff
#define D0F0x0C_LatencyTimer_OFFSET                             8
#define D0F0x0C_LatencyTimer_WIDTH                              8
#define D0F0x0C_LatencyTimer_MASK                               0xff00
#define D0F0x0C_HeaderTypeReg_OFFSET                            16
#define D0F0x0C_HeaderTypeReg_WIDTH                             8
#define D0F0x0C_HeaderTypeReg_MASK                              0xff0000
#define D0F0x0C_BIST_OFFSET                                     24
#define D0F0x0C_BIST_WIDTH                                      8
#define D0F0x0C_BIST_MASK                                       0xff000000

/// D0F0x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            CacheLineSize:8 ; ///<
    UINT32                                             LatencyTimer:8 ; ///<
    UINT32                                            HeaderTypeReg:8 ; ///<
    UINT32                                                     BIST:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x0C_STRUCT;

// **** D0F0x2C Register Definition ****
// Address
#define D0F0x2C_ADDRESS                                         0x2c

// Type
#define D0F0x2C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x2C_SubsystemVendorID_OFFSET                        0
#define D0F0x2C_SubsystemVendorID_WIDTH                         16
#define D0F0x2C_SubsystemVendorID_MASK                          0xffff
#define D0F0x2C_SubsystemID_OFFSET                              16
#define D0F0x2C_SubsystemID_WIDTH                               16
#define D0F0x2C_SubsystemID_MASK                                0xffff0000

/// D0F0x2C
typedef union {
  struct {                                                              ///<
    UINT32                                        SubsystemVendorID:16; ///<
    UINT32                                              SubsystemID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x2C_STRUCT;

// **** D0F0x34 Register Definition ****
// Address
#define D0F0x34_ADDRESS                                         0x34

// Type
#define D0F0x34_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x34_CapPtr_OFFSET                                   0
#define D0F0x34_CapPtr_WIDTH                                    8
#define D0F0x34_CapPtr_MASK                                     0xff
#define D0F0x34_Reserved_31_8_OFFSET                            8
#define D0F0x34_Reserved_31_8_WIDTH                             24
#define D0F0x34_Reserved_31_8_MASK                              0xffffff00

/// D0F0x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x34_STRUCT;

// **** D0F0x4C Register Definition ****
// Address
#define D0F0x4C_ADDRESS                                         0x4c

// Type
#define D0F0x4C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x4C_Function1Enable_OFFSET                          0
#define D0F0x4C_Function1Enable_WIDTH                           1
#define D0F0x4C_Function1Enable_MASK                            0x1
#define D0F0x4C_ApicEnable_OFFSET                               1
#define D0F0x4C_ApicEnable_WIDTH                                1
#define D0F0x4C_ApicEnable_MASK                                 0x2
#define D0F0x4C_Reserved_2_2_OFFSET                             2
#define D0F0x4C_Reserved_2_2_WIDTH                              1
#define D0F0x4C_Reserved_2_2_MASK                               0x4
#define D0F0x4C_Cf8Dis_OFFSET                                   3
#define D0F0x4C_Cf8Dis_WIDTH                                    1
#define D0F0x4C_Cf8Dis_MASK                                     0x8
#define D0F0x4C_PMEDis_OFFSET                                   4
#define D0F0x4C_PMEDis_WIDTH                                    1
#define D0F0x4C_PMEDis_MASK                                     0x10
#define D0F0x4C_SerrDis_OFFSET                                  5
#define D0F0x4C_SerrDis_WIDTH                                   1
#define D0F0x4C_SerrDis_MASK                                    0x20
#define D0F0x4C_Reserved_10_6_OFFSET                            6
#define D0F0x4C_Reserved_10_6_WIDTH                             5
#define D0F0x4C_Reserved_10_6_MASK                              0x7c0
#define D0F0x4C_CRS_OFFSET                                      11
#define D0F0x4C_CRS_WIDTH                                       1
#define D0F0x4C_CRS_MASK                                        0x800
#define D0F0x4C_CfgRdTime_OFFSET                                12
#define D0F0x4C_CfgRdTime_WIDTH                                 3
#define D0F0x4C_CfgRdTime_MASK                                  0x7000
#define D0F0x4C_Reserved_22_15_OFFSET                           15
#define D0F0x4C_Reserved_22_15_WIDTH                            8
#define D0F0x4C_Reserved_22_15_MASK                             0x7f8000
#define D0F0x4C_MMIOEnable_OFFSET                               23
#define D0F0x4C_MMIOEnable_WIDTH                                1
#define D0F0x4C_MMIOEnable_MASK                                 0x800000
#define D0F0x4C_Reserved_25_24_OFFSET                           24
#define D0F0x4C_Reserved_25_24_WIDTH                            2
#define D0F0x4C_Reserved_25_24_MASK                             0x3000000
#define D0F0x4C_HPDis_OFFSET                                    26
#define D0F0x4C_HPDis_WIDTH                                     1
#define D0F0x4C_HPDis_MASK                                      0x4000000
#define D0F0x4C_Reserved_31_27_OFFSET                           27
#define D0F0x4C_Reserved_31_27_WIDTH                            5
#define D0F0x4C_Reserved_31_27_MASK                             0xf8000000

/// D0F0x4C
typedef union {
  struct {                                                              ///<
    UINT32                                          Function1Enable:1 ; ///<
    UINT32                                               ApicEnable:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                   Cf8Dis:1 ; ///<
    UINT32                                                   PMEDis:1 ; ///<
    UINT32                                                  SerrDis:1 ; ///<
    UINT32                                            Reserved_10_6:5 ; ///<
    UINT32                                                      CRS:1 ; ///<
    UINT32                                                CfgRdTime:3 ; ///<
    UINT32                                           Reserved_22_15:8 ; ///<
    UINT32                                               MMIOEnable:1 ; ///<
    UINT32                                           Reserved_25_24:2 ; ///<
    UINT32                                                    HPDis:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x4C_STRUCT;

// **** D0F0x60 Register Definition ****
// Address
#define D0F0x60_ADDRESS                                         0x60

// Type
#define D0F0x60_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x60_MiscIndAddr_OFFSET                              0
#define D0F0x60_MiscIndAddr_WIDTH                               7
#define D0F0x60_MiscIndAddr_MASK                                0x7f
#define D0F0x60_MiscIndWrEn_OFFSET                              7
#define D0F0x60_MiscIndWrEn_WIDTH                               1
#define D0F0x60_MiscIndWrEn_MASK                                0x80
#define D0F0x60_Reserved_31_8_OFFSET                            8
#define D0F0x60_Reserved_31_8_WIDTH                             24
#define D0F0x60_Reserved_31_8_MASK                              0xffffff00

/// D0F0x60
typedef union {
  struct {                                                              ///<
    UINT32                                              MiscIndAddr:7 ; ///<
    UINT32                                              MiscIndWrEn:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x60_STRUCT;

// **** D0F0x64 Register Definition ****
// Address
#define D0F0x64_ADDRESS                                         0x64

// Type
#define D0F0x64_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x64_MiscIndData_OFFSET                              0
#define D0F0x64_MiscIndData_WIDTH                               32
#define D0F0x64_MiscIndData_MASK                                0xffffffff

/// D0F0x64
typedef union {
  struct {                                                              ///<
    UINT32                                              MiscIndData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_STRUCT;

// **** D0F0x7C Register Definition ****
// Address
#define D0F0x7C_ADDRESS                                         0x7c

// Type
#define D0F0x7C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x7C_ForceIntGFXDisable_OFFSET                       0
#define D0F0x7C_ForceIntGFXDisable_WIDTH                        1
#define D0F0x7C_ForceIntGFXDisable_MASK                         0x1
#define D0F0x7C_Reserved_31_1_OFFSET                            1
#define D0F0x7C_Reserved_31_1_WIDTH                             31
#define D0F0x7C_Reserved_31_1_MASK                              0xfffffffe

/// D0F0x7C
typedef union {
  struct {                                                              ///<
    UINT32                                       ForceIntGFXDisable:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x7C_STRUCT;

// **** D0F0x84 Register Definition ****
// Address
#define D0F0x84_ADDRESS                                         0x84

// Type
#define D0F0x84_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x84_Reserved_2_0_OFFSET                             0
#define D0F0x84_Reserved_2_0_WIDTH                              3
#define D0F0x84_Reserved_2_0_MASK                               0x7
#define D0F0x84_VgaHole_OFFSET                                  3
#define D0F0x84_VgaHole_WIDTH                                   1
#define D0F0x84_VgaHole_MASK                                    0x8
#define D0F0x84_Ev6Mode_OFFSET                                  4
#define D0F0x84_Ev6Mode_WIDTH                                   1
#define D0F0x84_Ev6Mode_MASK                                    0x10
#define D0F0x84_Reserved_7_5_OFFSET                             5
#define D0F0x84_Reserved_7_5_WIDTH                              3
#define D0F0x84_Reserved_7_5_MASK                               0xe0
#define D0F0x84_PmeMode_OFFSET                                  8
#define D0F0x84_PmeMode_WIDTH                                   1
#define D0F0x84_PmeMode_MASK                                    0x100
#define D0F0x84_PmeTurnOff_OFFSET                               9
#define D0F0x84_PmeTurnOff_WIDTH                                1
#define D0F0x84_PmeTurnOff_MASK                                 0x200
#define D0F0x84_Reserved_31_10_OFFSET                           10
#define D0F0x84_Reserved_31_10_WIDTH                            22
#define D0F0x84_Reserved_31_10_MASK                             0xfffffc00

/// D0F0x84
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                  VgaHole:1 ; ///<
    UINT32                                                  Ev6Mode:1 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                  PmeMode:1 ; ///<
    UINT32                                               PmeTurnOff:1 ; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x84_STRUCT;

// **** D0F0x90 Register Definition ****
// Address
#define D0F0x90_ADDRESS                                         0x90

// Type
#define D0F0x90_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x90_Reserved_22_0_OFFSET                            0
#define D0F0x90_Reserved_22_0_WIDTH                             23
#define D0F0x90_Reserved_22_0_MASK                              0x7fffff
#define D0F0x90_TopOfDram_OFFSET                                23
#define D0F0x90_TopOfDram_WIDTH                                 9
#define D0F0x90_TopOfDram_MASK                                  0xff800000

/// D0F0x90
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_22_0:23; ///<
    UINT32                                                TopOfDram:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x90_STRUCT;

// **** D0F0x94 Register Definition ****
// Address
#define D0F0x94_ADDRESS                                         0x94

// Type
#define D0F0x94_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x94_OrbIndAddr_OFFSET                               0
#define D0F0x94_OrbIndAddr_WIDTH                                7
#define D0F0x94_OrbIndAddr_MASK                                 0x7f
#define D0F0x94_Reserved_7_7_OFFSET                             7
#define D0F0x94_Reserved_7_7_WIDTH                              1
#define D0F0x94_Reserved_7_7_MASK                               0x80
#define D0F0x94_OrbIndWrEn_OFFSET                               8
#define D0F0x94_OrbIndWrEn_WIDTH                                1
#define D0F0x94_OrbIndWrEn_MASK                                 0x100
#define D0F0x94_Reserved_31_9_OFFSET                            9
#define D0F0x94_Reserved_31_9_WIDTH                             23
#define D0F0x94_Reserved_31_9_MASK                              0xfffffe00

/// D0F0x94
typedef union {
  struct {                                                              ///<
    UINT32                                               OrbIndAddr:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                               OrbIndWrEn:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x94_STRUCT;

// **** D0F0x98 Register Definition ****
// Address
#define D0F0x98_ADDRESS                                         0x98

// Type
#define D0F0x98_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x98_OrbIndData_OFFSET                               0
#define D0F0x98_OrbIndData_WIDTH                                32
#define D0F0x98_OrbIndData_MASK                                 0xffffffff

/// D0F0x98
typedef union {
  struct {                                                              ///<
    UINT32                                               OrbIndData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_STRUCT;

// **** D0F0xB8 Register Definition ****
// Address
#define D0F0xB8_ADDRESS                                         0xb8

// Type
#define D0F0xB8_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xB8_NbSmuIndAddr_OFFSET                             0
#define D0F0xB8_NbSmuIndAddr_WIDTH                              32
#define D0F0xB8_NbSmuIndAddr_MASK                               0xffffffff

/// D0F0xB8
typedef union {
  struct {                                                              ///<
    UINT32                                             NbSmuIndAddr:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xB8_STRUCT;

// **** D0F0xBC Register Definition ****
// Address
#define D0F0xBC_ADDRESS                                         0xbc

// Type
#define D0F0xBC_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xBC_NbSmuIndData_OFFSET                             0
#define D0F0xBC_NbSmuIndData_WIDTH                              32
#define D0F0xBC_NbSmuIndData_MASK                               0xffffffff

/// D0F0xBC
typedef union {
  struct {                                                              ///<
    UINT32                                             NbSmuIndData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_STRUCT;

// **** D0F0xE0 Register Definition ****
// Address
#define D0F0xE0_ADDRESS                                         0xe0

// Type
#define D0F0xE0_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xE0_PcieIndxAddr_OFFSET                             0
#define D0F0xE0_PcieIndxAddr_WIDTH                              16
#define D0F0xE0_PcieIndxAddr_MASK                               0xffff
#define D0F0xE0_FrameType_OFFSET                                16
#define D0F0xE0_FrameType_WIDTH                                 8
#define D0F0xE0_FrameType_MASK                                  0xff0000
#define D0F0xE0_BlockSelect_OFFSET                              24
#define D0F0xE0_BlockSelect_WIDTH                               8
#define D0F0xE0_BlockSelect_MASK                                0xff000000

/// D0F0xE0
typedef union {
  struct {                                                              ///<
    UINT32                                             PcieIndxAddr:16; ///<
    UINT32                                                FrameType:8 ; ///<
    UINT32                                              BlockSelect:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE0_STRUCT;

// **** D0F0xE4 Register Definition ****
// Address
#define D0F0xE4_ADDRESS                                         0xe4

// Type
#define D0F0xE4_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xE4_PcieIndxData_OFFSET                             0
#define D0F0xE4_PcieIndxData_WIDTH                              32
#define D0F0xE4_PcieIndxData_MASK                               0xffffffff

/// D0F0xE4
typedef union {
  struct {                                                              ///<
    UINT32                                             PcieIndxData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_STRUCT;

// **** D0F2x00 Register Definition ****
// Address
#define D0F2x00_ADDRESS                                         0x0

// Type
#define D0F2x00_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x00_VendorId_OFFSET                                 0
#define D0F2x00_VendorId_WIDTH                                  16
#define D0F2x00_VendorId_MASK                                   0xffff
#define D0F2x00_DeviceId_OFFSET                                 16
#define D0F2x00_DeviceId_WIDTH                                  16
#define D0F2x00_DeviceId_MASK                                   0xffff0000

/// D0F2x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorId:16; ///<
    UINT32                                                 DeviceId:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x00_STRUCT;

// **** D0F2x04 Register Definition ****
// Address
#define D0F2x04_ADDRESS                                         0x4

// Type
#define D0F2x04_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x04_IoAccessEn_OFFSET                               0
#define D0F2x04_IoAccessEn_WIDTH                                1
#define D0F2x04_IoAccessEn_MASK                                 0x1
#define D0F2x04_MemAccessEn_OFFSET                              1
#define D0F2x04_MemAccessEn_WIDTH                               1
#define D0F2x04_MemAccessEn_MASK                                0x2
#define D0F2x04_BusMasterEn_OFFSET                              2
#define D0F2x04_BusMasterEn_WIDTH                               1
#define D0F2x04_BusMasterEn_MASK                                0x4
#define D0F2x04_Reserved_5_3_OFFSET                             3
#define D0F2x04_Reserved_5_3_WIDTH                              3
#define D0F2x04_Reserved_5_3_MASK                               0x38
#define D0F2x04_ParityErrorEn_OFFSET                            6
#define D0F2x04_ParityErrorEn_WIDTH                             1
#define D0F2x04_ParityErrorEn_MASK                              0x40
#define D0F2x04_Reserved_7_7_OFFSET                             7
#define D0F2x04_Reserved_7_7_WIDTH                              1
#define D0F2x04_Reserved_7_7_MASK                               0x80
#define D0F2x04_SerrEn_OFFSET                                   8
#define D0F2x04_SerrEn_WIDTH                                    1
#define D0F2x04_SerrEn_MASK                                     0x100
#define D0F2x04_Reserved_9_9_OFFSET                             9
#define D0F2x04_Reserved_9_9_WIDTH                              1
#define D0F2x04_Reserved_9_9_MASK                               0x200
#define D0F2x04_InterruptDis_OFFSET                             10
#define D0F2x04_InterruptDis_WIDTH                              1
#define D0F2x04_InterruptDis_MASK                               0x400
#define D0F2x04_Reserved_18_11_OFFSET                           11
#define D0F2x04_Reserved_18_11_WIDTH                            8
#define D0F2x04_Reserved_18_11_MASK                             0x7f800
#define D0F2x04_IntStatus_OFFSET                                19
#define D0F2x04_IntStatus_WIDTH                                 1
#define D0F2x04_IntStatus_MASK                                  0x80000
#define D0F2x04_CapList_OFFSET                                  20
#define D0F2x04_CapList_WIDTH                                   1
#define D0F2x04_CapList_MASK                                    0x100000
#define D0F2x04_Reserved_23_21_OFFSET                           21
#define D0F2x04_Reserved_23_21_WIDTH                            3
#define D0F2x04_Reserved_23_21_MASK                             0xe00000
#define D0F2x04_MasterDataError_OFFSET                          24
#define D0F2x04_MasterDataError_WIDTH                           1
#define D0F2x04_MasterDataError_MASK                            0x1000000
#define D0F2x04_Reserved_26_25_OFFSET                           25
#define D0F2x04_Reserved_26_25_WIDTH                            2
#define D0F2x04_Reserved_26_25_MASK                             0x6000000
#define D0F2x04_SignalTargetAbort_OFFSET                        27
#define D0F2x04_SignalTargetAbort_WIDTH                         1
#define D0F2x04_SignalTargetAbort_MASK                          0x8000000
#define D0F2x04_ReceivedTargetAbort_OFFSET                      28
#define D0F2x04_ReceivedTargetAbort_WIDTH                       1
#define D0F2x04_ReceivedTargetAbort_MASK                        0x10000000
#define D0F2x04_ReceivedMasterAbort_OFFSET                      29
#define D0F2x04_ReceivedMasterAbort_WIDTH                       1
#define D0F2x04_ReceivedMasterAbort_MASK                        0x20000000
#define D0F2x04_SignaledSystemError_OFFSET                      30
#define D0F2x04_SignaledSystemError_WIDTH                       1
#define D0F2x04_SignaledSystemError_MASK                        0x40000000
#define D0F2x04_ParityErrorDetected_OFFSET                      31
#define D0F2x04_ParityErrorDetected_WIDTH                       1
#define D0F2x04_ParityErrorDetected_MASK                        0x80000000

/// D0F2x04
typedef union {
  struct {                                                              ///<
    UINT32                                               IoAccessEn:1 ; ///<
    UINT32                                              MemAccessEn:1 ; ///<
    UINT32                                              BusMasterEn:1 ; ///<
    UINT32                                             Reserved_5_3:3 ; ///<
    UINT32                                            ParityErrorEn:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                             Reserved_9_9:1 ; ///<
    UINT32                                             InterruptDis:1 ; ///<
    UINT32                                           Reserved_18_11:8 ; ///<
    UINT32                                                IntStatus:1 ; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                          MasterDataError:1 ; ///<
    UINT32                                           Reserved_26_25:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      SignaledSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x04_STRUCT;

// **** D0F2x08 Register Definition ****
// Address
#define D0F2x08_ADDRESS                                         0x8

// Type
#define D0F2x08_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x08_RevID_OFFSET                                    0
#define D0F2x08_RevID_WIDTH                                     8
#define D0F2x08_RevID_MASK                                      0xff
#define D0F2x08_ClassCode_OFFSET                                8
#define D0F2x08_ClassCode_WIDTH                                 24
#define D0F2x08_ClassCode_MASK                                  0xffffff00

/// D0F2x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x08_STRUCT;

// **** D0F2x0C Register Definition ****
// Address
#define D0F2x0C_ADDRESS                                         0xc

// Type
#define D0F2x0C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x0C_CacheLineSize_OFFSET                            0
#define D0F2x0C_CacheLineSize_WIDTH                             8
#define D0F2x0C_CacheLineSize_MASK                              0xff
#define D0F2x0C_LatencyTimer_OFFSET                             8
#define D0F2x0C_LatencyTimer_WIDTH                              8
#define D0F2x0C_LatencyTimer_MASK                               0xff00
#define D0F2x0C_HeaderTypeReg_OFFSET                            16
#define D0F2x0C_HeaderTypeReg_WIDTH                             8
#define D0F2x0C_HeaderTypeReg_MASK                              0xff0000
#define D0F2x0C_BIST_OFFSET                                     24
#define D0F2x0C_BIST_WIDTH                                      8
#define D0F2x0C_BIST_MASK                                       0xff000000

/// D0F2x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            CacheLineSize:8 ; ///<
    UINT32                                             LatencyTimer:8 ; ///<
    UINT32                                            HeaderTypeReg:8 ; ///<
    UINT32                                                     BIST:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x0C_STRUCT;

// **** D0F2x2C Register Definition ****
// Address
#define D0F2x2C_ADDRESS                                         0x2c

// Type
#define D0F2x2C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x2C_SubsystemVendorId_OFFSET                        0
#define D0F2x2C_SubsystemVendorId_WIDTH                         16
#define D0F2x2C_SubsystemVendorId_MASK                          0xffff
#define D0F2x2C_SubsystemId_OFFSET                              16
#define D0F2x2C_SubsystemId_WIDTH                               16
#define D0F2x2C_SubsystemId_MASK                                0xffff0000

/// D0F2x2C
typedef union {
  struct {                                                              ///<
    UINT32                                        SubsystemVendorId:16; ///<
    UINT32                                              SubsystemId:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x2C_STRUCT;

// **** D0F2x34 Register Definition ****
// Address
#define D0F2x34_ADDRESS                                         0x34

// Type
#define D0F2x34_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x34_CapPtr_OFFSET                                   0
#define D0F2x34_CapPtr_WIDTH                                    8
#define D0F2x34_CapPtr_MASK                                     0xff
#define D0F2x34_Reserved_31_8_OFFSET                            8
#define D0F2x34_Reserved_31_8_WIDTH                             24
#define D0F2x34_Reserved_31_8_MASK                              0xffffff00

/// D0F2x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x34_STRUCT;

// **** D0F2x3C Register Definition ****
// Address
#define D0F2x3C_ADDRESS                                         0x3c

// Type
#define D0F2x3C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x3C_InterruptLine_OFFSET                            0
#define D0F2x3C_InterruptLine_WIDTH                             8
#define D0F2x3C_InterruptLine_MASK                              0xff
#define D0F2x3C_InterruptPin_OFFSET                             8
#define D0F2x3C_InterruptPin_WIDTH                              8
#define D0F2x3C_InterruptPin_MASK                               0xff00
#define D0F2x3C_Reserved_31_16_OFFSET                           16
#define D0F2x3C_Reserved_31_16_WIDTH                            16
#define D0F2x3C_Reserved_31_16_MASK                             0xffff0000

/// D0F2x3C
typedef union {
  struct {                                                              ///<
    UINT32                                            InterruptLine:8 ; ///<
    UINT32                                             InterruptPin:8 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x3C_STRUCT;

// **** D0F2x40 Register Definition ****
// Address
#define D0F2x40_ADDRESS                                         0x40

// Type
#define D0F2x40_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x40_IommuCapId_OFFSET                               0
#define D0F2x40_IommuCapId_WIDTH                                8
#define D0F2x40_IommuCapId_MASK                                 0xff
#define D0F2x40_IommuCapPtr_OFFSET                              8
#define D0F2x40_IommuCapPtr_WIDTH                               8
#define D0F2x40_IommuCapPtr_MASK                                0xff00
#define D0F2x40_IommuCapType_OFFSET                             16
#define D0F2x40_IommuCapType_WIDTH                              3
#define D0F2x40_IommuCapType_MASK                               0x70000
#define D0F2x40_IommuCapRev_OFFSET                              19
#define D0F2x40_IommuCapRev_WIDTH                               5
#define D0F2x40_IommuCapRev_MASK                                0xf80000
#define D0F2x40_IommuIoTlbsup_OFFSET                            24
#define D0F2x40_IommuIoTlbsup_WIDTH                             1
#define D0F2x40_IommuIoTlbsup_MASK                              0x1000000
#define D0F2x40_IommuHtTunnelSup_OFFSET                         25
#define D0F2x40_IommuHtTunnelSup_WIDTH                          1
#define D0F2x40_IommuHtTunnelSup_MASK                           0x2000000
#define D0F2x40_IommuNpCache_OFFSET                             26
#define D0F2x40_IommuNpCache_WIDTH                              1
#define D0F2x40_IommuNpCache_MASK                               0x4000000
#define D0F2x40_IommuEfrSup_OFFSET                              27
#define D0F2x40_IommuEfrSup_WIDTH                               1
#define D0F2x40_IommuEfrSup_MASK                                0x8000000
#define D0F2x40_Reserved_31_28_OFFSET                           28
#define D0F2x40_Reserved_31_28_WIDTH                            4
#define D0F2x40_Reserved_31_28_MASK                             0xf0000000

/// D0F2x40
typedef union {
  struct {                                                              ///<
    UINT32                                               IommuCapId:8 ; ///<
    UINT32                                              IommuCapPtr:8 ; ///<
    UINT32                                             IommuCapType:3 ; ///<
    UINT32                                              IommuCapRev:5 ; ///<
    UINT32                                            IommuIoTlbsup:1 ; ///<
    UINT32                                         IommuHtTunnelSup:1 ; ///<
    UINT32                                             IommuNpCache:1 ; ///<
    UINT32                                              IommuEfrSup:1 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x40_STRUCT;

// **** D0F2x44 Register Definition ****
// Address
#define D0F2x44_ADDRESS                                         0x44

// Type
#define D0F2x44_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x44_IommuEnable_OFFSET                              0
#define D0F2x44_IommuEnable_WIDTH                               1
#define D0F2x44_IommuEnable_MASK                                0x1
#define D0F2x44_Reserved_13_1_OFFSET                            1
#define D0F2x44_Reserved_13_1_WIDTH                             13
#define D0F2x44_Reserved_13_1_MASK                              0x3ffe
#define D0F2x44_IommuBaseAddr_31_14__OFFSET                     14
#define D0F2x44_IommuBaseAddr_31_14__WIDTH                      18
#define D0F2x44_IommuBaseAddr_31_14__MASK                       0xffffc000

/// D0F2x44
typedef union {
  struct {                                                              ///<
    UINT32                                              IommuEnable:1 ; ///<
    UINT32                                            Reserved_13_1:13; ///<
    UINT32                                     IommuBaseAddr_31_14_:18; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x44_STRUCT;

// **** D0F2x48 Register Definition ****
// Address
#define D0F2x48_ADDRESS                                         0x48

// Type
#define D0F2x48_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x48_IommuBaseAddr_63_32__OFFSET                     0
#define D0F2x48_IommuBaseAddr_63_32__WIDTH                      32
#define D0F2x48_IommuBaseAddr_63_32__MASK                       0xffffffff

/// D0F2x48
typedef union {
  struct {                                                              ///<
    UINT32                                     IommuBaseAddr_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x48_STRUCT;

// **** D0F2x4C Register Definition ****
// Address
#define D0F2x4C_ADDRESS                                         0x4c

// Type
#define D0F2x4C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x4C_IommuUnitId_OFFSET                              0
#define D0F2x4C_IommuUnitId_WIDTH                               5
#define D0F2x4C_IommuUnitId_MASK                                0x1f
#define D0F2x4C_Reserved_6_5_OFFSET                             5
#define D0F2x4C_Reserved_6_5_WIDTH                              2
#define D0F2x4C_Reserved_6_5_MASK                               0x60
#define D0F2x4C_IommuRngValid_OFFSET                            7
#define D0F2x4C_IommuRngValid_WIDTH                             1
#define D0F2x4C_IommuRngValid_MASK                              0x80
#define D0F2x4C_IommuBusNumber_OFFSET                           8
#define D0F2x4C_IommuBusNumber_WIDTH                            8
#define D0F2x4C_IommuBusNumber_MASK                             0xff00
#define D0F2x4C_IommuFirstDevice_OFFSET                         16
#define D0F2x4C_IommuFirstDevice_WIDTH                          8
#define D0F2x4C_IommuFirstDevice_MASK                           0xff0000
#define D0F2x4C_IommuLastDevice_OFFSET                          24
#define D0F2x4C_IommuLastDevice_WIDTH                           8
#define D0F2x4C_IommuLastDevice_MASK                            0xff000000

/// D0F2x4C
typedef union {
  struct {                                                              ///<
    UINT32                                              IommuUnitId:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                            IommuRngValid:1 ; ///<
    UINT32                                           IommuBusNumber:8 ; ///<
    UINT32                                         IommuFirstDevice:8 ; ///<
    UINT32                                          IommuLastDevice:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x4C_STRUCT;

// **** D0F2x50 Register Definition ****
// Address
#define D0F2x50_ADDRESS                                         0x50

// Type
#define D0F2x50_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x50_IommuMsiNum_OFFSET                              0
#define D0F2x50_IommuMsiNum_WIDTH                               5
#define D0F2x50_IommuMsiNum_MASK                                0x1f
#define D0F2x50_IommuGvaSize_OFFSET                             5
#define D0F2x50_IommuGvaSize_WIDTH                              3
#define D0F2x50_IommuGvaSize_MASK                               0xe0
#define D0F2x50_IommuPaSize_OFFSET                              8
#define D0F2x50_IommuPaSize_WIDTH                               7
#define D0F2x50_IommuPaSize_MASK                                0x7f00
#define D0F2x50_IommuVaSize_OFFSET                              15
#define D0F2x50_IommuVaSize_WIDTH                               7
#define D0F2x50_IommuVaSize_MASK                                0x3f8000
#define D0F2x50_IommuHtAtsResv_OFFSET                           22
#define D0F2x50_IommuHtAtsResv_WIDTH                            1
#define D0F2x50_IommuHtAtsResv_MASK                             0x400000
#define D0F2x50_Reserved_26_23_OFFSET                           23
#define D0F2x50_Reserved_26_23_WIDTH                            4
#define D0F2x50_Reserved_26_23_MASK                             0x7800000
#define D0F2x50_IommuMsiNumPpr_OFFSET                           27
#define D0F2x50_IommuMsiNumPpr_WIDTH                            5
#define D0F2x50_IommuMsiNumPpr_MASK                             0xf8000000

/// D0F2x50
typedef union {
  struct {                                                              ///<
    UINT32                                              IommuMsiNum:5 ; ///<
    UINT32                                             IommuGvaSize:3 ; ///<
    UINT32                                              IommuPaSize:7 ; ///<
    UINT32                                              IommuVaSize:7 ; ///<
    UINT32                                           IommuHtAtsResv:1 ; ///<
    UINT32                                           Reserved_26_23:4 ; ///<
    UINT32                                           IommuMsiNumPpr:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x50_STRUCT;

// **** D0F2x54 Register Definition ****
// Address
#define D0F2x54_ADDRESS                                         0x54

// Type
#define D0F2x54_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x54_MsiCapId_OFFSET                                 0
#define D0F2x54_MsiCapId_WIDTH                                  8
#define D0F2x54_MsiCapId_MASK                                   0xff
#define D0F2x54_MsiCapPtr_OFFSET                                8
#define D0F2x54_MsiCapPtr_WIDTH                                 8
#define D0F2x54_MsiCapPtr_MASK                                  0xff00
#define D0F2x54_MsiEn_OFFSET                                    16
#define D0F2x54_MsiEn_WIDTH                                     1
#define D0F2x54_MsiEn_MASK                                      0x10000
#define D0F2x54_MsiMultMessCap_OFFSET                           17
#define D0F2x54_MsiMultMessCap_WIDTH                            3
#define D0F2x54_MsiMultMessCap_MASK                             0xe0000
#define D0F2x54_MsiMultMessEn_OFFSET                            20
#define D0F2x54_MsiMultMessEn_WIDTH                             3
#define D0F2x54_MsiMultMessEn_MASK                              0x700000
#define D0F2x54_Msi64En_OFFSET                                  23
#define D0F2x54_Msi64En_WIDTH                                   1
#define D0F2x54_Msi64En_MASK                                    0x800000
#define D0F2x54_Reserved_31_24_OFFSET                           24
#define D0F2x54_Reserved_31_24_WIDTH                            8
#define D0F2x54_Reserved_31_24_MASK                             0xff000000

/// D0F2x54
typedef union {
  struct {                                                              ///<
    UINT32                                                 MsiCapId:8 ; ///<
    UINT32                                                MsiCapPtr:8 ; ///<
    UINT32                                                    MsiEn:1 ; ///<
    UINT32                                           MsiMultMessCap:3 ; ///<
    UINT32                                            MsiMultMessEn:3 ; ///<
    UINT32                                                  Msi64En:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x54_STRUCT;

// **** D0F2x58 Register Definition ****
// Address
#define D0F2x58_ADDRESS                                         0x58

// Type
#define D0F2x58_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x58_Reserved_1_0_OFFSET                             0
#define D0F2x58_Reserved_1_0_WIDTH                              2
#define D0F2x58_Reserved_1_0_MASK                               0x3
#define D0F2x58_MsiAddr_31_2__OFFSET                            2
#define D0F2x58_MsiAddr_31_2__WIDTH                             30
#define D0F2x58_MsiAddr_31_2__MASK                              0xfffffffc

/// D0F2x58
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            MsiAddr_31_2_:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x58_STRUCT;

// **** D0F2x5C Register Definition ****
// Address
#define D0F2x5C_ADDRESS                                         0x5c

// Type
#define D0F2x5C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x5C_MsiAddr_63_32__OFFSET                           0
#define D0F2x5C_MsiAddr_63_32__WIDTH                            32
#define D0F2x5C_MsiAddr_63_32__MASK                             0xffffffff

/// D0F2x5C
typedef union {
  struct {                                                              ///<
    UINT32                                           MsiAddr_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x5C_STRUCT;

// **** D0F2x60 Register Definition ****
// Address
#define D0F2x60_ADDRESS                                         0x60

// Type
#define D0F2x60_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x60_MsiData_OFFSET                                  0
#define D0F2x60_MsiData_WIDTH                                   16
#define D0F2x60_MsiData_MASK                                    0xffff
#define D0F2x60_Reserved_31_16_OFFSET                           16
#define D0F2x60_Reserved_31_16_WIDTH                            16
#define D0F2x60_Reserved_31_16_MASK                             0xffff0000

/// D0F2x60
typedef union {
  struct {                                                              ///<
    UINT32                                                  MsiData:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x60_STRUCT;

// **** D0F2x64 Register Definition ****
// Address
#define D0F2x64_ADDRESS                                         0x64

// Type
#define D0F2x64_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x64_MsiMapCapId_OFFSET                              0
#define D0F2x64_MsiMapCapId_WIDTH                               8
#define D0F2x64_MsiMapCapId_MASK                                0xff
#define D0F2x64_MsiMapCapPtr_OFFSET                             8
#define D0F2x64_MsiMapCapPtr_WIDTH                              8
#define D0F2x64_MsiMapCapPtr_MASK                               0xff00
#define D0F2x64_MsiMapEn_OFFSET                                 16
#define D0F2x64_MsiMapEn_WIDTH                                  1
#define D0F2x64_MsiMapEn_MASK                                   0x10000
#define D0F2x64_MsiMapFixd_OFFSET                               17
#define D0F2x64_MsiMapFixd_WIDTH                                1
#define D0F2x64_MsiMapFixd_MASK                                 0x20000
#define D0F2x64_Reserved_26_18_OFFSET                           18
#define D0F2x64_Reserved_26_18_WIDTH                            9
#define D0F2x64_Reserved_26_18_MASK                             0x7fc0000
#define D0F2x64_MsiMapCapType_OFFSET                            27
#define D0F2x64_MsiMapCapType_WIDTH                             5
#define D0F2x64_MsiMapCapType_MASK                              0xf8000000

/// D0F2x64
typedef union {
  struct {                                                              ///<
    UINT32                                              MsiMapCapId:8 ; ///<
    UINT32                                             MsiMapCapPtr:8 ; ///<
    UINT32                                                 MsiMapEn:1 ; ///<
    UINT32                                               MsiMapFixd:1 ; ///<
    UINT32                                           Reserved_26_18:9 ; ///<
    UINT32                                            MsiMapCapType:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x64_STRUCT;

// **** D0F2x6C Register Definition ****
// Address
#define D0F2x6C_ADDRESS                                         0x6c

// Type
#define D0F2x6C_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x6C_InterruptPinW_OFFSET                            0
#define D0F2x6C_InterruptPinW_WIDTH                             3
#define D0F2x6C_InterruptPinW_MASK                              0x7
#define D0F2x6C_Reserved_3_3_OFFSET                             3
#define D0F2x6C_Reserved_3_3_WIDTH                              1
#define D0F2x6C_Reserved_3_3_MASK                               0x8
#define D0F2x6C_MinorRevIdW_OFFSET                              4
#define D0F2x6C_MinorRevIdW_WIDTH                               4
#define D0F2x6C_MinorRevIdW_MASK                                0xf0
#define D0F2x6C_IoTlbsupW_OFFSET                                8
#define D0F2x6C_IoTlbsupW_WIDTH                                 1
#define D0F2x6C_IoTlbsupW_MASK                                  0x100
#define D0F2x6C_EfrSupW_OFFSET                                  9
#define D0F2x6C_EfrSupW_WIDTH                                   1
#define D0F2x6C_EfrSupW_MASK                                    0x200
#define D0F2x6C_Reserved_31_10_OFFSET                           10
#define D0F2x6C_Reserved_31_10_WIDTH                            22
#define D0F2x6C_Reserved_31_10_MASK                             0xfffffc00

/// D0F2x6C
typedef union {
  struct {                                                              ///<
    UINT32                                            InterruptPinW:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                              MinorRevIdW:4 ; ///<
    UINT32                                                IoTlbsupW:1 ; ///<
    UINT32                                                  EfrSupW:1 ; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x6C_STRUCT;

// **** D0F2x70 Register Definition ****
// Address
#define D0F2x70_ADDRESS                                         0x70

// Type
#define D0F2x70_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x70_PrefSupW_OFFSET                                 0
#define D0F2x70_PrefSupW_WIDTH                                  1
#define D0F2x70_PrefSupW_MASK                                   0x1
#define D0F2x70_PprSupW_OFFSET                                  1
#define D0F2x70_PprSupW_WIDTH                                   1
#define D0F2x70_PprSupW_MASK                                    0x2
#define D0F2x70_Reserved_2_2_OFFSET                             2
#define D0F2x70_Reserved_2_2_WIDTH                              1
#define D0F2x70_Reserved_2_2_MASK                               0x4
#define D0F2x70_NxSupW_OFFSET                                   3
#define D0F2x70_NxSupW_WIDTH                                    1
#define D0F2x70_NxSupW_MASK                                     0x8
#define D0F2x70_GtSupW_OFFSET                                   4
#define D0F2x70_GtSupW_WIDTH                                    1
#define D0F2x70_GtSupW_MASK                                     0x10
#define D0F2x70_Reserved_5_5_OFFSET                             5
#define D0F2x70_Reserved_5_5_WIDTH                              1
#define D0F2x70_Reserved_5_5_MASK                               0x20
#define D0F2x70_IaSupW_OFFSET                                   6
#define D0F2x70_IaSupW_WIDTH                                    1
#define D0F2x70_IaSupW_MASK                                     0x40
#define D0F2x70_Reserved_7_7_OFFSET                             7
#define D0F2x70_Reserved_7_7_WIDTH                              1
#define D0F2x70_Reserved_7_7_MASK                               0x80
#define D0F2x70_Reserved_8_8_OFFSET                             8
#define D0F2x70_Reserved_8_8_WIDTH                              1
#define D0F2x70_Reserved_8_8_MASK                               0x100
#define D0F2x70_PcSupW_OFFSET                                   9
#define D0F2x70_PcSupW_WIDTH                                    1
#define D0F2x70_PcSupW_MASK                                     0x200
#define D0F2x70_HatsW_OFFSET                                    10
#define D0F2x70_HatsW_WIDTH                                     2
#define D0F2x70_HatsW_MASK                                      0xc00
#define D0F2x70_Reserved_31_12_OFFSET                           12
#define D0F2x70_Reserved_31_12_WIDTH                            20
#define D0F2x70_Reserved_31_12_MASK                             0xfffff000

/// D0F2x70
typedef union {
  struct {                                                              ///<
    UINT32                                                 PrefSupW:1 ; ///<
    UINT32                                                  PprSupW:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                   NxSupW:1 ; ///<
    UINT32                                                   GtSupW:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                                   IaSupW:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                             Reserved_8_8:1 ; ///<
    UINT32                                                   PcSupW:1 ; ///<
    UINT32                                                    HatsW:2 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x70_STRUCT;

// **** D0F2x74 Register Definition ****
// Address
#define D0F2x74_ADDRESS                                         0x74

// Type
#define D0F2x74_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x74_PasMaxW_OFFSET                                  0
#define D0F2x74_PasMaxW_WIDTH                                   4
#define D0F2x74_PasMaxW_MASK                                    0xf
#define D0F2x74_Reserved_31_4_OFFSET                            4
#define D0F2x74_Reserved_31_4_WIDTH                             28
#define D0F2x74_Reserved_31_4_MASK                              0xfffffff0

/// D0F2x74
typedef union {
  struct {                                                              ///<
    UINT32                                                  PasMaxW:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x74_STRUCT;

// **** D0F2x78 Register Definition ****
// Address
#define D0F2x78_ADDRESS                                         0x78

// Type
#define D0F2x78_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2x78_Reserved_6_0_OFFSET                             0
#define D0F2x78_Reserved_6_0_WIDTH                              7
#define D0F2x78_Reserved_6_0_MASK                               0x7f
#define D0F2x78_RngValidW_OFFSET                                7
#define D0F2x78_RngValidW_WIDTH                                 1
#define D0F2x78_RngValidW_MASK                                  0x80
#define D0F2x78_BusNumberW_OFFSET                               8
#define D0F2x78_BusNumberW_WIDTH                                8
#define D0F2x78_BusNumberW_MASK                                 0xff00
#define D0F2x78_FirstDeviceW_OFFSET                             16
#define D0F2x78_FirstDeviceW_WIDTH                              8
#define D0F2x78_FirstDeviceW_MASK                               0xff0000
#define D0F2x78_LastDeviceW_OFFSET                              24
#define D0F2x78_LastDeviceW_WIDTH                               8
#define D0F2x78_LastDeviceW_MASK                                0xff000000

/// D0F2x78
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_6_0:7 ; ///<
    UINT32                                                RngValidW:1 ; ///<
    UINT32                                               BusNumberW:8 ; ///<
    UINT32                                             FirstDeviceW:8 ; ///<
    UINT32                                              LastDeviceW:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2x78_STRUCT;

// **** D0F2xF0 Register Definition ****
// Address
#define D0F2xF0_ADDRESS                                         0xf0

// Type
#define D0F2xF0_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2xF0_L2cfgIndex_OFFSET                               0
#define D0F2xF0_L2cfgIndex_WIDTH                                8
#define D0F2xF0_L2cfgIndex_MASK                                 0xff
#define D0F2xF0_L2cfgWrEn_OFFSET                                8
#define D0F2xF0_L2cfgWrEn_WIDTH                                 1
#define D0F2xF0_L2cfgWrEn_MASK                                  0x100
#define D0F2xF0_Reserved_31_9_OFFSET                            9
#define D0F2xF0_Reserved_31_9_WIDTH                             23
#define D0F2xF0_Reserved_31_9_MASK                              0xfffffe00

/// D0F2xF0
typedef union {
  struct {                                                              ///<
    UINT32                                               L2cfgIndex:8 ; ///<
    UINT32                                                L2cfgWrEn:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2xF0_STRUCT;

// **** D0F2xF4 Register Definition ****
// Address
#define D0F2xF4_ADDRESS                                         0xf4

// Type
#define D0F2xF4_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2xF4_L2cfgData_OFFSET                                0
#define D0F2xF4_L2cfgData_WIDTH                                 32
#define D0F2xF4_L2cfgData_MASK                                  0xffffffff

/// D0F2xF4
typedef union {
  struct {                                                              ///<
    UINT32                                                L2cfgData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2xF4_STRUCT;

// **** D0F2xF8 Register Definition ****
// Address
#define D0F2xF8_ADDRESS                                         0xf8

// Type
#define D0F2xF8_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2xF8_L1cfgIndex_OFFSET                               0
#define D0F2xF8_L1cfgIndex_WIDTH                                16
#define D0F2xF8_L1cfgIndex_MASK                                 0xffff
#define D0F2xF8_L1cfgSel_OFFSET                                 16
#define D0F2xF8_L1cfgSel_WIDTH                                  4
#define D0F2xF8_L1cfgSel_MASK                                   0xf0000
#define D0F2xF8_Reserved_30_20_OFFSET                           20
#define D0F2xF8_Reserved_30_20_WIDTH                            11
#define D0F2xF8_Reserved_30_20_MASK                             0x7ff00000
#define D0F2xF8_L1cfgEn_OFFSET                                  31
#define D0F2xF8_L1cfgEn_WIDTH                                   1
#define D0F2xF8_L1cfgEn_MASK                                    0x80000000

/// D0F2xF8
typedef union {
  struct {                                                              ///<
    UINT32                                               L1cfgIndex:16; ///<
    UINT32                                                 L1cfgSel:4 ; ///<
    UINT32                                           Reserved_30_20:11; ///<
    UINT32                                                  L1cfgEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2xF8_STRUCT;

// **** D0F2xFC Register Definition ****
// Address
#define D0F2xFC_ADDRESS                                         0xfc

// Type
#define D0F2xFC_TYPE                                            TYPE_D0F2
// Field Data
#define D0F2xFC_L1cfgData_OFFSET                                0
#define D0F2xFC_L1cfgData_WIDTH                                 32
#define D0F2xFC_L1cfgData_MASK                                  0xffffffff

/// D0F2xFC
typedef union {
  struct {                                                              ///<
    UINT32                                                L1cfgData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F2xFC_STRUCT;

// **** D18F0x00 Register Definition ****
// Address
#define D18F0x00_ADDRESS                                        0x0

// Type
#define D18F0x00_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x00_VendorID_OFFSET                                0
#define D18F0x00_VendorID_WIDTH                                 16
#define D18F0x00_VendorID_MASK                                  0xffff
#define D18F0x00_DeviceID_OFFSET                                16
#define D18F0x00_DeviceID_WIDTH                                 16
#define D18F0x00_DeviceID_MASK                                  0xffff0000

/// D18F0x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x00_STRUCT;

// **** D18F0x04 Register Definition ****
// Address
#define D18F0x04_ADDRESS                                        0x4

// Type
#define D18F0x04_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x04_Command_OFFSET                                 0
#define D18F0x04_Command_WIDTH                                  16
#define D18F0x04_Command_MASK                                   0xffff
#define D18F0x04_Status_OFFSET                                  16
#define D18F0x04_Status_WIDTH                                   16
#define D18F0x04_Status_MASK                                    0xffff0000

/// D18F0x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x04_STRUCT;

// **** D18F0x08 Register Definition ****
// Address
#define D18F0x08_ADDRESS                                        0x8

// Type
#define D18F0x08_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x08_RevID_OFFSET                                   0
#define D18F0x08_RevID_WIDTH                                    8
#define D18F0x08_RevID_MASK                                     0xff
#define D18F0x08_ClassCode_OFFSET                               8
#define D18F0x08_ClassCode_WIDTH                                24
#define D18F0x08_ClassCode_MASK                                 0xffffff00

/// D18F0x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x08_STRUCT;

// **** D18F0x0C Register Definition ****
// Address
#define D18F0x0C_ADDRESS                                        0xc

// Type
#define D18F0x0C_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x0C_HeaderTypeReg_OFFSET                           0
#define D18F0x0C_HeaderTypeReg_WIDTH                            32
#define D18F0x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F0x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x0C_STRUCT;

// **** D18F0x34 Register Definition ****
// Address
#define D18F0x34_ADDRESS                                        0x34

// Type
#define D18F0x34_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x34_CapPtr_OFFSET                                  0
#define D18F0x34_CapPtr_WIDTH                                   8
#define D18F0x34_CapPtr_MASK                                    0xff
#define D18F0x34_Reserved_31_8_OFFSET                           8
#define D18F0x34_Reserved_31_8_WIDTH                            24
#define D18F0x34_Reserved_31_8_MASK                             0xffffff00

/// D18F0x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x34_STRUCT;

// **** D18F0x40 Register Definition ****
// Address
#define D18F0x40_ADDRESS                                        0x40

// Type
#define D18F0x40_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x40_Reserved_31_0_OFFSET                           0
#define D18F0x40_Reserved_31_0_WIDTH                            32
#define D18F0x40_Reserved_31_0_MASK                             0xffffffff

/// D18F0x40
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x40_STRUCT;

// **** D18F0x60 Register Definition ****
// Address
#define D18F0x60_ADDRESS                                        0x60

// Type
#define D18F0x60_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x60_Reserved_15_0_OFFSET                           0
#define D18F0x60_Reserved_15_0_WIDTH                            16
#define D18F0x60_Reserved_15_0_MASK                             0xffff
#define D18F0x60_CpuCnt_4_0__OFFSET                             16
#define D18F0x60_CpuCnt_4_0__WIDTH                              5
#define D18F0x60_CpuCnt_4_0__MASK                               0x1f0000
#define D18F0x60_Reserved_31_21_OFFSET                          21
#define D18F0x60_Reserved_31_21_WIDTH                           11
#define D18F0x60_Reserved_31_21_MASK                            0xffe00000

/// D18F0x60
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                              CpuCnt_4_0_:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x60_STRUCT;

// **** D18F0x64 Register Definition ****
// Address
#define D18F0x64_ADDRESS                                        0x64

// Type
#define D18F0x64_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x64_MctUnit_OFFSET                                 4
#define D18F0x64_MctUnit_WIDTH                                  2
#define D18F0x64_MctUnit_MASK                                   0x30
#define D18F0x64_HbUnit_OFFSET                                  6
#define D18F0x64_HbUnit_WIDTH                                   2
#define D18F0x64_HbUnit_MASK                                    0xc0
#define D18F0x64_Reserved_31_8_OFFSET                           8
#define D18F0x64_Reserved_31_8_WIDTH                            24
#define D18F0x64_Reserved_31_8_MASK                             0xffffff00

/// D18F0x64
typedef union {
  struct {                                                              ///<
    UINT32                                                  CpuUnit:2 ; ///<
    UINT32                                               ExtCpuUnit:2 ; ///<
    UINT32                                                  MctUnit:2 ; ///<
    UINT32                                                   HbUnit:2 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x64_STRUCT;

// **** D18F0x68 Register Definition ****
// Address
#define D18F0x68_ADDRESS                                        0x68

// Type
#define D18F0x68_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x68_Reserved_3_0_OFFSET                            0
#define D18F0x68_Reserved_3_0_WIDTH                             4
#define D18F0x68_Reserved_3_0_MASK                              0xf
#define D18F0x68_DisMTS_OFFSET                                  4
#define D18F0x68_DisMTS_WIDTH                                   1
#define D18F0x68_DisMTS_MASK                                    0x10
#define D18F0x68_Reserved_5_5_OFFSET                            5
#define D18F0x68_Reserved_5_5_WIDTH                             1
#define D18F0x68_Reserved_5_5_MASK                              0x20
#define D18F0x68_CPUReqPassPW_OFFSET                            6
#define D18F0x68_CPUReqPassPW_WIDTH                             1
#define D18F0x68_CPUReqPassPW_MASK                              0x40
#define D18F0x68_CPURdRspPassPW_OFFSET                          7
#define D18F0x68_CPURdRspPassPW_WIDTH                           1
#define D18F0x68_CPURdRspPassPW_MASK                            0x80
#define D18F0x68_DisPMemC_OFFSET                                8
#define D18F0x68_DisPMemC_WIDTH                                 1
#define D18F0x68_DisPMemC_MASK                                  0x100
#define D18F0x68_DisRmtPMemC_OFFSET                             9
#define D18F0x68_DisRmtPMemC_WIDTH                              1
#define D18F0x68_DisRmtPMemC_MASK                               0x200
#define D18F0x68_DisFillP_OFFSET                                10
#define D18F0x68_DisFillP_WIDTH                                 1
#define D18F0x68_DisFillP_MASK                                  0x400
#define D18F0x68_RespPassPW_OFFSET                              11
#define D18F0x68_RespPassPW_WIDTH                               1
#define D18F0x68_RespPassPW_MASK                                0x800
#define D18F0x68_Reserved_14_12_OFFSET                          12
#define D18F0x68_Reserved_14_12_WIDTH                           3
#define D18F0x68_Reserved_14_12_MASK                            0x7000
#define D18F0x68_LimitCldtCfg_OFFSET                            15
#define D18F0x68_LimitCldtCfg_WIDTH                             1
#define D18F0x68_LimitCldtCfg_MASK                              0x8000
#define D18F0x68_LintEn_OFFSET                                  16
#define D18F0x68_LintEn_WIDTH                                   1
#define D18F0x68_LintEn_MASK                                    0x10000
#define D18F0x68_ApicExtBrdCst_OFFSET                           17
#define D18F0x68_ApicExtBrdCst_WIDTH                            1
#define D18F0x68_ApicExtBrdCst_MASK                             0x20000
#define D18F0x68_ApicExtId_OFFSET                               18
#define D18F0x68_ApicExtId_WIDTH                                1
#define D18F0x68_ApicExtId_MASK                                 0x40000
#define D18F0x68_ApicExtSpur_OFFSET                             19
#define D18F0x68_ApicExtSpur_WIDTH                              1
#define D18F0x68_ApicExtSpur_MASK                               0x80000
#define D18F0x68_SeqIdSrcNodeEn_OFFSET                          20
#define D18F0x68_SeqIdSrcNodeEn_WIDTH                           1
#define D18F0x68_SeqIdSrcNodeEn_MASK                            0x100000
#define D18F0x68_DsNpReqLmt_OFFSET                              21
#define D18F0x68_DsNpReqLmt_WIDTH                               2
#define D18F0x68_DsNpReqLmt_MASK                                0x600000
#define D18F0x68_Reserved_31_23_OFFSET                          23
#define D18F0x68_Reserved_31_23_WIDTH                           9
#define D18F0x68_Reserved_31_23_MASK                            0xff800000

/// D18F0x68
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                   DisMTS:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                             CPUReqPassPW:1 ; ///<
    UINT32                                           CPURdRspPassPW:1 ; ///<
    UINT32                                                 DisPMemC:1 ; ///<
    UINT32                                              DisRmtPMemC:1 ; ///<
    UINT32                                                 DisFillP:1 ; ///<
    UINT32                                               RespPassPW:1 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                             LimitCldtCfg:1 ; ///<
    UINT32                                                   LintEn:1 ; ///<
    UINT32                                            ApicExtBrdCst:1 ; ///<
    UINT32                                                ApicExtId:1 ; ///<
    UINT32                                              ApicExtSpur:1 ; ///<
    UINT32                                           SeqIdSrcNodeEn:1 ; ///<
    UINT32                                               DsNpReqLmt:2 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x68_STRUCT;

// **** D18F0x6C Register Definition ****
// Address
#define D18F0x6C_ADDRESS                                        0x6c

// Type
#define D18F0x6C_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x6C_RouteTblDis_OFFSET                             0
#define D18F0x6C_RouteTblDis_WIDTH                              1
#define D18F0x6C_RouteTblDis_MASK                               0x1
#define D18F0x6C_Reserved_3_1_OFFSET                            1
#define D18F0x6C_Reserved_3_1_WIDTH                             3
#define D18F0x6C_Reserved_3_1_MASK                              0xe
#define D18F0x6C_ColdRstDet_OFFSET                              4
#define D18F0x6C_ColdRstDet_WIDTH                               1
#define D18F0x6C_ColdRstDet_MASK                                0x10
#define D18F0x6C_BiosRstDet_0__OFFSET                           5
#define D18F0x6C_BiosRstDet_0__WIDTH                            1
#define D18F0x6C_BiosRstDet_0__MASK                             0x20
#define D18F0x6C_InitDet_OFFSET                                 6
#define D18F0x6C_InitDet_WIDTH                                  1
#define D18F0x6C_InitDet_MASK                                   0x40
#define D18F0x6C_Reserved_8_7_OFFSET                            7
#define D18F0x6C_Reserved_8_7_WIDTH                             2
#define D18F0x6C_Reserved_8_7_MASK                              0x180
#define D18F0x6C_BiosRstDet_2_1__OFFSET                         9
#define D18F0x6C_BiosRstDet_2_1__WIDTH                          2
#define D18F0x6C_BiosRstDet_2_1__MASK                           0x600
#define D18F0x6C_Reserved_26_11_OFFSET                          11
#define D18F0x6C_Reserved_26_11_WIDTH                           16
#define D18F0x6C_Reserved_26_11_MASK                            0x7fff800
#define D18F0x6C_ApplyIsocModeEnNow_OFFSET                      27
#define D18F0x6C_ApplyIsocModeEnNow_WIDTH                       1
#define D18F0x6C_ApplyIsocModeEnNow_MASK                        0x8000000
#define D18F0x6C_RlsIntFullTokCntImm_OFFSET                     28
#define D18F0x6C_RlsIntFullTokCntImm_WIDTH                      1
#define D18F0x6C_RlsIntFullTokCntImm_MASK                       0x10000000
#define D18F0x6C_Reserved_29_29_OFFSET                          29
#define D18F0x6C_Reserved_29_29_WIDTH                           1
#define D18F0x6C_Reserved_29_29_MASK                            0x20000000
#define D18F0x6C_RlsLnkFullTokCntImm_OFFSET                     30
#define D18F0x6C_RlsLnkFullTokCntImm_WIDTH                      1
#define D18F0x6C_RlsLnkFullTokCntImm_MASK                       0x40000000
#define D18F0x6C_Reserved_31_31_OFFSET                          31
#define D18F0x6C_Reserved_31_31_WIDTH                           1
#define D18F0x6C_Reserved_31_31_MASK                            0x80000000

/// D18F0x6C
typedef union {
  struct {                                                              ///<
    UINT32                                              RouteTblDis:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                               ColdRstDet:1 ; ///<
    UINT32                                            BiosRstDet_0_:1 ; ///<
    UINT32                                                  InitDet:1 ; ///<
    UINT32                                             Reserved_8_7:2 ; ///<
    UINT32                                          BiosRstDet_2_1_:2 ; ///<
    UINT32                                           Reserved_26_11:16; ///<
    UINT32                                       ApplyIsocModeEnNow:1 ; ///<
    UINT32                                      RlsIntFullTokCntImm:1 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                      RlsLnkFullTokCntImm:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x6C_STRUCT;

// **** D18F0x84 Register Definition ****
// Address
#define D18F0x84_ADDRESS                                        0x84

// Type
#define D18F0x84_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x84_Reserved_3_0_OFFSET                            0
#define D18F0x84_Reserved_3_0_WIDTH                             4
#define D18F0x84_Reserved_3_0_MASK                              0xf
#define D18F0x84_LinkFail_OFFSET                                4
#define D18F0x84_LinkFail_WIDTH                                 1
#define D18F0x84_LinkFail_MASK                                  0x10
#define D18F0x84_Reserved_5_5_OFFSET                            5
#define D18F0x84_Reserved_5_5_WIDTH                             1
#define D18F0x84_Reserved_5_5_MASK                              0x20
#define D18F0x84_Reserved_11_6_OFFSET                           6
#define D18F0x84_Reserved_11_6_WIDTH                            6
#define D18F0x84_Reserved_11_6_MASK                             0xfc0
#define D18F0x84_IsocEn_OFFSET                                  12
#define D18F0x84_IsocEn_WIDTH                                   1
#define D18F0x84_IsocEn_MASK                                    0x1000
#define D18F0x84_Reserved_31_13_OFFSET                          13
#define D18F0x84_Reserved_31_13_WIDTH                           19
#define D18F0x84_Reserved_31_13_MASK                            0xffffe000

/// D18F0x84
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                 LinkFail:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                            Reserved_11_6:6 ; ///<
    UINT32                                                   IsocEn:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x84_STRUCT;

// **** D18F0x90 Register Definition ****
// Address
#define D18F0x90_ADDRESS                                        0x90

// Type
#define D18F0x90_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x90_NpReqCmd_OFFSET                                0
#define D18F0x90_NpReqCmd_WIDTH                                 5
#define D18F0x90_NpReqCmd_MASK                                  0x1f
#define D18F0x90_PReq_OFFSET                                    5
#define D18F0x90_PReq_WIDTH                                     3
#define D18F0x90_PReq_MASK                                      0xe0
#define D18F0x90_RspCmd_OFFSET                                  8
#define D18F0x90_RspCmd_WIDTH                                   4
#define D18F0x90_RspCmd_MASK                                    0xf00
#define D18F0x90_ProbeCmd_OFFSET                                12
#define D18F0x90_ProbeCmd_WIDTH                                 4
#define D18F0x90_ProbeCmd_MASK                                  0xf000
#define D18F0x90_NpReqData_OFFSET                               16
#define D18F0x90_NpReqData_WIDTH                                2
#define D18F0x90_NpReqData_MASK                                 0x30000
#define D18F0x90_RspData_OFFSET                                 18
#define D18F0x90_RspData_WIDTH                                  2
#define D18F0x90_RspData_MASK                                   0xc0000
#define D18F0x90_FreeCmd_OFFSET                                 20
#define D18F0x90_FreeCmd_WIDTH                                  5
#define D18F0x90_FreeCmd_MASK                                   0x1f00000
#define D18F0x90_FreeData_OFFSET                                25
#define D18F0x90_FreeData_WIDTH                                 3
#define D18F0x90_FreeData_MASK                                  0xe000000
#define D18F0x90_Reserved_30_28_OFFSET                          28
#define D18F0x90_Reserved_30_28_WIDTH                           3
#define D18F0x90_Reserved_30_28_MASK                            0x70000000
#define D18F0x90_LockBc_OFFSET                                  31
#define D18F0x90_LockBc_WIDTH                                   1
#define D18F0x90_LockBc_MASK                                    0x80000000

/// D18F0x90
typedef union {
  struct {                                                              ///<
    UINT32                                                 NpReqCmd:5 ; ///<
    UINT32                                                     PReq:3 ; ///<
    UINT32                                                   RspCmd:4 ; ///<
    UINT32                                                 ProbeCmd:4 ; ///<
    UINT32                                                NpReqData:2 ; ///<
    UINT32                                                  RspData:2 ; ///<
    UINT32                                                  FreeCmd:5 ; ///<
    UINT32                                                 FreeData:3 ; ///<
    UINT32                                           Reserved_30_28:3 ; ///<
    UINT32                                                   LockBc:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x90_STRUCT;

// **** D18F0x94 Register Definition ****
// Address
#define D18F0x94_ADDRESS                                        0x94

// Type
#define D18F0x94_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x94_Reserved_7_0_OFFSET                            0
#define D18F0x94_Reserved_7_0_WIDTH                             8
#define D18F0x94_Reserved_7_0_MASK                              0xff
#define D18F0x94_SecBusNum_OFFSET                               8
#define D18F0x94_SecBusNum_WIDTH                                8
#define D18F0x94_SecBusNum_MASK                                 0xff00
#define D18F0x94_IsocNpReqCmd_OFFSET                            16
#define D18F0x94_IsocNpReqCmd_WIDTH                             3
#define D18F0x94_IsocNpReqCmd_MASK                              0x70000
#define D18F0x94_IsocPReq_OFFSET                                19
#define D18F0x94_IsocPReq_WIDTH                                 3
#define D18F0x94_IsocPReq_MASK                                  0x380000
#define D18F0x94_IsocRspCmd_OFFSET                              22
#define D18F0x94_IsocRspCmd_WIDTH                               3
#define D18F0x94_IsocRspCmd_MASK                                0x1c00000
#define D18F0x94_IsocNpReqData_OFFSET                           25
#define D18F0x94_IsocNpReqData_WIDTH                            2
#define D18F0x94_IsocNpReqData_MASK                             0x6000000
#define D18F0x94_IsocRspData_OFFSET                             27
#define D18F0x94_IsocRspData_WIDTH                              2
#define D18F0x94_IsocRspData_MASK                               0x18000000
#define D18F0x94_Reserved_31_29_OFFSET                          29
#define D18F0x94_Reserved_31_29_WIDTH                           3
#define D18F0x94_Reserved_31_29_MASK                            0xe0000000

/// D18F0x94
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                SecBusNum:8 ; ///<
    UINT32                                             IsocNpReqCmd:3 ; ///<
    UINT32                                                 IsocPReq:3 ; ///<
    UINT32                                               IsocRspCmd:3 ; ///<
    UINT32                                            IsocNpReqData:2 ; ///<
    UINT32                                              IsocRspData:2 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x94_STRUCT;

// **** D18F0x98 Register Definition ****
// Address
#define D18F0x98_ADDRESS                                        0x98

// Type
#define D18F0x98_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x98_Reserved_0_0_OFFSET                            0
#define D18F0x98_Reserved_0_0_WIDTH                             1
#define D18F0x98_Reserved_0_0_MASK                              0x1
#define D18F0x98_Reserved_1_1_OFFSET                            1
#define D18F0x98_Reserved_1_1_WIDTH                             1
#define D18F0x98_Reserved_1_1_MASK                              0x2
#define D18F0x98_Reserved_2_2_OFFSET                            2
#define D18F0x98_Reserved_2_2_WIDTH                             1
#define D18F0x98_Reserved_2_2_MASK                              0x4
#define D18F0x98_Reserved_4_3_OFFSET                            3
#define D18F0x98_Reserved_4_3_WIDTH                             2
#define D18F0x98_Reserved_4_3_MASK                              0x18
#define D18F0x98_PciEligible_OFFSET                             5
#define D18F0x98_PciEligible_WIDTH                              1
#define D18F0x98_PciEligible_MASK                               0x20
#define D18F0x98_Reserved_31_6_OFFSET                           6
#define D18F0x98_Reserved_31_6_WIDTH                            26
#define D18F0x98_Reserved_31_6_MASK                             0xffffffc0

/// D18F0x98
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                              PciEligible:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x98_STRUCT;

// **** D18F0x9C Register Definition ****
// Address
#define D18F0x9C_ADDRESS                                        0x9c

// Type
#define D18F0x9C_TYPE                                           TYPE_D18F0
// Field Data
#define D18F0x9C_Reserved_0_0_OFFSET                            0
#define D18F0x9C_Reserved_0_0_WIDTH                             1
#define D18F0x9C_Reserved_0_0_MASK                              0x1
#define D18F0x9C_Reserved_15_1_OFFSET                           1
#define D18F0x9C_Reserved_15_1_WIDTH                            15
#define D18F0x9C_Reserved_15_1_MASK                             0xfffe
#define D18F0x9C_Reserved_31_16_OFFSET                          16
#define D18F0x9C_Reserved_31_16_WIDTH                           16
#define D18F0x9C_Reserved_31_16_MASK                            0xffff0000

/// D18F0x9C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                            Reserved_15_1:15; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x9C_STRUCT;

// **** D18F0x110 Register Definition ****
// Address
#define D18F0x110_ADDRESS                                       0x110

// Type
#define D18F0x110_TYPE                                          TYPE_D18F0
// Field Data
#define D18F0x110_Reserved_0_0_OFFSET                           0
#define D18F0x110_Reserved_0_0_WIDTH                            1
#define D18F0x110_Reserved_0_0_MASK                             0x1
#define D18F0x110_Reserved_1_1_OFFSET                           1
#define D18F0x110_Reserved_1_1_WIDTH                            1
#define D18F0x110_Reserved_1_1_MASK                             0x2
#define D18F0x110_ClumpEn_OFFSET                                2
#define D18F0x110_ClumpEn_WIDTH                                 30
#define D18F0x110_ClumpEn_MASK                                  0xfffffffc

/// D18F0x110
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                  ClumpEn:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x110_STRUCT;

// **** D18F0x16C Register Definition ****
// Address
#define D18F0x16C_ADDRESS                                       0x16c

// Type
#define D18F0x16C_TYPE                                          TYPE_D18F0
// Field Data
#define D18F0x16C_Reserved_31_0_OFFSET                          0
#define D18F0x16C_Reserved_31_0_WIDTH                           32
#define D18F0x16C_Reserved_31_0_MASK                            0xffffffff

/// D18F0x16C
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x16C_STRUCT;

// **** D18F0x170 Register Definition ****
// Address
#define D18F0x170_ADDRESS                                       0x170

// Type
#define D18F0x170_TYPE                                          TYPE_D18F0
// Field Data
#define D18F0x170_Reserved_31_0_OFFSET                          0
#define D18F0x170_Reserved_31_0_WIDTH                           32
#define D18F0x170_Reserved_31_0_MASK                            0xffffffff

/// D18F0x170
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x170_STRUCT;

// **** D18F0x1A0 Register Definition ****
// Address
#define D18F0x1A0_ADDRESS                                       0x1a0

// Type
#define D18F0x1A0_TYPE                                          TYPE_D18F0
// Field Data
#define D18F0x1A0_InitComplete_OFFSET                           0
#define D18F0x1A0_InitComplete_WIDTH                            2
#define D18F0x1A0_InitComplete_MASK                             0x3
#define D18F0x1A0_Reserved_30_2_OFFSET                          2
#define D18F0x1A0_Reserved_30_2_WIDTH                           29
#define D18F0x1A0_Reserved_30_2_MASK                            0x7ffffffc
#define D18F0x1A0_InitStatusValid_OFFSET                        31
#define D18F0x1A0_InitStatusValid_WIDTH                         1
#define D18F0x1A0_InitStatusValid_MASK                          0x80000000

/// D18F0x1A0
typedef union {
  struct {                                                              ///<
    UINT32                                             InitComplete:2 ; ///<
    UINT32                                            Reserved_30_2:29; ///<
    UINT32                                          InitStatusValid:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x1A0_STRUCT;

// **** D18F0x1DC Register Definition ****
// Address
#define D18F0x1DC_ADDRESS                                       0x1dc

// Type
#define D18F0x1DC_TYPE                                          TYPE_D18F0
// Field Data
#define D18F0x1DC_Reserved_0_0_OFFSET                           0
#define D18F0x1DC_Reserved_0_0_WIDTH                            1
#define D18F0x1DC_Reserved_0_0_MASK                             0x1
#define D18F0x1DC_CpuEn_OFFSET                                  1
#define D18F0x1DC_CpuEn_WIDTH                                   7
#define D18F0x1DC_CpuEn_MASK                                    0xfe
#define D18F0x1DC_Reserved_31_8_OFFSET                          8
#define D18F0x1DC_Reserved_31_8_WIDTH                           24
#define D18F0x1DC_Reserved_31_8_MASK                            0xffffff00

/// D18F0x1DC
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                    CpuEn:7 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F0x1DC_STRUCT;

// **** D18F1x00 Register Definition ****
// Address
#define D18F1x00_ADDRESS                                        0x0

// Type
#define D18F1x00_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x00_VendorID_OFFSET                                0
#define D18F1x00_VendorID_WIDTH                                 16
#define D18F1x00_VendorID_MASK                                  0xffff
#define D18F1x00_DeviceID_OFFSET                                16
#define D18F1x00_DeviceID_WIDTH                                 16
#define D18F1x00_DeviceID_MASK                                  0xffff0000

/// D18F1x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x00_STRUCT;

// **** D18F1x08 Register Definition ****
// Address
#define D18F1x08_ADDRESS                                        0x8

// Type
#define D18F1x08_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x08_RevID_OFFSET                                   0
#define D18F1x08_RevID_WIDTH                                    8
#define D18F1x08_RevID_MASK                                     0xff
#define D18F1x08_ClassCode_OFFSET                               8
#define D18F1x08_ClassCode_WIDTH                                24
#define D18F1x08_ClassCode_MASK                                 0xffffff00

/// D18F1x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x08_STRUCT;

// **** D18F1x0C Register Definition ****
// Address
#define D18F1x0C_ADDRESS                                        0xc

// Type
#define D18F1x0C_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x0C_HeaderTypeReg_OFFSET                           0
#define D18F1x0C_HeaderTypeReg_WIDTH                            32
#define D18F1x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F1x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x0C_STRUCT;

// **** D18F1x40 Register Definition ****
// Address
#define D18F1x40_ADDRESS                                        0x40

// Type
#define D18F1x40_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x40_RE_OFFSET                                      0
#define D18F1x40_RE_WIDTH                                       1
#define D18F1x40_RE_MASK                                        0x1
#define D18F1x40_WE_OFFSET                                      1
#define D18F1x40_WE_WIDTH                                       1
#define D18F1x40_WE_MASK                                        0x2
#define D18F1x40_Reserved_15_2_OFFSET                           2
#define D18F1x40_Reserved_15_2_WIDTH                            14
#define D18F1x40_Reserved_15_2_MASK                             0xfffc
#define D18F1x40_DramBase_39_24__OFFSET                         16
#define D18F1x40_DramBase_39_24__WIDTH                          16
#define D18F1x40_DramBase_39_24__MASK                           0xffff0000

/// D18F1x40
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                            Reserved_15_2:14; ///<
    UINT32                                          DramBase_39_24_:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x40_STRUCT;

// **** D18F1x44 Register Definition ****
// Address
#define D18F1x44_ADDRESS                                        0x44

// Type
#define D18F1x44_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x44_DstNode_OFFSET                                 0
#define D18F1x44_DstNode_WIDTH                                  3
#define D18F1x44_DstNode_MASK                                   0x7
#define D18F1x44_Reserved_7_3_OFFSET                            3
#define D18F1x44_Reserved_7_3_WIDTH                             5
#define D18F1x44_Reserved_7_3_MASK                              0xf8
#define D18F1x44_Reserved_10_8_OFFSET                           8
#define D18F1x44_Reserved_10_8_WIDTH                            3
#define D18F1x44_Reserved_10_8_MASK                             0x700
#define D18F1x44_Reserved_15_11_OFFSET                          11
#define D18F1x44_Reserved_15_11_WIDTH                           5
#define D18F1x44_Reserved_15_11_MASK                            0xf800
#define D18F1x44_DramLimit_39_24__OFFSET                        16
#define D18F1x44_DramLimit_39_24__WIDTH                         16
#define D18F1x44_DramLimit_39_24__MASK                          0xffff0000

/// D18F1x44
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_7_3:5 ; ///<
    UINT32                                            Reserved_10_8:3 ; ///<
    UINT32                                           Reserved_15_11:5 ; ///<
    UINT32                                         DramLimit_39_24_:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x44_STRUCT;

// **** D18F1x80 Register Definition ****
// Address
#define D18F1x80_ADDRESS                                        0x80

// Type
#define D18F1x80_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x80_RE_OFFSET                                      0
#define D18F1x80_RE_WIDTH                                       1
#define D18F1x80_RE_MASK                                        0x1
#define D18F1x80_WE_OFFSET                                      1
#define D18F1x80_WE_WIDTH                                       1
#define D18F1x80_WE_MASK                                        0x2
#define D18F1x80_Reserved_2_2_OFFSET                            2
#define D18F1x80_Reserved_2_2_WIDTH                             1
#define D18F1x80_Reserved_2_2_MASK                              0x4
#define D18F1x80_Lock_OFFSET                                    3
#define D18F1x80_Lock_WIDTH                                     1
#define D18F1x80_Lock_MASK                                      0x8
#define D18F1x80_Reserved_7_4_OFFSET                            4
#define D18F1x80_Reserved_7_4_WIDTH                             4
#define D18F1x80_Reserved_7_4_MASK                              0xf0
#define D18F1x80_MMIOBase_39_16__OFFSET                         8
#define D18F1x80_MMIOBase_39_16__WIDTH                          24
#define D18F1x80_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1x80
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x80_STRUCT;

// **** D18F1x84 Register Definition ****
// Address
#define D18F1x84_ADDRESS                                        0x84

// Type
#define D18F1x84_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x84_DstNode_OFFSET                                 0
#define D18F1x84_DstNode_WIDTH                                  3
#define D18F1x84_DstNode_MASK                                   0x7
#define D18F1x84_Reserved_3_3_OFFSET                            3
#define D18F1x84_Reserved_3_3_WIDTH                             1
#define D18F1x84_Reserved_3_3_MASK                              0x8
#define D18F1x84_DstLink_OFFSET                                 4
#define D18F1x84_DstLink_WIDTH                                  2
#define D18F1x84_DstLink_MASK                                   0x30
#define D18F1x84_DstSubLink_OFFSET                              6
#define D18F1x84_DstSubLink_WIDTH                               1
#define D18F1x84_DstSubLink_MASK                                0x40
#define D18F1x84_NP_OFFSET                                      7
#define D18F1x84_NP_WIDTH                                       1
#define D18F1x84_NP_MASK                                        0x80
#define D18F1x84_MMIOLimit_39_16__OFFSET                        8
#define D18F1x84_MMIOLimit_39_16__WIDTH                         24
#define D18F1x84_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1x84
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x84_STRUCT;

// **** D18F1x88 Register Definition ****
// Address
#define D18F1x88_ADDRESS                                        0x88

// Type
#define D18F1x88_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x88_RE_OFFSET                                      0
#define D18F1x88_RE_WIDTH                                       1
#define D18F1x88_RE_MASK                                        0x1
#define D18F1x88_WE_OFFSET                                      1
#define D18F1x88_WE_WIDTH                                       1
#define D18F1x88_WE_MASK                                        0x2
#define D18F1x88_Reserved_2_2_OFFSET                            2
#define D18F1x88_Reserved_2_2_WIDTH                             1
#define D18F1x88_Reserved_2_2_MASK                              0x4
#define D18F1x88_Lock_OFFSET                                    3
#define D18F1x88_Lock_WIDTH                                     1
#define D18F1x88_Lock_MASK                                      0x8
#define D18F1x88_Reserved_7_4_OFFSET                            4
#define D18F1x88_Reserved_7_4_WIDTH                             4
#define D18F1x88_Reserved_7_4_MASK                              0xf0
#define D18F1x88_MMIOBase_39_16__OFFSET                         8
#define D18F1x88_MMIOBase_39_16__WIDTH                          24
#define D18F1x88_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1x88
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x88_STRUCT;

// **** D18F1x8C Register Definition ****
// Address
#define D18F1x8C_ADDRESS                                        0x8c

// Type
#define D18F1x8C_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x8C_DstNode_OFFSET                                 0
#define D18F1x8C_DstNode_WIDTH                                  3
#define D18F1x8C_DstNode_MASK                                   0x7
#define D18F1x8C_Reserved_3_3_OFFSET                            3
#define D18F1x8C_Reserved_3_3_WIDTH                             1
#define D18F1x8C_Reserved_3_3_MASK                              0x8
#define D18F1x8C_DstLink_OFFSET                                 4
#define D18F1x8C_DstLink_WIDTH                                  2
#define D18F1x8C_DstLink_MASK                                   0x30
#define D18F1x8C_DstSubLink_OFFSET                              6
#define D18F1x8C_DstSubLink_WIDTH                               1
#define D18F1x8C_DstSubLink_MASK                                0x40
#define D18F1x8C_NP_OFFSET                                      7
#define D18F1x8C_NP_WIDTH                                       1
#define D18F1x8C_NP_MASK                                        0x80
#define D18F1x8C_MMIOLimit_39_16__OFFSET                        8
#define D18F1x8C_MMIOLimit_39_16__WIDTH                         24
#define D18F1x8C_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1x8C
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x8C_STRUCT;

// **** D18F1x90 Register Definition ****
// Address
#define D18F1x90_ADDRESS                                        0x90

// Type
#define D18F1x90_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x90_RE_OFFSET                                      0
#define D18F1x90_RE_WIDTH                                       1
#define D18F1x90_RE_MASK                                        0x1
#define D18F1x90_WE_OFFSET                                      1
#define D18F1x90_WE_WIDTH                                       1
#define D18F1x90_WE_MASK                                        0x2
#define D18F1x90_Reserved_2_2_OFFSET                            2
#define D18F1x90_Reserved_2_2_WIDTH                             1
#define D18F1x90_Reserved_2_2_MASK                              0x4
#define D18F1x90_Lock_OFFSET                                    3
#define D18F1x90_Lock_WIDTH                                     1
#define D18F1x90_Lock_MASK                                      0x8
#define D18F1x90_Reserved_7_4_OFFSET                            4
#define D18F1x90_Reserved_7_4_WIDTH                             4
#define D18F1x90_Reserved_7_4_MASK                              0xf0
#define D18F1x90_MMIOBase_39_16__OFFSET                         8
#define D18F1x90_MMIOBase_39_16__WIDTH                          24
#define D18F1x90_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1x90
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x90_STRUCT;

// **** D18F1x94 Register Definition ****
// Address
#define D18F1x94_ADDRESS                                        0x94

// Type
#define D18F1x94_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x94_DstNode_OFFSET                                 0
#define D18F1x94_DstNode_WIDTH                                  3
#define D18F1x94_DstNode_MASK                                   0x7
#define D18F1x94_Reserved_3_3_OFFSET                            3
#define D18F1x94_Reserved_3_3_WIDTH                             1
#define D18F1x94_Reserved_3_3_MASK                              0x8
#define D18F1x94_DstLink_OFFSET                                 4
#define D18F1x94_DstLink_WIDTH                                  2
#define D18F1x94_DstLink_MASK                                   0x30
#define D18F1x94_DstSubLink_OFFSET                              6
#define D18F1x94_DstSubLink_WIDTH                               1
#define D18F1x94_DstSubLink_MASK                                0x40
#define D18F1x94_NP_OFFSET                                      7
#define D18F1x94_NP_WIDTH                                       1
#define D18F1x94_NP_MASK                                        0x80
#define D18F1x94_MMIOLimit_39_16__OFFSET                        8
#define D18F1x94_MMIOLimit_39_16__WIDTH                         24
#define D18F1x94_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1x94
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x94_STRUCT;

// **** D18F1x98 Register Definition ****
// Address
#define D18F1x98_ADDRESS                                        0x98

// Type
#define D18F1x98_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x98_RE_OFFSET                                      0
#define D18F1x98_RE_WIDTH                                       1
#define D18F1x98_RE_MASK                                        0x1
#define D18F1x98_WE_OFFSET                                      1
#define D18F1x98_WE_WIDTH                                       1
#define D18F1x98_WE_MASK                                        0x2
#define D18F1x98_Reserved_2_2_OFFSET                            2
#define D18F1x98_Reserved_2_2_WIDTH                             1
#define D18F1x98_Reserved_2_2_MASK                              0x4
#define D18F1x98_Lock_OFFSET                                    3
#define D18F1x98_Lock_WIDTH                                     1
#define D18F1x98_Lock_MASK                                      0x8
#define D18F1x98_Reserved_7_4_OFFSET                            4
#define D18F1x98_Reserved_7_4_WIDTH                             4
#define D18F1x98_Reserved_7_4_MASK                              0xf0
#define D18F1x98_MMIOBase_39_16__OFFSET                         8
#define D18F1x98_MMIOBase_39_16__WIDTH                          24
#define D18F1x98_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1x98
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x98_STRUCT;

// **** D18F1x9C Register Definition ****
// Address
#define D18F1x9C_ADDRESS                                        0x9c

// Type
#define D18F1x9C_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1x9C_DstNode_OFFSET                                 0
#define D18F1x9C_DstNode_WIDTH                                  3
#define D18F1x9C_DstNode_MASK                                   0x7
#define D18F1x9C_Reserved_3_3_OFFSET                            3
#define D18F1x9C_Reserved_3_3_WIDTH                             1
#define D18F1x9C_Reserved_3_3_MASK                              0x8
#define D18F1x9C_DstLink_OFFSET                                 4
#define D18F1x9C_DstLink_WIDTH                                  2
#define D18F1x9C_DstLink_MASK                                   0x30
#define D18F1x9C_DstSubLink_OFFSET                              6
#define D18F1x9C_DstSubLink_WIDTH                               1
#define D18F1x9C_DstSubLink_MASK                                0x40
#define D18F1x9C_NP_OFFSET                                      7
#define D18F1x9C_NP_WIDTH                                       1
#define D18F1x9C_NP_MASK                                        0x80
#define D18F1x9C_MMIOLimit_39_16__OFFSET                        8
#define D18F1x9C_MMIOLimit_39_16__WIDTH                         24
#define D18F1x9C_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1x9C
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x9C_STRUCT;

// **** D18F1xA0 Register Definition ****
// Address
#define D18F1xA0_ADDRESS                                        0xa0

// Type
#define D18F1xA0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xA0_RE_OFFSET                                      0
#define D18F1xA0_RE_WIDTH                                       1
#define D18F1xA0_RE_MASK                                        0x1
#define D18F1xA0_WE_OFFSET                                      1
#define D18F1xA0_WE_WIDTH                                       1
#define D18F1xA0_WE_MASK                                        0x2
#define D18F1xA0_Reserved_2_2_OFFSET                            2
#define D18F1xA0_Reserved_2_2_WIDTH                             1
#define D18F1xA0_Reserved_2_2_MASK                              0x4
#define D18F1xA0_Lock_OFFSET                                    3
#define D18F1xA0_Lock_WIDTH                                     1
#define D18F1xA0_Lock_MASK                                      0x8
#define D18F1xA0_Reserved_7_4_OFFSET                            4
#define D18F1xA0_Reserved_7_4_WIDTH                             4
#define D18F1xA0_Reserved_7_4_MASK                              0xf0
#define D18F1xA0_MMIOBase_39_16__OFFSET                         8
#define D18F1xA0_MMIOBase_39_16__WIDTH                          24
#define D18F1xA0_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1xA0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xA0_STRUCT;

// **** D18F1xA4 Register Definition ****
// Address
#define D18F1xA4_ADDRESS                                        0xa4

// Type
#define D18F1xA4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xA4_DstNode_OFFSET                                 0
#define D18F1xA4_DstNode_WIDTH                                  3
#define D18F1xA4_DstNode_MASK                                   0x7
#define D18F1xA4_Reserved_3_3_OFFSET                            3
#define D18F1xA4_Reserved_3_3_WIDTH                             1
#define D18F1xA4_Reserved_3_3_MASK                              0x8
#define D18F1xA4_DstLink_OFFSET                                 4
#define D18F1xA4_DstLink_WIDTH                                  2
#define D18F1xA4_DstLink_MASK                                   0x30
#define D18F1xA4_DstSubLink_OFFSET                              6
#define D18F1xA4_DstSubLink_WIDTH                               1
#define D18F1xA4_DstSubLink_MASK                                0x40
#define D18F1xA4_NP_OFFSET                                      7
#define D18F1xA4_NP_WIDTH                                       1
#define D18F1xA4_NP_MASK                                        0x80
#define D18F1xA4_MMIOLimit_39_16__OFFSET                        8
#define D18F1xA4_MMIOLimit_39_16__WIDTH                         24
#define D18F1xA4_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1xA4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xA4_STRUCT;

// **** D18F1xA8 Register Definition ****
// Address
#define D18F1xA8_ADDRESS                                        0xa8

// Type
#define D18F1xA8_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xA8_RE_OFFSET                                      0
#define D18F1xA8_RE_WIDTH                                       1
#define D18F1xA8_RE_MASK                                        0x1
#define D18F1xA8_WE_OFFSET                                      1
#define D18F1xA8_WE_WIDTH                                       1
#define D18F1xA8_WE_MASK                                        0x2
#define D18F1xA8_Reserved_2_2_OFFSET                            2
#define D18F1xA8_Reserved_2_2_WIDTH                             1
#define D18F1xA8_Reserved_2_2_MASK                              0x4
#define D18F1xA8_Lock_OFFSET                                    3
#define D18F1xA8_Lock_WIDTH                                     1
#define D18F1xA8_Lock_MASK                                      0x8
#define D18F1xA8_Reserved_7_4_OFFSET                            4
#define D18F1xA8_Reserved_7_4_WIDTH                             4
#define D18F1xA8_Reserved_7_4_MASK                              0xf0
#define D18F1xA8_MMIOBase_39_16__OFFSET                         8
#define D18F1xA8_MMIOBase_39_16__WIDTH                          24
#define D18F1xA8_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1xA8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xA8_STRUCT;

// **** D18F1xAC Register Definition ****
// Address
#define D18F1xAC_ADDRESS                                        0xac

// Type
#define D18F1xAC_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xAC_DstNode_OFFSET                                 0
#define D18F1xAC_DstNode_WIDTH                                  3
#define D18F1xAC_DstNode_MASK                                   0x7
#define D18F1xAC_Reserved_3_3_OFFSET                            3
#define D18F1xAC_Reserved_3_3_WIDTH                             1
#define D18F1xAC_Reserved_3_3_MASK                              0x8
#define D18F1xAC_DstLink_OFFSET                                 4
#define D18F1xAC_DstLink_WIDTH                                  2
#define D18F1xAC_DstLink_MASK                                   0x30
#define D18F1xAC_DstSubLink_OFFSET                              6
#define D18F1xAC_DstSubLink_WIDTH                               1
#define D18F1xAC_DstSubLink_MASK                                0x40
#define D18F1xAC_NP_OFFSET                                      7
#define D18F1xAC_NP_WIDTH                                       1
#define D18F1xAC_NP_MASK                                        0x80
#define D18F1xAC_MMIOLimit_39_16__OFFSET                        8
#define D18F1xAC_MMIOLimit_39_16__WIDTH                         24
#define D18F1xAC_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1xAC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xAC_STRUCT;

// **** D18F1xB0 Register Definition ****
// Address
#define D18F1xB0_ADDRESS                                        0xb0

// Type
#define D18F1xB0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xB0_RE_OFFSET                                      0
#define D18F1xB0_RE_WIDTH                                       1
#define D18F1xB0_RE_MASK                                        0x1
#define D18F1xB0_WE_OFFSET                                      1
#define D18F1xB0_WE_WIDTH                                       1
#define D18F1xB0_WE_MASK                                        0x2
#define D18F1xB0_Reserved_2_2_OFFSET                            2
#define D18F1xB0_Reserved_2_2_WIDTH                             1
#define D18F1xB0_Reserved_2_2_MASK                              0x4
#define D18F1xB0_Lock_OFFSET                                    3
#define D18F1xB0_Lock_WIDTH                                     1
#define D18F1xB0_Lock_MASK                                      0x8
#define D18F1xB0_Reserved_7_4_OFFSET                            4
#define D18F1xB0_Reserved_7_4_WIDTH                             4
#define D18F1xB0_Reserved_7_4_MASK                              0xf0
#define D18F1xB0_MMIOBase_39_16__OFFSET                         8
#define D18F1xB0_MMIOBase_39_16__WIDTH                          24
#define D18F1xB0_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1xB0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xB0_STRUCT;

// **** D18F1xB4 Register Definition ****
// Address
#define D18F1xB4_ADDRESS                                        0xb4

// Type
#define D18F1xB4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xB4_DstNode_OFFSET                                 0
#define D18F1xB4_DstNode_WIDTH                                  3
#define D18F1xB4_DstNode_MASK                                   0x7
#define D18F1xB4_Reserved_3_3_OFFSET                            3
#define D18F1xB4_Reserved_3_3_WIDTH                             1
#define D18F1xB4_Reserved_3_3_MASK                              0x8
#define D18F1xB4_DstLink_OFFSET                                 4
#define D18F1xB4_DstLink_WIDTH                                  2
#define D18F1xB4_DstLink_MASK                                   0x30
#define D18F1xB4_DstSubLink_OFFSET                              6
#define D18F1xB4_DstSubLink_WIDTH                               1
#define D18F1xB4_DstSubLink_MASK                                0x40
#define D18F1xB4_NP_OFFSET                                      7
#define D18F1xB4_NP_WIDTH                                       1
#define D18F1xB4_NP_MASK                                        0x80
#define D18F1xB4_MMIOLimit_39_16__OFFSET                        8
#define D18F1xB4_MMIOLimit_39_16__WIDTH                         24
#define D18F1xB4_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1xB4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xB4_STRUCT;

// **** D18F1xB8 Register Definition ****
// Address
#define D18F1xB8_ADDRESS                                        0xb8

// Type
#define D18F1xB8_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xB8_RE_OFFSET                                      0
#define D18F1xB8_RE_WIDTH                                       1
#define D18F1xB8_RE_MASK                                        0x1
#define D18F1xB8_WE_OFFSET                                      1
#define D18F1xB8_WE_WIDTH                                       1
#define D18F1xB8_WE_MASK                                        0x2
#define D18F1xB8_Reserved_2_2_OFFSET                            2
#define D18F1xB8_Reserved_2_2_WIDTH                             1
#define D18F1xB8_Reserved_2_2_MASK                              0x4
#define D18F1xB8_Lock_OFFSET                                    3
#define D18F1xB8_Lock_WIDTH                                     1
#define D18F1xB8_Lock_MASK                                      0x8
#define D18F1xB8_Reserved_7_4_OFFSET                            4
#define D18F1xB8_Reserved_7_4_WIDTH                             4
#define D18F1xB8_Reserved_7_4_MASK                              0xf0
#define D18F1xB8_MMIOBase_39_16__OFFSET                         8
#define D18F1xB8_MMIOBase_39_16__WIDTH                          24
#define D18F1xB8_MMIOBase_39_16__MASK                           0xffffff00

/// D18F1xB8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xB8_STRUCT;

// **** D18F1xBC Register Definition ****
// Address
#define D18F1xBC_ADDRESS                                        0xbc

// Type
#define D18F1xBC_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xBC_DstNode_OFFSET                                 0
#define D18F1xBC_DstNode_WIDTH                                  3
#define D18F1xBC_DstNode_MASK                                   0x7
#define D18F1xBC_Reserved_3_3_OFFSET                            3
#define D18F1xBC_Reserved_3_3_WIDTH                             1
#define D18F1xBC_Reserved_3_3_MASK                              0x8
#define D18F1xBC_DstLink_OFFSET                                 4
#define D18F1xBC_DstLink_WIDTH                                  2
#define D18F1xBC_DstLink_MASK                                   0x30
#define D18F1xBC_DstSubLink_OFFSET                              6
#define D18F1xBC_DstSubLink_WIDTH                               1
#define D18F1xBC_DstSubLink_MASK                                0x40
#define D18F1xBC_NP_OFFSET                                      7
#define D18F1xBC_NP_WIDTH                                       1
#define D18F1xBC_NP_MASK                                        0x80
#define D18F1xBC_MMIOLimit_39_16__OFFSET                        8
#define D18F1xBC_MMIOLimit_39_16__WIDTH                         24
#define D18F1xBC_MMIOLimit_39_16__MASK                          0xffffff00

/// D18F1xBC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xBC_STRUCT;

// **** D18F1xC0 Register Definition ****
// Address
#define D18F1xC0_ADDRESS                                        0xc0

// Type
#define D18F1xC0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xC0_RE_OFFSET                                      0
#define D18F1xC0_RE_WIDTH                                       1
#define D18F1xC0_RE_MASK                                        0x1
#define D18F1xC0_WE_OFFSET                                      1
#define D18F1xC0_WE_WIDTH                                       1
#define D18F1xC0_WE_MASK                                        0x2
#define D18F1xC0_Reserved_3_2_OFFSET                            2
#define D18F1xC0_Reserved_3_2_WIDTH                             2
#define D18F1xC0_Reserved_3_2_MASK                              0xc
#define D18F1xC0_VE_OFFSET                                      4
#define D18F1xC0_VE_WIDTH                                       1
#define D18F1xC0_VE_MASK                                        0x10
#define D18F1xC0_IE_OFFSET                                      5
#define D18F1xC0_IE_WIDTH                                       1
#define D18F1xC0_IE_MASK                                        0x20
#define D18F1xC0_Reserved_11_6_OFFSET                           6
#define D18F1xC0_Reserved_11_6_WIDTH                            6
#define D18F1xC0_Reserved_11_6_MASK                             0xfc0
#define D18F1xC0_IOBase_24_12__OFFSET                           12
#define D18F1xC0_IOBase_24_12__WIDTH                            13
#define D18F1xC0_IOBase_24_12__MASK                             0x1fff000
#define D18F1xC0_Reserved_31_25_OFFSET                          25
#define D18F1xC0_Reserved_31_25_WIDTH                           7
#define D18F1xC0_Reserved_31_25_MASK                            0xfe000000

/// D18F1xC0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                       VE:1 ; ///<
    UINT32                                                       IE:1 ; ///<
    UINT32                                            Reserved_11_6:6 ; ///<
    UINT32                                            IOBase_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xC0_STRUCT;

// **** D18F1xC4 Register Definition ****
// Address
#define D18F1xC4_ADDRESS                                        0xc4

// Type
#define D18F1xC4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xC4_DstNode_OFFSET                                 0
#define D18F1xC4_DstNode_WIDTH                                  3
#define D18F1xC4_DstNode_MASK                                   0x7
#define D18F1xC4_Reserved_3_3_OFFSET                            3
#define D18F1xC4_Reserved_3_3_WIDTH                             1
#define D18F1xC4_Reserved_3_3_MASK                              0x8
#define D18F1xC4_DstLink_OFFSET                                 4
#define D18F1xC4_DstLink_WIDTH                                  2
#define D18F1xC4_DstLink_MASK                                   0x30
#define D18F1xC4_DstSubLink_OFFSET                              6
#define D18F1xC4_DstSubLink_WIDTH                               1
#define D18F1xC4_DstSubLink_MASK                                0x40
#define D18F1xC4_Reserved_11_7_OFFSET                           7
#define D18F1xC4_Reserved_11_7_WIDTH                            5
#define D18F1xC4_Reserved_11_7_MASK                             0xf80
#define D18F1xC4_IOLimit_24_12__OFFSET                          12
#define D18F1xC4_IOLimit_24_12__WIDTH                           13
#define D18F1xC4_IOLimit_24_12__MASK                            0x1fff000
#define D18F1xC4_Reserved_31_25_OFFSET                          25
#define D18F1xC4_Reserved_31_25_WIDTH                           7
#define D18F1xC4_Reserved_31_25_MASK                            0xfe000000

/// D18F1xC4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                           IOLimit_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xC4_STRUCT;

// **** D18F1xC8 Register Definition ****
// Address
#define D18F1xC8_ADDRESS                                        0xc8

// Type
#define D18F1xC8_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xC8_RE_OFFSET                                      0
#define D18F1xC8_RE_WIDTH                                       1
#define D18F1xC8_RE_MASK                                        0x1
#define D18F1xC8_WE_OFFSET                                      1
#define D18F1xC8_WE_WIDTH                                       1
#define D18F1xC8_WE_MASK                                        0x2
#define D18F1xC8_Reserved_3_2_OFFSET                            2
#define D18F1xC8_Reserved_3_2_WIDTH                             2
#define D18F1xC8_Reserved_3_2_MASK                              0xc
#define D18F1xC8_VE_OFFSET                                      4
#define D18F1xC8_VE_WIDTH                                       1
#define D18F1xC8_VE_MASK                                        0x10
#define D18F1xC8_IE_OFFSET                                      5
#define D18F1xC8_IE_WIDTH                                       1
#define D18F1xC8_IE_MASK                                        0x20
#define D18F1xC8_Reserved_11_6_OFFSET                           6
#define D18F1xC8_Reserved_11_6_WIDTH                            6
#define D18F1xC8_Reserved_11_6_MASK                             0xfc0
#define D18F1xC8_IOBase_24_12__OFFSET                           12
#define D18F1xC8_IOBase_24_12__WIDTH                            13
#define D18F1xC8_IOBase_24_12__MASK                             0x1fff000
#define D18F1xC8_Reserved_31_25_OFFSET                          25
#define D18F1xC8_Reserved_31_25_WIDTH                           7
#define D18F1xC8_Reserved_31_25_MASK                            0xfe000000

/// D18F1xC8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                       VE:1 ; ///<
    UINT32                                                       IE:1 ; ///<
    UINT32                                            Reserved_11_6:6 ; ///<
    UINT32                                            IOBase_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xC8_STRUCT;

// **** D18F1xCC Register Definition ****
// Address
#define D18F1xCC_ADDRESS                                        0xcc

// Type
#define D18F1xCC_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xCC_DstNode_OFFSET                                 0
#define D18F1xCC_DstNode_WIDTH                                  3
#define D18F1xCC_DstNode_MASK                                   0x7
#define D18F1xCC_Reserved_3_3_OFFSET                            3
#define D18F1xCC_Reserved_3_3_WIDTH                             1
#define D18F1xCC_Reserved_3_3_MASK                              0x8
#define D18F1xCC_DstLink_OFFSET                                 4
#define D18F1xCC_DstLink_WIDTH                                  2
#define D18F1xCC_DstLink_MASK                                   0x30
#define D18F1xCC_DstSubLink_OFFSET                              6
#define D18F1xCC_DstSubLink_WIDTH                               1
#define D18F1xCC_DstSubLink_MASK                                0x40
#define D18F1xCC_Reserved_11_7_OFFSET                           7
#define D18F1xCC_Reserved_11_7_WIDTH                            5
#define D18F1xCC_Reserved_11_7_MASK                             0xf80
#define D18F1xCC_IOLimit_24_12__OFFSET                          12
#define D18F1xCC_IOLimit_24_12__WIDTH                           13
#define D18F1xCC_IOLimit_24_12__MASK                            0x1fff000
#define D18F1xCC_Reserved_31_25_OFFSET                          25
#define D18F1xCC_Reserved_31_25_WIDTH                           7
#define D18F1xCC_Reserved_31_25_MASK                            0xfe000000

/// D18F1xCC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                           IOLimit_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xCC_STRUCT;

// **** D18F1xD0 Register Definition ****
// Address
#define D18F1xD0_ADDRESS                                        0xd0

// Type
#define D18F1xD0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xD0_RE_OFFSET                                      0
#define D18F1xD0_RE_WIDTH                                       1
#define D18F1xD0_RE_MASK                                        0x1
#define D18F1xD0_WE_OFFSET                                      1
#define D18F1xD0_WE_WIDTH                                       1
#define D18F1xD0_WE_MASK                                        0x2
#define D18F1xD0_Reserved_3_2_OFFSET                            2
#define D18F1xD0_Reserved_3_2_WIDTH                             2
#define D18F1xD0_Reserved_3_2_MASK                              0xc
#define D18F1xD0_VE_OFFSET                                      4
#define D18F1xD0_VE_WIDTH                                       1
#define D18F1xD0_VE_MASK                                        0x10
#define D18F1xD0_IE_OFFSET                                      5
#define D18F1xD0_IE_WIDTH                                       1
#define D18F1xD0_IE_MASK                                        0x20
#define D18F1xD0_Reserved_11_6_OFFSET                           6
#define D18F1xD0_Reserved_11_6_WIDTH                            6
#define D18F1xD0_Reserved_11_6_MASK                             0xfc0
#define D18F1xD0_IOBase_24_12__OFFSET                           12
#define D18F1xD0_IOBase_24_12__WIDTH                            13
#define D18F1xD0_IOBase_24_12__MASK                             0x1fff000
#define D18F1xD0_Reserved_31_25_OFFSET                          25
#define D18F1xD0_Reserved_31_25_WIDTH                           7
#define D18F1xD0_Reserved_31_25_MASK                            0xfe000000

/// D18F1xD0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                       VE:1 ; ///<
    UINT32                                                       IE:1 ; ///<
    UINT32                                            Reserved_11_6:6 ; ///<
    UINT32                                            IOBase_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xD0_STRUCT;

// **** D18F1xD4 Register Definition ****
// Address
#define D18F1xD4_ADDRESS                                        0xd4

// Type
#define D18F1xD4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xD4_DstNode_OFFSET                                 0
#define D18F1xD4_DstNode_WIDTH                                  3
#define D18F1xD4_DstNode_MASK                                   0x7
#define D18F1xD4_Reserved_3_3_OFFSET                            3
#define D18F1xD4_Reserved_3_3_WIDTH                             1
#define D18F1xD4_Reserved_3_3_MASK                              0x8
#define D18F1xD4_DstLink_OFFSET                                 4
#define D18F1xD4_DstLink_WIDTH                                  2
#define D18F1xD4_DstLink_MASK                                   0x30
#define D18F1xD4_DstSubLink_OFFSET                              6
#define D18F1xD4_DstSubLink_WIDTH                               1
#define D18F1xD4_DstSubLink_MASK                                0x40
#define D18F1xD4_Reserved_11_7_OFFSET                           7
#define D18F1xD4_Reserved_11_7_WIDTH                            5
#define D18F1xD4_Reserved_11_7_MASK                             0xf80
#define D18F1xD4_IOLimit_24_12__OFFSET                          12
#define D18F1xD4_IOLimit_24_12__WIDTH                           13
#define D18F1xD4_IOLimit_24_12__MASK                            0x1fff000
#define D18F1xD4_Reserved_31_25_OFFSET                          25
#define D18F1xD4_Reserved_31_25_WIDTH                           7
#define D18F1xD4_Reserved_31_25_MASK                            0xfe000000

/// D18F1xD4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                           IOLimit_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xD4_STRUCT;

// **** D18F1xD8 Register Definition ****
// Address
#define D18F1xD8_ADDRESS                                        0xd8

// Type
#define D18F1xD8_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xD8_RE_OFFSET                                      0
#define D18F1xD8_RE_WIDTH                                       1
#define D18F1xD8_RE_MASK                                        0x1
#define D18F1xD8_WE_OFFSET                                      1
#define D18F1xD8_WE_WIDTH                                       1
#define D18F1xD8_WE_MASK                                        0x2
#define D18F1xD8_Reserved_3_2_OFFSET                            2
#define D18F1xD8_Reserved_3_2_WIDTH                             2
#define D18F1xD8_Reserved_3_2_MASK                              0xc
#define D18F1xD8_VE_OFFSET                                      4
#define D18F1xD8_VE_WIDTH                                       1
#define D18F1xD8_VE_MASK                                        0x10
#define D18F1xD8_IE_OFFSET                                      5
#define D18F1xD8_IE_WIDTH                                       1
#define D18F1xD8_IE_MASK                                        0x20
#define D18F1xD8_Reserved_11_6_OFFSET                           6
#define D18F1xD8_Reserved_11_6_WIDTH                            6
#define D18F1xD8_Reserved_11_6_MASK                             0xfc0
#define D18F1xD8_IOBase_24_12__OFFSET                           12
#define D18F1xD8_IOBase_24_12__WIDTH                            13
#define D18F1xD8_IOBase_24_12__MASK                             0x1fff000
#define D18F1xD8_Reserved_31_25_OFFSET                          25
#define D18F1xD8_Reserved_31_25_WIDTH                           7
#define D18F1xD8_Reserved_31_25_MASK                            0xfe000000

/// D18F1xD8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                       VE:1 ; ///<
    UINT32                                                       IE:1 ; ///<
    UINT32                                            Reserved_11_6:6 ; ///<
    UINT32                                            IOBase_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xD8_STRUCT;

// **** D18F1xDC Register Definition ****
// Address
#define D18F1xDC_ADDRESS                                        0xdc

// Type
#define D18F1xDC_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xDC_DstNode_OFFSET                                 0
#define D18F1xDC_DstNode_WIDTH                                  3
#define D18F1xDC_DstNode_MASK                                   0x7
#define D18F1xDC_Reserved_3_3_OFFSET                            3
#define D18F1xDC_Reserved_3_3_WIDTH                             1
#define D18F1xDC_Reserved_3_3_MASK                              0x8
#define D18F1xDC_DstLink_OFFSET                                 4
#define D18F1xDC_DstLink_WIDTH                                  2
#define D18F1xDC_DstLink_MASK                                   0x30
#define D18F1xDC_DstSubLink_OFFSET                              6
#define D18F1xDC_DstSubLink_WIDTH                               1
#define D18F1xDC_DstSubLink_MASK                                0x40
#define D18F1xDC_Reserved_11_7_OFFSET                           7
#define D18F1xDC_Reserved_11_7_WIDTH                            5
#define D18F1xDC_Reserved_11_7_MASK                             0xf80
#define D18F1xDC_IOLimit_24_12__OFFSET                          12
#define D18F1xDC_IOLimit_24_12__WIDTH                           13
#define D18F1xDC_IOLimit_24_12__MASK                            0x1fff000
#define D18F1xDC_Reserved_31_25_OFFSET                          25
#define D18F1xDC_Reserved_31_25_WIDTH                           7
#define D18F1xDC_Reserved_31_25_MASK                            0xfe000000

/// D18F1xDC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                           IOLimit_24_12_:13; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xDC_STRUCT;

// **** D18F1xE0 Register Definition ****
// Address
#define D18F1xE0_ADDRESS                                        0xe0

// Type
#define D18F1xE0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xE0_RE_OFFSET                                      0
#define D18F1xE0_RE_WIDTH                                       1
#define D18F1xE0_RE_MASK                                        0x1
#define D18F1xE0_WE_OFFSET                                      1
#define D18F1xE0_WE_WIDTH                                       1
#define D18F1xE0_WE_MASK                                        0x2
#define D18F1xE0_DevCmpEn_OFFSET                                2
#define D18F1xE0_DevCmpEn_WIDTH                                 1
#define D18F1xE0_DevCmpEn_MASK                                  0x4
#define D18F1xE0_Reserved_15_3_OFFSET                           3
#define D18F1xE0_Reserved_15_3_WIDTH                            13
#define D18F1xE0_Reserved_15_3_MASK                             0xfff8
#define D18F1xE0_BusNumBase_7_0__OFFSET                         16
#define D18F1xE0_BusNumBase_7_0__WIDTH                          8
#define D18F1xE0_BusNumBase_7_0__MASK                           0xff0000
#define D18F1xE0_BusNumLimit_7_0__OFFSET                        24
#define D18F1xE0_BusNumLimit_7_0__WIDTH                         8
#define D18F1xE0_BusNumLimit_7_0__MASK                          0xff000000

/// D18F1xE0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                                 DevCmpEn:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                          BusNumBase_7_0_:8 ; ///<
    UINT32                                         BusNumLimit_7_0_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xE0_STRUCT;

// **** D18F1xE4 Register Definition ****
// Address
#define D18F1xE4_ADDRESS                                        0xe4

// Type
#define D18F1xE4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xE4_RE_OFFSET                                      0
#define D18F1xE4_RE_WIDTH                                       1
#define D18F1xE4_RE_MASK                                        0x1
#define D18F1xE4_WE_OFFSET                                      1
#define D18F1xE4_WE_WIDTH                                       1
#define D18F1xE4_WE_MASK                                        0x2
#define D18F1xE4_DevCmpEn_OFFSET                                2
#define D18F1xE4_DevCmpEn_WIDTH                                 1
#define D18F1xE4_DevCmpEn_MASK                                  0x4
#define D18F1xE4_Reserved_15_3_OFFSET                           3
#define D18F1xE4_Reserved_15_3_WIDTH                            13
#define D18F1xE4_Reserved_15_3_MASK                             0xfff8
#define D18F1xE4_BusNumBase_7_0__OFFSET                         16
#define D18F1xE4_BusNumBase_7_0__WIDTH                          8
#define D18F1xE4_BusNumBase_7_0__MASK                           0xff0000
#define D18F1xE4_BusNumLimit_7_0__OFFSET                        24
#define D18F1xE4_BusNumLimit_7_0__WIDTH                         8
#define D18F1xE4_BusNumLimit_7_0__MASK                          0xff000000

/// D18F1xE4
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                                 DevCmpEn:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                          BusNumBase_7_0_:8 ; ///<
    UINT32                                         BusNumLimit_7_0_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xE4_STRUCT;

// **** D18F1xE8 Register Definition ****
// Address
#define D18F1xE8_ADDRESS                                        0xe8

// Type
#define D18F1xE8_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xE8_RE_OFFSET                                      0
#define D18F1xE8_RE_WIDTH                                       1
#define D18F1xE8_RE_MASK                                        0x1
#define D18F1xE8_WE_OFFSET                                      1
#define D18F1xE8_WE_WIDTH                                       1
#define D18F1xE8_WE_MASK                                        0x2
#define D18F1xE8_DevCmpEn_OFFSET                                2
#define D18F1xE8_DevCmpEn_WIDTH                                 1
#define D18F1xE8_DevCmpEn_MASK                                  0x4
#define D18F1xE8_Reserved_15_3_OFFSET                           3
#define D18F1xE8_Reserved_15_3_WIDTH                            13
#define D18F1xE8_Reserved_15_3_MASK                             0xfff8
#define D18F1xE8_BusNumBase_7_0__OFFSET                         16
#define D18F1xE8_BusNumBase_7_0__WIDTH                          8
#define D18F1xE8_BusNumBase_7_0__MASK                           0xff0000
#define D18F1xE8_BusNumLimit_7_0__OFFSET                        24
#define D18F1xE8_BusNumLimit_7_0__WIDTH                         8
#define D18F1xE8_BusNumLimit_7_0__MASK                          0xff000000

/// D18F1xE8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                                 DevCmpEn:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                          BusNumBase_7_0_:8 ; ///<
    UINT32                                         BusNumLimit_7_0_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xE8_STRUCT;

// **** D18F1xEC Register Definition ****
// Address
#define D18F1xEC_ADDRESS                                        0xec

// Type
#define D18F1xEC_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xEC_RE_OFFSET                                      0
#define D18F1xEC_RE_WIDTH                                       1
#define D18F1xEC_RE_MASK                                        0x1
#define D18F1xEC_WE_OFFSET                                      1
#define D18F1xEC_WE_WIDTH                                       1
#define D18F1xEC_WE_MASK                                        0x2
#define D18F1xEC_DevCmpEn_OFFSET                                2
#define D18F1xEC_DevCmpEn_WIDTH                                 1
#define D18F1xEC_DevCmpEn_MASK                                  0x4
#define D18F1xEC_Reserved_15_3_OFFSET                           3
#define D18F1xEC_Reserved_15_3_WIDTH                            13
#define D18F1xEC_Reserved_15_3_MASK                             0xfff8
#define D18F1xEC_BusNumBase_7_0__OFFSET                         16
#define D18F1xEC_BusNumBase_7_0__WIDTH                          8
#define D18F1xEC_BusNumBase_7_0__MASK                           0xff0000
#define D18F1xEC_BusNumLimit_7_0__OFFSET                        24
#define D18F1xEC_BusNumLimit_7_0__WIDTH                         8
#define D18F1xEC_BusNumLimit_7_0__MASK                          0xff000000

/// D18F1xEC
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                                 DevCmpEn:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                          BusNumBase_7_0_:8 ; ///<
    UINT32                                         BusNumLimit_7_0_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xEC_STRUCT;

// **** D18F1xF0 Register Definition ****
// Address
#define D18F1xF0_ADDRESS                                        0xf0

// Type
#define D18F1xF0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xF0_DramHoleValid_OFFSET                           0
#define D18F1xF0_DramHoleValid_WIDTH                            1
#define D18F1xF0_DramHoleValid_MASK                             0x1
#define D18F1xF0_DramMemHoistValid_OFFSET                       1
#define D18F1xF0_DramMemHoistValid_WIDTH                        1
#define D18F1xF0_DramMemHoistValid_MASK                         0x2
#define D18F1xF0_Reserved_2_2_OFFSET                            2
#define D18F1xF0_Reserved_2_2_WIDTH                             1
#define D18F1xF0_Reserved_2_2_MASK                              0x4
#define D18F1xF0_Reserved_6_3_OFFSET                            3
#define D18F1xF0_Reserved_6_3_WIDTH                             4
#define D18F1xF0_Reserved_6_3_MASK                              0x78
#define D18F1xF0_DramHoleOffset_31_23__OFFSET                   7
#define D18F1xF0_DramHoleOffset_31_23__WIDTH                    9
#define D18F1xF0_DramHoleOffset_31_23__MASK                     0xff80
#define D18F1xF0_Reserved_23_16_OFFSET                          16
#define D18F1xF0_Reserved_23_16_WIDTH                           8
#define D18F1xF0_Reserved_23_16_MASK                            0xff0000
#define D18F1xF0_DramHoleBase_31_24__OFFSET                     24
#define D18F1xF0_DramHoleBase_31_24__WIDTH                      8
#define D18F1xF0_DramHoleBase_31_24__MASK                       0xff000000

/// D18F1xF0
typedef union {
  struct {                                                              ///<
    UINT32                                            DramHoleValid:1 ; ///<
    UINT32                                        DramMemHoistValid:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             Reserved_6_3:4 ; ///<
    UINT32                                    DramHoleOffset_31_23_:9 ; ///<
    UINT32                                           Reserved_23_16:8 ; ///<
    UINT32                                      DramHoleBase_31_24_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xF0_STRUCT;

// **** D18F1xF4 Register Definition ****
// Address
#define D18F1xF4_ADDRESS                                        0xf4

// Type
#define D18F1xF4_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xF4_VE_OFFSET                                      0
#define D18F1xF4_VE_WIDTH                                       1
#define D18F1xF4_VE_MASK                                        0x1
#define D18F1xF4_NP_OFFSET                                      1
#define D18F1xF4_NP_WIDTH                                       1
#define D18F1xF4_NP_MASK                                        0x2
#define D18F1xF4_Reserved_2_2_OFFSET                            2
#define D18F1xF4_Reserved_2_2_WIDTH                             1
#define D18F1xF4_Reserved_2_2_MASK                              0x4
#define D18F1xF4_Lock_OFFSET                                    3
#define D18F1xF4_Lock_WIDTH                                     1
#define D18F1xF4_Lock_MASK                                      0x8
#define D18F1xF4_DstNode_OFFSET                                 4
#define D18F1xF4_DstNode_WIDTH                                  3
#define D18F1xF4_DstNode_MASK                                   0x70
#define D18F1xF4_Reserved_11_7_OFFSET                           7
#define D18F1xF4_Reserved_11_7_WIDTH                            5
#define D18F1xF4_Reserved_11_7_MASK                             0xf80
#define D18F1xF4_DstLink_OFFSET                                 12
#define D18F1xF4_DstLink_WIDTH                                  2
#define D18F1xF4_DstLink_MASK                                   0x3000
#define D18F1xF4_DstSubLink_OFFSET                              14
#define D18F1xF4_DstSubLink_WIDTH                               1
#define D18F1xF4_DstSubLink_MASK                                0x4000
#define D18F1xF4_Reserved_31_15_OFFSET                          15
#define D18F1xF4_Reserved_31_15_WIDTH                           17
#define D18F1xF4_Reserved_31_15_MASK                            0xffff8000

/// D18F1xF4
typedef union {
  struct {                                                              ///<
    UINT32                                                       VE:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xF4_STRUCT;

// **** D18F1x10C Register Definition ****
// Address
#define D18F1x10C_ADDRESS                                       0x10c

// Type
#define D18F1x10C_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x10C_DctCfgSel_OFFSET                              0
#define D18F1x10C_DctCfgSel_WIDTH                               1
#define D18F1x10C_DctCfgSel_MASK                                0x1
#define D18F1x10C_Reserved_2_1_OFFSET                           1
#define D18F1x10C_Reserved_2_1_WIDTH                            2
#define D18F1x10C_Reserved_2_1_MASK                             0x6
#define D18F1x10C_MemPsSel_OFFSET                               3
#define D18F1x10C_MemPsSel_WIDTH                                1
#define D18F1x10C_MemPsSel_MASK                                 0x8
#define D18F1x10C_NbPsSel_OFFSET                                4
#define D18F1x10C_NbPsSel_WIDTH                                 2
#define D18F1x10C_NbPsSel_MASK                                  0x30
#define D18F1x10C_Unused_31_6_OFFSET                            6
#define D18F1x10C_Unused_31_6_WIDTH                             26
#define D18F1x10C_Unused_31_6_MASK                              0xffffffc0

/// D18F1x10C
typedef union {
  struct {                                                              ///<
    UINT32                                                DctCfgSel:1 ; ///<
    UINT32                                             Reserved_2_1:2 ; ///<
    UINT32                                                 MemPsSel:1 ; ///<
    UINT32                                                  NbPsSel:2 ; ///<
    UINT32                                              Unused_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x10C_STRUCT;

// **** D18F1x120 Register Definition ****
// Address
#define D18F1x120_ADDRESS                                       0x120

// Type
#define D18F1x120_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x120_DramBaseAddr_47_27__OFFSET                    0
#define D18F1x120_DramBaseAddr_47_27__WIDTH                     21
#define D18F1x120_DramBaseAddr_47_27__MASK                      0x1fffff
#define D18F1x120_Reserved_31_21_OFFSET                         21
#define D18F1x120_Reserved_31_21_WIDTH                          11
#define D18F1x120_Reserved_31_21_MASK                           0xffe00000

/// D18F1x120
typedef union {
  struct {                                                              ///<
    UINT32                                      DramBaseAddr_47_27_:21; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x120_STRUCT;

// **** D18F1x124 Register Definition ****
// Address
#define D18F1x124_ADDRESS                                       0x124

// Type
#define D18F1x124_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x124_DramLimitAddr_47_27__OFFSET                   0
#define D18F1x124_DramLimitAddr_47_27__WIDTH                    21
#define D18F1x124_DramLimitAddr_47_27__MASK                     0x1fffff
#define D18F1x124_Reserved_31_21_OFFSET                         21
#define D18F1x124_Reserved_31_21_WIDTH                          11
#define D18F1x124_Reserved_31_21_MASK                           0xffe00000

/// D18F1x124
typedef union {
  struct {                                                              ///<
    UINT32                                     DramLimitAddr_47_27_:21; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x124_STRUCT;

// **** D18F1x140 Register Definition ****
// Address
#define D18F1x140_ADDRESS                                       0x140

// Type
#define D18F1x140_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x140_DramBase_47_40__OFFSET                        0
#define D18F1x140_DramBase_47_40__WIDTH                         8
#define D18F1x140_DramBase_47_40__MASK                          0xff
#define D18F1x140_Reserved_31_8_OFFSET                          8
#define D18F1x140_Reserved_31_8_WIDTH                           24
#define D18F1x140_Reserved_31_8_MASK                            0xffffff00

/// D18F1x140
typedef union {
  struct {                                                              ///<
    UINT32                                          DramBase_47_40_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x140_STRUCT;

// **** D18F1x144 Register Definition ****
// Address
#define D18F1x144_ADDRESS                                       0x144

// Type
#define D18F1x144_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x144_DramLimit_47_40__OFFSET                       0
#define D18F1x144_DramLimit_47_40__WIDTH                        8
#define D18F1x144_DramLimit_47_40__MASK                         0xff
#define D18F1x144_Reserved_31_8_OFFSET                          8
#define D18F1x144_Reserved_31_8_WIDTH                           24
#define D18F1x144_Reserved_31_8_MASK                            0xffffff00

/// D18F1x144
typedef union {
  struct {                                                              ///<
    UINT32                                         DramLimit_47_40_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x144_STRUCT;

// **** D18F1x180 Register Definition ****
// Address
#define D18F1x180_ADDRESS                                       0x180

// Type
#define D18F1x180_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x180_MMIOBase_47_40__OFFSET                        0
#define D18F1x180_MMIOBase_47_40__WIDTH                         8
#define D18F1x180_MMIOBase_47_40__MASK                          0xff
#define D18F1x180_Reserved_15_8_OFFSET                          8
#define D18F1x180_Reserved_15_8_WIDTH                           8
#define D18F1x180_Reserved_15_8_MASK                            0xff00
#define D18F1x180_MMIOLimit_47_40__OFFSET                       16
#define D18F1x180_MMIOLimit_47_40__WIDTH                        8
#define D18F1x180_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x180_Reserved_31_24_OFFSET                         24
#define D18F1x180_Reserved_31_24_WIDTH                          8
#define D18F1x180_Reserved_31_24_MASK                           0xff000000

/// D18F1x180
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x180_STRUCT;

// **** D18F1x184 Register Definition ****
// Address
#define D18F1x184_ADDRESS                                       0x184

// Type
#define D18F1x184_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x184_MMIOBase_47_40__OFFSET                        0
#define D18F1x184_MMIOBase_47_40__WIDTH                         8
#define D18F1x184_MMIOBase_47_40__MASK                          0xff
#define D18F1x184_Reserved_15_8_OFFSET                          8
#define D18F1x184_Reserved_15_8_WIDTH                           8
#define D18F1x184_Reserved_15_8_MASK                            0xff00
#define D18F1x184_MMIOLimit_47_40__OFFSET                       16
#define D18F1x184_MMIOLimit_47_40__WIDTH                        8
#define D18F1x184_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x184_Reserved_31_24_OFFSET                         24
#define D18F1x184_Reserved_31_24_WIDTH                          8
#define D18F1x184_Reserved_31_24_MASK                           0xff000000

/// D18F1x184
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x184_STRUCT;

// **** D18F1x188 Register Definition ****
// Address
#define D18F1x188_ADDRESS                                       0x188

// Type
#define D18F1x188_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x188_MMIOBase_47_40__OFFSET                        0
#define D18F1x188_MMIOBase_47_40__WIDTH                         8
#define D18F1x188_MMIOBase_47_40__MASK                          0xff
#define D18F1x188_Reserved_15_8_OFFSET                          8
#define D18F1x188_Reserved_15_8_WIDTH                           8
#define D18F1x188_Reserved_15_8_MASK                            0xff00
#define D18F1x188_MMIOLimit_47_40__OFFSET                       16
#define D18F1x188_MMIOLimit_47_40__WIDTH                        8
#define D18F1x188_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x188_Reserved_31_24_OFFSET                         24
#define D18F1x188_Reserved_31_24_WIDTH                          8
#define D18F1x188_Reserved_31_24_MASK                           0xff000000

/// D18F1x188
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x188_STRUCT;

// **** D18F1x18C Register Definition ****
// Address
#define D18F1x18C_ADDRESS                                       0x18c

// Type
#define D18F1x18C_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x18C_MMIOBase_47_40__OFFSET                        0
#define D18F1x18C_MMIOBase_47_40__WIDTH                         8
#define D18F1x18C_MMIOBase_47_40__MASK                          0xff
#define D18F1x18C_Reserved_15_8_OFFSET                          8
#define D18F1x18C_Reserved_15_8_WIDTH                           8
#define D18F1x18C_Reserved_15_8_MASK                            0xff00
#define D18F1x18C_MMIOLimit_47_40__OFFSET                       16
#define D18F1x18C_MMIOLimit_47_40__WIDTH                        8
#define D18F1x18C_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x18C_Reserved_31_24_OFFSET                         24
#define D18F1x18C_Reserved_31_24_WIDTH                          8
#define D18F1x18C_Reserved_31_24_MASK                           0xff000000

/// D18F1x18C
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x18C_STRUCT;

// **** D18F1x190 Register Definition ****
// Address
#define D18F1x190_ADDRESS                                       0x190

// Type
#define D18F1x190_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x190_MMIOBase_47_40__OFFSET                        0
#define D18F1x190_MMIOBase_47_40__WIDTH                         8
#define D18F1x190_MMIOBase_47_40__MASK                          0xff
#define D18F1x190_Reserved_15_8_OFFSET                          8
#define D18F1x190_Reserved_15_8_WIDTH                           8
#define D18F1x190_Reserved_15_8_MASK                            0xff00
#define D18F1x190_MMIOLimit_47_40__OFFSET                       16
#define D18F1x190_MMIOLimit_47_40__WIDTH                        8
#define D18F1x190_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x190_Reserved_31_24_OFFSET                         24
#define D18F1x190_Reserved_31_24_WIDTH                          8
#define D18F1x190_Reserved_31_24_MASK                           0xff000000

/// D18F1x190
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x190_STRUCT;

// **** D18F1x194 Register Definition ****
// Address
#define D18F1x194_ADDRESS                                       0x194

// Type
#define D18F1x194_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x194_MMIOBase_47_40__OFFSET                        0
#define D18F1x194_MMIOBase_47_40__WIDTH                         8
#define D18F1x194_MMIOBase_47_40__MASK                          0xff
#define D18F1x194_Reserved_15_8_OFFSET                          8
#define D18F1x194_Reserved_15_8_WIDTH                           8
#define D18F1x194_Reserved_15_8_MASK                            0xff00
#define D18F1x194_MMIOLimit_47_40__OFFSET                       16
#define D18F1x194_MMIOLimit_47_40__WIDTH                        8
#define D18F1x194_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x194_Reserved_31_24_OFFSET                         24
#define D18F1x194_Reserved_31_24_WIDTH                          8
#define D18F1x194_Reserved_31_24_MASK                           0xff000000

/// D18F1x194
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x194_STRUCT;

// **** D18F1x198 Register Definition ****
// Address
#define D18F1x198_ADDRESS                                       0x198

// Type
#define D18F1x198_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x198_MMIOBase_47_40__OFFSET                        0
#define D18F1x198_MMIOBase_47_40__WIDTH                         8
#define D18F1x198_MMIOBase_47_40__MASK                          0xff
#define D18F1x198_Reserved_15_8_OFFSET                          8
#define D18F1x198_Reserved_15_8_WIDTH                           8
#define D18F1x198_Reserved_15_8_MASK                            0xff00
#define D18F1x198_MMIOLimit_47_40__OFFSET                       16
#define D18F1x198_MMIOLimit_47_40__WIDTH                        8
#define D18F1x198_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x198_Reserved_31_24_OFFSET                         24
#define D18F1x198_Reserved_31_24_WIDTH                          8
#define D18F1x198_Reserved_31_24_MASK                           0xff000000

/// D18F1x198
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x198_STRUCT;

// **** D18F1x19C Register Definition ****
// Address
#define D18F1x19C_ADDRESS                                       0x19c

// Type
#define D18F1x19C_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x19C_MMIOBase_47_40__OFFSET                        0
#define D18F1x19C_MMIOBase_47_40__WIDTH                         8
#define D18F1x19C_MMIOBase_47_40__MASK                          0xff
#define D18F1x19C_Reserved_15_8_OFFSET                          8
#define D18F1x19C_Reserved_15_8_WIDTH                           8
#define D18F1x19C_Reserved_15_8_MASK                            0xff00
#define D18F1x19C_MMIOLimit_47_40__OFFSET                       16
#define D18F1x19C_MMIOLimit_47_40__WIDTH                        8
#define D18F1x19C_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x19C_Reserved_31_24_OFFSET                         24
#define D18F1x19C_Reserved_31_24_WIDTH                          8
#define D18F1x19C_Reserved_31_24_MASK                           0xff000000

/// D18F1x19C
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x19C_STRUCT;

// **** D18F1x1A0 Register Definition ****
// Address
#define D18F1x1A0_ADDRESS                                       0x1a0

// Type
#define D18F1x1A0_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1A0_RE_OFFSET                                     0
#define D18F1x1A0_RE_WIDTH                                      1
#define D18F1x1A0_RE_MASK                                       0x1
#define D18F1x1A0_WE_OFFSET                                     1
#define D18F1x1A0_WE_WIDTH                                      1
#define D18F1x1A0_WE_MASK                                       0x2
#define D18F1x1A0_Reserved_2_2_OFFSET                           2
#define D18F1x1A0_Reserved_2_2_WIDTH                            1
#define D18F1x1A0_Reserved_2_2_MASK                             0x4
#define D18F1x1A0_Lock_OFFSET                                   3
#define D18F1x1A0_Lock_WIDTH                                    1
#define D18F1x1A0_Lock_MASK                                     0x8
#define D18F1x1A0_Reserved_7_4_OFFSET                           4
#define D18F1x1A0_Reserved_7_4_WIDTH                            4
#define D18F1x1A0_Reserved_7_4_MASK                             0xf0
#define D18F1x1A0_MMIOBase_39_16__OFFSET                        8
#define D18F1x1A0_MMIOBase_39_16__WIDTH                         24
#define D18F1x1A0_MMIOBase_39_16__MASK                          0xffffff00

/// D18F1x1A0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1A0_STRUCT;

// **** D18F1x1A4 Register Definition ****
// Address
#define D18F1x1A4_ADDRESS                                       0x1a4

// Type
#define D18F1x1A4_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1A4_DstNode_OFFSET                                0
#define D18F1x1A4_DstNode_WIDTH                                 3
#define D18F1x1A4_DstNode_MASK                                  0x7
#define D18F1x1A4_Reserved_3_3_OFFSET                           3
#define D18F1x1A4_Reserved_3_3_WIDTH                            1
#define D18F1x1A4_Reserved_3_3_MASK                             0x8
#define D18F1x1A4_DstLink_OFFSET                                4
#define D18F1x1A4_DstLink_WIDTH                                 2
#define D18F1x1A4_DstLink_MASK                                  0x30
#define D18F1x1A4_DstSubLink_OFFSET                             6
#define D18F1x1A4_DstSubLink_WIDTH                              1
#define D18F1x1A4_DstSubLink_MASK                               0x40
#define D18F1x1A4_NP_OFFSET                                     7
#define D18F1x1A4_NP_WIDTH                                      1
#define D18F1x1A4_NP_MASK                                       0x80
#define D18F1x1A4_MMIOLimit_39_16__OFFSET                       8
#define D18F1x1A4_MMIOLimit_39_16__WIDTH                        24
#define D18F1x1A4_MMIOLimit_39_16__MASK                         0xffffff00

/// D18F1x1A4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1A4_STRUCT;

// **** D18F1x1A8 Register Definition ****
// Address
#define D18F1x1A8_ADDRESS                                       0x1a8

// Type
#define D18F1x1A8_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1A8_RE_OFFSET                                     0
#define D18F1x1A8_RE_WIDTH                                      1
#define D18F1x1A8_RE_MASK                                       0x1
#define D18F1x1A8_WE_OFFSET                                     1
#define D18F1x1A8_WE_WIDTH                                      1
#define D18F1x1A8_WE_MASK                                       0x2
#define D18F1x1A8_Reserved_2_2_OFFSET                           2
#define D18F1x1A8_Reserved_2_2_WIDTH                            1
#define D18F1x1A8_Reserved_2_2_MASK                             0x4
#define D18F1x1A8_Lock_OFFSET                                   3
#define D18F1x1A8_Lock_WIDTH                                    1
#define D18F1x1A8_Lock_MASK                                     0x8
#define D18F1x1A8_Reserved_7_4_OFFSET                           4
#define D18F1x1A8_Reserved_7_4_WIDTH                            4
#define D18F1x1A8_Reserved_7_4_MASK                             0xf0
#define D18F1x1A8_MMIOBase_39_16__OFFSET                        8
#define D18F1x1A8_MMIOBase_39_16__WIDTH                         24
#define D18F1x1A8_MMIOBase_39_16__MASK                          0xffffff00

/// D18F1x1A8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1A8_STRUCT;

// **** D18F1x1AC Register Definition ****
// Address
#define D18F1x1AC_ADDRESS                                       0x1ac

// Type
#define D18F1x1AC_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1AC_DstNode_OFFSET                                0
#define D18F1x1AC_DstNode_WIDTH                                 3
#define D18F1x1AC_DstNode_MASK                                  0x7
#define D18F1x1AC_Reserved_3_3_OFFSET                           3
#define D18F1x1AC_Reserved_3_3_WIDTH                            1
#define D18F1x1AC_Reserved_3_3_MASK                             0x8
#define D18F1x1AC_DstLink_OFFSET                                4
#define D18F1x1AC_DstLink_WIDTH                                 2
#define D18F1x1AC_DstLink_MASK                                  0x30
#define D18F1x1AC_DstSubLink_OFFSET                             6
#define D18F1x1AC_DstSubLink_WIDTH                              1
#define D18F1x1AC_DstSubLink_MASK                               0x40
#define D18F1x1AC_NP_OFFSET                                     7
#define D18F1x1AC_NP_WIDTH                                      1
#define D18F1x1AC_NP_MASK                                       0x80
#define D18F1x1AC_MMIOLimit_39_16__OFFSET                       8
#define D18F1x1AC_MMIOLimit_39_16__WIDTH                        24
#define D18F1x1AC_MMIOLimit_39_16__MASK                         0xffffff00

/// D18F1x1AC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1AC_STRUCT;

// **** D18F1x1B0 Register Definition ****
// Address
#define D18F1x1B0_ADDRESS                                       0x1b0

// Type
#define D18F1x1B0_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1B0_RE_OFFSET                                     0
#define D18F1x1B0_RE_WIDTH                                      1
#define D18F1x1B0_RE_MASK                                       0x1
#define D18F1x1B0_WE_OFFSET                                     1
#define D18F1x1B0_WE_WIDTH                                      1
#define D18F1x1B0_WE_MASK                                       0x2
#define D18F1x1B0_Reserved_2_2_OFFSET                           2
#define D18F1x1B0_Reserved_2_2_WIDTH                            1
#define D18F1x1B0_Reserved_2_2_MASK                             0x4
#define D18F1x1B0_Lock_OFFSET                                   3
#define D18F1x1B0_Lock_WIDTH                                    1
#define D18F1x1B0_Lock_MASK                                     0x8
#define D18F1x1B0_Reserved_7_4_OFFSET                           4
#define D18F1x1B0_Reserved_7_4_WIDTH                            4
#define D18F1x1B0_Reserved_7_4_MASK                             0xf0
#define D18F1x1B0_MMIOBase_39_16__OFFSET                        8
#define D18F1x1B0_MMIOBase_39_16__WIDTH                         24
#define D18F1x1B0_MMIOBase_39_16__MASK                          0xffffff00

/// D18F1x1B0
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1B0_STRUCT;

// **** D18F1x1B4 Register Definition ****
// Address
#define D18F1x1B4_ADDRESS                                       0x1b4

// Type
#define D18F1x1B4_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1B4_DstNode_OFFSET                                0
#define D18F1x1B4_DstNode_WIDTH                                 3
#define D18F1x1B4_DstNode_MASK                                  0x7
#define D18F1x1B4_Reserved_3_3_OFFSET                           3
#define D18F1x1B4_Reserved_3_3_WIDTH                            1
#define D18F1x1B4_Reserved_3_3_MASK                             0x8
#define D18F1x1B4_DstLink_OFFSET                                4
#define D18F1x1B4_DstLink_WIDTH                                 2
#define D18F1x1B4_DstLink_MASK                                  0x30
#define D18F1x1B4_DstSubLink_OFFSET                             6
#define D18F1x1B4_DstSubLink_WIDTH                              1
#define D18F1x1B4_DstSubLink_MASK                               0x40
#define D18F1x1B4_NP_OFFSET                                     7
#define D18F1x1B4_NP_WIDTH                                      1
#define D18F1x1B4_NP_MASK                                       0x80
#define D18F1x1B4_MMIOLimit_39_16__OFFSET                       8
#define D18F1x1B4_MMIOLimit_39_16__WIDTH                        24
#define D18F1x1B4_MMIOLimit_39_16__MASK                         0xffffff00

/// D18F1x1B4
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1B4_STRUCT;

// **** D18F1x1B8 Register Definition ****
// Address
#define D18F1x1B8_ADDRESS                                       0x1b8

// Type
#define D18F1x1B8_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1B8_RE_OFFSET                                     0
#define D18F1x1B8_RE_WIDTH                                      1
#define D18F1x1B8_RE_MASK                                       0x1
#define D18F1x1B8_WE_OFFSET                                     1
#define D18F1x1B8_WE_WIDTH                                      1
#define D18F1x1B8_WE_MASK                                       0x2
#define D18F1x1B8_Reserved_2_2_OFFSET                           2
#define D18F1x1B8_Reserved_2_2_WIDTH                            1
#define D18F1x1B8_Reserved_2_2_MASK                             0x4
#define D18F1x1B8_Lock_OFFSET                                   3
#define D18F1x1B8_Lock_WIDTH                                    1
#define D18F1x1B8_Lock_MASK                                     0x8
#define D18F1x1B8_Reserved_7_4_OFFSET                           4
#define D18F1x1B8_Reserved_7_4_WIDTH                            4
#define D18F1x1B8_Reserved_7_4_MASK                             0xf0
#define D18F1x1B8_MMIOBase_39_16__OFFSET                        8
#define D18F1x1B8_MMIOBase_39_16__WIDTH                         24
#define D18F1x1B8_MMIOBase_39_16__MASK                          0xffffff00

/// D18F1x1B8
typedef union {
  struct {                                                              ///<
    UINT32                                                       RE:1 ; ///<
    UINT32                                                       WE:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                     Lock:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                          MMIOBase_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1B8_STRUCT;

// **** D18F1x1BC Register Definition ****
// Address
#define D18F1x1BC_ADDRESS                                       0x1bc

// Type
#define D18F1x1BC_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1BC_DstNode_OFFSET                                0
#define D18F1x1BC_DstNode_WIDTH                                 3
#define D18F1x1BC_DstNode_MASK                                  0x7
#define D18F1x1BC_Reserved_3_3_OFFSET                           3
#define D18F1x1BC_Reserved_3_3_WIDTH                            1
#define D18F1x1BC_Reserved_3_3_MASK                             0x8
#define D18F1x1BC_DstLink_OFFSET                                4
#define D18F1x1BC_DstLink_WIDTH                                 2
#define D18F1x1BC_DstLink_MASK                                  0x30
#define D18F1x1BC_DstSubLink_OFFSET                             6
#define D18F1x1BC_DstSubLink_WIDTH                              1
#define D18F1x1BC_DstSubLink_MASK                               0x40
#define D18F1x1BC_NP_OFFSET                                     7
#define D18F1x1BC_NP_WIDTH                                      1
#define D18F1x1BC_NP_MASK                                       0x80
#define D18F1x1BC_MMIOLimit_39_16__OFFSET                       8
#define D18F1x1BC_MMIOLimit_39_16__WIDTH                        24
#define D18F1x1BC_MMIOLimit_39_16__MASK                         0xffffff00

/// D18F1x1BC
typedef union {
  struct {                                                              ///<
    UINT32                                                  DstNode:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                  DstLink:2 ; ///<
    UINT32                                               DstSubLink:1 ; ///<
    UINT32                                                       NP:1 ; ///<
    UINT32                                         MMIOLimit_39_16_:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1BC_STRUCT;

// **** D18F1x1C0 Register Definition ****
// Address
#define D18F1x1C0_ADDRESS                                       0x1c0

// Type
#define D18F1x1C0_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1C0_MMIOBase_47_40__OFFSET                        0
#define D18F1x1C0_MMIOBase_47_40__WIDTH                         8
#define D18F1x1C0_MMIOBase_47_40__MASK                          0xff
#define D18F1x1C0_Reserved_15_8_OFFSET                          8
#define D18F1x1C0_Reserved_15_8_WIDTH                           8
#define D18F1x1C0_Reserved_15_8_MASK                            0xff00
#define D18F1x1C0_MMIOLimit_47_40__OFFSET                       16
#define D18F1x1C0_MMIOLimit_47_40__WIDTH                        8
#define D18F1x1C0_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x1C0_Reserved_31_24_OFFSET                         24
#define D18F1x1C0_Reserved_31_24_WIDTH                          8
#define D18F1x1C0_Reserved_31_24_MASK                           0xff000000

/// D18F1x1C0
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1C0_STRUCT;

// **** D18F1x1C4 Register Definition ****
// Address
#define D18F1x1C4_ADDRESS                                       0x1c4

// Type
#define D18F1x1C4_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1C4_MMIOBase_47_40__OFFSET                        0
#define D18F1x1C4_MMIOBase_47_40__WIDTH                         8
#define D18F1x1C4_MMIOBase_47_40__MASK                          0xff
#define D18F1x1C4_Reserved_15_8_OFFSET                          8
#define D18F1x1C4_Reserved_15_8_WIDTH                           8
#define D18F1x1C4_Reserved_15_8_MASK                            0xff00
#define D18F1x1C4_MMIOLimit_47_40__OFFSET                       16
#define D18F1x1C4_MMIOLimit_47_40__WIDTH                        8
#define D18F1x1C4_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x1C4_Reserved_31_24_OFFSET                         24
#define D18F1x1C4_Reserved_31_24_WIDTH                          8
#define D18F1x1C4_Reserved_31_24_MASK                           0xff000000

/// D18F1x1C4
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1C4_STRUCT;

// **** D18F1x1C8 Register Definition ****
// Address
#define D18F1x1C8_ADDRESS                                       0x1c8

// Type
#define D18F1x1C8_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1C8_MMIOBase_47_40__OFFSET                        0
#define D18F1x1C8_MMIOBase_47_40__WIDTH                         8
#define D18F1x1C8_MMIOBase_47_40__MASK                          0xff
#define D18F1x1C8_Reserved_15_8_OFFSET                          8
#define D18F1x1C8_Reserved_15_8_WIDTH                           8
#define D18F1x1C8_Reserved_15_8_MASK                            0xff00
#define D18F1x1C8_MMIOLimit_47_40__OFFSET                       16
#define D18F1x1C8_MMIOLimit_47_40__WIDTH                        8
#define D18F1x1C8_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x1C8_Reserved_31_24_OFFSET                         24
#define D18F1x1C8_Reserved_31_24_WIDTH                          8
#define D18F1x1C8_Reserved_31_24_MASK                           0xff000000

/// D18F1x1C8
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1C8_STRUCT;

// **** D18F1x1CC Register Definition ****
// Address
#define D18F1x1CC_ADDRESS                                       0x1cc

// Type
#define D18F1x1CC_TYPE                                          TYPE_D18F1
// Field Data
#define D18F1x1CC_MMIOBase_47_40__OFFSET                        0
#define D18F1x1CC_MMIOBase_47_40__WIDTH                         8
#define D18F1x1CC_MMIOBase_47_40__MASK                          0xff
#define D18F1x1CC_Reserved_15_8_OFFSET                          8
#define D18F1x1CC_Reserved_15_8_WIDTH                           8
#define D18F1x1CC_Reserved_15_8_MASK                            0xff00
#define D18F1x1CC_MMIOLimit_47_40__OFFSET                       16
#define D18F1x1CC_MMIOLimit_47_40__WIDTH                        8
#define D18F1x1CC_MMIOLimit_47_40__MASK                         0xff0000
#define D18F1x1CC_Reserved_31_24_OFFSET                         24
#define D18F1x1CC_Reserved_31_24_WIDTH                          8
#define D18F1x1CC_Reserved_31_24_MASK                           0xff000000

/// D18F1x1CC
typedef union {
  struct {                                                              ///<
    UINT32                                          MMIOBase_47_40_:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                         MMIOLimit_47_40_:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1x1CC_STRUCT;

// **** D18F2x00 Register Definition ****
// Address
#define D18F2x00_ADDRESS                                        0x0

// Type
#define D18F2x00_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x00_VendorID_OFFSET                                0
#define D18F2x00_VendorID_WIDTH                                 16
#define D18F2x00_VendorID_MASK                                  0xffff
#define D18F2x00_DeviceID_OFFSET                                16
#define D18F2x00_DeviceID_WIDTH                                 16
#define D18F2x00_DeviceID_MASK                                  0xffff0000

/// D18F2x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x00_STRUCT;

// **** D18F2x08 Register Definition ****
// Address
#define D18F2x08_ADDRESS                                        0x8

// Type
#define D18F2x08_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x08_RevID_OFFSET                                   0
#define D18F2x08_RevID_WIDTH                                    8
#define D18F2x08_RevID_MASK                                     0xff
#define D18F2x08_ClassCode_OFFSET                               8
#define D18F2x08_ClassCode_WIDTH                                24
#define D18F2x08_ClassCode_MASK                                 0xffffff00

/// D18F2x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x08_STRUCT;

// **** D18F2x0C Register Definition ****
// Address
#define D18F2x0C_ADDRESS                                        0xc

// Type
#define D18F2x0C_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x0C_HeaderTypeReg_OFFSET                           0
#define D18F2x0C_HeaderTypeReg_WIDTH                            32
#define D18F2x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F2x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0C_STRUCT;

// **** D18F2x40_dct1 Register Definition ****
// Address
#define D18F2x40_dct1_ADDRESS                                   0x40

// Type
#define D18F2x40_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x40_dct1_CSEnable_OFFSET                           0
#define D18F2x40_dct1_CSEnable_WIDTH                            1
#define D18F2x40_dct1_CSEnable_MASK                             0x1
#define D18F2x40_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x40_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x40_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x40_dct1_TestFail_OFFSET                           2
#define D18F2x40_dct1_TestFail_WIDTH                            1
#define D18F2x40_dct1_TestFail_MASK                             0x4
#define D18F2x40_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x40_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x40_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x40_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x40_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x40_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x40_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x40_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x40_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x40_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x40_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x40_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x40_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x40_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x40_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x40_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x40_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x40_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x40_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x40_dct1_STRUCT;

// **** D18F2x40_dct0 Register Definition ****
// Address
#define D18F2x40_dct0_ADDRESS                                   0x40

// Type
#define D18F2x40_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x40_dct0_CSEnable_OFFSET                           0
#define D18F2x40_dct0_CSEnable_WIDTH                            1
#define D18F2x40_dct0_CSEnable_MASK                             0x1
#define D18F2x40_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x40_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x40_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x40_dct0_TestFail_OFFSET                           2
#define D18F2x40_dct0_TestFail_WIDTH                            1
#define D18F2x40_dct0_TestFail_MASK                             0x4
#define D18F2x40_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x40_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x40_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x40_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x40_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x40_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x40_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x40_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x40_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x40_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x40_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x40_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x40_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x40_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x40_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x40_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x40_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x40_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x40_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x40_dct0_STRUCT;

// **** D18F2x44_dct1 Register Definition ****
// Address
#define D18F2x44_dct1_ADDRESS                                   0x44

// Type
#define D18F2x44_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x44_dct1_CSEnable_OFFSET                           0
#define D18F2x44_dct1_CSEnable_WIDTH                            1
#define D18F2x44_dct1_CSEnable_MASK                             0x1
#define D18F2x44_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x44_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x44_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x44_dct1_TestFail_OFFSET                           2
#define D18F2x44_dct1_TestFail_WIDTH                            1
#define D18F2x44_dct1_TestFail_MASK                             0x4
#define D18F2x44_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x44_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x44_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x44_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x44_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x44_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x44_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x44_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x44_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x44_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x44_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x44_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x44_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x44_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x44_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x44_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x44_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x44_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x44_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x44_dct1_STRUCT;

// **** D18F2x44_dct0 Register Definition ****
// Address
#define D18F2x44_dct0_ADDRESS                                   0x44

// Type
#define D18F2x44_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x44_dct0_CSEnable_OFFSET                           0
#define D18F2x44_dct0_CSEnable_WIDTH                            1
#define D18F2x44_dct0_CSEnable_MASK                             0x1
#define D18F2x44_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x44_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x44_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x44_dct0_TestFail_OFFSET                           2
#define D18F2x44_dct0_TestFail_WIDTH                            1
#define D18F2x44_dct0_TestFail_MASK                             0x4
#define D18F2x44_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x44_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x44_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x44_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x44_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x44_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x44_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x44_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x44_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x44_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x44_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x44_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x44_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x44_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x44_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x44_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x44_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x44_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x44_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x44_dct0_STRUCT;

// **** D18F2x48_dct1 Register Definition ****
// Address
#define D18F2x48_dct1_ADDRESS                                   0x48

// Type
#define D18F2x48_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x48_dct1_CSEnable_OFFSET                           0
#define D18F2x48_dct1_CSEnable_WIDTH                            1
#define D18F2x48_dct1_CSEnable_MASK                             0x1
#define D18F2x48_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x48_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x48_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x48_dct1_TestFail_OFFSET                           2
#define D18F2x48_dct1_TestFail_WIDTH                            1
#define D18F2x48_dct1_TestFail_MASK                             0x4
#define D18F2x48_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x48_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x48_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x48_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x48_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x48_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x48_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x48_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x48_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x48_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x48_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x48_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x48_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x48_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x48_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x48_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x48_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x48_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x48_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x48_dct1_STRUCT;

// **** D18F2x48_dct0 Register Definition ****
// Address
#define D18F2x48_dct0_ADDRESS                                   0x48

// Type
#define D18F2x48_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x48_dct0_CSEnable_OFFSET                           0
#define D18F2x48_dct0_CSEnable_WIDTH                            1
#define D18F2x48_dct0_CSEnable_MASK                             0x1
#define D18F2x48_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x48_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x48_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x48_dct0_TestFail_OFFSET                           2
#define D18F2x48_dct0_TestFail_WIDTH                            1
#define D18F2x48_dct0_TestFail_MASK                             0x4
#define D18F2x48_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x48_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x48_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x48_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x48_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x48_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x48_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x48_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x48_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x48_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x48_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x48_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x48_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x48_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x48_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x48_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x48_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x48_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x48_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x48_dct0_STRUCT;

// **** D18F2x4C_dct1 Register Definition ****
// Address
#define D18F2x4C_dct1_ADDRESS                                   0x4c

// Type
#define D18F2x4C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x4C_dct1_CSEnable_OFFSET                           0
#define D18F2x4C_dct1_CSEnable_WIDTH                            1
#define D18F2x4C_dct1_CSEnable_MASK                             0x1
#define D18F2x4C_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x4C_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x4C_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x4C_dct1_TestFail_OFFSET                           2
#define D18F2x4C_dct1_TestFail_WIDTH                            1
#define D18F2x4C_dct1_TestFail_MASK                             0x4
#define D18F2x4C_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x4C_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x4C_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x4C_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x4C_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x4C_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x4C_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x4C_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x4C_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x4C_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x4C_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x4C_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x4C_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x4C_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x4C_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x4C_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x4C_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x4C_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x4C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x4C_dct1_STRUCT;

// **** D18F2x4C_dct0 Register Definition ****
// Address
#define D18F2x4C_dct0_ADDRESS                                   0x4c

// Type
#define D18F2x4C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x4C_dct0_CSEnable_OFFSET                           0
#define D18F2x4C_dct0_CSEnable_WIDTH                            1
#define D18F2x4C_dct0_CSEnable_MASK                             0x1
#define D18F2x4C_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x4C_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x4C_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x4C_dct0_TestFail_OFFSET                           2
#define D18F2x4C_dct0_TestFail_WIDTH                            1
#define D18F2x4C_dct0_TestFail_MASK                             0x4
#define D18F2x4C_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x4C_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x4C_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x4C_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x4C_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x4C_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x4C_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x4C_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x4C_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x4C_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x4C_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x4C_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x4C_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x4C_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x4C_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x4C_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x4C_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x4C_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x4C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x4C_dct0_STRUCT;

// **** D18F2x50_dct1 Register Definition ****
// Address
#define D18F2x50_dct1_ADDRESS                                   0x50

// Type
#define D18F2x50_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x50_dct1_CSEnable_OFFSET                           0
#define D18F2x50_dct1_CSEnable_WIDTH                            1
#define D18F2x50_dct1_CSEnable_MASK                             0x1
#define D18F2x50_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x50_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x50_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x50_dct1_TestFail_OFFSET                           2
#define D18F2x50_dct1_TestFail_WIDTH                            1
#define D18F2x50_dct1_TestFail_MASK                             0x4
#define D18F2x50_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x50_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x50_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x50_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x50_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x50_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x50_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x50_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x50_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x50_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x50_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x50_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x50_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x50_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x50_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x50_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x50_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x50_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x50_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x50_dct1_STRUCT;

// **** D18F2x50_dct0 Register Definition ****
// Address
#define D18F2x50_dct0_ADDRESS                                   0x50

// Type
#define D18F2x50_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x50_dct0_CSEnable_OFFSET                           0
#define D18F2x50_dct0_CSEnable_WIDTH                            1
#define D18F2x50_dct0_CSEnable_MASK                             0x1
#define D18F2x50_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x50_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x50_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x50_dct0_TestFail_OFFSET                           2
#define D18F2x50_dct0_TestFail_WIDTH                            1
#define D18F2x50_dct0_TestFail_MASK                             0x4
#define D18F2x50_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x50_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x50_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x50_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x50_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x50_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x50_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x50_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x50_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x50_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x50_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x50_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x50_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x50_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x50_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x50_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x50_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x50_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x50_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x50_dct0_STRUCT;

// **** D18F2x54_dct0 Register Definition ****
// Address
#define D18F2x54_dct0_ADDRESS                                   0x54

// Type
#define D18F2x54_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x54_dct0_CSEnable_OFFSET                           0
#define D18F2x54_dct0_CSEnable_WIDTH                            1
#define D18F2x54_dct0_CSEnable_MASK                             0x1
#define D18F2x54_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x54_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x54_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x54_dct0_TestFail_OFFSET                           2
#define D18F2x54_dct0_TestFail_WIDTH                            1
#define D18F2x54_dct0_TestFail_MASK                             0x4
#define D18F2x54_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x54_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x54_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x54_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x54_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x54_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x54_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x54_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x54_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x54_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x54_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x54_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x54_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x54_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x54_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x54_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x54_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x54_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x54_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x54_dct0_STRUCT;

// **** D18F2x54_dct1 Register Definition ****
// Address
#define D18F2x54_dct1_ADDRESS                                   0x54

// Type
#define D18F2x54_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x54_dct1_CSEnable_OFFSET                           0
#define D18F2x54_dct1_CSEnable_WIDTH                            1
#define D18F2x54_dct1_CSEnable_MASK                             0x1
#define D18F2x54_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x54_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x54_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x54_dct1_TestFail_OFFSET                           2
#define D18F2x54_dct1_TestFail_WIDTH                            1
#define D18F2x54_dct1_TestFail_MASK                             0x4
#define D18F2x54_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x54_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x54_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x54_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x54_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x54_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x54_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x54_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x54_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x54_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x54_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x54_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x54_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x54_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x54_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x54_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x54_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x54_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x54_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x54_dct1_STRUCT;

// **** D18F2x58_dct1 Register Definition ****
// Address
#define D18F2x58_dct1_ADDRESS                                   0x58

// Type
#define D18F2x58_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x58_dct1_CSEnable_OFFSET                           0
#define D18F2x58_dct1_CSEnable_WIDTH                            1
#define D18F2x58_dct1_CSEnable_MASK                             0x1
#define D18F2x58_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x58_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x58_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x58_dct1_TestFail_OFFSET                           2
#define D18F2x58_dct1_TestFail_WIDTH                            1
#define D18F2x58_dct1_TestFail_MASK                             0x4
#define D18F2x58_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x58_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x58_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x58_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x58_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x58_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x58_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x58_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x58_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x58_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x58_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x58_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x58_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x58_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x58_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x58_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x58_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x58_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x58_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x58_dct1_STRUCT;

// **** D18F2x58_dct0 Register Definition ****
// Address
#define D18F2x58_dct0_ADDRESS                                   0x58

// Type
#define D18F2x58_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x58_dct0_CSEnable_OFFSET                           0
#define D18F2x58_dct0_CSEnable_WIDTH                            1
#define D18F2x58_dct0_CSEnable_MASK                             0x1
#define D18F2x58_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x58_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x58_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x58_dct0_TestFail_OFFSET                           2
#define D18F2x58_dct0_TestFail_WIDTH                            1
#define D18F2x58_dct0_TestFail_MASK                             0x4
#define D18F2x58_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x58_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x58_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x58_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x58_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x58_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x58_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x58_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x58_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x58_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x58_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x58_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x58_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x58_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x58_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x58_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x58_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x58_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x58_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x58_dct0_STRUCT;

// **** D18F2x5C_dct1 Register Definition ****
// Address
#define D18F2x5C_dct1_ADDRESS                                   0x5c

// Type
#define D18F2x5C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x5C_dct1_CSEnable_OFFSET                           0
#define D18F2x5C_dct1_CSEnable_WIDTH                            1
#define D18F2x5C_dct1_CSEnable_MASK                             0x1
#define D18F2x5C_dct1_Reserved_1_1_OFFSET                       1
#define D18F2x5C_dct1_Reserved_1_1_WIDTH                        1
#define D18F2x5C_dct1_Reserved_1_1_MASK                         0x2
#define D18F2x5C_dct1_TestFail_OFFSET                           2
#define D18F2x5C_dct1_TestFail_WIDTH                            1
#define D18F2x5C_dct1_TestFail_MASK                             0x4
#define D18F2x5C_dct1_OnDimmMirror_OFFSET                       3
#define D18F2x5C_dct1_OnDimmMirror_WIDTH                        1
#define D18F2x5C_dct1_OnDimmMirror_MASK                         0x8
#define D18F2x5C_dct1_Reserved_4_4_OFFSET                       4
#define D18F2x5C_dct1_Reserved_4_4_WIDTH                        1
#define D18F2x5C_dct1_Reserved_4_4_MASK                         0x10
#define D18F2x5C_dct1_BaseAddr_21_11__OFFSET                    5
#define D18F2x5C_dct1_BaseAddr_21_11__WIDTH                     11
#define D18F2x5C_dct1_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x5C_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x5C_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x5C_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x5C_dct1_BaseAddr_38_27__OFFSET                    19
#define D18F2x5C_dct1_BaseAddr_38_27__WIDTH                     12
#define D18F2x5C_dct1_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x5C_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x5C_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x5C_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x5C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x5C_dct1_STRUCT;

// **** D18F2x5C_dct0 Register Definition ****
// Address
#define D18F2x5C_dct0_ADDRESS                                   0x5c

// Type
#define D18F2x5C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x5C_dct0_CSEnable_OFFSET                           0
#define D18F2x5C_dct0_CSEnable_WIDTH                            1
#define D18F2x5C_dct0_CSEnable_MASK                             0x1
#define D18F2x5C_dct0_Reserved_1_1_OFFSET                       1
#define D18F2x5C_dct0_Reserved_1_1_WIDTH                        1
#define D18F2x5C_dct0_Reserved_1_1_MASK                         0x2
#define D18F2x5C_dct0_TestFail_OFFSET                           2
#define D18F2x5C_dct0_TestFail_WIDTH                            1
#define D18F2x5C_dct0_TestFail_MASK                             0x4
#define D18F2x5C_dct0_OnDimmMirror_OFFSET                       3
#define D18F2x5C_dct0_OnDimmMirror_WIDTH                        1
#define D18F2x5C_dct0_OnDimmMirror_MASK                         0x8
#define D18F2x5C_dct0_Reserved_4_4_OFFSET                       4
#define D18F2x5C_dct0_Reserved_4_4_WIDTH                        1
#define D18F2x5C_dct0_Reserved_4_4_MASK                         0x10
#define D18F2x5C_dct0_BaseAddr_21_11__OFFSET                    5
#define D18F2x5C_dct0_BaseAddr_21_11__WIDTH                     11
#define D18F2x5C_dct0_BaseAddr_21_11__MASK                      0xffe0
#define D18F2x5C_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x5C_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x5C_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x5C_dct0_BaseAddr_38_27__OFFSET                    19
#define D18F2x5C_dct0_BaseAddr_38_27__WIDTH                     12
#define D18F2x5C_dct0_BaseAddr_38_27__MASK                      0x7ff80000
#define D18F2x5C_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x5C_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x5C_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x5C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          BaseAddr_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x5C_dct0_STRUCT;

// **** D18F2x60_dct1 Register Definition ****
// Address
#define D18F2x60_dct1_ADDRESS                                   0x60

// Type
#define D18F2x60_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x60_dct1_Reserved_4_0_OFFSET                       0
#define D18F2x60_dct1_Reserved_4_0_WIDTH                        5
#define D18F2x60_dct1_Reserved_4_0_MASK                         0x1f
#define D18F2x60_dct1_AddrMask_21_11__OFFSET                    5
#define D18F2x60_dct1_AddrMask_21_11__WIDTH                     11
#define D18F2x60_dct1_AddrMask_21_11__MASK                      0xffe0
#define D18F2x60_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x60_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x60_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x60_dct1_AddrMask_38_27__OFFSET                    19
#define D18F2x60_dct1_AddrMask_38_27__WIDTH                     12
#define D18F2x60_dct1_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x60_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x60_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x60_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x60_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x60_dct1_STRUCT;

// **** D18F2x60_dct0 Register Definition ****
// Address
#define D18F2x60_dct0_ADDRESS                                   0x60

// Type
#define D18F2x60_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x60_dct0_Reserved_4_0_OFFSET                       0
#define D18F2x60_dct0_Reserved_4_0_WIDTH                        5
#define D18F2x60_dct0_Reserved_4_0_MASK                         0x1f
#define D18F2x60_dct0_AddrMask_21_11__OFFSET                    5
#define D18F2x60_dct0_AddrMask_21_11__WIDTH                     11
#define D18F2x60_dct0_AddrMask_21_11__MASK                      0xffe0
#define D18F2x60_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x60_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x60_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x60_dct0_AddrMask_38_27__OFFSET                    19
#define D18F2x60_dct0_AddrMask_38_27__WIDTH                     12
#define D18F2x60_dct0_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x60_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x60_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x60_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x60_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x60_dct0_STRUCT;

// **** D18F2x64_dct0 Register Definition ****
// Address
#define D18F2x64_dct0_ADDRESS                                   0x64

// Type
#define D18F2x64_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x64_dct0_Reserved_4_0_OFFSET                       0
#define D18F2x64_dct0_Reserved_4_0_WIDTH                        5
#define D18F2x64_dct0_Reserved_4_0_MASK                         0x1f
#define D18F2x64_dct0_AddrMask_21_11__OFFSET                    5
#define D18F2x64_dct0_AddrMask_21_11__WIDTH                     11
#define D18F2x64_dct0_AddrMask_21_11__MASK                      0xffe0
#define D18F2x64_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x64_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x64_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x64_dct0_AddrMask_38_27__OFFSET                    19
#define D18F2x64_dct0_AddrMask_38_27__WIDTH                     12
#define D18F2x64_dct0_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x64_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x64_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x64_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x64_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x64_dct0_STRUCT;

// **** D18F2x64_dct1 Register Definition ****
// Address
#define D18F2x64_dct1_ADDRESS                                   0x64

// Type
#define D18F2x64_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x64_dct1_Reserved_4_0_OFFSET                       0
#define D18F2x64_dct1_Reserved_4_0_WIDTH                        5
#define D18F2x64_dct1_Reserved_4_0_MASK                         0x1f
#define D18F2x64_dct1_AddrMask_21_11__OFFSET                    5
#define D18F2x64_dct1_AddrMask_21_11__WIDTH                     11
#define D18F2x64_dct1_AddrMask_21_11__MASK                      0xffe0
#define D18F2x64_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x64_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x64_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x64_dct1_AddrMask_38_27__OFFSET                    19
#define D18F2x64_dct1_AddrMask_38_27__WIDTH                     12
#define D18F2x64_dct1_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x64_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x64_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x64_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x64_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x64_dct1_STRUCT;

// **** D18F2x68_dct1 Register Definition ****
// Address
#define D18F2x68_dct1_ADDRESS                                   0x68

// Type
#define D18F2x68_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x68_dct1_Reserved_4_0_OFFSET                       0
#define D18F2x68_dct1_Reserved_4_0_WIDTH                        5
#define D18F2x68_dct1_Reserved_4_0_MASK                         0x1f
#define D18F2x68_dct1_AddrMask_21_11__OFFSET                    5
#define D18F2x68_dct1_AddrMask_21_11__WIDTH                     11
#define D18F2x68_dct1_AddrMask_21_11__MASK                      0xffe0
#define D18F2x68_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x68_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x68_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x68_dct1_AddrMask_38_27__OFFSET                    19
#define D18F2x68_dct1_AddrMask_38_27__WIDTH                     12
#define D18F2x68_dct1_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x68_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x68_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x68_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x68_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x68_dct1_STRUCT;

// **** D18F2x68_dct0 Register Definition ****
// Address
#define D18F2x68_dct0_ADDRESS                                   0x68

// Type
#define D18F2x68_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x68_dct0_Reserved_4_0_OFFSET                       0
#define D18F2x68_dct0_Reserved_4_0_WIDTH                        5
#define D18F2x68_dct0_Reserved_4_0_MASK                         0x1f
#define D18F2x68_dct0_AddrMask_21_11__OFFSET                    5
#define D18F2x68_dct0_AddrMask_21_11__WIDTH                     11
#define D18F2x68_dct0_AddrMask_21_11__MASK                      0xffe0
#define D18F2x68_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x68_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x68_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x68_dct0_AddrMask_38_27__OFFSET                    19
#define D18F2x68_dct0_AddrMask_38_27__WIDTH                     12
#define D18F2x68_dct0_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x68_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x68_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x68_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x68_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x68_dct0_STRUCT;

// **** D18F2x6C_dct1 Register Definition ****
// Address
#define D18F2x6C_dct1_ADDRESS                                   0x6c

// Type
#define D18F2x6C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x6C_dct1_Reserved_4_0_OFFSET                       0
#define D18F2x6C_dct1_Reserved_4_0_WIDTH                        5
#define D18F2x6C_dct1_Reserved_4_0_MASK                         0x1f
#define D18F2x6C_dct1_AddrMask_21_11__OFFSET                    5
#define D18F2x6C_dct1_AddrMask_21_11__WIDTH                     11
#define D18F2x6C_dct1_AddrMask_21_11__MASK                      0xffe0
#define D18F2x6C_dct1_Reserved_18_16_OFFSET                     16
#define D18F2x6C_dct1_Reserved_18_16_WIDTH                      3
#define D18F2x6C_dct1_Reserved_18_16_MASK                       0x70000
#define D18F2x6C_dct1_AddrMask_38_27__OFFSET                    19
#define D18F2x6C_dct1_AddrMask_38_27__WIDTH                     12
#define D18F2x6C_dct1_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x6C_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x6C_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x6C_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x6C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x6C_dct1_STRUCT;

// **** D18F2x6C_dct0 Register Definition ****
// Address
#define D18F2x6C_dct0_ADDRESS                                   0x6c

// Type
#define D18F2x6C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x6C_dct0_Reserved_4_0_OFFSET                       0
#define D18F2x6C_dct0_Reserved_4_0_WIDTH                        5
#define D18F2x6C_dct0_Reserved_4_0_MASK                         0x1f
#define D18F2x6C_dct0_AddrMask_21_11__OFFSET                    5
#define D18F2x6C_dct0_AddrMask_21_11__WIDTH                     11
#define D18F2x6C_dct0_AddrMask_21_11__MASK                      0xffe0
#define D18F2x6C_dct0_Reserved_18_16_OFFSET                     16
#define D18F2x6C_dct0_Reserved_18_16_WIDTH                      3
#define D18F2x6C_dct0_Reserved_18_16_MASK                       0x70000
#define D18F2x6C_dct0_AddrMask_38_27__OFFSET                    19
#define D18F2x6C_dct0_AddrMask_38_27__WIDTH                     12
#define D18F2x6C_dct0_AddrMask_38_27__MASK                      0x7ff80000
#define D18F2x6C_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x6C_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x6C_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x6C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_11_:11; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                          AddrMask_38_27_:12; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x6C_dct0_STRUCT;

// **** D18F2x78_dct0 Register Definition ****
// Address
#define D18F2x78_dct0_ADDRESS                                   0x78

// Type
#define D18F2x78_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x78_dct0_Reserved_16_0_OFFSET                      0
#define D18F2x78_dct0_Reserved_16_0_WIDTH                       17
#define D18F2x78_dct0_Reserved_16_0_MASK                        0x1ffff
#define D18F2x78_dct0_AddrCmdTriEn_OFFSET                       17
#define D18F2x78_dct0_AddrCmdTriEn_WIDTH                        1
#define D18F2x78_dct0_AddrCmdTriEn_MASK                         0x20000
#define D18F2x78_dct0_Reserved_31_18_OFFSET                     18
#define D18F2x78_dct0_Reserved_31_18_WIDTH                      14
#define D18F2x78_dct0_Reserved_31_18_MASK                       0xfffc0000

/// D18F2x78_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_16_0:17; ///<
    UINT32                                             AddrCmdTriEn:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x78_dct0_STRUCT;

// **** D18F2x78_dct1 Register Definition ****
// Address
#define D18F2x78_dct1_ADDRESS                                   0x78

// Type
#define D18F2x78_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x78_dct1_Reserved_16_0_OFFSET                      0
#define D18F2x78_dct1_Reserved_16_0_WIDTH                       17
#define D18F2x78_dct1_Reserved_16_0_MASK                        0x1ffff
#define D18F2x78_dct1_AddrCmdTriEn_OFFSET                       17
#define D18F2x78_dct1_AddrCmdTriEn_WIDTH                        1
#define D18F2x78_dct1_AddrCmdTriEn_MASK                         0x20000
#define D18F2x78_dct1_Reserved_31_18_OFFSET                     18
#define D18F2x78_dct1_Reserved_31_18_WIDTH                      14
#define D18F2x78_dct1_Reserved_31_18_MASK                       0xfffc0000

/// D18F2x78_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_16_0:17; ///<
    UINT32                                             AddrCmdTriEn:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x78_dct1_STRUCT;

// **** D18F2x7C_dct1 Register Definition ****
// Address
#define D18F2x7C_dct1_ADDRESS                                   0x7c

// Type
#define D18F2x7C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x7C_dct1_MrsAddress_17_0__OFFSET                   0
#define D18F2x7C_dct1_MrsAddress_17_0__WIDTH                    18
#define D18F2x7C_dct1_MrsAddress_17_0__MASK                     0x3ffff
#define D18F2x7C_dct1_MrsBank_2_0__OFFSET                       18
#define D18F2x7C_dct1_MrsBank_2_0__WIDTH                        3
#define D18F2x7C_dct1_MrsBank_2_0__MASK                         0x1c0000
#define D18F2x7C_dct1_MrsChipSel_OFFSET                         21
#define D18F2x7C_dct1_MrsChipSel_WIDTH                          3
#define D18F2x7C_dct1_MrsChipSel_MASK                           0xe00000
#define D18F2x7C_dct1_Reserved_24_24_OFFSET                     24
#define D18F2x7C_dct1_Reserved_24_24_WIDTH                      1
#define D18F2x7C_dct1_Reserved_24_24_MASK                       0x1000000
#define D18F2x7C_dct1_SendAutoRefresh_OFFSET                    25
#define D18F2x7C_dct1_SendAutoRefresh_WIDTH                     1
#define D18F2x7C_dct1_SendAutoRefresh_MASK                      0x2000000
#define D18F2x7C_dct1_SendMrsCmd_OFFSET                         26
#define D18F2x7C_dct1_SendMrsCmd_WIDTH                          1
#define D18F2x7C_dct1_SendMrsCmd_MASK                           0x4000000
#define D18F2x7C_dct1_DeassertMemRstX_OFFSET                    27
#define D18F2x7C_dct1_DeassertMemRstX_WIDTH                     1
#define D18F2x7C_dct1_DeassertMemRstX_MASK                      0x8000000
#define D18F2x7C_dct1_AssertCke_OFFSET                          28
#define D18F2x7C_dct1_AssertCke_WIDTH                           1
#define D18F2x7C_dct1_AssertCke_MASK                            0x10000000
#define D18F2x7C_dct1_SendZQCmd_OFFSET                          29
#define D18F2x7C_dct1_SendZQCmd_WIDTH                           1
#define D18F2x7C_dct1_SendZQCmd_MASK                            0x20000000
#define D18F2x7C_dct1_SendControlWord_OFFSET                    30
#define D18F2x7C_dct1_SendControlWord_WIDTH                     1
#define D18F2x7C_dct1_SendControlWord_MASK                      0x40000000
#define D18F2x7C_dct1_EnDramInit_OFFSET                         31
#define D18F2x7C_dct1_EnDramInit_WIDTH                          1
#define D18F2x7C_dct1_EnDramInit_MASK                           0x80000000

/// D18F2x7C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                         MrsAddress_17_0_:18; ///<
    UINT32                                             MrsBank_2_0_:3 ; ///<
    UINT32                                               MrsChipSel:3 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                          SendAutoRefresh:1 ; ///<
    UINT32                                               SendMrsCmd:1 ; ///<
    UINT32                                          DeassertMemRstX:1 ; ///<
    UINT32                                                AssertCke:1 ; ///<
    UINT32                                                SendZQCmd:1 ; ///<
    UINT32                                          SendControlWord:1 ; ///<
    UINT32                                               EnDramInit:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x7C_dct1_STRUCT;

// **** D18F2x7C_dct0 Register Definition ****
// Address
#define D18F2x7C_dct0_ADDRESS                                   0x7c

// Type
#define D18F2x7C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x7C_dct0_MrsAddress_17_0__OFFSET                   0
#define D18F2x7C_dct0_MrsAddress_17_0__WIDTH                    18
#define D18F2x7C_dct0_MrsAddress_17_0__MASK                     0x3ffff
#define D18F2x7C_dct0_MrsBank_2_0__OFFSET                       18
#define D18F2x7C_dct0_MrsBank_2_0__WIDTH                        3
#define D18F2x7C_dct0_MrsBank_2_0__MASK                         0x1c0000
#define D18F2x7C_dct0_MrsChipSel_OFFSET                         21
#define D18F2x7C_dct0_MrsChipSel_WIDTH                          3
#define D18F2x7C_dct0_MrsChipSel_MASK                           0xe00000
#define D18F2x7C_dct0_Reserved_24_24_OFFSET                     24
#define D18F2x7C_dct0_Reserved_24_24_WIDTH                      1
#define D18F2x7C_dct0_Reserved_24_24_MASK                       0x1000000
#define D18F2x7C_dct0_SendAutoRefresh_OFFSET                    25
#define D18F2x7C_dct0_SendAutoRefresh_WIDTH                     1
#define D18F2x7C_dct0_SendAutoRefresh_MASK                      0x2000000
#define D18F2x7C_dct0_SendMrsCmd_OFFSET                         26
#define D18F2x7C_dct0_SendMrsCmd_WIDTH                          1
#define D18F2x7C_dct0_SendMrsCmd_MASK                           0x4000000
#define D18F2x7C_dct0_DeassertMemRstX_OFFSET                    27
#define D18F2x7C_dct0_DeassertMemRstX_WIDTH                     1
#define D18F2x7C_dct0_DeassertMemRstX_MASK                      0x8000000
#define D18F2x7C_dct0_AssertCke_OFFSET                          28
#define D18F2x7C_dct0_AssertCke_WIDTH                           1
#define D18F2x7C_dct0_AssertCke_MASK                            0x10000000
#define D18F2x7C_dct0_SendZQCmd_OFFSET                          29
#define D18F2x7C_dct0_SendZQCmd_WIDTH                           1
#define D18F2x7C_dct0_SendZQCmd_MASK                            0x20000000
#define D18F2x7C_dct0_SendControlWord_OFFSET                    30
#define D18F2x7C_dct0_SendControlWord_WIDTH                     1
#define D18F2x7C_dct0_SendControlWord_MASK                      0x40000000
#define D18F2x7C_dct0_EnDramInit_OFFSET                         31
#define D18F2x7C_dct0_EnDramInit_WIDTH                          1
#define D18F2x7C_dct0_EnDramInit_MASK                           0x80000000

/// D18F2x7C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                         MrsAddress_17_0_:18; ///<
    UINT32                                             MrsBank_2_0_:3 ; ///<
    UINT32                                               MrsChipSel:3 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                          SendAutoRefresh:1 ; ///<
    UINT32                                               SendMrsCmd:1 ; ///<
    UINT32                                          DeassertMemRstX:1 ; ///<
    UINT32                                                AssertCke:1 ; ///<
    UINT32                                                SendZQCmd:1 ; ///<
    UINT32                                          SendControlWord:1 ; ///<
    UINT32                                               EnDramInit:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x7C_dct0_STRUCT;

// **** D18F2x80_dct1 Register Definition ****
// Address
#define D18F2x80_dct1_ADDRESS                                   0x80

// Type
#define D18F2x80_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x80_dct1_DimmAddrMap0_OFFSET                       0
#define D18F2x80_dct1_DimmAddrMap0_WIDTH                        4
#define D18F2x80_dct1_DimmAddrMap0_MASK                         0xf
#define D18F2x80_dct1_DimmAddrMap1_OFFSET                       4
#define D18F2x80_dct1_DimmAddrMap1_WIDTH                        4
#define D18F2x80_dct1_DimmAddrMap1_MASK                         0xf0
#define D18F2x80_dct1_DimmAddrMap2_OFFSET                       8
#define D18F2x80_dct1_DimmAddrMap2_WIDTH                        4
#define D18F2x80_dct1_DimmAddrMap2_MASK                         0xf00
#define D18F2x80_dct1_DimmAddrMap3_OFFSET                       12
#define D18F2x80_dct1_DimmAddrMap3_WIDTH                        4
#define D18F2x80_dct1_DimmAddrMap3_MASK                         0xf000
#define D18F2x80_dct1_Reserved_31_16_OFFSET                     16
#define D18F2x80_dct1_Reserved_31_16_WIDTH                      16
#define D18F2x80_dct1_Reserved_31_16_MASK                       0xffff0000

/// D18F2x80_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             DimmAddrMap0:4 ; ///<
    UINT32                                             DimmAddrMap1:4 ; ///<
    UINT32                                             DimmAddrMap2:4 ; ///<
    UINT32                                             DimmAddrMap3:4 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x80_dct1_STRUCT;

// **** D18F2x80_dct0 Register Definition ****
// Address
#define D18F2x80_dct0_ADDRESS                                   0x80

// Type
#define D18F2x80_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x80_dct0_DimmAddrMap0_OFFSET                       0
#define D18F2x80_dct0_DimmAddrMap0_WIDTH                        4
#define D18F2x80_dct0_DimmAddrMap0_MASK                         0xf
#define D18F2x80_dct0_DimmAddrMap1_OFFSET                       4
#define D18F2x80_dct0_DimmAddrMap1_WIDTH                        4
#define D18F2x80_dct0_DimmAddrMap1_MASK                         0xf0
#define D18F2x80_dct0_DimmAddrMap2_OFFSET                       8
#define D18F2x80_dct0_DimmAddrMap2_WIDTH                        4
#define D18F2x80_dct0_DimmAddrMap2_MASK                         0xf00
#define D18F2x80_dct0_DimmAddrMap3_OFFSET                       12
#define D18F2x80_dct0_DimmAddrMap3_WIDTH                        4
#define D18F2x80_dct0_DimmAddrMap3_MASK                         0xf000
#define D18F2x80_dct0_Reserved_31_16_OFFSET                     16
#define D18F2x80_dct0_Reserved_31_16_WIDTH                      16
#define D18F2x80_dct0_Reserved_31_16_MASK                       0xffff0000

/// D18F2x80_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             DimmAddrMap0:4 ; ///<
    UINT32                                             DimmAddrMap1:4 ; ///<
    UINT32                                             DimmAddrMap2:4 ; ///<
    UINT32                                             DimmAddrMap3:4 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x80_dct0_STRUCT;

// **** D18F2x84_dct1 Register Definition ****
// Address
#define D18F2x84_dct1_ADDRESS                                   0x84

// Type
#define D18F2x84_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x84_dct1_BurstCtrl_OFFSET                          0
#define D18F2x84_dct1_BurstCtrl_WIDTH                           2
#define D18F2x84_dct1_BurstCtrl_MASK                            0x3
#define D18F2x84_dct1_Reserved_22_2_OFFSET                      2
#define D18F2x84_dct1_Reserved_22_2_WIDTH                       21
#define D18F2x84_dct1_Reserved_22_2_MASK                        0x7ffffc
#define D18F2x84_dct1_PchgPDModeSel_OFFSET                      23
#define D18F2x84_dct1_PchgPDModeSel_WIDTH                       1
#define D18F2x84_dct1_PchgPDModeSel_MASK                        0x800000
#define D18F2x84_dct1_Reserved_31_24_OFFSET                     24
#define D18F2x84_dct1_Reserved_31_24_WIDTH                      8
#define D18F2x84_dct1_Reserved_31_24_MASK                       0xff000000

/// D18F2x84_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                BurstCtrl:2 ; ///<
    UINT32                                            Reserved_22_2:21; ///<
    UINT32                                            PchgPDModeSel:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x84_dct1_STRUCT;

// **** D18F2x84_dct0 Register Definition ****
// Address
#define D18F2x84_dct0_ADDRESS                                   0x84

// Type
#define D18F2x84_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x84_dct0_BurstCtrl_OFFSET                          0
#define D18F2x84_dct0_BurstCtrl_WIDTH                           2
#define D18F2x84_dct0_BurstCtrl_MASK                            0x3
#define D18F2x84_dct0_Reserved_22_2_OFFSET                      2
#define D18F2x84_dct0_Reserved_22_2_WIDTH                       21
#define D18F2x84_dct0_Reserved_22_2_MASK                        0x7ffffc
#define D18F2x84_dct0_PchgPDModeSel_OFFSET                      23
#define D18F2x84_dct0_PchgPDModeSel_WIDTH                       1
#define D18F2x84_dct0_PchgPDModeSel_MASK                        0x800000
#define D18F2x84_dct0_Reserved_31_24_OFFSET                     24
#define D18F2x84_dct0_Reserved_31_24_WIDTH                      8
#define D18F2x84_dct0_Reserved_31_24_MASK                       0xff000000

/// D18F2x84_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                BurstCtrl:2 ; ///<
    UINT32                                            Reserved_22_2:21; ///<
    UINT32                                            PchgPDModeSel:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x84_dct0_STRUCT;

// **** D18F2x88_dct1 Register Definition ****
// Address
#define D18F2x88_dct1_ADDRESS                                   0x88

// Type
#define D18F2x88_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x88_dct1_Reserved_23_0_OFFSET                      0
#define D18F2x88_dct1_Reserved_23_0_WIDTH                       24
#define D18F2x88_dct1_Reserved_23_0_MASK                        0xffffff
#define D18F2x88_dct1_MemClkDis_OFFSET                          24
#define D18F2x88_dct1_MemClkDis_WIDTH                           6
#define D18F2x88_dct1_MemClkDis_MASK                            0x3f000000
#define D18F2x88_dct1_Reserved_31_30_OFFSET                     30
#define D18F2x88_dct1_Reserved_31_30_WIDTH                      2
#define D18F2x88_dct1_Reserved_31_30_MASK                       0xc0000000

/// D18F2x88_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                                MemClkDis:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x88_dct1_STRUCT;

// **** D18F2x88_dct0 Register Definition ****
// Address
#define D18F2x88_dct0_ADDRESS                                   0x88

// Type
#define D18F2x88_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x88_dct0_Reserved_23_0_OFFSET                      0
#define D18F2x88_dct0_Reserved_23_0_WIDTH                       24
#define D18F2x88_dct0_Reserved_23_0_MASK                        0xffffff
#define D18F2x88_dct0_MemClkDis_OFFSET                          24
#define D18F2x88_dct0_MemClkDis_WIDTH                           6
#define D18F2x88_dct0_MemClkDis_MASK                            0x3f000000
#define D18F2x88_dct0_Reserved_31_30_OFFSET                     30
#define D18F2x88_dct0_Reserved_31_30_WIDTH                      2
#define D18F2x88_dct0_Reserved_31_30_MASK                       0xc0000000

/// D18F2x88_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                                MemClkDis:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x88_dct0_STRUCT;

// **** D18F2x8C_dct1 Register Definition ****
// Address
#define D18F2x8C_dct1_ADDRESS                                   0x8c

// Type
#define D18F2x8C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x8C_dct1_Reserved_15_0_OFFSET                      0
#define D18F2x8C_dct1_Reserved_15_0_WIDTH                       16
#define D18F2x8C_dct1_Reserved_15_0_MASK                        0xffff
#define D18F2x8C_dct1_Tref_OFFSET                               16
#define D18F2x8C_dct1_Tref_WIDTH                                2
#define D18F2x8C_dct1_Tref_MASK                                 0x30000
#define D18F2x8C_dct1_DisAutoRefresh_OFFSET                     18
#define D18F2x8C_dct1_DisAutoRefresh_WIDTH                      1
#define D18F2x8C_dct1_DisAutoRefresh_MASK                       0x40000
#define D18F2x8C_dct1_Reserved_31_19_OFFSET                     19
#define D18F2x8C_dct1_Reserved_31_19_WIDTH                      13
#define D18F2x8C_dct1_Reserved_31_19_MASK                       0xfff80000

/// D18F2x8C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                                     Tref:2 ; ///<
    UINT32                                           DisAutoRefresh:1 ; ///<
    UINT32                                           Reserved_31_19:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x8C_dct1_STRUCT;

// **** D18F2x8C_dct0 Register Definition ****
// Address
#define D18F2x8C_dct0_ADDRESS                                   0x8c

// Type
#define D18F2x8C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x8C_dct0_Reserved_15_0_OFFSET                      0
#define D18F2x8C_dct0_Reserved_15_0_WIDTH                       16
#define D18F2x8C_dct0_Reserved_15_0_MASK                        0xffff
#define D18F2x8C_dct0_Tref_OFFSET                               16
#define D18F2x8C_dct0_Tref_WIDTH                                2
#define D18F2x8C_dct0_Tref_MASK                                 0x30000
#define D18F2x8C_dct0_DisAutoRefresh_OFFSET                     18
#define D18F2x8C_dct0_DisAutoRefresh_WIDTH                      1
#define D18F2x8C_dct0_DisAutoRefresh_MASK                       0x40000
#define D18F2x8C_dct0_Reserved_31_19_OFFSET                     19
#define D18F2x8C_dct0_Reserved_31_19_WIDTH                      13
#define D18F2x8C_dct0_Reserved_31_19_MASK                       0xfff80000

/// D18F2x8C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                                     Tref:2 ; ///<
    UINT32                                           DisAutoRefresh:1 ; ///<
    UINT32                                           Reserved_31_19:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x8C_dct0_STRUCT;

// **** D18F2x90_dct0 Register Definition ****
// Address
#define D18F2x90_dct0_ADDRESS                                   0x90

// Type
#define D18F2x90_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x90_dct0_Reserved_0_0_OFFSET                       0
#define D18F2x90_dct0_Reserved_0_0_WIDTH                        1
#define D18F2x90_dct0_Reserved_0_0_MASK                         0x1
#define D18F2x90_dct0_ExitSelfRef_OFFSET                        1
#define D18F2x90_dct0_ExitSelfRef_WIDTH                         1
#define D18F2x90_dct0_ExitSelfRef_MASK                          0x2
#define D18F2x90_dct0_Reserved_7_2_OFFSET                       2
#define D18F2x90_dct0_Reserved_7_2_WIDTH                        6
#define D18F2x90_dct0_Reserved_7_2_MASK                         0xfc
#define D18F2x90_dct0_Reserved_8_8_OFFSET                       8
#define D18F2x90_dct0_Reserved_8_8_WIDTH                        1
#define D18F2x90_dct0_Reserved_8_8_MASK                         0x100
#define D18F2x90_dct0_Reserved_11_9_OFFSET                      9
#define D18F2x90_dct0_Reserved_11_9_WIDTH                       3
#define D18F2x90_dct0_Reserved_11_9_MASK                        0xe00
#define D18F2x90_dct0_Reserved_15_12_OFFSET                     12
#define D18F2x90_dct0_Reserved_15_12_WIDTH                      4
#define D18F2x90_dct0_Reserved_15_12_MASK                       0xf000
#define D18F2x90_dct0_UnbuffDimm_OFFSET                         16
#define D18F2x90_dct0_UnbuffDimm_WIDTH                          1
#define D18F2x90_dct0_UnbuffDimm_MASK                           0x10000
#define D18F2x90_dct0_EnterSelfRef_OFFSET                       17
#define D18F2x90_dct0_EnterSelfRef_WIDTH                        1
#define D18F2x90_dct0_EnterSelfRef_MASK                         0x20000
#define D18F2x90_dct0_PendRefPayback_OFFSET                     18
#define D18F2x90_dct0_PendRefPayback_WIDTH                      1
#define D18F2x90_dct0_PendRefPayback_MASK                       0x40000
#define D18F2x90_dct0_Reserved_19_19_OFFSET                     19
#define D18F2x90_dct0_Reserved_19_19_WIDTH                      1
#define D18F2x90_dct0_Reserved_19_19_MASK                       0x80000
#define D18F2x90_dct0_DynPageCloseEn_OFFSET                     20
#define D18F2x90_dct0_DynPageCloseEn_WIDTH                      1
#define D18F2x90_dct0_DynPageCloseEn_MASK                       0x100000
#define D18F2x90_dct0_IdleCycLowLimit_OFFSET                    21
#define D18F2x90_dct0_IdleCycLowLimit_WIDTH                     2
#define D18F2x90_dct0_IdleCycLowLimit_MASK                      0x600000
#define D18F2x90_dct0_ForceAutoPchg_OFFSET                      23
#define D18F2x90_dct0_ForceAutoPchg_WIDTH                       1
#define D18F2x90_dct0_ForceAutoPchg_MASK                        0x800000
#define D18F2x90_dct0_StagRefEn_OFFSET                          24
#define D18F2x90_dct0_StagRefEn_WIDTH                           1
#define D18F2x90_dct0_StagRefEn_MASK                            0x1000000
#define D18F2x90_dct0_PendRefPaybackS3En_OFFSET                 25
#define D18F2x90_dct0_PendRefPaybackS3En_WIDTH                  1
#define D18F2x90_dct0_PendRefPaybackS3En_MASK                   0x2000000
#define D18F2x90_dct0_Reserved_26_26_OFFSET                     26
#define D18F2x90_dct0_Reserved_26_26_WIDTH                      1
#define D18F2x90_dct0_Reserved_26_26_MASK                       0x4000000
#define D18F2x90_dct0_DisDllShutdownSR_OFFSET                   27
#define D18F2x90_dct0_DisDllShutdownSR_WIDTH                    1
#define D18F2x90_dct0_DisDllShutdownSR_MASK                     0x8000000
#define D18F2x90_dct0_Reserved_31_28_OFFSET                     28
#define D18F2x90_dct0_Reserved_31_28_WIDTH                      4
#define D18F2x90_dct0_Reserved_31_28_MASK                       0xf0000000

/// D18F2x90_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                              ExitSelfRef:1 ; ///<
    UINT32                                             Reserved_7_2:6 ; ///<
    UINT32                                             Reserved_8_8:1 ; ///<
    UINT32                                            Reserved_11_9:3 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                               UnbuffDimm:1 ; ///<
    UINT32                                             EnterSelfRef:1 ; ///<
    UINT32                                           PendRefPayback:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                           DynPageCloseEn:1 ; ///<
    UINT32                                          IdleCycLowLimit:2 ; ///<
    UINT32                                            ForceAutoPchg:1 ; ///<
    UINT32                                                StagRefEn:1 ; ///<
    UINT32                                       PendRefPaybackS3En:1 ; ///<
    UINT32                                           Reserved_26_26:1 ; ///<
    UINT32                                         DisDllShutdownSR:1 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x90_dct0_STRUCT;

// **** D18F2x90_dct1 Register Definition ****
// Address
#define D18F2x90_dct1_ADDRESS                                   0x90

// Type
#define D18F2x90_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x90_dct1_Reserved_0_0_OFFSET                       0
#define D18F2x90_dct1_Reserved_0_0_WIDTH                        1
#define D18F2x90_dct1_Reserved_0_0_MASK                         0x1
#define D18F2x90_dct1_ExitSelfRef_OFFSET                        1
#define D18F2x90_dct1_ExitSelfRef_WIDTH                         1
#define D18F2x90_dct1_ExitSelfRef_MASK                          0x2
#define D18F2x90_dct1_Reserved_7_2_OFFSET                       2
#define D18F2x90_dct1_Reserved_7_2_WIDTH                        6
#define D18F2x90_dct1_Reserved_7_2_MASK                         0xfc
#define D18F2x90_dct1_Reserved_8_8_OFFSET                       8
#define D18F2x90_dct1_Reserved_8_8_WIDTH                        1
#define D18F2x90_dct1_Reserved_8_8_MASK                         0x100
#define D18F2x90_dct1_Reserved_11_9_OFFSET                      9
#define D18F2x90_dct1_Reserved_11_9_WIDTH                       3
#define D18F2x90_dct1_Reserved_11_9_MASK                        0xe00
#define D18F2x90_dct1_Reserved_15_12_OFFSET                     12
#define D18F2x90_dct1_Reserved_15_12_WIDTH                      4
#define D18F2x90_dct1_Reserved_15_12_MASK                       0xf000
#define D18F2x90_dct1_UnbuffDimm_OFFSET                         16
#define D18F2x90_dct1_UnbuffDimm_WIDTH                          1
#define D18F2x90_dct1_UnbuffDimm_MASK                           0x10000
#define D18F2x90_dct1_EnterSelfRef_OFFSET                       17
#define D18F2x90_dct1_EnterSelfRef_WIDTH                        1
#define D18F2x90_dct1_EnterSelfRef_MASK                         0x20000
#define D18F2x90_dct1_PendRefPayback_OFFSET                     18
#define D18F2x90_dct1_PendRefPayback_WIDTH                      1
#define D18F2x90_dct1_PendRefPayback_MASK                       0x40000
#define D18F2x90_dct1_Reserved_19_19_OFFSET                     19
#define D18F2x90_dct1_Reserved_19_19_WIDTH                      1
#define D18F2x90_dct1_Reserved_19_19_MASK                       0x80000
#define D18F2x90_dct1_DynPageCloseEn_OFFSET                     20
#define D18F2x90_dct1_DynPageCloseEn_WIDTH                      1
#define D18F2x90_dct1_DynPageCloseEn_MASK                       0x100000
#define D18F2x90_dct1_IdleCycLowLimit_OFFSET                    21
#define D18F2x90_dct1_IdleCycLowLimit_WIDTH                     2
#define D18F2x90_dct1_IdleCycLowLimit_MASK                      0x600000
#define D18F2x90_dct1_ForceAutoPchg_OFFSET                      23
#define D18F2x90_dct1_ForceAutoPchg_WIDTH                       1
#define D18F2x90_dct1_ForceAutoPchg_MASK                        0x800000
#define D18F2x90_dct1_StagRefEn_OFFSET                          24
#define D18F2x90_dct1_StagRefEn_WIDTH                           1
#define D18F2x90_dct1_StagRefEn_MASK                            0x1000000
#define D18F2x90_dct1_PendRefPaybackS3En_OFFSET                 25
#define D18F2x90_dct1_PendRefPaybackS3En_WIDTH                  1
#define D18F2x90_dct1_PendRefPaybackS3En_MASK                   0x2000000
#define D18F2x90_dct1_Reserved_26_26_OFFSET                     26
#define D18F2x90_dct1_Reserved_26_26_WIDTH                      1
#define D18F2x90_dct1_Reserved_26_26_MASK                       0x4000000
#define D18F2x90_dct1_DisDllShutdownSR_OFFSET                   27
#define D18F2x90_dct1_DisDllShutdownSR_WIDTH                    1
#define D18F2x90_dct1_DisDllShutdownSR_MASK                     0x8000000
#define D18F2x90_dct1_Reserved_31_28_OFFSET                     28
#define D18F2x90_dct1_Reserved_31_28_WIDTH                      4
#define D18F2x90_dct1_Reserved_31_28_MASK                       0xf0000000

/// D18F2x90_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                              ExitSelfRef:1 ; ///<
    UINT32                                             Reserved_7_2:6 ; ///<
    UINT32                                             Reserved_8_8:1 ; ///<
    UINT32                                            Reserved_11_9:3 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                               UnbuffDimm:1 ; ///<
    UINT32                                             EnterSelfRef:1 ; ///<
    UINT32                                           PendRefPayback:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                           DynPageCloseEn:1 ; ///<
    UINT32                                          IdleCycLowLimit:2 ; ///<
    UINT32                                            ForceAutoPchg:1 ; ///<
    UINT32                                                StagRefEn:1 ; ///<
    UINT32                                       PendRefPaybackS3En:1 ; ///<
    UINT32                                           Reserved_26_26:1 ; ///<
    UINT32                                         DisDllShutdownSR:1 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x90_dct1_STRUCT;

// **** D18F2x94_dct1 Register Definition ****
// Address
#define D18F2x94_dct1_ADDRESS                                   0x94

// Type
#define D18F2x94_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x94_dct1_MemClkFreq_OFFSET                         0
#define D18F2x94_dct1_MemClkFreq_WIDTH                          5
#define D18F2x94_dct1_MemClkFreq_MASK                           0x1f
#define D18F2x94_dct1_Reserved_6_5_OFFSET                       5
#define D18F2x94_dct1_Reserved_6_5_WIDTH                        2
#define D18F2x94_dct1_Reserved_6_5_MASK                         0x60
#define D18F2x94_dct1_MemClkFreqVal_OFFSET                      7
#define D18F2x94_dct1_MemClkFreqVal_WIDTH                       1
#define D18F2x94_dct1_MemClkFreqVal_MASK                        0x80
#define D18F2x94_dct1_Reserved_9_8_OFFSET                       8
#define D18F2x94_dct1_Reserved_9_8_WIDTH                        2
#define D18F2x94_dct1_Reserved_9_8_MASK                         0x300
#define D18F2x94_dct1_ZqcsInterval_OFFSET                       10
#define D18F2x94_dct1_ZqcsInterval_WIDTH                        2
#define D18F2x94_dct1_ZqcsInterval_MASK                         0xc00
#define D18F2x94_dct1_Reserved_12_12_OFFSET                     12
#define D18F2x94_dct1_Reserved_12_12_WIDTH                      1
#define D18F2x94_dct1_Reserved_12_12_MASK                       0x1000
#define D18F2x94_dct1_Reserved_13_13_OFFSET                     13
#define D18F2x94_dct1_Reserved_13_13_WIDTH                      1
#define D18F2x94_dct1_Reserved_13_13_MASK                       0x2000
#define D18F2x94_dct1_DisDramInterface_OFFSET                   14
#define D18F2x94_dct1_DisDramInterface_WIDTH                    1
#define D18F2x94_dct1_DisDramInterface_MASK                     0x4000
#define D18F2x94_dct1_PowerDownEn_OFFSET                        15
#define D18F2x94_dct1_PowerDownEn_WIDTH                         1
#define D18F2x94_dct1_PowerDownEn_MASK                          0x8000
#define D18F2x94_dct1_PowerDownMode_OFFSET                      16
#define D18F2x94_dct1_PowerDownMode_WIDTH                       1
#define D18F2x94_dct1_PowerDownMode_MASK                        0x10000
#define D18F2x94_dct1_Reserved_18_17_OFFSET                     17
#define D18F2x94_dct1_Reserved_18_17_WIDTH                      2
#define D18F2x94_dct1_Reserved_18_17_MASK                       0x60000
#define D18F2x94_dct1_SlowAccessMode_OFFSET                     20
#define D18F2x94_dct1_SlowAccessMode_WIDTH                      1
#define D18F2x94_dct1_SlowAccessMode_MASK                       0x100000
#define D18F2x94_dct1_FreqChgInProg_OFFSET                      21
#define D18F2x94_dct1_FreqChgInProg_WIDTH                       1
#define D18F2x94_dct1_FreqChgInProg_MASK                        0x200000
#define D18F2x94_dct1_BankSwizzleMode_OFFSET                    22
#define D18F2x94_dct1_BankSwizzleMode_WIDTH                     1
#define D18F2x94_dct1_BankSwizzleMode_MASK                      0x400000
#define D18F2x94_dct1_ProcOdtDis_OFFSET                         23
#define D18F2x94_dct1_ProcOdtDis_WIDTH                          1
#define D18F2x94_dct1_ProcOdtDis_MASK                           0x800000
#define D18F2x94_dct1_DcqBypassMax_OFFSET                       24
#define D18F2x94_dct1_DcqBypassMax_WIDTH                        5
#define D18F2x94_dct1_DcqBypassMax_MASK                         0x1f000000
#define D18F2x94_dct1_Reserved_30_29_OFFSET                     29
#define D18F2x94_dct1_Reserved_30_29_WIDTH                      2
#define D18F2x94_dct1_Reserved_30_29_MASK                       0x60000000
#define D18F2x94_dct1_DphyMemPsSelEn_OFFSET                     31
#define D18F2x94_dct1_DphyMemPsSelEn_WIDTH                      1
#define D18F2x94_dct1_DphyMemPsSelEn_MASK                       0x80000000

/// D18F2x94_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                               MemClkFreq:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                            MemClkFreqVal:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                             ZqcsInterval:2 ; ///<
    UINT32                                           Reserved_12_12:1 ; ///<
    UINT32                                           Reserved_13_13:1 ; ///<
    UINT32                                         DisDramInterface:1 ; ///<
    UINT32                                              PowerDownEn:1 ; ///<
    UINT32                                            PowerDownMode:1 ; ///<
    UINT32                                           Reserved_18_17:2 ; ///<
    UINT32                                           DcqArbBypassEn:1 ; ///<
    UINT32                                           SlowAccessMode:1 ; ///<
    UINT32                                            FreqChgInProg:1 ; ///<
    UINT32                                          BankSwizzleMode:1 ; ///<
    UINT32                                               ProcOdtDis:1 ; ///<
    UINT32                                             DcqBypassMax:5 ; ///<
    UINT32                                           Reserved_30_29:2 ; ///<
    UINT32                                           DphyMemPsSelEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x94_dct1_STRUCT;

// **** D18F2x94_dct0 Register Definition ****
// Address
#define D18F2x94_dct0_ADDRESS                                   0x94

// Type
#define D18F2x94_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x94_dct0_MemClkFreq_OFFSET                         0
#define D18F2x94_dct0_MemClkFreq_WIDTH                          5
#define D18F2x94_dct0_MemClkFreq_MASK                           0x1f
#define D18F2x94_dct0_Reserved_6_5_OFFSET                       5
#define D18F2x94_dct0_Reserved_6_5_WIDTH                        2
#define D18F2x94_dct0_Reserved_6_5_MASK                         0x60
#define D18F2x94_dct0_MemClkFreqVal_OFFSET                      7
#define D18F2x94_dct0_MemClkFreqVal_WIDTH                       1
#define D18F2x94_dct0_MemClkFreqVal_MASK                        0x80
#define D18F2x94_dct0_Reserved_9_8_OFFSET                       8
#define D18F2x94_dct0_Reserved_9_8_WIDTH                        2
#define D18F2x94_dct0_Reserved_9_8_MASK                         0x300
#define D18F2x94_dct0_ZqcsInterval_OFFSET                       10
#define D18F2x94_dct0_ZqcsInterval_WIDTH                        2
#define D18F2x94_dct0_ZqcsInterval_MASK                         0xc00
#define D18F2x94_dct0_Reserved_12_12_OFFSET                     12
#define D18F2x94_dct0_Reserved_12_12_WIDTH                      1
#define D18F2x94_dct0_Reserved_12_12_MASK                       0x1000
#define D18F2x94_dct0_Reserved_13_13_OFFSET                     13
#define D18F2x94_dct0_Reserved_13_13_WIDTH                      1
#define D18F2x94_dct0_Reserved_13_13_MASK                       0x2000
#define D18F2x94_dct0_DisDramInterface_OFFSET                   14
#define D18F2x94_dct0_DisDramInterface_WIDTH                    1
#define D18F2x94_dct0_DisDramInterface_MASK                     0x4000
#define D18F2x94_dct0_PowerDownEn_OFFSET                        15
#define D18F2x94_dct0_PowerDownEn_WIDTH                         1
#define D18F2x94_dct0_PowerDownEn_MASK                          0x8000
#define D18F2x94_dct0_PowerDownMode_OFFSET                      16
#define D18F2x94_dct0_PowerDownMode_WIDTH                       1
#define D18F2x94_dct0_PowerDownMode_MASK                        0x10000
#define D18F2x94_dct0_Reserved_18_17_OFFSET                     17
#define D18F2x94_dct0_Reserved_18_17_WIDTH                      2
#define D18F2x94_dct0_Reserved_18_17_MASK                       0x60000
#define D18F2x94_dct0_SlowAccessMode_OFFSET                     20
#define D18F2x94_dct0_SlowAccessMode_WIDTH                      1
#define D18F2x94_dct0_SlowAccessMode_MASK                       0x100000
#define D18F2x94_dct0_FreqChgInProg_OFFSET                      21
#define D18F2x94_dct0_FreqChgInProg_WIDTH                       1
#define D18F2x94_dct0_FreqChgInProg_MASK                        0x200000
#define D18F2x94_dct0_BankSwizzleMode_OFFSET                    22
#define D18F2x94_dct0_BankSwizzleMode_WIDTH                     1
#define D18F2x94_dct0_BankSwizzleMode_MASK                      0x400000
#define D18F2x94_dct0_ProcOdtDis_OFFSET                         23
#define D18F2x94_dct0_ProcOdtDis_WIDTH                          1
#define D18F2x94_dct0_ProcOdtDis_MASK                           0x800000
#define D18F2x94_dct0_DcqBypassMax_OFFSET                       24
#define D18F2x94_dct0_DcqBypassMax_WIDTH                        5
#define D18F2x94_dct0_DcqBypassMax_MASK                         0x1f000000
#define D18F2x94_dct0_Reserved_30_29_OFFSET                     29
#define D18F2x94_dct0_Reserved_30_29_WIDTH                      2
#define D18F2x94_dct0_Reserved_30_29_MASK                       0x60000000
#define D18F2x94_dct0_DphyMemPsSelEn_OFFSET                     31
#define D18F2x94_dct0_DphyMemPsSelEn_WIDTH                      1
#define D18F2x94_dct0_DphyMemPsSelEn_MASK                       0x80000000

/// D18F2x94_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                               MemClkFreq:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                            MemClkFreqVal:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                             ZqcsInterval:2 ; ///<
    UINT32                                           Reserved_12_12:1 ; ///<
    UINT32                                           Reserved_13_13:1 ; ///<
    UINT32                                         DisDramInterface:1 ; ///<
    UINT32                                              PowerDownEn:1 ; ///<
    UINT32                                            PowerDownMode:1 ; ///<
    UINT32                                           Reserved_18_17:2 ; ///<
    UINT32                                           DcqArbBypassEn:1 ; ///<
    UINT32                                           SlowAccessMode:1 ; ///<
    UINT32                                            FreqChgInProg:1 ; ///<
    UINT32                                          BankSwizzleMode:1 ; ///<
    UINT32                                               ProcOdtDis:1 ; ///<
    UINT32                                             DcqBypassMax:5 ; ///<
    UINT32                                           Reserved_30_29:2 ; ///<
    UINT32                                           DphyMemPsSelEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x94_dct0_STRUCT;

// **** D18F2x98_dct0 Register Definition ****
// Address
#define D18F2x98_dct0_ADDRESS                                   0x98

// Type
#define D18F2x98_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x98_dct0_DctOffset_OFFSET                          0
#define D18F2x98_dct0_DctOffset_WIDTH                           30
#define D18F2x98_dct0_DctOffset_MASK                            0x3fffffff
#define D18F2x98_dct0_DctAccessWrite_OFFSET                     30
#define D18F2x98_dct0_DctAccessWrite_WIDTH                      1
#define D18F2x98_dct0_DctAccessWrite_MASK                       0x40000000
#define D18F2x98_dct0_Reserved_31_31_OFFSET                     31
#define D18F2x98_dct0_Reserved_31_31_WIDTH                      1
#define D18F2x98_dct0_Reserved_31_31_MASK                       0x80000000

/// D18F2x98_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:30; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x98_dct0_STRUCT;

// **** D18F2x98_dct1 Register Definition ****
// Address
#define D18F2x98_dct1_ADDRESS                                   0x98

// Type
#define D18F2x98_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x98_dct1_DctOffset_OFFSET                          0
#define D18F2x98_dct1_DctOffset_WIDTH                           30
#define D18F2x98_dct1_DctOffset_MASK                            0x3fffffff
#define D18F2x98_dct1_DctAccessWrite_OFFSET                     30
#define D18F2x98_dct1_DctAccessWrite_WIDTH                      1
#define D18F2x98_dct1_DctAccessWrite_MASK                       0x40000000
#define D18F2x98_dct1_Reserved_31_31_OFFSET                     31
#define D18F2x98_dct1_Reserved_31_31_WIDTH                      1
#define D18F2x98_dct1_Reserved_31_31_MASK                       0x80000000

/// D18F2x98_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:30; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x98_dct1_STRUCT;

// **** D18F2x9C_dct1 Register Definition ****
// Address
#define D18F2x9C_dct1_ADDRESS                                   0x9c

// Type
#define D18F2x9C_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2x9C_dct1_Data_OFFSET                               0
#define D18F2x9C_dct1_Data_WIDTH                                32
#define D18F2x9C_dct1_Data_MASK                                 0xffffffff

/// D18F2x9C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x9C_dct1_STRUCT;

// **** D18F2x9C_dct0 Register Definition ****
// Address
#define D18F2x9C_dct0_ADDRESS                                   0x9c

// Type
#define D18F2x9C_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2x9C_dct0_Data_OFFSET                               0
#define D18F2x9C_dct0_Data_WIDTH                                32
#define D18F2x9C_dct0_Data_MASK                                 0xffffffff

/// D18F2x9C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x9C_dct0_STRUCT;

// **** D18F2xA4 Register Definition ****
// Address
#define D18F2xA4_ADDRESS                                        0xa4

// Type
#define D18F2xA4_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2xA4_Reserved_7_0_OFFSET                            0
#define D18F2xA4_Reserved_7_0_WIDTH                             8
#define D18F2xA4_Reserved_7_0_MASK                              0xff
#define D18F2xA4_ODTSEn_OFFSET                                  8
#define D18F2xA4_ODTSEn_WIDTH                                   1
#define D18F2xA4_ODTSEn_MASK                                    0x100
#define D18F2xA4_Reserved_10_9_OFFSET                           9
#define D18F2xA4_Reserved_10_9_WIDTH                            2
#define D18F2xA4_Reserved_10_9_MASK                             0x600
#define D18F2xA4_BwCapEn_OFFSET                                 11
#define D18F2xA4_BwCapEn_WIDTH                                  1
#define D18F2xA4_BwCapEn_MASK                                   0x800
#define D18F2xA4_CmdThrottleMode_OFFSET                         12
#define D18F2xA4_CmdThrottleMode_WIDTH                          3
#define D18F2xA4_CmdThrottleMode_MASK                           0x7000
#define D18F2xA4_Reserved_19_15_OFFSET                          15
#define D18F2xA4_Reserved_19_15_WIDTH                           5
#define D18F2xA4_Reserved_19_15_MASK                            0xf8000
#define D18F2xA4_BwCapCmdThrottleMode_OFFSET                    20
#define D18F2xA4_BwCapCmdThrottleMode_WIDTH                     4
#define D18F2xA4_BwCapCmdThrottleMode_MASK                      0xf00000
#define D18F2xA4_Reserved_31_24_OFFSET                          24
#define D18F2xA4_Reserved_31_24_WIDTH                           8
#define D18F2xA4_Reserved_31_24_MASK                            0xff000000

/// D18F2xA4
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                   ODTSEn:1 ; ///<
    UINT32                                            Reserved_10_9:2 ; ///<
    UINT32                                                  BwCapEn:1 ; ///<
    UINT32                                          CmdThrottleMode:3 ; ///<
    UINT32                                           Reserved_19_15:5 ; ///<
    UINT32                                     BwCapCmdThrottleMode:4 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xA4_STRUCT;

// **** D18F2xA8_dct0 Register Definition ****
// Address
#define D18F2xA8_dct0_ADDRESS                                   0xa8

// Type
#define D18F2xA8_dct0_TYPE                                      TYPE_D18F2_dct0
// Field Data
#define D18F2xA8_dct0_Reserved_1_0_OFFSET                       0
#define D18F2xA8_dct0_Reserved_1_0_WIDTH                        2
#define D18F2xA8_dct0_Reserved_1_0_MASK                         0x3
#define D18F2xA8_dct0_CSTimingMux67_OFFSET                      2
#define D18F2xA8_dct0_CSTimingMux67_WIDTH                       1
#define D18F2xA8_dct0_CSTimingMux67_MASK                        0x4
#define D18F2xA8_dct0_Reserved_3_3_OFFSET                       3
#define D18F2xA8_dct0_Reserved_3_3_WIDTH                        1
#define D18F2xA8_dct0_Reserved_3_3_MASK                         0x8
#define D18F2xA8_dct0_Reserved_4_4_OFFSET                       4
#define D18F2xA8_dct0_Reserved_4_4_WIDTH                        1
#define D18F2xA8_dct0_Reserved_4_4_MASK                         0x10
#define D18F2xA8_dct0_SubMemclkRegDly_OFFSET                    5
#define D18F2xA8_dct0_SubMemclkRegDly_WIDTH                     1
#define D18F2xA8_dct0_SubMemclkRegDly_MASK                      0x20
#define D18F2xA8_dct0_Reserved_7_6_OFFSET                       6
#define D18F2xA8_dct0_Reserved_7_6_WIDTH                        2
#define D18F2xA8_dct0_Reserved_7_6_MASK                         0xc0
#define D18F2xA8_dct0_CtrlWordCS_7_0__OFFSET                    8
#define D18F2xA8_dct0_CtrlWordCS_7_0__WIDTH                     8
#define D18F2xA8_dct0_CtrlWordCS_7_0__MASK                      0xff00
#define D18F2xA8_dct0_MemPhyPllPdMode_OFFSET                    16
#define D18F2xA8_dct0_MemPhyPllPdMode_WIDTH                     2
#define D18F2xA8_dct0_MemPhyPllPdMode_MASK                      0x30000
#define D18F2xA8_dct0_Reserved_19_18_OFFSET                     18
#define D18F2xA8_dct0_Reserved_19_18_WIDTH                      2
#define D18F2xA8_dct0_Reserved_19_18_MASK                       0xc0000
#define D18F2xA8_dct0_BankSwap_OFFSET                           20
#define D18F2xA8_dct0_BankSwap_WIDTH                            1
#define D18F2xA8_dct0_BankSwap_MASK                             0x100000
#define D18F2xA8_dct0_AggrPDEn_OFFSET                           21
#define D18F2xA8_dct0_AggrPDEn_WIDTH                            1
#define D18F2xA8_dct0_AggrPDEn_MASK                             0x200000
#define D18F2xA8_dct0_PrtlChPDEnhEn_OFFSET                      22
#define D18F2xA8_dct0_PrtlChPDEnhEn_WIDTH                       1
#define D18F2xA8_dct0_PrtlChPDEnhEn_MASK                        0x400000
#define D18F2xA8_dct0_Reserved_23_23_OFFSET                     23
#define D18F2xA8_dct0_Reserved_23_23_WIDTH                      1
#define D18F2xA8_dct0_Reserved_23_23_MASK                       0x800000
#define D18F2xA8_dct0_Reserved_25_24_OFFSET                     24
#define D18F2xA8_dct0_Reserved_25_24_WIDTH                      2
#define D18F2xA8_dct0_Reserved_25_24_MASK                       0x3000000
#define D18F2xA8_dct0_CsMux45_OFFSET                            26
#define D18F2xA8_dct0_CsMux45_WIDTH                             1
#define D18F2xA8_dct0_CsMux45_MASK                              0x4000000
#define D18F2xA8_dct0_CsMux67_OFFSET                            27
#define D18F2xA8_dct0_CsMux67_WIDTH                             1
#define D18F2xA8_dct0_CsMux67_MASK                              0x8000000
#define D18F2xA8_dct0_FastSelfRefEntryDis_OFFSET                28
#define D18F2xA8_dct0_FastSelfRefEntryDis_WIDTH                 1
#define D18F2xA8_dct0_FastSelfRefEntryDis_MASK                  0x10000000
#define D18F2xA8_dct0_RefChCmdMgtDis_OFFSET                     29
#define D18F2xA8_dct0_RefChCmdMgtDis_WIDTH                      1
#define D18F2xA8_dct0_RefChCmdMgtDis_MASK                       0x20000000
#define D18F2xA8_dct0_Reserved_30_30_OFFSET                     30
#define D18F2xA8_dct0_Reserved_30_30_WIDTH                      1
#define D18F2xA8_dct0_Reserved_30_30_MASK                       0x40000000
#define D18F2xA8_dct0_PerRankTimingEn_OFFSET                    31
#define D18F2xA8_dct0_PerRankTimingEn_WIDTH                     1
#define D18F2xA8_dct0_PerRankTimingEn_MASK                      0x80000000

/// D18F2xA8_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            CSTimingMux67:1 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          SubMemclkRegDly:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                          CtrlWordCS_7_0_:8 ; ///<
    UINT32                                          MemPhyPllPdMode:2 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                                 BankSwap:1 ; ///<
    UINT32                                                 AggrPDEn:1 ; ///<
    UINT32                                            PrtlChPDEnhEn:1 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                           Reserved_25_24:2 ; ///<
    UINT32                                                  CsMux45:1 ; ///<
    UINT32                                                  CsMux67:1 ; ///<
    UINT32                                      FastSelfRefEntryDis:1 ; ///<
    UINT32                                           RefChCmdMgtDis:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                          PerRankTimingEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xA8_dct0_STRUCT;

// **** D18F2xA8_dct1 Register Definition ****
// Address
#define D18F2xA8_dct1_ADDRESS                                   0xa8

// Type
#define D18F2xA8_dct1_TYPE                                      TYPE_D18F2_dct1
// Field Data
#define D18F2xA8_dct1_Reserved_1_0_OFFSET                       0
#define D18F2xA8_dct1_Reserved_1_0_WIDTH                        2
#define D18F2xA8_dct1_Reserved_1_0_MASK                         0x3
#define D18F2xA8_dct1_CSTimingMux67_OFFSET                      2
#define D18F2xA8_dct1_CSTimingMux67_WIDTH                       1
#define D18F2xA8_dct1_CSTimingMux67_MASK                        0x4
#define D18F2xA8_dct1_Reserved_3_3_OFFSET                       3
#define D18F2xA8_dct1_Reserved_3_3_WIDTH                        1
#define D18F2xA8_dct1_Reserved_3_3_MASK                         0x8
#define D18F2xA8_dct1_Reserved_4_4_OFFSET                       4
#define D18F2xA8_dct1_Reserved_4_4_WIDTH                        1
#define D18F2xA8_dct1_Reserved_4_4_MASK                         0x10
#define D18F2xA8_dct1_SubMemclkRegDly_OFFSET                    5
#define D18F2xA8_dct1_SubMemclkRegDly_WIDTH                     1
#define D18F2xA8_dct1_SubMemclkRegDly_MASK                      0x20
#define D18F2xA8_dct1_Reserved_7_6_OFFSET                       6
#define D18F2xA8_dct1_Reserved_7_6_WIDTH                        2
#define D18F2xA8_dct1_Reserved_7_6_MASK                         0xc0
#define D18F2xA8_dct1_CtrlWordCS_7_0__OFFSET                    8
#define D18F2xA8_dct1_CtrlWordCS_7_0__WIDTH                     8
#define D18F2xA8_dct1_CtrlWordCS_7_0__MASK                      0xff00
#define D18F2xA8_dct1_MemPhyPllPdMode_OFFSET                    16
#define D18F2xA8_dct1_MemPhyPllPdMode_WIDTH                     2
#define D18F2xA8_dct1_MemPhyPllPdMode_MASK                      0x30000
#define D18F2xA8_dct1_Reserved_19_18_OFFSET                     18
#define D18F2xA8_dct1_Reserved_19_18_WIDTH                      2
#define D18F2xA8_dct1_Reserved_19_18_MASK                       0xc0000
#define D18F2xA8_dct1_BankSwap_OFFSET                           20
#define D18F2xA8_dct1_BankSwap_WIDTH                            1
#define D18F2xA8_dct1_BankSwap_MASK                             0x100000
#define D18F2xA8_dct1_AggrPDEn_OFFSET                           21
#define D18F2xA8_dct1_AggrPDEn_WIDTH                            1
#define D18F2xA8_dct1_AggrPDEn_MASK                             0x200000
#define D18F2xA8_dct1_PrtlChPDEnhEn_OFFSET                      22
#define D18F2xA8_dct1_PrtlChPDEnhEn_WIDTH                       1
#define D18F2xA8_dct1_PrtlChPDEnhEn_MASK                        0x400000
#define D18F2xA8_dct1_Reserved_23_23_OFFSET                     23
#define D18F2xA8_dct1_Reserved_23_23_WIDTH                      1
#define D18F2xA8_dct1_Reserved_23_23_MASK                       0x800000
#define D18F2xA8_dct1_Reserved_25_24_OFFSET                     24
#define D18F2xA8_dct1_Reserved_25_24_WIDTH                      2
#define D18F2xA8_dct1_Reserved_25_24_MASK                       0x3000000
#define D18F2xA8_dct1_CsMux45_OFFSET                            26
#define D18F2xA8_dct1_CsMux45_WIDTH                             1
#define D18F2xA8_dct1_CsMux45_MASK                              0x4000000
#define D18F2xA8_dct1_CsMux67_OFFSET                            27
#define D18F2xA8_dct1_CsMux67_WIDTH                             1
#define D18F2xA8_dct1_CsMux67_MASK                              0x8000000
#define D18F2xA8_dct1_FastSelfRefEntryDis_OFFSET                28
#define D18F2xA8_dct1_FastSelfRefEntryDis_WIDTH                 1
#define D18F2xA8_dct1_FastSelfRefEntryDis_MASK                  0x10000000
#define D18F2xA8_dct1_RefChCmdMgtDis_OFFSET                     29
#define D18F2xA8_dct1_RefChCmdMgtDis_WIDTH                      1
#define D18F2xA8_dct1_RefChCmdMgtDis_MASK                       0x20000000
#define D18F2xA8_dct1_Reserved_30_30_OFFSET                     30
#define D18F2xA8_dct1_Reserved_30_30_WIDTH                      1
#define D18F2xA8_dct1_Reserved_30_30_MASK                       0x40000000
#define D18F2xA8_dct1_PerRankTimingEn_OFFSET                    31
#define D18F2xA8_dct1_PerRankTimingEn_WIDTH                     1
#define D18F2xA8_dct1_PerRankTimingEn_MASK                      0x80000000

/// D18F2xA8_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            CSTimingMux67:1 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          SubMemclkRegDly:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                          CtrlWordCS_7_0_:8 ; ///<
    UINT32                                          MemPhyPllPdMode:2 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                                 BankSwap:1 ; ///<
    UINT32                                                 AggrPDEn:1 ; ///<
    UINT32                                            PrtlChPDEnhEn:1 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                           Reserved_25_24:2 ; ///<
    UINT32                                                  CsMux45:1 ; ///<
    UINT32                                                  CsMux67:1 ; ///<
    UINT32                                      FastSelfRefEntryDis:1 ; ///<
    UINT32                                           RefChCmdMgtDis:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                          PerRankTimingEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xA8_dct1_STRUCT;

// **** D18F2xAC Register Definition ****
// Address
#define D18F2xAC_ADDRESS                                        0xac

// Type
#define D18F2xAC_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2xAC_MemTempHot0_OFFSET                             0
#define D18F2xAC_MemTempHot0_WIDTH                              1
#define D18F2xAC_MemTempHot0_MASK                               0x1
#define D18F2xAC_Reserved_1_1_OFFSET                            1
#define D18F2xAC_Reserved_1_1_WIDTH                             1
#define D18F2xAC_Reserved_1_1_MASK                              0x2
#define D18F2xAC_MemTempHot1_OFFSET                             2
#define D18F2xAC_MemTempHot1_WIDTH                              1
#define D18F2xAC_MemTempHot1_MASK                               0x4
#define D18F2xAC_Reserved_31_3_OFFSET                           3
#define D18F2xAC_Reserved_31_3_WIDTH                            29
#define D18F2xAC_Reserved_31_3_MASK                             0xfffffff8

/// D18F2xAC
typedef union {
  struct {                                                              ///<
    UINT32                                              MemTempHot0:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                              MemTempHot1:1 ; ///<
    UINT32                                            Reserved_31_3:29; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xAC_STRUCT;



// **** D18F2xC4 Register Definition ****
// Address











// **** D18F2xF8 Register Definition ****
// Address
#define D18F2xF8_ADDRESS                                        0xf8

// Type
#define D18F2xF8_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2xF8_PwrValue0_OFFSET                               0
#define D18F2xF8_PwrValue0_WIDTH                                8
#define D18F2xF8_PwrValue0_MASK                                 0xff
#define D18F2xF8_PwrValue1_OFFSET                               8
#define D18F2xF8_PwrValue1_WIDTH                                8
#define D18F2xF8_PwrValue1_MASK                                 0xff00
#define D18F2xF8_PwrValue2_OFFSET                               16
#define D18F2xF8_PwrValue2_WIDTH                                8
#define D18F2xF8_PwrValue2_MASK                                 0xff0000
#define D18F2xF8_PwrValue3_OFFSET                               24
#define D18F2xF8_PwrValue3_WIDTH                                8
#define D18F2xF8_PwrValue3_MASK                                 0xff000000

/// D18F2xF8
typedef union {
  struct {                                                              ///<
    UINT32                                                PwrValue0:8 ; ///<
    UINT32                                                PwrValue1:8 ; ///<
    UINT32                                                PwrValue2:8 ; ///<
    UINT32                                                PwrValue3:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xF8_STRUCT;


// **** D18F2x104 Register Definition ****
// Address
#define D18F2x104_ADDRESS                                       0x104

// Type
#define D18F2x104_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x104_PwrValue5_OFFSET                              0
#define D18F2x104_PwrValue5_WIDTH                               8
#define D18F2x104_PwrValue5_MASK                                0xff
#define D18F2x104_PwrValue6_OFFSET                              8
#define D18F2x104_PwrValue6_WIDTH                               8
#define D18F2x104_PwrValue6_MASK                                0xff00
#define D18F2x104_PwrValue7_OFFSET                              16
#define D18F2x104_PwrValue7_WIDTH                               8
#define D18F2x104_PwrValue7_MASK                                0xff0000
#define D18F2x104_Reserved_31_24_OFFSET                         24
#define D18F2x104_Reserved_31_24_WIDTH                          8
#define D18F2x104_Reserved_31_24_MASK                           0xff000000

/// D18F2x104
typedef union {
  struct {                                                              ///<
    UINT32                                                PwrValue5:8 ; ///<
    UINT32                                                PwrValue6:8 ; ///<
    UINT32                                                PwrValue7:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x104_STRUCT;

// **** D18F2x10C Register Definition ****
// Address
#define D18F2x10C_ADDRESS                                       0x10c

// Type
#define D18F2x10C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x10C_IntLvRgnSwapEn_OFFSET                         0
#define D18F2x10C_IntLvRgnSwapEn_WIDTH                          1
#define D18F2x10C_IntLvRgnSwapEn_MASK                           0x1
#define D18F2x10C_Reserved_2_1_OFFSET                           1
#define D18F2x10C_Reserved_2_1_WIDTH                            2
#define D18F2x10C_Reserved_2_1_MASK                             0x6
#define D18F2x10C_IntLvRgnBaseAddr_33_27__OFFSET                3
#define D18F2x10C_IntLvRgnBaseAddr_33_27__WIDTH                 7
#define D18F2x10C_IntLvRgnBaseAddr_33_27__MASK                  0x3f8
#define D18F2x10C_Reserved_10_10_OFFSET                         10
#define D18F2x10C_Reserved_10_10_WIDTH                          1
#define D18F2x10C_Reserved_10_10_MASK                           0x400
#define D18F2x10C_IntLvRgnLmtAddr_33_27__OFFSET                 11
#define D18F2x10C_IntLvRgnLmtAddr_33_27__WIDTH                  7
#define D18F2x10C_IntLvRgnLmtAddr_33_27__MASK                   0x3f800
#define D18F2x10C_Reserved_19_18_OFFSET                         18
#define D18F2x10C_Reserved_19_18_WIDTH                          2
#define D18F2x10C_Reserved_19_18_MASK                           0xc0000
#define D18F2x10C_IntLvRgnSize_33_27__OFFSET                    20
#define D18F2x10C_IntLvRgnSize_33_27__WIDTH                     7
#define D18F2x10C_IntLvRgnSize_33_27__MASK                      0x7f00000
#define D18F2x10C_Reserved_31_27_OFFSET                         27
#define D18F2x10C_Reserved_31_27_WIDTH                          5
#define D18F2x10C_Reserved_31_27_MASK                           0xf8000000

/// D18F2x10C
typedef union {
  struct {                                                              ///<
    UINT32                                           IntLvRgnSwapEn:1 ; ///<
    UINT32                                             Reserved_2_1:2 ; ///<
    UINT32                                  IntLvRgnBaseAddr_33_27_:7 ; ///<
    UINT32                                           Reserved_10_10:1 ; ///<
    UINT32                                   IntLvRgnLmtAddr_33_27_:7 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                      IntLvRgnSize_33_27_:7 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x10C_STRUCT;

// **** D18F2x110 Register Definition ****
// Address
#define D18F2x110_ADDRESS                                       0x110

// Type
#define D18F2x110_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x110_DctSelHiRngEn_OFFSET                          0
#define D18F2x110_DctSelHiRngEn_WIDTH                           1
#define D18F2x110_DctSelHiRngEn_MASK                            0x1
#define D18F2x110_DctSelHi_OFFSET                               1
#define D18F2x110_DctSelHi_WIDTH                                1
#define D18F2x110_DctSelHi_MASK                                 0x2
#define D18F2x110_DctSelIntLvEn_OFFSET                          2
#define D18F2x110_DctSelIntLvEn_WIDTH                           1
#define D18F2x110_DctSelIntLvEn_MASK                            0x4
#define D18F2x110_MemClrInit_OFFSET                             3
#define D18F2x110_MemClrInit_WIDTH                              1
#define D18F2x110_MemClrInit_MASK                               0x8
#define D18F2x110_Reserved_4_4_OFFSET                           4
#define D18F2x110_Reserved_4_4_WIDTH                            1
#define D18F2x110_Reserved_4_4_MASK                             0x10
#define D18F2x110_DctDatIntLv_OFFSET                            5
#define D18F2x110_DctDatIntLv_WIDTH                             1
#define D18F2x110_DctDatIntLv_MASK                              0x20
#define D18F2x110_DctSelIntLvAddr_1_0__OFFSET                   6
#define D18F2x110_DctSelIntLvAddr_1_0__WIDTH                    2
#define D18F2x110_DctSelIntLvAddr_1_0__MASK                     0xc0
#define D18F2x110_DramEnable_OFFSET                             8
#define D18F2x110_DramEnable_WIDTH                              1
#define D18F2x110_DramEnable_MASK                               0x100
#define D18F2x110_MemClrBusy_OFFSET                             9
#define D18F2x110_MemClrBusy_WIDTH                              1
#define D18F2x110_MemClrBusy_MASK                               0x200
#define D18F2x110_MemCleared_OFFSET                             10
#define D18F2x110_MemCleared_WIDTH                              1
#define D18F2x110_MemCleared_MASK                               0x400
#define D18F2x110_DctSelBaseAddr_47_27__OFFSET                  11
#define D18F2x110_DctSelBaseAddr_47_27__WIDTH                   21
#define D18F2x110_DctSelBaseAddr_47_27__MASK                    0xfffff800

/// D18F2x110
typedef union {
  struct {                                                              ///<
    UINT32                                            DctSelHiRngEn:1 ; ///<
    UINT32                                                 DctSelHi:1 ; ///<
    UINT32                                            DctSelIntLvEn:1 ; ///<
    UINT32                                               MemClrInit:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                              DctDatIntLv:1 ; ///<
    UINT32                                     DctSelIntLvAddr_1_0_:2 ; ///<
    UINT32                                               DramEnable:1 ; ///<
    UINT32                                               MemClrBusy:1 ; ///<
    UINT32                                               MemCleared:1 ; ///<
    UINT32                                    DctSelBaseAddr_47_27_:21; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x110_STRUCT;

// **** D18F2x114 Register Definition ****
// Address
#define D18F2x114_ADDRESS                                       0x114

// Type
#define D18F2x114_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x114_Reserved_8_0_OFFSET                           0
#define D18F2x114_Reserved_8_0_WIDTH                            9
#define D18F2x114_Reserved_8_0_MASK                             0x1ff
#define D18F2x114_DctSelIntLvAddr_2__OFFSET                     9
#define D18F2x114_DctSelIntLvAddr_2__WIDTH                      1
#define D18F2x114_DctSelIntLvAddr_2__MASK                       0x200
#define D18F2x114_DctSelBaseOffset_47_26__OFFSET                10
#define D18F2x114_DctSelBaseOffset_47_26__WIDTH                 22
#define D18F2x114_DctSelBaseOffset_47_26__MASK                  0xfffffc00

/// D18F2x114
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_8_0:9 ; ///<
    UINT32                                       DctSelIntLvAddr_2_:1 ; ///<
    UINT32                                  DctSelBaseOffset_47_26_:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x114_STRUCT;

// **** D18F2x118 Register Definition ****
// Address
#define D18F2x118_ADDRESS                                       0x118

// Type
#define D18F2x118_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x118_MctPriCpuRd_OFFSET                            0
#define D18F2x118_MctPriCpuRd_WIDTH                             2
#define D18F2x118_MctPriCpuRd_MASK                              0x3
#define D18F2x118_MctPriCpuWr_OFFSET                            2
#define D18F2x118_MctPriCpuWr_WIDTH                             2
#define D18F2x118_MctPriCpuWr_MASK                              0xc
#define D18F2x118_MctPriIsocRd_OFFSET                           4
#define D18F2x118_MctPriIsocRd_WIDTH                            2
#define D18F2x118_MctPriIsocRd_MASK                             0x30
#define D18F2x118_MctPriIsocWr_OFFSET                           6
#define D18F2x118_MctPriIsocWr_WIDTH                            2
#define D18F2x118_MctPriIsocWr_MASK                             0xc0
#define D18F2x118_MctPriDefault_OFFSET                          8
#define D18F2x118_MctPriDefault_WIDTH                           2
#define D18F2x118_MctPriDefault_MASK                            0x300
#define D18F2x118_MctPriWr_OFFSET                               10
#define D18F2x118_MctPriWr_WIDTH                                2
#define D18F2x118_MctPriWr_MASK                                 0xc00
#define D18F2x118_MctPriIsoc_OFFSET                             12
#define D18F2x118_MctPriIsoc_WIDTH                              2
#define D18F2x118_MctPriIsoc_MASK                               0x3000
#define D18F2x118_MctPriTrace_OFFSET                            14
#define D18F2x118_MctPriTrace_WIDTH                             2
#define D18F2x118_MctPriTrace_MASK                              0xc000
#define D18F2x118_MctPriScrub_OFFSET                            16
#define D18F2x118_MctPriScrub_WIDTH                             2
#define D18F2x118_MctPriScrub_MASK                              0x30000
#define D18F2x118_CC6SaveEn_OFFSET                              18
#define D18F2x118_CC6SaveEn_WIDTH                               1
#define D18F2x118_CC6SaveEn_MASK                                0x40000
#define D18F2x118_LockDramCfg_OFFSET                            19
#define D18F2x118_LockDramCfg_WIDTH                             1
#define D18F2x118_LockDramCfg_MASK                              0x80000
#define D18F2x118_McqMedPriByPassMax_OFFSET                     20
#define D18F2x118_McqMedPriByPassMax_WIDTH                      3
#define D18F2x118_McqMedPriByPassMax_MASK                       0x700000
#define D18F2x118_Reserved_23_23_OFFSET                         23
#define D18F2x118_Reserved_23_23_WIDTH                          1
#define D18F2x118_Reserved_23_23_MASK                           0x800000
#define D18F2x118_McqHiPriByPassMax_OFFSET                      24
#define D18F2x118_McqHiPriByPassMax_WIDTH                       3
#define D18F2x118_McqHiPriByPassMax_MASK                        0x7000000
#define D18F2x118_MctEccDisLatOptEn_OFFSET                      27
#define D18F2x118_MctEccDisLatOptEn_WIDTH                       1
#define D18F2x118_MctEccDisLatOptEn_MASK                        0x8000000
#define D18F2x118_MctVarPriCntLmt_OFFSET                        28
#define D18F2x118_MctVarPriCntLmt_WIDTH                         4
#define D18F2x118_MctVarPriCntLmt_MASK                          0xf0000000

/// D18F2x118
typedef union {
  struct {                                                              ///<
    UINT32                                              MctPriCpuRd:2 ; ///<
    UINT32                                              MctPriCpuWr:2 ; ///<
    UINT32                                             MctPriIsocRd:2 ; ///<
    UINT32                                             MctPriIsocWr:2 ; ///<
    UINT32                                            MctPriDefault:2 ; ///<
    UINT32                                                 MctPriWr:2 ; ///<
    UINT32                                               MctPriIsoc:2 ; ///<
    UINT32                                              MctPriTrace:2 ; ///<
    UINT32                                              MctPriScrub:2 ; ///<
    UINT32                                                CC6SaveEn:1 ; ///<
    UINT32                                              LockDramCfg:1 ; ///<
    UINT32                                       McqMedPriByPassMax:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                        McqHiPriByPassMax:3 ; ///<
    UINT32                                        MctEccDisLatOptEn:1 ; ///<
    UINT32                                          MctVarPriCntLmt:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x118_STRUCT;

// **** D18F2x11C Register Definition ****
// Address
#define D18F2x11C_ADDRESS                                       0x11c

// Type
#define D18F2x11C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x11C_DctWrLimit_OFFSET                             0
#define D18F2x11C_DctWrLimit_WIDTH                              2
#define D18F2x11C_DctWrLimit_MASK                               0x3
#define D18F2x11C_MctWrLimit_OFFSET                             2
#define D18F2x11C_MctWrLimit_WIDTH                              5
#define D18F2x11C_MctWrLimit_MASK                               0x7c
#define D18F2x11C_MctPrefReqLimit_OFFSET                        7
#define D18F2x11C_MctPrefReqLimit_WIDTH                         5
#define D18F2x11C_MctPrefReqLimit_MASK                          0xf80
#define D18F2x11C_PrefCpuDis_OFFSET                             12
#define D18F2x11C_PrefCpuDis_WIDTH                              1
#define D18F2x11C_PrefCpuDis_MASK                               0x1000
#define D18F2x11C_PrefIoDis_OFFSET                              13
#define D18F2x11C_PrefIoDis_WIDTH                               1
#define D18F2x11C_PrefIoDis_MASK                                0x2000
#define D18F2x11C_PrefIoFixStrideEn_OFFSET                      14
#define D18F2x11C_PrefIoFixStrideEn_WIDTH                       1
#define D18F2x11C_PrefIoFixStrideEn_MASK                        0x4000
#define D18F2x11C_PrefFixStrideEn_OFFSET                        15
#define D18F2x11C_PrefFixStrideEn_WIDTH                         1
#define D18F2x11C_PrefFixStrideEn_MASK                          0x8000
#define D18F2x11C_PrefFixDist_OFFSET                            16
#define D18F2x11C_PrefFixDist_WIDTH                             2
#define D18F2x11C_PrefFixDist_MASK                              0x30000
#define D18F2x11C_PrefConfSat_OFFSET                            18
#define D18F2x11C_PrefConfSat_WIDTH                             2
#define D18F2x11C_PrefConfSat_MASK                              0xc0000
#define D18F2x11C_PrefOneConf_OFFSET                            20
#define D18F2x11C_PrefOneConf_WIDTH                             2
#define D18F2x11C_PrefOneConf_MASK                              0x300000
#define D18F2x11C_PrefTwoConf_OFFSET                            22
#define D18F2x11C_PrefTwoConf_WIDTH                             3
#define D18F2x11C_PrefTwoConf_MASK                              0x1c00000
#define D18F2x11C_PrefThreeConf_OFFSET                          25
#define D18F2x11C_PrefThreeConf_WIDTH                           3
#define D18F2x11C_PrefThreeConf_MASK                            0xe000000
#define D18F2x11C_PrefDramTrainMode_OFFSET                      28
#define D18F2x11C_PrefDramTrainMode_WIDTH                       1
#define D18F2x11C_PrefDramTrainMode_MASK                        0x10000000
#define D18F2x11C_FlushWrOnStpGnt_OFFSET                        29
#define D18F2x11C_FlushWrOnStpGnt_WIDTH                         1
#define D18F2x11C_FlushWrOnStpGnt_MASK                          0x20000000
#define D18F2x11C_FlushWr_OFFSET                                30
#define D18F2x11C_FlushWr_WIDTH                                 1
#define D18F2x11C_FlushWr_MASK                                  0x40000000
#define D18F2x11C_Reserved_31_31_OFFSET                         31
#define D18F2x11C_Reserved_31_31_WIDTH                          1
#define D18F2x11C_Reserved_31_31_MASK                           0x80000000

/// D18F2x11C
typedef union {
  struct {                                                              ///<
    UINT32                                               DctWrLimit:2 ; ///<
    UINT32                                               MctWrLimit:5 ; ///<
    UINT32                                          MctPrefReqLimit:5 ; ///<
    UINT32                                               PrefCpuDis:1 ; ///<
    UINT32                                                PrefIoDis:1 ; ///<
    UINT32                                        PrefIoFixStrideEn:1 ; ///<
    UINT32                                          PrefFixStrideEn:1 ; ///<
    UINT32                                              PrefFixDist:2 ; ///<
    UINT32                                              PrefConfSat:2 ; ///<
    UINT32                                              PrefOneConf:2 ; ///<
    UINT32                                              PrefTwoConf:3 ; ///<
    UINT32                                            PrefThreeConf:3 ; ///<
    UINT32                                        PrefDramTrainMode:1 ; ///<
    UINT32                                          FlushWrOnStpGnt:1 ; ///<
    UINT32                                                  FlushWr:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x11C_STRUCT;






// **** D18F2x1B0 Register Definition ****
// Address
#define D18F2x1B0_ADDRESS                                       0x1b0

// Type
#define D18F2x1B0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1B0_AdapPrefMissRatio_OFFSET                      0
#define D18F2x1B0_AdapPrefMissRatio_WIDTH                       2
#define D18F2x1B0_AdapPrefMissRatio_MASK                        0x3
#define D18F2x1B0_AdapPrefPositiveStep_OFFSET                   2
#define D18F2x1B0_AdapPrefPositiveStep_WIDTH                    2
#define D18F2x1B0_AdapPrefPositiveStep_MASK                     0xc
#define D18F2x1B0_AdapPrefNegativeStep_OFFSET                   4
#define D18F2x1B0_AdapPrefNegativeStep_WIDTH                    2
#define D18F2x1B0_AdapPrefNegativeStep_MASK                     0x30
#define D18F2x1B0_Reserved_7_6_OFFSET                           6
#define D18F2x1B0_Reserved_7_6_WIDTH                            2
#define D18F2x1B0_Reserved_7_6_MASK                             0xc0
#define D18F2x1B0_CohPrefPrbLmt_OFFSET                          8
#define D18F2x1B0_CohPrefPrbLmt_WIDTH                           3
#define D18F2x1B0_CohPrefPrbLmt_MASK                            0x700
#define D18F2x1B0_DisIoCohPref_OFFSET                           11
#define D18F2x1B0_DisIoCohPref_WIDTH                            1
#define D18F2x1B0_DisIoCohPref_MASK                             0x800
#define D18F2x1B0_EnSplitDctLimits_OFFSET                       12
#define D18F2x1B0_EnSplitDctLimits_WIDTH                        1
#define D18F2x1B0_EnSplitDctLimits_MASK                         0x1000
#define D18F2x1B0_Reserved_17_13_OFFSET                         13
#define D18F2x1B0_Reserved_17_13_WIDTH                          5
#define D18F2x1B0_Reserved_17_13_MASK                           0x3e000
#define D18F2x1B0_Reserved_19_18_OFFSET                         18
#define D18F2x1B0_Reserved_19_18_WIDTH                          2
#define D18F2x1B0_Reserved_19_18_MASK                           0xc0000
#define D18F2x1B0_DblPrefEn_OFFSET                              20
#define D18F2x1B0_DblPrefEn_WIDTH                               1
#define D18F2x1B0_DblPrefEn_MASK                                0x100000
#define D18F2x1B0_Reserved_21_21_OFFSET                         21
#define D18F2x1B0_Reserved_21_21_WIDTH                          1
#define D18F2x1B0_Reserved_21_21_MASK                           0x200000
#define D18F2x1B0_PrefFourConf_OFFSET                           22
#define D18F2x1B0_PrefFourConf_WIDTH                            3
#define D18F2x1B0_PrefFourConf_MASK                             0x1c00000
#define D18F2x1B0_PrefFiveConf_OFFSET                           25
#define D18F2x1B0_PrefFiveConf_WIDTH                            3
#define D18F2x1B0_PrefFiveConf_MASK                             0xe000000
#define D18F2x1B0_DcqBwThrotWm_OFFSET                           28
#define D18F2x1B0_DcqBwThrotWm_WIDTH                            4
#define D18F2x1B0_DcqBwThrotWm_MASK                             0xf0000000

/// D18F2x1B0
typedef union {
  struct {                                                              ///<
    UINT32                                        AdapPrefMissRatio:2 ; ///<
    UINT32                                     AdapPrefPositiveStep:2 ; ///<
    UINT32                                     AdapPrefNegativeStep:2 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                            CohPrefPrbLmt:3 ; ///<
    UINT32                                             DisIoCohPref:1 ; ///<
    UINT32                                         EnSplitDctLimits:1 ; ///<
    UINT32                                           Reserved_17_13:5 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                                DblPrefEn:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                             PrefFourConf:3 ; ///<
    UINT32                                             PrefFiveConf:3 ; ///<
    UINT32                                             DcqBwThrotWm:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1B0_STRUCT;

// **** D18F2x1B4 Register Definition ****
// Address
#define D18F2x1B4_ADDRESS                                       0x1b4

// Type
#define D18F2x1B4_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1B4_DcqBwThrotWm1_OFFSET                          0
#define D18F2x1B4_DcqBwThrotWm1_WIDTH                           5
#define D18F2x1B4_DcqBwThrotWm1_MASK                            0x1f
#define D18F2x1B4_DcqBwThrotWm2_OFFSET                          5
#define D18F2x1B4_DcqBwThrotWm2_WIDTH                           5
#define D18F2x1B4_DcqBwThrotWm2_MASK                            0x3e0
#define D18F2x1B4_DemandPropWm1_OFFSET                          10
#define D18F2x1B4_DemandPropWm1_WIDTH                           1
#define D18F2x1B4_DemandPropWm1_MASK                            0x400
#define D18F2x1B4_DemandAlloWm1_OFFSET                          11
#define D18F2x1B4_DemandAlloWm1_WIDTH                           1
#define D18F2x1B4_DemandAlloWm1_MASK                            0x800
#define D18F2x1B4_StridePropWm1_OFFSET                          12
#define D18F2x1B4_StridePropWm1_WIDTH                           1
#define D18F2x1B4_StridePropWm1_MASK                            0x1000
#define D18F2x1B4_StrideAlloWm1_OFFSET                          13
#define D18F2x1B4_StrideAlloWm1_WIDTH                           1
#define D18F2x1B4_StrideAlloWm1_MASK                            0x2000
#define D18F2x1B4_RegionPropWm1_OFFSET                          14
#define D18F2x1B4_RegionPropWm1_WIDTH                           1
#define D18F2x1B4_RegionPropWm1_MASK                            0x4000
#define D18F2x1B4_RegionAlloWm1_OFFSET                          15
#define D18F2x1B4_RegionAlloWm1_WIDTH                           1
#define D18F2x1B4_RegionAlloWm1_MASK                            0x8000
#define D18F2x1B4_DemandPropWm2_OFFSET                          16
#define D18F2x1B4_DemandPropWm2_WIDTH                           1
#define D18F2x1B4_DemandPropWm2_MASK                            0x10000
#define D18F2x1B4_DemandAlloWm2_OFFSET                          17
#define D18F2x1B4_DemandAlloWm2_WIDTH                           1
#define D18F2x1B4_DemandAlloWm2_MASK                            0x20000
#define D18F2x1B4_StridePropWm2_OFFSET                          18
#define D18F2x1B4_StridePropWm2_WIDTH                           1
#define D18F2x1B4_StridePropWm2_MASK                            0x40000
#define D18F2x1B4_StrideAlloWm2_OFFSET                          19
#define D18F2x1B4_StrideAlloWm2_WIDTH                           1
#define D18F2x1B4_StrideAlloWm2_MASK                            0x80000
#define D18F2x1B4_RegionPropWm2_OFFSET                          20
#define D18F2x1B4_RegionPropWm2_WIDTH                           1
#define D18F2x1B4_RegionPropWm2_MASK                            0x100000
#define D18F2x1B4_RegionAlloWm2_OFFSET                          21
#define D18F2x1B4_RegionAlloWm2_WIDTH                           1
#define D18F2x1B4_RegionAlloWm2_MASK                            0x200000
#define D18F2x1B4_SpecPrefDisWm1_OFFSET                         22
#define D18F2x1B4_SpecPrefDisWm1_WIDTH                          1
#define D18F2x1B4_SpecPrefDisWm1_MASK                           0x400000
#define D18F2x1B4_Reserved_25_23_OFFSET                         23
#define D18F2x1B4_Reserved_25_23_WIDTH                          3
#define D18F2x1B4_Reserved_25_23_MASK                           0x3800000
#define D18F2x1B4_EnSplitMctDatBuffers_OFFSET                   26
#define D18F2x1B4_EnSplitMctDatBuffers_WIDTH                    1
#define D18F2x1B4_EnSplitMctDatBuffers_MASK                     0x4000000
#define D18F2x1B4_FlushWrOnS3StpGnt_OFFSET                      27
#define D18F2x1B4_FlushWrOnS3StpGnt_WIDTH                       1
#define D18F2x1B4_FlushWrOnS3StpGnt_MASK                        0x8000000
#define D18F2x1B4_S3SmafId_OFFSET                               28
#define D18F2x1B4_S3SmafId_WIDTH                                3
#define D18F2x1B4_S3SmafId_MASK                                 0x70000000
#define D18F2x1B4_FlushOnMmioWrEn_OFFSET                        31
#define D18F2x1B4_FlushOnMmioWrEn_WIDTH                         1
#define D18F2x1B4_FlushOnMmioWrEn_MASK                          0x80000000

/// D18F2x1B4
typedef union {
  struct {                                                              ///<
    UINT32                                            DcqBwThrotWm1:5 ; ///<
    UINT32                                            DcqBwThrotWm2:5 ; ///<
    UINT32                                            DemandPropWm1:1 ; ///<
    UINT32                                            DemandAlloWm1:1 ; ///<
    UINT32                                            StridePropWm1:1 ; ///<
    UINT32                                            StrideAlloWm1:1 ; ///<
    UINT32                                            RegionPropWm1:1 ; ///<
    UINT32                                            RegionAlloWm1:1 ; ///<
    UINT32                                            DemandPropWm2:1 ; ///<
    UINT32                                            DemandAlloWm2:1 ; ///<
    UINT32                                            StridePropWm2:1 ; ///<
    UINT32                                            StrideAlloWm2:1 ; ///<
    UINT32                                            RegionPropWm2:1 ; ///<
    UINT32                                            RegionAlloWm2:1 ; ///<
    UINT32                                           SpecPrefDisWm1:1 ; ///<
    UINT32                                           Reserved_25_23:3 ; ///<
    UINT32                                     EnSplitMctDatBuffers:1 ; ///<
    UINT32                                        FlushWrOnS3StpGnt:1 ; ///<
    UINT32                                                 S3SmafId:3 ; ///<
    UINT32                                          FlushOnMmioWrEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1B4_STRUCT;

// **** D18F2x200_dct0_mp1 Register Definition ****
// Address
#define D18F2x200_dct0_mp1_ADDRESS                              0x200

// Type
#define D18F2x200_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x200_dct0_mp1_Tcl_OFFSET                           0
#define D18F2x200_dct0_mp1_Tcl_WIDTH                            5
#define D18F2x200_dct0_mp1_Tcl_MASK                             0x1f
#define D18F2x200_dct0_mp1_Reserved_7_5_OFFSET                  5
#define D18F2x200_dct0_mp1_Reserved_7_5_WIDTH                   3
#define D18F2x200_dct0_mp1_Reserved_7_5_MASK                    0xe0
#define D18F2x200_dct0_mp1_Trcd_OFFSET                          8
#define D18F2x200_dct0_mp1_Trcd_WIDTH                           5
#define D18F2x200_dct0_mp1_Trcd_MASK                            0x1f00
#define D18F2x200_dct0_mp1_Reserved_15_13_OFFSET                13
#define D18F2x200_dct0_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x200_dct0_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x200_dct0_mp1_Trp_OFFSET                           16
#define D18F2x200_dct0_mp1_Trp_WIDTH                            5
#define D18F2x200_dct0_mp1_Trp_MASK                             0x1f0000
#define D18F2x200_dct0_mp1_Reserved_23_21_OFFSET                21
#define D18F2x200_dct0_mp1_Reserved_23_21_WIDTH                 3
#define D18F2x200_dct0_mp1_Reserved_23_21_MASK                  0xe00000
#define D18F2x200_dct0_mp1_Tras_OFFSET                          24
#define D18F2x200_dct0_mp1_Tras_WIDTH                           6
#define D18F2x200_dct0_mp1_Tras_MASK                            0x3f000000
#define D18F2x200_dct0_mp1_Reserved_31_30_OFFSET                30
#define D18F2x200_dct0_mp1_Reserved_31_30_WIDTH                 2
#define D18F2x200_dct0_mp1_Reserved_31_30_MASK                  0xc0000000

/// D18F2x200_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Trcd:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                      Trp:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                                     Tras:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x200_dct0_mp1_STRUCT;

// **** D18F2x200_dct0_mp0 Register Definition ****
// Address
#define D18F2x200_dct0_mp0_ADDRESS                              0x200

// Type
#define D18F2x200_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x200_dct0_mp0_Tcl_OFFSET                           0
#define D18F2x200_dct0_mp0_Tcl_WIDTH                            5
#define D18F2x200_dct0_mp0_Tcl_MASK                             0x1f
#define D18F2x200_dct0_mp0_Reserved_7_5_OFFSET                  5
#define D18F2x200_dct0_mp0_Reserved_7_5_WIDTH                   3
#define D18F2x200_dct0_mp0_Reserved_7_5_MASK                    0xe0
#define D18F2x200_dct0_mp0_Trcd_OFFSET                          8
#define D18F2x200_dct0_mp0_Trcd_WIDTH                           5
#define D18F2x200_dct0_mp0_Trcd_MASK                            0x1f00
#define D18F2x200_dct0_mp0_Reserved_15_13_OFFSET                13
#define D18F2x200_dct0_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x200_dct0_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x200_dct0_mp0_Trp_OFFSET                           16
#define D18F2x200_dct0_mp0_Trp_WIDTH                            5
#define D18F2x200_dct0_mp0_Trp_MASK                             0x1f0000
#define D18F2x200_dct0_mp0_Reserved_23_21_OFFSET                21
#define D18F2x200_dct0_mp0_Reserved_23_21_WIDTH                 3
#define D18F2x200_dct0_mp0_Reserved_23_21_MASK                  0xe00000
#define D18F2x200_dct0_mp0_Tras_OFFSET                          24
#define D18F2x200_dct0_mp0_Tras_WIDTH                           6
#define D18F2x200_dct0_mp0_Tras_MASK                            0x3f000000
#define D18F2x200_dct0_mp0_Reserved_31_30_OFFSET                30
#define D18F2x200_dct0_mp0_Reserved_31_30_WIDTH                 2
#define D18F2x200_dct0_mp0_Reserved_31_30_MASK                  0xc0000000

/// D18F2x200_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Trcd:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                      Trp:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                                     Tras:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x200_dct0_mp0_STRUCT;

// **** D18F2x200_dct1_mp1 Register Definition ****
// Address
#define D18F2x200_dct1_mp1_ADDRESS                              0x200

// Type
#define D18F2x200_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x200_dct1_mp1_Tcl_OFFSET                           0
#define D18F2x200_dct1_mp1_Tcl_WIDTH                            5
#define D18F2x200_dct1_mp1_Tcl_MASK                             0x1f
#define D18F2x200_dct1_mp1_Reserved_7_5_OFFSET                  5
#define D18F2x200_dct1_mp1_Reserved_7_5_WIDTH                   3
#define D18F2x200_dct1_mp1_Reserved_7_5_MASK                    0xe0
#define D18F2x200_dct1_mp1_Trcd_OFFSET                          8
#define D18F2x200_dct1_mp1_Trcd_WIDTH                           5
#define D18F2x200_dct1_mp1_Trcd_MASK                            0x1f00
#define D18F2x200_dct1_mp1_Reserved_15_13_OFFSET                13
#define D18F2x200_dct1_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x200_dct1_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x200_dct1_mp1_Trp_OFFSET                           16
#define D18F2x200_dct1_mp1_Trp_WIDTH                            5
#define D18F2x200_dct1_mp1_Trp_MASK                             0x1f0000
#define D18F2x200_dct1_mp1_Reserved_23_21_OFFSET                21
#define D18F2x200_dct1_mp1_Reserved_23_21_WIDTH                 3
#define D18F2x200_dct1_mp1_Reserved_23_21_MASK                  0xe00000
#define D18F2x200_dct1_mp1_Tras_OFFSET                          24
#define D18F2x200_dct1_mp1_Tras_WIDTH                           6
#define D18F2x200_dct1_mp1_Tras_MASK                            0x3f000000
#define D18F2x200_dct1_mp1_Reserved_31_30_OFFSET                30
#define D18F2x200_dct1_mp1_Reserved_31_30_WIDTH                 2
#define D18F2x200_dct1_mp1_Reserved_31_30_MASK                  0xc0000000

/// D18F2x200_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Trcd:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                      Trp:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                                     Tras:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x200_dct1_mp1_STRUCT;

// **** D18F2x200_dct1_mp0 Register Definition ****
// Address
#define D18F2x200_dct1_mp0_ADDRESS                              0x200

// Type
#define D18F2x200_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x200_dct1_mp0_Tcl_OFFSET                           0
#define D18F2x200_dct1_mp0_Tcl_WIDTH                            5
#define D18F2x200_dct1_mp0_Tcl_MASK                             0x1f
#define D18F2x200_dct1_mp0_Reserved_7_5_OFFSET                  5
#define D18F2x200_dct1_mp0_Reserved_7_5_WIDTH                   3
#define D18F2x200_dct1_mp0_Reserved_7_5_MASK                    0xe0
#define D18F2x200_dct1_mp0_Trcd_OFFSET                          8
#define D18F2x200_dct1_mp0_Trcd_WIDTH                           5
#define D18F2x200_dct1_mp0_Trcd_MASK                            0x1f00
#define D18F2x200_dct1_mp0_Reserved_15_13_OFFSET                13
#define D18F2x200_dct1_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x200_dct1_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x200_dct1_mp0_Trp_OFFSET                           16
#define D18F2x200_dct1_mp0_Trp_WIDTH                            5
#define D18F2x200_dct1_mp0_Trp_MASK                             0x1f0000
#define D18F2x200_dct1_mp0_Reserved_23_21_OFFSET                21
#define D18F2x200_dct1_mp0_Reserved_23_21_WIDTH                 3
#define D18F2x200_dct1_mp0_Reserved_23_21_MASK                  0xe00000
#define D18F2x200_dct1_mp0_Tras_OFFSET                          24
#define D18F2x200_dct1_mp0_Tras_WIDTH                           6
#define D18F2x200_dct1_mp0_Tras_MASK                            0x3f000000
#define D18F2x200_dct1_mp0_Reserved_31_30_OFFSET                30
#define D18F2x200_dct1_mp0_Reserved_31_30_WIDTH                 2
#define D18F2x200_dct1_mp0_Reserved_31_30_MASK                  0xc0000000

/// D18F2x200_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Trcd:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                      Trp:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                                     Tras:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x200_dct1_mp0_STRUCT;

// **** D18F2x204_dct0_mp0 Register Definition ****
// Address
#define D18F2x204_dct0_mp0_ADDRESS                              0x204

// Type
#define D18F2x204_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x204_dct0_mp0_Trc_OFFSET                           0
#define D18F2x204_dct0_mp0_Trc_WIDTH                            6
#define D18F2x204_dct0_mp0_Trc_MASK                             0x3f
#define D18F2x204_dct0_mp0_Reserved_7_6_OFFSET                  6
#define D18F2x204_dct0_mp0_Reserved_7_6_WIDTH                   2
#define D18F2x204_dct0_mp0_Reserved_7_6_MASK                    0xc0
#define D18F2x204_dct0_mp0_Trrd_OFFSET                          8
#define D18F2x204_dct0_mp0_Trrd_WIDTH                           4
#define D18F2x204_dct0_mp0_Trrd_MASK                            0xf00
#define D18F2x204_dct0_mp0_Reserved_15_12_OFFSET                12
#define D18F2x204_dct0_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x204_dct0_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x204_dct0_mp0_FourActWindow_OFFSET                 16
#define D18F2x204_dct0_mp0_FourActWindow_WIDTH                  6
#define D18F2x204_dct0_mp0_FourActWindow_MASK                   0x3f0000
#define D18F2x204_dct0_mp0_Reserved_23_22_OFFSET                22
#define D18F2x204_dct0_mp0_Reserved_23_22_WIDTH                 2
#define D18F2x204_dct0_mp0_Reserved_23_22_MASK                  0xc00000
#define D18F2x204_dct0_mp0_Trtp_OFFSET                          24
#define D18F2x204_dct0_mp0_Trtp_WIDTH                           4
#define D18F2x204_dct0_mp0_Trtp_MASK                            0xf000000
#define D18F2x204_dct0_mp0_Reserved_31_28_OFFSET                28
#define D18F2x204_dct0_mp0_Reserved_31_28_WIDTH                 4
#define D18F2x204_dct0_mp0_Reserved_31_28_MASK                  0xf0000000

/// D18F2x204_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Trc:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                     Trrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                            FourActWindow:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                     Trtp:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x204_dct0_mp0_STRUCT;

// **** D18F2x204_dct1_mp0 Register Definition ****
// Address
#define D18F2x204_dct1_mp0_ADDRESS                              0x204

// Type
#define D18F2x204_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x204_dct1_mp0_Trc_OFFSET                           0
#define D18F2x204_dct1_mp0_Trc_WIDTH                            6
#define D18F2x204_dct1_mp0_Trc_MASK                             0x3f
#define D18F2x204_dct1_mp0_Reserved_7_6_OFFSET                  6
#define D18F2x204_dct1_mp0_Reserved_7_6_WIDTH                   2
#define D18F2x204_dct1_mp0_Reserved_7_6_MASK                    0xc0
#define D18F2x204_dct1_mp0_Trrd_OFFSET                          8
#define D18F2x204_dct1_mp0_Trrd_WIDTH                           4
#define D18F2x204_dct1_mp0_Trrd_MASK                            0xf00
#define D18F2x204_dct1_mp0_Reserved_15_12_OFFSET                12
#define D18F2x204_dct1_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x204_dct1_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x204_dct1_mp0_FourActWindow_OFFSET                 16
#define D18F2x204_dct1_mp0_FourActWindow_WIDTH                  6
#define D18F2x204_dct1_mp0_FourActWindow_MASK                   0x3f0000
#define D18F2x204_dct1_mp0_Reserved_23_22_OFFSET                22
#define D18F2x204_dct1_mp0_Reserved_23_22_WIDTH                 2
#define D18F2x204_dct1_mp0_Reserved_23_22_MASK                  0xc00000
#define D18F2x204_dct1_mp0_Trtp_OFFSET                          24
#define D18F2x204_dct1_mp0_Trtp_WIDTH                           4
#define D18F2x204_dct1_mp0_Trtp_MASK                            0xf000000
#define D18F2x204_dct1_mp0_Reserved_31_28_OFFSET                28
#define D18F2x204_dct1_mp0_Reserved_31_28_WIDTH                 4
#define D18F2x204_dct1_mp0_Reserved_31_28_MASK                  0xf0000000

/// D18F2x204_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Trc:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                     Trrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                            FourActWindow:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                     Trtp:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x204_dct1_mp0_STRUCT;

// **** D18F2x204_dct0_mp1 Register Definition ****
// Address
#define D18F2x204_dct0_mp1_ADDRESS                              0x204

// Type
#define D18F2x204_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x204_dct0_mp1_Trc_OFFSET                           0
#define D18F2x204_dct0_mp1_Trc_WIDTH                            6
#define D18F2x204_dct0_mp1_Trc_MASK                             0x3f
#define D18F2x204_dct0_mp1_Reserved_7_6_OFFSET                  6
#define D18F2x204_dct0_mp1_Reserved_7_6_WIDTH                   2
#define D18F2x204_dct0_mp1_Reserved_7_6_MASK                    0xc0
#define D18F2x204_dct0_mp1_Trrd_OFFSET                          8
#define D18F2x204_dct0_mp1_Trrd_WIDTH                           4
#define D18F2x204_dct0_mp1_Trrd_MASK                            0xf00
#define D18F2x204_dct0_mp1_Reserved_15_12_OFFSET                12
#define D18F2x204_dct0_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x204_dct0_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x204_dct0_mp1_FourActWindow_OFFSET                 16
#define D18F2x204_dct0_mp1_FourActWindow_WIDTH                  6
#define D18F2x204_dct0_mp1_FourActWindow_MASK                   0x3f0000
#define D18F2x204_dct0_mp1_Reserved_23_22_OFFSET                22
#define D18F2x204_dct0_mp1_Reserved_23_22_WIDTH                 2
#define D18F2x204_dct0_mp1_Reserved_23_22_MASK                  0xc00000
#define D18F2x204_dct0_mp1_Trtp_OFFSET                          24
#define D18F2x204_dct0_mp1_Trtp_WIDTH                           4
#define D18F2x204_dct0_mp1_Trtp_MASK                            0xf000000
#define D18F2x204_dct0_mp1_Reserved_31_28_OFFSET                28
#define D18F2x204_dct0_mp1_Reserved_31_28_WIDTH                 4
#define D18F2x204_dct0_mp1_Reserved_31_28_MASK                  0xf0000000

/// D18F2x204_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Trc:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                     Trrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                            FourActWindow:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                     Trtp:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x204_dct0_mp1_STRUCT;

// **** D18F2x204_dct1_mp1 Register Definition ****
// Address
#define D18F2x204_dct1_mp1_ADDRESS                              0x204

// Type
#define D18F2x204_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x204_dct1_mp1_Trc_OFFSET                           0
#define D18F2x204_dct1_mp1_Trc_WIDTH                            6
#define D18F2x204_dct1_mp1_Trc_MASK                             0x3f
#define D18F2x204_dct1_mp1_Reserved_7_6_OFFSET                  6
#define D18F2x204_dct1_mp1_Reserved_7_6_WIDTH                   2
#define D18F2x204_dct1_mp1_Reserved_7_6_MASK                    0xc0
#define D18F2x204_dct1_mp1_Trrd_OFFSET                          8
#define D18F2x204_dct1_mp1_Trrd_WIDTH                           4
#define D18F2x204_dct1_mp1_Trrd_MASK                            0xf00
#define D18F2x204_dct1_mp1_Reserved_15_12_OFFSET                12
#define D18F2x204_dct1_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x204_dct1_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x204_dct1_mp1_FourActWindow_OFFSET                 16
#define D18F2x204_dct1_mp1_FourActWindow_WIDTH                  6
#define D18F2x204_dct1_mp1_FourActWindow_MASK                   0x3f0000
#define D18F2x204_dct1_mp1_Reserved_23_22_OFFSET                22
#define D18F2x204_dct1_mp1_Reserved_23_22_WIDTH                 2
#define D18F2x204_dct1_mp1_Reserved_23_22_MASK                  0xc00000
#define D18F2x204_dct1_mp1_Trtp_OFFSET                          24
#define D18F2x204_dct1_mp1_Trtp_WIDTH                           4
#define D18F2x204_dct1_mp1_Trtp_MASK                            0xf000000
#define D18F2x204_dct1_mp1_Reserved_31_28_OFFSET                28
#define D18F2x204_dct1_mp1_Reserved_31_28_WIDTH                 4
#define D18F2x204_dct1_mp1_Reserved_31_28_MASK                  0xf0000000

/// D18F2x204_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Trc:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                     Trrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                            FourActWindow:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                     Trtp:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x204_dct1_mp1_STRUCT;

// **** D18F2x208_dct0 Register Definition ****
// Address
#define D18F2x208_dct0_ADDRESS                                  0x208

// Type
#define D18F2x208_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x208_dct0_Trfc0_OFFSET                             0
#define D18F2x208_dct0_Trfc0_WIDTH                              3
#define D18F2x208_dct0_Trfc0_MASK                               0x7
#define D18F2x208_dct0_Reserved_7_3_OFFSET                      3
#define D18F2x208_dct0_Reserved_7_3_WIDTH                       5
#define D18F2x208_dct0_Reserved_7_3_MASK                        0xf8
#define D18F2x208_dct0_Trfc1_OFFSET                             8
#define D18F2x208_dct0_Trfc1_WIDTH                              3
#define D18F2x208_dct0_Trfc1_MASK                               0x700
#define D18F2x208_dct0_Reserved_15_11_OFFSET                    11
#define D18F2x208_dct0_Reserved_15_11_WIDTH                     5
#define D18F2x208_dct0_Reserved_15_11_MASK                      0xf800
#define D18F2x208_dct0_Trfc2_OFFSET                             16
#define D18F2x208_dct0_Trfc2_WIDTH                              3
#define D18F2x208_dct0_Trfc2_MASK                               0x70000
#define D18F2x208_dct0_Reserved_23_19_OFFSET                    19
#define D18F2x208_dct0_Reserved_23_19_WIDTH                     5
#define D18F2x208_dct0_Reserved_23_19_MASK                      0xf80000
#define D18F2x208_dct0_Trfc3_OFFSET                             24
#define D18F2x208_dct0_Trfc3_WIDTH                              3
#define D18F2x208_dct0_Trfc3_MASK                               0x7000000
#define D18F2x208_dct0_Reserved_31_27_OFFSET                    27
#define D18F2x208_dct0_Reserved_31_27_WIDTH                     5
#define D18F2x208_dct0_Reserved_31_27_MASK                      0xf8000000

/// D18F2x208_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                    Trfc0:3 ; ///<
    UINT32                                             Reserved_7_3:5 ; ///<
    UINT32                                                    Trfc1:3 ; ///<
    UINT32                                           Reserved_15_11:5 ; ///<
    UINT32                                                    Trfc2:3 ; ///<
    UINT32                                           Reserved_23_19:5 ; ///<
    UINT32                                                    Trfc3:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x208_dct0_STRUCT;

// **** D18F2x208_dct1 Register Definition ****
// Address
#define D18F2x208_dct1_ADDRESS                                  0x208

// Type
#define D18F2x208_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x208_dct1_Trfc0_OFFSET                             0
#define D18F2x208_dct1_Trfc0_WIDTH                              3
#define D18F2x208_dct1_Trfc0_MASK                               0x7
#define D18F2x208_dct1_Reserved_7_3_OFFSET                      3
#define D18F2x208_dct1_Reserved_7_3_WIDTH                       5
#define D18F2x208_dct1_Reserved_7_3_MASK                        0xf8
#define D18F2x208_dct1_Trfc1_OFFSET                             8
#define D18F2x208_dct1_Trfc1_WIDTH                              3
#define D18F2x208_dct1_Trfc1_MASK                               0x700
#define D18F2x208_dct1_Reserved_15_11_OFFSET                    11
#define D18F2x208_dct1_Reserved_15_11_WIDTH                     5
#define D18F2x208_dct1_Reserved_15_11_MASK                      0xf800
#define D18F2x208_dct1_Trfc2_OFFSET                             16
#define D18F2x208_dct1_Trfc2_WIDTH                              3
#define D18F2x208_dct1_Trfc2_MASK                               0x70000
#define D18F2x208_dct1_Reserved_23_19_OFFSET                    19
#define D18F2x208_dct1_Reserved_23_19_WIDTH                     5
#define D18F2x208_dct1_Reserved_23_19_MASK                      0xf80000
#define D18F2x208_dct1_Trfc3_OFFSET                             24
#define D18F2x208_dct1_Trfc3_WIDTH                              3
#define D18F2x208_dct1_Trfc3_MASK                               0x7000000
#define D18F2x208_dct1_Reserved_31_27_OFFSET                    27
#define D18F2x208_dct1_Reserved_31_27_WIDTH                     5
#define D18F2x208_dct1_Reserved_31_27_MASK                      0xf8000000

/// D18F2x208_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                    Trfc0:3 ; ///<
    UINT32                                             Reserved_7_3:5 ; ///<
    UINT32                                                    Trfc1:3 ; ///<
    UINT32                                           Reserved_15_11:5 ; ///<
    UINT32                                                    Trfc2:3 ; ///<
    UINT32                                           Reserved_23_19:5 ; ///<
    UINT32                                                    Trfc3:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x208_dct1_STRUCT;

// **** D18F2x20C_dct0_mp1 Register Definition ****
// Address
#define D18F2x20C_dct0_mp1_ADDRESS                              0x20c

// Type
#define D18F2x20C_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x20C_dct0_mp1_Tcwl_OFFSET                          0
#define D18F2x20C_dct0_mp1_Tcwl_WIDTH                           5
#define D18F2x20C_dct0_mp1_Tcwl_MASK                            0x1f
#define D18F2x20C_dct0_mp1_Reserved_7_5_OFFSET                  5
#define D18F2x20C_dct0_mp1_Reserved_7_5_WIDTH                   3
#define D18F2x20C_dct0_mp1_Reserved_7_5_MASK                    0xe0
#define D18F2x20C_dct0_mp1_Twtr_OFFSET                          8
#define D18F2x20C_dct0_mp1_Twtr_WIDTH                           4
#define D18F2x20C_dct0_mp1_Twtr_MASK                            0xf00
#define D18F2x20C_dct0_mp1_Reserved_15_12_OFFSET                12
#define D18F2x20C_dct0_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x20C_dct0_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x20C_dct0_mp1_WrDqDqsEarly_OFFSET                  16
#define D18F2x20C_dct0_mp1_WrDqDqsEarly_WIDTH                   2
#define D18F2x20C_dct0_mp1_WrDqDqsEarly_MASK                    0x30000
#define D18F2x20C_dct0_mp1_Reserved_31_18_OFFSET                18
#define D18F2x20C_dct0_mp1_Reserved_31_18_WIDTH                 14
#define D18F2x20C_dct0_mp1_Reserved_31_18_MASK                  0xfffc0000

/// D18F2x20C_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tcwl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Twtr:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrDqDqsEarly:2 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x20C_dct0_mp1_STRUCT;

// **** D18F2x20C_dct1_mp1 Register Definition ****
// Address
#define D18F2x20C_dct1_mp1_ADDRESS                              0x20c

// Type
#define D18F2x20C_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x20C_dct1_mp1_Tcwl_OFFSET                          0
#define D18F2x20C_dct1_mp1_Tcwl_WIDTH                           5
#define D18F2x20C_dct1_mp1_Tcwl_MASK                            0x1f
#define D18F2x20C_dct1_mp1_Reserved_7_5_OFFSET                  5
#define D18F2x20C_dct1_mp1_Reserved_7_5_WIDTH                   3
#define D18F2x20C_dct1_mp1_Reserved_7_5_MASK                    0xe0
#define D18F2x20C_dct1_mp1_Twtr_OFFSET                          8
#define D18F2x20C_dct1_mp1_Twtr_WIDTH                           4
#define D18F2x20C_dct1_mp1_Twtr_MASK                            0xf00
#define D18F2x20C_dct1_mp1_Reserved_15_12_OFFSET                12
#define D18F2x20C_dct1_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x20C_dct1_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x20C_dct1_mp1_WrDqDqsEarly_OFFSET                  16
#define D18F2x20C_dct1_mp1_WrDqDqsEarly_WIDTH                   2
#define D18F2x20C_dct1_mp1_WrDqDqsEarly_MASK                    0x30000
#define D18F2x20C_dct1_mp1_Reserved_31_18_OFFSET                18
#define D18F2x20C_dct1_mp1_Reserved_31_18_WIDTH                 14
#define D18F2x20C_dct1_mp1_Reserved_31_18_MASK                  0xfffc0000

/// D18F2x20C_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tcwl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Twtr:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrDqDqsEarly:2 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x20C_dct1_mp1_STRUCT;

// **** D18F2x20C_dct1_mp0 Register Definition ****
// Address
#define D18F2x20C_dct1_mp0_ADDRESS                              0x20c

// Type
#define D18F2x20C_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x20C_dct1_mp0_Tcwl_OFFSET                          0
#define D18F2x20C_dct1_mp0_Tcwl_WIDTH                           5
#define D18F2x20C_dct1_mp0_Tcwl_MASK                            0x1f
#define D18F2x20C_dct1_mp0_Reserved_7_5_OFFSET                  5
#define D18F2x20C_dct1_mp0_Reserved_7_5_WIDTH                   3
#define D18F2x20C_dct1_mp0_Reserved_7_5_MASK                    0xe0
#define D18F2x20C_dct1_mp0_Twtr_OFFSET                          8
#define D18F2x20C_dct1_mp0_Twtr_WIDTH                           4
#define D18F2x20C_dct1_mp0_Twtr_MASK                            0xf00
#define D18F2x20C_dct1_mp0_Reserved_15_12_OFFSET                12
#define D18F2x20C_dct1_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x20C_dct1_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x20C_dct1_mp0_WrDqDqsEarly_OFFSET                  16
#define D18F2x20C_dct1_mp0_WrDqDqsEarly_WIDTH                   2
#define D18F2x20C_dct1_mp0_WrDqDqsEarly_MASK                    0x30000
#define D18F2x20C_dct1_mp0_Reserved_31_18_OFFSET                18
#define D18F2x20C_dct1_mp0_Reserved_31_18_WIDTH                 14
#define D18F2x20C_dct1_mp0_Reserved_31_18_MASK                  0xfffc0000

/// D18F2x20C_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tcwl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Twtr:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrDqDqsEarly:2 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x20C_dct1_mp0_STRUCT;

// **** D18F2x20C_dct0_mp0 Register Definition ****
// Address
#define D18F2x20C_dct0_mp0_ADDRESS                              0x20c

// Type
#define D18F2x20C_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x20C_dct0_mp0_Tcwl_OFFSET                          0
#define D18F2x20C_dct0_mp0_Tcwl_WIDTH                           5
#define D18F2x20C_dct0_mp0_Tcwl_MASK                            0x1f
#define D18F2x20C_dct0_mp0_Reserved_7_5_OFFSET                  5
#define D18F2x20C_dct0_mp0_Reserved_7_5_WIDTH                   3
#define D18F2x20C_dct0_mp0_Reserved_7_5_MASK                    0xe0
#define D18F2x20C_dct0_mp0_Twtr_OFFSET                          8
#define D18F2x20C_dct0_mp0_Twtr_WIDTH                           4
#define D18F2x20C_dct0_mp0_Twtr_MASK                            0xf00
#define D18F2x20C_dct0_mp0_Reserved_15_12_OFFSET                12
#define D18F2x20C_dct0_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x20C_dct0_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x20C_dct0_mp0_WrDqDqsEarly_OFFSET                  16
#define D18F2x20C_dct0_mp0_WrDqDqsEarly_WIDTH                   2
#define D18F2x20C_dct0_mp0_WrDqDqsEarly_MASK                    0x30000
#define D18F2x20C_dct0_mp0_Reserved_31_18_OFFSET                18
#define D18F2x20C_dct0_mp0_Reserved_31_18_WIDTH                 14
#define D18F2x20C_dct0_mp0_Reserved_31_18_MASK                  0xfffc0000

/// D18F2x20C_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tcwl:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                     Twtr:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrDqDqsEarly:2 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x20C_dct0_mp0_STRUCT;

// **** D18F2x210_dct1_nbp0 Register Definition ****
// Address
#define D18F2x210_dct1_nbp0_ADDRESS                             0x210

// Type
#define D18F2x210_dct1_nbp0_TYPE                                TYPE_D18F2_dct1
// Field Data
#define D18F2x210_dct1_nbp0_RdPtrInit_OFFSET                    0
#define D18F2x210_dct1_nbp0_RdPtrInit_WIDTH                     4
#define D18F2x210_dct1_nbp0_RdPtrInit_MASK                      0xf
#define D18F2x210_dct1_nbp0_Reserved_15_4_OFFSET                4
#define D18F2x210_dct1_nbp0_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct1_nbp0_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct1_nbp0_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct1_nbp0_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct1_nbp0_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct1_nbp0_Reserved_21_19_OFFSET               19
#define D18F2x210_dct1_nbp0_Reserved_21_19_WIDTH                3
#define D18F2x210_dct1_nbp0_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct1_nbp0_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct1_nbp0_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct1_nbp0_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct1_nbp0
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct1_nbp0_STRUCT;

// **** D18F2x210_dct0_nbp2 Register Definition ****
// Address
#define D18F2x210_dct0_nbp2_ADDRESS                             0x210

// Type
#define D18F2x210_dct0_nbp2_TYPE                                TYPE_D18F2_dct0
// Field Data
#define D18F2x210_dct0_nbp2_RdPtrInit_OFFSET                    0
#define D18F2x210_dct0_nbp2_RdPtrInit_WIDTH                     4
#define D18F2x210_dct0_nbp2_RdPtrInit_MASK                      0xf
#define D18F2x210_dct0_nbp2_Reserved_15_4_OFFSET                4
#define D18F2x210_dct0_nbp2_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct0_nbp2_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct0_nbp2_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct0_nbp2_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct0_nbp2_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct0_nbp2_Reserved_21_19_OFFSET               19
#define D18F2x210_dct0_nbp2_Reserved_21_19_WIDTH                3
#define D18F2x210_dct0_nbp2_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct0_nbp2_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct0_nbp2_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct0_nbp2_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct0_nbp2
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct0_nbp2_STRUCT;

// **** D18F2x210_dct1_nbp1 Register Definition ****
// Address
#define D18F2x210_dct1_nbp1_ADDRESS                             0x210

// Type
#define D18F2x210_dct1_nbp1_TYPE                                TYPE_D18F2_dct1
// Field Data
#define D18F2x210_dct1_nbp1_RdPtrInit_OFFSET                    0
#define D18F2x210_dct1_nbp1_RdPtrInit_WIDTH                     4
#define D18F2x210_dct1_nbp1_RdPtrInit_MASK                      0xf
#define D18F2x210_dct1_nbp1_Reserved_15_4_OFFSET                4
#define D18F2x210_dct1_nbp1_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct1_nbp1_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct1_nbp1_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct1_nbp1_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct1_nbp1_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct1_nbp1_Reserved_21_19_OFFSET               19
#define D18F2x210_dct1_nbp1_Reserved_21_19_WIDTH                3
#define D18F2x210_dct1_nbp1_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct1_nbp1_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct1_nbp1_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct1_nbp1_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct1_nbp1
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct1_nbp1_STRUCT;

// **** D18F2x210_dct1_nbp3 Register Definition ****
// Address
#define D18F2x210_dct1_nbp3_ADDRESS                             0x210

// Type
#define D18F2x210_dct1_nbp3_TYPE                                TYPE_D18F2_dct1
// Field Data
#define D18F2x210_dct1_nbp3_RdPtrInit_OFFSET                    0
#define D18F2x210_dct1_nbp3_RdPtrInit_WIDTH                     4
#define D18F2x210_dct1_nbp3_RdPtrInit_MASK                      0xf
#define D18F2x210_dct1_nbp3_Reserved_15_4_OFFSET                4
#define D18F2x210_dct1_nbp3_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct1_nbp3_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct1_nbp3_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct1_nbp3_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct1_nbp3_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct1_nbp3_Reserved_21_19_OFFSET               19
#define D18F2x210_dct1_nbp3_Reserved_21_19_WIDTH                3
#define D18F2x210_dct1_nbp3_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct1_nbp3_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct1_nbp3_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct1_nbp3_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct1_nbp3
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct1_nbp3_STRUCT;

// **** D18F2x210_dct0_nbp0 Register Definition ****
// Address
#define D18F2x210_dct0_nbp0_ADDRESS                             0x210

// Type
#define D18F2x210_dct0_nbp0_TYPE                                TYPE_D18F2_dct0
// Field Data
#define D18F2x210_dct0_nbp0_RdPtrInit_OFFSET                    0
#define D18F2x210_dct0_nbp0_RdPtrInit_WIDTH                     4
#define D18F2x210_dct0_nbp0_RdPtrInit_MASK                      0xf
#define D18F2x210_dct0_nbp0_Reserved_15_4_OFFSET                4
#define D18F2x210_dct0_nbp0_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct0_nbp0_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct0_nbp0_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct0_nbp0_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct0_nbp0_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct0_nbp0_Reserved_21_19_OFFSET               19
#define D18F2x210_dct0_nbp0_Reserved_21_19_WIDTH                3
#define D18F2x210_dct0_nbp0_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct0_nbp0_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct0_nbp0_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct0_nbp0_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct0_nbp0
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct0_nbp0_STRUCT;

// **** D18F2x210_dct0_nbp3 Register Definition ****
// Address
#define D18F2x210_dct0_nbp3_ADDRESS                             0x210

// Type
#define D18F2x210_dct0_nbp3_TYPE                                TYPE_D18F2_dct0
// Field Data
#define D18F2x210_dct0_nbp3_RdPtrInit_OFFSET                    0
#define D18F2x210_dct0_nbp3_RdPtrInit_WIDTH                     4
#define D18F2x210_dct0_nbp3_RdPtrInit_MASK                      0xf
#define D18F2x210_dct0_nbp3_Reserved_15_4_OFFSET                4
#define D18F2x210_dct0_nbp3_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct0_nbp3_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct0_nbp3_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct0_nbp3_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct0_nbp3_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct0_nbp3_Reserved_21_19_OFFSET               19
#define D18F2x210_dct0_nbp3_Reserved_21_19_WIDTH                3
#define D18F2x210_dct0_nbp3_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct0_nbp3_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct0_nbp3_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct0_nbp3_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct0_nbp3
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct0_nbp3_STRUCT;

// **** D18F2x210_dct1_nbp2 Register Definition ****
// Address
#define D18F2x210_dct1_nbp2_ADDRESS                             0x210

// Type
#define D18F2x210_dct1_nbp2_TYPE                                TYPE_D18F2_dct1
// Field Data
#define D18F2x210_dct1_nbp2_RdPtrInit_OFFSET                    0
#define D18F2x210_dct1_nbp2_RdPtrInit_WIDTH                     4
#define D18F2x210_dct1_nbp2_RdPtrInit_MASK                      0xf
#define D18F2x210_dct1_nbp2_Reserved_15_4_OFFSET                4
#define D18F2x210_dct1_nbp2_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct1_nbp2_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct1_nbp2_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct1_nbp2_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct1_nbp2_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct1_nbp2_Reserved_21_19_OFFSET               19
#define D18F2x210_dct1_nbp2_Reserved_21_19_WIDTH                3
#define D18F2x210_dct1_nbp2_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct1_nbp2_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct1_nbp2_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct1_nbp2_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct1_nbp2
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct1_nbp2_STRUCT;

// **** D18F2x210_dct0_nbp1 Register Definition ****
// Address
#define D18F2x210_dct0_nbp1_ADDRESS                             0x210

// Type
#define D18F2x210_dct0_nbp1_TYPE                                TYPE_D18F2_dct0
// Field Data
#define D18F2x210_dct0_nbp1_RdPtrInit_OFFSET                    0
#define D18F2x210_dct0_nbp1_RdPtrInit_WIDTH                     4
#define D18F2x210_dct0_nbp1_RdPtrInit_MASK                      0xf
#define D18F2x210_dct0_nbp1_Reserved_15_4_OFFSET                4
#define D18F2x210_dct0_nbp1_Reserved_15_4_WIDTH                 12
#define D18F2x210_dct0_nbp1_Reserved_15_4_MASK                  0xfff0
#define D18F2x210_dct0_nbp1_DataTxFifoWrDly_OFFSET              16
#define D18F2x210_dct0_nbp1_DataTxFifoWrDly_WIDTH               3
#define D18F2x210_dct0_nbp1_DataTxFifoWrDly_MASK                0x70000
#define D18F2x210_dct0_nbp1_Reserved_21_19_OFFSET               19
#define D18F2x210_dct0_nbp1_Reserved_21_19_WIDTH                3
#define D18F2x210_dct0_nbp1_Reserved_21_19_MASK                 0x380000
#define D18F2x210_dct0_nbp1_MaxRdLatency_OFFSET                 22
#define D18F2x210_dct0_nbp1_MaxRdLatency_WIDTH                  10
#define D18F2x210_dct0_nbp1_MaxRdLatency_MASK                   0xffc00000

/// D18F2x210_dct0_nbp1
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                          DataTxFifoWrDly:3 ; ///<
    UINT32                                           Reserved_21_19:3 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x210_dct0_nbp1_STRUCT;

// **** D18F2x214_dct1_mp1 Register Definition ****
// Address
#define D18F2x214_dct1_mp1_ADDRESS                              0x214

// Type
#define D18F2x214_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x214_dct1_mp1_TwrwrDd_OFFSET                       0
#define D18F2x214_dct1_mp1_TwrwrDd_WIDTH                        4
#define D18F2x214_dct1_mp1_TwrwrDd_MASK                         0xf
#define D18F2x214_dct1_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x214_dct1_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x214_dct1_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x214_dct1_mp1_TwrwrSdDc_OFFSET                     8
#define D18F2x214_dct1_mp1_TwrwrSdDc_WIDTH                      4
#define D18F2x214_dct1_mp1_TwrwrSdDc_MASK                       0xf00
#define D18F2x214_dct1_mp1_Reserved_15_12_OFFSET                12
#define D18F2x214_dct1_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x214_dct1_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x214_dct1_mp1_TwrwrSdSc_OFFSET                     16
#define D18F2x214_dct1_mp1_TwrwrSdSc_WIDTH                      4
#define D18F2x214_dct1_mp1_TwrwrSdSc_MASK                       0xf0000
#define D18F2x214_dct1_mp1_Reserved_31_20_OFFSET                20
#define D18F2x214_dct1_mp1_Reserved_31_20_WIDTH                 12
#define D18F2x214_dct1_mp1_Reserved_31_20_MASK                  0xfff00000

/// D18F2x214_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                  TwrwrDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                TwrwrSdDc:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TwrwrSdSc:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x214_dct1_mp1_STRUCT;

// **** D18F2x214_dct0_mp0 Register Definition ****
// Address
#define D18F2x214_dct0_mp0_ADDRESS                              0x214

// Type
#define D18F2x214_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x214_dct0_mp0_TwrwrDd_OFFSET                       0
#define D18F2x214_dct0_mp0_TwrwrDd_WIDTH                        4
#define D18F2x214_dct0_mp0_TwrwrDd_MASK                         0xf
#define D18F2x214_dct0_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x214_dct0_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x214_dct0_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x214_dct0_mp0_TwrwrSdDc_OFFSET                     8
#define D18F2x214_dct0_mp0_TwrwrSdDc_WIDTH                      4
#define D18F2x214_dct0_mp0_TwrwrSdDc_MASK                       0xf00
#define D18F2x214_dct0_mp0_Reserved_15_12_OFFSET                12
#define D18F2x214_dct0_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x214_dct0_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x214_dct0_mp0_TwrwrSdSc_OFFSET                     16
#define D18F2x214_dct0_mp0_TwrwrSdSc_WIDTH                      4
#define D18F2x214_dct0_mp0_TwrwrSdSc_MASK                       0xf0000
#define D18F2x214_dct0_mp0_Reserved_31_20_OFFSET                20
#define D18F2x214_dct0_mp0_Reserved_31_20_WIDTH                 12
#define D18F2x214_dct0_mp0_Reserved_31_20_MASK                  0xfff00000

/// D18F2x214_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                  TwrwrDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                TwrwrSdDc:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TwrwrSdSc:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x214_dct0_mp0_STRUCT;

// **** D18F2x214_dct1_mp0 Register Definition ****
// Address
#define D18F2x214_dct1_mp0_ADDRESS                              0x214

// Type
#define D18F2x214_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x214_dct1_mp0_TwrwrDd_OFFSET                       0
#define D18F2x214_dct1_mp0_TwrwrDd_WIDTH                        4
#define D18F2x214_dct1_mp0_TwrwrDd_MASK                         0xf
#define D18F2x214_dct1_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x214_dct1_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x214_dct1_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x214_dct1_mp0_TwrwrSdDc_OFFSET                     8
#define D18F2x214_dct1_mp0_TwrwrSdDc_WIDTH                      4
#define D18F2x214_dct1_mp0_TwrwrSdDc_MASK                       0xf00
#define D18F2x214_dct1_mp0_Reserved_15_12_OFFSET                12
#define D18F2x214_dct1_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x214_dct1_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x214_dct1_mp0_TwrwrSdSc_OFFSET                     16
#define D18F2x214_dct1_mp0_TwrwrSdSc_WIDTH                      4
#define D18F2x214_dct1_mp0_TwrwrSdSc_MASK                       0xf0000
#define D18F2x214_dct1_mp0_Reserved_31_20_OFFSET                20
#define D18F2x214_dct1_mp0_Reserved_31_20_WIDTH                 12
#define D18F2x214_dct1_mp0_Reserved_31_20_MASK                  0xfff00000

/// D18F2x214_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                  TwrwrDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                TwrwrSdDc:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TwrwrSdSc:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x214_dct1_mp0_STRUCT;

// **** D18F2x214_dct0_mp1 Register Definition ****
// Address
#define D18F2x214_dct0_mp1_ADDRESS                              0x214

// Type
#define D18F2x214_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x214_dct0_mp1_TwrwrDd_OFFSET                       0
#define D18F2x214_dct0_mp1_TwrwrDd_WIDTH                        4
#define D18F2x214_dct0_mp1_TwrwrDd_MASK                         0xf
#define D18F2x214_dct0_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x214_dct0_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x214_dct0_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x214_dct0_mp1_TwrwrSdDc_OFFSET                     8
#define D18F2x214_dct0_mp1_TwrwrSdDc_WIDTH                      4
#define D18F2x214_dct0_mp1_TwrwrSdDc_MASK                       0xf00
#define D18F2x214_dct0_mp1_Reserved_15_12_OFFSET                12
#define D18F2x214_dct0_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x214_dct0_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x214_dct0_mp1_TwrwrSdSc_OFFSET                     16
#define D18F2x214_dct0_mp1_TwrwrSdSc_WIDTH                      4
#define D18F2x214_dct0_mp1_TwrwrSdSc_MASK                       0xf0000
#define D18F2x214_dct0_mp1_Reserved_31_20_OFFSET                20
#define D18F2x214_dct0_mp1_Reserved_31_20_WIDTH                 12
#define D18F2x214_dct0_mp1_Reserved_31_20_MASK                  0xfff00000

/// D18F2x214_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                  TwrwrDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                TwrwrSdDc:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TwrwrSdSc:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x214_dct0_mp1_STRUCT;

// **** D18F2x218_dct0_mp1 Register Definition ****
// Address
#define D18F2x218_dct0_mp1_ADDRESS                              0x218

// Type
#define D18F2x218_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x218_dct0_mp1_TrdrdDd_OFFSET                       0
#define D18F2x218_dct0_mp1_TrdrdDd_WIDTH                        4
#define D18F2x218_dct0_mp1_TrdrdDd_MASK                         0xf
#define D18F2x218_dct0_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x218_dct0_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x218_dct0_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x218_dct0_mp1_Twrrd_OFFSET                         8
#define D18F2x218_dct0_mp1_Twrrd_WIDTH                          4
#define D18F2x218_dct0_mp1_Twrrd_MASK                           0xf00
#define D18F2x218_dct0_mp1_Reserved_15_12_OFFSET                12
#define D18F2x218_dct0_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x218_dct0_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x218_dct0_mp1_TrdrdSdDc_OFFSET                     16
#define D18F2x218_dct0_mp1_TrdrdSdDc_WIDTH                      4
#define D18F2x218_dct0_mp1_TrdrdSdDc_MASK                       0xf0000
#define D18F2x218_dct0_mp1_Reserved_23_20_OFFSET                20
#define D18F2x218_dct0_mp1_Reserved_23_20_WIDTH                 4
#define D18F2x218_dct0_mp1_Reserved_23_20_MASK                  0xf00000
#define D18F2x218_dct0_mp1_TrdrdSdSc_OFFSET                     24
#define D18F2x218_dct0_mp1_TrdrdSdSc_WIDTH                      4
#define D18F2x218_dct0_mp1_TrdrdSdSc_MASK                       0xf000000
#define D18F2x218_dct0_mp1_Reserved_31_28_OFFSET                28
#define D18F2x218_dct0_mp1_Reserved_31_28_WIDTH                 4
#define D18F2x218_dct0_mp1_Reserved_31_28_MASK                  0xf0000000

/// D18F2x218_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                  TrdrdDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Twrrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TrdrdSdDc:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                                TrdrdSdSc:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x218_dct0_mp1_STRUCT;

// **** D18F2x218_dct1_mp1 Register Definition ****
// Address
#define D18F2x218_dct1_mp1_ADDRESS                              0x218

// Type
#define D18F2x218_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x218_dct1_mp1_TrdrdDd_OFFSET                       0
#define D18F2x218_dct1_mp1_TrdrdDd_WIDTH                        4
#define D18F2x218_dct1_mp1_TrdrdDd_MASK                         0xf
#define D18F2x218_dct1_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x218_dct1_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x218_dct1_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x218_dct1_mp1_Twrrd_OFFSET                         8
#define D18F2x218_dct1_mp1_Twrrd_WIDTH                          4
#define D18F2x218_dct1_mp1_Twrrd_MASK                           0xf00
#define D18F2x218_dct1_mp1_Reserved_15_12_OFFSET                12
#define D18F2x218_dct1_mp1_Reserved_15_12_WIDTH                 4
#define D18F2x218_dct1_mp1_Reserved_15_12_MASK                  0xf000
#define D18F2x218_dct1_mp1_TrdrdSdDc_OFFSET                     16
#define D18F2x218_dct1_mp1_TrdrdSdDc_WIDTH                      4
#define D18F2x218_dct1_mp1_TrdrdSdDc_MASK                       0xf0000
#define D18F2x218_dct1_mp1_Reserved_23_20_OFFSET                20
#define D18F2x218_dct1_mp1_Reserved_23_20_WIDTH                 4
#define D18F2x218_dct1_mp1_Reserved_23_20_MASK                  0xf00000
#define D18F2x218_dct1_mp1_TrdrdSdSc_OFFSET                     24
#define D18F2x218_dct1_mp1_TrdrdSdSc_WIDTH                      4
#define D18F2x218_dct1_mp1_TrdrdSdSc_MASK                       0xf000000
#define D18F2x218_dct1_mp1_Reserved_31_28_OFFSET                28
#define D18F2x218_dct1_mp1_Reserved_31_28_WIDTH                 4
#define D18F2x218_dct1_mp1_Reserved_31_28_MASK                  0xf0000000

/// D18F2x218_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                  TrdrdDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Twrrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TrdrdSdDc:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                                TrdrdSdSc:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x218_dct1_mp1_STRUCT;

// **** D18F2x218_dct0_mp0 Register Definition ****
// Address
#define D18F2x218_dct0_mp0_ADDRESS                              0x218

// Type
#define D18F2x218_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x218_dct0_mp0_TrdrdDd_OFFSET                       0
#define D18F2x218_dct0_mp0_TrdrdDd_WIDTH                        4
#define D18F2x218_dct0_mp0_TrdrdDd_MASK                         0xf
#define D18F2x218_dct0_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x218_dct0_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x218_dct0_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x218_dct0_mp0_Twrrd_OFFSET                         8
#define D18F2x218_dct0_mp0_Twrrd_WIDTH                          4
#define D18F2x218_dct0_mp0_Twrrd_MASK                           0xf00
#define D18F2x218_dct0_mp0_Reserved_15_12_OFFSET                12
#define D18F2x218_dct0_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x218_dct0_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x218_dct0_mp0_TrdrdSdDc_OFFSET                     16
#define D18F2x218_dct0_mp0_TrdrdSdDc_WIDTH                      4
#define D18F2x218_dct0_mp0_TrdrdSdDc_MASK                       0xf0000
#define D18F2x218_dct0_mp0_Reserved_23_20_OFFSET                20
#define D18F2x218_dct0_mp0_Reserved_23_20_WIDTH                 4
#define D18F2x218_dct0_mp0_Reserved_23_20_MASK                  0xf00000
#define D18F2x218_dct0_mp0_TrdrdSdSc_OFFSET                     24
#define D18F2x218_dct0_mp0_TrdrdSdSc_WIDTH                      4
#define D18F2x218_dct0_mp0_TrdrdSdSc_MASK                       0xf000000
#define D18F2x218_dct0_mp0_Reserved_31_28_OFFSET                28
#define D18F2x218_dct0_mp0_Reserved_31_28_WIDTH                 4
#define D18F2x218_dct0_mp0_Reserved_31_28_MASK                  0xf0000000

/// D18F2x218_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                  TrdrdDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Twrrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TrdrdSdDc:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                                TrdrdSdSc:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x218_dct0_mp0_STRUCT;

// **** D18F2x218_dct1_mp0 Register Definition ****
// Address
#define D18F2x218_dct1_mp0_ADDRESS                              0x218

// Type
#define D18F2x218_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x218_dct1_mp0_TrdrdDd_OFFSET                       0
#define D18F2x218_dct1_mp0_TrdrdDd_WIDTH                        4
#define D18F2x218_dct1_mp0_TrdrdDd_MASK                         0xf
#define D18F2x218_dct1_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x218_dct1_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x218_dct1_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x218_dct1_mp0_Twrrd_OFFSET                         8
#define D18F2x218_dct1_mp0_Twrrd_WIDTH                          4
#define D18F2x218_dct1_mp0_Twrrd_MASK                           0xf00
#define D18F2x218_dct1_mp0_Reserved_15_12_OFFSET                12
#define D18F2x218_dct1_mp0_Reserved_15_12_WIDTH                 4
#define D18F2x218_dct1_mp0_Reserved_15_12_MASK                  0xf000
#define D18F2x218_dct1_mp0_TrdrdSdDc_OFFSET                     16
#define D18F2x218_dct1_mp0_TrdrdSdDc_WIDTH                      4
#define D18F2x218_dct1_mp0_TrdrdSdDc_MASK                       0xf0000
#define D18F2x218_dct1_mp0_Reserved_23_20_OFFSET                20
#define D18F2x218_dct1_mp0_Reserved_23_20_WIDTH                 4
#define D18F2x218_dct1_mp0_Reserved_23_20_MASK                  0xf00000
#define D18F2x218_dct1_mp0_TrdrdSdSc_OFFSET                     24
#define D18F2x218_dct1_mp0_TrdrdSdSc_WIDTH                      4
#define D18F2x218_dct1_mp0_TrdrdSdSc_MASK                       0xf000000
#define D18F2x218_dct1_mp0_Reserved_31_28_OFFSET                28
#define D18F2x218_dct1_mp0_Reserved_31_28_WIDTH                 4
#define D18F2x218_dct1_mp0_Reserved_31_28_MASK                  0xf0000000

/// D18F2x218_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                  TrdrdDd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Twrrd:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                TrdrdSdDc:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                                TrdrdSdSc:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x218_dct1_mp0_STRUCT;

// **** D18F2x21C_dct1_mp1 Register Definition ****
// Address
#define D18F2x21C_dct1_mp1_ADDRESS                              0x21c

// Type
#define D18F2x21C_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x21C_dct1_mp1_Reserved_7_0_OFFSET                  0
#define D18F2x21C_dct1_mp1_Reserved_7_0_WIDTH                   8
#define D18F2x21C_dct1_mp1_Reserved_7_0_MASK                    0xff
#define D18F2x21C_dct1_mp1_TrwtTO_OFFSET                        8
#define D18F2x21C_dct1_mp1_TrwtTO_WIDTH                         5
#define D18F2x21C_dct1_mp1_TrwtTO_MASK                          0x1f00
#define D18F2x21C_dct1_mp1_Reserved_15_13_OFFSET                13
#define D18F2x21C_dct1_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x21C_dct1_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x21C_dct1_mp1_TrwtWB_OFFSET                        16
#define D18F2x21C_dct1_mp1_TrwtWB_WIDTH                         5
#define D18F2x21C_dct1_mp1_TrwtWB_MASK                          0x1f0000
#define D18F2x21C_dct1_mp1_Reserved_31_21_OFFSET                21
#define D18F2x21C_dct1_mp1_Reserved_31_21_WIDTH                 11
#define D18F2x21C_dct1_mp1_Reserved_31_21_MASK                  0xffe00000

/// D18F2x21C_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                   TrwtTO:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                   TrwtWB:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x21C_dct1_mp1_STRUCT;

// **** D18F2x21C_dct1_mp0 Register Definition ****
// Address
#define D18F2x21C_dct1_mp0_ADDRESS                              0x21c

// Type
#define D18F2x21C_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x21C_dct1_mp0_Reserved_7_0_OFFSET                  0
#define D18F2x21C_dct1_mp0_Reserved_7_0_WIDTH                   8
#define D18F2x21C_dct1_mp0_Reserved_7_0_MASK                    0xff
#define D18F2x21C_dct1_mp0_TrwtTO_OFFSET                        8
#define D18F2x21C_dct1_mp0_TrwtTO_WIDTH                         5
#define D18F2x21C_dct1_mp0_TrwtTO_MASK                          0x1f00
#define D18F2x21C_dct1_mp0_Reserved_15_13_OFFSET                13
#define D18F2x21C_dct1_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x21C_dct1_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x21C_dct1_mp0_TrwtWB_OFFSET                        16
#define D18F2x21C_dct1_mp0_TrwtWB_WIDTH                         5
#define D18F2x21C_dct1_mp0_TrwtWB_MASK                          0x1f0000
#define D18F2x21C_dct1_mp0_Reserved_31_21_OFFSET                21
#define D18F2x21C_dct1_mp0_Reserved_31_21_WIDTH                 11
#define D18F2x21C_dct1_mp0_Reserved_31_21_MASK                  0xffe00000

/// D18F2x21C_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                   TrwtTO:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                   TrwtWB:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x21C_dct1_mp0_STRUCT;

// **** D18F2x21C_dct0_mp0 Register Definition ****
// Address
#define D18F2x21C_dct0_mp0_ADDRESS                              0x21c

// Type
#define D18F2x21C_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x21C_dct0_mp0_Reserved_7_0_OFFSET                  0
#define D18F2x21C_dct0_mp0_Reserved_7_0_WIDTH                   8
#define D18F2x21C_dct0_mp0_Reserved_7_0_MASK                    0xff
#define D18F2x21C_dct0_mp0_TrwtTO_OFFSET                        8
#define D18F2x21C_dct0_mp0_TrwtTO_WIDTH                         5
#define D18F2x21C_dct0_mp0_TrwtTO_MASK                          0x1f00
#define D18F2x21C_dct0_mp0_Reserved_15_13_OFFSET                13
#define D18F2x21C_dct0_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x21C_dct0_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x21C_dct0_mp0_TrwtWB_OFFSET                        16
#define D18F2x21C_dct0_mp0_TrwtWB_WIDTH                         5
#define D18F2x21C_dct0_mp0_TrwtWB_MASK                          0x1f0000
#define D18F2x21C_dct0_mp0_Reserved_31_21_OFFSET                21
#define D18F2x21C_dct0_mp0_Reserved_31_21_WIDTH                 11
#define D18F2x21C_dct0_mp0_Reserved_31_21_MASK                  0xffe00000

/// D18F2x21C_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                   TrwtTO:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                   TrwtWB:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x21C_dct0_mp0_STRUCT;

// **** D18F2x21C_dct0_mp1 Register Definition ****
// Address
#define D18F2x21C_dct0_mp1_ADDRESS                              0x21c

// Type
#define D18F2x21C_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x21C_dct0_mp1_Reserved_7_0_OFFSET                  0
#define D18F2x21C_dct0_mp1_Reserved_7_0_WIDTH                   8
#define D18F2x21C_dct0_mp1_Reserved_7_0_MASK                    0xff
#define D18F2x21C_dct0_mp1_TrwtTO_OFFSET                        8
#define D18F2x21C_dct0_mp1_TrwtTO_WIDTH                         5
#define D18F2x21C_dct0_mp1_TrwtTO_MASK                          0x1f00
#define D18F2x21C_dct0_mp1_Reserved_15_13_OFFSET                13
#define D18F2x21C_dct0_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x21C_dct0_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x21C_dct0_mp1_TrwtWB_OFFSET                        16
#define D18F2x21C_dct0_mp1_TrwtWB_WIDTH                         5
#define D18F2x21C_dct0_mp1_TrwtWB_MASK                          0x1f0000
#define D18F2x21C_dct0_mp1_Reserved_31_21_OFFSET                21
#define D18F2x21C_dct0_mp1_Reserved_31_21_WIDTH                 11
#define D18F2x21C_dct0_mp1_Reserved_31_21_MASK                  0xffe00000

/// D18F2x21C_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                                   TrwtTO:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                   TrwtWB:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x21C_dct0_mp1_STRUCT;

// **** D18F2x220_dct1 Register Definition ****
// Address
#define D18F2x220_dct1_ADDRESS                                  0x220

// Type
#define D18F2x220_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x220_dct1_Tmrd_OFFSET                              0
#define D18F2x220_dct1_Tmrd_WIDTH                               4
#define D18F2x220_dct1_Tmrd_MASK                                0xf
#define D18F2x220_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x220_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x220_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x220_dct1_Tmod_OFFSET                              8
#define D18F2x220_dct1_Tmod_WIDTH                               5
#define D18F2x220_dct1_Tmod_MASK                                0x1f00
#define D18F2x220_dct1_Reserved_31_13_OFFSET                    13
#define D18F2x220_dct1_Reserved_31_13_WIDTH                     19
#define D18F2x220_dct1_Reserved_31_13_MASK                      0xffffe000

/// D18F2x220_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tmrd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                     Tmod:5 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x220_dct1_STRUCT;

// **** D18F2x220_dct0 Register Definition ****
// Address
#define D18F2x220_dct0_ADDRESS                                  0x220

// Type
#define D18F2x220_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x220_dct0_Tmrd_OFFSET                              0
#define D18F2x220_dct0_Tmrd_WIDTH                               4
#define D18F2x220_dct0_Tmrd_MASK                                0xf
#define D18F2x220_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x220_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x220_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x220_dct0_Tmod_OFFSET                              8
#define D18F2x220_dct0_Tmod_WIDTH                               5
#define D18F2x220_dct0_Tmod_MASK                                0x1f00
#define D18F2x220_dct0_Reserved_31_13_OFFSET                    13
#define D18F2x220_dct0_Reserved_31_13_WIDTH                     19
#define D18F2x220_dct0_Reserved_31_13_MASK                      0xffffe000

/// D18F2x220_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                     Tmrd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                     Tmod:5 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x220_dct0_STRUCT;

// **** D18F2x224_dct0 Register Definition ****
// Address
#define D18F2x224_dct0_ADDRESS                                  0x224

// Type
#define D18F2x224_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x224_dct0_Tzqoper_OFFSET                           0
#define D18F2x224_dct0_Tzqoper_WIDTH                            4
#define D18F2x224_dct0_Tzqoper_MASK                             0xf
#define D18F2x224_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x224_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x224_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x224_dct0_Tzqcs_OFFSET                             8
#define D18F2x224_dct0_Tzqcs_WIDTH                              3
#define D18F2x224_dct0_Tzqcs_MASK                               0x700
#define D18F2x224_dct0_Reserved_31_11_OFFSET                    11
#define D18F2x224_dct0_Reserved_31_11_WIDTH                     21
#define D18F2x224_dct0_Reserved_31_11_MASK                      0xfffff800

/// D18F2x224_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                  Tzqoper:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Tzqcs:3 ; ///<
    UINT32                                           Reserved_31_11:21; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x224_dct0_STRUCT;

// **** D18F2x224_dct1 Register Definition ****
// Address
#define D18F2x224_dct1_ADDRESS                                  0x224

// Type
#define D18F2x224_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x224_dct1_Tzqoper_OFFSET                           0
#define D18F2x224_dct1_Tzqoper_WIDTH                            4
#define D18F2x224_dct1_Tzqoper_MASK                             0xf
#define D18F2x224_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x224_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x224_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x224_dct1_Tzqcs_OFFSET                             8
#define D18F2x224_dct1_Tzqcs_WIDTH                              3
#define D18F2x224_dct1_Tzqcs_MASK                               0x700
#define D18F2x224_dct1_Reserved_31_11_OFFSET                    11
#define D18F2x224_dct1_Reserved_31_11_WIDTH                     21
#define D18F2x224_dct1_Reserved_31_11_MASK                      0xfffff800

/// D18F2x224_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                  Tzqoper:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    Tzqcs:3 ; ///<
    UINT32                                           Reserved_31_11:21; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x224_dct1_STRUCT;

// **** D18F2x228_dct1 Register Definition ****
// Address
#define D18F2x228_dct1_ADDRESS                                  0x228

// Type
#define D18F2x228_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x228_dct1_Tstag0_OFFSET                            0
#define D18F2x228_dct1_Tstag0_WIDTH                             8
#define D18F2x228_dct1_Tstag0_MASK                              0xff
#define D18F2x228_dct1_Tstag1_OFFSET                            8
#define D18F2x228_dct1_Tstag1_WIDTH                             8
#define D18F2x228_dct1_Tstag1_MASK                              0xff00
#define D18F2x228_dct1_Tstag2_OFFSET                            16
#define D18F2x228_dct1_Tstag2_WIDTH                             8
#define D18F2x228_dct1_Tstag2_MASK                              0xff0000
#define D18F2x228_dct1_Tstag3_OFFSET                            24
#define D18F2x228_dct1_Tstag3_WIDTH                             8
#define D18F2x228_dct1_Tstag3_MASK                              0xff000000

/// D18F2x228_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                   Tstag0:8 ; ///<
    UINT32                                                   Tstag1:8 ; ///<
    UINT32                                                   Tstag2:8 ; ///<
    UINT32                                                   Tstag3:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x228_dct1_STRUCT;

// **** D18F2x228_dct0 Register Definition ****
// Address
#define D18F2x228_dct0_ADDRESS                                  0x228

// Type
#define D18F2x228_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x228_dct0_Tstag0_OFFSET                            0
#define D18F2x228_dct0_Tstag0_WIDTH                             8
#define D18F2x228_dct0_Tstag0_MASK                              0xff
#define D18F2x228_dct0_Tstag1_OFFSET                            8
#define D18F2x228_dct0_Tstag1_WIDTH                             8
#define D18F2x228_dct0_Tstag1_MASK                              0xff00
#define D18F2x228_dct0_Tstag2_OFFSET                            16
#define D18F2x228_dct0_Tstag2_WIDTH                             8
#define D18F2x228_dct0_Tstag2_MASK                              0xff0000
#define D18F2x228_dct0_Tstag3_OFFSET                            24
#define D18F2x228_dct0_Tstag3_WIDTH                             8
#define D18F2x228_dct0_Tstag3_MASK                              0xff000000

/// D18F2x228_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                   Tstag0:8 ; ///<
    UINT32                                                   Tstag1:8 ; ///<
    UINT32                                                   Tstag2:8 ; ///<
    UINT32                                                   Tstag3:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x228_dct0_STRUCT;

// **** D18F2x22C_dct1_mp1 Register Definition ****
// Address
#define D18F2x22C_dct1_mp1_ADDRESS                              0x22c

// Type
#define D18F2x22C_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x22C_dct1_mp1_Twr_OFFSET                           0
#define D18F2x22C_dct1_mp1_Twr_WIDTH                            5
#define D18F2x22C_dct1_mp1_Twr_MASK                             0x1f
#define D18F2x22C_dct1_mp1_Reserved_31_5_OFFSET                 5
#define D18F2x22C_dct1_mp1_Reserved_31_5_WIDTH                  27
#define D18F2x22C_dct1_mp1_Reserved_31_5_MASK                   0xffffffe0

/// D18F2x22C_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Twr:5 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x22C_dct1_mp1_STRUCT;

// **** D18F2x22C_dct1_mp0 Register Definition ****
// Address
#define D18F2x22C_dct1_mp0_ADDRESS                              0x22c

// Type
#define D18F2x22C_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x22C_dct1_mp0_Twr_OFFSET                           0
#define D18F2x22C_dct1_mp0_Twr_WIDTH                            5
#define D18F2x22C_dct1_mp0_Twr_MASK                             0x1f
#define D18F2x22C_dct1_mp0_Reserved_31_5_OFFSET                 5
#define D18F2x22C_dct1_mp0_Reserved_31_5_WIDTH                  27
#define D18F2x22C_dct1_mp0_Reserved_31_5_MASK                   0xffffffe0

/// D18F2x22C_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Twr:5 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x22C_dct1_mp0_STRUCT;

// **** D18F2x22C_dct0_mp0 Register Definition ****
// Address
#define D18F2x22C_dct0_mp0_ADDRESS                              0x22c

// Type
#define D18F2x22C_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x22C_dct0_mp0_Twr_OFFSET                           0
#define D18F2x22C_dct0_mp0_Twr_WIDTH                            5
#define D18F2x22C_dct0_mp0_Twr_MASK                             0x1f
#define D18F2x22C_dct0_mp0_Reserved_31_5_OFFSET                 5
#define D18F2x22C_dct0_mp0_Reserved_31_5_WIDTH                  27
#define D18F2x22C_dct0_mp0_Reserved_31_5_MASK                   0xffffffe0

/// D18F2x22C_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Twr:5 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x22C_dct0_mp0_STRUCT;

// **** D18F2x22C_dct0_mp1 Register Definition ****
// Address
#define D18F2x22C_dct0_mp1_ADDRESS                              0x22c

// Type
#define D18F2x22C_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x22C_dct0_mp1_Twr_OFFSET                           0
#define D18F2x22C_dct0_mp1_Twr_WIDTH                            5
#define D18F2x22C_dct0_mp1_Twr_MASK                             0x1f
#define D18F2x22C_dct0_mp1_Reserved_31_5_OFFSET                 5
#define D18F2x22C_dct0_mp1_Reserved_31_5_WIDTH                  27
#define D18F2x22C_dct0_mp1_Reserved_31_5_MASK                   0xffffffe0

/// D18F2x22C_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Twr:5 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x22C_dct0_mp1_STRUCT;

// **** D18F2x230_dct0 Register Definition ****
// Address
#define D18F2x230_dct0_ADDRESS                                  0x230

// Type
#define D18F2x230_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x230_dct0_RdOdtPatCs40_OFFSET                      0
#define D18F2x230_dct0_RdOdtPatCs40_WIDTH                       4
#define D18F2x230_dct0_RdOdtPatCs40_MASK                        0xf
#define D18F2x230_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x230_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x230_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x230_dct0_RdOdtPatCs51_OFFSET                      8
#define D18F2x230_dct0_RdOdtPatCs51_WIDTH                       4
#define D18F2x230_dct0_RdOdtPatCs51_MASK                        0xf00
#define D18F2x230_dct0_Reserved_15_12_OFFSET                    12
#define D18F2x230_dct0_Reserved_15_12_WIDTH                     4
#define D18F2x230_dct0_Reserved_15_12_MASK                      0xf000
#define D18F2x230_dct0_RdOdtPatCs62_OFFSET                      16
#define D18F2x230_dct0_RdOdtPatCs62_WIDTH                       4
#define D18F2x230_dct0_RdOdtPatCs62_MASK                        0xf0000
#define D18F2x230_dct0_Reserved_23_20_OFFSET                    20
#define D18F2x230_dct0_Reserved_23_20_WIDTH                     4
#define D18F2x230_dct0_Reserved_23_20_MASK                      0xf00000
#define D18F2x230_dct0_RdOdtPatCs73_OFFSET                      24
#define D18F2x230_dct0_RdOdtPatCs73_WIDTH                       4
#define D18F2x230_dct0_RdOdtPatCs73_MASK                        0xf000000
#define D18F2x230_dct0_Reserved_31_28_OFFSET                    28
#define D18F2x230_dct0_Reserved_31_28_WIDTH                     4
#define D18F2x230_dct0_Reserved_31_28_MASK                      0xf0000000

/// D18F2x230_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             RdOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             RdOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             RdOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             RdOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x230_dct0_STRUCT;

// **** D18F2x230_dct1 Register Definition ****
// Address
#define D18F2x230_dct1_ADDRESS                                  0x230

// Type
#define D18F2x230_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x230_dct1_RdOdtPatCs40_OFFSET                      0
#define D18F2x230_dct1_RdOdtPatCs40_WIDTH                       4
#define D18F2x230_dct1_RdOdtPatCs40_MASK                        0xf
#define D18F2x230_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x230_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x230_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x230_dct1_RdOdtPatCs51_OFFSET                      8
#define D18F2x230_dct1_RdOdtPatCs51_WIDTH                       4
#define D18F2x230_dct1_RdOdtPatCs51_MASK                        0xf00
#define D18F2x230_dct1_Reserved_15_12_OFFSET                    12
#define D18F2x230_dct1_Reserved_15_12_WIDTH                     4
#define D18F2x230_dct1_Reserved_15_12_MASK                      0xf000
#define D18F2x230_dct1_RdOdtPatCs62_OFFSET                      16
#define D18F2x230_dct1_RdOdtPatCs62_WIDTH                       4
#define D18F2x230_dct1_RdOdtPatCs62_MASK                        0xf0000
#define D18F2x230_dct1_Reserved_23_20_OFFSET                    20
#define D18F2x230_dct1_Reserved_23_20_WIDTH                     4
#define D18F2x230_dct1_Reserved_23_20_MASK                      0xf00000
#define D18F2x230_dct1_RdOdtPatCs73_OFFSET                      24
#define D18F2x230_dct1_RdOdtPatCs73_WIDTH                       4
#define D18F2x230_dct1_RdOdtPatCs73_MASK                        0xf000000
#define D18F2x230_dct1_Reserved_31_28_OFFSET                    28
#define D18F2x230_dct1_Reserved_31_28_WIDTH                     4
#define D18F2x230_dct1_Reserved_31_28_MASK                      0xf0000000

/// D18F2x230_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             RdOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             RdOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             RdOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             RdOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x230_dct1_STRUCT;

// **** D18F2x234_dct1 Register Definition ****
// Address
#define D18F2x234_dct1_ADDRESS                                  0x234

// Type
#define D18F2x234_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x234_dct1_RdOdtPatCs40_OFFSET                      0
#define D18F2x234_dct1_RdOdtPatCs40_WIDTH                       4
#define D18F2x234_dct1_RdOdtPatCs40_MASK                        0xf
#define D18F2x234_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x234_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x234_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x234_dct1_RdOdtPatCs51_OFFSET                      8
#define D18F2x234_dct1_RdOdtPatCs51_WIDTH                       4
#define D18F2x234_dct1_RdOdtPatCs51_MASK                        0xf00
#define D18F2x234_dct1_Reserved_15_12_OFFSET                    12
#define D18F2x234_dct1_Reserved_15_12_WIDTH                     4
#define D18F2x234_dct1_Reserved_15_12_MASK                      0xf000
#define D18F2x234_dct1_RdOdtPatCs62_OFFSET                      16
#define D18F2x234_dct1_RdOdtPatCs62_WIDTH                       4
#define D18F2x234_dct1_RdOdtPatCs62_MASK                        0xf0000
#define D18F2x234_dct1_Reserved_23_20_OFFSET                    20
#define D18F2x234_dct1_Reserved_23_20_WIDTH                     4
#define D18F2x234_dct1_Reserved_23_20_MASK                      0xf00000
#define D18F2x234_dct1_RdOdtPatCs73_OFFSET                      24
#define D18F2x234_dct1_RdOdtPatCs73_WIDTH                       4
#define D18F2x234_dct1_RdOdtPatCs73_MASK                        0xf000000
#define D18F2x234_dct1_Reserved_31_28_OFFSET                    28
#define D18F2x234_dct1_Reserved_31_28_WIDTH                     4
#define D18F2x234_dct1_Reserved_31_28_MASK                      0xf0000000

/// D18F2x234_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             RdOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             RdOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             RdOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             RdOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x234_dct1_STRUCT;

// **** D18F2x234_dct0 Register Definition ****
// Address
#define D18F2x234_dct0_ADDRESS                                  0x234

// Type
#define D18F2x234_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x234_dct0_RdOdtPatCs40_OFFSET                      0
#define D18F2x234_dct0_RdOdtPatCs40_WIDTH                       4
#define D18F2x234_dct0_RdOdtPatCs40_MASK                        0xf
#define D18F2x234_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x234_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x234_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x234_dct0_RdOdtPatCs51_OFFSET                      8
#define D18F2x234_dct0_RdOdtPatCs51_WIDTH                       4
#define D18F2x234_dct0_RdOdtPatCs51_MASK                        0xf00
#define D18F2x234_dct0_Reserved_15_12_OFFSET                    12
#define D18F2x234_dct0_Reserved_15_12_WIDTH                     4
#define D18F2x234_dct0_Reserved_15_12_MASK                      0xf000
#define D18F2x234_dct0_RdOdtPatCs62_OFFSET                      16
#define D18F2x234_dct0_RdOdtPatCs62_WIDTH                       4
#define D18F2x234_dct0_RdOdtPatCs62_MASK                        0xf0000
#define D18F2x234_dct0_Reserved_23_20_OFFSET                    20
#define D18F2x234_dct0_Reserved_23_20_WIDTH                     4
#define D18F2x234_dct0_Reserved_23_20_MASK                      0xf00000
#define D18F2x234_dct0_RdOdtPatCs73_OFFSET                      24
#define D18F2x234_dct0_RdOdtPatCs73_WIDTH                       4
#define D18F2x234_dct0_RdOdtPatCs73_MASK                        0xf000000
#define D18F2x234_dct0_Reserved_31_28_OFFSET                    28
#define D18F2x234_dct0_Reserved_31_28_WIDTH                     4
#define D18F2x234_dct0_Reserved_31_28_MASK                      0xf0000000

/// D18F2x234_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             RdOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             RdOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             RdOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             RdOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x234_dct0_STRUCT;

// **** D18F2x238_dct1 Register Definition ****
// Address
#define D18F2x238_dct1_ADDRESS                                  0x238

// Type
#define D18F2x238_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x238_dct1_WrOdtPatCs40_OFFSET                      0
#define D18F2x238_dct1_WrOdtPatCs40_WIDTH                       4
#define D18F2x238_dct1_WrOdtPatCs40_MASK                        0xf
#define D18F2x238_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x238_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x238_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x238_dct1_WrOdtPatCs51_OFFSET                      8
#define D18F2x238_dct1_WrOdtPatCs51_WIDTH                       4
#define D18F2x238_dct1_WrOdtPatCs51_MASK                        0xf00
#define D18F2x238_dct1_Reserved_15_12_OFFSET                    12
#define D18F2x238_dct1_Reserved_15_12_WIDTH                     4
#define D18F2x238_dct1_Reserved_15_12_MASK                      0xf000
#define D18F2x238_dct1_WrOdtPatCs62_OFFSET                      16
#define D18F2x238_dct1_WrOdtPatCs62_WIDTH                       4
#define D18F2x238_dct1_WrOdtPatCs62_MASK                        0xf0000
#define D18F2x238_dct1_Reserved_23_20_OFFSET                    20
#define D18F2x238_dct1_Reserved_23_20_WIDTH                     4
#define D18F2x238_dct1_Reserved_23_20_MASK                      0xf00000
#define D18F2x238_dct1_WrOdtPatCs73_OFFSET                      24
#define D18F2x238_dct1_WrOdtPatCs73_WIDTH                       4
#define D18F2x238_dct1_WrOdtPatCs73_MASK                        0xf000000
#define D18F2x238_dct1_Reserved_31_28_OFFSET                    28
#define D18F2x238_dct1_Reserved_31_28_WIDTH                     4
#define D18F2x238_dct1_Reserved_31_28_MASK                      0xf0000000

/// D18F2x238_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             WrOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             WrOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             WrOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x238_dct1_STRUCT;

// **** D18F2x238_dct0 Register Definition ****
// Address
#define D18F2x238_dct0_ADDRESS                                  0x238

// Type
#define D18F2x238_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x238_dct0_WrOdtPatCs40_OFFSET                      0
#define D18F2x238_dct0_WrOdtPatCs40_WIDTH                       4
#define D18F2x238_dct0_WrOdtPatCs40_MASK                        0xf
#define D18F2x238_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x238_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x238_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x238_dct0_WrOdtPatCs51_OFFSET                      8
#define D18F2x238_dct0_WrOdtPatCs51_WIDTH                       4
#define D18F2x238_dct0_WrOdtPatCs51_MASK                        0xf00
#define D18F2x238_dct0_Reserved_15_12_OFFSET                    12
#define D18F2x238_dct0_Reserved_15_12_WIDTH                     4
#define D18F2x238_dct0_Reserved_15_12_MASK                      0xf000
#define D18F2x238_dct0_WrOdtPatCs62_OFFSET                      16
#define D18F2x238_dct0_WrOdtPatCs62_WIDTH                       4
#define D18F2x238_dct0_WrOdtPatCs62_MASK                        0xf0000
#define D18F2x238_dct0_Reserved_23_20_OFFSET                    20
#define D18F2x238_dct0_Reserved_23_20_WIDTH                     4
#define D18F2x238_dct0_Reserved_23_20_MASK                      0xf00000
#define D18F2x238_dct0_WrOdtPatCs73_OFFSET                      24
#define D18F2x238_dct0_WrOdtPatCs73_WIDTH                       4
#define D18F2x238_dct0_WrOdtPatCs73_MASK                        0xf000000
#define D18F2x238_dct0_Reserved_31_28_OFFSET                    28
#define D18F2x238_dct0_Reserved_31_28_WIDTH                     4
#define D18F2x238_dct0_Reserved_31_28_MASK                      0xf0000000

/// D18F2x238_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             WrOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             WrOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             WrOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x238_dct0_STRUCT;

// **** D18F2x23C_dct0 Register Definition ****
// Address
#define D18F2x23C_dct0_ADDRESS                                  0x23c

// Type
#define D18F2x23C_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x23C_dct0_WrOdtPatCs40_OFFSET                      0
#define D18F2x23C_dct0_WrOdtPatCs40_WIDTH                       4
#define D18F2x23C_dct0_WrOdtPatCs40_MASK                        0xf
#define D18F2x23C_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x23C_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x23C_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x23C_dct0_WrOdtPatCs51_OFFSET                      8
#define D18F2x23C_dct0_WrOdtPatCs51_WIDTH                       4
#define D18F2x23C_dct0_WrOdtPatCs51_MASK                        0xf00
#define D18F2x23C_dct0_Reserved_15_12_OFFSET                    12
#define D18F2x23C_dct0_Reserved_15_12_WIDTH                     4
#define D18F2x23C_dct0_Reserved_15_12_MASK                      0xf000
#define D18F2x23C_dct0_WrOdtPatCs62_OFFSET                      16
#define D18F2x23C_dct0_WrOdtPatCs62_WIDTH                       4
#define D18F2x23C_dct0_WrOdtPatCs62_MASK                        0xf0000
#define D18F2x23C_dct0_Reserved_23_20_OFFSET                    20
#define D18F2x23C_dct0_Reserved_23_20_WIDTH                     4
#define D18F2x23C_dct0_Reserved_23_20_MASK                      0xf00000
#define D18F2x23C_dct0_WrOdtPatCs73_OFFSET                      24
#define D18F2x23C_dct0_WrOdtPatCs73_WIDTH                       4
#define D18F2x23C_dct0_WrOdtPatCs73_MASK                        0xf000000
#define D18F2x23C_dct0_Reserved_31_28_OFFSET                    28
#define D18F2x23C_dct0_Reserved_31_28_WIDTH                     4
#define D18F2x23C_dct0_Reserved_31_28_MASK                      0xf0000000

/// D18F2x23C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             WrOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             WrOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             WrOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x23C_dct0_STRUCT;

// **** D18F2x23C_dct1 Register Definition ****
// Address
#define D18F2x23C_dct1_ADDRESS                                  0x23c

// Type
#define D18F2x23C_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x23C_dct1_WrOdtPatCs40_OFFSET                      0
#define D18F2x23C_dct1_WrOdtPatCs40_WIDTH                       4
#define D18F2x23C_dct1_WrOdtPatCs40_MASK                        0xf
#define D18F2x23C_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x23C_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x23C_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x23C_dct1_WrOdtPatCs51_OFFSET                      8
#define D18F2x23C_dct1_WrOdtPatCs51_WIDTH                       4
#define D18F2x23C_dct1_WrOdtPatCs51_MASK                        0xf00
#define D18F2x23C_dct1_Reserved_15_12_OFFSET                    12
#define D18F2x23C_dct1_Reserved_15_12_WIDTH                     4
#define D18F2x23C_dct1_Reserved_15_12_MASK                      0xf000
#define D18F2x23C_dct1_WrOdtPatCs62_OFFSET                      16
#define D18F2x23C_dct1_WrOdtPatCs62_WIDTH                       4
#define D18F2x23C_dct1_WrOdtPatCs62_MASK                        0xf0000
#define D18F2x23C_dct1_Reserved_23_20_OFFSET                    20
#define D18F2x23C_dct1_Reserved_23_20_WIDTH                     4
#define D18F2x23C_dct1_Reserved_23_20_MASK                      0xf00000
#define D18F2x23C_dct1_WrOdtPatCs73_OFFSET                      24
#define D18F2x23C_dct1_WrOdtPatCs73_WIDTH                       4
#define D18F2x23C_dct1_WrOdtPatCs73_MASK                        0xf000000
#define D18F2x23C_dct1_Reserved_31_28_OFFSET                    28
#define D18F2x23C_dct1_Reserved_31_28_WIDTH                     4
#define D18F2x23C_dct1_Reserved_31_28_MASK                      0xf0000000

/// D18F2x23C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             WrOdtPatCs40:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             WrOdtPatCs51:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                             WrOdtPatCs62:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             WrOdtPatCs73:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x23C_dct1_STRUCT;

// **** D18F2x240_dct0_mp1 Register Definition ****
// Address
#define D18F2x240_dct0_mp1_ADDRESS                              0x240

// Type
#define D18F2x240_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x240_dct0_mp1_RdOdtTrnOnDly_OFFSET                 0
#define D18F2x240_dct0_mp1_RdOdtTrnOnDly_WIDTH                  4
#define D18F2x240_dct0_mp1_RdOdtTrnOnDly_MASK                   0xf
#define D18F2x240_dct0_mp1_RdOdtOnDuration_OFFSET               4
#define D18F2x240_dct0_mp1_RdOdtOnDuration_WIDTH                3
#define D18F2x240_dct0_mp1_RdOdtOnDuration_MASK                 0x70
#define D18F2x240_dct0_mp1_Reserved_7_7_OFFSET                  7
#define D18F2x240_dct0_mp1_Reserved_7_7_WIDTH                   1
#define D18F2x240_dct0_mp1_Reserved_7_7_MASK                    0x80
#define D18F2x240_dct0_mp1_WrOdtTrnOnDly_OFFSET                 8
#define D18F2x240_dct0_mp1_WrOdtTrnOnDly_WIDTH                  3
#define D18F2x240_dct0_mp1_WrOdtTrnOnDly_MASK                   0x700
#define D18F2x240_dct0_mp1_Reserved_11_11_OFFSET                11
#define D18F2x240_dct0_mp1_Reserved_11_11_WIDTH                 1
#define D18F2x240_dct0_mp1_Reserved_11_11_MASK                  0x800
#define D18F2x240_dct0_mp1_WrOdtOnDuration_OFFSET               12
#define D18F2x240_dct0_mp1_WrOdtOnDuration_WIDTH                3
#define D18F2x240_dct0_mp1_WrOdtOnDuration_MASK                 0x7000
#define D18F2x240_dct0_mp1_Reserved_31_15_OFFSET                15
#define D18F2x240_dct0_mp1_Reserved_31_15_WIDTH                 17
#define D18F2x240_dct0_mp1_Reserved_31_15_MASK                  0xffff8000

/// D18F2x240_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                            RdOdtTrnOnDly:4 ; ///<
    UINT32                                          RdOdtOnDuration:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            WrOdtTrnOnDly:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                          WrOdtOnDuration:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x240_dct0_mp1_STRUCT;

// **** D18F2x240_dct1_mp0 Register Definition ****
// Address
#define D18F2x240_dct1_mp0_ADDRESS                              0x240

// Type
#define D18F2x240_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x240_dct1_mp0_RdOdtTrnOnDly_OFFSET                 0
#define D18F2x240_dct1_mp0_RdOdtTrnOnDly_WIDTH                  4
#define D18F2x240_dct1_mp0_RdOdtTrnOnDly_MASK                   0xf
#define D18F2x240_dct1_mp0_RdOdtOnDuration_OFFSET               4
#define D18F2x240_dct1_mp0_RdOdtOnDuration_WIDTH                3
#define D18F2x240_dct1_mp0_RdOdtOnDuration_MASK                 0x70
#define D18F2x240_dct1_mp0_Reserved_7_7_OFFSET                  7
#define D18F2x240_dct1_mp0_Reserved_7_7_WIDTH                   1
#define D18F2x240_dct1_mp0_Reserved_7_7_MASK                    0x80
#define D18F2x240_dct1_mp0_WrOdtTrnOnDly_OFFSET                 8
#define D18F2x240_dct1_mp0_WrOdtTrnOnDly_WIDTH                  3
#define D18F2x240_dct1_mp0_WrOdtTrnOnDly_MASK                   0x700
#define D18F2x240_dct1_mp0_Reserved_11_11_OFFSET                11
#define D18F2x240_dct1_mp0_Reserved_11_11_WIDTH                 1
#define D18F2x240_dct1_mp0_Reserved_11_11_MASK                  0x800
#define D18F2x240_dct1_mp0_WrOdtOnDuration_OFFSET               12
#define D18F2x240_dct1_mp0_WrOdtOnDuration_WIDTH                3
#define D18F2x240_dct1_mp0_WrOdtOnDuration_MASK                 0x7000
#define D18F2x240_dct1_mp0_Reserved_31_15_OFFSET                15
#define D18F2x240_dct1_mp0_Reserved_31_15_WIDTH                 17
#define D18F2x240_dct1_mp0_Reserved_31_15_MASK                  0xffff8000

/// D18F2x240_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                            RdOdtTrnOnDly:4 ; ///<
    UINT32                                          RdOdtOnDuration:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            WrOdtTrnOnDly:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                          WrOdtOnDuration:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x240_dct1_mp0_STRUCT;

// **** D18F2x240_dct0_mp0 Register Definition ****
// Address
#define D18F2x240_dct0_mp0_ADDRESS                              0x240

// Type
#define D18F2x240_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x240_dct0_mp0_RdOdtTrnOnDly_OFFSET                 0
#define D18F2x240_dct0_mp0_RdOdtTrnOnDly_WIDTH                  4
#define D18F2x240_dct0_mp0_RdOdtTrnOnDly_MASK                   0xf
#define D18F2x240_dct0_mp0_RdOdtOnDuration_OFFSET               4
#define D18F2x240_dct0_mp0_RdOdtOnDuration_WIDTH                3
#define D18F2x240_dct0_mp0_RdOdtOnDuration_MASK                 0x70
#define D18F2x240_dct0_mp0_Reserved_7_7_OFFSET                  7
#define D18F2x240_dct0_mp0_Reserved_7_7_WIDTH                   1
#define D18F2x240_dct0_mp0_Reserved_7_7_MASK                    0x80
#define D18F2x240_dct0_mp0_WrOdtTrnOnDly_OFFSET                 8
#define D18F2x240_dct0_mp0_WrOdtTrnOnDly_WIDTH                  3
#define D18F2x240_dct0_mp0_WrOdtTrnOnDly_MASK                   0x700
#define D18F2x240_dct0_mp0_Reserved_11_11_OFFSET                11
#define D18F2x240_dct0_mp0_Reserved_11_11_WIDTH                 1
#define D18F2x240_dct0_mp0_Reserved_11_11_MASK                  0x800
#define D18F2x240_dct0_mp0_WrOdtOnDuration_OFFSET               12
#define D18F2x240_dct0_mp0_WrOdtOnDuration_WIDTH                3
#define D18F2x240_dct0_mp0_WrOdtOnDuration_MASK                 0x7000
#define D18F2x240_dct0_mp0_Reserved_31_15_OFFSET                15
#define D18F2x240_dct0_mp0_Reserved_31_15_WIDTH                 17
#define D18F2x240_dct0_mp0_Reserved_31_15_MASK                  0xffff8000

/// D18F2x240_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                            RdOdtTrnOnDly:4 ; ///<
    UINT32                                          RdOdtOnDuration:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            WrOdtTrnOnDly:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                          WrOdtOnDuration:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x240_dct0_mp0_STRUCT;

// **** D18F2x240_dct1_mp1 Register Definition ****
// Address
#define D18F2x240_dct1_mp1_ADDRESS                              0x240

// Type
#define D18F2x240_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x240_dct1_mp1_RdOdtTrnOnDly_OFFSET                 0
#define D18F2x240_dct1_mp1_RdOdtTrnOnDly_WIDTH                  4
#define D18F2x240_dct1_mp1_RdOdtTrnOnDly_MASK                   0xf
#define D18F2x240_dct1_mp1_RdOdtOnDuration_OFFSET               4
#define D18F2x240_dct1_mp1_RdOdtOnDuration_WIDTH                3
#define D18F2x240_dct1_mp1_RdOdtOnDuration_MASK                 0x70
#define D18F2x240_dct1_mp1_Reserved_7_7_OFFSET                  7
#define D18F2x240_dct1_mp1_Reserved_7_7_WIDTH                   1
#define D18F2x240_dct1_mp1_Reserved_7_7_MASK                    0x80
#define D18F2x240_dct1_mp1_WrOdtTrnOnDly_OFFSET                 8
#define D18F2x240_dct1_mp1_WrOdtTrnOnDly_WIDTH                  3
#define D18F2x240_dct1_mp1_WrOdtTrnOnDly_MASK                   0x700
#define D18F2x240_dct1_mp1_Reserved_11_11_OFFSET                11
#define D18F2x240_dct1_mp1_Reserved_11_11_WIDTH                 1
#define D18F2x240_dct1_mp1_Reserved_11_11_MASK                  0x800
#define D18F2x240_dct1_mp1_WrOdtOnDuration_OFFSET               12
#define D18F2x240_dct1_mp1_WrOdtOnDuration_WIDTH                3
#define D18F2x240_dct1_mp1_WrOdtOnDuration_MASK                 0x7000
#define D18F2x240_dct1_mp1_Reserved_31_15_OFFSET                15
#define D18F2x240_dct1_mp1_Reserved_31_15_WIDTH                 17
#define D18F2x240_dct1_mp1_Reserved_31_15_MASK                  0xffff8000

/// D18F2x240_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                            RdOdtTrnOnDly:4 ; ///<
    UINT32                                          RdOdtOnDuration:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            WrOdtTrnOnDly:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                          WrOdtOnDuration:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x240_dct1_mp1_STRUCT;

// **** D18F2x244_dct1 Register Definition ****
// Address
#define D18F2x244_dct1_ADDRESS                                  0x244

// Type
#define D18F2x244_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x244_dct1_PrtlChPDDynDly_OFFSET                    0
#define D18F2x244_dct1_PrtlChPDDynDly_WIDTH                     4
#define D18F2x244_dct1_PrtlChPDDynDly_MASK                      0xf
#define D18F2x244_dct1_Reserved_31_4_OFFSET                     4
#define D18F2x244_dct1_Reserved_31_4_WIDTH                      28
#define D18F2x244_dct1_Reserved_31_4_MASK                       0xfffffff0

/// D18F2x244_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                           PrtlChPDDynDly:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x244_dct1_STRUCT;

// **** D18F2x244_dct0 Register Definition ****
// Address
#define D18F2x244_dct0_ADDRESS                                  0x244

// Type
#define D18F2x244_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x244_dct0_PrtlChPDDynDly_OFFSET                    0
#define D18F2x244_dct0_PrtlChPDDynDly_WIDTH                     4
#define D18F2x244_dct0_PrtlChPDDynDly_MASK                      0xf
#define D18F2x244_dct0_Reserved_31_4_OFFSET                     4
#define D18F2x244_dct0_Reserved_31_4_WIDTH                      28
#define D18F2x244_dct0_Reserved_31_4_MASK                       0xfffffff0

/// D18F2x244_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                           PrtlChPDDynDly:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x244_dct0_STRUCT;

// **** D18F2x248_dct1_mp1 Register Definition ****
// Address
#define D18F2x248_dct1_mp1_ADDRESS                              0x248

// Type
#define D18F2x248_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x248_dct1_mp1_Txp_OFFSET                           0
#define D18F2x248_dct1_mp1_Txp_WIDTH                            4
#define D18F2x248_dct1_mp1_Txp_MASK                             0xf
#define D18F2x248_dct1_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x248_dct1_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x248_dct1_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x248_dct1_mp1_Txpdll_OFFSET                        8
#define D18F2x248_dct1_mp1_Txpdll_WIDTH                         5
#define D18F2x248_dct1_mp1_Txpdll_MASK                          0x1f00
#define D18F2x248_dct1_mp1_Reserved_15_13_OFFSET                13
#define D18F2x248_dct1_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x248_dct1_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x248_dct1_mp1_PchgPDEnDelay_OFFSET                 16
#define D18F2x248_dct1_mp1_PchgPDEnDelay_WIDTH                  6
#define D18F2x248_dct1_mp1_PchgPDEnDelay_MASK                   0x3f0000
#define D18F2x248_dct1_mp1_Reserved_23_22_OFFSET                22
#define D18F2x248_dct1_mp1_Reserved_23_22_WIDTH                 2
#define D18F2x248_dct1_mp1_Reserved_23_22_MASK                  0xc00000
#define D18F2x248_dct1_mp1_AggrPDDelay_OFFSET                   24
#define D18F2x248_dct1_mp1_AggrPDDelay_WIDTH                    6
#define D18F2x248_dct1_mp1_AggrPDDelay_MASK                     0x3f000000
#define D18F2x248_dct1_mp1_Reserved_30_30_OFFSET                30
#define D18F2x248_dct1_mp1_Reserved_30_30_WIDTH                 1
#define D18F2x248_dct1_mp1_Reserved_30_30_MASK                  0x40000000
#define D18F2x248_dct1_mp1_RxChMntClkEn_OFFSET                  31
#define D18F2x248_dct1_mp1_RxChMntClkEn_WIDTH                   1
#define D18F2x248_dct1_mp1_RxChMntClkEn_MASK                    0x80000000

/// D18F2x248_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Txp:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Txpdll:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                            PchgPDEnDelay:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                              AggrPDDelay:6 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             RxChMntClkEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x248_dct1_mp1_STRUCT;

// **** D18F2x248_dct0_mp1 Register Definition ****
// Address
#define D18F2x248_dct0_mp1_ADDRESS                              0x248

// Type
#define D18F2x248_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x248_dct0_mp1_Txp_OFFSET                           0
#define D18F2x248_dct0_mp1_Txp_WIDTH                            4
#define D18F2x248_dct0_mp1_Txp_MASK                             0xf
#define D18F2x248_dct0_mp1_Reserved_7_4_OFFSET                  4
#define D18F2x248_dct0_mp1_Reserved_7_4_WIDTH                   4
#define D18F2x248_dct0_mp1_Reserved_7_4_MASK                    0xf0
#define D18F2x248_dct0_mp1_Txpdll_OFFSET                        8
#define D18F2x248_dct0_mp1_Txpdll_WIDTH                         5
#define D18F2x248_dct0_mp1_Txpdll_MASK                          0x1f00
#define D18F2x248_dct0_mp1_Reserved_15_13_OFFSET                13
#define D18F2x248_dct0_mp1_Reserved_15_13_WIDTH                 3
#define D18F2x248_dct0_mp1_Reserved_15_13_MASK                  0xe000
#define D18F2x248_dct0_mp1_PchgPDEnDelay_OFFSET                 16
#define D18F2x248_dct0_mp1_PchgPDEnDelay_WIDTH                  6
#define D18F2x248_dct0_mp1_PchgPDEnDelay_MASK                   0x3f0000
#define D18F2x248_dct0_mp1_Reserved_23_22_OFFSET                22
#define D18F2x248_dct0_mp1_Reserved_23_22_WIDTH                 2
#define D18F2x248_dct0_mp1_Reserved_23_22_MASK                  0xc00000
#define D18F2x248_dct0_mp1_AggrPDDelay_OFFSET                   24
#define D18F2x248_dct0_mp1_AggrPDDelay_WIDTH                    6
#define D18F2x248_dct0_mp1_AggrPDDelay_MASK                     0x3f000000
#define D18F2x248_dct0_mp1_Reserved_30_30_OFFSET                30
#define D18F2x248_dct0_mp1_Reserved_30_30_WIDTH                 1
#define D18F2x248_dct0_mp1_Reserved_30_30_MASK                  0x40000000
#define D18F2x248_dct0_mp1_RxChMntClkEn_OFFSET                  31
#define D18F2x248_dct0_mp1_RxChMntClkEn_WIDTH                   1
#define D18F2x248_dct0_mp1_RxChMntClkEn_MASK                    0x80000000

/// D18F2x248_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Txp:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Txpdll:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                            PchgPDEnDelay:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                              AggrPDDelay:6 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             RxChMntClkEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x248_dct0_mp1_STRUCT;

// **** D18F2x248_dct1_mp0 Register Definition ****
// Address
#define D18F2x248_dct1_mp0_ADDRESS                              0x248

// Type
#define D18F2x248_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x248_dct1_mp0_Txp_OFFSET                           0
#define D18F2x248_dct1_mp0_Txp_WIDTH                            4
#define D18F2x248_dct1_mp0_Txp_MASK                             0xf
#define D18F2x248_dct1_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x248_dct1_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x248_dct1_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x248_dct1_mp0_Txpdll_OFFSET                        8
#define D18F2x248_dct1_mp0_Txpdll_WIDTH                         5
#define D18F2x248_dct1_mp0_Txpdll_MASK                          0x1f00
#define D18F2x248_dct1_mp0_Reserved_15_13_OFFSET                13
#define D18F2x248_dct1_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x248_dct1_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x248_dct1_mp0_PchgPDEnDelay_OFFSET                 16
#define D18F2x248_dct1_mp0_PchgPDEnDelay_WIDTH                  6
#define D18F2x248_dct1_mp0_PchgPDEnDelay_MASK                   0x3f0000
#define D18F2x248_dct1_mp0_Reserved_23_22_OFFSET                22
#define D18F2x248_dct1_mp0_Reserved_23_22_WIDTH                 2
#define D18F2x248_dct1_mp0_Reserved_23_22_MASK                  0xc00000
#define D18F2x248_dct1_mp0_AggrPDDelay_OFFSET                   24
#define D18F2x248_dct1_mp0_AggrPDDelay_WIDTH                    6
#define D18F2x248_dct1_mp0_AggrPDDelay_MASK                     0x3f000000
#define D18F2x248_dct1_mp0_Reserved_30_30_OFFSET                30
#define D18F2x248_dct1_mp0_Reserved_30_30_WIDTH                 1
#define D18F2x248_dct1_mp0_Reserved_30_30_MASK                  0x40000000
#define D18F2x248_dct1_mp0_RxChMntClkEn_OFFSET                  31
#define D18F2x248_dct1_mp0_RxChMntClkEn_WIDTH                   1
#define D18F2x248_dct1_mp0_RxChMntClkEn_MASK                    0x80000000

/// D18F2x248_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Txp:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Txpdll:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                            PchgPDEnDelay:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                              AggrPDDelay:6 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             RxChMntClkEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x248_dct1_mp0_STRUCT;

// **** D18F2x248_dct0_mp0 Register Definition ****
// Address
#define D18F2x248_dct0_mp0_ADDRESS                              0x248

// Type
#define D18F2x248_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x248_dct0_mp0_Txp_OFFSET                           0
#define D18F2x248_dct0_mp0_Txp_WIDTH                            4
#define D18F2x248_dct0_mp0_Txp_MASK                             0xf
#define D18F2x248_dct0_mp0_Reserved_7_4_OFFSET                  4
#define D18F2x248_dct0_mp0_Reserved_7_4_WIDTH                   4
#define D18F2x248_dct0_mp0_Reserved_7_4_MASK                    0xf0
#define D18F2x248_dct0_mp0_Txpdll_OFFSET                        8
#define D18F2x248_dct0_mp0_Txpdll_WIDTH                         5
#define D18F2x248_dct0_mp0_Txpdll_MASK                          0x1f00
#define D18F2x248_dct0_mp0_Reserved_15_13_OFFSET                13
#define D18F2x248_dct0_mp0_Reserved_15_13_WIDTH                 3
#define D18F2x248_dct0_mp0_Reserved_15_13_MASK                  0xe000
#define D18F2x248_dct0_mp0_PchgPDEnDelay_OFFSET                 16
#define D18F2x248_dct0_mp0_PchgPDEnDelay_WIDTH                  6
#define D18F2x248_dct0_mp0_PchgPDEnDelay_MASK                   0x3f0000
#define D18F2x248_dct0_mp0_Reserved_23_22_OFFSET                22
#define D18F2x248_dct0_mp0_Reserved_23_22_WIDTH                 2
#define D18F2x248_dct0_mp0_Reserved_23_22_MASK                  0xc00000
#define D18F2x248_dct0_mp0_AggrPDDelay_OFFSET                   24
#define D18F2x248_dct0_mp0_AggrPDDelay_WIDTH                    6
#define D18F2x248_dct0_mp0_AggrPDDelay_MASK                     0x3f000000
#define D18F2x248_dct0_mp0_Reserved_30_30_OFFSET                30
#define D18F2x248_dct0_mp0_Reserved_30_30_WIDTH                 1
#define D18F2x248_dct0_mp0_Reserved_30_30_MASK                  0x40000000
#define D18F2x248_dct0_mp0_RxChMntClkEn_OFFSET                  31
#define D18F2x248_dct0_mp0_RxChMntClkEn_WIDTH                   1
#define D18F2x248_dct0_mp0_RxChMntClkEn_MASK                    0x80000000

/// D18F2x248_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Txp:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Txpdll:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                            PchgPDEnDelay:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                              AggrPDDelay:6 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             RxChMntClkEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x248_dct0_mp0_STRUCT;

// **** D18F2x24C_dct0 Register Definition ****
// Address
#define D18F2x24C_dct0_ADDRESS                                  0x24c

// Type
#define D18F2x24C_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x24C_dct0_Tpd_OFFSET                               0
#define D18F2x24C_dct0_Tpd_WIDTH                                4
#define D18F2x24C_dct0_Tpd_MASK                                 0xf
#define D18F2x24C_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x24C_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x24C_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x24C_dct0_Tckesr_OFFSET                            8
#define D18F2x24C_dct0_Tckesr_WIDTH                             6
#define D18F2x24C_dct0_Tckesr_MASK                              0x3f00
#define D18F2x24C_dct0_Reserved_15_14_OFFSET                    14
#define D18F2x24C_dct0_Reserved_15_14_WIDTH                     2
#define D18F2x24C_dct0_Reserved_15_14_MASK                      0xc000
#define D18F2x24C_dct0_Tcksre_OFFSET                            16
#define D18F2x24C_dct0_Tcksre_WIDTH                             6
#define D18F2x24C_dct0_Tcksre_MASK                              0x3f0000
#define D18F2x24C_dct0_Reserved_23_22_OFFSET                    22
#define D18F2x24C_dct0_Reserved_23_22_WIDTH                     2
#define D18F2x24C_dct0_Reserved_23_22_MASK                      0xc00000
#define D18F2x24C_dct0_Tcksrx_OFFSET                            24
#define D18F2x24C_dct0_Tcksrx_WIDTH                             6
#define D18F2x24C_dct0_Tcksrx_MASK                              0x3f000000
#define D18F2x24C_dct0_Reserved_31_30_OFFSET                    30
#define D18F2x24C_dct0_Reserved_31_30_WIDTH                     2
#define D18F2x24C_dct0_Reserved_31_30_MASK                      0xc0000000

/// D18F2x24C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tpd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Tckesr:6 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                                   Tcksre:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                   Tcksrx:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x24C_dct0_STRUCT;

// **** D18F2x24C_dct1 Register Definition ****
// Address
#define D18F2x24C_dct1_ADDRESS                                  0x24c

// Type
#define D18F2x24C_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x24C_dct1_Tpd_OFFSET                               0
#define D18F2x24C_dct1_Tpd_WIDTH                                4
#define D18F2x24C_dct1_Tpd_MASK                                 0xf
#define D18F2x24C_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x24C_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x24C_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x24C_dct1_Tckesr_OFFSET                            8
#define D18F2x24C_dct1_Tckesr_WIDTH                             6
#define D18F2x24C_dct1_Tckesr_MASK                              0x3f00
#define D18F2x24C_dct1_Reserved_15_14_OFFSET                    14
#define D18F2x24C_dct1_Reserved_15_14_WIDTH                     2
#define D18F2x24C_dct1_Reserved_15_14_MASK                      0xc000
#define D18F2x24C_dct1_Tcksre_OFFSET                            16
#define D18F2x24C_dct1_Tcksre_WIDTH                             6
#define D18F2x24C_dct1_Tcksre_MASK                              0x3f0000
#define D18F2x24C_dct1_Reserved_23_22_OFFSET                    22
#define D18F2x24C_dct1_Reserved_23_22_WIDTH                     2
#define D18F2x24C_dct1_Reserved_23_22_MASK                      0xc00000
#define D18F2x24C_dct1_Tcksrx_OFFSET                            24
#define D18F2x24C_dct1_Tcksrx_WIDTH                             6
#define D18F2x24C_dct1_Tcksrx_MASK                              0x3f000000
#define D18F2x24C_dct1_Reserved_31_30_OFFSET                    30
#define D18F2x24C_dct1_Reserved_31_30_WIDTH                     2
#define D18F2x24C_dct1_Reserved_31_30_MASK                      0xc0000000

/// D18F2x24C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tpd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Tckesr:6 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                                   Tcksre:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                   Tcksrx:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x24C_dct1_STRUCT;

// **** D18F2x250_dct0 Register Definition ****
// Address
#define D18F2x250_dct0_ADDRESS                                  0x250

// Type
#define D18F2x250_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x250_dct0_Reserved_1_0_OFFSET                      0
#define D18F2x250_dct0_Reserved_1_0_WIDTH                       2
#define D18F2x250_dct0_Reserved_1_0_MASK                        0x3
#define D18F2x250_dct0_CmdTestEnable_OFFSET                     2
#define D18F2x250_dct0_CmdTestEnable_WIDTH                      1
#define D18F2x250_dct0_CmdTestEnable_MASK                       0x4
#define D18F2x250_dct0_ResetAllErr_OFFSET                       3
#define D18F2x250_dct0_ResetAllErr_WIDTH                        1
#define D18F2x250_dct0_ResetAllErr_MASK                         0x8
#define D18F2x250_dct0_StopOnErr_OFFSET                         4
#define D18F2x250_dct0_StopOnErr_WIDTH                          1
#define D18F2x250_dct0_StopOnErr_MASK                           0x10
#define D18F2x250_dct0_CmdType_OFFSET                           5
#define D18F2x250_dct0_CmdType_WIDTH                            3
#define D18F2x250_dct0_CmdType_MASK                             0xe0
#define D18F2x250_dct0_CmdTgt_OFFSET                            8
#define D18F2x250_dct0_CmdTgt_WIDTH                             2
#define D18F2x250_dct0_CmdTgt_MASK                              0x300
#define D18F2x250_dct0_TestStatus_OFFSET                        10
#define D18F2x250_dct0_TestStatus_WIDTH                         1
#define D18F2x250_dct0_TestStatus_MASK                          0x400
#define D18F2x250_dct0_SendCmd_OFFSET                           11
#define D18F2x250_dct0_SendCmd_WIDTH                            1
#define D18F2x250_dct0_SendCmd_MASK                             0x800
#define D18F2x250_dct0_CmdSendInProg_OFFSET                     12
#define D18F2x250_dct0_CmdSendInProg_WIDTH                      1
#define D18F2x250_dct0_CmdSendInProg_MASK                       0x1000
#define D18F2x250_dct0_Reserved_31_13_OFFSET                    13
#define D18F2x250_dct0_Reserved_31_13_WIDTH                     19
#define D18F2x250_dct0_Reserved_31_13_MASK                      0xffffe000

/// D18F2x250_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            CmdTestEnable:1 ; ///<
    UINT32                                              ResetAllErr:1 ; ///<
    UINT32                                                StopOnErr:1 ; ///<
    UINT32                                                  CmdType:3 ; ///<
    UINT32                                                   CmdTgt:2 ; ///<
    UINT32                                               TestStatus:1 ; ///<
    UINT32                                                  SendCmd:1 ; ///<
    UINT32                                            CmdSendInProg:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x250_dct0_STRUCT;

// **** D18F2x250_dct1 Register Definition ****
// Address
#define D18F2x250_dct1_ADDRESS                                  0x250

// Type
#define D18F2x250_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x250_dct1_Reserved_1_0_OFFSET                      0
#define D18F2x250_dct1_Reserved_1_0_WIDTH                       2
#define D18F2x250_dct1_Reserved_1_0_MASK                        0x3
#define D18F2x250_dct1_CmdTestEnable_OFFSET                     2
#define D18F2x250_dct1_CmdTestEnable_WIDTH                      1
#define D18F2x250_dct1_CmdTestEnable_MASK                       0x4
#define D18F2x250_dct1_ResetAllErr_OFFSET                       3
#define D18F2x250_dct1_ResetAllErr_WIDTH                        1
#define D18F2x250_dct1_ResetAllErr_MASK                         0x8
#define D18F2x250_dct1_StopOnErr_OFFSET                         4
#define D18F2x250_dct1_StopOnErr_WIDTH                          1
#define D18F2x250_dct1_StopOnErr_MASK                           0x10
#define D18F2x250_dct1_CmdType_OFFSET                           5
#define D18F2x250_dct1_CmdType_WIDTH                            3
#define D18F2x250_dct1_CmdType_MASK                             0xe0
#define D18F2x250_dct1_CmdTgt_OFFSET                            8
#define D18F2x250_dct1_CmdTgt_WIDTH                             2
#define D18F2x250_dct1_CmdTgt_MASK                              0x300
#define D18F2x250_dct1_TestStatus_OFFSET                        10
#define D18F2x250_dct1_TestStatus_WIDTH                         1
#define D18F2x250_dct1_TestStatus_MASK                          0x400
#define D18F2x250_dct1_SendCmd_OFFSET                           11
#define D18F2x250_dct1_SendCmd_WIDTH                            1
#define D18F2x250_dct1_SendCmd_MASK                             0x800
#define D18F2x250_dct1_CmdSendInProg_OFFSET                     12
#define D18F2x250_dct1_CmdSendInProg_WIDTH                      1
#define D18F2x250_dct1_CmdSendInProg_MASK                       0x1000
#define D18F2x250_dct1_Reserved_31_13_OFFSET                    13
#define D18F2x250_dct1_Reserved_31_13_WIDTH                     19
#define D18F2x250_dct1_Reserved_31_13_MASK                      0xffffe000

/// D18F2x250_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            CmdTestEnable:1 ; ///<
    UINT32                                              ResetAllErr:1 ; ///<
    UINT32                                                StopOnErr:1 ; ///<
    UINT32                                                  CmdType:3 ; ///<
    UINT32                                                   CmdTgt:2 ; ///<
    UINT32                                               TestStatus:1 ; ///<
    UINT32                                                  SendCmd:1 ; ///<
    UINT32                                            CmdSendInProg:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x250_dct1_STRUCT;

// **** D18F2x254_dct0 Register Definition ****
// Address
#define D18F2x254_dct0_ADDRESS                                  0x254

// Type
#define D18F2x254_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x254_dct0_TgtAddress_9_0__OFFSET                   0
#define D18F2x254_dct0_TgtAddress_9_0__WIDTH                    10
#define D18F2x254_dct0_TgtAddress_9_0__MASK                     0x3ff
#define D18F2x254_dct0_Reserved_20_10_OFFSET                    10
#define D18F2x254_dct0_Reserved_20_10_WIDTH                     11
#define D18F2x254_dct0_Reserved_20_10_MASK                      0x1ffc00
#define D18F2x254_dct0_TgtBank_OFFSET                           21
#define D18F2x254_dct0_TgtBank_WIDTH                            3
#define D18F2x254_dct0_TgtBank_MASK                             0xe00000
#define D18F2x254_dct0_TgtChipSelect_OFFSET                     24
#define D18F2x254_dct0_TgtChipSelect_WIDTH                      3
#define D18F2x254_dct0_TgtChipSelect_MASK                       0x7000000
#define D18F2x254_dct0_Reserved_31_27_OFFSET                    27
#define D18F2x254_dct0_Reserved_31_27_WIDTH                     5
#define D18F2x254_dct0_Reserved_31_27_MASK                      0xf8000000

/// D18F2x254_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                          TgtAddress_9_0_:10; ///<
    UINT32                                           Reserved_20_10:11; ///<
    UINT32                                                  TgtBank:3 ; ///<
    UINT32                                            TgtChipSelect:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x254_dct0_STRUCT;

// **** D18F2x254_dct1 Register Definition ****
// Address
#define D18F2x254_dct1_ADDRESS                                  0x254

// Type
#define D18F2x254_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x254_dct1_TgtAddress_9_0__OFFSET                   0
#define D18F2x254_dct1_TgtAddress_9_0__WIDTH                    10
#define D18F2x254_dct1_TgtAddress_9_0__MASK                     0x3ff
#define D18F2x254_dct1_Reserved_20_10_OFFSET                    10
#define D18F2x254_dct1_Reserved_20_10_WIDTH                     11
#define D18F2x254_dct1_Reserved_20_10_MASK                      0x1ffc00
#define D18F2x254_dct1_TgtBank_OFFSET                           21
#define D18F2x254_dct1_TgtBank_WIDTH                            3
#define D18F2x254_dct1_TgtBank_MASK                             0xe00000
#define D18F2x254_dct1_TgtChipSelect_OFFSET                     24
#define D18F2x254_dct1_TgtChipSelect_WIDTH                      3
#define D18F2x254_dct1_TgtChipSelect_MASK                       0x7000000
#define D18F2x254_dct1_Reserved_31_27_OFFSET                    27
#define D18F2x254_dct1_Reserved_31_27_WIDTH                     5
#define D18F2x254_dct1_Reserved_31_27_MASK                      0xf8000000

/// D18F2x254_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                          TgtAddress_9_0_:10; ///<
    UINT32                                           Reserved_20_10:11; ///<
    UINT32                                                  TgtBank:3 ; ///<
    UINT32                                            TgtChipSelect:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x254_dct1_STRUCT;

// **** D18F2x258_dct0 Register Definition ****
// Address
#define D18F2x258_dct0_ADDRESS                                  0x258

// Type
#define D18F2x258_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x258_dct0_TgtAddress_9_0__OFFSET                   0
#define D18F2x258_dct0_TgtAddress_9_0__WIDTH                    10
#define D18F2x258_dct0_TgtAddress_9_0__MASK                     0x3ff
#define D18F2x258_dct0_Reserved_20_10_OFFSET                    10
#define D18F2x258_dct0_Reserved_20_10_WIDTH                     11
#define D18F2x258_dct0_Reserved_20_10_MASK                      0x1ffc00
#define D18F2x258_dct0_TgtBank_OFFSET                           21
#define D18F2x258_dct0_TgtBank_WIDTH                            3
#define D18F2x258_dct0_TgtBank_MASK                             0xe00000
#define D18F2x258_dct0_TgtChipSelect_OFFSET                     24
#define D18F2x258_dct0_TgtChipSelect_WIDTH                      3
#define D18F2x258_dct0_TgtChipSelect_MASK                       0x7000000
#define D18F2x258_dct0_Reserved_31_27_OFFSET                    27
#define D18F2x258_dct0_Reserved_31_27_WIDTH                     5
#define D18F2x258_dct0_Reserved_31_27_MASK                      0xf8000000

/// D18F2x258_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                          TgtAddress_9_0_:10; ///<
    UINT32                                           Reserved_20_10:11; ///<
    UINT32                                                  TgtBank:3 ; ///<
    UINT32                                            TgtChipSelect:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x258_dct0_STRUCT;

// **** D18F2x258_dct1 Register Definition ****
// Address
#define D18F2x258_dct1_ADDRESS                                  0x258

// Type
#define D18F2x258_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x258_dct1_TgtAddress_9_0__OFFSET                   0
#define D18F2x258_dct1_TgtAddress_9_0__WIDTH                    10
#define D18F2x258_dct1_TgtAddress_9_0__MASK                     0x3ff
#define D18F2x258_dct1_Reserved_20_10_OFFSET                    10
#define D18F2x258_dct1_Reserved_20_10_WIDTH                     11
#define D18F2x258_dct1_Reserved_20_10_MASK                      0x1ffc00
#define D18F2x258_dct1_TgtBank_OFFSET                           21
#define D18F2x258_dct1_TgtBank_WIDTH                            3
#define D18F2x258_dct1_TgtBank_MASK                             0xe00000
#define D18F2x258_dct1_TgtChipSelect_OFFSET                     24
#define D18F2x258_dct1_TgtChipSelect_WIDTH                      3
#define D18F2x258_dct1_TgtChipSelect_MASK                       0x7000000
#define D18F2x258_dct1_Reserved_31_27_OFFSET                    27
#define D18F2x258_dct1_Reserved_31_27_WIDTH                     5
#define D18F2x258_dct1_Reserved_31_27_MASK                      0xf8000000

/// D18F2x258_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                          TgtAddress_9_0_:10; ///<
    UINT32                                           Reserved_20_10:11; ///<
    UINT32                                                  TgtBank:3 ; ///<
    UINT32                                            TgtChipSelect:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x258_dct1_STRUCT;


// **** D18F2x260_dct1 Register Definition ****
// Address
#define D18F2x260_dct1_ADDRESS                                  0x260

// Type
#define D18F2x260_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x260_dct1_CmdCount_OFFSET                          0
#define D18F2x260_dct1_CmdCount_WIDTH                           21
#define D18F2x260_dct1_CmdCount_MASK                            0x1fffff
#define D18F2x260_dct1_Reserved_31_21_OFFSET                    21
#define D18F2x260_dct1_Reserved_31_21_WIDTH                     11
#define D18F2x260_dct1_Reserved_31_21_MASK                      0xffe00000

/// D18F2x260_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                 CmdCount:21; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x260_dct1_STRUCT;

// **** D18F2x260_dct0 Register Definition ****
// Address
#define D18F2x260_dct0_ADDRESS                                  0x260

// Type
#define D18F2x260_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x260_dct0_CmdCount_OFFSET                          0
#define D18F2x260_dct0_CmdCount_WIDTH                           21
#define D18F2x260_dct0_CmdCount_MASK                            0x1fffff
#define D18F2x260_dct0_Reserved_31_21_OFFSET                    21
#define D18F2x260_dct0_Reserved_31_21_WIDTH                     11
#define D18F2x260_dct0_Reserved_31_21_MASK                      0xffe00000

/// D18F2x260_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                 CmdCount:21; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x260_dct0_STRUCT;

// **** D18F2x264_dct1 Register Definition ****
// Address
#define D18F2x264_dct1_ADDRESS                                  0x264

// Type
#define D18F2x264_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x264_dct1_ErrCnt_OFFSET                            0
#define D18F2x264_dct1_ErrCnt_WIDTH                             25
#define D18F2x264_dct1_ErrCnt_MASK                              0x1ffffff
#define D18F2x264_dct1_ErrDqNum_OFFSET                          25
#define D18F2x264_dct1_ErrDqNum_WIDTH                           7
#define D18F2x264_dct1_ErrDqNum_MASK                            0xfe000000

/// D18F2x264_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                   ErrCnt:25; ///<
    UINT32                                                 ErrDqNum:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x264_dct1_STRUCT;

// **** D18F2x264_dct0 Register Definition ****
// Address
#define D18F2x264_dct0_ADDRESS                                  0x264

// Type
#define D18F2x264_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x264_dct0_ErrCnt_OFFSET                            0
#define D18F2x264_dct0_ErrCnt_WIDTH                             25
#define D18F2x264_dct0_ErrCnt_MASK                              0x1ffffff
#define D18F2x264_dct0_ErrDqNum_OFFSET                          25
#define D18F2x264_dct0_ErrDqNum_WIDTH                           7
#define D18F2x264_dct0_ErrDqNum_MASK                            0xfe000000

/// D18F2x264_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                   ErrCnt:25; ///<
    UINT32                                                 ErrDqNum:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x264_dct0_STRUCT;

// **** D18F2x268_dct1 Register Definition ****
// Address
#define D18F2x268_dct1_ADDRESS                                  0x268

// Type
#define D18F2x268_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x268_dct1_NibbleErrSts_OFFSET                      0
#define D18F2x268_dct1_NibbleErrSts_WIDTH                       18
#define D18F2x268_dct1_NibbleErrSts_MASK                        0x3ffff
#define D18F2x268_dct1_Reserved_31_18_OFFSET                    18
#define D18F2x268_dct1_Reserved_31_18_WIDTH                     14
#define D18F2x268_dct1_Reserved_31_18_MASK                      0xfffc0000

/// D18F2x268_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             NibbleErrSts:18; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x268_dct1_STRUCT;

// **** D18F2x268_dct0 Register Definition ****
// Address
#define D18F2x268_dct0_ADDRESS                                  0x268

// Type
#define D18F2x268_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x268_dct0_NibbleErrSts_OFFSET                      0
#define D18F2x268_dct0_NibbleErrSts_WIDTH                       18
#define D18F2x268_dct0_NibbleErrSts_MASK                        0x3ffff
#define D18F2x268_dct0_Reserved_31_18_OFFSET                    18
#define D18F2x268_dct0_Reserved_31_18_WIDTH                     14
#define D18F2x268_dct0_Reserved_31_18_MASK                      0xfffc0000

/// D18F2x268_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             NibbleErrSts:18; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x268_dct0_STRUCT;

// **** D18F2x26C_dct1 Register Definition ****
// Address
#define D18F2x26C_dct1_ADDRESS                                  0x26c

// Type
#define D18F2x26C_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x26C_dct1_NibbleErr180Sts_OFFSET                   0
#define D18F2x26C_dct1_NibbleErr180Sts_WIDTH                    18
#define D18F2x26C_dct1_NibbleErr180Sts_MASK                     0x3ffff
#define D18F2x26C_dct1_Reserved_31_18_OFFSET                    18
#define D18F2x26C_dct1_Reserved_31_18_WIDTH                     14
#define D18F2x26C_dct1_Reserved_31_18_MASK                      0xfffc0000

/// D18F2x26C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                          NibbleErr180Sts:18; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x26C_dct1_STRUCT;

// **** D18F2x26C_dct0 Register Definition ****
// Address
#define D18F2x26C_dct0_ADDRESS                                  0x26c

// Type
#define D18F2x26C_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x26C_dct0_NibbleErr180Sts_OFFSET                   0
#define D18F2x26C_dct0_NibbleErr180Sts_WIDTH                    18
#define D18F2x26C_dct0_NibbleErr180Sts_MASK                     0x3ffff
#define D18F2x26C_dct0_Reserved_31_18_OFFSET                    18
#define D18F2x26C_dct0_Reserved_31_18_WIDTH                     14
#define D18F2x26C_dct0_Reserved_31_18_MASK                      0xfffc0000

/// D18F2x26C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                          NibbleErr180Sts:18; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x26C_dct0_STRUCT;

// **** D18F2x270_dct0 Register Definition ****
// Address
#define D18F2x270_dct0_ADDRESS                                  0x270

// Type
#define D18F2x270_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x270_dct0_DataPrbsSeed_OFFSET                      0
#define D18F2x270_dct0_DataPrbsSeed_WIDTH                       19
#define D18F2x270_dct0_DataPrbsSeed_MASK                        0x7ffff
#define D18F2x270_dct0_Reserved_23_19_OFFSET                    19
#define D18F2x270_dct0_Reserved_23_19_WIDTH                     5
#define D18F2x270_dct0_Reserved_23_19_MASK                      0xf80000
#define D18F2x270_dct0_Reserved_30_24_OFFSET                    24
#define D18F2x270_dct0_Reserved_30_24_WIDTH                     7
#define D18F2x270_dct0_Reserved_30_24_MASK                      0x7f000000
#define D18F2x270_dct0_Reserved_31_31_OFFSET                    31
#define D18F2x270_dct0_Reserved_31_31_WIDTH                     1
#define D18F2x270_dct0_Reserved_31_31_MASK                      0x80000000

/// D18F2x270_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             DataPrbsSeed:19; ///<
    UINT32                                           Reserved_23_19:5 ; ///<
    UINT32                                           Reserved_30_24:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x270_dct0_STRUCT;

// **** D18F2x270_dct1 Register Definition ****
// Address
#define D18F2x270_dct1_ADDRESS                                  0x270

// Type
#define D18F2x270_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x270_dct1_DataPrbsSeed_OFFSET                      0
#define D18F2x270_dct1_DataPrbsSeed_WIDTH                       19
#define D18F2x270_dct1_DataPrbsSeed_MASK                        0x7ffff
#define D18F2x270_dct1_Reserved_23_19_OFFSET                    19
#define D18F2x270_dct1_Reserved_23_19_WIDTH                     5
#define D18F2x270_dct1_Reserved_23_19_MASK                      0xf80000
#define D18F2x270_dct1_Reserved_30_24_OFFSET                    24
#define D18F2x270_dct1_Reserved_30_24_WIDTH                     7
#define D18F2x270_dct1_Reserved_30_24_MASK                      0x7f000000
#define D18F2x270_dct1_Reserved_31_31_OFFSET                    31
#define D18F2x270_dct1_Reserved_31_31_WIDTH                     1
#define D18F2x270_dct1_Reserved_31_31_MASK                      0x80000000

/// D18F2x270_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             DataPrbsSeed:19; ///<
    UINT32                                           Reserved_23_19:5 ; ///<
    UINT32                                           Reserved_30_24:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x270_dct1_STRUCT;

// **** D18F2x274_dct0 Register Definition ****
// Address
#define D18F2x274_dct0_ADDRESS                                  0x274

// Type
#define D18F2x274_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x274_dct0_DQMask_31_0__OFFSET                      0
#define D18F2x274_dct0_DQMask_31_0__WIDTH                       32
#define D18F2x274_dct0_DQMask_31_0__MASK                        0xffffffff

/// D18F2x274_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             DQMask_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x274_dct0_STRUCT;

// **** D18F2x274_dct1 Register Definition ****
// Address
#define D18F2x274_dct1_ADDRESS                                  0x274

// Type
#define D18F2x274_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x274_dct1_DQMask_31_0__OFFSET                      0
#define D18F2x274_dct1_DQMask_31_0__WIDTH                       32
#define D18F2x274_dct1_DQMask_31_0__MASK                        0xffffffff

/// D18F2x274_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             DQMask_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x274_dct1_STRUCT;

// **** D18F2x278_dct0 Register Definition ****
// Address
#define D18F2x278_dct0_ADDRESS                                  0x278

// Type
#define D18F2x278_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x278_dct0_DQMask_63_32__OFFSET                     0
#define D18F2x278_dct0_DQMask_63_32__WIDTH                      32
#define D18F2x278_dct0_DQMask_63_32__MASK                       0xffffffff

/// D18F2x278_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                            DQMask_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x278_dct0_STRUCT;

// **** D18F2x278_dct1 Register Definition ****
// Address
#define D18F2x278_dct1_ADDRESS                                  0x278

// Type
#define D18F2x278_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x278_dct1_DQMask_63_32__OFFSET                     0
#define D18F2x278_dct1_DQMask_63_32__WIDTH                      32
#define D18F2x278_dct1_DQMask_63_32__MASK                       0xffffffff

/// D18F2x278_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                            DQMask_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x278_dct1_STRUCT;

// **** D18F2x28C_dct0 Register Definition ****
// Address
#define D18F2x28C_dct0_ADDRESS                                  0x28c

// Type
#define D18F2x28C_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x28C_dct0_CmdAddress_17_0__OFFSET                  0
#define D18F2x28C_dct0_CmdAddress_17_0__WIDTH                   18
#define D18F2x28C_dct0_CmdAddress_17_0__MASK                    0x3ffff
#define D18F2x28C_dct0_Reserved_18_18_OFFSET                    18
#define D18F2x28C_dct0_Reserved_18_18_WIDTH                     1
#define D18F2x28C_dct0_Reserved_18_18_MASK                      0x40000
#define D18F2x28C_dct0_CmdBank_2_0__OFFSET                      19
#define D18F2x28C_dct0_CmdBank_2_0__WIDTH                       3
#define D18F2x28C_dct0_CmdBank_2_0__MASK                        0x380000
#define D18F2x28C_dct0_CmdChipSelect_OFFSET                     22
#define D18F2x28C_dct0_CmdChipSelect_WIDTH                      8
#define D18F2x28C_dct0_CmdChipSelect_MASK                       0x3fc00000
#define D18F2x28C_dct0_SendPchgCmd_OFFSET                       30
#define D18F2x28C_dct0_SendPchgCmd_WIDTH                        1
#define D18F2x28C_dct0_SendPchgCmd_MASK                         0x40000000
#define D18F2x28C_dct0_SendActCmd_OFFSET                        31
#define D18F2x28C_dct0_SendActCmd_WIDTH                         1
#define D18F2x28C_dct0_SendActCmd_MASK                          0x80000000

/// D18F2x28C_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                         CmdAddress_17_0_:18; ///<
    UINT32                                           Reserved_18_18:1 ; ///<
    UINT32                                             CmdBank_2_0_:3 ; ///<
    UINT32                                            CmdChipSelect:8 ; ///<
    UINT32                                              SendPchgCmd:1 ; ///<
    UINT32                                               SendActCmd:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x28C_dct0_STRUCT;

// **** D18F2x28C_dct1 Register Definition ****
// Address
#define D18F2x28C_dct1_ADDRESS                                  0x28c

// Type
#define D18F2x28C_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x28C_dct1_CmdAddress_17_0__OFFSET                  0
#define D18F2x28C_dct1_CmdAddress_17_0__WIDTH                   18
#define D18F2x28C_dct1_CmdAddress_17_0__MASK                    0x3ffff
#define D18F2x28C_dct1_Reserved_18_18_OFFSET                    18
#define D18F2x28C_dct1_Reserved_18_18_WIDTH                     1
#define D18F2x28C_dct1_Reserved_18_18_MASK                      0x40000
#define D18F2x28C_dct1_CmdBank_2_0__OFFSET                      19
#define D18F2x28C_dct1_CmdBank_2_0__WIDTH                       3
#define D18F2x28C_dct1_CmdBank_2_0__MASK                        0x380000
#define D18F2x28C_dct1_CmdChipSelect_OFFSET                     22
#define D18F2x28C_dct1_CmdChipSelect_WIDTH                      8
#define D18F2x28C_dct1_CmdChipSelect_MASK                       0x3fc00000
#define D18F2x28C_dct1_SendPchgCmd_OFFSET                       30
#define D18F2x28C_dct1_SendPchgCmd_WIDTH                        1
#define D18F2x28C_dct1_SendPchgCmd_MASK                         0x40000000
#define D18F2x28C_dct1_SendActCmd_OFFSET                        31
#define D18F2x28C_dct1_SendActCmd_WIDTH                         1
#define D18F2x28C_dct1_SendActCmd_MASK                          0x80000000

/// D18F2x28C_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                         CmdAddress_17_0_:18; ///<
    UINT32                                           Reserved_18_18:1 ; ///<
    UINT32                                             CmdBank_2_0_:3 ; ///<
    UINT32                                            CmdChipSelect:8 ; ///<
    UINT32                                              SendPchgCmd:1 ; ///<
    UINT32                                               SendActCmd:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x28C_dct1_STRUCT;

// **** D18F2x290_dct1 Register Definition ****
// Address
#define D18F2x290_dct1_ADDRESS                                  0x290

// Type
#define D18F2x290_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x290_dct1_ErrCmdNum_OFFSET                         0
#define D18F2x290_dct1_ErrCmdNum_WIDTH                          21
#define D18F2x290_dct1_ErrCmdNum_MASK                           0x1fffff
#define D18F2x290_dct1_Reserved_23_21_OFFSET                    21
#define D18F2x290_dct1_Reserved_23_21_WIDTH                     3
#define D18F2x290_dct1_Reserved_23_21_MASK                      0xe00000
#define D18F2x290_dct1_ErrBeatNum_OFFSET                        24
#define D18F2x290_dct1_ErrBeatNum_WIDTH                         3
#define D18F2x290_dct1_ErrBeatNum_MASK                          0x7000000
#define D18F2x290_dct1_Reserved_31_27_OFFSET                    27
#define D18F2x290_dct1_Reserved_31_27_WIDTH                     5
#define D18F2x290_dct1_Reserved_31_27_MASK                      0xf8000000

/// D18F2x290_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                                ErrCmdNum:21; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                               ErrBeatNum:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x290_dct1_STRUCT;

// **** D18F2x290_dct0 Register Definition ****
// Address
#define D18F2x290_dct0_ADDRESS                                  0x290

// Type
#define D18F2x290_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x290_dct0_ErrCmdNum_OFFSET                         0
#define D18F2x290_dct0_ErrCmdNum_WIDTH                          21
#define D18F2x290_dct0_ErrCmdNum_MASK                           0x1fffff
#define D18F2x290_dct0_Reserved_23_21_OFFSET                    21
#define D18F2x290_dct0_Reserved_23_21_WIDTH                     3
#define D18F2x290_dct0_Reserved_23_21_MASK                      0xe00000
#define D18F2x290_dct0_ErrBeatNum_OFFSET                        24
#define D18F2x290_dct0_ErrBeatNum_WIDTH                         3
#define D18F2x290_dct0_ErrBeatNum_MASK                          0x7000000
#define D18F2x290_dct0_Reserved_31_27_OFFSET                    27
#define D18F2x290_dct0_Reserved_31_27_WIDTH                     5
#define D18F2x290_dct0_Reserved_31_27_MASK                      0xf8000000

/// D18F2x290_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                                ErrCmdNum:21; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                               ErrBeatNum:3 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x290_dct0_STRUCT;

// **** D18F2x294_dct1 Register Definition ****
// Address
#define D18F2x294_dct1_ADDRESS                                  0x294

// Type
#define D18F2x294_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x294_dct1_DQErr_31_0__OFFSET                       0
#define D18F2x294_dct1_DQErr_31_0__WIDTH                        32
#define D18F2x294_dct1_DQErr_31_0__MASK                         0xffffffff

/// D18F2x294_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                              DQErr_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x294_dct1_STRUCT;

// **** D18F2x294_dct0 Register Definition ****
// Address
#define D18F2x294_dct0_ADDRESS                                  0x294

// Type
#define D18F2x294_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x294_dct0_DQErr_31_0__OFFSET                       0
#define D18F2x294_dct0_DQErr_31_0__WIDTH                        32
#define D18F2x294_dct0_DQErr_31_0__MASK                         0xffffffff

/// D18F2x294_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                              DQErr_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x294_dct0_STRUCT;

// **** D18F2x298_dct0 Register Definition ****
// Address
#define D18F2x298_dct0_ADDRESS                                  0x298

// Type
#define D18F2x298_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x298_dct0_DQErr_63_32__OFFSET                      0
#define D18F2x298_dct0_DQErr_63_32__WIDTH                       32
#define D18F2x298_dct0_DQErr_63_32__MASK                        0xffffffff

/// D18F2x298_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             DQErr_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x298_dct0_STRUCT;

// **** D18F2x298_dct1 Register Definition ****
// Address
#define D18F2x298_dct1_ADDRESS                                  0x298

// Type
#define D18F2x298_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x298_dct1_DQErr_63_32__OFFSET                      0
#define D18F2x298_dct1_DQErr_63_32__WIDTH                       32
#define D18F2x298_dct1_DQErr_63_32__MASK                        0xffffffff

/// D18F2x298_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             DQErr_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x298_dct1_STRUCT;

// **** D18F2x2E0_dct1 Register Definition ****
// Address
#define D18F2x2E0_dct1_ADDRESS                                  0x2e0

// Type
#define D18F2x2E0_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x2E0_dct1_CurMemPstate_OFFSET                      0
#define D18F2x2E0_dct1_CurMemPstate_WIDTH                       1
#define D18F2x2E0_dct1_CurMemPstate_MASK                        0x1
#define D18F2x2E0_dct1_Reserved_19_1_OFFSET                     1
#define D18F2x2E0_dct1_Reserved_19_1_WIDTH                      19
#define D18F2x2E0_dct1_Reserved_19_1_MASK                       0xffffe
#define D18F2x2E0_dct1_MxMrsEn_OFFSET                           20
#define D18F2x2E0_dct1_MxMrsEn_WIDTH                            3
#define D18F2x2E0_dct1_MxMrsEn_MASK                             0x700000
#define D18F2x2E0_dct1_Reserved_23_23_OFFSET                    23
#define D18F2x2E0_dct1_Reserved_23_23_WIDTH                     1
#define D18F2x2E0_dct1_Reserved_23_23_MASK                      0x800000
#define D18F2x2E0_dct1_M1MemClkFreq_OFFSET                      24
#define D18F2x2E0_dct1_M1MemClkFreq_WIDTH                       5
#define D18F2x2E0_dct1_M1MemClkFreq_MASK                        0x1f000000
#define D18F2x2E0_dct1_Reserved_29_29_OFFSET                    29
#define D18F2x2E0_dct1_Reserved_29_29_WIDTH                     1
#define D18F2x2E0_dct1_Reserved_29_29_MASK                      0x20000000
#define D18F2x2E0_dct1_FastMstateDis_OFFSET                     30
#define D18F2x2E0_dct1_FastMstateDis_WIDTH                      1
#define D18F2x2E0_dct1_FastMstateDis_MASK                       0x40000000
#define D18F2x2E0_dct1_Reserved_31_31_OFFSET                    31
#define D18F2x2E0_dct1_Reserved_31_31_WIDTH                     1
#define D18F2x2E0_dct1_Reserved_31_31_MASK                      0x80000000

/// D18F2x2E0_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             CurMemPstate:1 ; ///<
    UINT32                                            Reserved_19_1:19; ///<
    UINT32                                                  MxMrsEn:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                             M1MemClkFreq:5 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                            FastMstateDis:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E0_dct1_STRUCT;

// **** D18F2x2E0_dct0 Register Definition ****
// Address
#define D18F2x2E0_dct0_ADDRESS                                  0x2e0

// Type
#define D18F2x2E0_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x2E0_dct0_CurMemPstate_OFFSET                      0
#define D18F2x2E0_dct0_CurMemPstate_WIDTH                       1
#define D18F2x2E0_dct0_CurMemPstate_MASK                        0x1
#define D18F2x2E0_dct0_Reserved_19_1_OFFSET                     1
#define D18F2x2E0_dct0_Reserved_19_1_WIDTH                      19
#define D18F2x2E0_dct0_Reserved_19_1_MASK                       0xffffe
#define D18F2x2E0_dct0_MxMrsEn_OFFSET                           20
#define D18F2x2E0_dct0_MxMrsEn_WIDTH                            3
#define D18F2x2E0_dct0_MxMrsEn_MASK                             0x700000
#define D18F2x2E0_dct0_Reserved_23_23_OFFSET                    23
#define D18F2x2E0_dct0_Reserved_23_23_WIDTH                     1
#define D18F2x2E0_dct0_Reserved_23_23_MASK                      0x800000
#define D18F2x2E0_dct0_M1MemClkFreq_OFFSET                      24
#define D18F2x2E0_dct0_M1MemClkFreq_WIDTH                       5
#define D18F2x2E0_dct0_M1MemClkFreq_MASK                        0x1f000000
#define D18F2x2E0_dct0_Reserved_29_29_OFFSET                    29
#define D18F2x2E0_dct0_Reserved_29_29_WIDTH                     1
#define D18F2x2E0_dct0_Reserved_29_29_MASK                      0x20000000
#define D18F2x2E0_dct0_FastMstateDis_OFFSET                     30
#define D18F2x2E0_dct0_FastMstateDis_WIDTH                      1
#define D18F2x2E0_dct0_FastMstateDis_MASK                       0x40000000
#define D18F2x2E0_dct0_Reserved_31_31_OFFSET                    31
#define D18F2x2E0_dct0_Reserved_31_31_WIDTH                     1
#define D18F2x2E0_dct0_Reserved_31_31_MASK                      0x80000000

/// D18F2x2E0_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             CurMemPstate:1 ; ///<
    UINT32                                            Reserved_19_1:19; ///<
    UINT32                                                  MxMrsEn:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                             M1MemClkFreq:5 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                            FastMstateDis:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E0_dct0_STRUCT;

// **** D18F2x2E8_dct0_mp1 Register Definition ****
// Address
#define D18F2x2E8_dct0_mp1_ADDRESS                              0x2e8

// Type
#define D18F2x2E8_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x2E8_dct0_mp1_MxMr0_OFFSET                         0
#define D18F2x2E8_dct0_mp1_MxMr0_WIDTH                          16
#define D18F2x2E8_dct0_mp1_MxMr0_MASK                           0xffff
#define D18F2x2E8_dct0_mp1_MxMr1_OFFSET                         16
#define D18F2x2E8_dct0_mp1_MxMr1_WIDTH                          16
#define D18F2x2E8_dct0_mp1_MxMr1_MASK                           0xffff0000

/// D18F2x2E8_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr0:16; ///<
    UINT32                                                    MxMr1:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E8_dct0_mp1_STRUCT;

// **** D18F2x2E8_dct1_mp1 Register Definition ****
// Address
#define D18F2x2E8_dct1_mp1_ADDRESS                              0x2e8

// Type
#define D18F2x2E8_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x2E8_dct1_mp1_MxMr0_OFFSET                         0
#define D18F2x2E8_dct1_mp1_MxMr0_WIDTH                          16
#define D18F2x2E8_dct1_mp1_MxMr0_MASK                           0xffff
#define D18F2x2E8_dct1_mp1_MxMr1_OFFSET                         16
#define D18F2x2E8_dct1_mp1_MxMr1_WIDTH                          16
#define D18F2x2E8_dct1_mp1_MxMr1_MASK                           0xffff0000

/// D18F2x2E8_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr0:16; ///<
    UINT32                                                    MxMr1:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E8_dct1_mp1_STRUCT;

// **** D18F2x2E8_dct1_mp0 Register Definition ****
// Address
#define D18F2x2E8_dct1_mp0_ADDRESS                              0x2e8

// Type
#define D18F2x2E8_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x2E8_dct1_mp0_MxMr0_OFFSET                         0
#define D18F2x2E8_dct1_mp0_MxMr0_WIDTH                          16
#define D18F2x2E8_dct1_mp0_MxMr0_MASK                           0xffff
#define D18F2x2E8_dct1_mp0_MxMr1_OFFSET                         16
#define D18F2x2E8_dct1_mp0_MxMr1_WIDTH                          16
#define D18F2x2E8_dct1_mp0_MxMr1_MASK                           0xffff0000

/// D18F2x2E8_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr0:16; ///<
    UINT32                                                    MxMr1:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E8_dct1_mp0_STRUCT;

// **** D18F2x2E8_dct0_mp0 Register Definition ****
// Address
#define D18F2x2E8_dct0_mp0_ADDRESS                              0x2e8

// Type
#define D18F2x2E8_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x2E8_dct0_mp0_MxMr0_OFFSET                         0
#define D18F2x2E8_dct0_mp0_MxMr0_WIDTH                          16
#define D18F2x2E8_dct0_mp0_MxMr0_MASK                           0xffff
#define D18F2x2E8_dct0_mp0_MxMr1_OFFSET                         16
#define D18F2x2E8_dct0_mp0_MxMr1_WIDTH                          16
#define D18F2x2E8_dct0_mp0_MxMr1_MASK                           0xffff0000

/// D18F2x2E8_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr0:16; ///<
    UINT32                                                    MxMr1:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2E8_dct0_mp0_STRUCT;

// **** D18F2x2EC_dct0_mp0 Register Definition ****
// Address
#define D18F2x2EC_dct0_mp0_ADDRESS                              0x2ec

// Type
#define D18F2x2EC_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x2EC_dct0_mp0_MxMr2_OFFSET                         0
#define D18F2x2EC_dct0_mp0_MxMr2_WIDTH                          16
#define D18F2x2EC_dct0_mp0_MxMr2_MASK                           0xffff
#define D18F2x2EC_dct0_mp0_Reserved_31_16_OFFSET                16
#define D18F2x2EC_dct0_mp0_Reserved_31_16_WIDTH                 16
#define D18F2x2EC_dct0_mp0_Reserved_31_16_MASK                  0xffff0000

/// D18F2x2EC_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr2:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2EC_dct0_mp0_STRUCT;

// **** D18F2x2EC_dct0_mp1 Register Definition ****
// Address
#define D18F2x2EC_dct0_mp1_ADDRESS                              0x2ec

// Type
#define D18F2x2EC_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x2EC_dct0_mp1_MxMr2_OFFSET                         0
#define D18F2x2EC_dct0_mp1_MxMr2_WIDTH                          16
#define D18F2x2EC_dct0_mp1_MxMr2_MASK                           0xffff
#define D18F2x2EC_dct0_mp1_Reserved_31_16_OFFSET                16
#define D18F2x2EC_dct0_mp1_Reserved_31_16_WIDTH                 16
#define D18F2x2EC_dct0_mp1_Reserved_31_16_MASK                  0xffff0000

/// D18F2x2EC_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr2:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2EC_dct0_mp1_STRUCT;

// **** D18F2x2EC_dct1_mp1 Register Definition ****
// Address
#define D18F2x2EC_dct1_mp1_ADDRESS                              0x2ec

// Type
#define D18F2x2EC_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x2EC_dct1_mp1_MxMr2_OFFSET                         0
#define D18F2x2EC_dct1_mp1_MxMr2_WIDTH                          16
#define D18F2x2EC_dct1_mp1_MxMr2_MASK                           0xffff
#define D18F2x2EC_dct1_mp1_Reserved_31_16_OFFSET                16
#define D18F2x2EC_dct1_mp1_Reserved_31_16_WIDTH                 16
#define D18F2x2EC_dct1_mp1_Reserved_31_16_MASK                  0xffff0000

/// D18F2x2EC_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr2:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2EC_dct1_mp1_STRUCT;

// **** D18F2x2EC_dct1_mp0 Register Definition ****
// Address
#define D18F2x2EC_dct1_mp0_ADDRESS                              0x2ec

// Type
#define D18F2x2EC_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x2EC_dct1_mp0_MxMr2_OFFSET                         0
#define D18F2x2EC_dct1_mp0_MxMr2_WIDTH                          16
#define D18F2x2EC_dct1_mp0_MxMr2_MASK                           0xffff
#define D18F2x2EC_dct1_mp0_Reserved_31_16_OFFSET                16
#define D18F2x2EC_dct1_mp0_Reserved_31_16_WIDTH                 16
#define D18F2x2EC_dct1_mp0_Reserved_31_16_MASK                  0xffff0000

/// D18F2x2EC_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                    MxMr2:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2EC_dct1_mp0_STRUCT;

// **** D18F2x2F0_dct1_mp1 Register Definition ****
// Address
#define D18F2x2F0_dct1_mp1_ADDRESS                              0x2f0

// Type
#define D18F2x2F0_dct1_mp1_TYPE                                 TYPE_D18F2_dct1_mp1
// Field Data
#define D18F2x2F0_dct1_mp1_EffArbDis_OFFSET                     0
#define D18F2x2F0_dct1_mp1_EffArbDis_WIDTH                      1
#define D18F2x2F0_dct1_mp1_EffArbDis_MASK                       0x1
#define D18F2x2F0_dct1_mp1_Reserved_31_1_OFFSET                 1
#define D18F2x2F0_dct1_mp1_Reserved_31_1_WIDTH                  31
#define D18F2x2F0_dct1_mp1_Reserved_31_1_MASK                   0xfffffffe

/// D18F2x2F0_dct1_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                EffArbDis:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2F0_dct1_mp1_STRUCT;

// **** D18F2x2F0_dct0_mp1 Register Definition ****
// Address
#define D18F2x2F0_dct0_mp1_ADDRESS                              0x2f0

// Type
#define D18F2x2F0_dct0_mp1_TYPE                                 TYPE_D18F2_dct0_mp1
// Field Data
#define D18F2x2F0_dct0_mp1_EffArbDis_OFFSET                     0
#define D18F2x2F0_dct0_mp1_EffArbDis_WIDTH                      1
#define D18F2x2F0_dct0_mp1_EffArbDis_MASK                       0x1
#define D18F2x2F0_dct0_mp1_Reserved_31_1_OFFSET                 1
#define D18F2x2F0_dct0_mp1_Reserved_31_1_WIDTH                  31
#define D18F2x2F0_dct0_mp1_Reserved_31_1_MASK                   0xfffffffe

/// D18F2x2F0_dct0_mp1
typedef union {
  struct {                                                              ///<
    UINT32                                                EffArbDis:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2F0_dct0_mp1_STRUCT;

// **** D18F2x2F0_dct1_mp0 Register Definition ****
// Address
#define D18F2x2F0_dct1_mp0_ADDRESS                              0x2f0

// Type
#define D18F2x2F0_dct1_mp0_TYPE                                 TYPE_D18F2_dct1_mp0
// Field Data
#define D18F2x2F0_dct1_mp0_EffArbDis_OFFSET                     0
#define D18F2x2F0_dct1_mp0_EffArbDis_WIDTH                      1
#define D18F2x2F0_dct1_mp0_EffArbDis_MASK                       0x1
#define D18F2x2F0_dct1_mp0_Reserved_31_1_OFFSET                 1
#define D18F2x2F0_dct1_mp0_Reserved_31_1_WIDTH                  31
#define D18F2x2F0_dct1_mp0_Reserved_31_1_MASK                   0xfffffffe

/// D18F2x2F0_dct1_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                EffArbDis:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2F0_dct1_mp0_STRUCT;

// **** D18F2x2F0_dct0_mp0 Register Definition ****
// Address
#define D18F2x2F0_dct0_mp0_ADDRESS                              0x2f0

// Type
#define D18F2x2F0_dct0_mp0_TYPE                                 TYPE_D18F2_dct0_mp0
// Field Data
#define D18F2x2F0_dct0_mp0_EffArbDis_OFFSET                     0
#define D18F2x2F0_dct0_mp0_EffArbDis_WIDTH                      1
#define D18F2x2F0_dct0_mp0_EffArbDis_MASK                       0x1
#define D18F2x2F0_dct0_mp0_Reserved_31_1_OFFSET                 1
#define D18F2x2F0_dct0_mp0_Reserved_31_1_WIDTH                  31
#define D18F2x2F0_dct0_mp0_Reserved_31_1_MASK                   0xfffffffe

/// D18F2x2F0_dct0_mp0
typedef union {
  struct {                                                              ///<
    UINT32                                                EffArbDis:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x2F0_dct0_mp0_STRUCT;

// **** D18F2x400_dct1 Register Definition ****
// Address
#define D18F2x400_dct1_ADDRESS                                  0x400

// Type
#define D18F2x400_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x400_dct1_MctTokenLimit_OFFSET                     0
#define D18F2x400_dct1_MctTokenLimit_WIDTH                      4
#define D18F2x400_dct1_MctTokenLimit_MASK                       0xf
#define D18F2x400_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x400_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x400_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x400_dct1_GmcTokenLimit_OFFSET                     8
#define D18F2x400_dct1_GmcTokenLimit_WIDTH                      4
#define D18F2x400_dct1_GmcTokenLimit_MASK                       0xf00
#define D18F2x400_dct1_Reserved_15_12_OFFSET                    12
#define D18F2x400_dct1_Reserved_15_12_WIDTH                     4
#define D18F2x400_dct1_Reserved_15_12_MASK                      0xf000
#define D18F2x400_dct1_Reserved_31_16_OFFSET                    16
#define D18F2x400_dct1_Reserved_31_16_WIDTH                     16
#define D18F2x400_dct1_Reserved_31_16_MASK                      0xffff0000

/// D18F2x400_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                            MctTokenLimit:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                            GmcTokenLimit:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x400_dct1_STRUCT;

// **** D18F2x400_dct0 Register Definition ****
// Address
#define D18F2x400_dct0_ADDRESS                                  0x400

// Type
#define D18F2x400_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x400_dct0_MctTokenLimit_OFFSET                     0
#define D18F2x400_dct0_MctTokenLimit_WIDTH                      4
#define D18F2x400_dct0_MctTokenLimit_MASK                       0xf
#define D18F2x400_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x400_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x400_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x400_dct0_GmcTokenLimit_OFFSET                     8
#define D18F2x400_dct0_GmcTokenLimit_WIDTH                      4
#define D18F2x400_dct0_GmcTokenLimit_MASK                       0xf00
#define D18F2x400_dct0_Reserved_15_12_OFFSET                    12
#define D18F2x400_dct0_Reserved_15_12_WIDTH                     4
#define D18F2x400_dct0_Reserved_15_12_MASK                      0xf000
#define D18F2x400_dct0_Reserved_31_16_OFFSET                    16
#define D18F2x400_dct0_Reserved_31_16_WIDTH                     16
#define D18F2x400_dct0_Reserved_31_16_MASK                      0xffff0000

/// D18F2x400_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                            MctTokenLimit:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                            GmcTokenLimit:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x400_dct0_STRUCT;

// **** D18F2x404_dct0 Register Definition ****
// Address
#define D18F2x404_dct0_ADDRESS                                  0x404

// Type
#define D18F2x404_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x404_dct0_UrMctTokenLimit_OFFSET                   0
#define D18F2x404_dct0_UrMctTokenLimit_WIDTH                    4
#define D18F2x404_dct0_UrMctTokenLimit_MASK                     0xf
#define D18F2x404_dct0_UrMctMinTokens_OFFSET                    4
#define D18F2x404_dct0_UrMctMinTokens_WIDTH                     4
#define D18F2x404_dct0_UrMctMinTokens_MASK                      0xf0
#define D18F2x404_dct0_UrGmcTokenLimit_OFFSET                   8
#define D18F2x404_dct0_UrGmcTokenLimit_WIDTH                    4
#define D18F2x404_dct0_UrGmcTokenLimit_MASK                     0xf00
#define D18F2x404_dct0_UrGmcMinTokens_OFFSET                    12
#define D18F2x404_dct0_UrGmcMinTokens_WIDTH                     4
#define D18F2x404_dct0_UrGmcMinTokens_MASK                      0xf000
#define D18F2x404_dct0_UrgentTknDis_OFFSET                      16
#define D18F2x404_dct0_UrgentTknDis_WIDTH                       1
#define D18F2x404_dct0_UrgentTknDis_MASK                        0x10000
#define D18F2x404_dct0_Reserved_31_17_OFFSET                    17
#define D18F2x404_dct0_Reserved_31_17_WIDTH                     15
#define D18F2x404_dct0_Reserved_31_17_MASK                      0xfffe0000

/// D18F2x404_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                          UrMctTokenLimit:4 ; ///<
    UINT32                                           UrMctMinTokens:4 ; ///<
    UINT32                                          UrGmcTokenLimit:4 ; ///<
    UINT32                                           UrGmcMinTokens:4 ; ///<
    UINT32                                             UrgentTknDis:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x404_dct0_STRUCT;

// **** D18F2x404_dct1 Register Definition ****
// Address
#define D18F2x404_dct1_ADDRESS                                  0x404

// Type
#define D18F2x404_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x404_dct1_UrMctTokenLimit_OFFSET                   0
#define D18F2x404_dct1_UrMctTokenLimit_WIDTH                    4
#define D18F2x404_dct1_UrMctTokenLimit_MASK                     0xf
#define D18F2x404_dct1_UrMctMinTokens_OFFSET                    4
#define D18F2x404_dct1_UrMctMinTokens_WIDTH                     4
#define D18F2x404_dct1_UrMctMinTokens_MASK                      0xf0
#define D18F2x404_dct1_UrGmcTokenLimit_OFFSET                   8
#define D18F2x404_dct1_UrGmcTokenLimit_WIDTH                    4
#define D18F2x404_dct1_UrGmcTokenLimit_MASK                     0xf00
#define D18F2x404_dct1_UrGmcMinTokens_OFFSET                    12
#define D18F2x404_dct1_UrGmcMinTokens_WIDTH                     4
#define D18F2x404_dct1_UrGmcMinTokens_MASK                      0xf000
#define D18F2x404_dct1_UrgentTknDis_OFFSET                      16
#define D18F2x404_dct1_UrgentTknDis_WIDTH                       1
#define D18F2x404_dct1_UrgentTknDis_MASK                        0x10000
#define D18F2x404_dct1_Reserved_31_17_OFFSET                    17
#define D18F2x404_dct1_Reserved_31_17_WIDTH                     15
#define D18F2x404_dct1_Reserved_31_17_MASK                      0xfffe0000

/// D18F2x404_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                          UrMctTokenLimit:4 ; ///<
    UINT32                                           UrMctMinTokens:4 ; ///<
    UINT32                                          UrGmcTokenLimit:4 ; ///<
    UINT32                                           UrGmcMinTokens:4 ; ///<
    UINT32                                             UrgentTknDis:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x404_dct1_STRUCT;

// **** D18F2x408_dct1 Register Definition ****
// Address
#define D18F2x408_dct1_ADDRESS                                  0x408

// Type
#define D18F2x408_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x408_dct1_CpuElevPrioDis_OFFSET                    0
#define D18F2x408_dct1_CpuElevPrioDis_WIDTH                     1
#define D18F2x408_dct1_CpuElevPrioDis_MASK                      0x1
#define D18F2x408_dct1_TokenAllocSelect_OFFSET                  1
#define D18F2x408_dct1_TokenAllocSelect_WIDTH                   1
#define D18F2x408_dct1_TokenAllocSelect_MASK                    0x2
#define D18F2x408_dct1_Reserved_30_2_OFFSET                     2
#define D18F2x408_dct1_Reserved_30_2_WIDTH                      29
#define D18F2x408_dct1_Reserved_30_2_MASK                       0x7ffffffc
#define D18F2x408_dct1_DisHalfNclkPwrGate_OFFSET                31
#define D18F2x408_dct1_DisHalfNclkPwrGate_WIDTH                 1
#define D18F2x408_dct1_DisHalfNclkPwrGate_MASK                  0x80000000

/// D18F2x408_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                           CpuElevPrioDis:1 ; ///<
    UINT32                                         TokenAllocSelect:1 ; ///<
    UINT32                                            Reserved_30_2:29; ///<
    UINT32                                       DisHalfNclkPwrGate:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x408_dct1_STRUCT;

// **** D18F2x408_dct0 Register Definition ****
// Address
#define D18F2x408_dct0_ADDRESS                                  0x408

// Type
#define D18F2x408_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x408_dct0_CpuElevPrioDis_OFFSET                    0
#define D18F2x408_dct0_CpuElevPrioDis_WIDTH                     1
#define D18F2x408_dct0_CpuElevPrioDis_MASK                      0x1
#define D18F2x408_dct0_TokenAllocSelect_OFFSET                  1
#define D18F2x408_dct0_TokenAllocSelect_WIDTH                   1
#define D18F2x408_dct0_TokenAllocSelect_MASK                    0x2
#define D18F2x408_dct0_Reserved_30_2_OFFSET                     2
#define D18F2x408_dct0_Reserved_30_2_WIDTH                      29
#define D18F2x408_dct0_Reserved_30_2_MASK                       0x7ffffffc
#define D18F2x408_dct0_DisHalfNclkPwrGate_OFFSET                31
#define D18F2x408_dct0_DisHalfNclkPwrGate_WIDTH                 1
#define D18F2x408_dct0_DisHalfNclkPwrGate_MASK                  0x80000000

/// D18F2x408_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                           CpuElevPrioDis:1 ; ///<
    UINT32                                         TokenAllocSelect:1 ; ///<
    UINT32                                            Reserved_30_2:29; ///<
    UINT32                                       DisHalfNclkPwrGate:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x408_dct0_STRUCT;

// **** D18F2x420_dct0 Register Definition ****
// Address
#define D18F2x420_dct0_ADDRESS                                  0x420

// Type
#define D18F2x420_dct0_TYPE                                     TYPE_D18F2_dct0
// Field Data
#define D18F2x420_dct0_CmdRdPtrInit_OFFSET                      0
#define D18F2x420_dct0_CmdRdPtrInit_WIDTH                       4
#define D18F2x420_dct0_CmdRdPtrInit_MASK                        0xf
#define D18F2x420_dct0_Reserved_7_4_OFFSET                      4
#define D18F2x420_dct0_Reserved_7_4_WIDTH                       4
#define D18F2x420_dct0_Reserved_7_4_MASK                        0xf0
#define D18F2x420_dct0_SbRdPtrInit_OFFSET                       8
#define D18F2x420_dct0_SbRdPtrInit_WIDTH                        4
#define D18F2x420_dct0_SbRdPtrInit_MASK                         0xf00
#define D18F2x420_dct0_Reserved_31_12_OFFSET                    12
#define D18F2x420_dct0_Reserved_31_12_WIDTH                     20
#define D18F2x420_dct0_Reserved_31_12_MASK                      0xfffff000

/// D18F2x420_dct0
typedef union {
  struct {                                                              ///<
    UINT32                                             CmdRdPtrInit:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                              SbRdPtrInit:4 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x420_dct0_STRUCT;

// **** D18F2x420_dct1 Register Definition ****
// Address
#define D18F2x420_dct1_ADDRESS                                  0x420

// Type
#define D18F2x420_dct1_TYPE                                     TYPE_D18F2_dct1
// Field Data
#define D18F2x420_dct1_CmdRdPtrInit_OFFSET                      0
#define D18F2x420_dct1_CmdRdPtrInit_WIDTH                       4
#define D18F2x420_dct1_CmdRdPtrInit_MASK                        0xf
#define D18F2x420_dct1_Reserved_7_4_OFFSET                      4
#define D18F2x420_dct1_Reserved_7_4_WIDTH                       4
#define D18F2x420_dct1_Reserved_7_4_MASK                        0xf0
#define D18F2x420_dct1_SbRdPtrInit_OFFSET                       8
#define D18F2x420_dct1_SbRdPtrInit_WIDTH                        4
#define D18F2x420_dct1_SbRdPtrInit_MASK                         0xf00
#define D18F2x420_dct1_Reserved_31_12_OFFSET                    12
#define D18F2x420_dct1_Reserved_31_12_WIDTH                     20
#define D18F2x420_dct1_Reserved_31_12_MASK                      0xfffff000

/// D18F2x420_dct1
typedef union {
  struct {                                                              ///<
    UINT32                                             CmdRdPtrInit:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                              SbRdPtrInit:4 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x420_dct1_STRUCT;

// **** D18F3x00 Register Definition ****
// Address
#define D18F3x00_ADDRESS                                        0x0

// Type
#define D18F3x00_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x00_VendorID_OFFSET                                0
#define D18F3x00_VendorID_WIDTH                                 16
#define D18F3x00_VendorID_MASK                                  0xffff
#define D18F3x00_DeviceID_OFFSET                                16
#define D18F3x00_DeviceID_WIDTH                                 16
#define D18F3x00_DeviceID_MASK                                  0xffff0000

/// D18F3x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x00_STRUCT;

// **** D18F3x04 Register Definition ****
// Address
#define D18F3x04_ADDRESS                                        0x4

// Type
#define D18F3x04_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x04_Command_OFFSET                                 0
#define D18F3x04_Command_WIDTH                                  16
#define D18F3x04_Command_MASK                                   0xffff
#define D18F3x04_Status_OFFSET                                  16
#define D18F3x04_Status_WIDTH                                   16
#define D18F3x04_Status_MASK                                    0xffff0000

/// D18F3x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x04_STRUCT;

// **** D18F3x08 Register Definition ****
// Address
#define D18F3x08_ADDRESS                                        0x8

// Type
#define D18F3x08_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x08_RevID_OFFSET                                   0
#define D18F3x08_RevID_WIDTH                                    8
#define D18F3x08_RevID_MASK                                     0xff
#define D18F3x08_ClassCode_OFFSET                               8
#define D18F3x08_ClassCode_WIDTH                                24
#define D18F3x08_ClassCode_MASK                                 0xffffff00

/// D18F3x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x08_STRUCT;

// **** D18F3x0C Register Definition ****
// Address
#define D18F3x0C_ADDRESS                                        0xc

// Type
#define D18F3x0C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x0C_HeaderTypeReg_OFFSET                           0
#define D18F3x0C_HeaderTypeReg_WIDTH                            32
#define D18F3x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F3x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x0C_STRUCT;

// **** D18F3x34 Register Definition ****
// Address
#define D18F3x34_ADDRESS                                        0x34

// Type
#define D18F3x34_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x34_CapPtr_OFFSET                                  0
#define D18F3x34_CapPtr_WIDTH                                   8
#define D18F3x34_CapPtr_MASK                                    0xff
#define D18F3x34_Reserved_31_8_OFFSET                           8
#define D18F3x34_Reserved_31_8_WIDTH                            24
#define D18F3x34_Reserved_31_8_MASK                             0xffffff00

/// D18F3x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x34_STRUCT;

// **** D18F3x40 Register Definition ****
// Address
#define D18F3x40_ADDRESS                                        0x40

// Type
#define D18F3x40_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x40_Unused_4_0_OFFSET                              0
#define D18F3x40_Unused_4_0_WIDTH                               5
#define D18F3x40_Unused_4_0_MASK                                0x1f
#define D18F3x40_SyncPktEn_OFFSET                               5
#define D18F3x40_SyncPktEn_WIDTH                                1
#define D18F3x40_SyncPktEn_MASK                                 0x20
#define D18F3x40_Unused_7_6_OFFSET                              6
#define D18F3x40_Unused_7_6_WIDTH                               2
#define D18F3x40_Unused_7_6_MASK                                0xc0
#define D18F3x40_MstrAbortEn_OFFSET                             8
#define D18F3x40_MstrAbortEn_WIDTH                              1
#define D18F3x40_MstrAbortEn_MASK                               0x100
#define D18F3x40_TgtAbortEn_OFFSET                              9
#define D18F3x40_TgtAbortEn_WIDTH                               1
#define D18F3x40_TgtAbortEn_MASK                                0x200
#define D18F3x40_Unused_10_10_OFFSET                            10
#define D18F3x40_Unused_10_10_WIDTH                             1
#define D18F3x40_Unused_10_10_MASK                              0x400
#define D18F3x40_AtomicRMWEn_OFFSET                             11
#define D18F3x40_AtomicRMWEn_WIDTH                              1
#define D18F3x40_AtomicRMWEn_MASK                               0x800
#define D18F3x40_WDTRptEn_OFFSET                                12
#define D18F3x40_WDTRptEn_WIDTH                                 1
#define D18F3x40_WDTRptEn_MASK                                  0x1000
#define D18F3x40_Unused_15_13_OFFSET                            13
#define D18F3x40_Unused_15_13_WIDTH                             3
#define D18F3x40_Unused_15_13_MASK                              0xe000
#define D18F3x40_NbIntProtEn_OFFSET                             16
#define D18F3x40_NbIntProtEn_WIDTH                              1
#define D18F3x40_NbIntProtEn_MASK                               0x10000
#define D18F3x40_CpPktDatEn_OFFSET                              17
#define D18F3x40_CpPktDatEn_WIDTH                               1
#define D18F3x40_CpPktDatEn_MASK                                0x20000
#define D18F3x40_Unused_24_18_OFFSET                            18
#define D18F3x40_Unused_24_18_WIDTH                             7
#define D18F3x40_Unused_24_18_MASK                              0x1fc0000
#define D18F3x40_UsPwDatErrEn_OFFSET                            25
#define D18F3x40_UsPwDatErrEn_WIDTH                             1
#define D18F3x40_UsPwDatErrEn_MASK                              0x2000000
#define D18F3x40_NbArrayParEn_OFFSET                            26
#define D18F3x40_NbArrayParEn_WIDTH                             1
#define D18F3x40_NbArrayParEn_MASK                              0x4000000
#define D18F3x40_Unused_29_27_OFFSET                            27
#define D18F3x40_Unused_29_27_WIDTH                             3
#define D18F3x40_Unused_29_27_MASK                              0x38000000
#define D18F3x40_Unused_30_30_OFFSET                            30
#define D18F3x40_Unused_30_30_WIDTH                             1
#define D18F3x40_Unused_30_30_MASK                              0x40000000
#define D18F3x40_McaCpuDatErrEn_OFFSET                          31
#define D18F3x40_McaCpuDatErrEn_WIDTH                           1
#define D18F3x40_McaCpuDatErrEn_MASK                            0x80000000

/// D18F3x40
typedef union {
  struct {                                                              ///<
    UINT32                                               Unused_4_0:5 ; ///<
    UINT32                                                SyncPktEn:1 ; ///<
    UINT32                                               Unused_7_6:2 ; ///<
    UINT32                                              MstrAbortEn:1 ; ///<
    UINT32                                               TgtAbortEn:1 ; ///<
    UINT32                                             Unused_10_10:1 ; ///<
    UINT32                                              AtomicRMWEn:1 ; ///<
    UINT32                                                 WDTRptEn:1 ; ///<
    UINT32                                             Unused_15_13:3 ; ///<
    UINT32                                              NbIntProtEn:1 ; ///<
    UINT32                                               CpPktDatEn:1 ; ///<
    UINT32                                             Unused_24_18:7 ; ///<
    UINT32                                             UsPwDatErrEn:1 ; ///<
    UINT32                                             NbArrayParEn:1 ; ///<
    UINT32                                             Unused_29_27:3 ; ///<
    UINT32                                             Unused_30_30:1 ; ///<
    UINT32                                           McaCpuDatErrEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x40_STRUCT;

// **** D18F3x44 Register Definition ****
// Address
#define D18F3x44_ADDRESS                                        0x44

// Type
#define D18F3x44_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x44_Reserved_0_0_OFFSET                            0
#define D18F3x44_Reserved_0_0_WIDTH                             1
#define D18F3x44_Reserved_0_0_MASK                              0x1
#define D18F3x44_CpuRdDatErrEn_OFFSET                           1
#define D18F3x44_CpuRdDatErrEn_WIDTH                            1
#define D18F3x44_CpuRdDatErrEn_MASK                             0x2
#define D18F3x44_SyncPktGenDis_OFFSET                           3
#define D18F3x44_SyncPktGenDis_WIDTH                            1
#define D18F3x44_SyncPktGenDis_MASK                             0x8
#define D18F3x44_SyncPktPropDis_OFFSET                          4
#define D18F3x44_SyncPktPropDis_WIDTH                           1
#define D18F3x44_SyncPktPropDis_MASK                            0x10
#define D18F3x44_IoMstAbortDis_OFFSET                           5
#define D18F3x44_IoMstAbortDis_WIDTH                            1
#define D18F3x44_IoMstAbortDis_MASK                             0x20
#define D18F3x44_CpuErrDis_OFFSET                               6
#define D18F3x44_CpuErrDis_WIDTH                                1
#define D18F3x44_CpuErrDis_MASK                                 0x40
#define D18F3x44_IoErrDis_OFFSET                                7
#define D18F3x44_IoErrDis_WIDTH                                 1
#define D18F3x44_IoErrDis_MASK                                  0x80
#define D18F3x44_WDTDis_OFFSET                                  8
#define D18F3x44_WDTDis_WIDTH                                   1
#define D18F3x44_WDTDis_MASK                                    0x100
#define D18F3x44_WDTCntSel_2_0__OFFSET                          9
#define D18F3x44_WDTCntSel_2_0__WIDTH                           3
#define D18F3x44_WDTCntSel_2_0__MASK                            0xe00
#define D18F3x44_WDTBaseSel_OFFSET                              12
#define D18F3x44_WDTBaseSel_WIDTH                               2
#define D18F3x44_WDTBaseSel_MASK                                0x3000
#define D18F3x44_GenCrcErrByte0_OFFSET                          16
#define D18F3x44_GenCrcErrByte0_WIDTH                           1
#define D18F3x44_GenCrcErrByte0_MASK                            0x10000
#define D18F3x44_GenCrcErrByte1_OFFSET                          17
#define D18F3x44_GenCrcErrByte1_WIDTH                           1
#define D18F3x44_GenCrcErrByte1_MASK                            0x20000
#define D18F3x44_GenSubLinkSel_OFFSET                           18
#define D18F3x44_GenSubLinkSel_WIDTH                            2
#define D18F3x44_GenSubLinkSel_MASK                             0xc0000
#define D18F3x44_Reserved_23_22_WIDTH                           2
#define D18F3x44_Reserved_23_22_MASK                            0xc00000
#define D18F3x44_IoRdDatErrEn_OFFSET                            24
#define D18F3x44_IoRdDatErrEn_WIDTH                             1
#define D18F3x44_IoRdDatErrEn_MASK                              0x1000000
#define D18F3x44_DisPciCfgCpuErrRsp_OFFSET                      25
#define D18F3x44_DisPciCfgCpuErrRsp_WIDTH                       1
#define D18F3x44_DisPciCfgCpuErrRsp_MASK                        0x2000000
#define D18F3x44_FlagMcaCorrErr_OFFSET                          26
#define D18F3x44_FlagMcaCorrErr_WIDTH                           1
#define D18F3x44_FlagMcaCorrErr_MASK                            0x4000000
#define D18F3x44_NbMcaToMstCpuEn_OFFSET                         27
#define D18F3x44_NbMcaToMstCpuEn_WIDTH                          1
#define D18F3x44_NbMcaToMstCpuEn_MASK                           0x8000000
#define D18F3x44_DisTgtAbortCpuErrRsp_OFFSET                    28
#define D18F3x44_DisTgtAbortCpuErrRsp_WIDTH                     1
#define D18F3x44_DisTgtAbortCpuErrRsp_MASK                      0x10000000
#define D18F3x44_DisMstAbortCpuErrRsp_OFFSET                    29
#define D18F3x44_DisMstAbortCpuErrRsp_WIDTH                     1
#define D18F3x44_DisMstAbortCpuErrRsp_MASK                      0x20000000
#define D18F3x44_SyncOnDramAdrParErrEn_OFFSET                   30
#define D18F3x44_SyncOnDramAdrParErrEn_WIDTH                    1
#define D18F3x44_SyncOnDramAdrParErrEn_MASK                     0x40000000
#define D18F3x44_NbMcaLogEn_OFFSET                              31
#define D18F3x44_NbMcaLogEn_WIDTH                               1
#define D18F3x44_NbMcaLogEn_MASK                                0x80000000

/// D18F3x44
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                            CpuRdDatErrEn:1 ; ///<
    UINT32                                            SyncOnUcEccEn:1 ; ///<
    UINT32                                            SyncPktGenDis:1 ; ///<
    UINT32                                           SyncPktPropDis:1 ; ///<
    UINT32                                            IoMstAbortDis:1 ; ///<
    UINT32                                                CpuErrDis:1 ; ///<
    UINT32                                                 IoErrDis:1 ; ///<
    UINT32                                                   WDTDis:1 ; ///<
    UINT32                                           WDTCntSel_2_0_:3 ; ///<
    UINT32                                               WDTBaseSel:2 ; ///<
    UINT32                                               :2 ; ///<
    UINT32                                           GenCrcErrByte0:1 ; ///<
    UINT32                                           GenCrcErrByte1:1 ; ///<
    UINT32                                            GenSubLinkSel:2 ; ///<
    UINT32                                              :1 ; ///<
    UINT32                                           :1 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                             IoRdDatErrEn:1 ; ///<
    UINT32                                       DisPciCfgCpuErrRsp:1 ; ///<
    UINT32                                           FlagMcaCorrErr:1 ; ///<
    UINT32                                          NbMcaToMstCpuEn:1 ; ///<
    UINT32                                     DisTgtAbortCpuErrRsp:1 ; ///<
    UINT32                                     DisMstAbortCpuErrRsp:1 ; ///<
    UINT32                                    SyncOnDramAdrParErrEn:1 ; ///<
    UINT32                                               NbMcaLogEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x44_STRUCT;

// **** D18F3x48 Register Definition ****
// Address
#define D18F3x48_ADDRESS                                        0x48

// Type
#define D18F3x48_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x48_ErrorCode_OFFSET                               0
#define D18F3x48_ErrorCode_WIDTH                                16
#define D18F3x48_ErrorCode_MASK                                 0xffff
#define D18F3x48_ErrorCodeExt_OFFSET                            16
#define D18F3x48_ErrorCodeExt_WIDTH                             5
#define D18F3x48_ErrorCodeExt_MASK                              0x1f0000
#define D18F3x48_Reserved_23_21_OFFSET                          21
#define D18F3x48_Reserved_23_21_WIDTH                           3
#define D18F3x48_Reserved_23_21_MASK                            0xe00000
#define D18F3x48_Reserved_31_24_OFFSET                          24
#define D18F3x48_Reserved_31_24_WIDTH                           8
#define D18F3x48_Reserved_31_24_MASK                            0xff000000

/// D18F3x48
typedef union {
  struct {                                                              ///<
    UINT32                                                ErrorCode:16; ///<
    UINT32                                             ErrorCodeExt:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x48_STRUCT;

// **** D18F3x4C Register Definition ****
// Address
#define D18F3x4C_ADDRESS                                        0x4c

// Type
#define D18F3x4C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x4C_ErrCoreId_OFFSET                               0
#define D18F3x4C_ErrCoreId_WIDTH                                4
#define D18F3x4C_ErrCoreId_MASK                                 0xf
#define D18F3x4C_Reserved_39_37_OFFSET                          5
#define D18F3x4C_Reserved_39_37_WIDTH                           3
#define D18F3x4C_Reserved_39_37_MASK                            0xe0
#define D18F3x4C_Reserved_40_40_OFFSET                          8
#define D18F3x4C_Reserved_40_40_WIDTH                           1
#define D18F3x4C_Reserved_40_40_MASK                            0x100
#define D18F3x4C_SubLink_OFFSET                                 9
#define D18F3x4C_SubLink_WIDTH                                  1
#define D18F3x4C_SubLink_MASK                                   0x200
#define D18F3x4C_Reserved_43_42_OFFSET                          10
#define D18F3x4C_Reserved_43_42_WIDTH                           2
#define D18F3x4C_Reserved_43_42_MASK                            0xc00
#define D18F3x4C_Reserved_54_45_OFFSET                          13
#define D18F3x4C_Reserved_54_45_WIDTH                           10
#define D18F3x4C_Reserved_54_45_MASK                            0x7fe000
#define D18F3x4C_Reserved_55_55_OFFSET                          23
#define D18F3x4C_Reserved_55_55_WIDTH                           1
#define D18F3x4C_Reserved_55_55_MASK                            0x800000
#define D18F3x4C_ErrCoreIdVal_OFFSET                            24
#define D18F3x4C_ErrCoreIdVal_WIDTH                             1
#define D18F3x4C_ErrCoreIdVal_MASK                              0x1000000
#define D18F3x4C_PCC_OFFSET                                     25
#define D18F3x4C_PCC_WIDTH                                      1
#define D18F3x4C_PCC_MASK                                       0x2000000
#define D18F3x4C_AddrV_OFFSET                                   26
#define D18F3x4C_AddrV_WIDTH                                    1
#define D18F3x4C_AddrV_MASK                                     0x4000000
#define D18F3x4C_MiscV_OFFSET                                   27
#define D18F3x4C_MiscV_WIDTH                                    1
#define D18F3x4C_MiscV_MASK                                     0x8000000
#define D18F3x4C_En_OFFSET                                      28
#define D18F3x4C_En_WIDTH                                       1
#define D18F3x4C_En_MASK                                        0x10000000
#define D18F3x4C_UC_OFFSET                                      29
#define D18F3x4C_UC_WIDTH                                       1
#define D18F3x4C_UC_MASK                                        0x20000000
#define D18F3x4C_Overflow_OFFSET                                30
#define D18F3x4C_Overflow_WIDTH                                 1
#define D18F3x4C_Overflow_MASK                                  0x40000000
#define D18F3x4C_Val_OFFSET                                     31
#define D18F3x4C_Val_WIDTH                                      1
#define D18F3x4C_Val_MASK                                       0x80000000

/// D18F3x4C
typedef union {
  struct {                                                              ///<
    UINT32                                                ErrCoreId:4 ; ///<
    UINT32                                                     Link:1 ; ///<
    UINT32                                           Reserved_39_37:3 ; ///<
    UINT32                                           Reserved_40_40:1 ; ///<
    UINT32                                                  SubLink:1 ; ///<
    UINT32                                           Reserved_43_42:2 ; ///<
    UINT32                                           Reserved_44_44:1 ; ///<
    UINT32                                           Reserved_54_45:10; ///<
    UINT32                                           Reserved_55_55:1 ; ///<
    UINT32                                             ErrCoreIdVal:1 ; ///<
    UINT32                                                      PCC:1 ; ///<
    UINT32                                                    AddrV:1 ; ///<
    UINT32                                                    MiscV:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                                       UC:1 ; ///<
    UINT32                                                 Overflow:1 ; ///<
    UINT32                                                      Val:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x4C_STRUCT;

// **** D18F3x50 Register Definition ****
// Address
#define D18F3x50_ADDRESS                                        0x50

// Type
#define D18F3x50_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x50_Reserved_0_0_OFFSET                            0
#define D18F3x50_Reserved_0_0_WIDTH                             1
#define D18F3x50_Reserved_0_0_MASK                              0x1
#define D18F3x50_ErrAddr_31_1__OFFSET                           1
#define D18F3x50_ErrAddr_31_1__WIDTH                            31
#define D18F3x50_ErrAddr_31_1__MASK                             0xfffffffe

/// D18F3x50
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                            ErrAddr_31_1_:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x50_STRUCT;

// **** D18F3x54 Register Definition ****
// Address
#define D18F3x54_ADDRESS                                        0x54

// Type
#define D18F3x54_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x54_ErrAddr_47_32__OFFSET                          0
#define D18F3x54_ErrAddr_47_32__WIDTH                           16
#define D18F3x54_ErrAddr_47_32__MASK                            0xffff
#define D18F3x54_Reserved_63_48_OFFSET                          16
#define D18F3x54_Reserved_63_48_WIDTH                           16
#define D18F3x54_Reserved_63_48_MASK                            0xffff0000

/// D18F3x54
typedef union {
  struct {                                                              ///<
    UINT32                                           ErrAddr_47_32_:16; ///<
    UINT32                                           Reserved_63_48:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x54_STRUCT;

// **** D18F3x64 Register Definition ****
// Address
#define D18F3x64_ADDRESS                                        0x64

// Type
#define D18F3x64_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x64_HtcEn_OFFSET                                   0
#define D18F3x64_HtcEn_WIDTH                                    1
#define D18F3x64_HtcEn_MASK                                     0x1
#define D18F3x64_Reserved_3_1_OFFSET                            1
#define D18F3x64_Reserved_3_1_WIDTH                             3
#define D18F3x64_Reserved_3_1_MASK                              0xe
#define D18F3x64_HtcAct_OFFSET                                  4
#define D18F3x64_HtcAct_WIDTH                                   1
#define D18F3x64_HtcAct_MASK                                    0x10
#define D18F3x64_HtcActSts_OFFSET                               5
#define D18F3x64_HtcActSts_WIDTH                                1
#define D18F3x64_HtcActSts_MASK                                 0x20
#define D18F3x64_PslApicHiEn_OFFSET                             6
#define D18F3x64_PslApicHiEn_WIDTH                              1
#define D18F3x64_PslApicHiEn_MASK                               0x40
#define D18F3x64_PslApicLoEn_OFFSET                             7
#define D18F3x64_PslApicLoEn_WIDTH                              1
#define D18F3x64_PslApicLoEn_MASK                               0x80
#define D18F3x64_Reserved_15_8_OFFSET                           8
#define D18F3x64_Reserved_15_8_WIDTH                            8
#define D18F3x64_Reserved_15_8_MASK                             0xff00
#define D18F3x64_HtcTmpLmt_OFFSET                               16
#define D18F3x64_HtcTmpLmt_WIDTH                                7
#define D18F3x64_HtcTmpLmt_MASK                                 0x7f0000
#define D18F3x64_HtcSlewSel_OFFSET                              23
#define D18F3x64_HtcSlewSel_WIDTH                               1
#define D18F3x64_HtcSlewSel_MASK                                0x800000
#define D18F3x64_HtcHystLmt_OFFSET                              24
#define D18F3x64_HtcHystLmt_WIDTH                               4
#define D18F3x64_HtcHystLmt_MASK                                0xf000000
#define D18F3x64_HtcPstateLimit_OFFSET                          28
#define D18F3x64_HtcPstateLimit_WIDTH                           3
#define D18F3x64_HtcPstateLimit_MASK                            0x70000000
#define D18F3x64_Reserved_31_31_OFFSET                          31
#define D18F3x64_Reserved_31_31_WIDTH                           1
#define D18F3x64_Reserved_31_31_MASK                            0x80000000

/// D18F3x64
typedef union {
  struct {                                                              ///<
    UINT32                                                    HtcEn:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                                   HtcAct:1 ; ///<
    UINT32                                                HtcActSts:1 ; ///<
    UINT32                                              PslApicHiEn:1 ; ///<
    UINT32                                              PslApicLoEn:1 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                                HtcTmpLmt:7 ; ///<
    UINT32                                               HtcSlewSel:1 ; ///<
    UINT32                                               HtcHystLmt:4 ; ///<
    UINT32                                           HtcPstateLimit:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x64_STRUCT;

// **** D18F3x68 Register Definition ****
// Address
#define D18F3x68_ADDRESS                                        0x68

// Type
#define D18F3x68_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x68_Reserved_4_0_OFFSET                            0
#define D18F3x68_Reserved_4_0_WIDTH                             5
#define D18F3x68_Reserved_4_0_MASK                              0x1f
#define D18F3x68_SwPstateLimitEn_OFFSET                         5
#define D18F3x68_SwPstateLimitEn_WIDTH                          1
#define D18F3x68_SwPstateLimitEn_MASK                           0x20
#define D18F3x68_Reserved_27_6_OFFSET                           6
#define D18F3x68_Reserved_27_6_WIDTH                            22
#define D18F3x68_Reserved_27_6_MASK                             0xfffffc0
#define D18F3x68_SwPstateLimit_OFFSET                           28
#define D18F3x68_SwPstateLimit_WIDTH                            3
#define D18F3x68_SwPstateLimit_MASK                             0x70000000
#define D18F3x68_Reserved_31_31_OFFSET                          31
#define D18F3x68_Reserved_31_31_WIDTH                           1
#define D18F3x68_Reserved_31_31_MASK                            0x80000000

/// D18F3x68
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          SwPstateLimitEn:1 ; ///<
    UINT32                                            Reserved_27_6:22; ///<
    UINT32                                            SwPstateLimit:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x68_STRUCT;

// **** D18F3x6C Register Definition ****
// Address
#define D18F3x6C_ADDRESS                                        0x6c

// Type
#define D18F3x6C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x6C_UpReqDBC_OFFSET                                0
#define D18F3x6C_UpReqDBC_WIDTH                                 3
#define D18F3x6C_UpReqDBC_MASK                                  0x7
#define D18F3x6C_Reserved_3_3_OFFSET                            3
#define D18F3x6C_Reserved_3_3_WIDTH                             1
#define D18F3x6C_Reserved_3_3_MASK                              0x8
#define D18F3x6C_DnReqDBC_OFFSET                                4
#define D18F3x6C_DnReqDBC_WIDTH                                 2
#define D18F3x6C_DnReqDBC_MASK                                  0x30
#define D18F3x6C_DnRspDBC_OFFSET                                6
#define D18F3x6C_DnRspDBC_WIDTH                                 2
#define D18F3x6C_DnRspDBC_MASK                                  0xc0
#define D18F3x6C_Reserved_15_8_OFFSET                           8
#define D18F3x6C_Reserved_15_8_WIDTH                            8
#define D18F3x6C_Reserved_15_8_MASK                             0xff00
#define D18F3x6C_UpRspDBC_OFFSET                                16
#define D18F3x6C_UpRspDBC_WIDTH                                 3
#define D18F3x6C_UpRspDBC_MASK                                  0x70000
#define D18F3x6C_Reserved_27_19_OFFSET                          19
#define D18F3x6C_Reserved_27_19_WIDTH                           9
#define D18F3x6C_Reserved_27_19_MASK                            0xff80000
#define D18F3x6C_IsocRspDBC_OFFSET                              28
#define D18F3x6C_IsocRspDBC_WIDTH                               3
#define D18F3x6C_IsocRspDBC_MASK                                0x70000000
#define D18F3x6C_Reserved_31_31_OFFSET                          31
#define D18F3x6C_Reserved_31_31_WIDTH                           1
#define D18F3x6C_Reserved_31_31_MASK                            0x80000000

/// D18F3x6C
typedef union {
  struct {                                                              ///<
    UINT32                                                 UpReqDBC:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                 DnReqDBC:2 ; ///<
    UINT32                                                 DnRspDBC:2 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                                 UpRspDBC:3 ; ///<
    UINT32                                           Reserved_27_19:9 ; ///<
    UINT32                                               IsocRspDBC:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x6C_STRUCT;

// **** D18F3x70 Register Definition ****
// Address
#define D18F3x70_ADDRESS                                        0x70

// Type
#define D18F3x70_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x70_UpReqCBC_OFFSET                                0
#define D18F3x70_UpReqCBC_WIDTH                                 3
#define D18F3x70_UpReqCBC_MASK                                  0x7
#define D18F3x70_Reserved_3_3_OFFSET                            3
#define D18F3x70_Reserved_3_3_WIDTH                             1
#define D18F3x70_Reserved_3_3_MASK                              0x8
#define D18F3x70_DnReqCBC_OFFSET                                4
#define D18F3x70_DnReqCBC_WIDTH                                 2
#define D18F3x70_DnReqCBC_MASK                                  0x30
#define D18F3x70_DnRspCBC_OFFSET                                6
#define D18F3x70_DnRspCBC_WIDTH                                 2
#define D18F3x70_DnRspCBC_MASK                                  0xc0
#define D18F3x70_UpPreqCBC_OFFSET                               8
#define D18F3x70_UpPreqCBC_WIDTH                                3
#define D18F3x70_UpPreqCBC_MASK                                 0x700
#define D18F3x70_Reserved_11_11_OFFSET                          11
#define D18F3x70_Reserved_11_11_WIDTH                           1
#define D18F3x70_Reserved_11_11_MASK                            0x800
#define D18F3x70_DnPreqCBC_OFFSET                               12
#define D18F3x70_DnPreqCBC_WIDTH                                3
#define D18F3x70_DnPreqCBC_MASK                                 0x7000
#define D18F3x70_Reserved_15_15_OFFSET                          15
#define D18F3x70_Reserved_15_15_WIDTH                           1
#define D18F3x70_Reserved_15_15_MASK                            0x8000
#define D18F3x70_UpRspCBC_OFFSET                                16
#define D18F3x70_UpRspCBC_WIDTH                                 3
#define D18F3x70_UpRspCBC_MASK                                  0x70000
#define D18F3x70_Reserved_19_19_OFFSET                          19
#define D18F3x70_Reserved_19_19_WIDTH                           1
#define D18F3x70_Reserved_19_19_MASK                            0x80000
#define D18F3x70_IsocReqCBC_OFFSET                              20
#define D18F3x70_IsocReqCBC_WIDTH                               3
#define D18F3x70_IsocReqCBC_MASK                                0x700000
#define D18F3x70_Reserved_23_23_OFFSET                          23
#define D18F3x70_Reserved_23_23_WIDTH                           1
#define D18F3x70_Reserved_23_23_MASK                            0x800000
#define D18F3x70_IsocPreqCBC_OFFSET                             24
#define D18F3x70_IsocPreqCBC_WIDTH                              3
#define D18F3x70_IsocPreqCBC_MASK                               0x7000000
#define D18F3x70_Reserved_27_27_OFFSET                          27
#define D18F3x70_Reserved_27_27_WIDTH                           1
#define D18F3x70_Reserved_27_27_MASK                            0x8000000
#define D18F3x70_IsocRspCBC_OFFSET                              28
#define D18F3x70_IsocRspCBC_WIDTH                               3
#define D18F3x70_IsocRspCBC_MASK                                0x70000000
#define D18F3x70_Reserved_31_31_OFFSET                          31
#define D18F3x70_Reserved_31_31_WIDTH                           1
#define D18F3x70_Reserved_31_31_MASK                            0x80000000

/// D18F3x70
typedef union {
  struct {                                                              ///<
    UINT32                                                 UpReqCBC:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                 DnReqCBC:2 ; ///<
    UINT32                                                 DnRspCBC:2 ; ///<
    UINT32                                                UpPreqCBC:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                                DnPreqCBC:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                                 UpRspCBC:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                               IsocReqCBC:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                              IsocPreqCBC:3 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                               IsocRspCBC:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x70_STRUCT;

// **** D18F3x74 Register Definition ****
// Address
#define D18F3x74_ADDRESS                                        0x74

// Type
#define D18F3x74_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x74_UpReqCBC_OFFSET                                0
#define D18F3x74_UpReqCBC_WIDTH                                 3
#define D18F3x74_UpReqCBC_MASK                                  0x7
#define D18F3x74_Reserved_3_3_OFFSET                            3
#define D18F3x74_Reserved_3_3_WIDTH                             1
#define D18F3x74_Reserved_3_3_MASK                              0x8
#define D18F3x74_DnReqCBC_OFFSET                                4
#define D18F3x74_DnReqCBC_WIDTH                                 3
#define D18F3x74_DnReqCBC_MASK                                  0x70
#define D18F3x74_Reserved_7_7_OFFSET                            7
#define D18F3x74_Reserved_7_7_WIDTH                             1
#define D18F3x74_Reserved_7_7_MASK                              0x80
#define D18F3x74_UpPreqCBC_OFFSET                               8
#define D18F3x74_UpPreqCBC_WIDTH                                3
#define D18F3x74_UpPreqCBC_MASK                                 0x700
#define D18F3x74_Reserved_11_11_OFFSET                          11
#define D18F3x74_Reserved_11_11_WIDTH                           1
#define D18F3x74_Reserved_11_11_MASK                            0x800
#define D18F3x74_DnPreqCBC_OFFSET                               12
#define D18F3x74_DnPreqCBC_WIDTH                                3
#define D18F3x74_DnPreqCBC_MASK                                 0x7000
#define D18F3x74_Reserved_15_15_OFFSET                          15
#define D18F3x74_Reserved_15_15_WIDTH                           1
#define D18F3x74_Reserved_15_15_MASK                            0x8000
#define D18F3x74_ProbeCBC_OFFSET                                16
#define D18F3x74_ProbeCBC_WIDTH                                 4
#define D18F3x74_ProbeCBC_MASK                                  0xf0000
#define D18F3x74_IsocReqCBC_OFFSET                              20
#define D18F3x74_IsocReqCBC_WIDTH                               4
#define D18F3x74_IsocReqCBC_MASK                                0xf00000
#define D18F3x74_IsocPreqCBC_OFFSET                             24
#define D18F3x74_IsocPreqCBC_WIDTH                              3
#define D18F3x74_IsocPreqCBC_MASK                               0x7000000
#define D18F3x74_Reserved_27_27_OFFSET                          27
#define D18F3x74_Reserved_27_27_WIDTH                           1
#define D18F3x74_Reserved_27_27_MASK                            0x8000000
#define D18F3x74_DRReqCBC_OFFSET                                28
#define D18F3x74_DRReqCBC_WIDTH                                 4
#define D18F3x74_DRReqCBC_MASK                                  0xf0000000

/// D18F3x74
typedef union {
  struct {                                                              ///<
    UINT32                                                 UpReqCBC:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                                 DnReqCBC:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                UpPreqCBC:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                                DnPreqCBC:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                                 ProbeCBC:4 ; ///<
    UINT32                                               IsocReqCBC:4 ; ///<
    UINT32                                              IsocPreqCBC:3 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                                 DRReqCBC:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x74_STRUCT;

// **** D18F3x78 Register Definition ****
// Address
#define D18F3x78_ADDRESS                                        0x78

// Type
#define D18F3x78_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x78_RspCBC_OFFSET                                  0
#define D18F3x78_RspCBC_WIDTH                                   5
#define D18F3x78_RspCBC_MASK                                    0x1f
#define D18F3x78_Reserved_7_5_OFFSET                            5
#define D18F3x78_Reserved_7_5_WIDTH                             3
#define D18F3x78_Reserved_7_5_MASK                              0xe0
#define D18F3x78_ProbeCBC_OFFSET                                8
#define D18F3x78_ProbeCBC_WIDTH                                 5
#define D18F3x78_ProbeCBC_MASK                                  0x1f00
#define D18F3x78_Reserved_15_13_OFFSET                          13
#define D18F3x78_Reserved_15_13_WIDTH                           3
#define D18F3x78_Reserved_15_13_MASK                            0xe000
#define D18F3x78_RspDBC_OFFSET                                  16
#define D18F3x78_RspDBC_WIDTH                                   6
#define D18F3x78_RspDBC_MASK                                    0x3f0000
#define D18F3x78_Reserved_31_22_OFFSET                          22
#define D18F3x78_Reserved_31_22_WIDTH                           10
#define D18F3x78_Reserved_31_22_MASK                            0xffc00000

/// D18F3x78
typedef union {
  struct {                                                              ///<
    UINT32                                                   RspCBC:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                 ProbeCBC:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                   RspDBC:6 ; ///<
    UINT32                                           Reserved_31_22:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x78_STRUCT;

// **** D18F3x7C Register Definition ****
// Address
#define D18F3x7C_ADDRESS                                        0x7c

// Type
#define D18F3x7C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x7C_Xbar2SriFreeListCBC_OFFSET                     0
#define D18F3x7C_Xbar2SriFreeListCBC_WIDTH                      5
#define D18F3x7C_Xbar2SriFreeListCBC_MASK                       0x1f
#define D18F3x7C_Reserved_7_5_OFFSET                            5
#define D18F3x7C_Reserved_7_5_WIDTH                             3
#define D18F3x7C_Reserved_7_5_MASK                              0xe0
#define D18F3x7C_Sri2XbarFreeXreqCBC_OFFSET                     8
#define D18F3x7C_Sri2XbarFreeXreqCBC_WIDTH                      4
#define D18F3x7C_Sri2XbarFreeXreqCBC_MASK                       0xf00
#define D18F3x7C_Sri2XbarFreeRspCBC_OFFSET                      12
#define D18F3x7C_Sri2XbarFreeRspCBC_WIDTH                       4
#define D18F3x7C_Sri2XbarFreeRspCBC_MASK                        0xf000
#define D18F3x7C_Sri2XbarFreeXreqDBC_OFFSET                     16
#define D18F3x7C_Sri2XbarFreeXreqDBC_WIDTH                      4
#define D18F3x7C_Sri2XbarFreeXreqDBC_MASK                       0xf0000
#define D18F3x7C_Sri2XbarFreeRspDBC_OFFSET                      20
#define D18F3x7C_Sri2XbarFreeRspDBC_WIDTH                       3
#define D18F3x7C_Sri2XbarFreeRspDBC_MASK                        0x700000
#define D18F3x7C_ExtSrqFreeList_OFFSET                          23
#define D18F3x7C_ExtSrqFreeList_WIDTH                           4
#define D18F3x7C_ExtSrqFreeList_MASK                            0x7800000
#define D18F3x7C_Reserved_27_27_OFFSET                          27
#define D18F3x7C_Reserved_27_27_WIDTH                           1
#define D18F3x7C_Reserved_27_27_MASK                            0x8000000
#define D18F3x7C_Xbar2SriFreeListCBInc_OFFSET                   28
#define D18F3x7C_Xbar2SriFreeListCBInc_WIDTH                    3
#define D18F3x7C_Xbar2SriFreeListCBInc_MASK                     0x70000000
#define D18F3x7C_Reserved_31_31_OFFSET                          31
#define D18F3x7C_Reserved_31_31_WIDTH                           1
#define D18F3x7C_Reserved_31_31_MASK                            0x80000000

/// D18F3x7C
typedef union {
  struct {                                                              ///<
    UINT32                                      Xbar2SriFreeListCBC:5 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                      Sri2XbarFreeXreqCBC:4 ; ///<
    UINT32                                       Sri2XbarFreeRspCBC:4 ; ///<
    UINT32                                      Sri2XbarFreeXreqDBC:4 ; ///<
    UINT32                                       Sri2XbarFreeRspDBC:3 ; ///<
    UINT32                                           ExtSrqFreeList:4 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                    Xbar2SriFreeListCBInc:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x7C_STRUCT;

// **** D18F3x80 Register Definition ****
// Address
#define D18F3x80_ADDRESS                                        0x80

// Type
#define D18F3x80_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x80_CpuPrbEnSmafAct0_OFFSET                        0
#define D18F3x80_CpuPrbEnSmafAct0_WIDTH                         1
#define D18F3x80_CpuPrbEnSmafAct0_MASK                          0x1
#define D18F3x80_NbLowPwrEnSmafAct0_OFFSET                      1
#define D18F3x80_NbLowPwrEnSmafAct0_WIDTH                       1
#define D18F3x80_NbLowPwrEnSmafAct0_MASK                        0x2
#define D18F3x80_NbGateEnSmafAct0_OFFSET                        2
#define D18F3x80_NbGateEnSmafAct0_WIDTH                         1
#define D18F3x80_NbGateEnSmafAct0_MASK                          0x4
#define D18F3x80_Reserved_4_3_OFFSET                            3
#define D18F3x80_Reserved_4_3_WIDTH                             2
#define D18F3x80_Reserved_4_3_MASK                              0x18
#define D18F3x80_ClkDivisorSmafAct0_OFFSET                      5
#define D18F3x80_ClkDivisorSmafAct0_WIDTH                       3
#define D18F3x80_ClkDivisorSmafAct0_MASK                        0xe0
#define D18F3x80_CpuPrbEnSmafAct1_OFFSET                        8
#define D18F3x80_CpuPrbEnSmafAct1_WIDTH                         1
#define D18F3x80_CpuPrbEnSmafAct1_MASK                          0x100
#define D18F3x80_NbLowPwrEnSmafAct1_OFFSET                      9
#define D18F3x80_NbLowPwrEnSmafAct1_WIDTH                       1
#define D18F3x80_NbLowPwrEnSmafAct1_MASK                        0x200
#define D18F3x80_NbGateEnSmafAct1_OFFSET                        10
#define D18F3x80_NbGateEnSmafAct1_WIDTH                         1
#define D18F3x80_NbGateEnSmafAct1_MASK                          0x400
#define D18F3x80_Reserved_12_11_OFFSET                          11
#define D18F3x80_Reserved_12_11_WIDTH                           2
#define D18F3x80_Reserved_12_11_MASK                            0x1800
#define D18F3x80_ClkDivisorSmafAct1_OFFSET                      13
#define D18F3x80_ClkDivisorSmafAct1_WIDTH                       3
#define D18F3x80_ClkDivisorSmafAct1_MASK                        0xe000
#define D18F3x80_CpuPrbEnSmafAct2_OFFSET                        16
#define D18F3x80_CpuPrbEnSmafAct2_WIDTH                         1
#define D18F3x80_CpuPrbEnSmafAct2_MASK                          0x10000
#define D18F3x80_NbLowPwrEnSmafAct2_OFFSET                      17
#define D18F3x80_NbLowPwrEnSmafAct2_WIDTH                       1
#define D18F3x80_NbLowPwrEnSmafAct2_MASK                        0x20000
#define D18F3x80_NbGateEnSmafAct2_OFFSET                        18
#define D18F3x80_NbGateEnSmafAct2_WIDTH                         1
#define D18F3x80_NbGateEnSmafAct2_MASK                          0x40000
#define D18F3x80_Reserved_20_19_OFFSET                          19
#define D18F3x80_Reserved_20_19_WIDTH                           2
#define D18F3x80_Reserved_20_19_MASK                            0x180000
#define D18F3x80_ClkDivisorSmafAct2_OFFSET                      21
#define D18F3x80_ClkDivisorSmafAct2_WIDTH                       3
#define D18F3x80_ClkDivisorSmafAct2_MASK                        0xe00000
#define D18F3x80_CpuPrbEnSmafAct3_OFFSET                        24
#define D18F3x80_CpuPrbEnSmafAct3_WIDTH                         1
#define D18F3x80_CpuPrbEnSmafAct3_MASK                          0x1000000
#define D18F3x80_NbLowPwrEnSmafAct3_OFFSET                      25
#define D18F3x80_NbLowPwrEnSmafAct3_WIDTH                       1
#define D18F3x80_NbLowPwrEnSmafAct3_MASK                        0x2000000
#define D18F3x80_NbGateEnSmafAct3_OFFSET                        26
#define D18F3x80_NbGateEnSmafAct3_WIDTH                         1
#define D18F3x80_NbGateEnSmafAct3_MASK                          0x4000000
#define D18F3x80_Reserved_28_27_OFFSET                          27
#define D18F3x80_Reserved_28_27_WIDTH                           2
#define D18F3x80_Reserved_28_27_MASK                            0x18000000
#define D18F3x80_ClkDivisorSmafAct3_OFFSET                      29
#define D18F3x80_ClkDivisorSmafAct3_WIDTH                       3
#define D18F3x80_ClkDivisorSmafAct3_MASK                        0xe0000000

/// D18F3x80
typedef union {
  struct {                                                              ///<
    UINT32                                         CpuPrbEnSmafAct0:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct0:1 ; ///<
    UINT32                                         NbGateEnSmafAct0:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                       ClkDivisorSmafAct0:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct1:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct1:1 ; ///<
    UINT32                                         NbGateEnSmafAct1:1 ; ///<
    UINT32                                           Reserved_12_11:2 ; ///<
    UINT32                                       ClkDivisorSmafAct1:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct2:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct2:1 ; ///<
    UINT32                                         NbGateEnSmafAct2:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                       ClkDivisorSmafAct2:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct3:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct3:1 ; ///<
    UINT32                                         NbGateEnSmafAct3:1 ; ///<
    UINT32                                           Reserved_28_27:2 ; ///<
    UINT32                                       ClkDivisorSmafAct3:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x80_STRUCT;

// **** D18F3x84 Register Definition ****
// Address
#define D18F3x84_ADDRESS                                        0x84

// Type
#define D18F3x84_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x84_CpuPrbEnSmafAct4_OFFSET                        0
#define D18F3x84_CpuPrbEnSmafAct4_WIDTH                         1
#define D18F3x84_CpuPrbEnSmafAct4_MASK                          0x1
#define D18F3x84_NbLowPwrEnSmafAct4_OFFSET                      1
#define D18F3x84_NbLowPwrEnSmafAct4_WIDTH                       1
#define D18F3x84_NbLowPwrEnSmafAct4_MASK                        0x2
#define D18F3x84_NbGateEnSmafAct4_OFFSET                        2
#define D18F3x84_NbGateEnSmafAct4_WIDTH                         1
#define D18F3x84_NbGateEnSmafAct4_MASK                          0x4
#define D18F3x84_Reserved_4_3_OFFSET                            3
#define D18F3x84_Reserved_4_3_WIDTH                             2
#define D18F3x84_Reserved_4_3_MASK                              0x18
#define D18F3x84_ClkDivisorSmafAct4_OFFSET                      5
#define D18F3x84_ClkDivisorSmafAct4_WIDTH                       3
#define D18F3x84_ClkDivisorSmafAct4_MASK                        0xe0
#define D18F3x84_CpuPrbEnSmafAct5_OFFSET                        8
#define D18F3x84_CpuPrbEnSmafAct5_WIDTH                         1
#define D18F3x84_CpuPrbEnSmafAct5_MASK                          0x100
#define D18F3x84_NbLowPwrEnSmafAct5_OFFSET                      9
#define D18F3x84_NbLowPwrEnSmafAct5_WIDTH                       1
#define D18F3x84_NbLowPwrEnSmafAct5_MASK                        0x200
#define D18F3x84_NbGateEnSmafAct5_OFFSET                        10
#define D18F3x84_NbGateEnSmafAct5_WIDTH                         1
#define D18F3x84_NbGateEnSmafAct5_MASK                          0x400
#define D18F3x84_Reserved_12_11_OFFSET                          11
#define D18F3x84_Reserved_12_11_WIDTH                           2
#define D18F3x84_Reserved_12_11_MASK                            0x1800
#define D18F3x84_ClkDivisorSmafAct5_OFFSET                      13
#define D18F3x84_ClkDivisorSmafAct5_WIDTH                       3
#define D18F3x84_ClkDivisorSmafAct5_MASK                        0xe000
#define D18F3x84_CpuPrbEnSmafAct6_OFFSET                        16
#define D18F3x84_CpuPrbEnSmafAct6_WIDTH                         1
#define D18F3x84_CpuPrbEnSmafAct6_MASK                          0x10000
#define D18F3x84_NbLowPwrEnSmafAct6_OFFSET                      17
#define D18F3x84_NbLowPwrEnSmafAct6_WIDTH                       1
#define D18F3x84_NbLowPwrEnSmafAct6_MASK                        0x20000
#define D18F3x84_NbGateEnSmafAct6_OFFSET                        18
#define D18F3x84_NbGateEnSmafAct6_WIDTH                         1
#define D18F3x84_NbGateEnSmafAct6_MASK                          0x40000
#define D18F3x84_Reserved_20_19_OFFSET                          19
#define D18F3x84_Reserved_20_19_WIDTH                           2
#define D18F3x84_Reserved_20_19_MASK                            0x180000
#define D18F3x84_ClkDivisorSmafAct6_OFFSET                      21
#define D18F3x84_ClkDivisorSmafAct6_WIDTH                       3
#define D18F3x84_ClkDivisorSmafAct6_MASK                        0xe00000
#define D18F3x84_CpuPrbEnSmafAct7_OFFSET                        24
#define D18F3x84_CpuPrbEnSmafAct7_WIDTH                         1
#define D18F3x84_CpuPrbEnSmafAct7_MASK                          0x1000000
#define D18F3x84_NbLowPwrEnSmafAct7_OFFSET                      25
#define D18F3x84_NbLowPwrEnSmafAct7_WIDTH                       1
#define D18F3x84_NbLowPwrEnSmafAct7_MASK                        0x2000000
#define D18F3x84_NbGateEnSmafAct7_OFFSET                        26
#define D18F3x84_NbGateEnSmafAct7_WIDTH                         1
#define D18F3x84_NbGateEnSmafAct7_MASK                          0x4000000
#define D18F3x84_Reserved_28_27_OFFSET                          27
#define D18F3x84_Reserved_28_27_WIDTH                           2
#define D18F3x84_Reserved_28_27_MASK                            0x18000000
#define D18F3x84_ClkDivisorSmafAct7_OFFSET                      29
#define D18F3x84_ClkDivisorSmafAct7_WIDTH                       3
#define D18F3x84_ClkDivisorSmafAct7_MASK                        0xe0000000

/// D18F3x84
typedef union {
  struct {                                                              ///<
    UINT32                                         CpuPrbEnSmafAct4:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct4:1 ; ///<
    UINT32                                         NbGateEnSmafAct4:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                       ClkDivisorSmafAct4:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct5:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct5:1 ; ///<
    UINT32                                         NbGateEnSmafAct5:1 ; ///<
    UINT32                                           Reserved_12_11:2 ; ///<
    UINT32                                       ClkDivisorSmafAct5:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct6:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct6:1 ; ///<
    UINT32                                         NbGateEnSmafAct6:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                       ClkDivisorSmafAct6:3 ; ///<
    UINT32                                         CpuPrbEnSmafAct7:1 ; ///<
    UINT32                                       NbLowPwrEnSmafAct7:1 ; ///<
    UINT32                                         NbGateEnSmafAct7:1 ; ///<
    UINT32                                           Reserved_28_27:2 ; ///<
    UINT32                                       ClkDivisorSmafAct7:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x84_STRUCT;

// **** D18F3x88 Register Definition ****
// Address
#define D18F3x88_ADDRESS                                        0x88

// Type
#define D18F3x88_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x88_Reserved_30_0_OFFSET                           0
#define D18F3x88_Reserved_30_0_WIDTH                            31
#define D18F3x88_Reserved_30_0_MASK                             0x7fffffff
#define D18F3x88_DisCohLdtCfg_OFFSET                            31
#define D18F3x88_DisCohLdtCfg_WIDTH                             1
#define D18F3x88_DisCohLdtCfg_MASK                              0x80000000

/// D18F3x88
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_30_0:31; ///<
    UINT32                                             DisCohLdtCfg:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x88_STRUCT;

// **** D18F3x8C Register Definition ****
// Address
#define D18F3x8C_ADDRESS                                        0x8c

// Type
#define D18F3x8C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x8C_Reserved_35_32_OFFSET                          0
#define D18F3x8C_Reserved_35_32_WIDTH                           4
#define D18F3x8C_Reserved_35_32_MASK                            0xf
#define D18F3x8C_DisDatMsk_OFFSET                               4
#define D18F3x8C_DisDatMsk_WIDTH                                1
#define D18F3x8C_DisDatMsk_MASK                                 0x10
#define D18F3x8C_Reserved_44_37_OFFSET                          5
#define D18F3x8C_Reserved_44_37_WIDTH                           8
#define D18F3x8C_Reserved_44_37_MASK                            0x1fe0
#define D18F3x8C_DisUsSysMgtReqToNcHt_OFFSET                    13
#define D18F3x8C_DisUsSysMgtReqToNcHt_WIDTH                     1
#define D18F3x8C_DisUsSysMgtReqToNcHt_MASK                      0x2000
#define D18F3x8C_EnableCf8ExtCfg_OFFSET                         14
#define D18F3x8C_EnableCf8ExtCfg_WIDTH                          1
#define D18F3x8C_EnableCf8ExtCfg_MASK                           0x4000
#define D18F3x8C_Reserved_49_47_OFFSET                          15
#define D18F3x8C_Reserved_49_47_WIDTH                           3
#define D18F3x8C_Reserved_49_47_MASK                            0x38000
#define D18F3x8C_DisOrderRdRsp_OFFSET                           18
#define D18F3x8C_DisOrderRdRsp_WIDTH                            1
#define D18F3x8C_DisOrderRdRsp_MASK                             0x40000
#define D18F3x8C_Reserved_53_51_OFFSET                          19
#define D18F3x8C_Reserved_53_51_WIDTH                           3
#define D18F3x8C_Reserved_53_51_MASK                            0x380000
#define D18F3x8C_InitApicIdCpuIdLo_OFFSET                       22
#define D18F3x8C_InitApicIdCpuIdLo_WIDTH                        1
#define D18F3x8C_InitApicIdCpuIdLo_MASK                         0x400000
#define D18F3x8C_Reserved_63_55_OFFSET                          23
#define D18F3x8C_Reserved_63_55_WIDTH                           9
#define D18F3x8C_Reserved_63_55_MASK                            0xff800000

/// D18F3x8C
typedef union {
  struct {                                                              ///<
    UINT32                                           Reserved_35_32:4 ; ///<
    UINT32                                                DisDatMsk:1 ; ///<
    UINT32                                           Reserved_44_37:8 ; ///<
    UINT32                                     DisUsSysMgtReqToNcHt:1 ; ///<
    UINT32                                          EnableCf8ExtCfg:1 ; ///<
    UINT32                                           Reserved_49_47:3 ; ///<
    UINT32                                            DisOrderRdRsp:1 ; ///<
    UINT32                                           Reserved_53_51:3 ; ///<
    UINT32                                        InitApicIdCpuIdLo:1 ; ///<
    UINT32                                           Reserved_63_55:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x8C_STRUCT;

// **** D18F3xA0 Register Definition ****
// Address
#define D18F3xA0_ADDRESS                                        0xa0

// Type
#define D18F3xA0_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xA0_PsiVid_6_0__OFFSET                             0
#define D18F3xA0_PsiVid_6_0__WIDTH                              7
#define D18F3xA0_PsiVid_6_0__MASK                               0x7f
#define D18F3xA0_PsiVidEn_OFFSET                                7
#define D18F3xA0_PsiVidEn_WIDTH                                 1
#define D18F3xA0_PsiVidEn_MASK                                  0x80
#define D18F3xA0_PsiVid_7__OFFSET                               8
#define D18F3xA0_PsiVid_7__WIDTH                                1
#define D18F3xA0_PsiVid_7__MASK                                 0x100
#define D18F3xA0_Reserved_10_9_OFFSET                           9
#define D18F3xA0_Reserved_10_9_WIDTH                            2
#define D18F3xA0_Reserved_10_9_MASK                             0x600
#define D18F3xA0_PllLockTime_OFFSET                             11
#define D18F3xA0_PllLockTime_WIDTH                              3
#define D18F3xA0_PllLockTime_MASK                               0x3800
#define D18F3xA0_Svi2HighFreqSel_OFFSET                         14
#define D18F3xA0_Svi2HighFreqSel_WIDTH                          1
#define D18F3xA0_Svi2HighFreqSel_MASK                           0x4000
#define D18F3xA0_Reserved_15_15_OFFSET                          15
#define D18F3xA0_Reserved_15_15_WIDTH                           1
#define D18F3xA0_Reserved_15_15_MASK                            0x8000
#define D18F3xA0_ConfigId_OFFSET                                16
#define D18F3xA0_ConfigId_WIDTH                                 12
#define D18F3xA0_ConfigId_MASK                                  0xfff0000
#define D18F3xA0_Reserved_30_28_OFFSET                          28
#define D18F3xA0_Reserved_30_28_WIDTH                           3
#define D18F3xA0_Reserved_30_28_MASK                            0x70000000
#define D18F3xA0_CofVidProg_OFFSET                              31
#define D18F3xA0_CofVidProg_WIDTH                               1
#define D18F3xA0_CofVidProg_MASK                                0x80000000

/// D18F3xA0
typedef union {
  struct {                                                              ///<
    UINT32                                              PsiVid_6_0_:7 ; ///<
    UINT32                                                 PsiVidEn:1 ; ///<
    UINT32                                                PsiVid_7_:1 ; ///<
    UINT32                                            Reserved_10_9:2 ; ///<
    UINT32                                              PllLockTime:3 ; ///<
    UINT32                                          Svi2HighFreqSel:1 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                                 ConfigId:12; ///<
    UINT32                                           Reserved_30_28:3 ; ///<
    UINT32                                               CofVidProg:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xA0_STRUCT;

// **** D18F3xA4 Register Definition ****
// Address
#define D18F3xA4_ADDRESS                                        0xa4

// Type
#define D18F3xA4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xA4_PerStepTimeUp_OFFSET                           0
#define D18F3xA4_PerStepTimeUp_WIDTH                            5
#define D18F3xA4_PerStepTimeUp_MASK                             0x1f
#define D18F3xA4_TmpMaxDiffUp_OFFSET                            5
#define D18F3xA4_TmpMaxDiffUp_WIDTH                             2
#define D18F3xA4_TmpMaxDiffUp_MASK                              0x60
#define D18F3xA4_TmpSlewDnEn_OFFSET                             7
#define D18F3xA4_TmpSlewDnEn_WIDTH                              1
#define D18F3xA4_TmpSlewDnEn_MASK                               0x80
#define D18F3xA4_PerStepTimeDn_OFFSET                           8
#define D18F3xA4_PerStepTimeDn_WIDTH                            5
#define D18F3xA4_PerStepTimeDn_MASK                             0x1f00
#define D18F3xA4_Reserved_15_13_OFFSET                          13
#define D18F3xA4_Reserved_15_13_WIDTH                           3
#define D18F3xA4_Reserved_15_13_MASK                            0xe000
#define D18F3xA4_CurTmpTjSel_OFFSET                             16
#define D18F3xA4_CurTmpTjSel_WIDTH                              2
#define D18F3xA4_CurTmpTjSel_MASK                               0x30000
#define D18F3xA4_Reserved_19_18_OFFSET                          18
#define D18F3xA4_Reserved_19_18_WIDTH                           2
#define D18F3xA4_Reserved_19_18_MASK                            0xc0000
#define D18F3xA4_TcenPwrDnCc6En_OFFSET                          20
#define D18F3xA4_TcenPwrDnCc6En_WIDTH                           1
#define D18F3xA4_TcenPwrDnCc6En_MASK                            0x100000
#define D18F3xA4_CurTmp_OFFSET                                  21
#define D18F3xA4_CurTmp_WIDTH                                   11
#define D18F3xA4_CurTmp_MASK                                    0xffe00000

/// D18F3xA4
typedef union {
  struct {                                                              ///<
    UINT32                                            PerStepTimeUp:5 ; ///<
    UINT32                                             TmpMaxDiffUp:2 ; ///<
    UINT32                                              TmpSlewDnEn:1 ; ///<
    UINT32                                            PerStepTimeDn:5 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                              CurTmpTjSel:2 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                           TcenPwrDnCc6En:1 ; ///<
    UINT32                                                   CurTmp:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xA4_STRUCT;

// **** D18F3xA8 Register Definition ****
// Address
#define D18F3xA8_ADDRESS                                        0xa8

// Type
#define D18F3xA8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xA8_Reserved_28_0_OFFSET                           0
#define D18F3xA8_Reserved_28_0_WIDTH                            29
#define D18F3xA8_Reserved_28_0_MASK                             0x1fffffff
#define D18F3xA8_PopDownPstate_OFFSET                           29
#define D18F3xA8_PopDownPstate_WIDTH                            3
#define D18F3xA8_PopDownPstate_MASK                             0xe0000000

/// D18F3xA8
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_28_0:29; ///<
    UINT32                                            PopDownPstate:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xA8_STRUCT;


// **** D18F3xD4 Register Definition ****
// Address
#define D18F3xD4_ADDRESS                                        0xd4

// Type
#define D18F3xD4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xD4_MaxSwPstateCpuCof_OFFSET                       0
#define D18F3xD4_MaxSwPstateCpuCof_WIDTH                        6
#define D18F3xD4_MaxSwPstateCpuCof_MASK                         0x3f
#define D18F3xD4_Reserved_7_6_OFFSET                            6
#define D18F3xD4_Reserved_7_6_WIDTH                             2
#define D18F3xD4_Reserved_7_6_MASK                              0xc0
#define D18F3xD4_ClkRampHystSel_OFFSET                          8
#define D18F3xD4_ClkRampHystSel_WIDTH                           4
#define D18F3xD4_ClkRampHystSel_MASK                            0xf00
#define D18F3xD4_ClkRampHystCtl_OFFSET                          12
#define D18F3xD4_ClkRampHystCtl_WIDTH                           1
#define D18F3xD4_ClkRampHystCtl_MASK                            0x1000
#define D18F3xD4_Reserved_13_13_OFFSET                          13
#define D18F3xD4_Reserved_13_13_WIDTH                           1
#define D18F3xD4_Reserved_13_13_MASK                            0x2000
#define D18F3xD4_CacheFlushImmOnAllHalt_OFFSET                  14
#define D18F3xD4_CacheFlushImmOnAllHalt_WIDTH                   1
#define D18F3xD4_CacheFlushImmOnAllHalt_MASK                    0x4000
#define D18F3xD4_Reserved_17_15_OFFSET                          15
#define D18F3xD4_Reserved_17_15_WIDTH                           3
#define D18F3xD4_Reserved_17_15_MASK                            0x38000
#define D18F3xD4_Reserved_19_18_OFFSET                          18
#define D18F3xD4_Reserved_19_18_WIDTH                           2
#define D18F3xD4_Reserved_19_18_MASK                            0xc0000
#define D18F3xD4_PowerStepDown_OFFSET                           20
#define D18F3xD4_PowerStepDown_WIDTH                            4
#define D18F3xD4_PowerStepDown_MASK                             0xf00000
#define D18F3xD4_PowerStepUp_OFFSET                             24
#define D18F3xD4_PowerStepUp_WIDTH                              4
#define D18F3xD4_PowerStepUp_MASK                               0xf000000
#define D18F3xD4_NbClkDiv_OFFSET                                28
#define D18F3xD4_NbClkDiv_WIDTH                                 3
#define D18F3xD4_NbClkDiv_MASK                                  0x70000000
#define D18F3xD4_NbClkDivApplyAll_OFFSET                        31
#define D18F3xD4_NbClkDivApplyAll_WIDTH                         1
#define D18F3xD4_NbClkDivApplyAll_MASK                          0x80000000

/// D18F3xD4
typedef union {
  struct {                                                              ///<
    UINT32                                        MaxSwPstateCpuCof:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                           ClkRampHystSel:4 ; ///<
    UINT32                                           ClkRampHystCtl:1 ; ///<
    UINT32                                           Reserved_13_13:1 ; ///<
    UINT32                                   CacheFlushImmOnAllHalt:1 ; ///<
    UINT32                                           Reserved_17_15:3 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                            PowerStepDown:4 ; ///<
    UINT32                                              PowerStepUp:4 ; ///<
    UINT32                                                 NbClkDiv:3 ; ///<
    UINT32                                         NbClkDivApplyAll:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xD4_STRUCT;

// **** D18F3xD8 Register Definition ****
// Address
#define D18F3xD8_ADDRESS                                        0xd8

// Type
#define D18F3xD8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xD8_Reserved_3_0_OFFSET                            0
#define D18F3xD8_Reserved_3_0_WIDTH                             4
#define D18F3xD8_Reserved_3_0_MASK                              0xf
#define D18F3xD8_VSRampSlamTime_OFFSET                          4
#define D18F3xD8_VSRampSlamTime_WIDTH                           3
#define D18F3xD8_VSRampSlamTime_MASK                            0x70
#define D18F3xD8_Reserved_31_7_OFFSET                           7
#define D18F3xD8_Reserved_31_7_WIDTH                            25
#define D18F3xD8_Reserved_31_7_MASK                             0xffffff80

/// D18F3xD8
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                           VSRampSlamTime:3 ; ///<
    UINT32                                            Reserved_31_7:25; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xD8_STRUCT;

// **** D18F3xDC Register Definition ****
// Address
#define D18F3xDC_ADDRESS                                        0xdc

// Type
#define D18F3xDC_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xDC_Reserved_7_0_OFFSET                            0
#define D18F3xDC_Reserved_7_0_WIDTH                             8
#define D18F3xDC_Reserved_7_0_MASK                              0xff
#define D18F3xDC_PstateMaxVal_OFFSET                            8
#define D18F3xDC_PstateMaxVal_WIDTH                             3
#define D18F3xDC_PstateMaxVal_MASK                              0x700
#define D18F3xDC_Reserved_11_11_OFFSET                          11
#define D18F3xDC_Reserved_11_11_WIDTH                           1
#define D18F3xDC_Reserved_11_11_MASK                            0x800
#define D18F3xDC_NbsynPtrAdj_OFFSET                             12
#define D18F3xDC_NbsynPtrAdj_WIDTH                              3
#define D18F3xDC_NbsynPtrAdj_MASK                               0x7000
#define D18F3xDC_Reserved_15_15_OFFSET                          15
#define D18F3xDC_Reserved_15_15_WIDTH                           1
#define D18F3xDC_Reserved_15_15_MASK                            0x8000
#define D18F3xDC_CacheFlushOnHaltCtl_OFFSET                     16
#define D18F3xDC_CacheFlushOnHaltCtl_WIDTH                      3
#define D18F3xDC_CacheFlushOnHaltCtl_MASK                       0x70000
#define D18F3xDC_CacheFlushOnHaltTmr_OFFSET                     19
#define D18F3xDC_CacheFlushOnHaltTmr_WIDTH                      7
#define D18F3xDC_CacheFlushOnHaltTmr_MASK                       0x3f80000
#define D18F3xDC_IgnCpuPrbEn_OFFSET                             26
#define D18F3xDC_IgnCpuPrbEn_WIDTH                              1
#define D18F3xDC_IgnCpuPrbEn_MASK                               0x4000000
#define D18F3xDC_Reserved_31_27_OFFSET                          27
#define D18F3xDC_Reserved_31_27_WIDTH                           5
#define D18F3xDC_Reserved_31_27_MASK                            0xf8000000

/// D18F3xDC
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                             PstateMaxVal:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                              NbsynPtrAdj:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                      CacheFlushOnHaltCtl:3 ; ///<
    UINT32                                      CacheFlushOnHaltTmr:7 ; ///<
    UINT32                                              IgnCpuPrbEn:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xDC_STRUCT;

// **** D18F3xE4 Register Definition ****
// Address
#define D18F3xE4_ADDRESS                                        0xe4

// Type
#define D18F3xE4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xE4_Reserved_0_0_OFFSET                            0
#define D18F3xE4_Reserved_0_0_WIDTH                             1
#define D18F3xE4_Reserved_0_0_MASK                              0x1
#define D18F3xE4_Thermtp_OFFSET                                 1
#define D18F3xE4_Thermtp_WIDTH                                  1
#define D18F3xE4_Thermtp_MASK                                   0x2
#define D18F3xE4_Reserved_2_2_OFFSET                            2
#define D18F3xE4_Reserved_2_2_WIDTH                             1
#define D18F3xE4_Reserved_2_2_MASK                              0x4
#define D18F3xE4_ThermtpSense_OFFSET                            3
#define D18F3xE4_ThermtpSense_WIDTH                             1
#define D18F3xE4_ThermtpSense_MASK                              0x8
#define D18F3xE4_Reserved_4_4_OFFSET                            4
#define D18F3xE4_Reserved_4_4_WIDTH                             1
#define D18F3xE4_Reserved_4_4_MASK                              0x10
#define D18F3xE4_ThermtpEn_OFFSET                               5
#define D18F3xE4_ThermtpEn_WIDTH                                1
#define D18F3xE4_ThermtpEn_MASK                                 0x20
#define D18F3xE4_Reserved_30_6_OFFSET                           6
#define D18F3xE4_Reserved_30_6_WIDTH                            25
#define D18F3xE4_Reserved_30_6_MASK                             0x7fffffc0
#define D18F3xE4_SwThermtp_OFFSET                               31
#define D18F3xE4_SwThermtp_WIDTH                                1
#define D18F3xE4_SwThermtp_MASK                                 0x80000000

/// D18F3xE4
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                  Thermtp:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             ThermtpSense:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                                ThermtpEn:1 ; ///<
    UINT32                                            Reserved_30_6:25; ///<
    UINT32                                                SwThermtp:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xE4_STRUCT;

// **** D18F3xE8 Register Definition ****
// Address
#define D18F3xE8_ADDRESS                                        0xe8

// Type
#define D18F3xE8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xE8_Reserved_0_0_OFFSET                            0
#define D18F3xE8_Reserved_0_0_WIDTH                             1
#define D18F3xE8_Reserved_0_0_MASK                              0x1
#define D18F3xE8_DualNode_OFFSET                                1
#define D18F3xE8_DualNode_WIDTH                                 1
#define D18F3xE8_DualNode_MASK                                  0x2
#define D18F3xE8_EightNode_OFFSET                               2
#define D18F3xE8_EightNode_WIDTH                                1
#define D18F3xE8_EightNode_MASK                                 0x4
#define D18F3xE8_ECC_OFFSET                                     3
#define D18F3xE8_ECC_WIDTH                                      1
#define D18F3xE8_ECC_MASK                                       0x8
#define D18F3xE8_ChipKill_OFFSET                                4
#define D18F3xE8_ChipKill_WIDTH                                 1
#define D18F3xE8_ChipKill_MASK                                  0x10
#define D18F3xE8_Reserved_7_5_OFFSET                            5
#define D18F3xE8_Reserved_7_5_WIDTH                             3
#define D18F3xE8_Reserved_7_5_MASK                              0xe0
#define D18F3xE8_MctCap_OFFSET                                  8
#define D18F3xE8_MctCap_WIDTH                                   1
#define D18F3xE8_MctCap_MASK                                    0x100
#define D18F3xE8_SvmCapable_OFFSET                              9
#define D18F3xE8_SvmCapable_WIDTH                               1
#define D18F3xE8_SvmCapable_MASK                                0x200
#define D18F3xE8_HtcCapable_OFFSET                              10
#define D18F3xE8_HtcCapable_WIDTH                               1
#define D18F3xE8_HtcCapable_MASK                                0x400
#define D18F3xE8_Reserved_11_11_OFFSET                          11
#define D18F3xE8_Reserved_11_11_WIDTH                           1
#define D18F3xE8_Reserved_11_11_MASK                            0x800
#define D18F3xE8_Reserved_13_12_OFFSET                          12
#define D18F3xE8_Reserved_13_12_WIDTH                           2
#define D18F3xE8_Reserved_13_12_MASK                            0x3000
#define D18F3xE8_MultVidPlane_OFFSET                            14
#define D18F3xE8_MultVidPlane_WIDTH                             1
#define D18F3xE8_MultVidPlane_MASK                              0x4000
#define D18F3xE8_Reserved_15_15_OFFSET                          15
#define D18F3xE8_Reserved_15_15_WIDTH                           1
#define D18F3xE8_Reserved_15_15_MASK                            0x8000
#define D18F3xE8_Reserved_18_16_OFFSET                          16
#define D18F3xE8_Reserved_18_16_WIDTH                           3
#define D18F3xE8_Reserved_18_16_MASK                            0x70000
#define D18F3xE8_x2Apic_OFFSET                                  19
#define D18F3xE8_x2Apic_WIDTH                                   1
#define D18F3xE8_x2Apic_MASK                                    0x80000
#define D18F3xE8_Reserved_23_20_OFFSET                          20
#define D18F3xE8_Reserved_23_20_WIDTH                           4
#define D18F3xE8_Reserved_23_20_MASK                            0xf00000
#define D18F3xE8_MemPstateCap_OFFSET                            24
#define D18F3xE8_MemPstateCap_WIDTH                             1
#define D18F3xE8_MemPstateCap_MASK                              0x1000000
#define D18F3xE8_L3Capable_OFFSET                               25
#define D18F3xE8_L3Capable_WIDTH                                1
#define D18F3xE8_L3Capable_MASK                                 0x2000000
#define D18F3xE8_Reserved_28_26_OFFSET                          26
#define D18F3xE8_Reserved_28_26_WIDTH                           3
#define D18F3xE8_Reserved_28_26_MASK                            0x1c000000
#define D18F3xE8_Reserved_31_29_OFFSET                          29
#define D18F3xE8_Reserved_31_29_WIDTH                           3
#define D18F3xE8_Reserved_31_29_MASK                            0xe0000000

/// D18F3xE8
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                 DualNode:1 ; ///<
    UINT32                                                EightNode:1 ; ///<
    UINT32                                                      ECC:1 ; ///<
    UINT32                                                 ChipKill:1 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                   MctCap:1 ; ///<
    UINT32                                               SvmCapable:1 ; ///<
    UINT32                                               HtcCapable:1 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                           Reserved_13_12:2 ; ///<
    UINT32                                             MultVidPlane:1 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                                   x2Apic:1 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                             MemPstateCap:1 ; ///<
    UINT32                                                L3Capable:1 ; ///<
    UINT32                                           Reserved_28_26:3 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xE8_STRUCT;

// **** D18F3xFC Register Definition ****
// Address
#define D18F3xFC_ADDRESS                                        0xfc

// Type
#define D18F3xFC_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xFC_Stepping_OFFSET                                0
#define D18F3xFC_Stepping_WIDTH                                 4
#define D18F3xFC_Stepping_MASK                                  0xf
#define D18F3xFC_BaseModel_OFFSET                               4
#define D18F3xFC_BaseModel_WIDTH                                4
#define D18F3xFC_BaseModel_MASK                                 0xf0
#define D18F3xFC_BaseFamily_OFFSET                              8
#define D18F3xFC_BaseFamily_WIDTH                               4
#define D18F3xFC_BaseFamily_MASK                                0xf00
#define D18F3xFC_Reserved_15_12_OFFSET                          12
#define D18F3xFC_Reserved_15_12_WIDTH                           4
#define D18F3xFC_Reserved_15_12_MASK                            0xf000
#define D18F3xFC_ExtModel_OFFSET                                16
#define D18F3xFC_ExtModel_WIDTH                                 4
#define D18F3xFC_ExtModel_MASK                                  0xf0000
#define D18F3xFC_ExtFamily_OFFSET                               20
#define D18F3xFC_ExtFamily_WIDTH                                8
#define D18F3xFC_ExtFamily_MASK                                 0xff00000
#define D18F3xFC_Reserved_31_28_OFFSET                          28
#define D18F3xFC_Reserved_31_28_WIDTH                           4
#define D18F3xFC_Reserved_31_28_MASK                            0xf0000000

/// D18F3xFC
typedef union {
  struct {                                                              ///<
    UINT32                                                 Stepping:4 ; ///<
    UINT32                                                BaseModel:4 ; ///<
    UINT32                                               BaseFamily:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                 ExtModel:4 ; ///<
    UINT32                                                ExtFamily:8 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xFC_STRUCT;

// **** D18F3x140 Register Definition ****
// Address
#define D18F3x140_ADDRESS                                       0x140

// Type
#define D18F3x140_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x140_UpReqTok_OFFSET                               0
#define D18F3x140_UpReqTok_WIDTH                                2
#define D18F3x140_UpReqTok_MASK                                 0x3
#define D18F3x140_DnReqTok_OFFSET                               2
#define D18F3x140_DnReqTok_WIDTH                                2
#define D18F3x140_DnReqTok_MASK                                 0xc
#define D18F3x140_UpPreqTok_OFFSET                              4
#define D18F3x140_UpPreqTok_WIDTH                               2
#define D18F3x140_UpPreqTok_MASK                                0x30
#define D18F3x140_DnPreqTok_OFFSET                              6
#define D18F3x140_DnPreqTok_WIDTH                               2
#define D18F3x140_DnPreqTok_MASK                                0xc0
#define D18F3x140_UpRspTok_OFFSET                               8
#define D18F3x140_UpRspTok_WIDTH                                2
#define D18F3x140_UpRspTok_MASK                                 0x300
#define D18F3x140_DnRspTok_OFFSET                               10
#define D18F3x140_DnRspTok_WIDTH                                2
#define D18F3x140_DnRspTok_MASK                                 0xc00
#define D18F3x140_IsocReqTok_OFFSET                             12
#define D18F3x140_IsocReqTok_WIDTH                              2
#define D18F3x140_IsocReqTok_MASK                               0x3000
#define D18F3x140_IsocPreqTok_OFFSET                            14
#define D18F3x140_IsocPreqTok_WIDTH                             2
#define D18F3x140_IsocPreqTok_MASK                              0xc000
#define D18F3x140_IsocRspTok_OFFSET                             16
#define D18F3x140_IsocRspTok_WIDTH                              2
#define D18F3x140_IsocRspTok_MASK                               0x30000
#define D18F3x140_Reserved_19_18_OFFSET                         18
#define D18F3x140_Reserved_19_18_WIDTH                          2
#define D18F3x140_Reserved_19_18_MASK                           0xc0000
#define D18F3x140_FreeTok_OFFSET                                20
#define D18F3x140_FreeTok_WIDTH                                 4
#define D18F3x140_FreeTok_MASK                                  0xf00000
#define D18F3x140_Reserved_31_24_OFFSET                         24
#define D18F3x140_Reserved_31_24_WIDTH                          8
#define D18F3x140_Reserved_31_24_MASK                           0xff000000

/// D18F3x140
typedef union {
  struct {                                                              ///<
    UINT32                                                 UpReqTok:2 ; ///<
    UINT32                                                 DnReqTok:2 ; ///<
    UINT32                                                UpPreqTok:2 ; ///<
    UINT32                                                DnPreqTok:2 ; ///<
    UINT32                                                 UpRspTok:2 ; ///<
    UINT32                                                 DnRspTok:2 ; ///<
    UINT32                                               IsocReqTok:2 ; ///<
    UINT32                                              IsocPreqTok:2 ; ///<
    UINT32                                               IsocRspTok:2 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                                  FreeTok:4 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x140_STRUCT;

// **** D18F3x144 Register Definition ****
// Address
#define D18F3x144_ADDRESS                                       0x144

// Type
#define D18F3x144_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x144_RspTok_OFFSET                                 0
#define D18F3x144_RspTok_WIDTH                                  4
#define D18F3x144_RspTok_MASK                                   0xf
#define D18F3x144_ProbeTok_OFFSET                               4
#define D18F3x144_ProbeTok_WIDTH                                4
#define D18F3x144_ProbeTok_MASK                                 0xf0
#define D18F3x144_Reserved_31_8_OFFSET                          8
#define D18F3x144_Reserved_31_8_WIDTH                           24
#define D18F3x144_Reserved_31_8_MASK                            0xffffff00

/// D18F3x144
typedef union {
  struct {                                                              ///<
    UINT32                                                   RspTok:4 ; ///<
    UINT32                                                 ProbeTok:4 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x144_STRUCT;

// **** D18F3x148 Register Definition ****
// Address
#define D18F3x148_ADDRESS                                       0x148

// Type
#define D18F3x148_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x148_ReqTok0_OFFSET                                0
#define D18F3x148_ReqTok0_WIDTH                                 2
#define D18F3x148_ReqTok0_MASK                                  0x3
#define D18F3x148_PReqTok0_OFFSET                               2
#define D18F3x148_PReqTok0_WIDTH                                2
#define D18F3x148_PReqTok0_MASK                                 0xc
#define D18F3x148_RspTok0_OFFSET                                4
#define D18F3x148_RspTok0_WIDTH                                 2
#define D18F3x148_RspTok0_MASK                                  0x30
#define D18F3x148_ProbeTok0_OFFSET                              6
#define D18F3x148_ProbeTok0_WIDTH                               2
#define D18F3x148_ProbeTok0_MASK                                0xc0
#define D18F3x148_IsocReqTok0_OFFSET                            8
#define D18F3x148_IsocReqTok0_WIDTH                             2
#define D18F3x148_IsocReqTok0_MASK                              0x300
#define D18F3x148_IsocPreqTok0_OFFSET                           10
#define D18F3x148_IsocPreqTok0_WIDTH                            2
#define D18F3x148_IsocPreqTok0_MASK                             0xc00
#define D18F3x148_IsocRspTok0_OFFSET                            12
#define D18F3x148_IsocRspTok0_WIDTH                             2
#define D18F3x148_IsocRspTok0_MASK                              0x3000
#define D18F3x148_FreeTok_1_0__OFFSET                           14
#define D18F3x148_FreeTok_1_0__WIDTH                            2
#define D18F3x148_FreeTok_1_0__MASK                             0xc000
#define D18F3x148_ReqTok1_OFFSET                                16
#define D18F3x148_ReqTok1_WIDTH                                 2
#define D18F3x148_ReqTok1_MASK                                  0x30000
#define D18F3x148_PReqTok1_OFFSET                               18
#define D18F3x148_PReqTok1_WIDTH                                2
#define D18F3x148_PReqTok1_MASK                                 0xc0000
#define D18F3x148_RspTok1_OFFSET                                20
#define D18F3x148_RspTok1_WIDTH                                 2
#define D18F3x148_RspTok1_MASK                                  0x300000
#define D18F3x148_ProbeTok1_OFFSET                              22
#define D18F3x148_ProbeTok1_WIDTH                               2
#define D18F3x148_ProbeTok1_MASK                                0xc00000
#define D18F3x148_IsocReqTok1_OFFSET                            24
#define D18F3x148_IsocReqTok1_WIDTH                             1
#define D18F3x148_IsocReqTok1_MASK                              0x1000000
#define D18F3x148_Reserved_25_25_OFFSET                         25
#define D18F3x148_Reserved_25_25_WIDTH                          1
#define D18F3x148_Reserved_25_25_MASK                           0x2000000
#define D18F3x148_IsocPreqTok1_OFFSET                           26
#define D18F3x148_IsocPreqTok1_WIDTH                            1
#define D18F3x148_IsocPreqTok1_MASK                             0x4000000
#define D18F3x148_Reserved_27_27_OFFSET                         27
#define D18F3x148_Reserved_27_27_WIDTH                          1
#define D18F3x148_Reserved_27_27_MASK                           0x8000000
#define D18F3x148_IsocRspTok1_OFFSET                            28
#define D18F3x148_IsocRspTok1_WIDTH                             1
#define D18F3x148_IsocRspTok1_MASK                              0x10000000
#define D18F3x148_Reserved_29_29_OFFSET                         29
#define D18F3x148_Reserved_29_29_WIDTH                          1
#define D18F3x148_Reserved_29_29_MASK                           0x20000000
#define D18F3x148_FreeTok_3_2__OFFSET                           30
#define D18F3x148_FreeTok_3_2__WIDTH                            2
#define D18F3x148_FreeTok_3_2__MASK                             0xc0000000

/// D18F3x148
typedef union {
  struct {                                                              ///<
    UINT32                                                  ReqTok0:2 ; ///<
    UINT32                                                 PReqTok0:2 ; ///<
    UINT32                                                  RspTok0:2 ; ///<
    UINT32                                                ProbeTok0:2 ; ///<
    UINT32                                              IsocReqTok0:2 ; ///<
    UINT32                                             IsocPreqTok0:2 ; ///<
    UINT32                                              IsocRspTok0:2 ; ///<
    UINT32                                             FreeTok_1_0_:2 ; ///<
    UINT32                                                  ReqTok1:2 ; ///<
    UINT32                                                 PReqTok1:2 ; ///<
    UINT32                                                  RspTok1:2 ; ///<
    UINT32                                                ProbeTok1:2 ; ///<
    UINT32                                              IsocReqTok1:1 ; ///<
    UINT32                                           Reserved_25_25:1 ; ///<
    UINT32                                             IsocPreqTok1:1 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                              IsocRspTok1:1 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                             FreeTok_3_2_:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x148_STRUCT;

// **** D18F3x17C Register Definition ****
// Address
#define D18F3x17C_ADDRESS                                       0x17c

// Type
#define D18F3x17C_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x17C_SPQPrbFreeCBC_OFFSET                          0
#define D18F3x17C_SPQPrbFreeCBC_WIDTH                           4
#define D18F3x17C_SPQPrbFreeCBC_MASK                            0xf
#define D18F3x17C_Reserved_31_4_OFFSET                          4
#define D18F3x17C_Reserved_31_4_WIDTH                           28
#define D18F3x17C_Reserved_31_4_MASK                            0xfffffff0

/// D18F3x17C
typedef union {
  struct {                                                              ///<
    UINT32                                            SPQPrbFreeCBC:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x17C_STRUCT;

// **** D18F3x180 Register Definition ****
// Address
#define D18F3x180_ADDRESS                                       0x180

// Type
#define D18F3x180_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x180_Reserved_1_0_OFFSET                           0
#define D18F3x180_Reserved_1_0_WIDTH                            2
#define D18F3x180_Reserved_1_0_MASK                             0x3
#define D18F3x180_WDTCntSel_3__OFFSET                           2
#define D18F3x180_WDTCntSel_3__WIDTH                            1
#define D18F3x180_WDTCntSel_3__MASK                             0x4
#define D18F3x180_ChgDatErrToTgtAbort_OFFSET                    3
#define D18F3x180_ChgDatErrToTgtAbort_WIDTH                     1
#define D18F3x180_ChgDatErrToTgtAbort_MASK                      0x8
#define D18F3x180_ChgMstAbortToNoErr_OFFSET                     4
#define D18F3x180_ChgMstAbortToNoErr_WIDTH                      1
#define D18F3x180_ChgMstAbortToNoErr_MASK                       0x10
#define D18F3x180_DisPciCfgCpuMstAbortRsp_OFFSET                5
#define D18F3x180_DisPciCfgCpuMstAbortRsp_WIDTH                 1
#define D18F3x180_DisPciCfgCpuMstAbortRsp_MASK                  0x20
#define D18F3x180_SyncFloodOnDatErr_OFFSET                      6
#define D18F3x180_SyncFloodOnDatErr_WIDTH                       1
#define D18F3x180_SyncFloodOnDatErr_MASK                        0x40
#define D18F3x180_SyncFloodOnTgtAbortErr_OFFSET                 7
#define D18F3x180_SyncFloodOnTgtAbortErr_WIDTH                  1
#define D18F3x180_SyncFloodOnTgtAbortErr_MASK                   0x80
#define D18F3x180_PwP2pDatErrLclPropDis_OFFSET                  18
#define D18F3x180_PwP2pDatErrLclPropDis_WIDTH                   1
#define D18F3x180_PwP2pDatErrLclPropDis_MASK                    0x40000
#define D18F3x180_PwP2pDatErrRmtPropDis_OFFSET                  19
#define D18F3x180_PwP2pDatErrRmtPropDis_WIDTH                   1
#define D18F3x180_PwP2pDatErrRmtPropDis_MASK                    0x80000
#define D18F3x180_SyncFloodOnL3LeakErr_OFFSET                   20
#define D18F3x180_SyncFloodOnL3LeakErr_WIDTH                    1
#define D18F3x180_SyncFloodOnL3LeakErr_MASK                     0x100000
#define D18F3x180_SyncFloodOnCpuLeakErr_OFFSET                  21
#define D18F3x180_SyncFloodOnCpuLeakErr_WIDTH                   1
#define D18F3x180_SyncFloodOnCpuLeakErr_MASK                    0x200000
#define D18F3x180_SyncFloodOnTblWalkErr_OFFSET                  22
#define D18F3x180_SyncFloodOnTblWalkErr_WIDTH                   1
#define D18F3x180_SyncFloodOnTblWalkErr_MASK                    0x400000
#define D18F3x180_Reserved_23_23_OFFSET                         23
#define D18F3x180_Reserved_23_23_WIDTH                          1
#define D18F3x180_Reserved_23_23_MASK                           0x800000
#define D18F3x180_McaLogErrAddrWdtErr_OFFSET                    24
#define D18F3x180_McaLogErrAddrWdtErr_WIDTH                     1
#define D18F3x180_McaLogErrAddrWdtErr_MASK                      0x1000000
#define D18F3x180_Reserved_25_25_OFFSET                         25
#define D18F3x180_Reserved_25_25_WIDTH                          1
#define D18F3x180_Reserved_25_25_MASK                           0x2000000
#define D18F3x180_ChgUcToCeEn_OFFSET                            26
#define D18F3x180_ChgUcToCeEn_WIDTH                             1
#define D18F3x180_ChgUcToCeEn_MASK                              0x4000000
#define D18F3x180_Reserved_31_27_OFFSET                         27
#define D18F3x180_Reserved_31_27_WIDTH                          5
#define D18F3x180_Reserved_31_27_MASK                           0xf8000000

/// D18F3x180
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                             WDTCntSel_3_:1 ; ///<
    UINT32                                      ChgDatErrToTgtAbort:1 ; ///<
    UINT32                                       ChgMstAbortToNoErr:1 ; ///<
    UINT32                                  DisPciCfgCpuMstAbortRsp:1 ; ///<
    UINT32                                        SyncFloodOnDatErr:1 ; ///<
    UINT32                                   SyncFloodOnTgtAbortErr:1 ; ///<
    UINT32                                      :1 ; ///<
    UINT32                                     :1 ; ///<
    UINT32                                             :1 ; ///<
    UINT32                                           :7 ; ///<
    UINT32                                    PwP2pDatErrLclPropDis:1 ; ///<
    UINT32                                    PwP2pDatErrRmtPropDis:1 ; ///<
    UINT32                                     SyncFloodOnL3LeakErr:1 ; ///<
    UINT32                                    SyncFloodOnCpuLeakErr:1 ; ///<
    UINT32                                    SyncFloodOnTblWalkErr:1 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                      McaLogErrAddrWdtErr:1 ; ///<
    UINT32                                           Reserved_25_25:1 ; ///<
    UINT32                                              ChgUcToCeEn:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x180_STRUCT;

// **** D18F3x190 Register Definition ****
// Address
#define D18F3x190_ADDRESS                                       0x190

// Type
#define D18F3x190_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x190_DisCore_OFFSET                                0
#define D18F3x190_DisCore_WIDTH                                 32
#define D18F3x190_DisCore_MASK                                  0xffffffff

/// D18F3x190
typedef union {
  struct {                                                              ///<
    UINT32                                                  DisCore:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x190_STRUCT;

// **** D18F3x1A0 Register Definition ****
// Address
#define D18F3x1A0_ADDRESS                                       0x1a0

// Type
#define D18F3x1A0_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1A0_CpuCmdBufCnt_OFFSET                           0
#define D18F3x1A0_CpuCmdBufCnt_WIDTH                            3
#define D18F3x1A0_CpuCmdBufCnt_MASK                             0x7
#define D18F3x1A0_Reserved_3_3_OFFSET                           3
#define D18F3x1A0_Reserved_3_3_WIDTH                            1
#define D18F3x1A0_Reserved_3_3_MASK                             0x8
#define D18F3x1A0_Reserved_8_4_OFFSET                           4
#define D18F3x1A0_Reserved_8_4_WIDTH                            5
#define D18F3x1A0_Reserved_8_4_MASK                             0x1f0
#define D18F3x1A0_Reserved_11_9_OFFSET                          9
#define D18F3x1A0_Reserved_11_9_WIDTH                           3
#define D18F3x1A0_Reserved_11_9_MASK                            0xe00
#define D18F3x1A0_Reserved_14_12_OFFSET                         12
#define D18F3x1A0_Reserved_14_12_WIDTH                          3
#define D18F3x1A0_Reserved_14_12_MASK                           0x7000
#define D18F3x1A0_Reserved_15_15_OFFSET                         15
#define D18F3x1A0_Reserved_15_15_WIDTH                          1
#define D18F3x1A0_Reserved_15_15_MASK                           0x8000
#define D18F3x1A0_CpuToNbFreeBufCnt_OFFSET                      16
#define D18F3x1A0_CpuToNbFreeBufCnt_WIDTH                       2
#define D18F3x1A0_CpuToNbFreeBufCnt_MASK                        0x30000
#define D18F3x1A0_Reserved_31_18_OFFSET                         18
#define D18F3x1A0_Reserved_31_18_WIDTH                          14
#define D18F3x1A0_Reserved_31_18_MASK                           0xfffc0000

/// D18F3x1A0
typedef union {
  struct {                                                              ///<
    UINT32                                             CpuCmdBufCnt:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                             Reserved_8_4:5 ; ///<
    UINT32                                            Reserved_11_9:3 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                        CpuToNbFreeBufCnt:2 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1A0_STRUCT;

// **** D18F3x1CC Register Definition ****
// Address
#define D18F3x1CC_ADDRESS                                       0x1cc

// Type
#define D18F3x1CC_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1CC_LvtOffset_OFFSET                              0
#define D18F3x1CC_LvtOffset_WIDTH                               4
#define D18F3x1CC_LvtOffset_MASK                                0xf
#define D18F3x1CC_Reserved_7_4_OFFSET                           4
#define D18F3x1CC_Reserved_7_4_WIDTH                            4
#define D18F3x1CC_Reserved_7_4_MASK                             0xf0
#define D18F3x1CC_LvtOffsetVal_OFFSET                           8
#define D18F3x1CC_LvtOffsetVal_WIDTH                            1
#define D18F3x1CC_LvtOffsetVal_MASK                             0x100
#define D18F3x1CC_Reserved_31_9_OFFSET                          9
#define D18F3x1CC_Reserved_31_9_WIDTH                           23
#define D18F3x1CC_Reserved_31_9_MASK                            0xfffffe00

/// D18F3x1CC
typedef union {
  struct {                                                              ///<
    UINT32                                                LvtOffset:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             LvtOffsetVal:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1CC_STRUCT;


// **** D18F3x1FC Register Definition ****
// Address
#define D18F3x1FC_ADDRESS                                       0x1fc

// Type
#define D18F3x1FC_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1FC_DiDtMode_OFFSET                               0
#define D18F3x1FC_DiDtMode_WIDTH                                1
#define D18F3x1FC_DiDtMode_MASK                                 0x1
#define D18F3x1FC_DiDtCfg0_OFFSET                               1
#define D18F3x1FC_DiDtCfg0_WIDTH                                5
#define D18F3x1FC_DiDtCfg0_MASK                                 0x3e
#define D18F3x1FC_DiDtCfg1_OFFSET                               6
#define D18F3x1FC_DiDtCfg1_WIDTH                                8
#define D18F3x1FC_DiDtCfg1_MASK                                 0x3fc0
#define D18F3x1FC_DiDtCfg2_OFFSET                               14
#define D18F3x1FC_DiDtCfg2_WIDTH                                2
#define D18F3x1FC_DiDtCfg2_MASK                                 0xc000
#define D18F3x1FC_Reserved_16_16_OFFSET                         16
#define D18F3x1FC_Reserved_16_16_WIDTH                          1
#define D18F3x1FC_Reserved_16_16_MASK                           0x10000
#define D18F3x1FC_DiDtCfg4_OFFSET                               17
#define D18F3x1FC_DiDtCfg4_WIDTH                                3
#define D18F3x1FC_DiDtCfg4_MASK                                 0xe0000
#define D18F3x1FC_Reserved_23_20_OFFSET                         20
#define D18F3x1FC_Reserved_23_20_WIDTH                          4
#define D18F3x1FC_Reserved_23_20_MASK                           0xf00000
#define D18F3x1FC_SWDllCapTableEn_OFFSET                        24
#define D18F3x1FC_SWDllCapTableEn_WIDTH                         1
#define D18F3x1FC_SWDllCapTableEn_MASK                          0x1000000
#define D18F3x1FC_DllProcFreqCtlIndex2Rate50_OFFSET             25
#define D18F3x1FC_DllProcFreqCtlIndex2Rate50_WIDTH              4
#define D18F3x1FC_DllProcFreqCtlIndex2Rate50_MASK               0x1e000000

/// D18F3x1FC
typedef union {
  struct {                                                              ///<
    UINT32                                                 DiDtMode:1 ; ///<
    UINT32                                                 DiDtCfg0:5 ; ///<
    UINT32                                                 DiDtCfg1:8 ; ///<
    UINT32                                                 DiDtCfg2:2 ; ///<
    UINT32                                           Reserved_16_16:1 ; ///<
    UINT32                                                 DiDtCfg4:3 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                          SWDllCapTableEn:1 ; ///<
    UINT32                               DllProcFreqCtlIndex2Rate50:4 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1FC_STRUCT;

// **** D18F4x00 Register Definition ****
// Address
#define D18F4x00_ADDRESS                                        0x0

// Type
#define D18F4x00_TYPE                                           TYPE_D18F4
// Field Data
#define D18F4x00_VendorID_OFFSET                                0
#define D18F4x00_VendorID_WIDTH                                 16
#define D18F4x00_VendorID_MASK                                  0xffff
#define D18F4x00_DeviceID_OFFSET                                16
#define D18F4x00_DeviceID_WIDTH                                 16
#define D18F4x00_DeviceID_MASK                                  0xffff0000

/// D18F4x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x00_STRUCT;

// **** D18F4x04 Register Definition ****
// Address
#define D18F4x04_ADDRESS                                        0x4

// Type
#define D18F4x04_TYPE                                           TYPE_D18F4
// Field Data
#define D18F4x04_Command_OFFSET                                 0
#define D18F4x04_Command_WIDTH                                  16
#define D18F4x04_Command_MASK                                   0xffff
#define D18F4x04_Status_OFFSET                                  16
#define D18F4x04_Status_WIDTH                                   16
#define D18F4x04_Status_MASK                                    0xffff0000

/// D18F4x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x04_STRUCT;

// **** D18F4x08 Register Definition ****
// Address
#define D18F4x08_ADDRESS                                        0x8

// Type
#define D18F4x08_TYPE                                           TYPE_D18F4
// Field Data
#define D18F4x08_RevID_OFFSET                                   0
#define D18F4x08_RevID_WIDTH                                    8
#define D18F4x08_RevID_MASK                                     0xff
#define D18F4x08_ClassCode_OFFSET                               8
#define D18F4x08_ClassCode_WIDTH                                24
#define D18F4x08_ClassCode_MASK                                 0xffffff00

/// D18F4x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x08_STRUCT;

// **** D18F4x0C Register Definition ****
// Address
#define D18F4x0C_ADDRESS                                        0xc

// Type
#define D18F4x0C_TYPE                                           TYPE_D18F4
// Field Data
#define D18F4x0C_HeaderTypeReg_OFFSET                           0
#define D18F4x0C_HeaderTypeReg_WIDTH                            32
#define D18F4x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F4x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x0C_STRUCT;

// **** D18F4x34 Register Definition ****
// Address
#define D18F4x34_ADDRESS                                        0x34

// Type
#define D18F4x34_TYPE                                           TYPE_D18F4
// Field Data
#define D18F4x34_CapPtr_OFFSET                                  0
#define D18F4x34_CapPtr_WIDTH                                   8
#define D18F4x34_CapPtr_MASK                                    0xff
#define D18F4x34_Reserved_31_8_OFFSET                           8
#define D18F4x34_Reserved_31_8_WIDTH                            24
#define D18F4x34_Reserved_31_8_MASK                             0xffffff00

/// D18F4x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x34_STRUCT;

// **** D18F4x108 Register Definition ****
// Address
#define D18F4x108_ADDRESS                                       0x108

// Type
#define D18F4x108_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x108_Reserved_31_0_OFFSET                          0
#define D18F4x108_Reserved_31_0_WIDTH                           32
#define D18F4x108_Reserved_31_0_MASK                            0xffffffff

/// D18F4x108
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x108_STRUCT;

// **** D18F4x10C Register Definition ****
// Address
#define D18F4x10C_ADDRESS                                       0x10c

// Type
#define D18F4x10C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x10C_NodeTdpLimit_OFFSET                           0
#define D18F4x10C_NodeTdpLimit_WIDTH                            12
#define D18F4x10C_NodeTdpLimit_MASK                             0xfff
#define D18F4x10C_Reserved_31_12_OFFSET                         12
#define D18F4x10C_Reserved_31_12_WIDTH                          20
#define D18F4x10C_Reserved_31_12_MASK                           0xfffff000

/// D18F4x10C
typedef union {
  struct {                                                              ///<
    UINT32                                             NodeTdpLimit:12; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x10C_STRUCT;

// **** D18F4x110 Register Definition ****
// Address
#define D18F4x110_ADDRESS                                       0x110

// Type
#define D18F4x110_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x110_CSampleTimer_OFFSET                           0
#define D18F4x110_CSampleTimer_WIDTH                            12
#define D18F4x110_CSampleTimer_MASK                             0xfff
#define D18F4x110_Reserved_12_12_OFFSET                         12
#define D18F4x110_Reserved_12_12_WIDTH                          1
#define D18F4x110_Reserved_12_12_MASK                           0x1000
#define D18F4x110_MinResTmr_OFFSET                              13
#define D18F4x110_MinResTmr_WIDTH                               8
#define D18F4x110_MinResTmr_MASK                                0x1fe000
#define D18F4x110_Reserved_31_21_OFFSET                         21
#define D18F4x110_Reserved_31_21_WIDTH                          11
#define D18F4x110_Reserved_31_21_MASK                           0xffe00000

/// D18F4x110
typedef union {
  struct {                                                              ///<
    UINT32                                             CSampleTimer:12; ///<
    UINT32                                           Reserved_12_12:1 ; ///<
    UINT32                                                MinResTmr:8 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x110_STRUCT;

// **** D18F4x118 Register Definition ****
// Address
#define D18F4x118_ADDRESS                                       0x118

// Type
#define D18F4x118_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x118_CpuPrbEnCstAct0_OFFSET                        0
#define D18F4x118_CpuPrbEnCstAct0_WIDTH                         1
#define D18F4x118_CpuPrbEnCstAct0_MASK                          0x1
#define D18F4x118_CacheFlushEnCstAct0_OFFSET                    1
#define D18F4x118_CacheFlushEnCstAct0_WIDTH                     1
#define D18F4x118_CacheFlushEnCstAct0_MASK                      0x2
#define D18F4x118_CacheFlushTmrSelCstAct0_OFFSET                2
#define D18F4x118_CacheFlushTmrSelCstAct0_WIDTH                 2
#define D18F4x118_CacheFlushTmrSelCstAct0_MASK                  0xc
#define D18F4x118_Reserved_4_4_OFFSET                           4
#define D18F4x118_Reserved_4_4_WIDTH                            1
#define D18F4x118_Reserved_4_4_MASK                             0x10
#define D18F4x118_ClkDivisorCstAct0_OFFSET                      5
#define D18F4x118_ClkDivisorCstAct0_WIDTH                       3
#define D18F4x118_ClkDivisorCstAct0_MASK                        0xe0
#define D18F4x118_PwrGateEnCstAct0_OFFSET                       8
#define D18F4x118_PwrGateEnCstAct0_WIDTH                        1
#define D18F4x118_PwrGateEnCstAct0_MASK                         0x100
#define D18F4x118_PwrOffEnCstAct0_OFFSET                        9
#define D18F4x118_PwrOffEnCstAct0_WIDTH                         1
#define D18F4x118_PwrOffEnCstAct0_MASK                          0x200
#define D18F4x118_NbPwrGate0_OFFSET                             10
#define D18F4x118_NbPwrGate0_WIDTH                              1
#define D18F4x118_NbPwrGate0_MASK                               0x400
#define D18F4x118_NbClkGate0_OFFSET                             11
#define D18F4x118_NbClkGate0_WIDTH                              1
#define D18F4x118_NbClkGate0_MASK                               0x800
#define D18F4x118_SelfRefr0_OFFSET                              12
#define D18F4x118_SelfRefr0_WIDTH                               1
#define D18F4x118_SelfRefr0_MASK                                0x1000
#define D18F4x118_SelfRefrEarly0_OFFSET                         13
#define D18F4x118_SelfRefrEarly0_WIDTH                          1
#define D18F4x118_SelfRefrEarly0_MASK                           0x2000
#define D18F4x118_Reserved_15_14_OFFSET                         14
#define D18F4x118_Reserved_15_14_WIDTH                          2
#define D18F4x118_Reserved_15_14_MASK                           0xc000
#define D18F4x118_CpuPrbEnCstAct1_OFFSET                        16
#define D18F4x118_CpuPrbEnCstAct1_WIDTH                         1
#define D18F4x118_CpuPrbEnCstAct1_MASK                          0x10000
#define D18F4x118_CacheFlushEnCstAct1_OFFSET                    17
#define D18F4x118_CacheFlushEnCstAct1_WIDTH                     1
#define D18F4x118_CacheFlushEnCstAct1_MASK                      0x20000
#define D18F4x118_CacheFlushTmrSelCstAct1_OFFSET                18
#define D18F4x118_CacheFlushTmrSelCstAct1_WIDTH                 2
#define D18F4x118_CacheFlushTmrSelCstAct1_MASK                  0xc0000
#define D18F4x118_Reserved_20_20_OFFSET                         20
#define D18F4x118_Reserved_20_20_WIDTH                          1
#define D18F4x118_Reserved_20_20_MASK                           0x100000
#define D18F4x118_ClkDivisorCstAct1_OFFSET                      21
#define D18F4x118_ClkDivisorCstAct1_WIDTH                       3
#define D18F4x118_ClkDivisorCstAct1_MASK                        0xe00000
#define D18F4x118_PwrGateEnCstAct1_OFFSET                       24
#define D18F4x118_PwrGateEnCstAct1_WIDTH                        1
#define D18F4x118_PwrGateEnCstAct1_MASK                         0x1000000
#define D18F4x118_PwrOffEnCstAct1_OFFSET                        25
#define D18F4x118_PwrOffEnCstAct1_WIDTH                         1
#define D18F4x118_PwrOffEnCstAct1_MASK                          0x2000000
#define D18F4x118_NbPwrGate1_OFFSET                             26
#define D18F4x118_NbPwrGate1_WIDTH                              1
#define D18F4x118_NbPwrGate1_MASK                               0x4000000
#define D18F4x118_NbClkGate1_OFFSET                             27
#define D18F4x118_NbClkGate1_WIDTH                              1
#define D18F4x118_NbClkGate1_MASK                               0x8000000
#define D18F4x118_SelfRefr1_OFFSET                              28
#define D18F4x118_SelfRefr1_WIDTH                               1
#define D18F4x118_SelfRefr1_MASK                                0x10000000
#define D18F4x118_SelfRefrEarly1_OFFSET                         29
#define D18F4x118_SelfRefrEarly1_WIDTH                          1
#define D18F4x118_SelfRefrEarly1_MASK                           0x20000000
#define D18F4x118_Reserved_31_30_OFFSET                         30
#define D18F4x118_Reserved_31_30_WIDTH                          2
#define D18F4x118_Reserved_31_30_MASK                           0xc0000000

/// D18F4x118
typedef union {
  struct {                                                              ///<
    UINT32                                          CpuPrbEnCstAct0:1 ; ///<
    UINT32                                      CacheFlushEnCstAct0:1 ; ///<
    UINT32                                  CacheFlushTmrSelCstAct0:2 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                        ClkDivisorCstAct0:3 ; ///<
    UINT32                                         PwrGateEnCstAct0:1 ; ///<
    UINT32                                          PwrOffEnCstAct0:1 ; ///<
    UINT32                                               NbPwrGate0:1 ; ///<
    UINT32                                               NbClkGate0:1 ; ///<
    UINT32                                                SelfRefr0:1 ; ///<
    UINT32                                           SelfRefrEarly0:1 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                          CpuPrbEnCstAct1:1 ; ///<
    UINT32                                      CacheFlushEnCstAct1:1 ; ///<
    UINT32                                  CacheFlushTmrSelCstAct1:2 ; ///<
    UINT32                                           Reserved_20_20:1 ; ///<
    UINT32                                        ClkDivisorCstAct1:3 ; ///<
    UINT32                                         PwrGateEnCstAct1:1 ; ///<
    UINT32                                          PwrOffEnCstAct1:1 ; ///<
    UINT32                                               NbPwrGate1:1 ; ///<
    UINT32                                               NbClkGate1:1 ; ///<
    UINT32                                                SelfRefr1:1 ; ///<
    UINT32                                           SelfRefrEarly1:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x118_STRUCT;

// **** D18F4x11C Register Definition ****
// Address
#define D18F4x11C_ADDRESS                                       0x11c

// Type
#define D18F4x11C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x11C_CpuPrbEnCstAct2_OFFSET                        0
#define D18F4x11C_CpuPrbEnCstAct2_WIDTH                         1
#define D18F4x11C_CpuPrbEnCstAct2_MASK                          0x1
#define D18F4x11C_CacheFlushEnCstAct2_OFFSET                    1
#define D18F4x11C_CacheFlushEnCstAct2_WIDTH                     1
#define D18F4x11C_CacheFlushEnCstAct2_MASK                      0x2
#define D18F4x11C_CacheFlushTmrSelCstAct2_OFFSET                2
#define D18F4x11C_CacheFlushTmrSelCstAct2_WIDTH                 2
#define D18F4x11C_CacheFlushTmrSelCstAct2_MASK                  0xc
#define D18F4x11C_Reserved_4_4_OFFSET                           4
#define D18F4x11C_Reserved_4_4_WIDTH                            1
#define D18F4x11C_Reserved_4_4_MASK                             0x10
#define D18F4x11C_ClkDivisorCstAct2_OFFSET                      5
#define D18F4x11C_ClkDivisorCstAct2_WIDTH                       3
#define D18F4x11C_ClkDivisorCstAct2_MASK                        0xe0
#define D18F4x11C_PwrGateEnCstAct2_OFFSET                       8
#define D18F4x11C_PwrGateEnCstAct2_WIDTH                        1
#define D18F4x11C_PwrGateEnCstAct2_MASK                         0x100
#define D18F4x11C_PwrOffEnCstAct2_OFFSET                        9
#define D18F4x11C_PwrOffEnCstAct2_WIDTH                         1
#define D18F4x11C_PwrOffEnCstAct2_MASK                          0x200
#define D18F4x11C_NbPwrGate2_OFFSET                             10
#define D18F4x11C_NbPwrGate2_WIDTH                              1
#define D18F4x11C_NbPwrGate2_MASK                               0x400
#define D18F4x11C_NbClkGate2_OFFSET                             11
#define D18F4x11C_NbClkGate2_WIDTH                              1
#define D18F4x11C_NbClkGate2_MASK                               0x800
#define D18F4x11C_SelfRefr2_OFFSET                              12
#define D18F4x11C_SelfRefr2_WIDTH                               1
#define D18F4x11C_SelfRefr2_MASK                                0x1000
#define D18F4x11C_SelfRefrEarly2_OFFSET                         13
#define D18F4x11C_SelfRefrEarly2_WIDTH                          1
#define D18F4x11C_SelfRefrEarly2_MASK                           0x2000
#define D18F4x11C_Reserved_31_14_OFFSET                         14
#define D18F4x11C_Reserved_31_14_WIDTH                          18
#define D18F4x11C_Reserved_31_14_MASK                           0xffffc000

/// D18F4x11C
typedef union {
  struct {                                                              ///<
    UINT32                                          CpuPrbEnCstAct2:1 ; ///<
    UINT32                                      CacheFlushEnCstAct2:1 ; ///<
    UINT32                                  CacheFlushTmrSelCstAct2:2 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                        ClkDivisorCstAct2:3 ; ///<
    UINT32                                         PwrGateEnCstAct2:1 ; ///<
    UINT32                                          PwrOffEnCstAct2:1 ; ///<
    UINT32                                               NbPwrGate2:1 ; ///<
    UINT32                                               NbClkGate2:1 ; ///<
    UINT32                                                SelfRefr2:1 ; ///<
    UINT32                                           SelfRefrEarly2:1 ; ///<
    UINT32                                           Reserved_31_14:18; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x11C_STRUCT;

// **** D18F4x124 Register Definition ****
// Address
#define D18F4x124_ADDRESS                                       0x124

// Type
#define D18F4x124_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x124_Reserved_21_0_OFFSET                          0
#define D18F4x124_Reserved_21_0_WIDTH                           22
#define D18F4x124_Reserved_21_0_MASK                            0x3fffff
#define D18F4x124_IntMonPC6En_OFFSET                            22
#define D18F4x124_IntMonPC6En_WIDTH                             1
#define D18F4x124_IntMonPC6En_MASK                              0x400000
#define D18F4x124_IntMonPC6Limit_OFFSET                         23
#define D18F4x124_IntMonPC6Limit_WIDTH                          4
#define D18F4x124_IntMonPC6Limit_MASK                           0x7800000
#define D18F4x124_Reserved_31_27_OFFSET                         27
#define D18F4x124_Reserved_31_27_WIDTH                          5
#define D18F4x124_Reserved_31_27_MASK                           0xf8000000

/// D18F4x124
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_21_0:22; ///<
    UINT32                                              IntMonPC6En:1 ; ///<
    UINT32                                           IntMonPC6Limit:4 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x124_STRUCT;

// **** D18F4x128 Register Definition ****
// Address
#define D18F4x128_ADDRESS                                       0x128

// Type
#define D18F4x128_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x128_Reserved_0_0_OFFSET                           0
#define D18F4x128_Reserved_0_0_WIDTH                            1
#define D18F4x128_Reserved_0_0_MASK                             0x1
#define D18F4x128_CoreCstatePolicy_OFFSET                       1
#define D18F4x128_CoreCstatePolicy_WIDTH                        1
#define D18F4x128_CoreCstatePolicy_MASK                         0x2
#define D18F4x128_HaltCstateIndex_OFFSET                        2
#define D18F4x128_HaltCstateIndex_WIDTH                         3
#define D18F4x128_HaltCstateIndex_MASK                          0x1c
#define D18F4x128_CacheFlushTmr_OFFSET                          5
#define D18F4x128_CacheFlushTmr_WIDTH                           7
#define D18F4x128_CacheFlushTmr_MASK                            0xfe0
#define D18F4x128_Reserved_17_12_OFFSET                         12
#define D18F4x128_Reserved_17_12_WIDTH                          6
#define D18F4x128_Reserved_17_12_MASK                           0x3f000
#define D18F4x128_CacheFlushSucMonThreshold_OFFSET              18
#define D18F4x128_CacheFlushSucMonThreshold_WIDTH               3
#define D18F4x128_CacheFlushSucMonThreshold_MASK                0x1c0000
#define D18F4x128_Reserved_30_21_OFFSET                         21
#define D18F4x128_Reserved_30_21_WIDTH                          10
#define D18F4x128_Reserved_30_21_MASK                           0x7fe00000
#define D18F4x128_CstateMsgDis_OFFSET                           31
#define D18F4x128_CstateMsgDis_WIDTH                            1
#define D18F4x128_CstateMsgDis_MASK                             0x80000000

/// D18F4x128
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                         CoreCstatePolicy:1 ; ///<
    UINT32                                          HaltCstateIndex:3 ; ///<
    UINT32                                            CacheFlushTmr:7 ; ///<
    UINT32                                           Reserved_17_12:6 ; ///<
    UINT32                                CacheFlushSucMonThreshold:3 ; ///<
    UINT32                                           Reserved_30_21:10; ///<
    UINT32                                             CstateMsgDis:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x128_STRUCT;

// **** D18F4x13C Register Definition ****
// Address
#define D18F4x13C_ADDRESS                                       0x13c

// Type
#define D18F4x13C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x13C_SmuPstateLimitEn_OFFSET                       0
#define D18F4x13C_SmuPstateLimitEn_WIDTH                        1
#define D18F4x13C_SmuPstateLimitEn_MASK                         0x1
#define D18F4x13C_SmuPstateLimit_OFFSET                         1
#define D18F4x13C_SmuPstateLimit_WIDTH                          3
#define D18F4x13C_SmuPstateLimit_MASK                           0xe
#define D18F4x13C_Reserved_31_4_OFFSET                          4
#define D18F4x13C_Reserved_31_4_WIDTH                           28
#define D18F4x13C_Reserved_31_4_MASK                            0xfffffff0

/// D18F4x13C
typedef union {
  struct {                                                              ///<
    UINT32                                         SmuPstateLimitEn:1 ; ///<
    UINT32                                           SmuPstateLimit:3 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x13C_STRUCT;

// **** D18F4x15C Register Definition ****
// Address
#define D18F4x15C_ADDRESS                                       0x15c

// Type
#define D18F4x15C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x15C_BoostSrc_OFFSET                               0
#define D18F4x15C_BoostSrc_WIDTH                                2
#define D18F4x15C_BoostSrc_MASK                                 0x3
#define D18F4x15C_NumBoostStates_OFFSET                         2
#define D18F4x15C_NumBoostStates_WIDTH                          3
#define D18F4x15C_NumBoostStates_MASK                           0x1c
#define D18F4x15C_Reserved_6_5_OFFSET                           5
#define D18F4x15C_Reserved_6_5_WIDTH                            2
#define D18F4x15C_Reserved_6_5_MASK                             0x60
#define D18F4x15C_ApmMasterEn_OFFSET                            7
#define D18F4x15C_ApmMasterEn_WIDTH                             1
#define D18F4x15C_ApmMasterEn_MASK                              0x80
#define D18F4x15C_Reserved_27_8_OFFSET                          8
#define D18F4x15C_Reserved_27_8_WIDTH                           20
#define D18F4x15C_Reserved_27_8_MASK                            0xfffff00
#define D18F4x15C_Reserved_30_28_OFFSET                         28
#define D18F4x15C_Reserved_30_28_WIDTH                          3
#define D18F4x15C_Reserved_30_28_MASK                           0x70000000
#define D18F4x15C_BoostLock_OFFSET                              31
#define D18F4x15C_BoostLock_WIDTH                               1
#define D18F4x15C_BoostLock_MASK                                0x80000000

/// D18F4x15C
typedef union {
  struct {                                                              ///<
    UINT32                                                 BoostSrc:2 ; ///<
    UINT32                                           NumBoostStates:3 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                              ApmMasterEn:1 ; ///<
    UINT32                                            Reserved_27_8:20; ///<
    UINT32                                           Reserved_30_28:3 ; ///<
    UINT32                                                BoostLock:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x15C_STRUCT;


// **** D18F4x164 Register Definition ****
// Address
#define D18F4x164_ADDRESS                                       0x164

// Type
#define D18F4x164_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x164_FixedErrata_OFFSET                            0
#define D18F4x164_FixedErrata_WIDTH                             32
#define D18F4x164_FixedErrata_MASK                              0xffffffff

/// D18F4x164
typedef union {
  struct {                                                              ///<
    UINT32                                              FixedErrata:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x164_STRUCT;

// **** D18F4x16C Register Definition ****
// Address
#define D18F4x16C_ADDRESS                                       0x16c

// Type
#define D18F4x16C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x16C_CstateBoost_OFFSET                            6
#define D18F4x16C_CstateBoost_WIDTH                             3
#define D18F4x16C_CstateBoost_MASK                              0x1c0
#define D18F4x16C_CstateCnt_OFFSET                              9
#define D18F4x16C_CstateCnt_WIDTH                               3
#define D18F4x16C_CstateCnt_MASK                                0xe00
#define D18F4x16C_Reserved_31_12_OFFSET                         12
#define D18F4x16C_Reserved_31_12_WIDTH                          20
#define D18F4x16C_Reserved_31_12_MASK                           0xfffff000

/// D18F4x16C
typedef union {
  struct {                                                              ///<
    UINT32                                             :6 ; ///<
    UINT32                                              CstateBoost:3 ; ///<
    UINT32                                                CstateCnt:3 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x16C_STRUCT;


// **** D18F5x00 Register Definition ****
// Address
#define D18F5x00_ADDRESS                                        0x0

// Type
#define D18F5x00_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x00_VendorID_OFFSET                                0
#define D18F5x00_VendorID_WIDTH                                 16
#define D18F5x00_VendorID_MASK                                  0xffff
#define D18F5x00_DeviceID_OFFSET                                16
#define D18F5x00_DeviceID_WIDTH                                 16
#define D18F5x00_DeviceID_MASK                                  0xffff0000

/// D18F5x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x00_STRUCT;

// **** D18F5x04 Register Definition ****
// Address
#define D18F5x04_ADDRESS                                        0x4

// Type
#define D18F5x04_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x04_Command_OFFSET                                 0
#define D18F5x04_Command_WIDTH                                  16
#define D18F5x04_Command_MASK                                   0xffff
#define D18F5x04_Status_OFFSET                                  16
#define D18F5x04_Status_WIDTH                                   16
#define D18F5x04_Status_MASK                                    0xffff0000

/// D18F5x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x04_STRUCT;

// **** D18F5x08 Register Definition ****
// Address
#define D18F5x08_ADDRESS                                        0x8

// Type
#define D18F5x08_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x08_RevID_OFFSET                                   0
#define D18F5x08_RevID_WIDTH                                    8
#define D18F5x08_RevID_MASK                                     0xff
#define D18F5x08_ClassCode_OFFSET                               8
#define D18F5x08_ClassCode_WIDTH                                24
#define D18F5x08_ClassCode_MASK                                 0xffffff00

/// D18F5x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x08_STRUCT;

// **** D18F5x0C Register Definition ****
// Address
#define D18F5x0C_ADDRESS                                        0xc

// Type
#define D18F5x0C_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x0C_HeaderTypeReg_OFFSET                           0
#define D18F5x0C_HeaderTypeReg_WIDTH                            32
#define D18F5x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F5x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x0C_STRUCT;

// **** D18F5x34 Register Definition ****
// Address
#define D18F5x34_ADDRESS                                        0x34

// Type
#define D18F5x34_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x34_CapPtr_OFFSET                                  0
#define D18F5x34_CapPtr_WIDTH                                   8
#define D18F5x34_CapPtr_MASK                                    0xff
#define D18F5x34_Reserved_31_8_OFFSET                           8
#define D18F5x34_Reserved_31_8_WIDTH                            24
#define D18F5x34_Reserved_31_8_MASK                             0xffffff00

/// D18F5x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x34_STRUCT;

// **** D18F5x40 Register Definition ****
// Address
#define D18F5x40_ADDRESS                                        0x40

// Type
#define D18F5x40_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x40_EventSelect_7_0__OFFSET                        0
#define D18F5x40_EventSelect_7_0__WIDTH                         8
#define D18F5x40_EventSelect_7_0__MASK                          0xff
#define D18F5x40_UnitMask_OFFSET                                8
#define D18F5x40_UnitMask_WIDTH                                 8
#define D18F5x40_UnitMask_MASK                                  0xff00
#define D18F5x40_Reserved_18_16_OFFSET                          16
#define D18F5x40_Reserved_18_16_WIDTH                           3
#define D18F5x40_Reserved_18_16_MASK                            0x70000
#define D18F5x40_Reserved_19_19_OFFSET                          19
#define D18F5x40_Reserved_19_19_WIDTH                           1
#define D18F5x40_Reserved_19_19_MASK                            0x80000
#define D18F5x40_Int_OFFSET                                     20
#define D18F5x40_Int_WIDTH                                      1
#define D18F5x40_Int_MASK                                       0x100000
#define D18F5x40_Reserved_21_21_OFFSET                          21
#define D18F5x40_Reserved_21_21_WIDTH                           1
#define D18F5x40_Reserved_21_21_MASK                            0x200000
#define D18F5x40_En_OFFSET                                      22
#define D18F5x40_En_WIDTH                                       1
#define D18F5x40_En_MASK                                        0x400000
#define D18F5x40_Reserved_31_23_OFFSET                          23
#define D18F5x40_Reserved_31_23_WIDTH                           9
#define D18F5x40_Reserved_31_23_MASK                            0xff800000

/// D18F5x40
typedef union {
  struct {                                                              ///<
    UINT32                                         EventSelect_7_0_:8 ; ///<
    UINT32                                                 UnitMask:8 ; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                      Int:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x40_STRUCT;

// **** D18F5x44 Register Definition ****
// Address
#define D18F5x44_ADDRESS                                        0x44

// Type
#define D18F5x44_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x44_EventSelect_11_8__OFFSET                       0
#define D18F5x44_EventSelect_11_8__WIDTH                        4
#define D18F5x44_EventSelect_11_8__MASK                         0xf
#define D18F5x44_Reserved_63_36_OFFSET                          4
#define D18F5x44_Reserved_63_36_WIDTH                           28
#define D18F5x44_Reserved_63_36_MASK                            0xfffffff0

/// D18F5x44
typedef union {
  struct {                                                              ///<
    UINT32                                        EventSelect_11_8_:4 ; ///<
    UINT32                                           Reserved_63_36:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x44_STRUCT;

// **** D18F5x48 Register Definition ****
// Address
#define D18F5x48_ADDRESS                                        0x48

// Type
#define D18F5x48_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x48_CTR_31_0__OFFSET                               0
#define D18F5x48_CTR_31_0__WIDTH                                32
#define D18F5x48_CTR_31_0__MASK                                 0xffffffff

/// D18F5x48
typedef union {
  struct {                                                              ///<
    UINT32                                                CTR_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x48_STRUCT;

// **** D18F5x4C Register Definition ****
// Address
#define D18F5x4C_ADDRESS                                        0x4c

// Type
#define D18F5x4C_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x4C_CTR_47_32__OFFSET                              0
#define D18F5x4C_CTR_47_32__WIDTH                               16
#define D18F5x4C_CTR_47_32__MASK                                0xffff
#define D18F5x4C_RAZ_63_48_OFFSET                               16
#define D18F5x4C_RAZ_63_48_WIDTH                                16
#define D18F5x4C_RAZ_63_48_MASK                                 0xffff0000

/// D18F5x4C
typedef union {
  struct {                                                              ///<
    UINT32                                               CTR_47_32_:16; ///<
    UINT32                                                RAZ_63_48:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x4C_STRUCT;

// **** D18F5x50 Register Definition ****
// Address
#define D18F5x50_ADDRESS                                        0x50

// Type
#define D18F5x50_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x50_EventSelect_7_0__OFFSET                        0
#define D18F5x50_EventSelect_7_0__WIDTH                         8
#define D18F5x50_EventSelect_7_0__MASK                          0xff
#define D18F5x50_UnitMask_OFFSET                                8
#define D18F5x50_UnitMask_WIDTH                                 8
#define D18F5x50_UnitMask_MASK                                  0xff00
#define D18F5x50_Reserved_18_16_OFFSET                          16
#define D18F5x50_Reserved_18_16_WIDTH                           3
#define D18F5x50_Reserved_18_16_MASK                            0x70000
#define D18F5x50_Reserved_19_19_OFFSET                          19
#define D18F5x50_Reserved_19_19_WIDTH                           1
#define D18F5x50_Reserved_19_19_MASK                            0x80000
#define D18F5x50_Int_OFFSET                                     20
#define D18F5x50_Int_WIDTH                                      1
#define D18F5x50_Int_MASK                                       0x100000
#define D18F5x50_Reserved_21_21_OFFSET                          21
#define D18F5x50_Reserved_21_21_WIDTH                           1
#define D18F5x50_Reserved_21_21_MASK                            0x200000
#define D18F5x50_En_OFFSET                                      22
#define D18F5x50_En_WIDTH                                       1
#define D18F5x50_En_MASK                                        0x400000
#define D18F5x50_Reserved_31_23_OFFSET                          23
#define D18F5x50_Reserved_31_23_WIDTH                           9
#define D18F5x50_Reserved_31_23_MASK                            0xff800000

/// D18F5x50
typedef union {
  struct {                                                              ///<
    UINT32                                         EventSelect_7_0_:8 ; ///<
    UINT32                                                 UnitMask:8 ; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                      Int:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x50_STRUCT;

// **** D18F5x54 Register Definition ****
// Address
#define D18F5x54_ADDRESS                                        0x54

// Type
#define D18F5x54_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x54_EventSelect_11_8__OFFSET                       0
#define D18F5x54_EventSelect_11_8__WIDTH                        4
#define D18F5x54_EventSelect_11_8__MASK                         0xf
#define D18F5x54_Reserved_63_36_OFFSET                          4
#define D18F5x54_Reserved_63_36_WIDTH                           28
#define D18F5x54_Reserved_63_36_MASK                            0xfffffff0

/// D18F5x54
typedef union {
  struct {                                                              ///<
    UINT32                                        EventSelect_11_8_:4 ; ///<
    UINT32                                           Reserved_63_36:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x54_STRUCT;

// **** D18F5x58 Register Definition ****
// Address
#define D18F5x58_ADDRESS                                        0x58

// Type
#define D18F5x58_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x58_CTR_31_0__OFFSET                               0
#define D18F5x58_CTR_31_0__WIDTH                                32
#define D18F5x58_CTR_31_0__MASK                                 0xffffffff

/// D18F5x58
typedef union {
  struct {                                                              ///<
    UINT32                                                CTR_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x58_STRUCT;

// **** D18F5x5C Register Definition ****
// Address
#define D18F5x5C_ADDRESS                                        0x5c

// Type
#define D18F5x5C_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x5C_CTR_47_32__OFFSET                              0
#define D18F5x5C_CTR_47_32__WIDTH                               16
#define D18F5x5C_CTR_47_32__MASK                                0xffff
#define D18F5x5C_RAZ_63_48_OFFSET                               16
#define D18F5x5C_RAZ_63_48_WIDTH                                16
#define D18F5x5C_RAZ_63_48_MASK                                 0xffff0000

/// D18F5x5C
typedef union {
  struct {                                                              ///<
    UINT32                                               CTR_47_32_:16; ///<
    UINT32                                                RAZ_63_48:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x5C_STRUCT;

// **** D18F5x60 Register Definition ****
// Address
#define D18F5x60_ADDRESS                                        0x60

// Type
#define D18F5x60_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x60_EventSelect_7_0__OFFSET                        0
#define D18F5x60_EventSelect_7_0__WIDTH                         8
#define D18F5x60_EventSelect_7_0__MASK                          0xff
#define D18F5x60_UnitMask_OFFSET                                8
#define D18F5x60_UnitMask_WIDTH                                 8
#define D18F5x60_UnitMask_MASK                                  0xff00
#define D18F5x60_Reserved_18_16_OFFSET                          16
#define D18F5x60_Reserved_18_16_WIDTH                           3
#define D18F5x60_Reserved_18_16_MASK                            0x70000
#define D18F5x60_Reserved_19_19_OFFSET                          19
#define D18F5x60_Reserved_19_19_WIDTH                           1
#define D18F5x60_Reserved_19_19_MASK                            0x80000
#define D18F5x60_Int_OFFSET                                     20
#define D18F5x60_Int_WIDTH                                      1
#define D18F5x60_Int_MASK                                       0x100000
#define D18F5x60_Reserved_21_21_OFFSET                          21
#define D18F5x60_Reserved_21_21_WIDTH                           1
#define D18F5x60_Reserved_21_21_MASK                            0x200000
#define D18F5x60_En_OFFSET                                      22
#define D18F5x60_En_WIDTH                                       1
#define D18F5x60_En_MASK                                        0x400000
#define D18F5x60_Reserved_31_23_OFFSET                          23
#define D18F5x60_Reserved_31_23_WIDTH                           9
#define D18F5x60_Reserved_31_23_MASK                            0xff800000

/// D18F5x60
typedef union {
  struct {                                                              ///<
    UINT32                                         EventSelect_7_0_:8 ; ///<
    UINT32                                                 UnitMask:8 ; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                      Int:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x60_STRUCT;

// **** D18F5x64 Register Definition ****
// Address
#define D18F5x64_ADDRESS                                        0x64

// Type
#define D18F5x64_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x64_EventSelect_11_8__OFFSET                       0
#define D18F5x64_EventSelect_11_8__WIDTH                        4
#define D18F5x64_EventSelect_11_8__MASK                         0xf
#define D18F5x64_Reserved_63_36_OFFSET                          4
#define D18F5x64_Reserved_63_36_WIDTH                           28
#define D18F5x64_Reserved_63_36_MASK                            0xfffffff0

/// D18F5x64
typedef union {
  struct {                                                              ///<
    UINT32                                        EventSelect_11_8_:4 ; ///<
    UINT32                                           Reserved_63_36:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x64_STRUCT;

// **** D18F5x68 Register Definition ****
// Address
#define D18F5x68_ADDRESS                                        0x68

// Type
#define D18F5x68_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x68_CTR_31_0__OFFSET                               0
#define D18F5x68_CTR_31_0__WIDTH                                32
#define D18F5x68_CTR_31_0__MASK                                 0xffffffff

/// D18F5x68
typedef union {
  struct {                                                              ///<
    UINT32                                                CTR_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x68_STRUCT;

// **** D18F5x6C Register Definition ****
// Address
#define D18F5x6C_ADDRESS                                        0x6c

// Type
#define D18F5x6C_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x6C_CTR_47_32__OFFSET                              0
#define D18F5x6C_CTR_47_32__WIDTH                               16
#define D18F5x6C_CTR_47_32__MASK                                0xffff
#define D18F5x6C_RAZ_63_48_OFFSET                               16
#define D18F5x6C_RAZ_63_48_WIDTH                                16
#define D18F5x6C_RAZ_63_48_MASK                                 0xffff0000

/// D18F5x6C
typedef union {
  struct {                                                              ///<
    UINT32                                               CTR_47_32_:16; ///<
    UINT32                                                RAZ_63_48:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x6C_STRUCT;

// **** D18F5x70 Register Definition ****
// Address
#define D18F5x70_ADDRESS                                        0x70

// Type
#define D18F5x70_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x70_EventSelect_7_0__OFFSET                        0
#define D18F5x70_EventSelect_7_0__WIDTH                         8
#define D18F5x70_EventSelect_7_0__MASK                          0xff
#define D18F5x70_UnitMask_OFFSET                                8
#define D18F5x70_UnitMask_WIDTH                                 8
#define D18F5x70_UnitMask_MASK                                  0xff00
#define D18F5x70_Reserved_18_16_OFFSET                          16
#define D18F5x70_Reserved_18_16_WIDTH                           3
#define D18F5x70_Reserved_18_16_MASK                            0x70000
#define D18F5x70_Reserved_19_19_OFFSET                          19
#define D18F5x70_Reserved_19_19_WIDTH                           1
#define D18F5x70_Reserved_19_19_MASK                            0x80000
#define D18F5x70_Int_OFFSET                                     20
#define D18F5x70_Int_WIDTH                                      1
#define D18F5x70_Int_MASK                                       0x100000
#define D18F5x70_Reserved_21_21_OFFSET                          21
#define D18F5x70_Reserved_21_21_WIDTH                           1
#define D18F5x70_Reserved_21_21_MASK                            0x200000
#define D18F5x70_En_OFFSET                                      22
#define D18F5x70_En_WIDTH                                       1
#define D18F5x70_En_MASK                                        0x400000
#define D18F5x70_Reserved_31_23_OFFSET                          23
#define D18F5x70_Reserved_31_23_WIDTH                           9
#define D18F5x70_Reserved_31_23_MASK                            0xff800000

/// D18F5x70
typedef union {
  struct {                                                              ///<
    UINT32                                         EventSelect_7_0_:8 ; ///<
    UINT32                                                 UnitMask:8 ; ///<
    UINT32                                           Reserved_18_16:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                      Int:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x70_STRUCT;

// **** D18F5x74 Register Definition ****
// Address
#define D18F5x74_ADDRESS                                        0x74

// Type
#define D18F5x74_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x74_EventSelect_11_8__OFFSET                       0
#define D18F5x74_EventSelect_11_8__WIDTH                        4
#define D18F5x74_EventSelect_11_8__MASK                         0xf
#define D18F5x74_Reserved_63_36_OFFSET                          4
#define D18F5x74_Reserved_63_36_WIDTH                           28
#define D18F5x74_Reserved_63_36_MASK                            0xfffffff0

/// D18F5x74
typedef union {
  struct {                                                              ///<
    UINT32                                        EventSelect_11_8_:4 ; ///<
    UINT32                                           Reserved_63_36:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x74_STRUCT;

// **** D18F5x78 Register Definition ****
// Address
#define D18F5x78_ADDRESS                                        0x78

// Type
#define D18F5x78_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x78_CTR_31_0__OFFSET                               0
#define D18F5x78_CTR_31_0__WIDTH                                32
#define D18F5x78_CTR_31_0__MASK                                 0xffffffff

/// D18F5x78
typedef union {
  struct {                                                              ///<
    UINT32                                                CTR_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x78_STRUCT;

// **** D18F5x7C Register Definition ****
// Address
#define D18F5x7C_ADDRESS                                        0x7c

// Type
#define D18F5x7C_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x7C_CTR_47_32__OFFSET                              0
#define D18F5x7C_CTR_47_32__WIDTH                               16
#define D18F5x7C_CTR_47_32__MASK                                0xffff
#define D18F5x7C_RAZ_63_48_OFFSET                               16
#define D18F5x7C_RAZ_63_48_WIDTH                                16
#define D18F5x7C_RAZ_63_48_MASK                                 0xffff0000

/// D18F5x7C
typedef union {
  struct {                                                              ///<
    UINT32                                               CTR_47_32_:16; ///<
    UINT32                                                RAZ_63_48:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x7C_STRUCT;

// **** D18F5x80 Register Definition ****
// Address
#define D18F5x80_ADDRESS                                        0x80

// Type
#define D18F5x80_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x80_Enabled_OFFSET                                 0
#define D18F5x80_Enabled_WIDTH                                  4
#define D18F5x80_Enabled_MASK                                   0xf
#define D18F5x80_Reserved_15_4_OFFSET                           4
#define D18F5x80_Reserved_15_4_WIDTH                            12
#define D18F5x80_Reserved_15_4_MASK                             0xfff0
#define D18F5x80_DualCore_OFFSET                                16
#define D18F5x80_DualCore_WIDTH                                 4
#define D18F5x80_DualCore_MASK                                  0xf0000
#define D18F5x80_Reserved_31_20_OFFSET                          20
#define D18F5x80_Reserved_31_20_WIDTH                           12
#define D18F5x80_Reserved_31_20_MASK                            0xfff00000

/// D18F5x80
typedef union {
  struct {                                                              ///<
    UINT32                                                  Enabled:4 ; ///<
    UINT32                                            Reserved_15_4:12; ///<
    UINT32                                                 DualCore:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x80_STRUCT;

// **** D18F5x84 Register Definition ****
// Address
#define D18F5x84_ADDRESS                                        0x84

// Type
#define D18F5x84_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x84_CmpCap_OFFSET                                  0
#define D18F5x84_CmpCap_WIDTH                                   8
#define D18F5x84_CmpCap_MASK                                    0xff
#define D18F5x84_Reserved_11_8_OFFSET                           8
#define D18F5x84_Reserved_11_8_WIDTH                            4
#define D18F5x84_Reserved_11_8_MASK                             0xf00
#define D18F5x84_DctEn_OFFSET                                   12
#define D18F5x84_DctEn_WIDTH                                    2
#define D18F5x84_DctEn_MASK                                     0x3000
#define D18F5x84_Reserved_15_14_OFFSET                          14
#define D18F5x84_Reserved_15_14_WIDTH                           2
#define D18F5x84_Reserved_15_14_MASK                            0xc000
#define D18F5x84_DdrMaxRate_OFFSET                              16
#define D18F5x84_DdrMaxRate_WIDTH                               5
#define D18F5x84_DdrMaxRate_MASK                                0x1f0000
#define D18F5x84_Reserved_23_21_OFFSET                          21
#define D18F5x84_Reserved_23_21_WIDTH                           3
#define D18F5x84_Reserved_23_21_MASK                            0xe00000
#define D18F5x84_DdrMaxRateEnf_OFFSET                           24
#define D18F5x84_DdrMaxRateEnf_WIDTH                            5
#define D18F5x84_DdrMaxRateEnf_MASK                             0x1f000000
#define D18F5x84_Reserved_31_29_OFFSET                          29
#define D18F5x84_Reserved_31_29_WIDTH                           3
#define D18F5x84_Reserved_31_29_MASK                            0xe0000000

/// D18F5x84
typedef union {
  struct {                                                              ///<
    UINT32                                                   CmpCap:8 ; ///<
    UINT32                                            Reserved_11_8:4 ; ///<
    UINT32                                                    DctEn:2 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                               DdrMaxRate:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                            DdrMaxRateEnf:5 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x84_STRUCT;

// **** D18F5x88 Register Definition ****
// Address
#define D18F5x88_ADDRESS                                        0x88

// Type
#define D18F5x88_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5x88_Reserved_1_0_OFFSET                            0
#define D18F5x88_Reserved_1_0_WIDTH                             2
#define D18F5x88_Reserved_1_0_MASK                              0x3
#define D18F5x88_IntStpClkHaltExitEn_OFFSET                     2
#define D18F5x88_IntStpClkHaltExitEn_WIDTH                      1
#define D18F5x88_IntStpClkHaltExitEn_MASK                       0x4

/// D18F5x88
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                      IntStpClkHaltExitEn:1 ; ///<
    UINT32                                            :29; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x88_STRUCT;

// **** D18F5xE0 Register Definition ****
// Address
#define D18F5xE0_ADDRESS                                        0xe0

// Type
#define D18F5xE0_TYPE                                           TYPE_D18F5
// Field Data
#define D18F5xE0_RunAvgRange_OFFSET                             0
#define D18F5xE0_RunAvgRange_WIDTH                              4
#define D18F5xE0_RunAvgRange_MASK                               0xf
#define D18F5xE0_Reserved_31_4_OFFSET                           4
#define D18F5xE0_Reserved_31_4_WIDTH                            28
#define D18F5xE0_Reserved_31_4_MASK                             0xfffffff0

/// D18F5xE0
typedef union {
  struct {                                                              ///<
    UINT32                                              RunAvgRange:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5xE0_STRUCT;


// **** D18F5x128 Register Definition ****
// Address
#define D18F5x128_ADDRESS                                       0x128

// Type
#define D18F5x128_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x128_PC6Vid_6_0__OFFSET                            0
#define D18F5x128_PC6Vid_6_0__WIDTH                             7
#define D18F5x128_PC6Vid_6_0__MASK                              0x7f
#define D18F5x128_PllRegTime_OFFSET                             7
#define D18F5x128_PllRegTime_WIDTH                              2
#define D18F5x128_PllRegTime_MASK                               0x180
#define D18F5x128_FastSlamTimeDown_OFFSET                       9
#define D18F5x128_FastSlamTimeDown_WIDTH                        1
#define D18F5x128_FastSlamTimeDown_MASK                         0x200
#define D18F5x128_PllVddOutUpTime_OFFSET                        10
#define D18F5x128_PllVddOutUpTime_WIDTH                         2
#define D18F5x128_PllVddOutUpTime_MASK                          0xc00
#define D18F5x128_PwrGateTmr_OFFSET                             12
#define D18F5x128_PwrGateTmr_WIDTH                              2
#define D18F5x128_PwrGateTmr_MASK                               0x3000
#define D18F5x128_PC6PwrDwnRegEn_OFFSET                         14
#define D18F5x128_PC6PwrDwnRegEn_WIDTH                          1
#define D18F5x128_PC6PwrDwnRegEn_MASK                           0x4000
#define D18F5x128_CC6PwrDwnRegEn_OFFSET                         15
#define D18F5x128_CC6PwrDwnRegEn_WIDTH                          1
#define D18F5x128_CC6PwrDwnRegEn_MASK                           0x8000
#define D18F5x128_Reserved_20_16_OFFSET                         16
#define D18F5x128_Reserved_20_16_WIDTH                          5
#define D18F5x128_Reserved_20_16_MASK                           0x1f0000
#define D18F5x128_PC6Vid_7__OFFSET                              21
#define D18F5x128_PC6Vid_7__WIDTH                               1
#define D18F5x128_PC6Vid_7__MASK                                0x200000
#define D18F5x128_NbPllPwrDwnRegEn_OFFSET                       22
#define D18F5x128_NbPllPwrDwnRegEn_WIDTH                        1
#define D18F5x128_NbPllPwrDwnRegEn_MASK                         0x400000
#define D18F5x128_Reserved_31_23_OFFSET                         23
#define D18F5x128_Reserved_31_23_WIDTH                          9
#define D18F5x128_Reserved_31_23_MASK                           0xff800000

/// D18F5x128
typedef union {
  struct {                                                              ///<
    UINT32                                              PC6Vid_6_0_:7 ; ///<
    UINT32                                               PllRegTime:2 ; ///<
    UINT32                                         FastSlamTimeDown:1 ; ///<
    UINT32                                          PllVddOutUpTime:2 ; ///<
    UINT32                                               PwrGateTmr:2 ; ///<
    UINT32                                           PC6PwrDwnRegEn:1 ; ///<
    UINT32                                           CC6PwrDwnRegEn:1 ; ///<
    UINT32                                           Reserved_20_16:5 ; ///<
    UINT32                                                PC6Vid_7_:1 ; ///<
    UINT32                                         NbPllPwrDwnRegEn:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x128_STRUCT;

// **** D18F5x12C Register Definition ****
// Address
#define D18F5x12C_ADDRESS                                       0x12c

// Type
#define D18F5x12C_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x12C_CoreOffsetTrim_OFFSET                         0
#define D18F5x12C_CoreOffsetTrim_WIDTH                          2
#define D18F5x12C_CoreOffsetTrim_MASK                           0x3
#define D18F5x12C_CoreLoadLineTrim_OFFSET                       2
#define D18F5x12C_CoreLoadLineTrim_WIDTH                        3
#define D18F5x12C_CoreLoadLineTrim_MASK                         0x1c
#define D18F5x12C_CorePsi1En_OFFSET                             5
#define D18F5x12C_CorePsi1En_WIDTH                              1
#define D18F5x12C_CorePsi1En_MASK                               0x20
#define D18F5x12C_Reserved_29_7_OFFSET                          7
#define D18F5x12C_Reserved_29_7_WIDTH                           23
#define D18F5x12C_Reserved_29_7_MASK                            0x3fffff80
#define D18F5x12C_WaitVidCompDis_OFFSET                         30
#define D18F5x12C_WaitVidCompDis_WIDTH                          1
#define D18F5x12C_WaitVidCompDis_MASK                           0x40000000
#define D18F5x12C_Svi2CmdBusy_OFFSET                            31
#define D18F5x12C_Svi2CmdBusy_WIDTH                             1
#define D18F5x12C_Svi2CmdBusy_MASK                              0x80000000

/// D18F5x12C
typedef union {
  struct {                                                              ///<
    UINT32                                           CoreOffsetTrim:2 ; ///<
    UINT32                                         CoreLoadLineTrim:3 ; ///<
    UINT32                                               CorePsi1En:1 ; ///<
    UINT32                                                  :1 ; ///<
    UINT32                                            Reserved_29_7:23; ///<
    UINT32                                           WaitVidCompDis:1 ; ///<
    UINT32                                              Svi2CmdBusy:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x12C_STRUCT;


// **** D18F5x160 Register Definition ****
// Address
#define D18F5x160_ADDRESS                                       0x160

// Type
#define D18F5x160_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x160_NbPstateEn_OFFSET                             0
#define D18F5x160_NbPstateEn_WIDTH                              1
#define D18F5x160_NbPstateEn_MASK                               0x1
#define D18F5x160_NbFid_OFFSET                                  1
#define D18F5x160_NbFid_WIDTH                                   6
#define D18F5x160_NbFid_MASK                                    0x7e
#define D18F5x160_NbDid_OFFSET                                  7
#define D18F5x160_NbDid_WIDTH                                   1
#define D18F5x160_NbDid_MASK                                    0x80
#define D18F5x160_Reserved_9_8_OFFSET                           8
#define D18F5x160_Reserved_9_8_WIDTH                            2
#define D18F5x160_Reserved_9_8_MASK                             0x300
#define D18F5x160_NbVid_6_0__OFFSET                             10
#define D18F5x160_NbVid_6_0__WIDTH                              7
#define D18F5x160_NbVid_6_0__MASK                               0x1fc00
#define D18F5x160_Reserved_17_17_OFFSET                         17
#define D18F5x160_Reserved_17_17_WIDTH                          1
#define D18F5x160_Reserved_17_17_MASK                           0x20000
#define D18F5x160_MemPstate_OFFSET                              18
#define D18F5x160_MemPstate_WIDTH                               1
#define D18F5x160_MemPstate_MASK                                0x40000
#define D18F5x160_Reserved_20_19_OFFSET                         19
#define D18F5x160_Reserved_20_19_WIDTH                          2
#define D18F5x160_Reserved_20_19_MASK                           0x180000
#define D18F5x160_NbVid_7__OFFSET                               21
#define D18F5x160_NbVid_7__WIDTH                                1
#define D18F5x160_NbVid_7__MASK                                 0x200000
#define D18F5x160_NbIddDiv_OFFSET                               22
#define D18F5x160_NbIddDiv_WIDTH                                2
#define D18F5x160_NbIddDiv_MASK                                 0xc00000
#define D18F5x160_NbIddValue_OFFSET                             24
#define D18F5x160_NbIddValue_WIDTH                              8
#define D18F5x160_NbIddValue_MASK                               0xff000000

/// D18F5x160
typedef union {
  struct {                                                              ///<
    UINT32                                               NbPstateEn:1 ; ///<
    UINT32                                                    NbFid:6 ; ///<
    UINT32                                                    NbDid:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               NbVid_6_0_:7 ; ///<
    UINT32                                           Reserved_17_17:1 ; ///<
    UINT32                                                MemPstate:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                                 NbVid_7_:1 ; ///<
    UINT32                                                 NbIddDiv:2 ; ///<
    UINT32                                               NbIddValue:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x160_STRUCT;

// **** D18F5x164 Register Definition ****
// Address
#define D18F5x164_ADDRESS                                       0x164

// Type
#define D18F5x164_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x164_NbPstateEn_OFFSET                             0
#define D18F5x164_NbPstateEn_WIDTH                              1
#define D18F5x164_NbPstateEn_MASK                               0x1
#define D18F5x164_NbFid_OFFSET                                  1
#define D18F5x164_NbFid_WIDTH                                   6
#define D18F5x164_NbFid_MASK                                    0x7e
#define D18F5x164_NbDid_OFFSET                                  7
#define D18F5x164_NbDid_WIDTH                                   1
#define D18F5x164_NbDid_MASK                                    0x80
#define D18F5x164_Reserved_9_8_OFFSET                           8
#define D18F5x164_Reserved_9_8_WIDTH                            2
#define D18F5x164_Reserved_9_8_MASK                             0x300
#define D18F5x164_NbVid_6_0__OFFSET                             10
#define D18F5x164_NbVid_6_0__WIDTH                              7
#define D18F5x164_NbVid_6_0__MASK                               0x1fc00
#define D18F5x164_Reserved_17_17_OFFSET                         17
#define D18F5x164_Reserved_17_17_WIDTH                          1
#define D18F5x164_Reserved_17_17_MASK                           0x20000
#define D18F5x164_MemPstate_OFFSET                              18
#define D18F5x164_MemPstate_WIDTH                               1
#define D18F5x164_MemPstate_MASK                                0x40000
#define D18F5x164_Reserved_20_19_OFFSET                         19
#define D18F5x164_Reserved_20_19_WIDTH                          2
#define D18F5x164_Reserved_20_19_MASK                           0x180000
#define D18F5x164_NbVid_7__OFFSET                               21
#define D18F5x164_NbVid_7__WIDTH                                1
#define D18F5x164_NbVid_7__MASK                                 0x200000
#define D18F5x164_NbIddDiv_OFFSET                               22
#define D18F5x164_NbIddDiv_WIDTH                                2
#define D18F5x164_NbIddDiv_MASK                                 0xc00000
#define D18F5x164_NbIddValue_OFFSET                             24
#define D18F5x164_NbIddValue_WIDTH                              8
#define D18F5x164_NbIddValue_MASK                               0xff000000

/// D18F5x164
typedef union {
  struct {                                                              ///<
    UINT32                                               NbPstateEn:1 ; ///<
    UINT32                                                    NbFid:6 ; ///<
    UINT32                                                    NbDid:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               NbVid_6_0_:7 ; ///<
    UINT32                                           Reserved_17_17:1 ; ///<
    UINT32                                                MemPstate:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                                 NbVid_7_:1 ; ///<
    UINT32                                                 NbIddDiv:2 ; ///<
    UINT32                                               NbIddValue:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x164_STRUCT;

// **** D18F5x168 Register Definition ****
// Address
#define D18F5x168_ADDRESS                                       0x168

// Type
#define D18F5x168_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x168_NbPstateEn_OFFSET                             0
#define D18F5x168_NbPstateEn_WIDTH                              1
#define D18F5x168_NbPstateEn_MASK                               0x1
#define D18F5x168_NbFid_OFFSET                                  1
#define D18F5x168_NbFid_WIDTH                                   6
#define D18F5x168_NbFid_MASK                                    0x7e
#define D18F5x168_NbDid_OFFSET                                  7
#define D18F5x168_NbDid_WIDTH                                   1
#define D18F5x168_NbDid_MASK                                    0x80
#define D18F5x168_Reserved_9_8_OFFSET                           8
#define D18F5x168_Reserved_9_8_WIDTH                            2
#define D18F5x168_Reserved_9_8_MASK                             0x300
#define D18F5x168_NbVid_6_0__OFFSET                             10
#define D18F5x168_NbVid_6_0__WIDTH                              7
#define D18F5x168_NbVid_6_0__MASK                               0x1fc00
#define D18F5x168_Reserved_17_17_OFFSET                         17
#define D18F5x168_Reserved_17_17_WIDTH                          1
#define D18F5x168_Reserved_17_17_MASK                           0x20000
#define D18F5x168_MemPstate_OFFSET                              18
#define D18F5x168_MemPstate_WIDTH                               1
#define D18F5x168_MemPstate_MASK                                0x40000
#define D18F5x168_Reserved_20_19_OFFSET                         19
#define D18F5x168_Reserved_20_19_WIDTH                          2
#define D18F5x168_Reserved_20_19_MASK                           0x180000
#define D18F5x168_NbVid_7__OFFSET                               21
#define D18F5x168_NbVid_7__WIDTH                                1
#define D18F5x168_NbVid_7__MASK                                 0x200000
#define D18F5x168_NbIddDiv_OFFSET                               22
#define D18F5x168_NbIddDiv_WIDTH                                2
#define D18F5x168_NbIddDiv_MASK                                 0xc00000
#define D18F5x168_NbIddValue_OFFSET                             24
#define D18F5x168_NbIddValue_WIDTH                              8
#define D18F5x168_NbIddValue_MASK                               0xff000000

/// D18F5x168
typedef union {
  struct {                                                              ///<
    UINT32                                               NbPstateEn:1 ; ///<
    UINT32                                                    NbFid:6 ; ///<
    UINT32                                                    NbDid:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               NbVid_6_0_:7 ; ///<
    UINT32                                           Reserved_17_17:1 ; ///<
    UINT32                                                MemPstate:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                                 NbVid_7_:1 ; ///<
    UINT32                                                 NbIddDiv:2 ; ///<
    UINT32                                               NbIddValue:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x168_STRUCT;

// **** D18F5x16C Register Definition ****
// Address
#define D18F5x16C_ADDRESS                                       0x16c

// Type
#define D18F5x16C_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x16C_NbPstateEn_OFFSET                             0
#define D18F5x16C_NbPstateEn_WIDTH                              1
#define D18F5x16C_NbPstateEn_MASK                               0x1
#define D18F5x16C_NbFid_OFFSET                                  1
#define D18F5x16C_NbFid_WIDTH                                   6
#define D18F5x16C_NbFid_MASK                                    0x7e
#define D18F5x16C_NbDid_OFFSET                                  7
#define D18F5x16C_NbDid_WIDTH                                   1
#define D18F5x16C_NbDid_MASK                                    0x80
#define D18F5x16C_Reserved_9_8_OFFSET                           8
#define D18F5x16C_Reserved_9_8_WIDTH                            2
#define D18F5x16C_Reserved_9_8_MASK                             0x300
#define D18F5x16C_NbVid_6_0__OFFSET                             10
#define D18F5x16C_NbVid_6_0__WIDTH                              7
#define D18F5x16C_NbVid_6_0__MASK                               0x1fc00
#define D18F5x16C_Reserved_17_17_OFFSET                         17
#define D18F5x16C_Reserved_17_17_WIDTH                          1
#define D18F5x16C_Reserved_17_17_MASK                           0x20000
#define D18F5x16C_MemPstate_OFFSET                              18
#define D18F5x16C_MemPstate_WIDTH                               1
#define D18F5x16C_MemPstate_MASK                                0x40000
#define D18F5x16C_Reserved_20_19_OFFSET                         19
#define D18F5x16C_Reserved_20_19_WIDTH                          2
#define D18F5x16C_Reserved_20_19_MASK                           0x180000
#define D18F5x16C_NbVid_7__OFFSET                               21
#define D18F5x16C_NbVid_7__WIDTH                                1
#define D18F5x16C_NbVid_7__MASK                                 0x200000
#define D18F5x16C_NbIddDiv_OFFSET                               22
#define D18F5x16C_NbIddDiv_WIDTH                                2
#define D18F5x16C_NbIddDiv_MASK                                 0xc00000
#define D18F5x16C_NbIddValue_OFFSET                             24
#define D18F5x16C_NbIddValue_WIDTH                              8
#define D18F5x16C_NbIddValue_MASK                               0xff000000

/// D18F5x16C
typedef union {
  struct {                                                              ///<
    UINT32                                               NbPstateEn:1 ; ///<
    UINT32                                                    NbFid:6 ; ///<
    UINT32                                                    NbDid:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               NbVid_6_0_:7 ; ///<
    UINT32                                           Reserved_17_17:1 ; ///<
    UINT32                                                MemPstate:1 ; ///<
    UINT32                                           Reserved_20_19:2 ; ///<
    UINT32                                                 NbVid_7_:1 ; ///<
    UINT32                                                 NbIddDiv:2 ; ///<
    UINT32                                               NbIddValue:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x16C_STRUCT;

// **** D18F5x170 Register Definition ****
// Address
#define D18F5x170_ADDRESS                                       0x170

// Type
#define D18F5x170_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x170_NbPstateMaxVal_OFFSET                         0
#define D18F5x170_NbPstateMaxVal_WIDTH                          2
#define D18F5x170_NbPstateMaxVal_MASK                           0x3
#define D18F5x170_Reserved_2_2_OFFSET                           2
#define D18F5x170_Reserved_2_2_WIDTH                            1
#define D18F5x170_Reserved_2_2_MASK                             0x4
#define D18F5x170_NbPstateLo_OFFSET                             3
#define D18F5x170_NbPstateLo_WIDTH                              2
#define D18F5x170_NbPstateLo_MASK                               0x18
#define D18F5x170_Reserved_5_5_OFFSET                           5
#define D18F5x170_Reserved_5_5_WIDTH                            1
#define D18F5x170_Reserved_5_5_MASK                             0x20
#define D18F5x170_NbPstateHi_OFFSET                             6
#define D18F5x170_NbPstateHi_WIDTH                              2
#define D18F5x170_NbPstateHi_MASK                               0xc0
#define D18F5x170_Reserved_8_8_OFFSET                           8
#define D18F5x170_Reserved_8_8_WIDTH                            1
#define D18F5x170_Reserved_8_8_MASK                             0x100
#define D18F5x170_NbPstateThreshold_OFFSET                      9
#define D18F5x170_NbPstateThreshold_WIDTH                       3
#define D18F5x170_NbPstateThreshold_MASK                        0xe00
#define D18F5x170_Reserved_12_12_OFFSET                         12
#define D18F5x170_Reserved_12_12_WIDTH                          1
#define D18F5x170_Reserved_12_12_MASK                           0x1000
#define D18F5x170_NbPstateDisOnP0_OFFSET                        13
#define D18F5x170_NbPstateDisOnP0_WIDTH                         1
#define D18F5x170_NbPstateDisOnP0_MASK                          0x2000
#define D18F5x170_SwNbPstateLoDis_OFFSET                        14
#define D18F5x170_SwNbPstateLoDis_WIDTH                         1
#define D18F5x170_SwNbPstateLoDis_MASK                          0x4000
#define D18F5x170_Reserved_22_15_OFFSET                         15
#define D18F5x170_Reserved_22_15_WIDTH                          8
#define D18F5x170_Reserved_22_15_MASK                           0x7f8000
#define D18F5x170_NbPstateGnbSlowDis_OFFSET                     23
#define D18F5x170_NbPstateGnbSlowDis_WIDTH                      1
#define D18F5x170_NbPstateGnbSlowDis_MASK                       0x800000
#define D18F5x170_NbPstateLoRes_OFFSET                          24
#define D18F5x170_NbPstateLoRes_WIDTH                           3
#define D18F5x170_NbPstateLoRes_MASK                            0x7000000
#define D18F5x170_NbPstateHiRes_OFFSET                          27
#define D18F5x170_NbPstateHiRes_WIDTH                           3
#define D18F5x170_NbPstateHiRes_MASK                            0x38000000
#define D18F5x170_Reserved_30_30_OFFSET                         30
#define D18F5x170_Reserved_30_30_WIDTH                          1
#define D18F5x170_Reserved_30_30_MASK                           0x40000000
#define D18F5x170_MemPstateDis_OFFSET                           31
#define D18F5x170_MemPstateDis_WIDTH                            1
#define D18F5x170_MemPstateDis_MASK                             0x80000000

/// D18F5x170
typedef union {
  struct {                                                              ///<
    UINT32                                           NbPstateMaxVal:2 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                               NbPstateLo:2 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                               NbPstateHi:2 ; ///<
    UINT32                                             Reserved_8_8:1 ; ///<
    UINT32                                        NbPstateThreshold:3 ; ///<
    UINT32                                           Reserved_12_12:1 ; ///<
    UINT32                                          NbPstateDisOnP0:1 ; ///<
    UINT32                                          SwNbPstateLoDis:1 ; ///<
    UINT32                                           Reserved_22_15:8 ; ///<
    UINT32                                       NbPstateGnbSlowDis:1 ; ///<
    UINT32                                            NbPstateLoRes:3 ; ///<
    UINT32                                            NbPstateHiRes:3 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             MemPstateDis:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x170_STRUCT;

// **** D18F5x174 Register Definition ****
// Address
#define D18F5x174_ADDRESS                                       0x174

// Type
#define D18F5x174_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x174_NbPstateDis_OFFSET                            0
#define D18F5x174_NbPstateDis_WIDTH                             1
#define D18F5x174_NbPstateDis_MASK                              0x1
#define D18F5x174_StartupNbPstate_OFFSET                        1
#define D18F5x174_StartupNbPstate_WIDTH                         2
#define D18F5x174_StartupNbPstate_MASK                          0x6
#define D18F5x174_CurNbFid_OFFSET                               3
#define D18F5x174_CurNbFid_WIDTH                                6
#define D18F5x174_CurNbFid_MASK                                 0x1f8
#define D18F5x174_CurNbDid_OFFSET                               9
#define D18F5x174_CurNbDid_WIDTH                                1
#define D18F5x174_CurNbDid_MASK                                 0x200
#define D18F5x174_Reserved_11_10_OFFSET                         10
#define D18F5x174_Reserved_11_10_WIDTH                          2
#define D18F5x174_Reserved_11_10_MASK                           0xc00
#define D18F5x174_CurNbVid_6_0__OFFSET                          12
#define D18F5x174_CurNbVid_6_0__WIDTH                           7
#define D18F5x174_CurNbVid_6_0__MASK                            0x7f000
#define D18F5x174_CurNbPstate_OFFSET                            19
#define D18F5x174_CurNbPstate_WIDTH                             2
#define D18F5x174_CurNbPstate_MASK                              0x180000
#define D18F5x174_Reserved_22_21_OFFSET                         21
#define D18F5x174_Reserved_22_21_WIDTH                          2
#define D18F5x174_Reserved_22_21_MASK                           0x600000
#define D18F5x174_CurNbVid_7__OFFSET                            23
#define D18F5x174_CurNbVid_7__WIDTH                             1
#define D18F5x174_CurNbVid_7__MASK                              0x800000
#define D18F5x174_CurMemPstate_OFFSET                           24
#define D18F5x174_CurMemPstate_WIDTH                            1
#define D18F5x174_CurMemPstate_MASK                             0x1000000
#define D18F5x174_Reserved_31_25_OFFSET                         25
#define D18F5x174_Reserved_31_25_WIDTH                          7
#define D18F5x174_Reserved_31_25_MASK                           0xfe000000

/// D18F5x174
typedef union {
  struct {                                                              ///<
    UINT32                                              NbPstateDis:1 ; ///<
    UINT32                                          StartupNbPstate:2 ; ///<
    UINT32                                                 CurNbFid:6 ; ///<
    UINT32                                                 CurNbDid:1 ; ///<
    UINT32                                           Reserved_11_10:2 ; ///<
    UINT32                                            CurNbVid_6_0_:7 ; ///<
    UINT32                                              CurNbPstate:2 ; ///<
    UINT32                                           Reserved_22_21:2 ; ///<
    UINT32                                              CurNbVid_7_:1 ; ///<
    UINT32                                             CurMemPstate:1 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x174_STRUCT;

// **** D18F5x178 Register Definition ****
// Address
#define D18F5x178_ADDRESS                                       0x178

// Type
#define D18F5x178_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x178_Reserved_1_0_OFFSET                           0
#define D18F5x178_Reserved_1_0_WIDTH                            2
#define D18F5x178_Reserved_1_0_MASK                             0x3
#define D18F5x178_CstateFusionDis_OFFSET                        2
#define D18F5x178_CstateFusionDis_WIDTH                         1
#define D18F5x178_CstateFusionDis_MASK                          0x4
#define D18F5x178_CstateThreeWayHsEn_OFFSET                     3
#define D18F5x178_CstateThreeWayHsEn_WIDTH                      1
#define D18F5x178_CstateThreeWayHsEn_MASK                       0x8
#define D18F5x178_Reserved_9_4_OFFSET                           4
#define D18F5x178_Reserved_9_4_WIDTH                            6
#define D18F5x178_Reserved_9_4_MASK                             0x3f0
#define D18F5x178_InbWakeS3Dis_OFFSET                           10
#define D18F5x178_InbWakeS3Dis_WIDTH                            1
#define D18F5x178_InbWakeS3Dis_MASK                             0x400
#define D18F5x178_AllowSelfRefrS3Dis_OFFSET                     11
#define D18F5x178_AllowSelfRefrS3Dis_WIDTH                      1
#define D18F5x178_AllowSelfRefrS3Dis_MASK                       0x800
#define D18F5x178_CstateFusionHsDis_OFFSET                      18
#define D18F5x178_CstateFusionHsDis_WIDTH                       1
#define D18F5x178_CstateFusionHsDis_MASK                        0x40000
#define D18F5x178_SwGfxDis_OFFSET                               19
#define D18F5x178_SwGfxDis_WIDTH                                1
#define D18F5x178_SwGfxDis_MASK                                 0x80000
#define D18F5x178_Reserved_31_20_OFFSET                         20
#define D18F5x178_Reserved_31_20_WIDTH                          12
#define D18F5x178_Reserved_31_20_MASK                           0xfff00000

/// D18F5x178
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                          CstateFusionDis:1 ; ///<
    UINT32                                       CstateThreeWayHsEn:1 ; ///<
    UINT32                                             Reserved_9_4:6 ; ///<
    UINT32                                             InbWakeS3Dis:1 ; ///<
    UINT32                                       AllowSelfRefrS3Dis:1 ; ///<
    UINT32                                           :6 ; ///<
    UINT32                                        CstateFusionHsDis:1 ; ///<
    UINT32                                                 SwGfxDis:1 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x178_STRUCT;

// **** D18F5x17C Register Definition ****
// Address
#define D18F5x17C_ADDRESS                                       0x17c

// Type
#define D18F5x17C_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x17C_MaxVid_OFFSET                                 0
#define D18F5x17C_MaxVid_WIDTH                                  8
#define D18F5x17C_MaxVid_MASK                                   0xff
#define D18F5x17C_Reserved_9_8_OFFSET                           8
#define D18F5x17C_Reserved_9_8_WIDTH                            2
#define D18F5x17C_Reserved_9_8_MASK                             0x300
#define D18F5x17C_MinVid_OFFSET                                 10
#define D18F5x17C_MinVid_WIDTH                                  8
#define D18F5x17C_MinVid_MASK                                   0x3fc00
#define D18F5x17C_Reserved_22_18_OFFSET                         18
#define D18F5x17C_Reserved_22_18_WIDTH                          5
#define D18F5x17C_Reserved_22_18_MASK                           0x7c0000
#define D18F5x17C_NbPsi0Vid_7_0__OFFSET                         23
#define D18F5x17C_NbPsi0Vid_7_0__WIDTH                          8
#define D18F5x17C_NbPsi0Vid_7_0__MASK                           0x7f800000
#define D18F5x17C_NbPsi0VidEn_OFFSET                            31
#define D18F5x17C_NbPsi0VidEn_WIDTH                             1
#define D18F5x17C_NbPsi0VidEn_MASK                              0x80000000

/// D18F5x17C
typedef union {
  struct {                                                              ///<
    UINT32                                                   MaxVid:8 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                                   MinVid:8 ; ///<
    UINT32                                           Reserved_22_18:5 ; ///<
    UINT32                                           NbPsi0Vid_7_0_:8 ; ///<
    UINT32                                              NbPsi0VidEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x17C_STRUCT;

// **** D18F5x188 Register Definition ****
// Address
#define D18F5x188_ADDRESS                                       0x188

// Type
#define D18F5x188_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x188_NbOffsetTrim_OFFSET                           0
#define D18F5x188_NbOffsetTrim_WIDTH                            2
#define D18F5x188_NbOffsetTrim_MASK                             0x3
#define D18F5x188_NbLoadLineTrim_OFFSET                         2
#define D18F5x188_NbLoadLineTrim_WIDTH                          3
#define D18F5x188_NbLoadLineTrim_MASK                           0x1c
#define D18F5x188_NbPsi1_OFFSET                                 5
#define D18F5x188_NbPsi1_WIDTH                                  1
#define D18F5x188_NbPsi1_MASK                                   0x20
#define D18F5x188_Reserved_31_7_OFFSET                          7
#define D18F5x188_Reserved_31_7_WIDTH                           25
#define D18F5x188_Reserved_31_7_MASK                            0xffffff80

/// D18F5x188
typedef union {
  struct {                                                              ///<
    UINT32                                             NbOffsetTrim:2 ; ///<
    UINT32                                           NbLoadLineTrim:3 ; ///<
    UINT32                                                   NbPsi1:1 ; ///<
    UINT32                                                    NbTfn:1 ; ///<
    UINT32                                            Reserved_31_7:25; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x188_STRUCT;

// **** D18F5x194 Register Definition ****
// Address
#define D18F5x194_ADDRESS                                       0x194

// Type
#define D18F5x194_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x194_Index_OFFSET                                  0
#define D18F5x194_Index_WIDTH                                   4
#define D18F5x194_Index_MASK                                    0xf
#define D18F5x194_Reserved_31_4_OFFSET                          4
#define D18F5x194_Reserved_31_4_WIDTH                           28
#define D18F5x194_Reserved_31_4_MASK                            0xfffffff0

/// D18F5x194
typedef union {
  struct {                                                              ///<
    UINT32                                                    Index:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x194_STRUCT;

// **** D18F5x198 Register Definition ****
// Address
#define D18F5x198_ADDRESS                                       0x198

// Type
#define D18F5x198_TYPE                                          TYPE_D18F5
// Field Data
#define D18F5x198_Data_OFFSET                                   0
#define D18F5x198_Data_WIDTH                                    32
#define D18F5x198_Data_MASK                                     0xffffffff

/// D18F5x198
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F5x198_STRUCT;

// **** DxF0x00 Register Definition ****
// Address
#define DxF0x00_ADDRESS                                         0x0

// Type
#define DxF0x00_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x00_VendorID_OFFSET                                 0
#define DxF0x00_VendorID_WIDTH                                  16
#define DxF0x00_VendorID_MASK                                   0xffff
#define DxF0x00_DeviceID_OFFSET                                 16
#define DxF0x00_DeviceID_WIDTH                                  16
#define DxF0x00_DeviceID_MASK                                   0xffff0000

/// DxF0x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x00_STRUCT;

// **** DxF0x04 Register Definition ****
// Address
#define DxF0x04_ADDRESS                                         0x4

// Type
#define DxF0x04_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x04_IoAccessEn_OFFSET                               0
#define DxF0x04_IoAccessEn_WIDTH                                1
#define DxF0x04_IoAccessEn_MASK                                 0x1
#define DxF0x04_MemAccessEn_OFFSET                              1
#define DxF0x04_MemAccessEn_WIDTH                               1
#define DxF0x04_MemAccessEn_MASK                                0x2
#define DxF0x04_BusMasterEn_OFFSET                              2
#define DxF0x04_BusMasterEn_WIDTH                               1
#define DxF0x04_BusMasterEn_MASK                                0x4
#define DxF0x04_SpecialCycleEn_OFFSET                           3
#define DxF0x04_SpecialCycleEn_WIDTH                            1
#define DxF0x04_SpecialCycleEn_MASK                             0x8
#define DxF0x04_MemWriteInvalidateEn_OFFSET                     4
#define DxF0x04_MemWriteInvalidateEn_WIDTH                      1
#define DxF0x04_MemWriteInvalidateEn_MASK                       0x10
#define DxF0x04_PalSnoopEn_OFFSET                               5
#define DxF0x04_PalSnoopEn_WIDTH                                1
#define DxF0x04_PalSnoopEn_MASK                                 0x20
#define DxF0x04_ParityErrorEn_OFFSET                            6
#define DxF0x04_ParityErrorEn_WIDTH                             1
#define DxF0x04_ParityErrorEn_MASK                              0x40
#define DxF0x04_Stepping_OFFSET                                 7
#define DxF0x04_Stepping_WIDTH                                  1
#define DxF0x04_Stepping_MASK                                   0x80
#define DxF0x04_SerrEn_OFFSET                                   8
#define DxF0x04_SerrEn_WIDTH                                    1
#define DxF0x04_SerrEn_MASK                                     0x100
#define DxF0x04_FastB2BEn_OFFSET                                9
#define DxF0x04_FastB2BEn_WIDTH                                 1
#define DxF0x04_FastB2BEn_MASK                                  0x200
#define DxF0x04_IntDis_OFFSET                                   10
#define DxF0x04_IntDis_WIDTH                                    1
#define DxF0x04_IntDis_MASK                                     0x400
#define DxF0x04_Reserved_18_11_OFFSET                           11
#define DxF0x04_Reserved_18_11_WIDTH                            8
#define DxF0x04_Reserved_18_11_MASK                             0x7f800
#define DxF0x04_IntStatus_OFFSET                                19
#define DxF0x04_IntStatus_WIDTH                                 1
#define DxF0x04_IntStatus_MASK                                  0x80000
#define DxF0x04_CapList_OFFSET                                  20
#define DxF0x04_CapList_WIDTH                                   1
#define DxF0x04_CapList_MASK                                    0x100000
#define DxF0x04_PCI66En_OFFSET                                  21
#define DxF0x04_PCI66En_WIDTH                                   1
#define DxF0x04_PCI66En_MASK                                    0x200000
#define DxF0x04_UDFEn_OFFSET                                    22
#define DxF0x04_UDFEn_WIDTH                                     1
#define DxF0x04_UDFEn_MASK                                      0x400000
#define DxF0x04_FastBackCapable_OFFSET                          23
#define DxF0x04_FastBackCapable_WIDTH                           1
#define DxF0x04_FastBackCapable_MASK                            0x800000
#define DxF0x04_DataPerr_OFFSET                                 24
#define DxF0x04_DataPerr_WIDTH                                  1
#define DxF0x04_DataPerr_MASK                                   0x1000000
#define DxF0x04_DevselTiming_OFFSET                             25
#define DxF0x04_DevselTiming_WIDTH                              2
#define DxF0x04_DevselTiming_MASK                               0x6000000
#define DxF0x04_SignalTargetAbort_OFFSET                        27
#define DxF0x04_SignalTargetAbort_WIDTH                         1
#define DxF0x04_SignalTargetAbort_MASK                          0x8000000
#define DxF0x04_ReceivedTargetAbort_OFFSET                      28
#define DxF0x04_ReceivedTargetAbort_WIDTH                       1
#define DxF0x04_ReceivedTargetAbort_MASK                        0x10000000
#define DxF0x04_ReceivedMasterAbort_OFFSET                      29
#define DxF0x04_ReceivedMasterAbort_WIDTH                       1
#define DxF0x04_ReceivedMasterAbort_MASK                        0x20000000
#define DxF0x04_SignaledSystemError_OFFSET                      30
#define DxF0x04_SignaledSystemError_WIDTH                       1
#define DxF0x04_SignaledSystemError_MASK                        0x40000000
#define DxF0x04_ParityErrorDetected_OFFSET                      31
#define DxF0x04_ParityErrorDetected_WIDTH                       1
#define DxF0x04_ParityErrorDetected_MASK                        0x80000000

/// DxF0x04
typedef union {
  struct {                                                              ///<
    UINT32                                               IoAccessEn:1 ; ///<
    UINT32                                              MemAccessEn:1 ; ///<
    UINT32                                              BusMasterEn:1 ; ///<
    UINT32                                           SpecialCycleEn:1 ; ///<
    UINT32                                     MemWriteInvalidateEn:1 ; ///<
    UINT32                                               PalSnoopEn:1 ; ///<
    UINT32                                            ParityErrorEn:1 ; ///<
    UINT32                                                 Stepping:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                FastB2BEn:1 ; ///<
    UINT32                                                   IntDis:1 ; ///<
    UINT32                                           Reserved_18_11:8 ; ///<
    UINT32                                                IntStatus:1 ; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                                    UDFEn:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                                 DataPerr:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      SignaledSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x04_STRUCT;

// **** DxF0x08 Register Definition ****
// Address
#define DxF0x08_ADDRESS                                         0x8

// Type
#define DxF0x08_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x08_RevID_OFFSET                                    0
#define DxF0x08_RevID_WIDTH                                     8
#define DxF0x08_RevID_MASK                                      0xff
#define DxF0x08_ClassCode_OFFSET                                8
#define DxF0x08_ClassCode_WIDTH                                 24
#define DxF0x08_ClassCode_MASK                                  0xffffff00

/// DxF0x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x08_STRUCT;

// **** DxF0x0C Register Definition ****
// Address
#define DxF0x0C_ADDRESS                                         0xc

// Type
#define DxF0x0C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x0C_CacheLineSize_OFFSET                            0
#define DxF0x0C_CacheLineSize_WIDTH                             8
#define DxF0x0C_CacheLineSize_MASK                              0xff
#define DxF0x0C_LatencyTimer_OFFSET                             8
#define DxF0x0C_LatencyTimer_WIDTH                              8
#define DxF0x0C_LatencyTimer_MASK                               0xff00
#define DxF0x0C_HeaderTypeReg_OFFSET                            16
#define DxF0x0C_HeaderTypeReg_WIDTH                             8
#define DxF0x0C_HeaderTypeReg_MASK                              0xff0000
#define DxF0x0C_BIST_OFFSET                                     24
#define DxF0x0C_BIST_WIDTH                                      8
#define DxF0x0C_BIST_MASK                                       0xff000000

/// DxF0x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            CacheLineSize:8 ; ///<
    UINT32                                             LatencyTimer:8 ; ///<
    UINT32                                            HeaderTypeReg:8 ; ///<
    UINT32                                                     BIST:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x0C_STRUCT;

// **** DxF0x18 Register Definition ****
// Address
#define DxF0x18_ADDRESS                                         0x18

// Type
#define DxF0x18_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x18_PrimaryBus_OFFSET                               0
#define DxF0x18_PrimaryBus_WIDTH                                8
#define DxF0x18_PrimaryBus_MASK                                 0xff
#define DxF0x18_SecondaryBus_OFFSET                             8
#define DxF0x18_SecondaryBus_WIDTH                              8
#define DxF0x18_SecondaryBus_MASK                               0xff00
#define DxF0x18_SubBusNumber_OFFSET                             16
#define DxF0x18_SubBusNumber_WIDTH                              8
#define DxF0x18_SubBusNumber_MASK                               0xff0000
#define DxF0x18_SecondaryLatencyTimer_OFFSET                    24
#define DxF0x18_SecondaryLatencyTimer_WIDTH                     8
#define DxF0x18_SecondaryLatencyTimer_MASK                      0xff000000

/// DxF0x18
typedef union {
  struct {                                                              ///<
    UINT32                                               PrimaryBus:8 ; ///<
    UINT32                                             SecondaryBus:8 ; ///<
    UINT32                                             SubBusNumber:8 ; ///<
    UINT32                                    SecondaryLatencyTimer:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x18_STRUCT;

// **** DxF0x1C Register Definition ****
// Address
#define DxF0x1C_ADDRESS                                         0x1c

// Type
#define DxF0x1C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x1C_Reserved_3_0_OFFSET                             0
#define DxF0x1C_Reserved_3_0_WIDTH                              4
#define DxF0x1C_Reserved_3_0_MASK                               0xf
#define DxF0x1C_IOBase_15_12__OFFSET                            4
#define DxF0x1C_IOBase_15_12__WIDTH                             4
#define DxF0x1C_IOBase_15_12__MASK                              0xf0
#define DxF0x1C_Reserved_11_8_OFFSET                            8
#define DxF0x1C_Reserved_11_8_WIDTH                             4
#define DxF0x1C_Reserved_11_8_MASK                              0xf00
#define DxF0x1C_IOLimit_15_12__OFFSET                           12
#define DxF0x1C_IOLimit_15_12__WIDTH                            4
#define DxF0x1C_IOLimit_15_12__MASK                             0xf000
#define DxF0x1C_Reserved_19_16_OFFSET                           16
#define DxF0x1C_Reserved_19_16_WIDTH                            4
#define DxF0x1C_Reserved_19_16_MASK                             0xf0000
#define DxF0x1C_CapList_OFFSET                                  20
#define DxF0x1C_CapList_WIDTH                                   1
#define DxF0x1C_CapList_MASK                                    0x100000
#define DxF0x1C_PCI66En_OFFSET                                  21
#define DxF0x1C_PCI66En_WIDTH                                   1
#define DxF0x1C_PCI66En_MASK                                    0x200000
#define DxF0x1C_UDFEn_OFFSET                                    22
#define DxF0x1C_UDFEn_WIDTH                                     1
#define DxF0x1C_UDFEn_MASK                                      0x400000
#define DxF0x1C_FastBackCapable_OFFSET                          23
#define DxF0x1C_FastBackCapable_WIDTH                           1
#define DxF0x1C_FastBackCapable_MASK                            0x800000
#define DxF0x1C_MasterDataPerr_OFFSET                           24
#define DxF0x1C_MasterDataPerr_WIDTH                            1
#define DxF0x1C_MasterDataPerr_MASK                             0x1000000
#define DxF0x1C_DevselTiming_OFFSET                             25
#define DxF0x1C_DevselTiming_WIDTH                              2
#define DxF0x1C_DevselTiming_MASK                               0x6000000
#define DxF0x1C_SignalTargetAbort_OFFSET                        27
#define DxF0x1C_SignalTargetAbort_WIDTH                         1
#define DxF0x1C_SignalTargetAbort_MASK                          0x8000000
#define DxF0x1C_ReceivedTargetAbort_OFFSET                      28
#define DxF0x1C_ReceivedTargetAbort_WIDTH                       1
#define DxF0x1C_ReceivedTargetAbort_MASK                        0x10000000
#define DxF0x1C_ReceivedMasterAbort_OFFSET                      29
#define DxF0x1C_ReceivedMasterAbort_WIDTH                       1
#define DxF0x1C_ReceivedMasterAbort_MASK                        0x20000000
#define DxF0x1C_ReceivedSystemError_OFFSET                      30
#define DxF0x1C_ReceivedSystemError_WIDTH                       1
#define DxF0x1C_ReceivedSystemError_MASK                        0x40000000
#define DxF0x1C_ParityErrorDetected_OFFSET                      31
#define DxF0x1C_ParityErrorDetected_WIDTH                       1
#define DxF0x1C_ParityErrorDetected_MASK                        0x80000000

/// DxF0x1C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            IOBase_15_12_:4 ; ///<
    UINT32                                            Reserved_11_8:4 ; ///<
    UINT32                                           IOLimit_15_12_:4 ; ///<
    UINT32                                           Reserved_19_16:4 ; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                                    UDFEn:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                           MasterDataPerr:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      ReceivedSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x1C_STRUCT;

// **** DxF0x20 Register Definition ****
// Address
#define DxF0x20_ADDRESS                                         0x20

// Type
#define DxF0x20_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x20_Reserved_3_0_OFFSET                             0
#define DxF0x20_Reserved_3_0_WIDTH                              4
#define DxF0x20_Reserved_3_0_MASK                               0xf
#define DxF0x20_MemBase_OFFSET                                  4
#define DxF0x20_MemBase_WIDTH                                   12
#define DxF0x20_MemBase_MASK                                    0xfff0
#define DxF0x20_Reserved_19_16_OFFSET                           16
#define DxF0x20_Reserved_19_16_WIDTH                            4
#define DxF0x20_Reserved_19_16_MASK                             0xf0000
#define DxF0x20_MemLimit_OFFSET                                 20
#define DxF0x20_MemLimit_WIDTH                                  12
#define DxF0x20_MemLimit_MASK                                   0xfff00000

/// DxF0x20
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                  MemBase:12; ///<
    UINT32                                           Reserved_19_16:4 ; ///<
    UINT32                                                 MemLimit:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x20_STRUCT;

// **** DxF0x24 Register Definition ****
// Address
#define DxF0x24_ADDRESS                                         0x24

// Type
#define DxF0x24_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x24_PrefMemBaseR_OFFSET                             0
#define DxF0x24_PrefMemBaseR_WIDTH                              4
#define DxF0x24_PrefMemBaseR_MASK                               0xf
#define DxF0x24_PrefMemBase_31_20__OFFSET                       4
#define DxF0x24_PrefMemBase_31_20__WIDTH                        12
#define DxF0x24_PrefMemBase_31_20__MASK                         0xfff0
#define DxF0x24_PrefMemLimitR_OFFSET                            16
#define DxF0x24_PrefMemLimitR_WIDTH                             4
#define DxF0x24_PrefMemLimitR_MASK                              0xf0000
#define DxF0x24_PrefMemLimit_OFFSET                             20
#define DxF0x24_PrefMemLimit_WIDTH                              12
#define DxF0x24_PrefMemLimit_MASK                               0xfff00000

/// DxF0x24
typedef union {
  struct {                                                              ///<
    UINT32                                             PrefMemBaseR:4 ; ///<
    UINT32                                       PrefMemBase_31_20_:12; ///<
    UINT32                                            PrefMemLimitR:4 ; ///<
    UINT32                                             PrefMemLimit:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x24_STRUCT;

// **** DxF0x28 Register Definition ****
// Address
#define DxF0x28_ADDRESS                                         0x28

// Type
#define DxF0x28_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x28_PrefMemBase_63_32__OFFSET                       0
#define DxF0x28_PrefMemBase_63_32__WIDTH                        32
#define DxF0x28_PrefMemBase_63_32__MASK                         0xffffffff

/// DxF0x28
typedef union {
  struct {                                                              ///<
    UINT32                                       PrefMemBase_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x28_STRUCT;

// **** DxF0x2C Register Definition ****
// Address
#define DxF0x2C_ADDRESS                                         0x2c

// Type
#define DxF0x2C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x2C_PrefMemLimit_63_32__OFFSET                      0
#define DxF0x2C_PrefMemLimit_63_32__WIDTH                       32
#define DxF0x2C_PrefMemLimit_63_32__MASK                        0xffffffff

/// DxF0x2C
typedef union {
  struct {                                                              ///<
    UINT32                                      PrefMemLimit_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x2C_STRUCT;

// **** DxF0x30 Register Definition ****
// Address
#define DxF0x30_ADDRESS                                         0x30

// Type
#define DxF0x30_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x30_IOBase_31_16__OFFSET                            0
#define DxF0x30_IOBase_31_16__WIDTH                             16
#define DxF0x30_IOBase_31_16__MASK                              0xffff
#define DxF0x30_IOLimit_31_16__OFFSET                           16
#define DxF0x30_IOLimit_31_16__WIDTH                            16
#define DxF0x30_IOLimit_31_16__MASK                             0xffff0000

/// DxF0x30
typedef union {
  struct {                                                              ///<
    UINT32                                            IOBase_31_16_:16; ///<
    UINT32                                           IOLimit_31_16_:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x30_STRUCT;

// **** DxF0x34 Register Definition ****
// Address
#define DxF0x34_ADDRESS                                         0x34

// Type
#define DxF0x34_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x34_CapPtr_OFFSET                                   0
#define DxF0x34_CapPtr_WIDTH                                    8
#define DxF0x34_CapPtr_MASK                                     0xff
#define DxF0x34_Reserved_31_8_OFFSET                            8
#define DxF0x34_Reserved_31_8_WIDTH                             24
#define DxF0x34_Reserved_31_8_MASK                              0xffffff00

/// DxF0x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x34_STRUCT;

// **** DxF0x3C Register Definition ****
// Address
#define DxF0x3C_ADDRESS                                         0x3c

// Type
#define DxF0x3C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x3C_IntLine_OFFSET                                  0
#define DxF0x3C_IntLine_WIDTH                                   8
#define DxF0x3C_IntLine_MASK                                    0xff
#define DxF0x3C_IntPin_OFFSET                                   8
#define DxF0x3C_IntPin_WIDTH                                    3
#define DxF0x3C_IntPin_MASK                                     0x700
#define DxF0x3C_IntPinR_OFFSET                                  11
#define DxF0x3C_IntPinR_WIDTH                                   5
#define DxF0x3C_IntPinR_MASK                                    0xf800
#define DxF0x3C_ParityResponseEn_OFFSET                         16
#define DxF0x3C_ParityResponseEn_WIDTH                          1
#define DxF0x3C_ParityResponseEn_MASK                           0x10000
#define DxF0x3C_SerrEn_OFFSET                                   17
#define DxF0x3C_SerrEn_WIDTH                                    1
#define DxF0x3C_SerrEn_MASK                                     0x20000
#define DxF0x3C_IsaEn_OFFSET                                    18
#define DxF0x3C_IsaEn_WIDTH                                     1
#define DxF0x3C_IsaEn_MASK                                      0x40000
#define DxF0x3C_VgaEn_OFFSET                                    19
#define DxF0x3C_VgaEn_WIDTH                                     1
#define DxF0x3C_VgaEn_MASK                                      0x80000
#define DxF0x3C_Vga16En_OFFSET                                  20
#define DxF0x3C_Vga16En_WIDTH                                   1
#define DxF0x3C_Vga16En_MASK                                    0x100000
#define DxF0x3C_MasterAbortMode_OFFSET                          21
#define DxF0x3C_MasterAbortMode_WIDTH                           1
#define DxF0x3C_MasterAbortMode_MASK                            0x200000
#define DxF0x3C_SecondaryBusReset_OFFSET                        22
#define DxF0x3C_SecondaryBusReset_WIDTH                         1
#define DxF0x3C_SecondaryBusReset_MASK                          0x400000
#define DxF0x3C_FastB2BCap_OFFSET                               23
#define DxF0x3C_FastB2BCap_WIDTH                                1
#define DxF0x3C_FastB2BCap_MASK                                 0x800000
#define DxF0x3C_Reserved_31_24_OFFSET                           24
#define DxF0x3C_Reserved_31_24_WIDTH                            8
#define DxF0x3C_Reserved_31_24_MASK                             0xff000000

/// DxF0x3C
typedef union {
  struct {                                                              ///<
    UINT32                                                  IntLine:8 ; ///<
    UINT32                                                   IntPin:3 ; ///<
    UINT32                                                  IntPinR:5 ; ///<
    UINT32                                         ParityResponseEn:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                    IsaEn:1 ; ///<
    UINT32                                                    VgaEn:1 ; ///<
    UINT32                                                  Vga16En:1 ; ///<
    UINT32                                          MasterAbortMode:1 ; ///<
    UINT32                                        SecondaryBusReset:1 ; ///<
    UINT32                                               FastB2BCap:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x3C_STRUCT;

// **** DxF0x50 Register Definition ****
// Address
#define DxF0x50_ADDRESS                                         0x50

// Type
#define DxF0x50_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x50_CapID_OFFSET                                    0
#define DxF0x50_CapID_WIDTH                                     8
#define DxF0x50_CapID_MASK                                      0xff
#define DxF0x50_NextPtr_OFFSET                                  8
#define DxF0x50_NextPtr_WIDTH                                   8
#define DxF0x50_NextPtr_MASK                                    0xff00
#define DxF0x50_Version_OFFSET                                  16
#define DxF0x50_Version_WIDTH                                   3
#define DxF0x50_Version_MASK                                    0x70000
#define DxF0x50_PmeClock_OFFSET                                 19
#define DxF0x50_PmeClock_WIDTH                                  1
#define DxF0x50_PmeClock_MASK                                   0x80000
#define DxF0x50_Reserved_20_20_OFFSET                           20
#define DxF0x50_Reserved_20_20_WIDTH                            1
#define DxF0x50_Reserved_20_20_MASK                             0x100000
#define DxF0x50_DevSpecificInit_OFFSET                          21
#define DxF0x50_DevSpecificInit_WIDTH                           1
#define DxF0x50_DevSpecificInit_MASK                            0x200000
#define DxF0x50_AuxCurrent_OFFSET                               22
#define DxF0x50_AuxCurrent_WIDTH                                3
#define DxF0x50_AuxCurrent_MASK                                 0x1c00000
#define DxF0x50_D1Support_OFFSET                                25
#define DxF0x50_D1Support_WIDTH                                 1
#define DxF0x50_D1Support_MASK                                  0x2000000
#define DxF0x50_D2Support_OFFSET                                26
#define DxF0x50_D2Support_WIDTH                                 1
#define DxF0x50_D2Support_MASK                                  0x4000000
#define DxF0x50_PmeSupport_OFFSET                               27
#define DxF0x50_PmeSupport_WIDTH                                5
#define DxF0x50_PmeSupport_MASK                                 0xf8000000

/// DxF0x50
typedef union {
  struct {                                                              ///<
    UINT32                                                    CapID:8 ; ///<
    UINT32                                                  NextPtr:8 ; ///<
    UINT32                                                  Version:3 ; ///<
    UINT32                                                 PmeClock:1 ; ///<
    UINT32                                           Reserved_20_20:1 ; ///<
    UINT32                                          DevSpecificInit:1 ; ///<
    UINT32                                               AuxCurrent:3 ; ///<
    UINT32                                                D1Support:1 ; ///<
    UINT32                                                D2Support:1 ; ///<
    UINT32                                               PmeSupport:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x50_STRUCT;

// **** DxF0x54 Register Definition ****
// Address
#define DxF0x54_ADDRESS                                         0x54

// Type
#define DxF0x54_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x54_PowerState_OFFSET                               0
#define DxF0x54_PowerState_WIDTH                                2
#define DxF0x54_PowerState_MASK                                 0x3
#define DxF0x54_Reserved_2_2_OFFSET                             2
#define DxF0x54_Reserved_2_2_WIDTH                              1
#define DxF0x54_Reserved_2_2_MASK                               0x4
#define DxF0x54_NoSoftReset_OFFSET                              3
#define DxF0x54_NoSoftReset_WIDTH                               1
#define DxF0x54_NoSoftReset_MASK                                0x8
#define DxF0x54_Reserved_7_4_OFFSET                             4
#define DxF0x54_Reserved_7_4_WIDTH                              4
#define DxF0x54_Reserved_7_4_MASK                               0xf0
#define DxF0x54_PmeEn_OFFSET                                    8
#define DxF0x54_PmeEn_WIDTH                                     1
#define DxF0x54_PmeEn_MASK                                      0x100
#define DxF0x54_DataSelect_OFFSET                               9
#define DxF0x54_DataSelect_WIDTH                                4
#define DxF0x54_DataSelect_MASK                                 0x1e00
#define DxF0x54_DataScale_OFFSET                                13
#define DxF0x54_DataScale_WIDTH                                 2
#define DxF0x54_DataScale_MASK                                  0x6000
#define DxF0x54_PmeStatus_OFFSET                                15
#define DxF0x54_PmeStatus_WIDTH                                 1
#define DxF0x54_PmeStatus_MASK                                  0x8000
#define DxF0x54_Reserved_21_16_OFFSET                           16
#define DxF0x54_Reserved_21_16_WIDTH                            6
#define DxF0x54_Reserved_21_16_MASK                             0x3f0000
#define DxF0x54_B2B3Support_OFFSET                              22
#define DxF0x54_B2B3Support_WIDTH                               1
#define DxF0x54_B2B3Support_MASK                                0x400000
#define DxF0x54_BusPwrEn_OFFSET                                 23
#define DxF0x54_BusPwrEn_WIDTH                                  1
#define DxF0x54_BusPwrEn_MASK                                   0x800000
#define DxF0x54_PmeData_OFFSET                                  24
#define DxF0x54_PmeData_WIDTH                                   8
#define DxF0x54_PmeData_MASK                                    0xff000000

/// DxF0x54
typedef union {
  struct {                                                              ///<
    UINT32                                               PowerState:2 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                              NoSoftReset:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    PmeEn:1 ; ///<
    UINT32                                               DataSelect:4 ; ///<
    UINT32                                                DataScale:2 ; ///<
    UINT32                                                PmeStatus:1 ; ///<
    UINT32                                           Reserved_21_16:6 ; ///<
    UINT32                                              B2B3Support:1 ; ///<
    UINT32                                                 BusPwrEn:1 ; ///<
    UINT32                                                  PmeData:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x54_STRUCT;

// **** DxF0x58 Register Definition ****
// Address
#define DxF0x58_ADDRESS                                         0x58

// Type
#define DxF0x58_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x58_CapID_OFFSET                                    0
#define DxF0x58_CapID_WIDTH                                     8
#define DxF0x58_CapID_MASK                                      0xff
#define DxF0x58_NextPtr_OFFSET                                  8
#define DxF0x58_NextPtr_WIDTH                                   8
#define DxF0x58_NextPtr_MASK                                    0xff00
#define DxF0x58_Version_OFFSET                                  16
#define DxF0x58_Version_WIDTH                                   4
#define DxF0x58_Version_MASK                                    0xf0000
#define DxF0x58_DeviceType_OFFSET                               20
#define DxF0x58_DeviceType_WIDTH                                4
#define DxF0x58_DeviceType_MASK                                 0xf00000
#define DxF0x58_SlotImplemented_OFFSET                          24
#define DxF0x58_SlotImplemented_WIDTH                           1
#define DxF0x58_SlotImplemented_MASK                            0x1000000
#define DxF0x58_IntMessageNum_OFFSET                            25
#define DxF0x58_IntMessageNum_WIDTH                             5
#define DxF0x58_IntMessageNum_MASK                              0x3e000000
#define DxF0x58_Reserved_31_30_OFFSET                           30
#define DxF0x58_Reserved_31_30_WIDTH                            2
#define DxF0x58_Reserved_31_30_MASK                             0xc0000000

/// DxF0x58
typedef union {
  struct {                                                              ///<
    UINT32                                                    CapID:8 ; ///<
    UINT32                                                  NextPtr:8 ; ///<
    UINT32                                                  Version:4 ; ///<
    UINT32                                               DeviceType:4 ; ///<
    UINT32                                          SlotImplemented:1 ; ///<
    UINT32                                            IntMessageNum:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x58_STRUCT;

// **** DxF0x5C Register Definition ****
// Address
#define DxF0x5C_ADDRESS                                         0x5c

// Type
#define DxF0x5C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x5C_MaxPayloadSupport_OFFSET                        0
#define DxF0x5C_MaxPayloadSupport_WIDTH                         3
#define DxF0x5C_MaxPayloadSupport_MASK                          0x7
#define DxF0x5C_PhantomFunc_OFFSET                              3
#define DxF0x5C_PhantomFunc_WIDTH                               2
#define DxF0x5C_PhantomFunc_MASK                                0x18
#define DxF0x5C_ExtendedTag_OFFSET                              5
#define DxF0x5C_ExtendedTag_WIDTH                               1
#define DxF0x5C_ExtendedTag_MASK                                0x20
#define DxF0x5C_L0SAcceptableLatency_OFFSET                     6
#define DxF0x5C_L0SAcceptableLatency_WIDTH                      3
#define DxF0x5C_L0SAcceptableLatency_MASK                       0x1c0
#define DxF0x5C_L1AcceptableLatency_OFFSET                      9
#define DxF0x5C_L1AcceptableLatency_WIDTH                       3
#define DxF0x5C_L1AcceptableLatency_MASK                        0xe00
#define DxF0x5C_Reserved_14_12_OFFSET                           12
#define DxF0x5C_Reserved_14_12_WIDTH                            3
#define DxF0x5C_Reserved_14_12_MASK                             0x7000
#define DxF0x5C_RoleBasedErrReporting_OFFSET                    15
#define DxF0x5C_RoleBasedErrReporting_WIDTH                     1
#define DxF0x5C_RoleBasedErrReporting_MASK                      0x8000
#define DxF0x5C_Reserved_17_16_OFFSET                           16
#define DxF0x5C_Reserved_17_16_WIDTH                            2
#define DxF0x5C_Reserved_17_16_MASK                             0x30000
#define DxF0x5C_CapturedSlotPowerLimit_OFFSET                   18
#define DxF0x5C_CapturedSlotPowerLimit_WIDTH                    8
#define DxF0x5C_CapturedSlotPowerLimit_MASK                     0x3fc0000
#define DxF0x5C_CapturedSlotPowerScale_OFFSET                   26
#define DxF0x5C_CapturedSlotPowerScale_WIDTH                    2
#define DxF0x5C_CapturedSlotPowerScale_MASK                     0xc000000
#define DxF0x5C_FlrCapable_OFFSET                               28
#define DxF0x5C_FlrCapable_WIDTH                                1
#define DxF0x5C_FlrCapable_MASK                                 0x10000000
#define DxF0x5C_Reserved_31_29_OFFSET                           29
#define DxF0x5C_Reserved_31_29_WIDTH                            3
#define DxF0x5C_Reserved_31_29_MASK                             0xe0000000

/// DxF0x5C
typedef union {
  struct {                                                              ///<
    UINT32                                        MaxPayloadSupport:3 ; ///<
    UINT32                                              PhantomFunc:2 ; ///<
    UINT32                                              ExtendedTag:1 ; ///<
    UINT32                                     L0SAcceptableLatency:3 ; ///<
    UINT32                                      L1AcceptableLatency:3 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                    RoleBasedErrReporting:1 ; ///<
    UINT32                                           Reserved_17_16:2 ; ///<
    UINT32                                   CapturedSlotPowerLimit:8 ; ///<
    UINT32                                   CapturedSlotPowerScale:2 ; ///<
    UINT32                                               FlrCapable:1 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x5C_STRUCT;

// **** DxF0x60 Register Definition ****
// Address
#define DxF0x60_ADDRESS                                         0x60

// Type
#define DxF0x60_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x60_CorrErrEn_OFFSET                                0
#define DxF0x60_CorrErrEn_WIDTH                                 1
#define DxF0x60_CorrErrEn_MASK                                  0x1
#define DxF0x60_NonFatalErrEn_OFFSET                            1
#define DxF0x60_NonFatalErrEn_WIDTH                             1
#define DxF0x60_NonFatalErrEn_MASK                              0x2
#define DxF0x60_FatalErrEn_OFFSET                               2
#define DxF0x60_FatalErrEn_WIDTH                                1
#define DxF0x60_FatalErrEn_MASK                                 0x4
#define DxF0x60_UsrReportEn_OFFSET                              3
#define DxF0x60_UsrReportEn_WIDTH                               1
#define DxF0x60_UsrReportEn_MASK                                0x8
#define DxF0x60_RelaxedOrdEn_OFFSET                             4
#define DxF0x60_RelaxedOrdEn_WIDTH                              1
#define DxF0x60_RelaxedOrdEn_MASK                               0x10
#define DxF0x60_MaxPayloadSize_OFFSET                           5
#define DxF0x60_MaxPayloadSize_WIDTH                            3
#define DxF0x60_MaxPayloadSize_MASK                             0xe0
#define DxF0x60_ExtendedTagEn_OFFSET                            8
#define DxF0x60_ExtendedTagEn_WIDTH                             1
#define DxF0x60_ExtendedTagEn_MASK                              0x100
#define DxF0x60_PhantomFuncEn_OFFSET                            9
#define DxF0x60_PhantomFuncEn_WIDTH                             1
#define DxF0x60_PhantomFuncEn_MASK                              0x200
#define DxF0x60_AuxPowerPmEn_OFFSET                             10
#define DxF0x60_AuxPowerPmEn_WIDTH                              1
#define DxF0x60_AuxPowerPmEn_MASK                               0x400
#define DxF0x60_NoSnoopEnable_OFFSET                            11
#define DxF0x60_NoSnoopEnable_WIDTH                             1
#define DxF0x60_NoSnoopEnable_MASK                              0x800
#define DxF0x60_MaxRequestSize_OFFSET                           12
#define DxF0x60_MaxRequestSize_WIDTH                            3
#define DxF0x60_MaxRequestSize_MASK                             0x7000
#define DxF0x60_BridgeCfgRetryEn_OFFSET                         15
#define DxF0x60_BridgeCfgRetryEn_WIDTH                          1
#define DxF0x60_BridgeCfgRetryEn_MASK                           0x8000
#define DxF0x60_CorrErr_OFFSET                                  16
#define DxF0x60_CorrErr_WIDTH                                   1
#define DxF0x60_CorrErr_MASK                                    0x10000
#define DxF0x60_NonFatalErr_OFFSET                              17
#define DxF0x60_NonFatalErr_WIDTH                               1
#define DxF0x60_NonFatalErr_MASK                                0x20000
#define DxF0x60_FatalErr_OFFSET                                 18
#define DxF0x60_FatalErr_WIDTH                                  1
#define DxF0x60_FatalErr_MASK                                   0x40000
#define DxF0x60_UsrDetected_OFFSET                              19
#define DxF0x60_UsrDetected_WIDTH                               1
#define DxF0x60_UsrDetected_MASK                                0x80000
#define DxF0x60_AuxPwr_OFFSET                                   20
#define DxF0x60_AuxPwr_WIDTH                                    1
#define DxF0x60_AuxPwr_MASK                                     0x100000
#define DxF0x60_TransactionsPending_OFFSET                      21
#define DxF0x60_TransactionsPending_WIDTH                       1
#define DxF0x60_TransactionsPending_MASK                        0x200000
#define DxF0x60_Reserved_31_22_OFFSET                           22
#define DxF0x60_Reserved_31_22_WIDTH                            10
#define DxF0x60_Reserved_31_22_MASK                             0xffc00000

/// DxF0x60
typedef union {
  struct {                                                              ///<
    UINT32                                                CorrErrEn:1 ; ///<
    UINT32                                            NonFatalErrEn:1 ; ///<
    UINT32                                               FatalErrEn:1 ; ///<
    UINT32                                              UsrReportEn:1 ; ///<
    UINT32                                             RelaxedOrdEn:1 ; ///<
    UINT32                                           MaxPayloadSize:3 ; ///<
    UINT32                                            ExtendedTagEn:1 ; ///<
    UINT32                                            PhantomFuncEn:1 ; ///<
    UINT32                                             AuxPowerPmEn:1 ; ///<
    UINT32                                            NoSnoopEnable:1 ; ///<
    UINT32                                           MaxRequestSize:3 ; ///<
    UINT32                                         BridgeCfgRetryEn:1 ; ///<
    UINT32                                                  CorrErr:1 ; ///<
    UINT32                                              NonFatalErr:1 ; ///<
    UINT32                                                 FatalErr:1 ; ///<
    UINT32                                              UsrDetected:1 ; ///<
    UINT32                                                   AuxPwr:1 ; ///<
    UINT32                                      TransactionsPending:1 ; ///<
    UINT32                                           Reserved_31_22:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x60_STRUCT;

// **** DxF0x64 Register Definition ****
// Address
#define DxF0x64_ADDRESS                                         0x64

// Type
#define DxF0x64_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x64_LinkSpeed_OFFSET                                0
#define DxF0x64_LinkSpeed_WIDTH                                 4
#define DxF0x64_LinkSpeed_MASK                                  0xf
#define DxF0x64_LinkWidth_OFFSET                                4
#define DxF0x64_LinkWidth_WIDTH                                 6
#define DxF0x64_LinkWidth_MASK                                  0x3f0
#define DxF0x64_PMSupport_OFFSET                                10
#define DxF0x64_PMSupport_WIDTH                                 2
#define DxF0x64_PMSupport_MASK                                  0xc00
#define DxF0x64_L0sExitLatency_OFFSET                           12
#define DxF0x64_L0sExitLatency_WIDTH                            3
#define DxF0x64_L0sExitLatency_MASK                             0x7000
#define DxF0x64_L1ExitLatency_OFFSET                            15
#define DxF0x64_L1ExitLatency_WIDTH                             3
#define DxF0x64_L1ExitLatency_MASK                              0x38000
#define DxF0x64_ClockPowerManagement_OFFSET                     18
#define DxF0x64_ClockPowerManagement_WIDTH                      1
#define DxF0x64_ClockPowerManagement_MASK                       0x40000
#define DxF0x64_SurpriseDownErrReporting_OFFSET                 19
#define DxF0x64_SurpriseDownErrReporting_WIDTH                  1
#define DxF0x64_SurpriseDownErrReporting_MASK                   0x80000
#define DxF0x64_DlActiveReportingCapable_OFFSET                 20
#define DxF0x64_DlActiveReportingCapable_WIDTH                  1
#define DxF0x64_DlActiveReportingCapable_MASK                   0x100000
#define DxF0x64_LinkBWNotificationCap_OFFSET                    21
#define DxF0x64_LinkBWNotificationCap_WIDTH                     1
#define DxF0x64_LinkBWNotificationCap_MASK                      0x200000
#define DxF0x64_AspmOptionalityCompliance_OFFSET                22
#define DxF0x64_AspmOptionalityCompliance_WIDTH                 1
#define DxF0x64_AspmOptionalityCompliance_MASK                  0x400000
#define DxF0x64_Reserved_23_23_OFFSET                           23
#define DxF0x64_Reserved_23_23_WIDTH                            1
#define DxF0x64_Reserved_23_23_MASK                             0x800000
#define DxF0x64_PortNumber_OFFSET                               24
#define DxF0x64_PortNumber_WIDTH                                8
#define DxF0x64_PortNumber_MASK                                 0xff000000

/// DxF0x64
typedef union {
  struct {                                                              ///<
    UINT32                                                LinkSpeed:4 ; ///<
    UINT32                                                LinkWidth:6 ; ///<
    UINT32                                                PMSupport:2 ; ///<
    UINT32                                           L0sExitLatency:3 ; ///<
    UINT32                                            L1ExitLatency:3 ; ///<
    UINT32                                     ClockPowerManagement:1 ; ///<
    UINT32                                 SurpriseDownErrReporting:1 ; ///<
    UINT32                                 DlActiveReportingCapable:1 ; ///<
    UINT32                                    LinkBWNotificationCap:1 ; ///<
    UINT32                                AspmOptionalityCompliance:1 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                               PortNumber:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x64_STRUCT;

// **** DxF0x68 Register Definition ****
// Address
#define DxF0x68_ADDRESS                                         0x68

// Type
#define DxF0x68_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x68_PmControl_OFFSET                                0
#define DxF0x68_PmControl_WIDTH                                 2
#define DxF0x68_PmControl_MASK                                  0x3
#define DxF0x68_Reserved_2_2_OFFSET                             2
#define DxF0x68_Reserved_2_2_WIDTH                              1
#define DxF0x68_Reserved_2_2_MASK                               0x4
#define DxF0x68_ReadCplBoundary_OFFSET                          3
#define DxF0x68_ReadCplBoundary_WIDTH                           1
#define DxF0x68_ReadCplBoundary_MASK                            0x8
#define DxF0x68_LinkDis_OFFSET                                  4
#define DxF0x68_LinkDis_WIDTH                                   1
#define DxF0x68_LinkDis_MASK                                    0x10
#define DxF0x68_RetrainLink_OFFSET                              5
#define DxF0x68_RetrainLink_WIDTH                               1
#define DxF0x68_RetrainLink_MASK                                0x20
#define DxF0x68_CommonClockCfg_OFFSET                           6
#define DxF0x68_CommonClockCfg_WIDTH                            1
#define DxF0x68_CommonClockCfg_MASK                             0x40
#define DxF0x68_ExtendedSync_OFFSET                             7
#define DxF0x68_ExtendedSync_WIDTH                              1
#define DxF0x68_ExtendedSync_MASK                               0x80
#define DxF0x68_ClockPowerManagementEn_OFFSET                   8
#define DxF0x68_ClockPowerManagementEn_WIDTH                    1
#define DxF0x68_ClockPowerManagementEn_MASK                     0x100
#define DxF0x68_HWAutonomousWidthDisable_OFFSET                 9
#define DxF0x68_HWAutonomousWidthDisable_WIDTH                  1
#define DxF0x68_HWAutonomousWidthDisable_MASK                   0x200
#define DxF0x68_LinkBWManagementEn_OFFSET                       10
#define DxF0x68_LinkBWManagementEn_WIDTH                        1
#define DxF0x68_LinkBWManagementEn_MASK                         0x400
#define DxF0x68_LinkAutonomousBWIntEn_OFFSET                    11
#define DxF0x68_LinkAutonomousBWIntEn_WIDTH                     1
#define DxF0x68_LinkAutonomousBWIntEn_MASK                      0x800
#define DxF0x68_Reserved_15_12_OFFSET                           12
#define DxF0x68_Reserved_15_12_WIDTH                            4
#define DxF0x68_Reserved_15_12_MASK                             0xf000
#define DxF0x68_LinkSpeed_OFFSET                                16
#define DxF0x68_LinkSpeed_WIDTH                                 4
#define DxF0x68_LinkSpeed_MASK                                  0xf0000
#define DxF0x68_NegotiatedLinkWidth_OFFSET                      20
#define DxF0x68_NegotiatedLinkWidth_WIDTH                       6
#define DxF0x68_NegotiatedLinkWidth_MASK                        0x3f00000
#define DxF0x68_Reserved_26_26_OFFSET                           26
#define DxF0x68_Reserved_26_26_WIDTH                            1
#define DxF0x68_Reserved_26_26_MASK                             0x4000000
#define DxF0x68_LinkTraining_OFFSET                             27
#define DxF0x68_LinkTraining_WIDTH                              1
#define DxF0x68_LinkTraining_MASK                               0x8000000
#define DxF0x68_SlotClockCfg_OFFSET                             28
#define DxF0x68_SlotClockCfg_WIDTH                              1
#define DxF0x68_SlotClockCfg_MASK                               0x10000000
#define DxF0x68_DlActive_OFFSET                                 29
#define DxF0x68_DlActive_WIDTH                                  1
#define DxF0x68_DlActive_MASK                                   0x20000000
#define DxF0x68_LinkBWManagementStatus_OFFSET                   30
#define DxF0x68_LinkBWManagementStatus_WIDTH                    1
#define DxF0x68_LinkBWManagementStatus_MASK                     0x40000000
#define DxF0x68_LinkAutonomousBWStatus_OFFSET                   31
#define DxF0x68_LinkAutonomousBWStatus_WIDTH                    1
#define DxF0x68_LinkAutonomousBWStatus_MASK                     0x80000000

/// DxF0x68
typedef union {
  struct {                                                              ///<
    UINT32                                                PmControl:2 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                          ReadCplBoundary:1 ; ///<
    UINT32                                                  LinkDis:1 ; ///<
    UINT32                                              RetrainLink:1 ; ///<
    UINT32                                           CommonClockCfg:1 ; ///<
    UINT32                                             ExtendedSync:1 ; ///<
    UINT32                                   ClockPowerManagementEn:1 ; ///<
    UINT32                                 HWAutonomousWidthDisable:1 ; ///<
    UINT32                                       LinkBWManagementEn:1 ; ///<
    UINT32                                    LinkAutonomousBWIntEn:1 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                LinkSpeed:4 ; ///<
    UINT32                                      NegotiatedLinkWidth:6 ; ///<
    UINT32                                           Reserved_26_26:1 ; ///<
    UINT32                                             LinkTraining:1 ; ///<
    UINT32                                             SlotClockCfg:1 ; ///<
    UINT32                                                 DlActive:1 ; ///<
    UINT32                                   LinkBWManagementStatus:1 ; ///<
    UINT32                                   LinkAutonomousBWStatus:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x68_STRUCT;

// **** DxF0x6C Register Definition ****
// Address
#define DxF0x6C_ADDRESS                                         0x6c

// Type
#define DxF0x6C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x6C_AttnButtonPresent_OFFSET                        0
#define DxF0x6C_AttnButtonPresent_WIDTH                         1
#define DxF0x6C_AttnButtonPresent_MASK                          0x1
#define DxF0x6C_PwrControllerPresent_OFFSET                     1
#define DxF0x6C_PwrControllerPresent_WIDTH                      1
#define DxF0x6C_PwrControllerPresent_MASK                       0x2
#define DxF0x6C_MrlSensorPresent_OFFSET                         2
#define DxF0x6C_MrlSensorPresent_WIDTH                          1
#define DxF0x6C_MrlSensorPresent_MASK                           0x4
#define DxF0x6C_AttnIndicatorPresent_OFFSET                     3
#define DxF0x6C_AttnIndicatorPresent_WIDTH                      1
#define DxF0x6C_AttnIndicatorPresent_MASK                       0x8
#define DxF0x6C_PwrIndicatorPresent_OFFSET                      4
#define DxF0x6C_PwrIndicatorPresent_WIDTH                       1
#define DxF0x6C_PwrIndicatorPresent_MASK                        0x10
#define DxF0x6C_HotplugSurprise_OFFSET                          5
#define DxF0x6C_HotplugSurprise_WIDTH                           1
#define DxF0x6C_HotplugSurprise_MASK                            0x20
#define DxF0x6C_HotplugCapable_OFFSET                           6
#define DxF0x6C_HotplugCapable_WIDTH                            1
#define DxF0x6C_HotplugCapable_MASK                             0x40
#define DxF0x6C_SlotPwrLimitValue_OFFSET                        7
#define DxF0x6C_SlotPwrLimitValue_WIDTH                         8
#define DxF0x6C_SlotPwrLimitValue_MASK                          0x7f80
#define DxF0x6C_SlotPwrLimitScale_OFFSET                        15
#define DxF0x6C_SlotPwrLimitScale_WIDTH                         2
#define DxF0x6C_SlotPwrLimitScale_MASK                          0x18000
#define DxF0x6C_ElecMechIlPresent_OFFSET                        17
#define DxF0x6C_ElecMechIlPresent_WIDTH                         1
#define DxF0x6C_ElecMechIlPresent_MASK                          0x20000
#define DxF0x6C_NoCmdCplSupport_OFFSET                          18
#define DxF0x6C_NoCmdCplSupport_WIDTH                           1
#define DxF0x6C_NoCmdCplSupport_MASK                            0x40000
#define DxF0x6C_PhysicalSlotNumber_OFFSET                       19
#define DxF0x6C_PhysicalSlotNumber_WIDTH                        13
#define DxF0x6C_PhysicalSlotNumber_MASK                         0xfff80000

/// DxF0x6C
typedef union {
  struct {                                                              ///<
    UINT32                                        AttnButtonPresent:1 ; ///<
    UINT32                                     PwrControllerPresent:1 ; ///<
    UINT32                                         MrlSensorPresent:1 ; ///<
    UINT32                                     AttnIndicatorPresent:1 ; ///<
    UINT32                                      PwrIndicatorPresent:1 ; ///<
    UINT32                                          HotplugSurprise:1 ; ///<
    UINT32                                           HotplugCapable:1 ; ///<
    UINT32                                        SlotPwrLimitValue:8 ; ///<
    UINT32                                        SlotPwrLimitScale:2 ; ///<
    UINT32                                        ElecMechIlPresent:1 ; ///<
    UINT32                                          NoCmdCplSupport:1 ; ///<
    UINT32                                       PhysicalSlotNumber:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x6C_STRUCT;

// **** DxF0x70 Register Definition ****
// Address
#define DxF0x70_ADDRESS                                         0x70

// Type
#define DxF0x70_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x70_AttnButtonPressedEn_OFFSET                      0
#define DxF0x70_AttnButtonPressedEn_WIDTH                       1
#define DxF0x70_AttnButtonPressedEn_MASK                        0x1
#define DxF0x70_PwrFaultDetectedEn_OFFSET                       1
#define DxF0x70_PwrFaultDetectedEn_WIDTH                        1
#define DxF0x70_PwrFaultDetectedEn_MASK                         0x2
#define DxF0x70_MrlSensorChangedEn_OFFSET                       2
#define DxF0x70_MrlSensorChangedEn_WIDTH                        1
#define DxF0x70_MrlSensorChangedEn_MASK                         0x4
#define DxF0x70_PresenceDetectChangedEn_OFFSET                  3
#define DxF0x70_PresenceDetectChangedEn_WIDTH                   1
#define DxF0x70_PresenceDetectChangedEn_MASK                    0x8
#define DxF0x70_CmdCplIntrEn_OFFSET                             4
#define DxF0x70_CmdCplIntrEn_WIDTH                              1
#define DxF0x70_CmdCplIntrEn_MASK                               0x10
#define DxF0x70_HotplugIntrEn_OFFSET                            5
#define DxF0x70_HotplugIntrEn_WIDTH                             1
#define DxF0x70_HotplugIntrEn_MASK                              0x20
#define DxF0x70_AttnIndicatorControl_OFFSET                     6
#define DxF0x70_AttnIndicatorControl_WIDTH                      2
#define DxF0x70_AttnIndicatorControl_MASK                       0xc0
#define DxF0x70_PwrIndicatorCntl_OFFSET                         8
#define DxF0x70_PwrIndicatorCntl_WIDTH                          2
#define DxF0x70_PwrIndicatorCntl_MASK                           0x300
#define DxF0x70_PwrControllerCntl_OFFSET                        10
#define DxF0x70_PwrControllerCntl_WIDTH                         1
#define DxF0x70_PwrControllerCntl_MASK                          0x400
#define DxF0x70_ElecMechIlCntl_OFFSET                           11
#define DxF0x70_ElecMechIlCntl_WIDTH                            1
#define DxF0x70_ElecMechIlCntl_MASK                             0x800
#define DxF0x70_DlStateChangedEn_OFFSET                         12
#define DxF0x70_DlStateChangedEn_WIDTH                          1
#define DxF0x70_DlStateChangedEn_MASK                           0x1000
#define DxF0x70_Reserved_15_13_OFFSET                           13
#define DxF0x70_Reserved_15_13_WIDTH                            3
#define DxF0x70_Reserved_15_13_MASK                             0xe000
#define DxF0x70_AttnButtonPressed_OFFSET                        16
#define DxF0x70_AttnButtonPressed_WIDTH                         1
#define DxF0x70_AttnButtonPressed_MASK                          0x10000
#define DxF0x70_PwrFaultDetected_OFFSET                         17
#define DxF0x70_PwrFaultDetected_WIDTH                          1
#define DxF0x70_PwrFaultDetected_MASK                           0x20000
#define DxF0x70_MrlSensorChanged_OFFSET                         18
#define DxF0x70_MrlSensorChanged_WIDTH                          1
#define DxF0x70_MrlSensorChanged_MASK                           0x40000
#define DxF0x70_PresenceDetectChanged_OFFSET                    19
#define DxF0x70_PresenceDetectChanged_WIDTH                     1
#define DxF0x70_PresenceDetectChanged_MASK                      0x80000
#define DxF0x70_CmdCpl_OFFSET                                   20
#define DxF0x70_CmdCpl_WIDTH                                    1
#define DxF0x70_CmdCpl_MASK                                     0x100000
#define DxF0x70_MrlSensorState_OFFSET                           21
#define DxF0x70_MrlSensorState_WIDTH                            1
#define DxF0x70_MrlSensorState_MASK                             0x200000
#define DxF0x70_PresenceDetectState_OFFSET                      22
#define DxF0x70_PresenceDetectState_WIDTH                       1
#define DxF0x70_PresenceDetectState_MASK                        0x400000
#define DxF0x70_ElecMechIlSts_OFFSET                            23
#define DxF0x70_ElecMechIlSts_WIDTH                             1
#define DxF0x70_ElecMechIlSts_MASK                              0x800000
#define DxF0x70_DlStateChanged_OFFSET                           24
#define DxF0x70_DlStateChanged_WIDTH                            1
#define DxF0x70_DlStateChanged_MASK                             0x1000000
#define DxF0x70_Reserved_31_25_OFFSET                           25
#define DxF0x70_Reserved_31_25_WIDTH                            7
#define DxF0x70_Reserved_31_25_MASK                             0xfe000000

/// DxF0x70
typedef union {
  struct {                                                              ///<
    UINT32                                      AttnButtonPressedEn:1 ; ///<
    UINT32                                       PwrFaultDetectedEn:1 ; ///<
    UINT32                                       MrlSensorChangedEn:1 ; ///<
    UINT32                                  PresenceDetectChangedEn:1 ; ///<
    UINT32                                             CmdCplIntrEn:1 ; ///<
    UINT32                                            HotplugIntrEn:1 ; ///<
    UINT32                                     AttnIndicatorControl:2 ; ///<
    UINT32                                         PwrIndicatorCntl:2 ; ///<
    UINT32                                        PwrControllerCntl:1 ; ///<
    UINT32                                           ElecMechIlCntl:1 ; ///<
    UINT32                                         DlStateChangedEn:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                        AttnButtonPressed:1 ; ///<
    UINT32                                         PwrFaultDetected:1 ; ///<
    UINT32                                         MrlSensorChanged:1 ; ///<
    UINT32                                    PresenceDetectChanged:1 ; ///<
    UINT32                                                   CmdCpl:1 ; ///<
    UINT32                                           MrlSensorState:1 ; ///<
    UINT32                                      PresenceDetectState:1 ; ///<
    UINT32                                            ElecMechIlSts:1 ; ///<
    UINT32                                           DlStateChanged:1 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x70_STRUCT;

// **** DxF0x74 Register Definition ****
// Address
#define DxF0x74_ADDRESS                                         0x74

// Type
#define DxF0x74_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x74_SerrOnCorrErrEn_OFFSET                          0
#define DxF0x74_SerrOnCorrErrEn_WIDTH                           1
#define DxF0x74_SerrOnCorrErrEn_MASK                            0x1
#define DxF0x74_SerrOnNonFatalErrEn_OFFSET                      1
#define DxF0x74_SerrOnNonFatalErrEn_WIDTH                       1
#define DxF0x74_SerrOnNonFatalErrEn_MASK                        0x2
#define DxF0x74_SerrOnFatalErrEn_OFFSET                         2
#define DxF0x74_SerrOnFatalErrEn_WIDTH                          1
#define DxF0x74_SerrOnFatalErrEn_MASK                           0x4
#define DxF0x74_PmIntEn_OFFSET                                  3
#define DxF0x74_PmIntEn_WIDTH                                   1
#define DxF0x74_PmIntEn_MASK                                    0x8
#define DxF0x74_CrsSoftVisibilityEn_OFFSET                      4
#define DxF0x74_CrsSoftVisibilityEn_WIDTH                       1
#define DxF0x74_CrsSoftVisibilityEn_MASK                        0x10
#define DxF0x74_Reserved_15_5_OFFSET                            5
#define DxF0x74_Reserved_15_5_WIDTH                             11
#define DxF0x74_Reserved_15_5_MASK                              0xffe0
#define DxF0x74_CrsSoftVisibility_OFFSET                        16
#define DxF0x74_CrsSoftVisibility_WIDTH                         1
#define DxF0x74_CrsSoftVisibility_MASK                          0x10000
#define DxF0x74_Reserved_31_17_OFFSET                           17
#define DxF0x74_Reserved_31_17_WIDTH                            15
#define DxF0x74_Reserved_31_17_MASK                             0xfffe0000

/// DxF0x74
typedef union {
  struct {                                                              ///<
    UINT32                                          SerrOnCorrErrEn:1 ; ///<
    UINT32                                      SerrOnNonFatalErrEn:1 ; ///<
    UINT32                                         SerrOnFatalErrEn:1 ; ///<
    UINT32                                                  PmIntEn:1 ; ///<
    UINT32                                      CrsSoftVisibilityEn:1 ; ///<
    UINT32                                            Reserved_15_5:11; ///<
    UINT32                                        CrsSoftVisibility:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x74_STRUCT;

// **** DxF0x78 Register Definition ****
// Address
#define DxF0x78_ADDRESS                                         0x78

// Type
#define DxF0x78_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x78_PmeRequestorId_OFFSET                           0
#define DxF0x78_PmeRequestorId_WIDTH                            16
#define DxF0x78_PmeRequestorId_MASK                             0xffff
#define DxF0x78_PmeStatus_OFFSET                                16
#define DxF0x78_PmeStatus_WIDTH                                 1
#define DxF0x78_PmeStatus_MASK                                  0x10000
#define DxF0x78_PmePending_OFFSET                               17
#define DxF0x78_PmePending_WIDTH                                1
#define DxF0x78_PmePending_MASK                                 0x20000
#define DxF0x78_Reserved_31_18_OFFSET                           18
#define DxF0x78_Reserved_31_18_WIDTH                            14
#define DxF0x78_Reserved_31_18_MASK                             0xfffc0000

/// DxF0x78
typedef union {
  struct {                                                              ///<
    UINT32                                           PmeRequestorId:16; ///<
    UINT32                                                PmeStatus:1 ; ///<
    UINT32                                               PmePending:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x78_STRUCT;

// **** DxF0x7C Register Definition ****
// Address
#define DxF0x7C_ADDRESS                                         0x7c

// Type
#define DxF0x7C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x7C_CplTimeoutRangeSup_OFFSET                       0
#define DxF0x7C_CplTimeoutRangeSup_WIDTH                        4
#define DxF0x7C_CplTimeoutRangeSup_MASK                         0xf
#define DxF0x7C_CplTimeoutDisSup_OFFSET                         4
#define DxF0x7C_CplTimeoutDisSup_WIDTH                          1
#define DxF0x7C_CplTimeoutDisSup_MASK                           0x10
#define DxF0x7C_AriForwardingSupported_OFFSET                   5
#define DxF0x7C_AriForwardingSupported_WIDTH                    1
#define DxF0x7C_AriForwardingSupported_MASK                     0x20
#define DxF0x7C_Reserved_31_6_OFFSET                            6
#define DxF0x7C_Reserved_31_6_WIDTH                             26
#define DxF0x7C_Reserved_31_6_MASK                              0xffffffc0

/// DxF0x7C
typedef union {
  struct {                                                              ///<
    UINT32                                       CplTimeoutRangeSup:4 ; ///<
    UINT32                                         CplTimeoutDisSup:1 ; ///<
    UINT32                                   AriForwardingSupported:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x7C_STRUCT;

// **** DxF0x80 Register Definition ****
// Address
#define DxF0x80_ADDRESS                                         0x80

// Type
#define DxF0x80_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x80_CplTimeoutValue_OFFSET                          0
#define DxF0x80_CplTimeoutValue_WIDTH                           4
#define DxF0x80_CplTimeoutValue_MASK                            0xf
#define DxF0x80_CplTimeoutDis_OFFSET                            4
#define DxF0x80_CplTimeoutDis_WIDTH                             1
#define DxF0x80_CplTimeoutDis_MASK                              0x10
#define DxF0x80_AriForwardingEn_OFFSET                          5
#define DxF0x80_AriForwardingEn_WIDTH                           1
#define DxF0x80_AriForwardingEn_MASK                            0x20
#define DxF0x80_Reserved_31_6_OFFSET                            6
#define DxF0x80_Reserved_31_6_WIDTH                             26
#define DxF0x80_Reserved_31_6_MASK                              0xffffffc0

/// DxF0x80
typedef union {
  struct {                                                              ///<
    UINT32                                          CplTimeoutValue:4 ; ///<
    UINT32                                            CplTimeoutDis:1 ; ///<
    UINT32                                          AriForwardingEn:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x80_STRUCT;

// **** DxF0x84 Register Definition ****
// Address
#define DxF0x84_ADDRESS                                         0x84

// Type
#define DxF0x84_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x84_Reserved_31_0_OFFSET                            0
#define DxF0x84_Reserved_31_0_WIDTH                             32
#define DxF0x84_Reserved_31_0_MASK                              0xffffffff

/// DxF0x84
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x84_STRUCT;

// **** DxF0x88 Register Definition ****
// Address
#define DxF0x88_ADDRESS                                         0x88

// Type
#define DxF0x88_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x88_TargetLinkSpeed_OFFSET                          0
#define DxF0x88_TargetLinkSpeed_WIDTH                           4
#define DxF0x88_TargetLinkSpeed_MASK                            0xf
#define DxF0x88_EnterCompliance_OFFSET                          4
#define DxF0x88_EnterCompliance_WIDTH                           1
#define DxF0x88_EnterCompliance_MASK                            0x10
#define DxF0x88_HwAutonomousSpeedDisable_OFFSET                 5
#define DxF0x88_HwAutonomousSpeedDisable_WIDTH                  1
#define DxF0x88_HwAutonomousSpeedDisable_MASK                   0x20
#define DxF0x88_SelectableDeemphasis_OFFSET                     6
#define DxF0x88_SelectableDeemphasis_WIDTH                      1
#define DxF0x88_SelectableDeemphasis_MASK                       0x40
#define DxF0x88_XmitMargin_OFFSET                               7
#define DxF0x88_XmitMargin_WIDTH                                3
#define DxF0x88_XmitMargin_MASK                                 0x380
#define DxF0x88_EnterModCompliance_OFFSET                       10
#define DxF0x88_EnterModCompliance_WIDTH                        1
#define DxF0x88_EnterModCompliance_MASK                         0x400
#define DxF0x88_ComplianceSOS_OFFSET                            11
#define DxF0x88_ComplianceSOS_WIDTH                             1
#define DxF0x88_ComplianceSOS_MASK                              0x800
#define DxF0x88_ComplianceDeemphasis_OFFSET                     12
#define DxF0x88_ComplianceDeemphasis_WIDTH                      1
#define DxF0x88_ComplianceDeemphasis_MASK                       0x1000
#define DxF0x88_Reserved_15_13_OFFSET                           13
#define DxF0x88_Reserved_15_13_WIDTH                            3
#define DxF0x88_Reserved_15_13_MASK                             0xe000
#define DxF0x88_CurDeemphasisLevel_OFFSET                       16
#define DxF0x88_CurDeemphasisLevel_WIDTH                        1
#define DxF0x88_CurDeemphasisLevel_MASK                         0x10000
#define DxF0x88_Reserved_31_17_OFFSET                           17
#define DxF0x88_Reserved_31_17_WIDTH                            15
#define DxF0x88_Reserved_31_17_MASK                             0xfffe0000

/// DxF0x88
typedef union {
  struct {                                                              ///<
    UINT32                                          TargetLinkSpeed:4 ; ///<
    UINT32                                          EnterCompliance:1 ; ///<
    UINT32                                 HwAutonomousSpeedDisable:1 ; ///<
    UINT32                                     SelectableDeemphasis:1 ; ///<
    UINT32                                               XmitMargin:3 ; ///<
    UINT32                                       EnterModCompliance:1 ; ///<
    UINT32                                            ComplianceSOS:1 ; ///<
    UINT32                                     ComplianceDeemphasis:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                       CurDeemphasisLevel:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x88_STRUCT;

// **** DxF0x8C Register Definition ****
// Address
#define DxF0x8C_ADDRESS                                         0x8c

// Type
#define DxF0x8C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x8C_Reserved_31_0_OFFSET                            0
#define DxF0x8C_Reserved_31_0_WIDTH                             32
#define DxF0x8C_Reserved_31_0_MASK                              0xffffffff

/// DxF0x8C
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x8C_STRUCT;

// **** DxF0x90 Register Definition ****
// Address
#define DxF0x90_ADDRESS                                         0x90

// Type
#define DxF0x90_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x90_Reserved_31_0_OFFSET                            0
#define DxF0x90_Reserved_31_0_WIDTH                             32
#define DxF0x90_Reserved_31_0_MASK                              0xffffffff

/// DxF0x90
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x90_STRUCT;

// **** DxF0x128 Register Definition ****
// Address
#define DxF0x128_ADDRESS                                        0x128

// Type
#define DxF0x128_TYPE                                           TYPE_D4F0
// Field Data
#define DxF0x128_Reserved_15_0_OFFSET                           0
#define DxF0x128_Reserved_15_0_WIDTH                            16
#define DxF0x128_Reserved_15_0_MASK                             0xffff
#define DxF0x128_PortArbTableStatus_OFFSET                      16
#define DxF0x128_PortArbTableStatus_WIDTH                       1
#define DxF0x128_PortArbTableStatus_MASK                        0x10000
#define DxF0x128_VcNegotiationPending_OFFSET                    17
#define DxF0x128_VcNegotiationPending_WIDTH                     1
#define DxF0x128_VcNegotiationPending_MASK                      0x20000
#define DxF0x128_Reserved_31_18_OFFSET                          18
#define DxF0x128_Reserved_31_18_WIDTH                           14
#define DxF0x128_Reserved_31_18_MASK                            0xfffc0000

/// DxF0x128
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                       PortArbTableStatus:1 ; ///<
    UINT32                                     VcNegotiationPending:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x128_STRUCT;

// **** D0F0x64_x00 Register Definition ****
// Address
#define D0F0x64_x00_ADDRESS                                     0x0

// Type
#define D0F0x64_x00_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x00_Reserved_5_0_OFFSET                         0
#define D0F0x64_x00_Reserved_5_0_WIDTH                          6
#define D0F0x64_x00_Reserved_5_0_MASK                           0x3f
#define D0F0x64_x00_NbFchCfgEn_OFFSET                           6
#define D0F0x64_x00_NbFchCfgEn_WIDTH                            1
#define D0F0x64_x00_NbFchCfgEn_MASK                             0x40
#define D0F0x64_x00_HwInitWrLock_OFFSET                         7
#define D0F0x64_x00_HwInitWrLock_WIDTH                          1
#define D0F0x64_x00_HwInitWrLock_MASK                           0x80
#define D0F0x64_x00_Reserved_31_8_OFFSET                        8
#define D0F0x64_x00_Reserved_31_8_WIDTH                         24
#define D0F0x64_x00_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x00
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_5_0:6 ; ///<
    UINT32                                               NbFchCfgEn:1 ; ///<
    UINT32                                             HwInitWrLock:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x00_STRUCT;

// **** D0F0x64_x0B Register Definition ****
// Address
#define D0F0x64_x0B_ADDRESS                                     0xb

// Type
#define D0F0x64_x0B_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x0B_Reserved_19_0_OFFSET                        0
#define D0F0x64_x0B_Reserved_19_0_WIDTH                         20
#define D0F0x64_x0B_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x0B_SetPowEn_OFFSET                             20
#define D0F0x64_x0B_SetPowEn_WIDTH                              1
#define D0F0x64_x0B_SetPowEn_MASK                               0x100000
#define D0F0x64_x0B_IocFchSetPowEn_OFFSET                       21
#define D0F0x64_x0B_IocFchSetPowEn_WIDTH                        1
#define D0F0x64_x0B_IocFchSetPowEn_MASK                         0x200000
#define D0F0x64_x0B_Reserved_22_22_OFFSET                       22
#define D0F0x64_x0B_Reserved_22_22_WIDTH                        1
#define D0F0x64_x0B_Reserved_22_22_MASK                         0x400000
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_OFFSET                23
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_WIDTH                 1
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_MASK                  0x800000
#define D0F0x64_x0B_Reserved_31_24_OFFSET                       24
#define D0F0x64_x0B_Reserved_31_24_WIDTH                        8
#define D0F0x64_x0B_Reserved_31_24_MASK                         0xff000000

/// D0F0x64_x0B
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           IocFchSetPowEn:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                    IocFchSetPmeTurnOffEn:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x0B_STRUCT;

// **** D0F0x64_x0C Register Definition ****
// Address
#define D0F0x64_x0C_ADDRESS                                     0xc

// Type
#define D0F0x64_x0C_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x0C_Reserved_1_0_OFFSET                         0
#define D0F0x64_x0C_Reserved_1_0_WIDTH                          2
#define D0F0x64_x0C_Reserved_1_0_MASK                           0x3
#define D0F0x64_x0C_Dev2BridgeDis_OFFSET                        2
#define D0F0x64_x0C_Dev2BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev2BridgeDis_MASK                          0x4
#define D0F0x64_x0C_Dev3BridgeDis_OFFSET                        3
#define D0F0x64_x0C_Dev3BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev3BridgeDis_MASK                          0x8
#define D0F0x64_x0C_Dev4BridgeDis_OFFSET                        4
#define D0F0x64_x0C_Dev4BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev4BridgeDis_MASK                          0x10
#define D0F0x64_x0C_Dev5BridgeDis_OFFSET                        5
#define D0F0x64_x0C_Dev5BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev5BridgeDis_MASK                          0x20
#define D0F0x64_x0C_Dev6BridgeDis_OFFSET                        6
#define D0F0x64_x0C_Dev6BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev6BridgeDis_MASK                          0x40
#define D0F0x64_x0C_Dev7BridgeDis_OFFSET                        7
#define D0F0x64_x0C_Dev7BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev7BridgeDis_MASK                          0x80
#define D0F0x64_x0C_Reserved_31_8_OFFSET                        8
#define D0F0x64_x0C_Reserved_31_8_WIDTH                         24
#define D0F0x64_x0C_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x0C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            Dev2BridgeDis:1 ; ///<
    UINT32                                            Dev3BridgeDis:1 ; ///<
    UINT32                                            Dev4BridgeDis:1 ; ///<
    UINT32                                            Dev5BridgeDis:1 ; ///<
    UINT32                                            Dev6BridgeDis:1 ; ///<
    UINT32                                            Dev7BridgeDis:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x0C_STRUCT;

// **** D0F0x64_x0D Register Definition ****
// Address
#define D0F0x64_x0D_ADDRESS                                     0xd

// Type
#define D0F0x64_x0D_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x0D_PciDev0Fn2RegEn_OFFSET                      0
#define D0F0x64_x0D_PciDev0Fn2RegEn_WIDTH                       1
#define D0F0x64_x0D_PciDev0Fn2RegEn_MASK                        0x1
#define D0F0x64_x0D_Reserved_31_1_OFFSET                        1
#define D0F0x64_x0D_Reserved_31_1_WIDTH                         31
#define D0F0x64_x0D_Reserved_31_1_MASK                          0xfffffffe

/// D0F0x64_x0D
typedef union {
  struct {                                                              ///<
    UINT32                                          PciDev0Fn2RegEn:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x0D_STRUCT;

// **** D0F0x64_x16 Register Definition ****
// Address
#define D0F0x64_x16_ADDRESS                                     0x16

// Type
#define D0F0x64_x16_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x16_AerUrMsgEn_OFFSET                           0
#define D0F0x64_x16_AerUrMsgEn_WIDTH                            1
#define D0F0x64_x16_AerUrMsgEn_MASK                             0x1
#define D0F0x64_x16_Reserved_31_1_OFFSET                        1
#define D0F0x64_x16_Reserved_31_1_WIDTH                         31
#define D0F0x64_x16_Reserved_31_1_MASK                          0xfffffffe

/// D0F0x64_x16
typedef union {
  struct {                                                              ///<
    UINT32                                               AerUrMsgEn:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x16_STRUCT;

// **** D0F0x64_x19 Register Definition ****
// Address
#define D0F0x64_x19_ADDRESS                                     0x19

// Type
#define D0F0x64_x19_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x19_TomEn_OFFSET                                0
#define D0F0x64_x19_TomEn_WIDTH                                 1
#define D0F0x64_x19_TomEn_MASK                                  0x1
#define D0F0x64_x19_Reserved_22_1_OFFSET                        1
#define D0F0x64_x19_Reserved_22_1_WIDTH                         22
#define D0F0x64_x19_Reserved_22_1_MASK                          0x7ffffe
#define D0F0x64_x19_Tom2_31_23__OFFSET                          23
#define D0F0x64_x19_Tom2_31_23__WIDTH                           9
#define D0F0x64_x19_Tom2_31_23__MASK                            0xff800000

/// D0F0x64_x19
typedef union {
  struct {                                                              ///<
    UINT32                                                    TomEn:1 ; ///<
    UINT32                                            Reserved_22_1:22; ///<
    UINT32                                              Tom2_31_23_:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x19_STRUCT;

// **** D0F0x64_x1A Register Definition ****
// Address
#define D0F0x64_x1A_ADDRESS                                     0x1a

// Type
#define D0F0x64_x1A_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x1A_Tom2_39_32__OFFSET                          0
#define D0F0x64_x1A_Tom2_39_32__WIDTH                           8
#define D0F0x64_x1A_Tom2_39_32__MASK                            0xff
#define D0F0x64_x1A_Reserved_31_8_OFFSET                        8
#define D0F0x64_x1A_Reserved_31_8_WIDTH                         24
#define D0F0x64_x1A_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x1A
typedef union {
  struct {                                                              ///<
    UINT32                                              Tom2_39_32_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x1A_STRUCT;

// **** D0F0x64_x1C Register Definition ****
// Address
#define D0F0x64_x1C_ADDRESS                                     0x1c

// Type
#define D0F0x64_x1C_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x1C_WriteDis_OFFSET                             0
#define D0F0x64_x1C_WriteDis_WIDTH                              1
#define D0F0x64_x1C_WriteDis_MASK                               0x1
#define D0F0x64_x1C_F0NonlegacyDeviceTypeEn_OFFSET              1
#define D0F0x64_x1C_F0NonlegacyDeviceTypeEn_WIDTH               1
#define D0F0x64_x1C_F0NonlegacyDeviceTypeEn_MASK                0x2
#define D0F0x64_x1C_F064BarEn_OFFSET                            2
#define D0F0x64_x1C_F064BarEn_WIDTH                             1
#define D0F0x64_x1C_F064BarEn_MASK                              0x4
#define D0F0x64_x1C_MemApSize_OFFSET                            3
#define D0F0x64_x1C_MemApSize_WIDTH                             3
#define D0F0x64_x1C_MemApSize_MASK                              0x38
#define D0F0x64_x1C_RegApSize_OFFSET                            6
#define D0F0x64_x1C_RegApSize_WIDTH                             1
#define D0F0x64_x1C_RegApSize_MASK                              0x40
#define D0F0x64_x1C_Reserved_7_7_OFFSET                         7
#define D0F0x64_x1C_Reserved_7_7_WIDTH                          1
#define D0F0x64_x1C_Reserved_7_7_MASK                           0x80
#define D0F0x64_x1C_AudioEn_OFFSET                              8
#define D0F0x64_x1C_AudioEn_WIDTH                               1
#define D0F0x64_x1C_AudioEn_MASK                                0x100
#define D0F0x64_x1C_MsiDis_OFFSET                               9
#define D0F0x64_x1C_MsiDis_WIDTH                                1
#define D0F0x64_x1C_MsiDis_MASK                                 0x200
#define D0F0x64_x1C_AudioNonlegacyDeviceTypeEn_OFFSET           10
#define D0F0x64_x1C_AudioNonlegacyDeviceTypeEn_WIDTH            1
#define D0F0x64_x1C_AudioNonlegacyDeviceTypeEn_MASK             0x400
#define D0F0x64_x1C_Audio64BarEn_OFFSET                         11
#define D0F0x64_x1C_Audio64BarEn_WIDTH                          1
#define D0F0x64_x1C_Audio64BarEn_MASK                           0x800
#define D0F0x64_x1C_Reserved_15_12_OFFSET                       12
#define D0F0x64_x1C_Reserved_15_12_WIDTH                        4
#define D0F0x64_x1C_Reserved_15_12_MASK                         0xf000
#define D0F0x64_x1C_IoBarDis_OFFSET                             16
#define D0F0x64_x1C_IoBarDis_WIDTH                              1
#define D0F0x64_x1C_IoBarDis_MASK                               0x10000
#define D0F0x64_x1C_F0En_OFFSET                                 17
#define D0F0x64_x1C_F0En_WIDTH                                  1
#define D0F0x64_x1C_F0En_MASK                                   0x20000
#define D0F0x64_x1C_Reserved_22_18_OFFSET                       18
#define D0F0x64_x1C_Reserved_22_18_WIDTH                        5
#define D0F0x64_x1C_Reserved_22_18_MASK                         0x7c0000
#define D0F0x64_x1C_RcieEn_OFFSET                               23
#define D0F0x64_x1C_RcieEn_WIDTH                                1
#define D0F0x64_x1C_RcieEn_MASK                                 0x800000
#define D0F0x64_x1C_Reserved_31_24_OFFSET                       24
#define D0F0x64_x1C_Reserved_31_24_WIDTH                        8
#define D0F0x64_x1C_Reserved_31_24_MASK                         0xff000000

/// D0F0x64_x1C
typedef union {
  struct {                                                              ///<
    UINT32                                                 WriteDis:1 ; ///<
    UINT32                                  F0NonlegacyDeviceTypeEn:1 ; ///<
    UINT32                                                F064BarEn:1 ; ///<
    UINT32                                                MemApSize:3 ; ///<
    UINT32                                                RegApSize:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                  AudioEn:1 ; ///<
    UINT32                                                   MsiDis:1 ; ///<
    UINT32                               AudioNonlegacyDeviceTypeEn:1 ; ///<
    UINT32                                             Audio64BarEn:1 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                 IoBarDis:1 ; ///<
    UINT32                                                     F0En:1 ; ///<
    UINT32                                           Reserved_22_18:5 ; ///<
    UINT32                                                   RcieEn:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x1C_STRUCT;

// **** D0F0x64_x1D Register Definition ****
// Address
#define D0F0x64_x1D_ADDRESS                                     0x1d

// Type
#define D0F0x64_x1D_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x1D_IntGfxAsPcieEn_OFFSET                       0
#define D0F0x64_x1D_IntGfxAsPcieEn_WIDTH                        1
#define D0F0x64_x1D_IntGfxAsPcieEn_MASK                         0x1
#define D0F0x64_x1D_VgaEn_OFFSET                                1
#define D0F0x64_x1D_VgaEn_WIDTH                                 1
#define D0F0x64_x1D_VgaEn_MASK                                  0x2
#define D0F0x64_x1D_Reserved_2_2_OFFSET                         2
#define D0F0x64_x1D_Reserved_2_2_WIDTH                          1
#define D0F0x64_x1D_Reserved_2_2_MASK                           0x4
#define D0F0x64_x1D_Vga16En_OFFSET                              3
#define D0F0x64_x1D_Vga16En_WIDTH                               1
#define D0F0x64_x1D_Vga16En_MASK                                0x8
#define D0F0x64_x1D_Reserved_31_4_OFFSET                        4
#define D0F0x64_x1D_Reserved_31_4_WIDTH                         28
#define D0F0x64_x1D_Reserved_31_4_MASK                          0xfffffff0

/// D0F0x64_x1D
typedef union {
  struct {                                                              ///<
    UINT32                                           IntGfxAsPcieEn:1 ; ///<
    UINT32                                                    VgaEn:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                  Vga16En:1 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x1D_STRUCT;

// **** D0F0x64_x20 Register Definition ****
// Address
#define D0F0x64_x20_ADDRESS                                     0x20

// Type
#define D0F0x64_x20_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x20_ProgDevMapEn_OFFSET                         0
#define D0F0x64_x20_ProgDevMapEn_WIDTH                          1
#define D0F0x64_x20_ProgDevMapEn_MASK                           0x1
#define D0F0x64_x20_IocPcieDevRemapDis_OFFSET                   1
#define D0F0x64_x20_IocPcieDevRemapDis_WIDTH                    1
#define D0F0x64_x20_IocPcieDevRemapDis_MASK                     0x2
#define D0F0x64_x20_Reserved_3_2_OFFSET                         2
#define D0F0x64_x20_Reserved_3_2_WIDTH                          2
#define D0F0x64_x20_Reserved_3_2_MASK                           0xc
#define D0F0x64_x20_GppPortBDevmap_OFFSET                       4
#define D0F0x64_x20_GppPortBDevmap_WIDTH                        4
#define D0F0x64_x20_GppPortBDevmap_MASK                         0xf0
#define D0F0x64_x20_GppPortCDevmap_OFFSET                       8
#define D0F0x64_x20_GppPortCDevmap_WIDTH                        4
#define D0F0x64_x20_GppPortCDevmap_MASK                         0xf00
#define D0F0x64_x20_GppPortDDevmap_OFFSET                       12
#define D0F0x64_x20_GppPortDDevmap_WIDTH                        4
#define D0F0x64_x20_GppPortDDevmap_MASK                         0xf000
#define D0F0x64_x20_GppPortEDevmap_OFFSET                       16
#define D0F0x64_x20_GppPortEDevmap_WIDTH                        4
#define D0F0x64_x20_GppPortEDevmap_MASK                         0xf0000
#define D0F0x64_x20_Reserved_31_20_OFFSET                       20
#define D0F0x64_x20_Reserved_31_20_WIDTH                        12
#define D0F0x64_x20_Reserved_31_20_MASK                         0xfff00000

/// D0F0x64_x20
typedef union {
  struct {                                                              ///<
    UINT32                                             ProgDevMapEn:1 ; ///<
    UINT32                                       IocPcieDevRemapDis:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                           GppPortBDevmap:4 ; ///<
    UINT32                                           GppPortCDevmap:4 ; ///<
    UINT32                                           GppPortDDevmap:4 ; ///<
    UINT32                                           GppPortEDevmap:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x20_STRUCT;

// **** D0F0x64_x21 Register Definition ****
// Address
#define D0F0x64_x21_ADDRESS                                     0x21

// Type
#define D0F0x64_x21_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x21_Reserved_11_0_OFFSET                        0
#define D0F0x64_x21_Reserved_11_0_WIDTH                         12
#define D0F0x64_x21_Reserved_11_0_MASK                          0xfff
#define D0F0x64_x21_GfxPortADevmap_OFFSET                       12
#define D0F0x64_x21_GfxPortADevmap_WIDTH                        4
#define D0F0x64_x21_GfxPortADevmap_MASK                         0xf000
#define D0F0x64_x21_GfxPortBDevmap_OFFSET                       16
#define D0F0x64_x21_GfxPortBDevmap_WIDTH                        4
#define D0F0x64_x21_GfxPortBDevmap_MASK                         0xf0000
#define D0F0x64_x21_Reserved_31_20_OFFSET                       20
#define D0F0x64_x21_Reserved_31_20_WIDTH                        12
#define D0F0x64_x21_Reserved_31_20_MASK                         0xfff00000

/// D0F0x64_x21
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           GfxPortADevmap:4 ; ///<
    UINT32                                           GfxPortBDevmap:4 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x21_STRUCT;

// **** D0F0x64_x22 Register Definition ****
// Address
#define D0F0x64_x22_ADDRESS                                     0x22

// Type
#define D0F0x64_x22_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x22_Reserved_25_0_OFFSET                        0
#define D0F0x64_x22_Reserved_25_0_WIDTH                         26
#define D0F0x64_x22_Reserved_25_0_MASK                          0x3ffffff
#define D0F0x64_x22_SoftOverrideClk4_OFFSET                     26
#define D0F0x64_x22_SoftOverrideClk4_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x64_x22_SoftOverrideClk3_OFFSET                     27
#define D0F0x64_x22_SoftOverrideClk3_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x64_x22_SoftOverrideClk2_OFFSET                     28
#define D0F0x64_x22_SoftOverrideClk2_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x64_x22_SoftOverrideClk1_OFFSET                     29
#define D0F0x64_x22_SoftOverrideClk1_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x64_x22_SoftOverrideClk0_OFFSET                     30
#define D0F0x64_x22_SoftOverrideClk0_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x64_x22_Reserved_31_31_OFFSET                       31
#define D0F0x64_x22_Reserved_31_31_WIDTH                        1
#define D0F0x64_x22_Reserved_31_31_MASK                         0x80000000

/// D0F0x64_x22
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_25_0:26; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x22_STRUCT;

// **** D0F0x64_x23 Register Definition ****
// Address
#define D0F0x64_x23_ADDRESS                                     0x23

// Type
#define D0F0x64_x23_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x23_Reserved_25_0_OFFSET                        0
#define D0F0x64_x23_Reserved_25_0_WIDTH                         26
#define D0F0x64_x23_Reserved_25_0_MASK                          0x3ffffff
#define D0F0x64_x23_SoftOverrideClk4_OFFSET                     26
#define D0F0x64_x23_SoftOverrideClk4_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x64_x23_SoftOverrideClk3_OFFSET                     27
#define D0F0x64_x23_SoftOverrideClk3_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x64_x23_SoftOverrideClk2_OFFSET                     28
#define D0F0x64_x23_SoftOverrideClk2_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x64_x23_SoftOverrideClk1_OFFSET                     29
#define D0F0x64_x23_SoftOverrideClk1_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x64_x23_SoftOverrideClk0_OFFSET                     30
#define D0F0x64_x23_SoftOverrideClk0_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x64_x23_Reserved_31_31_OFFSET                       31
#define D0F0x64_x23_Reserved_31_31_WIDTH                        1
#define D0F0x64_x23_Reserved_31_31_MASK                         0x80000000

/// D0F0x64_x23
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_25_0:26; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x23_STRUCT;


// **** D0F0x64_x46 Register Definition ****
// Address
#define D0F0x64_x46_ADDRESS                                     0x46

// Type
#define D0F0x64_x46_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x46_Reserved_0_0_OFFSET                         0
#define D0F0x64_x46_Reserved_0_0_WIDTH                          1
#define D0F0x64_x46_Reserved_0_0_MASK                           0x1
#define D0F0x64_x46_Reserved_15_3_OFFSET                        3
#define D0F0x64_x46_Reserved_15_3_WIDTH                         13
#define D0F0x64_x46_Reserved_15_3_MASK                          0xfff8
#define D0F0x64_x46_Msi64bitEn_OFFSET                           16
#define D0F0x64_x46_Msi64bitEn_WIDTH                            1
#define D0F0x64_x46_Msi64bitEn_MASK                             0x10000
#define D0F0x64_x46_Reserved_31_17_OFFSET                       17
#define D0F0x64_x46_Reserved_31_17_WIDTH                        15
#define D0F0x64_x46_Reserved_31_17_MASK                         0xfffe0000

/// D0F0x64_x46
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                  :2 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                               Msi64bitEn:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x46_STRUCT;


// **** D0F0x64_x53 Register Definition ****
// Address
#define D0F0x64_x53_ADDRESS                                     0x53

// Type
#define D0F0x64_x53_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x53_Reserved_19_0_OFFSET                        0
#define D0F0x64_x53_Reserved_19_0_WIDTH                         20
#define D0F0x64_x53_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x53_SetPowEn_OFFSET                             20
#define D0F0x64_x53_SetPowEn_WIDTH                              1
#define D0F0x64_x53_SetPowEn_MASK                               0x100000
#define D0F0x64_x53_Reserved_31_21_OFFSET                       21
#define D0F0x64_x53_Reserved_31_21_WIDTH                        11
#define D0F0x64_x53_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x53
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x53_STRUCT;

// **** D0F0x64_x55 Register Definition ****
// Address
#define D0F0x64_x55_ADDRESS                                     0x55

// Type
#define D0F0x64_x55_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x55_Reserved_19_0_OFFSET                        0
#define D0F0x64_x55_Reserved_19_0_WIDTH                         20
#define D0F0x64_x55_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x55_SetPowEn_OFFSET                             20
#define D0F0x64_x55_SetPowEn_WIDTH                              1
#define D0F0x64_x55_SetPowEn_MASK                               0x100000
#define D0F0x64_x55_Reserved_31_21_OFFSET                       21
#define D0F0x64_x55_Reserved_31_21_WIDTH                        11
#define D0F0x64_x55_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x55
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x55_STRUCT;

// **** D0F0x64_x57 Register Definition ****
// Address
#define D0F0x64_x57_ADDRESS                                     0x57

// Type
#define D0F0x64_x57_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x57_Reserved_19_0_OFFSET                        0
#define D0F0x64_x57_Reserved_19_0_WIDTH                         20
#define D0F0x64_x57_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x57_SetPowEn_OFFSET                             20
#define D0F0x64_x57_SetPowEn_WIDTH                              1
#define D0F0x64_x57_SetPowEn_MASK                               0x100000
#define D0F0x64_x57_Reserved_31_21_OFFSET                       21
#define D0F0x64_x57_Reserved_31_21_WIDTH                        11
#define D0F0x64_x57_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x57
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x57_STRUCT;

// **** D0F0x64_x59 Register Definition ****
// Address
#define D0F0x64_x59_ADDRESS                                     0x59

// Type
#define D0F0x64_x59_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x59_Reserved_19_0_OFFSET                        0
#define D0F0x64_x59_Reserved_19_0_WIDTH                         20
#define D0F0x64_x59_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x59_SetPowEn_OFFSET                             20
#define D0F0x64_x59_SetPowEn_WIDTH                              1
#define D0F0x64_x59_SetPowEn_MASK                               0x100000
#define D0F0x64_x59_Reserved_31_21_OFFSET                       21
#define D0F0x64_x59_Reserved_31_21_WIDTH                        11
#define D0F0x64_x59_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x59
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x59_STRUCT;

// **** D0F0x64_x5B Register Definition ****
// Address
#define D0F0x64_x5B_ADDRESS                                     0x5b

// Type
#define D0F0x64_x5B_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x5B_Reserved_19_0_OFFSET                        0
#define D0F0x64_x5B_Reserved_19_0_WIDTH                         20
#define D0F0x64_x5B_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x5B_SetPowEn_OFFSET                             20
#define D0F0x64_x5B_SetPowEn_WIDTH                              1
#define D0F0x64_x5B_SetPowEn_MASK                               0x100000
#define D0F0x64_x5B_Reserved_31_21_OFFSET                       21
#define D0F0x64_x5B_Reserved_31_21_WIDTH                        11
#define D0F0x64_x5B_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x5B
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x5B_STRUCT;

// **** D0F0x98_x06 Register Definition ****
// Address
#define D0F0x98_x06_ADDRESS                                     0x6

// Type
#define D0F0x98_x06_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x06_Reserved_25_0_OFFSET                        0
#define D0F0x98_x06_Reserved_25_0_WIDTH                         26
#define D0F0x98_x06_Reserved_25_0_MASK                          0x3ffffff
#define D0F0x98_x06_UmiNpMemWrEn_OFFSET                         26
#define D0F0x98_x06_UmiNpMemWrEn_WIDTH                          1
#define D0F0x98_x06_UmiNpMemWrEn_MASK                           0x4000000
#define D0F0x98_x06_Reserved_31_27_OFFSET                       27
#define D0F0x98_x06_Reserved_31_27_WIDTH                        5
#define D0F0x98_x06_Reserved_31_27_MASK                         0xf8000000

/// D0F0x98_x06
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_25_0:26; ///<
    UINT32                                             UmiNpMemWrEn:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x06_STRUCT;

// **** D0F0x98_x07 Register Definition ****
// Address
#define D0F0x98_x07_ADDRESS                                     0x7

// Type
#define D0F0x98_x07_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x07_IocBwOptEn_OFFSET                           0
#define D0F0x98_x07_IocBwOptEn_WIDTH                            1
#define D0F0x98_x07_IocBwOptEn_MASK                             0x1
#define D0F0x98_x07_Reserved_3_1_OFFSET                         1
#define D0F0x98_x07_Reserved_3_1_WIDTH                          3
#define D0F0x98_x07_Reserved_3_1_MASK                           0xe
#define D0F0x98_x07_IommuBwOptEn_OFFSET                         4
#define D0F0x98_x07_IommuBwOptEn_WIDTH                          1
#define D0F0x98_x07_IommuBwOptEn_MASK                           0x10
#define D0F0x98_x07_Reserved_5_5_OFFSET                         5
#define D0F0x98_x07_Reserved_5_5_WIDTH                          1
#define D0F0x98_x07_Reserved_5_5_MASK                           0x20
#define D0F0x98_x07_DmaReqRespPassPWMode_OFFSET                 6
#define D0F0x98_x07_DmaReqRespPassPWMode_WIDTH                  1
#define D0F0x98_x07_DmaReqRespPassPWMode_MASK                   0x40
#define D0F0x98_x07_IommuIsocPassPWMode_OFFSET                  7
#define D0F0x98_x07_IommuIsocPassPWMode_WIDTH                   1
#define D0F0x98_x07_IommuIsocPassPWMode_MASK                    0x80
#define D0F0x98_x07_Reserved_13_8_OFFSET                        8
#define D0F0x98_x07_Reserved_13_8_WIDTH                         6
#define D0F0x98_x07_Reserved_13_8_MASK                          0x3f00
#define D0F0x98_x07_MSIHTIntConversionEn_OFFSET                 14
#define D0F0x98_x07_MSIHTIntConversionEn_WIDTH                  1
#define D0F0x98_x07_MSIHTIntConversionEn_MASK                   0x4000
#define D0F0x98_x07_DropZeroMaskWrEn_OFFSET                     15
#define D0F0x98_x07_DropZeroMaskWrEn_WIDTH                      1
#define D0F0x98_x07_DropZeroMaskWrEn_MASK                       0x8000
#define D0F0x98_x07_Reserved_29_16_OFFSET                       16
#define D0F0x98_x07_Reserved_29_16_WIDTH                        14
#define D0F0x98_x07_Reserved_29_16_MASK                         0x3fff0000
#define D0F0x98_x07_UnadjustThrottlingStpclk_OFFSET             30
#define D0F0x98_x07_UnadjustThrottlingStpclk_WIDTH              1
#define D0F0x98_x07_UnadjustThrottlingStpclk_MASK               0x40000000
#define D0F0x98_x07_SMUCsrIsocEn_OFFSET                         31
#define D0F0x98_x07_SMUCsrIsocEn_WIDTH                          1
#define D0F0x98_x07_SMUCsrIsocEn_MASK                           0x80000000

/// D0F0x98_x07
typedef union {
  struct {                                                              ///<
    UINT32                                               IocBwOptEn:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                             IommuBwOptEn:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                     DmaReqRespPassPWMode:1 ; ///<
    UINT32                                      IommuIsocPassPWMode:1 ; ///<
    UINT32                                            Reserved_13_8:6 ; ///<
    UINT32                                     MSIHTIntConversionEn:1 ; ///<
    UINT32                                         DropZeroMaskWrEn:1 ; ///<
    UINT32                                           Reserved_29_16:14; ///<
    UINT32                                 UnadjustThrottlingStpclk:1 ; ///<
    UINT32                                             SMUCsrIsocEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x07_STRUCT;

// **** D0F0x98_x08 Register Definition ****
// Address
#define D0F0x98_x08_ADDRESS                                     0x8

// Type
#define D0F0x98_x08_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x08_NpWrrLenA_OFFSET                            0
#define D0F0x98_x08_NpWrrLenA_WIDTH                             8
#define D0F0x98_x08_NpWrrLenA_MASK                              0xff
#define D0F0x98_x08_NpWrrLenB_OFFSET                            8
#define D0F0x98_x08_NpWrrLenB_WIDTH                             8
#define D0F0x98_x08_NpWrrLenB_MASK                              0xff00
#define D0F0x98_x08_NpWrrLenC_OFFSET                            16
#define D0F0x98_x08_NpWrrLenC_WIDTH                             8
#define D0F0x98_x08_NpWrrLenC_MASK                              0xff0000
#define D0F0x98_x08_Reserved_31_24_OFFSET                       24
#define D0F0x98_x08_Reserved_31_24_WIDTH                        8
#define D0F0x98_x08_Reserved_31_24_MASK                         0xff000000

/// D0F0x98_x08
typedef union {
  struct {                                                              ///<
    UINT32                                                NpWrrLenA:8 ; ///<
    UINT32                                                NpWrrLenB:8 ; ///<
    UINT32                                                NpWrrLenC:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x08_STRUCT;

// **** D0F0x98_x09 Register Definition ****
// Address
#define D0F0x98_x09_ADDRESS                                     0x9

// Type
#define D0F0x98_x09_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x09_PWrrLenA_OFFSET                             0
#define D0F0x98_x09_PWrrLenA_WIDTH                              8
#define D0F0x98_x09_PWrrLenA_MASK                               0xff
#define D0F0x98_x09_PWrrLenB_OFFSET                             8
#define D0F0x98_x09_PWrrLenB_WIDTH                              8
#define D0F0x98_x09_PWrrLenB_MASK                               0xff00
#define D0F0x98_x09_Reserved_31_16_OFFSET                       16
#define D0F0x98_x09_Reserved_31_16_WIDTH                        16
#define D0F0x98_x09_Reserved_31_16_MASK                         0xffff0000

/// D0F0x98_x09
typedef union {
  struct {                                                              ///<
    UINT32                                                 PWrrLenA:8 ; ///<
    UINT32                                                 PWrrLenB:8 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x09_STRUCT;

// **** D0F0x98_x0C Register Definition ****
// Address
#define D0F0x98_x0C_ADDRESS                                     0xc

// Type
#define D0F0x98_x0C_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x0C_GcmWrrLenA_OFFSET                           0
#define D0F0x98_x0C_GcmWrrLenA_WIDTH                            8
#define D0F0x98_x0C_GcmWrrLenA_MASK                             0xff
#define D0F0x98_x0C_GcmWrrLenB_OFFSET                           8
#define D0F0x98_x0C_GcmWrrLenB_WIDTH                            8
#define D0F0x98_x0C_GcmWrrLenB_MASK                             0xff00
#define D0F0x98_x0C_Reserved_29_16_OFFSET                       16
#define D0F0x98_x0C_Reserved_29_16_WIDTH                        14
#define D0F0x98_x0C_Reserved_29_16_MASK                         0x3fff0000
#define D0F0x98_x0C_StrictSelWinnerEn_OFFSET                    30
#define D0F0x98_x0C_StrictSelWinnerEn_WIDTH                     1
#define D0F0x98_x0C_StrictSelWinnerEn_MASK                      0x40000000
#define D0F0x98_x0C_Reserved_31_31_OFFSET                       31
#define D0F0x98_x0C_Reserved_31_31_WIDTH                        1
#define D0F0x98_x0C_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x0C
typedef union {
  struct {                                                              ///<
    UINT32                                               GcmWrrLenA:8 ; ///<
    UINT32                                               GcmWrrLenB:8 ; ///<
    UINT32                                           Reserved_29_16:14; ///<
    UINT32                                        StrictSelWinnerEn:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x0C_STRUCT;

// **** D0F0x98_x1E Register Definition ****
// Address
#define D0F0x98_x1E_ADDRESS                                     0x1e

// Type
#define D0F0x98_x1E_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x1E_Reserved_0_0_OFFSET                         0
#define D0F0x98_x1E_Reserved_0_0_WIDTH                          1
#define D0F0x98_x1E_Reserved_0_0_MASK                           0x1
#define D0F0x98_x1E_HiPriEn_OFFSET                              1
#define D0F0x98_x1E_HiPriEn_WIDTH                               1
#define D0F0x98_x1E_HiPriEn_MASK                                0x2
#define D0F0x98_x1E_Reserved_31_2_OFFSET                        2
#define D0F0x98_x1E_Reserved_31_2_WIDTH                         30
#define D0F0x98_x1E_Reserved_31_2_MASK                          0xfffffffc

/// D0F0x98_x1E
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                  HiPriEn:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x1E_STRUCT;

// **** D0F0x98_x26 Register Definition ****
// Address
#define D0F0x98_x26_ADDRESS                                     0x26

// Type
#define D0F0x98_x26_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x26_IOMMUUrAddr_39_32__OFFSET                   0
#define D0F0x98_x26_IOMMUUrAddr_39_32__WIDTH                    8
#define D0F0x98_x26_IOMMUUrAddr_39_32__MASK                     0xff
#define D0F0x98_x26_Reserved_31_8_OFFSET                        8
#define D0F0x98_x26_Reserved_31_8_WIDTH                         24
#define D0F0x98_x26_Reserved_31_8_MASK                          0xffffff00

/// D0F0x98_x26
typedef union {
  struct {                                                              ///<
    UINT32                                       IOMMUUrAddr_39_32_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x26_STRUCT;

// **** D0F0x98_x27 Register Definition ****
// Address
#define D0F0x98_x27_ADDRESS                                     0x27

// Type
#define D0F0x98_x27_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x27_Reserved_5_0_OFFSET                         0
#define D0F0x98_x27_Reserved_5_0_WIDTH                          6
#define D0F0x98_x27_Reserved_5_0_MASK                           0x3f
#define D0F0x98_x27_IOMMUUrAddr_31_6__OFFSET                    6
#define D0F0x98_x27_IOMMUUrAddr_31_6__WIDTH                     26
#define D0F0x98_x27_IOMMUUrAddr_31_6__MASK                      0xffffffc0

/// D0F0x98_x27
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_5_0:6 ; ///<
    UINT32                                        IOMMUUrAddr_31_6_:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x27_STRUCT;

// **** D0F0x98_x28 Register Definition ****
// Address
#define D0F0x98_x28_ADDRESS                                     0x28

// Type
#define D0F0x98_x28_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x28_Reserved_0_0_OFFSET                         0
#define D0F0x98_x28_Reserved_0_0_WIDTH                          1
#define D0F0x98_x28_Reserved_0_0_MASK                           0x1
#define D0F0x98_x28_ForceCoherentIntr_OFFSET                    1
#define D0F0x98_x28_ForceCoherentIntr_WIDTH                     1
#define D0F0x98_x28_ForceCoherentIntr_MASK                      0x2
#define D0F0x98_x28_Reserved_31_2_OFFSET                        2
#define D0F0x98_x28_Reserved_31_2_WIDTH                         30
#define D0F0x98_x28_Reserved_31_2_MASK                          0xfffffffc

/// D0F0x98_x28
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                        ForceCoherentIntr:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x28_STRUCT;


// **** D0F0x98_x2C Register Definition ****
// Address
#define D0F0x98_x2C_ADDRESS                                     0x2c

// Type
#define D0F0x98_x2C_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x2C_Reserved_0_0_OFFSET                         0
#define D0F0x98_x2C_Reserved_0_0_WIDTH                          1
#define D0F0x98_x2C_Reserved_0_0_MASK                           0x1
#define D0F0x98_x2C_DynWakeEn_OFFSET                            1
#define D0F0x98_x2C_DynWakeEn_WIDTH                             1
#define D0F0x98_x2C_DynWakeEn_MASK                              0x2
#define D0F0x98_x2C_Reserved_7_2_OFFSET                         2
#define D0F0x98_x2C_Reserved_7_2_WIDTH                          6
#define D0F0x98_x2C_Reserved_7_2_MASK                           0xfc
#define D0F0x98_x2C_OrbRxIdlesMask_OFFSET                       8
#define D0F0x98_x2C_OrbRxIdlesMask_WIDTH                        1
#define D0F0x98_x2C_OrbRxIdlesMask_MASK                         0x100
#define D0F0x98_x2C_SBDmaActiveMask_OFFSET                      9
#define D0F0x98_x2C_SBDmaActiveMask_WIDTH                       1
#define D0F0x98_x2C_SBDmaActiveMask_MASK                        0x200
#define D0F0x98_x2C_NBOutbWakeMask_OFFSET                       10
#define D0F0x98_x2C_NBOutbWakeMask_WIDTH                        1
#define D0F0x98_x2C_NBOutbWakeMask_MASK                         0x400
#define D0F0x98_x2C_Reserved_15_11_OFFSET                       11
#define D0F0x98_x2C_Reserved_15_11_WIDTH                        5
#define D0F0x98_x2C_Reserved_15_11_MASK                         0xf800
#define D0F0x98_x2C_WakeHysteresis_OFFSET                       16
#define D0F0x98_x2C_WakeHysteresis_WIDTH                        16
#define D0F0x98_x2C_WakeHysteresis_MASK                         0xffff0000

/// D0F0x98_x2C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                DynWakeEn:1 ; ///<
    UINT32                                             Reserved_7_2:6 ; ///<
    UINT32                                           OrbRxIdlesMask:1 ; ///<
    UINT32                                          SBDmaActiveMask:1 ; ///<
    UINT32                                           NBOutbWakeMask:1 ; ///<
    UINT32                                           Reserved_15_11:5 ; ///<
    UINT32                                           WakeHysteresis:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x2C_STRUCT;

// **** D0F0x98_x3A Register Definition ****
// Address
#define D0F0x98_x3A_ADDRESS                                     0x3a

// Type
#define D0F0x98_x3A_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x3A_ClumpingEn_OFFSET                           0
#define D0F0x98_x3A_ClumpingEn_WIDTH                            32
#define D0F0x98_x3A_ClumpingEn_MASK                             0xffffffff

/// D0F0x98_x3A
typedef union {
  struct {                                                              ///<
    UINT32                                               ClumpingEn:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x3A_STRUCT;

// **** D0F0x98_x49 Register Definition ****
// Address
#define D0F0x98_x49_ADDRESS                                     0x49

// Type
#define D0F0x98_x49_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x49_Reserved_23_0_OFFSET                        0
#define D0F0x98_x49_Reserved_23_0_WIDTH                         24
#define D0F0x98_x49_Reserved_23_0_MASK                          0xffffff
#define D0F0x98_x49_SoftOverrideClk6_OFFSET                     24
#define D0F0x98_x49_SoftOverrideClk6_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk6_MASK                       0x1000000
#define D0F0x98_x49_SoftOverrideClk5_OFFSET                     25
#define D0F0x98_x49_SoftOverrideClk5_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk5_MASK                       0x2000000
#define D0F0x98_x49_SoftOverrideClk4_OFFSET                     26
#define D0F0x98_x49_SoftOverrideClk4_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x98_x49_SoftOverrideClk3_OFFSET                     27
#define D0F0x98_x49_SoftOverrideClk3_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x98_x49_SoftOverrideClk2_OFFSET                     28
#define D0F0x98_x49_SoftOverrideClk2_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x98_x49_SoftOverrideClk1_OFFSET                     29
#define D0F0x98_x49_SoftOverrideClk1_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x98_x49_SoftOverrideClk0_OFFSET                     30
#define D0F0x98_x49_SoftOverrideClk0_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x98_x49_Reserved_31_31_OFFSET                       31
#define D0F0x98_x49_Reserved_31_31_WIDTH                        1
#define D0F0x98_x49_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x49
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                         SoftOverrideClk6:1 ; ///<
    UINT32                                         SoftOverrideClk5:1 ; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x49_STRUCT;

// **** D0F0x98_x4A Register Definition ****
// Address
#define D0F0x98_x4A_ADDRESS                                     0x4a

// Type
#define D0F0x98_x4A_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x4A_Reserved_23_0_OFFSET                        0
#define D0F0x98_x4A_Reserved_23_0_WIDTH                         24
#define D0F0x98_x4A_Reserved_23_0_MASK                          0xffffff
#define D0F0x98_x4A_SoftOverrideClk6_OFFSET                     24
#define D0F0x98_x4A_SoftOverrideClk6_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk6_MASK                       0x1000000
#define D0F0x98_x4A_SoftOverrideClk5_OFFSET                     25
#define D0F0x98_x4A_SoftOverrideClk5_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk5_MASK                       0x2000000
#define D0F0x98_x4A_SoftOverrideClk4_OFFSET                     26
#define D0F0x98_x4A_SoftOverrideClk4_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x98_x4A_SoftOverrideClk3_OFFSET                     27
#define D0F0x98_x4A_SoftOverrideClk3_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x98_x4A_SoftOverrideClk2_OFFSET                     28
#define D0F0x98_x4A_SoftOverrideClk2_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x98_x4A_SoftOverrideClk1_OFFSET                     29
#define D0F0x98_x4A_SoftOverrideClk1_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x98_x4A_SoftOverrideClk0_OFFSET                     30
#define D0F0x98_x4A_SoftOverrideClk0_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x98_x4A_Reserved_31_31_OFFSET                       31
#define D0F0x98_x4A_Reserved_31_31_WIDTH                        1
#define D0F0x98_x4A_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x4A
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                         SoftOverrideClk6:1 ; ///<
    UINT32                                         SoftOverrideClk5:1 ; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x4A_STRUCT;

// **** D0F0xBC_x1F200 Register Definition ****
// Address
#define D0F0xBC_x1F200_ADDRESS                                  0x1f200

// Type
#define D0F0xBC_x1F200_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F200_StateValid_OFFSET                        0
#define D0F0xBC_x1F200_StateValid_WIDTH                         1
#define D0F0xBC_x1F200_StateValid_MASK                          0x1
#define D0F0xBC_x1F200_Reserved_7_1_OFFSET                      1
#define D0F0xBC_x1F200_Reserved_7_1_WIDTH                       7
#define D0F0xBC_x1F200_Reserved_7_1_MASK                        0xfe
#define D0F0xBC_x1F200_LclkDivider_OFFSET                       8
#define D0F0xBC_x1F200_LclkDivider_WIDTH                        8
#define D0F0xBC_x1F200_LclkDivider_MASK                         0xff00
#define D0F0xBC_x1F200_VID_OFFSET                               16
#define D0F0xBC_x1F200_VID_WIDTH                                8
#define D0F0xBC_x1F200_VID_MASK                                 0xff0000
#define D0F0xBC_x1F200_LowVoltageReqThreshold_OFFSET            24
#define D0F0xBC_x1F200_LowVoltageReqThreshold_WIDTH             8
#define D0F0xBC_x1F200_LowVoltageReqThreshold_MASK              0xff000000

/// D0F0xBC_x1F200
typedef union {
  struct {                                                              ///<
    UINT32                                               StateValid:1 ; ///<
    UINT32                                             Reserved_7_1:7 ; ///<
    UINT32                                              LclkDivider:8 ; ///<
    UINT32                                                      VID:8 ; ///<
    UINT32                                   LowVoltageReqThreshold:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F200_STRUCT;

// **** D0F0xBC_x1F208 Register Definition ****
// Address
#define D0F0xBC_x1F208_ADDRESS                                  0x1f208

// Type
#define D0F0xBC_x1F208_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F208_HysteresisUp_OFFSET                      0
#define D0F0xBC_x1F208_HysteresisUp_WIDTH                       8
#define D0F0xBC_x1F208_HysteresisUp_MASK                        0xff
#define D0F0xBC_x1F208_HysteresisDown_OFFSET                    8
#define D0F0xBC_x1F208_HysteresisDown_WIDTH                     8
#define D0F0xBC_x1F208_HysteresisDown_MASK                      0xff00
#define D0F0xBC_x1F208_ResidencyCounter_OFFSET                  16
#define D0F0xBC_x1F208_ResidencyCounter_WIDTH                   16
#define D0F0xBC_x1F208_ResidencyCounter_MASK                    0xffff0000

/// D0F0xBC_x1F208
typedef union {
  struct {                                                              ///<
    UINT32                                             HysteresisUp:8 ; ///<
    UINT32                                           HysteresisDown:8 ; ///<
    UINT32                                         ResidencyCounter:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F208_STRUCT;

// **** D0F0xBC_x1F210 Register Definition ****
// Address
#define D0F0xBC_x1F210_ADDRESS                                  0x1f210

// Type
#define D0F0xBC_x1F210_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F210_ActivityThreshold_OFFSET                 0
#define D0F0xBC_x1F210_ActivityThreshold_WIDTH                  8
#define D0F0xBC_x1F210_ActivityThreshold_MASK                   0xff
#define D0F0xBC_x1F210_Reserved_31_8_OFFSET                     8
#define D0F0xBC_x1F210_Reserved_31_8_WIDTH                      24
#define D0F0xBC_x1F210_Reserved_31_8_MASK                       0xffffff00

/// D0F0xBC_x1F210
typedef union {
  struct {                                                              ///<
    UINT32                                        ActivityThreshold:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F210_STRUCT;

// **** D0F0xBC_x1F220 Register Definition ****
// Address
#define D0F0xBC_x1F220_ADDRESS                                  0x1f220

// Type
#define D0F0xBC_x1F220_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F220_StateValid_OFFSET                        0
#define D0F0xBC_x1F220_StateValid_WIDTH                         1
#define D0F0xBC_x1F220_StateValid_MASK                          0x1
#define D0F0xBC_x1F220_Reserved_7_1_OFFSET                      1
#define D0F0xBC_x1F220_Reserved_7_1_WIDTH                       7
#define D0F0xBC_x1F220_Reserved_7_1_MASK                        0xfe
#define D0F0xBC_x1F220_LclkDivider_OFFSET                       8
#define D0F0xBC_x1F220_LclkDivider_WIDTH                        8
#define D0F0xBC_x1F220_LclkDivider_MASK                         0xff00
#define D0F0xBC_x1F220_VID_OFFSET                               16
#define D0F0xBC_x1F220_VID_WIDTH                                8
#define D0F0xBC_x1F220_VID_MASK                                 0xff0000
#define D0F0xBC_x1F220_LowVoltageReqThreshold_OFFSET            24
#define D0F0xBC_x1F220_LowVoltageReqThreshold_WIDTH             8
#define D0F0xBC_x1F220_LowVoltageReqThreshold_MASK              0xff000000

/// D0F0xBC_x1F220
typedef union {
  struct {                                                              ///<
    UINT32                                               StateValid:1 ; ///<
    UINT32                                             Reserved_7_1:7 ; ///<
    UINT32                                              LclkDivider:8 ; ///<
    UINT32                                                      VID:8 ; ///<
    UINT32                                   LowVoltageReqThreshold:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F220_STRUCT;

// **** D0F0xBC_x1F228 Register Definition ****
// Address
#define D0F0xBC_x1F228_ADDRESS                                  0x1f228

// Type
#define D0F0xBC_x1F228_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F228_HysteresisUp_OFFSET                      0
#define D0F0xBC_x1F228_HysteresisUp_WIDTH                       8
#define D0F0xBC_x1F228_HysteresisUp_MASK                        0xff
#define D0F0xBC_x1F228_HysteresisDown_OFFSET                    8
#define D0F0xBC_x1F228_HysteresisDown_WIDTH                     8
#define D0F0xBC_x1F228_HysteresisDown_MASK                      0xff00
#define D0F0xBC_x1F228_ResidencyCounter_OFFSET                  16
#define D0F0xBC_x1F228_ResidencyCounter_WIDTH                   16
#define D0F0xBC_x1F228_ResidencyCounter_MASK                    0xffff0000

/// D0F0xBC_x1F228
typedef union {
  struct {                                                              ///<
    UINT32                                             HysteresisUp:8 ; ///<
    UINT32                                           HysteresisDown:8 ; ///<
    UINT32                                         ResidencyCounter:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F228_STRUCT;

// **** D0F0xBC_x1F230 Register Definition ****
// Address
#define D0F0xBC_x1F230_ADDRESS                                  0x1f230

// Type
#define D0F0xBC_x1F230_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F230_ActivityThreshold_OFFSET                 0
#define D0F0xBC_x1F230_ActivityThreshold_WIDTH                  8
#define D0F0xBC_x1F230_ActivityThreshold_MASK                   0xff
#define D0F0xBC_x1F230_Reserved_31_8_OFFSET                     8
#define D0F0xBC_x1F230_Reserved_31_8_WIDTH                      24
#define D0F0xBC_x1F230_Reserved_31_8_MASK                       0xffffff00

/// D0F0xBC_x1F230
typedef union {
  struct {                                                              ///<
    UINT32                                        ActivityThreshold:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F230_STRUCT;

// **** D0F0xBC_x1F240 Register Definition ****
// Address
#define D0F0xBC_x1F240_ADDRESS                                  0x1f240

// Type
#define D0F0xBC_x1F240_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F240_StateValid_OFFSET                        0
#define D0F0xBC_x1F240_StateValid_WIDTH                         1
#define D0F0xBC_x1F240_StateValid_MASK                          0x1
#define D0F0xBC_x1F240_Reserved_7_1_OFFSET                      1
#define D0F0xBC_x1F240_Reserved_7_1_WIDTH                       7
#define D0F0xBC_x1F240_Reserved_7_1_MASK                        0xfe
#define D0F0xBC_x1F240_LclkDivider_OFFSET                       8
#define D0F0xBC_x1F240_LclkDivider_WIDTH                        8
#define D0F0xBC_x1F240_LclkDivider_MASK                         0xff00
#define D0F0xBC_x1F240_VID_OFFSET                               16
#define D0F0xBC_x1F240_VID_WIDTH                                8
#define D0F0xBC_x1F240_VID_MASK                                 0xff0000
#define D0F0xBC_x1F240_LowVoltageReqThreshold_OFFSET            24
#define D0F0xBC_x1F240_LowVoltageReqThreshold_WIDTH             8
#define D0F0xBC_x1F240_LowVoltageReqThreshold_MASK              0xff000000

/// D0F0xBC_x1F240
typedef union {
  struct {                                                              ///<
    UINT32                                               StateValid:1 ; ///<
    UINT32                                             Reserved_7_1:7 ; ///<
    UINT32                                              LclkDivider:8 ; ///<
    UINT32                                                      VID:8 ; ///<
    UINT32                                   LowVoltageReqThreshold:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F240_STRUCT;

// **** D0F0xBC_x1F248 Register Definition ****
// Address
#define D0F0xBC_x1F248_ADDRESS                                  0x1f248

// Type
#define D0F0xBC_x1F248_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F248_HysteresisUp_OFFSET                      0
#define D0F0xBC_x1F248_HysteresisUp_WIDTH                       8
#define D0F0xBC_x1F248_HysteresisUp_MASK                        0xff
#define D0F0xBC_x1F248_HysteresisDown_OFFSET                    8
#define D0F0xBC_x1F248_HysteresisDown_WIDTH                     8
#define D0F0xBC_x1F248_HysteresisDown_MASK                      0xff00
#define D0F0xBC_x1F248_ResidencyCounter_OFFSET                  16
#define D0F0xBC_x1F248_ResidencyCounter_WIDTH                   16
#define D0F0xBC_x1F248_ResidencyCounter_MASK                    0xffff0000

/// D0F0xBC_x1F248
typedef union {
  struct {                                                              ///<
    UINT32                                             HysteresisUp:8 ; ///<
    UINT32                                           HysteresisDown:8 ; ///<
    UINT32                                         ResidencyCounter:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F248_STRUCT;

// **** D0F0xBC_x1F250 Register Definition ****
// Address
#define D0F0xBC_x1F250_ADDRESS                                  0x1f250

// Type
#define D0F0xBC_x1F250_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F250_ActivityThreshold_OFFSET                 0
#define D0F0xBC_x1F250_ActivityThreshold_WIDTH                  8
#define D0F0xBC_x1F250_ActivityThreshold_MASK                   0xff
#define D0F0xBC_x1F250_Reserved_31_8_OFFSET                     8
#define D0F0xBC_x1F250_Reserved_31_8_WIDTH                      24
#define D0F0xBC_x1F250_Reserved_31_8_MASK                       0xffffff00

/// D0F0xBC_x1F250
typedef union {
  struct {                                                              ///<
    UINT32                                        ActivityThreshold:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xBC_x1F250_STRUCT;

// **** D0F0xBC_x1F260 Register Definition ****
// Address
#define D0F0xBC_x1F260_ADDRESS                                  0x1f260

// Type
#define D0F0xBC_x1F260_TYPE                                     TYPE_D0F0xBC
// Field Data
#define D0F0xBC_x1F260_StateValid_OFFSET                        0
#define D0F0xBC_x1F260_StateValid_WIDTH                         1
#define D0F0xBC_x1F260_StateValid_MASK                          0x1
#define D0F0xBC_x1F260_Reserved_7_1_OFFSET                      1
#define D0F0xBC_x1F260_Reserved_7_1_WIDTH                       7
#define D0F0xBC_x1F260_Reserved_7_1_MASK                        0xfe
#d