/* Test handling of spaces and empty macro expansions in
   stringifying.  PR 31869.  */
/* { dg-do run } */

extern int strcmp (const char *, const char *);
extern int puts (const char *);
extern void abort (void);
extern void exit (int);
#define err(str) do { puts (str); abort (); } while (0)

#define s(x) #x
#define v(x, r) if (strcmp (s(x), r)) err (#x)

#define EOA /* empty */
#define EFA() /* empty */
#define EOB EFA()EFA()
#define EOC EFA()EOA
#define EFB() EFA()EFA()
#define EFC() EFA()EOA
#define ARG(x) x
#define SOA EOA EOA
#define SOB ARG(EFB() EOA)
#define SOC ARG(SOA)
#define SFA() EOA EOA
#define SFB() ARG(EFB() EOA)
#define SFC() ARG(SOA)
#define SAa(x) x EOA
#define SAb(x) x EOB
#define SAc(x) x EOC
#define SAd(x) x EFA()
#define SAe(x) x EFB()
#define SAf(x) x EFC()
#define SBa(x) EOA x
#define SBb(x) EOB x
#define SBc(x) EOC x
#define SBd(x) SFA()x
#define SBe(x) SFB()x
#define SBf(x) SFC()x

void
check0 (void)
{
  v(||, "||");
  v(|EOA|, "||");
  v(|EOB|, "||");
  v(|EOC|, "||");
  v(|EFA()|, "||");
  v(|EFB()|, "||");
  v(|EFC()|, "||");
}

void
check1 (void)
{
  v(|SBa(|), "| |");
  v(|SBb(|), "| |");
  v(|SBc(|), "| |");
  v(|SBd(|), "| |");
  v(|SBe(|), "| |");
  v(|SBf(|), "| |");
  v(| |, "| |");
  v(| SBa(|), "| |");
  v(| SBb(|), "| |");
  v(| SBc(|), "| |");
  v(| SBd(|), "| |");
  v(| SBe(|), "| |");
  v(| SBf(|), "| |");
  v(|EFA()SBa(|), "| |");
  v(|EFA()SBb(|), "| |");
  v(|EFA()SBc(|), "| |");
  v(|EFA()SBd(|), "| |");
  v(|EFA()SBe(|), "| |");
  v(|EFA()SBf(|), "| |");
  v(|EFB()SBa(|), "| |");
  v(|EFB()SBb(|), "| |");
  v(|EFB()SBc(|), "| |");
  v(|EFB()SBd(|), "| |");
  v(|EFB()SBe(|), "| |");
  v(|EFB()SBf(|), "| |");
  v(|EFC()SBa(|), "| |");
  v(|EFC()SBb(|), "| |");
  v(|EFC()SBc(|), "| |");
  v(|EFC()SBd(|), "| |");
  v(|EFC()SBe(|), "| |");
  v(|EFC()SBf(|), "| |");
  v(| EOA|, "| |");
  v(| EOB|, "| |");
  v(| EOC|, "| |");
  v(| EFA()|, "| |");
  v(| EFA()SBa(|), "| |");
  v(| EFA()SBb(|), "| |");
  v(| EFA()SBc(|), "| |");
  v(| EFA()SBd(|), "| |");
  v(| EFA()SBe(|), "| |");
  v(| EFA()SBf(|), "| |");
  v(| EFB()|, "| |");
  v(| EFB()SBa(|), "| |");
  v(| EFB()SBb(|), "| |");
  v(| EFB()SBc(|), "| |");
  v(| EFB()SBd(|), "| |");
  v(| EFB()SBe(|), "| |");
  v(| EFB()SBf(|), "| |");
  v(| EFC()|, "| |");
  v(| EFC()SBa(|), "| |");
  v(| EFC()SBb(|), "| |");
  v(| EFC()SBc(|), "| |");
  v(| EFC()SBd(|), "| |");
  v(| EFC()SBe(|), "| |");
  v(| EFC()SBf(|), "| |");
  v(|EOA |, "| |");
  v(|EOA SBa(|), "| |");
  v(|EOA SBb(|), "| |");
  v(|EOA SBc(|), "| |");
  v(|EOA SBd(|), "| |");
  v(|EOA SBe(|), "| |");
  v(|EOA SBf(|), "| |");
  v(|EOB |, "| |");
  v(|EOB SBa(|), "| |");
  v(|EOB SBb(|), "| |");
  v(|EOB SBc(|), "| |");
  v(|EOB SBd(|), "| |");
  v(|EOB SBe(|), "| |");
  v(|EOB SBf(|), "| |");
  v(|EOC |, "| |");
  v(|EOC SBa(|), "| |");
  v(|EOC SBb(|), "| |");
  v(|EOC SBc(|), "| |");
  v(|EOC SBd(|), "| |");
  v(|EOC SBe(|), "| |");
  v(|EOC SBf(|), "| |");
  v(|EFA() |, "| |");
  v(|EFA() SBa(|), "| |");
  v(|EFA() SBb(|), "| |");
  v(|EFA() SBc(|), "| |");
  v(|EFA() SBd(|), "| |");
  v(|EFA() SBe(|), "| |");
  v(|EFA() SBf(|), "| |");
  v(|EFB() |, "| |");
  v(|EFB() SBa(|), "| |");
  v(|EFB() SBb(|), "| |");
  v(|EFB() SBc(|), "| |");
  v(|EFB() SBd(|), "| |");
  v(|EFB() SBe(|), "| |");
  v(|EFB() SBf(|), "| |");
  v(|EFC() |, "| |");
  v(|EFC() SBa(|), "| |");
  v(|EFC() SBb(|), "| |");
  v(|EFC() SBc(|), "| |");
  v(|EFC() SBd(|), "| |");
  v(|EFC() SBe(|), "| |");
  v(|EFC() SBf(|), "| |");
  v(| EOA |, "| |");
  v(| EOA SBa(|), "| |");
  v(| EOA SBb(|), "| |");
  v(| EOA SBc(|), "| |");
  v(| EOA SBd(|), "| |");
  v(| EOA SBe(|), "| |");
  v(| EOA SBf(|), "| |");
  v(| EOB |, "| |");
  v(| EOB SBa(|), "| |");
  v(| EOB SBb(|), "| |");
  v(| EOB SBc(|), "| |");
  v(| EOB SBd(|), "| |");
  v(| EOB SBe(|), "| |");
  v(| EOB SBf(|), "| |");
  v(| EOC |, "| |");
  v(| EOC SBa(|), "| |");
  v(| EOC SBb(|), "| |");
  v(| EOC SBc(|), "| |");
  v(| EOC SBd(|), "| |");
  v(| EOC SBe(|), "| |");
  v(| EOC SBf(|), "| |");
  v(| EFA() |, "| |");
  v(| EFA() SBa(|), "| |");
  v(| EFA() SBb(|), "| |");
  v(| EFA() SBc(|), "| |");
  v(| EFA() SBd(|), "| |");
  v(| EFA() SBe(|), "| |");
  v(| EFA() SBf(|), "| |");
  v(| EFB() |, "| |");
  v(| EFB() SBa(|), "| |");
  v(| EFB() SBb(|), "| |");
  v(| EFB() SBc(|), "| |");
  v(| EFB() SBd(|), "| |");
  v(| EFB() SBe(|), "| |");
  v(| EFB() SBf(|), "| |");
  v(| EFC() |, "| |");
  v(| EFC() SBa(|), "| |");
  v(| EFC() SBb(|), "| |");
  v(| EFC() SBc(|), "| |");
  v(| EFC() SBd(|), "| |");
  v(| EFC() SBe(|), "| |");
  v(| EFC() SBf(|), "| |");
}

void
check2 (void)
{
  v(SAa(|)|, "| |");
  v(SAa(|)SBa(|), "| |");
  v(SAa(|)SBb(|), "| |");
  v(SAa(|)SBc(|), "| |");
  v(SAa(|)SBd(|), "| |");
  v(SAa(|)SBe(|), "| |");
  v(SAa(|)SBf(|), "| |");
  v(SAa(|) |, "| |");
  v(SAa(|) SBa(|), "| |");
  v(SAa(|) SBb(|), "| |");
  v(SAa(|) SBc(|), "| |");
  v(SAa(|) SBd(|), "| |");
  v(SAa(|) SBe(|), "| |");
  v(SAa(|) SBf(|), "| |");
  v(SAa(|)EOA|, "| |");
  v(SAa(|)EOB|, "| |");
  v(SAa(|)EOC|, "| |");
  v(SAa(|)EFA()|, "| |");
  v(SAa(|)EFA()SBa(|), "| |");
  v(SAa(|)EFA()SBb(|), "| |");
  v(SAa(|)EFA()SBc(|), "| |");
  v(SAa(|)EFA()SBd(|), "| |");
  v(SAa(|)EFA()SBe(|), "| |");
  v(SAa(|)EFA()SBf(|), "| |");
  v(SAa(|)EFB()|, "| |");
  v(SAa(|)EFB()SBa(|), "| |");
  v(SAa(|)EFB()SBb(|), "| |");
  v(SAa(|)EFB()SBc(|), "| |");
  v(SAa(|)EFB()SBd(|), "| |");
  v(SAa(|)EFB()SBe(|), "| |");
  v(SAa(|)EFB()SBf(|), "| |");
  v(SAa(|)EFC()|, "| |");
  v(SAa(|)EFC()SBa(|), "| |");
  v(SAa(|)EFC()SBb(|), "| |");
  v(SAa(|)EFC()SBc(|), "| |");
  v(SAa(|)EFC()SBd(|), "| |");
  v(SAa(|)EFC()SBe(|), "| |");
  v(SAa(|)EFC()SBf(|), "| |");
  v(SAa(|) EOA|, "| |");
  v(SAa(|) EOB|, "| |");
  v(SAa(|) EOC|, "| |");
  v(SAa(|) EFA()|, "| |");
  v(SAa(|) EFA()SBa(|), "| |");
  v(SAa(|) EFA()SBb(|), "| |");
  v(SAa(|) EFA()SBc(|), "| |");
  v(SAa(|) EFA()SBd(|), "| |");
  v(SAa(|) EFA()SBe(|), "| |");
  v(SAa(|) EFA()SBf(|), "| |");
  v(SAa(|) EFB()|, "| |");
  v(SAa(|) EFB()SBa(|), "| |");
  v(SAa(|) EFB()SBb(|), "| |");
  v(SAa(|) EFB()SBc(|), "| |");
  v(SAa(|) EFB()SBd(|), "| |");
  v(SAa(|) EFB()SBe(|), "| |");
  v(SAa(|) EFB()SBf(|), "| |");
  v(SAa(|) EFC()|, "| |");
  v(SAa(|) EFC()SBa(|), "| |");
  v(SAa(|) EFC()SBb(|), "| |");
  v(SAa(|) EFC()SBc(|), "| |");
  v(SAa(|) EFC()SBd(|), "| |");
  v(SAa(|) EFC()SBe(|), "| |");
  v(SAa(|) EFC()SBf(|), "| |");
  v(SAa(|)EOA |, "| |");
  v(SAa(|)EOA SBa(|), "| |");
  v(SAa(|)EOA SBb(|), "| |");
  v(SAa(|)EOA SBc(|), "| |");
  v(SAa(|)EOA SBd(|), "| |");
  v(SAa(|)EOA SBe(|), "| |");
  v(SAa(|)EOA SBf(|), "| |");
  v(SAa(|)EOB |, "| |");
  v(SAa(|)EOB SBa(|), "| |");
  v(SAa(|)EOB SBb(|), "| |");
  v(SAa(|)EOB SBc(|), "| |");
  v(SAa(|)EOB SBd(|), "| |");
  v(SAa(|)EOB SBe(|), "| |");
  v(SAa(|)EOB SBf(|), "| |");
  v(SAa(|)EOC |, "| |");
  v(SAa(|)EOC SBa(|), "| |");
  v(SAa(|)EOC SBb(|), "| |");
  v(SAa(|)EOC SBc(|), "| |");
  v(SAa(|)EOC SBd(|), "| |");
  v(SAa(|)EOC SBe(|), "| |");
  v(SAa(|)EOC SBf(|), "| |");
  v(SAa(|)EFA() |, "| |");
  v(SAa(|)EFA() SBa(|), "| |");
  v(SAa(|)EFA() SBb(|), "| |");
  v(SAa(|)EFA() SBc(|), "| |");
  v(SAa(|)EFA() SBd(|), "| |");
  v(SAa(|)EFA() SBe(|), "| |");
  v(SAa(|)EFA() SBf(|), "| |");
  v(SAa(|)EFB() |, "| |");
  v(SAa(|)EFB() SBa(|), "| |");
  v(SAa(|)EFB() SBb(|), "| |");
  v(SAa(|)EFB() SBc(|), "| |");
  v(SAa(|)EFB() SBd(|), "| |");
  v(SAa(|)EFB() SBe(|), "| |");
  v(SAa(|)EFB() SBf(|), "| |");
  v(SAa(|)EFC() |, "| |");
  v(SAa(|)EFC() SBa(|), "| |");
  v(SAa(|)EFC() SBb(|), "| |");
  v(SAa(|)EFC() SBc(|), "| |");
  v(SAa(|)EFC() SBd(|), "| |");
  v(SAa(|)EFC() SBe(|), "| |");
  v(SAa(|)EFC() SBf(|), "| |");
  v(SAa(|) EOA |, "| |");
  v(SAa(|) EOA SBa(|), "| |");
  v(SAa(|) EOA SBb(|), "| |");
  v(SAa(|) EOA SBc(|), "| |");
  v(SAa(|) EOA SBd(|), "| |");
  v(SAa(|) EOA SBe(|), "| |");
  v(SAa(|) EOA SBf(|), "| |");
  v(SAa(|) EOB |, "| |");
  v(SAa(|) EOB SBa(|), "| |");
  v(SAa(|) EOB SBb(|), "| |");
  v(SAa(|) EOB SBc(|), "| |");
  v(SAa(|) EOB SBd(|), "| |");
  v(SAa(|) EOB SBe(|), "| |");
  v(SAa(|) EOB SBf(|), "| |");
  v(SAa(|) EOC |, "| |");
  v(SAa(|) EOC SBa(|), "| |");
  v(SAa(|) EOC SBb(|), "| |");
  v(SAa(|) EOC SBc(|), "| |");
  v(SAa(|) EOC SBd(|), "| |");
  v(SAa(|) EOC SBe(|), "| |");
  v(SAa(|) EOC SBf(|), "| |");
  v(SAa(|) EFA() |, "| |");
  v(SAa(|) EFA() SBa(|), "| |");
  v(SAa(|) EFA() SBb(|), "| |");
  v(SAa(|) EFA() SBc(|), "| |");
  v(SAa(|) EFA() SBd(|), "| |");
  v(SAa(|) EFA() SBe(|), "| |");
  v(SAa(|) EFA() SBf(|), "| |");
  v(SAa(|) EFB() |, "| |");
  v(SAa(|) EFB() SBa(|), "| |");
  v(SAa(|) EFB() SBb(|), "| |");
  v(SAa(|) EFB() SBc(|), "| |");
  v(SAa(|) EFB() SBd(|), "| |");
  v(SAa(|) EFB() SBe(|), "| |");
  v(SAa(|) EFB() SBf(|), "| |");
  v(SAa(|) EFC() |, "| |");
  v(SAa(|) EFC() SBa(|), "| |");
  v(SAa(|) EFC() SBb(|), "| |");
  v(SAa(|) EFC() SBc(|), "| |");
  v(SAa(|) EFC() SBd(|), "| |");
  v(SAa(|) EFC() SBe(|), "| |");
  v(SAa(|) EFC() SBf(|), "| |");
}

void
check3 (void)
{
  v(SAb(|)|, "| |");
  v(SAb(|)SBa(|), "| |");
  v(SAb(|)SBb(|), "| |");
  v(SAb(|)SBc(|), "| |");
  v(SAb(|)SBd(|), "| |");
  v(SAb(|)SBe(|), "| |");
  v(SAb(|)SBf(|), "| |");
  v(SAb(|) |, "| |");
  v(SAb(|) SBa(|), "| |");
  v(SAb(|) SBb(|), "| |");
  v(SAb(|) SBc(|), "| |");
  v(SAb(|) SBd(|), "| |");
  v(SAb(|) SBe(|), "| |");
  v(SAb(|) SBf(|), "| |");
  v(SAb(|)EOA|, "| |");
  v(SAb(|)EOB|, "| |");
  v(SAb(|)EOC|, "| |");
  v(SAb(|)EFA()|, "| |");
  v(SAb(|)EFA()SBa(|), "| |");
  v(SAb(|)EFA()SBb(|), "| |");
  v(SAb(|)EFA()SBc(|), "| |");
  v(SAb(|)EFA()SBd(|), "| |");
  v(SAb(|)EFA()SBe(|), "| |");
  v(SAb(|)EFA()SBf(|), "| |");
  v(SAb(|)EFB()|, "| |");
  v(SAb(|)EFB()SBa(|), "| |");
  v(SAb(|)EFB()SBb(|), "| |");
  v(SAb(|)EFB()SBc(|), "| |");
  v(SAb(|)EFB()SBd(|), "| |");
  v(SAb(|)EFB()SBe(|), "| |");
  v(SAb(|)EFB()SBf(|), "| |");
  v(SAb(|)EFC()|, "| |");
  v(SAb(|)EFC()SBa(|), "| |");
  v(SAb(|)EFC()SBb(|), "| |");
  v(SAb(|)EFC()SBc(|), "| |");
  v(SAb(|)EFC()SBd(|), "| |");
  v(SAb(|)EFC()SBe(|), "| |");
  v(SAb(|)EFC()SBf(|), "| |");
  v(SAb(|) EOA|, "| |");
  v(SAb(|) EOB|, "| |");
  v(SAb(|) EOC|, "| |");
  v(SAb(|) EFA()|, "| |");
  v(SAb(|) EFA()SBa(|), "| |");
  v(SAb(|) EFA()SBb(|), "| |");
  v(SAb(|) EFA()SBc(|), "| |");
  v(SAb(|) EFA()SBd(|), "| |");
  v(SAb(|) EFA()SBe(|), "| |");
  v(SAb(|) EFA()SBf(|), "| |");
  v(SAb(|) EFB()|, "| |");
  v(SAb(|) EFB()SBa(|), "| |");
  v(SAb(|) EFB()SBb(|), "| |");
  v(SAb(|) EFB()SBc(|), "| |");
  v(SAb(|) EFB()SBd(|), "| |");
  v(SAb(|) EFB()SBe(|), "| |");
  v(SAb(|) EFB()SBf(|), "| |");
  v(SAb(|) EFC()|, "| |");
  v(SAb(|) EFC()SBa(|), "| |");
  v(SAb(|) EFC()SBb(|), "| |");
  v(SAb(|) EFC()SBc(|), "| |");
  v(SAb(|) EFC()SBd(|), "| |");
  v(SAb(|) EFC()SBe(|), "| |");
  v(SAb(|) EFC()SBf(|), "| |");
  v(SAb(|)EOA |, "| |");
  v(SAb(|)EOA SBa(|), "| |");
  v(SAb(|)EOA SBb(|), "| |");
  v(SAb(|)EOA SBc(|), "| |");
  v(SAb(|)EOA SBd(|), "| |");
  v(SAb(|)EOA SBe(|), "| |");
  v(SAb(|)EOA SBf(|), "| |");
  v(SAb(|)EOB |, "| |");
  v(SAb(|)EOB SBa(|), "| |");
  v(SAb(|)EOB SBb(|), "| |");
  v(SAb(|)EOB SBc(|), "| |");
  v(SAb(|)EOB SBd(|), "| |");
  v(SAb(|)EOB SBe(|), "| |");
  v(SAb(|)EOB SBf(|), "| |");
  v(SAb(|)EOC |, "| |");
  v(SAb(|)EOC SBa(|), "| |");
  v(SAb(|)EOC SBb(|), "| |");
  v(SAb(|)EOC SBc(|), "| |");
  v(SAb(|)EOC SBd(|), "| |");
  v(SAb(|)EOC SBe(|), "| |");
  v(SAb(|)EOC SBf(|), "| |");
  v(SAb(|)EFA() |, "| |");
  v(SAb(|)EFA() SBa(|), "| |");
  v(SAb(|)EFA() SBb(|), "| |");
  v(SAb(|)EFA() SBc(|), "| |");
  v(SAb(|)EFA() SBd(|), "| |");
  v(SAb(|)EFA() SBe(|), "| |");
  v(SAb(|)EFA() SBf(|), "| |");
  v(SAb(|)EFB() |, "| |");
  v(SAb(|)EFB() SBa(|), "| |");
  v(SAb(|)EFB() SBb(|), "| |");
  v(SAb(|)EFB() SBc(|), "| |");
  v(SAb(|)EFB() SBd(|), "| |");
  v(SAb(|)EFB() SBe(|), "| |");
  v(SAb(|)EFB() SBf(|), "| |");
  v(SAb(|)EFC() |, "| |");
  v(SAb(|)EFC() SBa(|), "| |");
  v(SAb(|)EFC() SBb(|), "| |");
  v(SAb(|)EFC() SBc(|), "| |");
  v(SAb(|)EFC() SBd(|), "| |");
  v(SAb(|)EFC() SBe(|), "| |");
  v(SAb(|)EFC() SBf(|), "| |");
  v(SAb(|) EOA |, "| |");
  v(SAb(|) EOA SBa(|), "| |");
  v(SAb(|) EOA SBb(|), "| |");
  v(SAb(|) EOA SBc(|), "| |");
  v(SAb(|) EOA SBd(|), "| |");
  v(SAb(|) EOA SBe(|), "| |");
  v(SAb(|) EOA SBf(|), "| |");
  v(SAb(|) EOB |, "| |");
  v(SAb(|) EOB SBa(|), "| |");
  v(SAb(|) EOB SBb(|), "| |");
  v(SAb(|) EOB SBc(|), "| |");
  v(SAb(|) EOB SBd(|), "| |");
  v(SAb(|) EOB SBe(|), "| |");
  v(SAb(|) EOB SBf(|), "| |");
  v(SAb(|) EOC |, "| |");
  v(SAb(|) EOC SBa(|), "| |");
  v(SAb(|) EOC SBb(|), "| |");
  v(SAb(|) EOC SBc(|), "| |");
  v(SAb(|) EOC SBd(|), "| |");
  v(SAb(|) EOC SBe(|), "| |");
  v(SAb(|) EOC SBf(|), "| |");
  v(SAb(|) EFA() |, "| |");
  v(SAb(|) EFA() SBa(|), "| |");
  v(SAb(|) EFA() SBb(|), "| |");
  v(SAb(|) EFA() SBc(|), "| |");
  v(SAb(|) EFA() SBd(|), "| |");
  v(SAb(|) EFA() SBe(|), "| |");
  v(SAb(|) EFA() SBf(|), "| |");
  v(SAb(|) EFB() |, "| |");
  v(SAb(|) EFB() SBa(|), "| |");
  v(SAb(|) EFB() SBb(|), "| |");
  v(SAb(|) EFB() SBc(|), "| |");
  v(SAb(|) EFB() SBd(|), "| |");
  v(SAb(|) EFB() SBe(|), "| |");
  v(SAb(|) EFB() SBf(|), "| |");
  v(SAb(|) EFC() |, "| |");
  v(SAb(|) EFC() SBa(|), "| |");
  v(SAb(|) EFC() SBb(|), "| |");
  v(SAb(|) EFC() SBc(|), "| |");
  v(SAb(|) EFC() SBd(|), "| |");
  v(SAb(|) EFC() SBe(|), "| |");
  v(SAb(|) EFC() SBf(|), "| |");
}

void
check4 (void)
{
  v(SAc(|)|, "| |");
  v(SAc(|)SBa(|), "| |");
  v(SAc(|)SBb(|), "| |");
  v(SAc(|)SBc(|), "| |");
  v(SAc(|)SBd(|), "| |");
  v(SAc(|)SBe(|), "| |");
  v(SAc(|)SBf(|), "| |");
  v(SAc(|) |, "| |");
  v(SAc(|) SBa(|), "| |");
  v(SAc(|) SBb(|), "| |");
  v(SAc(|) SBc(|), "| |");
  v(SAc(|) SBd(|), "| |");
  v(SAc(|) SBe(|), "| |");
  v(SAc(|) SBf(|), "| |");
  v(SAc(|)EOA|, "| |");
  v(SAc(|)EOB|, "| |");
  v(SAc(|)EOC|, "| |");
  v(SAc(|)EFA()|, "| |");
  v(SAc(|)EFA()SBa(|), "| |");
  v(SAc(|)EFA()SBb(|), "| |");
  v(SAc(|)EFA()SBc(|), "| |");
  v(SAc(|)EFA()SBd(|), "| |");
  v(SAc(|)EFA()SBe(|), "| |");
  v(SAc(|)EFA()SBf(|), "| |");
  v(SAc(|)EFB()|, "| |");
  v(SAc(|)EFB()SBa(|), "| |");
  v(SAc(|)EFB()SBb(|), "| |");
  v(SAc(|)EFB()SBc(|), "| |");
  v(SAc(|)EFB()SBd(|), "| |");
  v(SAc(|)EFB()SBe(|), "| |");
  v(SAc(|)EFB()SBf(|), "| |");
  v(SAc(|)EFC()|, "| |");
  v(SAc(|)EFC()SBa(|), "| |");
  v(SAc(|)EFC()SBb(|), "| |");
  v(SAc(|)EFC()SBc(|), "| |");
  v(SAc(|)EFC()SBd(|), "| |");
  v(SAc(|)EFC()SBe(|), "| |");
  v(SAc(|)EFC()SBf(|), "| |");
  v(SAc(|) EOA|, "| |");
  v(SAc(|) EOB|, "| |");
  v(SAc(|) EOC|, "| |");
  v(SAc(|) EFA()|, "| |");
  v(SAc(|) EFA()SBa(|), "| |");
  v(SAc(|) EFA()SBb(|), "| |");
  v(SAc(|) EFA()SBc(|), "| |");
  v(SAc(|) EFA()SBd(|), "| |");
  v(SAc(|) EFA()SBe(|), "| |");
  v(SAc(|) EFA()SBf(|), "| |");
  v(SAc(|) EFB()|, "| |");
  v(SAc(|) EFB()SBa(|), "| |");
  v(SAc(|) EFB()SBb(|), "| |");
  v(SAc(|) EFB()SBc(|), "| |");
  v(SAc(|) EFB()SBd(|), "| |");
  v(SAc(|) EFB()SBe(|), "| |");
  v(SAc(|) EFB()SBf(|), "| |");
  v(SAc(|) EFC()|, "| |");
  v(SAc(|) EFC()SBa(|), "| |");
  v(SAc(|) EFC()SBb(|), "| |");
  v(SAc(|) EFC()SBc(|), "| |");
  v(SAc(|) EFC()SBd(|), "| |");
  v(SAc(|) EFC()SBe(|), "| |");
  v(SAc(|) EFC()SBf(|), "| |");
  v(SAc(|)EOA |, "| |");
  v(SAc(|)EOA SBa(|), "| |");
  v(SAc(|)EOA SBb(|), "| |");
  v(SAc(|)EOA SBc(|), "| |");
  v(SAc(|)EOA SBd(|), "| |");
  v(SAc(|)EOA SBe(|), "| |");
  v(SAc(|)EOA SBf(|), "| |");
  v(SAc(|)EOB |, "| |");
  v(SAc(|)EOB SBa(|), "| |");
  v(SAc(|)EOB SBb(|), "| |");
  v(SAc(|)EOB SBc(|), "| |");
  v(SAc(|)EOB SBd(|), "| |");
  v(SAc(|)EOB SBe(|), "| |");
  v(SAc(|)EOB SBf(|), "| |");
  v(SAc(|)EOC |, "| |");
  v(SAc(|)EOC SBa(|), "| |");
  v(SAc(|)EOC SBb(|), "| |");
  v(SAc(|)EOC SBc(|), "| |");
  v(SAc(|)EOC SBd(|), "| |");
  v(SAc(|)EOC SBe(|), "| |");
  v(SAc(|)EOC SBf(|), "| |");
  v(SAc(|)EFA() |, "| |");
  v(SAc(|)EFA() SBa(|), "| |");
  v(SAc(|)EFA() SBb(|), "| |");
  v(SAc(|)EFA() SBc(|), "| |");
  v(SAc(|)EFA() SBd(|), "| |");
  v(SAc(|)EFA() SBe(|), "| |");
  v(SAc(|)EFA() SBf(|), "| |");
  v(SAc(|)EFB() |, "| |");
  v(SAc(|)EFB() SBa(|), "| |");
  v(SAc(|)EFB() SBb(|), "| |");
  v(SAc(|)EFB() SBc(|), "| |");
  v(SAc(|)EFB() SBd(|), "| |");
  v(SAc(|)EFB() SBe(|), "| |");
  v(SAc(|)EFB() SBf(|), "| |");
  v(SAc(|)EFC() |, "| |");
  v(SAc(|)EFC() SBa(|), "| |");
  v(SAc(|)EFC() SBb(|), "| |");
  v(SAc(|)EFC() SBc(|), "| |");
  v(SAc(|)EFC() SBd(|), "| |");
  v(SAc(|)EFC() SBe(|), "| |");
  v(SAc(|)EFC() SBf(|), "| |");
  v(SAc(|) EOA |, "| |");
  v(SAc(|) EOA SBa(|), "| |");
  v(SAc(|) EOA SBb(|), "| |");
  v(SAc(|) EOA SBc(|), "| |");
  v(SAc(|) EOA SBd(|), "| |");
  v(SAc(|) EOA SBe(|), "| |");
  v(SAc(|) EOA SBf(|), "| |");
  v(SAc(|) EOB |, "| |");
  v(SAc(|) EOB SBa(|), "| |");
  v(SAc(|) EOB SBb(|), "| |");
  v(SAc(|) EOB SBc(|), "| |");
  v(SAc(|) EOB SBd(|), "| |");
  v(SAc(|) EOB SBe(|), "| |");
  v(SAc(|) EOB SBf(|), "| |");
  v(SAc(|) EOC |, "| |");
  v(SAc(|) EOC SBa(|), "| |");
  v(SAc(|) EOC SBb(|), "| |");
  v(SAc(|) EOC SBc(|), "| |");
  v(SAc(|) EOC SBd(|), "| |");
  v(SAc(|) EOC SBe(|), "| |");
  v(SAc(|) EOC SBf(|), "| |");
  v(SAc(|) EFA() |, "| |");
  v(SAc(|) EFA() SBa(|), "| |");
  v(SAc(|) EFA() SBb(|), "| |");
  v(SAc(|) EFA() SBc(|), "| |");
  v(SAc(|) EFA() SBd(|), "| |");
  v(SAc(|) EFA() SBe(|), "| |");
  v(SAc(|) EFA() SBf(|), "| |");
  v(SAc(|) EFB() |, "| |");
  v(SAc(|) EFB() SBa(|), "| |");
  v(SAc(|) EFB() SBb(|), "| |");
  v(SAc(|) EFB() SBc(|), "| |");
  v(SAc(|) EFB() SBd(|), "| |");
  v(SAc(|) EFB() SBe(|), "| |");
  v(SAc(|) EFB() SBf(|), "| |");
  v(SAc(|) EFC() |, "| |");
  v(SAc(|) EFC() SBa(|), "| |");
  v(SAc(|) EFC() SBb(|), "| |");
  v(SAc(|) EFC() SBc(|), "| |");
  v(SAc(|) EFC() SBd(|), "| |");
  v(SAc(|) EFC() SBe(|), "| |");
  v(SAc(|) EFC() SBf(|), "| |");
  v(SAc(|)|, "| |");
  v(SAc(|)SBa(|), "| |");
  v(SAc(|)SBb(|), "| |");
  v(SAc(|)SBc(|), "| |");
  v(SAc(|)SBd(|), "| |");
  v(SAc(|)SBe(|), "| |");
  v(SAc(|)SBf(|), "| |");
  v(SAc(|) |, "| |");
  v(SAc(|) SBa(|), "| |");
  v(SAc(|) SBb(|), "| |");
  v(SAc(|) SBc(|), "| |");
  v(SAc(|) SBd(|), "| |");
  v(SAc(|) SBe(|), "| |");
  v(SAc(|) SBf(|), "| |");
  v(SAc(|)EOA|, "| |");
  v(SAc(|)EOB|, "| |");
  v(SAc(|)EOC|, "| |");
  v(SAc(|)EFA()|, "| |");
  v(SAc(|)EFA()SBa(|), "| |");
  v(SAc(|)EFA()SBb(|), "| |");
  v(SAc(|)EFA()SBc(|), "| |");
  v(SAc(|)EFA()SBd(|), "| |");
  v(SAc(|)EFA()SBe(|), "| |");
  v(SAc(|)EFA()SBf(|), "| |");
  v(SAc(|)EFB()|, "| |");
  v(SAc(|)EFB()SBa(|), "| |");
  v(SAc(|)EFB()SBb(|), "| |");
  v(SAc(|)EFB()SBc(|), "| |");
  v(SAc(|)EFB()SBd(|), "| |");
  v(SAc(|)EFB()SBe(|), "| |");
  v(SAc(|)EFB()SBf(|), "| |");
  v(SAc(|)EFC()|, "| |");
  v(SAc(|)EFC()SBa(|), "| |");
  v(SAc(|)EFC()SBb(|), "| |");
  v(SAc(|)EFC()SBc(|), "| |");
  v(SAc(|)EFC()SBd(|), "| |");
  v(SAc(|)EFC()SBe(|), "| |");
  v(SAc(|)EFC()SBf(|), "| |");
  v(SAc(|) EOA|, "| |");
  v(SAc(|) EOB|, "| |");
  v(SAc(|) EOC|, "| |");
  v(SAc(|) EFA()|, "| |");
  v(SAc(|) EFA()SBa(|), "| |");
  v(SAc(|) EFA()SBb(|), "| |");
  v(SAc(|) EFA()SBc(|), "| |");
  v(SAc(|) EFA()SBd(|), "| |");
  v(SAc(|) EFA()SBe(|), "| |");
  v(SAc(|) EFA()SBf(|), "| |");
  v(SAc(|) EFB()|, "| |");
  v(SAc(|) EFB()SBa(|), "| |");
  v(SAc(|) EFB()SBb(|), "| |");
  v(SAc(|) EFB()SBc(|), "| |");
  v(SAc(|) EFB()SBd(|), "| |");
  v(SAc(|) EFB()SBe(|), "| |");
  v(SAc(|) EFB()SBf(|), "| |");
  v(SAc(|) EFC()|, "| |");
  v(SAc(|) EFC()SBa(|), "| |");
  v(SAc(|) EFC()SBb(|), "| |");
  v(SAc(|) EFC()SBc(|), "| |");
  v(SAc(|) EFC()SBd(|), "| |");
  v(SAc(|) EFC()SBe(|), "| |");
  v(SAc(|) EFC()SBf(|), "| |");
  v(SAc(|)EOA |, "| |");
  v(SAc(|)EOA SBa(|), "| |");
  v(SAc(|)EOA SBb(|), "| |");
  v(SAc(|)EOA SBc(|), "| |");
  v(SAc(|)EOA SBd(|), "| |");
  v(SAc(|)EOA SBe(|), "| |");
  v(SAc(|)EOA SBf(|), "| |");
  v(SAc(|)EOB |, "| |");
  v(SAc(|)EOB SBa(|), "| |");
  v(SAc(|)EOB SBb(|), "| |");
  v(SAc(|)EOB SBc(|), "| |");
  v(SAc(|)EOB SBd(|), "| |");
  v(SAc(|)EOB SBe(|), "| |");
  v(SAc(|)EOB SBf(|), "| |");
  v(SAc(|)EOC |, "| |");
  v(SAc(|)EOC SBa(|), "| |");
  v(SAc(|)EOC SBb(|), "| |");
  v(SAc(|)EOC SBc(|), "| |");
  v(SAc(|)EOC SBd(|), "| |");
  v(SAc(|)EOC SBe(|), "| |");
  v(SAc(|)EOC SBf(|), "| |");
  v(SAc(|)EFA() |, "| |");
  v(SAc(|)EFA() SBa(|), "| |");
  v(SAc(|)EFA() SBb(|), "| |");
  v(SAc(|)EFA() SBc(|), "| |");
  v(SAc(|)EFA() SBd(|), "| |");
  v(SAc(|)EFA() SBe(|), "| |");
  v(SAc(|)EFA() SBf(|), "| |");
  v(SAc(|)EFB() |, "| |");
  v(SAc(|)EFB() SBa(|), "| |");
  v(SAc(|)EFB() SBb(|), "| |");
  v(SAc(|)EFB() SBc(|), "| |");
  v(SAc(|)EFB() SBd(|), "| |");
  v(SAc(|)EFB() SBe(|), "| |");
  v(SAc(|)EFB() SBf(|), "| |");
  v(SAc(|)EFC() |, "| |");
  v(SAc(|)EFC() SBa(|), "| |");
  v(SAc(|)EFC() SBb(|), "| |");
  v(SAc(|)EFC() SBc(|), "| |");
  v(SAc(|)EFC() SBd(|), "| |");
  v(SAc(|)EFC() SBe(|), "| |");
  v(SAc(|)EFC() SBf(|), "| |");
  v(SAc(|) EOA |, "| |");
  v(SAc(|) EOA SBa(|), "| |");
  v(SAc(|) EOA SBb(|), "| |");
  v(SAc(|) EOA SBc(|), "| |");
  v(SAc(|) EOA SBd(|), "| |");
  v(SAc(|) EOA SBe(|), "| |");
  v(SAc(|) EOA SBf(|), "| |");
  v(SAc(|) EOB |, "| |");
  v(SAc(|) EOB SBa(|), "| |");
  v(SAc(|) EOB SBb(|), "| |");
  v(SAc(|) EOB SBc(|), "| |");
  v(SAc(|) EOB SBd(|), "| |");
  v(SAc(|) EOB SBe(|), "| |");
  v(SAc(|) EOB SBf(|), "| |");
  v(SAc(|) EOC |, "| |");
  v(SAc(|) EOC SBa(|), "| |");
  v(SAc(|) EOC SBb(|), "| |");
  v(SAc(|) EOC SBc(|), "| |");
  v(SAc(|) EOC SBd(|), "| |");
  v(SAc(|) EOC SBe(|), "| |");
  v(SAc(|) EOC SBf(|), "| |");
  v(SAc(|) EFA() |, "| |");
  v(SAc(|) EFA() SBa(|), "| |");
  v(SAc(|) EFA() SBb(|), "| |");
  v(SAc(|) EFA() SBc(|), "| |");
  v(SAc(|) EFA() SBd(|), "| |");
  v(SAc(|) EFA() SBe(|), "| |");
  v(SAc(|) EFA() SBf(|), "| |");
  v(SAc(|) EFB() |, "| |");
  v(SAc(|) EFB() SBa(|), "| |");
  v(SAc(|) EFB() SBb(|), "| |");
  v(SAc(|) EFB() SBc(|), "| |");
  v(SAc(|) EFB() SBd(|), "| |");
  v(SAc(|) EFB() SBe(|), "| |");
  v(SAc(|) EFB() SBf(|), "| |");
  v(SAc(|) EFC() |, "| |");
  v(SAc(|) EFC() SBa(|), "| |");
  v(SAc(|) EFC() SBb(|), "| |");
  v(SAc(|) EFC() SBc(|), "| |");
  v(SAc(|) EFC() SBd(|), "| |");
  v(SAc(|) EFC() SBe(|), "| |");
  v(SAc(|) EFC() SBf(|), "| |");
}

void
check5 (void)
{
  v(SAd(|)|, "| |");
  v(SAd(|)SBa(|), "| |");
  v(SAd(|)SBb(|), "| |");
  v(SAd(|)SBc(|), "| |");
  v(SAd(|)SBd(|), "| |");
  v(SAd(|)SBe(|), "| |");
  v(SAd(|)SBf(|), "| |");
  v(SAd(|) |, "| |");
  v(SAd(|) SBa(|), "| |");
  v(SAd(|) SBb(|), "| |");
  v(SAd(|) SBc(|), "| |");
  v(SAd(|) SBd(|), "| |");
  v(SAd(|) SBe(|), "| |");
  v(SAd(|) SBf(|), "| |");
  v(SAd(|)EOA|, "| |");
  v(SAd(|)EOB|, "| |");
  v(SAd(|)EOC|, "| |");
  v(SAd(|)EFA()|, "| |");
  v(SAd(|)EFA()SBa(|), "| |");
  v(SAd(|)EFA()SBb(|), "| |");
  v(SAd(|)EFA()SBc(|), "| |");
  v(SAd(|)EFA()SBd(|), "| |");
  v(SAd(|)EFA()SBe(|), "| |");
  v(SAd(|)EFA()SBf(|), "| |");
  v(SAd(|)EFB()|, "| |");
  v(SAd(|)EFB()SBa(|), "| |");
  v(SAd(|)EFB()SBb(|), "| |");
  v(SAd(|)EFB()SBc(|), "| |");
  v(SAd(|)EFB()SBd(|), "| |");
  v(SAd(|)EFB()SBe(|), "| |");
  v(SAd(|)EFB()SBf(|), "| |");
  v(SAd(|)EFC()|, "| |");
  v(SAd(|)EFC()SBa(|), "| |");
  v(SAd(|)EFC()SBb(|), "| |");
  v(SAd(|)EFC()SBc(|), "| |");
  v(SAd(|)EFC()SBd(|), "| |");
  v(SAd(|)EFC()SBe(|), "| |");
  v(SAd(|)EFC()SBf(|), "| |");
  v(SAd(|) EOA|, "| |");
  v(SAd(|) EOB|, "| |");
  v(SAd(|) EOC|, "| |");
  v(SAd(|) EFA()|, "| |");
  v(SAd(|) EFA()SBa(|), "| |");
  v(SAd(|) EFA()SBb(|), "| |");
  v(SAd(|) EFA()SBc(|), "| |");
  v(SAd(|) EFA()SBd(|), "| |");
  v(SAd(|) EFA()SBe(|), "| |");
  v(SAd(|) EFA()SBf(|), "| |");
  v(SAd(|) EFB()|, "| |");
  v(SAd(|) EFB()SBa(|), "| |");
  v(SAd(|) EFB()SBb(|), "| |");
  v(SAd(|) EFB()SBc(|), "| |");
  v(SAd(|) EFB()SBd(|), "| |");
  v(SAd(|) EFB()SBe(|), "| |");
  v(SAd(|) EFB()SBf(|), "| |");
  v(SAd(|) EFC()|, "| |");
  v(SAd(|) EFC()SBa(|), "| |");
  v(SAd(|) EFC()SBb(|), "| |");
  v(SAd(|) EFC()SBc(|), "| |");
  v(SAd(|) EFC()SBd(|), "| |");
  v(SAd(|) EFC()SBe(|), "| |");
  v(SAd(|) EFC()SBf(|), "| |");
  v(SAd(|)EOA |, "| |");
  v(SAd(|)EOA SBa(|), "| |");
  v(SAd(|)EOA SBb(|), "| |");
  v(SAd(|)EOA SBc(|), "| |");
  v(SAd(|)EOA SBd(|), "| |");
  v(SAd(|)EOA SBe(|), "| |");
  v(SAd(|)EOA SBf(|), "| |");
  v(SAd(|)EOB |, "| |");
  v(SAd(|)EOB SBa(|), "| |");
  v(SAd(|)EOB SBb(|), "| |");
  v(SAd(|)EOB SBc(|), "| |");
  v(SAd(|)EOB SBd(|), "| |");
  v(SAd(|)EOB SBe(|), "| |");
  v(SAd(|)EOB SBf(|), "| |");
  v(SAd(|)EOC |, "| |");
  v(SAd(|)EOC SBa(|), "| |");
  v(SAd(|)EOC SBb(|), "| |");
  v(SAd(|)EOC SBc(|), "| |");
  v(SAd(|)EOC SBd(|), "| |");
  v(SAd(|)EOC SBe(|), "| |");
  v(SAd(|)EOC SBf(|), "| |");
  v(SAd(|)EFA() |, "| |");
  v(SAd(|)EFA() SBa(|), "| |");
  v(SAd(|)EFA() SBb(|), "| |");
  v(SAd(|)EFA() SBc(|), "| |");
  v(SAd(|)EFA() SBd(|), "| |");
  v(SAd(|)EFA() SBe(|), "| |");
  v(SAd(|)EFA() SBf(|), "| |");
  v(SAd(|)EFB() |, "| |");
  v(SAd(|)EFB() SBa(|), "| |");
  v(SAd(|)EFB() SBb(|), "| |");
  v(SAd(|)EFB() SBc(|), "| |");
  v(SAd(|)EFB() SBd(|), "| |");
  v(SAd(|)EFB() SBe(|), "| |");
  v(SAd(|)EFB() SBf(|), "| |");
  v(SAd(|)EFC() |, "| |");
  v(SAd(|)EFC() SBa(|), "| |");
  v(SAd(|)EFC() SBb(|), "| |");
  v(SAd(|)EFC() SBc(|), "| |");
  v(SAd(|)EFC() SBd(|), "| |");
  v(SAd(|)EFC() SBe(|), "| |");
  v(SAd(|)EFC() SBf(|), "| |");
  v(SAd(|) EOA |, "| |");
  v(SAd(|) EOA SBa(|), "| |");
  v(SAd(|) EOA SBb(|), "| |");
  v(SAd(|) EOA SBc(|), "| |");
  v(SAd(|) EOA SBd(|), "| |");
  v(SAd(|) EOA SBe(|), "| |");
  v(SAd(|) EOA SBf(|), "| |");
  v(SAd(|) EOB |, "| |");
  v(SAd(|) EOB SBa(|), "| |");
  v(SAd(|) EOB SBb(|), "| |");
  v(SAd(|) EOB SBc(|), "| |");
  v(SAd(|) EOB SBd(|), "| |");
  v(SAd(|) EOB SBe(|), "| |");
  v(SAd(|) EOB SBf(|), "| |");
  v(SAd(|) EOC |, "| |");
  v(SAd(|) EOC SBa(|), "| |");
  v(SAd(|) EOC SBb(|), "| |");
  v(SAd(|) EOC SBc(|), "| |");
  v(SAd(|) EOC SBd(|), "| |");
  v(SAd(|) EOC SBe(|), "| |");
  v(SAd(|) EOC SBf(|), "| |");
  v(SAd(|) EFA() |, "| |");
  v(SAd(|) EFA() SBa(|), "| |");
  v(SAd(|) EFA() SBb(|), "| |");
  v(SAd(|) EFA() SBc(|), "| |");
  v(SAd(|) EFA() SBd(|), "| |");
  v(SAd(|) EFA() SBe(|), "| |");
  v(SAd(|) EFA() SBf(|), "| |");
  v(SAd(|) EFB() |, "| |");
  v(SAd(|) EFB() SBa(|), "| |");
  v(SAd(|) EFB() SBb(|), "| |");
  v(SAd(|) EFB() SBc(|), "| |");
  v(SAd(|) EFB() SBd(|), "| |");
  v(SAd(|) EFB() SBe(|), "| |");
  v(SAd(|) EFB() SBf(|), "| |");
  v(SAd(|) EFC() |, "| |");
  v(SAd(|) EFC() SBa(|), "| |");
  v(SAd(|) EFC() SBb(|), "| |");
  v(SAd(|) EFC() SBc(|), "| |");
  v(SAd(|) EFC() SBd(|), "| |");
  v(SAd(|) EFC() SBe(|), "| |");
  v(SAd(|) EFC() SBf(|), "| |");
}

void
check6 (void)
{
  v(SAe(|)|, "| |");
  v(SAe(|)SBa(|), "| |");
  v(SAe(|)SBb(|), "| |");
  v(SAe(|)SBc(|), "| |");
  v(SAe(|)SBd(|), "| |");
  v(SAe(|)SBe(|), "| |");
  v(SAe(|)SBf(|), "| |");
  v(SAe(|) |, "| |");
  v(SAe(|) SBa(|), "| |");
  v(SAe(|) SBb(|), "| |");
  v(SAe(|) SBc(|), "| |");
  v(SAe(|) SBd(|), "| |");
  v(SAe(|) SBe(|), "| |");
  v(SAe(|) SBf(|), "| |");
  v(SAe(|)EOA|, "| |");
  v(SAe(|)EOB|, "| |");
  v(SAe(|)EOC|, "| |");
  v(SAe(|)EFA()|, "| |");
  v(SAe(|)EFA()SBa(|), "| |");
  v(SAe(|)EFA()SBb(|), "| |");
  v(SAe(|)EFA()SBc(|), "| |");
  v(SAe(|)EFA()SBd(|), "| |");
  v(SAe(|)EFA()SBe(|), "| |");
  v(SAe(|)EFA()SBf(|), "| |");
  v(SAe(|)EFB()|, "| |");
  v(SAe(|)EFB()SBa(|), "| |");
  v(SAe(|)EFB()SBb(|), "| |");
  v(SAe(|)EFB()SBc(|), "| |");
  v(SAe(|)EFB()SBd(|), "| |");
  v(SAe(|)EFB()SBe(|), "| |");
  v(SAe(|)EFB()SBf(|), "| |");
  v(SAe(|)EFC()|, "| |");
  v(SAe(|)EFC()SBa(|), "| |");
  v(SAe(|)EFC()SBb(|), "| |");
  v(SAe(|)EFC()SBc(|), "| |");
  v(SAe(|)EFC()SBd(|), "| |");
  v(SAe(|)EFC()SBe(|), "| |");
  v(SAe(|)EFC()SBf(|), "| |");
  v(SAe(|) EOA|, "| |");
  v(SAe(|) EOB|, "| |");
  v(SAe(|) EOC|, "| |");
  v(SAe(|) EFA()|, "| |");
  v(SAe(|) EFA()SBa(|), "| |");
  v(SAe(|) EFA()SBb(|), "| |");
  v(SAe(|) EFA()SBc(|), "| |");
  v(SAe(|) EFA()SBd(|), "| |");
  v(SAe(|) EFA()SBe(|), "| |");
  v(SAe(|) EFA()SBf(|), "| |");
  v(SAe(|) EFB()|, "| |");
  v(SAe(|) EFB()SBa(|), "| |");
  v(SAe(|) EFB()SBb(|), "| |");
  v(SAe(|) EFB()SBc(|), "| |");
  v(SAe(|) EFB()SBd(|), "| |");
  v(SAe(|) EFB()SBe(|), "| |");
  v(SAe(|) EFB()SBf(|), "| |");
  v(SAe(|) EFC()|, "| |");
  v(SAe(|) EFC()SBa(|), "| |");
  v(SAe(|) EFC()SBb(|), "| |");
  v(SAe(|) EFC()SBc(|), "| |");
  v(SAe(|) EFC()SBd(|), "| |");
  v(SAe(|) EFC()SBe(|), "| |");
  v(SAe(|) EFC()SBf(|), "| |");
  v(SAe(|)EOA |, "| |");
  v(SAe(|)EOA SBa(|), "| |");
  v(SAe(|)EOA SBb(|), "| |");
  v(SAe(|)EOA SBc(|), "| |");
  v(SAe(|)EOA SBd(|), "| |");
  v(SAe(|)EOA SBe(|), "| |");
  v(SAe(|)EOA SBf(|), "| |");
  v(SAe(|)EOB |, "| |");
  v(SAe(|)EOB SBa(|), "| |");
  v(SAe(|)EOB SBb(|), "| |");
  v(SAe(|)EOB SBc(|), "| |");
  v(SAe(|)EOB SBd(|), "| |");
  v(SAe(|)EOB SBe(|), "| |");
  v(SAe(|)EOB SBf(|), "| |");
  v(SAe(|)EOC |, "| |");
  v(SAe(|)EOC SBa(|), "| |");
  v(SAe(|)EOC SBb(|), "| |");
  v(SAe(|)EOC SBc(|), "| |");
  v(SAe(|)EOC SBd(|), "| |");
  v(SAe(|)EOC SBe(|), "| |");
  v(SAe(|)EOC SBf(|), "| |");
  v(SAe(|)EFA() |, "| |");
  v(SAe(|)EFA() SBa(|), "| |");
  v(SAe(|)EFA() SBb(|), "| |");
  v(SAe(|)EFA() SBc(|), "| |");
  v(SAe(|)EFA() SBd(|), "| |");
  v(SAe(|)EFA() SBe(|), "| |");
  v(SAe(|)EFA() SBf(|), "| |");
  v(SAe(|)EFB() |, "| |");
  v(SAe(|)EFB() SBa(|), "| |");
  v(SAe(|)EFB() SBb(|), "| |");
  v(SAe(|)EFB() SBc(|), "| |");
  v(SAe(|)EFB() SBd(|), "| |");
  v(SAe(|)EFB() SBe(|), "| |");
  v(SAe(|)EFB() SBf(|), "| |");
  v(SAe(|)EFC() |, "| |");
  v(SAe(|)EFC() SBa(|), "| |");
  v(SAe(|)EFC() SBb(|), "| |");
  v(SAe(|)EFC() SBc(|), "| |");
  v(SAe(|)EFC() SBd(|), "| |");
  v(SAe(|)EFC() SBe(|), "| |");
  v(SAe(|)EFC() SBf(|), "| |");
  v(SAe(|) EOA |, "| |");
  v(SAe(|) EOA SBa(|), "| |");
  v(SAe(|) EOA SBb(|), "| |");
  v(SAe(|) EOA SBc(|), "| |");
  v(SAe(|) EOA SBd(|), "| |");
  v(SAe(|) EOA SBe(|), "| |");
  v(SAe(|) EOA SBf(|), "| |");
  v(SAe(|) EOB |, "| |");
  v(SAe(|) EOB SBa(|), "| |");
  v(SAe(|) EOB SBb(|), "| |");
  v(SAe(|) EOB SBc(|), "| |");
  v(SAe(|) EOB SBd(|), "| |");
  v(SAe(|) EOB SBe(|), "| |");
  v(SAe(|) EOB SBf(|), "| |");
  v(SAe(|) EOC |, "| |");
  v(SAe(|) EOC SBa(|), "| |");
  v(SAe(|) EOC SBb(|), "| |");
  v(SAe(|) EOC SBc(|), "| |");
  v(SAe(|) EOC SBd(|), "| |");
  v(SAe(|) EOC SBe(|), "| |");
  v(SAe(|) EOC SBf(|), "| |");
  v(SAe(|) EFA() |, "| |");
  v(SAe(|) EFA() SBa(|), "| |");
  v(SAe(|) EFA() SBb(|), "| |");
  v(SAe(|) EFA() SBc(|), "| |");
  v(SAe(|) EFA() SBd(|), "| |");
  v(SAe(|) EFA() SBe(|), "| |");
  v(SAe(|) EFA() SBf(|), "| |");
  v(SAe(|) EFB() |, "| |");
  v(SAe(|) EFB() SBa(|), "| |");
  v(SAe(|) EFB() SBb(|), "| |");
  v(SAe(|) EFB() SBc(|), "| |");
  v(SAe(|) EFB() SBd(|), "| |");
  v(SAe(|) EFB() SBe(|), "| |");
  v(SAe(|) EFB() SBf(|), "| |");
  v(SAe(|) EFC() |, "| |");
  v(SAe(|) EFC() SBa(|), "| |");
  v(SAe(|) EFC() SBb(|), "| |");
  v(SAe(|) EFC() SBc(|), "| |");
  v(SAe(|) EFC() SBd(|), "| |");
  v(SAe(|) EFC() SBe(|), "| |");
  v(SAe(|) EFC() SBf(|), "| |");
}

void
check7 (void)
{
  v(SAf(|)|, "| |");
  v(SAf(|)SBa(|), "| |");
  v(SAf(|)SBb(|), "| |");
  v(SAf(|)SBc(|), "| |");
  v(SAf(|)SBd(|), "| |");
  v(SAf(|)SBe(|), "| |");
  v(SAf(|)SBf(|), "| |");
  v(SAf(|) |, "| |");
  v(SAf(|) SBa(|), "| |");
  v(SAf(|) SBb(|), "| |");
  v(SAf(|) SBc(|), "| |");
  v(SAf(|) SBd(|), "| |");
  v(SAf(|) SBe(|), "| |");
  v(SAf(|) SBf(|), "| |");
  v(SAf(|)EOA|, "| |");
  v(SAf(|)EOB|, "| |");
  v(SAf(|)EOC|, "| |");
  v(SAf(|)EFA()|, "| |");
  v(SAf(|)EFA()SBa(|), "| |");
  v(SAf(|)EFA()SBb(|), "| |");
  v(SAf(|)EFA()SBc(|), "| |");
  v(SAf(|)EFA()SBd(|), "| |");
  v(SAf(|)EFA()SBe(|), "| |");
  v(SAf(|)EFA()SBf(|), "| |");
  v(SAf(|)EFB()|, "| |");
  v(SAf(|)EFB()SBa(|), "| |");
  v(SAf(|)EFB()SBb(|), "| |");
  v(SAf(|)EFB()SBc(|), "| |");
  v(SAf(|)EFB()SBd(|), "| |");
  v(SAf(|)EFB()SBe(|), "| |");
  v(SAf(|)EFB()SBf(|), "| |");
  v(SAf(|)EFC()|, "| |");
  v(SAf(|)EFC()SBa(|), "| |");
  v(SAf(|)EFC()SBb(|), "| |");
  v(SAf(|)EFC()SBc(|), "| |");
  v(SAf(|)EFC()SBd(|), "| |");
  v(SAf(|)EFC()SBe(|), "| |");
  v(SAf(|)EFC()SBf(|), "| |");
  v(SAf(|) EOA|, "| |");
  v(SAf(|) EOB|, "| |");
  v(SAf(|) EOC|, "| |");
  v(SAf(|) EFA()|, "| |");
  v(SAf(|) EFA()SBa(|), "| |");
  v(SAf(|) EFA()SBb(|), "| |");
  v(SAf(|) EFA()SBc(|), "| |");
  v(SAf(|) EFA()SBd(|), "| |");
  v(SAf(|) EFA()SBe(|), "| |");
  v(SAf(|) EFA()SBf(|), "| |");
  v(SAf(|) EFB()|, "| |");
  v(SAf(|) EFB()SBa(|), "| |");
  v(SAf(|) EFB()SBb(|), "| |");
  v(SAf(|) EFB()SBc(|), "| |");
  v(SAf(|) EFB()SBd(|), "| |");
  v(SAf(|) EFB()SBe(|), "| |");
  v(SAf(|) EFB()SBf(|), "| |");
  v(SAf(|) EFC()|, "| |");
  v(SAf(|) EFC()SBa(|), "| |");
  v(SAf(|) EFC()SBb(|), "| |");
  v(SAf(|) EFC()SBc(|), "| |");
  v(SAf(|) EFC()SBd(|), "| |");
  v(SAf(|) EFC()SBe(|), "| |");
  v(SAf(|) EFC()SBf(|), "| |");
  v(SAf(|)EOA |, "| |");
  v(SAf(|)EOA SBa(|), "| |");
  v(SAf(|)EOA SBb(|), "| |");
  v(SAf(|)EOA SBc(|), "| |");
  v(SAf(|)EOA SBd(|), "| |");
  v(SAf(|)EOA SBe(|), "| |");
  v(SAf(|)EOA SBf(|), "| |");
  v(SAf(|)EOB |, "| |");
  v(SAf(|)EOB SBa(|), "| |");
  v(SAf(|)EOB SBb(|), "| |");
  v(SAf(|)EOB SBc(|), "| |");
  v(SAf(|)EOB SBd(|), "| |");
  v(SAf(|)EOB SBe(|), "| |");
  v(SAf(|)EOB SBf(|), "| |");
  v(SAf(|)EOC |, "| |");
  v(SAf(|)EOC SBa(|), "| |");
  v(SAf(|)EOC SBb(|), "| |");
  v(SAf(|)EOC SBc(|), "| |");
  v(SAf(|)EOC SBd(|), "| |");
  v(SAf(|)EOC SBe(|), "| |");
  v(SAf(|)EOC SBf(|), "| |");
  v(SAf(|)EFA() |, "| |");
  v(SAf(|)EFA() SBa(|), "| |");
  v(SAf(|)EFA() SBb(|), "| |");
  v(SAf(|)EFA() SBc(|), "| |");
  v(SAf(|)EFA() SBd(|), "| |");
  v(SAf(|)EFA() SBe(|), "| |");
  v(SAf(|)EFA() SBf(|), "| |");
  v(SAf(|)EFB() |, "| |");
  v(SAf(|)EFB() SBa(|), "| |");
  v(SAf(|)EFB() SBb(|), "| |");
  v(SAf(|)EFB() SBc(|), "| |");
  v(SAf(|)EFB() SBd(|), "| |");
  v(SAf(|)EFB() SBe(|), "| |");
  v(SAf(|)EFB() SBf(|), "| |");
  v(SAf(|)EFC() |, "| |");
  v(SAf(|)EFC() SBa(|), "| |");
  v(SAf(|)EFC() SBb(|), "| |");
  v(SAf(|)EFC() SBc(|), "| |");
  v(SAf(|)EFC() SBd(|), "| |");
  v(SAf(|)EFC() SBe(|), "| |");
  v(SAf(|)EFC() SBf(|), "| |");
  v(SAf(|) EOA |, "| |");
  v(SAf(|) EOA SBa(|), "| |");
  v(SAf(|) EOA SBb(|), "| |");
  v(SAf(|) EOA SBc(|), "| |");
  v(SAf(|) EOA SBd(|), "| |");
  v(SAf(|) EOA SBe(|), "| |");
  v(SAf(|) EOA SBf(|), "| |");
  v(SAf(|) EOB |, "| |");
  v(SAf(|) EOB SBa(|), "| |");
  v(SAf(|) EOB SBb(|), "| |");
  v(SAf(|) EOB SBc(|), "| |");
  v(SAf(|) EOB SBd(|), "| |");
  v(SAf(|) EOB SBe(|), "| |");
  v(SAf(|) EOB SBf(|), "| |");
  v(SAf(|) EOC |, "| |");
  v(SAf(|) EOC SBa(|), "| |");
  v(SAf(|) EOC SBb(|), "| |");
  v(SAf(|) EOC SBc(|), "| |");
  v(SAf(|) EOC SBd(|), "| |");
  v(SAf(|) EOC SBe(|), "| |");
  v(SAf(|) EOC SBf(|), "| |");
  v(SAf(|) EFA() |, "| |");
  v(SAf(|) EFA() SBa(|), "| |");
  v(SAf(|) EFA() SBb(|), "| |");
  v(SAf(|) EFA() SBc(|), "| |");
  v(SAf(|) EFA() SBd(|), "| |");
  v(SAf(|) EFA() SBe(|), "| |");
  v(SAf(|) EFA() SBf(|), "| |");
  v(SAf(|) EFB() |, "| |");
  v(SAf(|) EFB() SBa(|), "| |");
  v(SAf(|) EFB() SBb(|), "| |");
  v(SAf(|) EFB() SBc(|), "| |");
  v(SAf(|) EFB() SBd(|), "| |");
  v(SAf(|) EFB() SBe(|), "| |");
  v(SAf(|) EFB() SBf(|), "| |");
  v(SAf(|) EFC() |, "| |");
  v(SAf(|) EFC() SBa(|), "| |");
  v(SAf(|) EFC() SBb(|), "| |");
  v(SAf(|) EFC() SBc(|), "| |");
  v(SAf(|) EFC() SBd(|), "| |");
  v(SAf(|) EFC() SBe(|), "| |");
  v(SAf(|) EFC() SBf(|), "| |");
}

int
main (void)
{
  check0 ();
  check1 ();
  check2 ();
  check3 ();
  check4 ();
  check5 ();
  check6 ();
  check7 ();
  exit (0);
}
