/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.drc.CellLayersContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CheckCellLayerEnumerator
extends HierarchyEnumerator.Visitor {
    private Map<Cell, Cell> cellsMap = new HashMap<Cell, Cell>();
    private CellLayersContainer cellLayersCon;

    CheckCellLayerEnumerator(CellLayersContainer cellLayersC) {
        this.cellLayersCon = cellLayersC;
    }

    private boolean skipCell(Cell cell) {
        return this.cellsMap.get(cell) != null;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.skipCell(cell)) {
            return false;
        }
        this.cellsMap.put(cell, cell);
        return true;
    }

    private Set<Layer> getLayersInCell(Cell cell) {
        HashMap<NodeProto, NodeProto> tempNodeMap = new HashMap<NodeProto, NodeProto>();
        HashMap<ArcProto, ArcProto> tempArcMap = new HashMap<ArcProto, ArcProto>();
        HashSet<Layer> set = new HashSet<Layer>();
        Technology tech = cell.getTechnology();
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                Cell c = (Cell)np;
                if (!c.isLayout()) continue;
                Technology.NodeLayer[] s = this.cellLayersCon.getLayersSet(np);
                assert (s != null);
                set.addAll((Collection<Layer>)s);
                continue;
            }
            if (tempNodeMap.get(np) != null) continue;
            tempNodeMap.put(np, np);
            if (NodeInst.isSpecialNode(ni)) continue;
            PrimitiveNode pNp = (PrimitiveNode)np;
            for (Technology.NodeLayer nLayer : pNp.getNodeLayers()) {
                Layer layer = nLayer.getLayer();
                if (tech.findLayer(layer.getName()) == null) continue;
                set.add(layer);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ArcProto ap = ai.getProto();
            if (tempArcMap.get(ap) != null) continue;
            tempArcMap.put(ap, ap);
            for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                Layer layer = ap.getLayer(i);
                if (tech.findLayer(layer.getName()) == null) continue;
                set.add(layer);
            }
        }
        return set;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        Set<Layer> set = this.getLayersInCell(cell);
        assert (this.cellLayersCon.getLayersSet(cell) == null);
        this.cellLayersCon.addCellLayers(cell, set);
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        NodeInst ni = no.getNodeInst();
        return ni.isCellInstance();
    }
}

