/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.plugins.j3d.JMouseRotate;
import com.sun.electric.plugins.j3d.JMouseTranslate;
import com.sun.electric.plugins.j3d.JMouseZoom;
import com.sun.electric.plugins.j3d.ui.JThreeDTab;
import com.sun.electric.plugins.j3d.utils.J3DAppearance;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.MutableDouble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.picking.PickCanvas;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.java3d.utils.universe.PlatformGeometry;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.Vector3d;

public class JThreeDSideView
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static Layer currentLayerSelected = null;
    private HashMap<Layer, Shape3DTab> layerPolyhedra = null;
    double lowHeight = Double.MAX_VALUE;
    double highHeight = Double.MIN_VALUE;
    private PickCanvas pickCanvas;
    private JThreeDTab parentDialog;

    private static GraphicsConfiguration getBestConfigurationOnSameDevice(Frame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsConfiguration good = null;
        GraphicsConfigTemplate3D gct = new GraphicsConfigTemplate3D();
        for (GraphicsDevice gd : gs) {
            if (gd == gc.getDevice() && (good = gct.getBestConfiguration(gd.getConfigurations())) != null) break;
        }
        return good;
    }

    public JThreeDSideView(JThreeDTab dialog) {
        this.parentDialog = dialog;
        GraphicsConfiguration config = JThreeDSideView.getBestConfigurationOnSameDevice(TopLevel.getCurrentJFrame());
        this.setLayout(new BorderLayout());
        Canvas3D canvas = new Canvas3D(config);
        this.add("Center", (Component)canvas);
        canvas.addMouseListener((MouseListener)this);
        J3DAppearance.setHighlightedAppearanceValues(this);
        J3DAppearance.setCellAppearanceValues(this);
        J3DAppearance.setAxisAppearanceValues(this);
        BranchGroup scene = this.createSceneGraph(canvas, J3DUtils.infiniteBounds);
        ViewingPlatform viewP = new ViewingPlatform(4);
        viewP.setCapability(12);
        Viewer viewer = new Viewer(canvas);
        SimpleUniverse u = new SimpleUniverse(viewP, viewer);
        u.addBranchGraph(scene);
        PlatformGeometry pg = new PlatformGeometry();
        J3DUtils.createLights((BranchGroup)pg);
        viewP.setPlatformGeometry(pg);
        JMouseRotate rotate = new JMouseRotate(2);
        rotate.setTransformGroup(u.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0));
        BranchGroup rotateBG = new BranchGroup();
        rotateBG.addChild((Node)rotate);
        u.getViewingPlatform().addChild((Node)rotateBG);
        rotate.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        JMouseZoom zoom = new JMouseZoom((Component)canvas, 2);
        zoom.setTransformGroup(u.getViewingPlatform().getMultiTransformGroup().getTransformGroup(1));
        zoom.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        zoom.setFactor(0.7);
        BranchGroup zoomBG = new BranchGroup();
        zoomBG.addChild((Node)zoom);
        u.getViewingPlatform().addChild((Node)zoomBG);
        JMouseTranslate translate = new JMouseTranslate((Component)canvas, 2);
        translate.setTransformGroup(u.getViewingPlatform().getMultiTransformGroup().getTransformGroup(2));
        translate.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        translate.setFactor(0.01 * (this.highHeight - this.lowHeight));
        BranchGroup translateBG = new BranchGroup();
        translateBG.addChild((Node)translate);
        u.getViewingPlatform().addChild((Node)translateBG);
        u.getViewingPlatform().setNominalViewingTransform();
        J3DUtils.setViewPoint(u, canvas, scene, new Rectangle2D.Double(0.0, 0.0, 10.0, 20.0));
        rotate.setRotation(-1.57, 0.5, 0.0);
        zoom.setZoom(0.5);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas, BoundingSphere infiniteBounds) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(3);
        objRoot.setCapability(1);
        objRoot.setCapability(4);
        Background bg = new Background(J3DUtils.makeColor3f(User.ColorPrefType.BACKGROUND.getFactoryDefaultColor()));
        bg.setApplicationBounds((Bounds)infiniteBounds);
        objRoot.addChild((Node)bg);
        Transform3D t = new Transform3D();
        t.set(1.0, new Vector3d(0.0, -10.0, -40.0));
        TransformGroup objTrans = new TransformGroup(t);
        objRoot.addChild((Node)objTrans);
        TransformGroup nodesGroup = new TransformGroup();
        nodesGroup.setCapability(18);
        nodesGroup.setCapability(17);
        nodesGroup.setCapability(1);
        objTrans.addChild((Node)nodesGroup);
        this.layerPolyhedra = new HashMap(this.parentDialog.getTech().getNumLayers());
        Iterator<Layer> it = this.parentDialog.getTech().getLayers();
        while (it.hasNext()) {
            double max;
            Layer layer = it.next();
            double xyFactor = layer.getFunctionExtras() == 16384 ? 0.8 : 1.0;
            J3DAppearance ap = this.parentDialog.transparencyMap.get(layer);
            MutableDouble thickness = this.parentDialog.threeDThicknessMap.get(layer);
            MutableDouble distance = this.parentDialog.threeDDistanceMap.get(layer);
            double dis = distance.doubleValue();
            double thick = thickness.doubleValue();
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, 10.0 * xyFactor, 20.0 * xyFactor);
            Shape3DTab shape = new Shape3DTab(J3DUtils.addPolyhedron(bounds, dis, thick, (Appearance)ap, nodesGroup), dis, thick);
            this.layerPolyhedra.put(layer, shape);
            if (dis < this.lowHeight) {
                this.lowHeight = dis;
            }
            if (!((max = dis + thick) > this.highHeight)) continue;
            this.highHeight = max;
        }
        this.pickCanvas = new PickCanvas(canvas, objRoot);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(4.0f);
        objRoot.compile();
        return objRoot;
    }

    public void showLayer(Layer layer) {
        Shape3DTab shape;
        if (currentLayerSelected != null && (shape = this.layerPolyhedra.get(currentLayerSelected)) != null) {
            shape.shape.setAppearance((Appearance)this.parentDialog.transparencyMap.get(currentLayerSelected));
        }
        if ((shape = this.layerPolyhedra.get(layer)) != null) {
            shape.shape.setAppearance((Appearance)J3DAppearance.highlightApp);
        } else {
            System.out.println("Shape is null in JThreeDSideView.showLayer");
        }
        currentLayerSelected = layer;
    }

    public void updateZValues(Layer layer, double thickness, double distance) {
        Shape3DTab shape = this.layerPolyhedra.get(layer);
        if (J3DUtils.updateZValues(shape.shape, (float)shape.origDist, (float)(shape.origDist + shape.origThick), (float)distance, (float)(distance + thickness))) {
            shape.origDist = distance;
            shape.origThick = thickness;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        J3DAppearance app;
        Shape3D s;
        this.pickCanvas.setShapeLocation(evt);
        PickResult result = this.pickCanvas.pickClosest();
        if (result != null && (s = (Shape3D)result.getNode(1)) != null && (app = (J3DAppearance)s.getAppearance()) != J3DAppearance.highlightApp) {
            Layer layer = app.getLayer();
            this.parentDialog.threeDLayerList.setSelectedValue(layer.getName(), false);
            this.parentDialog.processDataInFields(layer, false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    private static class Shape3DTab {
        Shape3D shape;
        double origDist;
        double origThick;

        Shape3DTab(Shape3D s, double dist, double thick) {
            this.shape = s;
            this.origDist = dist;
            this.origThick = thick;
        }
    }
}

