/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.TimedSignal;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analysis {
    public static final AnalysisType ANALYSIS_SIGNALS = new AnalysisType("Signals");
    public static final AnalysisType ANALYSIS_TRANS = new AnalysisType("Transient");
    public static final AnalysisType ANALYSIS_AC = new AnalysisType("AC");
    public static final AnalysisType ANALYSIS_DC = new AnalysisType("DC");
    public static final AnalysisType ANALYSIS_MEAS = new AnalysisType("Measurement");
    private Stimuli sd;
    private AnalysisType type;
    private List<Signal> signals;
    private HashMap<String, Signal> signalNames;
    private List<Signal> allBussedSignals;
    private List<Object> sweeps;
    private double[] commonTime;
    private List<double[]> sweepCommonTime;
    private Rectangle2D bounds;

    public Analysis(Stimuli sd, AnalysisType type) {
        this.sd = sd;
        this.type = type;
        this.signals = new ArrayList<Signal>();
        this.signalNames = new HashMap();
        this.allBussedSignals = new ArrayList<Signal>();
        if (type != ANALYSIS_MEAS) {
            this.sweeps = new ArrayList<Object>();
            this.sweepCommonTime = new ArrayList<double[]>();
        }
        sd.addAnalysis(this);
    }

    public void finished() {
        for (Signal s : this.signals) {
            s.finished();
        }
        this.signals.clear();
        for (Signal s : this.allBussedSignals) {
            s.finished();
        }
        if (this.sweeps != null) {
            this.sweeps.clear();
        }
        if (this.sweepCommonTime != null) {
            this.sweepCommonTime.clear();
        }
        this.signalNames.clear();
    }

    public Stimuli getStimuli() {
        return this.sd;
    }

    public AnalysisType getAnalysisType() {
        return this.type;
    }

    public List<Signal> getSignals() {
        return this.signals;
    }

    public List<Signal> getBussedSignals() {
        return this.allBussedSignals;
    }

    public void nameSignal(Signal ws, String sigName) {
        String name = TextUtils.canonicString(sigName);
        this.signalNames.put(name, ws);
        if (name.indexOf(95) >= 0 && !name.endsWith("_")) {
            this.signalNames.put(name + "_", ws);
        }
    }

    public void addSignal(Signal ws) {
        this.signals.add(ws);
        String sigName = ws.getFullName();
        if (sigName != null) {
            this.nameSignal(ws, sigName);
        }
        this.setBoundsDirty();
    }

    public void buildCommonTime(int numEvents) {
        this.commonTime = new double[numEvents];
    }

    public void addCommonTime(int numEvents) {
        double[] sct = new double[numEvents];
        this.sweepCommonTime.add(sct);
        this.setBoundsDirty();
    }

    public void setCommonTime(int index, double time) {
        this.commonTime[index] = time;
        this.setBoundsDirty();
    }

    public double[] getCommonTimeArray() {
        return this.commonTime;
    }

    public void setCommonTime(int index, int sweep, double time) {
        double[] sct = this.sweepCommonTime.get(sweep);
        sct[index] = time;
        this.setBoundsDirty();
    }

    public double[] getCommonTimeArray(int sweep) {
        return this.sweepCommonTime.get(sweep);
    }

    public void addSweep(Object obj) {
        this.sweeps.add(obj);
        this.setBoundsDirty();
    }

    public int getNumSweeps() {
        return this.sweeps != null ? this.sweeps.size() : 0;
    }

    public Object getSweep(int i) {
        if (this.sweeps == null || this.sweeps.size() == 0) {
            return null;
        }
        return this.sweeps.get(i);
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = null;
            for (Signal sig : this.signals) {
                Rectangle2D sigBounds = sig.getBounds();
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Double(sigBounds.getMinX(), sigBounds.getMinY(), sigBounds.getWidth(), sigBounds.getHeight());
                    continue;
                }
                Rectangle2D.union(this.bounds, sigBounds, this.bounds);
            }
        }
        return this.bounds;
    }

    public void setBoundsDirty() {
        this.bounds = null;
    }

    public boolean isAnalog() {
        TimedSignal sSig;
        return this.getSignals().size() > 0 && (sSig = (TimedSignal)this.getSignals().get(0)) instanceof AnalogSignal;
    }

    public Signal findSignalForNetworkQuickly(String netName) {
        String lookupName = TextUtils.canonicString(netName);
        Signal sSig = this.signalNames.get(lookupName);
        return sSig;
    }

    public Signal findSignalForNetwork(String netName) {
        for (Signal sSig : this.getSignals()) {
            String signalName = sSig.getFullName();
            if (netName.equalsIgnoreCase(signalName)) {
                return sSig;
            }
            if (signalName.length() + 1 == netName.length() && netName.charAt(signalName.length()) == ']') {
                signalName = signalName + "_";
            }
            if (signalName.length() != netName.length() || signalName.indexOf(95) < 0) continue;
            boolean matches = true;
            for (int i = 0; i < signalName.length(); ++i) {
                char sigChar = signalName.charAt(i);
                char netChar = netName.charAt(i);
                if (TextUtils.isLetterOrDigit(sigChar) != TextUtils.isLetterOrDigit(netChar)) {
                    matches = false;
                    break;
                }
                if (!TextUtils.isLetterOrDigit(sigChar) || TextUtils.canonicChar(sigChar) == TextUtils.canonicChar(netChar)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return sSig;
        }
        return null;
    }

    public static class AnalysisType {
        private String name;
        private static List<AnalysisType> allTypes = new ArrayList<AnalysisType>();

        AnalysisType(String name) {
            this.name = name;
            allTypes.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static AnalysisType findAnalysisType(String analysisName) {
            for (AnalysisType at : allTypes) {
                if (!at.name.equals(analysisName)) continue;
                return at;
            }
            return null;
        }
    }
}

