/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetlistImpl;
import com.sun.electric.database.network.NetlistShorted;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetCell {
    static final int VALID = 1;
    static final int LOCALVALID = 2;
    static final char PORT_SEPARATOR = '.';
    final NetworkManager networkManager;
    final Cell cell;
    int flags;
    int modCount = 0;
    int[] equivPortsN;
    int[] equivPortsP;
    int[] equivPortsA;
    int[] ni_pi;
    int arcsOffset;
    private int[] headConn;
    private int[] tailConn;
    int[] drawns;
    int numDrawns;
    int numExportedDrawns;
    int numConnectedDrawns;
    HashMap<Name, GenMath.MutableInteger> netNames = new HashMap();
    private int netNameCount;
    int exportedNetNameCount;
    NetlistImpl netlistN;
    NetlistShorted netlistP;
    NetlistShorted netlistA;
    private static PortProto busPinPort = Schematics.tech.busPinNode.getPort(0);
    private static ArcProto busArc = Schematics.tech.bus_arc;
    private ArrayList<PortInst> stack;

    NetCell(Cell cell) {
        this.networkManager = cell.getDatabase().getNetworkManager();
        this.cell = cell;
        this.networkManager.setCell(cell, this);
    }

    final void setNetworksDirty() {
        this.setInvalid(true, false);
    }

    void exportsChanged() {
        this.setInvalid(true, true);
    }

    void setInvalid(boolean strongMe, boolean strongUsages) {
        if (strongMe) {
            this.flags &= 0xFFFFFFFD;
        }
        if ((this.flags & 1) == 0 && !strongUsages) {
            return;
        }
        this.flags &= 0xFFFFFFFE;
        this.invalidateUsagesOf(strongUsages);
    }

    void invalidateUsagesOf(boolean strong) {
        Iterator<CellUsage> it = this.cell.getUsagesOf();
        while (it.hasNext()) {
            NetCell netCell;
            CellUsage u = it.next();
            Cell parent = u.getParent();
            if (this.cell.isIconOf(parent) || (netCell = this.networkManager.getNetCell(parent)) == null) continue;
            netCell.setInvalid(strong, false);
        }
    }

    Netlist getNetlist(Netlist.ShortResistors shortResistors) {
        if ((this.flags & 1) == 0) {
            this.redoNetworks();
        }
        switch (shortResistors) {
            case NO: {
                return this.netlistN;
            }
            case PARASITIC: {
                return this.netlistP;
            }
            case ALL: {
                return this.netlistA;
            }
        }
        throw new AssertionError();
    }

    Iterator<Nodable> getNodables() {
        return this.cell.getNodables();
    }

    Global.Set getGlobals() {
        return Global.Set.empty;
    }

    int getNetMapOffset(Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        NodeInst ni = (NodeInst)no;
        return this.drawns[this.ni_pi[ni.getNodeIndex()] + portProto.getPortIndex()];
    }

    int getBusWidth(Nodable no, PortProto portProto) {
        return 1;
    }

    int getNetMapOffset(Export export, int busIndex) {
        return this.drawns[export.getPortIndex()];
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        return this.drawns[this.arcsOffset + ai.getArcIndex()];
    }

    Name getBusName(ArcInst ai) {
        return null;
    }

    public int getBusWidth(ArcInst ai) {
        int drawn = this.drawns[this.arcsOffset + ai.getArcIndex()];
        if (drawn < 0) {
            return 0;
        }
        return 1;
    }

    private void initConnections() {
        int i;
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        if (this.ni_pi == null || this.ni_pi.length != numNodes) {
            this.ni_pi = new int[numNodes];
        }
        int offset = numPorts;
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            this.ni_pi[i] = offset;
            offset += ni.getProto().getNumPorts();
        }
        this.arcsOffset = offset;
        if (this.headConn == null || this.headConn.length != (offset += numArcs)) {
            this.headConn = new int[offset];
            this.tailConn = new int[offset];
            this.drawns = new int[offset];
        }
        for (i = numPorts; i < this.arcsOffset; ++i) {
            this.headConn[i] = i;
            this.tailConn[i] = i;
        }
        for (i = 0; i < numPorts; ++i) {
            int portOffset = i;
            Export export = this.cell.getPort(i);
            int orig = this.getPortInstOffset(export.getOriginalPort());
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        for (i = 0; i < this.cell.getNumArcs(); ++i) {
            ArcInst ai = this.cell.getArc(i);
            int arcOffset = this.arcsOffset + i;
            int head = this.getPortInstOffset(ai.getHeadPortInst());
            this.headConn[arcOffset] = this.headConn[head];
            this.headConn[head] = arcOffset;
            int tail = this.getPortInstOffset(ai.getTailPortInst());
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ArcInst ai;
        int piOffset = this.getPortInstOffset(pi);
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        PortProto pp = pi.getPortProto();
        if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        if (NetworkTool.debug) {
            System.out.println(this.numDrawns + ": " + pi);
        }
        int k = piOffset;
        while (this.headConn[k] != piOffset) {
            PortInst tpi;
            if (this.drawns[k = this.headConn[k]] >= 0) continue;
            if (k < this.arcsOffset) {
                this.drawns[k] = this.numDrawns;
                if (!NetworkTool.debug) continue;
                System.out.println(this.numDrawns + ": " + this.cell.getPort(k));
                continue;
            }
            ai = this.cell.getArc(k - this.arcsOffset);
            ap = ai.getProto();
            if (ap.getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(tpi);
        }
        k = piOffset;
        while (this.tailConn[k] != piOffset) {
            PortInst hpi;
            if (this.drawns[k = this.tailConn[k]] >= 0 || (ap = (ai = this.cell.getArc(k - this.arcsOffset)).getProto()).getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        assert (this.stack.isEmpty());
        this.stack.add(pi);
        while (!this.stack.isEmpty()) {
            pi = this.stack.remove(this.stack.size() - 1);
            PortProto pp = pi.getPortProto();
            NodeProto np = pp.getParent();
            int numPorts = np.getNumPorts();
            if (numPorts == 1 || np instanceof Cell) {
                this.addToDrawn1(pi);
                continue;
            }
            NodeInst ni = pi.getNodeInst();
            int topology = ((PrimitivePort)pp).getTopology();
            for (int i = 0; i < numPorts; ++i) {
                if (((PrimitivePort)np.getPort(i)).getTopology() != topology) continue;
                this.addToDrawn1(ni.getPortInst(i));
            }
        }
    }

    void makeDrawns() {
        int i;
        this.initConnections();
        Arrays.fill(this.drawns, -1);
        this.stack = new ArrayList();
        this.numDrawns = 0;
        int numPorts = this.cell.getNumPorts();
        for (i = 0; i < numPorts; ++i) {
            if (this.drawns[i] >= 0) continue;
            this.drawns[i] = this.numDrawns++;
            Export export = this.cell.getPort(i);
            this.addToDrawn(export.getOriginalPort());
        }
        this.numExportedDrawns = this.numDrawns;
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            PortInst tpi;
            PortInst hpi;
            ArcInst ai;
            ArcProto ap;
            if (this.drawns[this.arcsOffset + i] >= 0 || (ap = (ai = this.cell.getArc(i)).getProto()).getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        this.numConnectedDrawns = this.numDrawns;
        int numNodes = this.cell.getNumNodes();
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            NodeProto np = ni.getProto();
            if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech.simProbeNode || np == Artwork.tech.pinNode || np == Generic.tech.invisiblePinNode) continue;
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                PortInst pi = ni.getPortInst(j);
                int piOffset = this.getPortInstOffset(pi);
                if (this.drawns[piOffset] >= 0 || pi.getPortProto() instanceof PrimitivePort && ((PrimitivePort)pi.getPortProto()).isIsolated()) continue;
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
        this.stack = null;
    }

    void showDrawns() {
        PrintWriter out;
        String filePath = "tttt";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, true)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return;
        }
        out.println("Drawns " + this.cell);
        int numPorts = this.cell.getNumPorts();
        for (int drawn = 0; drawn < this.numDrawns; ++drawn) {
            for (int i = 0; i < this.drawns.length; ++i) {
                int k;
                if (this.drawns[i] != drawn) continue;
                if (i < numPorts) {
                    out.println(drawn + ": " + this.cell.getPort(i));
                    continue;
                }
                if (i >= this.arcsOffset) {
                    out.println(drawn + ": " + this.cell.getArc(i - this.arcsOffset));
                    continue;
                }
                for (k = 1; k < this.cell.getNumNodes() && this.ni_pi[k] <= i; ++k) {
                }
                NodeInst ni = this.cell.getNode(--k);
                PortInst pi = ni.getPortInst(i - this.ni_pi[k]);
                out.println(drawn + ": " + pi);
            }
        }
        out.close();
    }

    void initNetnames() {
        Object e;
        for (GenMath.MutableInteger nn : this.netNames.values()) {
            nn.setValue(-1);
        }
        this.netNameCount = 0;
        Iterator<Object> it = this.cell.getExports();
        while (it.hasNext()) {
            e = it.next();
            this.addNetNames(((Export)e).getNameKey(), (Export)e, null);
        }
        this.exportedNetNameCount = this.netNameCount;
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) continue;
            if (ai.getNameKey().isBus() && ai.getProto() != busArc) {
                String msg = "Network: " + this.cell + " has bus name <" + ai.getNameKey() + "> on arc that is not a bus";
                System.out.println(msg);
                this.networkManager.pushHighlight(ai);
                this.networkManager.logError(msg, 0);
            }
            if (!ai.isUsernamed()) continue;
            this.addNetNames(ai.getNameKey(), null, ai);
        }
        it = this.netNames.entrySet().iterator();
        while (it.hasNext()) {
            e = (Map.Entry)it.next();
            Name name = (Name)e.getKey();
            int index = ((GenMath.MutableInteger)e.getValue()).intValue();
            if (index < 0) {
                it.remove();
                continue;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("NetName " + name + " " + index);
        }
        assert (this.netNameCount == this.netNames.size());
    }

    void addNetNames(Name name, Export e, ArcInst ai) {
        if (name.isBus()) {
            System.out.println("Network: Layout " + this.cell + " has bus port/arc " + name);
        }
        this.addNetName(name, e, ai);
    }

    void addNetName(Name name, Export e, ArcInst ai) {
        GenMath.MutableInteger nn = this.netNames.get(name);
        if (nn == null) {
            nn = new GenMath.MutableInteger(-1);
            this.netNames.put(name, nn);
        }
        if (nn.intValue() < 0) {
            nn.setValue(this.netNameCount++);
        }
    }

    private void internalConnections(int[] netMapF, int[] netMapP, int[] netMapA) {
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            int nodeOffset = this.ni_pi[ni.getNodeIndex()];
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.RESIST) {
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    continue;
                }
                if (fun != PrimitiveNode.Function.PRESIST) continue;
                Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                continue;
            }
            NetCell netCell = this.networkManager.getNetCell((Cell)ni.getProto());
            if (netCell instanceof NetSchem) continue;
            int[] eqF = netCell.equivPortsN;
            int[] eqP = netCell.equivPortsP;
            int[] eqA = netCell.equivPortsA;
            for (int i = 0; i < eqF.length; ++i) {
                if (eqF[i] != i) {
                    Netlist.connectMap(netMapF, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqF[i]]);
                }
                if (eqP[i] != i) {
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqP[i]]);
                }
                if (eqA[i] == i) continue;
                Netlist.connectMap(netMapA, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqA[i]]);
            }
        }
    }

    final int getPortInstOffset(PortInst pi) {
        return this.ni_pi[pi.getNodeInst().getNodeIndex()] + pi.getPortProto().getPortIndex();
    }

    int getPortOffset(int portIndex, int busIndex) {
        return busIndex == 0 ? portIndex : -1;
    }

    NetSchem getSchem() {
        return null;
    }

    private void buildNetworkList(int[] netMapN) {
        int drawn;
        ArcInst ai;
        int i;
        this.netlistN = new NetlistImpl(this, this.numExportedDrawns, netMapN);
        int[] netNameToNetIndex = new int[this.netNames.size()];
        Arrays.fill(netNameToNetIndex, -1);
        int numPorts = this.cell.getNumPorts();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            Export e = this.cell.getPort(i2);
            this.setNetName(netNameToNetIndex, this.drawns[i2], e.getNameKey(), true);
        }
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            ai = this.cell.getArc(i);
            if (!ai.isUsernamed() || (drawn = this.drawns[this.arcsOffset + i]) < 0) continue;
            this.setNetName(netNameToNetIndex, drawn, ai.getNameKey(), false);
        }
        for (i = 0; i < numArcs; ++i) {
            int netIndexN;
            ai = this.cell.getArc(i);
            drawn = this.drawns[this.arcsOffset + i];
            if (drawn < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn))) continue;
            this.netlistN.addTempName(netIndexN, ai.getName());
        }
        for (i = 0; i < this.cell.getNumNodes(); ++i) {
            NodeInst ni = this.cell.getNode(i);
            for (int j = 0; j < ni.getProto().getNumPorts(); ++j) {
                int netIndexN;
                int drawn2 = this.drawns[this.ni_pi[i] + j];
                if (drawn2 < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn2))) continue;
                this.netlistN.addTempName(netIndexN, ni.getName() + '.' + ni.getProto().getPort(j).getName());
            }
        }
        int numNetworks = this.netlistN.getNumNetworks();
        for (i = 0; i < numNetworks; ++i) {
            assert (this.netlistN.hasNames(i));
        }
    }

    private void setNetName(int[] netNamesToNetIndex, int drawn, Name name, boolean exported) {
        int netIndexN = this.netlistN.getNetIndexByMap(drawn);
        assert (netIndexN >= 0);
        GenMath.MutableInteger nn = this.netNames.get(name);
        if (netNamesToNetIndex[nn.intValue()] >= 0) {
            int i;
            if (netNamesToNetIndex[nn.intValue()] == netIndexN) {
                return;
            }
            String msg = "Network: Layout " + this.cell + " has nets with same name " + name;
            System.out.println(msg);
            int numPorts = this.cell.getNumPorts();
            for (i = 0; i < numPorts; ++i) {
                Export e = this.cell.getPort(i);
                if (!e.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(this.cell.getPort(i));
            }
            int numArcs = this.cell.getNumArcs();
            for (i = 0; i < numArcs; ++i) {
                ArcInst ai = this.cell.getArc(i);
                if (!ai.isUsernamed() || !ai.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(ai);
            }
            this.networkManager.logError(msg, 0);
        } else {
            netNamesToNetIndex[nn.intValue()] = netIndexN;
        }
        this.netlistN.addUserName(netIndexN, name, exported);
    }

    private boolean updateInterface() {
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.equivPortsN == null || this.equivPortsN.length != numPorts) {
            changed = true;
            this.equivPortsN = new int[numPorts];
            this.equivPortsP = new int[numPorts];
            this.equivPortsA = new int[numPorts];
        }
        int[] netToPortN = new int[numPorts];
        int[] netToPortP = new int[numPorts];
        int[] netToPortA = new int[numPorts];
        Arrays.fill(netToPortN, -1);
        Arrays.fill(netToPortP, -1);
        Arrays.fill(netToPortA, -1);
        for (int i = 0; i < numPorts; ++i) {
            int netA;
            int netP;
            int netN = this.netlistN.netMap[this.drawns[i]];
            if (netToPortN[netN] < 0) {
                netToPortN[netN] = i;
            }
            if (this.equivPortsN[i] != netToPortN[netN]) {
                changed = true;
                this.equivPortsN[i] = netToPortN[netN];
            }
            if (netToPortP[netP = this.netlistP.netMap[this.drawns[i]]] < 0) {
                netToPortP[netP] = i;
            }
            if (this.equivPortsP[i] != netToPortP[netP]) {
                changed = true;
                this.equivPortsP[i] = netToPortP[netP];
            }
            if (netToPortA[netA = this.netlistA.netMap[this.drawns[i]]] < 0) {
                netToPortA[netA] = i;
            }
            if (this.equivPortsA[i] == netToPortA[netA]) continue;
            changed = true;
            this.equivPortsA[i] = netToPortA[netA];
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoNetworks() {
        if ((this.flags & 1) != 0) {
            return;
        }
        Iterator<CellUsage> it = this.cell.getUsagesIn();
        while (it.hasNext()) {
            CellUsage u = it.next();
            Cell subCell = u.getProto();
            if (subCell.isIconOf(this.cell)) continue;
            NetCell netCell = this.networkManager.getNetCell(subCell);
            if ((netCell.flags & 1) != 0) continue;
            netCell.redoNetworks();
        }
        NetSchem schem = this.getSchem();
        if (schem != null && schem != this) {
            schem.redoNetworks();
        }
        if ((this.flags & 2) != 0) {
            this.flags |= 1;
            return;
        }
        ++this.modCount;
        this.networkManager.startErrorLogging(this.cell);
        try {
            this.makeDrawns();
            this.initNetnames();
            if (this.redoNetworks1()) {
                this.setInvalid(false, true);
            }
        }
        finally {
            this.networkManager.finishErrorLogging();
        }
        this.flags |= 3;
    }

    boolean redoNetworks1() {
        int[] netMapN = Netlist.initMap(this.numDrawns);
        int[] netMapP = (int[])netMapN.clone();
        int[] netMapA = (int[])netMapN.clone();
        this.internalConnections(netMapN, netMapP, netMapA);
        this.buildNetworkList(netMapN);
        this.netlistP = new NetlistShorted(this.netlistN, Netlist.ShortResistors.PARASITIC, netMapP);
        this.netlistA = new NetlistShorted(this.netlistN, Netlist.ShortResistors.ALL, netMapA);
        return this.updateInterface();
    }
}

