/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.ObjectQTree;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChangeJobs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoStitch {
    private static final boolean USEQTREE = true;
    private static InteractiveRouter router = new SimpleWirer();
    private static List<Route> allRoutes;
    private static Pairs intendedPairs;
    private static HashSet<NodeInst> possibleInlinePins;
    private static HashSet<NodeInst> nodeMark;

    public static void autoStitch(boolean highlighted, boolean forced) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        ArrayList<NodeInst> nodesToStitch = null;
        ArrayList<ArcInst> arcsToStitch = null;
        RectangularShape limitBound = null;
        if (highlighted) {
            nodesToStitch = new ArrayList<NodeInst>();
            arcsToStitch = new ArrayList<ArcInst>();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            List<Geometric> highs = wnd.getHighlightedEObjs(true, true);
            limitBound = wnd.getHighlightedArea();
            for (Geometric geom : highs) {
                Geometric eObj = geom;
                if (eObj instanceof PortInst) {
                    eObj = ((PortInst)((Object)eObj)).getNodeInst();
                }
                if (eObj instanceof NodeInst) {
                    PrimitiveNode pnp;
                    NodeInst ni = (NodeInst)eObj;
                    if (!ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                    nodesToStitch.add((NodeInst)eObj);
                    continue;
                }
                if (!(eObj instanceof ArcInst)) continue;
                arcsToStitch.add((ArcInst)eObj);
            }
            if (nodesToStitch.size() == 0 && arcsToStitch.size() == 0) {
                if (forced) {
                    System.out.println("Nothing selected to auto-route");
                }
                return;
            }
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        if (limitBound != null) {
            lX = limitBound.getMinX();
            hX = limitBound.getMaxX();
            lY = limitBound.getMinY();
            hY = limitBound.getMaxY();
        }
        new AutoStitchJob(cell, nodesToStitch, arcsToStitch, lX, hX, lY, hY, forced);
    }

    public static void runAutoStitch(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, PolyMerge stayInside, Rectangle2D limitBound, boolean forced) {
        Netlist netlist;
        Iterator<Geometric> it;
        ArcProto preferredArc = Routing.getPreferredRoutingArcProto();
        if (nodesToStitch == null) {
            nodesToStitch = new ArrayList<NodeInst>();
            it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pnp;
                NodeInst ni = (NodeInst)it.next();
                if (ni.isIconOfParent() || !ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                nodesToStitch.add(ni);
            }
        }
        if (arcsToStitch == null) {
            arcsToStitch = new ArrayList<ArcInst>();
            it = cell.getArcs();
            while (it.hasNext()) {
                arcsToStitch.add((ArcInst)it.next());
            }
        }
        allRoutes = new ArrayList<Route>();
        intendedPairs = new Pairs();
        possibleInlinePins = new HashSet();
        HashMap<NodeInst, Rectangle2D[]> nodeBounds = new HashMap<NodeInst, Rectangle2D[]>();
        HashMap<NodeInst, ObjectQTree> nodePortBounds = new HashMap<NodeInst, ObjectQTree>();
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            int total = ni.getProto().getNumPorts();
            Rectangle2D[] bbArray = new Rectangle2D[total];
            int i = 0;
            Iterator<PortProto> pIt = ni.getProto().getPorts();
            while (pIt.hasNext()) {
                PortProto pp = pIt.next();
                PortOriginal fp = new PortOriginal(ni, pp);
                AffineTransform trans = fp.getTransformToTop();
                NodeInst rNi = fp.getBottomNodeInst();
                Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                DBMath.transformRect(bounds, trans);
                bbArray[i++] = bounds;
            }
            nodeBounds.put(ni, bbArray);
            ObjectQTree oqt = new ObjectQTree(ni.getBounds());
            Iterator<PortInst> it2 = ni.getPortInsts();
            while (it2.hasNext()) {
                PortInst pi = it2.next();
                PortProto pp = pi.getPortProto();
                PortOriginal fp = new PortOriginal(ni, pp);
                AffineTransform trans = fp.getTransformToTop();
                NodeInst rNi = fp.getBottomNodeInst();
                Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                DBMath.transformRect(bounds, trans);
                oqt.add(pi, bounds);
            }
            nodePortBounds.put(ni, oqt);
        }
        nodeMark = new HashSet();
        for (NodeInst ni : nodesToStitch) {
            nodeMark.add(ni);
        }
        HashMap<ArcProto, Layer> arcLayers = new HashMap<ArcProto, Layer>();
        int count = 0;
        HashMap<ArcProto, Integer> arcCount = new HashMap<ArcProto, Integer>();
        for (NodeInst ni : nodesToStitch) {
            if (cell.isAllLocked()) continue;
            netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted auto-routing (network information unavailable).  Please try again");
                break;
            }
            count += AutoStitch.checkStitching(ni, arcCount, nodeBounds, nodePortBounds, arcLayers, stayInside, netlist, limitBound, preferredArc);
        }
        for (ArcInst ai : arcsToStitch) {
            if (!ai.isLinked() || cell.isAllLocked() || !AutoStitch.arcTooWide(ai)) continue;
            netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted auto-routing (network information unavailable).  Please try again");
                break;
            }
            count += AutoStitch.checkStitching(ai, arcCount, nodeBounds, nodePortBounds, arcLayers, stayInside, netlist, limitBound, preferredArc);
        }
        if (forced) {
            if (count != 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("AUTO ROUTING: added ");
                boolean first = true;
                for (ArcProto ap : arcCount.keySet()) {
                    if (!first) {
                        buf.append("; ");
                    }
                    Integer c = arcCount.get(ap);
                    buf.append(c + " " + ap.describe() + " wires");
                    first = false;
                }
                System.out.println(buf.toString());
            } else {
                System.out.println("No arcs added");
            }
        }
        nodeMark = null;
        Collections.sort(allRoutes, new compRoutes());
        for (Route route : allRoutes) {
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            RouteElementPort start = route.getStart();
            RouteElementPort end = route.getEnd();
            PortInst startPi = start.getPortInst();
            PortInst endPi = end.getPortInst();
            if (startPi != null && endPi != null) {
                boolean already = false;
                Iterator<Connection> cIt = startPi.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst existingAI = con.getArc();
                    if (existingAI.getHead() == con) {
                        if (existingAI.getTail().getPortInst() != endPi) continue;
                        already = true;
                        break;
                    }
                    if (existingAI.getHead().getPortInst() != endPi) continue;
                    already = true;
                    break;
                }
                if (already) continue;
            }
            if (stayInside != null) {
                for (RouteElement obj : route) {
                    RouteElementArc reArc;
                    if (!(obj instanceof RouteElementArc) || (reArc = (RouteElementArc)obj).getAction() == RouteElement.RouteElementAction.deleteArc) continue;
                    Point2D head = reArc.getHeadConnPoint();
                    Point2D tail = reArc.getTailConnPoint();
                    ArcProto ap = reArc.getArcProto();
                    Layer arcLayer = ap.getLayers()[0].getLayer();
                    double width = ap.getDefaultWidth();
                    if (AutoStitch.arcInMerge(head, tail, reArc.getArcWidth(), stayInside, arcLayer)) continue;
                    double tinyAmountLess = reArc.getArcWidth() - DBMath.getEpsilon();
                    if (AutoStitch.arcInMerge(head, tail, tinyAmountLess, stayInside, arcLayer)) {
                        reArc.setArcWidth(tinyAmountLess);
                        continue;
                    }
                    if (AutoStitch.arcInMerge(head, tail, ap.getDefaultWidth(), stayInside, arcLayer)) {
                        reArc.setArcWidth(ap.getDefaultWidth());
                        continue;
                    }
                    reArc.setArcWidth(ap.getWidthOffset());
                }
            }
            Router.createRouteNoJob(route, c, false, false);
        }
        ArrayList<CircuitChangeJobs.Reconnect> pinsToPassThrough = new ArrayList<CircuitChangeJobs.Reconnect>();
        for (NodeInst ni : possibleInlinePins) {
            CircuitChangeJobs.Reconnect re;
            if (!ni.isInlinePin() || (re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true)) == null) continue;
            pinsToPassThrough.add(re);
        }
        if (pinsToPassThrough.size() > 0) {
            CircuitChangeJobs.CleanupChanges job = new CircuitChangeJobs.CleanupChanges(cell, true, new ArrayList<NodeInst>(), pinsToPassThrough, new HashMap<NodeInst, EPoint>(), new ArrayList<NodeInst>(), new HashSet<ArcInst>(), 0, 0, 0);
            try {
                job.doIt();
            }
            catch (JobException e) {
                // empty catch block
            }
        }
    }

    private static boolean arcTooWide(ArcInst ai) {
        boolean headTooWide = true;
        NodeInst hNi = ai.getHeadPortInst().getNodeInst();
        if (hNi.isCellInstance()) {
            headTooWide = false;
        } else if (ai.getWidth() <= hNi.getXSize() && ai.getWidth() <= hNi.getYSize()) {
            headTooWide = false;
        }
        boolean tailTooWide = true;
        NodeInst tNi = ai.getTailPortInst().getNodeInst();
        if (tNi.isCellInstance()) {
            tailTooWide = false;
        } else if (ai.getWidth() <= tNi.getXSize() && ai.getWidth() <= tNi.getYSize()) {
            tailTooWide = false;
        }
        return headTooWide || tailTooWide;
    }

    private static boolean arcInMerge(Point2D head, Point2D tail, double width, PolyMerge stayInside, Layer layer) {
        Poly arcPoly;
        Rectangle2D.Double arcRect;
        return head.equals(tail) ? stayInside.contains(layer, arcRect = new Rectangle2D.Double(head.getX() - width / 2.0, head.getY() - width / 2.0, width, width)) : stayInside.contains(layer, arcPoly = Poly.makeEndPointPoly(head.distance(tail), width, GenMath.figureAngle(head, tail), head, width / 2.0, tail, width / 2.0, Poly.Type.FILLED));
    }

    private static int checkStitching(Geometric geom, HashMap<ArcProto, Integer> arcCount, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Netlist netlist, Rectangle2D limitBound, ArcProto preferredArc) {
        Cell cell = geom.getParent();
        NodeInst ni = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        }
        ArrayList<Geometric> geomsInArea = new ArrayList<Geometric>();
        Rectangle2D geomBounds = geom.getBounds();
        double epsilon = DBMath.getEpsilon();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(geomBounds.getMinX() - epsilon, geomBounds.getMinY() - epsilon, geomBounds.getWidth() + epsilon * 2.0, geomBounds.getHeight() + epsilon * 2.0);
        Iterator<Geometric> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            geomsInArea.add(it.next());
        }
        int count = 0;
        for (Geometric oGeom : geomsInArea) {
            PrimitiveNode pnp;
            if (oGeom instanceof ArcInst) {
                ArcInst oAi = (ArcInst)oGeom;
                if (ni == null) {
                    if (!AutoStitch.arcTooWide(oAi)) continue;
                    count += AutoStitch.compareTwoArcs((ArcInst)geom, oAi, stayInside, netlist, limitBound);
                    continue;
                }
                count += AutoStitch.compareNodeWithArc(ni, oAi, stayInside, netlist, limitBound);
                continue;
            }
            NodeInst oNi = (NodeInst)oGeom;
            if (!oNi.isCellInstance() && ((pnp = (PrimitiveNode)oNi.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
            if (ni == null) {
                count += AutoStitch.compareNodeWithArc(oNi, (ArcInst)geom, stayInside, netlist, limitBound);
                continue;
            }
            count += AutoStitch.compareTwoNodes(ni, oNi, arcCount, nodeBounds, nodePortBounds, arcLayers, stayInside, netlist, limitBound, preferredArc);
        }
        return count;
    }

    private static int compareTwoNodes(NodeInst ni, NodeInst oNi, HashMap<ArcProto, Integer> arcCount, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Netlist netlist, Rectangle2D limitBound, ArcProto preferredArc) {
        int count;
        block28: {
            block29: {
                Rectangle2D.Double biggerBounds;
                count = 0;
                if (nodeMark.contains(oNi) && oNi.getNodeIndex() <= ni.getNodeIndex()) {
                    return count;
                }
                Rectangle2D oBounds = oNi.getBounds();
                if (!ni.isCellInstance()) break block29;
                ObjectQTree oqt = nodePortBounds.get(ni);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(oBounds.getMinX() - 1.0, oBounds.getMinY() - 1.0, oBounds.getWidth() + 2.0, oBounds.getHeight() + 2.0));
                if (set == null) break block28;
                block0: for (Object obj : set) {
                    PortInst pi = (PortInst)obj;
                    PortProto pp = pi.getPortProto();
                    AffineTransform trans = ni.rotateOut();
                    NodeInst rNi = ni;
                    PortProto rPp = pp;
                    while (rNi.isCellInstance()) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    ArcProto[] connections = pp.getBasePort().getConnections();
                    for (int i = 0; i < connections.length; ++i) {
                        AutoStitch.findSmallestLayer(connections[i], arcLayers);
                    }
                    boolean usePortPoly = false;
                    Poly[] nodePolys = AutoStitch.shapeOfNode(rNi);
                    int tot = nodePolys.length;
                    if (tot == 0 || rNi.getProto() == Generic.tech.simProbeNode) {
                        usePortPoly = true;
                        tot = 1;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Layer layer = null;
                        Poly poly = null;
                        if (usePortPoly) {
                            poly = ni.getShapeOfPort(pp);
                            layer = poly.getLayer();
                        } else {
                            poly = nodePolys[j];
                            if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                            poly.transform(trans);
                            layer = poly.getLayer();
                            if (layer != null) {
                                layer = layer.getNonPseudoLayer();
                            }
                        }
                        boolean connected = false;
                        for (int pass = 0; pass < 2; ++pass) {
                            for (int i = 0; i < connections.length; ++i) {
                                ArcProto ap = connections[i];
                                if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                                if (!usePortPoly) {
                                    Layer oLayer = arcLayers.get(ap);
                                    if (!layer.getTechnology().sameLayer(oLayer, layer)) continue;
                                }
                                if (!(connected = AutoStitch.testPoly(ni, pp, ap, poly, oNi, netlist, nodeBounds, nodePortBounds, arcLayers, stayInside, limitBound))) continue;
                                Integer c = arcCount.get(ap);
                                if (c == null) {
                                    c = new Integer(0);
                                }
                                c = new Integer(c + 1);
                                arcCount.put(ap, c);
                                ++count;
                                break;
                            }
                            if (connected) break;
                        }
                        if (connected) continue block0;
                    }
                }
                break block28;
            }
            AffineTransform trans = ni.rotateOut();
            double oX = oNi.getAnchorCenterX();
            double oY = oNi.getAnchorCenterY();
            boolean usePortPoly = false;
            Poly[] polys = AutoStitch.shapeOfNode(ni);
            int tot = polys.length;
            if (tot == 0 || ni.getProto() == Generic.tech.simProbeNode) {
                usePortPoly = true;
                tot = 1;
            }
            for (int j = 0; j < tot; ++j) {
                double dist;
                double y;
                Iterator<PortProto> pIt;
                double bestDist;
                PortProto bestPp;
                PortProto rPp = null;
                Poly polyPtr = null;
                if (usePortPoly) {
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                            bestPp = tPp;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr = ni.getShapeOfPort(rPp);
                } else {
                    polyPtr = polys[j];
                    if (polyPtr.getPort() == null) continue;
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        if (!netlist.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr.transform(trans);
                }
                Layer layer = polyPtr.getLayer();
                if (layer != null) {
                    layer = layer.getNonPseudoLayer();
                }
                boolean found = false;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    PortInst pi = con.getPortInst();
                    if (!netlist.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHeadPortInst().getNodeInst() != oNi && con.getArc().getTailPortInst().getNodeInst() != oNi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean connected = false;
                ArcProto[] connections = rPp.getBasePort().getConnections();
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < connections.length; ++i) {
                        ArcProto ap = connections[i];
                        if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                        if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                        AutoStitch.findSmallestLayer(ap, arcLayers);
                        if (!usePortPoly) {
                            Layer oLayer = arcLayers.get(ap);
                            if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                        }
                        if (!(connected = AutoStitch.testPoly(ni, rPp, ap, polyPtr, oNi, netlist, nodeBounds, nodePortBounds, arcLayers, stayInside, limitBound))) continue;
                        Integer c = arcCount.get(ap);
                        if (c == null) {
                            c = new Integer(0);
                        }
                        c = new Integer(c + 1);
                        arcCount.put(ap, c);
                        ++count;
                        break;
                    }
                    if (connected) break;
                }
                if (!connected) {
                    continue;
                }
                break;
            }
        }
        return count;
    }

    private static int compareTwoArcs(ArcInst ai1, ArcInst ai2, PolyMerge stayInside, Netlist nl, Rectangle2D limitBound) {
        Network net2;
        if (ai1.getProto() != ai2.getProto()) {
            return 0;
        }
        Network net1 = nl.getNetwork(ai1, 0);
        if (net1 == (net2 = nl.getNetwork(ai2, 0))) {
            return 0;
        }
        boolean usePortPoly = false;
        Poly[] polys1 = ai1.getProto().getTechnology().getShapeOfArc(ai1);
        int tot1 = polys1.length;
        Poly[] polys2 = ai2.getProto().getTechnology().getShapeOfArc(ai1);
        int tot2 = polys2.length;
        for (int i1 = 0; i1 < tot1; ++i1) {
            Poly poly1 = polys1[i1];
            Layer layer1 = poly1.getLayer();
            Layer.Function fun = layer1.getFunction();
            if (!fun.isMetal() && !fun.isDiff() && !fun.isPoly()) continue;
            Rectangle2D bounds1 = poly1.getBounds2D();
            for (int i2 = 0; i2 < tot2; ++i2) {
                Rectangle2D bounds2;
                Poly poly2 = polys2[i2];
                if (layer1 != poly2.getLayer() || !bounds1.intersects(bounds2 = poly2.getBounds2D())) continue;
                Rectangle2D.Double intersection = new Rectangle2D.Double();
                Rectangle2D.intersect(bounds1, bounds2, intersection);
                double x = intersection.getCenterX();
                double y = intersection.getCenterY();
                AutoStitch.connectObjects(ai1, net1, ai2, net2, ai1.getParent(), new Point2D.Double(x, y), stayInside, limitBound);
                return 1;
            }
        }
        return 0;
    }

    private static int compareNodeWithArc(NodeInst ni, ArcInst ai, PolyMerge stayInside, Netlist nl, Rectangle2D limitBound) {
        if (ni.isCellInstance()) {
            return 0;
        }
        Network arcNet = nl.getNetwork(ai, 0);
        Poly[] nodePolys = AutoStitch.shapeOfNode(ni);
        int nTot = nodePolys.length;
        AffineTransform trans = ni.rotateOut();
        for (Poly arcPoly : ai.getProto().getTechnology().getShapeOfArc(ai)) {
            Layer arcLayer = arcPoly.getLayer();
            Layer.Function fun = arcLayer.getFunction();
            if (!fun.isMetal() && !fun.isDiff() && !fun.isPoly()) continue;
            Rectangle2D arcBounds = arcPoly.getBounds2D();
            double aCX = arcBounds.getCenterX();
            double aCY = arcBounds.getCenterY();
            for (int j = 0; j < nTot; ++j) {
                double polyDist;
                Poly nodePoly = nodePolys[j];
                nodePoly.transform(trans);
                Layer nodeLayer = nodePoly.getLayer();
                if (nodeLayer != null) {
                    nodeLayer = nodeLayer.getNonPseudoLayer();
                }
                if (nodeLayer != arcLayer || (polyDist = arcPoly.separation(nodePoly)) > 0.0 || nodePoly.getPort() == null) continue;
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto tPp = pIt.next();
                    if (!nl.portsConnected(ni, tPp, nodePoly.getPort())) continue;
                    Poly portPoly = ni.getShapeOfPort(tPp);
                    double portCX = portPoly.getCenterX();
                    double portCY = portPoly.getCenterY();
                    double dist = Math.abs(portCX - aCX) + Math.abs(portCY - aCY);
                    if (bestPp == null) {
                        bestDist = dist;
                    }
                    if (dist > bestDist) continue;
                    bestPp = tPp;
                    bestDist = dist;
                }
                if (bestPp == null) continue;
                PortInst pi = ni.findPortInstFromProto(bestPp);
                Poly portPoly = ni.getShapeOfPort(bestPp);
                double portCX = portPoly.getCenterX();
                double portCY = portPoly.getCenterY();
                Network nodeNet = nl.getNetwork(pi);
                if (arcNet == nodeNet) continue;
                Point2D.Double bend1 = new Point2D.Double(portCX, aCY);
                Point2D.Double bend2 = new Point2D.Double(aCX, portCY);
                if (stayInside != null) {
                    if (!stayInside.contains(arcLayer, bend1)) {
                        bend1 = bend2;
                    }
                } else if (!arcPoly.contains(bend1)) {
                    bend1 = bend2;
                }
                AutoStitch.connectObjects(ai, arcNet, pi, nodeNet, ai.getParent(), bend1, stayInside, limitBound);
                return 1;
            }
        }
        return 0;
    }

    private static boolean connectObjects(ElectricObject eobj1, Network net1, ElectricObject eobj2, Network net2, Cell cell, Point2D ctr, PolyMerge stayInside, Rectangle2D limitBound) {
        if (intendedPairs.contains(net1, net2)) {
            return false;
        }
        intendedPairs.add(net1, net2);
        NodeInst ni1 = null;
        if (eobj1 instanceof NodeInst) {
            ni1 = (NodeInst)eobj1;
        } else if (eobj1 instanceof PortInst) {
            ni1 = ((PortInst)eobj1).getNodeInst();
        }
        NodeInst ni2 = null;
        if (eobj2 instanceof NodeInst) {
            ni2 = (NodeInst)eobj2;
        } else if (eobj2 instanceof PortInst) {
            ni2 = ((PortInst)eobj2).getNodeInst();
        }
        Route route = router.planRoute(cell, eobj1, eobj2, ctr, stayInside, true);
        if (route.size() == 0) {
            return false;
        }
        allRoutes.add(route);
        if (ni1 != null && ni1.getFunction() == PrimitiveNode.Function.PIN && !ni1.hasExports() && !ni1.hasConnections()) {
            possibleInlinePins.add(ni1);
        }
        if (ni2 != null && ni2.getFunction() == PrimitiveNode.Function.PIN && !ni2.hasExports() && !ni2.hasConnections()) {
            possibleInlinePins.add(ni2);
        }
        return true;
    }

    private static boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, Netlist netlist, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Rectangle2D limitBound) {
        block19: {
            Network net;
            block18: {
                Rectangle2D.Double biggerBounds;
                PortInst pi = ni.findPortInstFromProto(pp);
                net = netlist.getNetwork(pi);
                if (!oNi.isCellInstance()) break block18;
                Rectangle2D bounds = poly.getBounds2D();
                ObjectQTree oqt = nodePortBounds.get(oNi);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(bounds.getMinX() - 1.0, bounds.getMinY() - 1.0, bounds.getWidth() + 2.0, bounds.getHeight() + 2.0));
                if (set == null) break block19;
                for (Object obj : set) {
                    PortInst oPi = (PortInst)obj;
                    PortProto mPp = oPi.getPortProto();
                    if (!mPp.getBasePort().connectsTo(ap)) continue;
                    Network oNet = netlist.getNetwork(oNi.findPortInstFromProto(mPp));
                    if (net != null && oNet == net) continue;
                    boolean ignore = false;
                    Iterator<Connection> piit = oPi.getConnections();
                    while (piit.hasNext()) {
                        Connection conn = piit.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getHeadPortInst() == pi) {
                            ignore = true;
                        }
                        if (ai.getTailPortInst() != pi) continue;
                        ignore = true;
                    }
                    if (ignore) continue;
                    AffineTransform trans = oNi.rotateOut();
                    NodeInst rNi = oNi;
                    PortProto rPp = mPp;
                    while (rNi.isCellInstance()) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    Poly[] polys = AutoStitch.shapeOfNode(rNi);
                    int tot = polys.length;
                    if (tot == 0) {
                        Poly oPoly = oNi.getShapeOfPort(mPp);
                        if (!AutoStitch.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist, limitBound)) continue;
                        return true;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Poly oPoly = polys[j];
                        if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                        if (ni.getProto() != Generic.tech.simProbeNode) {
                            Layer oLayer = oPoly.getLayer();
                            if (oLayer != null) {
                                oLayer = oLayer.getNonPseudoLayer();
                            }
                            Layer apLayer = arcLayers.get(ap);
                            if (!oLayer.getTechnology().sameLayer(oLayer, apLayer)) continue;
                        }
                        oPoly.transform(trans);
                        if (!AutoStitch.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist, limitBound)) continue;
                        return true;
                    }
                }
                break block19;
            }
            AffineTransform trans = oNi.rotateOut();
            double ox = poly.getCenterX();
            double oy = poly.getCenterY();
            Poly[] polys = AutoStitch.shapeOfNode(oNi);
            int tot = polys.length;
            if (tot == 0) {
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = oNi.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto rPp = pIt.next();
                    Poly portPoly = oNi.getShapeOfPort(rPp);
                    double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                    if (bestPp == null) {
                        bestDist = dist;
                        bestPp = rPp;
                    }
                    if (dist > bestDist) continue;
                    bestPp = rPp;
                    bestDist = dist;
                }
                if (bestPp != null) {
                    Poly oPoly;
                    PortProto rPp = bestPp;
                    Network oNet = netlist.getNetwork(oNi.findPortInstFromProto(bestPp));
                    if ((net == null || oNet != net) && rPp.getBasePort().connectsTo(ap) && AutoStitch.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), oNet, ni, pp, poly, net, ap, stayInside, netlist, limitBound)) {
                        return true;
                    }
                }
            } else {
                for (int j = 0; j < tot; ++j) {
                    PortProto rPp;
                    Layer apLayer;
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null) continue;
                    Layer oLayer = oPoly.getLayer();
                    if (oLayer != null) {
                        oLayer = oLayer.getNonPseudoLayer();
                    }
                    if (!(apLayer = arcLayers.get(ap)).getTechnology().sameLayer(apLayer, oLayer)) continue;
                    PortInst oPi = oNi.findPortInstFromProto(oPoly.getPort());
                    Network oNet = netlist.getNetwork(oPi);
                    if (net != null && oNet == net) continue;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator<PortProto> pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp2 = pIt.next();
                        if (!netlist.portsConnected(oNi, rPp2, oPoly.getPort())) continue;
                        Poly portPoly = oNi.getShapeOfPort(rPp2);
                        double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp2;
                        bestDist = dist;
                    }
                    if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                    oPoly.transform(trans);
                    if (!AutoStitch.comparePoly(oNi, rPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist, limitBound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, Network oNet, NodeInst ni, PortProto pp, Poly poly, Network net, ArcProto ap, PolyMerge stayInside, Netlist netlist, Rectangle2D limitBound) {
        Point2D.Double tPortCenter;
        double tDist;
        PortProto tPp;
        if (poly.separation(oPoly) > 0.0) {
            return false;
        }
        Poly portPoly = ni.getShapeOfPort(pp);
        Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        Poly oPortPoly = oNi.getShapeOfPort(opp);
        Point2D.Double oPortCenter = new Point2D.Double(oPortPoly.getCenterX(), oPortPoly.getCenterY());
        Rectangle2D polyBounds = portPoly.getBounds2D();
        Rectangle2D oPolyBounds = oPortPoly.getBounds2D();
        if ((polyBounds.getMinX() > oPolyBounds.getMaxX() || oPolyBounds.getMinX() > polyBounds.getMaxX()) && (polyBounds.getMinY() > oPolyBounds.getMaxY() || oPolyBounds.getMinY() > polyBounds.getMaxY())) {
            return false;
        }
        double dist = portCenter.distance(oPortCenter);
        Iterator<PortProto> it = oNi.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == opp || !netlist.portsConnected(oNi, tPp, opp) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            opp = tPp;
            oPortCenter.setLocation(tPortCenter);
        }
        it = ni.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == pp || !netlist.portsConnected(ni, tPp, pp) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            pp = tPp;
            portCenter.setLocation(tPortCenter);
        }
        if (limitBound != null && !GenMath.pointInRect(portCenter, limitBound) && !GenMath.pointInRect(oPortCenter, limitBound)) {
            return false;
        }
        double x = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
        double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
        PortInst pi = ni.findPortInstFromProto(pp);
        PortInst opi = oNi.findPortInstFromProto(opp);
        return AutoStitch.connectObjects(pi, net, opi, oNet, ni.getParent(), new Point2D.Double(x, y), stayInside, limitBound);
    }

    private static Poly[] shapeOfNode(NodeInst ni) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] nodePolys = tech.getShapeOfNode(ni, null, null, true, true, null);
        if (nodePolys.length == 0) {
            return nodePolys;
        }
        if (ni.getFunction() == PrimitiveNode.Function.PIN) {
            boolean gotOne = false;
            Rectangle2D coverage = null;
            Rectangle2D polyBounds = nodePolys[0].getBounds2D();
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (ai.getWidth() >= ni.getXSize() && ai.getWidth() >= ni.getYSize() && ai.isHeadExtended() && ai.isTailExtended()) {
                    gotOne = true;
                    break;
                }
                Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
                if (arcPolys.length == 0) continue;
                Rectangle2D arcBounds = arcPolys[0].getBounds2D();
                arcBounds.intersects(polyBounds);
                if (coverage == null) {
                    coverage = arcBounds;
                    continue;
                }
                if (coverage.getMinX() == arcBounds.getMinX() && coverage.getMaxX() == arcBounds.getMaxX() && coverage.getMinY() >= arcBounds.getMaxY() && coverage.getMaxY() <= arcBounds.getMinY()) {
                    double lX = Math.min(coverage.getMinX(), arcBounds.getMinX());
                    double hX = Math.max(coverage.getMaxX(), arcBounds.getMaxX());
                    coverage.setRect(lX, coverage.getMinY(), hX - lX, coverage.getHeight());
                    continue;
                }
                if (coverage.getMinY() == arcBounds.getMinY() && coverage.getMaxY() == arcBounds.getMaxY()) {
                    if (!(coverage.getMinX() >= arcBounds.getMaxX()) || !(coverage.getMaxX() <= arcBounds.getMinX())) continue;
                    double lY = Math.min(coverage.getMinY(), arcBounds.getMinY());
                    double hY = Math.max(coverage.getMaxY(), arcBounds.getMaxY());
                    coverage.setRect(coverage.getMinX(), lY, coverage.getWidth(), hY - lY);
                    continue;
                }
                coverage.intersects(arcBounds);
            }
            if (!gotOne && ni.getNumExports() == 0) {
                if (coverage == null) {
                    return new Poly[0];
                }
                Poly newPoly = new Poly(coverage);
                newPoly.setStyle(nodePolys[0].getStyle());
                newPoly.setLayer(nodePolys[0].getLayer());
                newPoly.setPort(nodePolys[0].getPort());
                nodePolys[0] = newPoly;
            }
        }
        return nodePolys;
    }

    public static void findSmallestLayer(ArcProto ap, HashMap<ArcProto, Layer> arcLayers) {
        if (arcLayers.get(ap) != null) {
            return;
        }
        ArcInst ai = ArcInst.makeDummyInstance(ap, 100.0);
        boolean bestFound = false;
        double bestArea = 0.0;
        Technology tech = ap.getTechnology();
        for (Poly poly : tech.getShapeOfArc(ai)) {
            double area = poly.getArea();
            if (bestFound && area >= bestArea) continue;
            bestArea = area;
            bestFound = true;
            arcLayers.put(ap, poly.getLayer());
        }
    }

    private static class Pairs {
        private HashMap<Object, HashSet<Object>> first = new HashMap();

        Pairs() {
        }

        void add(Object o1, Object o2) {
            if (this.contains(o1, o2)) {
                return;
            }
            HashSet<Object> other1 = this.first.get(o1);
            if (other1 != null) {
                other1.add(o2);
                return;
            }
            HashSet<Object> other2 = this.first.get(o2);
            if (other2 != null) {
                other2.add(o1);
                return;
            }
            other1 = new HashSet();
            this.first.put(o1, other1);
            other1.add(o2);
        }

        boolean contains(Object o1, Object o2) {
            HashSet<Object> other1 = this.first.get(o1);
            if (other1 != null && other1.contains(o2)) {
                return true;
            }
            HashSet<Object> other2 = this.first.get(o2);
            return other2 != null && other2.contains(o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class compRoutes
    implements Comparator<Route> {
        @Override
        public int compare(Route r1, Route r2) {
            int res;
            NodeInst n2e;
            NodeInst n2s;
            NodeInst n1e;
            boolean r2ToArc;
            RouteElementPort r1s = r1.getStart();
            RouteElementPort r1e = r1.getEnd();
            RouteElementPort r2s = r2.getStart();
            RouteElementPort r2e = r2.getEnd();
            boolean r1ToArc = r1s.getPortInst() == null || r1e.getPortInst() == null;
            boolean bl = r2ToArc = r2s.getPortInst() == null || r2e.getPortInst() == null;
            if (r1ToArc && !r2ToArc) {
                return 1;
            }
            if (!r1ToArc && r2ToArc) {
                return -1;
            }
            if (r1ToArc && r2ToArc) {
                ArcProto ap1 = null;
                ArcProto ap2 = null;
                if (r1s.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1s.getNewArcs().next()).getArcProto();
                }
                if (r1e.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1e.getNewArcs().next()).getArcProto();
                }
                if (r2s.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2s.getNewArcs().next()).getArcProto();
                }
                if (r2e.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2e.getNewArcs().next()).getArcProto();
                }
                if (ap1 == null || ap2 == null) {
                    return 0;
                }
                return ap1.compareTo(ap2);
            }
            NodeInst n1s = r1s.getPortInst().getNodeInst();
            if (n1s.compareTo(n1e = r1e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n1s;
                n1s = n1e;
                n1e = s;
                RouteElementPort se = r1s;
                r1s = r1e;
                r1e = se;
            }
            if ((n2s = r2s.getPortInst().getNodeInst()).compareTo(n2e = r2e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n2s;
                n2s = n2e;
                n2e = s;
                RouteElementPort se = r2s;
                r2s = r2e;
                r2e = se;
            }
            if ((res = n1s.compareTo(n2s)) != 0) {
                return res;
            }
            res = n1e.compareTo(n2e);
            if (res != 0) {
                return res;
            }
            res = r1s.getPortInst().getPortProto().getName().compareTo(r2s.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            res = r1e.getPortInst().getPortProto().getName().compareTo(r2e.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutoStitchJob
    extends Job {
        private Cell cell;
        private List<NodeInst> nodesToStitch;
        private List<ArcInst> arcsToStitch;
        private double lX;
        private double hX;
        private double lY;
        private double hY;
        private boolean forced;

        private AutoStitchJob(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, double lX, double hX, double lY, double hY, boolean forced) {
            super("Auto-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodesToStitch = nodesToStitch;
            this.arcsToStitch = arcsToStitch;
            this.lX = lX;
            this.hX = hX;
            this.lY = lY;
            this.hY = hY;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Rectangle2D.Double limitBound = null;
            if (this.lX != this.hX && this.lY != this.hY) {
                limitBound = new Rectangle2D.Double(this.lX, this.lY, this.hX - this.lX, this.hY - this.lY);
            }
            AutoStitch.runAutoStitch(this.cell, this.nodesToStitch, this.arcsToStitch, null, limitBound, this.forced);
            return true;
        }
    }
}

