/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccPreferences;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.user.ncc.NccMsgsFrame;
import java.util.List;

public class NccJob
extends Job {
    static final long serialVersionUID = 0L;
    private static NccResults lastResults;
    private final int numWindows;
    private final NccOptions options;
    private final CellContext[] cellCtxts;
    private NccResults results;
    public static NccMsgsFrame nccgui;

    private void prln(String s) {
        System.out.println(s);
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private CellContext[] getSchemLayFromCurrentWindow() {
        CellContext curCellCtxt = NccUtils.getCurrentCellContext();
        if (curCellCtxt == null) {
            this.prln("Please open the Cell you wish to NCC");
            return null;
        }
        Cell[] schLay = NccUtils.findSchematicAndLayout(curCellCtxt.cell);
        if (schLay == null) {
            this.prln("current Cell Group doesn't have both schematic and layout Cells");
            return null;
        }
        CellContext[] cc = new CellContext[]{new CellContext(schLay[0], curCellCtxt.context), new CellContext(schLay[1], curCellCtxt.context)};
        return cc;
    }

    private boolean isSchemOrLay(CellContext cc) {
        boolean ok;
        Cell c = cc.cell;
        View v = c.getView();
        boolean bl = ok = c.isSchematic() || v == View.LAYOUT;
        if (!ok) {
            this.prln("Cell: " + NccUtils.fullName(c) + " isn't schematic or layout");
        }
        return ok;
    }

    private boolean isSchem(CellContext cc) {
        return cc.cell.isSchematic();
    }

    private CellContext[] getTwoCellsFromTwoWindows() {
        List<CellContext> cellCtxts = NccUtils.getCellContextsFromWindows();
        if (cellCtxts.size() < 2) {
            this.prln("Two Cells aren't open in two windows");
            return null;
        }
        if (cellCtxts.size() > 2) {
            this.prln("More than two Cells are open in windows. Could you please");
            this.prln("close windows until only two Cells are open. (Sorry JonL.)");
            return null;
        }
        CellContext[] cellContexts = new CellContext[]{cellCtxts.get(0), cellCtxts.get(1)};
        if (!this.isSchemOrLay(cellContexts[0]) || !this.isSchemOrLay(cellContexts[1])) {
            return null;
        }
        if (!this.isSchem(cellContexts[0]) && this.isSchem(cellContexts[1])) {
            CellContext cc = cellContexts[0];
            cellContexts[0] = cellContexts[1];
            cellContexts[1] = cc;
        }
        return cellContexts;
    }

    private CellContext[] getCellsFromWindows(int numWindows) {
        if (numWindows == 2) {
            return this.getTwoCellsFromTwoWindows();
        }
        return this.getSchemLayFromCurrentWindow();
    }

    private NccOptions getOptionsFromNccConfigDialog() {
        NccOptions options = new NccOptions();
        options.operation = NccPreferences.getOperation();
        options.checkSizes = NccPreferences.getCheckSizes();
        options.relativeSizeTolerance = NccPreferences.getRelativeSizeTolerance() / 100.0;
        options.absoluteSizeTolerance = NccPreferences.getAbsoluteSizeTolerance();
        options.skipPassed = NccPreferences.getSkipPassed();
        options.howMuchStatus = NccPreferences.getHowMuchStatus();
        options.haltAfterFirstMismatch = NccPreferences.getHaltAfterFirstMismatch();
        options.maxMismatchedEquivRecsToPrint = NccPreferences.getMaxMismatchedClasses();
        options.maxMatchedEquivRecsToPrint = NccPreferences.getMaxMatchedClasses();
        options.maxEquivRecMembersToPrint = NccPreferences.getMaxClassMembers();
        return options;
    }

    public boolean doIt() {
        if (this.cellCtxts == null) {
            this.results = null;
            return true;
        }
        this.results = Ncc.compare(this.cellCtxts[0].cell, this.cellCtxts[0].context, this.cellCtxts[1].cell, this.cellCtxts[1].context, this.options, this);
        this.fieldVariableChanged("results");
        return true;
    }

    public void terminateOK() {
        lastResults = this.results;
        if (this.results == null) {
            return;
        }
        nccgui.setMismatches(this.results.getAllComparisonMismatches(), this.options);
        nccgui.display();
    }

    public static NccResults getLastNccResults() {
        return lastResults;
    }

    public static void invalidateLastNccResult() {
        lastResults = null;
    }

    public NccJob(int numWind) {
        super("Run NCC", NetworkTool.getNetworkTool(), Job.Type.REMOTE_EXAMINE, null, null, Job.Priority.ANALYSIS);
        this.numWindows = numWind;
        LayoutLib.error(this.numWindows != 1 && this.numWindows != 2, "numWindows must be 1 or 2");
        this.cellCtxts = this.getCellsFromWindows(this.numWindows);
        this.options = this.getOptionsFromNccConfigDialog();
        this.results = null;
        this.startJob();
    }

    static {
        nccgui = new NccMsgsFrame();
    }
}

