/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    private final Object[] array;
    private final int limit;
    private int cursor;
    public static final ArrayIterator NULL_ITERATOR = new ArrayIterator(new Object[0]);

    private ArrayIterator(Object[] array) {
        this.array = array;
        this.limit = array.length;
        this.cursor = 0;
    }

    private ArrayIterator(Object[] array, int start, int limit) {
        this.array = array;
        this.limit = limit;
        this.cursor = start;
    }

    public static Iterator iterator(Object[] array) {
        return array != null && array.length > 0 ? new ArrayIterator(array) : NULL_ITERATOR;
    }

    public static Iterator iterator(Object[] array, int start, int limit) {
        if (array != null) {
            if (start >= 0 && limit <= array.length) {
                if (start < limit) {
                    return new ArrayIterator(array, start, limit);
                }
                if (start == limit) {
                    return NULL_ITERATOR;
                }
            }
        } else if (start == 0 && limit == 0) {
            return NULL_ITERATOR;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean hasNext() {
        return this.cursor < this.limit;
    }

    public Object next() {
        if (this.cursor >= this.limit) {
            throw new NoSuchElementException();
        }
        Object next = this.array[this.cursor];
        ++this.cursor;
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

