 /*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EMPLOYER_INNER
    Description : Simple employer class to be used with the inner approach
                  This class is used by the inheritance tests
    Author      : David Martnez Oliveira
    Date        : March, 27th, 2002
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EMPLOYER_INNER
***************************************************
*/
 
typedef struct
  {
     ESint32		employer_number;
}DtEMPLOYER_INNER;
/*
***************************************************
  Method Declaration for class employer_number
***************************************************
*/
 
ESint32 EDMAPROC
EMPLOYER_INNERdisplay(OBJID IdObj)
{
  DtEMPLOYER_INNER	*m;
  OBJID                  e;
  
  m = (DtEMPLOYER_INNER *) edma_get_data_ref (IdObj);
  EDMA_TRY
    {
      edma_met3 (IdObj, "INNER<.display");
    }
  EDMA_CATCH(e) {}
  EDMA_TRY_END;
  printf (" [%ld] ", m->employer_number);

  return 0;
}


ESint32 EDMAPROC
EMPLOYER_INNERpayS32(OBJID IdObj, ESint32 amount)
{
  DtEMPLOYER_INNER	*m;

  m = (DtEMPLOYER_INNER *) edma_get_data_ref (IdObj);
  printf ("-->EMPLOYER<-- Paying %ld$ to :", amount);
  edma_met3 (IdObj, ".display");
  printf ("\n");
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
