/*
 * Copyright (C) 1999-2001 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * CNS 11643-1992 plane 5
 */

static const unsigned short cns11643_5_2uni_page21[8603] = {
  /* 0x21 */
  0x3cd1, 0x3ccb, 0x3cc9, 0x3d0c, 0x3c00, 0x3c87, 0x3d0d, 0x3d0f,
  0x3bfd, 0x5f98, 0x3cd2, 0x3d11, 0x3c7e, 0x46d3, 0x5152, 0x58fe,
  0x61a9, 0x7542, 0x3c09, 0x3cd6, 0x40dd, 0x40dc, 0x4102, 0x4173,
  0x4276, 0x42a7, 0x42a8, 0x4433, 0x44cc, 0x460d, 0x462c, 0x471b,
  0x015a, 0x471d, 0x4799, 0x4e3e, 0x592d, 0x592f, 0x5f99, 0x2129,
  0x75b6, 0x771b, 0x80ef, 0x84e9, 0x3c14, 0x3c94, 0x3ce1, 0x4106,
  0x414a, 0x4144, 0x4231, 0x427a, 0x42ad, 0x42ae, 0x42b1, 0x4438,
  0x4437, 0x457d, 0x457e, 0x462d, 0x4632, 0x4723, 0x4726, 0x3bfd,
  0x47a0, 0x52a8, 0x553f, 0x55bc, 0x57c4, 0x593b, 0x5c19, 0x5c18,
  0x5db3, 0x5faa, 0x60be, 0x61ac, 0x6625, 0x6666, 0x666b, 0x7543,
  0x75b5, 0x76ec, 0x7876, 0x08bc, 0x8214, 0x51dc, 0x831c, 0x831d,
  0xa0d0, 0xa212, 0xa6f3, 0xc269, 0x15b9, 0xca11,
  /* 0x22 */
  0xca15, 0xca10, 0xca13, 0x3ca4, 0x3ca5, 0x3dd0, 0x3dba, 0x3dcb,
  0x417b, 0x4286, 0x42bb, 0x42ba, 0x42c3, 0x42b9, 0x42c0, 0x00de,
  0x4439, 0x443b, 0x4441, 0x44d1, 0x44cf, 0x44d2, 0x452e, 0x456e,
  0x458c, 0x4588, 0x4635, 0x0143, 0x463a, 0x463b, 0x4638, 0x4639,
  0x472e, 0x472c, 0x47c8, 0x47b5, 0x47ad, 0x47b0, 0x47ab, 0x4db3,
  0x4da9, 0x52bb, 0x52b9, 0x575a, 0x57cd, 0x582b, 0x5905, 0x03ac,
  0x03aa, 0x5951, 0x594b, 0x5bea, 0x5bed, 0x5c36, 0x5c62, 0x5c56,
  0x5c55, 0x5c64, 0x5c58, 0x1c07, 0x5dda, 0x5dd8, 0x5fad, 0x5fab,
  0x60c0, 0x60c3, 0x61b3, 0x61b7, 0x61ba, 0x1dcb, 0x04fe, 0x61c7,
  0x61b5, 0x658e, 0x6673, 0x666c, 0x6674, 0x3bfd, 0x6672, 0x6671,
  0x6682, 0x6670, 0x6d3f, 0x6fba, 0x6fb8, 0x75b7, 0x8323, 0x8321,
  0x832b, 0x8326, 0x8322, 0x8925, 0x8ce4, 0x9015,
  /* 0x23 */
  0xa0e4, 0xa233, 0xa22a, 0xa232, 0xa229, 0xa6fb, 0xb55b, 0xb55c,
  0xb828, 0xc26f, 0xc26d, 0xc26b, 0xc26e, 0xca16, 0x3c22, 0x3d16,
  0x3d48, 0x3dd8, 0x3e00, 0x0041, 0x4080, 0x40e4, 0x00b4, 0x40e7,
  0x410c, 0x4153, 0x41b7, 0x46e8, 0x42d1, 0x42e5, 0x42d8, 0x42d6,
  0x42da, 0x42d9, 0x42d5, 0x42e6, 0x42d4, 0x42d3, 0x4444, 0x44d6,
  0x44d7, 0x4513, 0x3bfd, 0x4570, 0x4592, 0x45db, 0x45da, 0x4641,
  0x4643, 0x4733, 0x47f6, 0x47d4, 0x47dd, 0x47d0, 0x4804, 0x47d9,
  0x47db, 0x4805, 0x47d3, 0x47e1, 0x4e80, 0x4e77, 0x4e81, 0x4e82,
  0x4e83, 0x3bfd, 0x5161, 0x5160, 0x52d8, 0x52d6, 0x52d7, 0x8205,
  0x554d, 0x5548, 0x57d6, 0x57cf, 0x57d9, 0x57d8, 0x583d, 0x03b3,
  0x5954, 0x595b, 0x595c, 0x03b4, 0x5959, 0x5958, 0x595a, 0x5955,
  0x5956, 0x5982, 0x5bf0, 0x5c1c, 0x5c6a, 0x5c69,
  /* 0x24 */
  0x5c71, 0x5c67, 0x5c6c, 0x5c6e, 0x5c79, 0x5d8b, 0x5db8, 0x5de7,
  0x5de8, 0x5de4, 0x5de6, 0x5de5, 0x5df0, 0x5f83, 0x5fb7, 0x5fbb,
  0x5fb9, 0x5fc5, 0x6053, 0x60c4, 0x60c6, 0x60cb, 0x61c8, 0x3bfd,
  0x61c9, 0x61db, 0x6594, 0x6695, 0x6688, 0x668d, 0x6aec, 0x6aee,
  0x6af1, 0x6d2e, 0x6d49, 0x6f5f, 0x6fd1, 0x6fcb, 0x7485, 0x081d,
  0x754a, 0x7547, 0x754b, 0x75bb, 0x75c4, 0x087c, 0x7702, 0x7882,
  0x7891, 0x788f, 0x7892, 0x7d8f, 0x7d91, 0x7db4, 0x7d92, 0x80f4,
  0x81aa, 0x8335, 0x8337, 0x833d, 0x833c, 0x832f, 0x8330, 0x84f8,
  0x84ef, 0x8726, 0x0b55, 0x8926, 0x8927, 0x8b41, 0x8bc6, 0x8bc7,
  0x8ceb, 0x8ce8, 0x8cea, 0x901a, 0x9019, 0x0d26, 0x9523, 0x9524,
  0x9a25, 0xa235, 0xa234, 0xa607, 0xae1d, 0xb3e1, 0xb7ab, 0xc060,
  0xc277, 0xc27d, 0x15bc, 0xca1e, 0xca1a, 0xca1d,
  /* 0x25 */
  0x3c6b, 0x3d2d, 0x3d4c, 0x3e2a, 0x004a, 0x3e15, 0x3e2c, 0x3e06,
  0x3e08, 0x3e0a, 0x004e, 0x4156, 0x4184, 0x00c9, 0x41c6, 0x42f5,
  0x4309, 0x42f8, 0x42e8, 0x42fb, 0x42e9, 0x42f6, 0x1ab7, 0x1ab8,
  0x4452, 0x1ab6, 0x1aba, 0x4454, 0x4451, 0x4539, 0x453a, 0x4598,
  0x464e, 0x017b, 0x4836, 0x480c, 0x4810, 0x4832, 0x4811, 0x4818,
  0x481c, 0x481a, 0x4819, 0x480b, 0x480f, 0x481d, 0x4821, 0x4813,
  0x481b, 0x4815, 0x0220, 0x4dd1, 0x4dc8, 0x4e8d, 0x4eb5, 0x0289,
  0x0295, 0x51f8, 0x52e0, 0x52e1, 0x02be, 0x52de, 0x52fe, 0x52dc,
  0x5301, 0x52fd, 0x5300, 0x55d7, 0x55d6, 0x55d9, 0x5765, 0x57d2,
  0x57dc, 0x57e1, 0x57de, 0x5842, 0x584b, 0x03c3, 0x598e, 0x5991,
  0x598b, 0x5990, 0x5988, 0x5989, 0x5984, 0x59aa, 0x5c8d, 0x5c8f,
  0x5c7d, 0x5c7f, 0x5c7b, 0x5c80, 0x5c7e, 0x5c83,
  /* 0x26 */
  0x5c81, 0x5c86, 0x5c8a, 0x5dbd, 0x5dbe, 0x0477, 0x5df4, 0x5df3,
  0x5e02, 0x5df6, 0x5df5, 0x5df2, 0x5e04, 0x5f3d, 0x5fc6, 0x6089,
  0x60d4, 0x60d6, 0x60d2, 0x61fa, 0x6206, 0x620c, 0x620a, 0x620f,
  0x662f, 0x05d4, 0x66b7, 0x66be, 0x66bc, 0x66e2, 0x6b06, 0x6af7,
  0x6b07, 0x6af6, 0x7735, 0x6d5f, 0x6d65, 0x6d64, 0x6d61, 0x6d5a,
  0x6d5d, 0x3bfd, 0x6fd7, 0x6fd5, 0x6fde, 0x6fe1, 0x6fe0, 0x6fd9,
  0x074c, 0x6fda, 0x6fdf, 0x6ff6, 0x7003, 0x0820, 0x7493, 0x748b,
  0x7491, 0x7492, 0x748a, 0x7489, 0x748f, 0x7556, 0x7559, 0x75ca,
  0x75cc, 0x085b, 0x75d0, 0x75cd, 0x75d6, 0x75cb, 0x7683, 0x7682,
  0x7706, 0x772a, 0x772c, 0x772b, 0x7729, 0x78bd, 0x78b3, 0x78be,
  0x78c0, 0x78b5, 0x78b6, 0x7d9d, 0x7d9f, 0x8220, 0x0a2d, 0x821e,
  0x821c, 0x8232, 0x821f, 0x822b, 0x8221, 0x8226,
  /* 0x27 */
  0x8224, 0x821d, 0x8227, 0x835b, 0x8359, 0x8380, 0x8355, 0x8350,
  0x835a, 0x8356, 0x8363, 0x8352, 0x8358, 0x0a63, 0x8339, 0x84f9,
  0x8728, 0x0b18, 0x87bc, 0x87d6, 0x8805, 0x8820, 0x0b74, 0x8933,
  0x8b46, 0x8b42, 0x8b43, 0x8b47, 0x8bcb, 0x8c42, 0x8c45, 0x8cfd,
  0x8cf4, 0x8cf9, 0x8cfa, 0x8f5e, 0x901d, 0x0d28, 0x9358, 0x9355,
  0x9657, 0x9658, 0x96d9, 0x96dc, 0x96db, 0x9a27, 0x9b85, 0x9b87,
  0x9b8a, 0x9e8b, 0x9f4f, 0xa130, 0xa12f, 0xa268, 0xa249, 0x0fda,
  0xa248, 0xa23f, 0xa24b, 0xa25c, 0xa246, 0xa240, 0xa60d, 0xa71b,
  0xa71d, 0xa717, 0x10a4, 0xa722, 0xb1a7, 0xb208, 0xb406, 0xc07d,
  0x148e, 0xc063, 0xc064, 0xc07f, 0xc06b, 0xc07c, 0xc068, 0xc065,
  0xc06a, 0xc298, 0xc299, 0xc2ae, 0xca2b, 0xca2d, 0xca31, 0xca2e,
  0xca2f, 0x3c6d, 0x3d31, 0x3e2d, 0x3e39, 0x3e38,
  /* 0x28 */
  0x005b, 0x3e3a, 0x3e35, 0x3e62, 0x40ea, 0x40eb, 0x4115, 0x41cc,
  0x41c8, 0x41cd, 0x41db, 0x41cb, 0x4311, 0x4326, 0x4462, 0x445e,
  0x4461, 0x4541, 0x453f, 0x4575, 0x7565, 0x4749, 0x45eb, 0x461a,
  0x4657, 0x486b, 0x48a9, 0x4854, 0x4862, 0x48aa, 0x4858, 0x4872,
  0x4863, 0x4873, 0x488b, 0x488c, 0x485c, 0x4851, 0x4816, 0x4860,
  0x4861, 0x485e, 0x485d, 0x4864, 0x4853, 0x485f, 0x485b, 0x486e,
  0x4855, 0x4852, 0x4868, 0x4dd2, 0x4dd6, 0x4dd3, 0x4eb8, 0x4ebb,
  0x4eeb, 0x4ee8, 0x4eb6, 0x4eea, 0x4ee7, 0x4ee9, 0x5191, 0x5210,
  0x520e, 0x520f, 0x530b, 0x5303, 0x532b, 0x5309, 0x5328, 0x532c,
  0x5325, 0x5327, 0x530f, 0x55e9, 0x55ec, 0x0353, 0x5727, 0x5773,
  0x57e2, 0x57e6, 0x3bfd, 0x5861, 0x5851, 0x5912, 0x590e, 0x59ad,
  0x59af, 0x59b1, 0x59d3, 0x5c94, 0x5c92, 0x5c90,
  /* 0x29 */
  0x5c9d, 0x5c93, 0x5c95, 0x5c98, 0x5c97, 0x0480, 0x3bfd, 0x5e07,
  0x5e0b, 0x5e08, 0x5fd9, 0x5fd5, 0x60d7, 0x60df, 0x04dd, 0x60de,
  0x60e3, 0x60e2, 0x04de, 0x6247, 0x0522, 0x623d, 0x6238, 0x6644,
  0x663a, 0x66b8, 0x672a, 0x6700, 0x66f3, 0x66f2, 0x66eb, 0x66fa,
  0x66ed, 0x66ec, 0x66ff, 0x66fb, 0x1f06, 0x674e, 0x66ef, 0x66f7,
  0x6b10, 0x6b11, 0x6b0c, 0x6b0b, 0x6cdd, 0x6d30, 0x06db, 0x6d7a,
  0x6d77, 0x6f28, 0x6f27, 0x6f65, 0x700e, 0x700b, 0x7041, 0x7013,
  0x700f, 0x7012, 0x7030, 0x74a0, 0x74a3, 0x749e, 0x7497, 0x74a1,
  0x749d, 0x749b, 0x7563, 0x75e3, 0x75e4, 0x75e6, 0x75e7, 0x75dd,
  0x2285, 0x75ec, 0x75e5, 0x75f1, 0x773b, 0x7739, 0x773a, 0x773c,
  0x773d, 0x7747, 0x773f, 0x7744, 0x7848, 0x7849, 0x7860, 0x78e3,
  0x78e9, 0x78f0, 0x08da, 0x08db, 0x78f2, 0x78ed,
  /* 0x2a */
  0x78ec, 0x78e6, 0x7916, 0x08d7, 0x7dbc, 0x7dbe, 0x7dc0, 0x7de0,
  0x8100, 0x8102, 0x80fe, 0x815e, 0x81b3, 0x81b7, 0x823a, 0x8239,
  0x823e, 0x8238, 0x823d, 0x824f, 0x836e, 0x835f, 0x8381, 0x8382,
  0x8371, 0x837b, 0x8379, 0x8377, 0x8373, 0x836f, 0x8397, 0x837e,
  0x84fc, 0x8511, 0x8532, 0x8531, 0x8510, 0x86ec, 0x86eb, 0x872c,
  0x872d, 0x87da, 0x882e, 0x882c, 0x882a, 0x8833, 0x884b, 0x8918,
  0x8942, 0x893b, 0x893f, 0x8941, 0x8943, 0x893c, 0x8b4c, 0x8b4a,
  0x8b49, 0x8b56, 0x8bcf, 0x8c47, 0x8c48, 0x8c46, 0x8d1b, 0x8d11,
  0x8d14, 0x8d1d, 0x8d17, 0x8d1e, 0x8d0b, 0x8d1c, 0x8d12, 0x8d16,
  0x8d0d, 0x8d15, 0x8d13, 0x8d18, 0x0c1a, 0x8fac, 0x9044, 0x902c,
  0x9045, 0x9366, 0x936e, 0x9365, 0x9368, 0x9384, 0x9538, 0x953b,
  0x953a, 0x953f, 0x96df, 0x96dd, 0x96de, 0x96e2,
  /* 0x2b */
  0x0dd6, 0x9a2c, 0x9a2f, 0x9b8f, 0x9b90, 0x9b8c, 0x9b93, 0x9e25,
  0x9e88, 0x9ea7, 0x9ff7, 0xa0bb, 0xa138, 0xa139, 0xa137, 0xa214,
  0xa26e, 0xa27b, 0x0fde, 0xa26c, 0xa27f, 0xa278, 0xa27a, 0xa26f,
  0x0fe5, 0xa4fe, 0xa748, 0xa74b, 0xa741, 0xa749, 0xa73b, 0xae2d,
  0xb1e3, 0xb21a, 0xb20d, 0xb213, 0xb211, 0xb21c, 0x1272, 0xb4b5,
  0x12af, 0xb829, 0xb8a1, 0xb924, 0xbbbb, 0xbea1, 0xc083, 0xc08d,
  0xc087, 0xc085, 0xc08a, 0xc0a3, 0xc089, 0xc084, 0xc0a2, 0xc2b1,
  0xc2b0, 0xc2af, 0xc2b6, 0xc2c9, 0xc2ca, 0xc2c8, 0xc2b4, 0xc859,
  0xc8c9, 0xca41, 0xca4c, 0x15c4, 0xca45, 0xca5a, 0x3cb9, 0x3e94,
  0x3e6e, 0x3ea2, 0x3e67, 0x0063, 0x3ea3, 0x3e76, 0x3e6c, 0x3e64,
  0x3ea5, 0x3e30, 0x3ea6, 0x3e69, 0x3ea4, 0x4090, 0x415f, 0x4160,
  0x41da, 0x41d8, 0x41dd, 0x00ec, 0x4359, 0x435b,
  /* 0x2c */
  0x435a, 0x4339, 0x4334, 0x4344, 0x4333, 0x433c, 0x4358, 0x436a,
  0x446f, 0x4472, 0x4470, 0x4471, 0x446e, 0x44f0, 0x44eb, 0x4549,
  0x454c, 0x45f5, 0x4620, 0x466a, 0x4672, 0x474b, 0x475d, 0x4850,
  0x48f9, 0x48fa, 0x48fb, 0x4923, 0x48b7, 0x4922, 0x48b5, 0x48c4,
  0x48b4, 0x48ef, 0x0198, 0x48cd, 0x48f0, 0x48b8, 0x48cb, 0x48f1,
  0x48ba, 0x4903, 0x48f8, 0x48b6, 0x48bc, 0x48b3, 0x4921, 0x48f7,
  0x48c2, 0x48be, 0x48c9, 0x48bd, 0x48ce, 0x48b9, 0x48c7, 0x48ca,
  0x48cc, 0x4926, 0x4de4, 0x4de0, 0x4df0, 0x4eec, 0x4f24, 0x4f18,
  0x4f2f, 0x4f25, 0x5128, 0x5122, 0x516a, 0x3d57, 0x5194, 0x5192,
  0x519c, 0x5222, 0x5230, 0x521d, 0x5223, 0x5335, 0x5333, 0x532f,
  0x534d, 0x5331, 0x535b, 0x535a, 0x5332, 0x535c, 0x5359, 0x535d,
  0x5569, 0x556d, 0x5e32, 0x0358, 0x560a, 0x5620,
  /* 0x2d */
  0x561f, 0x560d, 0x57e8, 0x57ec, 0x5877, 0x5870, 0x5871, 0x59f8,
  0x59d6, 0x59d9, 0x59de, 0x59d5, 0x59e1, 0x03d3, 0x59e2, 0x59dd,
  0x59e0, 0x5a0e, 0x5a08, 0x59dc, 0x5a0a, 0x5a0c, 0x5cb4, 0x5cb1,
  0x5cb6, 0x5cbc, 0x5e1d, 0x5e24, 0x5e19, 0x5e1b, 0x5e22, 0x5e1a,
  0x5e1c, 0x5e21, 0x5fe6, 0x5fe4, 0x5fe7, 0x5fea, 0x04e2, 0x3bfd,
  0x60f0, 0x60f5, 0x60ef, 0x6242, 0x626e, 0x623c, 0x6297, 0x628c,
  0x6281, 0x6271, 0x62ce, 0x62ba, 0x627a, 0x627e, 0x0554, 0x6272,
  0x62bb, 0x052f, 0x6273, 0x6282, 0x05b6, 0x65ba, 0x65b8, 0x664b,
  0x6648, 0x672b, 0x66f4, 0x672c, 0x6742, 0x6748, 0x6744, 0x6745,
  0x673c, 0x6737, 0x6733, 0x6741, 0x6732, 0x6787, 0x6b27, 0x6b23,
  0x6b2d, 0x6b1f, 0x6b2c, 0x6b28, 0x6c75, 0x6c74, 0x6ce7, 0x6d32,
  0x6d31, 0x6d99, 0x6d96, 0x6d98, 0x6d9d, 0x6d92,
  /* 0x2e */
  0x6d94, 0x6d95, 0x6d97, 0xa2b9, 0x0735, 0x7011, 0x703b, 0x7079,
  0x7042, 0x7043, 0x075d, 0x7078, 0x74ac, 0x0829, 0x74b1, 0x74b4,
  0x74b3, 0x74af, 0x74aa, 0x74b2, 0x7568, 0x75f2, 0x75fe, 0x75f8,
  0x75f9, 0x75ff, 0x75f5, 0x75f7, 0x75fd, 0x7600, 0x7688, 0x776e,
  0x775d, 0x7763, 0x7760, 0x7861, 0x7937, 0x7971, 0x7923, 0x7922,
  0x791f, 0x7925, 0x7dfd, 0x7e11, 0x7e23, 0x7df0, 0x7def, 0x810e,
  0x810c, 0x81ba, 0x0a1f, 0x8252, 0x8255, 0x8253, 0x8254, 0x8251,
  0x8258, 0x83b0, 0x839f, 0x0a72, 0x83a1, 0x839a, 0x83be, 0x83a0,
  0x8537, 0x0b0b, 0x86f1, 0x86f2, 0x8734, 0x8737, 0x8735, 0x5f8c,
  0x87df, 0x884c, 0x884e, 0x8864, 0x8863, 0x8836, 0x8958, 0x8968,
  0x895b, 0x895f, 0x8959, 0x8965, 0x8960, 0x895e, 0x8bd5, 0x8bd6,
  0x8c4e, 0x8c52, 0x8d35, 0x8d39, 0x8d58, 0x8d41,
  /* 0x2f */
  0x8d57, 0x8d38, 0x8d3d, 0x8d32, 0x8d44, 0x3bfd, 0x8f63, 0x8f62,
  0x8fb8, 0x8fb0, 0x8fb1, 0x904d, 0x9063, 0x9070, 0x904b, 0x904f,
  0x904e, 0x9053, 0x9047, 0x0ca2, 0x9054, 0x9052, 0x9059, 0x907e,
  0x922b, 0x922e, 0x937f, 0x937e, 0x9381, 0x9383, 0x9547, 0x9554,
  0x954d, 0x954c, 0x954b, 0x9557, 0x9665, 0x9664, 0x9661, 0x9662,
  0x96f0, 0x96f3, 0x96f9, 0x96f4, 0x96f5, 0x96ef, 0x96f8, 0x96fc,
  0x96f7, 0x96fd, 0x9717, 0x9a34, 0x9a36, 0x9a38, 0x9baf, 0x9bae,
  0x9bac, 0x9ba2, 0x9e28, 0x6ac2, 0x9e9c, 0x9eb3, 0x9e90, 0xa006,
  0xa004, 0xa00b, 0xa005, 0xa140, 0xa14f, 0xa2ab, 0xa29d, 0xa2b8,
  0xa2b2, 0xa2d2, 0xa2cf, 0xa2a2, 0x0fec, 0xa2a5, 0xa2a9, 0xa2a7,
  0xa2d0, 0xa502, 0xa5cf, 0xa5d0, 0xa616, 0xa619, 0xa775, 0xa771,
  0xa791, 0xa772, 0xa78e, 0xa76d, 0xa788, 0xa773,
  /* 0x30 */
  0x10bb, 0xa781, 0xa776, 0xa77b, 0xa77f, 0xa790, 0xa778, 0xae4b,
  0xae48, 0xae5b, 0xae51, 0xae3d, 0xae40, 0xae46, 0xae4d, 0xae3b,
  0xae4a, 0xae41, 0xae3e, 0xae4e, 0xb1ac, 0xb1e6, 0xb1e9, 0xb229,
  0x1221, 0xb233, 0xb22e, 0xb21e, 0x121f, 0x3bfd, 0xb222, 0xb227,
  0xb3e7, 0xb40b, 0xb566, 0xb7ad, 0xb7ae, 0x3138, 0xb82b, 0xb82a,
  0xb92c, 0xb92d, 0x1391, 0x1396, 0xba8f, 0xba93, 0xbbc6, 0xbbc5,
  0xbe15, 0xbe13, 0xbeb1, 0xbea9, 0x3bfd, 0xc0a8, 0xc0ab, 0xc0be,
  0xc0ac, 0xc0a9, 0xc0a6, 0xc0c1, 0xc2cc, 0xc2d1, 0xc2d3, 0xc2e4,
  0xc2cb, 0xc2e1, 0xc2d2, 0xc2e3, 0xc2cf, 0xc2d0, 0xc2e5, 0xc30e,
  0xc8cc, 0xc8ca, 0xc8cb, 0xca5c, 0xca61, 0xca5d, 0xca59, 0xcc77,
  0xd284, 0x3c41, 0x3cfd, 0x3d1a, 0x3d63, 0x3eb6, 0x3eb2, 0x3ee9,
  0x3ee7, 0x3ed6, 0x3f30, 0x3eec, 0x3edd, 0x3ee8,
  /* 0x31 */
  0x3eb0, 0x3eb5, 0x3ee1, 0x4098, 0x4099, 0x00bc, 0x4193, 0x41e5,
  0x00d8, 0x4360, 0x435e, 0x00f4, 0x447b, 0x44f1, 0x44f3, 0x467f,
  0x3bfd, 0x4757, 0x4758, 0x4939, 0x49a7, 0x4935, 0x4960, 0x4951,
  0x4962, 0x4942, 0x493c, 0x4943, 0x49ab, 0x49a9, 0x49b4, 0x4979,
  0x496a, 0x493b, 0x49aa, 0x4933, 0x4937, 0x4927, 0x49a8, 0x4970,
  0x492f, 0x4936, 0x49b5, 0x4930, 0x493a, 0x4938, 0x49b1, 0x49ac,
  0x492e, 0x4975, 0x49b0, 0x4df7, 0x4e00, 0x4df1, 0x4df3, 0x4f60,
  0x4f61, 0x4f32, 0x4f2d, 0x4f4a, 0x4f2a, 0x5167, 0x51a2, 0x51a3,
  0x519e, 0x51a4, 0x5244, 0x5232, 0x539b, 0x5398, 0x5399, 0x539a,
  0x5366, 0x5362, 0x536b, 0x8162, 0x5367, 0x563b, 0x5623, 0x5629,
  0x577e, 0x57f3, 0x0385, 0x57f5, 0x0383, 0x5880, 0x587e, 0x587c,
  0x587f, 0x587d, 0x5881, 0x5a25, 0x5a29, 0x5a17,
  /* 0x32 */
  0x5a63, 0x5a67, 0x5a65, 0x5a2a, 0x5a68, 0x5a26, 0x5a64, 0x5a1b,
  0x5a62, 0x5a69, 0x5bfe, 0x5c44, 0x5c42, 0x5cb7, 0x5cd2, 0x5cd4,
  0x5cd7, 0x5cdc, 0x5cd1, 0x5cd5, 0x5ccd, 0x5cd8, 0x5d9a, 0x5e42,
  0x5e35, 0x5e58, 0x5e34, 0x5e3c, 0x5e3b, 0x5e3e, 0x5e3d, 0x5e5a,
  0x5e41, 0x5e38, 0x5e45, 0x5e33, 0x5f26, 0x04ba, 0x5ff7, 0x5fef,
  0x5ff0, 0x5fee, 0x609d, 0x6106, 0x6111, 0x6108, 0x6102, 0x610a,
  0x6107, 0x6291, 0x628e, 0x6285, 0x62e8, 0x6317, 0x62d4, 0x0569,
  0x62c4, 0x62d5, 0x0545, 0x62d8, 0x6280, 0x62de, 0x6342, 0x65c7,
  0x65bf, 0x678d, 0x6789, 0x6790, 0x679a, 0x67c8, 0x6792, 0x67a1,
  0x6784, 0x6b57, 0x6b47, 0x6b77, 0x6b3a, 0x6b50, 0x6b42, 0x6b43,
  0x6ba3, 0x6c77, 0x6db2, 0x6de2, 0x6dbd, 0x6f74, 0x7082, 0x70b8,
  0x076c, 0x70ba, 0x70b9, 0x70bb, 0x7087, 0x3bfd,
  /* 0x33 */
  0x7083, 0x70b7, 0x3c43, 0x74ce, 0x74ba, 0x7573, 0x7609, 0x760a,
  0x760b, 0x7607, 0x7605, 0x760e, 0x7697, 0x7777, 0x777b, 0x777a,
  0x7774, 0x7779, 0x7986, 0x79f5, 0x79a5, 0x799d, 0x79be, 0x7996,
  0x79e1, 0x79a4, 0x79a1, 0x79f6, 0x0904, 0x798d, 0x798b, 0x7978,
  0x7998, 0x7a0a, 0x7e5d, 0x7e27, 0x7e5f, 0x81c0, 0x81c1, 0x826d,
  0x825e, 0x828a, 0x8262, 0x8264, 0x0a3a, 0x83c0, 0x83ca, 0x83d1,
  0x0a79, 0x83c7, 0x83ce, 0x2409, 0x83c5, 0x8536, 0x8557, 0x8577,
  0x86f6, 0x86f7, 0x8755, 0x8744, 0x873e, 0x8742, 0x8752, 0x87e1,
  0x8808, 0x8868, 0x8867, 0x0b5d, 0x3bfd, 0x897e, 0x8993, 0x8979,
  0x8981, 0x897d, 0x897b, 0x8994, 0x0b8a, 0x8b66, 0x8bd9, 0x8be0,
  0x3bfd, 0x8c5f, 0x8d5f, 0x8d5e, 0x8d68, 0x0c27, 0x8d88, 0x8d6a,
  0x8d6c, 0x8d66, 0x8d67, 0x8d89, 0x8d60, 0x8d85,
  /* 0x34 */
  0x3f2a, 0x8f68, 0x8fb9, 0x8fba, 0x8fbe, 0x906f, 0x9080, 0x9074,
  0x9081, 0x907a, 0x909c, 0x9073, 0x9082, 0x907f, 0x90a7, 0x9079,
  0x9078, 0x907d, 0x90a8, 0x907c, 0x9268, 0x924e, 0x939e, 0x0d46,
  0x0d40, 0x9398, 0x0d3f, 0x9385, 0x939c, 0x93c5, 0x939a, 0x9568,
  0x9565, 0x9567, 0x9561, 0x9560, 0x0d9d, 0x0dcb, 0x967b, 0x0de1,
  0x9719, 0x970e, 0x9731, 0x9712, 0x9710, 0x9715, 0x973f, 0x971d,
  0x971e, 0x9a4d, 0x9a48, 0x9a45, 0x9a42, 0x9a49, 0x9a4a, 0x9a47,
  0x0e7f, 0x9a4c, 0x9bcd, 0x9bd5, 0x9bc4, 0x9bca, 0x9bc3, 0x0f46,
  0x9e29, 0x9eb4, 0x9f6d, 0x9f66, 0x9f6a, 0xa015, 0xa0d3, 0xa0ec,
  0xa155, 0x101a, 0xa2d6, 0xa2d8, 0xa351, 0xa2e0, 0xa303, 0xa304,
  0xa2da, 0xa2ea, 0xa302, 0xa2d3, 0xa2e4, 0xa2e5, 0xa53b, 0xa566,
  0xa62c, 0xa621, 0xa626, 0xa6d4, 0xa6d5, 0xa6d9,
  /* 0x35 */
  0xa7d5, 0xa7eb, 0xa7c5, 0x10d3, 0xa827, 0xa7f0, 0xa7b9, 0xa818,
  0xa7ee, 0x10d0, 0xa7b7, 0xa7bb, 0xa7ef, 0xa7b8, 0xa7df, 0xa7da,
  0xa7e3, 0xa7c9, 0xa7ec, 0xada4, 0x118e, 0xada3, 0xae5e, 0xae61,
  0xae62, 0xae63, 0xae8e, 0xae69, 0xae6b, 0xae85, 0xae8d, 0xae64,
  0xae6d, 0xb24c, 0xb249, 0xb247, 0xb248, 0xb242, 0xb245, 0xb25b,
  0xb25d, 0xb246, 0xb413, 0xb41a, 0xb40e, 0xb40f, 0xb41b, 0xb412,
  0xb4c3, 0xb4be, 0xb4bd, 0xb579, 0xb57c, 0x12c3, 0x12b6, 0xb580,
  0xb575, 0xb59b, 0x302f, 0xb574, 0x12c0, 0x12b8, 0x5c41, 0x6094,
  0xb830, 0xb8a7, 0xb8a5, 0xb8a4, 0xb93a, 0xba5b, 0xba9f, 0xbaa8,
  0xbab3, 0xbaa1, 0xbaa7, 0xbab2, 0xba9d, 0xbaa3, 0xbaa2, 0xbbef,
  0xbbd9, 0x13d9, 0xbbd5, 0xbbdd, 0xbbda, 0xbbee, 0xbbd7, 0xbe1a,
  0xbe19, 0xbe18, 0xbeb3, 0xbebf, 0xbebb, 0xbec0,
  /* 0x36 */
  0xbeb9, 0xbeb8, 0xbed5, 0xc011, 0xc010, 0xc0c3, 0xc0c2, 0xc0e9,
  0xc0cd, 0xc0e5, 0xc0ca, 0xc0c7, 0xc0e8, 0xc2f1, 0xc30c, 0xc2ef,
  0xc2ee, 0xc2f3, 0xc30d, 0xc2f6, 0xc2f0, 0x14ec, 0xc3f5, 0xc3f4,
  0xc3f8, 0xc3fe, 0xc511, 0xc522, 0xc542, 0xc85c, 0xc85a, 0xc85d,
  0xc8d1, 0xc8d0, 0xca75, 0xca7b, 0xcb89, 0xd04d, 0xd289, 0xd292,
  0xd28c, 0xd288, 0xd467, 0xd468, 0x3f21, 0x3ef2, 0x3f09, 0x3ef8,
  0x3ef0, 0x3ef3, 0x3ef5, 0x3efb, 0x3ef7, 0x3eef, 0x3f0b, 0x40a2,
  0x41f5, 0x41f3, 0x41f4, 0x41f2, 0x4298, 0x4368, 0x4380, 0x4385,
  0x438e, 0x438f, 0x3ef4, 0x4386, 0x43a4, 0x4486, 0x4489, 0x4487,
  0x4485, 0x1adc, 0x4488, 0x46ff, 0x4766, 0x01cc, 0x49c3, 0x01a2,
  0x49c4, 0x4a3b, 0x49e7, 0x49f8, 0x49fb, 0x01b6, 0x49be, 0x49c6,
  0x01c5, 0x01c6, 0x49fc, 0x49c0, 0x4a33, 0x49c9,
  /* 0x37 */
  0x49fe, 0x49da, 0x49cc, 0x49bb, 0x49fd, 0x49df, 0x49cd, 0x49c2,
  0x49c8, 0x4a32, 0x4a2d, 0x49d2, 0x4a31, 0x49d3, 0x4a2e, 0x49cf,
  0x4dff, 0x4e09, 0x4dfc, 0x4f72, 0x4faa, 0x4fab, 0x4fa7, 0x4f7b,
  0x4f76, 0x4fa8, 0x4fac, 0x0283, 0x1b21, 0x51aa, 0x4603, 0x51ac,
  0x51ad, 0x51ab, 0x5250, 0x5258, 0x53dd, 0x02f8, 0x53ae, 0x53a2,
  0x53ab, 0x53e3, 0x53af, 0x53e0, 0x53e4, 0x02f6, 0x53a7, 0x53aa,
  0x53e2, 0x53e1, 0x53df, 0x53ad, 0x53e5, 0x53d1, 0x53ac, 0x53d5,
  0x53a3, 0x539f, 0x5579, 0x5576, 0x5643, 0x563d, 0x5647, 0x5644,
  0x563f, 0x565b, 0x577f, 0x589a, 0x589c, 0x039b, 0x591e, 0x5a88,
  0x5a6a, 0x5a76, 0x5a72, 0x5a70, 0x5a7e, 0x5a6c, 0x5a6f, 0x5a75,
  0x5a77, 0x5a78, 0x5a8a, 0x5a79, 0x5a94, 0x5c01, 0x5d05, 0x5cf1,
  0x5cee, 0x5cef, 0x5d04, 0x1c3f, 0x5cfa, 0x5d07,
  /* 0x38 */
  0x5cf4, 0x5cf5, 0x5d9c, 0x5e6d, 0x5e69, 0x5e66, 0x5e62, 0x5e46,
  0x048d, 0x5e65, 0x5e5d, 0x5e5e, 0x5e5f, 0x5f8e, 0x6002, 0x6006,
  0x6004, 0x6003, 0x6062, 0x6127, 0x6121, 0x6120, 0x6124, 0x6129,
  0x6131, 0x6123, 0x6122, 0x62dc, 0x634d, 0x62e5, 0x62d3, 0x62ee,
  0x62e6, 0x0556, 0x6336, 0x6340, 0x643f, 0x633d, 0x6344, 0x055b,
  0x635f, 0x6329, 0x6349, 0x638a, 0x632a, 0x6387, 0x634c, 0x6331,
  0x6348, 0x632b, 0x633b, 0x6341, 0x62c9, 0x6334, 0x6353, 0x6335,
  0x6347, 0x6338, 0x65d1, 0x65d2, 0x6651, 0x6655, 0x6652, 0x6653,
  0x678f, 0x67f4, 0x6847, 0x680d, 0x681c, 0x67fb, 0x6819, 0x67f7,
  0x67f9, 0x67f5, 0x67e9, 0x680a, 0x67ee, 0x680b, 0x67fd, 0x6806,
  0x6802, 0x6816, 0x6818, 0x67f0, 0x6ad4, 0x6b66, 0x6b6a, 0x6b75,
  0x6b76, 0x6b80, 0x6b6d, 0x0696, 0x6b69, 0x6b67,
  /* 0x39 */
  0x6b68, 0x6b5d, 0x6ca4, 0x6cfe, 0x6cfd, 0x6dec, 0x6de9, 0x6e21,
  0x6deb, 0x6de7, 0x6df2, 0x6e20, 0x6f7a, 0x712d, 0x712e, 0x70ca,
  0x712f, 0x70c8, 0x077e, 0x70cb, 0x70c3, 0x7084, 0x70d2, 0x70c6,
  0x0781, 0x70cf, 0x70d5, 0x70d4, 0x70dd, 0x712b, 0x71a3, 0x70db,
  0x712c, 0x7113, 0x0835, 0x74d1, 0x74cc, 0x74d5, 0x74c9, 0x74cf,
  0x74d2, 0x757b, 0x757c, 0x7623, 0x761d, 0x761c, 0x761e, 0x7622,
  0x7624, 0x7620, 0x7618, 0x7621, 0x7788, 0x778a, 0x7794, 0x778f,
  0x778e, 0x7790, 0x089b, 0x77a7, 0x7864, 0x0900, 0x7a18, 0x7a14,
  0x7a1d, 0x7a05, 0x79ff, 0x7a1b, 0x7a1a, 0x7a19, 0x7a03, 0x7a0e,
  0x7a47, 0x7a04, 0x7a5a, 0x7a07, 0x7a20, 0x7e6a, 0x7e66, 0x7e7a,
  0x7e65, 0x7eaf, 0x81cd, 0x81cf, 0x81d1, 0x81ce, 0x825f, 0x8277,
  0x8274, 0x8288, 0x8275, 0x8289, 0x8272, 0x83c6,
  /* 0x3a */
  0x83ea, 0x83e0, 0x8407, 0x83e6, 0x83e5, 0x83dd, 0x83e3, 0x83da,
  0x85ae, 0x857e, 0x857d, 0x857f, 0x0ad3, 0x85d9, 0x86fa, 0x86fb,
  0x874d, 0x8754, 0x8751, 0x8750, 0x8998, 0x8995, 0x899d, 0x89c1,
  0x899a, 0x899b, 0x0b9f, 0x899c, 0x89d7, 0x89a4, 0x8996, 0x89a0,
  0x8b31, 0x8be9, 0x8c6e, 0x8d9a, 0x8da5, 0x8d94, 0x8da6, 0x8d99,
  0x8d8b, 0x8d98, 0x8d91, 0x8d8c, 0x8da1, 0x8da3, 0x8dc6, 0x8f6f,
  0x8f6d, 0x8f6a, 0x8f6c, 0x8f71, 0x8f6e, 0x8fdf, 0x90ac, 0x90aa,
  0x0cb1, 0x90b5, 0x90ad, 0x90b2, 0x90b3, 0x90ab, 0x90b6, 0x90c7,
  0x90c6, 0x926c, 0x9270, 0x93b3, 0x0d4b, 0x958c, 0x9581, 0x9583,
  0x957d, 0x9585, 0x9590, 0x95a2, 0x958d, 0x958f, 0x957e, 0x958a,
  0x957f, 0x9576, 0x9587, 0x9578, 0x9680, 0x9682, 0x9681, 0x9683,
  0x975a, 0x9734, 0x972c, 0x972a, 0x9740, 0x972d,
  /* 0x3b */
  0x9733, 0x972b, 0x974b, 0x293f, 0x973c, 0x9a5a, 0x9a77, 0x9a60,
  0x9bfa, 0x9bf9, 0x9bfc, 0x0ed6, 0x9bf5, 0x9be8, 0x9c09, 0x9be7,
  0x9be6, 0x9be9, 0x9e32, 0x9e2c, 0x9ebd, 0x9ebc, 0x9f7a, 0x9f7e,
  0x9f79, 0x0f89, 0xa023, 0xa030, 0xa028, 0xa0d4, 0xa6ce, 0xa0f1,
  0xa0f0, 0xa160, 0xa165, 0xa2a8, 0xa30a, 0xa31b, 0xa312, 0xa307,
  0xa34f, 0xa30e, 0xa352, 0xa316, 0x1000, 0xa353, 0xa354, 0x3bfd,
  0xa356, 0xa56d, 0xa572, 0xa62f, 0xa82a, 0x10dc, 0xa863, 0xa884,
  0xa8af, 0xa845, 0xa870, 0xa856, 0xa816, 0xa83d, 0xa838, 0xa86f,
  0xa877, 0xa82e, 0xa831, 0xa84c, 0xa85f, 0xa875, 0xa839, 0xa83a,
  0xa82c, 0xa82d, 0xa83f, 0xa82f, 0xa830, 0xa83e, 0x2bd0, 0x1190,
  0xadb2, 0xaeb7, 0xae8f, 0x11b1, 0xae96, 0xae9e, 0xae97, 0xae95,
  0xaea5, 0xae98, 0x2ce7, 0xaea3, 0xae9a, 0xaead,
  /* 0x3c */
  0xaea6, 0xaeb6, 0xae99, 0xaeaf, 0xaeac, 0x11aa, 0xae9f, 0xae94,
  0xb1eb, 0xb26f, 0xb26d, 0xb27e, 0xb26c, 0xb261, 0xb263, 0xb26b,
  0xb25e, 0xb23e, 0xb264, 0xb2ad, 0x127d, 0xb420, 0xb4d1, 0xb4d5,
  0xb5ae, 0xb5af, 0xb59f, 0xb5a8, 0xb5ca, 0xb7e1, 0xb839, 0xb838,
  0xb83b, 0xb8ad, 0xb8b5, 0xb8af, 0xb8b1, 0xb8ae, 0xb8b4, 0xb8b0,
  0xb94b, 0xb951, 0xb94c, 0x1369, 0xb960, 0xbabe, 0xbab9, 0xbab7,
  0xbab6, 0x13a1, 0xbabd, 0xbab8, 0xbac1, 0xbbf7, 0xbbf3, 0xbbf4,
  0xbbfb, 0xbbfd, 0xbbf5, 0x13e7, 0xbbfa, 0xbc14, 0x13ec, 0xbbf2,
  0xbbfc, 0xbc00, 0x13df, 0xbe2b, 0xbe29, 0xbe2e, 0x1433, 0xbed7,
  0xbedb, 0xbed9, 0xbed8, 0xbee6, 0xbed6, 0xbed1, 0xbee7, 0xbed0,
  0xbedc, 0xc0ed, 0xc11a, 0xc119, 0xc116, 0xc0ec, 0xc0ef, 0xc0ee,
  0xc0f4, 0xc12f, 0xc330, 0xc319, 0xc318, 0xc311,
  /* 0x3d */
  0xc316, 0xc312, 0xc310, 0xc314, 0xc40c, 0xc40d, 0xc510, 0xc529,
  0xc528, 0xc865, 0xc866, 0xc8de, 0xc8df, 0xc8e0, 0xc8d9, 0xc8db,
  0xc8d8, 0xc8e3, 0xc8d7, 0xcaa6, 0xcaa7, 0xcabf, 0xcaa8, 0xca9f,
  0xcaa1, 0xcaa2, 0xcaad, 0xcaa3, 0xcaa0, 0xcc83, 0xcc85, 0xcc82,
  0xcc84, 0xcdee, 0xce5d, 0xcf92, 0xd055, 0xd053, 0x3bfd, 0xd051,
  0xd052, 0xd050, 0xd19d, 0xd287, 0xd297, 0xd29b, 0xd29d, 0xd469,
  0xd611, 0x17ee, 0xd87a, 0x1832, 0x6e44, 0x3cc6, 0x3f40, 0x3f2e,
  0x3f68, 0x3f2d, 0x3f34, 0x3f32, 0x3f69, 0x3f31, 0x3f6a, 0x3f3e,
  0x3f6f, 0x3f75, 0x40f6, 0x4120, 0x4128, 0x4167, 0x41fb, 0x41fe,
  0x41fc, 0x41fd, 0x41ff, 0x41fa, 0x43ac, 0x43af, 0x43b1, 0x00fc,
  0x43bf, 0x43be, 0x43a7, 0x43aa, 0x4494, 0x4493, 0x4499, 0x012a,
  0x44fa, 0x4556, 0x4622, 0x4691, 0x4692, 0x4708,
  /* 0x3e */
  0x4706, 0x49d6, 0x4a37, 0x4a4b, 0x4ace, 0x4ad0, 0x4a39, 0x4a64,
  0x4acf, 0x4a46, 0x4a66, 0x4a56, 0x4a43, 0x4a4a, 0x4a58, 0x4a65,
  0x4a5a, 0x4a5b, 0x4a55, 0x4a50, 0x4a4c, 0x4acd, 0x4a51, 0x4a47,
  0x01d3, 0x4a53, 0x4a62, 0x4acc, 0x01d7, 0x4a7f, 0x4a4d, 0x4e0a,
  0x4e0c, 0x4e0f, 0x4fbb, 0x4fb9, 0x4feb, 0x4fae, 0x4fc1, 0x4fea,
  0x4fbe, 0x4fbf, 0x4fba, 0x4fb7, 0x4fb3, 0x4fe9, 0x516e, 0x51af,
  0x51b3, 0x51b2, 0x5268, 0x5269, 0x526a, 0x53de, 0x53eb, 0x5411,
  0x53ed, 0x53e9, 0x53f7, 0x53f4, 0x53ea, 0x5412, 0x53e8, 0x5413,
  0x558e, 0x5586, 0x5663, 0x5665, 0x5799, 0x58c2, 0x58ae, 0x58b0,
  0x58ad, 0x5ab4, 0x5ad1, 0x5aad, 0x03f3, 0x5abd, 0x5ab7, 0x5aab,
  0x5aaf, 0x5ac1, 0x5ab5, 0x5d0f, 0x5d0e, 0x5d1c, 0x5d13, 0x5d0a,
  0x5d1e, 0x5d14, 0x5d1a, 0x5dcb, 0x5e87, 0x5e93,
  /* 0x3f */
  0x0491, 0x5e84, 0x5e85, 0x5e92, 0x5e80, 0x5f2b, 0x5f63, 0x600a,
  0x04c0, 0x6066, 0x6134, 0x6133, 0x614d, 0x6389, 0x6357, 0x1e17,
  0x634a, 0x0563, 0x6339, 0x633f, 0x6390, 0x638f, 0x63b2, 0x639f,
  0x6395, 0x63a1, 0x639c, 0x638e, 0x63a0, 0x63ae, 0x6396, 0x63ca,
  0x63ac, 0x0570, 0x63a6, 0x6397, 0x6393, 0x3fb6, 0x65d6, 0x65e0,
  0x65d8, 0x6656, 0x686e, 0x687e, 0x6874, 0x6877, 0x6880, 0x687a,
  0x686b, 0x685f, 0x6876, 0x68b0, 0x6863, 0x6b92, 0x6b82, 0x6b9d,
  0x6b94, 0x6b83, 0x6b8b, 0x6b84, 0x6c57, 0x6c84, 0x6cb5, 0x6d09,
  0x6de6, 0x0702, 0x6e25, 0x6e51, 0x6f3e, 0x3bfd, 0x6f85, 0x713f,
  0x7142, 0x7138, 0x713a, 0x714e, 0x7145, 0x7139, 0x7137, 0x7144,
  0x3bfd, 0x71a4, 0x713d, 0x7141, 0x74df, 0x74de, 0x74ca, 0x74e9,
  0x74e2, 0x74e0, 0x7589, 0x7587, 0x7632, 0x7633,
  /* 0x40 */
  0x76ac, 0x76f9, 0x770d, 0x77b9, 0x7a5e, 0x7a6a, 0x0935, 0x7a81,
  0x7a69, 0x7aac, 0x7a80, 0x7a75, 0x7a71, 0x7a76, 0x7a6f, 0x7eb6,
  0x7f03, 0x7ebf, 0x7f01, 0x7eb2, 0x7ec4, 0x81db, 0x81dc, 0x81d8,
  0xd272, 0x82b5, 0x82a8, 0x828f, 0x829e, 0x828e, 0x83de, 0x83e2,
  0x8420, 0x841d, 0x841a, 0x8419, 0x842b, 0x8418, 0x8410, 0x840e,
  0x8424, 0x841f, 0x8413, 0x8435, 0x8583, 0x0ae0, 0x85d7, 0x8702,
  0x8703, 0x875c, 0x875f, 0x87c7, 0x889a, 0x8897, 0x88a3, 0x89f7,
  0x89c6, 0x89cc, 0x89d6, 0x89cd, 0x89f9, 0x89d9, 0x89d8, 0x0b9a,
  0x89d1, 0x89ce, 0x89d5, 0x0ba3, 0x89d4, 0x89f8, 0x8b7a, 0x8b79,
  0x8b7f, 0x8bf3, 0x8bf5, 0x8bf6, 0x8bf4, 0x8bf7, 0x0c05, 0x8c79,
  0x8d9c, 0x8ddf, 0x8df5, 0x8dff, 0x8dd1, 0x8dda, 0x8dcf, 0x8dcd,
  0x8dde, 0x8dd8, 0x76ad, 0x8de0, 0x8dfe, 0x8d9e,
  /* 0x41 */
  0x8f75, 0x8f73, 0x8f72, 0x8fd8, 0x90d0, 0x90d6, 0x90d7, 0x90ca,
  0x90cd, 0x928a, 0x9289, 0x928b, 0x93d3, 0x93da, 0x93ce, 0x93d2,
  0x0d5e, 0x93d4, 0x93d7, 0x93d5, 0x93fb, 0x93cd, 0x93fa, 0x93d6,
  0x0da6, 0x959b, 0x959e, 0x959d, 0x95a4, 0x959f, 0x95a5, 0x95a8,
  0x968f, 0x968c, 0x9695, 0x9760, 0x9755, 0x975c, 0x976f, 0x9751,
  0x9761, 0x97a7, 0x975e, 0x9762, 0x9754, 0x976e, 0x9752, 0x9758,
  0x976d, 0x975f, 0x976c, 0x9750, 0x975d, 0x978e, 0x9a72, 0x9a78,
  0x9a75, 0x9a76, 0x9a7c, 0x9a7e, 0x9a7d, 0x9c15, 0x9c14, 0x9c1d,
  0x9c1c, 0x9c23, 0x9c57, 0x9ec8, 0x0f5d, 0x9ec9, 0x9ec5, 0x9f87,
  0x9f8a, 0x9f94, 0xa039, 0xa040, 0xa03e, 0xa038, 0xa0d6, 0x0fb8,
  0xa177, 0xa178, 0xa17d, 0xa2dd, 0xa35e, 0xa377, 0xa3d4, 0xa366,
  0xa35f, 0xa373, 0xa372, 0xa397, 0xa35a, 0xa396,
  /* 0x42 */
  0xa35d, 0xa365, 0xa370, 0xa375, 0xa374, 0xa35c, 0xa360, 0x1034,
  0xa36d, 0xa541, 0xa63c, 0xa63e, 0x106f, 0xa649, 0xa7e4, 0xa90c,
  0xa915, 0xa90e, 0xa8d4, 0xa8c7, 0xa914, 0xa8db, 0xa95f, 0xa8ed,
  0xa909, 0xa8cf, 0xa8ff, 0xa91a, 0xa8f5, 0xa8ee, 0xa8e5, 0xa90d,
  0xa8df, 0xa8ec, 0xa8d7, 0xa92c, 0xa8cd, 0xa8e3, 0xa900, 0xa8eb,
  0xa8fd, 0xa90f, 0xa92d, 0xa950, 0xa8fe, 0xa8c4, 0xa8e1, 0xa8f9,
  0xadbb, 0xadbc, 0x1194, 0x1193, 0xadba, 0xaed0, 0xaed6, 0xaece,
  0xaee1, 0xaed5, 0xaecf, 0xaed3, 0x2d14, 0xaed4, 0xb1b5, 0xb290,
  0xb2a1, 0xb281, 0xb285, 0xb26e, 0xb288, 0xb282, 0xb286, 0xb28f,
  0xb289, 0xb280, 0xb284, 0x2ed1, 0xb429, 0xb42b, 0xb42a, 0xb430,
  0xb4e2, 0xb4e3, 0xb4e1, 0xb5d5, 0xb5c4, 0xb5c9, 0xb5e0, 0xb5df,
  0xb5cb, 0xb5dd, 0xb5e8, 0xb5d4, 0xb61c, 0xb7b5,
  /* 0x43 */
  0xb7b6, 0xb7e5, 0xb845, 0xb849, 0xb840, 0xb846, 0xb844, 0xb84a,
  0xb8c9, 0xb8c4, 0xb8c2, 0xb968, 0x31cb, 0xb982, 0xb96b, 0xb967,
  0xb96c, 0xb96d, 0xb971, 0x1392, 0xbad7, 0xbad2, 0xbad9, 0x13aa,
  0xbabc, 0xbadd, 0xbad6, 0x13a7, 0xbad8, 0xbc20, 0xbc16, 0xbc18,
  0xbc15, 0xbc19, 0xbc27, 0xbc50, 0xbc1d, 0xbc2c, 0xbc1c, 0xbc29,
  0xbc2b, 0xbc24, 0x13ef, 0xbc28, 0xbe39, 0xbef2, 0xbef0, 0x32ed,
  0xbeed, 0xbeef, 0xbeea, 0xbf01, 0xc0bc, 0xc15c, 0xc15b, 0xc15a,
  0xc126, 0xc343, 0xc333, 0xc33a, 0xc337, 0xc336, 0xc33c, 0xc334,
  0xc34a, 0xc33b, 0xc335, 0xc33d, 0xc340, 0xc33e, 0xc317, 0xc426,
  0xc424, 0xc410, 0xc436, 0xc425, 0x1522, 0xc566, 0xc87f, 0xc87a,
  0xc8fb, 0xc8fd, 0xc8fc, 0xc8fa, 0xcad6, 0xcad2, 0xcac8, 0xcac2,
  0xcac7, 0xcacd, 0xcac1, 0xcac6, 0xcacc, 0xcba1,
  /* 0x44 */
  0xcc95, 0xcc94, 0xcc97, 0xcc96, 0xcc93, 0xcca1, 0xce09, 0xce08,
  0xce67, 0xce65, 0xce62, 0xce61, 0xcf97, 0xd001, 0xd019, 0xd018,
  0xd05c, 0xd067, 0xd06c, 0x16b5, 0x3bfd, 0xd066, 0xd061, 0xd06e,
  0xd05d, 0xd05a, 0xd1a2, 0xd1a9, 0xd1a5, 0xd1a6, 0xd1b2, 0xd1a3,
  0xd2ac, 0xd2aa, 0xd2af, 0xd2ab, 0xd2b1, 0xd2c6, 0xd2ad, 0xd2b9,
  0xd470, 0x1775, 0xd80c, 0xd881, 0xd883, 0xd87e, 0xd951, 0xdb99,
  0xdb94, 0xdb95, 0xdefe, 0xe018, 0x3d05, 0x3f72, 0x0082, 0x3f99,
  0x40ad, 0x4206, 0x43c2, 0x43cb, 0x43d5, 0x43d2, 0x43cc, 0x43d7,
  0x43c5, 0x43ca, 0x1aec, 0x44a2, 0x44a3, 0x44a1, 0x1ae8, 0x44a6,
  0x44a4, 0x44ff, 0x4500, 0x0135, 0x4606, 0x4625, 0x469f, 0x477f,
  0x4aea, 0x4aeb, 0x4ade, 0x4b18, 0x4ae0, 0x4ae8, 0x4adf, 0x4af1,
  0x4aec, 0x4b1a, 0x4ae6, 0x4ae1, 0x4b5d, 0x3c77,
  /* 0x45 */
  0x4b1e, 0x01f0, 0x4b80, 0x4e17, 0x501d, 0x4ff7, 0x4fef, 0x4fee,
  0x4fed, 0x4ff5, 0x501e, 0x51bd, 0x93ff, 0x51be, 0x526d, 0x5276,
  0x544c, 0x5419, 0x5448, 0x541e, 0x544a, 0x5449, 0x5426, 0x5595,
  0x5685, 0x567e, 0x5697, 0x567d, 0x5742, 0x579e, 0x580c, 0x580b,
  0x580e, 0x58cf, 0x5ad8, 0x5ae0, 0x5ae8, 0x5ae9, 0x5ae2, 0x5ae1,
  0x5ada, 0x5ae3, 0x5ad9, 0x5af0, 0x5ae7, 0x5ae4, 0x5d23, 0x5d31,
  0x5d33, 0x5d0c, 0xa5e0, 0x5d26, 0x5d24, 0x5d32, 0x5d27, 0x5d21,
  0x5d30, 0x5da2, 0x5dcc, 0x5e96, 0x3bfd, 0x5e98, 0x5e9c, 0x5e9b,
  0x5f6b, 0x6012, 0x6014, 0x615a, 0x6154, 0x6151, 0x615e, 0x6158,
  0x04f0, 0x6159, 0x639a, 0x63f2, 0x63ad, 0x6420, 0x63f1, 0x63f0,
  0x63f3, 0x63f4, 0x63e9, 0x63fe, 0x642e, 0x63e8, 0x63e7, 0x63ff,
  0x63f5, 0x65e5, 0x65e7, 0x65e6, 0x65e9, 0x6658,
  /* 0x46 */
  0x686c, 0x68d9, 0x063e, 0x68cb, 0x0639, 0x68be, 0x68b5, 0x68d1,
  0x68c2, 0x68b6, 0x68d3, 0x3bfd, 0x6ada, 0x3bfd, 0x6bae, 0x06a1,
  0x6bac, 0x6ba9, 0x6bba, 0x6ba7, 0x6bb3, 0x6bbd, 0x6bb1, 0x6d0e,
  0x6d11, 0x6d0f, 0x6e52, 0x6e6a, 0x6e54, 0x6e55, 0x6e53, 0x6e57,
  0x3bfd, 0x6e5b, 0x6e58, 0x6e59, 0x073b, 0x71b8, 0x71b5, 0x71bf,
  0x71c1, 0x71bb, 0x07b7, 0x71c3, 0x71ad, 0x71a8, 0x71ae, 0x71aa,
  0x71d0, 0x71b1, 0x71bc, 0x71b7, 0x71b0, 0x71fa, 0x71fb, 0x71b9,
  0x7507, 0x74fc, 0x74ff, 0x74f2, 0x74f8, 0x74f4, 0x0857, 0x0870,
  0x76ae, 0x770f, 0x7710, 0xd6c1, 0x77c7, 0x77c6, 0x77ce, 0x08a7,
  0x77dc, 0x7ad5, 0x7ad3, 0x7b20, 0x7ae2, 0x7af1, 0x7adb, 0x7aea,
  0x7aeb, 0x7ae1, 0x7aff, 0x7ad6, 0x7ae0, 0x7ad7, 0x7ae5, 0x0954,
  0x7f1b, 0x7f10, 0x7f0f, 0x7f0e, 0x7f39, 0x7f0a,
  /* 0x47 */
  0x7f14, 0x7f0c, 0x8123, 0x815a, 0x81e2, 0x8293, 0x82b0, 0x82ab,
  0x82bd, 0x82b1, 0x828d, 0x82ad, 0x82aa, 0x82ac, 0x82bc, 0x82c9,
  0x8447, 0x8462, 0x8440, 0x8444, 0x843f, 0x8443, 0x843d, 0x8460,
  0x845f, 0x843a, 0x8442, 0x845e, 0x845d, 0x85bc, 0x85e0, 0x85ee,
  0x85eb, 0x860d, 0x8709, 0x870c, 0x8769, 0x8774, 0x8767, 0x0b31,
  0x2527, 0x88ad, 0x89ff, 0x8a16, 0x8a08, 0x8a09, 0x8a00, 0x89fc,
  0x8a13, 0x8a14, 0x8a0a, 0xd43e, 0x8a29, 0x8a17, 0x8a3b, 0x89fb,
  0x0bbf, 0x8a0e, 0x0be4, 0x8c08, 0x8e1b, 0x8e1a, 0x8e19, 0x8e02,
  0x0c4a, 0x8e17, 0x8e07, 0x8e13, 0x8e09, 0x8e0a, 0x8e12, 0x8eaa,
  0x8e38, 0x8f7b, 0x8f7c, 0x8f7a, 0x8fea, 0x8feb, 0x8fef, 0x8ff0,
  0x9109, 0x9102, 0x9101, 0x912b, 0x9107, 0x0ccf, 0x9128, 0x90fb,
  0x912a, 0x90fe, 0x9104, 0x9129, 0x910a, 0x278c,
  /* 0x48 */
  0x92c2, 0x2791, 0x92a6, 0x0d14, 0x6bc6, 0x5807, 0x940a, 0x93fd,
  0x9406, 0x940d, 0x9409, 0x940b, 0x9400, 0x9405, 0x943d, 0x95d5,
  0x95bf, 0x95ba, 0x95c7, 0x9698, 0x969a, 0x0e0d, 0x97a4, 0x979c,
  0x979d, 0x97a2, 0x9796, 0x9795, 0x97a5, 0x97aa, 0x97ad, 0x979a,
  0x97a3, 0x9797, 0x9790, 0x97af, 0x978d, 0x0e01, 0x97a8, 0x97ee,
  0x9aa3, 0x9a99, 0x9aa1, 0x9a9c, 0x9aa4, 0x9acb, 0x9c56, 0x9c48,
  0x9c59, 0x9c4a, 0x9c5c, 0x0ef1, 0x9c4f, 0x9c4d, 0x9c5d, 0x9e3a,
  0x9ee3, 0x9ee1, 0x9ede, 0x9f97, 0x9f9a, 0xa048, 0xa04a, 0xa04c,
  0xa04e, 0xa04f, 0xa04b, 0xa04d, 0xa047, 0xa051, 0xa0da, 0xa0f9,
  0xa0fc, 0xa0fb, 0xa0fd, 0xa0f8, 0xa0fa, 0xa18a, 0xa18e, 0xa188,
  0xa189, 0xa18d, 0xa190, 0x3bfd, 0xa31c, 0xa3ab, 0xa3a4, 0xa3a8,
  0xa3ad, 0xa39f, 0xa39a, 0xa3b0, 0xa3a5, 0xa3d5,
  /* 0x49 */
  0xa3a2, 0xa3b2, 0xa39d, 0xa3a1, 0xa515, 0xa542, 0xa573, 0xa584,
  0xa5dd, 0xa65c, 0xa64c, 0x1076, 0xa64b, 0xa867, 0xa9a8, 0xa97f,
  0xa98d, 0xa98b, 0xa9f7, 0xa9a9, 0xa9f4, 0xa99a, 0xa98c, 0xa995,
  0xa97e, 0xa977, 0x110a, 0x1103, 0xa971, 0xa9fd, 0xa988, 0xa999,
  0xa96d, 0xa9d4, 0xa991, 0xa97d, 0xa963, 0xa975, 0xa9f9, 0xa98e,
  0xa974, 0xa9d9, 0xa966, 0xa9fa, 0xa9f5, 0x2c60, 0xadc1, 0xadc9,
  0xaf03, 0xaf2c, 0xaf34, 0xaf17, 0xaf09, 0xaf04, 0xaf06, 0xaf1a,
  0xaf0e, 0xaf27, 0xaf05, 0xaf07, 0xaf19, 0xaf14, 0xaf0c, 0xaf1d,
  0xaf22, 0xaf23, 0xb1bb, 0xb1bc, 0xb1ba, 0xb2a9, 0xb2b5, 0xb2ac,
  0xb2aa, 0xb2af, 0xb2b7, 0x1235, 0x1236, 0xb43d, 0xb445, 0xb448,
  0xb43c, 0xb43e, 0xb4ec, 0xb4ed, 0xb4e9, 0xb60a, 0xb60b, 0xb5f8,
  0xb604, 0xb5f6, 0xb5f9, 0xb853, 0xb852, 0xb860,
  /* 0x4a */
  0xb863, 0xb8ce, 0xb8cd, 0xb8d0, 0xb8cc, 0xb987, 0xb98d, 0xb99d,
  0x1373, 0xba63, 0xbaf4, 0xbaf1, 0xbaff, 0xbaf5, 0xbafc, 0xbaf2,
  0xbaf6, 0x13b1, 0xbafa, 0x13af, 0xbc2e, 0xbc45, 0xbc43, 0xbc51,
  0xbc4c, 0xbc73, 0xbc47, 0xbc4b, 0xbc4f, 0x13f4, 0xbc44, 0xbc4d,
  0xbc4e, 0xbc4a, 0xbc41, 0xbc52, 0xbc9f, 0xbc54, 0xbc59, 0xbca2,
  0xbe4b, 0xbe48, 0xbf0d, 0xbf1f, 0xbf08, 0xbf0e, 0xbf1d, 0xbf04,
  0xc018, 0xc01b, 0xc166, 0xc162, 0xc183, 0xc167, 0xc362, 0xc34f,
  0xc34e, 0xc367, 0xc353, 0xc34d, 0xc34c, 0xc368, 0xc351, 0x14dc,
  0xc358, 0xc35b, 0xc350, 0xc36a, 0xc439, 0xc438, 0xc582, 0xc584,
  0xc586, 0xc880, 0xc886, 0xc925, 0xc911, 0x1599, 0xc90e, 0xc915,
  0xc90f, 0xc918, 0xc90d, 0xc913, 0xc916, 0xc919, 0xcb08, 0xcaf7,
  0xcafb, 0xcafc, 0xcbb4, 0xcbbe, 0xcbc1, 0xcca6,
  /* 0x4b */
  0xcca5, 0xcca2, 0xcca4, 0xce12, 0xce0e, 0xce7a, 0xce78, 0xce7d,
  0xce7e, 0xce81, 0xce83, 0xce80, 0xce82, 0xcf9b, 0xcf99, 0xcf9c,
  0xcf9a, 0xcfa1, 0xd01a, 0xd01c, 0xd08a, 0xd079, 0xd073, 0xd075,
  0xd07c, 0xd078, 0xd060, 0xd083, 0xd070, 0x16b6, 0x16bd, 0xd087,
  0xd084, 0xd07b, 0xd07e, 0xd074, 0xd1b9, 0xd1b8, 0xd1b7, 0xd1b5,
  0xd2cc, 0xd2ce, 0xd2d1, 0x3604, 0xd2cb, 0x369b, 0xd47e, 0xd47a,
  0xd477, 0xd48c, 0xd4e1, 0xd620, 0xd61e, 0xd6c2, 0xd70f, 0xd700,
  0x17f4, 0xd710, 0xd80d, 0xd80e, 0xd88e, 0xd88d, 0xd88a, 0xd88b,
  0xd88c, 0xd88f, 0xd957, 0x1835, 0xd955, 0xd95b, 0xdbac, 0xdba7,
  0xdba0, 0xdb9e, 0x18aa, 0xde8d, 0x191f, 0xdf93, 0xdf94, 0xdf92,
  0x3d81, 0x3fd6, 0x3fc3, 0x3fe4, 0x3fe2, 0x4009, 0x3fbf, 0x3fc8,
  0x3fc7, 0x40b5, 0x40b2, 0x420c, 0x420b, 0x420a,
  /* 0x4c */
  0x4205, 0x43d3, 0x43e6, 0x43e9, 0x43f0, 0x43ea, 0x43e7, 0x44b1,
  0x44b3, 0x44b4, 0x44b0, 0x455c, 0x455d, 0x455e, 0x45c0, 0x46af,
  0x0150, 0x4786, 0x4783, 0x4784, 0x4b5c, 0x4b70, 0x4b8c, 0x4b7b,
  0x4b66, 0x4b79, 0x4b63, 0x4bc5, 0x4b6b, 0x4b6d, 0x4b72, 0x4b69,
  0x4b75, 0x4b89, 0x4bc6, 0x4ba5, 0x3fe7, 0x4b6a, 0x4b97, 0x505a,
  0x505c, 0x5059, 0x5024, 0x5025, 0x5030, 0x5058, 0x5031, 0x5176,
  0x51c1, 0x5285, 0x527d, 0x5465, 0x5487, 0x5452, 0x5454, 0x548a,
  0x5450, 0x5486, 0x544f, 0x5468, 0x559d, 0x56a0, 0x56ba, 0x56bd,
  0x56b8, 0x57a6, 0x037b, 0x58de, 0x58d8, 0x58d1, 0x5b13, 0x0409,
  0x5b0e, 0x5b1b, 0x5b3a, 0x0407, 0x5b1c, 0x5b12, 0x5b16, 0x5b1a,
  0x5048, 0x5d4b, 0x5d37, 0x5d36, 0x5d38, 0x5d3a, 0x5d49, 0x5d3c,
  0x5d4a, 0x5eb1, 0x5ec2, 0x5eb5, 0x5ec4, 0x5eb6,
  /* 0x4d */
  0x601e, 0x601f, 0x60af, 0x616b, 0x616f, 0x6392, 0x63e4, 0x642c,
  0x63ef, 0x3bfd, 0x644f, 0x6452, 0x6450, 0x643a, 0x6437, 0x6447,
  0x6464, 0x6440, 0x643c, 0x6445, 0x6441, 0x65f3, 0x05bb, 0x68c1,
  0x68b4, 0x064b, 0x692a, 0x6922, 0x6929, 0x064d, 0x693e, 0x693c,
  0x6930, 0x6bc7, 0x6bd5, 0x6bd6, 0x6bd3, 0x6bce, 0x6bc8, 0x6c5c,
  0x6c5f, 0x6c62, 0x06c2, 0x6cbd, 0x6cbf, 0x6e5c, 0x6eb6, 0x071a,
  0x6e9d, 0x6e7f, 0x0712, 0x6e94, 0x6e81, 0x6f47, 0x6f46, 0x073c,
  0x6f94, 0x7275, 0x721a, 0x722a, 0x7232, 0x7217, 0x7223, 0x7274,
  0x07c3, 0x7276, 0x722e, 0x7225, 0x7220, 0x7271, 0x7216, 0x7270,
  0x722c, 0x722f, 0x721f, 0x7264, 0x07c0, 0x7508, 0x7514, 0x750a,
  0x750b, 0x764f, 0x7659, 0x7654, 0x7651, 0x76b6, 0x77ec, 0x77ed,
  0x77ea, 0x7aee, 0x7b5a, 0x7b73, 0x7b65, 0x7b61,
  /* 0x4e */
  0x7b55, 0x7b6b, 0x7b64, 0x7b5b, 0x7b4c, 0x7b6f, 0x7b84, 0x7b70,
  0x7f5d, 0x7f57, 0x7f66, 0x7f53, 0x7f98, 0x7f97, 0x8128, 0x81eb,
  0x81ea, 0x81e8, 0x81ec, 0x81ef, 0x82d1, 0x82ca, 0x239f, 0x82cf,
  0x82cd, 0x82ce, 0x8470, 0x8467, 0x8473, 0x846d, 0x8476, 0x8479,
  0x846a, 0x848b, 0x8472, 0x8471, 0x846e, 0x847a, 0x8616, 0x8639,
  0x863b, 0x8710, 0x8796, 0x877b, 0x877c, 0x877d, 0x88be, 0x8a5c,
  0x8a38, 0x8a39, 0x8a2e, 0x8a34, 0x8a32, 0x8a5b, 0x8a33, 0x8a3c,
  0x0be5, 0x8c0e, 0x8c0f, 0x8c10, 0x8c87, 0x8e5b, 0x8e53, 0x0c5f,
  0x8e5c, 0x8e3f, 0x8e59, 0x8e4a, 0x8e44, 0x8e4c, 0x8e40, 0x8e5f,
  0x8e5e, 0x8e4e, 0x8e54, 0x8e43, 0x8e87, 0x8f82, 0x8f85, 0x9131,
  0x9147, 0x912e, 0x912f, 0x9148, 0x9134, 0x0d18, 0x419f, 0x9432,
  0x9436, 0x9433, 0x9431, 0x9440, 0x9441, 0x95dd,
  /* 0x4f */
  0x95d2, 0x95d9, 0x0dad, 0x95df, 0x95db, 0x95d8, 0x95d3, 0x95de,
  0x95e0, 0x95d4, 0x95d7, 0x95da, 0x96a7, 0x97fe, 0x97dd, 0x9840,
  0x97e2, 0x0e1e, 0x97d6, 0x97de, 0x97ef, 0x0e27, 0x97eb, 0x97ea,
  0x97e4, 0x97d1, 0x0e18, 0x97ec, 0x97fa, 0x97d9, 0x97f3, 0x97e1,
  0x97dc, 0x97e5, 0x97df, 0x97d4, 0x0e20, 0x9805, 0x9ad6, 0x9ad5,
  0x9ad0, 0x9ac8, 0x9ac4, 0x9ac9, 0x9acd, 0x9ad2, 0x9acc, 0x9aca,
  0x9ca0, 0x9c92, 0x0ef4, 0x0f02, 0x9c8b, 0x9ca1, 0x9c95, 0x9c88,
  0x9c86, 0x9c8d, 0x9c85, 0x9c91, 0x9c89, 0x9ca2, 0x9ef0, 0x9ef3,
  0x9ef4, 0x9eef, 0x9f06, 0x9fa2, 0xa05e, 0xa063, 0xa060, 0xa05b,
  0xa07b, 0xa058, 0xa059, 0xa05d, 0xa105, 0xa106, 0xa102, 0xa103,
  0xa104, 0xa1a2, 0xa1a7, 0xa1a6, 0xa1a4, 0xa1ac, 0xa1a9, 0xa3e7,
  0xa401, 0xa3df, 0xa3d9, 0xa3e3, 0xa40f, 0xa51a,
  /* 0x50 */
  0xa545, 0xa548, 0xa57b, 0xa585, 0xa586, 0xa5fe, 0xa5ff, 0xa664,
  0xa671, 0xa672, 0xa661, 0xa662, 0xa66c, 0xa660, 0xa65d, 0xa663,
  0xa667, 0xaa01, 0xaa2a, 0xaa30, 0xaa06, 0xaa7d, 0xaa22, 0xaab9,
  0xaa0a, 0xaa10, 0xa98f, 0xaa80, 0xaa13, 0xaa2e, 0xaa18, 0xaa17,
  0xaa1a, 0xaa14, 0xaa47, 0xaa63, 0xaa38, 0x1124, 0xaa7f, 0xaa21,
  0xaa37, 0xaa31, 0xaa1b, 0xaaa5, 0xab6c, 0xadd3, 0xaf88, 0xaf6e,
  0xaf5c, 0xaf74, 0xaf54, 0xaf83, 0x2d70, 0xaf65, 0xaf60, 0xaf70,
  0xaf6f, 0xaf6d, 0xaf72, 0xaf6c, 0xaf76, 0xaf75, 0xaf59, 0xafc7,
  0xb1c1, 0xb1f9, 0xb2e3, 0xb2e7, 0xb2d6, 0xb2cf, 0xb2da, 0xb2e9,
  0xb2d2, 0xb455, 0xb44f, 0xb44d, 0xb451, 0xb456, 0xb4f9, 0xb4f8,
  0xb506, 0xb503, 0xb509, 0xb4f7, 0xb4f5, 0xb647, 0xb645, 0xb63e,
  0xb646, 0xb629, 0xb634, 0xb63f, 0xb644, 0xb635,
  /* 0x51 */
  0xb65a, 0xb62a, 0xb633, 0xb637, 0xb643, 0xb639, 0xb630, 0xb65d,
  0xb632, 0xb627, 0xb7bd, 0xb7ba, 0xb7bc, 0xb7f1, 0xb7f0, 0xb861,
  0xb85c, 0xb858, 0xb85d, 0xb8da, 0xb8d9, 0xb8dd, 0xb8dc, 0xb8de,
  0x137d, 0xb9a0, 0xb9a2, 0xbb0f, 0xbb13, 0xbb12, 0xbb11, 0xbb14,
  0xbb19, 0xbb0e, 0xbb17, 0xbb21, 0xbb20, 0xbb16, 0xbc78, 0x3237,
  0xbc87, 0xbc79, 0xbc80, 0xbc77, 0xbc81, 0xbc46, 0xbc7a, 0xbc9c,
  0xbc83, 0xbc84, 0xbcad, 0xbc9d, 0xbc9e, 0xbe55, 0xbf36, 0xbf2b,
  0xbf27, 0xbf46, 0xbf2c, 0xbf45, 0xbf33, 0xbf2d, 0xbf34, 0xbf22,
  0x1464, 0xc01f, 0xc1b3, 0xc18c, 0xc18f, 0xc1af, 0xc1ad, 0xc18e,
  0xc1ac, 0xc1b0, 0xc1b1, 0xc1ae, 0xc199, 0xc2eb, 0xc374, 0xc375,
  0xc38e, 0xc36d, 0xc370, 0xc38c, 0xc44f, 0xc451, 0xc458, 0xc44c,
  0xc44e, 0xc515, 0xc5be, 0xc5db, 0xc5b3, 0xc5ae,
  /* 0x52 */
  0xc887, 0xc88a, 0xc888, 0xc88b, 0xc88c, 0xc944, 0xc92d, 0xc92a,
  0xc931, 0xc92c, 0xc945, 0xc930, 0xc929, 0xc946, 0xcaf4, 0xcb14,
  0xcb10, 0xcb0f, 0xcb12, 0xcb0b, 0xcb0c, 0xcb0a, 0xcb13, 0xcb0e,
  0xcbd9, 0xcbd0, 0x3503, 0xccc1, 0xccbf, 0xccbd, 0xccbc, 0xccba,
  0xccbb, 0xccd1, 0xccbe, 0xccd0, 0xccb9, 0xce1a, 0xce1c, 0xce1b,
  0xce91, 0xce96, 0xce9f, 0xce9c, 0xce9a, 0xce9d, 0xcfad, 0xcfa5,
  0xcfae, 0xd003, 0xd026, 0xd020, 0xd023, 0xd024, 0xd021, 0xd028,
  0xd025, 0xd01e, 0xd094, 0xd093, 0xd08f, 0xd09a, 0xd0ad, 0x16c2,
  0xd1ca, 0xd1c5, 0xd2bb, 0xd2e1, 0xd2ea, 0xd2e4, 0xd2ed, 0xd2e6,
  0xd2e0, 0xd2e8, 0xd2e5, 0xd41a, 0xd494, 0xd496, 0xd49e, 0xd495,
  0xd4a1, 0xd48e, 0xd49b, 0xd492, 0xd497, 0xd499, 0xd493, 0xd632,
  0xd62f, 0xd62e, 0xd633, 0xd71c, 0xd71e, 0xd711,
  /* 0x53 */
  0xd720, 0xd71f, 0xd719, 0xd716, 0xd8ac, 0xd8b9, 0xd8b3, 0xd8a6,
  0xd8a2, 0xd8a9, 0xd8a7, 0xd96c, 0xd96d, 0xd969, 0xd980, 0xd966,
  0xd965, 0xd971, 0xd96b, 0xdbbd, 0xdbc1, 0xdbd3, 0xdbb6, 0x18ac,
  0xdbb9, 0xdbd4, 0xdbb7, 0xdbdb, 0xdbb8, 0xdbc0, 0xdbbc, 0xdbd5,
  0xdbbf, 0xdbc3, 0xdbc9, 0xde58, 0xde90, 0xde95, 0xde97, 0xdf09,
  0xdf08, 0xdf06, 0xdf05, 0xdf10, 0xdf97, 0xdf95, 0xdfee, 0xe01f,
  0x3bfd, 0x574b, 0x3d8e, 0x3fe8, 0x3ff0, 0x3ff4, 0x4006, 0x3fed,
  0x009b, 0x3fe9, 0x4000, 0x40b8, 0x416d, 0x4404, 0x4401, 0x4403,
  0x4402, 0x1af6, 0x0126, 0x4562, 0x46ba, 0x4713, 0x4bde, 0x4bd7,
  0x4be4, 0x4bce, 0x4be3, 0x4bdd, 0x4c3a, 0x4bdb, 0x4bd6, 0x4be0,
  0x4bd4, 0x4bcb, 0x4be1, 0x4bc9, 0x4bdf, 0x4c3c, 0x4bfc, 0x4bcf,
  0x5079, 0x5076, 0x5078, 0x5287, 0x549c, 0x54b1,
  /* 0x54 */
  0x54c1, 0x549a, 0x5492, 0x3bfd, 0x54c2, 0x5496, 0x54c0, 0x5491,
  0x5495, 0x55a2, 0x56c3, 0x56c0, 0x56c2, 0x478a, 0x57b0, 0x5816,
  0x5b46, 0x5b4a, 0x5b3e, 0x5b45, 0x5b42, 0x0415, 0x5b5b, 0x5b44,
  0x5c04, 0x7c22, 0x5d55, 0x5d57, 0x5d51, 0x5d4e, 0x5d5a, 0x5ec6,
  0x5ec3, 0x049c, 0x5ec5, 0x5ecc, 0x5f71, 0x6026, 0x60b2, 0x617a,
  0x6184, 0x617b, 0x6474, 0x648c, 0x6451, 0x6448, 0x648d, 0x6492,
  0x6498, 0x6493, 0x64b0, 0x644e, 0x6496, 0x6497, 0x649c, 0x64ca,
  0x6933, 0x6983, 0x6984, 0x699a, 0x698c, 0x20cc, 0x6999, 0x6ae0,
  0x6be4, 0x6bf8, 0x6bed, 0x6bf3, 0x6bf4, 0x6bf5, 0x6bfd, 0x6d19,
  0x6e9e, 0x6ec4, 0x6e9f, 0x6f9b, 0x6f9f, 0x6f9a, 0x72aa, 0x729d,
  0x7292, 0x72a2, 0x72af, 0x72eb, 0x72a0, 0x72a1, 0x7294, 0x7298,
  0x728f, 0x7287, 0x7284, 0x72a9, 0x727c, 0x7518,
  /* 0x55 */
  0x765f, 0x7662, 0x7661, 0x76c0, 0x7715, 0x77fc, 0x77f9, 0x7bc8,
  0x7bc9, 0x7bde, 0x7bca, 0x7be2, 0x0964, 0x096e, 0x7c04, 0x7bcc,
  0x7bdd, 0x7be4, 0x7bd3, 0x7bc7, 0x7bc6, 0x095f, 0x7c37, 0x7fd8,
  0x7fee, 0x7fb2, 0x7fa3, 0x7fb3, 0x7fed, 0x7ff8, 0x8131, 0x815b,
  0x8166, 0x8169, 0x8196, 0x819b, 0x81f7, 0x81f3, 0x81f4, 0x81f5,
  0x82e2, 0x82e7, 0x82e5, 0x82e9, 0x82e6, 0x82e3, 0x8474, 0x847f,
  0x848f, 0x8490, 0x8497, 0x84a3, 0x848e, 0x8498, 0x848c, 0x8642,
  0x8644, 0x8669, 0x8643, 0x8668, 0x0af6, 0x878d, 0x8788, 0x878b,
  0x8789, 0x88cc, 0x891f, 0x8a80, 0x8a5e, 0x8a67, 0x8a68, 0x8a65,
  0x264a, 0x8a74, 0x8a69, 0x8a61, 0x8a62, 0x8a6c, 0x8a93, 0x8a86,
  0x8b9d, 0x8b9b, 0x8c1b, 0x8c16, 0x8c19, 0x8c14, 0x8c18, 0x8c15,
  0x8c99, 0x8c98, 0x8e5d, 0x8e89, 0x8e7a, 0x8e7d,
  /* 0x56 */
  0x8e4b, 0x0c73, 0x8e78, 0x8e7f, 0x8e77, 0x8e7e, 0x8e79, 0x8eab,
  0x8e7c, 0x8e74, 0x8e75, 0x8ea7, 0x8f8d, 0x914e, 0x9166, 0x9161,
  0x914d, 0x914f, 0x0cdd, 0x9154, 0x917c, 0x92da, 0x92de, 0x92d8,
  0x92dd, 0x92df, 0x9466, 0x9462, 0x945f, 0x9464, 0x9463, 0x9460,
  0x9488, 0x946a, 0x9467, 0x9487, 0x943f, 0x946c, 0x946e, 0x94ad,
  0x95f1, 0x95f4, 0x95f6, 0x95f5, 0x95f8, 0x95fb, 0x95ec, 0x95ef,
  0x95ed, 0x28b9, 0x95f7, 0x95f9, 0x95fd, 0x96b1, 0x9836, 0x981b,
  0x9832, 0x9842, 0x984d, 0x981f, 0x9821, 0x981c, 0x9831, 0x982e,
  0x9847, 0x983b, 0x9841, 0x9818, 0x9839, 0x981d, 0x9827, 0x9823,
  0x29d7, 0x9aee, 0x9ae8, 0x9ae5, 0x9aef, 0x9ae4, 0x9aec, 0x9af0,
  0x9cd7, 0x9cd8, 0x9cd4, 0x9cca, 0x9cd2, 0x9ccb, 0x9cd3, 0x9ce6,
  0x9ce2, 0x9e49, 0x9e48, 0x9eff, 0x9f09, 0x9fb0,
  /* 0x57 */
  0x9faf, 0xa07c, 0xa078, 0xa07a, 0xa072, 0xa079, 0xa07e, 0xa10c,
  0xa10b, 0xa1cd, 0xa1be, 0xa1bc, 0xa1bf, 0xa1c0, 0xa1bd, 0xa438,
  0xa408, 0xa405, 0xa43b, 0xa410, 0xa40c, 0xa40d, 0xa404, 0xa43a,
  0xa413, 0xa437, 0xa439, 0xa51f, 0xa54b, 0xa5ee, 0xa675, 0xa678,
  0xa67c, 0xa674, 0xa676, 0xa6ea, 0xa6eb, 0xa9fb, 0xaa19, 0xaaa7,
  0xaa8c, 0xaadc, 0xaa98, 0xaabe, 0xaa9e, 0xab0f, 0xaa9f, 0xaadd,
  0xaa93, 0xaabb, 0xaab6, 0xaa90, 0xaaa1, 0xaabd, 0xaade, 0xaa3a,
  0xab22, 0xaa97, 0xaa94, 0xaac3, 0xaa8e, 0xaaa8, 0xaa99, 0xaaad,
  0xaa9b, 0xaaa2, 0xab21, 0xaaac, 0xab0e, 0xab31, 0xade1, 0xadde,
  0xaddf, 0xaddc, 0xaddd, 0xadec, 0xade7, 0xaf69, 0xafb8, 0xafa1,
  0xafa8, 0xafba, 0xafc2, 0xafa6, 0xafa4, 0xafa3, 0xafab, 0xafbc,
  0xafb7, 0xafbf, 0xafad, 0xafb1, 0xafca, 0xafc4,
  /* 0x58 */
  0xafb9, 0xb1c8, 0xb1c6, 0xb1c7, 0xb30a, 0xb30d, 0xb2fb, 0xb303,
  0xb302, 0xb2fc, 0xb2f9, 0xb2f8, 0xb46e, 0xb463, 0xb462, 0xb461,
  0xb46b, 0x1288, 0xb46f, 0xb466, 0xb46c, 0xb50e, 0xb515, 0xb516,
  0xb510, 0xb517, 0xb511, 0xb66e, 0xb66c, 0xb687, 0xb683, 0xb663,
  0xb6dc, 0xb7c0, 0xb7f7, 0xb7fa, 0xb870, 0xb86a, 0xb868, 0xb869,
  0xb884, 0xb8ec, 0xb8e7, 0xb8ee, 0xb9ba, 0xb9b2, 0xb9b5, 0xb9cb,
  0x440b, 0xb9d0, 0xba6d, 0xba6c, 0x13bb, 0xbb45, 0xbb46, 0xbb34,
  0xbb2c, 0xbb35, 0xbb44, 0x13ba, 0xbb76, 0xbcb1, 0xbcaa, 0xbca1,
  0xbcb2, 0x1412, 0xbca6, 0xbcb5, 0xbcb4, 0xbcb8, 0xbcaf, 0xbcb0,
  0xbca3, 0xbe62, 0xbe64, 0xbf56, 0xbf51, 0xbf4f, 0xbf68, 0xbf4c,
  0xbf50, 0x1461, 0xbf48, 0xbf4a, 0xc021, 0xc1e3, 0xc1b9, 0xc1de,
  0xc1b7, 0xc1e1, 0xc1b6, 0xc1b5, 0xc1df, 0x14e1,
  /* 0x59 */
  0xc397, 0xc39a, 0xc39b, 0xc398, 0xc392, 0xc393, 0xc3d7, 0xc373,
  0xc46b, 0xc474, 0xc478, 0xc46d, 0xc518, 0xc5e9, 0xc5f5, 0xc5ea,
  0xc62e, 0xc5e7, 0xc5fe, 0xc5e5, 0xc636, 0xc5f0, 0xc5e6, 0xc62c,
  0xc889, 0xc895, 0xc893, 0xc94d, 0xc94a, 0xc94f, 0xc950, 0xc94b,
  0xcb2a, 0xcb2b, 0xcb2f, 0xcb2e, 0xcb7c, 0xcbed, 0xcbe2, 0xcce0,
  0xccdc, 0xccda, 0xccd6, 0xccf4, 0xccd9, 0xccd5, 0xce22, 0xce21,
  0xce24, 0xce25, 0xce26, 0xce23, 0xceaa, 0xceaf, 0xceb0, 0xceab,
  0xcfaf, 0xcfb7, 0xcfb5, 0xcfb2, 0xcfb3, 0xd02b, 0xd0d8, 0xd0c2,
  0xd0af, 0xd0bc, 0xd0b8, 0xd0be, 0xd0b7, 0xd0b4, 0xd0bf, 0xd0b3,
  0xd0b1, 0xd0bb, 0xd0bd, 0xd0d6, 0xd0dd, 0xd1d8, 0xd1d3, 0xd1d5,
  0xd1e3, 0xd1e2, 0xd1d9, 0xd1de, 0xd1df, 0xd1da, 0xd1d4, 0xd2f3,
  0xd2e2, 0xd30d, 0xd301, 0xd305, 0xd31a, 0xd303,
  /* 0x5a */
  0xd31f, 0xd316, 0xd2fa, 0xd2fc, 0xd30a, 0x369f, 0xd4bc, 0xd4ca,
  0xd4b6, 0xd4c7, 0xd4bf, 0x1789, 0xd4b9, 0x178c, 0xd4b0, 0xd4b8,
  0xd4bd, 0xd491, 0xd4bb, 0xd4be, 0xd63e, 0xd63d, 0xd738, 0xd73d,
  0xd739, 0xd733, 0xd833, 0xd8bb, 0xd8c6, 0xd8c5, 0xd8c7, 0xd8cb,
  0xd8a8, 0xd8c8, 0xd8be, 0xd8c1, 0xd8bd, 0xd982, 0xd99e, 0xd981,
  0xd984, 0x378d, 0xd996, 0xd98e, 0xd988, 0xd987, 0xdbe0, 0xdc0d,
  0xdbdf, 0xdbe4, 0xdbe2, 0xdbdd, 0xdbec, 0xdbde, 0xdbe7, 0xdbea,
  0xdbe3, 0xde5c, 0x3a77, 0xde5d, 0xde9c, 0xdf1d, 0xdf9d, 0xdf9e,
  0xdf9b, 0xdfb5, 0xdfb9, 0xdfb6, 0xdff3, 0xdff2, 0xdff4, 0xe026,
  0xe027, 0xe025, 0xe106, 0xe10b, 0xe13a, 0xe13c, 0x400a, 0x400b,
  0x40bf, 0x40fd, 0x4218, 0xcddf, 0x8f90, 0x429e, 0x43fc, 0x4410,
  0x440f, 0x440d, 0x44b9, 0x44b7, 0x44ba, 0x450a,
  /* 0x5b */
  0x4c41, 0x4c8b, 0x4c46, 0x4c53, 0x4ce2, 0x4c3f, 0x4b7c, 0x4c4b,
  0x4c4e, 0x4c8a, 0x4c47, 0x5093, 0xb9ce, 0x508c, 0x50af, 0x50c9,
  0x51c6, 0x51c8, 0x5291, 0x54cf, 0x54d4, 0x54ce, 0x56dd, 0x56d4,
  0x5b49, 0x5b63, 0x5b5d, 0x041a, 0x5b67, 0x5bbb, 0x5b60, 0x5b80,
  0x5d5f, 0x5d60, 0x5eda, 0x5ed2, 0x5edd, 0x618e, 0x6188, 0x616c,
  0x649e, 0x64c9, 0x64a4, 0x0598, 0x64d9, 0x64d2, 0x64da, 0x64dd,
  0x64ce, 0x64fc, 0x6614, 0x6660, 0x69d7, 0x69cb, 0x69cd, 0x69d5,
  0x6ae7, 0x6c00, 0x6c0a, 0x6c0f, 0x6c02, 0x6c01, 0x6d1d, 0x6eca,
  0x6ecb, 0x6ecd, 0x6f4f, 0x6f9c, 0x7280, 0x730d, 0x7302, 0x07f1,
  0x7307, 0x72f7, 0x72f8, 0x72fd, 0x7324, 0x72fb, 0x7339, 0x733a,
  0x7522, 0x3bfd, 0x766a, 0x766d, 0x7674, 0x780e, 0x7bdf, 0x7c2b,
  0x7be3, 0x7c26, 0x7c2a, 0x7c23, 0x7c35, 0x7c4a,
  /* 0x5c */
  0x7ffd, 0x8000, 0x801e, 0x7fff, 0x819e, 0x81fa, 0x82f1, 0x8495,
  0x84a8, 0x84a6, 0x866e, 0x8683, 0x866d, 0x878f, 0x0b6a, 0x88df,
  0x88d5, 0x88e0, 0x88d3, 0x88d8, 0x8a8c, 0x264b, 0x8a94, 0x8a96,
  0x8a85, 0x8a8f, 0x8aa9, 0x8a8e, 0x8a90, 0x8ab8, 0x8ac3, 0x8abb,
  0x8ba5, 0x8ba2, 0x26a2, 0x8ba3, 0x8cb5, 0x8cac, 0x8ca8, 0x8ead,
  0x8eb8, 0x8eb4, 0x8eae, 0x8eb6, 0x1085, 0x8ec1, 0x8ebf, 0x8f92,
  0x9000, 0x9001, 0x9175, 0x9172, 0x9178, 0x9170, 0x917e, 0x917d,
  0x917f, 0x92ef, 0x946d, 0x948e, 0x948f, 0x948a, 0x948d, 0x9495,
  0x948b, 0x948c, 0x94b0, 0x9493, 0x95fc, 0x9615, 0x960e, 0x9618,
  0x9611, 0x960d, 0x96bb, 0x96b3, 0x0e39, 0x98a1, 0x989a, 0x9884,
  0x98a0, 0x9886, 0x989d, 0x98aa, 0x9878, 0x988d, 0x988a, 0x98a6,
  0x987a, 0x9897, 0x9888, 0x988e, 0x0e3d, 0x0e44,
  /* 0x5d */
  0x9876, 0x9881, 0x9885, 0x9875, 0x98a8, 0x988f, 0x9891, 0x98a2,
  0x989c, 0x9889, 0x987f, 0x9896, 0x9879, 0x989f, 0x98a7, 0x0e46,
  0x9887, 0x989b, 0x98a5, 0x988b, 0x98c9, 0x9aff, 0x9b03, 0x9b00,
  0x9b02, 0x9b04, 0x9b05, 0x9ae6, 0x9b1f, 0x9d14, 0x0f0e, 0x9d0c,
  0x9d0f, 0x9d19, 0x9d0b, 0x9d13, 0x9cd5, 0x0f10, 0x9d1c, 0x9e50,
  0x9e4e, 0x9f12, 0x9fb9, 0xa085, 0xa088, 0xa090, 0xa113, 0xa1d0,
  0xa1d1, 0xa1d2, 0xa1d7, 0xa1d6, 0xa1e5, 0xa446, 0xa46b, 0xa445,
  0xa43f, 0xa43e, 0x103e, 0xa46a, 0xa468, 0xa44c, 0xa523, 0xa522,
  0xa597, 0xa591, 0x96b5, 0xa598, 0xa59c, 0xa689, 0x1084, 0xa68b,
  0xa68a, 0xa68d, 0xa68e, 0xa688, 0xab4e, 0xab44, 0xab37, 0xab75,
  0xab54, 0xab76, 0xab34, 0xab6b, 0xab32, 0xab57, 0xab52, 0xab45,
  0x1149, 0xaab1, 0xab4b, 0xab47, 0xab33, 0xab40,
  /* 0x5e */
  0xab3c, 0xab43, 0xab4f, 0xab55, 0xab41, 0xabb2, 0xabc0, 0xb034,
  0xaff9, 0xb019, 0xb00d, 0xaffa, 0xb01e, 0xb01f, 0xb00e, 0xb040,
  0xb008, 0x11df, 0xb013, 0xb04c, 0x11f0, 0xb1cc, 0xb1cb, 0xb324,
  0xb325, 0xb33d, 0xb320, 0xb327, 0xb326, 0xb31d, 0xb31e, 0xb332,
  0xb36c, 0xb359, 0x128a, 0xb47a, 0xb479, 0xb51b, 0xb52e, 0xb523,
  0xb520, 0xb51f, 0xb6b6, 0xb6b9, 0xb6a1, 0xb6a3, 0xb6a8, 0xb6af,
  0xb69a, 0xb699, 0xb6a2, 0xb69d, 0x1302, 0xb6ab, 0xb7c9, 0xb7fe,
  0xb800, 0xb7fc, 0xb807, 0xb875, 0xb872, 0xb873, 0xb874, 0xb8fa,
  0xb8fc, 0xb8f8, 0xb8f6, 0xb8fb, 0xb9cd, 0xb9d1, 0xb9cf, 0xba74,
  0xba72, 0xba73, 0xbb54, 0xbb51, 0x13c0, 0xbb53, 0xbb49, 0xbb4c,
  0xbb4a, 0xbb4f, 0xbb56, 0xbd00, 0xbcd5, 0xbcd7, 0xbcff, 0xbcd9,
  0xbce3, 0xbcd3, 0x1415, 0xbcd8, 0xbcd4, 0xbcde,
  /* 0x5f */
  0xbe71, 0xbf74, 0xbf88, 0xbf7f, 0xbf6b, 0xbf87, 0xbf79, 0xbf78,
  0xbf89, 0xbf80, 0xbf76, 0xc029, 0xc028, 0xc02f, 0xc1e5, 0xc204,
  0xc203, 0xc1f0, 0xc1e8, 0xc1ea, 0xc1f1, 0xc201, 0xc202, 0xc3a9,
  0xc3ab, 0xc3b7, 0xc3b6, 0x14e2, 0xc4a0, 0xc48e, 0xc486, 0xc487,
  0xc485, 0xc48b, 0xc488, 0xc490, 0xc51a, 0xc534, 0xc637, 0xc62f,
  0xc630, 0xc639, 0xc634, 0xc633, 0xc685, 0xc684, 0xc63a, 0xc89f,
  0xc969, 0xc96c, 0xc96a, 0xc967, 0xc96b, 0xcb3f, 0xcb40, 0xcc0b,
  0xccd2, 0xccf8, 0xcd01, 0xccfa, 0xcd16, 0x3bfd, 0xce2c, 0xce2d,
  0xce2f, 0xce2e, 0xcec1, 0xcef5, 0xcec4, 0xcede, 0xcecc, 0xced2,
  0xcec2, 0xcecd, 0xcecf, 0xcedd, 0xcec8, 0xcfba, 0xcfbe, 0xcfbf,
  0xd02e, 0xd030, 0xd0e7, 0xd0ee, 0xd0e8, 0xd0e6, 0xd0e2, 0xd0e4,
  0xd0fb, 0xd0fc, 0xd0ea, 0xd1ed, 0xd1f6, 0xd1f3,
  /* 0x60 */
  0xd1f4, 0xd1f1, 0xd1f7, 0xd1f5, 0xd1ea, 0xd1eb, 0xd300, 0xd32c,
  0xd312, 0xd33d, 0xd333, 0x174d, 0xd330, 0xd340, 0xd331, 0xd357,
  0x174a, 0xd335, 0xd332, 0xd32d, 0xd336, 0xd338, 0xd362, 0xd35f,
  0xd38a, 0xd4d6, 0xd4d8, 0xd4dd, 0xd4e4, 0xd4e3, 0xd64d, 0xd6d7,
  0xd74a, 0xd74c, 0xd750, 0xd74b, 0xd74e, 0xd74f, 0xd839, 0xd8d2,
  0xd8cd, 0xd8d3, 0xd8e1, 0xd8ce, 0xd8d5, 0xd8dd, 0xd8d4, 0xd8cf,
  0xd9cb, 0xd9a6, 0xd9c2, 0xd9a5, 0xd9a9, 0xd9a2, 0xd9a4, 0xd9b0,
  0xd9cc, 0xd9af, 0xd9bf, 0xdc24, 0xdc1a, 0xdc14, 0xdc3a, 0xdc20,
  0xdc1b, 0xdc21, 0xdc25, 0xdc1e, 0xdc3f, 0xdc40, 0xdc18, 0xdc2c,
  0xdc15, 0xdc2d, 0xdc1f, 0xdc29, 0xdc4b, 0xdeb3, 0xdea5, 0xdea7,
  0xdeab, 0xdea6, 0xdeaa, 0xdf22, 0xdf23, 0xdfa1, 0xdfa3, 0xdfa0,
  0xdfbd, 0xdfba, 0xdffa, 0xdff8, 0xdffc, 0xdff6,
  /* 0x61 */
  0xe034, 0xe043, 0x1963, 0xe0d4, 0xe10d, 0xe143, 0xe141, 0xe13d,
  0xe140, 0xe13e, 0xe13f, 0xe146, 0x1993, 0xe1d4, 0x4035, 0x4036,
  0x4032, 0x403a, 0x40c8, 0x4136, 0x421e, 0x421d, 0x421f, 0x441c,
  0x441d, 0x4420, 0x010e, 0x44c0, 0x4c9a, 0x4c93, 0x4cdd, 0x020a,
  0x4ca3, 0x4ca9, 0x4c9c, 0x4c9b, 0x020d, 0x4c97, 0x50b1, 0x50ca,
  0x50b3, 0x50cd, 0x54ea, 0x54ee, 0x54ef, 0x56df, 0x5750, 0x57bb,
  0x5b88, 0x5b89, 0x5b8c, 0x5b85, 0x5b5e, 0x5b94, 0x5b95, 0x5d6b,
  0x5d6a, 0x5d69, 0x5ee3, 0x5ef1, 0x6037, 0x6033, 0x6191, 0x618f,
  0x6197, 0x64d4, 0x64de, 0x64d3, 0x64e0, 0x6543, 0x650b, 0x64ff,
  0x6504, 0x6507, 0x69f9, 0x69fa, 0x69fb, 0x69f8, 0x6c12, 0x6c10,
  0x6d1f, 0x6edf, 0x6ee3, 0x6f52, 0x6fa9, 0x7365, 0x7387, 0x7342,
  0x7352, 0x734c, 0x729f, 0x7301, 0x7348, 0x734f,
  /* 0x62 */
  0x737e, 0x734d, 0x7358, 0x7347, 0x735e, 0x7349, 0x734e, 0x735d,
  0x735a, 0x7386, 0x7351, 0x7529, 0x75a6, 0x75a7, 0x7670, 0x766f,
  0x76d3, 0x76d2, 0x7828, 0x781b, 0x781a, 0x781c, 0x7821, 0x7c32,
  0x7c66, 0x7c7d, 0x7c73, 0x7c7f, 0x7c65, 0x7c80, 0x7c61, 0x7c75,
  0x7c6e, 0x7c67, 0x7c71, 0x7c6c, 0x7c63, 0x7c62, 0x7c83, 0x7cb2,
  0x7c81, 0x7c6f, 0x7c6b, 0x7c82, 0x7c8a, 0x8029, 0x8030, 0x8031,
  0x8197, 0x8200, 0x81ff, 0x84b6, 0x84b5, 0x84c3, 0x868d, 0x8718,
  0x879c, 0x879a, 0x8799, 0x8ab7, 0x8ac4, 0x8ac6, 0x8ac7, 0x8abc,
  0x8ac0, 0x8ac5, 0x8acd, 0x8ac1, 0x8abe, 0x8ba7, 0x8bb8, 0x8c23,
  0x0c74, 0x8ee8, 0x8ede, 0x8ee3, 0x8eef, 0x8edc, 0x8ee4, 0x8ee1,
  0x8ee5, 0x8f95, 0x8f94, 0x8f93, 0x8f8e, 0x9198, 0x919c, 0x9199,
  0x91a0, 0x919e, 0x9304, 0x94d3, 0x94b4, 0x94bb,
  /* 0x63 */
  0x94b7, 0x94b8, 0x94bd, 0x94b6, 0x94b9, 0x94b5, 0x9622, 0x9621,
  0x96c3, 0x96bc, 0x98ff, 0x98e5, 0x98f7, 0x98d2, 0x9900, 0x98db,
  0x98f0, 0x98e2, 0x98cd, 0x0e56, 0x98e1, 0x98f2, 0x98dc, 0x98cc,
  0x98d6, 0x98f3, 0x98fa, 0x98f6, 0x98ec, 0x98ea, 0x98e3, 0x98d0,
  0x0e5a, 0x9895, 0x98d5, 0x98f4, 0x98cb, 0x98da, 0x98c8, 0x98df,
  0x98f5, 0x98cf, 0x98c7, 0x98d7, 0x9b24, 0x0ea3, 0x9b1c, 0x9b21,
  0x9b1e, 0x9b18, 0x9b1b, 0x0ea8, 0x9d46, 0x9d4b, 0x9d48, 0x9d47,
  0x9d67, 0x9d54, 0x9f15, 0x9f22, 0x9fc5, 0x9f29, 0x9fc7, 0xa08d,
  0xa11b, 0xa120, 0xa1e2, 0xa1e7, 0xa1e8, 0xa1e1, 0xa472, 0xa47b,
  0xa474, 0xa471, 0xa479, 0xa475, 0xa490, 0xa477, 0xa47d, 0xa54f,
  0xa550, 0xa5a3, 0xa5a2, 0xa5f4, 0xa694, 0xa69a, 0xa69b, 0xa6a7,
  0xa697, 0xa695, 0xa692, 0xa69c, 0xa696, 0xabb6,
  /* 0x64 */
  0xabb8, 0xabb0, 0xac18, 0xabc5, 0xabb5, 0xabc2, 0xac06, 0xac19,
  0xabb9, 0xac15, 0xabd6, 0xabac, 0x113c, 0xabc6, 0xabb3, 0xabc3,
  0xabca, 0xabcf, 0xabbd, 0xabce, 0xac14, 0xabba, 0xac1a, 0xabc1,
  0xabbb, 0x119b, 0x119a, 0xae01, 0xadfc, 0xb05a, 0xb054, 0xb061,
  0xb05c, 0xb055, 0xb04a, 0xb04b, 0xb051, 0xb069, 0xb06b, 0x2df1,
  0xb066, 0xb058, 0xb05d, 0xb067, 0xb056, 0xb088, 0xb064, 0xb04e,
  0xb357, 0xb35a, 0xb351, 0xb34a, 0xb34b, 0x125e, 0xb347, 0xb36f,
  0xb36a, 0xb36b, 0xb346, 0xb36d, 0xb354, 0xb36e, 0xb34c, 0xb478,
  0xb486, 0xb482, 0x12a7, 0xb6e1, 0xb6e5, 0xb6db, 0xb6de, 0xb6d7,
  0xb803, 0xb87c, 0xb87e, 0xb905, 0xb907, 0xb9e6, 0xb9e1, 0xb9fb,
  0xb9e5, 0xb9e7, 0xb9df, 0xb9ff, 0xba76, 0xbb63, 0xbb66, 0xbb65,
  0xbb5e, 0xbb64, 0xbb6b, 0xbb5f, 0xbb67, 0xbb68,
  /* 0x65 */
  0xbd08, 0xbd09, 0xbd17, 0xbd15, 0xbd1b, 0xbd0b, 0xbd28, 0xbd0e,
  0xbd18, 0xbd53, 0xbd45, 0xbd0d, 0xbd0a, 0xbd13, 0xbd4a, 0xbe79,
  0xbfa1, 0xbf8d, 0xbfa2, 0xbf90, 0x146e, 0xc031, 0xc030, 0xc21f,
  0xc219, 0xc20c, 0xc21e, 0xc21d, 0xc207, 0xc366, 0xc3c5, 0xc3ba,
  0xc3bd, 0xc3c2, 0xc3c3, 0xc3bf, 0x150d, 0xc4a1, 0xc4a2, 0xc4a8,
  0xc4a3, 0xc4aa, 0xc4af, 0xc4b9, 0xc537, 0xc68f, 0x1543, 0xc68e,
  0xc687, 0xc68a, 0xc692, 0xc697, 0xc69f, 0xc705, 0xc8a9, 0xc8a7,
  0xc98a, 0xc982, 0xc985, 0xc98b, 0xc989, 0xc981, 0xc980, 0xc987,
  0xc986, 0xcb4d, 0xcc1c, 0xcc1f, 0xcd21, 0xcd1d, 0xcd22, 0xccfe,
  0xcd1b, 0xcd3a, 0xcd37, 0xcd17, 0xcd38, 0xcd26, 0xcd18, 0xce34,
  0xce35, 0xce32, 0x1673, 0xcee1, 0xcefd, 0xcee3, 0xcee8, 0xcef9,
  0xceff, 0xcefe, 0x1674, 0xcee0, 0xcf00, 0x1670,
  /* 0x66 */
  0xceec, 0xcee4, 0xceef, 0xcefa, 0xcfca, 0xd031, 0xd032, 0xd034,
  0xd041, 0xd100, 0xd106, 0xd108, 0xd105, 0xd103, 0xd10b, 0xd102,
  0xd10a, 0xd1f0, 0xd213, 0xd20a, 0xd20f, 0xd211, 0xd208, 0xd20b,
  0xd212, 0xd20d, 0xd35b, 0xd363, 0xd361, 0xd368, 0xd35a, 0xd44e,
  0xd44d, 0xd450, 0xd4fc, 0xd512, 0xd4f5, 0xd51e, 0xd4f0, 0xd4f3,
  0xd4f2, 0xd501, 0xd4ef, 0xd4ee, 0xd516, 0xd4f6, 0xd4fb, 0xd51c,
  0x17db, 0xd65d, 0xd660, 0xd666, 0xd65f, 0xd661, 0xd65b, 0xd662,
  0xd657, 0xd769, 0xd76b, 0xd761, 0xd777, 0xd75f, 0xd763, 0xd762,
  0xd765, 0xd8ef, 0xd8e2, 0xd900, 0xd8e8, 0xd8f2, 0xd8e7, 0x1829,
  0xd8e5, 0xd9d5, 0xd9d0, 0xd9da, 0xd9d3, 0x1851, 0xd9d9, 0xd9cf,
  0xd9d6, 0xd9d8, 0xd9f5, 0xd9ce, 0xd9d7, 0xd9f4, 0xd9cd, 0xda01,
  0x37ba, 0xdc52, 0xdc55, 0xdc5a, 0xdc4d, 0xdc54,
  /* 0x67 */
  0xdc53, 0xdc5e, 0xdc67, 0xdc65, 0xdc4e, 0x18db, 0xdc4f, 0xdc61,
  0xdc6e, 0xdc51, 0xdc5b, 0xde63, 0xdeb7, 0xdeb6, 0xdec3, 0xdebb,
  0xdeb5, 0xdf2e, 0xdf30, 0xdf33, 0xdf31, 0xdfa4, 0xdfc1, 0xdfbb,
  0xdfbe, 0xe000, 0xdfff, 0xe040, 0x1965, 0xe03f, 0xe044, 0x1964,
  0x1967, 0xe0db, 0xe10f, 0xe111, 0xe14e, 0xe14d, 0xe14b, 0xe14c,
  0xe195, 0x403b, 0x4045, 0x4044, 0x403e, 0x403c, 0x403f, 0x40cc,
  0x40ce, 0x4222, 0x4223, 0x429f, 0x44c5, 0x44c4, 0x4ce9, 0x4c99,
  0x0211, 0x4ce6, 0x4ce7, 0x4cf7, 0x50d2, 0x0333, 0x54fd, 0x550c,
  0x550b, 0x58ed, 0x0421, 0x0422, 0x5b9b, 0x5c0a, 0x5d6f, 0x5d75,
  0x5ef2, 0x5ef8, 0x603e, 0x6524, 0x650e, 0x6516, 0x6518, 0x6510,
  0x6531, 0x6544, 0x05a6, 0x6529, 0x652f, 0x654b, 0x6536, 0x05a3,
  0x6a34, 0x6a00, 0x6a2b, 0x6c20, 0x6c21, 0x6c1e,
  /* 0x68 */
  0x6c1d, 0x6ef5, 0x6ef2, 0x6ef6, 0x7390, 0x739d, 0x739c, 0x7392,
  0x7394, 0x73d1, 0x7393, 0x73b7, 0x7397, 0x73b0, 0x739f, 0x73c9,
  0x752d, 0x752c, 0x7677, 0x782c, 0x7cc0, 0x7cb9, 0x8053, 0x8140,
  0x8302, 0x82fb, 0x0aa1, 0x868b, 0x86ae, 0x86ab, 0x87a1, 0xdecd,
  0x88ea, 0x8add, 0x8adc, 0x8ad9, 0x8bab, 0x8bac, 0x8bad, 0x8bb2,
  0x8c2c, 0x8c2b, 0x8cc2, 0x8f00, 0x8f0d, 0x8f06, 0x8eff, 0x8f03,
  0x8f01, 0x8f10, 0x8f0f, 0x8f05, 0x8f98, 0x8f97, 0x8f96, 0x8f99,
  0x91ac, 0x91ab, 0x9312, 0x94d8, 0x94df, 0x94d6, 0x962d, 0x9632,
  0x993f, 0x992f, 0x9926, 0x993a, 0x9939, 0x0e5f, 0x993b, 0x9935,
  0x992a, 0x9921, 0x9938, 0x9937, 0x9934, 0x0e5c, 0x9922, 0x9936,
  0x9944, 0x9b45, 0x9b3b, 0x9b36, 0x9b42, 0x9d7a, 0x9d86, 0x9d8b,
  0x9d7f, 0x9d81, 0x9f2a, 0x9fd5, 0xa09f, 0xa09d,
  /* 0x69 */
  0xa126, 0xa1f4, 0xa1f5, 0xa415, 0xa48e, 0xa48f, 0xa526, 0xa5a7,
  0xa5af, 0xa6ad, 0xa6ac, 0xa6ab, 0xa6aa, 0xac2f, 0xac21, 0xac23,
  0xaca3, 0xac49, 0xac3a, 0xac48, 0xac2d, 0xac25, 0xac29, 0xac32,
  0xac34, 0xac24, 0xac2c, 0xac4b, 0xac3b, 0xac20, 0xac28, 0xb098,
  0x11f5, 0xb097, 0x2e04, 0xb09d, 0xb0a8, 0xb1d5, 0xb377, 0xb378,
  0xb372, 0xb373, 0xb402, 0xb53b, 0xb6fe, 0xb70b, 0xb6ff, 0xb707,
  0x1311, 0x130c, 0xb730, 0xb7cd, 0xb7cf, 0xb810, 0xb80a, 0xb883,
  0xb915, 0xb90e, 0xb90c, 0xba02, 0xb9fe, 0xba05, 0xba15, 0xba08,
  0xbb7f, 0xbb77, 0xbb7c, 0xbb82, 0xbb7e, 0xbb78, 0xbb7d, 0xbb79,
  0xbb81, 0xbd4b, 0xbd63, 0xbd64, 0xbd56, 0xbd54, 0xbd4e, 0xbd10,
  0xbd4f, 0xbd57, 0xbd5e, 0xbd51, 0xbd6a, 0xbd69, 0xbfad, 0xbfa4,
  0xbfac, 0xbfa9, 0xbfae, 0x404c, 0xc250, 0xc235,
  /* 0x6a */
  0xc232, 0xc3d8, 0xc3d1, 0xc3cf, 0xc3be, 0xc4d5, 0xc4c1, 0xc4c6,
  0xc4c3, 0xc4c2, 0xc4c0, 0xc4c5, 0xc4c7, 0xc4bf, 0xc4c4, 0xc4d4,
  0xc690, 0xc6d2, 0x154e, 0xc6d4, 0xc8af, 0xc8ae, 0xc8b2, 0xc8ad,
  0xc99c, 0xc9a0, 0xc9b6, 0xcb3d, 0xcb56, 0xcb82, 0xcc28, 0xcc2b,
  0xcd3c, 0xcd3e, 0xcd3f, 0xcd42, 0xcd3d, 0xcd41, 0xcd3b, 0xcd49,
  0xcd43, 0xce39, 0xce38, 0xcf22, 0xcf08, 0xcf0c, 0xcf06, 0xcf13,
  0xcf04, 0xcf20, 0xcf1d, 0xcf05, 0xcf0a, 0xcfd6, 0xcfd7, 0xd036,
  0xd037, 0xd123, 0xd122, 0xd120, 0xd11a, 0xd11d, 0xd21c, 0xd220,
  0xd277, 0xd37f, 0xd38b, 0xd37d, 0xd399, 0xd384, 0xd389, 0xd385,
  0xd383, 0xd386, 0xd39e, 0xd453, 0xd517, 0x1794, 0xd519, 0xd520,
  0xd51f, 0xd523, 0xd518, 0xd521, 0xd529, 0xd524, 0xd526, 0xd65e,
  0xd66f, 0xd66e, 0xd674, 0xd672, 0xd673, 0xd77d,
  /* 0x6b */
  0xd77e, 0xd785, 0xd77f, 0xd784, 0xd844, 0xd8f5, 0xd8f8, 0xd903,
  0xd8f6, 0xda28, 0x1863, 0xda39, 0xd9fb, 0xda0e, 0xd9fd, 0xda1f,
  0x1861, 0xda03, 0x37d8, 0xda10, 0x185a, 0xda0d, 0xda27, 0xda41,
  0xdc72, 0xdc78, 0xdc80, 0x18e3, 0xdc85, 0xdc7b, 0x397c, 0xdc7d,
  0xdc91, 0xdc88, 0xdcaa, 0xdc8d, 0xdc89, 0xdc95, 0xdc9b, 0xdc8c,
  0xdc9e, 0xdc7c, 0xdc86, 0xdc84, 0xde68, 0xdec5, 0xdec4, 0xdec9,
  0xdec6, 0xdf42, 0xdf45, 0xdf41, 0xdf44, 0xdfa6, 0xdfc2, 0xe042,
  0xe049, 0xe048, 0xe04a, 0xe04c, 0xe04b, 0xe117, 0xe118, 0xe115,
  0xe152, 0xe154, 0xe153, 0xe19a, 0xe19b, 0xe1dc, 0xe1e4, 0xe291,
  0x19af, 0xe2ba, 0x4051, 0x405b, 0x40cf, 0x6f05, 0x4d13, 0x4d15,
  0x4d14, 0x4d23, 0x0213, 0x4d11, 0x4d12, 0x0280, 0x50f0, 0x529b,
  0x5512, 0x5516, 0x5517, 0x55b5, 0x58f4, 0x5bb1,
  /* 0x6c */
  0x5d79, 0x5eff, 0x5efc, 0x5efb, 0x603f, 0x6044, 0x619d, 0x6532,
  0x654c, 0x652b, 0x655a, 0x661f, 0x6a01, 0x6a2d, 0x6a27, 0x6a59,
  0x6a5a, 0x6a4d, 0x6a58, 0x6c23, 0x6c25, 0x6c2b, 0x6eff, 0x6fae,
  0x73cb, 0x73ca, 0x73d0, 0x73ce, 0x73cc, 0x73d8, 0x73c6, 0x73d2,
  0x73cf, 0x73c8, 0x7717, 0x19b0, 0x7cc4, 0xce40, 0x7ce9, 0x7cf2,
  0x7cfc, 0x7cea, 0x7ceb, 0x7cfd, 0x8078, 0x8077, 0x8073, 0x809e,
  0x8079, 0x81a2, 0x8203, 0x8304, 0x8305, 0x84ce, 0x86bf, 0x8af6,
  0x8af7, 0x8c31, 0x8c30, 0x8cc9, 0x8cc7, 0x8f1c, 0x8f28, 0x8f1a,
  0x8f1e, 0x8f1b, 0x8f1f, 0x91bf, 0x91bb, 0x91bc, 0x91c0, 0x931a,
  0x94ef, 0x94ec, 0x94e9, 0x94f0, 0x94fe, 0x9634, 0x996a, 0x9995,
  0x996c, 0x9972, 0x9967, 0x9960, 0x996b, 0x995e, 0x996f, 0x9966,
  0x2a46, 0x9962, 0x995d, 0x995c, 0x3bfd, 0x9b50,
  /* 0x6d */
  0x9d9f, 0x0f23, 0x9d9e, 0x9da6, 0x9f35, 0x9f38, 0x9f36, 0x9f3a,
  0x9fdc, 0xa47c, 0xa4ab, 0x1049, 0xa4a8, 0xa4a7, 0xa52b, 0xa52c,
  0xa528, 0x452b, 0xa5a9, 0xa5aa, 0xa5ab, 0xa5f8, 0xa6b1, 0xa6f0,
  0xa6ef, 0xaca8, 0xac8b, 0xac94, 0xac9e, 0xac8f, 0xac88, 0xac7e,
  0xac81, 0xac30, 0xac9b, 0xac82, 0xac90, 0xac85, 0xac7f, 0xaca9,
  0xacde, 0xae0d, 0x11fa, 0xb0cf, 0xb0cb, 0xb0d8, 0xb0dd, 0xb0d3,
  0xb0d0, 0xb0d5, 0xb0d6, 0xb1d6, 0xb392, 0xb395, 0xe1cb, 0xb38d,
  0xb39b, 0xb39d, 0xb38f, 0xb39e, 0xb3a6, 0xb496, 0xb492, 0xb716,
  0xb72a, 0xb729, 0xb72c, 0xb815, 0xb812, 0xb811, 0xb813, 0xb888,
  0xb88b, 0xb88a, 0xb887, 0xb917, 0xb916, 0xb91a, 0xba19, 0xba17,
  0xbb91, 0xbb94, 0xbd8b, 0xbd90, 0xbd8f, 0xbd86, 0xbd83, 0xbd8e,
  0xbd87, 0xbda8, 0xbd85, 0xbda6, 0xbd82, 0xbda7,
  /* 0x6e */
  0xbfb9, 0xbfb7, 0xbfb4, 0xbfb6, 0xbfb3, 0xbfc6, 0xc23c, 0xc240,
  0xc238, 0xc391, 0xc3a6, 0xc3da, 0xc4da, 0xc4d8, 0xc4d9, 0xc4db,
  0xc4d7, 0xc716, 0xc712, 0xc71f, 0x1559, 0xc714, 0xc71a, 0xc710,
  0xc8b3, 0xc9ae, 0xc9c1, 0xc9b0, 0xc9af, 0xc9b1, 0xc9ad, 0xc9b2,
  0xc9c4, 0xcc3c, 0xcc3f, 0xcd61, 0xcd66, 0xce3c, 0xce3b, 0xcf2c,
  0x167e, 0xcf2a, 0xcf3e, 0xcf2f, 0xcf32, 0xcf27, 0xcf29, 0xcf40,
  0xcfdf, 0xcfde, 0xd03c, 0xd03b, 0xd03e, 0xd121, 0xd146, 0xd13c,
  0xd136, 0xd138, 0xd135, 0xd231, 0xd236, 0xd22d, 0xd233, 0xd22f,
  0xd22e, 0xd235, 0xd3ac, 0xd3a9, 0xd3a6, 0x17a8, 0xd54c, 0xd543,
  0xd541, 0xd54f, 0xd542, 0xd551, 0x17a9, 0xd540, 0xd550, 0xd545,
  0xd54a, 0xd54b, 0xd683, 0xd682, 0xd681, 0xd6e0, 0xd798, 0xd79f,
  0xd79b, 0xd79a, 0xd799, 0xd796, 0xd7ae, 0xd79e,
  /* 0x6f */
  0xd909, 0xd90d, 0xda4e, 0xda4a, 0xda4d, 0xda40, 0xda3e, 0xda48,
  0xda42, 0xda62, 0xda45, 0xda51, 0xdcc6, 0xdcd0, 0xdcc0, 0xdcb7,
  0xdcc2, 0xdcbc, 0xdcc5, 0xdcdc, 0xdcdb, 0xdcd2, 0xdcc7, 0xdcb6,
  0xdcc9, 0x398d, 0xdcd1, 0xdccd, 0xdcda, 0xdcba, 0xdcd3, 0xdcce,
  0xdcf6, 0xdcbd, 0xdcdd, 0xdcc8, 0xdd0d, 0xdd35, 0xde71, 0xde6e,
  0xde6f, 0xded6, 0xdf4c, 0xdf4f, 0xdf54, 0xdf53, 0xdfc9, 0xdfc8,
  0xe003, 0x1954, 0xe004, 0x3bfd, 0xe057, 0xe052, 0xe053, 0x196d,
  0xe056, 0xe05c, 0xe055, 0xe164, 0xe15d, 0xe15e, 0xe1a2, 0xe1a3,
  0x198e, 0xe1e7, 0xe1e6, 0xe298, 0xe2ac, 0xe2af, 0xe2ae, 0x4059,
  0x41a9, 0x442a, 0x44c7, 0x4d41, 0x4d37, 0x4d35, 0x4d33, 0x4d39,
  0x4d32, 0x50ff, 0x5101, 0x50f8, 0x551b, 0x5519, 0x57bf, 0x5bbc,
  0x5bbe, 0x5bbd, 0x5d7d, 0x6046, 0x6047, 0x61a4,
  /* 0x70 */
  0x6621, 0x6662, 0x6a86, 0x0672, 0x6c2f, 0x6c31, 0x0814, 0x73f8,
  0x73f5, 0x73f9, 0x73f2, 0x73fa, 0x73f3, 0x7414, 0x73fd, 0x740f,
  0x740e, 0x7401, 0x7537, 0x7535, 0x7534, 0x7531, 0x767a, 0x767b,
  0x7837, 0x7d2b, 0x7cfb, 0x7d16, 0x7d13, 0x0993, 0x7d11, 0x7d0f,
  0x7d1b, 0x7d38, 0x80a4, 0x8309, 0x8307, 0x830b, 0x84d3, 0x84d1,
  0x84d8, 0x871d, 0x87a9, 0x87d0, 0xae15, 0x8b02, 0x8b05, 0x8b01,
  0x8b00, 0x8f2e, 0x8f30, 0x8f2f, 0x8f31, 0x91d2, 0x91d3, 0x9502,
  0x9640, 0x9642, 0x963b, 0x96ce, 0x9998, 0x998f, 0x9994, 0x9991,
  0x0e6f, 0x99ba, 0x9990, 0x9986, 0x999a, 0x998c, 0x9993, 0x9987,
  0x9988, 0x9997, 0x998d, 0x999c, 0x99bd, 0x9b3c, 0x9b59, 0x0eb0,
  0x9dd1, 0x9dbb, 0x9dbe, 0x9e5d, 0x9fe2, 0xa205, 0xa4ba, 0x012e,
  0xa4f4, 0xa5b2, 0xa5f9, 0xa6b7, 0xa6b6, 0xac89,
  /* 0x71 */
  0xacf9, 0xacd9, 0xace8, 0xacd4, 0xacdb, 0xace2, 0xacdf, 0xacd1,
  0xace9, 0xacea, 0xae13, 0xae11, 0xb0fa, 0xb0f8, 0xb0f4, 0xb0fb,
  0xb10e, 0xb102, 0xb10f, 0xb390, 0xb3ad, 0xb3a9, 0xb548, 0xb75a,
  0xb74f, 0xb74e, 0xb755, 0xb754, 0xb74a, 0xb7d5, 0xb818, 0xb88d,
  0xb91d, 0xb919, 0xba26, 0xba28, 0xba2b, 0xba7d, 0xbba0, 0xbb9a,
  0xbb9b, 0xbdb5, 0xbdad, 0xbdb2, 0xbe94, 0xbfc9, 0xc24e, 0xc24f,
  0xc244, 0xc252, 0xc4e9, 0xc539, 0x1569, 0x347e, 0xc9c7, 0xc9d3,
  0xc9c6, 0xc9c3, 0x15b4, 0xc9d2, 0xcb66, 0xcd7f, 0xcd80, 0xcd84,
  0xcd85, 0xcde3, 0x164d, 0xce41, 0xce44, 0xce43, 0xcf4e, 0xcf4f,
  0x1683, 0xcf49, 0xcf4a, 0xcf4b, 0xcf43, 0xcfe0, 0xcfe5, 0xcfe1,
  0xcfe6, 0xcfe2, 0xd00c, 0xd040, 0xd149, 0xd14a, 0xd154, 0xd14c,
  0xd155, 0xd156, 0xd23b, 0xd23d, 0xd3a4, 0xd3a8,
  /* 0x72 */
  0xd3c3, 0xd3bf, 0xd3c8, 0xd3c2, 0xd3ca, 0xd3cc, 0xd3c9, 0xd3be,
  0xd3cd, 0xd3c7, 0xd3c5, 0xd45d, 0x17b0, 0xd56c, 0xd56b, 0xd570,
  0xd56d, 0xd56f, 0xd589, 0xd584, 0xd68d, 0xd68a, 0xd68e, 0xd691,
  0xd7b5, 0xd7b1, 0xd7af, 0xd7b9, 0xd7b7, 0xd7b0, 0x180c, 0xd817,
  0x1818, 0xd84f, 0xd919, 0xd910, 0xd918, 0xd911, 0xd91c, 0xd912,
  0xda76, 0xda71, 0x3820, 0xda7a, 0xda7f, 0x3822, 0xda73, 0xdaab,
  0x381e, 0xda77, 0xda74, 0xda7e, 0xda9b, 0xda84, 0xda7c, 0xdd29,
  0xdd2b, 0xdd0e, 0xdd00, 0xdd0b, 0xdcfe, 0xdcfa, 0xdd17, 0xdcff,
  0xdd0c, 0xdd0f, 0x18f5, 0xdd02, 0xdd01, 0xdcfc, 0xdd49, 0xdd06,
  0xdd12, 0xdd13, 0xde78, 0xdf5b, 0xdf62, 0xdf5f, 0xdf5d, 0xdfab,
  0xdfd5, 0xdfd4, 0xdfd3, 0xe007, 0xe06c, 0xe070, 0xe06e, 0xe068,
  0xe06d, 0xe077, 0xe06a, 0xe0ce, 0xe0ec, 0xe169,
  /* 0x73 */
  0xe168, 0xe1a6, 0xe1a9, 0xe1aa, 0xe200, 0xe20d, 0xe1f8, 0xe1fc,
  0xe20a, 0xe1f7, 0xe201, 0xe2b6, 0xe2bb, 0xe2b7, 0xe2b9, 0xe2ca,
  0x4069, 0x4225, 0x4d59, 0x5107, 0x5109, 0x5522, 0x5707, 0x5704,
  0x6f0f, 0x58f8, 0x5bc7, 0x5bd1, 0x5d7e, 0x5f08, 0x604a, 0x3bfd,
  0x60b9, 0x6a88, 0x6a91, 0x6a84, 0x6a73, 0x6a89, 0x6a85, 0x6c33,
  0x6f13, 0x741d, 0x741f, 0x741c, 0x7420, 0x741a, 0x741b, 0x7539,
  0x75af, 0x76e5, 0x783c, 0x7d37, 0x7d3a, 0x80bb, 0x0a0e, 0x8310,
  0x830d, 0x87af, 0x8811, 0x0bd8, 0x8b0d, 0x8b0c, 0x8b0b, 0x8cd4,
  0x8f3d, 0x8f3e, 0x8f3b, 0x8f43, 0x8f40, 0x8f46, 0x9011, 0x91dd,
  0x91df, 0x91ea, 0x934a, 0x9506, 0x99c1, 0x99b9, 0x99c6, 0x99b8,
  0x99bb, 0x99c8, 0x99c5, 0x99bf, 0x99c7, 0x99c4, 0x9b65, 0x9b67,
  0x9dd7, 0x9ddb, 0x9dd4, 0x9dd6, 0x9fe8, 0xa20a,
  /* 0x74 */
  0xa6bd, 0xa6be, 0xad1a, 0xad0d, 0xad0f, 0xad1b, 0xad10, 0xad11,
  0xad13, 0xae18, 0xb120, 0xb11f, 0xb123, 0xb11d, 0xb137, 0xb125,
  0xb124, 0xb12a, 0xb127, 0xb133, 0xb128, 0xb134, 0xb3ba, 0x2f70,
  0xb49d, 0xb54c, 0xb75c, 0xb76a, 0xb75d, 0xb765, 0xb763, 0xb75e,
  0xb819, 0xb897, 0xba3f, 0xba33, 0xba32, 0xbba1, 0xbba5, 0xbba4,
  0xbba2, 0xbdc1, 0x142c, 0xbdc7, 0xbdc4, 0xbdc6, 0xbdc5, 0xbdd4,
  0xbdca, 0xc253, 0xc4f1, 0xc521, 0x156e, 0xc7b7, 0xc792, 0xc9d4,
  0xcb44, 0xcd98, 0xcd9b, 0xcd91, 0xcd95, 0xcd9a, 0xcd92, 0xcf53,
  0xcf57, 0x1686, 0xcf5c, 0xcf5d, 0xcf64, 0xcfea, 0xcfed, 0xd042,
  0xd043, 0xd164, 0xd161, 0xd160, 0xd27d, 0xd3d4, 0xd3d5, 0xd3d9,
  0xd587, 0xd599, 0xd58c, 0xd58a, 0xd58f, 0x17b3, 0xd58b, 0xd582,
  0xd59b, 0x17eb, 0xd7c8, 0xd7c4, 0xd7cc, 0xd7c7,
  /* 0x75 */
  0xd7c3, 0xd7c6, 0xd7cb, 0xd7ca, 0xd7c9, 0xd7cd, 0xd853, 0xd921,
  0xd929, 0xd91d, 0xd924, 0xd928, 0x3843, 0xdab1, 0xdab2, 0xdab5,
  0xdad6, 0xdaaf, 0xdaca, 0xdab8, 0x3bfd, 0x3bfd, 0xdd45, 0xdd47,
  0xdd34, 0xdd6e, 0xdd42, 0xdd31, 0xdd2e, 0xdd56, 0xdd38, 0xdd37,
  0xdd4b, 0xdd2d, 0xdd33, 0xdd36, 0x39e0, 0xdd48, 0xdedc, 0x1942,
  0xdf66, 0xdf6d, 0xdf63, 0xdf64, 0x1941, 0xdf67, 0xdfd9, 0xe00b,
  0xe07e, 0xe08b, 0xe126, 0xe12c, 0xe129, 0xe16f, 0xe16b, 0xe16d,
  0xe16e, 0xe21c, 0xe211, 0xe210, 0xe224, 0xe212, 0xe215, 0xe217,
  0x19ac, 0x406f, 0x41ab, 0x442e, 0x44c9, 0x4796, 0x4d85, 0x52a0,
  0x552b, 0x5f0d, 0x6c36, 0x3bfd, 0x072f, 0x072e, 0x6fb1, 0x744a,
  0x7437, 0x743c, 0x7438, 0x743a, 0x743e, 0x7449, 0x084d, 0x087b,
  0x7680, 0x767f, 0x76e3, 0x783f, 0x7d52, 0x7d4e,
  /* 0x76 */
  0x7d4a, 0x7d4b, 0x80d5, 0x86d8, 0x8720, 0x87b3, 0x87b1, 0x87b0,
  0x8b17, 0x8cd9, 0x8f49, 0x9013, 0x91ed, 0x91eb, 0x91ee, 0x950a,
  0x950b, 0x964a, 0x99d5, 0x99d7, 0x99de, 0x99dc, 0x99ee, 0x9b70,
  0x0eb2, 0x9dd9, 0x9fd7, 0xa4cb, 0xa4c7, 0xa5fc, 0xad3b, 0xad39,
  0xad4b, 0xad43, 0xad40, 0xad46, 0xb14d, 0xb143, 0xb147, 0xb14b,
  0xb155, 0xb152, 0xb75f, 0x1322, 0xb77c, 0xb77b, 0xbba8, 0xbba9,
  0xbdde, 0xbdd7, 0xbddd, 0xbdd6, 0xbdd8, 0xbe9b, 0xbfe0, 0xbfe8,
  0xbfe6, 0xc4f8, 0xc4fb, 0xc7bb, 0x3359, 0xc7b8, 0x1570, 0xc8c1,
  0xc8c0, 0xcda4, 0xcdab, 0xce4d, 0xcf65, 0xcf67, 0xcf6a, 0xcf66,
  0xcf69, 0xd173, 0xd180, 0xd16f, 0xd171, 0xd3e4, 0xd3e6, 0xd3e7,
  0xd5a0, 0xd5a4, 0xd6a2, 0xd6a7, 0xd6a4, 0xd7de, 0xd7db, 0xd858,
  0xd85c, 0xd92f, 0xd92e, 0xdadd, 0xdae4, 0xdad8,
  /* 0x77 */
  0xdae7, 0xdada, 0xda75, 0x1895, 0xdd79, 0xdd80, 0xdd7f, 0xdd7c,
  0xdd75, 0xdd7b, 0xdd82, 0x1900, 0xdd89, 0xdd74, 0xdd7d, 0xdd7a,
  0xdd86, 0xdda8, 0xdd72, 0x1902, 0xdd8b, 0xdd91, 0xddb3, 0xdd81,
  0xde82, 0xdee1, 0xdee3, 0xdee2, 0xdf76, 0xdf74, 0xdf72, 0xdf75,
  0xe00e, 0xe00d, 0xe094, 0xe092, 0xe093, 0xe091, 0xe08f, 0xe095,
  0xe0d0, 0xe0f7, 0xe176, 0xe1af, 0x199f, 0xe226, 0xe225, 0xe22d,
  0xe2a0, 0xe2c3, 0x40d7, 0x46cc, 0x4d79, 0x4d7a, 0x5115, 0x5bdb,
  0x5d85, 0x6570, 0x657b, 0x6aa5, 0x6a9f, 0x6f17, 0x6fb2, 0x7439,
  0x7440, 0x744e, 0x753e, 0x76e8, 0x76e7, 0x7d66, 0x7d61, 0x80da,
  0x8314, 0x84df, 0x8b18, 0x8c39, 0x8c3a, 0x9330, 0x9332, 0x950e,
  0x964c, 0x99e8, 0x99f1, 0x99eb, 0x99ec, 0x9b74, 0x9b73, 0x9df1,
  0x9f42, 0x9f3e, 0x9f41, 0xa12c, 0xa4d2, 0xa5bb,
  /* 0x78 */
  0xad58, 0xad57, 0xad56, 0xad5a, 0x117d, 0xb161, 0xb168, 0xb165,
  0xb15f, 0xb164, 0xb15e, 0xb15b, 0xb167, 0xb3c3, 0xb4a2, 0xb553,
  0xb77d, 0xb820, 0xbbae, 0xbbaf, 0xbbb0, 0xbde7, 0xbde6, 0xbde9,
  0xbff1, 0xbfeb, 0xbfea, 0xbfe9, 0xc263, 0xc502, 0xc4fe, 0xc7de,
  0xc8c2, 0xc9e6, 0xcb5d, 0xcdad, 0xcf75, 0xcf72, 0xcf77, 0x16f6,
  0xd251, 0xd3e8, 0xd3ed, 0xd3ee, 0xd5b9, 0xd5a1, 0xd5b6, 0xd6ae,
  0xd7e8, 0x1812, 0xd81e, 0xd931, 0xd932, 0x1891, 0xdb0e, 0xdb12,
  0xdb09, 0xdb05, 0x1890, 0xdb03, 0xdb1f, 0xdb0d, 0xdb0c, 0xdb04,
  0xdb0a, 0xddc2, 0xddbf, 0xddc9, 0xddb2, 0xddc1, 0xddaf, 0xddb4,
  0xddb0, 0xddb6, 0xddb7, 0xddbb, 0xddb1, 0xdef0, 0xdf78, 0xdf7a,
  0xdf79, 0xdfe4, 0xdfe6, 0xe09f, 0xe09d, 0xe098, 0xe099, 0xe0f9,
  0xe130, 0xe182, 0xe181, 0xe1b3, 0xe17f, 0xe23a,
  /* 0x79 */
  0xe23e, 0xe248, 0x4d86, 0x5536, 0x5713, 0x5822, 0x5bdd, 0x61a7,
  0x657d, 0x0679, 0x6f1c, 0x7465, 0x7460, 0x7467, 0x084e, 0x771a,
  0x86e3, 0x9334, 0x9518, 0x9652, 0x99fc, 0x9b79, 0x9b78, 0x9b76,
  0x9dfa, 0x9df8, 0xa12d, 0xa4d6, 0xa5bd, 0xa5bf, 0xa5be, 0xad44,
  0xad70, 0xad62, 0xad6e, 0xb16e, 0xb17c, 0xb174, 0xb178, 0xb170,
  0xb179, 0xb171, 0xb3cc, 0xb4a7, 0xb4a6, 0xb793, 0xb821, 0xb89c,
  0xbe9d, 0xbff4, 0xbff3, 0xc9f0, 0xcdb8, 0xcdb6, 0xcdbd, 0xcf73,
  0xcf82, 0xd187, 0xd256, 0xd259, 0xd3f6, 0xd5c9, 0xd5c5, 0xd5c7,
  0xd5ca, 0xd5c2, 0xd5c4, 0xd7f2, 0xd7f0, 0xd93b, 0xd93a, 0xdb26,
  0xdb28, 0xdb34, 0xdb2d, 0xddd7, 0xddd2, 0xddd6, 0xdddc, 0xddd3,
  0xddd1, 0xde86, 0x191e, 0xdeef, 0xdeee, 0xdfe8, 0xe0ac, 0xe0a9,
  0xe0aa, 0xe0ab, 0xe0fb, 0xe133, 0xe188, 0xe1b6,
  /* 0x7a */
  0xe1b7, 0xe1d0, 0xe1cf, 0xe24f, 0xe259, 0xe24c, 0x5718, 0x5be0,
  0x7469, 0x7d73, 0x7d72, 0x86e8, 0x91fb, 0x951c, 0x9a09, 0x9a0a,
  0x9a08, 0x9b7d, 0x9b7f, 0x9e67, 0xad7a, 0xad7b, 0xb3d1, 0x1295,
  0xb79d, 0xb89d, 0xbdfc, 0xbdfb, 0xbdfd, 0xbff5, 0xbff6, 0xc80f,
  0xc81d, 0xcdc7, 0xcdc1, 0xcdbf, 0xce54, 0xcf7f, 0xcff5, 0xd18a,
  0xd18c, 0xd25c, 0xd465, 0xd5cf, 0xd5d0, 0xd6b8, 0xd7fa, 0xd866,
  0xdb40, 0xdb41, 0x3872, 0xddf7, 0xddf3, 0xddef, 0xddf4, 0xdded,
  0xddf2, 0xddf1, 0xddf9, 0xe0b4, 0xe0fc, 0xe1bc, 0xe25e, 0xe25b,
  0xe25f, 0xe25d, 0xe2cf, 0xe2ce, 0x553a, 0x5be1, 0x5f15, 0x5f14,
  0x7d78, 0x7d79, 0x80e6, 0x87b8, 0x8b22, 0x91fe, 0xa4db, 0xa606,
  0xa6c8, 0xad89, 0xb186, 0xb4ad, 0xb799, 0xb7d8, 0xb823, 0xb923,
  0xbbb5, 0xbff9, 0xc507, 0xc81e, 0xc9fb, 0xcb72,
  /* 0x7b */
  0xcb73, 0xcf87, 0xd049, 0xd25d, 0xd3f8, 0xd803, 0xdb4e, 0xdb4d,
  0xdb50, 0xdb55, 0xde09, 0xde07, 0xde0c, 0xde03, 0xde06, 0xde0b,
  0xde0a, 0xde89, 0xe0bb, 0xe0ff, 0xe136, 0xe18b, 0xe266, 0xe269,
  0xe267, 0xe2c2, 0xe2d2, 0x5be2, 0x0428, 0x6588, 0x6f5b, 0x7476,
  0x7d7d, 0x81a6, 0x8f5a, 0x9a17, 0xa4dc, 0xad8f, 0xb194, 0xb195,
  0xbbb6, 0xbe04, 0xc3ee, 0xcf8a, 0xcff9, 0xd807, 0xd81f, 0xd82a,
  0xd945, 0xdb5c, 0xdb5b, 0xdb61, 0xdb5d, 0xde18, 0xde1f, 0xdf83,
  0xe016, 0xe014, 0xe0bf, 0xe0c0, 0xe273, 0xe2c0, 0x5117, 0x6589,
  0x951e, 0x951f, 0x9654, 0x9a18, 0x9e05, 0xad95, 0xb198, 0xb19b,
  0xb559, 0xbe08, 0xc001, 0xcdce, 0xcffa, 0xd6be, 0xd947, 0xdb6a,
  0xdb69, 0xdb68, 0xdb67, 0xde25, 0xde28, 0xe0c4, 0xe137, 0xe18d,
  0xe18c, 0x1991, 0x3bfd, 0x9a22, 0x9b82, 0xb3d9,
  /* 0x7c */
  0xc838, 0xcffb, 0xd5e1, 0xd872, 0xd948, 0xdb6c, 0xdb70, 0xde31,
  0xde30, 0xe279, 0x9a23, 0xa4f8, 0xd874, 0xdb73, 0xde34, 0xdf87,
  0xdfb2, 0xe1c2, 0xe27d, 0x5be5, 0xcf8c, 0xdb77, 0xdb75, 0xde38,
  0xde3a, 0xe283, 0xe281, 0x7d80, 0xad99, 0x1187, 0xd04a, 0xd94a,
  0xde3c, 0xe2c8, 0x9204, 0xb4af, 0xe289, 0xdefa, 0xd261, 0xde3f,
  0xad93, 0xe0c9, 0xb3de, 0xcf91, 0xe28e, 0xe28d, 0xad98, 0xa5c5,
  0xe2a5,
};

static const ucs4_t cns11643_5_2uni_upages[227] = {
  0x03400, 0x03500, 0x03600, 0x03700, 0x03800, 0x03900, 0x03a00, 0x03b00,
  0x03c00, 0x03d00, 0x03e00, 0x03f00, 0x04000, 0x04100, 0x04200, 0x04300,
  0x04400, 0x04500, 0x04600, 0x04700, 0x04800, 0x04900, 0x04a00, 0x04b00,
  0x04c00, 0x04d00, 0x05200, 0x05900, 0x05e00, 0x05f00, 0x06100, 0x06300,
  0x06400, 0x06700, 0x06b00, 0x07200, 0x07300, 0x07500, 0x07600, 0x07900,
  0x07a00, 0x07b00, 0x07c00, 0x08300, 0x08600, 0x08700, 0x08800, 0x08900,
  0x08a00, 0x08c00, 0x08e00, 0x09400, 0x09500, 0x09700, 0x09900, 0x09b00,
  0x09c00, 0x09d00, 0x09e00, 0x0ff00, 0x20000, 0x20100, 0x20200, 0x20300,
  0x20400, 0x20500, 0x20600, 0x20700, 0x20800, 0x20900, 0x20a00, 0x20b00,
  0x20c00, 0x20d00, 0x20e00, 0x20f00, 0x21000, 0x21100, 0x21200, 0x21300,
  0x21400, 0x21500, 0x21600, 0x21700, 0x21800, 0x21900, 0x21a00, 0x21b00,
  0x21c00, 0x21d00, 0x21e00, 0x21f00, 0x22000, 0x22100, 0x22200, 0x22300,
  0x22400, 0x22500, 0x22600, 0x22700, 0x22800, 0x22900, 0x22a00, 0x22b00,
  0x22c00, 0x22d00, 0x22e00, 0x22f00, 0x23000, 0x23100, 0x23200, 0x23300,
  0x23400, 0x23500, 0x23600, 0x23700, 0x23800, 0x23900, 0x23a00, 0x23b00,
  0x23c00, 0x23d00, 0x23e00, 0x23f00, 0x24000, 0x24100, 0x24200, 0x24300,
  0x24400, 0x24500, 0x24600, 0x24700, 0x24800, 0x24900, 0x24a00, 0x24b00,
  0x24c00, 0x24d00, 0x24e00, 0x24f00, 0x25000, 0x25100, 0x25200, 0x25300,
  0x25400, 0x25500, 0x25600, 0x25700, 0x25800, 0x25900, 0x25a00, 0x25b00,
  0x25c00, 0x25d00, 0x25e00, 0x25f00, 0x26000, 0x26100, 0x26200, 0x26300,
  0x26400, 0x26500, 0x26600, 0x26700, 0x26800, 0x26900, 0x26a00, 0x26b00,
  0x26c00, 0x26d00, 0x26e00, 0x26f00, 0x27000, 0x27100, 0x27200, 0x27300,
  0x27400, 0x27500, 0x27600, 0x27700, 0x27800, 0x27900, 0x27a00, 0x27b00,
  0x27c00, 0x27d00, 0x27e00, 0x27f00, 0x28000, 0x28100, 0x28200, 0x28300,
  0x28400, 0x28500, 0x28600, 0x28700, 0x28800, 0x28900, 0x28a00, 0x28b00,
  0x28c00, 0x28d00, 0x28e00, 0x28f00, 0x29000, 0x29100, 0x29200, 0x29300,
  0x29400, 0x29500, 0x29600, 0x29700, 0x29800, 0x29900, 0x29a00, 0x29b00,
  0x29c00, 0x29d00, 0x29e00, 0x29f00, 0x2a000, 0x2a100, 0x2a200, 0x2a300,
  0x2a400, 0x2a500, 0x2a600,
};

static int
cns11643_5_mbtowc (conv_t conv, ucs4_t *pwc, const unsigned char *s, int n)
{
  unsigned char c1 = s[0];
  if ((c1 >= 0x21 && c1 <= 0x7c)) {
    if (n >= 2) {
      unsigned char c2 = s[1];
      if (c2 >= 0x21 && c2 < 0x7f) {
        unsigned int i = 94 * (c1 - 0x21) + (c2 - 0x21);
        ucs4_t wc = 0xfffd;
        unsigned short swc;
        {
          if (i < 8603)
            swc = cns11643_5_2uni_page21[i],
            wc = cns11643_5_2uni_upages[swc>>8] | (swc & 0xff);
        }
        if (wc != 0xfffd) {
          *pwc = wc;
          return 2;
        }
      }
      return RET_ILSEQ;
    }
    return RET_TOOFEW(0);
  }
  return RET_ILSEQ;
}

