dnl Copyright (C) 1999 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_MYSQL,[
	ost_cv_mysql_database=false
	MYSQL_FLAGS=""
	MYSQL_LIBS=""
	MYSQL_PREFIX=""	
	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS
	AC_ARG_WITH(mysql,
		[  --with-mysql=<path>  alternate mysql install prefix],
		[MYSQL_PREFIX=$with_mysql
		 AC_CHECK_HEADER([$MYSQL_PREFIX/include/mysql/mysql.h], [], 
			[MYSQL_PREFIX=""
			AC_MSG_ERROR([mysql.h not found])])
	],[
		AC_MSG_CHECKING([for mysql database support])
		if test -d $prefix/$target/include/mysql ; then
			MYSQL_PREFIX=`echo $prefix/$target`
		elif test -d $prefix/include/mysql ; then
			MYSQL_PREFIX=`echo $prefix`
		elif test -d /usr/include/mysql ; then
			MYSQL_PREFIX=/usr
		elif test -d /usr/local/include/mysql ; then
			MYSQL_PREFIX=/usr/local
		fi
		if test -z "$MYSQL_PREFIX" ; then 
			AC_MSG_RESULT("no")
		else
			AC_MSG_RESULT(("$MYSQL_PREFIX"))
		fi
	])

	if test ! -z "$MYSQL_PREFIX" ; then
		ost_cv_mysql_database=true
		MYSQL_FLAGS="-I$MYSQL_PREFIX/include/mysql"
		if test -d "$MYSQL_PREFIX/lib/mysql" ; then
			MYSQL_LIBS="-L$MYSQL_PREFIX/lib/mysql"
		fi
		MYSQL_LIBS="$MYSQL_LIBS -lmysqlclient"
	fi
		
	AC_LANG_RESTORE
	AC_SUBST(MYSQL_FLAGS)
	AC_SUBST(MYSQL_LIBS)
	AC_SUBST(MYSQL)
])

dnl ACCONFIG TEMPLATE
dnl END ACCONFIG


