/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "buffer_ptr.h"



static void
gimp_ptr_buffer_delete (GimpBuffer * buffer)
{
  GimpPtrBuffer * ptr_buffer = GIMP_PTR_BUFFER (buffer);

  g_free (ptr_buffer);
}


static gboolean
gimp_ptr_buffer_alloc (GimpBuffer   *buffer,
                       GimpArea     *area,
                       Alloc         how)
{
  return TRUE;
}


static gboolean
gimp_ptr_buffer_validate (GimpBuffer  *buffer,
                          GimpArea    *area, 
                          Validate     how)
{
  return TRUE;
}


static GimpMemPtr *
gimp_ptr_buffer_use (GimpBuffer  *buffer,
                     GimpPoint   *tile, 
                     Use          how)
{
  GimpPtrBuffer * ptr_buffer = GIMP_PTR_BUFFER (buffer);

  /* g_warning ("this is a bogus GimpMemPtr..."); */
  
  return &ptr_buffer->yuck;
}


static gboolean
gimp_ptr_buffer_query (GimpBuffer    *buffer,
                       GimpPoint     *tile)
{
  return TRUE;
}








GimpPtrBuffer *
gimp_ptr_buffer_new (void * ptr,
                     Tag    tag,
                     gint   x_len,
                     gint   x_period,
                     gint   x_offset,
                     gint   y_len,
                     gint   y_period,
                     gint   y_offset)
{
  GimpPtrBuffer * ptr_buffer;
  GimpBuffer * buffer;

  static GimpPtrBufferClass my_class =
  {
    {
      BUFFER_PTR,
      gimp_ptr_buffer_delete,
      gimp_ptr_buffer_alloc,
      NULL, /* map */
      gimp_ptr_buffer_validate,
      gimp_ptr_buffer_use,
      gimp_ptr_buffer_query
    }
  };


  ptr_buffer = g_new (GimpPtrBuffer, 1);
  buffer = GIMP_BUFFER (ptr_buffer);

  buffer->klass = (void*) &my_class;

  buffer->vfunc = NULL;
  buffer->vdata = NULL;
  
  buffer->_x.tile.count = 1;
  buffer->_x.tile.size = x_period;
  buffer->_x.image.size = x_len;
  buffer->_x.image.offset = x_offset;

  buffer->_y.tile.count = 1;
  buffer->_y.tile.size = y_period;
  buffer->_y.image.size = y_len;
  buffer->_y.image.offset = y_offset;

  buffer->_z.tag = tag;
  buffer->_z.bpp = tag_bytes (tag);

  d_init (&ptr_buffer->yuck);
  ptr_buffer->yuck.data = ptr;

  buffer->qq_x = 0;
  buffer->qq_y = 0;

  return ptr_buffer;
}


