/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __FLATBUF_H__
#define __FLATBUF_H__

#include "buffer.h"

#define GIMP_FLAT_BUFFER(b)        ((GimpFlatBuffer*)(b))
#define GIMP_FLAT_BUFFER_CLASS(b)  ((GimpFlatBufferClass*)(b))

typedef struct _GimpFlatBuffer        GimpFlatBuffer;
typedef struct _GimpFlatBufferClass   GimpFlatBufferClass;


struct _GimpFlatBuffer
{
  /* we are a GimpBuffer subclass */
  GimpBuffer buffer;

  /* the image memory */
  GimpMemPtr data;

  /* have we put data into the memory yet? */
  gboolean valid;

  /* are we in a validation cycle? */
  gboolean validating;
};

struct _GimpFlatBufferClass
{
  /* we are a GimpBuffer subclass */
  GimpBufferClass parent_class;

  /* no class specific extensions */
};


/* public methods */

GimpFlatBuffer *
gimp_flat_buffer_new (Tag   tag,
                      gint  width,
                      gint  height);

#endif /* __FLATBUF_H__ */
