/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include "gtkclist.h"
#include "main_window.h"
#include "index_interface.h"

/* menu structure for menu factory */
static GtkMenuEntry main_menu_items[] =
{
  { "<Balsa>/File/Get New Mail", NULL, NULL, NULL },
  { "<Balsa>/File/<separator>", NULL, NULL, NULL },
  { "<Balsa>/File/New Folder...", NULL, NULL, NULL },
  { "<Balsa>/File/Open Folder...", NULL, NULL, NULL },
  { "<Balsa>/File/Save Folder", NULL, NULL, NULL },
  { "<Balsa>/File/<separator>", NULL, NULL, NULL },
  { "<Balsa>/File/Print", NULL, NULL, NULL },
  { "<Balsa>/File/<separator>", NULL, NULL, NULL },
  { "<Balsa>/File/Quit", NULL, main_window_destroy_callback, NULL },
  { "<Balsa>/Options/Identity...", NULL, NULL, NULL },
  { "<Balsa>/Options/Servers...", NULL, NULL, NULL },
  { "<Balsa>/Options/Filters...", NULL, NULL, NULL }
};
static int main_nmenu_items = sizeof (main_menu_items) / sizeof (main_menu_items[0]);



/*
 * only one main window
 */
MainWindow *mainW = NULL;


void
main_window_init ()
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *vpane;
  GtkWidget *table;
  GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  gchar     *titles[4];
  gchar      title[4][20];


  if (!mainW)
    {
      mainW = g_malloc (sizeof (MainWindow));

      mainW->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (GTK_WINDOW (mainW->window), "Balsa");
      gtk_container_border_width (GTK_CONTAINER (mainW->window), 0);

      gtk_signal_connect (GTK_OBJECT (mainW->window), 
			  "destroy",
			  (GtkSignalFunc) main_window_destroy_callback, 
			  &mainW->window);

      gtk_signal_connect (GTK_OBJECT (mainW->window), 
			  "delete_event",
			  (GtkSignalFunc) main_window_destroy_callback, 
			  &mainW->window);


      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (mainW->window), vbox);
      gtk_widget_show (vbox);


      /* 
       * set menu bar
       */
      mainW->factory = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
      mainW->subfactories[0] = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
      gtk_menu_factory_add_subfactory (mainW->factory, mainW->subfactories[0], "<Balsa>");
      gtk_menu_factory_add_entries (mainW->factory, main_menu_items, main_nmenu_items);
      mainW->menubar = mainW->subfactories[0]->widget;
      gtk_box_pack_start (GTK_BOX (vbox), mainW->menubar, FALSE, TRUE, 0);
      gtk_widget_show (mainW->menubar);
      
      
      /*
       * toolbar 
       */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_container_border_width (GTK_CONTAINER (hbox), 2); 
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      gtk_widget_show (hbox);

      label = gtk_label_new (" Mailbox: ");
      gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
      gtk_widget_show (label);

      mainW->mailbox_menu = NULL;
      mainW->move_menu = NULL;

      mainW->mailbox_option_menu = gtk_option_menu_new ();
      gtk_widget_set_usize (mainW->mailbox_option_menu, 200, 25);
      gtk_box_pack_start (GTK_BOX (hbox), mainW->mailbox_option_menu, FALSE, FALSE, 5);
      gtk_widget_show (mainW->mailbox_option_menu);
      
      mainW->compose = gtk_button_new_with_label ("Compose");
      gtk_widget_set_usize (mainW->compose, 70, 25);
      gtk_box_pack_start (GTK_BOX (hbox), mainW->compose, FALSE, FALSE, 0);
      gtk_widget_show (mainW->compose);

      mainW->reply = gtk_button_new_with_label ("Reply");
      gtk_widget_set_usize (mainW->reply, 70, 25);
      gtk_box_pack_start (GTK_BOX (hbox), mainW->reply, FALSE, FALSE, 0);
      gtk_widget_show (mainW->reply);
      
      mainW->delete = gtk_button_new_with_label ("Delete");
      gtk_widget_set_usize (mainW->delete, 70, 25);
      gtk_box_pack_start (GTK_BOX (hbox), mainW->delete, FALSE, FALSE, 0);
      gtk_widget_show (mainW->delete);

      /* 
       * panned widget
       */
      vpane = gtk_vpaned_new ();
      gtk_box_pack_start (GTK_BOX (vbox), vpane, TRUE, TRUE, 0);
      gtk_container_border_width (GTK_CONTAINER (vpane), 5);
      gtk_widget_show (vpane);
      
      
      /* 
       * message index 
       */
      strcpy (title[0], "#");
      titles[0] = title[0];

      strcpy (title[1], "From");
      titles[1] = title[1];

      strcpy (title[2], "Subject");
      titles[2] = title[2];

      strcpy (title[3], "Date");
      titles[3] = title[3];

      mainW->index_clist = gtk_clist_new (4, titles);
      gtk_widget_set_usize (mainW->index_clist, 0, 100);

      gtk_signal_connect (GTK_OBJECT (mainW->index_clist), "select_row",
			  (GtkSignalFunc) index_select, NULL);

      gtk_clist_set_column_justification (GTK_CLIST (mainW->index_clist), 0,
					  GTK_JUSTIFY_RIGHT);
      gtk_clist_set_column_width (GTK_CLIST (mainW->index_clist), 0, 25);
      gtk_clist_set_column_width (GTK_CLIST (mainW->index_clist), 1, 150);
      gtk_clist_set_column_width (GTK_CLIST (mainW->index_clist), 2, 250);
      gtk_clist_set_column_width (GTK_CLIST (mainW->index_clist), 3, 100);
      gtk_paned_add1 (GTK_PANED (vpane), mainW->index_clist);
      gtk_widget_show (mainW->index_clist);
      
      
      /* 
       * message body
       */
      table = gtk_table_new (2, 2, FALSE);
      gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      gtk_paned_add2 (GTK_PANED (vpane), table);
      gtk_widget_show (table);

      mainW->message_area = gtk_text_new (NULL, NULL);
      gtk_table_attach_defaults (GTK_TABLE (table), mainW->message_area, 0, 1, 0, 1);
      gtk_widget_show (mainW->message_area);

      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (mainW->message_area)->hadj);
      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0,1,1,2,
                        GTK_EXPAND|GTK_FILL, GTK_FILL,0,0);
      gtk_widget_show (hscrollbar);

      vscrollbar = gtk_vscrollbar_new (GTK_TEXT (mainW->message_area)->vadj);
      gtk_table_attach (GTK_TABLE (table), vscrollbar, 1,2,0,1,
                        GTK_FILL, GTK_EXPAND|GTK_FILL,0,0);
      gtk_widget_show (vscrollbar);

      gtk_widget_show (mainW->window);
    }
}		    




void
main_window_destroy_callback ()
{
  gtk_exit (0);
}
