/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __mail_h__
#define __mail_h__

#include "mail_structs.h"


/*
 * mailbox methods
 */
Mailbox *mailbox_new (PostOffice   *postoffice,
		      char         *name,
		      char         *mbox);
int mailbox_open (Mailbox *);
void mailbox_close (Mailbox *);
/* int mailbox_move (Mailbox *, char *); */
/* int mailbox_delete (Mailbox *); */
/* int mailbox_rename (Mailbox *, char *); */

/*
 * message methods
 */
Message *message_new (Mailbox *, long);
void message_delete (Message *);

void mail_message_delete (Message *);
void mail_message_move (Message *, Mailbox *);
void mail_message_copy (Message *, Mailbox *);
char *mail_message_from (Message *);
char *mail_message_subject (Message *);
char *mail_message_date (Message *);

#endif /* __mail_h__ */
