#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

static const char *g_log_domain_gthread = "GThread";
static gboolean thread_system_already_initialized = FALSE;

#include G_THREAD_SOURCE

void 
g_thread_init(GMutexFunctions* init)
{
  /* Make sure, this function is only called once. */
  g_assert(!thread_system_already_initialized);
  thread_system_already_initialized = TRUE;

  g_mutex_use_default_impl = ( init == NULL );
  if( g_mutex_use_default_impl ) 
    {
      init = &g_mutex_functions_for_glib_use_default;
    }
  g_mutex_functions_for_glib_use = *init;

  g_mutex_supported = init->mutex_new && init->mutex_lock && 
    init->mutex_try_lock && init->mutex_unlock && init->mutex_free;

  g_cond_supported = init->cond_new && init->cond_signal && 
    init->cond_broadcast && init->cond_wait && init->cond_timed_wait &&
    init->cond_free;

  /* if somebody is calling g_thread_init(), it means that he at least wants
     to have mutex support, so check this */

  g_assert(g_mutex_supported);

  g_mutex_protect_static_mutex_allocation = g_mutex_new();
}

