#ifndef GTOOLKIT_GTKNOTEBOOK_H
#define GTOOLKIT_GTKNOTEBOOK_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtknotebook.h>

@interface GTKNotebook : GTKContainer
+ (guint) getType;
+ notebook;
- init;
- (void) appendPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label;
- (void) appendPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label;
- (void) prependPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label;
- (void) prependPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label;
- (void) insertPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label position:(gint) position;
- (void) insertPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label position:(gint) position;
- (void) removePage:(gint) page_num;
- (gint) currentPage;
- (void) setPage:(gint) page_num;
- (void) nextPage;
- (void) prevPage;
- (void) setTabPos:(GtkPositionType) pos;
- (void) setShowTabs:(gint) show_tabs;
- (void) setShowBorder:(gint) show_border;
- (void) setScrollable:(gint) scrollable;
- (void) setTabBorder:(gint) border_width;
- (void) popupEnable;
- (void) popupDisable;
@end

#endif
